// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ActivateKeySigningKeyInput`](crate::input::ActivateKeySigningKeyInput)
pub mod activate_key_signing_key_input {
    /// A builder for [`ActivateKeySigningKeyInput`](crate::input::ActivateKeySigningKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
        /// hosted zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
        /// hosted zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateKeySigningKeyInput`](crate::input::ActivateKeySigningKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateKeySigningKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateKeySigningKeyInput {
                hosted_zone_id: self.hosted_zone_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type ActivateKeySigningKeyInputOperationOutputAlias = crate::operation::ActivateKeySigningKey;
#[doc(hidden)]
pub type ActivateKeySigningKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ActivateKeySigningKeyInput {
    /// Consumes the builder and constructs an Operation<[`ActivateKeySigningKey`](crate::operation::ActivateKeySigningKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateKeySigningKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ActivateKeySigningKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.hosted_zone_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_1, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_2, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/activate",
                HostedZoneId = hosted_zone_id,
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ActivateKeySigningKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ActivateKeySigningKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateKeySigningKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateKeySigningKey",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ActivateKeySigningKeyInput`](crate::input::ActivateKeySigningKeyInput)
    pub fn builder() -> crate::input::activate_key_signing_key_input::Builder {
        crate::input::activate_key_signing_key_input::Builder::default()
    }
}

/// See [`AssociateVpcWithHostedZoneInput`](crate::input::AssociateVpcWithHostedZoneInput)
pub mod associate_vpc_with_hosted_zone_input {
    /// A builder for [`AssociateVpcWithHostedZoneInput`](crate::input::AssociateVpcWithHostedZoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
        /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
        /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>
        /// <i>Optional:</i> A comment about the association request.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>
        /// <i>Optional:</i> A comment about the association request.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateVpcWithHostedZoneInput`](crate::input::AssociateVpcWithHostedZoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateVpcWithHostedZoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateVpcWithHostedZoneInput {
                hosted_zone_id: self.hosted_zone_id,
                vpc: self.vpc,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateVpcWithHostedZoneInputOperationOutputAlias =
    crate::operation::AssociateVPCWithHostedZone;
#[doc(hidden)]
pub type AssociateVpcWithHostedZoneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateVpcWithHostedZoneInput {
    /// Consumes the builder and constructs an Operation<[`AssociateVPCWithHostedZone`](crate::operation::AssociateVPCWithHostedZone)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateVPCWithHostedZone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateVpcWithHostedZoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.hosted_zone_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_3, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/associatevpc",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateVpcWithHostedZoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateVpcWithHostedZoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_vpc_with_hosted_zone(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateVPCWithHostedZone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateVPCWithHostedZone",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateVpcWithHostedZoneInput`](crate::input::AssociateVpcWithHostedZoneInput)
    pub fn builder() -> crate::input::associate_vpc_with_hosted_zone_input::Builder {
        crate::input::associate_vpc_with_hosted_zone_input::Builder::default()
    }
}

/// See [`ChangeResourceRecordSetsInput`](crate::input::ChangeResourceRecordSetsInput)
pub mod change_resource_record_sets_input {
    /// A builder for [`ChangeResourceRecordSetsInput`](crate::input::ChangeResourceRecordSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) change_batch: std::option::Option<crate::model::ChangeBatch>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
        pub fn change_batch(mut self, input: crate::model::ChangeBatch) -> Self {
            self.change_batch = Some(input);
            self
        }
        /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
        pub fn set_change_batch(
            mut self,
            input: std::option::Option<crate::model::ChangeBatch>,
        ) -> Self {
            self.change_batch = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeResourceRecordSetsInput`](crate::input::ChangeResourceRecordSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ChangeResourceRecordSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ChangeResourceRecordSetsInput {
                hosted_zone_id: self.hosted_zone_id,
                change_batch: self.change_batch,
            })
        }
    }
}
#[doc(hidden)]
pub type ChangeResourceRecordSetsInputOperationOutputAlias =
    crate::operation::ChangeResourceRecordSets;
#[doc(hidden)]
pub type ChangeResourceRecordSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ChangeResourceRecordSetsInput {
    /// Consumes the builder and constructs an Operation<[`ChangeResourceRecordSets`](crate::operation::ChangeResourceRecordSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ChangeResourceRecordSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ChangeResourceRecordSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.hosted_zone_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_4, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/rrset",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ChangeResourceRecordSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ChangeResourceRecordSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_change_resource_record_sets(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ChangeResourceRecordSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ChangeResourceRecordSets",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ChangeResourceRecordSetsInput`](crate::input::ChangeResourceRecordSetsInput)
    pub fn builder() -> crate::input::change_resource_record_sets_input::Builder {
        crate::input::change_resource_record_sets_input::Builder::default()
    }
}

/// See [`ChangeTagsForResourceInput`](crate::input::ChangeTagsForResourceInput)
pub mod change_tags_for_resource_input {
    /// A builder for [`ChangeTagsForResourceInput`](crate::input::ChangeTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::TagResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) add_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) remove_tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li>
        /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
        /// </li>
        /// <li>
        /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li>
        /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
        /// </li>
        /// <li>
        /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Appends an item to `add_tags`.
        ///
        /// To override the contents of this collection use [`set_add_tags`](Self::set_add_tags).
        ///
        /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags
        /// that you want to edit <code>Value</code> for.</p>
        /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
        pub fn add_tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.add_tags.unwrap_or_default();
            v.push(input.into());
            self.add_tags = Some(v);
            self
        }
        /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags
        /// that you want to edit <code>Value</code> for.</p>
        /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
        pub fn set_add_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.add_tags = input;
            self
        }
        /// Appends an item to `remove_tag_keys`.
        ///
        /// To override the contents of this collection use [`set_remove_tag_keys`](Self::set_remove_tag_keys).
        ///
        /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone.
        /// You can specify up to 10 keys.</p>
        pub fn remove_tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.remove_tag_keys.unwrap_or_default();
            v.push(input.into());
            self.remove_tag_keys = Some(v);
            self
        }
        /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone.
        /// You can specify up to 10 keys.</p>
        pub fn set_remove_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.remove_tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeTagsForResourceInput`](crate::input::ChangeTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ChangeTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ChangeTagsForResourceInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                add_tags: self.add_tags,
                remove_tag_keys: self.remove_tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type ChangeTagsForResourceInputOperationOutputAlias = crate::operation::ChangeTagsForResource;
#[doc(hidden)]
pub type ChangeTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ChangeTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ChangeTagsForResource`](crate::operation::ChangeTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ChangeTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ChangeTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.resource_type;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_type",
                        details: "cannot be empty or unset",
                    })?;
            let resource_type = aws_smithy_http::label::fmt_string(input_5, false);
            if resource_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_type",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.resource_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_6, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/tags/{ResourceType}/{ResourceId}",
                ResourceType = resource_type,
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ChangeTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ChangeTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_change_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ChangeTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ChangeTagsForResource",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ChangeTagsForResourceInput`](crate::input::ChangeTagsForResourceInput)
    pub fn builder() -> crate::input::change_tags_for_resource_input::Builder {
        crate::input::change_tags_for_resource_input::Builder::default()
    }
}

/// See [`CreateHealthCheckInput`](crate::input::CreateHealthCheckInput)
pub mod create_health_check_input {
    /// A builder for [`CreateHealthCheckInput`](crate::input::CreateHealthCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request
        /// without the risk of creating two identical health checks:</p>
        /// <ul>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings
        /// as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist,
        /// Route 53 returns the settings for the existing health check.</p>
        /// </li>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check,
        /// regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
        /// </li>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check
        /// but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
        /// </li>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to
        /// an existing health check, Route 53 creates the health check.</p>
        /// </li>
        /// </ul>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request
        /// without the risk of creating two identical health checks:</p>
        /// <ul>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings
        /// as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist,
        /// Route 53 returns the settings for the existing health check.</p>
        /// </li>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check,
        /// regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
        /// </li>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check
        /// but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
        /// </li>
        /// <li>
        /// <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to
        /// an existing health check, Route 53 creates the health check.</p>
        /// </li>
        /// </ul>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>A complex type that contains settings for a new health check.</p>
        pub fn health_check_config(mut self, input: crate::model::HealthCheckConfig) -> Self {
            self.health_check_config = Some(input);
            self
        }
        /// <p>A complex type that contains settings for a new health check.</p>
        pub fn set_health_check_config(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfig>,
        ) -> Self {
            self.health_check_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHealthCheckInput`](crate::input::CreateHealthCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHealthCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHealthCheckInput {
                caller_reference: self.caller_reference,
                health_check_config: self.health_check_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHealthCheckInputOperationOutputAlias = crate::operation::CreateHealthCheck;
#[doc(hidden)]
pub type CreateHealthCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHealthCheckInput {
    /// Consumes the builder and constructs an Operation<[`CreateHealthCheck`](crate::operation::CreateHealthCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHealthCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHealthCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/healthcheck").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHealthCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHealthCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_health_check(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHealthCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHealthCheck",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHealthCheckInput`](crate::input::CreateHealthCheckInput)
    pub fn builder() -> crate::input::create_health_check_input::Builder {
        crate::input::create_health_check_input::Builder::default()
    }
}

/// See [`CreateHostedZoneInput`](crate::input::CreateHostedZoneInput)
pub mod create_hosted_zone_input {
    /// A builder for [`CreateHostedZoneInput`](crate::input::CreateHostedZoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) hosted_zone_config: std::option::Option<crate::model::HostedZoneConfig>,
        pub(crate) delegation_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>.
        /// The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats
        /// <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
        /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name
        /// is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that
        /// <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>.
        /// The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats
        /// <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
        /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name
        /// is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that
        /// <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
        /// <p>You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon VPCs with the hosted zone,
        /// use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a>
        /// after you create a hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
        /// <p>You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon VPCs with the hosted zone,
        /// use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a>
        /// after you create a hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without
        /// the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a
        /// <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without
        /// the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a
        /// <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>(Optional) A complex type that contains the following optional values:</p>
        /// <ul>
        /// <li>
        /// <p>For public and private hosted zones, an optional comment</p>
        /// </li>
        /// <li>
        /// <p>For private hosted zones, an optional <code>PrivateZone</code> element</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and
        /// the other elements.</p>
        pub fn hosted_zone_config(mut self, input: crate::model::HostedZoneConfig) -> Self {
            self.hosted_zone_config = Some(input);
            self
        }
        /// <p>(Optional) A complex type that contains the following optional values:</p>
        /// <ul>
        /// <li>
        /// <p>For public and private hosted zones, an optional comment</p>
        /// </li>
        /// <li>
        /// <p>For private hosted zones, an optional <code>PrivateZone</code> element</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and
        /// the other elements.</p>
        pub fn set_hosted_zone_config(
            mut self,
            input: std::option::Option<crate::model::HostedZoneConfig>,
        ) -> Self {
            self.hosted_zone_config = input;
            self
        }
        /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set
        /// when you created it. For more information about reusable delegation sets, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegation_set_id = Some(input.into());
            self
        }
        /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set
        /// when you created it. For more information about reusable delegation sets, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegation_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHostedZoneInput`](crate::input::CreateHostedZoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHostedZoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHostedZoneInput {
                name: self.name,
                vpc: self.vpc,
                caller_reference: self.caller_reference,
                hosted_zone_config: self.hosted_zone_config,
                delegation_set_id: self.delegation_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHostedZoneInputOperationOutputAlias = crate::operation::CreateHostedZone;
#[doc(hidden)]
pub type CreateHostedZoneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHostedZoneInput {
    /// Consumes the builder and constructs an Operation<[`CreateHostedZone`](crate::operation::CreateHostedZone)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHostedZone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHostedZoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/hostedzone").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHostedZoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHostedZoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_hosted_zone(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHostedZone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHostedZone",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHostedZoneInput`](crate::input::CreateHostedZoneInput)
    pub fn builder() -> crate::input::create_hosted_zone_input::Builder {
        crate::input::create_hosted_zone_input::Builder::default()
    }
}

/// See [`CreateKeySigningKeyInput`](crate::input::CreateKeySigningKeyInput)
pub mod create_key_signing_key_input {
    /// A builder for [`CreateKeySigningKeyInput`](crate::input::CreateKeySigningKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) key_management_service_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>The unique string (ID) used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The unique string (ID) used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The Amazon resource name (ARN) for a customer managed customer master key (CMK) in Key Management Service (KMS).
        /// The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.
        /// To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC,
        /// scroll down to <b>Example</b>. </p>
        /// <p>You must configure the customer managed CMK as follows:</p>
        /// <dl>
        /// <dt>Status</dt>
        /// <dd>
        /// <p>Enabled</p>
        /// </dd>
        /// <dt>Key spec</dt>
        /// <dd>
        /// <p>ECC_NIST_P256</p>
        /// </dd>
        /// <dt>Key usage</dt>
        /// <dd>
        /// <p>Sign and verify</p>
        /// </dd>
        /// <dt>Key policy</dt>
        /// <dd>
        /// <p>The key policy must give permission for the following actions:</p>
        /// <ul>
        /// <li>
        /// <p>DescribeKey</p>
        /// </li>
        /// <li>
        /// <p>GetPublicKey</p>
        /// </li>
        /// <li>
        /// <p>Sign</p>
        /// </li>
        /// </ul>
        /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account.
        /// Specify the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"Service": "dnssec-route53.amazonaws.com"</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        /// <p>For more information about working with a customer managed CMK in KMS, see
        /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
        pub fn key_management_service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_management_service_arn = Some(input.into());
            self
        }
        /// <p>The Amazon resource name (ARN) for a customer managed customer master key (CMK) in Key Management Service (KMS).
        /// The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.
        /// To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC,
        /// scroll down to <b>Example</b>. </p>
        /// <p>You must configure the customer managed CMK as follows:</p>
        /// <dl>
        /// <dt>Status</dt>
        /// <dd>
        /// <p>Enabled</p>
        /// </dd>
        /// <dt>Key spec</dt>
        /// <dd>
        /// <p>ECC_NIST_P256</p>
        /// </dd>
        /// <dt>Key usage</dt>
        /// <dd>
        /// <p>Sign and verify</p>
        /// </dd>
        /// <dt>Key policy</dt>
        /// <dd>
        /// <p>The key policy must give permission for the following actions:</p>
        /// <ul>
        /// <li>
        /// <p>DescribeKey</p>
        /// </li>
        /// <li>
        /// <p>GetPublicKey</p>
        /// </li>
        /// <li>
        /// <p>Sign</p>
        /// </li>
        /// </ul>
        /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account.
        /// Specify the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"Service": "dnssec-route53.amazonaws.com"</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        /// <p>For more information about working with a customer managed CMK in KMS, see
        /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
        pub fn set_key_management_service_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_management_service_arn = input;
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
        /// hosted zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
        /// hosted zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeySigningKeyInput`](crate::input::CreateKeySigningKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateKeySigningKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateKeySigningKeyInput {
                caller_reference: self.caller_reference,
                hosted_zone_id: self.hosted_zone_id,
                key_management_service_arn: self.key_management_service_arn,
                name: self.name,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateKeySigningKeyInputOperationOutputAlias = crate::operation::CreateKeySigningKey;
#[doc(hidden)]
pub type CreateKeySigningKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateKeySigningKeyInput {
    /// Consumes the builder and constructs an Operation<[`CreateKeySigningKey`](crate::operation::CreateKeySigningKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateKeySigningKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateKeySigningKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/keysigningkey").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateKeySigningKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateKeySigningKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_key_signing_key(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateKeySigningKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateKeySigningKey",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateKeySigningKeyInput`](crate::input::CreateKeySigningKeyInput)
    pub fn builder() -> crate::input::create_key_signing_key_input::Builder {
        crate::input::create_key_signing_key_input::Builder::default()
    }
}

/// See [`CreateQueryLoggingConfigInput`](crate::input::CreateQueryLoggingConfigInput)
pub mod create_query_logging_config_input {
    /// A builder for [`CreateQueryLoggingConfigInput`](crate::input::CreateQueryLoggingConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format
        /// of the ARN:</p>
        ///
        /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
        /// </p>
        ///
        /// <p>To get the ARN for a log group, you can use the CloudWatch console, the
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action,
        /// the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command,
        /// or the applicable command in one of the Amazon Web Services SDKs.</p>
        pub fn cloud_watch_logs_log_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format
        /// of the ARN:</p>
        ///
        /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
        /// </p>
        ///
        /// <p>To get the ARN for a log group, you can use the CloudWatch console, the
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action,
        /// the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command,
        /// or the applicable command in one of the Amazon Web Services SDKs.</p>
        pub fn set_cloud_watch_logs_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_log_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQueryLoggingConfigInput`](crate::input::CreateQueryLoggingConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateQueryLoggingConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateQueryLoggingConfigInput {
                hosted_zone_id: self.hosted_zone_id,
                cloud_watch_logs_log_group_arn: self.cloud_watch_logs_log_group_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateQueryLoggingConfigInputOperationOutputAlias =
    crate::operation::CreateQueryLoggingConfig;
#[doc(hidden)]
pub type CreateQueryLoggingConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateQueryLoggingConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateQueryLoggingConfig`](crate::operation::CreateQueryLoggingConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateQueryLoggingConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateQueryLoggingConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/queryloggingconfig").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateQueryLoggingConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateQueryLoggingConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_query_logging_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateQueryLoggingConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateQueryLoggingConfig",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateQueryLoggingConfigInput`](crate::input::CreateQueryLoggingConfigInput)
    pub fn builder() -> crate::input::create_query_logging_config_input::Builder {
        crate::input::create_query_logging_config_input::Builder::default()
    }
}

/// See [`CreateReusableDelegationSetInput`](crate::input::CreateReusableDelegationSetInput)
pub mod create_reusable_delegation_set_input {
    /// A builder for [`CreateReusableDelegationSetInput`](crate::input::CreateReusableDelegationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) caller_reference: std::option::Option<std::string::String>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string that identifies the request, and that allows you to retry failed
        /// <code>CreateReusableDelegationSet</code> requests without the risk of executing the
        /// operation twice. You must use a unique <code>CallerReference</code> string every time you
        /// submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be
        /// any unique string, for example a date/time stamp.</p>
        pub fn caller_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.caller_reference = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the request, and that allows you to retry failed
        /// <code>CreateReusableDelegationSet</code> requests without the risk of executing the
        /// operation twice. You must use a unique <code>CallerReference</code> string every time you
        /// submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be
        /// any unique string, for example a date/time stamp.</p>
        pub fn set_caller_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.caller_reference = input;
            self
        }
        /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID
        /// for that hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID
        /// for that hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReusableDelegationSetInput`](crate::input::CreateReusableDelegationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReusableDelegationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReusableDelegationSetInput {
                caller_reference: self.caller_reference,
                hosted_zone_id: self.hosted_zone_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReusableDelegationSetInputOperationOutputAlias =
    crate::operation::CreateReusableDelegationSet;
#[doc(hidden)]
pub type CreateReusableDelegationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReusableDelegationSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateReusableDelegationSet`](crate::operation::CreateReusableDelegationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReusableDelegationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReusableDelegationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/delegationset").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReusableDelegationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReusableDelegationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_reusable_delegation_set(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReusableDelegationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReusableDelegationSet",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReusableDelegationSetInput`](crate::input::CreateReusableDelegationSetInput)
    pub fn builder() -> crate::input::create_reusable_delegation_set_input::Builder {
        crate::input::create_reusable_delegation_set_input::Builder::default()
    }
}

/// See [`CreateTrafficPolicyInput`](crate::input::CreateTrafficPolicyInput)
pub mod create_traffic_policy_input {
    /// A builder for [`CreateTrafficPolicyInput`](crate::input::CreateTrafficPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the traffic policy.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the traffic policy.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The definition of this traffic policy in JSON format. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The definition of this traffic policy in JSON format. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrafficPolicyInput`](crate::input::CreateTrafficPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrafficPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrafficPolicyInput {
                name: self.name,
                document: self.document,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrafficPolicyInputOperationOutputAlias = crate::operation::CreateTrafficPolicy;
#[doc(hidden)]
pub type CreateTrafficPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrafficPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrafficPolicy`](crate::operation::CreateTrafficPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrafficPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrafficPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/trafficpolicy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrafficPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrafficPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_traffic_policy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrafficPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrafficPolicy",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyInput`](crate::input::CreateTrafficPolicyInput)
    pub fn builder() -> crate::input::create_traffic_policy_input::Builder {
        crate::input::create_traffic_policy_input::Builder::default()
    }
}

/// See [`CreateTrafficPolicyInstanceInput`](crate::input::CreateTrafficPolicyInstanceInput)
pub mod create_traffic_policy_instance_input {
    /// A builder for [`CreateTrafficPolicyInstanceInput`](crate::input::CreateTrafficPolicyInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<i64>,
        pub(crate) traffic_policy_id: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using
        /// the resource record sets that Route 53 creates for this traffic policy instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using
        /// the resource record sets that Route 53 creates for this traffic policy instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.traffic_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_id = input;
            self
        }
        /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.traffic_policy_version = Some(input);
            self
        }
        /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.traffic_policy_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrafficPolicyInstanceInput`](crate::input::CreateTrafficPolicyInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrafficPolicyInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrafficPolicyInstanceInput {
                hosted_zone_id: self.hosted_zone_id,
                name: self.name,
                ttl: self.ttl,
                traffic_policy_id: self.traffic_policy_id,
                traffic_policy_version: self.traffic_policy_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrafficPolicyInstanceInputOperationOutputAlias =
    crate::operation::CreateTrafficPolicyInstance;
#[doc(hidden)]
pub type CreateTrafficPolicyInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrafficPolicyInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrafficPolicyInstance`](crate::operation::CreateTrafficPolicyInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrafficPolicyInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrafficPolicyInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/trafficpolicyinstance").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrafficPolicyInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrafficPolicyInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_traffic_policy_instance(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrafficPolicyInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrafficPolicyInstance",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyInstanceInput`](crate::input::CreateTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::create_traffic_policy_instance_input::Builder {
        crate::input::create_traffic_policy_instance_input::Builder::default()
    }
}

/// See [`CreateTrafficPolicyVersionInput`](crate::input::CreateTrafficPolicyVersionInput)
pub mod create_traffic_policy_version_input {
    /// A builder for [`CreateTrafficPolicyVersionInput`](crate::input::CreateTrafficPolicyVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the traffic policy for which you want to create a new version.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy for which you want to create a new version.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code>
        /// request. For more information about the JSON format, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code>
        /// request. For more information about the JSON format, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrafficPolicyVersionInput`](crate::input::CreateTrafficPolicyVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrafficPolicyVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrafficPolicyVersionInput {
                id: self.id,
                document: self.document,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrafficPolicyVersionInputOperationOutputAlias =
    crate::operation::CreateTrafficPolicyVersion;
#[doc(hidden)]
pub type CreateTrafficPolicyVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrafficPolicyVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrafficPolicyVersion`](crate::operation::CreateTrafficPolicyVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrafficPolicyVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrafficPolicyVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_7, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/trafficpolicy/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrafficPolicyVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrafficPolicyVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_traffic_policy_version(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrafficPolicyVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrafficPolicyVersion",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrafficPolicyVersionInput`](crate::input::CreateTrafficPolicyVersionInput)
    pub fn builder() -> crate::input::create_traffic_policy_version_input::Builder {
        crate::input::create_traffic_policy_version_input::Builder::default()
    }
}

/// See [`CreateVpcAssociationAuthorizationInput`](crate::input::CreateVpcAssociationAuthorizationInput)
pub mod create_vpc_association_authorization_input {
    /// A builder for [`CreateVpcAssociationAuthorizationInput`](crate::input::CreateVpcAssociationAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
    }
    impl Builder {
        /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating
        /// with your hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating
        /// with your hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVpcAssociationAuthorizationInput`](crate::input::CreateVpcAssociationAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVpcAssociationAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVpcAssociationAuthorizationInput {
                hosted_zone_id: self.hosted_zone_id,
                vpc: self.vpc,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVpcAssociationAuthorizationInputOperationOutputAlias =
    crate::operation::CreateVPCAssociationAuthorization;
#[doc(hidden)]
pub type CreateVpcAssociationAuthorizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVpcAssociationAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`CreateVPCAssociationAuthorization`](crate::operation::CreateVPCAssociationAuthorization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVPCAssociationAuthorization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVpcAssociationAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.hosted_zone_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_8, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/authorizevpcassociation",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVpcAssociationAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVpcAssociationAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_vpc_association_authorization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVPCAssociationAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVPCAssociationAuthorization",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVpcAssociationAuthorizationInput`](crate::input::CreateVpcAssociationAuthorizationInput)
    pub fn builder() -> crate::input::create_vpc_association_authorization_input::Builder {
        crate::input::create_vpc_association_authorization_input::Builder::default()
    }
}

/// See [`DeactivateKeySigningKeyInput`](crate::input::DeactivateKeySigningKeyInput)
pub mod deactivate_key_signing_key_input {
    /// A builder for [`DeactivateKeySigningKeyInput`](crate::input::DeactivateKeySigningKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateKeySigningKeyInput`](crate::input::DeactivateKeySigningKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateKeySigningKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateKeySigningKeyInput {
                hosted_zone_id: self.hosted_zone_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeactivateKeySigningKeyInputOperationOutputAlias =
    crate::operation::DeactivateKeySigningKey;
#[doc(hidden)]
pub type DeactivateKeySigningKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeactivateKeySigningKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateKeySigningKey`](crate::operation::DeactivateKeySigningKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateKeySigningKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeactivateKeySigningKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.hosted_zone_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_9, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_10, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/deactivate",
                HostedZoneId = hosted_zone_id,
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeactivateKeySigningKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeactivateKeySigningKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateKeySigningKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateKeySigningKey",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeactivateKeySigningKeyInput`](crate::input::DeactivateKeySigningKeyInput)
    pub fn builder() -> crate::input::deactivate_key_signing_key_input::Builder {
        crate::input::deactivate_key_signing_key_input::Builder::default()
    }
}

/// See [`DeleteHealthCheckInput`](crate::input::DeleteHealthCheckInput)
pub mod delete_health_check_input {
    /// A builder for [`DeleteHealthCheckInput`](crate::input::DeleteHealthCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the health check that you want to delete.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_id = Some(input.into());
            self
        }
        /// <p>The ID of the health check that you want to delete.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHealthCheckInput`](crate::input::DeleteHealthCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHealthCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHealthCheckInput {
                health_check_id: self.health_check_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHealthCheckInputOperationOutputAlias = crate::operation::DeleteHealthCheck;
#[doc(hidden)]
pub type DeleteHealthCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHealthCheckInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHealthCheck`](crate::operation::DeleteHealthCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHealthCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHealthCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.health_check_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "health_check_id",
                        details: "cannot be empty or unset",
                    })?;
            let health_check_id = aws_smithy_http::label::fmt_string(input_11, false);
            if health_check_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "health_check_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/healthcheck/{HealthCheckId}",
                HealthCheckId = health_check_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHealthCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHealthCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHealthCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHealthCheck",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHealthCheckInput`](crate::input::DeleteHealthCheckInput)
    pub fn builder() -> crate::input::delete_health_check_input::Builder {
        crate::input::delete_health_check_input::Builder::default()
    }
}

/// See [`DeleteHostedZoneInput`](crate::input::DeleteHostedZoneInput)
pub mod delete_hosted_zone_input {
    /// A builder for [`DeleteHostedZoneInput`](crate::input::DeleteHostedZoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHostedZoneInput`](crate::input::DeleteHostedZoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHostedZoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHostedZoneInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteHostedZoneInputOperationOutputAlias = crate::operation::DeleteHostedZone;
#[doc(hidden)]
pub type DeleteHostedZoneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHostedZoneInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHostedZone`](crate::operation::DeleteHostedZone)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHostedZone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHostedZoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_12, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/hostedzone/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHostedZoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHostedZoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHostedZone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHostedZone",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHostedZoneInput`](crate::input::DeleteHostedZoneInput)
    pub fn builder() -> crate::input::delete_hosted_zone_input::Builder {
        crate::input::delete_hosted_zone_input::Builder::default()
    }
}

/// See [`DeleteKeySigningKeyInput`](crate::input::DeleteKeySigningKeyInput)
pub mod delete_key_signing_key_input {
    /// A builder for [`DeleteKeySigningKeyInput`](crate::input::DeleteKeySigningKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A string used to identify a key-signing key (KSK).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKeySigningKeyInput`](crate::input::DeleteKeySigningKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteKeySigningKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteKeySigningKeyInput {
                hosted_zone_id: self.hosted_zone_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteKeySigningKeyInputOperationOutputAlias = crate::operation::DeleteKeySigningKey;
#[doc(hidden)]
pub type DeleteKeySigningKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteKeySigningKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteKeySigningKey`](crate::operation::DeleteKeySigningKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteKeySigningKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteKeySigningKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.hosted_zone_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_13, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.name;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_14, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}",
                HostedZoneId = hosted_zone_id,
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteKeySigningKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteKeySigningKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteKeySigningKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteKeySigningKey",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteKeySigningKeyInput`](crate::input::DeleteKeySigningKeyInput)
    pub fn builder() -> crate::input::delete_key_signing_key_input::Builder {
        crate::input::delete_key_signing_key_input::Builder::default()
    }
}

/// See [`DeleteQueryLoggingConfigInput`](crate::input::DeleteQueryLoggingConfigInput)
pub mod delete_query_logging_config_input {
    /// A builder for [`DeleteQueryLoggingConfigInput`](crate::input::DeleteQueryLoggingConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the configuration that you want to delete. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration that you want to delete. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteQueryLoggingConfigInput`](crate::input::DeleteQueryLoggingConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteQueryLoggingConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteQueryLoggingConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteQueryLoggingConfigInputOperationOutputAlias =
    crate::operation::DeleteQueryLoggingConfig;
#[doc(hidden)]
pub type DeleteQueryLoggingConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteQueryLoggingConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteQueryLoggingConfig`](crate::operation::DeleteQueryLoggingConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteQueryLoggingConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteQueryLoggingConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_15, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/queryloggingconfig/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteQueryLoggingConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteQueryLoggingConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteQueryLoggingConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteQueryLoggingConfig",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteQueryLoggingConfigInput`](crate::input::DeleteQueryLoggingConfigInput)
    pub fn builder() -> crate::input::delete_query_logging_config_input::Builder {
        crate::input::delete_query_logging_config_input::Builder::default()
    }
}

/// See [`DeleteReusableDelegationSetInput`](crate::input::DeleteReusableDelegationSetInput)
pub mod delete_reusable_delegation_set_input {
    /// A builder for [`DeleteReusableDelegationSetInput`](crate::input::DeleteReusableDelegationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the reusable delegation set that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the reusable delegation set that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReusableDelegationSetInput`](crate::input::DeleteReusableDelegationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReusableDelegationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReusableDelegationSetInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteReusableDelegationSetInputOperationOutputAlias =
    crate::operation::DeleteReusableDelegationSet;
#[doc(hidden)]
pub type DeleteReusableDelegationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReusableDelegationSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReusableDelegationSet`](crate::operation::DeleteReusableDelegationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReusableDelegationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReusableDelegationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_16, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/delegationset/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReusableDelegationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReusableDelegationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReusableDelegationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReusableDelegationSet",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReusableDelegationSetInput`](crate::input::DeleteReusableDelegationSetInput)
    pub fn builder() -> crate::input::delete_reusable_delegation_set_input::Builder {
        crate::input::delete_reusable_delegation_set_input::Builder::default()
    }
}

/// See [`DeleteTrafficPolicyInput`](crate::input::DeleteTrafficPolicyInput)
pub mod delete_traffic_policy_input {
    /// A builder for [`DeleteTrafficPolicyInput`](crate::input::DeleteTrafficPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the traffic policy that you want to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version number of the traffic policy that you want to delete.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrafficPolicyInput`](crate::input::DeleteTrafficPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrafficPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrafficPolicyInput {
                id: self.id,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrafficPolicyInputOperationOutputAlias = crate::operation::DeleteTrafficPolicy;
#[doc(hidden)]
pub type DeleteTrafficPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTrafficPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrafficPolicy`](crate::operation::DeleteTrafficPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrafficPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTrafficPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_17, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            let input_18 = &_input.version;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let mut version_encoder = aws_smithy_types::primitive::Encoder::from(*input_18);
            let version = version_encoder.encode();
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/trafficpolicy/{Id}/{Version}",
                Id = id,
                Version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTrafficPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTrafficPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrafficPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrafficPolicy",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrafficPolicyInput`](crate::input::DeleteTrafficPolicyInput)
    pub fn builder() -> crate::input::delete_traffic_policy_input::Builder {
        crate::input::delete_traffic_policy_input::Builder::default()
    }
}

/// See [`DeleteTrafficPolicyInstanceInput`](crate::input::DeleteTrafficPolicyInstanceInput)
pub mod delete_traffic_policy_instance_input {
    /// A builder for [`DeleteTrafficPolicyInstanceInput`](crate::input::DeleteTrafficPolicyInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the traffic policy instance that you want to delete. </p>
        /// <important>
        /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created
        /// the traffic policy instance.</p>
        /// </important>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to delete. </p>
        /// <important>
        /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created
        /// the traffic policy instance.</p>
        /// </important>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrafficPolicyInstanceInput`](crate::input::DeleteTrafficPolicyInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrafficPolicyInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrafficPolicyInstanceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrafficPolicyInstanceInputOperationOutputAlias =
    crate::operation::DeleteTrafficPolicyInstance;
#[doc(hidden)]
pub type DeleteTrafficPolicyInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTrafficPolicyInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrafficPolicyInstance`](crate::operation::DeleteTrafficPolicyInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrafficPolicyInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTrafficPolicyInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_19, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/trafficpolicyinstance/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTrafficPolicyInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTrafficPolicyInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrafficPolicyInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrafficPolicyInstance",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrafficPolicyInstanceInput`](crate::input::DeleteTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::delete_traffic_policy_instance_input::Builder {
        crate::input::delete_traffic_policy_instance_input::Builder::default()
    }
}

/// See [`DeleteVpcAssociationAuthorizationInput`](crate::input::DeleteVpcAssociationAuthorizationInput)
pub mod delete_vpc_association_authorization_input {
    /// A builder for [`DeleteVpcAssociationAuthorizationInput`](crate::input::DeleteVpcAssociationAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
    }
    impl Builder {
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
        /// that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
        /// that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
        /// that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
        /// that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVpcAssociationAuthorizationInput`](crate::input::DeleteVpcAssociationAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVpcAssociationAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVpcAssociationAuthorizationInput {
                hosted_zone_id: self.hosted_zone_id,
                vpc: self.vpc,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVpcAssociationAuthorizationInputOperationOutputAlias =
    crate::operation::DeleteVPCAssociationAuthorization;
#[doc(hidden)]
pub type DeleteVpcAssociationAuthorizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVpcAssociationAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVPCAssociationAuthorization`](crate::operation::DeleteVPCAssociationAuthorization)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVPCAssociationAuthorization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVpcAssociationAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.hosted_zone_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_20, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/deauthorizevpcassociation",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVpcAssociationAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVpcAssociationAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_vpc_association_authorization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVPCAssociationAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVPCAssociationAuthorization",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVpcAssociationAuthorizationInput`](crate::input::DeleteVpcAssociationAuthorizationInput)
    pub fn builder() -> crate::input::delete_vpc_association_authorization_input::Builder {
        crate::input::delete_vpc_association_authorization_input::Builder::default()
    }
}

/// See [`DisableHostedZoneDnssecInput`](crate::input::DisableHostedZoneDnssecInput)
pub mod disable_hosted_zone_dnssec_input {
    /// A builder for [`DisableHostedZoneDnssecInput`](crate::input::DisableHostedZoneDnssecInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableHostedZoneDnssecInput`](crate::input::DisableHostedZoneDnssecInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableHostedZoneDnssecInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableHostedZoneDnssecInput {
                hosted_zone_id: self.hosted_zone_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableHostedZoneDnssecInputOperationOutputAlias =
    crate::operation::DisableHostedZoneDNSSEC;
#[doc(hidden)]
pub type DisableHostedZoneDnssecInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableHostedZoneDnssecInput {
    /// Consumes the builder and constructs an Operation<[`DisableHostedZoneDNSSEC`](crate::operation::DisableHostedZoneDNSSEC)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableHostedZoneDNSSEC,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableHostedZoneDnssecInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.hosted_zone_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_21, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/disable-dnssec",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableHostedZoneDnssecInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableHostedZoneDnssecInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableHostedZoneDNSSEC::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableHostedZoneDNSSEC",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableHostedZoneDnssecInput`](crate::input::DisableHostedZoneDnssecInput)
    pub fn builder() -> crate::input::disable_hosted_zone_dnssec_input::Builder {
        crate::input::disable_hosted_zone_dnssec_input::Builder::default()
    }
}

/// See [`DisassociateVpcFromHostedZoneInput`](crate::input::DisassociateVpcFromHostedZoneInput)
pub mod disassociate_vpc_from_hosted_zone_input {
    /// A builder for [`DisassociateVpcFromHostedZoneInput`](crate::input::DisassociateVpcFromHostedZoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::Vpc>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>A complex type that contains information about the VPC that you're disassociating
        /// from the specified hosted zone.</p>
        pub fn vpc(mut self, input: crate::model::Vpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>A complex type that contains information about the VPC that you're disassociating
        /// from the specified hosted zone.</p>
        pub fn set_vpc(mut self, input: std::option::Option<crate::model::Vpc>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>
        /// <i>Optional:</i> A comment about the disassociation request.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>
        /// <i>Optional:</i> A comment about the disassociation request.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateVpcFromHostedZoneInput`](crate::input::DisassociateVpcFromHostedZoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateVpcFromHostedZoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateVpcFromHostedZoneInput {
                hosted_zone_id: self.hosted_zone_id,
                vpc: self.vpc,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateVpcFromHostedZoneInputOperationOutputAlias =
    crate::operation::DisassociateVPCFromHostedZone;
#[doc(hidden)]
pub type DisassociateVpcFromHostedZoneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateVpcFromHostedZoneInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateVPCFromHostedZone`](crate::operation::DisassociateVPCFromHostedZone)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateVPCFromHostedZone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateVpcFromHostedZoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.hosted_zone_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_22, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/disassociatevpc",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateVpcFromHostedZoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateVpcFromHostedZoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_vpc_from_hosted_zone(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateVPCFromHostedZone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateVPCFromHostedZone",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateVpcFromHostedZoneInput`](crate::input::DisassociateVpcFromHostedZoneInput)
    pub fn builder() -> crate::input::disassociate_vpc_from_hosted_zone_input::Builder {
        crate::input::disassociate_vpc_from_hosted_zone_input::Builder::default()
    }
}

/// See [`EnableHostedZoneDnssecInput`](crate::input::EnableHostedZoneDnssecInput)
pub mod enable_hosted_zone_dnssec_input {
    /// A builder for [`EnableHostedZoneDnssecInput`](crate::input::EnableHostedZoneDnssecInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableHostedZoneDnssecInput`](crate::input::EnableHostedZoneDnssecInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableHostedZoneDnssecInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableHostedZoneDnssecInput {
                hosted_zone_id: self.hosted_zone_id,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableHostedZoneDnssecInputOperationOutputAlias = crate::operation::EnableHostedZoneDNSSEC;
#[doc(hidden)]
pub type EnableHostedZoneDnssecInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableHostedZoneDnssecInput {
    /// Consumes the builder and constructs an Operation<[`EnableHostedZoneDNSSEC`](crate::operation::EnableHostedZoneDNSSEC)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableHostedZoneDNSSEC,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableHostedZoneDnssecInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.hosted_zone_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_23, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/enable-dnssec",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableHostedZoneDnssecInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableHostedZoneDnssecInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableHostedZoneDNSSEC::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableHostedZoneDNSSEC",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableHostedZoneDnssecInput`](crate::input::EnableHostedZoneDnssecInput)
    pub fn builder() -> crate::input::enable_hosted_zone_dnssec_input::Builder {
        crate::input::enable_hosted_zone_dnssec_input::Builder::default()
    }
}

/// See [`GetAccountLimitInput`](crate::input::GetAccountLimitInput)
pub mod get_account_limit_input {
    /// A builder for [`GetAccountLimitInput`](crate::input::GetAccountLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::AccountLimitType>,
    }
    impl Builder {
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create
        /// using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create
        /// using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets
        /// that you can create using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies
        /// that you can create using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances
        /// that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the
        /// Amazon Route 53 console.)</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::AccountLimitType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create
        /// using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create
        /// using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets
        /// that you can create using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies
        /// that you can create using the current account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances
        /// that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the
        /// Amazon Route 53 console.)</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::AccountLimitType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountLimitInput`](crate::input::GetAccountLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountLimitInput {
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccountLimitInputOperationOutputAlias = crate::operation::GetAccountLimit;
#[doc(hidden)]
pub type GetAccountLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountLimitInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountLimit`](crate::operation::GetAccountLimit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.r#type;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "r#type",
                        details: "cannot be empty or unset",
                    })?;
            let r#type = aws_smithy_http::label::fmt_string(input_24, false);
            if r#type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "r#type",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/accountlimit/{Type}", Type = r#type)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountLimit",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountLimitInput`](crate::input::GetAccountLimitInput)
    pub fn builder() -> crate::input::get_account_limit_input::Builder {
        crate::input::get_account_limit_input::Builder::default()
    }
}

/// See [`GetChangeInput`](crate::input::GetChangeInput)
pub mod get_change_input {
    /// A builder for [`GetChangeInput`](crate::input::GetChangeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code>
        /// returned in the <code>Id</code> element when you submitted the request.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code>
        /// returned in the <code>Id</code> element when you submitted the request.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangeInput`](crate::input::GetChangeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetChangeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetChangeInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetChangeInputOperationOutputAlias = crate::operation::GetChange;
#[doc(hidden)]
pub type GetChangeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetChangeInput {
    /// Consumes the builder and constructs an Operation<[`GetChange`](crate::operation::GetChange)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChange,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetChangeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_25, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/change/{Id}", Id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetChangeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetChangeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetChange::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetChange",
                    "route53",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetChangeInput`](crate::input::GetChangeInput)
    pub fn builder() -> crate::input::get_change_input::Builder {
        crate::input::get_change_input::Builder::default()
    }
}

/// See [`GetCheckerIpRangesInput`](crate::input::GetCheckerIpRangesInput)
pub mod get_checker_ip_ranges_input {
    /// A builder for [`GetCheckerIpRangesInput`](crate::input::GetCheckerIpRangesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetCheckerIpRangesInput`](crate::input::GetCheckerIpRangesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCheckerIpRangesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCheckerIpRangesInput {})
        }
    }
}
#[doc(hidden)]
pub type GetCheckerIpRangesInputOperationOutputAlias = crate::operation::GetCheckerIpRanges;
#[doc(hidden)]
pub type GetCheckerIpRangesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCheckerIpRangesInput {
    /// Consumes the builder and constructs an Operation<[`GetCheckerIpRanges`](crate::operation::GetCheckerIpRanges)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCheckerIpRanges,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCheckerIpRangesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/checkeripranges").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCheckerIpRangesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCheckerIpRangesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCheckerIpRanges::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCheckerIpRanges",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCheckerIpRangesInput`](crate::input::GetCheckerIpRangesInput)
    pub fn builder() -> crate::input::get_checker_ip_ranges_input::Builder {
        crate::input::get_checker_ip_ranges_input::Builder::default()
    }
}

/// See [`GetDnssecInput`](crate::input::GetDnssecInput)
pub mod get_dnssec_input {
    /// A builder for [`GetDnssecInput`](crate::input::GetDnssecInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>A unique string used to identify a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDnssecInput`](crate::input::GetDnssecInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDnssecInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDnssecInput {
                hosted_zone_id: self.hosted_zone_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDnssecInputOperationOutputAlias = crate::operation::GetDNSSEC;
#[doc(hidden)]
pub type GetDnssecInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDnssecInput {
    /// Consumes the builder and constructs an Operation<[`GetDNSSEC`](crate::operation::GetDNSSEC)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDNSSEC,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDnssecInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.hosted_zone_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_26, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/dnssec",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDnssecInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDnssecInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDNSSEC::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDNSSEC",
                    "route53",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDnssecInput`](crate::input::GetDnssecInput)
    pub fn builder() -> crate::input::get_dnssec_input::Builder {
        crate::input::get_dnssec_input::Builder::default()
    }
}

/// See [`GetGeoLocationInput`](crate::input::GetGeoLocationInput)
pub mod get_geo_location_input {
    /// A builder for [`GetGeoLocationInput`](crate::input::GetGeoLocationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) continent_code: std::option::Option<std::string::String>,
        pub(crate) country_code: std::option::Option<std::string::String>,
        pub(crate) subdivision_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AF</b>: Africa</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AN</b>: Antarctica</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AS</b>: Asia</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EU</b>: Europe</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>OC</b>: Oceania</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NA</b>: North America</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SA</b>: South America</p>
        /// </li>
        /// </ul>
        pub fn continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.continent_code = Some(input.into());
            self
        }
        /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AF</b>: Africa</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AN</b>: Antarctica</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AS</b>: Asia</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EU</b>: Europe</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>OC</b>: Oceania</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NA</b>: North America</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>SA</b>: South America</p>
        /// </li>
        /// </ul>
        pub fn set_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continent_code = input;
            self
        }
        /// <p>Amazon Route 53 uses the two-letter country codes that are specified in
        /// <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
        pub fn country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.country_code = Some(input.into());
            self
        }
        /// <p>Amazon Route 53 uses the two-letter country codes that are specified in
        /// <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
        pub fn set_country_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country_code = input;
            self
        }
        /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a>  on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
        pub fn subdivision_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.subdivision_code = Some(input.into());
            self
        }
        /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a>  on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
        pub fn set_subdivision_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subdivision_code = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeoLocationInput`](crate::input::GetGeoLocationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGeoLocationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGeoLocationInput {
                continent_code: self.continent_code,
                country_code: self.country_code,
                subdivision_code: self.subdivision_code,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGeoLocationInputOperationOutputAlias = crate::operation::GetGeoLocation;
#[doc(hidden)]
pub type GetGeoLocationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGeoLocationInput {
    /// Consumes the builder and constructs an Operation<[`GetGeoLocation`](crate::operation::GetGeoLocation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGeoLocation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGeoLocationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/geolocation").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetGeoLocationInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_27) = &_input.continent_code {
                query.push_kv(
                    "continentcode",
                    &aws_smithy_http::query::fmt_string(&inner_27),
                );
            }
            if let Some(inner_28) = &_input.country_code {
                query.push_kv(
                    "countrycode",
                    &aws_smithy_http::query::fmt_string(&inner_28),
                );
            }
            if let Some(inner_29) = &_input.subdivision_code {
                query.push_kv(
                    "subdivisioncode",
                    &aws_smithy_http::query::fmt_string(&inner_29),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGeoLocationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGeoLocationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGeoLocation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGeoLocation",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGeoLocationInput`](crate::input::GetGeoLocationInput)
    pub fn builder() -> crate::input::get_geo_location_input::Builder {
        crate::input::get_geo_location_input::Builder::default()
    }
}

/// See [`GetHealthCheckInput`](crate::input::GetHealthCheckInput)
pub mod get_health_check_input {
    /// A builder for [`GetHealthCheckInput`](crate::input::GetHealthCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set,
        /// you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_id = Some(input.into());
            self
        }
        /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set,
        /// you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHealthCheckInput`](crate::input::GetHealthCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHealthCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHealthCheckInput {
                health_check_id: self.health_check_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetHealthCheckInputOperationOutputAlias = crate::operation::GetHealthCheck;
#[doc(hidden)]
pub type GetHealthCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHealthCheckInput {
    /// Consumes the builder and constructs an Operation<[`GetHealthCheck`](crate::operation::GetHealthCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHealthCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHealthCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.health_check_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "health_check_id",
                        details: "cannot be empty or unset",
                    })?;
            let health_check_id = aws_smithy_http::label::fmt_string(input_30, false);
            if health_check_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "health_check_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/healthcheck/{HealthCheckId}",
                HealthCheckId = health_check_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHealthCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHealthCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHealthCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHealthCheck",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHealthCheckInput`](crate::input::GetHealthCheckInput)
    pub fn builder() -> crate::input::get_health_check_input::Builder {
        crate::input::get_health_check_input::Builder::default()
    }
}

/// See [`GetHealthCheckCountInput`](crate::input::GetHealthCheckCountInput)
pub mod get_health_check_count_input {
    /// A builder for [`GetHealthCheckCountInput`](crate::input::GetHealthCheckCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetHealthCheckCountInput`](crate::input::GetHealthCheckCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHealthCheckCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHealthCheckCountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetHealthCheckCountInputOperationOutputAlias = crate::operation::GetHealthCheckCount;
#[doc(hidden)]
pub type GetHealthCheckCountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHealthCheckCountInput {
    /// Consumes the builder and constructs an Operation<[`GetHealthCheckCount`](crate::operation::GetHealthCheckCount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHealthCheckCount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHealthCheckCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/healthcheckcount").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHealthCheckCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHealthCheckCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHealthCheckCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHealthCheckCount",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHealthCheckCountInput`](crate::input::GetHealthCheckCountInput)
    pub fn builder() -> crate::input::get_health_check_count_input::Builder {
        crate::input::get_health_check_count_input::Builder::default()
    }
}

/// See [`GetHealthCheckLastFailureReasonInput`](crate::input::GetHealthCheckLastFailureReasonInput)
pub mod get_health_check_last_failure_reason_input {
    /// A builder for [`GetHealthCheckLastFailureReasonInput`](crate::input::GetHealthCheckLastFailureReasonInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the health check for which you want the last failure reason. When you created the health check,
        /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        /// <note>
        /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the
        /// CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
        /// </note>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_id = Some(input.into());
            self
        }
        /// <p>The ID for the health check for which you want the last failure reason. When you created the health check,
        /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        /// <note>
        /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the
        /// CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
        /// </note>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHealthCheckLastFailureReasonInput`](crate::input::GetHealthCheckLastFailureReasonInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHealthCheckLastFailureReasonInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHealthCheckLastFailureReasonInput {
                health_check_id: self.health_check_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetHealthCheckLastFailureReasonInputOperationOutputAlias =
    crate::operation::GetHealthCheckLastFailureReason;
#[doc(hidden)]
pub type GetHealthCheckLastFailureReasonInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHealthCheckLastFailureReasonInput {
    /// Consumes the builder and constructs an Operation<[`GetHealthCheckLastFailureReason`](crate::operation::GetHealthCheckLastFailureReason)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHealthCheckLastFailureReason,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHealthCheckLastFailureReasonInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.health_check_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "health_check_id",
                        details: "cannot be empty or unset",
                    })?;
            let health_check_id = aws_smithy_http::label::fmt_string(input_31, false);
            if health_check_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "health_check_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason",
                HealthCheckId = health_check_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHealthCheckLastFailureReasonInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHealthCheckLastFailureReasonInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHealthCheckLastFailureReason::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHealthCheckLastFailureReason",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHealthCheckLastFailureReasonInput`](crate::input::GetHealthCheckLastFailureReasonInput)
    pub fn builder() -> crate::input::get_health_check_last_failure_reason_input::Builder {
        crate::input::get_health_check_last_failure_reason_input::Builder::default()
    }
}

/// See [`GetHealthCheckStatusInput`](crate::input::GetHealthCheckStatusInput)
pub mod get_health_check_status_input {
    /// A builder for [`GetHealthCheckStatusInput`](crate::input::GetHealthCheckStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the health check that you want the current status for. When you created the health check,
        /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        /// <note>
        /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console.
        /// You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
        /// </note>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_id = Some(input.into());
            self
        }
        /// <p>The ID for the health check that you want the current status for. When you created the health check,
        /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        /// <note>
        /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console.
        /// You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
        /// </note>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHealthCheckStatusInput`](crate::input::GetHealthCheckStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHealthCheckStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHealthCheckStatusInput {
                health_check_id: self.health_check_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetHealthCheckStatusInputOperationOutputAlias = crate::operation::GetHealthCheckStatus;
#[doc(hidden)]
pub type GetHealthCheckStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHealthCheckStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetHealthCheckStatus`](crate::operation::GetHealthCheckStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHealthCheckStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHealthCheckStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.health_check_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "health_check_id",
                        details: "cannot be empty or unset",
                    })?;
            let health_check_id = aws_smithy_http::label::fmt_string(input_32, false);
            if health_check_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "health_check_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/healthcheck/{HealthCheckId}/status",
                HealthCheckId = health_check_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHealthCheckStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHealthCheckStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHealthCheckStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHealthCheckStatus",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHealthCheckStatusInput`](crate::input::GetHealthCheckStatusInput)
    pub fn builder() -> crate::input::get_health_check_status_input::Builder {
        crate::input::get_health_check_status_input::Builder::default()
    }
}

/// See [`GetHostedZoneInput`](crate::input::GetHostedZoneInput)
pub mod get_hosted_zone_input {
    /// A builder for [`GetHostedZoneInput`](crate::input::GetHostedZoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostedZoneInput`](crate::input::GetHostedZoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHostedZoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHostedZoneInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetHostedZoneInputOperationOutputAlias = crate::operation::GetHostedZone;
#[doc(hidden)]
pub type GetHostedZoneInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHostedZoneInput {
    /// Consumes the builder and constructs an Operation<[`GetHostedZone`](crate::operation::GetHostedZone)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHostedZone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHostedZoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_33, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/hostedzone/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHostedZoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHostedZoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHostedZone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHostedZone",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHostedZoneInput`](crate::input::GetHostedZoneInput)
    pub fn builder() -> crate::input::get_hosted_zone_input::Builder {
        crate::input::get_hosted_zone_input::Builder::default()
    }
}

/// See [`GetHostedZoneCountInput`](crate::input::GetHostedZoneCountInput)
pub mod get_hosted_zone_count_input {
    /// A builder for [`GetHostedZoneCountInput`](crate::input::GetHostedZoneCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetHostedZoneCountInput`](crate::input::GetHostedZoneCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHostedZoneCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHostedZoneCountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetHostedZoneCountInputOperationOutputAlias = crate::operation::GetHostedZoneCount;
#[doc(hidden)]
pub type GetHostedZoneCountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHostedZoneCountInput {
    /// Consumes the builder and constructs an Operation<[`GetHostedZoneCount`](crate::operation::GetHostedZoneCount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHostedZoneCount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHostedZoneCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/hostedzonecount").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHostedZoneCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHostedZoneCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHostedZoneCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHostedZoneCount",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHostedZoneCountInput`](crate::input::GetHostedZoneCountInput)
    pub fn builder() -> crate::input::get_hosted_zone_count_input::Builder {
        crate::input::get_hosted_zone_count_input::Builder::default()
    }
}

/// See [`GetHostedZoneLimitInput`](crate::input::GetHostedZoneLimitInput)
pub mod get_hosted_zone_limit_input {
    /// A builder for [`GetHostedZoneLimitInput`](crate::input::GetHostedZoneLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::HostedZoneLimitType>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create
        /// in the specified hosted zone.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can
        /// associate with the specified private hosted zone.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::HostedZoneLimitType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The limit that you want to get. Valid values include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create
        /// in the specified hosted zone.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can
        /// associate with the specified private hosted zone.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::HostedZoneLimitType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the hosted zone that you want to get a limit for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to get a limit for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetHostedZoneLimitInput`](crate::input::GetHostedZoneLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetHostedZoneLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetHostedZoneLimitInput {
                r#type: self.r#type,
                hosted_zone_id: self.hosted_zone_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetHostedZoneLimitInputOperationOutputAlias = crate::operation::GetHostedZoneLimit;
#[doc(hidden)]
pub type GetHostedZoneLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetHostedZoneLimitInput {
    /// Consumes the builder and constructs an Operation<[`GetHostedZoneLimit`](crate::operation::GetHostedZoneLimit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetHostedZoneLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetHostedZoneLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.hosted_zone_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_34, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.r#type;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "r#type",
                        details: "cannot be empty or unset",
                    })?;
            let r#type = aws_smithy_http::label::fmt_string(input_35, false);
            if r#type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "r#type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzonelimit/{HostedZoneId}/{Type}",
                HostedZoneId = hosted_zone_id,
                Type = r#type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetHostedZoneLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetHostedZoneLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetHostedZoneLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetHostedZoneLimit",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetHostedZoneLimitInput`](crate::input::GetHostedZoneLimitInput)
    pub fn builder() -> crate::input::get_hosted_zone_limit_input::Builder {
        crate::input::get_hosted_zone_limit_input::Builder::default()
    }
}

/// See [`GetQueryLoggingConfigInput`](crate::input::GetQueryLoggingConfigInput)
pub mod get_query_logging_config_input {
    /// A builder for [`GetQueryLoggingConfigInput`](crate::input::GetQueryLoggingConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryLoggingConfigInput`](crate::input::GetQueryLoggingConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQueryLoggingConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQueryLoggingConfigInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetQueryLoggingConfigInputOperationOutputAlias = crate::operation::GetQueryLoggingConfig;
#[doc(hidden)]
pub type GetQueryLoggingConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetQueryLoggingConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetQueryLoggingConfig`](crate::operation::GetQueryLoggingConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQueryLoggingConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQueryLoggingConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_36, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/queryloggingconfig/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQueryLoggingConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQueryLoggingConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQueryLoggingConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQueryLoggingConfig",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQueryLoggingConfigInput`](crate::input::GetQueryLoggingConfigInput)
    pub fn builder() -> crate::input::get_query_logging_config_input::Builder {
        crate::input::get_query_logging_config_input::Builder::default()
    }
}

/// See [`GetReusableDelegationSetInput`](crate::input::GetReusableDelegationSetInput)
pub mod get_reusable_delegation_set_input {
    /// A builder for [`GetReusableDelegationSetInput`](crate::input::GetReusableDelegationSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReusableDelegationSetInput`](crate::input::GetReusableDelegationSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReusableDelegationSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReusableDelegationSetInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetReusableDelegationSetInputOperationOutputAlias =
    crate::operation::GetReusableDelegationSet;
#[doc(hidden)]
pub type GetReusableDelegationSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetReusableDelegationSetInput {
    /// Consumes the builder and constructs an Operation<[`GetReusableDelegationSet`](crate::operation::GetReusableDelegationSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReusableDelegationSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReusableDelegationSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_37, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/delegationset/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReusableDelegationSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReusableDelegationSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReusableDelegationSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReusableDelegationSet",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReusableDelegationSetInput`](crate::input::GetReusableDelegationSetInput)
    pub fn builder() -> crate::input::get_reusable_delegation_set_input::Builder {
        crate::input::get_reusable_delegation_set_input::Builder::default()
    }
}

/// See [`GetReusableDelegationSetLimitInput`](crate::input::GetReusableDelegationSetLimitInput)
pub mod get_reusable_delegation_set_limit_input {
    /// A builder for [`GetReusableDelegationSetLimitInput`](crate::input::GetReusableDelegationSetLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ReusableDelegationSetLimitType>,
        pub(crate) delegation_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate
        /// with the specified reusable delegation set.</p>
        pub fn r#type(mut self, input: crate::model::ReusableDelegationSetLimitType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate
        /// with the specified reusable delegation set.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ReusableDelegationSetLimitType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The ID of the delegation set that you want to get the limit for.</p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegation_set_id = Some(input.into());
            self
        }
        /// <p>The ID of the delegation set that you want to get the limit for.</p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegation_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReusableDelegationSetLimitInput`](crate::input::GetReusableDelegationSetLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReusableDelegationSetLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReusableDelegationSetLimitInput {
                r#type: self.r#type,
                delegation_set_id: self.delegation_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReusableDelegationSetLimitInputOperationOutputAlias =
    crate::operation::GetReusableDelegationSetLimit;
#[doc(hidden)]
pub type GetReusableDelegationSetLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetReusableDelegationSetLimitInput {
    /// Consumes the builder and constructs an Operation<[`GetReusableDelegationSetLimit`](crate::operation::GetReusableDelegationSetLimit)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReusableDelegationSetLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReusableDelegationSetLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.delegation_set_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "delegation_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let delegation_set_id = aws_smithy_http::label::fmt_string(input_38, false);
            if delegation_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "delegation_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_39 = &_input.r#type;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "r#type",
                        details: "cannot be empty or unset",
                    })?;
            let r#type = aws_smithy_http::label::fmt_string(input_39, false);
            if r#type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "r#type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/reusabledelegationsetlimit/{DelegationSetId}/{Type}",
                DelegationSetId = delegation_set_id,
                Type = r#type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReusableDelegationSetLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReusableDelegationSetLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReusableDelegationSetLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReusableDelegationSetLimit",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReusableDelegationSetLimitInput`](crate::input::GetReusableDelegationSetLimitInput)
    pub fn builder() -> crate::input::get_reusable_delegation_set_limit_input::Builder {
        crate::input::get_reusable_delegation_set_limit_input::Builder::default()
    }
}

/// See [`GetTrafficPolicyInput`](crate::input::GetTrafficPolicyInput)
pub mod get_traffic_policy_input {
    /// A builder for [`GetTrafficPolicyInput`](crate::input::GetTrafficPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the traffic policy that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The version number of the traffic policy that you want to get information about.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the traffic policy that you want to get information about.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrafficPolicyInput`](crate::input::GetTrafficPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTrafficPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTrafficPolicyInput {
                id: self.id,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTrafficPolicyInputOperationOutputAlias = crate::operation::GetTrafficPolicy;
#[doc(hidden)]
pub type GetTrafficPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTrafficPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetTrafficPolicy`](crate::operation::GetTrafficPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrafficPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTrafficPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.id;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_40, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            let input_41 = &_input.version;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let mut version_encoder = aws_smithy_types::primitive::Encoder::from(*input_41);
            let version = version_encoder.encode();
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/trafficpolicy/{Id}/{Version}",
                Id = id,
                Version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTrafficPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTrafficPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTrafficPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTrafficPolicy",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInput`](crate::input::GetTrafficPolicyInput)
    pub fn builder() -> crate::input::get_traffic_policy_input::Builder {
        crate::input::get_traffic_policy_input::Builder::default()
    }
}

/// See [`GetTrafficPolicyInstanceInput`](crate::input::GetTrafficPolicyInstanceInput)
pub mod get_traffic_policy_instance_input {
    /// A builder for [`GetTrafficPolicyInstanceInput`](crate::input::GetTrafficPolicyInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the traffic policy instance that you want to get information about.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to get information about.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTrafficPolicyInstanceInput`](crate::input::GetTrafficPolicyInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTrafficPolicyInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTrafficPolicyInstanceInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetTrafficPolicyInstanceInputOperationOutputAlias =
    crate::operation::GetTrafficPolicyInstance;
#[doc(hidden)]
pub type GetTrafficPolicyInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTrafficPolicyInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetTrafficPolicyInstance`](crate::operation::GetTrafficPolicyInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrafficPolicyInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTrafficPolicyInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_42, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/trafficpolicyinstance/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTrafficPolicyInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTrafficPolicyInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTrafficPolicyInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTrafficPolicyInstance",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInstanceInput`](crate::input::GetTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::get_traffic_policy_instance_input::Builder {
        crate::input::get_traffic_policy_instance_input::Builder::default()
    }
}

/// See [`GetTrafficPolicyInstanceCountInput`](crate::input::GetTrafficPolicyInstanceCountInput)
pub mod get_traffic_policy_instance_count_input {
    /// A builder for [`GetTrafficPolicyInstanceCountInput`](crate::input::GetTrafficPolicyInstanceCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetTrafficPolicyInstanceCountInput`](crate::input::GetTrafficPolicyInstanceCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTrafficPolicyInstanceCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTrafficPolicyInstanceCountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetTrafficPolicyInstanceCountInputOperationOutputAlias =
    crate::operation::GetTrafficPolicyInstanceCount;
#[doc(hidden)]
pub type GetTrafficPolicyInstanceCountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTrafficPolicyInstanceCountInput {
    /// Consumes the builder and constructs an Operation<[`GetTrafficPolicyInstanceCount`](crate::operation::GetTrafficPolicyInstanceCount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTrafficPolicyInstanceCount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTrafficPolicyInstanceCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/trafficpolicyinstancecount")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTrafficPolicyInstanceCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTrafficPolicyInstanceCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTrafficPolicyInstanceCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTrafficPolicyInstanceCount",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTrafficPolicyInstanceCountInput`](crate::input::GetTrafficPolicyInstanceCountInput)
    pub fn builder() -> crate::input::get_traffic_policy_instance_count_input::Builder {
        crate::input::get_traffic_policy_instance_count_input::Builder::default()
    }
}

/// See [`ListGeoLocationsInput`](crate::input::ListGeoLocationsInput)
pub mod list_geo_locations_input {
    /// A builder for [`ListGeoLocationsInput`](crate::input::ListGeoLocationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_continent_code: std::option::Option<std::string::String>,
        pub(crate) start_country_code: std::option::Option<std::string::String>,
        pub(crate) start_subdivision_code: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
        /// returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous
        /// response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
        /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code>
        /// when you're listing countries or countries with their subdivisions.</p>
        pub fn start_continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_continent_code = Some(input.into());
            self
        }
        /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
        /// returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous
        /// response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
        /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code>
        /// when you're listing countries or countries with their subdivisions.</p>
        pub fn set_start_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_continent_code = input;
            self
        }
        /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
        /// returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the
        /// previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
        pub fn start_country_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_country_code = Some(input.into());
            self
        }
        /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
        /// returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the
        /// previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
        pub fn set_start_country_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_country_code = input;
            self
        }
        /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports
        /// for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if
        /// <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code>
        /// to return the next page of results.</p>
        /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
        pub fn start_subdivision_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_subdivision_code = Some(input.into());
            self
        }
        /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports
        /// for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if
        /// <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code>
        /// to return the next page of results.</p>
        /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
        pub fn set_start_subdivision_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_subdivision_code = input;
            self
        }
        /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code>
        /// geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code>
        /// geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeoLocationsInput`](crate::input::ListGeoLocationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGeoLocationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGeoLocationsInput {
                start_continent_code: self.start_continent_code,
                start_country_code: self.start_country_code,
                start_subdivision_code: self.start_subdivision_code,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGeoLocationsInputOperationOutputAlias = crate::operation::ListGeoLocations;
#[doc(hidden)]
pub type ListGeoLocationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGeoLocationsInput {
    /// Consumes the builder and constructs an Operation<[`ListGeoLocations`](crate::operation::ListGeoLocations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGeoLocations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGeoLocationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/geolocations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListGeoLocationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_43) = &_input.start_continent_code {
                query.push_kv(
                    "startcontinentcode",
                    &aws_smithy_http::query::fmt_string(&inner_43),
                );
            }
            if let Some(inner_44) = &_input.start_country_code {
                query.push_kv(
                    "startcountrycode",
                    &aws_smithy_http::query::fmt_string(&inner_44),
                );
            }
            if let Some(inner_45) = &_input.start_subdivision_code {
                query.push_kv(
                    "startsubdivisioncode",
                    &aws_smithy_http::query::fmt_string(&inner_45),
                );
            }
            if let Some(inner_46) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_46).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGeoLocationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGeoLocationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGeoLocations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGeoLocations",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGeoLocationsInput`](crate::input::ListGeoLocationsInput)
    pub fn builder() -> crate::input::list_geo_locations_input::Builder {
        crate::input::list_geo_locations_input::Builder::default()
    }
}

/// See [`ListHealthChecksInput`](crate::input::ListHealthChecksInput)
pub mod list_health_checks_input {
    /// A builder for [`ListHealthChecksInput`](crate::input::ListHealthChecksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group,
        /// submit another <code>ListHealthChecks</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
        /// which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group,
        /// submit another <code>ListHealthChecks</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
        /// which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request.
        /// Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request.
        /// Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHealthChecksInput`](crate::input::ListHealthChecksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHealthChecksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHealthChecksInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHealthChecksInputOperationOutputAlias = crate::operation::ListHealthChecks;
#[doc(hidden)]
pub type ListHealthChecksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHealthChecksInput {
    /// Consumes the builder and constructs an Operation<[`ListHealthChecks`](crate::operation::ListHealthChecks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHealthChecks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHealthChecksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/healthcheck").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListHealthChecksInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_47) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_47));
            }
            if let Some(inner_48) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_48).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHealthChecksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHealthChecksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHealthChecks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHealthChecks",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHealthChecksInput`](crate::input::ListHealthChecksInput)
    pub fn builder() -> crate::input::list_health_checks_input::Builder {
        crate::input::list_health_checks_input::Builder::default()
    }
}

/// See [`ListHostedZonesInput`](crate::input::ListHostedZonesInput)
pub mod list_hosted_zones_input {
    /// A builder for [`ListHostedZonesInput`](crate::input::ListHostedZonesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) delegation_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones.
        /// To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
        /// which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones.
        /// To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
        /// which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code>
        /// hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code>
        /// is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code>
        /// hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code>
        /// is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
        /// with a reusable delegation set, specify the ID of that reusable delegation set. </p>
        pub fn delegation_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegation_set_id = Some(input.into());
            self
        }
        /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
        /// with a reusable delegation set, specify the ID of that reusable delegation set. </p>
        pub fn set_delegation_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegation_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedZonesInput`](crate::input::ListHostedZonesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHostedZonesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHostedZonesInput {
                marker: self.marker,
                max_items: self.max_items,
                delegation_set_id: self.delegation_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHostedZonesInputOperationOutputAlias = crate::operation::ListHostedZones;
#[doc(hidden)]
pub type ListHostedZonesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHostedZonesInput {
    /// Consumes the builder and constructs an Operation<[`ListHostedZones`](crate::operation::ListHostedZones)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHostedZones,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHostedZonesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/hostedzone").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListHostedZonesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_49) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_49));
            }
            if let Some(inner_50) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_50).encode(),
                );
            }
            if let Some(inner_51) = &_input.delegation_set_id {
                query.push_kv(
                    "delegationsetid",
                    &aws_smithy_http::query::fmt_string(&inner_51),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHostedZonesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHostedZonesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHostedZones::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHostedZones",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHostedZonesInput`](crate::input::ListHostedZonesInput)
    pub fn builder() -> crate::input::list_hosted_zones_input::Builder {
        crate::input::list_hosted_zones_input::Builder::default()
    }
}

/// See [`ListHostedZonesByNameInput`](crate::input::ListHostedZonesByNameInput)
pub mod list_hosted_zones_by_name_input {
    /// A builder for [`ListHostedZonesByNameInput`](crate::input::ListHostedZonesByNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to
        /// specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of
        /// the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and
        /// <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to
        /// specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of
        /// the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and
        /// <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
        /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first
        /// <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to
        /// <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of
        /// <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
        /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first
        /// <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to
        /// <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of
        /// <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code>
        /// hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and
        /// <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code>
        /// hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and
        /// <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedZonesByNameInput`](crate::input::ListHostedZonesByNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHostedZonesByNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHostedZonesByNameInput {
                dns_name: self.dns_name,
                hosted_zone_id: self.hosted_zone_id,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHostedZonesByNameInputOperationOutputAlias = crate::operation::ListHostedZonesByName;
#[doc(hidden)]
pub type ListHostedZonesByNameInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHostedZonesByNameInput {
    /// Consumes the builder and constructs an Operation<[`ListHostedZonesByName`](crate::operation::ListHostedZonesByName)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHostedZonesByName,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHostedZonesByNameInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/hostedzonesbyname").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListHostedZonesByNameInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_52) = &_input.dns_name {
                query.push_kv("dnsname", &aws_smithy_http::query::fmt_string(&inner_52));
            }
            if let Some(inner_53) = &_input.hosted_zone_id {
                query.push_kv(
                    "hostedzoneid",
                    &aws_smithy_http::query::fmt_string(&inner_53),
                );
            }
            if let Some(inner_54) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_54).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHostedZonesByNameInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHostedZonesByNameInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHostedZonesByName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHostedZonesByName",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHostedZonesByNameInput`](crate::input::ListHostedZonesByNameInput)
    pub fn builder() -> crate::input::list_hosted_zones_by_name_input::Builder {
        crate::input::list_hosted_zones_by_name_input::Builder::default()
    }
}

/// See [`ListHostedZonesByVpcInput`](crate::input::ListHostedZonesByVpcInput)
pub mod list_hosted_zones_by_vpc_input {
    /// A builder for [`ListHostedZonesByVpcInput`](crate::input::ListHostedZonesByVpcInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) vpc_region: std::option::Option<crate::model::VpcRegion>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
        pub fn vpc_region(mut self, input: crate::model::VpcRegion) -> Self {
            self.vpc_region = Some(input);
            self
        }
        /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
        pub fn set_vpc_region(
            mut self,
            input: std::option::Option<crate::model::VpcRegion>,
        ) -> Self {
            self.vpc_region = input;
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with
        /// more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains
        /// an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with
        /// more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains
        /// an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones.
        /// To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
        /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
        /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones.
        /// To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
        /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
        /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHostedZonesByVpcInput`](crate::input::ListHostedZonesByVpcInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHostedZonesByVpcInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHostedZonesByVpcInput {
                vpc_id: self.vpc_id,
                vpc_region: self.vpc_region,
                max_items: self.max_items,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListHostedZonesByVpcInputOperationOutputAlias = crate::operation::ListHostedZonesByVPC;
#[doc(hidden)]
pub type ListHostedZonesByVpcInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListHostedZonesByVpcInput {
    /// Consumes the builder and constructs an Operation<[`ListHostedZonesByVPC`](crate::operation::ListHostedZonesByVPC)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHostedZonesByVPC,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHostedZonesByVpcInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/hostedzonesbyvpc").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListHostedZonesByVpcInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_55) = &_input.vpc_id {
                query.push_kv("vpcid", &aws_smithy_http::query::fmt_string(&inner_55));
            }
            if let Some(inner_56) = &_input.vpc_region {
                query.push_kv("vpcregion", &aws_smithy_http::query::fmt_string(&inner_56));
            }
            if let Some(inner_57) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_57).encode(),
                );
            }
            if let Some(inner_58) = &_input.next_token {
                query.push_kv("nexttoken", &aws_smithy_http::query::fmt_string(&inner_58));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHostedZonesByVpcInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHostedZonesByVpcInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHostedZonesByVPC::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHostedZonesByVPC",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHostedZonesByVpcInput`](crate::input::ListHostedZonesByVpcInput)
    pub fn builder() -> crate::input::list_hosted_zones_by_vpc_input::Builder {
        crate::input::list_hosted_zones_by_vpc_input::Builder::default()
    }
}

/// See [`ListQueryLoggingConfigsInput`](crate::input::ListQueryLoggingConfigsInput)
pub mod list_query_logging_configs_input {
    /// A builder for [`ListQueryLoggingConfigsInput`](crate::input::ListQueryLoggingConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in
        /// <code>HostedZoneId</code>. </p>
        /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations
        /// that are associated with the current Amazon Web Services account.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in
        /// <code>HostedZoneId</code>. </p>
        /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations
        /// that are associated with the current Amazon Web Services account.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code>
        /// to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
        /// for <code>NextToken</code> in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code>
        /// to get the second and subsequent pages of results.</p>
        /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
        /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
        /// for <code>NextToken</code> in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request.
        /// If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a>
        /// in the response to get the next page of results.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request.
        /// If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a>
        /// in the response to get the next page of results.</p>
        /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueryLoggingConfigsInput`](crate::input::ListQueryLoggingConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQueryLoggingConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQueryLoggingConfigsInput {
                hosted_zone_id: self.hosted_zone_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQueryLoggingConfigsInputOperationOutputAlias =
    crate::operation::ListQueryLoggingConfigs;
#[doc(hidden)]
pub type ListQueryLoggingConfigsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListQueryLoggingConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListQueryLoggingConfigs`](crate::operation::ListQueryLoggingConfigs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQueryLoggingConfigs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQueryLoggingConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/queryloggingconfig").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListQueryLoggingConfigsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_59) = &_input.hosted_zone_id {
                query.push_kv(
                    "hostedzoneid",
                    &aws_smithy_http::query::fmt_string(&inner_59),
                );
            }
            if let Some(inner_60) = &_input.next_token {
                query.push_kv("nexttoken", &aws_smithy_http::query::fmt_string(&inner_60));
            }
            if let Some(inner_61) = &_input.max_results {
                query.push_kv(
                    "maxresults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_61).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQueryLoggingConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQueryLoggingConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQueryLoggingConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQueryLoggingConfigs",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQueryLoggingConfigsInput`](crate::input::ListQueryLoggingConfigsInput)
    pub fn builder() -> crate::input::list_query_logging_configs_input::Builder {
        crate::input::list_query_logging_configs_input::Builder::default()
    }
}

/// See [`ListResourceRecordSetsInput`](crate::input::ListResourceRecordSetsInput)
pub mod list_resource_record_sets_input {
    /// A builder for [`ListResourceRecordSetsInput`](crate::input::ListResourceRecordSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) start_record_name: std::option::Option<std::string::String>,
        pub(crate) start_record_type: std::option::Option<crate::model::RrType>,
        pub(crate) start_record_identifier: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The first name in the lexicographic ordering of resource record sets that you want to list.
        /// If the specified record name doesn't exist, the results begin with the first resource record set that has a name
        /// greater than the value of <code>name</code>.</p>
        pub fn start_record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_record_name = Some(input.into());
            self
        }
        /// <p>The first name in the lexicographic ordering of resource record sets that you want to list.
        /// If the specified record name doesn't exist, the results begin with the first resource record set that has a name
        /// greater than the value of <code>name</code>.</p>
        pub fn set_start_record_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_record_name = input;
            self
        }
        /// <p>The type of resource record set to begin the record listing from.</p>
        /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> |
        /// <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
        /// </p>
        /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> |
        /// <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
        /// </p>
        /// <p>Values for alias resource record sets: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>API Gateway custom regional API or edge-optimized API</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudFront distribution</b>: A or AAAA</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Elastic Load Balancing load balancer</b>: A | AAAA</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>S3 bucket</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>VPC interface VPC endpoint</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Another resource record set in this hosted zone:</b> The type of the resource record set
        /// that the alias references.</p>
        /// </li>
        /// </ul>
        /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
        pub fn start_record_type(mut self, input: crate::model::RrType) -> Self {
            self.start_record_type = Some(input);
            self
        }
        /// <p>The type of resource record set to begin the record listing from.</p>
        /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> |
        /// <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
        /// </p>
        /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> |
        /// <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
        /// </p>
        /// <p>Values for alias resource record sets: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>API Gateway custom regional API or edge-optimized API</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CloudFront distribution</b>: A or AAAA</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Elastic Load Balancing load balancer</b>: A | AAAA</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>S3 bucket</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>VPC interface VPC endpoint</b>: A</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Another resource record set in this hosted zone:</b> The type of the resource record set
        /// that the alias references.</p>
        /// </li>
        /// </ul>
        /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
        pub fn set_start_record_type(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.start_record_type = input;
            self
        }
        /// <p>
        /// <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type,
        /// specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current
        /// DNS name and type.</p>
        pub fn start_record_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_record_identifier = Some(input.into());
            self
        }
        /// <p>
        /// <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type,
        /// specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current
        /// DNS name and type.</p>
        pub fn set_start_record_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_record_identifier = input;
            self
        }
        /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes
        /// more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
        /// and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first
        /// resource record set in the next group of <code>maxitems</code> resource record sets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes
        /// more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
        /// and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first
        /// resource record set in the next group of <code>maxitems</code> resource record sets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceRecordSetsInput`](crate::input::ListResourceRecordSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceRecordSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceRecordSetsInput {
                hosted_zone_id: self.hosted_zone_id,
                start_record_name: self.start_record_name,
                start_record_type: self.start_record_type,
                start_record_identifier: self.start_record_identifier,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceRecordSetsInputOperationOutputAlias = crate::operation::ListResourceRecordSets;
#[doc(hidden)]
pub type ListResourceRecordSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResourceRecordSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceRecordSets`](crate::operation::ListResourceRecordSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceRecordSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResourceRecordSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_62 = &_input.hosted_zone_id;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_62, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/rrset",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListResourceRecordSetsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_63) = &_input.start_record_name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_63));
            }
            if let Some(inner_64) = &_input.start_record_type {
                query.push_kv("type", &aws_smithy_http::query::fmt_string(&inner_64));
            }
            if let Some(inner_65) = &_input.start_record_identifier {
                query.push_kv("identifier", &aws_smithy_http::query::fmt_string(&inner_65));
            }
            if let Some(inner_66) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_66).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResourceRecordSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResourceRecordSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceRecordSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceRecordSets",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResourceRecordSetsInput`](crate::input::ListResourceRecordSetsInput)
    pub fn builder() -> crate::input::list_resource_record_sets_input::Builder {
        crate::input::list_resource_record_sets_input::Builder::default()
    }
}

/// See [`ListReusableDelegationSetsInput`](crate::input::ListReusableDelegationSetsInput)
pub mod list_reusable_delegation_sets_input {
    /// A builder for [`ListReusableDelegationSetsInput`](crate::input::ListReusableDelegationSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets.
        /// To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
        /// which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets.
        /// To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
        /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
        /// which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value
        /// greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value
        /// greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReusableDelegationSetsInput`](crate::input::ListReusableDelegationSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReusableDelegationSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReusableDelegationSetsInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReusableDelegationSetsInputOperationOutputAlias =
    crate::operation::ListReusableDelegationSets;
#[doc(hidden)]
pub type ListReusableDelegationSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReusableDelegationSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListReusableDelegationSets`](crate::operation::ListReusableDelegationSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReusableDelegationSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReusableDelegationSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/delegationset").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListReusableDelegationSetsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_67) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_67));
            }
            if let Some(inner_68) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_68).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReusableDelegationSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReusableDelegationSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReusableDelegationSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReusableDelegationSets",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReusableDelegationSetsInput`](crate::input::ListReusableDelegationSetsInput)
    pub fn builder() -> crate::input::list_reusable_delegation_sets_input::Builder {
        crate::input::list_reusable_delegation_sets_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::TagResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li>
        /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
        /// </li>
        /// <li>
        /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource.</p>
        /// <ul>
        /// <li>
        /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
        /// </li>
        /// <li>
        /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The ID of the resource for which you want to retrieve tags.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource for which you want to retrieve tags.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_69 = &_input.resource_type;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_type",
                        details: "cannot be empty or unset",
                    })?;
            let resource_type = aws_smithy_http::label::fmt_string(input_69, false);
            if resource_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_type",
                    details: "cannot be empty or unset",
                });
            }
            let input_70 = &_input.resource_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_id",
                        details: "cannot be empty or unset",
                    })?;
            let resource_id = aws_smithy_http::label::fmt_string(input_70, false);
            if resource_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/tags/{ResourceType}/{ResourceId}",
                ResourceType = resource_type,
                ResourceId = resource_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
pub mod list_tags_for_resources_input {
    /// A builder for [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::TagResourceType>,
        pub(crate) resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of the resources.</p>
        /// <ul>
        /// <li>
        /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
        /// </li>
        /// <li>
        /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::TagResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resources.</p>
        /// <ul>
        /// <li>
        /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
        /// </li>
        /// <li>
        /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TagResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `resource_ids`.
        ///
        /// To override the contents of this collection use [`set_resource_ids`](Self::set_resource_ids).
        ///
        /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
        pub fn resource_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_ids.unwrap_or_default();
            v.push(input.into());
            self.resource_ids = Some(v);
            self
        }
        /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
        pub fn set_resource_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourcesInput {
                resource_type: self.resource_type,
                resource_ids: self.resource_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourcesInputOperationOutputAlias = crate::operation::ListTagsForResources;
#[doc(hidden)]
pub type ListTagsForResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResources`](crate::operation::ListTagsForResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.resource_type;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_type",
                        details: "cannot be empty or unset",
                    })?;
            let resource_type = aws_smithy_http::label::fmt_string(input_71, false);
            if resource_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/tags/{ResourceType}",
                ResourceType = resource_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resources(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResources",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourcesInput`](crate::input::ListTagsForResourcesInput)
    pub fn builder() -> crate::input::list_tags_for_resources_input::Builder {
        crate::input::list_tags_for_resources_input::Builder::default()
    }
}

/// See [`ListTrafficPoliciesInput`](crate::input::ListTrafficPoliciesInput)
pub mod list_traffic_policies_input {
    /// A builder for [`ListTrafficPoliciesInput`](crate::input::ListTrafficPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_id_marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
        /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first
        /// <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>.
        /// For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the
        /// previous response.</p>
        pub fn traffic_policy_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.traffic_policy_id_marker = Some(input.into());
            self
        }
        /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
        /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first
        /// <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>.
        /// For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the
        /// previous response.</p>
        pub fn set_traffic_policy_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_id_marker = input;
            self
        }
        /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than
        /// <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the
        /// value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit
        /// another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than
        /// <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the
        /// value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit
        /// another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPoliciesInput`](crate::input::ListTrafficPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrafficPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrafficPoliciesInput {
                traffic_policy_id_marker: self.traffic_policy_id_marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrafficPoliciesInputOperationOutputAlias = crate::operation::ListTrafficPolicies;
#[doc(hidden)]
pub type ListTrafficPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTrafficPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListTrafficPolicies`](crate::operation::ListTrafficPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrafficPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrafficPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/trafficpolicies").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListTrafficPoliciesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_72) = &_input.traffic_policy_id_marker {
                query.push_kv(
                    "trafficpolicyid",
                    &aws_smithy_http::query::fmt_string(&inner_72),
                );
            }
            if let Some(inner_73) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_73).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrafficPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrafficPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrafficPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrafficPolicies",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrafficPoliciesInput`](crate::input::ListTrafficPoliciesInput)
    pub fn builder() -> crate::input::list_traffic_policies_input::Builder {
        crate::input::list_traffic_policies_input::Builder::default()
    }
}

/// See [`ListTrafficPolicyInstancesInput`](crate::input::ListTrafficPolicyInstancesInput)
pub mod list_traffic_policy_instances_input {
    /// A builder for [`ListTrafficPolicyInstancesInput`](crate::input::ListTrafficPolicyInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>,
        /// specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id_marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>,
        /// specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id_marker = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
        /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
        /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
        /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.traffic_policy_instance_type_marker = Some(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
        /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.traffic_policy_instance_type_marker = input;
            self
        }
        /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request.
        /// If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is
        /// <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
        /// <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code>
        /// traffic policy instances.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request.
        /// If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is
        /// <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
        /// <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code>
        /// traffic policy instances.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyInstancesInput`](crate::input::ListTrafficPolicyInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrafficPolicyInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrafficPolicyInstancesInput {
                hosted_zone_id_marker: self.hosted_zone_id_marker,
                traffic_policy_instance_name_marker: self.traffic_policy_instance_name_marker,
                traffic_policy_instance_type_marker: self.traffic_policy_instance_type_marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrafficPolicyInstancesInputOperationOutputAlias =
    crate::operation::ListTrafficPolicyInstances;
#[doc(hidden)]
pub type ListTrafficPolicyInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTrafficPolicyInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListTrafficPolicyInstances`](crate::operation::ListTrafficPolicyInstances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrafficPolicyInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrafficPolicyInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/trafficpolicyinstances")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTrafficPolicyInstancesInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_74) = &_input.hosted_zone_id_marker {
                query.push_kv(
                    "hostedzoneid",
                    &aws_smithy_http::query::fmt_string(&inner_74),
                );
            }
            if let Some(inner_75) = &_input.traffic_policy_instance_name_marker {
                query.push_kv(
                    "trafficpolicyinstancename",
                    &aws_smithy_http::query::fmt_string(&inner_75),
                );
            }
            if let Some(inner_76) = &_input.traffic_policy_instance_type_marker {
                query.push_kv(
                    "trafficpolicyinstancetype",
                    &aws_smithy_http::query::fmt_string(&inner_76),
                );
            }
            if let Some(inner_77) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_77).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrafficPolicyInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrafficPolicyInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrafficPolicyInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrafficPolicyInstances",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesInput`](crate::input::ListTrafficPolicyInstancesInput)
    pub fn builder() -> crate::input::list_traffic_policy_instances_input::Builder {
        crate::input::list_traffic_policy_instances_input::Builder::default()
    }
}

/// See [`ListTrafficPolicyInstancesByHostedZoneInput`](crate::input::ListTrafficPolicyInstancesByHostedZoneInput)
pub mod list_traffic_policy_instances_by_hosted_zone_input {
    /// A builder for [`ListTrafficPolicyInstancesByHostedZoneInput`](crate::input::ListTrafficPolicyInstancesByHostedZoneInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
        /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
        /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
        /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.traffic_policy_instance_type_marker = Some(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
        /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
        /// in the next group of traffic policy instances.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.traffic_policy_instance_type_marker = input;
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
        /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
        /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
        /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
        /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
        /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
        /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyInstancesByHostedZoneInput`](crate::input::ListTrafficPolicyInstancesByHostedZoneInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrafficPolicyInstancesByHostedZoneInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrafficPolicyInstancesByHostedZoneInput {
                hosted_zone_id: self.hosted_zone_id,
                traffic_policy_instance_name_marker: self.traffic_policy_instance_name_marker,
                traffic_policy_instance_type_marker: self.traffic_policy_instance_type_marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrafficPolicyInstancesByHostedZoneInputOperationOutputAlias =
    crate::operation::ListTrafficPolicyInstancesByHostedZone;
#[doc(hidden)]
pub type ListTrafficPolicyInstancesByHostedZoneInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListTrafficPolicyInstancesByHostedZoneInput {
    /// Consumes the builder and constructs an Operation<[`ListTrafficPolicyInstancesByHostedZone`](crate::operation::ListTrafficPolicyInstancesByHostedZone)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrafficPolicyInstancesByHostedZone,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrafficPolicyInstancesByHostedZoneInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/trafficpolicyinstances/hostedzone")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTrafficPolicyInstancesByHostedZoneInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_78) = &_input.hosted_zone_id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_78));
            }
            if let Some(inner_79) = &_input.traffic_policy_instance_name_marker {
                query.push_kv(
                    "trafficpolicyinstancename",
                    &aws_smithy_http::query::fmt_string(&inner_79),
                );
            }
            if let Some(inner_80) = &_input.traffic_policy_instance_type_marker {
                query.push_kv(
                    "trafficpolicyinstancetype",
                    &aws_smithy_http::query::fmt_string(&inner_80),
                );
            }
            if let Some(inner_81) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_81).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrafficPolicyInstancesByHostedZoneInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrafficPolicyInstancesByHostedZoneInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrafficPolicyInstancesByHostedZone::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrafficPolicyInstancesByHostedZone",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesByHostedZoneInput`](crate::input::ListTrafficPolicyInstancesByHostedZoneInput)
    pub fn builder() -> crate::input::list_traffic_policy_instances_by_hosted_zone_input::Builder {
        crate::input::list_traffic_policy_instances_by_hosted_zone_input::Builder::default()
    }
}

/// See [`ListTrafficPolicyInstancesByPolicyInput`](crate::input::ListTrafficPolicyInstancesByPolicyInput)
pub mod list_traffic_policy_instances_by_policy_input {
    /// A builder for [`ListTrafficPolicyInstancesByPolicyInput`](crate::input::ListTrafficPolicyInstancesByPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_policy_id: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_version: std::option::Option<i32>,
        pub(crate) hosted_zone_id_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.traffic_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_id = input;
            self
        }
        /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the
        /// traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.traffic_policy_version = Some(input);
            self
        }
        /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the
        /// traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.traffic_policy_version = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
        /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response,
        /// which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn hosted_zone_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id_marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
        /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response,
        /// which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_hosted_zone_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id_marker = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code>
        /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_name_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = Some(input.into());
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code>
        /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_name_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_instance_name_marker = input;
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code>
        /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn traffic_policy_instance_type_marker(mut self, input: crate::model::RrType) -> Self {
            self.traffic_policy_instance_type_marker = Some(input);
            self
        }
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
        /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
        /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code>
        /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
        pub fn set_traffic_policy_instance_type_marker(
            mut self,
            input: std::option::Option<crate::model::RrType>,
        ) -> Self {
            self.traffic_policy_instance_type_marker = input;
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
        /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
        /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
        /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
        /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
        /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
        /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyInstancesByPolicyInput`](crate::input::ListTrafficPolicyInstancesByPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrafficPolicyInstancesByPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrafficPolicyInstancesByPolicyInput {
                traffic_policy_id: self.traffic_policy_id,
                traffic_policy_version: self.traffic_policy_version,
                hosted_zone_id_marker: self.hosted_zone_id_marker,
                traffic_policy_instance_name_marker: self.traffic_policy_instance_name_marker,
                traffic_policy_instance_type_marker: self.traffic_policy_instance_type_marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrafficPolicyInstancesByPolicyInputOperationOutputAlias =
    crate::operation::ListTrafficPolicyInstancesByPolicy;
#[doc(hidden)]
pub type ListTrafficPolicyInstancesByPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTrafficPolicyInstancesByPolicyInput {
    /// Consumes the builder and constructs an Operation<[`ListTrafficPolicyInstancesByPolicy`](crate::operation::ListTrafficPolicyInstancesByPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrafficPolicyInstancesByPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrafficPolicyInstancesByPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/trafficpolicyinstances/trafficpolicy")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTrafficPolicyInstancesByPolicyInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_82) = &_input.traffic_policy_id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_82));
            }
            if let Some(inner_83) = &_input.traffic_policy_version {
                query.push_kv(
                    "version",
                    &aws_smithy_types::primitive::Encoder::from(*inner_83).encode(),
                );
            }
            if let Some(inner_84) = &_input.hosted_zone_id_marker {
                query.push_kv(
                    "hostedzoneid",
                    &aws_smithy_http::query::fmt_string(&inner_84),
                );
            }
            if let Some(inner_85) = &_input.traffic_policy_instance_name_marker {
                query.push_kv(
                    "trafficpolicyinstancename",
                    &aws_smithy_http::query::fmt_string(&inner_85),
                );
            }
            if let Some(inner_86) = &_input.traffic_policy_instance_type_marker {
                query.push_kv(
                    "trafficpolicyinstancetype",
                    &aws_smithy_http::query::fmt_string(&inner_86),
                );
            }
            if let Some(inner_87) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_87).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrafficPolicyInstancesByPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrafficPolicyInstancesByPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrafficPolicyInstancesByPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrafficPolicyInstancesByPolicy",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyInstancesByPolicyInput`](crate::input::ListTrafficPolicyInstancesByPolicyInput)
    pub fn builder() -> crate::input::list_traffic_policy_instances_by_policy_input::Builder {
        crate::input::list_traffic_policy_instances_by_policy_input::Builder::default()
    }
}

/// See [`ListTrafficPolicyVersionsInput`](crate::input::ListTrafficPolicyVersionsInput)
pub mod list_traffic_policy_versions_input {
    /// A builder for [`ListTrafficPolicyVersionsInput`](crate::input::ListTrafficPolicyVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_version_marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
        /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only
        /// the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code>
        /// request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous
        /// response.</p>
        pub fn traffic_policy_version_marker(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.traffic_policy_version_marker = Some(input.into());
            self
        }
        /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
        /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only
        /// the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code>
        /// request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous
        /// response.</p>
        pub fn set_traffic_policy_version_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_version_marker = input;
            self
        }
        /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified
        /// traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>,
        /// and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit
        /// another request.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified
        /// traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>,
        /// and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit
        /// another request.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrafficPolicyVersionsInput`](crate::input::ListTrafficPolicyVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrafficPolicyVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrafficPolicyVersionsInput {
                id: self.id,
                traffic_policy_version_marker: self.traffic_policy_version_marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrafficPolicyVersionsInputOperationOutputAlias =
    crate::operation::ListTrafficPolicyVersions;
#[doc(hidden)]
pub type ListTrafficPolicyVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTrafficPolicyVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListTrafficPolicyVersions`](crate::operation::ListTrafficPolicyVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrafficPolicyVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTrafficPolicyVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.id;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_88, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/trafficpolicies/{Id}/versions", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTrafficPolicyVersionsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_89) = &_input.traffic_policy_version_marker {
                query.push_kv(
                    "trafficpolicyversion",
                    &aws_smithy_http::query::fmt_string(&inner_89),
                );
            }
            if let Some(inner_90) = &_input.max_items {
                query.push_kv(
                    "maxitems",
                    &aws_smithy_types::primitive::Encoder::from(*inner_90).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTrafficPolicyVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTrafficPolicyVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrafficPolicyVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrafficPolicyVersions",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTrafficPolicyVersionsInput`](crate::input::ListTrafficPolicyVersionsInput)
    pub fn builder() -> crate::input::list_traffic_policy_versions_input::Builder {
        crate::input::list_traffic_policy_versions_input::Builder::default()
    }
}

/// See [`ListVpcAssociationAuthorizationsInput`](crate::input::ListVpcAssociationAuthorizationsInput)
pub mod list_vpc_association_authorizations_input {
    /// A builder for [`ListVpcAssociationAuthorizationsInput`](crate::input::ListVpcAssociationAuthorizationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>
        /// <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs
        /// that can be associated with the specified hosted zone. To get the next page of results, submit another request,
        /// and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter
        /// in another <code>ListVPCAssociationAuthorizations</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs
        /// that can be associated with the specified hosted zone. To get the next page of results, submit another request,
        /// and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter
        /// in another <code>ListVPCAssociationAuthorizations</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>
        /// <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return.
        /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return.
        /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVpcAssociationAuthorizationsInput`](crate::input::ListVpcAssociationAuthorizationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVpcAssociationAuthorizationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVpcAssociationAuthorizationsInput {
                hosted_zone_id: self.hosted_zone_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVpcAssociationAuthorizationsInputOperationOutputAlias =
    crate::operation::ListVPCAssociationAuthorizations;
#[doc(hidden)]
pub type ListVpcAssociationAuthorizationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVpcAssociationAuthorizationsInput {
    /// Consumes the builder and constructs an Operation<[`ListVPCAssociationAuthorizations`](crate::operation::ListVPCAssociationAuthorizations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVPCAssociationAuthorizations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVpcAssociationAuthorizationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_91 = &_input.hosted_zone_id;
            let input_91 =
                input_91
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hosted_zone_id",
                        details: "cannot be empty or unset",
                    })?;
            let hosted_zone_id = aws_smithy_http::label::fmt_string(input_91, false);
            if hosted_zone_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hosted_zone_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/hostedzone/{HostedZoneId}/authorizevpcassociation",
                HostedZoneId = hosted_zone_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListVpcAssociationAuthorizationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_92) = &_input.next_token {
                query.push_kv("nexttoken", &aws_smithy_http::query::fmt_string(&inner_92));
            }
            if let Some(inner_93) = &_input.max_results {
                query.push_kv(
                    "maxresults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_93).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVpcAssociationAuthorizationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVpcAssociationAuthorizationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVPCAssociationAuthorizations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVPCAssociationAuthorizations",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVpcAssociationAuthorizationsInput`](crate::input::ListVpcAssociationAuthorizationsInput)
    pub fn builder() -> crate::input::list_vpc_association_authorizations_input::Builder {
        crate::input::list_vpc_association_authorizations_input::Builder::default()
    }
}

/// See [`TestDnsAnswerInput`](crate::input::TestDnsAnswerInput)
pub mod test_dns_answer_input {
    /// A builder for [`TestDnsAnswerInput`](crate::input::TestDnsAnswerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) record_name: std::option::Option<std::string::String>,
        pub(crate) record_type: std::option::Option<crate::model::RrType>,
        pub(crate) resolver_ip: std::option::Option<std::string::String>,
        pub(crate) edns0_client_subnet_ip: std::option::Option<std::string::String>,
        pub(crate) edns0_client_subnet_mask: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
        pub fn record_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_name = Some(input.into());
            self
        }
        /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
        pub fn set_record_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.record_name = input;
            self
        }
        /// <p>The type of the resource record set.</p>
        pub fn record_type(mut self, input: crate::model::RrType) -> Self {
            self.record_type = Some(input);
            self
        }
        /// <p>The type of the resource record set.</p>
        pub fn set_record_type(mut self, input: std::option::Option<crate::model::RrType>) -> Self {
            self.record_type = input;
            self
        }
        /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver.
        /// If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region
        /// (<code>us-east-1</code>).</p>
        pub fn resolver_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_ip = Some(input.into());
            self
        }
        /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver.
        /// If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region
        /// (<code>us-east-1</code>).</p>
        pub fn set_resolver_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolver_ip = input;
            self
        }
        /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client
        /// in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
        pub fn edns0_client_subnet_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.edns0_client_subnet_ip = Some(input.into());
            self
        }
        /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client
        /// in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
        pub fn set_edns0_client_subnet_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edns0_client_subnet_ip = input;
            self
        }
        /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address
        /// that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for
        /// <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from
        /// 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
        /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>IPv4</b>: Specify a value between 0 and 32</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IPv6</b>: Specify a value between 0 and 128</p>
        /// </li>
        /// </ul>
        pub fn edns0_client_subnet_mask(mut self, input: impl Into<std::string::String>) -> Self {
            self.edns0_client_subnet_mask = Some(input.into());
            self
        }
        /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address
        /// that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for
        /// <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from
        /// 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
        /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>IPv4</b>: Specify a value between 0 and 32</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IPv6</b>: Specify a value between 0 and 128</p>
        /// </li>
        /// </ul>
        pub fn set_edns0_client_subnet_mask(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edns0_client_subnet_mask = input;
            self
        }
        /// Consumes the builder and constructs a [`TestDnsAnswerInput`](crate::input::TestDnsAnswerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestDnsAnswerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestDnsAnswerInput {
                hosted_zone_id: self.hosted_zone_id,
                record_name: self.record_name,
                record_type: self.record_type,
                resolver_ip: self.resolver_ip,
                edns0_client_subnet_ip: self.edns0_client_subnet_ip,
                edns0_client_subnet_mask: self.edns0_client_subnet_mask,
            })
        }
    }
}
#[doc(hidden)]
pub type TestDnsAnswerInputOperationOutputAlias = crate::operation::TestDNSAnswer;
#[doc(hidden)]
pub type TestDnsAnswerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestDnsAnswerInput {
    /// Consumes the builder and constructs an Operation<[`TestDNSAnswer`](crate::operation::TestDNSAnswer)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestDNSAnswer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestDnsAnswerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/2013-04-01/testdnsanswer").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::TestDnsAnswerInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_94) = &_input.hosted_zone_id {
                query.push_kv(
                    "hostedzoneid",
                    &aws_smithy_http::query::fmt_string(&inner_94),
                );
            }
            if let Some(inner_95) = &_input.record_name {
                query.push_kv("recordname", &aws_smithy_http::query::fmt_string(&inner_95));
            }
            if let Some(inner_96) = &_input.record_type {
                query.push_kv("recordtype", &aws_smithy_http::query::fmt_string(&inner_96));
            }
            if let Some(inner_97) = &_input.resolver_ip {
                query.push_kv("resolverip", &aws_smithy_http::query::fmt_string(&inner_97));
            }
            if let Some(inner_98) = &_input.edns0_client_subnet_ip {
                query.push_kv(
                    "edns0clientsubnetip",
                    &aws_smithy_http::query::fmt_string(&inner_98),
                );
            }
            if let Some(inner_99) = &_input.edns0_client_subnet_mask {
                query.push_kv(
                    "edns0clientsubnetmask",
                    &aws_smithy_http::query::fmt_string(&inner_99),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestDnsAnswerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestDnsAnswerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestDNSAnswer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestDNSAnswer",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestDnsAnswerInput`](crate::input::TestDnsAnswerInput)
    pub fn builder() -> crate::input::test_dns_answer_input::Builder {
        crate::input::test_dns_answer_input::Builder::default()
    }
}

/// See [`UpdateHealthCheckInput`](crate::input::UpdateHealthCheckInput)
pub mod update_health_check_input {
    /// A builder for [`UpdateHealthCheckInput`](crate::input::UpdateHealthCheckInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) health_check_id: std::option::Option<std::string::String>,
        pub(crate) health_check_version: std::option::Option<i64>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) resource_path: std::option::Option<std::string::String>,
        pub(crate) fully_qualified_domain_name: std::option::Option<std::string::String>,
        pub(crate) search_string: std::option::Option<std::string::String>,
        pub(crate) failure_threshold: std::option::Option<i32>,
        pub(crate) inverted: std::option::Option<bool>,
        pub(crate) disabled: std::option::Option<bool>,
        pub(crate) health_threshold: std::option::Option<i32>,
        pub(crate) child_health_checks: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enable_sni: std::option::Option<bool>,
        pub(crate) regions: std::option::Option<std::vec::Vec<crate::model::HealthCheckRegion>>,
        pub(crate) alarm_identifier: std::option::Option<crate::model::AlarmIdentifier>,
        pub(crate) insufficient_data_health_status:
            std::option::Option<crate::model::InsufficientDataHealthStatus>,
        pub(crate) reset_elements:
            std::option::Option<std::vec::Vec<crate::model::ResettableElementName>>,
    }
    impl Builder {
        /// <p>The ID for the health check for which you want detailed information. When you created the health check,
        /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        pub fn health_check_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_id = Some(input.into());
            self
        }
        /// <p>The ID for the health check for which you want detailed information. When you created the health check,
        /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
        pub fn set_health_check_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_id = input;
            self
        }
        /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you
        /// update settings for the health check.</p>
        /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of
        /// <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your
        /// <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
        /// <ul>
        /// <li>
        /// <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the
        /// health check, Route 53 updates the health check with the new settings.</p>
        /// </li>
        /// <li>
        /// <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you
        /// got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p>
        /// </li>
        /// </ul>
        pub fn health_check_version(mut self, input: i64) -> Self {
            self.health_check_version = Some(input);
            self
        }
        /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you
        /// update settings for the health check.</p>
        /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of
        /// <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your
        /// <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
        /// <ul>
        /// <li>
        /// <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the
        /// health check, Route 53 updates the health check with the new settings.</p>
        /// </li>
        /// <li>
        /// <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you
        /// got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p>
        /// </li>
        /// </ul>
        pub fn set_health_check_version(mut self, input: std::option::Option<i64>) -> Self {
            self.health_check_version = input;
            self
        }
        /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for
        /// <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code>
        /// at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then
        /// checks the health of the endpoint.</p>
        /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.),
        /// for example, <code>192.0.2.44</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:),
        /// for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952,
        /// for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and
        /// specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information,
        /// see the applicable documentation:</p>
        /// <ul>
        /// <li>
        /// <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
        /// <i>Amazon EC2 User Guide for Windows Instances</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
        /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
        /// </p>
        /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or
        /// multicast ranges. For more information about IP addresses for which you can't create health checks, see the following
        /// documents:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for
        /// <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code>
        /// at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then
        /// checks the health of the endpoint.</p>
        /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.),
        /// for example, <code>192.0.2.44</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:),
        /// for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952,
        /// for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p>
        /// </li>
        /// </ul>
        /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and
        /// specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information,
        /// see the applicable documentation:</p>
        /// <ul>
        /// <li>
        /// <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
        /// <i>Amazon EC2 User Guide for Windows Instances</i>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
        /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        /// <p>For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
        /// </p>
        /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or
        /// multicast ranges. For more information about IP addresses for which you can't create health checks, see the following
        /// documents:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p>
        /// <note>
        /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or
        /// <code>CALCULATED</code>.</p>
        /// </note>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p>
        /// <note>
        /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or
        /// <code>CALCULATED</code>.</p>
        /// </note>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint
        /// will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html.
        /// You can also include query string parameters, for example, <code>/welcome.html?language=jp&login=y</code>. </p>
        /// <p>Specify this value only if you want to change it.</p>
        pub fn resource_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_path = Some(input.into());
            self
        }
        /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint
        /// will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html.
        /// You can also include query string parameters, for example, <code>/welcome.html?language=jp&login=y</code>. </p>
        /// <p>Specify this value only if you want to change it.</p>
        pub fn set_resource_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_path = input;
            self
        }
        /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p>
        ///
        /// <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
        /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        ///
        /// <p>
        /// <b>If you specify a value for</b>
        /// <code>IPAddress</code>:</p>
        /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code>
        /// in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint
        /// on which you want Route 53 to perform health checks.</p>
        /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for
        /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for
        /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
        /// </li>
        /// <li>
        /// <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes
        /// <i>
        /// <code>FullyQualifiedDomainName</code>:<code>Port</code>
        /// </i> to the endpoint in the <code>Host</code> header.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code>
        /// in the <code>Host</code> header in each of the above cases.</p>
        ///
        /// <p>
        /// <b>If you don't specify a value for</b>
        /// <code>IPAddress</code>:</p>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in
        /// <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is
        /// returned by DNS, Route 53 then checks the health of the endpoint.</p>
        /// <note>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint.
        /// If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>,
        /// the health check fails with a "DNS resolution failed" error.</p>
        /// </note>
        /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by
        /// <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a
        /// health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>,
        /// specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p>
        /// <important>
        /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and
        /// you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
        /// </important>
        /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or
        /// <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does
        /// when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a
        /// <code>Host</code> header.</p>
        pub fn fully_qualified_domain_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.fully_qualified_domain_name = Some(input.into());
            self
        }
        /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p>
        ///
        /// <note>
        /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
        /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
        /// </note>
        ///
        /// <p>
        /// <b>If you specify a value for</b>
        /// <code>IPAddress</code>:</p>
        /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code>
        /// in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint
        /// on which you want Route 53 to perform health checks.</p>
        /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for
        /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
        /// </li>
        /// <li>
        /// <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for
        /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
        /// </li>
        /// <li>
        /// <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes
        /// <i>
        /// <code>FullyQualifiedDomainName</code>:<code>Port</code>
        /// </i> to the endpoint in the <code>Host</code> header.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code>
        /// in the <code>Host</code> header in each of the above cases.</p>
        ///
        /// <p>
        /// <b>If you don't specify a value for</b>
        /// <code>IPAddress</code>:</p>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in
        /// <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is
        /// returned by DNS, Route 53 then checks the health of the endpoint.</p>
        /// <note>
        /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint.
        /// If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>,
        /// the health check fails with a "DNS resolution failed" error.</p>
        /// </note>
        /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by
        /// <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a
        /// health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>,
        /// specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p>
        /// <important>
        /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and
        /// you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
        /// </important>
        /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or
        /// <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does
        /// when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a
        /// <code>Host</code> header.</p>
        pub fn set_fully_qualified_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fully_qualified_domain_name = input;
            self
        }
        /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want
        /// Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers
        /// the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.search_string = Some(input.into());
            self
        }
        /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want
        /// Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers
        /// the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.search_string = input;
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint
        /// from unhealthy to healthy or vice versa. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
        /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
        pub fn failure_threshold(mut self, input: i32) -> Self {
            self.failure_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint
        /// from unhealthy to healthy or vice versa. For more information, see
        /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
        /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
        /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
        pub fn set_failure_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_threshold = input;
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it
        /// otherwise would be considered healthy.</p>
        pub fn inverted(mut self, input: bool) -> Self {
            self.inverted = Some(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it
        /// otherwise would be considered healthy.</p>
        pub fn set_inverted(mut self, input: std::option::Option<bool>) -> Self {
            self.inverted = input;
            self
        }
        /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Health checks that check the health of endpoints:</b>
        /// Route 53 stops submitting requests to your application, server, or other resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Calculated health checks:</b>
        /// Route 53 stops aggregating the status of the referenced health checks.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Health checks that monitor CloudWatch alarms:</b>
        /// Route 53 stops monitoring the corresponding CloudWatch metrics.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover,
        /// Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>.
        /// </p>
        ///
        /// <p>Charges for a health check still apply when the health check is disabled. For more information, see
        /// <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn disabled(mut self, input: bool) -> Self {
            self.disabled = Some(input);
            self
        }
        /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Health checks that check the health of endpoints:</b>
        /// Route 53 stops submitting requests to your application, server, or other resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Calculated health checks:</b>
        /// Route 53 stops aggregating the status of the referenced health checks.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Health checks that monitor CloudWatch alarms:</b>
        /// Route 53 stops monitoring the corresponding CloudWatch metrics.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover,
        /// Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>.
        /// </p>
        ///
        /// <p>Charges for a health check still apply when the health check is disabled. For more information, see
        /// <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
        pub fn set_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.disabled = input;
            self
        }
        /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the
        /// <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a
        /// <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p>
        /// </li>
        /// <li>
        /// <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p>
        /// </li>
        /// </ul>
        pub fn health_threshold(mut self, input: i32) -> Self {
            self.health_threshold = Some(input);
            self
        }
        /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the
        /// <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a
        /// <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
        /// <p>Note the following:</p>
        /// <ul>
        /// <li>
        /// <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p>
        /// </li>
        /// <li>
        /// <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p>
        /// </li>
        /// </ul>
        pub fn set_health_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.health_threshold = input;
            self
        }
        /// Appends an item to `child_health_checks`.
        ///
        /// To override the contents of this collection use [`set_child_health_checks`](Self::set_child_health_checks).
        ///
        /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a
        /// <code>CALCULATED</code> health check.</p>
        pub fn child_health_checks(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.child_health_checks.unwrap_or_default();
            v.push(input.into());
            self.child_health_checks = Some(v);
            self
        }
        /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a
        /// <code>CALCULATED</code> health check.</p>
        pub fn set_child_health_checks(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.child_health_checks = input;
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code>
        /// message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable
        /// SSL/TLS certificate.</p>
        /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI,
        /// the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons.
        /// If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
        /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more
        /// in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for
        /// <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not
        /// include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the
        /// second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
        pub fn enable_sni(mut self, input: bool) -> Self {
            self.enable_sni = Some(input);
            self
        }
        /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code>
        /// message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable
        /// SSL/TLS certificate.</p>
        /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI,
        /// the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons.
        /// If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
        /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more
        /// in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for
        /// <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not
        /// include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the
        /// second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
        pub fn set_enable_sni(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_sni = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check
        /// the specified endpoint from.</p>
        pub fn regions(mut self, input: impl Into<crate::model::HealthCheckRegion>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check
        /// the specified endpoint from.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HealthCheckRegion>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether
        /// the specified health check is healthy.</p>
        pub fn alarm_identifier(mut self, input: crate::model::AlarmIdentifier) -> Self {
            self.alarm_identifier = Some(input);
            self
        }
        /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether
        /// the specified health check is healthy.</p>
        pub fn set_alarm_identifier(
            mut self,
            input: std::option::Option<crate::model::AlarmIdentifier>,
        ) -> Self {
            self.alarm_identifier = input;
            self
        }
        /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign
        /// to the health check:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Healthy</code>: Route 53 considers the health check to be healthy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time CloudWatch had sufficient data
        /// to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</p>
        /// </li>
        /// </ul>
        pub fn insufficient_data_health_status(
            mut self,
            input: crate::model::InsufficientDataHealthStatus,
        ) -> Self {
            self.insufficient_data_health_status = Some(input);
            self
        }
        /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign
        /// to the health check:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Healthy</code>: Route 53 considers the health check to be healthy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time CloudWatch had sufficient data
        /// to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</p>
        /// </li>
        /// </ul>
        pub fn set_insufficient_data_health_status(
            mut self,
            input: std::option::Option<crate::model::InsufficientDataHealthStatus>,
        ) -> Self {
            self.insufficient_data_health_status = input;
            self
        }
        /// Appends an item to `reset_elements`.
        ///
        /// To override the contents of this collection use [`set_reset_elements`](Self::set_reset_elements).
        ///
        /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value.
        /// Valid values for <code>ResettableElementName</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ChildHealthChecks</code>: Amazon Route 53 resets
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a>
        /// to null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FullyQualifiedDomainName</code>: Route 53 resets
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
        /// to null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Regions</code>: Route 53 resets the
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a>
        /// list to the default set of regions. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourcePath</code>: Route 53 resets
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a>
        /// to null.</p>
        /// </li>
        /// </ul>
        pub fn reset_elements(
            mut self,
            input: impl Into<crate::model::ResettableElementName>,
        ) -> Self {
            let mut v = self.reset_elements.unwrap_or_default();
            v.push(input.into());
            self.reset_elements = Some(v);
            self
        }
        /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value.
        /// Valid values for <code>ResettableElementName</code> include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ChildHealthChecks</code>: Amazon Route 53 resets
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a>
        /// to null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FullyQualifiedDomainName</code>: Route 53 resets
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
        /// to null.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Regions</code>: Route 53 resets the
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a>
        /// list to the default set of regions. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ResourcePath</code>: Route 53 resets
        /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a>
        /// to null.</p>
        /// </li>
        /// </ul>
        pub fn set_reset_elements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResettableElementName>>,
        ) -> Self {
            self.reset_elements = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHealthCheckInput`](crate::input::UpdateHealthCheckInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateHealthCheckInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateHealthCheckInput {
                health_check_id: self.health_check_id,
                health_check_version: self.health_check_version,
                ip_address: self.ip_address,
                port: self.port,
                resource_path: self.resource_path,
                fully_qualified_domain_name: self.fully_qualified_domain_name,
                search_string: self.search_string,
                failure_threshold: self.failure_threshold,
                inverted: self.inverted,
                disabled: self.disabled,
                health_threshold: self.health_threshold,
                child_health_checks: self.child_health_checks,
                enable_sni: self.enable_sni,
                regions: self.regions,
                alarm_identifier: self.alarm_identifier,
                insufficient_data_health_status: self.insufficient_data_health_status,
                reset_elements: self.reset_elements,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateHealthCheckInputOperationOutputAlias = crate::operation::UpdateHealthCheck;
#[doc(hidden)]
pub type UpdateHealthCheckInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateHealthCheckInput {
    /// Consumes the builder and constructs an Operation<[`UpdateHealthCheck`](crate::operation::UpdateHealthCheck)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateHealthCheck,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateHealthCheckInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_100 = &_input.health_check_id;
            let input_100 =
                input_100
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "health_check_id",
                        details: "cannot be empty or unset",
                    })?;
            let health_check_id = aws_smithy_http::label::fmt_string(input_100, false);
            if health_check_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "health_check_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/healthcheck/{HealthCheckId}",
                HealthCheckId = health_check_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateHealthCheckInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateHealthCheckInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_health_check(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateHealthCheck::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateHealthCheck",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateHealthCheckInput`](crate::input::UpdateHealthCheckInput)
    pub fn builder() -> crate::input::update_health_check_input::Builder {
        crate::input::update_health_check_input::Builder::default()
    }
}

/// See [`UpdateHostedZoneCommentInput`](crate::input::UpdateHostedZoneCommentInput)
pub mod update_hosted_zone_comment_input {
    /// A builder for [`UpdateHostedZoneCommentInput`](crate::input::UpdateHostedZoneCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the hosted zone that you want to update the comment for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for the hosted zone that you want to update the comment for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the
        /// <code>Comment</code> element, if any.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the
        /// <code>Comment</code> element, if any.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateHostedZoneCommentInput`](crate::input::UpdateHostedZoneCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateHostedZoneCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateHostedZoneCommentInput {
                id: self.id,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateHostedZoneCommentInputOperationOutputAlias =
    crate::operation::UpdateHostedZoneComment;
#[doc(hidden)]
pub type UpdateHostedZoneCommentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateHostedZoneCommentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateHostedZoneComment`](crate::operation::UpdateHostedZoneComment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateHostedZoneComment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateHostedZoneCommentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_101 = &_input.id;
            let input_101 =
                input_101
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_101, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/hostedzone/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateHostedZoneCommentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateHostedZoneCommentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_hosted_zone_comment(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateHostedZoneComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateHostedZoneComment",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateHostedZoneCommentInput`](crate::input::UpdateHostedZoneCommentInput)
    pub fn builder() -> crate::input::update_hosted_zone_comment_input::Builder {
        crate::input::update_hosted_zone_comment_input::Builder::default()
    }
}

/// See [`UpdateTrafficPolicyCommentInput`](crate::input::UpdateTrafficPolicyCommentInput)
pub mod update_traffic_policy_comment_input {
    /// A builder for [`UpdateTrafficPolicyCommentInput`](crate::input::UpdateTrafficPolicyCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// <p>The new comment for the specified traffic policy and version.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>The new comment for the specified traffic policy and version.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrafficPolicyCommentInput`](crate::input::UpdateTrafficPolicyCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTrafficPolicyCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTrafficPolicyCommentInput {
                id: self.id,
                version: self.version,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTrafficPolicyCommentInputOperationOutputAlias =
    crate::operation::UpdateTrafficPolicyComment;
#[doc(hidden)]
pub type UpdateTrafficPolicyCommentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTrafficPolicyCommentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTrafficPolicyComment`](crate::operation::UpdateTrafficPolicyComment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTrafficPolicyComment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTrafficPolicyCommentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_102 = &_input.id;
            let input_102 =
                input_102
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_102, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            let input_103 = &_input.version;
            let input_103 =
                input_103
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let mut version_encoder = aws_smithy_types::primitive::Encoder::from(*input_103);
            let version = version_encoder.encode();
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/2013-04-01/trafficpolicy/{Id}/{Version}",
                Id = id,
                Version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTrafficPolicyCommentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTrafficPolicyCommentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_traffic_policy_comment(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTrafficPolicyComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTrafficPolicyComment",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTrafficPolicyCommentInput`](crate::input::UpdateTrafficPolicyCommentInput)
    pub fn builder() -> crate::input::update_traffic_policy_comment_input::Builder {
        crate::input::update_traffic_policy_comment_input::Builder::default()
    }
}

/// See [`UpdateTrafficPolicyInstanceInput`](crate::input::UpdateTrafficPolicyInstanceInput)
pub mod update_traffic_policy_instance_input {
    /// A builder for [`UpdateTrafficPolicyInstanceInput`](crate::input::UpdateTrafficPolicyInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<i64>,
        pub(crate) traffic_policy_id: std::option::Option<std::string::String>,
        pub(crate) traffic_policy_version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the traffic policy instance that you want to update.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy instance that you want to update.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn traffic_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.traffic_policy_id = Some(input.into());
            self
        }
        /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn set_traffic_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.traffic_policy_id = input;
            self
        }
        /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn traffic_policy_version(mut self, input: i32) -> Self {
            self.traffic_policy_version = Some(input);
            self
        }
        /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
        pub fn set_traffic_policy_version(mut self, input: std::option::Option<i32>) -> Self {
            self.traffic_policy_version = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrafficPolicyInstanceInput`](crate::input::UpdateTrafficPolicyInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTrafficPolicyInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTrafficPolicyInstanceInput {
                id: self.id,
                ttl: self.ttl,
                traffic_policy_id: self.traffic_policy_id,
                traffic_policy_version: self.traffic_policy_version,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTrafficPolicyInstanceInputOperationOutputAlias =
    crate::operation::UpdateTrafficPolicyInstance;
#[doc(hidden)]
pub type UpdateTrafficPolicyInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateTrafficPolicyInstanceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTrafficPolicyInstance`](crate::operation::UpdateTrafficPolicyInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTrafficPolicyInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateTrafficPolicyInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_104 = &_input.id;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_104, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/2013-04-01/trafficpolicyinstance/{Id}", Id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateTrafficPolicyInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateTrafficPolicyInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_traffic_policy_instance(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTrafficPolicyInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTrafficPolicyInstance",
            "route53",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateTrafficPolicyInstanceInput`](crate::input::UpdateTrafficPolicyInstanceInput)
    pub fn builder() -> crate::input::update_traffic_policy_instance_input::Builder {
        crate::input::update_traffic_policy_instance_input::Builder::default()
    }
}

/// <p>A complex type that contains information about the resource record sets that you want to update based on a specified traffic policy instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrafficPolicyInstanceInput {
    /// <p>The ID of the traffic policy instance that you want to update.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
    pub ttl: std::option::Option<i64>,
    /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
    pub traffic_policy_id: std::option::Option<std::string::String>,
    /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
    pub traffic_policy_version: std::option::Option<i32>,
}
impl UpdateTrafficPolicyInstanceInput {
    /// <p>The ID of the traffic policy instance that you want to update.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The TTL that you want Amazon Route 53 to assign to all of the updated resource record sets.</p>
    pub fn ttl(&self) -> std::option::Option<i64> {
        self.ttl
    }
    /// <p>The ID of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
    pub fn traffic_policy_id(&self) -> std::option::Option<&str> {
        self.traffic_policy_id.as_deref()
    }
    /// <p>The version of the traffic policy that you want Amazon Route 53 to use to update resource record sets for the specified traffic policy instance.</p>
    pub fn traffic_policy_version(&self) -> std::option::Option<i32> {
        self.traffic_policy_version
    }
}
impl std::fmt::Debug for UpdateTrafficPolicyInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrafficPolicyInstanceInput");
        formatter.field("id", &self.id);
        formatter.field("ttl", &self.ttl);
        formatter.field("traffic_policy_id", &self.traffic_policy_id);
        formatter.field("traffic_policy_version", &self.traffic_policy_version);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the traffic policy that you want to update the comment for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrafficPolicyCommentInput {
    /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
    pub version: std::option::Option<i32>,
    /// <p>The new comment for the specified traffic policy and version.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl UpdateTrafficPolicyCommentInput {
    /// <p>The value of <code>Id</code> for the traffic policy that you want to update the comment for.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The value of <code>Version</code> for the traffic policy that you want to update the comment for.</p>
    pub fn version(&self) -> std::option::Option<i32> {
        self.version
    }
    /// <p>The new comment for the specified traffic policy and version.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for UpdateTrafficPolicyCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrafficPolicyCommentInput");
        formatter.field("id", &self.id);
        formatter.field("version", &self.version);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

/// <p>A request to update the comment for a hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHostedZoneCommentInput {
    /// <p>The ID for the hosted zone that you want to update the comment for.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the
    /// <code>Comment</code> element, if any.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl UpdateHostedZoneCommentInput {
    /// <p>The ID for the hosted zone that you want to update the comment for.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The new comment for the hosted zone. If you don't specify a value for <code>Comment</code>, Amazon Route 53 deletes the existing value of the
    /// <code>Comment</code> element, if any.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for UpdateHostedZoneCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHostedZoneCommentInput");
        formatter.field("id", &self.id);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about a request to update a health check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateHealthCheckInput {
    /// <p>The ID for the health check for which you want detailed information. When you created the health check,
    /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
    pub health_check_id: std::option::Option<std::string::String>,
    /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you
    /// update settings for the health check.</p>
    /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of
    /// <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your
    /// <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
    /// <ul>
    /// <li>
    /// <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the
    /// health check, Route 53 updates the health check with the new settings.</p>
    /// </li>
    /// <li>
    /// <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you
    /// got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p>
    /// </li>
    /// </ul>
    pub health_check_version: std::option::Option<i64>,
    /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for
    /// <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code>
    /// at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then
    /// checks the health of the endpoint.</p>
    /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.),
    /// for example, <code>192.0.2.44</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:),
    /// for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952,
    /// for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p>
    /// </li>
    /// </ul>
    /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and
    /// specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information,
    /// see the applicable documentation:</p>
    /// <ul>
    /// <li>
    /// <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
    /// <i>Amazon EC2 User Guide for Windows Instances</i>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
    /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
    /// </note>
    /// <p>For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
    /// </p>
    /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or
    /// multicast ranges. For more information about IP addresses for which you can't create health checks, see the following
    /// documents:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
    /// </p>
    /// </li>
    /// </ul>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p>
    /// <note>
    /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or
    /// <code>CALCULATED</code>.</p>
    /// </note>
    pub port: std::option::Option<i32>,
    /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint
    /// will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html.
    /// You can also include query string parameters, for example, <code>/welcome.html?language=jp&login=y</code>. </p>
    /// <p>Specify this value only if you want to change it.</p>
    pub resource_path: std::option::Option<std::string::String>,
    /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p>
    ///
    /// <note>
    /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
    /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
    /// </note>
    ///
    /// <p>
    /// <b>If you specify a value for</b>
    /// <code>IPAddress</code>:</p>
    /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code>
    /// in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint
    /// on which you want Route 53 to perform health checks.</p>
    /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for
    /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
    /// </li>
    /// <li>
    /// <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for
    /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
    /// </li>
    /// <li>
    /// <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes
    /// <i>
    /// <code>FullyQualifiedDomainName</code>:<code>Port</code>
    /// </i> to the endpoint in the <code>Host</code> header.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code>
    /// in the <code>Host</code> header in each of the above cases.</p>
    ///
    /// <p>
    /// <b>If you don't specify a value for</b>
    /// <code>IPAddress</code>:</p>
    /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in
    /// <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is
    /// returned by DNS, Route 53 then checks the health of the endpoint.</p>
    /// <note>
    /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint.
    /// If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>,
    /// the health check fails with a "DNS resolution failed" error.</p>
    /// </note>
    /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by
    /// <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a
    /// health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>,
    /// specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p>
    /// <important>
    /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and
    /// you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
    /// </important>
    /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or
    /// <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does
    /// when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a
    /// <code>Host</code> header.</p>
    pub fully_qualified_domain_name: std::option::Option<std::string::String>,
    /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want
    /// Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers
    /// the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
    pub search_string: std::option::Option<std::string::String>,
    /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint
    /// from unhealthy to healthy or vice versa. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
    pub failure_threshold: std::option::Option<i32>,
    /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it
    /// otherwise would be considered healthy.</p>
    pub inverted: std::option::Option<bool>,
    /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Health checks that check the health of endpoints:</b>
    /// Route 53 stops submitting requests to your application, server, or other resource.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Calculated health checks:</b>
    /// Route 53 stops aggregating the status of the referenced health checks.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Health checks that monitor CloudWatch alarms:</b>
    /// Route 53 stops monitoring the corresponding CloudWatch metrics.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover,
    /// Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>.
    /// </p>
    ///
    /// <p>Charges for a health check still apply when the health check is disabled. For more information, see
    /// <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    pub disabled: std::option::Option<bool>,
    /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the
    /// <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a
    /// <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
    /// <p>Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p>
    /// </li>
    /// <li>
    /// <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p>
    /// </li>
    /// </ul>
    pub health_threshold: std::option::Option<i32>,
    /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a
    /// <code>CALCULATED</code> health check.</p>
    pub child_health_checks: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code>
    /// message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable
    /// SSL/TLS certificate.</p>
    /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI,
    /// the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons.
    /// If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
    /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more
    /// in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for
    /// <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not
    /// include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the
    /// second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
    pub enable_sni: std::option::Option<bool>,
    /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check
    /// the specified endpoint from.</p>
    pub regions: std::option::Option<std::vec::Vec<crate::model::HealthCheckRegion>>,
    /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether
    /// the specified health check is healthy.</p>
    pub alarm_identifier: std::option::Option<crate::model::AlarmIdentifier>,
    /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign
    /// to the health check:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Healthy</code>: Route 53 considers the health check to be healthy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time CloudWatch had sufficient data
    /// to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</p>
    /// </li>
    /// </ul>
    pub insufficient_data_health_status:
        std::option::Option<crate::model::InsufficientDataHealthStatus>,
    /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value.
    /// Valid values for <code>ResettableElementName</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ChildHealthChecks</code>: Amazon Route 53 resets
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a>
    /// to null.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FullyQualifiedDomainName</code>: Route 53 resets
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
    /// to null.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Regions</code>: Route 53 resets the
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a>
    /// list to the default set of regions. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourcePath</code>: Route 53 resets
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a>
    /// to null.</p>
    /// </li>
    /// </ul>
    pub reset_elements: std::option::Option<std::vec::Vec<crate::model::ResettableElementName>>,
}
impl UpdateHealthCheckInput {
    /// <p>The ID for the health check for which you want detailed information. When you created the health check,
    /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
    pub fn health_check_id(&self) -> std::option::Option<&str> {
        self.health_check_id.as_deref()
    }
    /// <p>A sequential counter that Amazon Route 53 sets to <code>1</code> when you create a health check and increments by 1 each time you
    /// update settings for the health check.</p>
    /// <p>We recommend that you use <code>GetHealthCheck</code> or <code>ListHealthChecks</code> to get the current value of
    /// <code>HealthCheckVersion</code> for the health check that you want to update, and that you include that value in your
    /// <code>UpdateHealthCheck</code> request. This prevents Route 53 from overwriting an intervening update:</p>
    /// <ul>
    /// <li>
    /// <p>If the value in the <code>UpdateHealthCheck</code> request matches the value of <code>HealthCheckVersion</code> in the
    /// health check, Route 53 updates the health check with the new settings.</p>
    /// </li>
    /// <li>
    /// <p>If the value of <code>HealthCheckVersion</code> in the health check is greater, the health check was changed after you
    /// got the version number. Route 53 does not update the health check, and it returns a <code>HealthCheckVersionMismatch</code> error.</p>
    /// </li>
    /// </ul>
    pub fn health_check_version(&self) -> std::option::Option<i64> {
        self.health_check_version
    }
    /// <p>The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route 53 to perform health checks on. If you don't specify a value for
    /// <code>IPAddress</code>, Route 53 sends a DNS request to resolve the domain name that you specify in <code>FullyQualifiedDomainName</code>
    /// at the interval that you specify in <code>RequestInterval</code>. Using an IP address that is returned by DNS, Route 53 then
    /// checks the health of the endpoint.</p>
    /// <p>Use one of the following formats for the value of <code>IPAddress</code>: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>IPv4 address</b>: four values between 0 and 255, separated by periods (.),
    /// for example, <code>192.0.2.44</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>IPv6 address</b>: eight groups of four hexadecimal values, separated by colons (:),
    /// for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>. You can also shorten IPv6 addresses as described in RFC 5952,
    /// for example, <code>2001:db8:85a3::abcd:1:2345</code>.</p>
    /// </li>
    /// </ul>
    /// <p>If the endpoint is an EC2 instance, we recommend that you create an Elastic IP address, associate it with your EC2 instance, and
    /// specify the Elastic IP address for <code>IPAddress</code>. This ensures that the IP address of your instance never changes. For more information,
    /// see the applicable documentation:</p>
    /// <ul>
    /// <li>
    /// <p>Linux: <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Windows: <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses (EIP)</a> in the
    /// <i>Amazon EC2 User Guide for Windows Instances</i>
    /// </p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
    /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
    /// </note>
    /// <p>For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
    /// </p>
    /// <p>Constraints: Route 53 can't check the health of endpoints for which the IP address is in local, private, non-routable, or
    /// multicast ranges. For more information about IP addresses for which you can't create health checks, see the following
    /// documents:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://tools.ietf.org/html/rfc5735">RFC 5735, Special Use IPv4 Addresses</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://tools.ietf.org/html/rfc6598">RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://tools.ietf.org/html/rfc5156">RFC 5156, Special-Use IPv6 Addresses</a>
    /// </p>
    /// </li>
    /// </ul>
    pub fn ip_address(&self) -> std::option::Option<&str> {
        self.ip_address.as_deref()
    }
    /// <p>The port on the endpoint that you want Amazon Route 53 to perform health checks on.</p>
    /// <note>
    /// <p>Don't specify a value for <code>Port</code> when you specify a value for <code>Type</code> of <code>CLOUDWATCH_METRIC</code> or
    /// <code>CALCULATED</code>.</p>
    /// </note>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The path that you want Amazon Route 53 to request when performing health checks. The path can be any value for which your endpoint
    /// will return an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example the file /docs/route53-health-check.html.
    /// You can also include query string parameters, for example, <code>/welcome.html?language=jp&login=y</code>. </p>
    /// <p>Specify this value only if you want to change it.</p>
    pub fn resource_path(&self) -> std::option::Option<&str> {
        self.resource_path.as_deref()
    }
    /// <p>Amazon Route 53 behavior depends on whether you specify a value for <code>IPAddress</code>.</p>
    ///
    /// <note>
    /// <p>If a health check already has a value for <code>IPAddress</code>, you can change the value. However, you can't update an
    /// existing health check to add or remove the value of <code>IPAddress</code>. </p>
    /// </note>
    ///
    /// <p>
    /// <b>If you specify a value for</b>
    /// <code>IPAddress</code>:</p>
    /// <p>Route 53 sends health check requests to the specified IPv4 or IPv6 address and passes the value of <code>FullyQualifiedDomainName</code>
    /// in the <code>Host</code> header for all health checks except TCP health checks. This is typically the fully qualified DNS name of the endpoint
    /// on which you want Route 53 to perform health checks.</p>
    /// <p>When Route 53 checks the health of an endpoint, here is how it constructs the <code>Host</code> header:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify a value of <code>80</code> for <code>Port</code> and <code>HTTP</code> or <code>HTTP_STR_MATCH</code> for
    /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
    /// </li>
    /// <li>
    /// <p>If you specify a value of <code>443</code> for <code>Port</code> and <code>HTTPS</code> or <code>HTTPS_STR_MATCH</code> for
    /// <code>Type</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>Host</code> header.</p>
    /// </li>
    /// <li>
    /// <p>If you specify another value for <code>Port</code> and any value except <code>TCP</code> for <code>Type</code>, Route 53 passes
    /// <i>
    /// <code>FullyQualifiedDomainName</code>:<code>Port</code>
    /// </i> to the endpoint in the <code>Host</code> header.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a value for <code>FullyQualifiedDomainName</code>, Route 53 substitutes the value of <code>IPAddress</code>
    /// in the <code>Host</code> header in each of the above cases.</p>
    ///
    /// <p>
    /// <b>If you don't specify a value for</b>
    /// <code>IPAddress</code>:</p>
    /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 sends a DNS request to the domain that you specify in
    /// <code>FullyQualifiedDomainName</code> at the interval you specify in <code>RequestInterval</code>. Using an IPv4 address that is
    /// returned by DNS, Route 53 then checks the health of the endpoint.</p>
    /// <note>
    /// <p>If you don't specify a value for <code>IPAddress</code>, Route 53 uses only IPv4 to send health checks to the endpoint.
    /// If there's no resource record set with a type of A for the name that you specify for <code>FullyQualifiedDomainName</code>,
    /// the health check fails with a "DNS resolution failed" error.</p>
    /// </note>
    /// <p>If you want to check the health of weighted, latency, or failover resource record sets and you choose to specify the endpoint only by
    /// <code>FullyQualifiedDomainName</code>, we recommend that you create a separate health check for each endpoint. For example, create a
    /// health check for each HTTP server that is serving content for www.example.com. For the value of <code>FullyQualifiedDomainName</code>,
    /// specify the domain name of the server (such as <code>us-east-2-www.example.com</code>), not the name of the resource record sets (www.example.com).</p>
    /// <important>
    /// <p>In this configuration, if the value of <code>FullyQualifiedDomainName</code> matches the name of the resource record sets and
    /// you then associate the health check with those resource record sets, health check results will be unpredictable.</p>
    /// </important>
    /// <p>In addition, if the value of <code>Type</code> is <code>HTTP</code>, <code>HTTPS</code>, <code>HTTP_STR_MATCH</code>, or
    /// <code>HTTPS_STR_MATCH</code>, Route 53 passes the value of <code>FullyQualifiedDomainName</code> in the <code>Host</code> header, as it does
    /// when you specify a value for <code>IPAddress</code>. If the value of <code>Type</code> is <code>TCP</code>, Route 53 doesn't pass a
    /// <code>Host</code> header.</p>
    pub fn fully_qualified_domain_name(&self) -> std::option::Option<&str> {
        self.fully_qualified_domain_name.as_deref()
    }
    /// <p>If the value of <code>Type</code> is <code>HTTP_STR_MATCH</code> or <code>HTTPS_STR_MATCH</code>, the string that you want
    /// Amazon Route 53 to search for in the response body from the specified resource. If the string appears in the response body, Route 53 considers
    /// the resource healthy. (You can't change the value of <code>Type</code> when you update a health check.)</p>
    pub fn search_string(&self) -> std::option::Option<&str> {
        self.search_string.as_deref()
    }
    /// <p>The number of consecutive health checks that an endpoint must pass or fail for Amazon Route 53 to change the current status of the endpoint
    /// from unhealthy to healthy or vice versa. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a>
    /// in the <i>Amazon Route 53 Developer Guide</i>.</p>
    /// <p>If you don't specify a value for <code>FailureThreshold</code>, the default value is three health checks.</p>
    pub fn failure_threshold(&self) -> std::option::Option<i32> {
        self.failure_threshold
    }
    /// <p>Specify whether you want Amazon Route 53 to invert the status of a health check, for example, to consider a health check unhealthy when it
    /// otherwise would be considered healthy.</p>
    pub fn inverted(&self) -> std::option::Option<bool> {
        self.inverted
    }
    /// <p>Stops Route 53 from performing health checks. When you disable a health check, here's what happens:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Health checks that check the health of endpoints:</b>
    /// Route 53 stops submitting requests to your application, server, or other resource.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Calculated health checks:</b>
    /// Route 53 stops aggregating the status of the referenced health checks.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Health checks that monitor CloudWatch alarms:</b>
    /// Route 53 stops monitoring the corresponding CloudWatch metrics.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover,
    /// Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted">Inverted</a>.
    /// </p>
    ///
    /// <p>Charges for a health check still apply when the health check is disabled. For more information, see
    /// <a href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.</p>
    pub fn disabled(&self) -> std::option::Option<bool> {
        self.disabled
    }
    /// <p>The number of child health checks that are associated with a <code>CALCULATED</code> health that Amazon Route 53 must consider healthy for the
    /// <code>CALCULATED</code> health check to be considered healthy. To specify the child health checks that you want to associate with a
    /// <code>CALCULATED</code> health check, use the <code>ChildHealthChecks</code> and <code>ChildHealthCheck</code> elements.</p>
    /// <p>Note the following:</p>
    /// <ul>
    /// <li>
    /// <p>If you specify a number greater than the number of child health checks, Route 53 always considers this health check to be unhealthy.</p>
    /// </li>
    /// <li>
    /// <p>If you specify <code>0</code>, Route 53 always considers this health check to be healthy.</p>
    /// </li>
    /// </ul>
    pub fn health_threshold(&self) -> std::option::Option<i32> {
        self.health_threshold
    }
    /// <p>A complex type that contains one <code>ChildHealthCheck</code> element for each health check that you want to associate with a
    /// <code>CALCULATED</code> health check.</p>
    pub fn child_health_checks(&self) -> std::option::Option<&[std::string::String]> {
        self.child_health_checks.as_deref()
    }
    /// <p>Specify whether you want Amazon Route 53 to send the value of <code>FullyQualifiedDomainName</code> to the endpoint in the <code>client_hello</code>
    /// message during <code>TLS</code> negotiation. This allows the endpoint to respond to <code>HTTPS</code> health check requests with the applicable
    /// SSL/TLS certificate.</p>
    /// <p>Some endpoints require that HTTPS requests include the host name in the <code>client_hello</code> message. If you don't enable SNI,
    /// the status of the health check will be SSL alert <code>handshake_failure</code>. A health check can also have that status for other reasons.
    /// If SNI is enabled and you're still getting the error, check the SSL/TLS configuration on your endpoint and confirm that your certificate is valid.</p>
    /// <p>The SSL/TLS certificate on your endpoint includes a domain name in the <code>Common Name</code> field and possibly several more
    /// in the <code>Subject Alternative Names</code> field. One of the domain names in the certificate should match the value that you specify for
    /// <code>FullyQualifiedDomainName</code>. If the endpoint responds to the <code>client_hello</code> message with a certificate that does not
    /// include the domain name that you specified in <code>FullyQualifiedDomainName</code>, a health checker will retry the handshake. In the
    /// second attempt, the health checker will omit <code>FullyQualifiedDomainName</code> from the <code>client_hello</code> message.</p>
    pub fn enable_sni(&self) -> std::option::Option<bool> {
        self.enable_sni
    }
    /// <p>A complex type that contains one <code>Region</code> element for each region that you want Amazon Route 53 health checkers to check
    /// the specified endpoint from.</p>
    pub fn regions(&self) -> std::option::Option<&[crate::model::HealthCheckRegion]> {
        self.regions.as_deref()
    }
    /// <p>A complex type that identifies the CloudWatch alarm that you want Amazon Route 53 health checkers to use to determine whether
    /// the specified health check is healthy.</p>
    pub fn alarm_identifier(&self) -> std::option::Option<&crate::model::AlarmIdentifier> {
        self.alarm_identifier.as_ref()
    }
    /// <p>When CloudWatch has insufficient data about the metric to determine the alarm state, the status that you want Amazon Route 53 to assign
    /// to the health check:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Healthy</code>: Route 53 considers the health check to be healthy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unhealthy</code>: Route 53 considers the health check to be unhealthy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LastKnownStatus</code>: Route 53 uses the status of the health check from the last time CloudWatch had sufficient data
    /// to determine the alarm state. For new health checks that have no last known status, the default status for the health check is healthy.</p>
    /// </li>
    /// </ul>
    pub fn insufficient_data_health_status(
        &self,
    ) -> std::option::Option<&crate::model::InsufficientDataHealthStatus> {
        self.insufficient_data_health_status.as_ref()
    }
    /// <p>A complex type that contains one <code>ResettableElementName</code> element for each element that you want to reset to the default value.
    /// Valid values for <code>ResettableElementName</code> include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ChildHealthChecks</code>: Amazon Route 53 resets
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks">ChildHealthChecks</a>
    /// to null.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FullyQualifiedDomainName</code>: Route 53 resets
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName">FullyQualifiedDomainName</a>.
    /// to null.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Regions</code>: Route 53 resets the
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions">Regions</a>
    /// list to the default set of regions. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ResourcePath</code>: Route 53 resets
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath">ResourcePath</a>
    /// to null.</p>
    /// </li>
    /// </ul>
    pub fn reset_elements(&self) -> std::option::Option<&[crate::model::ResettableElementName]> {
        self.reset_elements.as_deref()
    }
}
impl std::fmt::Debug for UpdateHealthCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateHealthCheckInput");
        formatter.field("health_check_id", &self.health_check_id);
        formatter.field("health_check_version", &self.health_check_version);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("port", &self.port);
        formatter.field("resource_path", &self.resource_path);
        formatter.field(
            "fully_qualified_domain_name",
            &self.fully_qualified_domain_name,
        );
        formatter.field("search_string", &self.search_string);
        formatter.field("failure_threshold", &self.failure_threshold);
        formatter.field("inverted", &self.inverted);
        formatter.field("disabled", &self.disabled);
        formatter.field("health_threshold", &self.health_threshold);
        formatter.field("child_health_checks", &self.child_health_checks);
        formatter.field("enable_sni", &self.enable_sni);
        formatter.field("regions", &self.regions);
        formatter.field("alarm_identifier", &self.alarm_identifier);
        formatter.field(
            "insufficient_data_health_status",
            &self.insufficient_data_health_status,
        );
        formatter.field("reset_elements", &self.reset_elements);
        formatter.finish()
    }
}

/// <p>Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify
/// the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestDnsAnswerInput {
    /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
    pub record_name: std::option::Option<std::string::String>,
    /// <p>The type of the resource record set.</p>
    pub record_type: std::option::Option<crate::model::RrType>,
    /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver.
    /// If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region
    /// (<code>us-east-1</code>).</p>
    pub resolver_ip: std::option::Option<std::string::String>,
    /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client
    /// in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
    pub edns0_client_subnet_ip: std::option::Option<std::string::String>,
    /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address
    /// that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for
    /// <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from
    /// 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
    /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>IPv4</b>: Specify a value between 0 and 32</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>IPv6</b>: Specify a value between 0 and 128</p>
    /// </li>
    /// </ul>
    pub edns0_client_subnet_mask: std::option::Option<std::string::String>,
}
impl TestDnsAnswerInput {
    /// <p>The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The name of the resource record set that you want Amazon Route 53 to simulate a query for.</p>
    pub fn record_name(&self) -> std::option::Option<&str> {
        self.record_name.as_deref()
    }
    /// <p>The type of the resource record set.</p>
    pub fn record_type(&self) -> std::option::Option<&crate::model::RrType> {
        self.record_type.as_ref()
    }
    /// <p>If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver.
    /// If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the Amazon Web Services US East (N. Virginia) Region
    /// (<code>us-east-1</code>).</p>
    pub fn resolver_ip(&self) -> std::option::Option<&str> {
        self.resolver_ip.as_deref()
    }
    /// <p>If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client
    /// in the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.</p>
    pub fn edns0_client_subnet_ip(&self) -> std::option::Option<&str> {
        self.edns0_client_subnet_ip.as_deref()
    }
    /// <p>If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits of the IP address
    /// that you want the checking tool to include in the DNS query. For example, if you specify <code>192.0.2.44</code> for
    /// <code>edns0clientsubnetip</code> and <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from
    /// 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.</p>
    /// <p>The range of valid values depends on whether <code>edns0clientsubnetip</code> is an IPv4 or an IPv6 address:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>IPv4</b>: Specify a value between 0 and 32</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>IPv6</b>: Specify a value between 0 and 128</p>
    /// </li>
    /// </ul>
    pub fn edns0_client_subnet_mask(&self) -> std::option::Option<&str> {
        self.edns0_client_subnet_mask.as_deref()
    }
}
impl std::fmt::Debug for TestDnsAnswerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestDnsAnswerInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("record_name", &self.record_name);
        formatter.field("record_type", &self.record_type);
        formatter.field("resolver_ip", &self.resolver_ip);
        formatter.field("edns0_client_subnet_ip", &self.edns0_client_subnet_ip);
        formatter.field("edns0_client_subnet_mask", &self.edns0_client_subnet_mask);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about that can be associated with your hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVpcAssociationAuthorizationsInput {
    /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>
    /// <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs
    /// that can be associated with the specified hosted zone. To get the next page of results, submit another request,
    /// and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter
    /// in another <code>ListVPCAssociationAuthorizations</code> request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return.
    /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListVpcAssociationAuthorizationsInput {
    /// <p>The ID of the hosted zone for which you want a list of VPCs that can be associated with the hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>
    /// <i>Optional</i>: If a response includes a <code>NextToken</code> element, there are more VPCs
    /// that can be associated with the specified hosted zone. To get the next page of results, submit another request,
    /// and include the value of <code>NextToken</code> from the response in the <code>nexttoken</code> parameter
    /// in another <code>ListVPCAssociationAuthorizations</code> request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>
    /// <i>Optional</i>: An integer that specifies the maximum number of VPCs that you want Amazon Route 53 to return.
    /// If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 50 VPCs per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListVpcAssociationAuthorizationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVpcAssociationAuthorizationsInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>A complex type that contains the information about the request to list your traffic
/// policies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyVersionsInput {
    /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
    /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only
    /// the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code>
    /// request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous
    /// response.</p>
    pub traffic_policy_version_marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified
    /// traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>,
    /// and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit
    /// another request.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyVersionsInput {
    /// <p>Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>For your first request to <code>ListTrafficPolicyVersions</code>, don't include the <code>TrafficPolicyVersionMarker</code> parameter.</p>
    /// <p>If you have more traffic policy versions than the value of <code>MaxItems</code>, <code>ListTrafficPolicyVersions</code> returns only
    /// the first group of <code>MaxItems</code> versions. To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code>
    /// request. For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the previous
    /// response.</p>
    pub fn traffic_policy_version_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_version_marker.as_deref()
    }
    /// <p>The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for this request. If the specified
    /// traffic policy has more than <code>MaxItems</code> versions, the value of <code>IsTruncated</code> in the response is <code>true</code>,
    /// and the value of the <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Route 53 will return if you submit
    /// another request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyVersionsInput");
        formatter.field("id", &self.id);
        formatter.field(
            "traffic_policy_version_marker",
            &self.traffic_policy_version_marker,
        );
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A complex type that contains the information about the request to list your traffic policy instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyInstancesByPolicyInput {
    /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
    pub traffic_policy_id: std::option::Option<std::string::String>,
    /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the
    /// traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
    pub traffic_policy_version: std::option::Option<i32>,
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
    /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response,
    /// which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub hosted_zone_id_marker: std::option::Option<std::string::String>,
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
    /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code>
    /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
    /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code>
    /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
    /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
    /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
    /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
    /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyInstancesByPolicyInput {
    /// <p>The ID of the traffic policy for which you want to list traffic policy instances.</p>
    pub fn traffic_policy_id(&self) -> std::option::Option<&str> {
        self.traffic_policy_id.as_deref()
    }
    /// <p>The version of the traffic policy for which you want to list traffic policy instances. The version must be associated with the
    /// traffic policy that is specified by <code>TrafficPolicyId</code>.</p>
    pub fn traffic_policy_version(&self) -> std::option::Option<i32> {
        self.traffic_policy_version
    }
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
    /// <p>For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the previous response,
    /// which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn hosted_zone_id_marker(&self) -> std::option::Option<&str> {
        self.hosted_zone_id_marker.as_deref()
    }
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
    /// <p>For the value of <code>trafficpolicyinstancename</code>, specify the value of <code>TrafficPolicyInstanceNameMarker</code>
    /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn traffic_policy_instance_name_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_instance_name_marker.as_deref()
    }
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
    /// <p>For the value of <code>trafficpolicyinstancetype</code>, specify the value of <code>TrafficPolicyInstanceTypeMarker</code>
    /// from the previous response, which is the name of the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn traffic_policy_instance_type_marker(
        &self,
    ) -> std::option::Option<&crate::model::RrType> {
        self.traffic_policy_instance_type_marker.as_ref()
    }
    /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
    /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
    /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
    /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyInstancesByPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyInstancesByPolicyInput");
        formatter.field("traffic_policy_id", &self.traffic_policy_id);
        formatter.field("traffic_policy_version", &self.traffic_policy_version);
        formatter.field("hosted_zone_id_marker", &self.hosted_zone_id_marker);
        formatter.field(
            "traffic_policy_instance_name_marker",
            &self.traffic_policy_instance_name_marker,
        );
        formatter.field(
            "traffic_policy_instance_type_marker",
            &self.traffic_policy_instance_type_marker,
        );
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A request for the traffic policy instances that you created in a specified hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyInstancesByHostedZoneInput {
    /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
    /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
    /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
    /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
    /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
    /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
    /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
    /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyInstancesByHostedZoneInput {
    /// <p>The ID of the hosted zone that you want to list traffic policy instances for.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
    /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn traffic_policy_instance_name_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_instance_name_marker.as_deref()
    }
    /// <p>If the value of <code>IsTruncated</code> in the previous response is true, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
    /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn traffic_policy_instance_type_marker(
        &self,
    ) -> std::option::Option<&crate::model::RrType> {
        self.traffic_policy_instance_type_marker.as_ref()
    }
    /// <p>The maximum number of traffic policy instances to be included in the response body for this request. If you have more than
    /// <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
    /// and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code>
    /// represent the first traffic policy instance that Amazon Route 53 will return if you submit another request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyInstancesByHostedZoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyInstancesByHostedZoneInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field(
            "traffic_policy_instance_name_marker",
            &self.traffic_policy_instance_name_marker,
        );
        formatter.field(
            "traffic_policy_instance_type_marker",
            &self.traffic_policy_instance_type_marker,
        );
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A request to get information about the traffic policy instances that you created by using the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPolicyInstancesInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>,
    /// specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub hosted_zone_id_marker: std::option::Option<std::string::String>,
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
    /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub traffic_policy_instance_name_marker: std::option::Option<std::string::String>,
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
    /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub traffic_policy_instance_type_marker: std::option::Option<crate::model::RrType>,
    /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request.
    /// If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is
    /// <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
    /// <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code>
    /// traffic policy instances.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPolicyInstancesInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>HostedZoneId</code>,
    /// specify the value of <code>HostedZoneIdMarker</code> from the previous response, which is the hosted zone ID of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn hosted_zone_id_marker(&self) -> std::option::Option<&str> {
        self.hosted_zone_id_marker.as_deref()
    }
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancename</code>,
    /// specify the value of <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn traffic_policy_instance_name_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_instance_name_marker.as_deref()
    }
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic policy instances.
    /// To get more traffic policy instances, submit another <code>ListTrafficPolicyInstances</code> request. For the value of <code>trafficpolicyinstancetype</code>,
    /// specify the value of <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the type of the first traffic policy instance
    /// in the next group of traffic policy instances.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more traffic policy instances to get.</p>
    pub fn traffic_policy_instance_type_marker(
        &self,
    ) -> std::option::Option<&crate::model::RrType> {
        self.traffic_policy_instance_type_marker.as_ref()
    }
    /// <p>The maximum number of traffic policy instances that you want Amazon Route 53 to return in response to a <code>ListTrafficPolicyInstances</code> request.
    /// If you have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in the response is
    /// <code>true</code>, and the values of <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
    /// <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance in the next group of <code>MaxItems</code>
    /// traffic policy instances.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPolicyInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPolicyInstancesInput");
        formatter.field("hosted_zone_id_marker", &self.hosted_zone_id_marker);
        formatter.field(
            "traffic_policy_instance_name_marker",
            &self.traffic_policy_instance_name_marker,
        );
        formatter.field(
            "traffic_policy_instance_type_marker",
            &self.traffic_policy_instance_type_marker,
        );
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A complex type that contains the information about the request to list the traffic policies that are associated
/// with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrafficPoliciesInput {
    /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
    /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first
    /// <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>.
    /// For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the
    /// previous response.</p>
    pub traffic_policy_id_marker: std::option::Option<std::string::String>,
    /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than
    /// <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the
    /// value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit
    /// another request.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListTrafficPoliciesInput {
    /// <p>(Conditional) For your first request to <code>ListTrafficPolicies</code>, don't include the <code>TrafficPolicyIdMarker</code> parameter.</p>
    /// <p>If you have more traffic policies than the value of <code>MaxItems</code>, <code>ListTrafficPolicies</code> returns only the first
    /// <code>MaxItems</code> traffic policies. To get the next group of policies, submit another request to <code>ListTrafficPolicies</code>.
    /// For the value of <code>TrafficPolicyIdMarker</code>, specify the value of <code>TrafficPolicyIdMarker</code> that was returned in the
    /// previous response.</p>
    pub fn traffic_policy_id_marker(&self) -> std::option::Option<&str> {
        self.traffic_policy_id_marker.as_deref()
    }
    /// <p>(Optional) The maximum number of traffic policies that you want Amazon Route 53 to return in response to this request. If you have more than
    /// <code>MaxItems</code> traffic policies, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the
    /// value of <code>TrafficPolicyIdMarker</code> is the ID of the first traffic policy that Route 53 will return if you submit
    /// another request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListTrafficPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrafficPoliciesInput");
        formatter.field("traffic_policy_id_marker", &self.traffic_policy_id_marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the health checks or hosted zones for which you want to list tags.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourcesInput {
    /// <p>The type of the resources.</p>
    /// <ul>
    /// <li>
    /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
    /// </li>
    /// </ul>
    pub resource_type: std::option::Option<crate::model::TagResourceType>,
    /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
    pub resource_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListTagsForResourcesInput {
    /// <p>The type of the resources.</p>
    /// <ul>
    /// <li>
    /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
    /// </li>
    /// </ul>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TagResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.</p>
    pub fn resource_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_ids.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourcesInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_ids", &self.resource_ids);
        formatter.finish()
    }
}

/// <p>A complex type containing information about a request for a list of the tags that are associated with an individual resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The type of the resource.</p>
    /// <ul>
    /// <li>
    /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
    /// </li>
    /// </ul>
    pub resource_type: std::option::Option<crate::model::TagResourceType>,
    /// <p>The ID of the resource for which you want to retrieve tags.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The type of the resource.</p>
    /// <ul>
    /// <li>
    /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
    /// </li>
    /// </ul>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TagResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource for which you want to retrieve tags.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}

/// <p>A request to get a list of the reusable delegation sets that are associated with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReusableDelegationSetsInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets.
    /// To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
    /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
    /// which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value
    /// greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListReusableDelegationSetsInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more reusable delegation sets.
    /// To get another group, submit another <code>ListReusableDelegationSets</code> request. </p>
    /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
    /// which is the ID of the first reusable delegation set that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more reusable delegation sets to get.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The number of reusable delegation sets that you want Amazon Route 53 to return in the response to this request. If you specify a value
    /// greater than 100, Route 53 returns only the first 100 reusable delegation sets.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListReusableDelegationSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReusableDelegationSetsInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A request for the resource record sets that are associated with a specified hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceRecordSetsInput {
    /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The first name in the lexicographic ordering of resource record sets that you want to list.
    /// If the specified record name doesn't exist, the results begin with the first resource record set that has a name
    /// greater than the value of <code>name</code>.</p>
    pub start_record_name: std::option::Option<std::string::String>,
    /// <p>The type of resource record set to begin the record listing from.</p>
    /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> |
    /// <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
    /// </p>
    /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> |
    /// <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
    /// </p>
    /// <p>Values for alias resource record sets: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>API Gateway custom regional API or edge-optimized API</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CloudFront distribution</b>: A or AAAA</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Elastic Load Balancing load balancer</b>: A | AAAA</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>S3 bucket</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>VPC interface VPC endpoint</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Another resource record set in this hosted zone:</b> The type of the resource record set
    /// that the alias references.</p>
    /// </li>
    /// </ul>
    /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
    pub start_record_type: std::option::Option<crate::model::RrType>,
    /// <p>
    /// <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type,
    /// specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current
    /// DNS name and type.</p>
    pub start_record_identifier: std::option::Option<std::string::String>,
    /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes
    /// more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
    /// and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first
    /// resource record set in the next group of <code>maxitems</code> resource record sets.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListResourceRecordSetsInput {
    /// <p>The ID of the hosted zone that contains the resource record sets that you want to list.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The first name in the lexicographic ordering of resource record sets that you want to list.
    /// If the specified record name doesn't exist, the results begin with the first resource record set that has a name
    /// greater than the value of <code>name</code>.</p>
    pub fn start_record_name(&self) -> std::option::Option<&str> {
        self.start_record_name.as_deref()
    }
    /// <p>The type of resource record set to begin the record listing from.</p>
    /// <p>Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> |
    /// <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
    /// </p>
    /// <p>Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> |
    /// <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
    /// </p>
    /// <p>Values for alias resource record sets: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>API Gateway custom regional API or edge-optimized API</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CloudFront distribution</b>: A or AAAA</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Elastic Load Balancing load balancer</b>: A | AAAA</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>S3 bucket</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>VPC interface VPC endpoint</b>: A</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Another resource record set in this hosted zone:</b> The type of the resource record set
    /// that the alias references.</p>
    /// </li>
    /// </ul>
    /// <p>Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an <code>InvalidInput</code> error.</p>
    pub fn start_record_type(&self) -> std::option::Option<&crate::model::RrType> {
        self.start_record_type.as_ref()
    }
    /// <p>
    /// <i>Resource record sets that have a routing policy other than simple:</i> If results were truncated for a given DNS name and type,
    /// specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that has the current
    /// DNS name and type.</p>
    pub fn start_record_identifier(&self) -> std::option::Option<&str> {
        self.start_record_identifier.as_deref()
    }
    /// <p>(Optional) The maximum number of resource records sets to include in the response body for this request. If the response includes
    /// more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code> element in the response is <code>true</code>,
    /// and the values of the <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first
    /// resource record set in the next group of <code>maxitems</code> resource record sets.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListResourceRecordSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceRecordSetsInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("start_record_name", &self.start_record_name);
        formatter.field("start_record_type", &self.start_record_type);
        formatter.field("start_record_identifier", &self.start_record_identifier);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueryLoggingConfigsInput {
    /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in
    /// <code>HostedZoneId</code>. </p>
    /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations
    /// that are associated with the current Amazon Web Services account.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code>
    /// to get the second and subsequent pages of results.</p>
    /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
    /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
    /// for <code>NextToken</code> in the request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request.
    /// If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a>
    /// in the response to get the next page of results.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListQueryLoggingConfigsInput {
    /// <p>(Optional) If you want to list the query logging configuration that is associated with a hosted zone, specify the ID in
    /// <code>HostedZoneId</code>. </p>
    /// <p>If you don't specify a hosted zone ID, <code>ListQueryLoggingConfigs</code> returns all of the configurations
    /// that are associated with the current Amazon Web Services account.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>(Optional) If the current Amazon Web Services account has more than <code>MaxResults</code> query logging configurations, use <code>NextToken</code>
    /// to get the second and subsequent pages of results.</p>
    /// <p>For the first <code>ListQueryLoggingConfigs</code> request, omit this value.</p>
    /// <p>For the second and subsequent requests, get the value of <code>NextToken</code> from the previous response and specify that value
    /// for <code>NextToken</code> in the request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>(Optional) The maximum number of query logging configurations that you want Amazon Route 53 to return in response to the current request.
    /// If the current Amazon Web Services account has more than <code>MaxResults</code> configurations, use the value of
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax">NextToken</a>
    /// in the response to get the next page of results.</p>
    /// <p>If you don't specify a value for <code>MaxResults</code>, Route 53 returns up to 100 configurations.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListQueryLoggingConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueryLoggingConfigsInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web Services account created the hosted zones.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedZonesByVpcInput {
    /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
    pub vpc_region: std::option::Option<crate::model::VpcRegion>,
    /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with
    /// more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains
    /// an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones.
    /// To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
    /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
    /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHostedZonesByVpcInput {
    /// <p>The ID of the Amazon VPC that you want to list hosted zones for.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>For the Amazon VPC that you specified for <code>VPCId</code>, the Amazon Web Services Region that you created the VPC in. </p>
    pub fn vpc_region(&self) -> std::option::Option<&crate::model::VpcRegion> {
        self.vpc_region.as_ref()
    }
    /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If the specified VPC is associated with
    /// more than <code>MaxItems</code> hosted zones, the response includes a <code>NextToken</code> element. <code>NextToken</code> contains
    /// an encrypted token that identifies the first hosted zone that Route 53 will return if you submit another request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>If the previous response included a <code>NextToken</code> element, the specified VPC is associated with more hosted zones.
    /// To get more hosted zones, submit another <code>ListHostedZonesByVPC</code> request. </p>
    /// <p>For the value of <code>NextToken</code>, specify the value of <code>NextToken</code> from the previous response.</p>
    /// <p>If the previous response didn't include a <code>NextToken</code> element, there are no more hosted zones to get.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHostedZonesByVpcInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedZonesByVpcInput");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("vpc_region", &self.vpc_region);
        formatter.field("max_items", &self.max_items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services account in ASCII order by domain
/// name. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedZonesByNameInput {
    /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to
    /// specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of
    /// the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and
    /// <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
    /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first
    /// <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to
    /// <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of
    /// <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code>
    /// hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and
    /// <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
    pub max_items: std::option::Option<i32>,
}
impl ListHostedZonesByNameInput {
    /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, include the <code>dnsname</code> parameter only if you want to
    /// specify the name of the first hosted zone in the response. If you don't include the <code>dnsname</code> parameter, Amazon Route 53 returns all of
    /// the hosted zones that were created by the current Amazon Web Services account, in ASCII order. For subsequent requests, include both <code>dnsname</code> and
    /// <code>hostedzoneid</code> parameters. For <code>dnsname</code>, specify the value of <code>NextDNSName</code> from the previous response.</p>
    pub fn dns_name(&self) -> std::option::Option<&str> {
        self.dns_name.as_deref()
    }
    /// <p>(Optional) For your first request to <code>ListHostedZonesByName</code>, do not include the <code>hostedzoneid</code> parameter.</p>
    /// <p>If you have more hosted zones than the value of <code>maxitems</code>, <code>ListHostedZonesByName</code> returns only the first
    /// <code>maxitems</code> hosted zones. To get the next group of <code>maxitems</code> hosted zones, submit another request to
    /// <code>ListHostedZonesByName</code> and include both <code>dnsname</code> and <code>hostedzoneid</code> parameters. For the value of
    /// <code>hostedzoneid</code>, specify the value of the <code>NextHostedZoneId</code> element from the previous response.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The maximum number of hosted zones to be included in the response body for this request. If you have more than <code>maxitems</code>
    /// hosted zones, then the value of the <code>IsTruncated</code> element in the response is true, and the values of <code>NextDNSName</code> and
    /// <code>NextHostedZoneId</code> specify the first hosted zone in the next group of <code>maxitems</code> hosted zones. </p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListHostedZonesByNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedZonesByNameInput");
        formatter.field("dns_name", &self.dns_name);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A request to retrieve a list of the public and private hosted zones that are associated with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHostedZonesInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones.
    /// To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
    /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
    /// which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code>
    /// hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code>
    /// is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
    /// with a reusable delegation set, specify the ID of that reusable delegation set. </p>
    pub delegation_set_id: std::option::Option<std::string::String>,
}
impl ListHostedZonesInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more hosted zones.
    /// To get more hosted zones, submit another <code>ListHostedZones</code> request. </p>
    /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
    /// which is the ID of the first hosted zone that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more hosted zones to get.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>(Optional) The maximum number of hosted zones that you want Amazon Route 53 to return. If you have more than <code>maxitems</code>
    /// hosted zones, the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of <code>NextMarker</code>
    /// is the hosted zone ID of the first hosted zone that Route 53 will return if you submit another request.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>If you're using reusable delegation sets and you want to list all of the hosted zones that are associated
    /// with a reusable delegation set, specify the ID of that reusable delegation set. </p>
    pub fn delegation_set_id(&self) -> std::option::Option<&str> {
        self.delegation_set_id.as_deref()
    }
}
impl std::fmt::Debug for ListHostedZonesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHostedZonesInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("delegation_set_id", &self.delegation_set_id);
        formatter.finish()
    }
}

/// <p>A request to retrieve a list of the health checks that are associated with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHealthChecksInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group,
    /// submit another <code>ListHealthChecks</code> request. </p>
    /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
    /// which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request.
    /// Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
    pub max_items: std::option::Option<i32>,
}
impl ListHealthChecksInput {
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more health checks. To get another group,
    /// submit another <code>ListHealthChecks</code> request. </p>
    /// <p>For the value of <code>marker</code>, specify the value of <code>NextMarker</code> from the previous response,
    /// which is the ID of the first health check that Amazon Route 53 will return if you submit another request.</p>
    /// <p>If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more health checks to get.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of health checks that you want <code>ListHealthChecks</code> to return in response to the current request.
    /// Amazon Route 53 returns a maximum of 100 items. If you set <code>MaxItems</code> to a value greater than 100, Route 53 returns only the first 100 health checks. </p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListHealthChecksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHealthChecksInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource record sets. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeoLocationsInput {
    /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
    /// returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous
    /// response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
    /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code>
    /// when you're listing countries or countries with their subdivisions.</p>
    pub start_continent_code: std::option::Option<std::string::String>,
    /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
    /// returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the
    /// previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
    pub start_country_code: std::option::Option<std::string::String>,
    /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports
    /// for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if
    /// <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code>
    /// to return the next page of results.</p>
    /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
    pub start_subdivision_code: std::option::Option<std::string::String>,
    /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code>
    /// geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListGeoLocationsInput {
    /// <p>The code for the continent with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
    /// returned a page or more of results, if <code>IsTruncated</code> is true, and if <code>NextContinentCode</code> from the previous
    /// response has a value, enter that value in <code>startcontinentcode</code> to return the next page of results.</p>
    /// <p>Include <code>startcontinentcode</code> only if you want to list continents. Don't include <code>startcontinentcode</code>
    /// when you're listing countries or countries with their subdivisions.</p>
    pub fn start_continent_code(&self) -> std::option::Option<&str> {
        self.start_continent_code.as_deref()
    }
    /// <p>The code for the country with which you want to start listing locations that Amazon Route 53 supports for geolocation. If Route 53 has already
    /// returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if <code>NextCountryCode</code> from the
    /// previous response has a value, enter that value in <code>startcountrycode</code> to return the next page of results.</p>
    pub fn start_country_code(&self) -> std::option::Option<&str> {
        self.start_country_code.as_deref()
    }
    /// <p>The code for the state of the United States with which you want to start listing locations that Amazon Route 53 supports
    /// for geolocation. If Route 53 has already returned a page or more of results, if <code>IsTruncated</code> is <code>true</code>, and if
    /// <code>NextSubdivisionCode</code> from the previous response has a value, enter that value in <code>startsubdivisioncode</code>
    /// to return the next page of results.</p>
    /// <p>To list subdivisions (U.S. states), you must include both <code>startcountrycode</code> and <code>startsubdivisioncode</code>.</p>
    pub fn start_subdivision_code(&self) -> std::option::Option<&str> {
        self.start_subdivision_code.as_deref()
    }
    /// <p>(Optional) The maximum number of geolocations to be included in the response body for this request. If more than <code>maxitems</code>
    /// geolocations remain to be listed, then the value of the <code>IsTruncated</code> element in the response is <code>true</code>.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListGeoLocationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeoLocationsInput");
        formatter.field("start_continent_code", &self.start_continent_code);
        formatter.field("start_country_code", &self.start_country_code);
        formatter.field("start_subdivision_code", &self.start_subdivision_code);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

/// <p>Request to get the number of traffic policy instances that are associated with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrafficPolicyInstanceCountInput {}
impl std::fmt::Debug for GetTrafficPolicyInstanceCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrafficPolicyInstanceCountInput");
        formatter.finish()
    }
}

/// <p>Gets information about a specified traffic policy instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrafficPolicyInstanceInput {
    /// <p>The ID of the traffic policy instance that you want to get information about.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetTrafficPolicyInstanceInput {
    /// <p>The ID of the traffic policy instance that you want to get information about.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetTrafficPolicyInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrafficPolicyInstanceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>Gets information about a specific traffic policy version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTrafficPolicyInput {
    /// <p>The ID of the traffic policy that you want to get information about.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version number of the traffic policy that you want to get information about.</p>
    pub version: std::option::Option<i32>,
}
impl GetTrafficPolicyInput {
    /// <p>The ID of the traffic policy that you want to get information about.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version number of the traffic policy that you want to get information about.</p>
    pub fn version(&self) -> std::option::Option<i32> {
        self.version
    }
}
impl std::fmt::Debug for GetTrafficPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTrafficPolicyInput");
        formatter.field("id", &self.id);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the request to create a hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReusableDelegationSetLimitInput {
    /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate
    /// with the specified reusable delegation set.</p>
    pub r#type: std::option::Option<crate::model::ReusableDelegationSetLimitType>,
    /// <p>The ID of the delegation set that you want to get the limit for.</p>
    pub delegation_set_id: std::option::Option<std::string::String>,
}
impl GetReusableDelegationSetLimitInput {
    /// <p>Specify <code>MAX_ZONES_BY_REUSABLE_DELEGATION_SET</code> to get the maximum number of hosted zones that you can associate
    /// with the specified reusable delegation set.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ReusableDelegationSetLimitType> {
        self.r#type.as_ref()
    }
    /// <p>The ID of the delegation set that you want to get the limit for.</p>
    pub fn delegation_set_id(&self) -> std::option::Option<&str> {
        self.delegation_set_id.as_deref()
    }
}
impl std::fmt::Debug for GetReusableDelegationSetLimitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReusableDelegationSetLimitInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("delegation_set_id", &self.delegation_set_id);
        formatter.finish()
    }
}

/// <p>A request to get information about a specified reusable delegation set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReusableDelegationSetInput {
    /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetReusableDelegationSetInput {
    /// <p>The ID of the reusable delegation set that you want to get a list of name servers for.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetReusableDelegationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReusableDelegationSetInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryLoggingConfigInput {
    /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetQueryLoggingConfigInput {
    /// <p>The ID of the configuration for DNS query logging that you want to get information about.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetQueryLoggingConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryLoggingConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the request to create a hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedZoneLimitInput {
    /// <p>The limit that you want to get. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create
    /// in the specified hosted zone.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can
    /// associate with the specified private hosted zone.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::HostedZoneLimitType>,
    /// <p>The ID of the hosted zone that you want to get a limit for.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl GetHostedZoneLimitInput {
    /// <p>The limit that you want to get. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create
    /// in the specified hosted zone.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_VPCS_ASSOCIATED_BY_ZONE</b>: The maximum number of Amazon VPCs that you can
    /// associate with the specified private hosted zone.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::HostedZoneLimitType> {
        self.r#type.as_ref()
    }
    /// <p>The ID of the hosted zone that you want to get a limit for.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for GetHostedZoneLimitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedZoneLimitInput");
        formatter.field("r#type", &self.r#type);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}

/// <p>A request to retrieve a count of all the hosted zones that are associated with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedZoneCountInput {}
impl std::fmt::Debug for GetHostedZoneCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedZoneCountInput");
        formatter.finish()
    }
}

/// <p>A request to get information about a specified hosted zone. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHostedZoneInput {
    /// <p>The ID of the hosted zone that you want to get information about.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetHostedZoneInput {
    /// <p>The ID of the hosted zone that you want to get information about.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetHostedZoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHostedZoneInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>A request to get the status for a health check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckStatusInput {
    /// <p>The ID for the health check that you want the current status for. When you created the health check,
    /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
    /// <note>
    /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console.
    /// You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
    /// </note>
    pub health_check_id: std::option::Option<std::string::String>,
}
impl GetHealthCheckStatusInput {
    /// <p>The ID for the health check that you want the current status for. When you created the health check,
    /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
    /// <note>
    /// <p>If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the CloudWatch console.
    /// You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health check.</p>
    /// </note>
    pub fn health_check_id(&self) -> std::option::Option<&str> {
        self.health_check_id.as_deref()
    }
}
impl std::fmt::Debug for GetHealthCheckStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckStatusInput");
        formatter.field("health_check_id", &self.health_check_id);
        formatter.finish()
    }
}

/// <p>A request for the reason that a health check failed most recently.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckLastFailureReasonInput {
    /// <p>The ID for the health check for which you want the last failure reason. When you created the health check,
    /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
    /// <note>
    /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the
    /// CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
    /// </note>
    pub health_check_id: std::option::Option<std::string::String>,
}
impl GetHealthCheckLastFailureReasonInput {
    /// <p>The ID for the health check for which you want the last failure reason. When you created the health check,
    /// <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.</p>
    /// <note>
    /// <p>If you want to get the last failure reason for a calculated health check, you must use the Amazon Route 53 console or the
    /// CloudWatch console. You can't use <code>GetHealthCheckLastFailureReason</code> for a calculated health check.</p>
    /// </note>
    pub fn health_check_id(&self) -> std::option::Option<&str> {
        self.health_check_id.as_deref()
    }
}
impl std::fmt::Debug for GetHealthCheckLastFailureReasonInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckLastFailureReasonInput");
        formatter.field("health_check_id", &self.health_check_id);
        formatter.finish()
    }
}

/// <p>A request for the number of health checks that are associated with the current Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckCountInput {}
impl std::fmt::Debug for GetHealthCheckCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckCountInput");
        formatter.finish()
    }
}

/// <p>A request to get information about a specified health check. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetHealthCheckInput {
    /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set,
    /// you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
    pub health_check_id: std::option::Option<std::string::String>,
}
impl GetHealthCheckInput {
    /// <p>The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a resource record set,
    /// you use this value to specify which health check to use. The value can be up to 64 characters long.</p>
    pub fn health_check_id(&self) -> std::option::Option<&str> {
        self.health_check_id.as_deref()
    }
}
impl std::fmt::Debug for GetHealthCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetHealthCheckInput");
        formatter.field("health_check_id", &self.health_check_id);
        formatter.finish()
    }
}

/// <p>A request for information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeoLocationInput {
    /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AF</b>: Africa</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AN</b>: Antarctica</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AS</b>: Asia</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>EU</b>: Europe</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>OC</b>: Oceania</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>NA</b>: North America</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SA</b>: South America</p>
    /// </li>
    /// </ul>
    pub continent_code: std::option::Option<std::string::String>,
    /// <p>Amazon Route 53 uses the two-letter country codes that are specified in
    /// <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
    pub country_code: std::option::Option<std::string::String>,
    /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a>  on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
    pub subdivision_code: std::option::Option<std::string::String>,
}
impl GetGeoLocationInput {
    /// <p>For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Amazon Route 53 supports the following continent codes:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AF</b>: Africa</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AN</b>: Antarctica</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AS</b>: Asia</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>EU</b>: Europe</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>OC</b>: Oceania</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>NA</b>: North America</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>SA</b>: South America</p>
    /// </li>
    /// </ul>
    pub fn continent_code(&self) -> std::option::Option<&str> {
        self.continent_code.as_deref()
    }
    /// <p>Amazon Route 53 uses the two-letter country codes that are specified in
    /// <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.</p>
    pub fn country_code(&self) -> std::option::Option<&str> {
        self.country_code.as_deref()
    }
    /// <p>The code for the subdivision, such as a particular state within the United States. For a list of US state abbreviations, see <a href="https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a>  on the United States Postal Service website. For a list of all supported subdivision codes, use the <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html">ListGeoLocations</a> API.</p>
    pub fn subdivision_code(&self) -> std::option::Option<&str> {
        self.subdivision_code.as_deref()
    }
}
impl std::fmt::Debug for GetGeoLocationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeoLocationInput");
        formatter.field("continent_code", &self.continent_code);
        formatter.field("country_code", &self.country_code);
        formatter.field("subdivision_code", &self.subdivision_code);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDnssecInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl GetDnssecInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for GetDnssecInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDnssecInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}

/// <p>Empty request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCheckerIpRangesInput {}
impl std::fmt::Debug for GetCheckerIpRangesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCheckerIpRangesInput");
        formatter.finish()
    }
}

/// <p>The input for a GetChange request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangeInput {
    /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code>
    /// returned in the <code>Id</code> element when you submitted the request.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetChangeInput {
    /// <p>The ID of the change batch request. The value that you specify here is the value that <code>ChangeResourceRecordSets</code>
    /// returned in the <code>Id</code> element when you submitted the request.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetChangeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangeInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the request to create a hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountLimitInput {
    /// <p>The limit that you want to get. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create
    /// using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create
    /// using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets
    /// that you can create using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies
    /// that you can create using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances
    /// that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the
    /// Amazon Route 53 console.)</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::AccountLimitType>,
}
impl GetAccountLimitInput {
    /// <p>The limit that you want to get. Valid values include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create
    /// using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create
    /// using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets
    /// that you can create using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies
    /// that you can create using the current account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances
    /// that you can create using the current account. (Traffic policy instances are referred to as traffic flow policy records in the
    /// Amazon Route 53 console.)</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AccountLimitType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for GetAccountLimitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountLimitInput");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableHostedZoneDnssecInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl EnableHostedZoneDnssecInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for EnableHostedZoneDnssecInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableHostedZoneDnssecInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the VPC that you want to disassociate from a
/// specified private hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateVpcFromHostedZoneInput {
    /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about the VPC that you're disassociating
    /// from the specified hosted zone.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
    /// <p>
    /// <i>Optional:</i> A comment about the disassociation request.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl DisassociateVpcFromHostedZoneInput {
    /// <p>The ID of the private hosted zone that you want to disassociate a VPC from.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A complex type that contains information about the VPC that you're disassociating
    /// from the specified hosted zone.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
    /// <p>
    /// <i>Optional:</i> A comment about the disassociation request.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for DisassociateVpcFromHostedZoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateVpcFromHostedZoneInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("vpc", &self.vpc);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableHostedZoneDnssecInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl DisableHostedZoneDnssecInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for DisableHostedZoneDnssecInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableHostedZoneDnssecInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the request to remove authorization to associate a VPC
/// that was created by one Amazon Web Services account with a hosted zone that was created with a different Amazon Web Services account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVpcAssociationAuthorizationInput {
    /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
    /// that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
    /// that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
}
impl DeleteVpcAssociationAuthorizationInput {
    /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
    /// that was created with a different Amazon Web Services account, the ID of the hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>When removing authorization to associate a VPC that was created by one Amazon Web Services account with a hosted zone
    /// that was created with a different Amazon Web Services account, a complex type that includes the ID and region of the VPC.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for DeleteVpcAssociationAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVpcAssociationAuthorizationInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}

/// <p>A request to delete a specified traffic policy instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrafficPolicyInstanceInput {
    /// <p>The ID of the traffic policy instance that you want to delete. </p>
    /// <important>
    /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created
    /// the traffic policy instance.</p>
    /// </important>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteTrafficPolicyInstanceInput {
    /// <p>The ID of the traffic policy instance that you want to delete. </p>
    /// <important>
    /// <p>When you delete a traffic policy instance, Amazon Route 53 also deletes all of the resource record sets that were created when you created
    /// the traffic policy instance.</p>
    /// </important>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteTrafficPolicyInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrafficPolicyInstanceInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>A request to delete a specified traffic policy version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrafficPolicyInput {
    /// <p>The ID of the traffic policy that you want to delete.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The version number of the traffic policy that you want to delete.</p>
    pub version: std::option::Option<i32>,
}
impl DeleteTrafficPolicyInput {
    /// <p>The ID of the traffic policy that you want to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The version number of the traffic policy that you want to delete.</p>
    pub fn version(&self) -> std::option::Option<i32> {
        self.version
    }
}
impl std::fmt::Debug for DeleteTrafficPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrafficPolicyInput");
        formatter.field("id", &self.id);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

/// <p>A request to delete a reusable delegation set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReusableDelegationSetInput {
    /// <p>The ID of the reusable delegation set that you want to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteReusableDelegationSetInput {
    /// <p>The ID of the reusable delegation set that you want to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteReusableDelegationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReusableDelegationSetInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQueryLoggingConfigInput {
    /// <p>The ID of the configuration that you want to delete. </p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteQueryLoggingConfigInput {
    /// <p>The ID of the configuration that you want to delete. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteQueryLoggingConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQueryLoggingConfigInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteKeySigningKeyInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A string used to identify a key-signing key (KSK).</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteKeySigningKeyInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A string used to identify a key-signing key (KSK).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteKeySigningKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteKeySigningKeyInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>A request to delete a hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHostedZoneInput {
    /// <p>The ID of the hosted zone you want to delete.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteHostedZoneInput {
    /// <p>The ID of the hosted zone you want to delete.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteHostedZoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHostedZoneInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>This action deletes a health check.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHealthCheckInput {
    /// <p>The ID of the health check that you want to delete.</p>
    pub health_check_id: std::option::Option<std::string::String>,
}
impl DeleteHealthCheckInput {
    /// <p>The ID of the health check that you want to delete.</p>
    pub fn health_check_id(&self) -> std::option::Option<&str> {
        self.health_check_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteHealthCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHealthCheckInput");
        formatter.field("health_check_id", &self.health_check_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateKeySigningKeyInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A string used to identify a key-signing key (KSK).</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeactivateKeySigningKeyInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A string used to identify a key-signing key (KSK).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeactivateKeySigningKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateKeySigningKeyInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the request to authorize associating a VPC with your private hosted zone.
/// Authorization is only required when a private hosted zone and a VPC were created by using different accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVpcAssociationAuthorizationInput {
    /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating
    /// with your hosted zone.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
}
impl CreateVpcAssociationAuthorizationInput {
    /// <p>The ID of the private hosted zone that you want to authorize associating a VPC with.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A complex type that contains the VPC ID and region for the VPC that you want to authorize associating
    /// with your hosted zone.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
}
impl std::fmt::Debug for CreateVpcAssociationAuthorizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVpcAssociationAuthorizationInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the traffic policy that you want to create a new version for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrafficPolicyVersionInput {
    /// <p>The ID of the traffic policy for which you want to create a new version.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code>
    /// request. For more information about the JSON format, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
    pub document: std::option::Option<std::string::String>,
    /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl CreateTrafficPolicyVersionInput {
    /// <p>The ID of the traffic policy for which you want to create a new version.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The definition of this version of the traffic policy, in JSON format. You specified the JSON in the <code>CreateTrafficPolicyVersion</code>
    /// request. For more information about the JSON format, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html">CreateTrafficPolicy</a>.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
    /// <p>The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for CreateTrafficPolicyVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrafficPolicyVersionInput");
        formatter.field("id", &self.id);
        formatter.field("document", &self.document);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the resource record sets that you want to create based on a specified traffic policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrafficPolicyInstanceInput {
    /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using
    /// the resource record sets that Route 53 creates for this traffic policy instance.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
    pub ttl: std::option::Option<i64>,
    /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
    pub traffic_policy_id: std::option::Option<std::string::String>,
    /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
    pub traffic_policy_version: std::option::Option<i32>,
}
impl CreateTrafficPolicyInstanceInput {
    /// <p>The ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The domain name (such as example.com) or subdomain name (such as www.example.com) for which Amazon Route 53 responds to DNS queries by using
    /// the resource record sets that Route 53 creates for this traffic policy instance.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>(Optional) The TTL that you want Amazon Route 53 to assign to all of the resource record sets that it creates in the specified hosted zone.</p>
    pub fn ttl(&self) -> std::option::Option<i64> {
        self.ttl
    }
    /// <p>The ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
    pub fn traffic_policy_id(&self) -> std::option::Option<&str> {
        self.traffic_policy_id.as_deref()
    }
    /// <p>The version of the traffic policy that you want to use to create resource record sets in the specified hosted zone.</p>
    pub fn traffic_policy_version(&self) -> std::option::Option<i32> {
        self.traffic_policy_version
    }
}
impl std::fmt::Debug for CreateTrafficPolicyInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrafficPolicyInstanceInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("name", &self.name);
        formatter.field("ttl", &self.ttl);
        formatter.field("traffic_policy_id", &self.traffic_policy_id);
        formatter.field("traffic_policy_version", &self.traffic_policy_version);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the traffic policy that you want to create.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrafficPolicyInput {
    /// <p>The name of the traffic policy.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The definition of this traffic policy in JSON format. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
    pub document: std::option::Option<std::string::String>,
    /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl CreateTrafficPolicyInput {
    /// <p>The name of the traffic policy.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The definition of this traffic policy in JSON format. For more information, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html">Traffic Policy Document Format</a>.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
    /// <p>(Optional) Any comments that you want to include about the traffic policy.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for CreateTrafficPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrafficPolicyInput");
        formatter.field("name", &self.name);
        formatter.field("document", &self.document);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReusableDelegationSetInput {
    /// <p>A unique string that identifies the request, and that allows you to retry failed
    /// <code>CreateReusableDelegationSet</code> requests without the risk of executing the
    /// operation twice. You must use a unique <code>CallerReference</code> string every time you
    /// submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be
    /// any unique string, for example a date/time stamp.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID
    /// for that hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl CreateReusableDelegationSetInput {
    /// <p>A unique string that identifies the request, and that allows you to retry failed
    /// <code>CreateReusableDelegationSet</code> requests without the risk of executing the
    /// operation twice. You must use a unique <code>CallerReference</code> string every time you
    /// submit a <code>CreateReusableDelegationSet</code> request. <code>CallerReference</code> can be
    /// any unique string, for example a date/time stamp.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>If you want to mark the delegation set for an existing hosted zone as reusable, the ID
    /// for that hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for CreateReusableDelegationSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReusableDelegationSetInput");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateQueryLoggingConfigInput {
    /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format
    /// of the ARN:</p>
    ///
    /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
    /// </p>
    ///
    /// <p>To get the ARN for a log group, you can use the CloudWatch console, the
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action,
    /// the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command,
    /// or the applicable command in one of the Amazon Web Services SDKs.</p>
    pub cloud_watch_logs_log_group_arn: std::option::Option<std::string::String>,
}
impl CreateQueryLoggingConfigInput {
    /// <p>The ID of the hosted zone that you want to log queries for. You can log queries only for public hosted zones.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the log group that you want to Amazon Route 53 to send query logs to. This is the format
    /// of the ARN:</p>
    ///
    /// <p>arn:aws:logs:<i>region</i>:<i>account-id</i>:log-group:<i>log_group_name</i>
    /// </p>
    ///
    /// <p>To get the ARN for a log group, you can use the CloudWatch console, the
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html">DescribeLogGroups</a> API action,
    /// the <a href="https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html">describe-log-groups</a> command,
    /// or the applicable command in one of the Amazon Web Services SDKs.</p>
    pub fn cloud_watch_logs_log_group_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_log_group_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateQueryLoggingConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateQueryLoggingConfigInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field(
            "cloud_watch_logs_log_group_arn",
            &self.cloud_watch_logs_log_group_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateKeySigningKeyInput {
    /// <p>A unique string that identifies the request.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>The unique string (ID) used to identify a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>The Amazon resource name (ARN) for a customer managed customer master key (CMK) in Key Management Service (KMS).
    /// The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.
    /// To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC,
    /// scroll down to <b>Example</b>. </p>
    /// <p>You must configure the customer managed CMK as follows:</p>
    /// <dl>
    /// <dt>Status</dt>
    /// <dd>
    /// <p>Enabled</p>
    /// </dd>
    /// <dt>Key spec</dt>
    /// <dd>
    /// <p>ECC_NIST_P256</p>
    /// </dd>
    /// <dt>Key usage</dt>
    /// <dd>
    /// <p>Sign and verify</p>
    /// </dd>
    /// <dt>Key policy</dt>
    /// <dd>
    /// <p>The key policy must give permission for the following actions:</p>
    /// <ul>
    /// <li>
    /// <p>DescribeKey</p>
    /// </li>
    /// <li>
    /// <p>GetPublicKey</p>
    /// </li>
    /// <li>
    /// <p>Sign</p>
    /// </li>
    /// </ul>
    /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account.
    /// Specify the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"Service": "dnssec-route53.amazonaws.com"</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    /// <p>For more information about working with a customer managed CMK in KMS, see
    /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
    pub key_management_service_arn: std::option::Option<std::string::String>,
    /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
    /// hosted zone.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
    pub status: std::option::Option<std::string::String>,
}
impl CreateKeySigningKeyInput {
    /// <p>A unique string that identifies the request.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>The unique string (ID) used to identify a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>The Amazon resource name (ARN) for a customer managed customer master key (CMK) in Key Management Service (KMS).
    /// The <code>KeyManagementServiceArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.
    /// To see an example of <code>KeyManagementServiceArn</code> that grants the correct permissions for DNSSEC,
    /// scroll down to <b>Example</b>. </p>
    /// <p>You must configure the customer managed CMK as follows:</p>
    /// <dl>
    /// <dt>Status</dt>
    /// <dd>
    /// <p>Enabled</p>
    /// </dd>
    /// <dt>Key spec</dt>
    /// <dd>
    /// <p>ECC_NIST_P256</p>
    /// </dd>
    /// <dt>Key usage</dt>
    /// <dd>
    /// <p>Sign and verify</p>
    /// </dd>
    /// <dt>Key policy</dt>
    /// <dd>
    /// <p>The key policy must give permission for the following actions:</p>
    /// <ul>
    /// <li>
    /// <p>DescribeKey</p>
    /// </li>
    /// <li>
    /// <p>GetPublicKey</p>
    /// </li>
    /// <li>
    /// <p>Sign</p>
    /// </li>
    /// </ul>
    /// <p>The key policy must also include the Amazon Route 53 service in the principal for your account.
    /// Specify the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"Service": "dnssec-route53.amazonaws.com"</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    /// <p>For more information about working with a customer managed CMK in KMS, see
    /// <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.</p>
    pub fn key_management_service_arn(&self) -> std::option::Option<&str> {
        self.key_management_service_arn.as_deref()
    }
    /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
    /// hosted zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A string specifying the initial status of the key-signing key (KSK). You can set the value to <code>ACTIVE</code> or <code>INACTIVE</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for CreateKeySigningKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateKeySigningKeyInput");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field(
            "key_management_service_arn",
            &self.key_management_service_arn,
        );
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the request to create a public or private hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHostedZoneInput {
    /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>.
    /// The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats
    /// <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
    /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name
    /// is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that
    /// <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
    /// <p>You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon VPCs with the hosted zone,
    /// use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a>
    /// after you create a hosted zone.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
    /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without
    /// the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a
    /// <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>(Optional) A complex type that contains the following optional values:</p>
    /// <ul>
    /// <li>
    /// <p>For public and private hosted zones, an optional comment</p>
    /// </li>
    /// <li>
    /// <p>For private hosted zones, an optional <code>PrivateZone</code> element</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and
    /// the other elements.</p>
    pub hosted_zone_config: std::option::Option<crate::model::HostedZoneConfig>,
    /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set
    /// when you created it. For more information about reusable delegation sets, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
    pub delegation_set_id: std::option::Option<std::string::String>,
}
impl CreateHostedZoneInput {
    /// <p>The name of the domain. Specify a fully qualified domain name, for example, <i>www.example.com</i>.
    /// The trailing dot is optional; Amazon Route 53 assumes that the domain name is fully qualified. This means that Route 53 treats
    /// <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
    /// <p>If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your domain name
    /// is registered with a registrar other than Route 53, change the name servers for your domain to the set of <code>NameServers</code> that
    /// <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>(Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating with this hosted zone.</p>
    /// <p>You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon VPCs with the hosted zone,
    /// use <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html">AssociateVPCWithHostedZone</a>
    /// after you create a hosted zone.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
    /// <p>A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be retried without
    /// the risk of executing the operation twice. You must use a unique <code>CallerReference</code> string every time you submit a
    /// <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any unique string, for example, a date/time stamp.</p>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>(Optional) A complex type that contains the following optional values:</p>
    /// <ul>
    /// <li>
    /// <p>For public and private hosted zones, an optional comment</p>
    /// </li>
    /// <li>
    /// <p>For private hosted zones, an optional <code>PrivateZone</code> element</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and
    /// the other elements.</p>
    pub fn hosted_zone_config(&self) -> std::option::Option<&crate::model::HostedZoneConfig> {
        self.hosted_zone_config.as_ref()
    }
    /// <p>If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to the reusable delegation set
    /// when you created it. For more information about reusable delegation sets, see
    /// <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html">CreateReusableDelegationSet</a>.</p>
    pub fn delegation_set_id(&self) -> std::option::Option<&str> {
        self.delegation_set_id.as_deref()
    }
}
impl std::fmt::Debug for CreateHostedZoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHostedZoneInput");
        formatter.field("name", &self.name);
        formatter.field("vpc", &self.vpc);
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("hosted_zone_config", &self.hosted_zone_config);
        formatter.field("delegation_set_id", &self.delegation_set_id);
        formatter.finish()
    }
}

/// <p>A complex type that contains the health check request information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHealthCheckInput {
    /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request
    /// without the risk of creating two identical health checks:</p>
    /// <ul>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings
    /// as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist,
    /// Route 53 returns the settings for the existing health check.</p>
    /// </li>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check,
    /// regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
    /// </li>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check
    /// but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
    /// </li>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to
    /// an existing health check, Route 53 creates the health check.</p>
    /// </li>
    /// </ul>
    pub caller_reference: std::option::Option<std::string::String>,
    /// <p>A complex type that contains settings for a new health check.</p>
    pub health_check_config: std::option::Option<crate::model::HealthCheckConfig>,
}
impl CreateHealthCheckInput {
    /// <p>A unique string that identifies the request and that allows you to retry a failed <code>CreateHealthCheck</code> request
    /// without the risk of creating two identical health checks:</p>
    /// <ul>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> and settings
    /// as a previous request, and if the health check doesn't exist, Amazon Route 53 creates the health check. If the health check does exist,
    /// Route 53 returns the settings for the existing health check.</p>
    /// </li>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as a deleted health check,
    /// regardless of the settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
    /// </li>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with the same <code>CallerReference</code> as an existing health check
    /// but with different settings, Route 53 returns a <code>HealthCheckAlreadyExists</code> error.</p>
    /// </li>
    /// <li>
    /// <p>If you send a <code>CreateHealthCheck</code> request with a unique <code>CallerReference</code> but settings identical to
    /// an existing health check, Route 53 creates the health check.</p>
    /// </li>
    /// </ul>
    pub fn caller_reference(&self) -> std::option::Option<&str> {
        self.caller_reference.as_deref()
    }
    /// <p>A complex type that contains settings for a new health check.</p>
    pub fn health_check_config(&self) -> std::option::Option<&crate::model::HealthCheckConfig> {
        self.health_check_config.as_ref()
    }
}
impl std::fmt::Debug for CreateHealthCheckInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHealthCheckInput");
        formatter.field("caller_reference", &self.caller_reference);
        formatter.field("health_check_config", &self.health_check_config);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the tags that you want to add, edit, or delete.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeTagsForResourceInput {
    /// <p>The type of the resource.</p>
    /// <ul>
    /// <li>
    /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
    /// </li>
    /// </ul>
    pub resource_type: std::option::Option<crate::model::TagResourceType>,
    /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags
    /// that you want to edit <code>Value</code> for.</p>
    /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
    pub add_tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone.
    /// You can specify up to 10 keys.</p>
    pub remove_tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ChangeTagsForResourceInput {
    /// <p>The type of the resource.</p>
    /// <ul>
    /// <li>
    /// <p>The resource type for health checks is <code>healthcheck</code>.</p>
    /// </li>
    /// <li>
    /// <p>The resource type for hosted zones is <code>hostedzone</code>.</p>
    /// </li>
    /// </ul>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TagResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The ID of the resource for which you want to add, change, or delete tags.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone and/or the tags
    /// that you want to edit <code>Value</code> for.</p>
    /// <p>You can add a maximum of 10 tags to a health check or a hosted zone.</p>
    pub fn add_tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.add_tags.as_deref()
    }
    /// <p>A complex type that contains a list of the tags that you want to delete from the specified health check or hosted zone.
    /// You can specify up to 10 keys.</p>
    pub fn remove_tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.remove_tag_keys.as_deref()
    }
}
impl std::fmt::Debug for ChangeTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeTagsForResourceInput");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("add_tags", &self.add_tags);
        formatter.field("remove_tag_keys", &self.remove_tag_keys);
        formatter.finish()
    }
}

/// <p>A complex type that contains change information for the resource record set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeResourceRecordSetsInput {
    /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
    pub change_batch: std::option::Option<crate::model::ChangeBatch>,
}
impl ChangeResourceRecordSetsInput {
    /// <p>The ID of the hosted zone that contains the resource record sets that you want to change.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A complex type that contains an optional comment and the <code>Changes</code> element.</p>
    pub fn change_batch(&self) -> std::option::Option<&crate::model::ChangeBatch> {
        self.change_batch.as_ref()
    }
}
impl std::fmt::Debug for ChangeResourceRecordSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeResourceRecordSetsInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("change_batch", &self.change_batch);
        formatter.finish()
    }
}

/// <p>A complex type that contains information about the request to associate a VPC with a private hosted zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateVpcWithHostedZoneInput {
    /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
    /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
    pub vpc: std::option::Option<crate::model::Vpc>,
    /// <p>
    /// <i>Optional:</i> A comment about the association request.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl AssociateVpcWithHostedZoneInput {
    /// <p>The ID of the private hosted zone that you want to associate an Amazon VPC with.</p>
    /// <p>Note that you can't associate a VPC with a hosted zone that doesn't have an existing VPC association.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A complex type that contains information about the VPC that you want to associate with a private hosted zone.</p>
    pub fn vpc(&self) -> std::option::Option<&crate::model::Vpc> {
        self.vpc.as_ref()
    }
    /// <p>
    /// <i>Optional:</i> A comment about the association request.</p>
    pub fn comment(&self) -> std::option::Option<&str> {
        self.comment.as_deref()
    }
}
impl std::fmt::Debug for AssociateVpcWithHostedZoneInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateVpcWithHostedZoneInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("vpc", &self.vpc);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateKeySigningKeyInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
    /// hosted zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl ActivateKeySigningKeyInput {
    /// <p>A unique string used to identify a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters,  and underscores (_). <code>Name</code> must be unique for each key-signing key in the same
    /// hosted zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for ActivateKeySigningKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateKeySigningKeyInput");
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
