// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchDeleteWorlds`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_worlds`](crate::client::Client::batch_delete_worlds).
///
/// See [`crate::client::fluent_builders::BatchDeleteWorlds`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteWorlds {
    _private: (),
}
impl BatchDeleteWorlds {
    /// Creates a new builder-style object to manufacture [`BatchDeleteWorldsInput`](crate::input::BatchDeleteWorldsInput)
    pub fn builder() -> crate::input::batch_delete_worlds_input::Builder {
        crate::input::batch_delete_worlds_input::Builder::default()
    }
    /// Creates a new `BatchDeleteWorlds` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteWorlds {
    type Output = std::result::Result<
        crate::output::BatchDeleteWorldsOutput,
        crate::error::BatchDeleteWorldsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_worlds_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_worlds_response(response)
        }
    }
}

/// Operation shape for `BatchDescribeSimulationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_describe_simulation_job`](crate::client::Client::batch_describe_simulation_job).
///
/// See [`crate::client::fluent_builders::BatchDescribeSimulationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDescribeSimulationJob {
    _private: (),
}
impl BatchDescribeSimulationJob {
    /// Creates a new builder-style object to manufacture [`BatchDescribeSimulationJobInput`](crate::input::BatchDescribeSimulationJobInput)
    pub fn builder() -> crate::input::batch_describe_simulation_job_input::Builder {
        crate::input::batch_describe_simulation_job_input::Builder::default()
    }
    /// Creates a new `BatchDescribeSimulationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDescribeSimulationJob {
    type Output = std::result::Result<
        crate::output::BatchDescribeSimulationJobOutput,
        crate::error::BatchDescribeSimulationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_describe_simulation_job_error(response)
        } else {
            crate::operation_deser::parse_batch_describe_simulation_job_response(response)
        }
    }
}

/// Operation shape for `CancelDeploymentJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_deployment_job`](crate::client::Client::cancel_deployment_job).
///
/// See [`crate::client::fluent_builders::CancelDeploymentJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelDeploymentJob {
    _private: (),
}
impl CancelDeploymentJob {
    /// Creates a new builder-style object to manufacture [`CancelDeploymentJobInput`](crate::input::CancelDeploymentJobInput)
    pub fn builder() -> crate::input::cancel_deployment_job_input::Builder {
        crate::input::cancel_deployment_job_input::Builder::default()
    }
    /// Creates a new `CancelDeploymentJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelDeploymentJob {
    type Output = std::result::Result<
        crate::output::CancelDeploymentJobOutput,
        crate::error::CancelDeploymentJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_deployment_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_deployment_job_response(response)
        }
    }
}

/// Operation shape for `CancelSimulationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_simulation_job`](crate::client::Client::cancel_simulation_job).
///
/// See [`crate::client::fluent_builders::CancelSimulationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelSimulationJob {
    _private: (),
}
impl CancelSimulationJob {
    /// Creates a new builder-style object to manufacture [`CancelSimulationJobInput`](crate::input::CancelSimulationJobInput)
    pub fn builder() -> crate::input::cancel_simulation_job_input::Builder {
        crate::input::cancel_simulation_job_input::Builder::default()
    }
    /// Creates a new `CancelSimulationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelSimulationJob {
    type Output = std::result::Result<
        crate::output::CancelSimulationJobOutput,
        crate::error::CancelSimulationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_simulation_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_simulation_job_response(response)
        }
    }
}

/// Operation shape for `CancelSimulationJobBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_simulation_job_batch`](crate::client::Client::cancel_simulation_job_batch).
///
/// See [`crate::client::fluent_builders::CancelSimulationJobBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelSimulationJobBatch {
    _private: (),
}
impl CancelSimulationJobBatch {
    /// Creates a new builder-style object to manufacture [`CancelSimulationJobBatchInput`](crate::input::CancelSimulationJobBatchInput)
    pub fn builder() -> crate::input::cancel_simulation_job_batch_input::Builder {
        crate::input::cancel_simulation_job_batch_input::Builder::default()
    }
    /// Creates a new `CancelSimulationJobBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelSimulationJobBatch {
    type Output = std::result::Result<
        crate::output::CancelSimulationJobBatchOutput,
        crate::error::CancelSimulationJobBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_simulation_job_batch_error(response)
        } else {
            crate::operation_deser::parse_cancel_simulation_job_batch_response(response)
        }
    }
}

/// Operation shape for `CancelWorldExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_world_export_job`](crate::client::Client::cancel_world_export_job).
///
/// See [`crate::client::fluent_builders::CancelWorldExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelWorldExportJob {
    _private: (),
}
impl CancelWorldExportJob {
    /// Creates a new builder-style object to manufacture [`CancelWorldExportJobInput`](crate::input::CancelWorldExportJobInput)
    pub fn builder() -> crate::input::cancel_world_export_job_input::Builder {
        crate::input::cancel_world_export_job_input::Builder::default()
    }
    /// Creates a new `CancelWorldExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelWorldExportJob {
    type Output = std::result::Result<
        crate::output::CancelWorldExportJobOutput,
        crate::error::CancelWorldExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_world_export_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_world_export_job_response(response)
        }
    }
}

/// Operation shape for `CancelWorldGenerationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_world_generation_job`](crate::client::Client::cancel_world_generation_job).
///
/// See [`crate::client::fluent_builders::CancelWorldGenerationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelWorldGenerationJob {
    _private: (),
}
impl CancelWorldGenerationJob {
    /// Creates a new builder-style object to manufacture [`CancelWorldGenerationJobInput`](crate::input::CancelWorldGenerationJobInput)
    pub fn builder() -> crate::input::cancel_world_generation_job_input::Builder {
        crate::input::cancel_world_generation_job_input::Builder::default()
    }
    /// Creates a new `CancelWorldGenerationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelWorldGenerationJob {
    type Output = std::result::Result<
        crate::output::CancelWorldGenerationJobOutput,
        crate::error::CancelWorldGenerationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_world_generation_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_world_generation_job_response(response)
        }
    }
}

/// Operation shape for `CreateDeploymentJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_deployment_job`](crate::client::Client::create_deployment_job).
///
/// See [`crate::client::fluent_builders::CreateDeploymentJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeploymentJob {
    _private: (),
}
impl CreateDeploymentJob {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentJobInput`](crate::input::CreateDeploymentJobInput)
    pub fn builder() -> crate::input::create_deployment_job_input::Builder {
        crate::input::create_deployment_job_input::Builder::default()
    }
    /// Creates a new `CreateDeploymentJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeploymentJob {
    type Output = std::result::Result<
        crate::output::CreateDeploymentJobOutput,
        crate::error::CreateDeploymentJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_deployment_job_error(response)
        } else {
            crate::operation_deser::parse_create_deployment_job_response(response)
        }
    }
}

/// Operation shape for `CreateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fleet`](crate::client::Client::create_fleet).
///
/// See [`crate::client::fluent_builders::CreateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFleet {
    _private: (),
}
impl CreateFleet {
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
    /// Creates a new `CreateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFleet {
    type Output =
        std::result::Result<crate::output::CreateFleetOutput, crate::error::CreateFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fleet_error(response)
        } else {
            crate::operation_deser::parse_create_fleet_response(response)
        }
    }
}

/// Operation shape for `CreateRobot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_robot`](crate::client::Client::create_robot).
///
/// See [`crate::client::fluent_builders::CreateRobot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRobot {
    _private: (),
}
impl CreateRobot {
    /// Creates a new builder-style object to manufacture [`CreateRobotInput`](crate::input::CreateRobotInput)
    pub fn builder() -> crate::input::create_robot_input::Builder {
        crate::input::create_robot_input::Builder::default()
    }
    /// Creates a new `CreateRobot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRobot {
    type Output =
        std::result::Result<crate::output::CreateRobotOutput, crate::error::CreateRobotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_robot_error(response)
        } else {
            crate::operation_deser::parse_create_robot_response(response)
        }
    }
}

/// Operation shape for `CreateRobotApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_robot_application`](crate::client::Client::create_robot_application).
///
/// See [`crate::client::fluent_builders::CreateRobotApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRobotApplication {
    _private: (),
}
impl CreateRobotApplication {
    /// Creates a new builder-style object to manufacture [`CreateRobotApplicationInput`](crate::input::CreateRobotApplicationInput)
    pub fn builder() -> crate::input::create_robot_application_input::Builder {
        crate::input::create_robot_application_input::Builder::default()
    }
    /// Creates a new `CreateRobotApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRobotApplication {
    type Output = std::result::Result<
        crate::output::CreateRobotApplicationOutput,
        crate::error::CreateRobotApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_robot_application_error(response)
        } else {
            crate::operation_deser::parse_create_robot_application_response(response)
        }
    }
}

/// Operation shape for `CreateRobotApplicationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_robot_application_version`](crate::client::Client::create_robot_application_version).
///
/// See [`crate::client::fluent_builders::CreateRobotApplicationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRobotApplicationVersion {
    _private: (),
}
impl CreateRobotApplicationVersion {
    /// Creates a new builder-style object to manufacture [`CreateRobotApplicationVersionInput`](crate::input::CreateRobotApplicationVersionInput)
    pub fn builder() -> crate::input::create_robot_application_version_input::Builder {
        crate::input::create_robot_application_version_input::Builder::default()
    }
    /// Creates a new `CreateRobotApplicationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRobotApplicationVersion {
    type Output = std::result::Result<
        crate::output::CreateRobotApplicationVersionOutput,
        crate::error::CreateRobotApplicationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_robot_application_version_error(response)
        } else {
            crate::operation_deser::parse_create_robot_application_version_response(response)
        }
    }
}

/// Operation shape for `CreateSimulationApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_simulation_application`](crate::client::Client::create_simulation_application).
///
/// See [`crate::client::fluent_builders::CreateSimulationApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSimulationApplication {
    _private: (),
}
impl CreateSimulationApplication {
    /// Creates a new builder-style object to manufacture [`CreateSimulationApplicationInput`](crate::input::CreateSimulationApplicationInput)
    pub fn builder() -> crate::input::create_simulation_application_input::Builder {
        crate::input::create_simulation_application_input::Builder::default()
    }
    /// Creates a new `CreateSimulationApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSimulationApplication {
    type Output = std::result::Result<
        crate::output::CreateSimulationApplicationOutput,
        crate::error::CreateSimulationApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_simulation_application_error(response)
        } else {
            crate::operation_deser::parse_create_simulation_application_response(response)
        }
    }
}

/// Operation shape for `CreateSimulationApplicationVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_simulation_application_version`](crate::client::Client::create_simulation_application_version).
///
/// See [`crate::client::fluent_builders::CreateSimulationApplicationVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSimulationApplicationVersion {
    _private: (),
}
impl CreateSimulationApplicationVersion {
    /// Creates a new builder-style object to manufacture [`CreateSimulationApplicationVersionInput`](crate::input::CreateSimulationApplicationVersionInput)
    pub fn builder() -> crate::input::create_simulation_application_version_input::Builder {
        crate::input::create_simulation_application_version_input::Builder::default()
    }
    /// Creates a new `CreateSimulationApplicationVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSimulationApplicationVersion {
    type Output = std::result::Result<
        crate::output::CreateSimulationApplicationVersionOutput,
        crate::error::CreateSimulationApplicationVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_simulation_application_version_error(response)
        } else {
            crate::operation_deser::parse_create_simulation_application_version_response(response)
        }
    }
}

/// Operation shape for `CreateSimulationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_simulation_job`](crate::client::Client::create_simulation_job).
///
/// See [`crate::client::fluent_builders::CreateSimulationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSimulationJob {
    _private: (),
}
impl CreateSimulationJob {
    /// Creates a new builder-style object to manufacture [`CreateSimulationJobInput`](crate::input::CreateSimulationJobInput)
    pub fn builder() -> crate::input::create_simulation_job_input::Builder {
        crate::input::create_simulation_job_input::Builder::default()
    }
    /// Creates a new `CreateSimulationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSimulationJob {
    type Output = std::result::Result<
        crate::output::CreateSimulationJobOutput,
        crate::error::CreateSimulationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_simulation_job_error(response)
        } else {
            crate::operation_deser::parse_create_simulation_job_response(response)
        }
    }
}

/// Operation shape for `CreateWorldExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_world_export_job`](crate::client::Client::create_world_export_job).
///
/// See [`crate::client::fluent_builders::CreateWorldExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorldExportJob {
    _private: (),
}
impl CreateWorldExportJob {
    /// Creates a new builder-style object to manufacture [`CreateWorldExportJobInput`](crate::input::CreateWorldExportJobInput)
    pub fn builder() -> crate::input::create_world_export_job_input::Builder {
        crate::input::create_world_export_job_input::Builder::default()
    }
    /// Creates a new `CreateWorldExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorldExportJob {
    type Output = std::result::Result<
        crate::output::CreateWorldExportJobOutput,
        crate::error::CreateWorldExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_world_export_job_error(response)
        } else {
            crate::operation_deser::parse_create_world_export_job_response(response)
        }
    }
}

/// Operation shape for `CreateWorldGenerationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_world_generation_job`](crate::client::Client::create_world_generation_job).
///
/// See [`crate::client::fluent_builders::CreateWorldGenerationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorldGenerationJob {
    _private: (),
}
impl CreateWorldGenerationJob {
    /// Creates a new builder-style object to manufacture [`CreateWorldGenerationJobInput`](crate::input::CreateWorldGenerationJobInput)
    pub fn builder() -> crate::input::create_world_generation_job_input::Builder {
        crate::input::create_world_generation_job_input::Builder::default()
    }
    /// Creates a new `CreateWorldGenerationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorldGenerationJob {
    type Output = std::result::Result<
        crate::output::CreateWorldGenerationJobOutput,
        crate::error::CreateWorldGenerationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_world_generation_job_error(response)
        } else {
            crate::operation_deser::parse_create_world_generation_job_response(response)
        }
    }
}

/// Operation shape for `CreateWorldTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_world_template`](crate::client::Client::create_world_template).
///
/// See [`crate::client::fluent_builders::CreateWorldTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorldTemplate {
    _private: (),
}
impl CreateWorldTemplate {
    /// Creates a new builder-style object to manufacture [`CreateWorldTemplateInput`](crate::input::CreateWorldTemplateInput)
    pub fn builder() -> crate::input::create_world_template_input::Builder {
        crate::input::create_world_template_input::Builder::default()
    }
    /// Creates a new `CreateWorldTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorldTemplate {
    type Output = std::result::Result<
        crate::output::CreateWorldTemplateOutput,
        crate::error::CreateWorldTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_world_template_error(response)
        } else {
            crate::operation_deser::parse_create_world_template_response(response)
        }
    }
}

/// Operation shape for `DeleteFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fleet`](crate::client::Client::delete_fleet).
///
/// See [`crate::client::fluent_builders::DeleteFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFleet {
    _private: (),
}
impl DeleteFleet {
    /// Creates a new builder-style object to manufacture [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    pub fn builder() -> crate::input::delete_fleet_input::Builder {
        crate::input::delete_fleet_input::Builder::default()
    }
    /// Creates a new `DeleteFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFleet {
    type Output =
        std::result::Result<crate::output::DeleteFleetOutput, crate::error::DeleteFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fleet_error(response)
        } else {
            crate::operation_deser::parse_delete_fleet_response(response)
        }
    }
}

/// Operation shape for `DeleteRobot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_robot`](crate::client::Client::delete_robot).
///
/// See [`crate::client::fluent_builders::DeleteRobot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRobot {
    _private: (),
}
impl DeleteRobot {
    /// Creates a new builder-style object to manufacture [`DeleteRobotInput`](crate::input::DeleteRobotInput)
    pub fn builder() -> crate::input::delete_robot_input::Builder {
        crate::input::delete_robot_input::Builder::default()
    }
    /// Creates a new `DeleteRobot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRobot {
    type Output =
        std::result::Result<crate::output::DeleteRobotOutput, crate::error::DeleteRobotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_robot_error(response)
        } else {
            crate::operation_deser::parse_delete_robot_response(response)
        }
    }
}

/// Operation shape for `DeleteRobotApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_robot_application`](crate::client::Client::delete_robot_application).
///
/// See [`crate::client::fluent_builders::DeleteRobotApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRobotApplication {
    _private: (),
}
impl DeleteRobotApplication {
    /// Creates a new builder-style object to manufacture [`DeleteRobotApplicationInput`](crate::input::DeleteRobotApplicationInput)
    pub fn builder() -> crate::input::delete_robot_application_input::Builder {
        crate::input::delete_robot_application_input::Builder::default()
    }
    /// Creates a new `DeleteRobotApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRobotApplication {
    type Output = std::result::Result<
        crate::output::DeleteRobotApplicationOutput,
        crate::error::DeleteRobotApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_robot_application_error(response)
        } else {
            crate::operation_deser::parse_delete_robot_application_response(response)
        }
    }
}

/// Operation shape for `DeleteSimulationApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_simulation_application`](crate::client::Client::delete_simulation_application).
///
/// See [`crate::client::fluent_builders::DeleteSimulationApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSimulationApplication {
    _private: (),
}
impl DeleteSimulationApplication {
    /// Creates a new builder-style object to manufacture [`DeleteSimulationApplicationInput`](crate::input::DeleteSimulationApplicationInput)
    pub fn builder() -> crate::input::delete_simulation_application_input::Builder {
        crate::input::delete_simulation_application_input::Builder::default()
    }
    /// Creates a new `DeleteSimulationApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSimulationApplication {
    type Output = std::result::Result<
        crate::output::DeleteSimulationApplicationOutput,
        crate::error::DeleteSimulationApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_simulation_application_error(response)
        } else {
            crate::operation_deser::parse_delete_simulation_application_response(response)
        }
    }
}

/// Operation shape for `DeleteWorldTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_world_template`](crate::client::Client::delete_world_template).
///
/// See [`crate::client::fluent_builders::DeleteWorldTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorldTemplate {
    _private: (),
}
impl DeleteWorldTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteWorldTemplateInput`](crate::input::DeleteWorldTemplateInput)
    pub fn builder() -> crate::input::delete_world_template_input::Builder {
        crate::input::delete_world_template_input::Builder::default()
    }
    /// Creates a new `DeleteWorldTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorldTemplate {
    type Output = std::result::Result<
        crate::output::DeleteWorldTemplateOutput,
        crate::error::DeleteWorldTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_world_template_error(response)
        } else {
            crate::operation_deser::parse_delete_world_template_response(response)
        }
    }
}

/// Operation shape for `DeregisterRobot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_robot`](crate::client::Client::deregister_robot).
///
/// See [`crate::client::fluent_builders::DeregisterRobot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterRobot {
    _private: (),
}
impl DeregisterRobot {
    /// Creates a new builder-style object to manufacture [`DeregisterRobotInput`](crate::input::DeregisterRobotInput)
    pub fn builder() -> crate::input::deregister_robot_input::Builder {
        crate::input::deregister_robot_input::Builder::default()
    }
    /// Creates a new `DeregisterRobot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterRobot {
    type Output = std::result::Result<
        crate::output::DeregisterRobotOutput,
        crate::error::DeregisterRobotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_robot_error(response)
        } else {
            crate::operation_deser::parse_deregister_robot_response(response)
        }
    }
}

/// Operation shape for `DescribeDeploymentJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_deployment_job`](crate::client::Client::describe_deployment_job).
///
/// See [`crate::client::fluent_builders::DescribeDeploymentJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDeploymentJob {
    _private: (),
}
impl DescribeDeploymentJob {
    /// Creates a new builder-style object to manufacture [`DescribeDeploymentJobInput`](crate::input::DescribeDeploymentJobInput)
    pub fn builder() -> crate::input::describe_deployment_job_input::Builder {
        crate::input::describe_deployment_job_input::Builder::default()
    }
    /// Creates a new `DescribeDeploymentJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDeploymentJob {
    type Output = std::result::Result<
        crate::output::DescribeDeploymentJobOutput,
        crate::error::DescribeDeploymentJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_deployment_job_error(response)
        } else {
            crate::operation_deser::parse_describe_deployment_job_response(response)
        }
    }
}

/// Operation shape for `DescribeFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleet`](crate::client::Client::describe_fleet).
///
/// See [`crate::client::fluent_builders::DescribeFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleet {
    _private: (),
}
impl DescribeFleet {
    /// Creates a new builder-style object to manufacture [`DescribeFleetInput`](crate::input::DescribeFleetInput)
    pub fn builder() -> crate::input::describe_fleet_input::Builder {
        crate::input::describe_fleet_input::Builder::default()
    }
    /// Creates a new `DescribeFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleet {
    type Output =
        std::result::Result<crate::output::DescribeFleetOutput, crate::error::DescribeFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleet_error(response)
        } else {
            crate::operation_deser::parse_describe_fleet_response(response)
        }
    }
}

/// Operation shape for `DescribeRobot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_robot`](crate::client::Client::describe_robot).
///
/// See [`crate::client::fluent_builders::DescribeRobot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRobot {
    _private: (),
}
impl DescribeRobot {
    /// Creates a new builder-style object to manufacture [`DescribeRobotInput`](crate::input::DescribeRobotInput)
    pub fn builder() -> crate::input::describe_robot_input::Builder {
        crate::input::describe_robot_input::Builder::default()
    }
    /// Creates a new `DescribeRobot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRobot {
    type Output =
        std::result::Result<crate::output::DescribeRobotOutput, crate::error::DescribeRobotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_robot_error(response)
        } else {
            crate::operation_deser::parse_describe_robot_response(response)
        }
    }
}

/// Operation shape for `DescribeRobotApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_robot_application`](crate::client::Client::describe_robot_application).
///
/// See [`crate::client::fluent_builders::DescribeRobotApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRobotApplication {
    _private: (),
}
impl DescribeRobotApplication {
    /// Creates a new builder-style object to manufacture [`DescribeRobotApplicationInput`](crate::input::DescribeRobotApplicationInput)
    pub fn builder() -> crate::input::describe_robot_application_input::Builder {
        crate::input::describe_robot_application_input::Builder::default()
    }
    /// Creates a new `DescribeRobotApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRobotApplication {
    type Output = std::result::Result<
        crate::output::DescribeRobotApplicationOutput,
        crate::error::DescribeRobotApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_robot_application_error(response)
        } else {
            crate::operation_deser::parse_describe_robot_application_response(response)
        }
    }
}

/// Operation shape for `DescribeSimulationApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_simulation_application`](crate::client::Client::describe_simulation_application).
///
/// See [`crate::client::fluent_builders::DescribeSimulationApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSimulationApplication {
    _private: (),
}
impl DescribeSimulationApplication {
    /// Creates a new builder-style object to manufacture [`DescribeSimulationApplicationInput`](crate::input::DescribeSimulationApplicationInput)
    pub fn builder() -> crate::input::describe_simulation_application_input::Builder {
        crate::input::describe_simulation_application_input::Builder::default()
    }
    /// Creates a new `DescribeSimulationApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSimulationApplication {
    type Output = std::result::Result<
        crate::output::DescribeSimulationApplicationOutput,
        crate::error::DescribeSimulationApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_simulation_application_error(response)
        } else {
            crate::operation_deser::parse_describe_simulation_application_response(response)
        }
    }
}

/// Operation shape for `DescribeSimulationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_simulation_job`](crate::client::Client::describe_simulation_job).
///
/// See [`crate::client::fluent_builders::DescribeSimulationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSimulationJob {
    _private: (),
}
impl DescribeSimulationJob {
    /// Creates a new builder-style object to manufacture [`DescribeSimulationJobInput`](crate::input::DescribeSimulationJobInput)
    pub fn builder() -> crate::input::describe_simulation_job_input::Builder {
        crate::input::describe_simulation_job_input::Builder::default()
    }
    /// Creates a new `DescribeSimulationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSimulationJob {
    type Output = std::result::Result<
        crate::output::DescribeSimulationJobOutput,
        crate::error::DescribeSimulationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_simulation_job_error(response)
        } else {
            crate::operation_deser::parse_describe_simulation_job_response(response)
        }
    }
}

/// Operation shape for `DescribeSimulationJobBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_simulation_job_batch`](crate::client::Client::describe_simulation_job_batch).
///
/// See [`crate::client::fluent_builders::DescribeSimulationJobBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSimulationJobBatch {
    _private: (),
}
impl DescribeSimulationJobBatch {
    /// Creates a new builder-style object to manufacture [`DescribeSimulationJobBatchInput`](crate::input::DescribeSimulationJobBatchInput)
    pub fn builder() -> crate::input::describe_simulation_job_batch_input::Builder {
        crate::input::describe_simulation_job_batch_input::Builder::default()
    }
    /// Creates a new `DescribeSimulationJobBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSimulationJobBatch {
    type Output = std::result::Result<
        crate::output::DescribeSimulationJobBatchOutput,
        crate::error::DescribeSimulationJobBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_simulation_job_batch_error(response)
        } else {
            crate::operation_deser::parse_describe_simulation_job_batch_response(response)
        }
    }
}

/// Operation shape for `DescribeWorld`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_world`](crate::client::Client::describe_world).
///
/// See [`crate::client::fluent_builders::DescribeWorld`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorld {
    _private: (),
}
impl DescribeWorld {
    /// Creates a new builder-style object to manufacture [`DescribeWorldInput`](crate::input::DescribeWorldInput)
    pub fn builder() -> crate::input::describe_world_input::Builder {
        crate::input::describe_world_input::Builder::default()
    }
    /// Creates a new `DescribeWorld` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorld {
    type Output =
        std::result::Result<crate::output::DescribeWorldOutput, crate::error::DescribeWorldError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_world_error(response)
        } else {
            crate::operation_deser::parse_describe_world_response(response)
        }
    }
}

/// Operation shape for `DescribeWorldExportJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_world_export_job`](crate::client::Client::describe_world_export_job).
///
/// See [`crate::client::fluent_builders::DescribeWorldExportJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorldExportJob {
    _private: (),
}
impl DescribeWorldExportJob {
    /// Creates a new builder-style object to manufacture [`DescribeWorldExportJobInput`](crate::input::DescribeWorldExportJobInput)
    pub fn builder() -> crate::input::describe_world_export_job_input::Builder {
        crate::input::describe_world_export_job_input::Builder::default()
    }
    /// Creates a new `DescribeWorldExportJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorldExportJob {
    type Output = std::result::Result<
        crate::output::DescribeWorldExportJobOutput,
        crate::error::DescribeWorldExportJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_world_export_job_error(response)
        } else {
            crate::operation_deser::parse_describe_world_export_job_response(response)
        }
    }
}

/// Operation shape for `DescribeWorldGenerationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_world_generation_job`](crate::client::Client::describe_world_generation_job).
///
/// See [`crate::client::fluent_builders::DescribeWorldGenerationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorldGenerationJob {
    _private: (),
}
impl DescribeWorldGenerationJob {
    /// Creates a new builder-style object to manufacture [`DescribeWorldGenerationJobInput`](crate::input::DescribeWorldGenerationJobInput)
    pub fn builder() -> crate::input::describe_world_generation_job_input::Builder {
        crate::input::describe_world_generation_job_input::Builder::default()
    }
    /// Creates a new `DescribeWorldGenerationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorldGenerationJob {
    type Output = std::result::Result<
        crate::output::DescribeWorldGenerationJobOutput,
        crate::error::DescribeWorldGenerationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_world_generation_job_error(response)
        } else {
            crate::operation_deser::parse_describe_world_generation_job_response(response)
        }
    }
}

/// Operation shape for `DescribeWorldTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_world_template`](crate::client::Client::describe_world_template).
///
/// See [`crate::client::fluent_builders::DescribeWorldTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorldTemplate {
    _private: (),
}
impl DescribeWorldTemplate {
    /// Creates a new builder-style object to manufacture [`DescribeWorldTemplateInput`](crate::input::DescribeWorldTemplateInput)
    pub fn builder() -> crate::input::describe_world_template_input::Builder {
        crate::input::describe_world_template_input::Builder::default()
    }
    /// Creates a new `DescribeWorldTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorldTemplate {
    type Output = std::result::Result<
        crate::output::DescribeWorldTemplateOutput,
        crate::error::DescribeWorldTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_world_template_error(response)
        } else {
            crate::operation_deser::parse_describe_world_template_response(response)
        }
    }
}

/// Operation shape for `GetWorldTemplateBody`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_world_template_body`](crate::client::Client::get_world_template_body).
///
/// See [`crate::client::fluent_builders::GetWorldTemplateBody`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorldTemplateBody {
    _private: (),
}
impl GetWorldTemplateBody {
    /// Creates a new builder-style object to manufacture [`GetWorldTemplateBodyInput`](crate::input::GetWorldTemplateBodyInput)
    pub fn builder() -> crate::input::get_world_template_body_input::Builder {
        crate::input::get_world_template_body_input::Builder::default()
    }
    /// Creates a new `GetWorldTemplateBody` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorldTemplateBody {
    type Output = std::result::Result<
        crate::output::GetWorldTemplateBodyOutput,
        crate::error::GetWorldTemplateBodyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_world_template_body_error(response)
        } else {
            crate::operation_deser::parse_get_world_template_body_response(response)
        }
    }
}

/// Operation shape for `ListDeploymentJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_deployment_jobs`](crate::client::Client::list_deployment_jobs).
///
/// See [`crate::client::fluent_builders::ListDeploymentJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeploymentJobs {
    _private: (),
}
impl ListDeploymentJobs {
    /// Creates a new builder-style object to manufacture [`ListDeploymentJobsInput`](crate::input::ListDeploymentJobsInput)
    pub fn builder() -> crate::input::list_deployment_jobs_input::Builder {
        crate::input::list_deployment_jobs_input::Builder::default()
    }
    /// Creates a new `ListDeploymentJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeploymentJobs {
    type Output = std::result::Result<
        crate::output::ListDeploymentJobsOutput,
        crate::error::ListDeploymentJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_deployment_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_deployment_jobs_response(response)
        }
    }
}

/// Operation shape for `ListFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_fleets`](crate::client::Client::list_fleets).
///
/// See [`crate::client::fluent_builders::ListFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFleets {
    _private: (),
}
impl ListFleets {
    /// Creates a new builder-style object to manufacture [`ListFleetsInput`](crate::input::ListFleetsInput)
    pub fn builder() -> crate::input::list_fleets_input::Builder {
        crate::input::list_fleets_input::Builder::default()
    }
    /// Creates a new `ListFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFleets {
    type Output =
        std::result::Result<crate::output::ListFleetsOutput, crate::error::ListFleetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_fleets_error(response)
        } else {
            crate::operation_deser::parse_list_fleets_response(response)
        }
    }
}

/// Operation shape for `ListRobotApplications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_robot_applications`](crate::client::Client::list_robot_applications).
///
/// See [`crate::client::fluent_builders::ListRobotApplications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRobotApplications {
    _private: (),
}
impl ListRobotApplications {
    /// Creates a new builder-style object to manufacture [`ListRobotApplicationsInput`](crate::input::ListRobotApplicationsInput)
    pub fn builder() -> crate::input::list_robot_applications_input::Builder {
        crate::input::list_robot_applications_input::Builder::default()
    }
    /// Creates a new `ListRobotApplications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRobotApplications {
    type Output = std::result::Result<
        crate::output::ListRobotApplicationsOutput,
        crate::error::ListRobotApplicationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_robot_applications_error(response)
        } else {
            crate::operation_deser::parse_list_robot_applications_response(response)
        }
    }
}

/// Operation shape for `ListRobots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_robots`](crate::client::Client::list_robots).
///
/// See [`crate::client::fluent_builders::ListRobots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRobots {
    _private: (),
}
impl ListRobots {
    /// Creates a new builder-style object to manufacture [`ListRobotsInput`](crate::input::ListRobotsInput)
    pub fn builder() -> crate::input::list_robots_input::Builder {
        crate::input::list_robots_input::Builder::default()
    }
    /// Creates a new `ListRobots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRobots {
    type Output =
        std::result::Result<crate::output::ListRobotsOutput, crate::error::ListRobotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_robots_error(response)
        } else {
            crate::operation_deser::parse_list_robots_response(response)
        }
    }
}

/// Operation shape for `ListSimulationApplications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_simulation_applications`](crate::client::Client::list_simulation_applications).
///
/// See [`crate::client::fluent_builders::ListSimulationApplications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSimulationApplications {
    _private: (),
}
impl ListSimulationApplications {
    /// Creates a new builder-style object to manufacture [`ListSimulationApplicationsInput`](crate::input::ListSimulationApplicationsInput)
    pub fn builder() -> crate::input::list_simulation_applications_input::Builder {
        crate::input::list_simulation_applications_input::Builder::default()
    }
    /// Creates a new `ListSimulationApplications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSimulationApplications {
    type Output = std::result::Result<
        crate::output::ListSimulationApplicationsOutput,
        crate::error::ListSimulationApplicationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_simulation_applications_error(response)
        } else {
            crate::operation_deser::parse_list_simulation_applications_response(response)
        }
    }
}

/// Operation shape for `ListSimulationJobBatches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_simulation_job_batches`](crate::client::Client::list_simulation_job_batches).
///
/// See [`crate::client::fluent_builders::ListSimulationJobBatches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSimulationJobBatches {
    _private: (),
}
impl ListSimulationJobBatches {
    /// Creates a new builder-style object to manufacture [`ListSimulationJobBatchesInput`](crate::input::ListSimulationJobBatchesInput)
    pub fn builder() -> crate::input::list_simulation_job_batches_input::Builder {
        crate::input::list_simulation_job_batches_input::Builder::default()
    }
    /// Creates a new `ListSimulationJobBatches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSimulationJobBatches {
    type Output = std::result::Result<
        crate::output::ListSimulationJobBatchesOutput,
        crate::error::ListSimulationJobBatchesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_simulation_job_batches_error(response)
        } else {
            crate::operation_deser::parse_list_simulation_job_batches_response(response)
        }
    }
}

/// Operation shape for `ListSimulationJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_simulation_jobs`](crate::client::Client::list_simulation_jobs).
///
/// See [`crate::client::fluent_builders::ListSimulationJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSimulationJobs {
    _private: (),
}
impl ListSimulationJobs {
    /// Creates a new builder-style object to manufacture [`ListSimulationJobsInput`](crate::input::ListSimulationJobsInput)
    pub fn builder() -> crate::input::list_simulation_jobs_input::Builder {
        crate::input::list_simulation_jobs_input::Builder::default()
    }
    /// Creates a new `ListSimulationJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSimulationJobs {
    type Output = std::result::Result<
        crate::output::ListSimulationJobsOutput,
        crate::error::ListSimulationJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_simulation_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_simulation_jobs_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWorldExportJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_world_export_jobs`](crate::client::Client::list_world_export_jobs).
///
/// See [`crate::client::fluent_builders::ListWorldExportJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorldExportJobs {
    _private: (),
}
impl ListWorldExportJobs {
    /// Creates a new builder-style object to manufacture [`ListWorldExportJobsInput`](crate::input::ListWorldExportJobsInput)
    pub fn builder() -> crate::input::list_world_export_jobs_input::Builder {
        crate::input::list_world_export_jobs_input::Builder::default()
    }
    /// Creates a new `ListWorldExportJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorldExportJobs {
    type Output = std::result::Result<
        crate::output::ListWorldExportJobsOutput,
        crate::error::ListWorldExportJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_world_export_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_world_export_jobs_response(response)
        }
    }
}

/// Operation shape for `ListWorldGenerationJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_world_generation_jobs`](crate::client::Client::list_world_generation_jobs).
///
/// See [`crate::client::fluent_builders::ListWorldGenerationJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorldGenerationJobs {
    _private: (),
}
impl ListWorldGenerationJobs {
    /// Creates a new builder-style object to manufacture [`ListWorldGenerationJobsInput`](crate::input::ListWorldGenerationJobsInput)
    pub fn builder() -> crate::input::list_world_generation_jobs_input::Builder {
        crate::input::list_world_generation_jobs_input::Builder::default()
    }
    /// Creates a new `ListWorldGenerationJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorldGenerationJobs {
    type Output = std::result::Result<
        crate::output::ListWorldGenerationJobsOutput,
        crate::error::ListWorldGenerationJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_world_generation_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_world_generation_jobs_response(response)
        }
    }
}

/// Operation shape for `ListWorlds`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_worlds`](crate::client::Client::list_worlds).
///
/// See [`crate::client::fluent_builders::ListWorlds`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorlds {
    _private: (),
}
impl ListWorlds {
    /// Creates a new builder-style object to manufacture [`ListWorldsInput`](crate::input::ListWorldsInput)
    pub fn builder() -> crate::input::list_worlds_input::Builder {
        crate::input::list_worlds_input::Builder::default()
    }
    /// Creates a new `ListWorlds` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorlds {
    type Output =
        std::result::Result<crate::output::ListWorldsOutput, crate::error::ListWorldsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_worlds_error(response)
        } else {
            crate::operation_deser::parse_list_worlds_response(response)
        }
    }
}

/// Operation shape for `ListWorldTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_world_templates`](crate::client::Client::list_world_templates).
///
/// See [`crate::client::fluent_builders::ListWorldTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorldTemplates {
    _private: (),
}
impl ListWorldTemplates {
    /// Creates a new builder-style object to manufacture [`ListWorldTemplatesInput`](crate::input::ListWorldTemplatesInput)
    pub fn builder() -> crate::input::list_world_templates_input::Builder {
        crate::input::list_world_templates_input::Builder::default()
    }
    /// Creates a new `ListWorldTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorldTemplates {
    type Output = std::result::Result<
        crate::output::ListWorldTemplatesOutput,
        crate::error::ListWorldTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_world_templates_error(response)
        } else {
            crate::operation_deser::parse_list_world_templates_response(response)
        }
    }
}

/// Operation shape for `RegisterRobot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_robot`](crate::client::Client::register_robot).
///
/// See [`crate::client::fluent_builders::RegisterRobot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterRobot {
    _private: (),
}
impl RegisterRobot {
    /// Creates a new builder-style object to manufacture [`RegisterRobotInput`](crate::input::RegisterRobotInput)
    pub fn builder() -> crate::input::register_robot_input::Builder {
        crate::input::register_robot_input::Builder::default()
    }
    /// Creates a new `RegisterRobot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterRobot {
    type Output =
        std::result::Result<crate::output::RegisterRobotOutput, crate::error::RegisterRobotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_robot_error(response)
        } else {
            crate::operation_deser::parse_register_robot_response(response)
        }
    }
}

/// Operation shape for `RestartSimulationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restart_simulation_job`](crate::client::Client::restart_simulation_job).
///
/// See [`crate::client::fluent_builders::RestartSimulationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestartSimulationJob {
    _private: (),
}
impl RestartSimulationJob {
    /// Creates a new builder-style object to manufacture [`RestartSimulationJobInput`](crate::input::RestartSimulationJobInput)
    pub fn builder() -> crate::input::restart_simulation_job_input::Builder {
        crate::input::restart_simulation_job_input::Builder::default()
    }
    /// Creates a new `RestartSimulationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestartSimulationJob {
    type Output = std::result::Result<
        crate::output::RestartSimulationJobOutput,
        crate::error::RestartSimulationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restart_simulation_job_error(response)
        } else {
            crate::operation_deser::parse_restart_simulation_job_response(response)
        }
    }
}

/// Operation shape for `StartSimulationJobBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_simulation_job_batch`](crate::client::Client::start_simulation_job_batch).
///
/// See [`crate::client::fluent_builders::StartSimulationJobBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSimulationJobBatch {
    _private: (),
}
impl StartSimulationJobBatch {
    /// Creates a new builder-style object to manufacture [`StartSimulationJobBatchInput`](crate::input::StartSimulationJobBatchInput)
    pub fn builder() -> crate::input::start_simulation_job_batch_input::Builder {
        crate::input::start_simulation_job_batch_input::Builder::default()
    }
    /// Creates a new `StartSimulationJobBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSimulationJobBatch {
    type Output = std::result::Result<
        crate::output::StartSimulationJobBatchOutput,
        crate::error::StartSimulationJobBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_simulation_job_batch_error(response)
        } else {
            crate::operation_deser::parse_start_simulation_job_batch_response(response)
        }
    }
}

/// Operation shape for `SyncDeploymentJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`sync_deployment_job`](crate::client::Client::sync_deployment_job).
///
/// See [`crate::client::fluent_builders::SyncDeploymentJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SyncDeploymentJob {
    _private: (),
}
impl SyncDeploymentJob {
    /// Creates a new builder-style object to manufacture [`SyncDeploymentJobInput`](crate::input::SyncDeploymentJobInput)
    pub fn builder() -> crate::input::sync_deployment_job_input::Builder {
        crate::input::sync_deployment_job_input::Builder::default()
    }
    /// Creates a new `SyncDeploymentJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SyncDeploymentJob {
    type Output = std::result::Result<
        crate::output::SyncDeploymentJobOutput,
        crate::error::SyncDeploymentJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_sync_deployment_job_error(response)
        } else {
            crate::operation_deser::parse_sync_deployment_job_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateRobotApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_robot_application`](crate::client::Client::update_robot_application).
///
/// See [`crate::client::fluent_builders::UpdateRobotApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRobotApplication {
    _private: (),
}
impl UpdateRobotApplication {
    /// Creates a new builder-style object to manufacture [`UpdateRobotApplicationInput`](crate::input::UpdateRobotApplicationInput)
    pub fn builder() -> crate::input::update_robot_application_input::Builder {
        crate::input::update_robot_application_input::Builder::default()
    }
    /// Creates a new `UpdateRobotApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRobotApplication {
    type Output = std::result::Result<
        crate::output::UpdateRobotApplicationOutput,
        crate::error::UpdateRobotApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_robot_application_error(response)
        } else {
            crate::operation_deser::parse_update_robot_application_response(response)
        }
    }
}

/// Operation shape for `UpdateSimulationApplication`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_simulation_application`](crate::client::Client::update_simulation_application).
///
/// See [`crate::client::fluent_builders::UpdateSimulationApplication`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSimulationApplication {
    _private: (),
}
impl UpdateSimulationApplication {
    /// Creates a new builder-style object to manufacture [`UpdateSimulationApplicationInput`](crate::input::UpdateSimulationApplicationInput)
    pub fn builder() -> crate::input::update_simulation_application_input::Builder {
        crate::input::update_simulation_application_input::Builder::default()
    }
    /// Creates a new `UpdateSimulationApplication` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSimulationApplication {
    type Output = std::result::Result<
        crate::output::UpdateSimulationApplicationOutput,
        crate::error::UpdateSimulationApplicationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_simulation_application_error(response)
        } else {
            crate::operation_deser::parse_update_simulation_application_response(response)
        }
    }
}

/// Operation shape for `UpdateWorldTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_world_template`](crate::client::Client::update_world_template).
///
/// See [`crate::client::fluent_builders::UpdateWorldTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorldTemplate {
    _private: (),
}
impl UpdateWorldTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateWorldTemplateInput`](crate::input::UpdateWorldTemplateInput)
    pub fn builder() -> crate::input::update_world_template_input::Builder {
        crate::input::update_world_template_input::Builder::default()
    }
    /// Creates a new `UpdateWorldTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorldTemplate {
    type Output = std::result::Result<
        crate::output::UpdateWorldTemplateOutput,
        crate::error::UpdateWorldTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_world_template_error(response)
        } else {
            crate::operation_deser::parse_update_world_template_response(response)
        }
    }
}
