// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a template location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateLocation {
    /// <p>The Amazon S3 bucket name.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The list of S3 keys identifying the data source files.</p>
    pub s3_key: std::option::Option<std::string::String>,
}
impl TemplateLocation {
    /// <p>The Amazon S3 bucket name.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The list of S3 keys identifying the data source files.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
}
impl std::fmt::Debug for TemplateLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateLocation");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.finish()
    }
}
/// See [`TemplateLocation`](crate::model::TemplateLocation)
pub mod template_location {
    /// A builder for [`TemplateLocation`](crate::model::TemplateLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket name.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The list of S3 keys identifying the data source files.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The list of S3 keys identifying the data source files.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateLocation`](crate::model::TemplateLocation)
        pub fn build(self) -> crate::model::TemplateLocation {
            crate::model::TemplateLocation {
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
            }
        }
    }
}
impl TemplateLocation {
    /// Creates a new builder-style object to manufacture [`TemplateLocation`](crate::model::TemplateLocation)
    pub fn builder() -> crate::model::template_location::Builder {
        crate::model::template_location::Builder::default()
    }
}

/// <p>The object that contains the Docker image URI for either your robot or simulation applications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Environment {
    /// <p>The Docker image URI for either your robot or simulation applications.</p>
    pub uri: std::option::Option<std::string::String>,
}
impl Environment {
    /// <p>The Docker image URI for either your robot or simulation applications.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
}
impl std::fmt::Debug for Environment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Environment");
        formatter.field("uri", &self.uri);
        formatter.finish()
    }
}
/// See [`Environment`](crate::model::Environment)
pub mod environment {
    /// A builder for [`Environment`](crate::model::Environment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Docker image URI for either your robot or simulation applications.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The Docker image URI for either your robot or simulation applications.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// Consumes the builder and constructs a [`Environment`](crate::model::Environment)
        pub fn build(self) -> crate::model::Environment {
            crate::model::Environment { uri: self.uri }
        }
    }
}
impl Environment {
    /// Creates a new builder-style object to manufacture [`Environment`](crate::model::Environment)
    pub fn builder() -> crate::model::environment::Builder {
        crate::model::environment::Builder::default()
    }
}

/// <p>Information about a rendering engine.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenderingEngine {
    /// <p>The name of the rendering engine.</p>
    pub name: std::option::Option<crate::model::RenderingEngineType>,
    /// <p>The version of the rendering engine.</p>
    pub version: std::option::Option<std::string::String>,
}
impl RenderingEngine {
    /// <p>The name of the rendering engine.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::RenderingEngineType> {
        self.name.as_ref()
    }
    /// <p>The version of the rendering engine.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for RenderingEngine {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenderingEngine");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`RenderingEngine`](crate::model::RenderingEngine)
pub mod rendering_engine {
    /// A builder for [`RenderingEngine`](crate::model::RenderingEngine)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::RenderingEngineType>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rendering engine.</p>
        pub fn name(mut self, input: crate::model::RenderingEngineType) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the rendering engine.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::RenderingEngineType>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the rendering engine.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the rendering engine.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`RenderingEngine`](crate::model::RenderingEngine)
        pub fn build(self) -> crate::model::RenderingEngine {
            crate::model::RenderingEngine {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl RenderingEngine {
    /// Creates a new builder-style object to manufacture [`RenderingEngine`](crate::model::RenderingEngine)
    pub fn builder() -> crate::model::rendering_engine::Builder {
        crate::model::rendering_engine::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RenderingEngineType {
    #[allow(missing_docs)] // documentation missing in model
    Ogre,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RenderingEngineType {
    fn from(s: &str) -> Self {
        match s {
            "OGRE" => RenderingEngineType::Ogre,
            other => RenderingEngineType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RenderingEngineType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RenderingEngineType::from(s))
    }
}
impl RenderingEngineType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RenderingEngineType::Ogre => "OGRE",
            RenderingEngineType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OGRE"]
    }
}
impl AsRef<str> for RenderingEngineType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a robot software suite (ROS distribution).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RobotSoftwareSuite {
    /// <p>The name of the robot software suite (ROS distribution).</p>
    pub name: std::option::Option<crate::model::RobotSoftwareSuiteType>,
    /// <p>The version of the robot software suite (ROS distribution).</p>
    pub version: std::option::Option<crate::model::RobotSoftwareSuiteVersionType>,
}
impl RobotSoftwareSuite {
    /// <p>The name of the robot software suite (ROS distribution).</p>
    pub fn name(&self) -> std::option::Option<&crate::model::RobotSoftwareSuiteType> {
        self.name.as_ref()
    }
    /// <p>The version of the robot software suite (ROS distribution).</p>
    pub fn version(&self) -> std::option::Option<&crate::model::RobotSoftwareSuiteVersionType> {
        self.version.as_ref()
    }
}
impl std::fmt::Debug for RobotSoftwareSuite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RobotSoftwareSuite");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`RobotSoftwareSuite`](crate::model::RobotSoftwareSuite)
pub mod robot_software_suite {
    /// A builder for [`RobotSoftwareSuite`](crate::model::RobotSoftwareSuite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::RobotSoftwareSuiteType>,
        pub(crate) version: std::option::Option<crate::model::RobotSoftwareSuiteVersionType>,
    }
    impl Builder {
        /// <p>The name of the robot software suite (ROS distribution).</p>
        pub fn name(mut self, input: crate::model::RobotSoftwareSuiteType) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the robot software suite (ROS distribution).</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuiteType>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the robot software suite (ROS distribution).</p>
        pub fn version(mut self, input: crate::model::RobotSoftwareSuiteVersionType) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version of the robot software suite (ROS distribution).</p>
        pub fn set_version(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuiteVersionType>,
        ) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`RobotSoftwareSuite`](crate::model::RobotSoftwareSuite)
        pub fn build(self) -> crate::model::RobotSoftwareSuite {
            crate::model::RobotSoftwareSuite {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl RobotSoftwareSuite {
    /// Creates a new builder-style object to manufacture [`RobotSoftwareSuite`](crate::model::RobotSoftwareSuite)
    pub fn builder() -> crate::model::robot_software_suite::Builder {
        crate::model::robot_software_suite::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RobotSoftwareSuiteVersionType {
    #[allow(missing_docs)] // documentation missing in model
    Dashing,
    #[allow(missing_docs)] // documentation missing in model
    Foxy,
    #[allow(missing_docs)] // documentation missing in model
    Kinetic,
    #[allow(missing_docs)] // documentation missing in model
    Melodic,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RobotSoftwareSuiteVersionType {
    fn from(s: &str) -> Self {
        match s {
            "Dashing" => RobotSoftwareSuiteVersionType::Dashing,
            "Foxy" => RobotSoftwareSuiteVersionType::Foxy,
            "Kinetic" => RobotSoftwareSuiteVersionType::Kinetic,
            "Melodic" => RobotSoftwareSuiteVersionType::Melodic,
            other => RobotSoftwareSuiteVersionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RobotSoftwareSuiteVersionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RobotSoftwareSuiteVersionType::from(s))
    }
}
impl RobotSoftwareSuiteVersionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RobotSoftwareSuiteVersionType::Dashing => "Dashing",
            RobotSoftwareSuiteVersionType::Foxy => "Foxy",
            RobotSoftwareSuiteVersionType::Kinetic => "Kinetic",
            RobotSoftwareSuiteVersionType::Melodic => "Melodic",
            RobotSoftwareSuiteVersionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Dashing", "Foxy", "Kinetic", "Melodic"]
    }
}
impl AsRef<str> for RobotSoftwareSuiteVersionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RobotSoftwareSuiteType {
    #[allow(missing_docs)] // documentation missing in model
    General,
    #[allow(missing_docs)] // documentation missing in model
    Ros,
    #[allow(missing_docs)] // documentation missing in model
    Ros2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RobotSoftwareSuiteType {
    fn from(s: &str) -> Self {
        match s {
            "General" => RobotSoftwareSuiteType::General,
            "ROS" => RobotSoftwareSuiteType::Ros,
            "ROS2" => RobotSoftwareSuiteType::Ros2,
            other => RobotSoftwareSuiteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RobotSoftwareSuiteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RobotSoftwareSuiteType::from(s))
    }
}
impl RobotSoftwareSuiteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RobotSoftwareSuiteType::General => "General",
            RobotSoftwareSuiteType::Ros => "ROS",
            RobotSoftwareSuiteType::Ros2 => "ROS2",
            RobotSoftwareSuiteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["General", "ROS", "ROS2"]
    }
}
impl AsRef<str> for RobotSoftwareSuiteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a simulation software suite.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulationSoftwareSuite {
    /// <p>The name of the simulation software suite.</p>
    pub name: std::option::Option<crate::model::SimulationSoftwareSuiteType>,
    /// <p>The version of the simulation software suite.</p>
    pub version: std::option::Option<std::string::String>,
}
impl SimulationSoftwareSuite {
    /// <p>The name of the simulation software suite.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::SimulationSoftwareSuiteType> {
        self.name.as_ref()
    }
    /// <p>The version of the simulation software suite.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for SimulationSoftwareSuite {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulationSoftwareSuite");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`SimulationSoftwareSuite`](crate::model::SimulationSoftwareSuite)
pub mod simulation_software_suite {
    /// A builder for [`SimulationSoftwareSuite`](crate::model::SimulationSoftwareSuite)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SimulationSoftwareSuiteType>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the simulation software suite.</p>
        pub fn name(mut self, input: crate::model::SimulationSoftwareSuiteType) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the simulation software suite.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuiteType>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the simulation software suite.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the simulation software suite.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulationSoftwareSuite`](crate::model::SimulationSoftwareSuite)
        pub fn build(self) -> crate::model::SimulationSoftwareSuite {
            crate::model::SimulationSoftwareSuite {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl SimulationSoftwareSuite {
    /// Creates a new builder-style object to manufacture [`SimulationSoftwareSuite`](crate::model::SimulationSoftwareSuite)
    pub fn builder() -> crate::model::simulation_software_suite::Builder {
        crate::model::simulation_software_suite::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SimulationSoftwareSuiteType {
    #[allow(missing_docs)] // documentation missing in model
    Gazebo,
    #[allow(missing_docs)] // documentation missing in model
    RosbagPlay,
    #[allow(missing_docs)] // documentation missing in model
    SimulationRuntime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SimulationSoftwareSuiteType {
    fn from(s: &str) -> Self {
        match s {
            "Gazebo" => SimulationSoftwareSuiteType::Gazebo,
            "RosbagPlay" => SimulationSoftwareSuiteType::RosbagPlay,
            "SimulationRuntime" => SimulationSoftwareSuiteType::SimulationRuntime,
            other => SimulationSoftwareSuiteType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SimulationSoftwareSuiteType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SimulationSoftwareSuiteType::from(s))
    }
}
impl SimulationSoftwareSuiteType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SimulationSoftwareSuiteType::Gazebo => "Gazebo",
            SimulationSoftwareSuiteType::RosbagPlay => "RosbagPlay",
            SimulationSoftwareSuiteType::SimulationRuntime => "SimulationRuntime",
            SimulationSoftwareSuiteType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Gazebo", "RosbagPlay", "SimulationRuntime"]
    }
}
impl AsRef<str> for SimulationSoftwareSuiteType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Source {
    /// <p>The s3 bucket name.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The s3 object key.</p>
    pub s3_key: std::option::Option<std::string::String>,
    /// <p>A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.</p>
    pub etag: std::option::Option<std::string::String>,
    /// <p>The taget processor architecture for the application.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
}
impl Source {
    /// <p>The s3 bucket name.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The s3 object key.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
    /// <p>A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.</p>
    pub fn etag(&self) -> std::option::Option<&str> {
        self.etag.as_deref()
    }
    /// <p>The taget processor architecture for the application.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
}
impl std::fmt::Debug for Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Source");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.field("etag", &self.etag);
        formatter.field("architecture", &self.architecture);
        formatter.finish()
    }
}
/// See [`Source`](crate::model::Source)
pub mod source {
    /// A builder for [`Source`](crate::model::Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
        pub(crate) etag: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
    }
    impl Builder {
        /// <p>The s3 bucket name.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The s3 bucket name.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The s3 object key.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The s3 object key.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// <p>A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.</p>
        pub fn etag(mut self, input: impl Into<std::string::String>) -> Self {
            self.etag = Some(input.into());
            self
        }
        /// <p>A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.</p>
        pub fn set_etag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.etag = input;
            self
        }
        /// <p>The taget processor architecture for the application.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The taget processor architecture for the application.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// Consumes the builder and constructs a [`Source`](crate::model::Source)
        pub fn build(self) -> crate::model::Source {
            crate::model::Source {
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
                etag: self.etag,
                architecture: self.architecture,
            }
        }
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::model::Source)
    pub fn builder() -> crate::model::source::Builder {
        crate::model::source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Architecture {
    #[allow(missing_docs)] // documentation missing in model
    Arm64,
    #[allow(missing_docs)] // documentation missing in model
    Armhf,
    #[allow(missing_docs)] // documentation missing in model
    X8664,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Architecture {
    fn from(s: &str) -> Self {
        match s {
            "ARM64" => Architecture::Arm64,
            "ARMHF" => Architecture::Armhf,
            "X86_64" => Architecture::X8664,
            other => Architecture::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Architecture {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Architecture::from(s))
    }
}
impl Architecture {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Architecture::Arm64 => "ARM64",
            Architecture::Armhf => "ARMHF",
            Architecture::X8664 => "X86_64",
            Architecture::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARM64", "ARMHF", "X86_64"]
    }
}
impl AsRef<str> for Architecture {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a source configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceConfig {
    /// <p>The Amazon S3 bucket name.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The s3 object key.</p>
    pub s3_key: std::option::Option<std::string::String>,
    /// <p>The target processor architecture for the application.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
}
impl SourceConfig {
    /// <p>The Amazon S3 bucket name.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The s3 object key.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
    /// <p>The target processor architecture for the application.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
}
impl std::fmt::Debug for SourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceConfig");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.field("architecture", &self.architecture);
        formatter.finish()
    }
}
/// See [`SourceConfig`](crate::model::SourceConfig)
pub mod source_config {
    /// A builder for [`SourceConfig`](crate::model::SourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket name.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The s3 object key.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The s3 object key.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// <p>The target processor architecture for the application.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The target processor architecture for the application.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceConfig`](crate::model::SourceConfig)
        pub fn build(self) -> crate::model::SourceConfig {
            crate::model::SourceConfig {
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
                architecture: self.architecture,
            }
        }
    }
}
impl SourceConfig {
    /// Creates a new builder-style object to manufacture [`SourceConfig`](crate::model::SourceConfig)
    pub fn builder() -> crate::model::source_config::Builder {
        crate::model::source_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentJobErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    BadLambdaAssociated,
    #[allow(missing_docs)] // documentation missing in model
    BadPermissionError,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentFleetDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    DownloadConditionFailed,
    #[allow(missing_docs)] // documentation missing in model
    EnvironmentSetupError,
    #[allow(missing_docs)] // documentation missing in model
    EtagMismatch,
    #[allow(missing_docs)] // documentation missing in model
    ExtractingBundleFailure,
    #[allow(missing_docs)] // documentation missing in model
    FailureThresholdBreached,
    #[allow(missing_docs)] // documentation missing in model
    FleetDeploymentTimeout,
    #[allow(missing_docs)] // documentation missing in model
    GreengrassDeploymentFailed,
    #[allow(missing_docs)] // documentation missing in model
    GreengrassGroupVersionDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    InternalServerError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidGreengrassGroup,
    #[allow(missing_docs)] // documentation missing in model
    LambdaDeleted,
    #[allow(missing_docs)] // documentation missing in model
    MissingRobotApplicationArchitecture,
    #[allow(missing_docs)] // documentation missing in model
    MissingRobotArchitecture,
    #[allow(missing_docs)] // documentation missing in model
    MissingRobotDeploymentResource,
    #[allow(missing_docs)] // documentation missing in model
    PostLaunchFileFailure,
    #[allow(missing_docs)] // documentation missing in model
    PreLaunchFileFailure,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    RobotAgentConnectionTimeout,
    #[allow(missing_docs)] // documentation missing in model
    RobotApplicationDoesNotExist,
    #[allow(missing_docs)] // documentation missing in model
    RobotDeploymentAborted,
    #[allow(missing_docs)] // documentation missing in model
    RobotDeploymentNoResponse,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentJobErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "BadLambdaAssociated" => DeploymentJobErrorCode::BadLambdaAssociated,
            "BadPermissionError" => DeploymentJobErrorCode::BadPermissionError,
            "DeploymentFleetDoesNotExist" => DeploymentJobErrorCode::DeploymentFleetDoesNotExist,
            "DownloadConditionFailed" => DeploymentJobErrorCode::DownloadConditionFailed,
            "EnvironmentSetupError" => DeploymentJobErrorCode::EnvironmentSetupError,
            "EtagMismatch" => DeploymentJobErrorCode::EtagMismatch,
            "ExtractingBundleFailure" => DeploymentJobErrorCode::ExtractingBundleFailure,
            "FailureThresholdBreached" => DeploymentJobErrorCode::FailureThresholdBreached,
            "FleetDeploymentTimeout" => DeploymentJobErrorCode::FleetDeploymentTimeout,
            "GreengrassDeploymentFailed" => DeploymentJobErrorCode::GreengrassDeploymentFailed,
            "GreengrassGroupVersionDoesNotExist" => {
                DeploymentJobErrorCode::GreengrassGroupVersionDoesNotExist
            }
            "InternalServerError" => DeploymentJobErrorCode::InternalServerError,
            "InvalidGreengrassGroup" => DeploymentJobErrorCode::InvalidGreengrassGroup,
            "LambdaDeleted" => DeploymentJobErrorCode::LambdaDeleted,
            "MissingRobotApplicationArchitecture" => {
                DeploymentJobErrorCode::MissingRobotApplicationArchitecture
            }
            "MissingRobotArchitecture" => DeploymentJobErrorCode::MissingRobotArchitecture,
            "MissingRobotDeploymentResource" => {
                DeploymentJobErrorCode::MissingRobotDeploymentResource
            }
            "PostLaunchFileFailure" => DeploymentJobErrorCode::PostLaunchFileFailure,
            "PreLaunchFileFailure" => DeploymentJobErrorCode::PreLaunchFileFailure,
            "ResourceNotFound" => DeploymentJobErrorCode::ResourceNotFound,
            "RobotAgentConnectionTimeout" => DeploymentJobErrorCode::RobotAgentConnectionTimeout,
            "RobotApplicationDoesNotExist" => DeploymentJobErrorCode::RobotApplicationDoesNotExist,
            "RobotDeploymentAborted" => DeploymentJobErrorCode::RobotDeploymentAborted,
            "RobotDeploymentNoResponse" => DeploymentJobErrorCode::RobotDeploymentNoResponse,
            other => DeploymentJobErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentJobErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentJobErrorCode::from(s))
    }
}
impl DeploymentJobErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentJobErrorCode::BadLambdaAssociated => "BadLambdaAssociated",
            DeploymentJobErrorCode::BadPermissionError => "BadPermissionError",
            DeploymentJobErrorCode::DeploymentFleetDoesNotExist => "DeploymentFleetDoesNotExist",
            DeploymentJobErrorCode::DownloadConditionFailed => "DownloadConditionFailed",
            DeploymentJobErrorCode::EnvironmentSetupError => "EnvironmentSetupError",
            DeploymentJobErrorCode::EtagMismatch => "EtagMismatch",
            DeploymentJobErrorCode::ExtractingBundleFailure => "ExtractingBundleFailure",
            DeploymentJobErrorCode::FailureThresholdBreached => "FailureThresholdBreached",
            DeploymentJobErrorCode::FleetDeploymentTimeout => "FleetDeploymentTimeout",
            DeploymentJobErrorCode::GreengrassDeploymentFailed => "GreengrassDeploymentFailed",
            DeploymentJobErrorCode::GreengrassGroupVersionDoesNotExist => {
                "GreengrassGroupVersionDoesNotExist"
            }
            DeploymentJobErrorCode::InternalServerError => "InternalServerError",
            DeploymentJobErrorCode::InvalidGreengrassGroup => "InvalidGreengrassGroup",
            DeploymentJobErrorCode::LambdaDeleted => "LambdaDeleted",
            DeploymentJobErrorCode::MissingRobotApplicationArchitecture => {
                "MissingRobotApplicationArchitecture"
            }
            DeploymentJobErrorCode::MissingRobotArchitecture => "MissingRobotArchitecture",
            DeploymentJobErrorCode::MissingRobotDeploymentResource => {
                "MissingRobotDeploymentResource"
            }
            DeploymentJobErrorCode::PostLaunchFileFailure => "PostLaunchFileFailure",
            DeploymentJobErrorCode::PreLaunchFileFailure => "PreLaunchFileFailure",
            DeploymentJobErrorCode::ResourceNotFound => "ResourceNotFound",
            DeploymentJobErrorCode::RobotAgentConnectionTimeout => "RobotAgentConnectionTimeout",
            DeploymentJobErrorCode::RobotApplicationDoesNotExist => "RobotApplicationDoesNotExist",
            DeploymentJobErrorCode::RobotDeploymentAborted => "RobotDeploymentAborted",
            DeploymentJobErrorCode::RobotDeploymentNoResponse => "RobotDeploymentNoResponse",
            DeploymentJobErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BadLambdaAssociated",
            "BadPermissionError",
            "DeploymentFleetDoesNotExist",
            "DownloadConditionFailed",
            "EnvironmentSetupError",
            "EtagMismatch",
            "ExtractingBundleFailure",
            "FailureThresholdBreached",
            "FleetDeploymentTimeout",
            "GreengrassDeploymentFailed",
            "GreengrassGroupVersionDoesNotExist",
            "InternalServerError",
            "InvalidGreengrassGroup",
            "LambdaDeleted",
            "MissingRobotApplicationArchitecture",
            "MissingRobotArchitecture",
            "MissingRobotDeploymentResource",
            "PostLaunchFileFailure",
            "PreLaunchFileFailure",
            "ResourceNotFound",
            "RobotAgentConnectionTimeout",
            "RobotApplicationDoesNotExist",
            "RobotDeploymentAborted",
            "RobotDeploymentNoResponse",
        ]
    }
}
impl AsRef<str> for DeploymentJobErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a deployment application configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentApplicationConfig {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub application_version: std::option::Option<std::string::String>,
    /// <p>The launch configuration.</p>
    pub launch_config: std::option::Option<crate::model::DeploymentLaunchConfig>,
}
impl DeploymentApplicationConfig {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn application_version(&self) -> std::option::Option<&str> {
        self.application_version.as_deref()
    }
    /// <p>The launch configuration.</p>
    pub fn launch_config(&self) -> std::option::Option<&crate::model::DeploymentLaunchConfig> {
        self.launch_config.as_ref()
    }
}
impl std::fmt::Debug for DeploymentApplicationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentApplicationConfig");
        formatter.field("application", &self.application);
        formatter.field("application_version", &self.application_version);
        formatter.field("launch_config", &self.launch_config);
        formatter.finish()
    }
}
/// See [`DeploymentApplicationConfig`](crate::model::DeploymentApplicationConfig)
pub mod deployment_application_config {
    /// A builder for [`DeploymentApplicationConfig`](crate::model::DeploymentApplicationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) application_version: std::option::Option<std::string::String>,
        pub(crate) launch_config: std::option::Option<crate::model::DeploymentLaunchConfig>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// <p>The launch configuration.</p>
        pub fn launch_config(mut self, input: crate::model::DeploymentLaunchConfig) -> Self {
            self.launch_config = Some(input);
            self
        }
        /// <p>The launch configuration.</p>
        pub fn set_launch_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentLaunchConfig>,
        ) -> Self {
            self.launch_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentApplicationConfig`](crate::model::DeploymentApplicationConfig)
        pub fn build(self) -> crate::model::DeploymentApplicationConfig {
            crate::model::DeploymentApplicationConfig {
                application: self.application,
                application_version: self.application_version,
                launch_config: self.launch_config,
            }
        }
    }
}
impl DeploymentApplicationConfig {
    /// Creates a new builder-style object to manufacture [`DeploymentApplicationConfig`](crate::model::DeploymentApplicationConfig)
    pub fn builder() -> crate::model::deployment_application_config::Builder {
        crate::model::deployment_application_config::Builder::default()
    }
}

/// <p>Configuration information for a deployment launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentLaunchConfig {
    /// <p>The package name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The deployment pre-launch file. This file will be executed prior to the launch file.</p>
    pub pre_launch_file: std::option::Option<std::string::String>,
    /// <p>The launch file name.</p>
    pub launch_file: std::option::Option<std::string::String>,
    /// <p>The deployment post-launch file. This file will be executed after the launch file.</p>
    pub post_launch_file: std::option::Option<std::string::String>,
    /// <p>An array of key/value pairs specifying environment variables for the robot application</p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DeploymentLaunchConfig {
    /// <p>The package name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The deployment pre-launch file. This file will be executed prior to the launch file.</p>
    pub fn pre_launch_file(&self) -> std::option::Option<&str> {
        self.pre_launch_file.as_deref()
    }
    /// <p>The launch file name.</p>
    pub fn launch_file(&self) -> std::option::Option<&str> {
        self.launch_file.as_deref()
    }
    /// <p>The deployment post-launch file. This file will be executed after the launch file.</p>
    pub fn post_launch_file(&self) -> std::option::Option<&str> {
        self.post_launch_file.as_deref()
    }
    /// <p>An array of key/value pairs specifying environment variables for the robot application</p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
}
impl std::fmt::Debug for DeploymentLaunchConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentLaunchConfig");
        formatter.field("package_name", &self.package_name);
        formatter.field("pre_launch_file", &self.pre_launch_file);
        formatter.field("launch_file", &self.launch_file);
        formatter.field("post_launch_file", &self.post_launch_file);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.finish()
    }
}
/// See [`DeploymentLaunchConfig`](crate::model::DeploymentLaunchConfig)
pub mod deployment_launch_config {
    /// A builder for [`DeploymentLaunchConfig`](crate::model::DeploymentLaunchConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) pre_launch_file: std::option::Option<std::string::String>,
        pub(crate) launch_file: std::option::Option<std::string::String>,
        pub(crate) post_launch_file: std::option::Option<std::string::String>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The package name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The package name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The deployment pre-launch file. This file will be executed prior to the launch file.</p>
        pub fn pre_launch_file(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_launch_file = Some(input.into());
            self
        }
        /// <p>The deployment pre-launch file. This file will be executed prior to the launch file.</p>
        pub fn set_pre_launch_file(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_launch_file = input;
            self
        }
        /// <p>The launch file name.</p>
        pub fn launch_file(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_file = Some(input.into());
            self
        }
        /// <p>The launch file name.</p>
        pub fn set_launch_file(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_file = input;
            self
        }
        /// <p>The deployment post-launch file. This file will be executed after the launch file.</p>
        pub fn post_launch_file(mut self, input: impl Into<std::string::String>) -> Self {
            self.post_launch_file = Some(input.into());
            self
        }
        /// <p>The deployment post-launch file. This file will be executed after the launch file.</p>
        pub fn set_post_launch_file(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.post_launch_file = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p>An array of key/value pairs specifying environment variables for the robot application</p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p>An array of key/value pairs specifying environment variables for the robot application</p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentLaunchConfig`](crate::model::DeploymentLaunchConfig)
        pub fn build(self) -> crate::model::DeploymentLaunchConfig {
            crate::model::DeploymentLaunchConfig {
                package_name: self.package_name,
                pre_launch_file: self.pre_launch_file,
                launch_file: self.launch_file,
                post_launch_file: self.post_launch_file,
                environment_variables: self.environment_variables,
            }
        }
    }
}
impl DeploymentLaunchConfig {
    /// Creates a new builder-style object to manufacture [`DeploymentLaunchConfig`](crate::model::DeploymentLaunchConfig)
    pub fn builder() -> crate::model::deployment_launch_config::Builder {
        crate::model::deployment_launch_config::Builder::default()
    }
}

/// <p>Information about a deployment configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentConfig {
    /// <p>The percentage of robots receiving the deployment at the same time.</p>
    pub concurrent_deployment_percentage: std::option::Option<i32>,
    /// <p>The percentage of deployments that need to fail before stopping deployment.</p>
    pub failure_threshold_percentage: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time between 1 minute and 7 days. The default is 5 hours.</p>
    pub robot_deployment_timeout_in_seconds: std::option::Option<i64>,
    /// <p>The download condition file.</p>
    pub download_condition_file: std::option::Option<crate::model::S3Object>,
}
impl DeploymentConfig {
    /// <p>The percentage of robots receiving the deployment at the same time.</p>
    pub fn concurrent_deployment_percentage(&self) -> std::option::Option<i32> {
        self.concurrent_deployment_percentage
    }
    /// <p>The percentage of deployments that need to fail before stopping deployment.</p>
    pub fn failure_threshold_percentage(&self) -> std::option::Option<i32> {
        self.failure_threshold_percentage
    }
    /// <p>The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time between 1 minute and 7 days. The default is 5 hours.</p>
    pub fn robot_deployment_timeout_in_seconds(&self) -> std::option::Option<i64> {
        self.robot_deployment_timeout_in_seconds
    }
    /// <p>The download condition file.</p>
    pub fn download_condition_file(&self) -> std::option::Option<&crate::model::S3Object> {
        self.download_condition_file.as_ref()
    }
}
impl std::fmt::Debug for DeploymentConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentConfig");
        formatter.field(
            "concurrent_deployment_percentage",
            &self.concurrent_deployment_percentage,
        );
        formatter.field(
            "failure_threshold_percentage",
            &self.failure_threshold_percentage,
        );
        formatter.field(
            "robot_deployment_timeout_in_seconds",
            &self.robot_deployment_timeout_in_seconds,
        );
        formatter.field("download_condition_file", &self.download_condition_file);
        formatter.finish()
    }
}
/// See [`DeploymentConfig`](crate::model::DeploymentConfig)
pub mod deployment_config {
    /// A builder for [`DeploymentConfig`](crate::model::DeploymentConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) concurrent_deployment_percentage: std::option::Option<i32>,
        pub(crate) failure_threshold_percentage: std::option::Option<i32>,
        pub(crate) robot_deployment_timeout_in_seconds: std::option::Option<i64>,
        pub(crate) download_condition_file: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>The percentage of robots receiving the deployment at the same time.</p>
        pub fn concurrent_deployment_percentage(mut self, input: i32) -> Self {
            self.concurrent_deployment_percentage = Some(input);
            self
        }
        /// <p>The percentage of robots receiving the deployment at the same time.</p>
        pub fn set_concurrent_deployment_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.concurrent_deployment_percentage = input;
            self
        }
        /// <p>The percentage of deployments that need to fail before stopping deployment.</p>
        pub fn failure_threshold_percentage(mut self, input: i32) -> Self {
            self.failure_threshold_percentage = Some(input);
            self
        }
        /// <p>The percentage of deployments that need to fail before stopping deployment.</p>
        pub fn set_failure_threshold_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_threshold_percentage = input;
            self
        }
        /// <p>The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time between 1 minute and 7 days. The default is 5 hours.</p>
        pub fn robot_deployment_timeout_in_seconds(mut self, input: i64) -> Self {
            self.robot_deployment_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to wait for deployment to a single robot to complete. Choose a time between 1 minute and 7 days. The default is 5 hours.</p>
        pub fn set_robot_deployment_timeout_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.robot_deployment_timeout_in_seconds = input;
            self
        }
        /// <p>The download condition file.</p>
        pub fn download_condition_file(mut self, input: crate::model::S3Object) -> Self {
            self.download_condition_file = Some(input);
            self
        }
        /// <p>The download condition file.</p>
        pub fn set_download_condition_file(
            mut self,
            input: std::option::Option<crate::model::S3Object>,
        ) -> Self {
            self.download_condition_file = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentConfig`](crate::model::DeploymentConfig)
        pub fn build(self) -> crate::model::DeploymentConfig {
            crate::model::DeploymentConfig {
                concurrent_deployment_percentage: self.concurrent_deployment_percentage,
                failure_threshold_percentage: self.failure_threshold_percentage,
                robot_deployment_timeout_in_seconds: self.robot_deployment_timeout_in_seconds,
                download_condition_file: self.download_condition_file,
            }
        }
    }
}
impl DeploymentConfig {
    /// Creates a new builder-style object to manufacture [`DeploymentConfig`](crate::model::DeploymentConfig)
    pub fn builder() -> crate::model::deployment_config::Builder {
        crate::model::deployment_config::Builder::default()
    }
}

/// <p>Information about an S3 object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Object {
    /// <p>The bucket containing the object.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The key of the object.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The etag of the object.</p>
    pub etag: std::option::Option<std::string::String>,
}
impl S3Object {
    /// <p>The bucket containing the object.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The key of the object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The etag of the object.</p>
    pub fn etag(&self) -> std::option::Option<&str> {
        self.etag.as_deref()
    }
}
impl std::fmt::Debug for S3Object {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Object");
        formatter.field("bucket", &self.bucket);
        formatter.field("key", &self.key);
        formatter.field("etag", &self.etag);
        formatter.finish()
    }
}
/// See [`S3Object`](crate::model::S3Object)
pub mod s3_object {
    /// A builder for [`S3Object`](crate::model::S3Object)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) etag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket containing the object.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket containing the object.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key of the object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The etag of the object.</p>
        pub fn etag(mut self, input: impl Into<std::string::String>) -> Self {
            self.etag = Some(input.into());
            self
        }
        /// <p>The etag of the object.</p>
        pub fn set_etag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.etag = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Object`](crate::model::S3Object)
        pub fn build(self) -> crate::model::S3Object {
            crate::model::S3Object {
                bucket: self.bucket,
                key: self.key,
                etag: self.etag,
            }
        }
    }
}
impl S3Object {
    /// Creates a new builder-style object to manufacture [`S3Object`](crate::model::S3Object)
    pub fn builder() -> crate::model::s3_object::Builder {
        crate::model::s3_object::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeploymentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeploymentStatus {
    fn from(s: &str) -> Self {
        match s {
            "Canceled" => DeploymentStatus::Canceled,
            "Failed" => DeploymentStatus::Failed,
            "InProgress" => DeploymentStatus::InProgress,
            "Pending" => DeploymentStatus::Pending,
            "Preparing" => DeploymentStatus::Preparing,
            "Succeeded" => DeploymentStatus::Succeeded,
            other => DeploymentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeploymentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeploymentStatus::from(s))
    }
}
impl DeploymentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeploymentStatus::Canceled => "Canceled",
            DeploymentStatus::Failed => "Failed",
            DeploymentStatus::InProgress => "InProgress",
            DeploymentStatus::Pending => "Pending",
            DeploymentStatus::Preparing => "Preparing",
            DeploymentStatus::Succeeded => "Succeeded",
            DeploymentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Canceled",
            "Failed",
            "InProgress",
            "Pending",
            "Preparing",
            "Succeeded",
        ]
    }
}
impl AsRef<str> for DeploymentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information for a simulation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulationJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the simulation job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the simulation job.</p>
    pub status: std::option::Option<crate::model::SimulationJobStatus>,
    /// <p>A list of simulation job simulation application names.</p>
    pub simulation_application_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of simulation job robot application names.</p>
    pub robot_application_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the data sources.</p>
    pub data_source_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The compute type for the simulation job summary.</p>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
}
impl SimulationJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The name of the simulation job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the simulation job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SimulationJobStatus> {
        self.status.as_ref()
    }
    /// <p>A list of simulation job simulation application names.</p>
    pub fn simulation_application_names(&self) -> std::option::Option<&[std::string::String]> {
        self.simulation_application_names.as_deref()
    }
    /// <p>A list of simulation job robot application names.</p>
    pub fn robot_application_names(&self) -> std::option::Option<&[std::string::String]> {
        self.robot_application_names.as_deref()
    }
    /// <p>The names of the data sources.</p>
    pub fn data_source_names(&self) -> std::option::Option<&[std::string::String]> {
        self.data_source_names.as_deref()
    }
    /// <p>The compute type for the simulation job summary.</p>
    pub fn compute_type(&self) -> std::option::Option<&crate::model::ComputeType> {
        self.compute_type.as_ref()
    }
}
impl std::fmt::Debug for SimulationJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulationJobSummary");
        formatter.field("arn", &self.arn);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field(
            "simulation_application_names",
            &self.simulation_application_names,
        );
        formatter.field("robot_application_names", &self.robot_application_names);
        formatter.field("data_source_names", &self.data_source_names);
        formatter.field("compute_type", &self.compute_type);
        formatter.finish()
    }
}
/// See [`SimulationJobSummary`](crate::model::SimulationJobSummary)
pub mod simulation_job_summary {
    /// A builder for [`SimulationJobSummary`](crate::model::SimulationJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SimulationJobStatus>,
        pub(crate) simulation_application_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) robot_application_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) data_source_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The name of the simulation job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the simulation job.</p>
        pub fn status(mut self, input: crate::model::SimulationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the simulation job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SimulationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `simulation_application_names`.
        ///
        /// To override the contents of this collection use [`set_simulation_application_names`](Self::set_simulation_application_names).
        ///
        /// <p>A list of simulation job simulation application names.</p>
        pub fn simulation_application_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.simulation_application_names.unwrap_or_default();
            v.push(input.into());
            self.simulation_application_names = Some(v);
            self
        }
        /// <p>A list of simulation job simulation application names.</p>
        pub fn set_simulation_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.simulation_application_names = input;
            self
        }
        /// Appends an item to `robot_application_names`.
        ///
        /// To override the contents of this collection use [`set_robot_application_names`](Self::set_robot_application_names).
        ///
        /// <p>A list of simulation job robot application names.</p>
        pub fn robot_application_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.robot_application_names.unwrap_or_default();
            v.push(input.into());
            self.robot_application_names = Some(v);
            self
        }
        /// <p>A list of simulation job robot application names.</p>
        pub fn set_robot_application_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.robot_application_names = input;
            self
        }
        /// Appends an item to `data_source_names`.
        ///
        /// To override the contents of this collection use [`set_data_source_names`](Self::set_data_source_names).
        ///
        /// <p>The names of the data sources.</p>
        pub fn data_source_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.data_source_names.unwrap_or_default();
            v.push(input.into());
            self.data_source_names = Some(v);
            self
        }
        /// <p>The names of the data sources.</p>
        pub fn set_data_source_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.data_source_names = input;
            self
        }
        /// <p>The compute type for the simulation job summary.</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>The compute type for the simulation job summary.</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulationJobSummary`](crate::model::SimulationJobSummary)
        pub fn build(self) -> crate::model::SimulationJobSummary {
            crate::model::SimulationJobSummary {
                arn: self.arn,
                last_updated_at: self.last_updated_at,
                name: self.name,
                status: self.status,
                simulation_application_names: self.simulation_application_names,
                robot_application_names: self.robot_application_names,
                data_source_names: self.data_source_names,
                compute_type: self.compute_type,
            }
        }
    }
}
impl SimulationJobSummary {
    /// Creates a new builder-style object to manufacture [`SimulationJobSummary`](crate::model::SimulationJobSummary)
    pub fn builder() -> crate::model::simulation_job_summary::Builder {
        crate::model::simulation_job_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputeType {
    #[allow(missing_docs)] // documentation missing in model
    Cpu,
    #[allow(missing_docs)] // documentation missing in model
    GpuAndCpu,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputeType {
    fn from(s: &str) -> Self {
        match s {
            "CPU" => ComputeType::Cpu,
            "GPU_AND_CPU" => ComputeType::GpuAndCpu,
            other => ComputeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputeType::from(s))
    }
}
impl ComputeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputeType::Cpu => "CPU",
            ComputeType::GpuAndCpu => "GPU_AND_CPU",
            ComputeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CPU", "GPU_AND_CPU"]
    }
}
impl AsRef<str> for ComputeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SimulationJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Restarting,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    RunningFailed,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SimulationJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "Canceled" => SimulationJobStatus::Canceled,
            "Completed" => SimulationJobStatus::Completed,
            "Failed" => SimulationJobStatus::Failed,
            "Pending" => SimulationJobStatus::Pending,
            "Preparing" => SimulationJobStatus::Preparing,
            "Restarting" => SimulationJobStatus::Restarting,
            "Running" => SimulationJobStatus::Running,
            "RunningFailed" => SimulationJobStatus::RunningFailed,
            "Terminated" => SimulationJobStatus::Terminated,
            "Terminating" => SimulationJobStatus::Terminating,
            other => SimulationJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SimulationJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SimulationJobStatus::from(s))
    }
}
impl SimulationJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SimulationJobStatus::Canceled => "Canceled",
            SimulationJobStatus::Completed => "Completed",
            SimulationJobStatus::Failed => "Failed",
            SimulationJobStatus::Pending => "Pending",
            SimulationJobStatus::Preparing => "Preparing",
            SimulationJobStatus::Restarting => "Restarting",
            SimulationJobStatus::Running => "Running",
            SimulationJobStatus::RunningFailed => "RunningFailed",
            SimulationJobStatus::Terminated => "Terminated",
            SimulationJobStatus::Terminating => "Terminating",
            SimulationJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Canceled",
            "Completed",
            "Failed",
            "Pending",
            "Preparing",
            "Restarting",
            "Running",
            "RunningFailed",
            "Terminated",
            "Terminating",
        ]
    }
}
impl AsRef<str> for SimulationJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a simulation job request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulationJobRequest {
    /// <p>The output location.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The logging configuration.</p>
    pub logging_config: std::option::Option<crate::model::LoggingConfig>,
    /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
    pub max_job_duration_in_seconds: i64,
    /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>The failure behavior the simulation job.</p>
    /// <dl>
    /// <dt>
    /// Continue
    /// </dt>
    /// <dd>
    /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
    /// </dd>
    /// <dt>
    /// Fail
    /// </dt>
    /// <dd>
    /// <p>Stop the simulation job and terminate the instance.</p>
    /// </dd>
    /// </dl>
    pub failure_behavior: std::option::Option<crate::model::FailureBehavior>,
    /// <p>A Boolean indicating whether to use default applications in the simulation job. Default applications include Gazebo, rqt, rviz and terminal access. </p>
    pub use_default_applications: std::option::Option<bool>,
    /// <p>The robot applications to use in the simulation job.</p>
    pub robot_applications:
        std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
    /// <p>The simulation applications to use in the simulation job.</p>
    pub simulation_applications:
        std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
    /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
    /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
    /// </note>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceConfig>>,
    /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Compute information for the simulation job</p>
    pub compute: std::option::Option<crate::model::Compute>,
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job request.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl SimulationJobRequest {
    /// <p>The output location.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The logging configuration.</p>
    pub fn logging_config(&self) -> std::option::Option<&crate::model::LoggingConfig> {
        self.logging_config.as_ref()
    }
    /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
    pub fn max_job_duration_in_seconds(&self) -> i64 {
        self.max_job_duration_in_seconds
    }
    /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>The failure behavior the simulation job.</p>
    /// <dl>
    /// <dt>
    /// Continue
    /// </dt>
    /// <dd>
    /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
    /// </dd>
    /// <dt>
    /// Fail
    /// </dt>
    /// <dd>
    /// <p>Stop the simulation job and terminate the instance.</p>
    /// </dd>
    /// </dl>
    pub fn failure_behavior(&self) -> std::option::Option<&crate::model::FailureBehavior> {
        self.failure_behavior.as_ref()
    }
    /// <p>A Boolean indicating whether to use default applications in the simulation job. Default applications include Gazebo, rqt, rviz and terminal access. </p>
    pub fn use_default_applications(&self) -> std::option::Option<bool> {
        self.use_default_applications
    }
    /// <p>The robot applications to use in the simulation job.</p>
    pub fn robot_applications(
        &self,
    ) -> std::option::Option<&[crate::model::RobotApplicationConfig]> {
        self.robot_applications.as_deref()
    }
    /// <p>The simulation applications to use in the simulation job.</p>
    pub fn simulation_applications(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationApplicationConfig]> {
        self.simulation_applications.as_deref()
    }
    /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
    /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
    /// </note>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSourceConfig]> {
        self.data_sources.as_deref()
    }
    /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>Compute information for the simulation job</p>
    pub fn compute(&self) -> std::option::Option<&crate::model::Compute> {
        self.compute.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job request.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for SimulationJobRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulationJobRequest");
        formatter.field("output_location", &self.output_location);
        formatter.field("logging_config", &self.logging_config);
        formatter.field(
            "max_job_duration_in_seconds",
            &self.max_job_duration_in_seconds,
        );
        formatter.field("iam_role", &self.iam_role);
        formatter.field("failure_behavior", &self.failure_behavior);
        formatter.field("use_default_applications", &self.use_default_applications);
        formatter.field("robot_applications", &self.robot_applications);
        formatter.field("simulation_applications", &self.simulation_applications);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("compute", &self.compute);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`SimulationJobRequest`](crate::model::SimulationJobRequest)
pub mod simulation_job_request {
    /// A builder for [`SimulationJobRequest`](crate::model::SimulationJobRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) logging_config: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) max_job_duration_in_seconds: std::option::Option<i64>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) failure_behavior: std::option::Option<crate::model::FailureBehavior>,
        pub(crate) use_default_applications: std::option::Option<bool>,
        pub(crate) robot_applications:
            std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        pub(crate) simulation_applications:
            std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceConfig>>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) compute: std::option::Option<crate::model::Compute>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The output location.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>The output location.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The logging configuration.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging_config = Some(input);
            self
        }
        /// <p>The logging configuration.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging_config = input;
            self
        }
        /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
        pub fn max_job_duration_in_seconds(mut self, input: i64) -> Self {
            self.max_job_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
        pub fn set_max_job_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.max_job_duration_in_seconds = input;
            self
        }
        /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn failure_behavior(mut self, input: crate::model::FailureBehavior) -> Self {
            self.failure_behavior = Some(input);
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_behavior(
            mut self,
            input: std::option::Option<crate::model::FailureBehavior>,
        ) -> Self {
            self.failure_behavior = input;
            self
        }
        /// <p>A Boolean indicating whether to use default applications in the simulation job. Default applications include Gazebo, rqt, rviz and terminal access. </p>
        pub fn use_default_applications(mut self, input: bool) -> Self {
            self.use_default_applications = Some(input);
            self
        }
        /// <p>A Boolean indicating whether to use default applications in the simulation job. Default applications include Gazebo, rqt, rviz and terminal access. </p>
        pub fn set_use_default_applications(mut self, input: std::option::Option<bool>) -> Self {
            self.use_default_applications = input;
            self
        }
        /// Appends an item to `robot_applications`.
        ///
        /// To override the contents of this collection use [`set_robot_applications`](Self::set_robot_applications).
        ///
        /// <p>The robot applications to use in the simulation job.</p>
        pub fn robot_applications(mut self, input: crate::model::RobotApplicationConfig) -> Self {
            let mut v = self.robot_applications.unwrap_or_default();
            v.push(input);
            self.robot_applications = Some(v);
            self
        }
        /// <p>The robot applications to use in the simulation job.</p>
        pub fn set_robot_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        ) -> Self {
            self.robot_applications = input;
            self
        }
        /// Appends an item to `simulation_applications`.
        ///
        /// To override the contents of this collection use [`set_simulation_applications`](Self::set_simulation_applications).
        ///
        /// <p>The simulation applications to use in the simulation job.</p>
        pub fn simulation_applications(
            mut self,
            input: crate::model::SimulationApplicationConfig,
        ) -> Self {
            let mut v = self.simulation_applications.unwrap_or_default();
            v.push(input);
            self.simulation_applications = Some(v);
            self
        }
        /// <p>The simulation applications to use in the simulation job.</p>
        pub fn set_simulation_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        ) -> Self {
            self.simulation_applications = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
        /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
        /// </note>
        pub fn data_sources(mut self, input: crate::model::DataSourceConfig) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input);
            self.data_sources = Some(v);
            self
        }
        /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
        /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
        /// </note>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceConfig>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Compute information for the simulation job</p>
        pub fn compute(mut self, input: crate::model::Compute) -> Self {
            self.compute = Some(input);
            self
        }
        /// <p>Compute information for the simulation job</p>
        pub fn set_compute(mut self, input: std::option::Option<crate::model::Compute>) -> Self {
            self.compute = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job request.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulationJobRequest`](crate::model::SimulationJobRequest)
        pub fn build(self) -> crate::model::SimulationJobRequest {
            crate::model::SimulationJobRequest {
                output_location: self.output_location,
                logging_config: self.logging_config,
                max_job_duration_in_seconds: self.max_job_duration_in_seconds.unwrap_or_default(),
                iam_role: self.iam_role,
                failure_behavior: self.failure_behavior,
                use_default_applications: self.use_default_applications,
                robot_applications: self.robot_applications,
                simulation_applications: self.simulation_applications,
                data_sources: self.data_sources,
                vpc_config: self.vpc_config,
                compute: self.compute,
                tags: self.tags,
            }
        }
    }
}
impl SimulationJobRequest {
    /// Creates a new builder-style object to manufacture [`SimulationJobRequest`](crate::model::SimulationJobRequest)
    pub fn builder() -> crate::model::simulation_job_request::Builder {
        crate::model::simulation_job_request::Builder::default()
    }
}

/// <p>Compute information for the simulation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Compute {
    /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
    pub simulation_unit_limit: std::option::Option<i32>,
    /// <p>Compute type information for the simulation job.</p>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
    /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
    pub gpu_unit_limit: std::option::Option<i32>,
}
impl Compute {
    /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
    pub fn simulation_unit_limit(&self) -> std::option::Option<i32> {
        self.simulation_unit_limit
    }
    /// <p>Compute type information for the simulation job.</p>
    pub fn compute_type(&self) -> std::option::Option<&crate::model::ComputeType> {
        self.compute_type.as_ref()
    }
    /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
    pub fn gpu_unit_limit(&self) -> std::option::Option<i32> {
        self.gpu_unit_limit
    }
}
impl std::fmt::Debug for Compute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Compute");
        formatter.field("simulation_unit_limit", &self.simulation_unit_limit);
        formatter.field("compute_type", &self.compute_type);
        formatter.field("gpu_unit_limit", &self.gpu_unit_limit);
        formatter.finish()
    }
}
/// See [`Compute`](crate::model::Compute)
pub mod compute {
    /// A builder for [`Compute`](crate::model::Compute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simulation_unit_limit: std::option::Option<i32>,
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
        pub(crate) gpu_unit_limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
        pub fn simulation_unit_limit(mut self, input: i32) -> Self {
            self.simulation_unit_limit = Some(input);
            self
        }
        /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
        pub fn set_simulation_unit_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.simulation_unit_limit = input;
            self
        }
        /// <p>Compute type information for the simulation job.</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>Compute type information for the simulation job.</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
        pub fn gpu_unit_limit(mut self, input: i32) -> Self {
            self.gpu_unit_limit = Some(input);
            self
        }
        /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
        pub fn set_gpu_unit_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.gpu_unit_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`Compute`](crate::model::Compute)
        pub fn build(self) -> crate::model::Compute {
            crate::model::Compute {
                simulation_unit_limit: self.simulation_unit_limit,
                compute_type: self.compute_type,
                gpu_unit_limit: self.gpu_unit_limit,
            }
        }
    }
}
impl Compute {
    /// Creates a new builder-style object to manufacture [`Compute`](crate::model::Compute)
    pub fn builder() -> crate::model::compute::Builder {
        crate::model::compute::Builder::default()
    }
}

/// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet IDs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfig {
    /// <p>A list of one or more subnet IDs in your VPC.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of one or more security groups IDs in your VPC.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A boolean indicating whether to assign a public IP address.</p>
    pub assign_public_ip: bool,
}
impl VpcConfig {
    /// <p>A list of one or more subnet IDs in your VPC.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
    /// <p>A list of one or more security groups IDs in your VPC.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>A boolean indicating whether to assign a public IP address.</p>
    pub fn assign_public_ip(&self) -> bool {
        self.assign_public_ip
    }
}
impl std::fmt::Debug for VpcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfig");
        formatter.field("subnets", &self.subnets);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("assign_public_ip", &self.assign_public_ip);
        formatter.finish()
    }
}
/// See [`VpcConfig`](crate::model::VpcConfig)
pub mod vpc_config {
    /// A builder for [`VpcConfig`](crate::model::VpcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) assign_public_ip: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of one or more subnet IDs in your VPC.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>A list of one or more subnet IDs in your VPC.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list of one or more security groups IDs in your VPC.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list of one or more security groups IDs in your VPC.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>A boolean indicating whether to assign a public IP address.</p>
        pub fn assign_public_ip(mut self, input: bool) -> Self {
            self.assign_public_ip = Some(input);
            self
        }
        /// <p>A boolean indicating whether to assign a public IP address.</p>
        pub fn set_assign_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.assign_public_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfig`](crate::model::VpcConfig)
        pub fn build(self) -> crate::model::VpcConfig {
            crate::model::VpcConfig {
                subnets: self.subnets,
                security_groups: self.security_groups,
                assign_public_ip: self.assign_public_ip.unwrap_or_default(),
            }
        }
    }
}
impl VpcConfig {
    /// Creates a new builder-style object to manufacture [`VpcConfig`](crate::model::VpcConfig)
    pub fn builder() -> crate::model::vpc_config::Builder {
        crate::model::vpc_config::Builder::default()
    }
}

/// <p>Information about a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceConfig {
    /// <p>The name of the data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket where the data files are located.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The list of S3 keys identifying the data source files.</p>
    pub s3_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
    /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The location where your files are mounted in the container image.</p>
    /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
    pub destination: std::option::Option<std::string::String>,
}
impl DataSourceConfig {
    /// <p>The name of the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The S3 bucket where the data files are located.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The list of S3 keys identifying the data source files.</p>
    pub fn s3_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.s3_keys.as_deref()
    }
    /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
    /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The location where your files are mounted in the container image.</p>
    /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
}
impl std::fmt::Debug for DataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceConfig");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_keys", &self.s3_keys);
        formatter.field("r#type", &self.r#type);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`DataSourceConfig`](crate::model::DataSourceConfig)
pub mod data_source_config {
    /// A builder for [`DataSourceConfig`](crate::model::DataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) destination: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The S3 bucket where the data files are located.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket where the data files are located.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Appends an item to `s3_keys`.
        ///
        /// To override the contents of this collection use [`set_s3_keys`](Self::set_s3_keys).
        ///
        /// <p>The list of S3 keys identifying the data source files.</p>
        pub fn s3_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.s3_keys.unwrap_or_default();
            v.push(input.into());
            self.s3_keys = Some(v);
            self
        }
        /// <p>The list of S3 keys identifying the data source files.</p>
        pub fn set_s3_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.s3_keys = input;
            self
        }
        /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
        /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
        /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The location where your files are mounted in the container image.</p>
        /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The location where your files are mounted in the container image.</p>
        /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceConfig`](crate::model::DataSourceConfig)
        pub fn build(self) -> crate::model::DataSourceConfig {
            crate::model::DataSourceConfig {
                name: self.name,
                s3_bucket: self.s3_bucket,
                s3_keys: self.s3_keys,
                r#type: self.r#type,
                destination: self.destination,
            }
        }
    }
}
impl DataSourceConfig {
    /// Creates a new builder-style object to manufacture [`DataSourceConfig`](crate::model::DataSourceConfig)
    pub fn builder() -> crate::model::data_source_config::Builder {
        crate::model::data_source_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceType {
    #[allow(missing_docs)] // documentation missing in model
    Archive,
    #[allow(missing_docs)] // documentation missing in model
    File,
    #[allow(missing_docs)] // documentation missing in model
    Prefix,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceType {
    fn from(s: &str) -> Self {
        match s {
            "Archive" => DataSourceType::Archive,
            "File" => DataSourceType::File,
            "Prefix" => DataSourceType::Prefix,
            other => DataSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceType::from(s))
    }
}
impl DataSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceType::Archive => "Archive",
            DataSourceType::File => "File",
            DataSourceType::Prefix => "Prefix",
            DataSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Archive", "File", "Prefix"]
    }
}
impl AsRef<str> for DataSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a simulation application configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulationApplicationConfig {
    /// <p>The application information for the simulation application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The version of the simulation application.</p>
    pub application_version: std::option::Option<std::string::String>,
    /// <p>The launch configuration for the simulation application.</p>
    pub launch_config: std::option::Option<crate::model::LaunchConfig>,
    /// <p>Information about upload configurations for the simulation application.</p>
    pub upload_configurations:
        std::option::Option<std::vec::Vec<crate::model::UploadConfiguration>>,
    /// <p>A list of world configurations.</p>
    pub world_configs: std::option::Option<std::vec::Vec<crate::model::WorldConfig>>,
    /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
    /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
    pub use_default_upload_configurations: std::option::Option<bool>,
    /// <p>Information about tools configured for the simulation application.</p>
    pub tools: std::option::Option<std::vec::Vec<crate::model::Tool>>,
    /// <p>A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
    pub use_default_tools: std::option::Option<bool>,
}
impl SimulationApplicationConfig {
    /// <p>The application information for the simulation application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The version of the simulation application.</p>
    pub fn application_version(&self) -> std::option::Option<&str> {
        self.application_version.as_deref()
    }
    /// <p>The launch configuration for the simulation application.</p>
    pub fn launch_config(&self) -> std::option::Option<&crate::model::LaunchConfig> {
        self.launch_config.as_ref()
    }
    /// <p>Information about upload configurations for the simulation application.</p>
    pub fn upload_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::UploadConfiguration]> {
        self.upload_configurations.as_deref()
    }
    /// <p>A list of world configurations.</p>
    pub fn world_configs(&self) -> std::option::Option<&[crate::model::WorldConfig]> {
        self.world_configs.as_deref()
    }
    /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
    /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
    pub fn use_default_upload_configurations(&self) -> std::option::Option<bool> {
        self.use_default_upload_configurations
    }
    /// <p>Information about tools configured for the simulation application.</p>
    pub fn tools(&self) -> std::option::Option<&[crate::model::Tool]> {
        self.tools.as_deref()
    }
    /// <p>A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
    pub fn use_default_tools(&self) -> std::option::Option<bool> {
        self.use_default_tools
    }
}
impl std::fmt::Debug for SimulationApplicationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulationApplicationConfig");
        formatter.field("application", &self.application);
        formatter.field("application_version", &self.application_version);
        formatter.field("launch_config", &self.launch_config);
        formatter.field("upload_configurations", &self.upload_configurations);
        formatter.field("world_configs", &self.world_configs);
        formatter.field(
            "use_default_upload_configurations",
            &self.use_default_upload_configurations,
        );
        formatter.field("tools", &self.tools);
        formatter.field("use_default_tools", &self.use_default_tools);
        formatter.finish()
    }
}
/// See [`SimulationApplicationConfig`](crate::model::SimulationApplicationConfig)
pub mod simulation_application_config {
    /// A builder for [`SimulationApplicationConfig`](crate::model::SimulationApplicationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) application_version: std::option::Option<std::string::String>,
        pub(crate) launch_config: std::option::Option<crate::model::LaunchConfig>,
        pub(crate) upload_configurations:
            std::option::Option<std::vec::Vec<crate::model::UploadConfiguration>>,
        pub(crate) world_configs: std::option::Option<std::vec::Vec<crate::model::WorldConfig>>,
        pub(crate) use_default_upload_configurations: std::option::Option<bool>,
        pub(crate) tools: std::option::Option<std::vec::Vec<crate::model::Tool>>,
        pub(crate) use_default_tools: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The application information for the simulation application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the simulation application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version = Some(input.into());
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// <p>The launch configuration for the simulation application.</p>
        pub fn launch_config(mut self, input: crate::model::LaunchConfig) -> Self {
            self.launch_config = Some(input);
            self
        }
        /// <p>The launch configuration for the simulation application.</p>
        pub fn set_launch_config(
            mut self,
            input: std::option::Option<crate::model::LaunchConfig>,
        ) -> Self {
            self.launch_config = input;
            self
        }
        /// Appends an item to `upload_configurations`.
        ///
        /// To override the contents of this collection use [`set_upload_configurations`](Self::set_upload_configurations).
        ///
        /// <p>Information about upload configurations for the simulation application.</p>
        pub fn upload_configurations(mut self, input: crate::model::UploadConfiguration) -> Self {
            let mut v = self.upload_configurations.unwrap_or_default();
            v.push(input);
            self.upload_configurations = Some(v);
            self
        }
        /// <p>Information about upload configurations for the simulation application.</p>
        pub fn set_upload_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UploadConfiguration>>,
        ) -> Self {
            self.upload_configurations = input;
            self
        }
        /// Appends an item to `world_configs`.
        ///
        /// To override the contents of this collection use [`set_world_configs`](Self::set_world_configs).
        ///
        /// <p>A list of world configurations.</p>
        pub fn world_configs(mut self, input: crate::model::WorldConfig) -> Self {
            let mut v = self.world_configs.unwrap_or_default();
            v.push(input);
            self.world_configs = Some(v);
            self
        }
        /// <p>A list of world configurations.</p>
        pub fn set_world_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorldConfig>>,
        ) -> Self {
            self.world_configs = input;
            self
        }
        /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
        /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
        pub fn use_default_upload_configurations(mut self, input: bool) -> Self {
            self.use_default_upload_configurations = Some(input);
            self
        }
        /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
        /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
        pub fn set_use_default_upload_configurations(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_default_upload_configurations = input;
            self
        }
        /// Appends an item to `tools`.
        ///
        /// To override the contents of this collection use [`set_tools`](Self::set_tools).
        ///
        /// <p>Information about tools configured for the simulation application.</p>
        pub fn tools(mut self, input: crate::model::Tool) -> Self {
            let mut v = self.tools.unwrap_or_default();
            v.push(input);
            self.tools = Some(v);
            self
        }
        /// <p>Information about tools configured for the simulation application.</p>
        pub fn set_tools(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tool>>,
        ) -> Self {
            self.tools = input;
            self
        }
        /// <p>A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
        pub fn use_default_tools(mut self, input: bool) -> Self {
            self.use_default_tools = Some(input);
            self
        }
        /// <p>A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
        pub fn set_use_default_tools(mut self, input: std::option::Option<bool>) -> Self {
            self.use_default_tools = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulationApplicationConfig`](crate::model::SimulationApplicationConfig)
        pub fn build(self) -> crate::model::SimulationApplicationConfig {
            crate::model::SimulationApplicationConfig {
                application: self.application,
                application_version: self.application_version,
                launch_config: self.launch_config,
                upload_configurations: self.upload_configurations,
                world_configs: self.world_configs,
                use_default_upload_configurations: self.use_default_upload_configurations,
                tools: self.tools,
                use_default_tools: self.use_default_tools,
            }
        }
    }
}
impl SimulationApplicationConfig {
    /// Creates a new builder-style object to manufacture [`SimulationApplicationConfig`](crate::model::SimulationApplicationConfig)
    pub fn builder() -> crate::model::simulation_application_config::Builder {
        crate::model::simulation_application_config::Builder::default()
    }
}

/// <p>Information about a tool. Tools are used in a simulation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tool {
    /// <p>Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with the tool as it is running in the simulation. It must have a graphical user interface. The default is <code>False</code>. </p>
    pub stream_ui: std::option::Option<bool>,
    /// <p>The name of the tool.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Command-line arguments for the tool. It must include the tool executable name.</p>
    pub command: std::option::Option<std::string::String>,
    /// <p>Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is <code>False</code>. </p>
    pub stream_output_to_cloud_watch: std::option::Option<bool>,
    /// <p>Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>. </p>
    pub exit_behavior: std::option::Option<crate::model::ExitBehavior>,
}
impl Tool {
    /// <p>Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with the tool as it is running in the simulation. It must have a graphical user interface. The default is <code>False</code>. </p>
    pub fn stream_ui(&self) -> std::option::Option<bool> {
        self.stream_ui
    }
    /// <p>The name of the tool.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Command-line arguments for the tool. It must include the tool executable name.</p>
    pub fn command(&self) -> std::option::Option<&str> {
        self.command.as_deref()
    }
    /// <p>Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is <code>False</code>. </p>
    pub fn stream_output_to_cloud_watch(&self) -> std::option::Option<bool> {
        self.stream_output_to_cloud_watch
    }
    /// <p>Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>. </p>
    pub fn exit_behavior(&self) -> std::option::Option<&crate::model::ExitBehavior> {
        self.exit_behavior.as_ref()
    }
}
impl std::fmt::Debug for Tool {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tool");
        formatter.field("stream_ui", &self.stream_ui);
        formatter.field("name", &self.name);
        formatter.field("command", &self.command);
        formatter.field(
            "stream_output_to_cloud_watch",
            &self.stream_output_to_cloud_watch,
        );
        formatter.field("exit_behavior", &self.exit_behavior);
        formatter.finish()
    }
}
/// See [`Tool`](crate::model::Tool)
pub mod tool {
    /// A builder for [`Tool`](crate::model::Tool)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_ui: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) command: std::option::Option<std::string::String>,
        pub(crate) stream_output_to_cloud_watch: std::option::Option<bool>,
        pub(crate) exit_behavior: std::option::Option<crate::model::ExitBehavior>,
    }
    impl Builder {
        /// <p>Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with the tool as it is running in the simulation. It must have a graphical user interface. The default is <code>False</code>. </p>
        pub fn stream_ui(mut self, input: bool) -> Self {
            self.stream_ui = Some(input);
            self
        }
        /// <p>Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with the tool as it is running in the simulation. It must have a graphical user interface. The default is <code>False</code>. </p>
        pub fn set_stream_ui(mut self, input: std::option::Option<bool>) -> Self {
            self.stream_ui = input;
            self
        }
        /// <p>The name of the tool.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the tool.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Command-line arguments for the tool. It must include the tool executable name.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            self.command = Some(input.into());
            self
        }
        /// <p>Command-line arguments for the tool. It must include the tool executable name.</p>
        pub fn set_command(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.command = input;
            self
        }
        /// <p>Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is <code>False</code>. </p>
        pub fn stream_output_to_cloud_watch(mut self, input: bool) -> Self {
            self.stream_output_to_cloud_watch = Some(input);
            self
        }
        /// <p>Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is <code>False</code>. </p>
        pub fn set_stream_output_to_cloud_watch(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.stream_output_to_cloud_watch = input;
            self
        }
        /// <p>Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>. </p>
        pub fn exit_behavior(mut self, input: crate::model::ExitBehavior) -> Self {
            self.exit_behavior = Some(input);
            self
        }
        /// <p>Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>. </p>
        pub fn set_exit_behavior(
            mut self,
            input: std::option::Option<crate::model::ExitBehavior>,
        ) -> Self {
            self.exit_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`Tool`](crate::model::Tool)
        pub fn build(self) -> crate::model::Tool {
            crate::model::Tool {
                stream_ui: self.stream_ui,
                name: self.name,
                command: self.command,
                stream_output_to_cloud_watch: self.stream_output_to_cloud_watch,
                exit_behavior: self.exit_behavior,
            }
        }
    }
}
impl Tool {
    /// Creates a new builder-style object to manufacture [`Tool`](crate::model::Tool)
    pub fn builder() -> crate::model::tool::Builder {
        crate::model::tool::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExitBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Fail,
    #[allow(missing_docs)] // documentation missing in model
    Restart,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExitBehavior {
    fn from(s: &str) -> Self {
        match s {
            "FAIL" => ExitBehavior::Fail,
            "RESTART" => ExitBehavior::Restart,
            other => ExitBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExitBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExitBehavior::from(s))
    }
}
impl ExitBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExitBehavior::Fail => "FAIL",
            ExitBehavior::Restart => "RESTART",
            ExitBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAIL", "RESTART"]
    }
}
impl AsRef<str> for ExitBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration information for a world.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorldConfig {
    /// <p>The world generated by Simulation WorldForge.</p>
    pub world: std::option::Option<std::string::String>,
}
impl WorldConfig {
    /// <p>The world generated by Simulation WorldForge.</p>
    pub fn world(&self) -> std::option::Option<&str> {
        self.world.as_deref()
    }
}
impl std::fmt::Debug for WorldConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorldConfig");
        formatter.field("world", &self.world);
        formatter.finish()
    }
}
/// See [`WorldConfig`](crate::model::WorldConfig)
pub mod world_config {
    /// A builder for [`WorldConfig`](crate::model::WorldConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) world: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The world generated by Simulation WorldForge.</p>
        pub fn world(mut self, input: impl Into<std::string::String>) -> Self {
            self.world = Some(input.into());
            self
        }
        /// <p>The world generated by Simulation WorldForge.</p>
        pub fn set_world(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.world = input;
            self
        }
        /// Consumes the builder and constructs a [`WorldConfig`](crate::model::WorldConfig)
        pub fn build(self) -> crate::model::WorldConfig {
            crate::model::WorldConfig { world: self.world }
        }
    }
}
impl WorldConfig {
    /// Creates a new builder-style object to manufacture [`WorldConfig`](crate::model::WorldConfig)
    pub fn builder() -> crate::model::world_config::Builder {
        crate::model::world_config::Builder::default()
    }
}

/// <p>Provides upload configuration information. Files are uploaded from the simulation job to a location you specify. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadConfiguration {
    /// <p>A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output location to determine the final path. </p>
    /// <p> For example, if your simulation output location is <code>s3://my-bucket</code> and your upload configuration name is <code>robot-test</code>, your files will be uploaded to <code>s3://my-bucket/
    /// <simid>
    /// /
    /// <runid>
    /// /robot-test
    /// </runid>
    /// </simid></code>. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the addition of <code>**</code> as a <i>super asterisk</i>. For example, specifying <code>/var/log/**.log</code> causes all .log files in the <code>/var/log</code> directory tree to be collected. For more examples, see <a href="https://github.com/gobwas/glob">Glob Library</a>. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Specifies when to upload the files:</p>
    /// <dl>
    /// <dt>
    /// UPLOAD_ON_TERMINATE
    /// </dt>
    /// <dd>
    /// <p>Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are not uploaded until all of your code (including tools) have stopped. </p>
    /// <p>If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts will be made.</p>
    /// </dd>
    /// <dt>
    /// UPLOAD_ROLLING_AUTO_REMOVE
    /// </dt>
    /// <dd>
    /// <p>Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped. </p>
    /// </dd>
    /// </dl>
    pub upload_behavior: std::option::Option<crate::model::UploadBehavior>,
}
impl UploadConfiguration {
    /// <p>A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output location to determine the final path. </p>
    /// <p> For example, if your simulation output location is <code>s3://my-bucket</code> and your upload configuration name is <code>robot-test</code>, your files will be uploaded to <code>s3://my-bucket/
    /// <simid>
    /// /
    /// <runid>
    /// /robot-test
    /// </runid>
    /// </simid></code>. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the addition of <code>**</code> as a <i>super asterisk</i>. For example, specifying <code>/var/log/**.log</code> causes all .log files in the <code>/var/log</code> directory tree to be collected. For more examples, see <a href="https://github.com/gobwas/glob">Glob Library</a>. </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Specifies when to upload the files:</p>
    /// <dl>
    /// <dt>
    /// UPLOAD_ON_TERMINATE
    /// </dt>
    /// <dd>
    /// <p>Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are not uploaded until all of your code (including tools) have stopped. </p>
    /// <p>If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts will be made.</p>
    /// </dd>
    /// <dt>
    /// UPLOAD_ROLLING_AUTO_REMOVE
    /// </dt>
    /// <dd>
    /// <p>Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped. </p>
    /// </dd>
    /// </dl>
    pub fn upload_behavior(&self) -> std::option::Option<&crate::model::UploadBehavior> {
        self.upload_behavior.as_ref()
    }
}
impl std::fmt::Debug for UploadConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadConfiguration");
        formatter.field("name", &self.name);
        formatter.field("path", &self.path);
        formatter.field("upload_behavior", &self.upload_behavior);
        formatter.finish()
    }
}
/// See [`UploadConfiguration`](crate::model::UploadConfiguration)
pub mod upload_configuration {
    /// A builder for [`UploadConfiguration`](crate::model::UploadConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) upload_behavior: std::option::Option<crate::model::UploadBehavior>,
    }
    impl Builder {
        /// <p>A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output location to determine the final path. </p>
        /// <p> For example, if your simulation output location is <code>s3://my-bucket</code> and your upload configuration name is <code>robot-test</code>, your files will be uploaded to <code>s3://my-bucket/
        /// <simid>
        /// /
        /// <runid>
        /// /robot-test
        /// </runid>
        /// </simid></code>. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A prefix that specifies where files will be uploaded in Amazon S3. It is appended to the simulation output location to determine the final path. </p>
        /// <p> For example, if your simulation output location is <code>s3://my-bucket</code> and your upload configuration name is <code>robot-test</code>, your files will be uploaded to <code>s3://my-bucket/
        /// <simid>
        /// /
        /// <runid>
        /// /robot-test
        /// </runid>
        /// </simid></code>. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the addition of <code>**</code> as a <i>super asterisk</i>. For example, specifying <code>/var/log/**.log</code> causes all .log files in the <code>/var/log</code> directory tree to be collected. For more examples, see <a href="https://github.com/gobwas/glob">Glob Library</a>. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> Specifies the path of the file(s) to upload. Standard Unix glob matching rules are accepted, with the addition of <code>**</code> as a <i>super asterisk</i>. For example, specifying <code>/var/log/**.log</code> causes all .log files in the <code>/var/log</code> directory tree to be collected. For more examples, see <a href="https://github.com/gobwas/glob">Glob Library</a>. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Specifies when to upload the files:</p>
        /// <dl>
        /// <dt>
        /// UPLOAD_ON_TERMINATE
        /// </dt>
        /// <dd>
        /// <p>Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are not uploaded until all of your code (including tools) have stopped. </p>
        /// <p>If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts will be made.</p>
        /// </dd>
        /// <dt>
        /// UPLOAD_ROLLING_AUTO_REMOVE
        /// </dt>
        /// <dd>
        /// <p>Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped. </p>
        /// </dd>
        /// </dl>
        pub fn upload_behavior(mut self, input: crate::model::UploadBehavior) -> Self {
            self.upload_behavior = Some(input);
            self
        }
        /// <p>Specifies when to upload the files:</p>
        /// <dl>
        /// <dt>
        /// UPLOAD_ON_TERMINATE
        /// </dt>
        /// <dd>
        /// <p>Matching files are uploaded once the simulation enters the <code>TERMINATING</code> state. Matching files are not uploaded until all of your code (including tools) have stopped. </p>
        /// <p>If there is a problem uploading a file, the upload is retried. If problems persist, no further upload attempts will be made.</p>
        /// </dd>
        /// <dt>
        /// UPLOAD_ROLLING_AUTO_REMOVE
        /// </dt>
        /// <dd>
        /// <p>Matching files are uploaded as they are created. They are deleted after they are uploaded. The specified path is checked every 5 seconds. A final check is made when all of your code (including tools) have stopped. </p>
        /// </dd>
        /// </dl>
        pub fn set_upload_behavior(
            mut self,
            input: std::option::Option<crate::model::UploadBehavior>,
        ) -> Self {
            self.upload_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadConfiguration`](crate::model::UploadConfiguration)
        pub fn build(self) -> crate::model::UploadConfiguration {
            crate::model::UploadConfiguration {
                name: self.name,
                path: self.path,
                upload_behavior: self.upload_behavior,
            }
        }
    }
}
impl UploadConfiguration {
    /// Creates a new builder-style object to manufacture [`UploadConfiguration`](crate::model::UploadConfiguration)
    pub fn builder() -> crate::model::upload_configuration::Builder {
        crate::model::upload_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UploadBehavior {
    #[allow(missing_docs)] // documentation missing in model
    UploadOnTerminate,
    #[allow(missing_docs)] // documentation missing in model
    UploadRollingAutoRemove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UploadBehavior {
    fn from(s: &str) -> Self {
        match s {
            "UPLOAD_ON_TERMINATE" => UploadBehavior::UploadOnTerminate,
            "UPLOAD_ROLLING_AUTO_REMOVE" => UploadBehavior::UploadRollingAutoRemove,
            other => UploadBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UploadBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UploadBehavior::from(s))
    }
}
impl UploadBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UploadBehavior::UploadOnTerminate => "UPLOAD_ON_TERMINATE",
            UploadBehavior::UploadRollingAutoRemove => "UPLOAD_ROLLING_AUTO_REMOVE",
            UploadBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["UPLOAD_ON_TERMINATE", "UPLOAD_ROLLING_AUTO_REMOVE"]
    }
}
impl AsRef<str> for UploadBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a launch configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchConfig {
    /// <p>The package name.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The launch file name.</p>
    pub launch_file: std::option::Option<std::string::String>,
    /// <p>The environment variables for the application launch.</p>
    pub environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The port forwarding configuration.</p>
    pub port_forwarding_config: std::option::Option<crate::model::PortForwardingConfig>,
    /// <p>Boolean indicating whether a streaming session will be configured for the application. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with your application as it is running in the simulation. You must configure and launch the component. It must have a graphical user interface. </p>
    pub stream_ui: bool,
    /// <p>If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
    /// <p>If you've specified <code>SimulationRuntime</code> as the value for your <code>SimulationSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
    pub command: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl LaunchConfig {
    /// <p>The package name.</p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>The launch file name.</p>
    pub fn launch_file(&self) -> std::option::Option<&str> {
        self.launch_file.as_deref()
    }
    /// <p>The environment variables for the application launch.</p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment_variables.as_ref()
    }
    /// <p>The port forwarding configuration.</p>
    pub fn port_forwarding_config(
        &self,
    ) -> std::option::Option<&crate::model::PortForwardingConfig> {
        self.port_forwarding_config.as_ref()
    }
    /// <p>Boolean indicating whether a streaming session will be configured for the application. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with your application as it is running in the simulation. You must configure and launch the component. It must have a graphical user interface. </p>
    pub fn stream_ui(&self) -> bool {
        self.stream_ui
    }
    /// <p>If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
    /// <p>If you've specified <code>SimulationRuntime</code> as the value for your <code>SimulationSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
    pub fn command(&self) -> std::option::Option<&[std::string::String]> {
        self.command.as_deref()
    }
}
impl std::fmt::Debug for LaunchConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchConfig");
        formatter.field("package_name", &self.package_name);
        formatter.field("launch_file", &self.launch_file);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("port_forwarding_config", &self.port_forwarding_config);
        formatter.field("stream_ui", &self.stream_ui);
        formatter.field("command", &self.command);
        formatter.finish()
    }
}
/// See [`LaunchConfig`](crate::model::LaunchConfig)
pub mod launch_config {
    /// A builder for [`LaunchConfig`](crate::model::LaunchConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) launch_file: std::option::Option<std::string::String>,
        pub(crate) environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) port_forwarding_config: std::option::Option<crate::model::PortForwardingConfig>,
        pub(crate) stream_ui: std::option::Option<bool>,
        pub(crate) command: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The package name.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The package name.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The launch file name.</p>
        pub fn launch_file(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_file = Some(input.into());
            self
        }
        /// <p>The launch file name.</p>
        pub fn set_launch_file(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_file = input;
            self
        }
        /// Adds a key-value pair to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p>The environment variables for the application launch.</p>
        pub fn environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment_variables = Some(hash_map);
            self
        }
        /// <p>The environment variables for the application launch.</p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p>The port forwarding configuration.</p>
        pub fn port_forwarding_config(mut self, input: crate::model::PortForwardingConfig) -> Self {
            self.port_forwarding_config = Some(input);
            self
        }
        /// <p>The port forwarding configuration.</p>
        pub fn set_port_forwarding_config(
            mut self,
            input: std::option::Option<crate::model::PortForwardingConfig>,
        ) -> Self {
            self.port_forwarding_config = input;
            self
        }
        /// <p>Boolean indicating whether a streaming session will be configured for the application. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with your application as it is running in the simulation. You must configure and launch the component. It must have a graphical user interface. </p>
        pub fn stream_ui(mut self, input: bool) -> Self {
            self.stream_ui = Some(input);
            self
        }
        /// <p>Boolean indicating whether a streaming session will be configured for the application. If <code>True</code>, AWS RoboMaker will configure a connection so you can interact with your application as it is running in the simulation. You must configure and launch the component. It must have a graphical user interface. </p>
        pub fn set_stream_ui(mut self, input: std::option::Option<bool>) -> Self {
            self.stream_ui = input;
            self
        }
        /// Appends an item to `command`.
        ///
        /// To override the contents of this collection use [`set_command`](Self::set_command).
        ///
        /// <p>If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
        /// <p>If you've specified <code>SimulationRuntime</code> as the value for your <code>SimulationSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command.unwrap_or_default();
            v.push(input.into());
            self.command = Some(v);
            self
        }
        /// <p>If you've specified <code>General</code> as the value for your <code>RobotSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
        /// <p>If you've specified <code>SimulationRuntime</code> as the value for your <code>SimulationSoftwareSuite</code>, you can use this field to specify a list of commands for your container image.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchConfig`](crate::model::LaunchConfig)
        pub fn build(self) -> crate::model::LaunchConfig {
            crate::model::LaunchConfig {
                package_name: self.package_name,
                launch_file: self.launch_file,
                environment_variables: self.environment_variables,
                port_forwarding_config: self.port_forwarding_config,
                stream_ui: self.stream_ui.unwrap_or_default(),
                command: self.command,
            }
        }
    }
}
impl LaunchConfig {
    /// Creates a new builder-style object to manufacture [`LaunchConfig`](crate::model::LaunchConfig)
    pub fn builder() -> crate::model::launch_config::Builder {
        crate::model::launch_config::Builder::default()
    }
}

/// <p>Configuration information for port forwarding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortForwardingConfig {
    /// <p>The port mappings for the configuration.</p>
    pub port_mappings: std::option::Option<std::vec::Vec<crate::model::PortMapping>>,
}
impl PortForwardingConfig {
    /// <p>The port mappings for the configuration.</p>
    pub fn port_mappings(&self) -> std::option::Option<&[crate::model::PortMapping]> {
        self.port_mappings.as_deref()
    }
}
impl std::fmt::Debug for PortForwardingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortForwardingConfig");
        formatter.field("port_mappings", &self.port_mappings);
        formatter.finish()
    }
}
/// See [`PortForwardingConfig`](crate::model::PortForwardingConfig)
pub mod port_forwarding_config {
    /// A builder for [`PortForwardingConfig`](crate::model::PortForwardingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port_mappings: std::option::Option<std::vec::Vec<crate::model::PortMapping>>,
    }
    impl Builder {
        /// Appends an item to `port_mappings`.
        ///
        /// To override the contents of this collection use [`set_port_mappings`](Self::set_port_mappings).
        ///
        /// <p>The port mappings for the configuration.</p>
        pub fn port_mappings(mut self, input: crate::model::PortMapping) -> Self {
            let mut v = self.port_mappings.unwrap_or_default();
            v.push(input);
            self.port_mappings = Some(v);
            self
        }
        /// <p>The port mappings for the configuration.</p>
        pub fn set_port_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortMapping>>,
        ) -> Self {
            self.port_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`PortForwardingConfig`](crate::model::PortForwardingConfig)
        pub fn build(self) -> crate::model::PortForwardingConfig {
            crate::model::PortForwardingConfig {
                port_mappings: self.port_mappings,
            }
        }
    }
}
impl PortForwardingConfig {
    /// Creates a new builder-style object to manufacture [`PortForwardingConfig`](crate::model::PortForwardingConfig)
    pub fn builder() -> crate::model::port_forwarding_config::Builder {
        crate::model::port_forwarding_config::Builder::default()
    }
}

/// <p>An object representing a port mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortMapping {
    /// <p>The port number on the simulation job instance to use as a remote connection point. </p>
    pub job_port: i32,
    /// <p>The port number on the application.</p>
    pub application_port: i32,
    /// <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
    pub enable_on_public_ip: bool,
}
impl PortMapping {
    /// <p>The port number on the simulation job instance to use as a remote connection point. </p>
    pub fn job_port(&self) -> i32 {
        self.job_port
    }
    /// <p>The port number on the application.</p>
    pub fn application_port(&self) -> i32 {
        self.application_port
    }
    /// <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
    pub fn enable_on_public_ip(&self) -> bool {
        self.enable_on_public_ip
    }
}
impl std::fmt::Debug for PortMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortMapping");
        formatter.field("job_port", &self.job_port);
        formatter.field("application_port", &self.application_port);
        formatter.field("enable_on_public_ip", &self.enable_on_public_ip);
        formatter.finish()
    }
}
/// See [`PortMapping`](crate::model::PortMapping)
pub mod port_mapping {
    /// A builder for [`PortMapping`](crate::model::PortMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_port: std::option::Option<i32>,
        pub(crate) application_port: std::option::Option<i32>,
        pub(crate) enable_on_public_ip: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The port number on the simulation job instance to use as a remote connection point. </p>
        pub fn job_port(mut self, input: i32) -> Self {
            self.job_port = Some(input);
            self
        }
        /// <p>The port number on the simulation job instance to use as a remote connection point. </p>
        pub fn set_job_port(mut self, input: std::option::Option<i32>) -> Self {
            self.job_port = input;
            self
        }
        /// <p>The port number on the application.</p>
        pub fn application_port(mut self, input: i32) -> Self {
            self.application_port = Some(input);
            self
        }
        /// <p>The port number on the application.</p>
        pub fn set_application_port(mut self, input: std::option::Option<i32>) -> Self {
            self.application_port = input;
            self
        }
        /// <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
        pub fn enable_on_public_ip(mut self, input: bool) -> Self {
            self.enable_on_public_ip = Some(input);
            self
        }
        /// <p>A Boolean indicating whether to enable this port mapping on public IP.</p>
        pub fn set_enable_on_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_on_public_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`PortMapping`](crate::model::PortMapping)
        pub fn build(self) -> crate::model::PortMapping {
            crate::model::PortMapping {
                job_port: self.job_port.unwrap_or_default(),
                application_port: self.application_port.unwrap_or_default(),
                enable_on_public_ip: self.enable_on_public_ip.unwrap_or_default(),
            }
        }
    }
}
impl PortMapping {
    /// Creates a new builder-style object to manufacture [`PortMapping`](crate::model::PortMapping)
    pub fn builder() -> crate::model::port_mapping::Builder {
        crate::model::port_mapping::Builder::default()
    }
}

/// <p>Application configuration information for a robot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RobotApplicationConfig {
    /// <p>The application information for the robot application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The version of the robot application.</p>
    pub application_version: std::option::Option<std::string::String>,
    /// <p>The launch configuration for the robot application.</p>
    pub launch_config: std::option::Option<crate::model::LaunchConfig>,
    /// <p>The upload configurations for the robot application.</p>
    pub upload_configurations:
        std::option::Option<std::vec::Vec<crate::model::UploadConfiguration>>,
    /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
    /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
    pub use_default_upload_configurations: std::option::Option<bool>,
    /// <p>Information about tools configured for the robot application.</p>
    pub tools: std::option::Option<std::vec::Vec<crate::model::Tool>>,
    /// <p>A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
    pub use_default_tools: std::option::Option<bool>,
}
impl RobotApplicationConfig {
    /// <p>The application information for the robot application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The version of the robot application.</p>
    pub fn application_version(&self) -> std::option::Option<&str> {
        self.application_version.as_deref()
    }
    /// <p>The launch configuration for the robot application.</p>
    pub fn launch_config(&self) -> std::option::Option<&crate::model::LaunchConfig> {
        self.launch_config.as_ref()
    }
    /// <p>The upload configurations for the robot application.</p>
    pub fn upload_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::UploadConfiguration]> {
        self.upload_configurations.as_deref()
    }
    /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
    /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
    pub fn use_default_upload_configurations(&self) -> std::option::Option<bool> {
        self.use_default_upload_configurations
    }
    /// <p>Information about tools configured for the robot application.</p>
    pub fn tools(&self) -> std::option::Option<&[crate::model::Tool]> {
        self.tools.as_deref()
    }
    /// <p>A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
    pub fn use_default_tools(&self) -> std::option::Option<bool> {
        self.use_default_tools
    }
}
impl std::fmt::Debug for RobotApplicationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RobotApplicationConfig");
        formatter.field("application", &self.application);
        formatter.field("application_version", &self.application_version);
        formatter.field("launch_config", &self.launch_config);
        formatter.field("upload_configurations", &self.upload_configurations);
        formatter.field(
            "use_default_upload_configurations",
            &self.use_default_upload_configurations,
        );
        formatter.field("tools", &self.tools);
        formatter.field("use_default_tools", &self.use_default_tools);
        formatter.finish()
    }
}
/// See [`RobotApplicationConfig`](crate::model::RobotApplicationConfig)
pub mod robot_application_config {
    /// A builder for [`RobotApplicationConfig`](crate::model::RobotApplicationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) application_version: std::option::Option<std::string::String>,
        pub(crate) launch_config: std::option::Option<crate::model::LaunchConfig>,
        pub(crate) upload_configurations:
            std::option::Option<std::vec::Vec<crate::model::UploadConfiguration>>,
        pub(crate) use_default_upload_configurations: std::option::Option<bool>,
        pub(crate) tools: std::option::Option<std::vec::Vec<crate::model::Tool>>,
        pub(crate) use_default_tools: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The application information for the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version = Some(input.into());
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// <p>The launch configuration for the robot application.</p>
        pub fn launch_config(mut self, input: crate::model::LaunchConfig) -> Self {
            self.launch_config = Some(input);
            self
        }
        /// <p>The launch configuration for the robot application.</p>
        pub fn set_launch_config(
            mut self,
            input: std::option::Option<crate::model::LaunchConfig>,
        ) -> Self {
            self.launch_config = input;
            self
        }
        /// Appends an item to `upload_configurations`.
        ///
        /// To override the contents of this collection use [`set_upload_configurations`](Self::set_upload_configurations).
        ///
        /// <p>The upload configurations for the robot application.</p>
        pub fn upload_configurations(mut self, input: crate::model::UploadConfiguration) -> Self {
            let mut v = self.upload_configurations.unwrap_or_default();
            v.push(input);
            self.upload_configurations = Some(v);
            self
        }
        /// <p>The upload configurations for the robot application.</p>
        pub fn set_upload_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UploadConfiguration>>,
        ) -> Self {
            self.upload_configurations = input;
            self
        }
        /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
        /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
        pub fn use_default_upload_configurations(mut self, input: bool) -> Self {
            self.use_default_upload_configurations = Some(input);
            self
        }
        /// <p>A Boolean indicating whether to use default upload configurations. By default, <code>.ros</code> and <code>.gazebo</code> files are uploaded when the application terminates and all ROS topics will be recorded.</p>
        /// <p>If you set this value, you must specify an <code>outputLocation</code>. </p>
        pub fn set_use_default_upload_configurations(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_default_upload_configurations = input;
            self
        }
        /// Appends an item to `tools`.
        ///
        /// To override the contents of this collection use [`set_tools`](Self::set_tools).
        ///
        /// <p>Information about tools configured for the robot application.</p>
        pub fn tools(mut self, input: crate::model::Tool) -> Self {
            let mut v = self.tools.unwrap_or_default();
            v.push(input);
            self.tools = Some(v);
            self
        }
        /// <p>Information about tools configured for the robot application.</p>
        pub fn set_tools(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tool>>,
        ) -> Self {
            self.tools = input;
            self
        }
        /// <p>A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
        pub fn use_default_tools(mut self, input: bool) -> Self {
            self.use_default_tools = Some(input);
            self
        }
        /// <p>A Boolean indicating whether to use default robot application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is <code>False</code>. </p>
        pub fn set_use_default_tools(mut self, input: std::option::Option<bool>) -> Self {
            self.use_default_tools = input;
            self
        }
        /// Consumes the builder and constructs a [`RobotApplicationConfig`](crate::model::RobotApplicationConfig)
        pub fn build(self) -> crate::model::RobotApplicationConfig {
            crate::model::RobotApplicationConfig {
                application: self.application,
                application_version: self.application_version,
                launch_config: self.launch_config,
                upload_configurations: self.upload_configurations,
                use_default_upload_configurations: self.use_default_upload_configurations,
                tools: self.tools,
                use_default_tools: self.use_default_tools,
            }
        }
    }
}
impl RobotApplicationConfig {
    /// Creates a new builder-style object to manufacture [`RobotApplicationConfig`](crate::model::RobotApplicationConfig)
    pub fn builder() -> crate::model::robot_application_config::Builder {
        crate::model::robot_application_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailureBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Continue,
    #[allow(missing_docs)] // documentation missing in model
    Fail,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailureBehavior {
    fn from(s: &str) -> Self {
        match s {
            "Continue" => FailureBehavior::Continue,
            "Fail" => FailureBehavior::Fail,
            other => FailureBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailureBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailureBehavior::from(s))
    }
}
impl FailureBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailureBehavior::Continue => "Continue",
            FailureBehavior::Fail => "Fail",
            FailureBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Continue", "Fail"]
    }
}
impl AsRef<str> for FailureBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The logging configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingConfig {
    /// <p>A boolean indicating whether to record all ROS topics.</p>
    pub record_all_ros_topics: std::option::Option<bool>,
}
impl LoggingConfig {
    /// <p>A boolean indicating whether to record all ROS topics.</p>
    pub fn record_all_ros_topics(&self) -> std::option::Option<bool> {
        self.record_all_ros_topics
    }
}
impl std::fmt::Debug for LoggingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingConfig");
        formatter.field("record_all_ros_topics", &self.record_all_ros_topics);
        formatter.finish()
    }
}
/// See [`LoggingConfig`](crate::model::LoggingConfig)
pub mod logging_config {
    /// A builder for [`LoggingConfig`](crate::model::LoggingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_all_ros_topics: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A boolean indicating whether to record all ROS topics.</p>
        pub fn record_all_ros_topics(mut self, input: bool) -> Self {
            self.record_all_ros_topics = Some(input);
            self
        }
        /// <p>A boolean indicating whether to record all ROS topics.</p>
        pub fn set_record_all_ros_topics(mut self, input: std::option::Option<bool>) -> Self {
            self.record_all_ros_topics = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingConfig`](crate::model::LoggingConfig)
        pub fn build(self) -> crate::model::LoggingConfig {
            crate::model::LoggingConfig {
                record_all_ros_topics: self.record_all_ros_topics,
            }
        }
    }
}
impl LoggingConfig {
    /// Creates a new builder-style object to manufacture [`LoggingConfig`](crate::model::LoggingConfig)
    pub fn builder() -> crate::model::logging_config::Builder {
        crate::model::logging_config::Builder::default()
    }
}

/// <p>The output location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputLocation {
    /// <p>The S3 bucket for output.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The S3 folder in the <code>s3Bucket</code> where output files will be placed.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
}
impl OutputLocation {
    /// <p>The S3 bucket for output.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The S3 folder in the <code>s3Bucket</code> where output files will be placed.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
}
impl std::fmt::Debug for OutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputLocation");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.finish()
    }
}
/// See [`OutputLocation`](crate::model::OutputLocation)
pub mod output_location {
    /// A builder for [`OutputLocation`](crate::model::OutputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket for output.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket for output.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The S3 folder in the <code>s3Bucket</code> where output files will be placed.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The S3 folder in the <code>s3Bucket</code> where output files will be placed.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputLocation`](crate::model::OutputLocation)
        pub fn build(self) -> crate::model::OutputLocation {
            crate::model::OutputLocation {
                s3_bucket: self.s3_bucket,
                s3_prefix: self.s3_prefix,
            }
        }
    }
}
impl OutputLocation {
    /// Creates a new builder-style object to manufacture [`OutputLocation`](crate::model::OutputLocation)
    pub fn builder() -> crate::model::output_location::Builder {
        crate::model::output_location::Builder::default()
    }
}

/// <p>Information about a failed create simulation job request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedCreateSimulationJobRequest {
    /// <p>The simulation job request.</p>
    pub request: std::option::Option<crate::model::SimulationJobRequest>,
    /// <p>The failure reason of the simulation job request.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The failure code.</p>
    pub failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch failed.</p>
    pub failed_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl FailedCreateSimulationJobRequest {
    /// <p>The simulation job request.</p>
    pub fn request(&self) -> std::option::Option<&crate::model::SimulationJobRequest> {
        self.request.as_ref()
    }
    /// <p>The failure reason of the simulation job request.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The failure code.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::SimulationJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch failed.</p>
    pub fn failed_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.failed_at.as_ref()
    }
}
impl std::fmt::Debug for FailedCreateSimulationJobRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedCreateSimulationJobRequest");
        formatter.field("request", &self.request);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failed_at", &self.failed_at);
        formatter.finish()
    }
}
/// See [`FailedCreateSimulationJobRequest`](crate::model::FailedCreateSimulationJobRequest)
pub mod failed_create_simulation_job_request {
    /// A builder for [`FailedCreateSimulationJobRequest`](crate::model::FailedCreateSimulationJobRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request: std::option::Option<crate::model::SimulationJobRequest>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
        pub(crate) failed_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The simulation job request.</p>
        pub fn request(mut self, input: crate::model::SimulationJobRequest) -> Self {
            self.request = Some(input);
            self
        }
        /// <p>The simulation job request.</p>
        pub fn set_request(
            mut self,
            input: std::option::Option<crate::model::SimulationJobRequest>,
        ) -> Self {
            self.request = input;
            self
        }
        /// <p>The failure reason of the simulation job request.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The failure reason of the simulation job request.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The failure code.</p>
        pub fn failure_code(mut self, input: crate::model::SimulationJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::SimulationJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch failed.</p>
        pub fn failed_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.failed_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch failed.</p>
        pub fn set_failed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.failed_at = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedCreateSimulationJobRequest`](crate::model::FailedCreateSimulationJobRequest)
        pub fn build(self) -> crate::model::FailedCreateSimulationJobRequest {
            crate::model::FailedCreateSimulationJobRequest {
                request: self.request,
                failure_reason: self.failure_reason,
                failure_code: self.failure_code,
                failed_at: self.failed_at,
            }
        }
    }
}
impl FailedCreateSimulationJobRequest {
    /// Creates a new builder-style object to manufacture [`FailedCreateSimulationJobRequest`](crate::model::FailedCreateSimulationJobRequest)
    pub fn builder() -> crate::model::failed_create_simulation_job_request::Builder {
        crate::model::failed_create_simulation_job_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SimulationJobErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    BadPermissionsCloudwatchLogs,
    #[allow(missing_docs)] // documentation missing in model
    BadPermissionsRobotApplication,
    #[allow(missing_docs)] // documentation missing in model
    BadPermissionsS3Object,
    #[allow(missing_docs)] // documentation missing in model
    BadPermissionsS3Output,
    #[allow(missing_docs)] // documentation missing in model
    BadPermissionsSimulationApplication,
    #[allow(missing_docs)] // documentation missing in model
    BadPermissionsUserCredentials,
    #[allow(missing_docs)] // documentation missing in model
    BatchCanceled,
    #[allow(missing_docs)] // documentation missing in model
    BatchTimedOut,
    #[allow(missing_docs)] // documentation missing in model
    EniLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidBundleRobotApplication,
    #[allow(missing_docs)] // documentation missing in model
    InvalidBundleSimulationApplication,
    #[allow(missing_docs)] // documentation missing in model
    InvalidInput,
    #[allow(missing_docs)] // documentation missing in model
    InvalidS3Resource,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedEtag,
    #[allow(missing_docs)] // documentation missing in model
    RequestThrottled,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    #[allow(missing_docs)] // documentation missing in model
    RobotApplicationCrash,
    #[allow(missing_docs)] // documentation missing in model
    RobotApplicationHealthCheckFailure,
    #[allow(missing_docs)] // documentation missing in model
    RobotApplicationVersionMismatchedEtag,
    #[allow(missing_docs)] // documentation missing in model
    SimulationApplicationCrash,
    #[allow(missing_docs)] // documentation missing in model
    SimulationApplicationHealthCheckFailure,
    #[allow(missing_docs)] // documentation missing in model
    SimulationApplicationVersionMismatchedEtag,
    #[allow(missing_docs)] // documentation missing in model
    SubnetIpLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    ThrottlingError,
    #[allow(missing_docs)] // documentation missing in model
    UploadContentMismatchError,
    #[allow(missing_docs)] // documentation missing in model
    WrongRegionRobotApplication,
    #[allow(missing_docs)] // documentation missing in model
    WrongRegionS3Bucket,
    #[allow(missing_docs)] // documentation missing in model
    WrongRegionS3Output,
    #[allow(missing_docs)] // documentation missing in model
    WrongRegionSimulationApplication,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SimulationJobErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "BadPermissionsCloudwatchLogs" => SimulationJobErrorCode::BadPermissionsCloudwatchLogs,
            "BadPermissionsRobotApplication" => {
                SimulationJobErrorCode::BadPermissionsRobotApplication
            }
            "BadPermissionsS3Object" => SimulationJobErrorCode::BadPermissionsS3Object,
            "BadPermissionsS3Output" => SimulationJobErrorCode::BadPermissionsS3Output,
            "BadPermissionsSimulationApplication" => {
                SimulationJobErrorCode::BadPermissionsSimulationApplication
            }
            "BadPermissionsUserCredentials" => {
                SimulationJobErrorCode::BadPermissionsUserCredentials
            }
            "BatchCanceled" => SimulationJobErrorCode::BatchCanceled,
            "BatchTimedOut" => SimulationJobErrorCode::BatchTimedOut,
            "ENILimitExceeded" => SimulationJobErrorCode::EniLimitExceeded,
            "InternalServiceError" => SimulationJobErrorCode::InternalServiceError,
            "InvalidBundleRobotApplication" => {
                SimulationJobErrorCode::InvalidBundleRobotApplication
            }
            "InvalidBundleSimulationApplication" => {
                SimulationJobErrorCode::InvalidBundleSimulationApplication
            }
            "InvalidInput" => SimulationJobErrorCode::InvalidInput,
            "InvalidS3Resource" => SimulationJobErrorCode::InvalidS3Resource,
            "LimitExceeded" => SimulationJobErrorCode::LimitExceeded,
            "MismatchedEtag" => SimulationJobErrorCode::MismatchedEtag,
            "RequestThrottled" => SimulationJobErrorCode::RequestThrottled,
            "ResourceNotFound" => SimulationJobErrorCode::ResourceNotFound,
            "RobotApplicationCrash" => SimulationJobErrorCode::RobotApplicationCrash,
            "RobotApplicationHealthCheckFailure" => {
                SimulationJobErrorCode::RobotApplicationHealthCheckFailure
            }
            "RobotApplicationVersionMismatchedEtag" => {
                SimulationJobErrorCode::RobotApplicationVersionMismatchedEtag
            }
            "SimulationApplicationCrash" => SimulationJobErrorCode::SimulationApplicationCrash,
            "SimulationApplicationHealthCheckFailure" => {
                SimulationJobErrorCode::SimulationApplicationHealthCheckFailure
            }
            "SimulationApplicationVersionMismatchedEtag" => {
                SimulationJobErrorCode::SimulationApplicationVersionMismatchedEtag
            }
            "SubnetIpLimitExceeded" => SimulationJobErrorCode::SubnetIpLimitExceeded,
            "ThrottlingError" => SimulationJobErrorCode::ThrottlingError,
            "UploadContentMismatchError" => SimulationJobErrorCode::UploadContentMismatchError,
            "WrongRegionRobotApplication" => SimulationJobErrorCode::WrongRegionRobotApplication,
            "WrongRegionS3Bucket" => SimulationJobErrorCode::WrongRegionS3Bucket,
            "WrongRegionS3Output" => SimulationJobErrorCode::WrongRegionS3Output,
            "WrongRegionSimulationApplication" => {
                SimulationJobErrorCode::WrongRegionSimulationApplication
            }
            other => SimulationJobErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SimulationJobErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SimulationJobErrorCode::from(s))
    }
}
impl SimulationJobErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SimulationJobErrorCode::BadPermissionsCloudwatchLogs => "BadPermissionsCloudwatchLogs",
            SimulationJobErrorCode::BadPermissionsRobotApplication => {
                "BadPermissionsRobotApplication"
            }
            SimulationJobErrorCode::BadPermissionsS3Object => "BadPermissionsS3Object",
            SimulationJobErrorCode::BadPermissionsS3Output => "BadPermissionsS3Output",
            SimulationJobErrorCode::BadPermissionsSimulationApplication => {
                "BadPermissionsSimulationApplication"
            }
            SimulationJobErrorCode::BadPermissionsUserCredentials => {
                "BadPermissionsUserCredentials"
            }
            SimulationJobErrorCode::BatchCanceled => "BatchCanceled",
            SimulationJobErrorCode::BatchTimedOut => "BatchTimedOut",
            SimulationJobErrorCode::EniLimitExceeded => "ENILimitExceeded",
            SimulationJobErrorCode::InternalServiceError => "InternalServiceError",
            SimulationJobErrorCode::InvalidBundleRobotApplication => {
                "InvalidBundleRobotApplication"
            }
            SimulationJobErrorCode::InvalidBundleSimulationApplication => {
                "InvalidBundleSimulationApplication"
            }
            SimulationJobErrorCode::InvalidInput => "InvalidInput",
            SimulationJobErrorCode::InvalidS3Resource => "InvalidS3Resource",
            SimulationJobErrorCode::LimitExceeded => "LimitExceeded",
            SimulationJobErrorCode::MismatchedEtag => "MismatchedEtag",
            SimulationJobErrorCode::RequestThrottled => "RequestThrottled",
            SimulationJobErrorCode::ResourceNotFound => "ResourceNotFound",
            SimulationJobErrorCode::RobotApplicationCrash => "RobotApplicationCrash",
            SimulationJobErrorCode::RobotApplicationHealthCheckFailure => {
                "RobotApplicationHealthCheckFailure"
            }
            SimulationJobErrorCode::RobotApplicationVersionMismatchedEtag => {
                "RobotApplicationVersionMismatchedEtag"
            }
            SimulationJobErrorCode::SimulationApplicationCrash => "SimulationApplicationCrash",
            SimulationJobErrorCode::SimulationApplicationHealthCheckFailure => {
                "SimulationApplicationHealthCheckFailure"
            }
            SimulationJobErrorCode::SimulationApplicationVersionMismatchedEtag => {
                "SimulationApplicationVersionMismatchedEtag"
            }
            SimulationJobErrorCode::SubnetIpLimitExceeded => "SubnetIpLimitExceeded",
            SimulationJobErrorCode::ThrottlingError => "ThrottlingError",
            SimulationJobErrorCode::UploadContentMismatchError => "UploadContentMismatchError",
            SimulationJobErrorCode::WrongRegionRobotApplication => "WrongRegionRobotApplication",
            SimulationJobErrorCode::WrongRegionS3Bucket => "WrongRegionS3Bucket",
            SimulationJobErrorCode::WrongRegionS3Output => "WrongRegionS3Output",
            SimulationJobErrorCode::WrongRegionSimulationApplication => {
                "WrongRegionSimulationApplication"
            }
            SimulationJobErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BadPermissionsCloudwatchLogs",
            "BadPermissionsRobotApplication",
            "BadPermissionsS3Object",
            "BadPermissionsS3Output",
            "BadPermissionsSimulationApplication",
            "BadPermissionsUserCredentials",
            "BatchCanceled",
            "BatchTimedOut",
            "ENILimitExceeded",
            "InternalServiceError",
            "InvalidBundleRobotApplication",
            "InvalidBundleSimulationApplication",
            "InvalidInput",
            "InvalidS3Resource",
            "LimitExceeded",
            "MismatchedEtag",
            "RequestThrottled",
            "ResourceNotFound",
            "RobotApplicationCrash",
            "RobotApplicationHealthCheckFailure",
            "RobotApplicationVersionMismatchedEtag",
            "SimulationApplicationCrash",
            "SimulationApplicationHealthCheckFailure",
            "SimulationApplicationVersionMismatchedEtag",
            "SubnetIpLimitExceeded",
            "ThrottlingError",
            "UploadContentMismatchError",
            "WrongRegionRobotApplication",
            "WrongRegionS3Bucket",
            "WrongRegionS3Output",
            "WrongRegionSimulationApplication",
        ]
    }
}
impl AsRef<str> for SimulationJobErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SimulationJobBatchErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SimulationJobBatchErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "InternalServiceError" => SimulationJobBatchErrorCode::InternalServiceError,
            other => SimulationJobBatchErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SimulationJobBatchErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SimulationJobBatchErrorCode::from(s))
    }
}
impl SimulationJobBatchErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SimulationJobBatchErrorCode::InternalServiceError => "InternalServiceError",
            SimulationJobBatchErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["InternalServiceError"]
    }
}
impl AsRef<str> for SimulationJobBatchErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the batch policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPolicy {
    /// <p>The amount of time, in seconds, to wait for the batch to complete. </p>
    /// <p>If a batch times out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending requests will be moved to the failed list and the batch status will be <code>TimedOut</code>. </p>
    pub timeout_in_seconds: std::option::Option<i64>,
    /// <p>The number of active simulation jobs create as part of the batch that can be in an active state at the same time. </p>
    /// <p>Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>, <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are terminal states. </p>
    pub max_concurrency: std::option::Option<i32>,
}
impl BatchPolicy {
    /// <p>The amount of time, in seconds, to wait for the batch to complete. </p>
    /// <p>If a batch times out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending requests will be moved to the failed list and the batch status will be <code>TimedOut</code>. </p>
    pub fn timeout_in_seconds(&self) -> std::option::Option<i64> {
        self.timeout_in_seconds
    }
    /// <p>The number of active simulation jobs create as part of the batch that can be in an active state at the same time. </p>
    /// <p>Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>, <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are terminal states. </p>
    pub fn max_concurrency(&self) -> std::option::Option<i32> {
        self.max_concurrency
    }
}
impl std::fmt::Debug for BatchPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPolicy");
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.finish()
    }
}
/// See [`BatchPolicy`](crate::model::BatchPolicy)
pub mod batch_policy {
    /// A builder for [`BatchPolicy`](crate::model::BatchPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timeout_in_seconds: std::option::Option<i64>,
        pub(crate) max_concurrency: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The amount of time, in seconds, to wait for the batch to complete. </p>
        /// <p>If a batch times out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending requests will be moved to the failed list and the batch status will be <code>TimedOut</code>. </p>
        pub fn timeout_in_seconds(mut self, input: i64) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to wait for the batch to complete. </p>
        /// <p>If a batch times out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), they will be moved to the failed list and the batch status will be <code>Failed</code>. If the pending requests were failing for any other reason, the failed pending requests will be moved to the failed list and the batch status will be <code>TimedOut</code>. </p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>The number of active simulation jobs create as part of the batch that can be in an active state at the same time. </p>
        /// <p>Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>, <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are terminal states. </p>
        pub fn max_concurrency(mut self, input: i32) -> Self {
            self.max_concurrency = Some(input);
            self
        }
        /// <p>The number of active simulation jobs create as part of the batch that can be in an active state at the same time. </p>
        /// <p>Active states include: <code>Pending</code>,<code>Preparing</code>, <code>Running</code>, <code>Restarting</code>, <code>RunningFailed</code> and <code>Terminating</code>. All other states are terminal states. </p>
        pub fn set_max_concurrency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrency = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPolicy`](crate::model::BatchPolicy)
        pub fn build(self) -> crate::model::BatchPolicy {
            crate::model::BatchPolicy {
                timeout_in_seconds: self.timeout_in_seconds,
                max_concurrency: self.max_concurrency,
            }
        }
    }
}
impl BatchPolicy {
    /// Creates a new builder-style object to manufacture [`BatchPolicy`](crate::model::BatchPolicy)
    pub fn builder() -> crate::model::batch_policy::Builder {
        crate::model::batch_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SimulationJobBatchStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Canceling,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Completing,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    #[allow(missing_docs)] // documentation missing in model
    TimingOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SimulationJobBatchStatus {
    fn from(s: &str) -> Self {
        match s {
            "Canceled" => SimulationJobBatchStatus::Canceled,
            "Canceling" => SimulationJobBatchStatus::Canceling,
            "Completed" => SimulationJobBatchStatus::Completed,
            "Completing" => SimulationJobBatchStatus::Completing,
            "Failed" => SimulationJobBatchStatus::Failed,
            "InProgress" => SimulationJobBatchStatus::InProgress,
            "Pending" => SimulationJobBatchStatus::Pending,
            "TimedOut" => SimulationJobBatchStatus::TimedOut,
            "TimingOut" => SimulationJobBatchStatus::TimingOut,
            other => SimulationJobBatchStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SimulationJobBatchStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SimulationJobBatchStatus::from(s))
    }
}
impl SimulationJobBatchStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SimulationJobBatchStatus::Canceled => "Canceled",
            SimulationJobBatchStatus::Canceling => "Canceling",
            SimulationJobBatchStatus::Completed => "Completed",
            SimulationJobBatchStatus::Completing => "Completing",
            SimulationJobBatchStatus::Failed => "Failed",
            SimulationJobBatchStatus::InProgress => "InProgress",
            SimulationJobBatchStatus::Pending => "Pending",
            SimulationJobBatchStatus::TimedOut => "TimedOut",
            SimulationJobBatchStatus::TimingOut => "TimingOut",
            SimulationJobBatchStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Canceled",
            "Canceling",
            "Completed",
            "Completing",
            "Failed",
            "InProgress",
            "Pending",
            "TimedOut",
            "TimingOut",
        ]
    }
}
impl AsRef<str> for SimulationJobBatchStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information for a template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemplateSummary {
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the template was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the template that you're using.</p>
    pub version: std::option::Option<std::string::String>,
}
impl TemplateSummary {
    /// <p>The Amazon Resource Name (ARN) of the template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the template was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The name of the template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the template that you're using.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for TemplateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemplateSummary");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`TemplateSummary`](crate::model::TemplateSummary)
pub mod template_summary {
    /// A builder for [`TemplateSummary`](crate::model::TemplateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the template was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the template was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The name of the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the template that you're using.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the template that you're using.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`TemplateSummary`](crate::model::TemplateSummary)
        pub fn build(self) -> crate::model::TemplateSummary {
            crate::model::TemplateSummary {
                arn: self.arn,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl TemplateSummary {
    /// Creates a new builder-style object to manufacture [`TemplateSummary`](crate::model::TemplateSummary)
    pub fn builder() -> crate::model::template_summary::Builder {
        crate::model::template_summary::Builder::default()
    }
}

/// <p>Information about a world.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorldSummary {
    /// <p>The Amazon Resource Name (ARN) of the world.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (arn) of the world generation job.</p>
    pub generation_job: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub template: std::option::Option<std::string::String>,
}
impl WorldSummary {
    /// <p>The Amazon Resource Name (ARN) of the world.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Amazon Resource Name (arn) of the world generation job.</p>
    pub fn generation_job(&self) -> std::option::Option<&str> {
        self.generation_job.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
}
impl std::fmt::Debug for WorldSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorldSummary");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("generation_job", &self.generation_job);
        formatter.field("template", &self.template);
        formatter.finish()
    }
}
/// See [`WorldSummary`](crate::model::WorldSummary)
pub mod world_summary {
    /// A builder for [`WorldSummary`](crate::model::WorldSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) generation_job: std::option::Option<std::string::String>,
        pub(crate) template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generation job.</p>
        pub fn generation_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generation job.</p>
        pub fn set_generation_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_job = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`WorldSummary`](crate::model::WorldSummary)
        pub fn build(self) -> crate::model::WorldSummary {
            crate::model::WorldSummary {
                arn: self.arn,
                created_at: self.created_at,
                generation_job: self.generation_job,
                template: self.template,
            }
        }
    }
}
impl WorldSummary {
    /// Creates a new builder-style object to manufacture [`WorldSummary`](crate::model::WorldSummary)
    pub fn builder() -> crate::model::world_summary::Builder {
        crate::model::world_summary::Builder::default()
    }
}

/// <p>Information about a filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A list of values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name of the filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A list of values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Information about a world generator job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorldGenerationJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the world generator job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the world generator job:</p>
    /// <dl>
    /// <dt>
    /// Pending
    /// </dt>
    /// <dd>
    /// <p>The world generator job request is pending.</p>
    /// </dd>
    /// <dt>
    /// Running
    /// </dt>
    /// <dd>
    /// <p>The world generator job is running. </p>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <p>The world generator job completed. </p>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <p>The world generator job failed. See <code>failureCode</code> for more information. </p>
    /// </dd>
    /// <dt>
    /// PartialFailed
    /// </dt>
    /// <dd>
    /// <p>Some worlds did not generate.</p>
    /// </dd>
    /// <dt>
    /// Canceled
    /// </dt>
    /// <dd>
    /// <p>The world generator job was cancelled.</p>
    /// </dd>
    /// <dt>
    /// Canceling
    /// </dt>
    /// <dd>
    /// <p>The world generator job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::WorldGenerationJobStatus>,
    /// <p>Information about the world count.</p>
    pub world_count: std::option::Option<crate::model::WorldCount>,
    /// <p>The number of worlds that were generated.</p>
    pub succeeded_world_count: i32,
    /// <p>The number of worlds that failed.</p>
    pub failed_world_count: i32,
}
impl WorldGenerationJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world generator job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The status of the world generator job:</p>
    /// <dl>
    /// <dt>
    /// Pending
    /// </dt>
    /// <dd>
    /// <p>The world generator job request is pending.</p>
    /// </dd>
    /// <dt>
    /// Running
    /// </dt>
    /// <dd>
    /// <p>The world generator job is running. </p>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <p>The world generator job completed. </p>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <p>The world generator job failed. See <code>failureCode</code> for more information. </p>
    /// </dd>
    /// <dt>
    /// PartialFailed
    /// </dt>
    /// <dd>
    /// <p>Some worlds did not generate.</p>
    /// </dd>
    /// <dt>
    /// Canceled
    /// </dt>
    /// <dd>
    /// <p>The world generator job was cancelled.</p>
    /// </dd>
    /// <dt>
    /// Canceling
    /// </dt>
    /// <dd>
    /// <p>The world generator job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::WorldGenerationJobStatus> {
        self.status.as_ref()
    }
    /// <p>Information about the world count.</p>
    pub fn world_count(&self) -> std::option::Option<&crate::model::WorldCount> {
        self.world_count.as_ref()
    }
    /// <p>The number of worlds that were generated.</p>
    pub fn succeeded_world_count(&self) -> i32 {
        self.succeeded_world_count
    }
    /// <p>The number of worlds that failed.</p>
    pub fn failed_world_count(&self) -> i32 {
        self.failed_world_count
    }
}
impl std::fmt::Debug for WorldGenerationJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorldGenerationJobSummary");
        formatter.field("arn", &self.arn);
        formatter.field("template", &self.template);
        formatter.field("created_at", &self.created_at);
        formatter.field("status", &self.status);
        formatter.field("world_count", &self.world_count);
        formatter.field("succeeded_world_count", &self.succeeded_world_count);
        formatter.field("failed_world_count", &self.failed_world_count);
        formatter.finish()
    }
}
/// See [`WorldGenerationJobSummary`](crate::model::WorldGenerationJobSummary)
pub mod world_generation_job_summary {
    /// A builder for [`WorldGenerationJobSummary`](crate::model::WorldGenerationJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::WorldGenerationJobStatus>,
        pub(crate) world_count: std::option::Option<crate::model::WorldCount>,
        pub(crate) succeeded_world_count: std::option::Option<i32>,
        pub(crate) failed_world_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world generator job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world generator job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the world generator job:</p>
        /// <dl>
        /// <dt>
        /// Pending
        /// </dt>
        /// <dd>
        /// <p>The world generator job request is pending.</p>
        /// </dd>
        /// <dt>
        /// Running
        /// </dt>
        /// <dd>
        /// <p>The world generator job is running. </p>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <p>The world generator job completed. </p>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <p>The world generator job failed. See <code>failureCode</code> for more information. </p>
        /// </dd>
        /// <dt>
        /// PartialFailed
        /// </dt>
        /// <dd>
        /// <p>Some worlds did not generate.</p>
        /// </dd>
        /// <dt>
        /// Canceled
        /// </dt>
        /// <dd>
        /// <p>The world generator job was cancelled.</p>
        /// </dd>
        /// <dt>
        /// Canceling
        /// </dt>
        /// <dd>
        /// <p>The world generator job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::WorldGenerationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the world generator job:</p>
        /// <dl>
        /// <dt>
        /// Pending
        /// </dt>
        /// <dd>
        /// <p>The world generator job request is pending.</p>
        /// </dd>
        /// <dt>
        /// Running
        /// </dt>
        /// <dd>
        /// <p>The world generator job is running. </p>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <p>The world generator job completed. </p>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <p>The world generator job failed. See <code>failureCode</code> for more information. </p>
        /// </dd>
        /// <dt>
        /// PartialFailed
        /// </dt>
        /// <dd>
        /// <p>Some worlds did not generate.</p>
        /// </dd>
        /// <dt>
        /// Canceled
        /// </dt>
        /// <dd>
        /// <p>The world generator job was cancelled.</p>
        /// </dd>
        /// <dt>
        /// Canceling
        /// </dt>
        /// <dd>
        /// <p>The world generator job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorldGenerationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about the world count.</p>
        pub fn world_count(mut self, input: crate::model::WorldCount) -> Self {
            self.world_count = Some(input);
            self
        }
        /// <p>Information about the world count.</p>
        pub fn set_world_count(
            mut self,
            input: std::option::Option<crate::model::WorldCount>,
        ) -> Self {
            self.world_count = input;
            self
        }
        /// <p>The number of worlds that were generated.</p>
        pub fn succeeded_world_count(mut self, input: i32) -> Self {
            self.succeeded_world_count = Some(input);
            self
        }
        /// <p>The number of worlds that were generated.</p>
        pub fn set_succeeded_world_count(mut self, input: std::option::Option<i32>) -> Self {
            self.succeeded_world_count = input;
            self
        }
        /// <p>The number of worlds that failed.</p>
        pub fn failed_world_count(mut self, input: i32) -> Self {
            self.failed_world_count = Some(input);
            self
        }
        /// <p>The number of worlds that failed.</p>
        pub fn set_failed_world_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_world_count = input;
            self
        }
        /// Consumes the builder and constructs a [`WorldGenerationJobSummary`](crate::model::WorldGenerationJobSummary)
        pub fn build(self) -> crate::model::WorldGenerationJobSummary {
            crate::model::WorldGenerationJobSummary {
                arn: self.arn,
                template: self.template,
                created_at: self.created_at,
                status: self.status,
                world_count: self.world_count,
                succeeded_world_count: self.succeeded_world_count.unwrap_or_default(),
                failed_world_count: self.failed_world_count.unwrap_or_default(),
            }
        }
    }
}
impl WorldGenerationJobSummary {
    /// Creates a new builder-style object to manufacture [`WorldGenerationJobSummary`](crate::model::WorldGenerationJobSummary)
    pub fn builder() -> crate::model::world_generation_job_summary::Builder {
        crate::model::world_generation_job_summary::Builder::default()
    }
}

/// <p>The number of worlds that will be created. You can configure the number of unique floorplans and the number of unique interiors for each floor plan. For example, if you want 1 world with 20 unique interiors, you set <code>floorplanCount = 1</code> and <code>interiorCountPerFloorplan = 20</code>. This will result in 20 worlds (<code>floorplanCount</code> * <code>interiorCountPerFloorplan)</code>. </p>
/// <p>If you set <code>floorplanCount = 4</code> and <code>interiorCountPerFloorplan = 5</code>, there will be 20 worlds with 5 unique floor plans. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorldCount {
    /// <p>The number of unique floorplans.</p>
    pub floorplan_count: std::option::Option<i32>,
    /// <p>The number of unique interiors per floorplan.</p>
    pub interior_count_per_floorplan: std::option::Option<i32>,
}
impl WorldCount {
    /// <p>The number of unique floorplans.</p>
    pub fn floorplan_count(&self) -> std::option::Option<i32> {
        self.floorplan_count
    }
    /// <p>The number of unique interiors per floorplan.</p>
    pub fn interior_count_per_floorplan(&self) -> std::option::Option<i32> {
        self.interior_count_per_floorplan
    }
}
impl std::fmt::Debug for WorldCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorldCount");
        formatter.field("floorplan_count", &self.floorplan_count);
        formatter.field(
            "interior_count_per_floorplan",
            &self.interior_count_per_floorplan,
        );
        formatter.finish()
    }
}
/// See [`WorldCount`](crate::model::WorldCount)
pub mod world_count {
    /// A builder for [`WorldCount`](crate::model::WorldCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) floorplan_count: std::option::Option<i32>,
        pub(crate) interior_count_per_floorplan: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of unique floorplans.</p>
        pub fn floorplan_count(mut self, input: i32) -> Self {
            self.floorplan_count = Some(input);
            self
        }
        /// <p>The number of unique floorplans.</p>
        pub fn set_floorplan_count(mut self, input: std::option::Option<i32>) -> Self {
            self.floorplan_count = input;
            self
        }
        /// <p>The number of unique interiors per floorplan.</p>
        pub fn interior_count_per_floorplan(mut self, input: i32) -> Self {
            self.interior_count_per_floorplan = Some(input);
            self
        }
        /// <p>The number of unique interiors per floorplan.</p>
        pub fn set_interior_count_per_floorplan(mut self, input: std::option::Option<i32>) -> Self {
            self.interior_count_per_floorplan = input;
            self
        }
        /// Consumes the builder and constructs a [`WorldCount`](crate::model::WorldCount)
        pub fn build(self) -> crate::model::WorldCount {
            crate::model::WorldCount {
                floorplan_count: self.floorplan_count,
                interior_count_per_floorplan: self.interior_count_per_floorplan,
            }
        }
    }
}
impl WorldCount {
    /// Creates a new builder-style object to manufacture [`WorldCount`](crate::model::WorldCount)
    pub fn builder() -> crate::model::world_count::Builder {
        crate::model::world_count::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorldGenerationJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Canceling,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PartialFailed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorldGenerationJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "Canceled" => WorldGenerationJobStatus::Canceled,
            "Canceling" => WorldGenerationJobStatus::Canceling,
            "Completed" => WorldGenerationJobStatus::Completed,
            "Failed" => WorldGenerationJobStatus::Failed,
            "PartialFailed" => WorldGenerationJobStatus::PartialFailed,
            "Pending" => WorldGenerationJobStatus::Pending,
            "Running" => WorldGenerationJobStatus::Running,
            other => WorldGenerationJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorldGenerationJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorldGenerationJobStatus::from(s))
    }
}
impl WorldGenerationJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorldGenerationJobStatus::Canceled => "Canceled",
            WorldGenerationJobStatus::Canceling => "Canceling",
            WorldGenerationJobStatus::Completed => "Completed",
            WorldGenerationJobStatus::Failed => "Failed",
            WorldGenerationJobStatus::PartialFailed => "PartialFailed",
            WorldGenerationJobStatus::Pending => "Pending",
            WorldGenerationJobStatus::Running => "Running",
            WorldGenerationJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Canceled",
            "Canceling",
            "Completed",
            "Failed",
            "PartialFailed",
            "Pending",
            "Running",
        ]
    }
}
impl AsRef<str> for WorldGenerationJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a world export job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorldExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the world export job.</p>
    /// <dl>
    /// <dt>
    /// Pending
    /// </dt>
    /// <dd>
    /// <p>The world export job request is pending.</p>
    /// </dd>
    /// <dt>
    /// Running
    /// </dt>
    /// <dd>
    /// <p>The world export job is running. </p>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <p>The world export job completed. </p>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <p>The world export job failed. See <code>failureCode</code> for more information. </p>
    /// </dd>
    /// <dt>
    /// Canceled
    /// </dt>
    /// <dd>
    /// <p>The world export job was cancelled.</p>
    /// </dd>
    /// <dt>
    /// Canceling
    /// </dt>
    /// <dd>
    /// <p>The world export job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::WorldExportJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of worlds.</p>
    pub worlds: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl WorldExportJobSummary {
    /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the world export job.</p>
    /// <dl>
    /// <dt>
    /// Pending
    /// </dt>
    /// <dd>
    /// <p>The world export job request is pending.</p>
    /// </dd>
    /// <dt>
    /// Running
    /// </dt>
    /// <dd>
    /// <p>The world export job is running. </p>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <p>The world export job completed. </p>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <p>The world export job failed. See <code>failureCode</code> for more information. </p>
    /// </dd>
    /// <dt>
    /// Canceled
    /// </dt>
    /// <dd>
    /// <p>The world export job was cancelled.</p>
    /// </dd>
    /// <dt>
    /// Canceling
    /// </dt>
    /// <dd>
    /// <p>The world export job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::WorldExportJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>A list of worlds.</p>
    pub fn worlds(&self) -> std::option::Option<&[std::string::String]> {
        self.worlds.as_deref()
    }
}
impl std::fmt::Debug for WorldExportJobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorldExportJobSummary");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("worlds", &self.worlds);
        formatter.finish()
    }
}
/// See [`WorldExportJobSummary`](crate::model::WorldExportJobSummary)
pub mod world_export_job_summary {
    /// A builder for [`WorldExportJobSummary`](crate::model::WorldExportJobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorldExportJobStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) worlds: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the world export job.</p>
        /// <dl>
        /// <dt>
        /// Pending
        /// </dt>
        /// <dd>
        /// <p>The world export job request is pending.</p>
        /// </dd>
        /// <dt>
        /// Running
        /// </dt>
        /// <dd>
        /// <p>The world export job is running. </p>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <p>The world export job completed. </p>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <p>The world export job failed. See <code>failureCode</code> for more information. </p>
        /// </dd>
        /// <dt>
        /// Canceled
        /// </dt>
        /// <dd>
        /// <p>The world export job was cancelled.</p>
        /// </dd>
        /// <dt>
        /// Canceling
        /// </dt>
        /// <dd>
        /// <p>The world export job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::WorldExportJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the world export job.</p>
        /// <dl>
        /// <dt>
        /// Pending
        /// </dt>
        /// <dd>
        /// <p>The world export job request is pending.</p>
        /// </dd>
        /// <dt>
        /// Running
        /// </dt>
        /// <dd>
        /// <p>The world export job is running. </p>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <p>The world export job completed. </p>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <p>The world export job failed. See <code>failureCode</code> for more information. </p>
        /// </dd>
        /// <dt>
        /// Canceled
        /// </dt>
        /// <dd>
        /// <p>The world export job was cancelled.</p>
        /// </dd>
        /// <dt>
        /// Canceling
        /// </dt>
        /// <dd>
        /// <p>The world export job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorldExportJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `worlds`.
        ///
        /// To override the contents of this collection use [`set_worlds`](Self::set_worlds).
        ///
        /// <p>A list of worlds.</p>
        pub fn worlds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.worlds.unwrap_or_default();
            v.push(input.into());
            self.worlds = Some(v);
            self
        }
        /// <p>A list of worlds.</p>
        pub fn set_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.worlds = input;
            self
        }
        /// Consumes the builder and constructs a [`WorldExportJobSummary`](crate::model::WorldExportJobSummary)
        pub fn build(self) -> crate::model::WorldExportJobSummary {
            crate::model::WorldExportJobSummary {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                worlds: self.worlds,
            }
        }
    }
}
impl WorldExportJobSummary {
    /// Creates a new builder-style object to manufacture [`WorldExportJobSummary`](crate::model::WorldExportJobSummary)
    pub fn builder() -> crate::model::world_export_job_summary::Builder {
        crate::model::world_export_job_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorldExportJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Canceling,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorldExportJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "Canceled" => WorldExportJobStatus::Canceled,
            "Canceling" => WorldExportJobStatus::Canceling,
            "Completed" => WorldExportJobStatus::Completed,
            "Failed" => WorldExportJobStatus::Failed,
            "Pending" => WorldExportJobStatus::Pending,
            "Running" => WorldExportJobStatus::Running,
            other => WorldExportJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorldExportJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorldExportJobStatus::from(s))
    }
}
impl WorldExportJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorldExportJobStatus::Canceled => "Canceled",
            WorldExportJobStatus::Canceling => "Canceling",
            WorldExportJobStatus::Completed => "Completed",
            WorldExportJobStatus::Failed => "Failed",
            WorldExportJobStatus::Pending => "Pending",
            WorldExportJobStatus::Running => "Running",
            WorldExportJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Canceled",
            "Canceling",
            "Completed",
            "Failed",
            "Pending",
            "Running",
        ]
    }
}
impl AsRef<str> for WorldExportJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a simulation job batch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulationJobBatchSummary {
    /// <p>The Amazon Resource Name (ARN) of the batch.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the simulation job batch.</p>
    /// <dl>
    /// <dt>
    /// Pending
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch request is pending.</p>
    /// </dd>
    /// <dt>
    /// InProgress
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch is in progress. </p>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for more information.</p>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or <code>Failed</code>). </p>
    /// </dd>
    /// <dt>
    /// Canceled
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job was cancelled.</p>
    /// </dd>
    /// <dt>
    /// Canceling
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job is being cancelled.</p>
    /// </dd>
    /// <dt>
    /// Completing
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job is completing.</p>
    /// </dd>
    /// <dt>
    /// TimingOut
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch is timing out.</p>
    /// <p>If a batch timing out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing request, the batch status will be <code>TimedOut</code>. </p>
    /// </dd>
    /// <dt>
    /// TimedOut
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job timed out.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::SimulationJobBatchStatus>,
    /// <p>The number of failed simulation job requests.</p>
    pub failed_request_count: i32,
    /// <p>The number of pending simulation job requests.</p>
    pub pending_request_count: i32,
    /// <p>The number of created simulation job requests.</p>
    pub created_request_count: i32,
}
impl SimulationJobBatchSummary {
    /// <p>The Amazon Resource Name (ARN) of the batch.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The status of the simulation job batch.</p>
    /// <dl>
    /// <dt>
    /// Pending
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch request is pending.</p>
    /// </dd>
    /// <dt>
    /// InProgress
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch is in progress. </p>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for more information.</p>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or <code>Failed</code>). </p>
    /// </dd>
    /// <dt>
    /// Canceled
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job was cancelled.</p>
    /// </dd>
    /// <dt>
    /// Canceling
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job is being cancelled.</p>
    /// </dd>
    /// <dt>
    /// Completing
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job is completing.</p>
    /// </dd>
    /// <dt>
    /// TimingOut
    /// </dt>
    /// <dd>
    /// <p>The simulation job batch is timing out.</p>
    /// <p>If a batch timing out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing request, the batch status will be <code>TimedOut</code>. </p>
    /// </dd>
    /// <dt>
    /// TimedOut
    /// </dt>
    /// <dd>
    /// <p>The simulation batch job timed out.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::SimulationJobBatchStatus> {
        self.status.as_ref()
    }
    /// <p>The number of failed simulation job requests.</p>
    pub fn failed_request_count(&self) -> i32 {
        self.failed_request_count
    }
    /// <p>The number of pending simulation job requests.</p>
    pub fn pending_request_count(&self) -> i32 {
        self.pending_request_count
    }
    /// <p>The number of created simulation job requests.</p>
    pub fn created_request_count(&self) -> i32 {
        self.created_request_count
    }
}
impl std::fmt::Debug for SimulationJobBatchSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulationJobBatchSummary");
        formatter.field("arn", &self.arn);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("created_at", &self.created_at);
        formatter.field("status", &self.status);
        formatter.field("failed_request_count", &self.failed_request_count);
        formatter.field("pending_request_count", &self.pending_request_count);
        formatter.field("created_request_count", &self.created_request_count);
        formatter.finish()
    }
}
/// See [`SimulationJobBatchSummary`](crate::model::SimulationJobBatchSummary)
pub mod simulation_job_batch_summary {
    /// A builder for [`SimulationJobBatchSummary`](crate::model::SimulationJobBatchSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::SimulationJobBatchStatus>,
        pub(crate) failed_request_count: std::option::Option<i32>,
        pub(crate) pending_request_count: std::option::Option<i32>,
        pub(crate) created_request_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the batch.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the simulation job batch.</p>
        /// <dl>
        /// <dt>
        /// Pending
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch request is pending.</p>
        /// </dd>
        /// <dt>
        /// InProgress
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch is in progress. </p>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for more information.</p>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or <code>Failed</code>). </p>
        /// </dd>
        /// <dt>
        /// Canceled
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job was cancelled.</p>
        /// </dd>
        /// <dt>
        /// Canceling
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job is being cancelled.</p>
        /// </dd>
        /// <dt>
        /// Completing
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job is completing.</p>
        /// </dd>
        /// <dt>
        /// TimingOut
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch is timing out.</p>
        /// <p>If a batch timing out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing request, the batch status will be <code>TimedOut</code>. </p>
        /// </dd>
        /// <dt>
        /// TimedOut
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job timed out.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::SimulationJobBatchStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the simulation job batch.</p>
        /// <dl>
        /// <dt>
        /// Pending
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch request is pending.</p>
        /// </dd>
        /// <dt>
        /// InProgress
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch is in progress. </p>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like <code>InternalServiceError</code>). See <code>failureCode</code> and <code>failureReason</code> for more information.</p>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to <code>InternalServiceError</code> and (2) when all created simulation jobs have reached a terminal state (for example, <code>Completed</code> or <code>Failed</code>). </p>
        /// </dd>
        /// <dt>
        /// Canceled
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job was cancelled.</p>
        /// </dd>
        /// <dt>
        /// Canceling
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job is being cancelled.</p>
        /// </dd>
        /// <dt>
        /// Completing
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job is completing.</p>
        /// </dd>
        /// <dt>
        /// TimingOut
        /// </dt>
        /// <dd>
        /// <p>The simulation job batch is timing out.</p>
        /// <p>If a batch timing out, and there are pending requests that were failing due to an internal failure (like <code>InternalServiceError</code>), the batch status will be <code>Failed</code>. If there are no such failing request, the batch status will be <code>TimedOut</code>. </p>
        /// </dd>
        /// <dt>
        /// TimedOut
        /// </dt>
        /// <dd>
        /// <p>The simulation batch job timed out.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SimulationJobBatchStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The number of failed simulation job requests.</p>
        pub fn failed_request_count(mut self, input: i32) -> Self {
            self.failed_request_count = Some(input);
            self
        }
        /// <p>The number of failed simulation job requests.</p>
        pub fn set_failed_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failed_request_count = input;
            self
        }
        /// <p>The number of pending simulation job requests.</p>
        pub fn pending_request_count(mut self, input: i32) -> Self {
            self.pending_request_count = Some(input);
            self
        }
        /// <p>The number of pending simulation job requests.</p>
        pub fn set_pending_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_request_count = input;
            self
        }
        /// <p>The number of created simulation job requests.</p>
        pub fn created_request_count(mut self, input: i32) -> Self {
            self.created_request_count = Some(input);
            self
        }
        /// <p>The number of created simulation job requests.</p>
        pub fn set_created_request_count(mut self, input: std::option::Option<i32>) -> Self {
            self.created_request_count = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulationJobBatchSummary`](crate::model::SimulationJobBatchSummary)
        pub fn build(self) -> crate::model::SimulationJobBatchSummary {
            crate::model::SimulationJobBatchSummary {
                arn: self.arn,
                last_updated_at: self.last_updated_at,
                created_at: self.created_at,
                status: self.status,
                failed_request_count: self.failed_request_count.unwrap_or_default(),
                pending_request_count: self.pending_request_count.unwrap_or_default(),
                created_request_count: self.created_request_count.unwrap_or_default(),
            }
        }
    }
}
impl SimulationJobBatchSummary {
    /// Creates a new builder-style object to manufacture [`SimulationJobBatchSummary`](crate::model::SimulationJobBatchSummary)
    pub fn builder() -> crate::model::simulation_job_batch_summary::Builder {
        crate::model::simulation_job_batch_summary::Builder::default()
    }
}

/// <p>Summary information for a simulation application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulationApplicationSummary {
    /// <p>The name of the simulation application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the simulation application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about a robot software suite (ROS distribution).</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>Information about a simulation software suite.</p>
    pub simulation_software_suite: std::option::Option<crate::model::SimulationSoftwareSuite>,
}
impl SimulationApplicationSummary {
    /// <p>The name of the simulation application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the simulation application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>Information about a robot software suite (ROS distribution).</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>Information about a simulation software suite.</p>
    pub fn simulation_software_suite(
        &self,
    ) -> std::option::Option<&crate::model::SimulationSoftwareSuite> {
        self.simulation_software_suite.as_ref()
    }
}
impl std::fmt::Debug for SimulationApplicationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulationApplicationSummary");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("simulation_software_suite", &self.simulation_software_suite);
        formatter.finish()
    }
}
/// See [`SimulationApplicationSummary`](crate::model::SimulationApplicationSummary)
pub mod simulation_application_summary {
    /// A builder for [`SimulationApplicationSummary`](crate::model::SimulationApplicationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) simulation_software_suite:
            std::option::Option<crate::model::SimulationSoftwareSuite>,
    }
    impl Builder {
        /// <p>The name of the simulation application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>Information about a robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>Information about a robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>Information about a simulation software suite.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.simulation_software_suite = Some(input);
            self
        }
        /// <p>Information about a simulation software suite.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.simulation_software_suite = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulationApplicationSummary`](crate::model::SimulationApplicationSummary)
        pub fn build(self) -> crate::model::SimulationApplicationSummary {
            crate::model::SimulationApplicationSummary {
                name: self.name,
                arn: self.arn,
                version: self.version,
                last_updated_at: self.last_updated_at,
                robot_software_suite: self.robot_software_suite,
                simulation_software_suite: self.simulation_software_suite,
            }
        }
    }
}
impl SimulationApplicationSummary {
    /// Creates a new builder-style object to manufacture [`SimulationApplicationSummary`](crate::model::SimulationApplicationSummary)
    pub fn builder() -> crate::model::simulation_application_summary::Builder {
        crate::model::simulation_application_summary::Builder::default()
    }
}

/// <p>Information about a robot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Robot {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the robot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The status of the robot.</p>
    pub status: std::option::Option<crate::model::RobotStatus>,
    /// <p>The Greengrass group associated with the robot.</p>
    pub green_grass_group_id: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The architecture of the robot.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub last_deployment_job: std::option::Option<std::string::String>,
    /// <p>The time of the last deployment.</p>
    pub last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Robot {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the robot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The status of the robot.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RobotStatus> {
        self.status.as_ref()
    }
    /// <p>The Greengrass group associated with the robot.</p>
    pub fn green_grass_group_id(&self) -> std::option::Option<&str> {
        self.green_grass_group_id.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The architecture of the robot.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub fn last_deployment_job(&self) -> std::option::Option<&str> {
        self.last_deployment_job.as_deref()
    }
    /// <p>The time of the last deployment.</p>
    pub fn last_deployment_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_time.as_ref()
    }
}
impl std::fmt::Debug for Robot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Robot");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("status", &self.status);
        formatter.field("green_grass_group_id", &self.green_grass_group_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("architecture", &self.architecture);
        formatter.field("last_deployment_job", &self.last_deployment_job);
        formatter.field("last_deployment_time", &self.last_deployment_time);
        formatter.finish()
    }
}
/// See [`Robot`](crate::model::Robot)
pub mod robot {
    /// A builder for [`Robot`](crate::model::Robot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RobotStatus>,
        pub(crate) green_grass_group_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
        pub(crate) last_deployment_job: std::option::Option<std::string::String>,
        pub(crate) last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the robot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>The status of the robot.</p>
        pub fn status(mut self, input: crate::model::RobotStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the robot.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::RobotStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Greengrass group associated with the robot.</p>
        pub fn green_grass_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.green_grass_group_id = Some(input.into());
            self
        }
        /// <p>The Greengrass group associated with the robot.</p>
        pub fn set_green_grass_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.green_grass_group_id = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The architecture of the robot.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The architecture of the robot.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn last_deployment_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_deployment_job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn set_last_deployment_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_job = input;
            self
        }
        /// <p>The time of the last deployment.</p>
        pub fn last_deployment_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_time = Some(input);
            self
        }
        /// <p>The time of the last deployment.</p>
        pub fn set_last_deployment_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Robot`](crate::model::Robot)
        pub fn build(self) -> crate::model::Robot {
            crate::model::Robot {
                arn: self.arn,
                name: self.name,
                fleet_arn: self.fleet_arn,
                status: self.status,
                green_grass_group_id: self.green_grass_group_id,
                created_at: self.created_at,
                architecture: self.architecture,
                last_deployment_job: self.last_deployment_job,
                last_deployment_time: self.last_deployment_time,
            }
        }
    }
}
impl Robot {
    /// Creates a new builder-style object to manufacture [`Robot`](crate::model::Robot)
    pub fn builder() -> crate::model::robot::Builder {
        crate::model::robot::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RobotStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deploying,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InSync,
    #[allow(missing_docs)] // documentation missing in model
    NoResponse,
    #[allow(missing_docs)] // documentation missing in model
    PendingNewDeployment,
    #[allow(missing_docs)] // documentation missing in model
    Registered,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RobotStatus {
    fn from(s: &str) -> Self {
        match s {
            "Available" => RobotStatus::Available,
            "Deploying" => RobotStatus::Deploying,
            "Failed" => RobotStatus::Failed,
            "InSync" => RobotStatus::InSync,
            "NoResponse" => RobotStatus::NoResponse,
            "PendingNewDeployment" => RobotStatus::PendingNewDeployment,
            "Registered" => RobotStatus::Registered,
            other => RobotStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RobotStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RobotStatus::from(s))
    }
}
impl RobotStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RobotStatus::Available => "Available",
            RobotStatus::Deploying => "Deploying",
            RobotStatus::Failed => "Failed",
            RobotStatus::InSync => "InSync",
            RobotStatus::NoResponse => "NoResponse",
            RobotStatus::PendingNewDeployment => "PendingNewDeployment",
            RobotStatus::Registered => "Registered",
            RobotStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Available",
            "Deploying",
            "Failed",
            "InSync",
            "NoResponse",
            "PendingNewDeployment",
            "Registered",
        ]
    }
}
impl AsRef<str> for RobotStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information for a robot application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RobotApplicationSummary {
    /// <p>The name of the robot application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The version of the robot application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about a robot software suite (ROS distribution).</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
}
impl RobotApplicationSummary {
    /// <p>The name of the robot application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The version of the robot application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>Information about a robot software suite (ROS distribution).</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
}
impl std::fmt::Debug for RobotApplicationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RobotApplicationSummary");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("version", &self.version);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.finish()
    }
}
/// See [`RobotApplicationSummary`](crate::model::RobotApplicationSummary)
pub mod robot_application_summary {
    /// A builder for [`RobotApplicationSummary`](crate::model::RobotApplicationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    }
    impl Builder {
        /// <p>The name of the robot application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>Information about a robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>Information about a robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// Consumes the builder and constructs a [`RobotApplicationSummary`](crate::model::RobotApplicationSummary)
        pub fn build(self) -> crate::model::RobotApplicationSummary {
            crate::model::RobotApplicationSummary {
                name: self.name,
                arn: self.arn,
                version: self.version,
                last_updated_at: self.last_updated_at,
                robot_software_suite: self.robot_software_suite,
            }
        }
    }
}
impl RobotApplicationSummary {
    /// Creates a new builder-style object to manufacture [`RobotApplicationSummary`](crate::model::RobotApplicationSummary)
    pub fn builder() -> crate::model::robot_application_summary::Builder {
        crate::model::robot_application_summary::Builder::default()
    }
}

/// <p>Information about a fleet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Fleet {
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the last fleet deployment.</p>
    pub last_deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub last_deployment_job: std::option::Option<std::string::String>,
    /// <p>The time of the last deployment.</p>
    pub last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Fleet {
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The status of the last fleet deployment.</p>
    pub fn last_deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.last_deployment_status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub fn last_deployment_job(&self) -> std::option::Option<&str> {
        self.last_deployment_job.as_deref()
    }
    /// <p>The time of the last deployment.</p>
    pub fn last_deployment_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_time.as_ref()
    }
}
impl std::fmt::Debug for Fleet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Fleet");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_deployment_status", &self.last_deployment_status);
        formatter.field("last_deployment_job", &self.last_deployment_job);
        formatter.field("last_deployment_time", &self.last_deployment_time);
        formatter.finish()
    }
}
/// See [`Fleet`](crate::model::Fleet)
pub mod fleet {
    /// A builder for [`Fleet`](crate::model::Fleet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) last_deployment_job: std::option::Option<std::string::String>,
        pub(crate) last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the last fleet deployment.</p>
        pub fn last_deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.last_deployment_status = Some(input);
            self
        }
        /// <p>The status of the last fleet deployment.</p>
        pub fn set_last_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.last_deployment_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn last_deployment_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_deployment_job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn set_last_deployment_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_job = input;
            self
        }
        /// <p>The time of the last deployment.</p>
        pub fn last_deployment_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_time = Some(input);
            self
        }
        /// <p>The time of the last deployment.</p>
        pub fn set_last_deployment_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Fleet`](crate::model::Fleet)
        pub fn build(self) -> crate::model::Fleet {
            crate::model::Fleet {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                last_deployment_status: self.last_deployment_status,
                last_deployment_job: self.last_deployment_job,
                last_deployment_time: self.last_deployment_time,
            }
        }
    }
}
impl Fleet {
    /// Creates a new builder-style object to manufacture [`Fleet`](crate::model::Fleet)
    pub fn builder() -> crate::model::fleet::Builder {
        crate::model::fleet::Builder::default()
    }
}

/// <p>Information about a deployment job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentJob {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The status of the deployment job.</p>
    pub status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>The deployment application configuration.</p>
    pub deployment_application_configs:
        std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
    /// <p>The deployment configuration.</p>
    pub deployment_config: std::option::Option<crate::model::DeploymentConfig>,
    /// <p>A short description of the reason why the deployment job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The deployment job failure code.</p>
    pub failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
    /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeploymentJob {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The status of the deployment job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.status.as_ref()
    }
    /// <p>The deployment application configuration.</p>
    pub fn deployment_application_configs(
        &self,
    ) -> std::option::Option<&[crate::model::DeploymentApplicationConfig]> {
        self.deployment_application_configs.as_deref()
    }
    /// <p>The deployment configuration.</p>
    pub fn deployment_config(&self) -> std::option::Option<&crate::model::DeploymentConfig> {
        self.deployment_config.as_ref()
    }
    /// <p>A short description of the reason why the deployment job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The deployment job failure code.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::DeploymentJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for DeploymentJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentJob");
        formatter.field("arn", &self.arn);
        formatter.field("fleet", &self.fleet);
        formatter.field("status", &self.status);
        formatter.field(
            "deployment_application_configs",
            &self.deployment_application_configs,
        );
        formatter.field("deployment_config", &self.deployment_config);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`DeploymentJob`](crate::model::DeploymentJob)
pub mod deployment_job {
    /// A builder for [`DeploymentJob`](crate::model::DeploymentJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_application_configs:
            std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        pub(crate) deployment_config: std::option::Option<crate::model::DeploymentConfig>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>The status of the deployment job.</p>
        pub fn status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the deployment job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `deployment_application_configs`.
        ///
        /// To override the contents of this collection use [`set_deployment_application_configs`](Self::set_deployment_application_configs).
        ///
        /// <p>The deployment application configuration.</p>
        pub fn deployment_application_configs(
            mut self,
            input: crate::model::DeploymentApplicationConfig,
        ) -> Self {
            let mut v = self.deployment_application_configs.unwrap_or_default();
            v.push(input);
            self.deployment_application_configs = Some(v);
            self
        }
        /// <p>The deployment application configuration.</p>
        pub fn set_deployment_application_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        ) -> Self {
            self.deployment_application_configs = input;
            self
        }
        /// <p>The deployment configuration.</p>
        pub fn deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.deployment_config = Some(input);
            self
        }
        /// <p>The deployment configuration.</p>
        pub fn set_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.deployment_config = input;
            self
        }
        /// <p>A short description of the reason why the deployment job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>A short description of the reason why the deployment job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The deployment job failure code.</p>
        pub fn failure_code(mut self, input: crate::model::DeploymentJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The deployment job failure code.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::DeploymentJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentJob`](crate::model::DeploymentJob)
        pub fn build(self) -> crate::model::DeploymentJob {
            crate::model::DeploymentJob {
                arn: self.arn,
                fleet: self.fleet,
                status: self.status,
                deployment_application_configs: self.deployment_application_configs,
                deployment_config: self.deployment_config,
                failure_reason: self.failure_reason,
                failure_code: self.failure_code,
                created_at: self.created_at,
            }
        }
    }
}
impl DeploymentJob {
    /// Creates a new builder-style object to manufacture [`DeploymentJob`](crate::model::DeploymentJob)
    pub fn builder() -> crate::model::deployment_job::Builder {
        crate::model::deployment_job::Builder::default()
    }
}

/// <p>Information about worlds that finished.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FinishedWorldsSummary {
    /// <p>The total number of finished worlds.</p>
    pub finished_count: i32,
    /// <p>A list of worlds that succeeded.</p>
    pub succeeded_worlds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about worlds that failed.</p>
    pub failure_summary: std::option::Option<crate::model::FailureSummary>,
}
impl FinishedWorldsSummary {
    /// <p>The total number of finished worlds.</p>
    pub fn finished_count(&self) -> i32 {
        self.finished_count
    }
    /// <p>A list of worlds that succeeded.</p>
    pub fn succeeded_worlds(&self) -> std::option::Option<&[std::string::String]> {
        self.succeeded_worlds.as_deref()
    }
    /// <p>Information about worlds that failed.</p>
    pub fn failure_summary(&self) -> std::option::Option<&crate::model::FailureSummary> {
        self.failure_summary.as_ref()
    }
}
impl std::fmt::Debug for FinishedWorldsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FinishedWorldsSummary");
        formatter.field("finished_count", &self.finished_count);
        formatter.field("succeeded_worlds", &self.succeeded_worlds);
        formatter.field("failure_summary", &self.failure_summary);
        formatter.finish()
    }
}
/// See [`FinishedWorldsSummary`](crate::model::FinishedWorldsSummary)
pub mod finished_worlds_summary {
    /// A builder for [`FinishedWorldsSummary`](crate::model::FinishedWorldsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finished_count: std::option::Option<i32>,
        pub(crate) succeeded_worlds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failure_summary: std::option::Option<crate::model::FailureSummary>,
    }
    impl Builder {
        /// <p>The total number of finished worlds.</p>
        pub fn finished_count(mut self, input: i32) -> Self {
            self.finished_count = Some(input);
            self
        }
        /// <p>The total number of finished worlds.</p>
        pub fn set_finished_count(mut self, input: std::option::Option<i32>) -> Self {
            self.finished_count = input;
            self
        }
        /// Appends an item to `succeeded_worlds`.
        ///
        /// To override the contents of this collection use [`set_succeeded_worlds`](Self::set_succeeded_worlds).
        ///
        /// <p>A list of worlds that succeeded.</p>
        pub fn succeeded_worlds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.succeeded_worlds.unwrap_or_default();
            v.push(input.into());
            self.succeeded_worlds = Some(v);
            self
        }
        /// <p>A list of worlds that succeeded.</p>
        pub fn set_succeeded_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.succeeded_worlds = input;
            self
        }
        /// <p>Information about worlds that failed.</p>
        pub fn failure_summary(mut self, input: crate::model::FailureSummary) -> Self {
            self.failure_summary = Some(input);
            self
        }
        /// <p>Information about worlds that failed.</p>
        pub fn set_failure_summary(
            mut self,
            input: std::option::Option<crate::model::FailureSummary>,
        ) -> Self {
            self.failure_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`FinishedWorldsSummary`](crate::model::FinishedWorldsSummary)
        pub fn build(self) -> crate::model::FinishedWorldsSummary {
            crate::model::FinishedWorldsSummary {
                finished_count: self.finished_count.unwrap_or_default(),
                succeeded_worlds: self.succeeded_worlds,
                failure_summary: self.failure_summary,
            }
        }
    }
}
impl FinishedWorldsSummary {
    /// Creates a new builder-style object to manufacture [`FinishedWorldsSummary`](crate::model::FinishedWorldsSummary)
    pub fn builder() -> crate::model::finished_worlds_summary::Builder {
        crate::model::finished_worlds_summary::Builder::default()
    }
}

/// <p>Information about worlds that failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailureSummary {
    /// <p>The total number of failures.</p>
    pub total_failure_count: i32,
    /// <p>The worlds that failed.</p>
    pub failures: std::option::Option<std::vec::Vec<crate::model::WorldFailure>>,
}
impl FailureSummary {
    /// <p>The total number of failures.</p>
    pub fn total_failure_count(&self) -> i32 {
        self.total_failure_count
    }
    /// <p>The worlds that failed.</p>
    pub fn failures(&self) -> std::option::Option<&[crate::model::WorldFailure]> {
        self.failures.as_deref()
    }
}
impl std::fmt::Debug for FailureSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailureSummary");
        formatter.field("total_failure_count", &self.total_failure_count);
        formatter.field("failures", &self.failures);
        formatter.finish()
    }
}
/// See [`FailureSummary`](crate::model::FailureSummary)
pub mod failure_summary {
    /// A builder for [`FailureSummary`](crate::model::FailureSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_failure_count: std::option::Option<i32>,
        pub(crate) failures: std::option::Option<std::vec::Vec<crate::model::WorldFailure>>,
    }
    impl Builder {
        /// <p>The total number of failures.</p>
        pub fn total_failure_count(mut self, input: i32) -> Self {
            self.total_failure_count = Some(input);
            self
        }
        /// <p>The total number of failures.</p>
        pub fn set_total_failure_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_failure_count = input;
            self
        }
        /// Appends an item to `failures`.
        ///
        /// To override the contents of this collection use [`set_failures`](Self::set_failures).
        ///
        /// <p>The worlds that failed.</p>
        pub fn failures(mut self, input: crate::model::WorldFailure) -> Self {
            let mut v = self.failures.unwrap_or_default();
            v.push(input);
            self.failures = Some(v);
            self
        }
        /// <p>The worlds that failed.</p>
        pub fn set_failures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorldFailure>>,
        ) -> Self {
            self.failures = input;
            self
        }
        /// Consumes the builder and constructs a [`FailureSummary`](crate::model::FailureSummary)
        pub fn build(self) -> crate::model::FailureSummary {
            crate::model::FailureSummary {
                total_failure_count: self.total_failure_count.unwrap_or_default(),
                failures: self.failures,
            }
        }
    }
}
impl FailureSummary {
    /// Creates a new builder-style object to manufacture [`FailureSummary`](crate::model::FailureSummary)
    pub fn builder() -> crate::model::failure_summary::Builder {
        crate::model::failure_summary::Builder::default()
    }
}

/// <p>Information about a failed world.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorldFailure {
    /// <p>The failure code of the world export job if it failed:</p>
    /// <dl>
    /// <dt>
    /// InternalServiceError
    /// </dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>
    /// LimitExceeded
    /// </dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>
    /// ResourceNotFound
    /// </dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>
    /// RequestThrottled
    /// </dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>
    /// InvalidInput
    /// </dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
    /// <p>The sample reason why the world failed. World errors are aggregated. A sample is used as the <code>sampleFailureReason</code>. </p>
    pub sample_failure_reason: std::option::Option<std::string::String>,
    /// <p>The number of failed worlds.</p>
    pub failure_count: i32,
}
impl WorldFailure {
    /// <p>The failure code of the world export job if it failed:</p>
    /// <dl>
    /// <dt>
    /// InternalServiceError
    /// </dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>
    /// LimitExceeded
    /// </dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>
    /// ResourceNotFound
    /// </dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>
    /// RequestThrottled
    /// </dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>
    /// InvalidInput
    /// </dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::WorldGenerationJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The sample reason why the world failed. World errors are aggregated. A sample is used as the <code>sampleFailureReason</code>. </p>
    pub fn sample_failure_reason(&self) -> std::option::Option<&str> {
        self.sample_failure_reason.as_deref()
    }
    /// <p>The number of failed worlds.</p>
    pub fn failure_count(&self) -> i32 {
        self.failure_count
    }
}
impl std::fmt::Debug for WorldFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorldFailure");
        formatter.field("failure_code", &self.failure_code);
        formatter.field("sample_failure_reason", &self.sample_failure_reason);
        formatter.field("failure_count", &self.failure_count);
        formatter.finish()
    }
}
/// See [`WorldFailure`](crate::model::WorldFailure)
pub mod world_failure {
    /// A builder for [`WorldFailure`](crate::model::WorldFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_code: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
        pub(crate) sample_failure_reason: std::option::Option<std::string::String>,
        pub(crate) failure_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The failure code of the world export job if it failed:</p>
        /// <dl>
        /// <dt>
        /// InternalServiceError
        /// </dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>
        /// LimitExceeded
        /// </dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>
        /// ResourceNotFound
        /// </dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>
        /// RequestThrottled
        /// </dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>
        /// InvalidInput
        /// </dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::WorldGenerationJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the world export job if it failed:</p>
        /// <dl>
        /// <dt>
        /// InternalServiceError
        /// </dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>
        /// LimitExceeded
        /// </dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>
        /// ResourceNotFound
        /// </dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>
        /// RequestThrottled
        /// </dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>
        /// InvalidInput
        /// </dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The sample reason why the world failed. World errors are aggregated. A sample is used as the <code>sampleFailureReason</code>. </p>
        pub fn sample_failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.sample_failure_reason = Some(input.into());
            self
        }
        /// <p>The sample reason why the world failed. World errors are aggregated. A sample is used as the <code>sampleFailureReason</code>. </p>
        pub fn set_sample_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sample_failure_reason = input;
            self
        }
        /// <p>The number of failed worlds.</p>
        pub fn failure_count(mut self, input: i32) -> Self {
            self.failure_count = Some(input);
            self
        }
        /// <p>The number of failed worlds.</p>
        pub fn set_failure_count(mut self, input: std::option::Option<i32>) -> Self {
            self.failure_count = input;
            self
        }
        /// Consumes the builder and constructs a [`WorldFailure`](crate::model::WorldFailure)
        pub fn build(self) -> crate::model::WorldFailure {
            crate::model::WorldFailure {
                failure_code: self.failure_code,
                sample_failure_reason: self.sample_failure_reason,
                failure_count: self.failure_count.unwrap_or_default(),
            }
        }
    }
}
impl WorldFailure {
    /// Creates a new builder-style object to manufacture [`WorldFailure`](crate::model::WorldFailure)
    pub fn builder() -> crate::model::world_failure::Builder {
        crate::model::world_failure::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorldGenerationJobErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AllWorldGenerationFailed,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidInput,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    RequestThrottled,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorldGenerationJobErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AllWorldGenerationFailed" => WorldGenerationJobErrorCode::AllWorldGenerationFailed,
            "InternalServiceError" => WorldGenerationJobErrorCode::InternalServiceError,
            "InvalidInput" => WorldGenerationJobErrorCode::InvalidInput,
            "LimitExceeded" => WorldGenerationJobErrorCode::LimitExceeded,
            "RequestThrottled" => WorldGenerationJobErrorCode::RequestThrottled,
            "ResourceNotFound" => WorldGenerationJobErrorCode::ResourceNotFound,
            other => WorldGenerationJobErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorldGenerationJobErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorldGenerationJobErrorCode::from(s))
    }
}
impl WorldGenerationJobErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorldGenerationJobErrorCode::AllWorldGenerationFailed => "AllWorldGenerationFailed",
            WorldGenerationJobErrorCode::InternalServiceError => "InternalServiceError",
            WorldGenerationJobErrorCode::InvalidInput => "InvalidInput",
            WorldGenerationJobErrorCode::LimitExceeded => "LimitExceeded",
            WorldGenerationJobErrorCode::RequestThrottled => "RequestThrottled",
            WorldGenerationJobErrorCode::ResourceNotFound => "ResourceNotFound",
            WorldGenerationJobErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AllWorldGenerationFailed",
            "InternalServiceError",
            "InvalidInput",
            "LimitExceeded",
            "RequestThrottled",
            "ResourceNotFound",
        ]
    }
}
impl AsRef<str> for WorldGenerationJobErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorldExportJobErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidInput,
    #[allow(missing_docs)] // documentation missing in model
    LimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    RequestThrottled,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorldExportJobErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "AccessDenied" => WorldExportJobErrorCode::AccessDenied,
            "InternalServiceError" => WorldExportJobErrorCode::InternalServiceError,
            "InvalidInput" => WorldExportJobErrorCode::InvalidInput,
            "LimitExceeded" => WorldExportJobErrorCode::LimitExceeded,
            "RequestThrottled" => WorldExportJobErrorCode::RequestThrottled,
            "ResourceNotFound" => WorldExportJobErrorCode::ResourceNotFound,
            other => WorldExportJobErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorldExportJobErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorldExportJobErrorCode::from(s))
    }
}
impl WorldExportJobErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorldExportJobErrorCode::AccessDenied => "AccessDenied",
            WorldExportJobErrorCode::InternalServiceError => "InternalServiceError",
            WorldExportJobErrorCode::InvalidInput => "InvalidInput",
            WorldExportJobErrorCode::LimitExceeded => "LimitExceeded",
            WorldExportJobErrorCode::RequestThrottled => "RequestThrottled",
            WorldExportJobErrorCode::ResourceNotFound => "ResourceNotFound",
            WorldExportJobErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDenied",
            "InternalServiceError",
            "InvalidInput",
            "LimitExceeded",
            "RequestThrottled",
            "ResourceNotFound",
        ]
    }
}
impl AsRef<str> for WorldExportJobErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Compute information for the simulation job</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComputeResponse {
    /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
    pub simulation_unit_limit: std::option::Option<i32>,
    /// <p>Compute type response information for the simulation job.</p>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
    /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
    pub gpu_unit_limit: std::option::Option<i32>,
}
impl ComputeResponse {
    /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
    pub fn simulation_unit_limit(&self) -> std::option::Option<i32> {
        self.simulation_unit_limit
    }
    /// <p>Compute type response information for the simulation job.</p>
    pub fn compute_type(&self) -> std::option::Option<&crate::model::ComputeType> {
        self.compute_type.as_ref()
    }
    /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
    pub fn gpu_unit_limit(&self) -> std::option::Option<i32> {
        self.gpu_unit_limit
    }
}
impl std::fmt::Debug for ComputeResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComputeResponse");
        formatter.field("simulation_unit_limit", &self.simulation_unit_limit);
        formatter.field("compute_type", &self.compute_type);
        formatter.field("gpu_unit_limit", &self.gpu_unit_limit);
        formatter.finish()
    }
}
/// See [`ComputeResponse`](crate::model::ComputeResponse)
pub mod compute_response {
    /// A builder for [`ComputeResponse`](crate::model::ComputeResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simulation_unit_limit: std::option::Option<i32>,
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
        pub(crate) gpu_unit_limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
        pub fn simulation_unit_limit(mut self, input: i32) -> Self {
            self.simulation_unit_limit = Some(input);
            self
        }
        /// <p>The simulation unit limit. Your simulation is allocated CPU and memory proportional to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB of memory. You are only billed for the SU utilization you consume up to the maximum value provided. The default is 15. </p>
        pub fn set_simulation_unit_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.simulation_unit_limit = input;
            self
        }
        /// <p>Compute type response information for the simulation job.</p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>Compute type response information for the simulation job.</p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
        pub fn gpu_unit_limit(mut self, input: i32) -> Self {
            self.gpu_unit_limit = Some(input);
            self
        }
        /// <p>Compute GPU unit limit for the simulation job. It is the same as the number of GPUs allocated to the SimulationJob.</p>
        pub fn set_gpu_unit_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.gpu_unit_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ComputeResponse`](crate::model::ComputeResponse)
        pub fn build(self) -> crate::model::ComputeResponse {
            crate::model::ComputeResponse {
                simulation_unit_limit: self.simulation_unit_limit,
                compute_type: self.compute_type,
                gpu_unit_limit: self.gpu_unit_limit,
            }
        }
    }
}
impl ComputeResponse {
    /// Creates a new builder-style object to manufacture [`ComputeResponse`](crate::model::ComputeResponse)
    pub fn builder() -> crate::model::compute_response::Builder {
        crate::model::compute_response::Builder::default()
    }
}

/// <p>Describes a network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The IPv4 address of the network interface within the subnet.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The IPv4 public address of the network interface.</p>
    pub public_ip_address: std::option::Option<std::string::String>,
}
impl NetworkInterface {
    /// <p>The ID of the network interface.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>The IPv4 address of the network interface within the subnet.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>The IPv4 public address of the network interface.</p>
    pub fn public_ip_address(&self) -> std::option::Option<&str> {
        self.public_ip_address.as_deref()
    }
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("public_ip_address", &self.public_ip_address);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) public_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// <p>The IPv4 public address of the network interface.</p>
        pub fn public_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 public address of the network interface.</p>
        pub fn set_public_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                network_interface_id: self.network_interface_id,
                private_ip_address: self.private_ip_address,
                public_ip_address: self.public_ip_address,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>VPC configuration associated with your simulation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfigResponse {
    /// <p>A list of subnet IDs associated with the simulation job.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of security group IDs associated with the simulation job.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The VPC ID associated with your simulation job.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A boolean indicating if a public IP was assigned.</p>
    pub assign_public_ip: bool,
}
impl VpcConfigResponse {
    /// <p>A list of subnet IDs associated with the simulation job.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
    /// <p>A list of security group IDs associated with the simulation job.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The VPC ID associated with your simulation job.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A boolean indicating if a public IP was assigned.</p>
    pub fn assign_public_ip(&self) -> bool {
        self.assign_public_ip
    }
}
impl std::fmt::Debug for VpcConfigResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfigResponse");
        formatter.field("subnets", &self.subnets);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("assign_public_ip", &self.assign_public_ip);
        formatter.finish()
    }
}
/// See [`VpcConfigResponse`](crate::model::VpcConfigResponse)
pub mod vpc_config_response {
    /// A builder for [`VpcConfigResponse`](crate::model::VpcConfigResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) assign_public_ip: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of subnet IDs associated with the simulation job.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>A list of subnet IDs associated with the simulation job.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list of security group IDs associated with the simulation job.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list of security group IDs associated with the simulation job.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The VPC ID associated with your simulation job.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID associated with your simulation job.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>A boolean indicating if a public IP was assigned.</p>
        pub fn assign_public_ip(mut self, input: bool) -> Self {
            self.assign_public_ip = Some(input);
            self
        }
        /// <p>A boolean indicating if a public IP was assigned.</p>
        pub fn set_assign_public_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.assign_public_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfigResponse`](crate::model::VpcConfigResponse)
        pub fn build(self) -> crate::model::VpcConfigResponse {
            crate::model::VpcConfigResponse {
                subnets: self.subnets,
                security_groups: self.security_groups,
                vpc_id: self.vpc_id,
                assign_public_ip: self.assign_public_ip.unwrap_or_default(),
            }
        }
    }
}
impl VpcConfigResponse {
    /// Creates a new builder-style object to manufacture [`VpcConfigResponse`](crate::model::VpcConfigResponse)
    pub fn builder() -> crate::model::vpc_config_response::Builder {
        crate::model::vpc_config_response::Builder::default()
    }
}

/// <p>Information about a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSource {
    /// <p>The name of the data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The S3 bucket where the data files are located.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The list of S3 keys identifying the data source files.</p>
    pub s3_keys: std::option::Option<std::vec::Vec<crate::model::S3KeyOutput>>,
    /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
    /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The location where your files are mounted in the container image.</p>
    /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
    pub destination: std::option::Option<std::string::String>,
}
impl DataSource {
    /// <p>The name of the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The S3 bucket where the data files are located.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The list of S3 keys identifying the data source files.</p>
    pub fn s3_keys(&self) -> std::option::Option<&[crate::model::S3KeyOutput]> {
        self.s3_keys.as_deref()
    }
    /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
    /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The location where your files are mounted in the container image.</p>
    /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
    /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
}
impl std::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSource");
        formatter.field("name", &self.name);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_keys", &self.s3_keys);
        formatter.field("r#type", &self.r#type);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`DataSource`](crate::model::DataSource)
pub mod data_source {
    /// A builder for [`DataSource`](crate::model::DataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_keys: std::option::Option<std::vec::Vec<crate::model::S3KeyOutput>>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) destination: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The S3 bucket where the data files are located.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket where the data files are located.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Appends an item to `s3_keys`.
        ///
        /// To override the contents of this collection use [`set_s3_keys`](Self::set_s3_keys).
        ///
        /// <p>The list of S3 keys identifying the data source files.</p>
        pub fn s3_keys(mut self, input: crate::model::S3KeyOutput) -> Self {
            let mut v = self.s3_keys.unwrap_or_default();
            v.push(input);
            self.s3_keys = Some(v);
            self
        }
        /// <p>The list of S3 keys identifying the data source files.</p>
        pub fn set_s3_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3KeyOutput>>,
        ) -> Self {
            self.s3_keys = input;
            self
        }
        /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
        /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.</p>
        /// <p>If you don't specify a field, the default value is <code>File</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The location where your files are mounted in the container image.</p>
        /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The location where your files are mounted in the container image.</p>
        /// <p>If you've specified the <code>type</code> of the data source as an <code>Archive</code>, you must provide an Amazon S3 object key to your archive. The object key must point to either a <code>.zip</code> or <code>.tar.gz</code> file.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>Prefix</code>, you provide the Amazon S3 prefix that points to the files that you are using for your data source.</p>
        /// <p>If you've specified the <code>type</code> of the data source as a <code>File</code>, you provide the Amazon S3 path to the file that you're using as your data source.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSource`](crate::model::DataSource)
        pub fn build(self) -> crate::model::DataSource {
            crate::model::DataSource {
                name: self.name,
                s3_bucket: self.s3_bucket,
                s3_keys: self.s3_keys,
                r#type: self.r#type,
                destination: self.destination,
            }
        }
    }
}
impl DataSource {
    /// Creates a new builder-style object to manufacture [`DataSource`](crate::model::DataSource)
    pub fn builder() -> crate::model::data_source::Builder {
        crate::model::data_source::Builder::default()
    }
}

/// <p>Information about S3 keys.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3KeyOutput {
    /// <p>The S3 key.</p>
    pub s3_key: std::option::Option<std::string::String>,
    /// <p>The etag for the object.</p>
    pub etag: std::option::Option<std::string::String>,
}
impl S3KeyOutput {
    /// <p>The S3 key.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
    /// <p>The etag for the object.</p>
    pub fn etag(&self) -> std::option::Option<&str> {
        self.etag.as_deref()
    }
}
impl std::fmt::Debug for S3KeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3KeyOutput");
        formatter.field("s3_key", &self.s3_key);
        formatter.field("etag", &self.etag);
        formatter.finish()
    }
}
/// See [`S3KeyOutput`](crate::model::S3KeyOutput)
pub mod s3_key_output {
    /// A builder for [`S3KeyOutput`](crate::model::S3KeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_key: std::option::Option<std::string::String>,
        pub(crate) etag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 key.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The S3 key.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// <p>The etag for the object.</p>
        pub fn etag(mut self, input: impl Into<std::string::String>) -> Self {
            self.etag = Some(input.into());
            self
        }
        /// <p>The etag for the object.</p>
        pub fn set_etag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.etag = input;
            self
        }
        /// Consumes the builder and constructs a [`S3KeyOutput`](crate::model::S3KeyOutput)
        pub fn build(self) -> crate::model::S3KeyOutput {
            crate::model::S3KeyOutput {
                s3_key: self.s3_key,
                etag: self.etag,
            }
        }
    }
}
impl S3KeyOutput {
    /// Creates a new builder-style object to manufacture [`S3KeyOutput`](crate::model::S3KeyOutput)
    pub fn builder() -> crate::model::s3_key_output::Builder {
        crate::model::s3_key_output::Builder::default()
    }
}

/// <p>Information about a robot deployment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RobotDeployment {
    /// <p>The robot deployment Amazon Resource Name (ARN).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the deployment was started.</p>
    pub deployment_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the deployment finished.</p>
    pub deployment_finish_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the robot deployment.</p>
    pub status: std::option::Option<crate::model::RobotStatus>,
    /// <p>Information about how the deployment is progressing.</p>
    pub progress_detail: std::option::Option<crate::model::ProgressDetail>,
    /// <p>A short description of the reason why the robot deployment failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The robot deployment failure code.</p>
    pub failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
}
impl RobotDeployment {
    /// <p>The robot deployment Amazon Resource Name (ARN).</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the deployment was started.</p>
    pub fn deployment_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deployment_start_time.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the deployment finished.</p>
    pub fn deployment_finish_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deployment_finish_time.as_ref()
    }
    /// <p>The status of the robot deployment.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RobotStatus> {
        self.status.as_ref()
    }
    /// <p>Information about how the deployment is progressing.</p>
    pub fn progress_detail(&self) -> std::option::Option<&crate::model::ProgressDetail> {
        self.progress_detail.as_ref()
    }
    /// <p>A short description of the reason why the robot deployment failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The robot deployment failure code.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::DeploymentJobErrorCode> {
        self.failure_code.as_ref()
    }
}
impl std::fmt::Debug for RobotDeployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RobotDeployment");
        formatter.field("arn", &self.arn);
        formatter.field("deployment_start_time", &self.deployment_start_time);
        formatter.field("deployment_finish_time", &self.deployment_finish_time);
        formatter.field("status", &self.status);
        formatter.field("progress_detail", &self.progress_detail);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failure_code", &self.failure_code);
        formatter.finish()
    }
}
/// See [`RobotDeployment`](crate::model::RobotDeployment)
pub mod robot_deployment {
    /// A builder for [`RobotDeployment`](crate::model::RobotDeployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) deployment_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_finish_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::RobotStatus>,
        pub(crate) progress_detail: std::option::Option<crate::model::ProgressDetail>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
    }
    impl Builder {
        /// <p>The robot deployment Amazon Resource Name (ARN).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The robot deployment Amazon Resource Name (ARN).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment was started.</p>
        pub fn deployment_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deployment_start_time = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment was started.</p>
        pub fn set_deployment_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deployment_start_time = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment finished.</p>
        pub fn deployment_finish_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deployment_finish_time = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment finished.</p>
        pub fn set_deployment_finish_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deployment_finish_time = input;
            self
        }
        /// <p>The status of the robot deployment.</p>
        pub fn status(mut self, input: crate::model::RobotStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the robot deployment.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::RobotStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about how the deployment is progressing.</p>
        pub fn progress_detail(mut self, input: crate::model::ProgressDetail) -> Self {
            self.progress_detail = Some(input);
            self
        }
        /// <p>Information about how the deployment is progressing.</p>
        pub fn set_progress_detail(
            mut self,
            input: std::option::Option<crate::model::ProgressDetail>,
        ) -> Self {
            self.progress_detail = input;
            self
        }
        /// <p>A short description of the reason why the robot deployment failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>A short description of the reason why the robot deployment failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The robot deployment failure code.</p>
        pub fn failure_code(mut self, input: crate::model::DeploymentJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The robot deployment failure code.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::DeploymentJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// Consumes the builder and constructs a [`RobotDeployment`](crate::model::RobotDeployment)
        pub fn build(self) -> crate::model::RobotDeployment {
            crate::model::RobotDeployment {
                arn: self.arn,
                deployment_start_time: self.deployment_start_time,
                deployment_finish_time: self.deployment_finish_time,
                status: self.status,
                progress_detail: self.progress_detail,
                failure_reason: self.failure_reason,
                failure_code: self.failure_code,
            }
        }
    }
}
impl RobotDeployment {
    /// Creates a new builder-style object to manufacture [`RobotDeployment`](crate::model::RobotDeployment)
    pub fn builder() -> crate::model::robot_deployment::Builder {
        crate::model::robot_deployment::Builder::default()
    }
}

/// <p>Information about the progress of a deployment job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProgressDetail {
    /// <p>The current progress status.</p>
    /// <dl>
    /// <dt>
    /// Validating
    /// </dt>
    /// <dd>
    /// <p>Validating the deployment.</p>
    /// </dd>
    /// <dt>
    /// DownloadingExtracting
    /// </dt>
    /// <dd>
    /// <p>Downloading and extracting the bundle on the robot.</p>
    /// </dd>
    /// <dt>
    /// ExecutingPreLaunch
    /// </dt>
    /// <dd>
    /// <p>Executing pre-launch script(s) if provided.</p>
    /// </dd>
    /// <dt>
    /// Launching
    /// </dt>
    /// <dd>
    /// <p>Launching the robot application.</p>
    /// </dd>
    /// <dt>
    /// ExecutingPostLaunch
    /// </dt>
    /// <dd>
    /// <p>Executing post-launch script(s) if provided.</p>
    /// </dd>
    /// <dt>
    /// Finished
    /// </dt>
    /// <dd>
    /// <p>Deployment is complete.</p>
    /// </dd>
    /// </dl>
    pub current_progress: std::option::Option<crate::model::RobotDeploymentStep>,
    /// <p>Precentage of the step that is done. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
    pub percent_done: std::option::Option<f32>,
    /// <p>Estimated amount of time in seconds remaining in the step. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
    pub estimated_time_remaining_seconds: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub target_resource: std::option::Option<std::string::String>,
}
impl ProgressDetail {
    /// <p>The current progress status.</p>
    /// <dl>
    /// <dt>
    /// Validating
    /// </dt>
    /// <dd>
    /// <p>Validating the deployment.</p>
    /// </dd>
    /// <dt>
    /// DownloadingExtracting
    /// </dt>
    /// <dd>
    /// <p>Downloading and extracting the bundle on the robot.</p>
    /// </dd>
    /// <dt>
    /// ExecutingPreLaunch
    /// </dt>
    /// <dd>
    /// <p>Executing pre-launch script(s) if provided.</p>
    /// </dd>
    /// <dt>
    /// Launching
    /// </dt>
    /// <dd>
    /// <p>Launching the robot application.</p>
    /// </dd>
    /// <dt>
    /// ExecutingPostLaunch
    /// </dt>
    /// <dd>
    /// <p>Executing post-launch script(s) if provided.</p>
    /// </dd>
    /// <dt>
    /// Finished
    /// </dt>
    /// <dd>
    /// <p>Deployment is complete.</p>
    /// </dd>
    /// </dl>
    pub fn current_progress(&self) -> std::option::Option<&crate::model::RobotDeploymentStep> {
        self.current_progress.as_ref()
    }
    /// <p>Precentage of the step that is done. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
    pub fn percent_done(&self) -> std::option::Option<f32> {
        self.percent_done
    }
    /// <p>Estimated amount of time in seconds remaining in the step. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
    pub fn estimated_time_remaining_seconds(&self) -> std::option::Option<i32> {
        self.estimated_time_remaining_seconds
    }
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub fn target_resource(&self) -> std::option::Option<&str> {
        self.target_resource.as_deref()
    }
}
impl std::fmt::Debug for ProgressDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProgressDetail");
        formatter.field("current_progress", &self.current_progress);
        formatter.field("percent_done", &self.percent_done);
        formatter.field(
            "estimated_time_remaining_seconds",
            &self.estimated_time_remaining_seconds,
        );
        formatter.field("target_resource", &self.target_resource);
        formatter.finish()
    }
}
/// See [`ProgressDetail`](crate::model::ProgressDetail)
pub mod progress_detail {
    /// A builder for [`ProgressDetail`](crate::model::ProgressDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) current_progress: std::option::Option<crate::model::RobotDeploymentStep>,
        pub(crate) percent_done: std::option::Option<f32>,
        pub(crate) estimated_time_remaining_seconds: std::option::Option<i32>,
        pub(crate) target_resource: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current progress status.</p>
        /// <dl>
        /// <dt>
        /// Validating
        /// </dt>
        /// <dd>
        /// <p>Validating the deployment.</p>
        /// </dd>
        /// <dt>
        /// DownloadingExtracting
        /// </dt>
        /// <dd>
        /// <p>Downloading and extracting the bundle on the robot.</p>
        /// </dd>
        /// <dt>
        /// ExecutingPreLaunch
        /// </dt>
        /// <dd>
        /// <p>Executing pre-launch script(s) if provided.</p>
        /// </dd>
        /// <dt>
        /// Launching
        /// </dt>
        /// <dd>
        /// <p>Launching the robot application.</p>
        /// </dd>
        /// <dt>
        /// ExecutingPostLaunch
        /// </dt>
        /// <dd>
        /// <p>Executing post-launch script(s) if provided.</p>
        /// </dd>
        /// <dt>
        /// Finished
        /// </dt>
        /// <dd>
        /// <p>Deployment is complete.</p>
        /// </dd>
        /// </dl>
        pub fn current_progress(mut self, input: crate::model::RobotDeploymentStep) -> Self {
            self.current_progress = Some(input);
            self
        }
        /// <p>The current progress status.</p>
        /// <dl>
        /// <dt>
        /// Validating
        /// </dt>
        /// <dd>
        /// <p>Validating the deployment.</p>
        /// </dd>
        /// <dt>
        /// DownloadingExtracting
        /// </dt>
        /// <dd>
        /// <p>Downloading and extracting the bundle on the robot.</p>
        /// </dd>
        /// <dt>
        /// ExecutingPreLaunch
        /// </dt>
        /// <dd>
        /// <p>Executing pre-launch script(s) if provided.</p>
        /// </dd>
        /// <dt>
        /// Launching
        /// </dt>
        /// <dd>
        /// <p>Launching the robot application.</p>
        /// </dd>
        /// <dt>
        /// ExecutingPostLaunch
        /// </dt>
        /// <dd>
        /// <p>Executing post-launch script(s) if provided.</p>
        /// </dd>
        /// <dt>
        /// Finished
        /// </dt>
        /// <dd>
        /// <p>Deployment is complete.</p>
        /// </dd>
        /// </dl>
        pub fn set_current_progress(
            mut self,
            input: std::option::Option<crate::model::RobotDeploymentStep>,
        ) -> Self {
            self.current_progress = input;
            self
        }
        /// <p>Precentage of the step that is done. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
        pub fn percent_done(mut self, input: f32) -> Self {
            self.percent_done = Some(input);
            self
        }
        /// <p>Precentage of the step that is done. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
        pub fn set_percent_done(mut self, input: std::option::Option<f32>) -> Self {
            self.percent_done = input;
            self
        }
        /// <p>Estimated amount of time in seconds remaining in the step. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
        pub fn estimated_time_remaining_seconds(mut self, input: i32) -> Self {
            self.estimated_time_remaining_seconds = Some(input);
            self
        }
        /// <p>Estimated amount of time in seconds remaining in the step. This currently only applies to the <code>Downloading/Extracting</code> step of the deployment. It is empty for other steps.</p>
        pub fn set_estimated_time_remaining_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.estimated_time_remaining_seconds = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn target_resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_resource = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn set_target_resource(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_resource = input;
            self
        }
        /// Consumes the builder and constructs a [`ProgressDetail`](crate::model::ProgressDetail)
        pub fn build(self) -> crate::model::ProgressDetail {
            crate::model::ProgressDetail {
                current_progress: self.current_progress,
                percent_done: self.percent_done,
                estimated_time_remaining_seconds: self.estimated_time_remaining_seconds,
                target_resource: self.target_resource,
            }
        }
    }
}
impl ProgressDetail {
    /// Creates a new builder-style object to manufacture [`ProgressDetail`](crate::model::ProgressDetail)
    pub fn builder() -> crate::model::progress_detail::Builder {
        crate::model::progress_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RobotDeploymentStep {
    #[allow(missing_docs)] // documentation missing in model
    DownloadingExtractingStep,
    #[allow(missing_docs)] // documentation missing in model
    ExecutingDownloadCondition,
    #[allow(missing_docs)] // documentation missing in model
    PostLaunchStep,
    #[allow(missing_docs)] // documentation missing in model
    PreLaunchStep,
    #[allow(missing_docs)] // documentation missing in model
    FinishedStep,
    #[allow(missing_docs)] // documentation missing in model
    LaunchingStep,
    #[allow(missing_docs)] // documentation missing in model
    ValidatingStep,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RobotDeploymentStep {
    fn from(s: &str) -> Self {
        match s {
            "DownloadingExtracting" => RobotDeploymentStep::DownloadingExtractingStep,
            "ExecutingDownloadCondition" => RobotDeploymentStep::ExecutingDownloadCondition,
            "ExecutingPostLaunch" => RobotDeploymentStep::PostLaunchStep,
            "ExecutingPreLaunch" => RobotDeploymentStep::PreLaunchStep,
            "Finished" => RobotDeploymentStep::FinishedStep,
            "Launching" => RobotDeploymentStep::LaunchingStep,
            "Validating" => RobotDeploymentStep::ValidatingStep,
            other => RobotDeploymentStep::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RobotDeploymentStep {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RobotDeploymentStep::from(s))
    }
}
impl RobotDeploymentStep {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RobotDeploymentStep::DownloadingExtractingStep => "DownloadingExtracting",
            RobotDeploymentStep::ExecutingDownloadCondition => "ExecutingDownloadCondition",
            RobotDeploymentStep::PostLaunchStep => "ExecutingPostLaunch",
            RobotDeploymentStep::PreLaunchStep => "ExecutingPreLaunch",
            RobotDeploymentStep::FinishedStep => "Finished",
            RobotDeploymentStep::LaunchingStep => "Launching",
            RobotDeploymentStep::ValidatingStep => "Validating",
            RobotDeploymentStep::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DownloadingExtracting",
            "ExecutingDownloadCondition",
            "ExecutingPostLaunch",
            "ExecutingPreLaunch",
            "Finished",
            "Launching",
            "Validating",
        ]
    }
}
impl AsRef<str> for RobotDeploymentStep {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a simulation job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulationJob {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the simulation job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Status of the simulation job.</p>
    pub status: std::option::Option<crate::model::SimulationJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last started.</p>
    pub last_started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The failure behavior the simulation job.</p>
    /// <dl>
    /// <dt>
    /// Continue
    /// </dt>
    /// <dd>
    /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
    /// </dd>
    /// <dt>
    /// Fail
    /// </dt>
    /// <dd>
    /// <p>Stop the simulation job and terminate the instance.</p>
    /// </dd>
    /// </dl>
    pub failure_behavior: std::option::Option<crate::model::FailureBehavior>,
    /// <p>The failure code of the simulation job if it failed.</p>
    pub failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
    /// <p>The reason why the simulation job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>A unique identifier for this <code>SimulationJob</code> request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Location for output files generated by the simulation job.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The logging configuration.</p>
    pub logging_config: std::option::Option<crate::model::LoggingConfig>,
    /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
    pub max_job_duration_in_seconds: i64,
    /// <p>The simulation job execution duration in milliseconds.</p>
    pub simulation_time_millis: i64,
    /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>A list of robot applications.</p>
    pub robot_applications:
        std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
    /// <p>A list of simulation applications.</p>
    pub simulation_applications:
        std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
    /// <p>The data sources for the simulation job.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>VPC configuration information.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>Information about a network interface.</p>
    pub network_interface: std::option::Option<crate::model::NetworkInterface>,
    /// <p>Compute information for the simulation job</p>
    pub compute: std::option::Option<crate::model::ComputeResponse>,
}
impl SimulationJob {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the simulation job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Status of the simulation job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SimulationJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last started.</p>
    pub fn last_started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_started_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The failure behavior the simulation job.</p>
    /// <dl>
    /// <dt>
    /// Continue
    /// </dt>
    /// <dd>
    /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
    /// </dd>
    /// <dt>
    /// Fail
    /// </dt>
    /// <dd>
    /// <p>Stop the simulation job and terminate the instance.</p>
    /// </dd>
    /// </dl>
    pub fn failure_behavior(&self) -> std::option::Option<&crate::model::FailureBehavior> {
        self.failure_behavior.as_ref()
    }
    /// <p>The failure code of the simulation job if it failed.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::SimulationJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The reason why the simulation job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>A unique identifier for this <code>SimulationJob</code> request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Location for output files generated by the simulation job.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The logging configuration.</p>
    pub fn logging_config(&self) -> std::option::Option<&crate::model::LoggingConfig> {
        self.logging_config.as_ref()
    }
    /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
    pub fn max_job_duration_in_seconds(&self) -> i64 {
        self.max_job_duration_in_seconds
    }
    /// <p>The simulation job execution duration in milliseconds.</p>
    pub fn simulation_time_millis(&self) -> i64 {
        self.simulation_time_millis
    }
    /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>A list of robot applications.</p>
    pub fn robot_applications(
        &self,
    ) -> std::option::Option<&[crate::model::RobotApplicationConfig]> {
        self.robot_applications.as_deref()
    }
    /// <p>A list of simulation applications.</p>
    pub fn simulation_applications(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationApplicationConfig]> {
        self.simulation_applications.as_deref()
    }
    /// <p>The data sources for the simulation job.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.data_sources.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>VPC configuration information.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>Information about a network interface.</p>
    pub fn network_interface(&self) -> std::option::Option<&crate::model::NetworkInterface> {
        self.network_interface.as_ref()
    }
    /// <p>Compute information for the simulation job</p>
    pub fn compute(&self) -> std::option::Option<&crate::model::ComputeResponse> {
        self.compute.as_ref()
    }
}
impl std::fmt::Debug for SimulationJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulationJob");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("last_started_at", &self.last_started_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("failure_behavior", &self.failure_behavior);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("output_location", &self.output_location);
        formatter.field("logging_config", &self.logging_config);
        formatter.field(
            "max_job_duration_in_seconds",
            &self.max_job_duration_in_seconds,
        );
        formatter.field("simulation_time_millis", &self.simulation_time_millis);
        formatter.field("iam_role", &self.iam_role);
        formatter.field("robot_applications", &self.robot_applications);
        formatter.field("simulation_applications", &self.simulation_applications);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("network_interface", &self.network_interface);
        formatter.field("compute", &self.compute);
        formatter.finish()
    }
}
/// See [`SimulationJob`](crate::model::SimulationJob)
pub mod simulation_job {
    /// A builder for [`SimulationJob`](crate::model::SimulationJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SimulationJobStatus>,
        pub(crate) last_started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_behavior: std::option::Option<crate::model::FailureBehavior>,
        pub(crate) failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) logging_config: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) max_job_duration_in_seconds: std::option::Option<i64>,
        pub(crate) simulation_time_millis: std::option::Option<i64>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) robot_applications:
            std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        pub(crate) simulation_applications:
            std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) network_interface: std::option::Option<crate::model::NetworkInterface>,
        pub(crate) compute: std::option::Option<crate::model::ComputeResponse>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the simulation job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Status of the simulation job.</p>
        pub fn status(mut self, input: crate::model::SimulationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of the simulation job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SimulationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last started.</p>
        pub fn last_started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_started_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last started.</p>
        pub fn set_last_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_started_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn failure_behavior(mut self, input: crate::model::FailureBehavior) -> Self {
            self.failure_behavior = Some(input);
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the host running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_behavior(
            mut self,
            input: std::option::Option<crate::model::FailureBehavior>,
        ) -> Self {
            self.failure_behavior = input;
            self
        }
        /// <p>The failure code of the simulation job if it failed.</p>
        pub fn failure_code(mut self, input: crate::model::SimulationJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the simulation job if it failed.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::SimulationJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The reason why the simulation job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason why the simulation job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>A unique identifier for this <code>SimulationJob</code> request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique identifier for this <code>SimulationJob</code> request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The logging configuration.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging_config = Some(input);
            self
        }
        /// <p>The logging configuration.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging_config = input;
            self
        }
        /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
        pub fn max_job_duration_in_seconds(mut self, input: i64) -> Self {
            self.max_job_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum simulation job duration in seconds. The value must be 8 days (691,200 seconds) or less.</p>
        pub fn set_max_job_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.max_job_duration_in_seconds = input;
            self
        }
        /// <p>The simulation job execution duration in milliseconds.</p>
        pub fn simulation_time_millis(mut self, input: i64) -> Self {
            self.simulation_time_millis = Some(input);
            self
        }
        /// <p>The simulation job execution duration in milliseconds.</p>
        pub fn set_simulation_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.simulation_time_millis = input;
            self
        }
        /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// Appends an item to `robot_applications`.
        ///
        /// To override the contents of this collection use [`set_robot_applications`](Self::set_robot_applications).
        ///
        /// <p>A list of robot applications.</p>
        pub fn robot_applications(mut self, input: crate::model::RobotApplicationConfig) -> Self {
            let mut v = self.robot_applications.unwrap_or_default();
            v.push(input);
            self.robot_applications = Some(v);
            self
        }
        /// <p>A list of robot applications.</p>
        pub fn set_robot_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        ) -> Self {
            self.robot_applications = input;
            self
        }
        /// Appends an item to `simulation_applications`.
        ///
        /// To override the contents of this collection use [`set_simulation_applications`](Self::set_simulation_applications).
        ///
        /// <p>A list of simulation applications.</p>
        pub fn simulation_applications(
            mut self,
            input: crate::model::SimulationApplicationConfig,
        ) -> Self {
            let mut v = self.simulation_applications.unwrap_or_default();
            v.push(input);
            self.simulation_applications = Some(v);
            self
        }
        /// <p>A list of simulation applications.</p>
        pub fn set_simulation_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        ) -> Self {
            self.simulation_applications = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>The data sources for the simulation job.</p>
        pub fn data_sources(mut self, input: crate::model::DataSource) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input);
            self.data_sources = Some(v);
            self
        }
        /// <p>The data sources for the simulation job.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>VPC configuration information.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>VPC configuration information.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Information about a network interface.</p>
        pub fn network_interface(mut self, input: crate::model::NetworkInterface) -> Self {
            self.network_interface = Some(input);
            self
        }
        /// <p>Information about a network interface.</p>
        pub fn set_network_interface(
            mut self,
            input: std::option::Option<crate::model::NetworkInterface>,
        ) -> Self {
            self.network_interface = input;
            self
        }
        /// <p>Compute information for the simulation job</p>
        pub fn compute(mut self, input: crate::model::ComputeResponse) -> Self {
            self.compute = Some(input);
            self
        }
        /// <p>Compute information for the simulation job</p>
        pub fn set_compute(
            mut self,
            input: std::option::Option<crate::model::ComputeResponse>,
        ) -> Self {
            self.compute = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulationJob`](crate::model::SimulationJob)
        pub fn build(self) -> crate::model::SimulationJob {
            crate::model::SimulationJob {
                arn: self.arn,
                name: self.name,
                status: self.status,
                last_started_at: self.last_started_at,
                last_updated_at: self.last_updated_at,
                failure_behavior: self.failure_behavior,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
                client_request_token: self.client_request_token,
                output_location: self.output_location,
                logging_config: self.logging_config,
                max_job_duration_in_seconds: self.max_job_duration_in_seconds.unwrap_or_default(),
                simulation_time_millis: self.simulation_time_millis.unwrap_or_default(),
                iam_role: self.iam_role,
                robot_applications: self.robot_applications,
                simulation_applications: self.simulation_applications,
                data_sources: self.data_sources,
                tags: self.tags,
                vpc_config: self.vpc_config,
                network_interface: self.network_interface,
                compute: self.compute,
            }
        }
    }
}
impl SimulationJob {
    /// Creates a new builder-style object to manufacture [`SimulationJob`](crate::model::SimulationJob)
    pub fn builder() -> crate::model::simulation_job::Builder {
        crate::model::simulation_job::Builder::default()
    }
}
