// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchDeleteWorldsInput`](crate::input::BatchDeleteWorldsInput)
pub mod batch_delete_worlds_input {
    /// A builder for [`BatchDeleteWorldsInput`](crate::input::BatchDeleteWorldsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) worlds: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `worlds`.
        ///
        /// To override the contents of this collection use [`set_worlds`](Self::set_worlds).
        ///
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to delete.</p>
        pub fn worlds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.worlds.unwrap_or_default();
            v.push(input.into());
            self.worlds = Some(v);
            self
        }
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to delete.</p>
        pub fn set_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.worlds = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteWorldsInput`](crate::input::BatchDeleteWorldsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteWorldsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteWorldsInput {
                worlds: self.worlds,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteWorldsInputOperationOutputAlias = crate::operation::BatchDeleteWorlds;
#[doc(hidden)]
pub type BatchDeleteWorldsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeleteWorldsInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteWorlds`](crate::operation::BatchDeleteWorlds)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteWorlds,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchDeleteWorldsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/batchDeleteWorlds").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchDeleteWorldsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_worlds(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteWorlds::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteWorlds",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteWorldsInput`](crate::input::BatchDeleteWorldsInput)
    pub fn builder() -> crate::input::batch_delete_worlds_input::Builder {
        crate::input::batch_delete_worlds_input::Builder::default()
    }
}

/// See [`BatchDescribeSimulationJobInput`](crate::input::BatchDescribeSimulationJobInput)
pub mod batch_describe_simulation_job_input {
    /// A builder for [`BatchDescribeSimulationJobInput`](crate::input::BatchDescribeSimulationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of Amazon Resource Names (ARNs) of simulation jobs to describe.</p>
        pub fn jobs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of simulation jobs to describe.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeSimulationJobInput`](crate::input::BatchDescribeSimulationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDescribeSimulationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDescribeSimulationJobInput { jobs: self.jobs })
        }
    }
}
#[doc(hidden)]
pub type BatchDescribeSimulationJobInputOperationOutputAlias =
    crate::operation::BatchDescribeSimulationJob;
#[doc(hidden)]
pub type BatchDescribeSimulationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDescribeSimulationJobInput {
    /// Consumes the builder and constructs an Operation<[`BatchDescribeSimulationJob`](crate::operation::BatchDescribeSimulationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDescribeSimulationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchDescribeSimulationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/batchDescribeSimulationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchDescribeSimulationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_describe_simulation_job(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDescribeSimulationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDescribeSimulationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchDescribeSimulationJobInput`](crate::input::BatchDescribeSimulationJobInput)
    pub fn builder() -> crate::input::batch_describe_simulation_job_input::Builder {
        crate::input::batch_describe_simulation_job_input::Builder::default()
    }
}

/// See [`CancelDeploymentJobInput`](crate::input::CancelDeploymentJobInput)
pub mod cancel_deployment_job_input {
    /// A builder for [`CancelDeploymentJobInput`](crate::input::CancelDeploymentJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The deployment job ARN to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The deployment job ARN to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelDeploymentJobInput`](crate::input::CancelDeploymentJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelDeploymentJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelDeploymentJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type CancelDeploymentJobInputOperationOutputAlias = crate::operation::CancelDeploymentJob;
#[doc(hidden)]
pub type CancelDeploymentJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelDeploymentJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelDeploymentJob`](crate::operation::CancelDeploymentJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelDeploymentJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelDeploymentJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cancelDeploymentJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelDeploymentJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_deployment_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelDeploymentJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelDeploymentJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelDeploymentJobInput`](crate::input::CancelDeploymentJobInput)
    pub fn builder() -> crate::input::cancel_deployment_job_input::Builder {
        crate::input::cancel_deployment_job_input::Builder::default()
    }
}

/// See [`CancelSimulationJobInput`](crate::input::CancelSimulationJobInput)
pub mod cancel_simulation_job_input {
    /// A builder for [`CancelSimulationJobInput`](crate::input::CancelSimulationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The simulation job ARN to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The simulation job ARN to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelSimulationJobInput`](crate::input::CancelSimulationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelSimulationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelSimulationJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type CancelSimulationJobInputOperationOutputAlias = crate::operation::CancelSimulationJob;
#[doc(hidden)]
pub type CancelSimulationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelSimulationJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelSimulationJob`](crate::operation::CancelSimulationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelSimulationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelSimulationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cancelSimulationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelSimulationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_simulation_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelSimulationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelSimulationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelSimulationJobInput`](crate::input::CancelSimulationJobInput)
    pub fn builder() -> crate::input::cancel_simulation_job_input::Builder {
        crate::input::cancel_simulation_job_input::Builder::default()
    }
}

/// See [`CancelSimulationJobBatchInput`](crate::input::CancelSimulationJobBatchInput)
pub mod cancel_simulation_job_batch_input {
    /// A builder for [`CancelSimulationJobBatchInput`](crate::input::CancelSimulationJobBatchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The id of the batch to cancel.</p>
        pub fn batch(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch = Some(input.into());
            self
        }
        /// <p>The id of the batch to cancel.</p>
        pub fn set_batch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.batch = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelSimulationJobBatchInput`](crate::input::CancelSimulationJobBatchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelSimulationJobBatchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelSimulationJobBatchInput { batch: self.batch })
        }
    }
}
#[doc(hidden)]
pub type CancelSimulationJobBatchInputOperationOutputAlias =
    crate::operation::CancelSimulationJobBatch;
#[doc(hidden)]
pub type CancelSimulationJobBatchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelSimulationJobBatchInput {
    /// Consumes the builder and constructs an Operation<[`CancelSimulationJobBatch`](crate::operation::CancelSimulationJobBatch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelSimulationJobBatch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelSimulationJobBatchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cancelSimulationJobBatch").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelSimulationJobBatchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_simulation_job_batch(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelSimulationJobBatch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelSimulationJobBatch",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelSimulationJobBatchInput`](crate::input::CancelSimulationJobBatchInput)
    pub fn builder() -> crate::input::cancel_simulation_job_batch_input::Builder {
        crate::input::cancel_simulation_job_batch_input::Builder::default()
    }
}

/// See [`CancelWorldExportJobInput`](crate::input::CancelWorldExportJobInput)
pub mod cancel_world_export_job_input {
    /// A builder for [`CancelWorldExportJobInput`](crate::input::CancelWorldExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world export job to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world export job to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelWorldExportJobInput`](crate::input::CancelWorldExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelWorldExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelWorldExportJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type CancelWorldExportJobInputOperationOutputAlias = crate::operation::CancelWorldExportJob;
#[doc(hidden)]
pub type CancelWorldExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelWorldExportJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelWorldExportJob`](crate::operation::CancelWorldExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelWorldExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelWorldExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cancelWorldExportJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelWorldExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_world_export_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelWorldExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelWorldExportJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelWorldExportJobInput`](crate::input::CancelWorldExportJobInput)
    pub fn builder() -> crate::input::cancel_world_export_job_input::Builder {
        crate::input::cancel_world_export_job_input::Builder::default()
    }
}

/// See [`CancelWorldGenerationJobInput`](crate::input::CancelWorldGenerationJobInput)
pub mod cancel_world_generation_job_input {
    /// A builder for [`CancelWorldGenerationJobInput`](crate::input::CancelWorldGenerationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world generator job to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generator job to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelWorldGenerationJobInput`](crate::input::CancelWorldGenerationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelWorldGenerationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelWorldGenerationJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type CancelWorldGenerationJobInputOperationOutputAlias =
    crate::operation::CancelWorldGenerationJob;
#[doc(hidden)]
pub type CancelWorldGenerationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelWorldGenerationJobInput {
    /// Consumes the builder and constructs an Operation<[`CancelWorldGenerationJob`](crate::operation::CancelWorldGenerationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelWorldGenerationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelWorldGenerationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/cancelWorldGenerationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelWorldGenerationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_world_generation_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelWorldGenerationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelWorldGenerationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelWorldGenerationJobInput`](crate::input::CancelWorldGenerationJobInput)
    pub fn builder() -> crate::input::cancel_world_generation_job_input::Builder {
        crate::input::cancel_world_generation_job_input::Builder::default()
    }
}

/// See [`CreateDeploymentJobInput`](crate::input::CreateDeploymentJobInput)
pub mod create_deployment_job_input {
    /// A builder for [`CreateDeploymentJobInput`](crate::input::CreateDeploymentJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_config: std::option::Option<crate::model::DeploymentConfig>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) deployment_application_configs:
            std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The requested deployment configuration.</p>
        pub fn deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.deployment_config = Some(input);
            self
        }
        /// <p>The requested deployment configuration.</p>
        pub fn set_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.deployment_config = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet to deploy.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet to deploy.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// Appends an item to `deployment_application_configs`.
        ///
        /// To override the contents of this collection use [`set_deployment_application_configs`](Self::set_deployment_application_configs).
        ///
        /// <p>The deployment application configuration.</p>
        pub fn deployment_application_configs(
            mut self,
            input: crate::model::DeploymentApplicationConfig,
        ) -> Self {
            let mut v = self.deployment_application_configs.unwrap_or_default();
            v.push(input);
            self.deployment_application_configs = Some(v);
            self
        }
        /// <p>The deployment application configuration.</p>
        pub fn set_deployment_application_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        ) -> Self {
            self.deployment_application_configs = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentJobInput`](crate::input::CreateDeploymentJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeploymentJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeploymentJobInput {
                deployment_config: self.deployment_config,
                client_request_token: self.client_request_token,
                fleet: self.fleet,
                deployment_application_configs: self.deployment_application_configs,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeploymentJobInputOperationOutputAlias = crate::operation::CreateDeploymentJob;
#[doc(hidden)]
pub type CreateDeploymentJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDeploymentJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeploymentJob`](crate::operation::CreateDeploymentJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeploymentJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDeploymentJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createDeploymentJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDeploymentJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_deployment_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeploymentJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeploymentJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDeploymentJobInput`](crate::input::CreateDeploymentJobInput)
    pub fn builder() -> crate::input::create_deployment_job_input::Builder {
        crate::input::create_deployment_job_input::Builder::default()
    }
}

/// See [`CreateFleetInput`](crate::input::CreateFleetInput)
pub mod create_fleet_input {
    /// A builder for [`CreateFleetInput`](crate::input::CreateFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the fleet.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the fleet.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetInput`](crate::input::CreateFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFleetInput {
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFleetInputOperationOutputAlias = crate::operation::CreateFleet;
#[doc(hidden)]
pub type CreateFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFleetInput {
    /// Consumes the builder and constructs an Operation<[`CreateFleet`](crate::operation::CreateFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createFleet").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFleet",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
}

/// See [`CreateRobotInput`](crate::input::CreateRobotInput)
pub mod create_robot_input {
    /// A builder for [`CreateRobotInput`](crate::input::CreateRobotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
        pub(crate) greengrass_group_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name for the robot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the robot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The target architecture of the robot.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The target architecture of the robot.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The Greengrass group id.</p>
        pub fn greengrass_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.greengrass_group_id = Some(input.into());
            self
        }
        /// <p>The Greengrass group id.</p>
        pub fn set_greengrass_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_group_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the robot.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the robot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRobotInput`](crate::input::CreateRobotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRobotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRobotInput {
                name: self.name,
                architecture: self.architecture,
                greengrass_group_id: self.greengrass_group_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRobotInputOperationOutputAlias = crate::operation::CreateRobot;
#[doc(hidden)]
pub type CreateRobotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRobotInput {
    /// Consumes the builder and constructs an Operation<[`CreateRobot`](crate::operation::CreateRobot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRobot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRobotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createRobot").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRobotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_robot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRobot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRobot",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRobotInput`](crate::input::CreateRobotInput)
    pub fn builder() -> crate::input::create_robot_input::Builder {
        crate::input::create_robot_input::Builder::default()
    }
}

/// See [`CreateRobotApplicationInput`](crate::input::CreateRobotApplicationInput)
pub mod create_robot_application_input {
    /// A builder for [`CreateRobotApplicationInput`](crate::input::CreateRobotApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The name of the robot application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The robot software suite (ROS distribuition) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>The robot software suite (ROS distribuition) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the robot application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the robot application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The object that contains that URI of the Docker image that you use for your robot application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains that URI of the Docker image that you use for your robot application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRobotApplicationInput`](crate::input::CreateRobotApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRobotApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRobotApplicationInput {
                name: self.name,
                sources: self.sources,
                robot_software_suite: self.robot_software_suite,
                tags: self.tags,
                environment: self.environment,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRobotApplicationInputOperationOutputAlias = crate::operation::CreateRobotApplication;
#[doc(hidden)]
pub type CreateRobotApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRobotApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateRobotApplication`](crate::operation::CreateRobotApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRobotApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRobotApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createRobotApplication").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRobotApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_robot_application(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRobotApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRobotApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRobotApplicationInput`](crate::input::CreateRobotApplicationInput)
    pub fn builder() -> crate::input::create_robot_application_input::Builder {
        crate::input::create_robot_application_input::Builder::default()
    }
}

/// See [`CreateRobotApplicationVersionInput`](crate::input::CreateRobotApplicationVersionInput)
pub mod create_robot_application_version_input {
    /// A builder for [`CreateRobotApplicationVersionInput`](crate::input::CreateRobotApplicationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) current_revision_id: std::option::Option<std::string::String>,
        pub(crate) s3_etags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application information for the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The current revision id for the robot application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_revision_id = Some(input.into());
            self
        }
        /// <p>The current revision id for the robot application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_revision_id = input;
            self
        }
        /// Appends an item to `s3_etags`.
        ///
        /// To override the contents of this collection use [`set_s3_etags`](Self::set_s3_etags).
        ///
        /// <p>The Amazon S3 identifier for the zip file bundle that you use for your robot application.</p>
        pub fn s3_etags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.s3_etags.unwrap_or_default();
            v.push(input.into());
            self.s3_etags = Some(v);
            self
        }
        /// <p>The Amazon S3 identifier for the zip file bundle that you use for your robot application.</p>
        pub fn set_s3_etags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.s3_etags = input;
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRobotApplicationVersionInput`](crate::input::CreateRobotApplicationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRobotApplicationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRobotApplicationVersionInput {
                application: self.application,
                current_revision_id: self.current_revision_id,
                s3_etags: self.s3_etags,
                image_digest: self.image_digest,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRobotApplicationVersionInputOperationOutputAlias =
    crate::operation::CreateRobotApplicationVersion;
#[doc(hidden)]
pub type CreateRobotApplicationVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateRobotApplicationVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateRobotApplicationVersion`](crate::operation::CreateRobotApplicationVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRobotApplicationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRobotApplicationVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createRobotApplicationVersion")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRobotApplicationVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_robot_application_version(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRobotApplicationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRobotApplicationVersion",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRobotApplicationVersionInput`](crate::input::CreateRobotApplicationVersionInput)
    pub fn builder() -> crate::input::create_robot_application_version_input::Builder {
        crate::input::create_robot_application_version_input::Builder::default()
    }
}

/// See [`CreateSimulationApplicationInput`](crate::input::CreateSimulationApplicationInput)
pub mod create_simulation_application_input {
    /// A builder for [`CreateSimulationApplicationInput`](crate::input::CreateSimulationApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        pub(crate) simulation_software_suite:
            std::option::Option<crate::model::SimulationSoftwareSuite>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) rendering_engine: std::option::Option<crate::model::RenderingEngine>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The name of the simulation application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.simulation_software_suite = Some(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.simulation_software_suite = input;
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the simulation application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the simulation application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.rendering_engine = Some(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.rendering_engine = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the simulation application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the simulation application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The object that contains the Docker image URI used to create your simulation application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI used to create your simulation application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSimulationApplicationInput`](crate::input::CreateSimulationApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSimulationApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSimulationApplicationInput {
                name: self.name,
                sources: self.sources,
                simulation_software_suite: self.simulation_software_suite,
                robot_software_suite: self.robot_software_suite,
                rendering_engine: self.rendering_engine,
                tags: self.tags,
                environment: self.environment,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSimulationApplicationInputOperationOutputAlias =
    crate::operation::CreateSimulationApplication;
#[doc(hidden)]
pub type CreateSimulationApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSimulationApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateSimulationApplication`](crate::operation::CreateSimulationApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSimulationApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSimulationApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createSimulationApplication").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSimulationApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_simulation_application(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSimulationApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSimulationApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSimulationApplicationInput`](crate::input::CreateSimulationApplicationInput)
    pub fn builder() -> crate::input::create_simulation_application_input::Builder {
        crate::input::create_simulation_application_input::Builder::default()
    }
}

/// See [`CreateSimulationApplicationVersionInput`](crate::input::CreateSimulationApplicationVersionInput)
pub mod create_simulation_application_version_input {
    /// A builder for [`CreateSimulationApplicationVersionInput`](crate::input::CreateSimulationApplicationVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) current_revision_id: std::option::Option<std::string::String>,
        pub(crate) s3_etags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application information for the simulation application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the simulation application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_revision_id = Some(input.into());
            self
        }
        /// <p>The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_revision_id = input;
            self
        }
        /// Appends an item to `s3_etags`.
        ///
        /// To override the contents of this collection use [`set_s3_etags`](Self::set_s3_etags).
        ///
        /// <p>The Amazon S3 eTag identifier for the zip file bundle that you use to create the simulation application.</p>
        pub fn s3_etags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.s3_etags.unwrap_or_default();
            v.push(input.into());
            self.s3_etags = Some(v);
            self
        }
        /// <p>The Amazon S3 eTag identifier for the zip file bundle that you use to create the simulation application.</p>
        pub fn set_s3_etags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.s3_etags = input;
            self
        }
        /// <p>The SHA256 digest used to identify the Docker image URI used to created the simulation application.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>The SHA256 digest used to identify the Docker image URI used to created the simulation application.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSimulationApplicationVersionInput`](crate::input::CreateSimulationApplicationVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSimulationApplicationVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSimulationApplicationVersionInput {
                application: self.application,
                current_revision_id: self.current_revision_id,
                s3_etags: self.s3_etags,
                image_digest: self.image_digest,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSimulationApplicationVersionInputOperationOutputAlias =
    crate::operation::CreateSimulationApplicationVersion;
#[doc(hidden)]
pub type CreateSimulationApplicationVersionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateSimulationApplicationVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSimulationApplicationVersion`](crate::operation::CreateSimulationApplicationVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSimulationApplicationVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSimulationApplicationVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createSimulationApplicationVersion")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSimulationApplicationVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_simulation_application_version(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSimulationApplicationVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSimulationApplicationVersion",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSimulationApplicationVersionInput`](crate::input::CreateSimulationApplicationVersionInput)
    pub fn builder() -> crate::input::create_simulation_application_version_input::Builder {
        crate::input::create_simulation_application_version_input::Builder::default()
    }
}

/// See [`CreateSimulationJobInput`](crate::input::CreateSimulationJobInput)
pub mod create_simulation_job_input {
    /// A builder for [`CreateSimulationJobInput`](crate::input::CreateSimulationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) logging_config: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) max_job_duration_in_seconds: std::option::Option<i64>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) failure_behavior: std::option::Option<crate::model::FailureBehavior>,
        pub(crate) robot_applications:
            std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        pub(crate) simulation_applications:
            std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceConfig>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) compute: std::option::Option<crate::model::Compute>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The logging configuration.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging_config = Some(input);
            self
        }
        /// <p>The logging configuration.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging_config = input;
            self
        }
        /// <p>The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to <code>Completed</code>.</p>
        pub fn max_job_duration_in_seconds(mut self, input: i64) -> Self {
            self.max_job_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to <code>Completed</code>.</p>
        pub fn set_max_job_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.max_job_duration_in_seconds = input;
            self
        }
        /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn failure_behavior(mut self, input: crate::model::FailureBehavior) -> Self {
            self.failure_behavior = Some(input);
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_behavior(
            mut self,
            input: std::option::Option<crate::model::FailureBehavior>,
        ) -> Self {
            self.failure_behavior = input;
            self
        }
        /// Appends an item to `robot_applications`.
        ///
        /// To override the contents of this collection use [`set_robot_applications`](Self::set_robot_applications).
        ///
        /// <p>The robot application to use in the simulation job.</p>
        pub fn robot_applications(mut self, input: crate::model::RobotApplicationConfig) -> Self {
            let mut v = self.robot_applications.unwrap_or_default();
            v.push(input);
            self.robot_applications = Some(v);
            self
        }
        /// <p>The robot application to use in the simulation job.</p>
        pub fn set_robot_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        ) -> Self {
            self.robot_applications = input;
            self
        }
        /// Appends an item to `simulation_applications`.
        ///
        /// To override the contents of this collection use [`set_simulation_applications`](Self::set_simulation_applications).
        ///
        /// <p>The simulation application to use in the simulation job.</p>
        pub fn simulation_applications(
            mut self,
            input: crate::model::SimulationApplicationConfig,
        ) -> Self {
            let mut v = self.simulation_applications.unwrap_or_default();
            v.push(input);
            self.simulation_applications = Some(v);
            self
        }
        /// <p>The simulation application to use in the simulation job.</p>
        pub fn set_simulation_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        ) -> Self {
            self.simulation_applications = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
        /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
        /// </note>
        pub fn data_sources(mut self, input: crate::model::DataSourceConfig) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input);
            self.data_sources = Some(v);
            self
        }
        /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
        /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
        /// </note>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceConfig>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn compute(mut self, input: crate::model::Compute) -> Self {
            self.compute = Some(input);
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn set_compute(mut self, input: std::option::Option<crate::model::Compute>) -> Self {
            self.compute = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSimulationJobInput`](crate::input::CreateSimulationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSimulationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSimulationJobInput {
                client_request_token: self.client_request_token,
                output_location: self.output_location,
                logging_config: self.logging_config,
                max_job_duration_in_seconds: self.max_job_duration_in_seconds.unwrap_or_default(),
                iam_role: self.iam_role,
                failure_behavior: self.failure_behavior,
                robot_applications: self.robot_applications,
                simulation_applications: self.simulation_applications,
                data_sources: self.data_sources,
                tags: self.tags,
                vpc_config: self.vpc_config,
                compute: self.compute,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSimulationJobInputOperationOutputAlias = crate::operation::CreateSimulationJob;
#[doc(hidden)]
pub type CreateSimulationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSimulationJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateSimulationJob`](crate::operation::CreateSimulationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSimulationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateSimulationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createSimulationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateSimulationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_simulation_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSimulationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSimulationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateSimulationJobInput`](crate::input::CreateSimulationJobInput)
    pub fn builder() -> crate::input::create_simulation_job_input::Builder {
        crate::input::create_simulation_job_input::Builder::default()
    }
}

/// See [`CreateWorldExportJobInput`](crate::input::CreateWorldExportJobInput)
pub mod create_world_export_job_input {
    /// A builder for [`CreateWorldExportJobInput`](crate::input::CreateWorldExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) worlds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `worlds`.
        ///
        /// To override the contents of this collection use [`set_worlds`](Self::set_worlds).
        ///
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to export.</p>
        pub fn worlds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.worlds.unwrap_or_default();
            v.push(input.into());
            self.worlds = Some(v);
            self
        }
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to export.</p>
        pub fn set_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.worlds = input;
            self
        }
        /// <p>The output location.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>The output location.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.</p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world export job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world export job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorldExportJobInput`](crate::input::CreateWorldExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorldExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorldExportJobInput {
                client_request_token: self.client_request_token,
                worlds: self.worlds,
                output_location: self.output_location,
                iam_role: self.iam_role,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorldExportJobInputOperationOutputAlias = crate::operation::CreateWorldExportJob;
#[doc(hidden)]
pub type CreateWorldExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateWorldExportJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorldExportJob`](crate::operation::CreateWorldExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorldExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateWorldExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createWorldExportJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateWorldExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_world_export_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorldExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorldExportJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateWorldExportJobInput`](crate::input::CreateWorldExportJobInput)
    pub fn builder() -> crate::input::create_world_export_job_input::Builder {
        crate::input::create_world_export_job_input::Builder::default()
    }
}

/// See [`CreateWorldGenerationJobInput`](crate::input::CreateWorldGenerationJobInput)
pub mod create_world_generation_job_input {
    /// A builder for [`CreateWorldGenerationJobInput`](crate::input::CreateWorldGenerationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) world_count: std::option::Option<crate::model::WorldCount>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) world_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template describing the worlds you want to create.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template describing the worlds you want to create.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>Information about the world count.</p>
        pub fn world_count(mut self, input: crate::model::WorldCount) -> Self {
            self.world_count = Some(input);
            self
        }
        /// <p>Information about the world count.</p>
        pub fn set_world_count(
            mut self,
            input: std::option::Option<crate::model::WorldCount>,
        ) -> Self {
            self.world_count = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world generator job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world generator job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `world_tags`.
        ///
        /// To override the contents of this collection use [`set_world_tags`](Self::set_world_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the generated worlds.</p>
        pub fn world_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.world_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.world_tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the generated worlds.</p>
        pub fn set_world_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.world_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorldGenerationJobInput`](crate::input::CreateWorldGenerationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorldGenerationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorldGenerationJobInput {
                client_request_token: self.client_request_token,
                template: self.template,
                world_count: self.world_count,
                tags: self.tags,
                world_tags: self.world_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorldGenerationJobInputOperationOutputAlias =
    crate::operation::CreateWorldGenerationJob;
#[doc(hidden)]
pub type CreateWorldGenerationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateWorldGenerationJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorldGenerationJob`](crate::operation::CreateWorldGenerationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorldGenerationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateWorldGenerationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createWorldGenerationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateWorldGenerationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_world_generation_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorldGenerationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorldGenerationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateWorldGenerationJobInput`](crate::input::CreateWorldGenerationJobInput)
    pub fn builder() -> crate::input::create_world_generation_job_input::Builder {
        crate::input::create_world_generation_job_input::Builder::default()
    }
}

/// See [`CreateWorldTemplateInput`](crate::input::CreateWorldTemplateInput)
pub mod create_world_template_input {
    /// A builder for [`CreateWorldTemplateInput`](crate::input::CreateWorldTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_location: std::option::Option<crate::model::TemplateLocation>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The name of the world template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the world template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The world template body.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The world template body.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The location of the world template.</p>
        pub fn template_location(mut self, input: crate::model::TemplateLocation) -> Self {
            self.template_location = Some(input);
            self
        }
        /// <p>The location of the world template.</p>
        pub fn set_template_location(
            mut self,
            input: std::option::Option<crate::model::TemplateLocation>,
        ) -> Self {
            self.template_location = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world template.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorldTemplateInput`](crate::input::CreateWorldTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorldTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorldTemplateInput {
                client_request_token: self.client_request_token,
                name: self.name,
                template_body: self.template_body,
                template_location: self.template_location,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorldTemplateInputOperationOutputAlias = crate::operation::CreateWorldTemplate;
#[doc(hidden)]
pub type CreateWorldTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateWorldTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorldTemplate`](crate::operation::CreateWorldTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorldTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateWorldTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/createWorldTemplate").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateWorldTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_world_template(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorldTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorldTemplate",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateWorldTemplateInput`](crate::input::CreateWorldTemplateInput)
    pub fn builder() -> crate::input::create_world_template_input::Builder {
        crate::input::create_world_template_input::Builder::default()
    }
}

/// See [`DeleteFleetInput`](crate::input::DeleteFleetInput)
pub mod delete_fleet_input {
    /// A builder for [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFleetInput`](crate::input::DeleteFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFleetInput { fleet: self.fleet })
        }
    }
}
#[doc(hidden)]
pub type DeleteFleetInputOperationOutputAlias = crate::operation::DeleteFleet;
#[doc(hidden)]
pub type DeleteFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFleetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFleet`](crate::operation::DeleteFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/deleteFleet").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFleet",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    pub fn builder() -> crate::input::delete_fleet_input::Builder {
        crate::input::delete_fleet_input::Builder::default()
    }
}

/// See [`DeleteRobotInput`](crate::input::DeleteRobotInput)
pub mod delete_robot_input {
    /// A builder for [`DeleteRobotInput`](crate::input::DeleteRobotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) robot: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.robot = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.robot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRobotInput`](crate::input::DeleteRobotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRobotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRobotInput { robot: self.robot })
        }
    }
}
#[doc(hidden)]
pub type DeleteRobotInputOperationOutputAlias = crate::operation::DeleteRobot;
#[doc(hidden)]
pub type DeleteRobotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRobotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRobot`](crate::operation::DeleteRobot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRobot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRobotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/deleteRobot").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRobotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_robot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRobot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRobot",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRobotInput`](crate::input::DeleteRobotInput)
    pub fn builder() -> crate::input::delete_robot_input::Builder {
        crate::input::delete_robot_input::Builder::default()
    }
}

/// See [`DeleteRobotApplicationInput`](crate::input::DeleteRobotApplicationInput)
pub mod delete_robot_application_input {
    /// A builder for [`DeleteRobotApplicationInput`](crate::input::DeleteRobotApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) application_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The version of the robot application to delete.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version = Some(input.into());
            self
        }
        /// <p>The version of the robot application to delete.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRobotApplicationInput`](crate::input::DeleteRobotApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRobotApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRobotApplicationInput {
                application: self.application,
                application_version: self.application_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRobotApplicationInputOperationOutputAlias = crate::operation::DeleteRobotApplication;
#[doc(hidden)]
pub type DeleteRobotApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRobotApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRobotApplication`](crate::operation::DeleteRobotApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRobotApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRobotApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/deleteRobotApplication").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRobotApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_robot_application(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRobotApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRobotApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRobotApplicationInput`](crate::input::DeleteRobotApplicationInput)
    pub fn builder() -> crate::input::delete_robot_application_input::Builder {
        crate::input::delete_robot_application_input::Builder::default()
    }
}

/// See [`DeleteSimulationApplicationInput`](crate::input::DeleteSimulationApplicationInput)
pub mod delete_simulation_application_input {
    /// A builder for [`DeleteSimulationApplicationInput`](crate::input::DeleteSimulationApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) application_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application information for the simulation application to delete.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the simulation application to delete.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The version of the simulation application to delete.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version = Some(input.into());
            self
        }
        /// <p>The version of the simulation application to delete.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSimulationApplicationInput`](crate::input::DeleteSimulationApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSimulationApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSimulationApplicationInput {
                application: self.application,
                application_version: self.application_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSimulationApplicationInputOperationOutputAlias =
    crate::operation::DeleteSimulationApplication;
#[doc(hidden)]
pub type DeleteSimulationApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSimulationApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSimulationApplication`](crate::operation::DeleteSimulationApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSimulationApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteSimulationApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/deleteSimulationApplication").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteSimulationApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_simulation_application(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSimulationApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSimulationApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteSimulationApplicationInput`](crate::input::DeleteSimulationApplicationInput)
    pub fn builder() -> crate::input::delete_simulation_application_input::Builder {
        crate::input::delete_simulation_application_input::Builder::default()
    }
}

/// See [`DeleteWorldTemplateInput`](crate::input::DeleteWorldTemplateInput)
pub mod delete_world_template_input {
    /// A builder for [`DeleteWorldTemplateInput`](crate::input::DeleteWorldTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world template you want to delete.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template you want to delete.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorldTemplateInput`](crate::input::DeleteWorldTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorldTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorldTemplateInput {
                template: self.template,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorldTemplateInputOperationOutputAlias = crate::operation::DeleteWorldTemplate;
#[doc(hidden)]
pub type DeleteWorldTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWorldTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorldTemplate`](crate::operation::DeleteWorldTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorldTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteWorldTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/deleteWorldTemplate").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteWorldTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_world_template(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorldTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorldTemplate",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorldTemplateInput`](crate::input::DeleteWorldTemplateInput)
    pub fn builder() -> crate::input::delete_world_template_input::Builder {
        crate::input::delete_world_template_input::Builder::default()
    }
}

/// See [`DeregisterRobotInput`](crate::input::DeregisterRobotInput)
pub mod deregister_robot_input {
    /// A builder for [`DeregisterRobotInput`](crate::input::DeregisterRobotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) robot: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.robot = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.robot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterRobotInput`](crate::input::DeregisterRobotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterRobotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterRobotInput {
                fleet: self.fleet,
                robot: self.robot,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterRobotInputOperationOutputAlias = crate::operation::DeregisterRobot;
#[doc(hidden)]
pub type DeregisterRobotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterRobotInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterRobot`](crate::operation::DeregisterRobot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterRobot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeregisterRobotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/deregisterRobot").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeregisterRobotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deregister_robot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterRobot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterRobot",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeregisterRobotInput`](crate::input::DeregisterRobotInput)
    pub fn builder() -> crate::input::deregister_robot_input::Builder {
        crate::input::deregister_robot_input::Builder::default()
    }
}

/// See [`DescribeDeploymentJobInput`](crate::input::DescribeDeploymentJobInput)
pub mod describe_deployment_job_input {
    /// A builder for [`DescribeDeploymentJobInput`](crate::input::DescribeDeploymentJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeploymentJobInput`](crate::input::DescribeDeploymentJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeploymentJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeploymentJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeploymentJobInputOperationOutputAlias = crate::operation::DescribeDeploymentJob;
#[doc(hidden)]
pub type DescribeDeploymentJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDeploymentJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDeploymentJob`](crate::operation::DescribeDeploymentJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDeploymentJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDeploymentJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeDeploymentJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDeploymentJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_deployment_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDeploymentJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDeploymentJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeploymentJobInput`](crate::input::DescribeDeploymentJobInput)
    pub fn builder() -> crate::input::describe_deployment_job_input::Builder {
        crate::input::describe_deployment_job_input::Builder::default()
    }
}

/// See [`DescribeFleetInput`](crate::input::DescribeFleetInput)
pub mod describe_fleet_input {
    /// A builder for [`DescribeFleetInput`](crate::input::DescribeFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetInput`](crate::input::DescribeFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetInput { fleet: self.fleet })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetInputOperationOutputAlias = crate::operation::DescribeFleet;
#[doc(hidden)]
pub type DescribeFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleet`](crate::operation::DescribeFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeFleet").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleet",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetInput`](crate::input::DescribeFleetInput)
    pub fn builder() -> crate::input::describe_fleet_input::Builder {
        crate::input::describe_fleet_input::Builder::default()
    }
}

/// See [`DescribeRobotInput`](crate::input::DescribeRobotInput)
pub mod describe_robot_input {
    /// A builder for [`DescribeRobotInput`](crate::input::DescribeRobotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) robot: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot to be described.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.robot = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot to be described.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.robot = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRobotInput`](crate::input::DescribeRobotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRobotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRobotInput { robot: self.robot })
        }
    }
}
#[doc(hidden)]
pub type DescribeRobotInputOperationOutputAlias = crate::operation::DescribeRobot;
#[doc(hidden)]
pub type DescribeRobotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRobotInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRobot`](crate::operation::DescribeRobot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRobot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRobotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeRobot").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRobotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_robot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRobot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRobot",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRobotInput`](crate::input::DescribeRobotInput)
    pub fn builder() -> crate::input::describe_robot_input::Builder {
        crate::input::describe_robot_input::Builder::default()
    }
}

/// See [`DescribeRobotApplicationInput`](crate::input::DescribeRobotApplicationInput)
pub mod describe_robot_application_input {
    /// A builder for [`DescribeRobotApplicationInput`](crate::input::DescribeRobotApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) application_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The version of the robot application to describe.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version = Some(input.into());
            self
        }
        /// <p>The version of the robot application to describe.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRobotApplicationInput`](crate::input::DescribeRobotApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRobotApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRobotApplicationInput {
                application: self.application,
                application_version: self.application_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRobotApplicationInputOperationOutputAlias =
    crate::operation::DescribeRobotApplication;
#[doc(hidden)]
pub type DescribeRobotApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRobotApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRobotApplication`](crate::operation::DescribeRobotApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRobotApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRobotApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeRobotApplication").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRobotApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_robot_application(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRobotApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRobotApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRobotApplicationInput`](crate::input::DescribeRobotApplicationInput)
    pub fn builder() -> crate::input::describe_robot_application_input::Builder {
        crate::input::describe_robot_application_input::Builder::default()
    }
}

/// See [`DescribeSimulationApplicationInput`](crate::input::DescribeSimulationApplicationInput)
pub mod describe_simulation_application_input {
    /// A builder for [`DescribeSimulationApplicationInput`](crate::input::DescribeSimulationApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) application_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The application information for the simulation application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the simulation application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// <p>The version of the simulation application to describe.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_version = Some(input.into());
            self
        }
        /// <p>The version of the simulation application to describe.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSimulationApplicationInput`](crate::input::DescribeSimulationApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSimulationApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSimulationApplicationInput {
                application: self.application,
                application_version: self.application_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSimulationApplicationInputOperationOutputAlias =
    crate::operation::DescribeSimulationApplication;
#[doc(hidden)]
pub type DescribeSimulationApplicationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSimulationApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSimulationApplication`](crate::operation::DescribeSimulationApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSimulationApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSimulationApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeSimulationApplication")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSimulationApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_simulation_application(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSimulationApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSimulationApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSimulationApplicationInput`](crate::input::DescribeSimulationApplicationInput)
    pub fn builder() -> crate::input::describe_simulation_application_input::Builder {
        crate::input::describe_simulation_application_input::Builder::default()
    }
}

/// See [`DescribeSimulationJobInput`](crate::input::DescribeSimulationJobInput)
pub mod describe_simulation_job_input {
    /// A builder for [`DescribeSimulationJobInput`](crate::input::DescribeSimulationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation job to be described.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job to be described.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSimulationJobInput`](crate::input::DescribeSimulationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSimulationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSimulationJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type DescribeSimulationJobInputOperationOutputAlias = crate::operation::DescribeSimulationJob;
#[doc(hidden)]
pub type DescribeSimulationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSimulationJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSimulationJob`](crate::operation::DescribeSimulationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSimulationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSimulationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeSimulationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSimulationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_simulation_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSimulationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSimulationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSimulationJobInput`](crate::input::DescribeSimulationJobInput)
    pub fn builder() -> crate::input::describe_simulation_job_input::Builder {
        crate::input::describe_simulation_job_input::Builder::default()
    }
}

/// See [`DescribeSimulationJobBatchInput`](crate::input::DescribeSimulationJobBatchInput)
pub mod describe_simulation_job_batch_input {
    /// A builder for [`DescribeSimulationJobBatchInput`](crate::input::DescribeSimulationJobBatchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The id of the batch to describe.</p>
        pub fn batch(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch = Some(input.into());
            self
        }
        /// <p>The id of the batch to describe.</p>
        pub fn set_batch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.batch = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSimulationJobBatchInput`](crate::input::DescribeSimulationJobBatchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSimulationJobBatchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSimulationJobBatchInput { batch: self.batch })
        }
    }
}
#[doc(hidden)]
pub type DescribeSimulationJobBatchInputOperationOutputAlias =
    crate::operation::DescribeSimulationJobBatch;
#[doc(hidden)]
pub type DescribeSimulationJobBatchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSimulationJobBatchInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSimulationJobBatch`](crate::operation::DescribeSimulationJobBatch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSimulationJobBatch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSimulationJobBatchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeSimulationJobBatch").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSimulationJobBatchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_simulation_job_batch(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSimulationJobBatch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSimulationJobBatch",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSimulationJobBatchInput`](crate::input::DescribeSimulationJobBatchInput)
    pub fn builder() -> crate::input::describe_simulation_job_batch_input::Builder {
        crate::input::describe_simulation_job_batch_input::Builder::default()
    }
}

/// See [`DescribeWorldInput`](crate::input::DescribeWorldInput)
pub mod describe_world_input {
    /// A builder for [`DescribeWorldInput`](crate::input::DescribeWorldInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) world: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world you want to describe.</p>
        pub fn world(mut self, input: impl Into<std::string::String>) -> Self {
            self.world = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world you want to describe.</p>
        pub fn set_world(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.world = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldInput`](crate::input::DescribeWorldInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorldInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorldInput { world: self.world })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorldInputOperationOutputAlias = crate::operation::DescribeWorld;
#[doc(hidden)]
pub type DescribeWorldInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeWorldInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorld`](crate::operation::DescribeWorld)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorld,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeWorldInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeWorld").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeWorldInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_world(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorld::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorld",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorldInput`](crate::input::DescribeWorldInput)
    pub fn builder() -> crate::input::describe_world_input::Builder {
        crate::input::describe_world_input::Builder::default()
    }
}

/// See [`DescribeWorldExportJobInput`](crate::input::DescribeWorldExportJobInput)
pub mod describe_world_export_job_input {
    /// A builder for [`DescribeWorldExportJobInput`](crate::input::DescribeWorldExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world export job to describe.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world export job to describe.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldExportJobInput`](crate::input::DescribeWorldExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorldExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorldExportJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorldExportJobInputOperationOutputAlias = crate::operation::DescribeWorldExportJob;
#[doc(hidden)]
pub type DescribeWorldExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeWorldExportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorldExportJob`](crate::operation::DescribeWorldExportJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorldExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeWorldExportJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeWorldExportJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeWorldExportJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_world_export_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorldExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorldExportJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorldExportJobInput`](crate::input::DescribeWorldExportJobInput)
    pub fn builder() -> crate::input::describe_world_export_job_input::Builder {
        crate::input::describe_world_export_job_input::Builder::default()
    }
}

/// See [`DescribeWorldGenerationJobInput`](crate::input::DescribeWorldGenerationJobInput)
pub mod describe_world_generation_job_input {
    /// A builder for [`DescribeWorldGenerationJobInput`](crate::input::DescribeWorldGenerationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world generation job to describe.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generation job to describe.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldGenerationJobInput`](crate::input::DescribeWorldGenerationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorldGenerationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorldGenerationJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorldGenerationJobInputOperationOutputAlias =
    crate::operation::DescribeWorldGenerationJob;
#[doc(hidden)]
pub type DescribeWorldGenerationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeWorldGenerationJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorldGenerationJob`](crate::operation::DescribeWorldGenerationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorldGenerationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeWorldGenerationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeWorldGenerationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeWorldGenerationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_world_generation_job(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorldGenerationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorldGenerationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorldGenerationJobInput`](crate::input::DescribeWorldGenerationJobInput)
    pub fn builder() -> crate::input::describe_world_generation_job_input::Builder {
        crate::input::describe_world_generation_job_input::Builder::default()
    }
}

/// See [`DescribeWorldTemplateInput`](crate::input::DescribeWorldTemplateInput)
pub mod describe_world_template_input {
    /// A builder for [`DescribeWorldTemplateInput`](crate::input::DescribeWorldTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world template you want to describe.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template you want to describe.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldTemplateInput`](crate::input::DescribeWorldTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWorldTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWorldTemplateInput {
                template: self.template,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWorldTemplateInputOperationOutputAlias = crate::operation::DescribeWorldTemplate;
#[doc(hidden)]
pub type DescribeWorldTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeWorldTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWorldTemplate`](crate::operation::DescribeWorldTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWorldTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeWorldTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/describeWorldTemplate").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeWorldTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_world_template(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWorldTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWorldTemplate",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeWorldTemplateInput`](crate::input::DescribeWorldTemplateInput)
    pub fn builder() -> crate::input::describe_world_template_input::Builder {
        crate::input::describe_world_template_input::Builder::default()
    }
}

/// See [`GetWorldTemplateBodyInput`](crate::input::GetWorldTemplateBodyInput)
pub mod get_world_template_body_input {
    /// A builder for [`GetWorldTemplateBodyInput`](crate::input::GetWorldTemplateBodyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) generation_job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generator job.</p>
        pub fn generation_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generator job.</p>
        pub fn set_generation_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_job = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorldTemplateBodyInput`](crate::input::GetWorldTemplateBodyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorldTemplateBodyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorldTemplateBodyInput {
                template: self.template,
                generation_job: self.generation_job,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorldTemplateBodyInputOperationOutputAlias = crate::operation::GetWorldTemplateBody;
#[doc(hidden)]
pub type GetWorldTemplateBodyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWorldTemplateBodyInput {
    /// Consumes the builder and constructs an Operation<[`GetWorldTemplateBody`](crate::operation::GetWorldTemplateBody)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorldTemplateBody,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetWorldTemplateBodyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/getWorldTemplateBody").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetWorldTemplateBodyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_world_template_body(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorldTemplateBody::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorldTemplateBody",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetWorldTemplateBodyInput`](crate::input::GetWorldTemplateBodyInput)
    pub fn builder() -> crate::input::get_world_template_body_input::Builder {
        crate::input::get_world_template_body_input::Builder::default()
    }
}

/// See [`ListDeploymentJobsInput`](crate::input::ListDeploymentJobsInput)
pub mod list_deployment_jobs_input {
    /// A builder for [`ListDeploymentJobsInput`](crate::input::ListDeploymentJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>InProgress</code> or the status <code>Pending</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>InProgress</code> or the status <code>Pending</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListDeploymentJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListDeploymentJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListDeploymentJobs</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListDeploymentJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListDeploymentJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListDeploymentJobs</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentJobsInput`](crate::input::ListDeploymentJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDeploymentJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDeploymentJobsInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDeploymentJobsInputOperationOutputAlias = crate::operation::ListDeploymentJobs;
#[doc(hidden)]
pub type ListDeploymentJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDeploymentJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListDeploymentJobs`](crate::operation::ListDeploymentJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDeploymentJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDeploymentJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listDeploymentJobs").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDeploymentJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_deployment_jobs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDeploymentJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDeploymentJobs",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDeploymentJobsInput`](crate::input::ListDeploymentJobsInput)
    pub fn builder() -> crate::input::list_deployment_jobs_input::Builder {
        crate::input::list_deployment_jobs_input::Builder::default()
    }
}

/// See [`ListFleetsInput`](crate::input::ListFleetsInput)
pub mod list_fleets_input {
    /// A builder for [`ListFleetsInput`](crate::input::ListFleetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListFleets</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListFleets</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListFleets</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFleets</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListFleets</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListFleets</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFleets</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListFleets</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFleetsInput`](crate::input::ListFleetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFleetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFleetsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFleetsInputOperationOutputAlias = crate::operation::ListFleets;
#[doc(hidden)]
pub type ListFleetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFleetsInput {
    /// Consumes the builder and constructs an Operation<[`ListFleets`](crate::operation::ListFleets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFleets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFleetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listFleets").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFleetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_fleets(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFleets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFleets",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFleetsInput`](crate::input::ListFleetsInput)
    pub fn builder() -> crate::input::list_fleets_input::Builder {
        crate::input::list_fleets_input::Builder::default()
    }
}

/// See [`ListRobotApplicationsInput`](crate::input::ListRobotApplicationsInput)
pub mod list_robot_applications_input {
    /// A builder for [`ListRobotApplicationsInput`](crate::input::ListRobotApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_qualifier: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The version qualifier of the robot application.</p>
        pub fn version_qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_qualifier = Some(input.into());
            self
        }
        /// <p>The version qualifier of the robot application.</p>
        pub fn set_version_qualifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_qualifier = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobotApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobotApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListRobotApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobotApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListRobotApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListRobotApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobotApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListRobotApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRobotApplicationsInput`](crate::input::ListRobotApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRobotApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRobotApplicationsInput {
                version_qualifier: self.version_qualifier,
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRobotApplicationsInputOperationOutputAlias = crate::operation::ListRobotApplications;
#[doc(hidden)]
pub type ListRobotApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRobotApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListRobotApplications`](crate::operation::ListRobotApplications)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRobotApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRobotApplicationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listRobotApplications").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRobotApplicationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_robot_applications(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRobotApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRobotApplications",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRobotApplicationsInput`](crate::input::ListRobotApplicationsInput)
    pub fn builder() -> crate::input::list_robot_applications_input::Builder {
        crate::input::list_robot_applications_input::Builder::default()
    }
}

/// See [`ListRobotsInput`](crate::input::ListRobotsInput)
pub mod list_robots_input {
    /// A builder for [`ListRobotsInput`](crate::input::ListRobotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobots</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobots</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListRobots</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobots</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListRobots</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListRobots</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobots</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListRobots</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Registered</code> or the status <code>Available</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Registered</code> or the status <code>Available</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRobotsInput`](crate::input::ListRobotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRobotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRobotsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRobotsInputOperationOutputAlias = crate::operation::ListRobots;
#[doc(hidden)]
pub type ListRobotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRobotsInput {
    /// Consumes the builder and constructs an Operation<[`ListRobots`](crate::operation::ListRobots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRobots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRobotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listRobots").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRobotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_robots(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRobots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRobots",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRobotsInput`](crate::input::ListRobotsInput)
    pub fn builder() -> crate::input::list_robots_input::Builder {
        crate::input::list_robots_input::Builder::default()
    }
}

/// See [`ListSimulationApplicationsInput`](crate::input::ListSimulationApplicationsInput)
pub mod list_simulation_applications_input {
    /// A builder for [`ListSimulationApplicationsInput`](crate::input::ListSimulationApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version_qualifier: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The version qualifier of the simulation application.</p>
        pub fn version_qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_qualifier = Some(input.into());
            self
        }
        /// <p>The version qualifier of the simulation application.</p>
        pub fn set_version_qualifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_qualifier = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListSimulationApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListSimulationApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional list of filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional list of filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSimulationApplicationsInput`](crate::input::ListSimulationApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSimulationApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSimulationApplicationsInput {
                version_qualifier: self.version_qualifier,
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSimulationApplicationsInputOperationOutputAlias =
    crate::operation::ListSimulationApplications;
#[doc(hidden)]
pub type ListSimulationApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSimulationApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListSimulationApplications`](crate::operation::ListSimulationApplications)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSimulationApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListSimulationApplicationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listSimulationApplications").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListSimulationApplicationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_simulation_applications(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSimulationApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSimulationApplications",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListSimulationApplicationsInput`](crate::input::ListSimulationApplicationsInput)
    pub fn builder() -> crate::input::list_simulation_applications_input::Builder {
        crate::input::list_simulation_applications_input::Builder::default()
    }
}

/// See [`ListSimulationJobBatchesInput`](crate::input::ListSimulationJobBatchesInput)
pub mod list_simulation_job_batches_input {
    /// A builder for [`ListSimulationJobBatchesInput`](crate::input::ListSimulationJobBatchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSimulationJobBatchesInput`](crate::input::ListSimulationJobBatchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSimulationJobBatchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSimulationJobBatchesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSimulationJobBatchesInputOperationOutputAlias =
    crate::operation::ListSimulationJobBatches;
#[doc(hidden)]
pub type ListSimulationJobBatchesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSimulationJobBatchesInput {
    /// Consumes the builder and constructs an Operation<[`ListSimulationJobBatches`](crate::operation::ListSimulationJobBatches)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSimulationJobBatches,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListSimulationJobBatchesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listSimulationJobBatches").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListSimulationJobBatchesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_simulation_job_batches(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSimulationJobBatches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSimulationJobBatches",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListSimulationJobBatchesInput`](crate::input::ListSimulationJobBatchesInput)
    pub fn builder() -> crate::input::list_simulation_job_batches_input::Builder {
        crate::input::list_simulation_job_batches_input::Builder::default()
    }
}

/// See [`ListSimulationJobsInput`](crate::input::ListSimulationJobsInput)
pub mod list_simulation_jobs_input {
    /// A builder for [`ListSimulationJobsInput`](crate::input::ListSimulationJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListSimulationJobs</code> returns up to 1000 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListSimulationJobs</code> returns up to 1000 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>simulationApplicationName</code> and <code>robotApplicationName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Preparing</code> or the status <code>Running</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>simulationApplicationName</code> and <code>robotApplicationName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Preparing</code> or the status <code>Running</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSimulationJobsInput`](crate::input::ListSimulationJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSimulationJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSimulationJobsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSimulationJobsInputOperationOutputAlias = crate::operation::ListSimulationJobs;
#[doc(hidden)]
pub type ListSimulationJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSimulationJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListSimulationJobs`](crate::operation::ListSimulationJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSimulationJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListSimulationJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listSimulationJobs").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListSimulationJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_simulation_jobs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSimulationJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSimulationJobs",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListSimulationJobsInput`](crate::input::ListSimulationJobsInput)
    pub fn builder() -> crate::input::list_simulation_jobs_input::Builder {
        crate::input::list_simulation_jobs_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.resource_arn;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_1, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWorldExportJobsInput`](crate::input::ListWorldExportJobsInput)
pub mod list_world_export_jobs_input {
    /// A builder for [`ListWorldExportJobsInput`](crate::input::ListWorldExportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldExportJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldExportJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListWorldExportJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldExportJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldExportJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldExportJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldExportJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldExportJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results. You can use <code>generationJobId</code> and <code>templateId</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results. You can use <code>generationJobId</code> and <code>templateId</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldExportJobsInput`](crate::input::ListWorldExportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorldExportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorldExportJobsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorldExportJobsInputOperationOutputAlias = crate::operation::ListWorldExportJobs;
#[doc(hidden)]
pub type ListWorldExportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWorldExportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorldExportJobs`](crate::operation::ListWorldExportJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorldExportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListWorldExportJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listWorldExportJobs").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListWorldExportJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_world_export_jobs(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorldExportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorldExportJobs",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListWorldExportJobsInput`](crate::input::ListWorldExportJobsInput)
    pub fn builder() -> crate::input::list_world_export_jobs_input::Builder {
        crate::input::list_world_export_jobs_input::Builder::default()
    }
}

/// See [`ListWorldGenerationJobsInput`](crate::input::ListWorldGenerationJobsInput)
pub mod list_world_generation_jobs_input {
    /// A builder for [`ListWorldGenerationJobsInput`](crate::input::ListWorldGenerationJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldGenerationJobsRequest</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldGenerationJobsRequest</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListWorldGeneratorJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldGeneratorJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldGeneratorJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldGeneratorJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldGeneratorJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldGeneratorJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results. You can use <code>status</code> and <code>templateId</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results. You can use <code>status</code> and <code>templateId</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldGenerationJobsInput`](crate::input::ListWorldGenerationJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorldGenerationJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorldGenerationJobsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorldGenerationJobsInputOperationOutputAlias =
    crate::operation::ListWorldGenerationJobs;
#[doc(hidden)]
pub type ListWorldGenerationJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWorldGenerationJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorldGenerationJobs`](crate::operation::ListWorldGenerationJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorldGenerationJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListWorldGenerationJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listWorldGenerationJobs").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListWorldGenerationJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_world_generation_jobs(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorldGenerationJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorldGenerationJobs",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListWorldGenerationJobsInput`](crate::input::ListWorldGenerationJobsInput)
    pub fn builder() -> crate::input::list_world_generation_jobs_input::Builder {
        crate::input::list_world_generation_jobs_input::Builder::default()
    }
}

/// See [`ListWorldsInput`](crate::input::ListWorldsInput)
pub mod list_worlds_input {
    /// A builder for [`ListWorldsInput`](crate::input::ListWorldsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorlds</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorlds</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListWorlds</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorlds</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorlds</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorlds</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorlds</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorlds</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results. You can use <code>status</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Optional filters to limit results. You can use <code>status</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldsInput`](crate::input::ListWorldsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorldsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorldsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorldsInputOperationOutputAlias = crate::operation::ListWorlds;
#[doc(hidden)]
pub type ListWorldsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWorldsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorlds`](crate::operation::ListWorlds)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorlds,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListWorldsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listWorlds").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListWorldsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_worlds(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorlds::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorlds",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListWorldsInput`](crate::input::ListWorldsInput)
    pub fn builder() -> crate::input::list_worlds_input::Builder {
        crate::input::list_worlds_input::Builder::default()
    }
}

/// See [`ListWorldTemplatesInput`](crate::input::ListWorldTemplatesInput)
pub mod list_world_templates_input {
    /// A builder for [`ListWorldTemplatesInput`](crate::input::ListWorldTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>When this parameter is used, <code>ListWorldTemplates</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldTemplates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldTemplates</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldTemplates</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldTemplates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldTemplates</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldTemplatesInput`](crate::input::ListWorldTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorldTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorldTemplatesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorldTemplatesInputOperationOutputAlias = crate::operation::ListWorldTemplates;
#[doc(hidden)]
pub type ListWorldTemplatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWorldTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListWorldTemplates`](crate::operation::ListWorldTemplates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorldTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListWorldTemplatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/listWorldTemplates").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListWorldTemplatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_world_templates(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorldTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorldTemplates",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListWorldTemplatesInput`](crate::input::ListWorldTemplatesInput)
    pub fn builder() -> crate::input::list_world_templates_input::Builder {
        crate::input::list_world_templates_input::Builder::default()
    }
}

/// See [`RegisterRobotInput`](crate::input::RegisterRobotInput)
pub mod register_robot_input {
    /// A builder for [`RegisterRobotInput`](crate::input::RegisterRobotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) robot: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.robot = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.robot = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterRobotInput`](crate::input::RegisterRobotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterRobotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterRobotInput {
                fleet: self.fleet,
                robot: self.robot,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterRobotInputOperationOutputAlias = crate::operation::RegisterRobot;
#[doc(hidden)]
pub type RegisterRobotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RegisterRobotInput {
    /// Consumes the builder and constructs an Operation<[`RegisterRobot`](crate::operation::RegisterRobot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterRobot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RegisterRobotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/registerRobot").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RegisterRobotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_register_robot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterRobot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterRobot",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RegisterRobotInput`](crate::input::RegisterRobotInput)
    pub fn builder() -> crate::input::register_robot_input::Builder {
        crate::input::register_robot_input::Builder::default()
    }
}

/// See [`RestartSimulationJobInput`](crate::input::RestartSimulationJobInput)
pub mod restart_simulation_job_input {
    /// A builder for [`RestartSimulationJobInput`](crate::input::RestartSimulationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`RestartSimulationJobInput`](crate::input::RestartSimulationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RestartSimulationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RestartSimulationJobInput { job: self.job })
        }
    }
}
#[doc(hidden)]
pub type RestartSimulationJobInputOperationOutputAlias = crate::operation::RestartSimulationJob;
#[doc(hidden)]
pub type RestartSimulationJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RestartSimulationJobInput {
    /// Consumes the builder and constructs an Operation<[`RestartSimulationJob`](crate::operation::RestartSimulationJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RestartSimulationJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RestartSimulationJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/restartSimulationJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RestartSimulationJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_restart_simulation_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RestartSimulationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RestartSimulationJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RestartSimulationJobInput`](crate::input::RestartSimulationJobInput)
    pub fn builder() -> crate::input::restart_simulation_job_input::Builder {
        crate::input::restart_simulation_job_input::Builder::default()
    }
}

/// See [`StartSimulationJobBatchInput`](crate::input::StartSimulationJobBatchInput)
pub mod start_simulation_job_batch_input {
    /// A builder for [`StartSimulationJobBatchInput`](crate::input::StartSimulationJobBatchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) batch_policy: std::option::Option<crate::model::BatchPolicy>,
        pub(crate) create_simulation_job_requests:
            std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The batch policy.</p>
        pub fn batch_policy(mut self, input: crate::model::BatchPolicy) -> Self {
            self.batch_policy = Some(input);
            self
        }
        /// <p>The batch policy.</p>
        pub fn set_batch_policy(
            mut self,
            input: std::option::Option<crate::model::BatchPolicy>,
        ) -> Self {
            self.batch_policy = input;
            self
        }
        /// Appends an item to `create_simulation_job_requests`.
        ///
        /// To override the contents of this collection use [`set_create_simulation_job_requests`](Self::set_create_simulation_job_requests).
        ///
        /// <p>A list of simulation job requests to create in the batch.</p>
        pub fn create_simulation_job_requests(
            mut self,
            input: crate::model::SimulationJobRequest,
        ) -> Self {
            let mut v = self.create_simulation_job_requests.unwrap_or_default();
            v.push(input);
            self.create_simulation_job_requests = Some(v);
            self
        }
        /// <p>A list of simulation job requests to create in the batch.</p>
        pub fn set_create_simulation_job_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
        ) -> Self {
            self.create_simulation_job_requests = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSimulationJobBatchInput`](crate::input::StartSimulationJobBatchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSimulationJobBatchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSimulationJobBatchInput {
                client_request_token: self.client_request_token,
                batch_policy: self.batch_policy,
                create_simulation_job_requests: self.create_simulation_job_requests,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSimulationJobBatchInputOperationOutputAlias =
    crate::operation::StartSimulationJobBatch;
#[doc(hidden)]
pub type StartSimulationJobBatchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartSimulationJobBatchInput {
    /// Consumes the builder and constructs an Operation<[`StartSimulationJobBatch`](crate::operation::StartSimulationJobBatch)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSimulationJobBatch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartSimulationJobBatchInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/startSimulationJobBatch").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartSimulationJobBatchInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_simulation_job_batch(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSimulationJobBatch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSimulationJobBatch",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartSimulationJobBatchInput`](crate::input::StartSimulationJobBatchInput)
    pub fn builder() -> crate::input::start_simulation_job_batch_input::Builder {
        crate::input::start_simulation_job_batch_input::Builder::default()
    }
}

/// See [`SyncDeploymentJobInput`](crate::input::SyncDeploymentJobInput)
pub mod sync_deployment_job_input {
    /// A builder for [`SyncDeploymentJobInput`](crate::input::SyncDeploymentJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) fleet: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The target fleet for the synchronization.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The target fleet for the synchronization.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// Consumes the builder and constructs a [`SyncDeploymentJobInput`](crate::input::SyncDeploymentJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SyncDeploymentJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SyncDeploymentJobInput {
                client_request_token: self.client_request_token,
                fleet: self.fleet,
            })
        }
    }
}
#[doc(hidden)]
pub type SyncDeploymentJobInputOperationOutputAlias = crate::operation::SyncDeploymentJob;
#[doc(hidden)]
pub type SyncDeploymentJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SyncDeploymentJobInput {
    /// Consumes the builder and constructs an Operation<[`SyncDeploymentJob`](crate::operation::SyncDeploymentJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SyncDeploymentJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::SyncDeploymentJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/syncDeploymentJob").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SyncDeploymentJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_sync_deployment_job(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SyncDeploymentJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SyncDeploymentJob",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SyncDeploymentJobInput`](crate::input::SyncDeploymentJobInput)
    pub fn builder() -> crate::input::sync_deployment_job_input::Builder {
        crate::input::sync_deployment_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.resource_arn;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_2, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A map that contains tag keys and tag values that will be unattached from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A map that contains tag keys and tag values that will be unattached from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.resource_arn;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_3, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_4) = &_input.tag_keys {
                    for inner_5 in inner_4 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_5));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateRobotApplicationInput`](crate::input::UpdateRobotApplicationInput)
pub mod update_robot_application_input {
    /// A builder for [`UpdateRobotApplicationInput`](crate::input::UpdateRobotApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) current_revision_id: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The application information for the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_revision_id = Some(input.into());
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_revision_id = input;
            self
        }
        /// <p>The object that contains the Docker image URI for your robot application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI for your robot application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRobotApplicationInput`](crate::input::UpdateRobotApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRobotApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRobotApplicationInput {
                application: self.application,
                sources: self.sources,
                robot_software_suite: self.robot_software_suite,
                current_revision_id: self.current_revision_id,
                environment: self.environment,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRobotApplicationInputOperationOutputAlias = crate::operation::UpdateRobotApplication;
#[doc(hidden)]
pub type UpdateRobotApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRobotApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRobotApplication`](crate::operation::UpdateRobotApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRobotApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRobotApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/updateRobotApplication").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRobotApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_robot_application(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRobotApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRobotApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRobotApplicationInput`](crate::input::UpdateRobotApplicationInput)
    pub fn builder() -> crate::input::update_robot_application_input::Builder {
        crate::input::update_robot_application_input::Builder::default()
    }
}

/// See [`UpdateSimulationApplicationInput`](crate::input::UpdateSimulationApplicationInput)
pub mod update_simulation_application_input {
    /// A builder for [`UpdateSimulationApplicationInput`](crate::input::UpdateSimulationApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) application: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        pub(crate) simulation_software_suite:
            std::option::Option<crate::model::SimulationSoftwareSuite>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) rendering_engine: std::option::Option<crate::model::RenderingEngine>,
        pub(crate) current_revision_id: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The application information for the simulation application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.application = Some(input.into());
            self
        }
        /// <p>The application information for the simulation application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.application = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input);
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.simulation_software_suite = Some(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.simulation_software_suite = input;
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.rendering_engine = Some(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.rendering_engine = input;
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_revision_id = Some(input.into());
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_revision_id = input;
            self
        }
        /// <p>The object that contains the Docker image URI for your simulation application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI for your simulation application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSimulationApplicationInput`](crate::input::UpdateSimulationApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSimulationApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSimulationApplicationInput {
                application: self.application,
                sources: self.sources,
                simulation_software_suite: self.simulation_software_suite,
                robot_software_suite: self.robot_software_suite,
                rendering_engine: self.rendering_engine,
                current_revision_id: self.current_revision_id,
                environment: self.environment,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSimulationApplicationInputOperationOutputAlias =
    crate::operation::UpdateSimulationApplication;
#[doc(hidden)]
pub type UpdateSimulationApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSimulationApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSimulationApplication`](crate::operation::UpdateSimulationApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSimulationApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateSimulationApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/updateSimulationApplication").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateSimulationApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_simulation_application(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSimulationApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSimulationApplication",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateSimulationApplicationInput`](crate::input::UpdateSimulationApplicationInput)
    pub fn builder() -> crate::input::update_simulation_application_input::Builder {
        crate::input::update_simulation_application_input::Builder::default()
    }
}

/// See [`UpdateWorldTemplateInput`](crate::input::UpdateWorldTemplateInput)
pub mod update_world_template_input {
    /// A builder for [`UpdateWorldTemplateInput`](crate::input::UpdateWorldTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) template_body: std::option::Option<std::string::String>,
        pub(crate) template_location: std::option::Option<crate::model::TemplateLocation>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world template to update.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template to update.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>The name of the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The world template body.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The world template body.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// <p>The location of the world template.</p>
        pub fn template_location(mut self, input: crate::model::TemplateLocation) -> Self {
            self.template_location = Some(input);
            self
        }
        /// <p>The location of the world template.</p>
        pub fn set_template_location(
            mut self,
            input: std::option::Option<crate::model::TemplateLocation>,
        ) -> Self {
            self.template_location = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorldTemplateInput`](crate::input::UpdateWorldTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorldTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorldTemplateInput {
                template: self.template,
                name: self.name,
                template_body: self.template_body,
                template_location: self.template_location,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorldTemplateInputOperationOutputAlias = crate::operation::UpdateWorldTemplate;
#[doc(hidden)]
pub type UpdateWorldTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateWorldTemplateInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorldTemplate`](crate::operation::UpdateWorldTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorldTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateWorldTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/updateWorldTemplate").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateWorldTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_world_template(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorldTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorldTemplate",
            "robomaker",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorldTemplateInput`](crate::input::UpdateWorldTemplateInput)
    pub fn builder() -> crate::input::update_world_template_input::Builder {
        crate::input::update_world_template_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorldTemplateInput {
    /// <p>The Amazon Resource Name (arn) of the world template to update.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>The name of the template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The world template body.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>The location of the world template.</p>
    pub template_location: std::option::Option<crate::model::TemplateLocation>,
}
impl UpdateWorldTemplateInput {
    /// <p>The Amazon Resource Name (arn) of the world template to update.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>The name of the template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The world template body.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>The location of the world template.</p>
    pub fn template_location(&self) -> std::option::Option<&crate::model::TemplateLocation> {
        self.template_location.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorldTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorldTemplateInput");
        formatter.field("template", &self.template);
        formatter.field("name", &self.name);
        formatter.field("template_body", &self.template_body);
        formatter.field("template_location", &self.template_location);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSimulationApplicationInput {
    /// <p>The application information for the simulation application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The sources of the simulation application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
    /// <p>The simulation software suite used by the simulation application.</p>
    pub simulation_software_suite: std::option::Option<crate::model::SimulationSoftwareSuite>,
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The rendering engine for the simulation application.</p>
    pub rendering_engine: std::option::Option<crate::model::RenderingEngine>,
    /// <p>The revision id for the robot application.</p>
    pub current_revision_id: std::option::Option<std::string::String>,
    /// <p>The object that contains the Docker image URI for your simulation application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl UpdateSimulationApplicationInput {
    /// <p>The application information for the simulation application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The sources of the simulation application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::SourceConfig]> {
        self.sources.as_deref()
    }
    /// <p>The simulation software suite used by the simulation application.</p>
    pub fn simulation_software_suite(
        &self,
    ) -> std::option::Option<&crate::model::SimulationSoftwareSuite> {
        self.simulation_software_suite.as_ref()
    }
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The rendering engine for the simulation application.</p>
    pub fn rendering_engine(&self) -> std::option::Option<&crate::model::RenderingEngine> {
        self.rendering_engine.as_ref()
    }
    /// <p>The revision id for the robot application.</p>
    pub fn current_revision_id(&self) -> std::option::Option<&str> {
        self.current_revision_id.as_deref()
    }
    /// <p>The object that contains the Docker image URI for your simulation application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for UpdateSimulationApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSimulationApplicationInput");
        formatter.field("application", &self.application);
        formatter.field("sources", &self.sources);
        formatter.field("simulation_software_suite", &self.simulation_software_suite);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("rendering_engine", &self.rendering_engine);
        formatter.field("current_revision_id", &self.current_revision_id);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRobotApplicationInput {
    /// <p>The application information for the robot application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The sources of the robot application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The revision id for the robot application.</p>
    pub current_revision_id: std::option::Option<std::string::String>,
    /// <p>The object that contains the Docker image URI for your robot application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl UpdateRobotApplicationInput {
    /// <p>The application information for the robot application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The sources of the robot application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::SourceConfig]> {
        self.sources.as_deref()
    }
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The revision id for the robot application.</p>
    pub fn current_revision_id(&self) -> std::option::Option<&str> {
        self.current_revision_id.as_deref()
    }
    /// <p>The object that contains the Docker image URI for your robot application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for UpdateRobotApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRobotApplicationInput");
        formatter.field("application", &self.application);
        formatter.field("sources", &self.sources);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("current_revision_id", &self.current_revision_id);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that will be unattached from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that will be unattached from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SyncDeploymentJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The target fleet for the synchronization.</p>
    pub fleet: std::option::Option<std::string::String>,
}
impl SyncDeploymentJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The target fleet for the synchronization.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
}
impl std::fmt::Debug for SyncDeploymentJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SyncDeploymentJobInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("fleet", &self.fleet);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSimulationJobBatchInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The batch policy.</p>
    pub batch_policy: std::option::Option<crate::model::BatchPolicy>,
    /// <p>A list of simulation job requests to create in the batch.</p>
    pub create_simulation_job_requests:
        std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
    /// <p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartSimulationJobBatchInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The batch policy.</p>
    pub fn batch_policy(&self) -> std::option::Option<&crate::model::BatchPolicy> {
        self.batch_policy.as_ref()
    }
    /// <p>A list of simulation job requests to create in the batch.</p>
    pub fn create_simulation_job_requests(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationJobRequest]> {
        self.create_simulation_job_requests.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartSimulationJobBatchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSimulationJobBatchInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("batch_policy", &self.batch_policy);
        formatter.field(
            "create_simulation_job_requests",
            &self.create_simulation_job_requests,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestartSimulationJobInput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub job: std::option::Option<std::string::String>,
}
impl RestartSimulationJobInput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for RestartSimulationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestartSimulationJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub robot: std::option::Option<std::string::String>,
}
impl RegisterRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn robot(&self) -> std::option::Option<&str> {
        self.robot.as_deref()
    }
}
impl std::fmt::Debug for RegisterRobotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterRobotInput");
        formatter.field("fleet", &self.fleet);
        formatter.field("robot", &self.robot);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldTemplatesInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListWorldTemplates</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldTemplates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldTemplates</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListWorldTemplatesInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListWorldTemplates</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldTemplates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldTemplates</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListWorldTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorlds</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListWorlds</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorlds</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorlds</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results. You can use <code>status</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListWorldsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorlds</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListWorlds</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorlds</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorlds</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results. You can use <code>status</code>.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListWorldsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldGenerationJobsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldGenerationJobsRequest</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListWorldGeneratorJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldGeneratorJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldGeneratorJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results. You can use <code>status</code> and <code>templateId</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListWorldGenerationJobsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldGenerationJobsRequest</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListWorldGeneratorJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldGeneratorJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldGeneratorJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results. You can use <code>status</code> and <code>templateId</code>.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListWorldGenerationJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldGenerationJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldExportJobsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldExportJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListWorldExportJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldExportJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldExportJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results. You can use <code>generationJobId</code> and <code>templateId</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListWorldExportJobsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldExportJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListWorldExportJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldExportJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldExportJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results. You can use <code>generationJobId</code> and <code>templateId</code>.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListWorldExportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldExportJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSimulationJobsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListSimulationJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListSimulationJobs</code> returns up to 1000 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter names <code>status</code> and <code>simulationApplicationName</code> and <code>robotApplicationName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Preparing</code> or the status <code>Running</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListSimulationJobsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListSimulationJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListSimulationJobs</code> returns up to 1000 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter names <code>status</code> and <code>simulationApplicationName</code> and <code>robotApplicationName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Preparing</code> or the status <code>Running</code>.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListSimulationJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSimulationJobsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSimulationJobBatchesInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListSimulationJobBatchesInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListSimulationJobBatchesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSimulationJobBatchesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSimulationApplicationsInput {
    /// <p>The version qualifier of the simulation application.</p>
    pub version_qualifier: std::option::Option<std::string::String>,
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListSimulationApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListSimulationApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional list of filters to limit results.</p>
    /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListSimulationApplicationsInput {
    /// <p>The version qualifier of the simulation application.</p>
    pub fn version_qualifier(&self) -> std::option::Option<&str> {
        self.version_qualifier.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListSimulationApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListSimulationApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional list of filters to limit results.</p>
    /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListSimulationApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSimulationApplicationsInput");
        formatter.field("version_qualifier", &self.version_qualifier);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRobotsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobots</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListRobots</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobots</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListRobots</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Registered</code> or the status <code>Available</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListRobotsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobots</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListRobots</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobots</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListRobots</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Registered</code> or the status <code>Available</code>.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListRobotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRobotsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRobotApplicationsInput {
    /// <p>The version qualifier of the robot application.</p>
    pub version_qualifier: std::option::Option<std::string::String>,
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobotApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListRobotApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobotApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListRobotApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListRobotApplicationsInput {
    /// <p>The version qualifier of the robot application.</p>
    pub fn version_qualifier(&self) -> std::option::Option<&str> {
        self.version_qualifier.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobotApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListRobotApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobotApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListRobotApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListRobotApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRobotApplicationsInput");
        formatter.field("version_qualifier", &self.version_qualifier);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFleetsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListFleets</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p> <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListFleets</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFleets</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListFleets</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListFleetsInput {
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListFleets</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p> <note>
    /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListFleets</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFleets</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListFleets</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListFleetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFleetsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentJobsInput {
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>InProgress</code> or the status <code>Pending</code>.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>When this parameter is used, <code>ListDeploymentJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListDeploymentJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListDeploymentJobs</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListDeploymentJobsInput {
    /// <p>Optional filters to limit results.</p>
    /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>InProgress</code> or the status <code>Pending</code>.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>When this parameter is used, <code>ListDeploymentJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListDeploymentJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListDeploymentJobs</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDeploymentJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentJobsInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorldTemplateBodyInput {
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the world generator job.</p>
    pub generation_job: std::option::Option<std::string::String>,
}
impl GetWorldTemplateBodyInput {
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the world generator job.</p>
    pub fn generation_job(&self) -> std::option::Option<&str> {
        self.generation_job.as_deref()
    }
}
impl std::fmt::Debug for GetWorldTemplateBodyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorldTemplateBodyInput");
        formatter.field("template", &self.template);
        formatter.field("generation_job", &self.generation_job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldTemplateInput {
    /// <p>The Amazon Resource Name (arn) of the world template you want to describe.</p>
    pub template: std::option::Option<std::string::String>,
}
impl DescribeWorldTemplateInput {
    /// <p>The Amazon Resource Name (arn) of the world template you want to describe.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorldTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldTemplateInput");
        formatter.field("template", &self.template);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldGenerationJobInput {
    /// <p>The Amazon Resource Name (arn) of the world generation job to describe.</p>
    pub job: std::option::Option<std::string::String>,
}
impl DescribeWorldGenerationJobInput {
    /// <p>The Amazon Resource Name (arn) of the world generation job to describe.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorldGenerationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldGenerationJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldExportJobInput {
    /// <p>The Amazon Resource Name (arn) of the world export job to describe.</p>
    pub job: std::option::Option<std::string::String>,
}
impl DescribeWorldExportJobInput {
    /// <p>The Amazon Resource Name (arn) of the world export job to describe.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorldExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldExportJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldInput {
    /// <p>The Amazon Resource Name (arn) of the world you want to describe.</p>
    pub world: std::option::Option<std::string::String>,
}
impl DescribeWorldInput {
    /// <p>The Amazon Resource Name (arn) of the world you want to describe.</p>
    pub fn world(&self) -> std::option::Option<&str> {
        self.world.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorldInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldInput");
        formatter.field("world", &self.world);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSimulationJobBatchInput {
    /// <p>The id of the batch to describe.</p>
    pub batch: std::option::Option<std::string::String>,
}
impl DescribeSimulationJobBatchInput {
    /// <p>The id of the batch to describe.</p>
    pub fn batch(&self) -> std::option::Option<&str> {
        self.batch.as_deref()
    }
}
impl std::fmt::Debug for DescribeSimulationJobBatchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSimulationJobBatchInput");
        formatter.field("batch", &self.batch);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSimulationJobInput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job to be described.</p>
    pub job: std::option::Option<std::string::String>,
}
impl DescribeSimulationJobInput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job to be described.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for DescribeSimulationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSimulationJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSimulationApplicationInput {
    /// <p>The application information for the simulation application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The version of the simulation application to describe.</p>
    pub application_version: std::option::Option<std::string::String>,
}
impl DescribeSimulationApplicationInput {
    /// <p>The application information for the simulation application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The version of the simulation application to describe.</p>
    pub fn application_version(&self) -> std::option::Option<&str> {
        self.application_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeSimulationApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSimulationApplicationInput");
        formatter.field("application", &self.application);
        formatter.field("application_version", &self.application_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRobotApplicationInput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The version of the robot application to describe.</p>
    pub application_version: std::option::Option<std::string::String>,
}
impl DescribeRobotApplicationInput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The version of the robot application to describe.</p>
    pub fn application_version(&self) -> std::option::Option<&str> {
        self.application_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeRobotApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRobotApplicationInput");
        formatter.field("application", &self.application);
        formatter.field("application_version", &self.application_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the robot to be described.</p>
    pub robot: std::option::Option<std::string::String>,
}
impl DescribeRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the robot to be described.</p>
    pub fn robot(&self) -> std::option::Option<&str> {
        self.robot.as_deref()
    }
}
impl std::fmt::Debug for DescribeRobotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRobotInput");
        formatter.field("robot", &self.robot);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
}
impl DescribeFleetInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetInput");
        formatter.field("fleet", &self.fleet);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeploymentJobInput {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub job: std::option::Option<std::string::String>,
}
impl DescribeDeploymentJobInput {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for DescribeDeploymentJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeploymentJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub robot: std::option::Option<std::string::String>,
}
impl DeregisterRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn robot(&self) -> std::option::Option<&str> {
        self.robot.as_deref()
    }
}
impl std::fmt::Debug for DeregisterRobotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterRobotInput");
        formatter.field("fleet", &self.fleet);
        formatter.field("robot", &self.robot);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorldTemplateInput {
    /// <p>The Amazon Resource Name (arn) of the world template you want to delete.</p>
    pub template: std::option::Option<std::string::String>,
}
impl DeleteWorldTemplateInput {
    /// <p>The Amazon Resource Name (arn) of the world template you want to delete.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
}
impl std::fmt::Debug for DeleteWorldTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorldTemplateInput");
        formatter.field("template", &self.template);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSimulationApplicationInput {
    /// <p>The application information for the simulation application to delete.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The version of the simulation application to delete.</p>
    pub application_version: std::option::Option<std::string::String>,
}
impl DeleteSimulationApplicationInput {
    /// <p>The application information for the simulation application to delete.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The version of the simulation application to delete.</p>
    pub fn application_version(&self) -> std::option::Option<&str> {
        self.application_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteSimulationApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSimulationApplicationInput");
        formatter.field("application", &self.application);
        formatter.field("application_version", &self.application_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRobotApplicationInput {
    /// <p>The Amazon Resource Name (ARN) of the the robot application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The version of the robot application to delete.</p>
    pub application_version: std::option::Option<std::string::String>,
}
impl DeleteRobotApplicationInput {
    /// <p>The Amazon Resource Name (ARN) of the the robot application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The version of the robot application to delete.</p>
    pub fn application_version(&self) -> std::option::Option<&str> {
        self.application_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteRobotApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRobotApplicationInput");
        formatter.field("application", &self.application);
        formatter.field("application_version", &self.application_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub robot: std::option::Option<std::string::String>,
}
impl DeleteRobotInput {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn robot(&self) -> std::option::Option<&str> {
        self.robot.as_deref()
    }
}
impl std::fmt::Debug for DeleteRobotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRobotInput");
        formatter.field("robot", &self.robot);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFleetInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
}
impl DeleteFleetInput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
}
impl std::fmt::Debug for DeleteFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFleetInput");
        formatter.field("fleet", &self.fleet);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorldTemplateInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The name of the world template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The world template body.</p>
    pub template_body: std::option::Option<std::string::String>,
    /// <p>The location of the world template.</p>
    pub template_location: std::option::Option<crate::model::TemplateLocation>,
    /// <p>A map that contains tag keys and tag values that are attached to the world template.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorldTemplateInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The name of the world template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The world template body.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
    /// <p>The location of the world template.</p>
    pub fn template_location(&self) -> std::option::Option<&crate::model::TemplateLocation> {
        self.template_location.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world template.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorldTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorldTemplateInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("name", &self.name);
        formatter.field("template_body", &self.template_body);
        formatter.field("template_location", &self.template_location);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorldGenerationJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the world template describing the worlds you want to create.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>Information about the world count.</p>
    pub world_count: std::option::Option<crate::model::WorldCount>,
    /// <p>A map that contains tag keys and tag values that are attached to the world generator job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A map that contains tag keys and tag values that are attached to the generated worlds.</p>
    pub world_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorldGenerationJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the world template describing the worlds you want to create.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>Information about the world count.</p>
    pub fn world_count(&self) -> std::option::Option<&crate::model::WorldCount> {
        self.world_count.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world generator job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the generated worlds.</p>
    pub fn world_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.world_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorldGenerationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorldGenerationJobInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("template", &self.template);
        formatter.field("world_count", &self.world_count);
        formatter.field("tags", &self.tags);
        formatter.field("world_tags", &self.world_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorldExportJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to export.</p>
    pub worlds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The output location.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.</p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to the world export job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorldExportJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to export.</p>
    pub fn worlds(&self) -> std::option::Option<&[std::string::String]> {
        self.worlds.as_deref()
    }
    /// <p>The output location.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.</p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world export job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorldExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorldExportJobInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("worlds", &self.worlds);
        formatter.field("output_location", &self.output_location);
        formatter.field("iam_role", &self.iam_role);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSimulationJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Location for output files generated by the simulation job.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The logging configuration.</p>
    pub logging_config: std::option::Option<crate::model::LoggingConfig>,
    /// <p>The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to <code>Completed</code>.</p>
    pub max_job_duration_in_seconds: i64,
    /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>The failure behavior the simulation job.</p>
    /// <dl>
    /// <dt>
    /// Continue
    /// </dt>
    /// <dd>
    /// <p>Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.</p>
    /// </dd>
    /// <dt>
    /// Fail
    /// </dt>
    /// <dd>
    /// <p>Stop the simulation job and terminate the instance.</p>
    /// </dd>
    /// </dl>
    pub failure_behavior: std::option::Option<crate::model::FailureBehavior>,
    /// <p>The robot application to use in the simulation job.</p>
    pub robot_applications:
        std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
    /// <p>The simulation application to use in the simulation job.</p>
    pub simulation_applications:
        std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
    /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
    /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
    /// </note>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSourceConfig>>,
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Compute information for the simulation job.</p>
    pub compute: std::option::Option<crate::model::Compute>,
}
impl CreateSimulationJobInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Location for output files generated by the simulation job.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The logging configuration.</p>
    pub fn logging_config(&self) -> std::option::Option<&crate::model::LoggingConfig> {
        self.logging_config.as_ref()
    }
    /// <p>The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to <code>Completed</code>.</p>
    pub fn max_job_duration_in_seconds(&self) -> i64 {
        self.max_job_duration_in_seconds
    }
    /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>The failure behavior the simulation job.</p>
    /// <dl>
    /// <dt>
    /// Continue
    /// </dt>
    /// <dd>
    /// <p>Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.</p>
    /// </dd>
    /// <dt>
    /// Fail
    /// </dt>
    /// <dd>
    /// <p>Stop the simulation job and terminate the instance.</p>
    /// </dd>
    /// </dl>
    pub fn failure_behavior(&self) -> std::option::Option<&crate::model::FailureBehavior> {
        self.failure_behavior.as_ref()
    }
    /// <p>The robot application to use in the simulation job.</p>
    pub fn robot_applications(
        &self,
    ) -> std::option::Option<&[crate::model::RobotApplicationConfig]> {
        self.robot_applications.as_deref()
    }
    /// <p>The simulation application to use in the simulation job.</p>
    pub fn simulation_applications(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationApplicationConfig]> {
        self.simulation_applications.as_deref()
    }
    /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
    /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
    /// </note>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSourceConfig]> {
        self.data_sources.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>Compute information for the simulation job.</p>
    pub fn compute(&self) -> std::option::Option<&crate::model::Compute> {
        self.compute.as_ref()
    }
}
impl std::fmt::Debug for CreateSimulationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSimulationJobInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("output_location", &self.output_location);
        formatter.field("logging_config", &self.logging_config);
        formatter.field(
            "max_job_duration_in_seconds",
            &self.max_job_duration_in_seconds,
        );
        formatter.field("iam_role", &self.iam_role);
        formatter.field("failure_behavior", &self.failure_behavior);
        formatter.field("robot_applications", &self.robot_applications);
        formatter.field("simulation_applications", &self.simulation_applications);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("compute", &self.compute);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSimulationApplicationVersionInput {
    /// <p>The application information for the simulation application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
    pub current_revision_id: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 eTag identifier for the zip file bundle that you use to create the simulation application.</p>
    pub s3_etags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The SHA256 digest used to identify the Docker image URI used to created the simulation application.</p>
    pub image_digest: std::option::Option<std::string::String>,
}
impl CreateSimulationApplicationVersionInput {
    /// <p>The application information for the simulation application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
    pub fn current_revision_id(&self) -> std::option::Option<&str> {
        self.current_revision_id.as_deref()
    }
    /// <p>The Amazon S3 eTag identifier for the zip file bundle that you use to create the simulation application.</p>
    pub fn s3_etags(&self) -> std::option::Option<&[std::string::String]> {
        self.s3_etags.as_deref()
    }
    /// <p>The SHA256 digest used to identify the Docker image URI used to created the simulation application.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
}
impl std::fmt::Debug for CreateSimulationApplicationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSimulationApplicationVersionInput");
        formatter.field("application", &self.application);
        formatter.field("current_revision_id", &self.current_revision_id);
        formatter.field("s3_etags", &self.s3_etags);
        formatter.field("image_digest", &self.image_digest);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSimulationApplicationInput {
    /// <p>The name of the simulation application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The sources of the simulation application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
    /// <p>The simulation software suite used by the simulation application.</p>
    pub simulation_software_suite: std::option::Option<crate::model::SimulationSoftwareSuite>,
    /// <p>The robot software suite (ROS distribution) used by the simulation application.</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The rendering engine for the simulation application.</p>
    pub rendering_engine: std::option::Option<crate::model::RenderingEngine>,
    /// <p>A map that contains tag keys and tag values that are attached to the simulation application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The object that contains the Docker image URI used to create your simulation application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CreateSimulationApplicationInput {
    /// <p>The name of the simulation application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The sources of the simulation application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::SourceConfig]> {
        self.sources.as_deref()
    }
    /// <p>The simulation software suite used by the simulation application.</p>
    pub fn simulation_software_suite(
        &self,
    ) -> std::option::Option<&crate::model::SimulationSoftwareSuite> {
        self.simulation_software_suite.as_ref()
    }
    /// <p>The robot software suite (ROS distribution) used by the simulation application.</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The rendering engine for the simulation application.</p>
    pub fn rendering_engine(&self) -> std::option::Option<&crate::model::RenderingEngine> {
        self.rendering_engine.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the simulation application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The object that contains the Docker image URI used to create your simulation application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CreateSimulationApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSimulationApplicationInput");
        formatter.field("name", &self.name);
        formatter.field("sources", &self.sources);
        formatter.field("simulation_software_suite", &self.simulation_software_suite);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("rendering_engine", &self.rendering_engine);
        formatter.field("tags", &self.tags);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRobotApplicationVersionInput {
    /// <p>The application information for the robot application.</p>
    pub application: std::option::Option<std::string::String>,
    /// <p>The current revision id for the robot application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
    pub current_revision_id: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 identifier for the zip file bundle that you use for your robot application.</p>
    pub s3_etags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
    pub image_digest: std::option::Option<std::string::String>,
}
impl CreateRobotApplicationVersionInput {
    /// <p>The application information for the robot application.</p>
    pub fn application(&self) -> std::option::Option<&str> {
        self.application.as_deref()
    }
    /// <p>The current revision id for the robot application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
    pub fn current_revision_id(&self) -> std::option::Option<&str> {
        self.current_revision_id.as_deref()
    }
    /// <p>The Amazon S3 identifier for the zip file bundle that you use for your robot application.</p>
    pub fn s3_etags(&self) -> std::option::Option<&[std::string::String]> {
        self.s3_etags.as_deref()
    }
    /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
}
impl std::fmt::Debug for CreateRobotApplicationVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRobotApplicationVersionInput");
        formatter.field("application", &self.application);
        formatter.field("current_revision_id", &self.current_revision_id);
        formatter.field("s3_etags", &self.s3_etags);
        formatter.field("image_digest", &self.image_digest);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRobotApplicationInput {
    /// <p>The name of the robot application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The sources of the robot application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
    /// <p>The robot software suite (ROS distribuition) used by the robot application.</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>A map that contains tag keys and tag values that are attached to the robot application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The object that contains that URI of the Docker image that you use for your robot application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CreateRobotApplicationInput {
    /// <p>The name of the robot application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The sources of the robot application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::SourceConfig]> {
        self.sources.as_deref()
    }
    /// <p>The robot software suite (ROS distribuition) used by the robot application.</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the robot application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The object that contains that URI of the Docker image that you use for your robot application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CreateRobotApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRobotApplicationInput");
        formatter.field("name", &self.name);
        formatter.field("sources", &self.sources);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("tags", &self.tags);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRobotInput {
    /// <p>The name for the robot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The target architecture of the robot.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
    /// <p>The Greengrass group id.</p>
    pub greengrass_group_id: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to the robot.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRobotInput {
    /// <p>The name for the robot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The target architecture of the robot.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
    /// <p>The Greengrass group id.</p>
    pub fn greengrass_group_id(&self) -> std::option::Option<&str> {
        self.greengrass_group_id.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the robot.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRobotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRobotInput");
        formatter.field("name", &self.name);
        formatter.field("architecture", &self.architecture);
        formatter.field("greengrass_group_id", &self.greengrass_group_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFleetInput {
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to the fleet.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateFleetInput {
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the fleet.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFleetInput");
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentJobInput {
    /// <p>The requested deployment configuration.</p>
    pub deployment_config: std::option::Option<crate::model::DeploymentConfig>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet to deploy.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The deployment application configuration.</p>
    pub deployment_application_configs:
        std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
    /// <p>A map that contains tag keys and tag values that are attached to the deployment job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDeploymentJobInput {
    /// <p>The requested deployment configuration.</p>
    pub fn deployment_config(&self) -> std::option::Option<&crate::model::DeploymentConfig> {
        self.deployment_config.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet to deploy.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The deployment application configuration.</p>
    pub fn deployment_application_configs(
        &self,
    ) -> std::option::Option<&[crate::model::DeploymentApplicationConfig]> {
        self.deployment_application_configs.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the deployment job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDeploymentJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentJobInput");
        formatter.field("deployment_config", &self.deployment_config);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("fleet", &self.fleet);
        formatter.field(
            "deployment_application_configs",
            &self.deployment_application_configs,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelWorldGenerationJobInput {
    /// <p>The Amazon Resource Name (arn) of the world generator job to cancel.</p>
    pub job: std::option::Option<std::string::String>,
}
impl CancelWorldGenerationJobInput {
    /// <p>The Amazon Resource Name (arn) of the world generator job to cancel.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for CancelWorldGenerationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelWorldGenerationJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelWorldExportJobInput {
    /// <p>The Amazon Resource Name (arn) of the world export job to cancel.</p>
    pub job: std::option::Option<std::string::String>,
}
impl CancelWorldExportJobInput {
    /// <p>The Amazon Resource Name (arn) of the world export job to cancel.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for CancelWorldExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelWorldExportJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSimulationJobBatchInput {
    /// <p>The id of the batch to cancel.</p>
    pub batch: std::option::Option<std::string::String>,
}
impl CancelSimulationJobBatchInput {
    /// <p>The id of the batch to cancel.</p>
    pub fn batch(&self) -> std::option::Option<&str> {
        self.batch.as_deref()
    }
}
impl std::fmt::Debug for CancelSimulationJobBatchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSimulationJobBatchInput");
        formatter.field("batch", &self.batch);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSimulationJobInput {
    /// <p>The simulation job ARN to cancel.</p>
    pub job: std::option::Option<std::string::String>,
}
impl CancelSimulationJobInput {
    /// <p>The simulation job ARN to cancel.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for CancelSimulationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSimulationJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDeploymentJobInput {
    /// <p>The deployment job ARN to cancel.</p>
    pub job: std::option::Option<std::string::String>,
}
impl CancelDeploymentJobInput {
    /// <p>The deployment job ARN to cancel.</p>
    pub fn job(&self) -> std::option::Option<&str> {
        self.job.as_deref()
    }
}
impl std::fmt::Debug for CancelDeploymentJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDeploymentJobInput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDescribeSimulationJobInput {
    /// <p>A list of Amazon Resource Names (ARNs) of simulation jobs to describe.</p>
    pub jobs: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDescribeSimulationJobInput {
    /// <p>A list of Amazon Resource Names (ARNs) of simulation jobs to describe.</p>
    pub fn jobs(&self) -> std::option::Option<&[std::string::String]> {
        self.jobs.as_deref()
    }
}
impl std::fmt::Debug for BatchDescribeSimulationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDescribeSimulationJobInput");
        formatter.field("jobs", &self.jobs);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteWorldsInput {
    /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to delete.</p>
    pub worlds: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDeleteWorldsInput {
    /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to delete.</p>
    pub fn worlds(&self) -> std::option::Option<&[std::string::String]> {
        self.worlds.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteWorldsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteWorldsInput");
        formatter.field("worlds", &self.worlds);
        formatter.finish()
    }
}
