// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS RoboMaker
///
/// Client for invoking operations on AWS RoboMaker. Each operation on AWS RoboMaker is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_robomaker::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_robomaker::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_robomaker::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchDeleteWorlds` operation.
    ///
    /// See [`BatchDeleteWorlds`](crate::client::fluent_builders::BatchDeleteWorlds) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_worlds(&self) -> fluent_builders::BatchDeleteWorlds<C, M, R> {
        fluent_builders::BatchDeleteWorlds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDescribeSimulationJob` operation.
    ///
    /// See [`BatchDescribeSimulationJob`](crate::client::fluent_builders::BatchDescribeSimulationJob) for more information about the
    /// operation and its arguments.
    pub fn batch_describe_simulation_job(
        &self,
    ) -> fluent_builders::BatchDescribeSimulationJob<C, M, R> {
        fluent_builders::BatchDescribeSimulationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelDeploymentJob` operation.
    ///
    /// See [`CancelDeploymentJob`](crate::client::fluent_builders::CancelDeploymentJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_deployment_job(&self) -> fluent_builders::CancelDeploymentJob<C, M, R> {
        fluent_builders::CancelDeploymentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelSimulationJob` operation.
    ///
    /// See [`CancelSimulationJob`](crate::client::fluent_builders::CancelSimulationJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_simulation_job(&self) -> fluent_builders::CancelSimulationJob<C, M, R> {
        fluent_builders::CancelSimulationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelSimulationJobBatch` operation.
    ///
    /// See [`CancelSimulationJobBatch`](crate::client::fluent_builders::CancelSimulationJobBatch) for more information about the
    /// operation and its arguments.
    pub fn cancel_simulation_job_batch(
        &self,
    ) -> fluent_builders::CancelSimulationJobBatch<C, M, R> {
        fluent_builders::CancelSimulationJobBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelWorldExportJob` operation.
    ///
    /// See [`CancelWorldExportJob`](crate::client::fluent_builders::CancelWorldExportJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_world_export_job(&self) -> fluent_builders::CancelWorldExportJob<C, M, R> {
        fluent_builders::CancelWorldExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelWorldGenerationJob` operation.
    ///
    /// See [`CancelWorldGenerationJob`](crate::client::fluent_builders::CancelWorldGenerationJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_world_generation_job(
        &self,
    ) -> fluent_builders::CancelWorldGenerationJob<C, M, R> {
        fluent_builders::CancelWorldGenerationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeploymentJob` operation.
    ///
    /// See [`CreateDeploymentJob`](crate::client::fluent_builders::CreateDeploymentJob) for more information about the
    /// operation and its arguments.
    pub fn create_deployment_job(&self) -> fluent_builders::CreateDeploymentJob<C, M, R> {
        fluent_builders::CreateDeploymentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFleet` operation.
    ///
    /// See [`CreateFleet`](crate::client::fluent_builders::CreateFleet) for more information about the
    /// operation and its arguments.
    pub fn create_fleet(&self) -> fluent_builders::CreateFleet<C, M, R> {
        fluent_builders::CreateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRobot` operation.
    ///
    /// See [`CreateRobot`](crate::client::fluent_builders::CreateRobot) for more information about the
    /// operation and its arguments.
    pub fn create_robot(&self) -> fluent_builders::CreateRobot<C, M, R> {
        fluent_builders::CreateRobot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRobotApplication` operation.
    ///
    /// See [`CreateRobotApplication`](crate::client::fluent_builders::CreateRobotApplication) for more information about the
    /// operation and its arguments.
    pub fn create_robot_application(&self) -> fluent_builders::CreateRobotApplication<C, M, R> {
        fluent_builders::CreateRobotApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRobotApplicationVersion` operation.
    ///
    /// See [`CreateRobotApplicationVersion`](crate::client::fluent_builders::CreateRobotApplicationVersion) for more information about the
    /// operation and its arguments.
    pub fn create_robot_application_version(
        &self,
    ) -> fluent_builders::CreateRobotApplicationVersion<C, M, R> {
        fluent_builders::CreateRobotApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSimulationApplication` operation.
    ///
    /// See [`CreateSimulationApplication`](crate::client::fluent_builders::CreateSimulationApplication) for more information about the
    /// operation and its arguments.
    pub fn create_simulation_application(
        &self,
    ) -> fluent_builders::CreateSimulationApplication<C, M, R> {
        fluent_builders::CreateSimulationApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSimulationApplicationVersion` operation.
    ///
    /// See [`CreateSimulationApplicationVersion`](crate::client::fluent_builders::CreateSimulationApplicationVersion) for more information about the
    /// operation and its arguments.
    pub fn create_simulation_application_version(
        &self,
    ) -> fluent_builders::CreateSimulationApplicationVersion<C, M, R> {
        fluent_builders::CreateSimulationApplicationVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSimulationJob` operation.
    ///
    /// See [`CreateSimulationJob`](crate::client::fluent_builders::CreateSimulationJob) for more information about the
    /// operation and its arguments.
    pub fn create_simulation_job(&self) -> fluent_builders::CreateSimulationJob<C, M, R> {
        fluent_builders::CreateSimulationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorldExportJob` operation.
    ///
    /// See [`CreateWorldExportJob`](crate::client::fluent_builders::CreateWorldExportJob) for more information about the
    /// operation and its arguments.
    pub fn create_world_export_job(&self) -> fluent_builders::CreateWorldExportJob<C, M, R> {
        fluent_builders::CreateWorldExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorldGenerationJob` operation.
    ///
    /// See [`CreateWorldGenerationJob`](crate::client::fluent_builders::CreateWorldGenerationJob) for more information about the
    /// operation and its arguments.
    pub fn create_world_generation_job(
        &self,
    ) -> fluent_builders::CreateWorldGenerationJob<C, M, R> {
        fluent_builders::CreateWorldGenerationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorldTemplate` operation.
    ///
    /// See [`CreateWorldTemplate`](crate::client::fluent_builders::CreateWorldTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_world_template(&self) -> fluent_builders::CreateWorldTemplate<C, M, R> {
        fluent_builders::CreateWorldTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFleet` operation.
    ///
    /// See [`DeleteFleet`](crate::client::fluent_builders::DeleteFleet) for more information about the
    /// operation and its arguments.
    pub fn delete_fleet(&self) -> fluent_builders::DeleteFleet<C, M, R> {
        fluent_builders::DeleteFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRobot` operation.
    ///
    /// See [`DeleteRobot`](crate::client::fluent_builders::DeleteRobot) for more information about the
    /// operation and its arguments.
    pub fn delete_robot(&self) -> fluent_builders::DeleteRobot<C, M, R> {
        fluent_builders::DeleteRobot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRobotApplication` operation.
    ///
    /// See [`DeleteRobotApplication`](crate::client::fluent_builders::DeleteRobotApplication) for more information about the
    /// operation and its arguments.
    pub fn delete_robot_application(&self) -> fluent_builders::DeleteRobotApplication<C, M, R> {
        fluent_builders::DeleteRobotApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSimulationApplication` operation.
    ///
    /// See [`DeleteSimulationApplication`](crate::client::fluent_builders::DeleteSimulationApplication) for more information about the
    /// operation and its arguments.
    pub fn delete_simulation_application(
        &self,
    ) -> fluent_builders::DeleteSimulationApplication<C, M, R> {
        fluent_builders::DeleteSimulationApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorldTemplate` operation.
    ///
    /// See [`DeleteWorldTemplate`](crate::client::fluent_builders::DeleteWorldTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_world_template(&self) -> fluent_builders::DeleteWorldTemplate<C, M, R> {
        fluent_builders::DeleteWorldTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterRobot` operation.
    ///
    /// See [`DeregisterRobot`](crate::client::fluent_builders::DeregisterRobot) for more information about the
    /// operation and its arguments.
    pub fn deregister_robot(&self) -> fluent_builders::DeregisterRobot<C, M, R> {
        fluent_builders::DeregisterRobot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDeploymentJob` operation.
    ///
    /// See [`DescribeDeploymentJob`](crate::client::fluent_builders::DescribeDeploymentJob) for more information about the
    /// operation and its arguments.
    pub fn describe_deployment_job(&self) -> fluent_builders::DescribeDeploymentJob<C, M, R> {
        fluent_builders::DescribeDeploymentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFleet` operation.
    ///
    /// See [`DescribeFleet`](crate::client::fluent_builders::DescribeFleet) for more information about the
    /// operation and its arguments.
    pub fn describe_fleet(&self) -> fluent_builders::DescribeFleet<C, M, R> {
        fluent_builders::DescribeFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRobot` operation.
    ///
    /// See [`DescribeRobot`](crate::client::fluent_builders::DescribeRobot) for more information about the
    /// operation and its arguments.
    pub fn describe_robot(&self) -> fluent_builders::DescribeRobot<C, M, R> {
        fluent_builders::DescribeRobot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRobotApplication` operation.
    ///
    /// See [`DescribeRobotApplication`](crate::client::fluent_builders::DescribeRobotApplication) for more information about the
    /// operation and its arguments.
    pub fn describe_robot_application(&self) -> fluent_builders::DescribeRobotApplication<C, M, R> {
        fluent_builders::DescribeRobotApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSimulationApplication` operation.
    ///
    /// See [`DescribeSimulationApplication`](crate::client::fluent_builders::DescribeSimulationApplication) for more information about the
    /// operation and its arguments.
    pub fn describe_simulation_application(
        &self,
    ) -> fluent_builders::DescribeSimulationApplication<C, M, R> {
        fluent_builders::DescribeSimulationApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSimulationJob` operation.
    ///
    /// See [`DescribeSimulationJob`](crate::client::fluent_builders::DescribeSimulationJob) for more information about the
    /// operation and its arguments.
    pub fn describe_simulation_job(&self) -> fluent_builders::DescribeSimulationJob<C, M, R> {
        fluent_builders::DescribeSimulationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSimulationJobBatch` operation.
    ///
    /// See [`DescribeSimulationJobBatch`](crate::client::fluent_builders::DescribeSimulationJobBatch) for more information about the
    /// operation and its arguments.
    pub fn describe_simulation_job_batch(
        &self,
    ) -> fluent_builders::DescribeSimulationJobBatch<C, M, R> {
        fluent_builders::DescribeSimulationJobBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorld` operation.
    ///
    /// See [`DescribeWorld`](crate::client::fluent_builders::DescribeWorld) for more information about the
    /// operation and its arguments.
    pub fn describe_world(&self) -> fluent_builders::DescribeWorld<C, M, R> {
        fluent_builders::DescribeWorld::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorldExportJob` operation.
    ///
    /// See [`DescribeWorldExportJob`](crate::client::fluent_builders::DescribeWorldExportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_world_export_job(&self) -> fluent_builders::DescribeWorldExportJob<C, M, R> {
        fluent_builders::DescribeWorldExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorldGenerationJob` operation.
    ///
    /// See [`DescribeWorldGenerationJob`](crate::client::fluent_builders::DescribeWorldGenerationJob) for more information about the
    /// operation and its arguments.
    pub fn describe_world_generation_job(
        &self,
    ) -> fluent_builders::DescribeWorldGenerationJob<C, M, R> {
        fluent_builders::DescribeWorldGenerationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorldTemplate` operation.
    ///
    /// See [`DescribeWorldTemplate`](crate::client::fluent_builders::DescribeWorldTemplate) for more information about the
    /// operation and its arguments.
    pub fn describe_world_template(&self) -> fluent_builders::DescribeWorldTemplate<C, M, R> {
        fluent_builders::DescribeWorldTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorldTemplateBody` operation.
    ///
    /// See [`GetWorldTemplateBody`](crate::client::fluent_builders::GetWorldTemplateBody) for more information about the
    /// operation and its arguments.
    pub fn get_world_template_body(&self) -> fluent_builders::GetWorldTemplateBody<C, M, R> {
        fluent_builders::GetWorldTemplateBody::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeploymentJobs` operation.
    ///
    /// See [`ListDeploymentJobs`](crate::client::fluent_builders::ListDeploymentJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDeploymentJobs::into_paginator).
    pub fn list_deployment_jobs(&self) -> fluent_builders::ListDeploymentJobs<C, M, R> {
        fluent_builders::ListDeploymentJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFleets` operation.
    ///
    /// See [`ListFleets`](crate::client::fluent_builders::ListFleets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFleets::into_paginator).
    pub fn list_fleets(&self) -> fluent_builders::ListFleets<C, M, R> {
        fluent_builders::ListFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRobotApplications` operation.
    ///
    /// See [`ListRobotApplications`](crate::client::fluent_builders::ListRobotApplications) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListRobotApplications::into_paginator).
    pub fn list_robot_applications(&self) -> fluent_builders::ListRobotApplications<C, M, R> {
        fluent_builders::ListRobotApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRobots` operation.
    ///
    /// See [`ListRobots`](crate::client::fluent_builders::ListRobots) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListRobots::into_paginator).
    pub fn list_robots(&self) -> fluent_builders::ListRobots<C, M, R> {
        fluent_builders::ListRobots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSimulationApplications` operation.
    ///
    /// See [`ListSimulationApplications`](crate::client::fluent_builders::ListSimulationApplications) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSimulationApplications::into_paginator).
    pub fn list_simulation_applications(
        &self,
    ) -> fluent_builders::ListSimulationApplications<C, M, R> {
        fluent_builders::ListSimulationApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSimulationJobBatches` operation.
    ///
    /// See [`ListSimulationJobBatches`](crate::client::fluent_builders::ListSimulationJobBatches) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSimulationJobBatches::into_paginator).
    pub fn list_simulation_job_batches(
        &self,
    ) -> fluent_builders::ListSimulationJobBatches<C, M, R> {
        fluent_builders::ListSimulationJobBatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSimulationJobs` operation.
    ///
    /// See [`ListSimulationJobs`](crate::client::fluent_builders::ListSimulationJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSimulationJobs::into_paginator).
    pub fn list_simulation_jobs(&self) -> fluent_builders::ListSimulationJobs<C, M, R> {
        fluent_builders::ListSimulationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorldExportJobs` operation.
    ///
    /// See [`ListWorldExportJobs`](crate::client::fluent_builders::ListWorldExportJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorldExportJobs::into_paginator).
    pub fn list_world_export_jobs(&self) -> fluent_builders::ListWorldExportJobs<C, M, R> {
        fluent_builders::ListWorldExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorldGenerationJobs` operation.
    ///
    /// See [`ListWorldGenerationJobs`](crate::client::fluent_builders::ListWorldGenerationJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorldGenerationJobs::into_paginator).
    pub fn list_world_generation_jobs(&self) -> fluent_builders::ListWorldGenerationJobs<C, M, R> {
        fluent_builders::ListWorldGenerationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorlds` operation.
    ///
    /// See [`ListWorlds`](crate::client::fluent_builders::ListWorlds) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorlds::into_paginator).
    pub fn list_worlds(&self) -> fluent_builders::ListWorlds<C, M, R> {
        fluent_builders::ListWorlds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorldTemplates` operation.
    ///
    /// See [`ListWorldTemplates`](crate::client::fluent_builders::ListWorldTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorldTemplates::into_paginator).
    pub fn list_world_templates(&self) -> fluent_builders::ListWorldTemplates<C, M, R> {
        fluent_builders::ListWorldTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterRobot` operation.
    ///
    /// See [`RegisterRobot`](crate::client::fluent_builders::RegisterRobot) for more information about the
    /// operation and its arguments.
    pub fn register_robot(&self) -> fluent_builders::RegisterRobot<C, M, R> {
        fluent_builders::RegisterRobot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestartSimulationJob` operation.
    ///
    /// See [`RestartSimulationJob`](crate::client::fluent_builders::RestartSimulationJob) for more information about the
    /// operation and its arguments.
    pub fn restart_simulation_job(&self) -> fluent_builders::RestartSimulationJob<C, M, R> {
        fluent_builders::RestartSimulationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSimulationJobBatch` operation.
    ///
    /// See [`StartSimulationJobBatch`](crate::client::fluent_builders::StartSimulationJobBatch) for more information about the
    /// operation and its arguments.
    pub fn start_simulation_job_batch(&self) -> fluent_builders::StartSimulationJobBatch<C, M, R> {
        fluent_builders::StartSimulationJobBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SyncDeploymentJob` operation.
    ///
    /// See [`SyncDeploymentJob`](crate::client::fluent_builders::SyncDeploymentJob) for more information about the
    /// operation and its arguments.
    pub fn sync_deployment_job(&self) -> fluent_builders::SyncDeploymentJob<C, M, R> {
        fluent_builders::SyncDeploymentJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRobotApplication` operation.
    ///
    /// See [`UpdateRobotApplication`](crate::client::fluent_builders::UpdateRobotApplication) for more information about the
    /// operation and its arguments.
    pub fn update_robot_application(&self) -> fluent_builders::UpdateRobotApplication<C, M, R> {
        fluent_builders::UpdateRobotApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSimulationApplication` operation.
    ///
    /// See [`UpdateSimulationApplication`](crate::client::fluent_builders::UpdateSimulationApplication) for more information about the
    /// operation and its arguments.
    pub fn update_simulation_application(
        &self,
    ) -> fluent_builders::UpdateSimulationApplication<C, M, R> {
        fluent_builders::UpdateSimulationApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorldTemplate` operation.
    ///
    /// See [`UpdateWorldTemplate`](crate::client::fluent_builders::UpdateWorldTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_world_template(&self) -> fluent_builders::UpdateWorldTemplate<C, M, R> {
        fluent_builders::UpdateWorldTemplate::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDeleteWorlds`.
    ///
    /// <p>Deletes one or more worlds in a batch operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteWorlds<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_worlds_input::Builder,
    }
    impl<C, M, R> BatchDeleteWorlds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteWorlds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteWorldsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteWorldsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteWorldsInputOperationOutputAlias,
                crate::output::BatchDeleteWorldsOutput,
                crate::error::BatchDeleteWorldsError,
                crate::input::BatchDeleteWorldsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `worlds`.
        ///
        /// To override the contents of this collection use [`set_worlds`](Self::set_worlds).
        ///
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to delete.</p>
        pub fn worlds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worlds(input.into());
            self
        }
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to delete.</p>
        pub fn set_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_worlds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDescribeSimulationJob`.
    ///
    /// <p>Describes one or more simulation jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDescribeSimulationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_describe_simulation_job_input::Builder,
    }
    impl<C, M, R> BatchDescribeSimulationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDescribeSimulationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDescribeSimulationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDescribeSimulationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDescribeSimulationJobInputOperationOutputAlias,
                crate::output::BatchDescribeSimulationJobOutput,
                crate::error::BatchDescribeSimulationJobError,
                crate::input::BatchDescribeSimulationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of Amazon Resource Names (ARNs) of simulation jobs to describe.</p>
        pub fn jobs(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.jobs(input.into());
            self
        }
        /// <p>A list of Amazon Resource Names (ARNs) of simulation jobs to describe.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_jobs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelDeploymentJob`.
    ///
    /// <p>Cancels the specified deployment job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelDeploymentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_deployment_job_input::Builder,
    }
    impl<C, M, R> CancelDeploymentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelDeploymentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelDeploymentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelDeploymentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelDeploymentJobInputOperationOutputAlias,
                crate::output::CancelDeploymentJobOutput,
                crate::error::CancelDeploymentJobError,
                crate::input::CancelDeploymentJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The deployment job ARN to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The deployment job ARN to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSimulationJob`.
    ///
    /// <p>Cancels the specified simulation job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelSimulationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_simulation_job_input::Builder,
    }
    impl<C, M, R> CancelSimulationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelSimulationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSimulationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSimulationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelSimulationJobInputOperationOutputAlias,
                crate::output::CancelSimulationJobOutput,
                crate::error::CancelSimulationJobError,
                crate::input::CancelSimulationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The simulation job ARN to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The simulation job ARN to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelSimulationJobBatch`.
    ///
    /// <p>Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelSimulationJobBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_simulation_job_batch_input::Builder,
    }
    impl<C, M, R> CancelSimulationJobBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelSimulationJobBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelSimulationJobBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelSimulationJobBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelSimulationJobBatchInputOperationOutputAlias,
                crate::output::CancelSimulationJobBatchOutput,
                crate::error::CancelSimulationJobBatchError,
                crate::input::CancelSimulationJobBatchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the batch to cancel.</p>
        pub fn batch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch(input.into());
            self
        }
        /// <p>The id of the batch to cancel.</p>
        pub fn set_batch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_batch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelWorldExportJob`.
    ///
    /// <p>Cancels the specified export job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelWorldExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_world_export_job_input::Builder,
    }
    impl<C, M, R> CancelWorldExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelWorldExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelWorldExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelWorldExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelWorldExportJobInputOperationOutputAlias,
                crate::output::CancelWorldExportJobOutput,
                crate::error::CancelWorldExportJobError,
                crate::input::CancelWorldExportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world export job to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world export job to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelWorldGenerationJob`.
    ///
    /// <p>Cancels the specified world generator job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelWorldGenerationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_world_generation_job_input::Builder,
    }
    impl<C, M, R> CancelWorldGenerationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelWorldGenerationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelWorldGenerationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelWorldGenerationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelWorldGenerationJobInputOperationOutputAlias,
                crate::output::CancelWorldGenerationJobOutput,
                crate::error::CancelWorldGenerationJobError,
                crate::input::CancelWorldGenerationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world generator job to cancel.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generator job to cancel.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeploymentJob`.
    ///
    /// <p>Deploys a specific version of a robot application to robots in a fleet.</p>
    /// <p>The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a new version, use <code>CreateRobotApplicationVersion</code> or see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot Application Version</a>. </p> <note>
    /// <p>After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeploymentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_deployment_job_input::Builder,
    }
    impl<C, M, R> CreateDeploymentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeploymentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeploymentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeploymentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeploymentJobInputOperationOutputAlias,
                crate::output::CreateDeploymentJobOutput,
                crate::error::CreateDeploymentJobError,
                crate::input::CreateDeploymentJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The requested deployment configuration.</p>
        pub fn deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.inner = self.inner.deployment_config(input);
            self
        }
        /// <p>The requested deployment configuration.</p>
        pub fn set_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet to deploy.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet to deploy.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet(input);
            self
        }
        /// Appends an item to `deploymentApplicationConfigs`.
        ///
        /// To override the contents of this collection use [`set_deployment_application_configs`](Self::set_deployment_application_configs).
        ///
        /// <p>The deployment application configuration.</p>
        pub fn deployment_application_configs(
            mut self,
            input: crate::model::DeploymentApplicationConfig,
        ) -> Self {
            self.inner = self.inner.deployment_application_configs(input);
            self
        }
        /// <p>The deployment application configuration.</p>
        pub fn set_deployment_application_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_deployment_application_configs(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleet`.
    ///
    /// <p>Creates a fleet, a logical group of robots running the same robot application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fleet_input::Builder,
    }
    impl<C, M, R> CreateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFleetInputOperationOutputAlias,
                crate::output::CreateFleetOutput,
                crate::error::CreateFleetError,
                crate::input::CreateFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the fleet.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the fleet.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRobot`.
    ///
    /// <p>Creates a robot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRobot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_robot_input::Builder,
    }
    impl<C, M, R> CreateRobot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRobot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRobotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRobotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRobotInputOperationOutputAlias,
                crate::output::CreateRobotOutput,
                crate::error::CreateRobotError,
                crate::input::CreateRobotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the robot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the robot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The target architecture of the robot.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.inner = self.inner.architecture(input);
            self
        }
        /// <p>The target architecture of the robot.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.inner = self.inner.set_architecture(input);
            self
        }
        /// <p>The Greengrass group id.</p>
        pub fn greengrass_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.greengrass_group_id(input.into());
            self
        }
        /// <p>The Greengrass group id.</p>
        pub fn set_greengrass_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_greengrass_group_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the robot.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the robot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRobotApplication`.
    ///
    /// <p>Creates a robot application. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRobotApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_robot_application_input::Builder,
    }
    impl<C, M, R> CreateRobotApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRobotApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRobotApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRobotApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRobotApplicationInputOperationOutputAlias,
                crate::output::CreateRobotApplicationOutput,
                crate::error::CreateRobotApplicationError,
                crate::input::CreateRobotApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the robot application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            self.inner = self.inner.sources(input);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// <p>The robot software suite (ROS distribuition) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.inner = self.inner.robot_software_suite(input);
            self
        }
        /// <p>The robot software suite (ROS distribuition) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.inner = self.inner.set_robot_software_suite(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the robot application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the robot application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The object that contains that URI of the Docker image that you use for your robot application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The object that contains that URI of the Docker image that you use for your robot application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRobotApplicationVersion`.
    ///
    /// <p>Creates a version of a robot application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRobotApplicationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_robot_application_version_input::Builder,
    }
    impl<C, M, R> CreateRobotApplicationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRobotApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRobotApplicationVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRobotApplicationVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRobotApplicationVersionInputOperationOutputAlias,
                crate::output::CreateRobotApplicationVersionOutput,
                crate::error::CreateRobotApplicationVersionError,
                crate::input::CreateRobotApplicationVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application information for the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The application information for the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The current revision id for the robot application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_revision_id(input.into());
            self
        }
        /// <p>The current revision id for the robot application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_revision_id(input);
            self
        }
        /// Appends an item to `s3Etags`.
        ///
        /// To override the contents of this collection use [`set_s3_etags`](Self::set_s3_etags).
        ///
        /// <p>The Amazon S3 identifier for the zip file bundle that you use for your robot application.</p>
        pub fn s3_etags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_etags(input.into());
            self
        }
        /// <p>The Amazon S3 identifier for the zip file bundle that you use for your robot application.</p>
        pub fn set_s3_etags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_s3_etags(input);
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_digest(input.into());
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSimulationApplication`.
    ///
    /// <p>Creates a simulation application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSimulationApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_simulation_application_input::Builder,
    }
    impl<C, M, R> CreateSimulationApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSimulationApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSimulationApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSimulationApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSimulationApplicationInputOperationOutputAlias,
                crate::output::CreateSimulationApplicationOutput,
                crate::error::CreateSimulationApplicationError,
                crate::input::CreateSimulationApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the simulation application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            self.inner = self.inner.sources(input);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.inner = self.inner.simulation_software_suite(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.inner = self.inner.set_simulation_software_suite(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the simulation application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.inner = self.inner.robot_software_suite(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the simulation application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.inner = self.inner.set_robot_software_suite(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.inner = self.inner.rendering_engine(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.inner = self.inner.set_rendering_engine(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the simulation application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the simulation application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The object that contains the Docker image URI used to create your simulation application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The object that contains the Docker image URI used to create your simulation application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSimulationApplicationVersion`.
    ///
    /// <p>Creates a simulation application with a specific revision id.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSimulationApplicationVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_simulation_application_version_input::Builder,
    }
    impl<C, M, R> CreateSimulationApplicationVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSimulationApplicationVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSimulationApplicationVersionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateSimulationApplicationVersionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSimulationApplicationVersionInputOperationOutputAlias,
                crate::output::CreateSimulationApplicationVersionOutput,
                crate::error::CreateSimulationApplicationVersionError,
                crate::input::CreateSimulationApplicationVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application information for the simulation application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The application information for the simulation application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_revision_id(input.into());
            self
        }
        /// <p>The current revision id for the simulation application. If you provide a value and it matches the latest revision ID, a new version will be created.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_revision_id(input);
            self
        }
        /// Appends an item to `s3Etags`.
        ///
        /// To override the contents of this collection use [`set_s3_etags`](Self::set_s3_etags).
        ///
        /// <p>The Amazon S3 eTag identifier for the zip file bundle that you use to create the simulation application.</p>
        pub fn s3_etags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_etags(input.into());
            self
        }
        /// <p>The Amazon S3 eTag identifier for the zip file bundle that you use to create the simulation application.</p>
        pub fn set_s3_etags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_s3_etags(input);
            self
        }
        /// <p>The SHA256 digest used to identify the Docker image URI used to created the simulation application.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_digest(input.into());
            self
        }
        /// <p>The SHA256 digest used to identify the Docker image URI used to created the simulation application.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSimulationJob`.
    ///
    /// <p>Creates a simulation job.</p> <note>
    /// <p>After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSimulationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_simulation_job_input::Builder,
    }
    impl<C, M, R> CreateSimulationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSimulationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSimulationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSimulationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSimulationJobInputOperationOutputAlias,
                crate::output::CreateSimulationJobOutput,
                crate::error::CreateSimulationJobError,
                crate::input::CreateSimulationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.inner = self.inner.output_location(input);
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// <p>The logging configuration.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.inner = self.inner.logging_config(input);
            self
        }
        /// <p>The logging configuration.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.inner = self.inner.set_logging_config(input);
            self
        }
        /// <p>The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to <code>Completed</code>.</p>
        pub fn max_job_duration_in_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.max_job_duration_in_seconds(input);
            self
        }
        /// <p>The maximum simulation job duration in seconds (up to 14 days or 1,209,600 seconds. When <code>maxJobDurationInSeconds</code> is reached, the simulation job will status will transition to <code>Completed</code>.</p>
        pub fn set_max_job_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_max_job_duration_in_seconds(input);
            self
        }
        /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(input.into());
            self
        }
        /// <p>The IAM role name that allows the simulation instance to call the AWS APIs that are specified in its associated policies on your behalf. This is how credentials are passed in to your simulation job. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn failure_behavior(mut self, input: crate::model::FailureBehavior) -> Self {
            self.inner = self.inner.failure_behavior(input);
            self
        }
        /// <p>The failure behavior the simulation job.</p>
        /// <dl>
        /// <dt>
        /// Continue
        /// </dt>
        /// <dd>
        /// <p>Leaves the instance running for its maximum timeout duration after a <code>4XX</code> error code.</p>
        /// </dd>
        /// <dt>
        /// Fail
        /// </dt>
        /// <dd>
        /// <p>Stop the simulation job and terminate the instance.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_behavior(
            mut self,
            input: std::option::Option<crate::model::FailureBehavior>,
        ) -> Self {
            self.inner = self.inner.set_failure_behavior(input);
            self
        }
        /// Appends an item to `robotApplications`.
        ///
        /// To override the contents of this collection use [`set_robot_applications`](Self::set_robot_applications).
        ///
        /// <p>The robot application to use in the simulation job.</p>
        pub fn robot_applications(mut self, input: crate::model::RobotApplicationConfig) -> Self {
            self.inner = self.inner.robot_applications(input);
            self
        }
        /// <p>The robot application to use in the simulation job.</p>
        pub fn set_robot_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_robot_applications(input);
            self
        }
        /// Appends an item to `simulationApplications`.
        ///
        /// To override the contents of this collection use [`set_simulation_applications`](Self::set_simulation_applications).
        ///
        /// <p>The simulation application to use in the simulation job.</p>
        pub fn simulation_applications(
            mut self,
            input: crate::model::SimulationApplicationConfig,
        ) -> Self {
            self.inner = self.inner.simulation_applications(input);
            self
        }
        /// <p>The simulation application to use in the simulation job.</p>
        pub fn set_simulation_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_simulation_applications(input);
            self
        }
        /// Appends an item to `dataSources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
        /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
        /// </note>
        pub fn data_sources(mut self, input: crate::model::DataSourceConfig) -> Self {
            self.inner = self.inner.data_sources(input);
            self
        }
        /// <p>Specify data sources to mount read-only files from S3 into your simulation. These files are available under <code>/opt/robomaker/datasources/data_source_name</code>. </p> <note>
        /// <p>There is a limit of 100 files and a combined size of 25GB for all <code>DataSourceConfig</code> objects. </p>
        /// </note>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSourceConfig>>,
        ) -> Self {
            self.inner = self.inner.set_data_sources(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and one subnet ID. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn compute(mut self, input: crate::model::Compute) -> Self {
            self.inner = self.inner.compute(input);
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn set_compute(mut self, input: std::option::Option<crate::model::Compute>) -> Self {
            self.inner = self.inner.set_compute(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorldExportJob`.
    ///
    /// <p>Creates a world export job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorldExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_world_export_job_input::Builder,
    }
    impl<C, M, R> CreateWorldExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorldExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorldExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorldExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorldExportJobInputOperationOutputAlias,
                crate::output::CreateWorldExportJobOutput,
                crate::error::CreateWorldExportJobError,
                crate::input::CreateWorldExportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `worlds`.
        ///
        /// To override the contents of this collection use [`set_worlds`](Self::set_worlds).
        ///
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to export.</p>
        pub fn worlds(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.worlds(input.into());
            self
        }
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to export.</p>
        pub fn set_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_worlds(input);
            self
        }
        /// <p>The output location.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.inner = self.inner.output_location(input);
            self
        }
        /// <p>The output location.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.inner = self.inner.set_output_location(input);
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.</p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(input.into());
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world export job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world export job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorldGenerationJob`.
    ///
    /// <p>Creates worlds using the specified template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorldGenerationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_world_generation_job_input::Builder,
    }
    impl<C, M, R> CreateWorldGenerationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorldGenerationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorldGenerationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorldGenerationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorldGenerationJobInputOperationOutputAlias,
                crate::output::CreateWorldGenerationJobOutput,
                crate::error::CreateWorldGenerationJobError,
                crate::input::CreateWorldGenerationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template describing the worlds you want to create.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template describing the worlds you want to create.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
        /// <p>Information about the world count.</p>
        pub fn world_count(mut self, input: crate::model::WorldCount) -> Self {
            self.inner = self.inner.world_count(input);
            self
        }
        /// <p>Information about the world count.</p>
        pub fn set_world_count(
            mut self,
            input: std::option::Option<crate::model::WorldCount>,
        ) -> Self {
            self.inner = self.inner.set_world_count(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world generator job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world generator job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `worldTags`.
        ///
        /// To override the contents of this collection use [`set_world_tags`](Self::set_world_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the generated worlds.</p>
        pub fn world_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.world_tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the generated worlds.</p>
        pub fn set_world_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_world_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorldTemplate`.
    ///
    /// <p>Creates a world template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorldTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_world_template_input::Builder,
    }
    impl<C, M, R> CreateWorldTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorldTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorldTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorldTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorldTemplateInputOperationOutputAlias,
                crate::output::CreateWorldTemplateOutput,
                crate::error::CreateWorldTemplateError,
                crate::input::CreateWorldTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The name of the world template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the world template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The world template body.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The world template body.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>The location of the world template.</p>
        pub fn template_location(mut self, input: crate::model::TemplateLocation) -> Self {
            self.inner = self.inner.template_location(input);
            self
        }
        /// <p>The location of the world template.</p>
        pub fn set_template_location(
            mut self,
            input: std::option::Option<crate::model::TemplateLocation>,
        ) -> Self {
            self.inner = self.inner.set_template_location(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world template.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFleet`.
    ///
    /// <p>Deletes a fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fleet_input::Builder,
    }
    impl<C, M, R> DeleteFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFleetInputOperationOutputAlias,
                crate::output::DeleteFleetOutput,
                crate::error::DeleteFleetError,
                crate::input::DeleteFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRobot`.
    ///
    /// <p>Deletes a robot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRobot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_robot_input::Builder,
    }
    impl<C, M, R> DeleteRobot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRobot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRobotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRobotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRobotInputOperationOutputAlias,
                crate::output::DeleteRobotOutput,
                crate::error::DeleteRobotError,
                crate::input::DeleteRobotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.robot(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_robot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRobotApplication`.
    ///
    /// <p>Deletes a robot application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRobotApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_robot_application_input::Builder,
    }
    impl<C, M, R> DeleteRobotApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRobotApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRobotApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRobotApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRobotApplicationInputOperationOutputAlias,
                crate::output::DeleteRobotApplicationOutput,
                crate::error::DeleteRobotApplicationError,
                crate::input::DeleteRobotApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The version of the robot application to delete.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_version(input.into());
            self
        }
        /// <p>The version of the robot application to delete.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSimulationApplication`.
    ///
    /// <p>Deletes a simulation application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSimulationApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_simulation_application_input::Builder,
    }
    impl<C, M, R> DeleteSimulationApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSimulationApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSimulationApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSimulationApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSimulationApplicationInputOperationOutputAlias,
                crate::output::DeleteSimulationApplicationOutput,
                crate::error::DeleteSimulationApplicationError,
                crate::input::DeleteSimulationApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application information for the simulation application to delete.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The application information for the simulation application to delete.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The version of the simulation application to delete.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_version(input.into());
            self
        }
        /// <p>The version of the simulation application to delete.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorldTemplate`.
    ///
    /// <p>Deletes a world template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorldTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_world_template_input::Builder,
    }
    impl<C, M, R> DeleteWorldTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorldTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorldTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorldTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorldTemplateInputOperationOutputAlias,
                crate::output::DeleteWorldTemplateOutput,
                crate::error::DeleteWorldTemplateError,
                crate::input::DeleteWorldTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world template you want to delete.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template you want to delete.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterRobot`.
    ///
    /// <p>Deregisters a robot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterRobot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_robot_input::Builder,
    }
    impl<C, M, R> DeregisterRobot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterRobot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterRobotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterRobotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterRobotInputOperationOutputAlias,
                crate::output::DeregisterRobotOutput,
                crate::error::DeregisterRobotError,
                crate::input::DeregisterRobotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.robot(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_robot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDeploymentJob`.
    ///
    /// <p>Describes a deployment job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDeploymentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_deployment_job_input::Builder,
    }
    impl<C, M, R> DescribeDeploymentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDeploymentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeploymentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeploymentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeploymentJobInputOperationOutputAlias,
                crate::output::DescribeDeploymentJobOutput,
                crate::error::DescribeDeploymentJobError,
                crate::input::DescribeDeploymentJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFleet`.
    ///
    /// <p>Describes a fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fleet_input::Builder,
    }
    impl<C, M, R> DescribeFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFleetInputOperationOutputAlias,
                crate::output::DescribeFleetOutput,
                crate::error::DescribeFleetError,
                crate::input::DescribeFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRobot`.
    ///
    /// <p>Describes a robot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRobot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_robot_input::Builder,
    }
    impl<C, M, R> DescribeRobot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRobot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRobotOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRobotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRobotInputOperationOutputAlias,
                crate::output::DescribeRobotOutput,
                crate::error::DescribeRobotError,
                crate::input::DescribeRobotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the robot to be described.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.robot(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot to be described.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_robot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRobotApplication`.
    ///
    /// <p>Describes a robot application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRobotApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_robot_application_input::Builder,
    }
    impl<C, M, R> DescribeRobotApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRobotApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRobotApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRobotApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRobotApplicationInputOperationOutputAlias,
                crate::output::DescribeRobotApplicationOutput,
                crate::error::DescribeRobotApplicationError,
                crate::input::DescribeRobotApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The version of the robot application to describe.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_version(input.into());
            self
        }
        /// <p>The version of the robot application to describe.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSimulationApplication`.
    ///
    /// <p>Describes a simulation application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSimulationApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_simulation_application_input::Builder,
    }
    impl<C, M, R> DescribeSimulationApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSimulationApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSimulationApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSimulationApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSimulationApplicationInputOperationOutputAlias,
                crate::output::DescribeSimulationApplicationOutput,
                crate::error::DescribeSimulationApplicationError,
                crate::input::DescribeSimulationApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application information for the simulation application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The application information for the simulation application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// <p>The version of the simulation application to describe.</p>
        pub fn application_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_version(input.into());
            self
        }
        /// <p>The version of the simulation application to describe.</p>
        pub fn set_application_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSimulationJob`.
    ///
    /// <p>Describes a simulation job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSimulationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_simulation_job_input::Builder,
    }
    impl<C, M, R> DescribeSimulationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSimulationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSimulationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSimulationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSimulationJobInputOperationOutputAlias,
                crate::output::DescribeSimulationJobOutput,
                crate::error::DescribeSimulationJobError,
                crate::input::DescribeSimulationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job to be described.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job to be described.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSimulationJobBatch`.
    ///
    /// <p>Describes a simulation job batch.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSimulationJobBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_simulation_job_batch_input::Builder,
    }
    impl<C, M, R> DescribeSimulationJobBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSimulationJobBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSimulationJobBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSimulationJobBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSimulationJobBatchInputOperationOutputAlias,
                crate::output::DescribeSimulationJobBatchOutput,
                crate::error::DescribeSimulationJobBatchError,
                crate::input::DescribeSimulationJobBatchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The id of the batch to describe.</p>
        pub fn batch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch(input.into());
            self
        }
        /// <p>The id of the batch to describe.</p>
        pub fn set_batch(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_batch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorld`.
    ///
    /// <p>Describes a world.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorld<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_world_input::Builder,
    }
    impl<C, M, R> DescribeWorld<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorld`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorldOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorldError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorldInputOperationOutputAlias,
                crate::output::DescribeWorldOutput,
                crate::error::DescribeWorldError,
                crate::input::DescribeWorldInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world you want to describe.</p>
        pub fn world(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.world(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world you want to describe.</p>
        pub fn set_world(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_world(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorldExportJob`.
    ///
    /// <p>Describes a world export job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorldExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_world_export_job_input::Builder,
    }
    impl<C, M, R> DescribeWorldExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorldExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorldExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorldExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorldExportJobInputOperationOutputAlias,
                crate::output::DescribeWorldExportJobOutput,
                crate::error::DescribeWorldExportJobError,
                crate::input::DescribeWorldExportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world export job to describe.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world export job to describe.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorldGenerationJob`.
    ///
    /// <p>Describes a world generation job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorldGenerationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_world_generation_job_input::Builder,
    }
    impl<C, M, R> DescribeWorldGenerationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorldGenerationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorldGenerationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorldGenerationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorldGenerationJobInputOperationOutputAlias,
                crate::output::DescribeWorldGenerationJobOutput,
                crate::error::DescribeWorldGenerationJobError,
                crate::input::DescribeWorldGenerationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world generation job to describe.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generation job to describe.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorldTemplate`.
    ///
    /// <p>Describes a world template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorldTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_world_template_input::Builder,
    }
    impl<C, M, R> DescribeWorldTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorldTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorldTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorldTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorldTemplateInputOperationOutputAlias,
                crate::output::DescribeWorldTemplateOutput,
                crate::error::DescribeWorldTemplateError,
                crate::input::DescribeWorldTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world template you want to describe.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template you want to describe.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorldTemplateBody`.
    ///
    /// <p>Gets the world template body.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorldTemplateBody<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_world_template_body_input::Builder,
    }
    impl<C, M, R> GetWorldTemplateBody<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorldTemplateBody`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorldTemplateBodyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorldTemplateBodyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorldTemplateBodyInputOperationOutputAlias,
                crate::output::GetWorldTemplateBodyOutput,
                crate::error::GetWorldTemplateBodyError,
                crate::input::GetWorldTemplateBodyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generator job.</p>
        pub fn generation_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.generation_job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generator job.</p>
        pub fn set_generation_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_generation_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDeploymentJobs`.
    ///
    /// <p>Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDeploymentJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_deployment_jobs_input::Builder,
    }
    impl<C, M, R> ListDeploymentJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDeploymentJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDeploymentJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDeploymentJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDeploymentJobsInputOperationOutputAlias,
                crate::output::ListDeploymentJobsOutput,
                crate::error::ListDeploymentJobsError,
                crate::input::ListDeploymentJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDeploymentJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDeploymentJobsPaginator<C, M, R> {
            crate::paginator::ListDeploymentJobsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>InProgress</code> or the status <code>Pending</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>InProgress</code> or the status <code>Pending</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListDeploymentJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListDeploymentJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListDeploymentJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListDeploymentJobs</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListDeploymentJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListDeploymentJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListDeploymentJobs</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFleets`.
    ///
    /// <p>Returns a list of fleets. You can optionally provide filters to retrieve specific fleets. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFleets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fleets_input::Builder,
    }
    impl<C, M, R> ListFleets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFleetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFleetsInputOperationOutputAlias,
                crate::output::ListFleetsOutput,
                crate::error::ListFleetsError,
                crate::input::ListFleetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFleetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFleetsPaginator<C, M, R> {
            crate::paginator::ListFleetsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListFleets</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListFleets</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p> <note>
        /// <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListFleets</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFleets</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListFleets</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListFleets</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFleets</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListFleets</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRobotApplications`.
    ///
    /// <p>Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRobotApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_robot_applications_input::Builder,
    }
    impl<C, M, R> ListRobotApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRobotApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRobotApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRobotApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRobotApplicationsInputOperationOutputAlias,
                crate::output::ListRobotApplicationsOutput,
                crate::error::ListRobotApplicationsError,
                crate::input::ListRobotApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRobotApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRobotApplicationsPaginator<C, M, R> {
            crate::paginator::ListRobotApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The version qualifier of the robot application.</p>
        pub fn version_qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_qualifier(input.into());
            self
        }
        /// <p>The version qualifier of the robot application.</p>
        pub fn set_version_qualifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_qualifier(input);
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobotApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobotApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListRobotApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobotApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListRobotApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListRobotApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobotApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListRobotApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRobots`.
    ///
    /// <p>Returns a list of robots. You can optionally provide filters to retrieve specific robots.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRobots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_robots_input::Builder,
    }
    impl<C, M, R> ListRobots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRobots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRobotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRobotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRobotsInputOperationOutputAlias,
                crate::output::ListRobotsOutput,
                crate::error::ListRobotsError,
                crate::input::ListRobotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRobotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRobotsPaginator<C, M, R> {
            crate::paginator::ListRobotsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobots</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListRobots</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListRobots</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobots</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListRobots</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListRobots</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListRobots</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 200. If this parameter is not used, then <code>ListRobots</code> returns up to 200 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Registered</code> or the status <code>Available</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>fleetName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Registered</code> or the status <code>Available</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSimulationApplications`.
    ///
    /// <p>Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSimulationApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_simulation_applications_input::Builder,
    }
    impl<C, M, R> ListSimulationApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSimulationApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSimulationApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSimulationApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSimulationApplicationsInputOperationOutputAlias,
                crate::output::ListSimulationApplicationsOutput,
                crate::error::ListSimulationApplicationsError,
                crate::input::ListSimulationApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSimulationApplicationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListSimulationApplicationsPaginator<C, M, R> {
            crate::paginator::ListSimulationApplicationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The version qualifier of the simulation application.</p>
        pub fn version_qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_qualifier(input.into());
            self
        }
        /// <p>The version qualifier of the simulation application.</p>
        pub fn set_version_qualifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_qualifier(input);
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationApplications</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListSimulationApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationApplications</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationApplications</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListSimulationApplications</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional list of filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional list of filters to limit results.</p>
        /// <p>The filter name <code>name</code> is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSimulationJobBatches`.
    ///
    /// <p>Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSimulationJobBatches<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_simulation_job_batches_input::Builder,
    }
    impl<C, M, R> ListSimulationJobBatches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSimulationJobBatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSimulationJobBatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSimulationJobBatchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSimulationJobBatchesInputOperationOutputAlias,
                crate::output::ListSimulationJobBatchesOutput,
                crate::error::ListSimulationJobBatchesError,
                crate::input::ListSimulationJobBatchesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSimulationJobBatchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListSimulationJobBatchesPaginator<C, M, R> {
            crate::paginator::ListSimulationJobBatchesPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobBatches</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobBatches</code> request with the returned <code>nextToken</code> value. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSimulationJobs`.
    ///
    /// <p>Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSimulationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_simulation_jobs_input::Builder,
    }
    impl<C, M, R> ListSimulationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSimulationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSimulationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSimulationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSimulationJobsInputOperationOutputAlias,
                crate::output::ListSimulationJobsOutput,
                crate::error::ListSimulationJobsError,
                crate::input::ListSimulationJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSimulationJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSimulationJobsPaginator<C, M, R> {
            crate::paginator::ListSimulationJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListSimulationJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListSimulationJobs</code> returns up to 1000 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListSimulationJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListSimulationJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then <code>ListSimulationJobs</code> returns up to 1000 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>simulationApplicationName</code> and <code>robotApplicationName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Preparing</code> or the status <code>Running</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results.</p>
        /// <p>The filter names <code>status</code> and <code>simulationApplicationName</code> and <code>robotApplicationName</code> are supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters, but they must be for the same named item. For example, if you are looking for items with the status <code>Preparing</code> or the status <code>Running</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags on a AWS RoboMaker resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorldExportJobs`.
    ///
    /// <p>Lists world export jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorldExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_world_export_jobs_input::Builder,
    }
    impl<C, M, R> ListWorldExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorldExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorldExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorldExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorldExportJobsInputOperationOutputAlias,
                crate::output::ListWorldExportJobsOutput,
                crate::error::ListWorldExportJobsError,
                crate::input::ListWorldExportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorldExportJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorldExportJobsPaginator<C, M, R> {
            crate::paginator::ListWorldExportJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldExportJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldExportJobs</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldExportJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldExportJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldExportJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldExportJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldExportJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldExportJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results. You can use <code>generationJobId</code> and <code>templateId</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results. You can use <code>generationJobId</code> and <code>templateId</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorldGenerationJobs`.
    ///
    /// <p>Lists world generator jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorldGenerationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_world_generation_jobs_input::Builder,
    }
    impl<C, M, R> ListWorldGenerationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorldGenerationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorldGenerationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorldGenerationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorldGenerationJobsInputOperationOutputAlias,
                crate::output::ListWorldGenerationJobsOutput,
                crate::error::ListWorldGenerationJobsError,
                crate::input::ListWorldGenerationJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorldGenerationJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorldGenerationJobsPaginator<C, M, R> {
            crate::paginator::ListWorldGenerationJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldGenerationJobsRequest</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldGenerationJobsRequest</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldGeneratorJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldGeneratorJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldGeneratorJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldGeneratorJobs</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldGeneratorJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldGeneratorJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results. You can use <code>status</code> and <code>templateId</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results. You can use <code>status</code> and <code>templateId</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorlds`.
    ///
    /// <p>Lists worlds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorlds<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_worlds_input::Builder,
    }
    impl<C, M, R> ListWorlds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorlds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorldsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorldsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorldsInputOperationOutputAlias,
                crate::output::ListWorldsOutput,
                crate::error::ListWorldsError,
                crate::input::ListWorldsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorldsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorldsPaginator<C, M, R> {
            crate::paginator::ListWorldsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorlds</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorlds</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorlds</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorlds</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorlds</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorlds</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorlds</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorlds</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Optional filters to limit results. You can use <code>status</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional filters to limit results. You can use <code>status</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorldTemplates`.
    ///
    /// <p>Lists world templates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorldTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_world_templates_input::Builder,
    }
    impl<C, M, R> ListWorldTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorldTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorldTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorldTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorldTemplatesInputOperationOutputAlias,
                crate::output::ListWorldTemplatesOutput,
                crate::error::ListWorldTemplatesError,
                crate::input::ListWorldTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListWorldTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListWorldTemplatesPaginator<C, M, R> {
            crate::paginator::ListWorldTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the response object's <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call <code>ListWorldTemplates</code> again and assign that token to the request object's <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldTemplates</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldTemplates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldTemplates</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>When this parameter is used, <code>ListWorldTemplates</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListWorldTemplates</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then <code>ListWorldTemplates</code> returns up to 100 results and a <code>nextToken</code> value if applicable. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterRobot`.
    ///
    /// <p>Registers a robot with a fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterRobot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_robot_input::Builder,
    }
    impl<C, M, R> RegisterRobot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterRobot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterRobotOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterRobotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterRobotInputOperationOutputAlias,
                crate::output::RegisterRobotOutput,
                crate::error::RegisterRobotError,
                crate::input::RegisterRobotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.robot(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_robot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestartSimulationJob`.
    ///
    /// <p>Restarts a running simulation job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RestartSimulationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restart_simulation_job_input::Builder,
    }
    impl<C, M, R> RestartSimulationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestartSimulationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestartSimulationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::RestartSimulationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestartSimulationJobInputOperationOutputAlias,
                crate::output::RestartSimulationJobOutput,
                crate::error::RestartSimulationJobError,
                crate::input::RestartSimulationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn job(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn set_job(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSimulationJobBatch`.
    ///
    /// <p>Starts a new simulation job batch. The batch is defined using one or more <code>SimulationJobRequest</code> objects. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSimulationJobBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_simulation_job_batch_input::Builder,
    }
    impl<C, M, R> StartSimulationJobBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSimulationJobBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSimulationJobBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSimulationJobBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSimulationJobBatchInputOperationOutputAlias,
                crate::output::StartSimulationJobBatchOutput,
                crate::error::StartSimulationJobBatchError,
                crate::input::StartSimulationJobBatchInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The batch policy.</p>
        pub fn batch_policy(mut self, input: crate::model::BatchPolicy) -> Self {
            self.inner = self.inner.batch_policy(input);
            self
        }
        /// <p>The batch policy.</p>
        pub fn set_batch_policy(
            mut self,
            input: std::option::Option<crate::model::BatchPolicy>,
        ) -> Self {
            self.inner = self.inner.set_batch_policy(input);
            self
        }
        /// Appends an item to `createSimulationJobRequests`.
        ///
        /// To override the contents of this collection use [`set_create_simulation_job_requests`](Self::set_create_simulation_job_requests).
        ///
        /// <p>A list of simulation job requests to create in the batch.</p>
        pub fn create_simulation_job_requests(
            mut self,
            input: crate::model::SimulationJobRequest,
        ) -> Self {
            self.inner = self.inner.create_simulation_job_requests(input);
            self
        }
        /// <p>A list of simulation job requests to create in the batch.</p>
        pub fn set_create_simulation_job_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
        ) -> Self {
            self.inner = self.inner.set_create_simulation_job_requests(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job batch.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SyncDeploymentJob`.
    ///
    /// <p>Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SyncDeploymentJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::sync_deployment_job_input::Builder,
    }
    impl<C, M, R> SyncDeploymentJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SyncDeploymentJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SyncDeploymentJobOutput,
            aws_smithy_http::result::SdkError<crate::error::SyncDeploymentJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SyncDeploymentJobInputOperationOutputAlias,
                crate::output::SyncDeploymentJobOutput,
                crate::error::SyncDeploymentJobError,
                crate::input::SyncDeploymentJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The target fleet for the synchronization.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet(input.into());
            self
        }
        /// <p>The target fleet for the synchronization.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or edits tags for a AWS RoboMaker resource.</p>
    /// <p>Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings. </p>
    /// <p>For information about the rules that apply to tag keys and tag values, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified AWS RoboMaker resource.</p>
    /// <p>To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A map that contains tag keys and tag values that will be unattached from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A map that contains tag keys and tag values that will be unattached from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRobotApplication`.
    ///
    /// <p>Updates a robot application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRobotApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_robot_application_input::Builder,
    }
    impl<C, M, R> UpdateRobotApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRobotApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRobotApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRobotApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRobotApplicationInputOperationOutputAlias,
                crate::output::UpdateRobotApplicationOutput,
                crate::error::UpdateRobotApplicationError,
                crate::input::UpdateRobotApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application information for the robot application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The application information for the robot application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            self.inner = self.inner.sources(input);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.inner = self.inner.robot_software_suite(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.inner = self.inner.set_robot_software_suite(input);
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_revision_id(input.into());
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_revision_id(input);
            self
        }
        /// <p>The object that contains the Docker image URI for your robot application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The object that contains the Docker image URI for your robot application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSimulationApplication`.
    ///
    /// <p>Updates a simulation application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSimulationApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_simulation_application_input::Builder,
    }
    impl<C, M, R> UpdateSimulationApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSimulationApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSimulationApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSimulationApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSimulationApplicationInputOperationOutputAlias,
                crate::output::UpdateSimulationApplicationOutput,
                crate::error::UpdateSimulationApplicationError,
                crate::input::UpdateSimulationApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The application information for the simulation application.</p>
        pub fn application(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application(input.into());
            self
        }
        /// <p>The application information for the simulation application.</p>
        pub fn set_application(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_application(input);
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: crate::model::SourceConfig) -> Self {
            self.inner = self.inner.sources(input);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceConfig>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.inner = self.inner.simulation_software_suite(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.inner = self.inner.set_simulation_software_suite(input);
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.inner = self.inner.robot_software_suite(input);
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.inner = self.inner.set_robot_software_suite(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.inner = self.inner.rendering_engine(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.inner = self.inner.set_rendering_engine(input);
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn current_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.current_revision_id(input.into());
            self
        }
        /// <p>The revision id for the robot application.</p>
        pub fn set_current_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_current_revision_id(input);
            self
        }
        /// <p>The object that contains the Docker image URI for your simulation application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>The object that contains the Docker image URI for your simulation application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorldTemplate`.
    ///
    /// <p>Updates a world template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWorldTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_world_template_input::Builder,
    }
    impl<C, M, R> UpdateWorldTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorldTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorldTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorldTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorldTemplateInputOperationOutputAlias,
                crate::output::UpdateWorldTemplateOutput,
                crate::error::UpdateWorldTemplateError,
                crate::input::UpdateWorldTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (arn) of the world template to update.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template to update.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template(input);
            self
        }
        /// <p>The name of the template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The world template body.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_body(input.into());
            self
        }
        /// <p>The world template body.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_template_body(input);
            self
        }
        /// <p>The location of the world template.</p>
        pub fn template_location(mut self, input: crate::model::TemplateLocation) -> Self {
            self.inner = self.inner.template_location(input);
            self
        }
        /// <p>The location of the world template.</p>
        pub fn set_template_location(
            mut self,
            input: std::option::Option<crate::model::TemplateLocation>,
        ) -> Self {
            self.inner = self.inner.set_template_location(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
