// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorldTemplateOutput {
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the world template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the world template was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateWorldTemplateOutput {
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the world template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world template was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorldTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorldTemplateOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`UpdateWorldTemplateOutput`](crate::output::UpdateWorldTemplateOutput)
pub mod update_world_template_output {
    /// A builder for [`UpdateWorldTemplateOutput`](crate::output::UpdateWorldTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the world template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the world template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorldTemplateOutput`](crate::output::UpdateWorldTemplateOutput)
        pub fn build(self) -> crate::output::UpdateWorldTemplateOutput {
            crate::output::UpdateWorldTemplateOutput {
                arn: self.arn,
                name: self.name,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl UpdateWorldTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorldTemplateOutput`](crate::output::UpdateWorldTemplateOutput)
    pub fn builder() -> crate::output::update_world_template_output::Builder {
        crate::output::update_world_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSimulationApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated simulation application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the simulation application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the robot application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the simulation application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The simulation software suite used by the simulation application.</p>
    pub simulation_software_suite: std::option::Option<crate::model::SimulationSoftwareSuite>,
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The rendering engine for the simulation application.</p>
    pub rendering_engine: std::option::Option<crate::model::RenderingEngine>,
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The revision id of the simulation application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The object that contains the Docker image URI used for your simulation
    /// application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl UpdateSimulationApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated simulation application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the simulation application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the robot application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the simulation application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The simulation software suite used by the simulation application.</p>
    pub fn simulation_software_suite(
        &self,
    ) -> std::option::Option<&crate::model::SimulationSoftwareSuite> {
        self.simulation_software_suite.as_ref()
    }
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The rendering engine for the simulation application.</p>
    pub fn rendering_engine(&self) -> std::option::Option<&crate::model::RenderingEngine> {
        self.rendering_engine.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The revision id of the simulation application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The object that contains the Docker image URI used for your simulation
    /// application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for UpdateSimulationApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSimulationApplicationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("simulation_software_suite", &self.simulation_software_suite);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("rendering_engine", &self.rendering_engine);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`UpdateSimulationApplicationOutput`](crate::output::UpdateSimulationApplicationOutput)
pub mod update_simulation_application_output {
    /// A builder for [`UpdateSimulationApplicationOutput`](crate::output::UpdateSimulationApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) simulation_software_suite:
            std::option::Option<crate::model::SimulationSoftwareSuite>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) rendering_engine: std::option::Option<crate::model::RenderingEngine>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated simulation application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated simulation application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.simulation_software_suite = Some(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.simulation_software_suite = input;
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.rendering_engine = Some(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.rendering_engine = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The revision id of the simulation application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision id of the simulation application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The object that contains the Docker image URI used for your simulation
        /// application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI used for your simulation
        /// application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSimulationApplicationOutput`](crate::output::UpdateSimulationApplicationOutput)
        pub fn build(self) -> crate::output::UpdateSimulationApplicationOutput {
            crate::output::UpdateSimulationApplicationOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                simulation_software_suite: self.simulation_software_suite,
                robot_software_suite: self.robot_software_suite,
                rendering_engine: self.rendering_engine,
                last_updated_at: self.last_updated_at,
                revision_id: self.revision_id,
                environment: self.environment,
            }
        }
    }
}
impl UpdateSimulationApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSimulationApplicationOutput`](crate::output::UpdateSimulationApplicationOutput)
    pub fn builder() -> crate::output::update_simulation_application_output::Builder {
        crate::output::update_simulation_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRobotApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated robot application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the robot application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the robot application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the robot application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The revision id of the robot application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The object that contains the Docker image URI for your robot application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl UpdateRobotApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated robot application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the robot application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the robot application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the robot application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The revision id of the robot application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The object that contains the Docker image URI for your robot application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for UpdateRobotApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRobotApplicationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`UpdateRobotApplicationOutput`](crate::output::UpdateRobotApplicationOutput)
pub mod update_robot_application_output {
    /// A builder for [`UpdateRobotApplicationOutput`](crate::output::UpdateRobotApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated robot application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated robot application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The object that contains the Docker image URI for your robot application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI for your robot application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRobotApplicationOutput`](crate::output::UpdateRobotApplicationOutput)
        pub fn build(self) -> crate::output::UpdateRobotApplicationOutput {
            crate::output::UpdateRobotApplicationOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                robot_software_suite: self.robot_software_suite,
                last_updated_at: self.last_updated_at,
                revision_id: self.revision_id,
                environment: self.environment,
            }
        }
    }
}
impl UpdateRobotApplicationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRobotApplicationOutput`](crate::output::UpdateRobotApplicationOutput)
    pub fn builder() -> crate::output::update_robot_application_output::Builder {
        crate::output::update_robot_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SyncDeploymentJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the synchronization request.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The status of the synchronization job.</p>
    pub status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>Information about the deployment configuration.</p>
    pub deployment_config: std::option::Option<crate::model::DeploymentConfig>,
    /// <p>Information about the deployment application configurations.</p>
    pub deployment_application_configs:
        std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
    /// <p>The failure reason if the job fails.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The failure code if the job fails:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>RobotApplicationCrash</dt>
    /// <dd>
    /// <p>Robot application exited abnormally.</p>
    /// </dd>
    /// <dt>SimulationApplicationCrash</dt>
    /// <dd>
    /// <p> Simulation application exited abnormally.</p>
    /// </dd>
    /// <dt>BadPermissionsRobotApplication</dt>
    /// <dd>
    /// <p>Robot application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsS3Output</dt>
    /// <dd>
    /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
    /// </dd>
    /// <dt>BadPermissionsCloudwatchLogs</dt>
    /// <dd>
    /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
    /// </dd>
    /// <dt>SubnetIpLimitExceeded</dt>
    /// <dd>
    /// <p>Subnet IP limit exceeded.</p>
    /// </dd>
    /// <dt>ENILimitExceeded</dt>
    /// <dd>
    /// <p>ENI limit exceeded.</p>
    /// </dd>
    /// <dt>BadPermissionsUserCredentials</dt>
    /// <dd>
    /// <p>Unable to use the Role provided.</p>
    /// </dd>
    /// <dt>InvalidBundleRobotApplication</dt>
    /// <dd>
    /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>InvalidBundleSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>RobotApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for RobotApplication does not match value during version creation.</p>
    /// </dd>
    /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for SimulationApplication does not match value during version
    /// creation.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl SyncDeploymentJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the synchronization request.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The status of the synchronization job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.status.as_ref()
    }
    /// <p>Information about the deployment configuration.</p>
    pub fn deployment_config(&self) -> std::option::Option<&crate::model::DeploymentConfig> {
        self.deployment_config.as_ref()
    }
    /// <p>Information about the deployment application configurations.</p>
    pub fn deployment_application_configs(
        &self,
    ) -> std::option::Option<&[crate::model::DeploymentApplicationConfig]> {
        self.deployment_application_configs.as_deref()
    }
    /// <p>The failure reason if the job fails.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The failure code if the job fails:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>RobotApplicationCrash</dt>
    /// <dd>
    /// <p>Robot application exited abnormally.</p>
    /// </dd>
    /// <dt>SimulationApplicationCrash</dt>
    /// <dd>
    /// <p> Simulation application exited abnormally.</p>
    /// </dd>
    /// <dt>BadPermissionsRobotApplication</dt>
    /// <dd>
    /// <p>Robot application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsS3Output</dt>
    /// <dd>
    /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
    /// </dd>
    /// <dt>BadPermissionsCloudwatchLogs</dt>
    /// <dd>
    /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
    /// </dd>
    /// <dt>SubnetIpLimitExceeded</dt>
    /// <dd>
    /// <p>Subnet IP limit exceeded.</p>
    /// </dd>
    /// <dt>ENILimitExceeded</dt>
    /// <dd>
    /// <p>ENI limit exceeded.</p>
    /// </dd>
    /// <dt>BadPermissionsUserCredentials</dt>
    /// <dd>
    /// <p>Unable to use the Role provided.</p>
    /// </dd>
    /// <dt>InvalidBundleRobotApplication</dt>
    /// <dd>
    /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>InvalidBundleSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>RobotApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for RobotApplication does not match value during version creation.</p>
    /// </dd>
    /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for SimulationApplication does not match value during version
    /// creation.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::DeploymentJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for SyncDeploymentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SyncDeploymentJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("fleet", &self.fleet);
        formatter.field("status", &self.status);
        formatter.field("deployment_config", &self.deployment_config);
        formatter.field(
            "deployment_application_configs",
            &self.deployment_application_configs,
        );
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`SyncDeploymentJobOutput`](crate::output::SyncDeploymentJobOutput)
pub mod sync_deployment_job_output {
    /// A builder for [`SyncDeploymentJobOutput`](crate::output::SyncDeploymentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_config: std::option::Option<crate::model::DeploymentConfig>,
        pub(crate) deployment_application_configs:
            std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the synchronization request.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the synchronization request.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>The status of the synchronization job.</p>
        pub fn status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the synchronization job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Information about the deployment configuration.</p>
        pub fn deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.deployment_config = Some(input);
            self
        }
        /// <p>Information about the deployment configuration.</p>
        pub fn set_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.deployment_config = input;
            self
        }
        /// Appends an item to `deployment_application_configs`.
        ///
        /// To override the contents of this collection use [`set_deployment_application_configs`](Self::set_deployment_application_configs).
        ///
        /// <p>Information about the deployment application configurations.</p>
        pub fn deployment_application_configs(
            mut self,
            input: impl Into<crate::model::DeploymentApplicationConfig>,
        ) -> Self {
            let mut v = self.deployment_application_configs.unwrap_or_default();
            v.push(input.into());
            self.deployment_application_configs = Some(v);
            self
        }
        /// <p>Information about the deployment application configurations.</p>
        pub fn set_deployment_application_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        ) -> Self {
            self.deployment_application_configs = input;
            self
        }
        /// <p>The failure reason if the job fails.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The failure reason if the job fails.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The failure code if the job fails:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>RobotApplicationCrash</dt>
        /// <dd>
        /// <p>Robot application exited abnormally.</p>
        /// </dd>
        /// <dt>SimulationApplicationCrash</dt>
        /// <dd>
        /// <p> Simulation application exited abnormally.</p>
        /// </dd>
        /// <dt>BadPermissionsRobotApplication</dt>
        /// <dd>
        /// <p>Robot application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsS3Output</dt>
        /// <dd>
        /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
        /// </dd>
        /// <dt>BadPermissionsCloudwatchLogs</dt>
        /// <dd>
        /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
        /// </dd>
        /// <dt>SubnetIpLimitExceeded</dt>
        /// <dd>
        /// <p>Subnet IP limit exceeded.</p>
        /// </dd>
        /// <dt>ENILimitExceeded</dt>
        /// <dd>
        /// <p>ENI limit exceeded.</p>
        /// </dd>
        /// <dt>BadPermissionsUserCredentials</dt>
        /// <dd>
        /// <p>Unable to use the Role provided.</p>
        /// </dd>
        /// <dt>InvalidBundleRobotApplication</dt>
        /// <dd>
        /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>InvalidBundleSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>RobotApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for RobotApplication does not match value during version creation.</p>
        /// </dd>
        /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for SimulationApplication does not match value during version
        /// creation.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::DeploymentJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code if the job fails:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>RobotApplicationCrash</dt>
        /// <dd>
        /// <p>Robot application exited abnormally.</p>
        /// </dd>
        /// <dt>SimulationApplicationCrash</dt>
        /// <dd>
        /// <p> Simulation application exited abnormally.</p>
        /// </dd>
        /// <dt>BadPermissionsRobotApplication</dt>
        /// <dd>
        /// <p>Robot application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsS3Output</dt>
        /// <dd>
        /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
        /// </dd>
        /// <dt>BadPermissionsCloudwatchLogs</dt>
        /// <dd>
        /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
        /// </dd>
        /// <dt>SubnetIpLimitExceeded</dt>
        /// <dd>
        /// <p>Subnet IP limit exceeded.</p>
        /// </dd>
        /// <dt>ENILimitExceeded</dt>
        /// <dd>
        /// <p>ENI limit exceeded.</p>
        /// </dd>
        /// <dt>BadPermissionsUserCredentials</dt>
        /// <dd>
        /// <p>Unable to use the Role provided.</p>
        /// </dd>
        /// <dt>InvalidBundleRobotApplication</dt>
        /// <dd>
        /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>InvalidBundleSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>RobotApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for RobotApplication does not match value during version creation.</p>
        /// </dd>
        /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for SimulationApplication does not match value during version
        /// creation.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::DeploymentJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`SyncDeploymentJobOutput`](crate::output::SyncDeploymentJobOutput)
        pub fn build(self) -> crate::output::SyncDeploymentJobOutput {
            crate::output::SyncDeploymentJobOutput {
                arn: self.arn,
                fleet: self.fleet,
                status: self.status,
                deployment_config: self.deployment_config,
                deployment_application_configs: self.deployment_application_configs,
                failure_reason: self.failure_reason,
                failure_code: self.failure_code,
                created_at: self.created_at,
            }
        }
    }
}
impl SyncDeploymentJobOutput {
    /// Creates a new builder-style object to manufacture [`SyncDeploymentJobOutput`](crate::output::SyncDeploymentJobOutput)
    pub fn builder() -> crate::output::sync_deployment_job_output::Builder {
        crate::output::sync_deployment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSimulationJobBatchOutput {
    /// <p>The Amazon Resource Name (arn) of the batch.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the simulation job batch.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The simulation job batch request is pending.</p>
    /// </dd>
    /// <dt>InProgress</dt>
    /// <dd>
    /// <p>The simulation job batch is in progress. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The simulation job batch failed. One or more simulation job requests could not
    /// be completed due to an internal failure (like <code>InternalServiceError</code>).
    /// See <code>failureCode</code> and <code>failureReason</code> for more
    /// information.</p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The simulation batch job completed. A batch is complete when (1) there are no
    /// pending simulation job requests in the batch and none of the failed simulation job
    /// requests are due to <code>InternalServiceError</code> and (2) when all created
    /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
    /// or <code>Failed</code>). </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The simulation batch job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The simulation batch job is being cancelled.</p>
    /// </dd>
    /// <dt>Completing</dt>
    /// <dd>
    /// <p>The simulation batch job is completing.</p>
    /// </dd>
    /// <dt>TimingOut</dt>
    /// <dd>
    /// <p>The simulation job batch is timing out.</p>
    /// <p>If a batch timing out, and there are pending requests that were failing due to
    /// an internal failure (like <code>InternalServiceError</code>), the batch status
    /// will be <code>Failed</code>. If there are no such failing request, the batch
    /// status will be <code>TimedOut</code>. </p>
    /// </dd>
    /// <dt>TimedOut</dt>
    /// <dd>
    /// <p>The simulation batch job timed out.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::SimulationJobBatchStatus>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
    /// created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The batch policy.</p>
    pub batch_policy: std::option::Option<crate::model::BatchPolicy>,
    /// <p>The failure code if the simulation job batch failed.</p>
    pub failure_code: std::option::Option<crate::model::SimulationJobBatchErrorCode>,
    /// <p>The reason the simulation job batch failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>A list of failed simulation job requests. The request failed to be created into a
    /// simulation job. Failed requests do not have a simulation job ID. </p>
    pub failed_requests:
        std::option::Option<std::vec::Vec<crate::model::FailedCreateSimulationJobRequest>>,
    /// <p>A list of pending simulation job requests. These requests have not yet been created into
    /// simulation jobs.</p>
    pub pending_requests: std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
    /// <p>A list of created simulation job request summaries.</p>
    pub created_requests: std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
    /// <p>A map that contains tag keys and tag values that are attached to the deployment job
    /// batch.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartSimulationJobBatchOutput {
    /// <p>The Amazon Resource Name (arn) of the batch.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the simulation job batch.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The simulation job batch request is pending.</p>
    /// </dd>
    /// <dt>InProgress</dt>
    /// <dd>
    /// <p>The simulation job batch is in progress. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The simulation job batch failed. One or more simulation job requests could not
    /// be completed due to an internal failure (like <code>InternalServiceError</code>).
    /// See <code>failureCode</code> and <code>failureReason</code> for more
    /// information.</p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The simulation batch job completed. A batch is complete when (1) there are no
    /// pending simulation job requests in the batch and none of the failed simulation job
    /// requests are due to <code>InternalServiceError</code> and (2) when all created
    /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
    /// or <code>Failed</code>). </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The simulation batch job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The simulation batch job is being cancelled.</p>
    /// </dd>
    /// <dt>Completing</dt>
    /// <dd>
    /// <p>The simulation batch job is completing.</p>
    /// </dd>
    /// <dt>TimingOut</dt>
    /// <dd>
    /// <p>The simulation job batch is timing out.</p>
    /// <p>If a batch timing out, and there are pending requests that were failing due to
    /// an internal failure (like <code>InternalServiceError</code>), the batch status
    /// will be <code>Failed</code>. If there are no such failing request, the batch
    /// status will be <code>TimedOut</code>. </p>
    /// </dd>
    /// <dt>TimedOut</dt>
    /// <dd>
    /// <p>The simulation batch job timed out.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::SimulationJobBatchStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
    /// created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The batch policy.</p>
    pub fn batch_policy(&self) -> std::option::Option<&crate::model::BatchPolicy> {
        self.batch_policy.as_ref()
    }
    /// <p>The failure code if the simulation job batch failed.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::SimulationJobBatchErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The reason the simulation job batch failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>A list of failed simulation job requests. The request failed to be created into a
    /// simulation job. Failed requests do not have a simulation job ID. </p>
    pub fn failed_requests(
        &self,
    ) -> std::option::Option<&[crate::model::FailedCreateSimulationJobRequest]> {
        self.failed_requests.as_deref()
    }
    /// <p>A list of pending simulation job requests. These requests have not yet been created into
    /// simulation jobs.</p>
    pub fn pending_requests(&self) -> std::option::Option<&[crate::model::SimulationJobRequest]> {
        self.pending_requests.as_deref()
    }
    /// <p>A list of created simulation job request summaries.</p>
    pub fn created_requests(&self) -> std::option::Option<&[crate::model::SimulationJobSummary]> {
        self.created_requests.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the deployment job
    /// batch.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartSimulationJobBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSimulationJobBatchOutput");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("batch_policy", &self.batch_policy);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failed_requests", &self.failed_requests);
        formatter.field("pending_requests", &self.pending_requests);
        formatter.field("created_requests", &self.created_requests);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`StartSimulationJobBatchOutput`](crate::output::StartSimulationJobBatchOutput)
pub mod start_simulation_job_batch_output {
    /// A builder for [`StartSimulationJobBatchOutput`](crate::output::StartSimulationJobBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SimulationJobBatchStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) batch_policy: std::option::Option<crate::model::BatchPolicy>,
        pub(crate) failure_code: std::option::Option<crate::model::SimulationJobBatchErrorCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failed_requests:
            std::option::Option<std::vec::Vec<crate::model::FailedCreateSimulationJobRequest>>,
        pub(crate) pending_requests:
            std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
        pub(crate) created_requests:
            std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the batch.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the batch.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the simulation job batch.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The simulation job batch request is pending.</p>
        /// </dd>
        /// <dt>InProgress</dt>
        /// <dd>
        /// <p>The simulation job batch is in progress. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The simulation job batch failed. One or more simulation job requests could not
        /// be completed due to an internal failure (like <code>InternalServiceError</code>).
        /// See <code>failureCode</code> and <code>failureReason</code> for more
        /// information.</p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The simulation batch job completed. A batch is complete when (1) there are no
        /// pending simulation job requests in the batch and none of the failed simulation job
        /// requests are due to <code>InternalServiceError</code> and (2) when all created
        /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
        /// or <code>Failed</code>). </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The simulation batch job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The simulation batch job is being cancelled.</p>
        /// </dd>
        /// <dt>Completing</dt>
        /// <dd>
        /// <p>The simulation batch job is completing.</p>
        /// </dd>
        /// <dt>TimingOut</dt>
        /// <dd>
        /// <p>The simulation job batch is timing out.</p>
        /// <p>If a batch timing out, and there are pending requests that were failing due to
        /// an internal failure (like <code>InternalServiceError</code>), the batch status
        /// will be <code>Failed</code>. If there are no such failing request, the batch
        /// status will be <code>TimedOut</code>. </p>
        /// </dd>
        /// <dt>TimedOut</dt>
        /// <dd>
        /// <p>The simulation batch job timed out.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::SimulationJobBatchStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the simulation job batch.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The simulation job batch request is pending.</p>
        /// </dd>
        /// <dt>InProgress</dt>
        /// <dd>
        /// <p>The simulation job batch is in progress. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The simulation job batch failed. One or more simulation job requests could not
        /// be completed due to an internal failure (like <code>InternalServiceError</code>).
        /// See <code>failureCode</code> and <code>failureReason</code> for more
        /// information.</p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The simulation batch job completed. A batch is complete when (1) there are no
        /// pending simulation job requests in the batch and none of the failed simulation job
        /// requests are due to <code>InternalServiceError</code> and (2) when all created
        /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
        /// or <code>Failed</code>). </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The simulation batch job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The simulation batch job is being cancelled.</p>
        /// </dd>
        /// <dt>Completing</dt>
        /// <dd>
        /// <p>The simulation batch job is completing.</p>
        /// </dd>
        /// <dt>TimingOut</dt>
        /// <dd>
        /// <p>The simulation job batch is timing out.</p>
        /// <p>If a batch timing out, and there are pending requests that were failing due to
        /// an internal failure (like <code>InternalServiceError</code>), the batch status
        /// will be <code>Failed</code>. If there are no such failing request, the batch
        /// status will be <code>TimedOut</code>. </p>
        /// </dd>
        /// <dt>TimedOut</dt>
        /// <dd>
        /// <p>The simulation batch job timed out.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SimulationJobBatchStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
        /// created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
        /// created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The batch policy.</p>
        pub fn batch_policy(mut self, input: crate::model::BatchPolicy) -> Self {
            self.batch_policy = Some(input);
            self
        }
        /// <p>The batch policy.</p>
        pub fn set_batch_policy(
            mut self,
            input: std::option::Option<crate::model::BatchPolicy>,
        ) -> Self {
            self.batch_policy = input;
            self
        }
        /// <p>The failure code if the simulation job batch failed.</p>
        pub fn failure_code(mut self, input: crate::model::SimulationJobBatchErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code if the simulation job batch failed.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::SimulationJobBatchErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The reason the simulation job batch failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason the simulation job batch failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Appends an item to `failed_requests`.
        ///
        /// To override the contents of this collection use [`set_failed_requests`](Self::set_failed_requests).
        ///
        /// <p>A list of failed simulation job requests. The request failed to be created into a
        /// simulation job. Failed requests do not have a simulation job ID. </p>
        pub fn failed_requests(
            mut self,
            input: impl Into<crate::model::FailedCreateSimulationJobRequest>,
        ) -> Self {
            let mut v = self.failed_requests.unwrap_or_default();
            v.push(input.into());
            self.failed_requests = Some(v);
            self
        }
        /// <p>A list of failed simulation job requests. The request failed to be created into a
        /// simulation job. Failed requests do not have a simulation job ID. </p>
        pub fn set_failed_requests(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::FailedCreateSimulationJobRequest>,
            >,
        ) -> Self {
            self.failed_requests = input;
            self
        }
        /// Appends an item to `pending_requests`.
        ///
        /// To override the contents of this collection use [`set_pending_requests`](Self::set_pending_requests).
        ///
        /// <p>A list of pending simulation job requests. These requests have not yet been created into
        /// simulation jobs.</p>
        pub fn pending_requests(
            mut self,
            input: impl Into<crate::model::SimulationJobRequest>,
        ) -> Self {
            let mut v = self.pending_requests.unwrap_or_default();
            v.push(input.into());
            self.pending_requests = Some(v);
            self
        }
        /// <p>A list of pending simulation job requests. These requests have not yet been created into
        /// simulation jobs.</p>
        pub fn set_pending_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
        ) -> Self {
            self.pending_requests = input;
            self
        }
        /// Appends an item to `created_requests`.
        ///
        /// To override the contents of this collection use [`set_created_requests`](Self::set_created_requests).
        ///
        /// <p>A list of created simulation job request summaries.</p>
        pub fn created_requests(
            mut self,
            input: impl Into<crate::model::SimulationJobSummary>,
        ) -> Self {
            let mut v = self.created_requests.unwrap_or_default();
            v.push(input.into());
            self.created_requests = Some(v);
            self
        }
        /// <p>A list of created simulation job request summaries.</p>
        pub fn set_created_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
        ) -> Self {
            self.created_requests = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job
        /// batch.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the deployment job
        /// batch.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSimulationJobBatchOutput`](crate::output::StartSimulationJobBatchOutput)
        pub fn build(self) -> crate::output::StartSimulationJobBatchOutput {
            crate::output::StartSimulationJobBatchOutput {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                client_request_token: self.client_request_token,
                batch_policy: self.batch_policy,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
                failed_requests: self.failed_requests,
                pending_requests: self.pending_requests,
                created_requests: self.created_requests,
                tags: self.tags,
            }
        }
    }
}
impl StartSimulationJobBatchOutput {
    /// Creates a new builder-style object to manufacture [`StartSimulationJobBatchOutput`](crate::output::StartSimulationJobBatchOutput)
    pub fn builder() -> crate::output::start_simulation_job_batch_output::Builder {
        crate::output::start_simulation_job_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestartSimulationJobOutput {}
impl std::fmt::Debug for RestartSimulationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestartSimulationJobOutput");
        formatter.finish()
    }
}
/// See [`RestartSimulationJobOutput`](crate::output::RestartSimulationJobOutput)
pub mod restart_simulation_job_output {
    /// A builder for [`RestartSimulationJobOutput`](crate::output::RestartSimulationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RestartSimulationJobOutput`](crate::output::RestartSimulationJobOutput)
        pub fn build(self) -> crate::output::RestartSimulationJobOutput {
            crate::output::RestartSimulationJobOutput {}
        }
    }
}
impl RestartSimulationJobOutput {
    /// Creates a new builder-style object to manufacture [`RestartSimulationJobOutput`](crate::output::RestartSimulationJobOutput)
    pub fn builder() -> crate::output::restart_simulation_job_output::Builder {
        crate::output::restart_simulation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the fleet that the robot will join.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>Information about the robot registration.</p>
    pub robot: std::option::Option<std::string::String>,
}
impl RegisterRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the fleet that the robot will join.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>Information about the robot registration.</p>
    pub fn robot(&self) -> std::option::Option<&str> {
        self.robot.as_deref()
    }
}
impl std::fmt::Debug for RegisterRobotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterRobotOutput");
        formatter.field("fleet", &self.fleet);
        formatter.field("robot", &self.robot);
        formatter.finish()
    }
}
/// See [`RegisterRobotOutput`](crate::output::RegisterRobotOutput)
pub mod register_robot_output {
    /// A builder for [`RegisterRobotOutput`](crate::output::RegisterRobotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) robot: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the fleet that the robot will join.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet that the robot will join.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>Information about the robot registration.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.robot = Some(input.into());
            self
        }
        /// <p>Information about the robot registration.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.robot = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterRobotOutput`](crate::output::RegisterRobotOutput)
        pub fn build(self) -> crate::output::RegisterRobotOutput {
            crate::output::RegisterRobotOutput {
                fleet: self.fleet,
                robot: self.robot,
            }
        }
    }
}
impl RegisterRobotOutput {
    /// Creates a new builder-style object to manufacture [`RegisterRobotOutput`](crate::output::RegisterRobotOutput)
    pub fn builder() -> crate::output::register_robot_output::Builder {
        crate::output::register_robot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldTemplatesOutput {
    /// <p>Summary information for templates.</p>
    pub template_summaries: std::option::Option<std::vec::Vec<crate::model::TemplateSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorldTemplates</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorldTemplatesOutput {
    /// <p>Summary information for templates.</p>
    pub fn template_summaries(&self) -> std::option::Option<&[crate::model::TemplateSummary]> {
        self.template_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorldTemplates</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorldTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldTemplatesOutput");
        formatter.field("template_summaries", &self.template_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorldTemplatesOutput`](crate::output::ListWorldTemplatesOutput)
pub mod list_world_templates_output {
    /// A builder for [`ListWorldTemplatesOutput`](crate::output::ListWorldTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_summaries:
            std::option::Option<std::vec::Vec<crate::model::TemplateSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `template_summaries`.
        ///
        /// To override the contents of this collection use [`set_template_summaries`](Self::set_template_summaries).
        ///
        /// <p>Summary information for templates.</p>
        pub fn template_summaries(
            mut self,
            input: impl Into<crate::model::TemplateSummary>,
        ) -> Self {
            let mut v = self.template_summaries.unwrap_or_default();
            v.push(input.into());
            self.template_summaries = Some(v);
            self
        }
        /// <p>Summary information for templates.</p>
        pub fn set_template_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TemplateSummary>>,
        ) -> Self {
            self.template_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorldTemplates</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorldTemplates</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldTemplatesOutput`](crate::output::ListWorldTemplatesOutput)
        pub fn build(self) -> crate::output::ListWorldTemplatesOutput {
            crate::output::ListWorldTemplatesOutput {
                template_summaries: self.template_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorldTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListWorldTemplatesOutput`](crate::output::ListWorldTemplatesOutput)
    pub fn builder() -> crate::output::list_world_templates_output::Builder {
        crate::output::list_world_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldsOutput {
    /// <p>Summary information for worlds.</p>
    pub world_summaries: std::option::Option<std::vec::Vec<crate::model::WorldSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorlds</code> again and assign that token to the
    /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
    /// previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorldsOutput {
    /// <p>Summary information for worlds.</p>
    pub fn world_summaries(&self) -> std::option::Option<&[crate::model::WorldSummary]> {
        self.world_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorlds</code> again and assign that token to the
    /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
    /// previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorldsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldsOutput");
        formatter.field("world_summaries", &self.world_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorldsOutput`](crate::output::ListWorldsOutput)
pub mod list_worlds_output {
    /// A builder for [`ListWorldsOutput`](crate::output::ListWorldsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) world_summaries: std::option::Option<std::vec::Vec<crate::model::WorldSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `world_summaries`.
        ///
        /// To override the contents of this collection use [`set_world_summaries`](Self::set_world_summaries).
        ///
        /// <p>Summary information for worlds.</p>
        pub fn world_summaries(mut self, input: impl Into<crate::model::WorldSummary>) -> Self {
            let mut v = self.world_summaries.unwrap_or_default();
            v.push(input.into());
            self.world_summaries = Some(v);
            self
        }
        /// <p>Summary information for worlds.</p>
        pub fn set_world_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorldSummary>>,
        ) -> Self {
            self.world_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorlds</code> again and assign that token to the
        /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
        /// previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorlds</code> again and assign that token to the
        /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
        /// previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldsOutput`](crate::output::ListWorldsOutput)
        pub fn build(self) -> crate::output::ListWorldsOutput {
            crate::output::ListWorldsOutput {
                world_summaries: self.world_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorldsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorldsOutput`](crate::output::ListWorldsOutput)
    pub fn builder() -> crate::output::list_worlds_output::Builder {
        crate::output::list_worlds_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldGenerationJobsOutput {
    /// <p>Summary information for world generator jobs.</p>
    pub world_generation_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::WorldGenerationJobSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorldGeneratorJobsRequest</code> again and assign that
    /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorldGenerationJobsOutput {
    /// <p>Summary information for world generator jobs.</p>
    pub fn world_generation_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::WorldGenerationJobSummary]> {
        self.world_generation_job_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorldGeneratorJobsRequest</code> again and assign that
    /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorldGenerationJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldGenerationJobsOutput");
        formatter.field(
            "world_generation_job_summaries",
            &self.world_generation_job_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorldGenerationJobsOutput`](crate::output::ListWorldGenerationJobsOutput)
pub mod list_world_generation_jobs_output {
    /// A builder for [`ListWorldGenerationJobsOutput`](crate::output::ListWorldGenerationJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) world_generation_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::WorldGenerationJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `world_generation_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_world_generation_job_summaries`](Self::set_world_generation_job_summaries).
        ///
        /// <p>Summary information for world generator jobs.</p>
        pub fn world_generation_job_summaries(
            mut self,
            input: impl Into<crate::model::WorldGenerationJobSummary>,
        ) -> Self {
            let mut v = self.world_generation_job_summaries.unwrap_or_default();
            v.push(input.into());
            self.world_generation_job_summaries = Some(v);
            self
        }
        /// <p>Summary information for world generator jobs.</p>
        pub fn set_world_generation_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorldGenerationJobSummary>>,
        ) -> Self {
            self.world_generation_job_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorldGeneratorJobsRequest</code> again and assign that
        /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorldGeneratorJobsRequest</code> again and assign that
        /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldGenerationJobsOutput`](crate::output::ListWorldGenerationJobsOutput)
        pub fn build(self) -> crate::output::ListWorldGenerationJobsOutput {
            crate::output::ListWorldGenerationJobsOutput {
                world_generation_job_summaries: self.world_generation_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorldGenerationJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorldGenerationJobsOutput`](crate::output::ListWorldGenerationJobsOutput)
    pub fn builder() -> crate::output::list_world_generation_jobs_output::Builder {
        crate::output::list_world_generation_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorldExportJobsOutput {
    /// <p>Summary information for world export jobs.</p>
    pub world_export_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::WorldExportJobSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorldExportJobsRequest</code> again and assign that
    /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorldExportJobsOutput {
    /// <p>Summary information for world export jobs.</p>
    pub fn world_export_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::WorldExportJobSummary]> {
        self.world_export_job_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListWorldExportJobsRequest</code> again and assign that
    /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorldExportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorldExportJobsOutput");
        formatter.field(
            "world_export_job_summaries",
            &self.world_export_job_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorldExportJobsOutput`](crate::output::ListWorldExportJobsOutput)
pub mod list_world_export_jobs_output {
    /// A builder for [`ListWorldExportJobsOutput`](crate::output::ListWorldExportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) world_export_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::WorldExportJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `world_export_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_world_export_job_summaries`](Self::set_world_export_job_summaries).
        ///
        /// <p>Summary information for world export jobs.</p>
        pub fn world_export_job_summaries(
            mut self,
            input: impl Into<crate::model::WorldExportJobSummary>,
        ) -> Self {
            let mut v = self.world_export_job_summaries.unwrap_or_default();
            v.push(input.into());
            self.world_export_job_summaries = Some(v);
            self
        }
        /// <p>Summary information for world export jobs.</p>
        pub fn set_world_export_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::WorldExportJobSummary>>,
        ) -> Self {
            self.world_export_job_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorldExportJobsRequest</code> again and assign that
        /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListWorldExportJobsRequest</code> again and assign that
        /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorldExportJobsOutput`](crate::output::ListWorldExportJobsOutput)
        pub fn build(self) -> crate::output::ListWorldExportJobsOutput {
            crate::output::ListWorldExportJobsOutput {
                world_export_job_summaries: self.world_export_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorldExportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorldExportJobsOutput`](crate::output::ListWorldExportJobsOutput)
    pub fn builder() -> crate::output::list_world_export_jobs_output::Builder {
        crate::output::list_world_export_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The list of all tags added to the specified resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The list of all tags added to the specified resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSimulationJobsOutput {
    /// <p>A list of simulation job summaries that meet the criteria of the request.</p>
    pub simulation_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListSimulationJobs</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSimulationJobsOutput {
    /// <p>A list of simulation job summaries that meet the criteria of the request.</p>
    pub fn simulation_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationJobSummary]> {
        self.simulation_job_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListSimulationJobs</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSimulationJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSimulationJobsOutput");
        formatter.field("simulation_job_summaries", &self.simulation_job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSimulationJobsOutput`](crate::output::ListSimulationJobsOutput)
pub mod list_simulation_jobs_output {
    /// A builder for [`ListSimulationJobsOutput`](crate::output::ListSimulationJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simulation_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `simulation_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_simulation_job_summaries`](Self::set_simulation_job_summaries).
        ///
        /// <p>A list of simulation job summaries that meet the criteria of the request.</p>
        pub fn simulation_job_summaries(
            mut self,
            input: impl Into<crate::model::SimulationJobSummary>,
        ) -> Self {
            let mut v = self.simulation_job_summaries.unwrap_or_default();
            v.push(input.into());
            self.simulation_job_summaries = Some(v);
            self
        }
        /// <p>A list of simulation job summaries that meet the criteria of the request.</p>
        pub fn set_simulation_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
        ) -> Self {
            self.simulation_job_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListSimulationJobs</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListSimulationJobs</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSimulationJobsOutput`](crate::output::ListSimulationJobsOutput)
        pub fn build(self) -> crate::output::ListSimulationJobsOutput {
            crate::output::ListSimulationJobsOutput {
                simulation_job_summaries: self.simulation_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSimulationJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListSimulationJobsOutput`](crate::output::ListSimulationJobsOutput)
    pub fn builder() -> crate::output::list_simulation_jobs_output::Builder {
        crate::output::list_simulation_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSimulationJobBatchesOutput {
    /// <p>A list of simulation job batch summaries.</p>
    pub simulation_job_batch_summaries:
        std::option::Option<std::vec::Vec<crate::model::SimulationJobBatchSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListSimulationJobBatches</code> again and assign that token
    /// to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSimulationJobBatchesOutput {
    /// <p>A list of simulation job batch summaries.</p>
    pub fn simulation_job_batch_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationJobBatchSummary]> {
        self.simulation_job_batch_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListSimulationJobBatches</code> again and assign that token
    /// to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSimulationJobBatchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSimulationJobBatchesOutput");
        formatter.field(
            "simulation_job_batch_summaries",
            &self.simulation_job_batch_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSimulationJobBatchesOutput`](crate::output::ListSimulationJobBatchesOutput)
pub mod list_simulation_job_batches_output {
    /// A builder for [`ListSimulationJobBatchesOutput`](crate::output::ListSimulationJobBatchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simulation_job_batch_summaries:
            std::option::Option<std::vec::Vec<crate::model::SimulationJobBatchSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `simulation_job_batch_summaries`.
        ///
        /// To override the contents of this collection use [`set_simulation_job_batch_summaries`](Self::set_simulation_job_batch_summaries).
        ///
        /// <p>A list of simulation job batch summaries.</p>
        pub fn simulation_job_batch_summaries(
            mut self,
            input: impl Into<crate::model::SimulationJobBatchSummary>,
        ) -> Self {
            let mut v = self.simulation_job_batch_summaries.unwrap_or_default();
            v.push(input.into());
            self.simulation_job_batch_summaries = Some(v);
            self
        }
        /// <p>A list of simulation job batch summaries.</p>
        pub fn set_simulation_job_batch_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobBatchSummary>>,
        ) -> Self {
            self.simulation_job_batch_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListSimulationJobBatches</code> again and assign that token
        /// to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListSimulationJobBatches</code> again and assign that token
        /// to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSimulationJobBatchesOutput`](crate::output::ListSimulationJobBatchesOutput)
        pub fn build(self) -> crate::output::ListSimulationJobBatchesOutput {
            crate::output::ListSimulationJobBatchesOutput {
                simulation_job_batch_summaries: self.simulation_job_batch_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSimulationJobBatchesOutput {
    /// Creates a new builder-style object to manufacture [`ListSimulationJobBatchesOutput`](crate::output::ListSimulationJobBatchesOutput)
    pub fn builder() -> crate::output::list_simulation_job_batches_output::Builder {
        crate::output::list_simulation_job_batches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSimulationApplicationsOutput {
    /// <p>A list of simulation application summaries that meet the criteria of the request.</p>
    pub simulation_application_summaries:
        std::option::Option<std::vec::Vec<crate::model::SimulationApplicationSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListSimulationApplications</code> again and assign that
    /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSimulationApplicationsOutput {
    /// <p>A list of simulation application summaries that meet the criteria of the request.</p>
    pub fn simulation_application_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationApplicationSummary]> {
        self.simulation_application_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListSimulationApplications</code> again and assign that
    /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
    /// results, the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSimulationApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSimulationApplicationsOutput");
        formatter.field(
            "simulation_application_summaries",
            &self.simulation_application_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSimulationApplicationsOutput`](crate::output::ListSimulationApplicationsOutput)
pub mod list_simulation_applications_output {
    /// A builder for [`ListSimulationApplicationsOutput`](crate::output::ListSimulationApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simulation_application_summaries:
            std::option::Option<std::vec::Vec<crate::model::SimulationApplicationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `simulation_application_summaries`.
        ///
        /// To override the contents of this collection use [`set_simulation_application_summaries`](Self::set_simulation_application_summaries).
        ///
        /// <p>A list of simulation application summaries that meet the criteria of the request.</p>
        pub fn simulation_application_summaries(
            mut self,
            input: impl Into<crate::model::SimulationApplicationSummary>,
        ) -> Self {
            let mut v = self.simulation_application_summaries.unwrap_or_default();
            v.push(input.into());
            self.simulation_application_summaries = Some(v);
            self
        }
        /// <p>A list of simulation application summaries that meet the criteria of the request.</p>
        pub fn set_simulation_application_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationApplicationSummary>>,
        ) -> Self {
            self.simulation_application_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListSimulationApplications</code> again and assign that
        /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListSimulationApplications</code> again and assign that
        /// token to the request object's <code>nextToken</code> parameter. If there are no remaining
        /// results, the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSimulationApplicationsOutput`](crate::output::ListSimulationApplicationsOutput)
        pub fn build(self) -> crate::output::ListSimulationApplicationsOutput {
            crate::output::ListSimulationApplicationsOutput {
                simulation_application_summaries: self.simulation_application_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSimulationApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListSimulationApplicationsOutput`](crate::output::ListSimulationApplicationsOutput)
    pub fn builder() -> crate::output::list_simulation_applications_output::Builder {
        crate::output::list_simulation_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRobotsOutput {
    /// <p>A list of robots that meet the criteria of the request.</p>
    pub robots: std::option::Option<std::vec::Vec<crate::model::Robot>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListRobots</code> again and assign that token to the
    /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
    /// previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRobotsOutput {
    /// <p>A list of robots that meet the criteria of the request.</p>
    pub fn robots(&self) -> std::option::Option<&[crate::model::Robot]> {
        self.robots.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListRobots</code> again and assign that token to the
    /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
    /// previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRobotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRobotsOutput");
        formatter.field("robots", &self.robots);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRobotsOutput`](crate::output::ListRobotsOutput)
pub mod list_robots_output {
    /// A builder for [`ListRobotsOutput`](crate::output::ListRobotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) robots: std::option::Option<std::vec::Vec<crate::model::Robot>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `robots`.
        ///
        /// To override the contents of this collection use [`set_robots`](Self::set_robots).
        ///
        /// <p>A list of robots that meet the criteria of the request.</p>
        pub fn robots(mut self, input: impl Into<crate::model::Robot>) -> Self {
            let mut v = self.robots.unwrap_or_default();
            v.push(input.into());
            self.robots = Some(v);
            self
        }
        /// <p>A list of robots that meet the criteria of the request.</p>
        pub fn set_robots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Robot>>,
        ) -> Self {
            self.robots = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListRobots</code> again and assign that token to the
        /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
        /// previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListRobots</code> again and assign that token to the
        /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
        /// previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRobotsOutput`](crate::output::ListRobotsOutput)
        pub fn build(self) -> crate::output::ListRobotsOutput {
            crate::output::ListRobotsOutput {
                robots: self.robots,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRobotsOutput {
    /// Creates a new builder-style object to manufacture [`ListRobotsOutput`](crate::output::ListRobotsOutput)
    pub fn builder() -> crate::output::list_robots_output::Builder {
        crate::output::list_robots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRobotApplicationsOutput {
    /// <p>A list of robot application summaries that meet the criteria of the request.</p>
    pub robot_application_summaries:
        std::option::Option<std::vec::Vec<crate::model::RobotApplicationSummary>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListRobotApplications</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRobotApplicationsOutput {
    /// <p>A list of robot application summaries that meet the criteria of the request.</p>
    pub fn robot_application_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::RobotApplicationSummary]> {
        self.robot_application_summaries.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListRobotApplications</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRobotApplicationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRobotApplicationsOutput");
        formatter.field(
            "robot_application_summaries",
            &self.robot_application_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRobotApplicationsOutput`](crate::output::ListRobotApplicationsOutput)
pub mod list_robot_applications_output {
    /// A builder for [`ListRobotApplicationsOutput`](crate::output::ListRobotApplicationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) robot_application_summaries:
            std::option::Option<std::vec::Vec<crate::model::RobotApplicationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `robot_application_summaries`.
        ///
        /// To override the contents of this collection use [`set_robot_application_summaries`](Self::set_robot_application_summaries).
        ///
        /// <p>A list of robot application summaries that meet the criteria of the request.</p>
        pub fn robot_application_summaries(
            mut self,
            input: impl Into<crate::model::RobotApplicationSummary>,
        ) -> Self {
            let mut v = self.robot_application_summaries.unwrap_or_default();
            v.push(input.into());
            self.robot_application_summaries = Some(v);
            self
        }
        /// <p>A list of robot application summaries that meet the criteria of the request.</p>
        pub fn set_robot_application_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotApplicationSummary>>,
        ) -> Self {
            self.robot_application_summaries = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListRobotApplications</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListRobotApplications</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRobotApplicationsOutput`](crate::output::ListRobotApplicationsOutput)
        pub fn build(self) -> crate::output::ListRobotApplicationsOutput {
            crate::output::ListRobotApplicationsOutput {
                robot_application_summaries: self.robot_application_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRobotApplicationsOutput {
    /// Creates a new builder-style object to manufacture [`ListRobotApplicationsOutput`](crate::output::ListRobotApplicationsOutput)
    pub fn builder() -> crate::output::list_robot_applications_output::Builder {
        crate::output::list_robot_applications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFleetsOutput {
    /// <p>A list of fleet details meeting the request criteria.</p>
    pub fleet_details: std::option::Option<std::vec::Vec<crate::model::Fleet>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListFleets</code> again and assign that token to the
    /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
    /// previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFleetsOutput {
    /// <p>A list of fleet details meeting the request criteria.</p>
    pub fn fleet_details(&self) -> std::option::Option<&[crate::model::Fleet]> {
        self.fleet_details.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListFleets</code> again and assign that token to the
    /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
    /// previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFleetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFleetsOutput");
        formatter.field("fleet_details", &self.fleet_details);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFleetsOutput`](crate::output::ListFleetsOutput)
pub mod list_fleets_output {
    /// A builder for [`ListFleetsOutput`](crate::output::ListFleetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_details: std::option::Option<std::vec::Vec<crate::model::Fleet>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleet_details`.
        ///
        /// To override the contents of this collection use [`set_fleet_details`](Self::set_fleet_details).
        ///
        /// <p>A list of fleet details meeting the request criteria.</p>
        pub fn fleet_details(mut self, input: impl Into<crate::model::Fleet>) -> Self {
            let mut v = self.fleet_details.unwrap_or_default();
            v.push(input.into());
            self.fleet_details = Some(v);
            self
        }
        /// <p>A list of fleet details meeting the request criteria.</p>
        pub fn set_fleet_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Fleet>>,
        ) -> Self {
            self.fleet_details = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListFleets</code> again and assign that token to the
        /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
        /// previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListFleets</code> again and assign that token to the
        /// request object's <code>nextToken</code> parameter. If there are no remaining results, the
        /// previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFleetsOutput`](crate::output::ListFleetsOutput)
        pub fn build(self) -> crate::output::ListFleetsOutput {
            crate::output::ListFleetsOutput {
                fleet_details: self.fleet_details,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFleetsOutput {
    /// Creates a new builder-style object to manufacture [`ListFleetsOutput`](crate::output::ListFleetsOutput)
    pub fn builder() -> crate::output::list_fleets_output::Builder {
        crate::output::list_fleets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeploymentJobsOutput {
    /// <p>A list of deployment jobs that meet the criteria of the request.</p>
    pub deployment_jobs: std::option::Option<std::vec::Vec<crate::model::DeploymentJob>>,
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListDeploymentJobs</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeploymentJobsOutput {
    /// <p>A list of deployment jobs that meet the criteria of the request.</p>
    pub fn deployment_jobs(&self) -> std::option::Option<&[crate::model::DeploymentJob]> {
        self.deployment_jobs.as_deref()
    }
    /// <p>If the previous paginated request did not return all of the remaining results, the
    /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
    /// next set of results, call <code>ListDeploymentJobs</code> again and assign that token to
    /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
    /// the previous response object's NextToken parameter is set to null. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeploymentJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeploymentJobsOutput");
        formatter.field("deployment_jobs", &self.deployment_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeploymentJobsOutput`](crate::output::ListDeploymentJobsOutput)
pub mod list_deployment_jobs_output {
    /// A builder for [`ListDeploymentJobsOutput`](crate::output::ListDeploymentJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deployment_jobs: std::option::Option<std::vec::Vec<crate::model::DeploymentJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `deployment_jobs`.
        ///
        /// To override the contents of this collection use [`set_deployment_jobs`](Self::set_deployment_jobs).
        ///
        /// <p>A list of deployment jobs that meet the criteria of the request.</p>
        pub fn deployment_jobs(mut self, input: impl Into<crate::model::DeploymentJob>) -> Self {
            let mut v = self.deployment_jobs.unwrap_or_default();
            v.push(input.into());
            self.deployment_jobs = Some(v);
            self
        }
        /// <p>A list of deployment jobs that meet the criteria of the request.</p>
        pub fn set_deployment_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentJob>>,
        ) -> Self {
            self.deployment_jobs = input;
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListDeploymentJobs</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous paginated request did not return all of the remaining results, the
        /// response object's <code>nextToken</code> parameter value is set to a token. To retrieve the
        /// next set of results, call <code>ListDeploymentJobs</code> again and assign that token to
        /// the request object's <code>nextToken</code> parameter. If there are no remaining results,
        /// the previous response object's NextToken parameter is set to null. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeploymentJobsOutput`](crate::output::ListDeploymentJobsOutput)
        pub fn build(self) -> crate::output::ListDeploymentJobsOutput {
            crate::output::ListDeploymentJobsOutput {
                deployment_jobs: self.deployment_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeploymentJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeploymentJobsOutput`](crate::output::ListDeploymentJobsOutput)
    pub fn builder() -> crate::output::list_deployment_jobs_output::Builder {
        crate::output::list_deployment_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorldTemplateBodyOutput {
    /// <p>The world template body.</p>
    pub template_body: std::option::Option<std::string::String>,
}
impl GetWorldTemplateBodyOutput {
    /// <p>The world template body.</p>
    pub fn template_body(&self) -> std::option::Option<&str> {
        self.template_body.as_deref()
    }
}
impl std::fmt::Debug for GetWorldTemplateBodyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorldTemplateBodyOutput");
        formatter.field("template_body", &self.template_body);
        formatter.finish()
    }
}
/// See [`GetWorldTemplateBodyOutput`](crate::output::GetWorldTemplateBodyOutput)
pub mod get_world_template_body_output {
    /// A builder for [`GetWorldTemplateBodyOutput`](crate::output::GetWorldTemplateBodyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_body: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The world template body.</p>
        pub fn template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_body = Some(input.into());
            self
        }
        /// <p>The world template body.</p>
        pub fn set_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.template_body = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorldTemplateBodyOutput`](crate::output::GetWorldTemplateBodyOutput)
        pub fn build(self) -> crate::output::GetWorldTemplateBodyOutput {
            crate::output::GetWorldTemplateBodyOutput {
                template_body: self.template_body,
            }
        }
    }
}
impl GetWorldTemplateBodyOutput {
    /// Creates a new builder-style object to manufacture [`GetWorldTemplateBodyOutput`](crate::output::GetWorldTemplateBodyOutput)
    pub fn builder() -> crate::output::get_world_template_body_output::Builder {
        crate::output::get_world_template_body_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the world template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The name of the world template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the world template was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A map that contains tag keys and tag values that are attached to the world
    /// template.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The version of the world template that you're using.</p>
    pub version: std::option::Option<std::string::String>,
}
impl DescribeWorldTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the world template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The name of the world template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world template was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world
    /// template.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The version of the world template that you're using.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorldTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldTemplateOutput");
        formatter.field("arn", &self.arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("name", &self.name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`DescribeWorldTemplateOutput`](crate::output::DescribeWorldTemplateOutput)
pub mod describe_world_template_output {
    /// A builder for [`DescribeWorldTemplateOutput`](crate::output::DescribeWorldTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The name of the world template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the world template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world
        /// template.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world
        /// template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The version of the world template that you're using.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the world template that you're using.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldTemplateOutput`](crate::output::DescribeWorldTemplateOutput)
        pub fn build(self) -> crate::output::DescribeWorldTemplateOutput {
            crate::output::DescribeWorldTemplateOutput {
                arn: self.arn,
                client_request_token: self.client_request_token,
                name: self.name,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
                version: self.version,
            }
        }
    }
}
impl DescribeWorldTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorldTemplateOutput`](crate::output::DescribeWorldTemplateOutput)
    pub fn builder() -> crate::output::describe_world_template_output::Builder {
        crate::output::describe_world_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldGenerationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world generation job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the world generation job:</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world generation job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world generation job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world generation job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world generation job failed. See <code>failureCode</code> for more
    /// information. </p>
    /// </dd>
    /// <dt>PartialFailed</dt>
    /// <dd>
    /// <p>Some worlds did not generate.</p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world generation job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world generation job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::WorldGenerationJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the world generation job was
    /// created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The failure code of the world generation job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
    /// <p>The reason why the world generation job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>Information about the world count.</p>
    pub world_count: std::option::Option<crate::model::WorldCount>,
    /// <p>Summary information about finished worlds.</p>
    pub finished_worlds_summary: std::option::Option<crate::model::FinishedWorldsSummary>,
    /// <p>A map that contains tag keys and tag values that are attached to the world generation
    /// job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A map that contains tag keys and tag values that are attached to the generated
    /// worlds.</p>
    pub world_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeWorldGenerationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world generation job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the world generation job:</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world generation job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world generation job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world generation job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world generation job failed. See <code>failureCode</code> for more
    /// information. </p>
    /// </dd>
    /// <dt>PartialFailed</dt>
    /// <dd>
    /// <p>Some worlds did not generate.</p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world generation job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world generation job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::WorldGenerationJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world generation job was
    /// created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The failure code of the world generation job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::WorldGenerationJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The reason why the world generation job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>Information about the world count.</p>
    pub fn world_count(&self) -> std::option::Option<&crate::model::WorldCount> {
        self.world_count.as_ref()
    }
    /// <p>Summary information about finished worlds.</p>
    pub fn finished_worlds_summary(
        &self,
    ) -> std::option::Option<&crate::model::FinishedWorldsSummary> {
        self.finished_worlds_summary.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world generation
    /// job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the generated
    /// worlds.</p>
    pub fn world_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.world_tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorldGenerationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldGenerationJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("template", &self.template);
        formatter.field("world_count", &self.world_count);
        formatter.field("finished_worlds_summary", &self.finished_worlds_summary);
        formatter.field("tags", &self.tags);
        formatter.field("world_tags", &self.world_tags);
        formatter.finish()
    }
}
/// See [`DescribeWorldGenerationJobOutput`](crate::output::DescribeWorldGenerationJobOutput)
pub mod describe_world_generation_job_output {
    /// A builder for [`DescribeWorldGenerationJobOutput`](crate::output::DescribeWorldGenerationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorldGenerationJobStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_code: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) world_count: std::option::Option<crate::model::WorldCount>,
        pub(crate) finished_worlds_summary:
            std::option::Option<crate::model::FinishedWorldsSummary>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) world_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world generation job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world generation job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the world generation job:</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world generation job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world generation job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world generation job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world generation job failed. See <code>failureCode</code> for more
        /// information. </p>
        /// </dd>
        /// <dt>PartialFailed</dt>
        /// <dd>
        /// <p>Some worlds did not generate.</p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world generation job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world generation job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::WorldGenerationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the world generation job:</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world generation job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world generation job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world generation job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world generation job failed. See <code>failureCode</code> for more
        /// information. </p>
        /// </dd>
        /// <dt>PartialFailed</dt>
        /// <dd>
        /// <p>Some worlds did not generate.</p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world generation job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world generation job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorldGenerationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world generation job was
        /// created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world generation job was
        /// created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The failure code of the world generation job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::WorldGenerationJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the world generation job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The reason why the world generation job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason why the world generation job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>Information about the world count.</p>
        pub fn world_count(mut self, input: crate::model::WorldCount) -> Self {
            self.world_count = Some(input);
            self
        }
        /// <p>Information about the world count.</p>
        pub fn set_world_count(
            mut self,
            input: std::option::Option<crate::model::WorldCount>,
        ) -> Self {
            self.world_count = input;
            self
        }
        /// <p>Summary information about finished worlds.</p>
        pub fn finished_worlds_summary(
            mut self,
            input: crate::model::FinishedWorldsSummary,
        ) -> Self {
            self.finished_worlds_summary = Some(input);
            self
        }
        /// <p>Summary information about finished worlds.</p>
        pub fn set_finished_worlds_summary(
            mut self,
            input: std::option::Option<crate::model::FinishedWorldsSummary>,
        ) -> Self {
            self.finished_worlds_summary = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world generation
        /// job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world generation
        /// job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `world_tags`.
        ///
        /// To override the contents of this collection use [`set_world_tags`](Self::set_world_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the generated
        /// worlds.</p>
        pub fn world_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.world_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.world_tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the generated
        /// worlds.</p>
        pub fn set_world_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.world_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldGenerationJobOutput`](crate::output::DescribeWorldGenerationJobOutput)
        pub fn build(self) -> crate::output::DescribeWorldGenerationJobOutput {
            crate::output::DescribeWorldGenerationJobOutput {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
                client_request_token: self.client_request_token,
                template: self.template,
                world_count: self.world_count,
                finished_worlds_summary: self.finished_worlds_summary,
                tags: self.tags,
                world_tags: self.world_tags,
            }
        }
    }
}
impl DescribeWorldGenerationJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorldGenerationJobOutput`](crate::output::DescribeWorldGenerationJobOutput)
    pub fn builder() -> crate::output::describe_world_generation_job_output::Builder {
        crate::output::describe_world_generation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the world export job.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world export job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world export job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world export job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world export job failed. See <code>failureCode</code> and
    /// <code>failureReason</code> for more information. </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world export job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world export job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::WorldExportJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The failure code of the world export job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::WorldExportJobErrorCode>,
    /// <p>The reason why the world export job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to be exported.</p>
    pub worlds: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The output location.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
    /// the export.</p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to the world export
    /// job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeWorldExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the world export job.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world export job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world export job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world export job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world export job failed. See <code>failureCode</code> and
    /// <code>failureReason</code> for more information. </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world export job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world export job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::WorldExportJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The failure code of the world export job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::WorldExportJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The reason why the world export job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to be exported.</p>
    pub fn worlds(&self) -> std::option::Option<&[std::string::String]> {
        self.worlds.as_deref()
    }
    /// <p>The output location.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
    /// the export.</p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world export
    /// job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorldExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldExportJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("worlds", &self.worlds);
        formatter.field("output_location", &self.output_location);
        formatter.field("iam_role", &self.iam_role);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeWorldExportJobOutput`](crate::output::DescribeWorldExportJobOutput)
pub mod describe_world_export_job_output {
    /// A builder for [`DescribeWorldExportJobOutput`](crate::output::DescribeWorldExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorldExportJobStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_code: std::option::Option<crate::model::WorldExportJobErrorCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) worlds: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the world export job.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world export job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world export job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world export job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world export job failed. See <code>failureCode</code> and
        /// <code>failureReason</code> for more information. </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world export job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world export job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::WorldExportJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the world export job.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world export job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world export job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world export job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world export job failed. See <code>failureCode</code> and
        /// <code>failureReason</code> for more information. </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world export job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world export job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorldExportJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The failure code of the world export job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::WorldExportJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the world export job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::WorldExportJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The reason why the world export job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason why the world export job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `worlds`.
        ///
        /// To override the contents of this collection use [`set_worlds`](Self::set_worlds).
        ///
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to be exported.</p>
        pub fn worlds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.worlds.unwrap_or_default();
            v.push(input.into());
            self.worlds = Some(v);
            self
        }
        /// <p>A list of Amazon Resource Names (arns) that correspond to worlds to be exported.</p>
        pub fn set_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.worlds = input;
            self
        }
        /// <p>The output location.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>The output location.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
        /// the export.</p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
        /// the export.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world export
        /// job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world export
        /// job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldExportJobOutput`](crate::output::DescribeWorldExportJobOutput)
        pub fn build(self) -> crate::output::DescribeWorldExportJobOutput {
            crate::output::DescribeWorldExportJobOutput {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
                client_request_token: self.client_request_token,
                worlds: self.worlds,
                output_location: self.output_location,
                iam_role: self.iam_role,
                tags: self.tags,
            }
        }
    }
}
impl DescribeWorldExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorldExportJobOutput`](crate::output::DescribeWorldExportJobOutput)
    pub fn builder() -> crate::output::describe_world_export_job_output::Builder {
        crate::output::describe_world_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorldOutput {
    /// <p>The Amazon Resource Name (arn) of the world.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the world generation job that generated the
    /// world.</p>
    pub generation_job: std::option::Option<std::string::String>,
    /// <p>The world template.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A map that contains tag keys and tag values that are attached to the world.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Returns the JSON formatted string that describes the contents of your world.</p>
    pub world_description_body: std::option::Option<std::string::String>,
}
impl DescribeWorldOutput {
    /// <p>The Amazon Resource Name (arn) of the world.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the world generation job that generated the
    /// world.</p>
    pub fn generation_job(&self) -> std::option::Option<&str> {
        self.generation_job.as_deref()
    }
    /// <p>The world template.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Returns the JSON formatted string that describes the contents of your world.</p>
    pub fn world_description_body(&self) -> std::option::Option<&str> {
        self.world_description_body.as_deref()
    }
}
impl std::fmt::Debug for DescribeWorldOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorldOutput");
        formatter.field("arn", &self.arn);
        formatter.field("generation_job", &self.generation_job);
        formatter.field("template", &self.template);
        formatter.field("created_at", &self.created_at);
        formatter.field("tags", &self.tags);
        formatter.field("world_description_body", &self.world_description_body);
        formatter.finish()
    }
}
/// See [`DescribeWorldOutput`](crate::output::DescribeWorldOutput)
pub mod describe_world_output {
    /// A builder for [`DescribeWorldOutput`](crate::output::DescribeWorldOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) generation_job: std::option::Option<std::string::String>,
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) world_description_body: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (arn) of the world.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generation job that generated the
        /// world.</p>
        pub fn generation_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world generation job that generated the
        /// world.</p>
        pub fn set_generation_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_job = input;
            self
        }
        /// <p>The world template.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The world template.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Returns the JSON formatted string that describes the contents of your world.</p>
        pub fn world_description_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.world_description_body = Some(input.into());
            self
        }
        /// <p>Returns the JSON formatted string that describes the contents of your world.</p>
        pub fn set_world_description_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.world_description_body = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorldOutput`](crate::output::DescribeWorldOutput)
        pub fn build(self) -> crate::output::DescribeWorldOutput {
            crate::output::DescribeWorldOutput {
                arn: self.arn,
                generation_job: self.generation_job,
                template: self.template,
                created_at: self.created_at,
                tags: self.tags,
                world_description_body: self.world_description_body,
            }
        }
    }
}
impl DescribeWorldOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorldOutput`](crate::output::DescribeWorldOutput)
    pub fn builder() -> crate::output::describe_world_output::Builder {
        crate::output::describe_world_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSimulationJobBatchOutput {
    /// <p>The Amazon Resource Name (ARN) of the batch.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the batch.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The simulation job batch request is pending.</p>
    /// </dd>
    /// <dt>InProgress</dt>
    /// <dd>
    /// <p>The simulation job batch is in progress. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The simulation job batch failed. One or more simulation job requests could not
    /// be completed due to an internal failure (like <code>InternalServiceError</code>).
    /// See <code>failureCode</code> and <code>failureReason</code> for more
    /// information.</p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The simulation batch job completed. A batch is complete when (1) there are no
    /// pending simulation job requests in the batch and none of the failed simulation job
    /// requests are due to <code>InternalServiceError</code> and (2) when all created
    /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
    /// or <code>Failed</code>). </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The simulation batch job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The simulation batch job is being cancelled.</p>
    /// </dd>
    /// <dt>Completing</dt>
    /// <dd>
    /// <p>The simulation batch job is completing.</p>
    /// </dd>
    /// <dt>TimingOut</dt>
    /// <dd>
    /// <p>The simulation job batch is timing out.</p>
    /// <p>If a batch timing out, and there are pending requests that were failing due to
    /// an internal failure (like <code>InternalServiceError</code>), the batch status
    /// will be <code>Failed</code>. If there are no such failing request, the batch
    /// status will be <code>TimedOut</code>. </p>
    /// </dd>
    /// <dt>TimedOut</dt>
    /// <dd>
    /// <p>The simulation batch job timed out.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::SimulationJobBatchStatus>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
    /// created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The batch policy.</p>
    pub batch_policy: std::option::Option<crate::model::BatchPolicy>,
    /// <p>The failure code of the simulation job batch.</p>
    pub failure_code: std::option::Option<crate::model::SimulationJobBatchErrorCode>,
    /// <p>The reason the simulation job batch failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>A list of failed create simulation job requests. The request failed to be created into a
    /// simulation job. Failed requests do not have a simulation job ID. </p>
    pub failed_requests:
        std::option::Option<std::vec::Vec<crate::model::FailedCreateSimulationJobRequest>>,
    /// <p>A list of pending simulation job requests. These requests have not yet been created into
    /// simulation jobs.</p>
    pub pending_requests: std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
    /// <p>A list of created simulation job summaries.</p>
    pub created_requests: std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job
    /// batch.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeSimulationJobBatchOutput {
    /// <p>The Amazon Resource Name (ARN) of the batch.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the batch.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The simulation job batch request is pending.</p>
    /// </dd>
    /// <dt>InProgress</dt>
    /// <dd>
    /// <p>The simulation job batch is in progress. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The simulation job batch failed. One or more simulation job requests could not
    /// be completed due to an internal failure (like <code>InternalServiceError</code>).
    /// See <code>failureCode</code> and <code>failureReason</code> for more
    /// information.</p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The simulation batch job completed. A batch is complete when (1) there are no
    /// pending simulation job requests in the batch and none of the failed simulation job
    /// requests are due to <code>InternalServiceError</code> and (2) when all created
    /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
    /// or <code>Failed</code>). </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The simulation batch job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The simulation batch job is being cancelled.</p>
    /// </dd>
    /// <dt>Completing</dt>
    /// <dd>
    /// <p>The simulation batch job is completing.</p>
    /// </dd>
    /// <dt>TimingOut</dt>
    /// <dd>
    /// <p>The simulation job batch is timing out.</p>
    /// <p>If a batch timing out, and there are pending requests that were failing due to
    /// an internal failure (like <code>InternalServiceError</code>), the batch status
    /// will be <code>Failed</code>. If there are no such failing request, the batch
    /// status will be <code>TimedOut</code>. </p>
    /// </dd>
    /// <dt>TimedOut</dt>
    /// <dd>
    /// <p>The simulation batch job timed out.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::SimulationJobBatchStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
    /// created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The batch policy.</p>
    pub fn batch_policy(&self) -> std::option::Option<&crate::model::BatchPolicy> {
        self.batch_policy.as_ref()
    }
    /// <p>The failure code of the simulation job batch.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::SimulationJobBatchErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The reason the simulation job batch failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>A list of failed create simulation job requests. The request failed to be created into a
    /// simulation job. Failed requests do not have a simulation job ID. </p>
    pub fn failed_requests(
        &self,
    ) -> std::option::Option<&[crate::model::FailedCreateSimulationJobRequest]> {
        self.failed_requests.as_deref()
    }
    /// <p>A list of pending simulation job requests. These requests have not yet been created into
    /// simulation jobs.</p>
    pub fn pending_requests(&self) -> std::option::Option<&[crate::model::SimulationJobRequest]> {
        self.pending_requests.as_deref()
    }
    /// <p>A list of created simulation job summaries.</p>
    pub fn created_requests(&self) -> std::option::Option<&[crate::model::SimulationJobSummary]> {
        self.created_requests.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the simulation job
    /// batch.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeSimulationJobBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSimulationJobBatchOutput");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("created_at", &self.created_at);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("batch_policy", &self.batch_policy);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failed_requests", &self.failed_requests);
        formatter.field("pending_requests", &self.pending_requests);
        formatter.field("created_requests", &self.created_requests);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeSimulationJobBatchOutput`](crate::output::DescribeSimulationJobBatchOutput)
pub mod describe_simulation_job_batch_output {
    /// A builder for [`DescribeSimulationJobBatchOutput`](crate::output::DescribeSimulationJobBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SimulationJobBatchStatus>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) batch_policy: std::option::Option<crate::model::BatchPolicy>,
        pub(crate) failure_code: std::option::Option<crate::model::SimulationJobBatchErrorCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failed_requests:
            std::option::Option<std::vec::Vec<crate::model::FailedCreateSimulationJobRequest>>,
        pub(crate) pending_requests:
            std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
        pub(crate) created_requests:
            std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the batch.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the batch.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the batch.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The simulation job batch request is pending.</p>
        /// </dd>
        /// <dt>InProgress</dt>
        /// <dd>
        /// <p>The simulation job batch is in progress. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The simulation job batch failed. One or more simulation job requests could not
        /// be completed due to an internal failure (like <code>InternalServiceError</code>).
        /// See <code>failureCode</code> and <code>failureReason</code> for more
        /// information.</p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The simulation batch job completed. A batch is complete when (1) there are no
        /// pending simulation job requests in the batch and none of the failed simulation job
        /// requests are due to <code>InternalServiceError</code> and (2) when all created
        /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
        /// or <code>Failed</code>). </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The simulation batch job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The simulation batch job is being cancelled.</p>
        /// </dd>
        /// <dt>Completing</dt>
        /// <dd>
        /// <p>The simulation batch job is completing.</p>
        /// </dd>
        /// <dt>TimingOut</dt>
        /// <dd>
        /// <p>The simulation job batch is timing out.</p>
        /// <p>If a batch timing out, and there are pending requests that were failing due to
        /// an internal failure (like <code>InternalServiceError</code>), the batch status
        /// will be <code>Failed</code>. If there are no such failing request, the batch
        /// status will be <code>TimedOut</code>. </p>
        /// </dd>
        /// <dt>TimedOut</dt>
        /// <dd>
        /// <p>The simulation batch job timed out.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::SimulationJobBatchStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the batch.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The simulation job batch request is pending.</p>
        /// </dd>
        /// <dt>InProgress</dt>
        /// <dd>
        /// <p>The simulation job batch is in progress. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The simulation job batch failed. One or more simulation job requests could not
        /// be completed due to an internal failure (like <code>InternalServiceError</code>).
        /// See <code>failureCode</code> and <code>failureReason</code> for more
        /// information.</p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The simulation batch job completed. A batch is complete when (1) there are no
        /// pending simulation job requests in the batch and none of the failed simulation job
        /// requests are due to <code>InternalServiceError</code> and (2) when all created
        /// simulation jobs have reached a terminal state (for example, <code>Completed</code>
        /// or <code>Failed</code>). </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The simulation batch job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The simulation batch job is being cancelled.</p>
        /// </dd>
        /// <dt>Completing</dt>
        /// <dd>
        /// <p>The simulation batch job is completing.</p>
        /// </dd>
        /// <dt>TimingOut</dt>
        /// <dd>
        /// <p>The simulation job batch is timing out.</p>
        /// <p>If a batch timing out, and there are pending requests that were failing due to
        /// an internal failure (like <code>InternalServiceError</code>), the batch status
        /// will be <code>Failed</code>. If there are no such failing request, the batch
        /// status will be <code>TimedOut</code>. </p>
        /// </dd>
        /// <dt>TimedOut</dt>
        /// <dd>
        /// <p>The simulation batch job timed out.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SimulationJobBatchStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
        /// created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job batch was
        /// created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The batch policy.</p>
        pub fn batch_policy(mut self, input: crate::model::BatchPolicy) -> Self {
            self.batch_policy = Some(input);
            self
        }
        /// <p>The batch policy.</p>
        pub fn set_batch_policy(
            mut self,
            input: std::option::Option<crate::model::BatchPolicy>,
        ) -> Self {
            self.batch_policy = input;
            self
        }
        /// <p>The failure code of the simulation job batch.</p>
        pub fn failure_code(mut self, input: crate::model::SimulationJobBatchErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the simulation job batch.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::SimulationJobBatchErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The reason the simulation job batch failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason the simulation job batch failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Appends an item to `failed_requests`.
        ///
        /// To override the contents of this collection use [`set_failed_requests`](Self::set_failed_requests).
        ///
        /// <p>A list of failed create simulation job requests. The request failed to be created into a
        /// simulation job. Failed requests do not have a simulation job ID. </p>
        pub fn failed_requests(
            mut self,
            input: impl Into<crate::model::FailedCreateSimulationJobRequest>,
        ) -> Self {
            let mut v = self.failed_requests.unwrap_or_default();
            v.push(input.into());
            self.failed_requests = Some(v);
            self
        }
        /// <p>A list of failed create simulation job requests. The request failed to be created into a
        /// simulation job. Failed requests do not have a simulation job ID. </p>
        pub fn set_failed_requests(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::FailedCreateSimulationJobRequest>,
            >,
        ) -> Self {
            self.failed_requests = input;
            self
        }
        /// Appends an item to `pending_requests`.
        ///
        /// To override the contents of this collection use [`set_pending_requests`](Self::set_pending_requests).
        ///
        /// <p>A list of pending simulation job requests. These requests have not yet been created into
        /// simulation jobs.</p>
        pub fn pending_requests(
            mut self,
            input: impl Into<crate::model::SimulationJobRequest>,
        ) -> Self {
            let mut v = self.pending_requests.unwrap_or_default();
            v.push(input.into());
            self.pending_requests = Some(v);
            self
        }
        /// <p>A list of pending simulation job requests. These requests have not yet been created into
        /// simulation jobs.</p>
        pub fn set_pending_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobRequest>>,
        ) -> Self {
            self.pending_requests = input;
            self
        }
        /// Appends an item to `created_requests`.
        ///
        /// To override the contents of this collection use [`set_created_requests`](Self::set_created_requests).
        ///
        /// <p>A list of created simulation job summaries.</p>
        pub fn created_requests(
            mut self,
            input: impl Into<crate::model::SimulationJobSummary>,
        ) -> Self {
            let mut v = self.created_requests.unwrap_or_default();
            v.push(input.into());
            self.created_requests = Some(v);
            self
        }
        /// <p>A list of created simulation job summaries.</p>
        pub fn set_created_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJobSummary>>,
        ) -> Self {
            self.created_requests = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job
        /// batch.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the simulation job
        /// batch.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSimulationJobBatchOutput`](crate::output::DescribeSimulationJobBatchOutput)
        pub fn build(self) -> crate::output::DescribeSimulationJobBatchOutput {
            crate::output::DescribeSimulationJobBatchOutput {
                arn: self.arn,
                status: self.status,
                last_updated_at: self.last_updated_at,
                created_at: self.created_at,
                client_request_token: self.client_request_token,
                batch_policy: self.batch_policy,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
                failed_requests: self.failed_requests,
                pending_requests: self.pending_requests,
                created_requests: self.created_requests,
                tags: self.tags,
            }
        }
    }
}
impl DescribeSimulationJobBatchOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSimulationJobBatchOutput`](crate::output::DescribeSimulationJobBatchOutput)
    pub fn builder() -> crate::output::describe_simulation_job_batch_output::Builder {
        crate::output::describe_simulation_job_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSimulationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the simulation job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the simulation job.</p>
    pub status: std::option::Option<crate::model::SimulationJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// started.</p>
    pub last_started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The failure behavior for the simulation job.</p>
    pub failure_behavior: std::option::Option<crate::model::FailureBehavior>,
    /// <p>The failure code of the simulation job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>RobotApplicationCrash</dt>
    /// <dd>
    /// <p>Robot application exited abnormally.</p>
    /// </dd>
    /// <dt>SimulationApplicationCrash</dt>
    /// <dd>
    /// <p> Simulation application exited abnormally.</p>
    /// </dd>
    /// <dt>BadPermissionsRobotApplication</dt>
    /// <dd>
    /// <p>Robot application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsS3Output</dt>
    /// <dd>
    /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
    /// </dd>
    /// <dt>BadPermissionsCloudwatchLogs</dt>
    /// <dd>
    /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
    /// </dd>
    /// <dt>SubnetIpLimitExceeded</dt>
    /// <dd>
    /// <p>Subnet IP limit exceeded.</p>
    /// </dd>
    /// <dt>ENILimitExceeded</dt>
    /// <dd>
    /// <p>ENI limit exceeded.</p>
    /// </dd>
    /// <dt>BadPermissionsUserCredentials</dt>
    /// <dd>
    /// <p>Unable to use the Role provided.</p>
    /// </dd>
    /// <dt>InvalidBundleRobotApplication</dt>
    /// <dd>
    /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>InvalidBundleSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>RobotApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for RobotApplication does not match value during version creation.</p>
    /// </dd>
    /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for SimulationApplication does not match value during version
    /// creation.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
    /// <p>Details about why the simulation job failed. For more information about troubleshooting,
    /// see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Location for output files generated by the simulation job.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The logging configuration.</p>
    pub logging_config: std::option::Option<crate::model::LoggingConfig>,
    /// <p>The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or
    /// less.</p>
    pub max_job_duration_in_seconds: i64,
    /// <p>The simulation job execution duration in milliseconds.</p>
    pub simulation_time_millis: i64,
    /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified
    /// in its associated policies on your behalf.</p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>A list of robot applications.</p>
    pub robot_applications:
        std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
    /// <p>A list of simulation applications.</p>
    pub simulation_applications:
        std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
    /// <p>The data sources for the simulation job.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>The list of all tags added to the specified simulation job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The VPC configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The network interface information for the simulation job.</p>
    pub network_interface: std::option::Option<crate::model::NetworkInterface>,
    /// <p>Compute information for the simulation job.</p>
    pub compute: std::option::Option<crate::model::ComputeResponse>,
}
impl DescribeSimulationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the simulation job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the simulation job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SimulationJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// started.</p>
    pub fn last_started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_started_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The failure behavior for the simulation job.</p>
    pub fn failure_behavior(&self) -> std::option::Option<&crate::model::FailureBehavior> {
        self.failure_behavior.as_ref()
    }
    /// <p>The failure code of the simulation job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>RobotApplicationCrash</dt>
    /// <dd>
    /// <p>Robot application exited abnormally.</p>
    /// </dd>
    /// <dt>SimulationApplicationCrash</dt>
    /// <dd>
    /// <p> Simulation application exited abnormally.</p>
    /// </dd>
    /// <dt>BadPermissionsRobotApplication</dt>
    /// <dd>
    /// <p>Robot application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsS3Output</dt>
    /// <dd>
    /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
    /// </dd>
    /// <dt>BadPermissionsCloudwatchLogs</dt>
    /// <dd>
    /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
    /// </dd>
    /// <dt>SubnetIpLimitExceeded</dt>
    /// <dd>
    /// <p>Subnet IP limit exceeded.</p>
    /// </dd>
    /// <dt>ENILimitExceeded</dt>
    /// <dd>
    /// <p>ENI limit exceeded.</p>
    /// </dd>
    /// <dt>BadPermissionsUserCredentials</dt>
    /// <dd>
    /// <p>Unable to use the Role provided.</p>
    /// </dd>
    /// <dt>InvalidBundleRobotApplication</dt>
    /// <dd>
    /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>InvalidBundleSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>RobotApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for RobotApplication does not match value during version creation.</p>
    /// </dd>
    /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for SimulationApplication does not match value during version
    /// creation.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::SimulationJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>Details about why the simulation job failed. For more information about troubleshooting,
    /// see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Location for output files generated by the simulation job.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The logging configuration.</p>
    pub fn logging_config(&self) -> std::option::Option<&crate::model::LoggingConfig> {
        self.logging_config.as_ref()
    }
    /// <p>The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or
    /// less.</p>
    pub fn max_job_duration_in_seconds(&self) -> i64 {
        self.max_job_duration_in_seconds
    }
    /// <p>The simulation job execution duration in milliseconds.</p>
    pub fn simulation_time_millis(&self) -> i64 {
        self.simulation_time_millis
    }
    /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified
    /// in its associated policies on your behalf.</p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>A list of robot applications.</p>
    pub fn robot_applications(
        &self,
    ) -> std::option::Option<&[crate::model::RobotApplicationConfig]> {
        self.robot_applications.as_deref()
    }
    /// <p>A list of simulation applications.</p>
    pub fn simulation_applications(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationApplicationConfig]> {
        self.simulation_applications.as_deref()
    }
    /// <p>The data sources for the simulation job.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.data_sources.as_deref()
    }
    /// <p>The list of all tags added to the specified simulation job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The VPC configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>The network interface information for the simulation job.</p>
    pub fn network_interface(&self) -> std::option::Option<&crate::model::NetworkInterface> {
        self.network_interface.as_ref()
    }
    /// <p>Compute information for the simulation job.</p>
    pub fn compute(&self) -> std::option::Option<&crate::model::ComputeResponse> {
        self.compute.as_ref()
    }
}
impl std::fmt::Debug for DescribeSimulationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSimulationJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("last_started_at", &self.last_started_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("failure_behavior", &self.failure_behavior);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("output_location", &self.output_location);
        formatter.field("logging_config", &self.logging_config);
        formatter.field(
            "max_job_duration_in_seconds",
            &self.max_job_duration_in_seconds,
        );
        formatter.field("simulation_time_millis", &self.simulation_time_millis);
        formatter.field("iam_role", &self.iam_role);
        formatter.field("robot_applications", &self.robot_applications);
        formatter.field("simulation_applications", &self.simulation_applications);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("network_interface", &self.network_interface);
        formatter.field("compute", &self.compute);
        formatter.finish()
    }
}
/// See [`DescribeSimulationJobOutput`](crate::output::DescribeSimulationJobOutput)
pub mod describe_simulation_job_output {
    /// A builder for [`DescribeSimulationJobOutput`](crate::output::DescribeSimulationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SimulationJobStatus>,
        pub(crate) last_started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_behavior: std::option::Option<crate::model::FailureBehavior>,
        pub(crate) failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) logging_config: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) max_job_duration_in_seconds: std::option::Option<i64>,
        pub(crate) simulation_time_millis: std::option::Option<i64>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) robot_applications:
            std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        pub(crate) simulation_applications:
            std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) network_interface: std::option::Option<crate::model::NetworkInterface>,
        pub(crate) compute: std::option::Option<crate::model::ComputeResponse>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the simulation job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the simulation job.</p>
        pub fn status(mut self, input: crate::model::SimulationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the simulation job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SimulationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// started.</p>
        pub fn last_started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_started_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// started.</p>
        pub fn set_last_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_started_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The failure behavior for the simulation job.</p>
        pub fn failure_behavior(mut self, input: crate::model::FailureBehavior) -> Self {
            self.failure_behavior = Some(input);
            self
        }
        /// <p>The failure behavior for the simulation job.</p>
        pub fn set_failure_behavior(
            mut self,
            input: std::option::Option<crate::model::FailureBehavior>,
        ) -> Self {
            self.failure_behavior = input;
            self
        }
        /// <p>The failure code of the simulation job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>RobotApplicationCrash</dt>
        /// <dd>
        /// <p>Robot application exited abnormally.</p>
        /// </dd>
        /// <dt>SimulationApplicationCrash</dt>
        /// <dd>
        /// <p> Simulation application exited abnormally.</p>
        /// </dd>
        /// <dt>BadPermissionsRobotApplication</dt>
        /// <dd>
        /// <p>Robot application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsS3Output</dt>
        /// <dd>
        /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
        /// </dd>
        /// <dt>BadPermissionsCloudwatchLogs</dt>
        /// <dd>
        /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
        /// </dd>
        /// <dt>SubnetIpLimitExceeded</dt>
        /// <dd>
        /// <p>Subnet IP limit exceeded.</p>
        /// </dd>
        /// <dt>ENILimitExceeded</dt>
        /// <dd>
        /// <p>ENI limit exceeded.</p>
        /// </dd>
        /// <dt>BadPermissionsUserCredentials</dt>
        /// <dd>
        /// <p>Unable to use the Role provided.</p>
        /// </dd>
        /// <dt>InvalidBundleRobotApplication</dt>
        /// <dd>
        /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>InvalidBundleSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>RobotApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for RobotApplication does not match value during version creation.</p>
        /// </dd>
        /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for SimulationApplication does not match value during version
        /// creation.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::SimulationJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the simulation job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>RobotApplicationCrash</dt>
        /// <dd>
        /// <p>Robot application exited abnormally.</p>
        /// </dd>
        /// <dt>SimulationApplicationCrash</dt>
        /// <dd>
        /// <p> Simulation application exited abnormally.</p>
        /// </dd>
        /// <dt>BadPermissionsRobotApplication</dt>
        /// <dd>
        /// <p>Robot application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsS3Output</dt>
        /// <dd>
        /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
        /// </dd>
        /// <dt>BadPermissionsCloudwatchLogs</dt>
        /// <dd>
        /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
        /// </dd>
        /// <dt>SubnetIpLimitExceeded</dt>
        /// <dd>
        /// <p>Subnet IP limit exceeded.</p>
        /// </dd>
        /// <dt>ENILimitExceeded</dt>
        /// <dd>
        /// <p>ENI limit exceeded.</p>
        /// </dd>
        /// <dt>BadPermissionsUserCredentials</dt>
        /// <dd>
        /// <p>Unable to use the Role provided.</p>
        /// </dd>
        /// <dt>InvalidBundleRobotApplication</dt>
        /// <dd>
        /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>InvalidBundleSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>RobotApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for RobotApplication does not match value during version creation.</p>
        /// </dd>
        /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for SimulationApplication does not match value during version
        /// creation.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::SimulationJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>Details about why the simulation job failed. For more information about troubleshooting,
        /// see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>Details about why the simulation job failed. For more information about troubleshooting,
        /// see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Location for output files generated by the simulation job.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The logging configuration.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging_config = Some(input);
            self
        }
        /// <p>The logging configuration.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging_config = input;
            self
        }
        /// <p>The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or
        /// less.</p>
        pub fn max_job_duration_in_seconds(mut self, input: i64) -> Self {
            self.max_job_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or
        /// less.</p>
        pub fn set_max_job_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.max_job_duration_in_seconds = input;
            self
        }
        /// <p>The simulation job execution duration in milliseconds.</p>
        pub fn simulation_time_millis(mut self, input: i64) -> Self {
            self.simulation_time_millis = Some(input);
            self
        }
        /// <p>The simulation job execution duration in milliseconds.</p>
        pub fn set_simulation_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.simulation_time_millis = input;
            self
        }
        /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified
        /// in its associated policies on your behalf.</p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role that allows the simulation instance to call the AWS APIs that are specified
        /// in its associated policies on your behalf.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// Appends an item to `robot_applications`.
        ///
        /// To override the contents of this collection use [`set_robot_applications`](Self::set_robot_applications).
        ///
        /// <p>A list of robot applications.</p>
        pub fn robot_applications(
            mut self,
            input: impl Into<crate::model::RobotApplicationConfig>,
        ) -> Self {
            let mut v = self.robot_applications.unwrap_or_default();
            v.push(input.into());
            self.robot_applications = Some(v);
            self
        }
        /// <p>A list of robot applications.</p>
        pub fn set_robot_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        ) -> Self {
            self.robot_applications = input;
            self
        }
        /// Appends an item to `simulation_applications`.
        ///
        /// To override the contents of this collection use [`set_simulation_applications`](Self::set_simulation_applications).
        ///
        /// <p>A list of simulation applications.</p>
        pub fn simulation_applications(
            mut self,
            input: impl Into<crate::model::SimulationApplicationConfig>,
        ) -> Self {
            let mut v = self.simulation_applications.unwrap_or_default();
            v.push(input.into());
            self.simulation_applications = Some(v);
            self
        }
        /// <p>A list of simulation applications.</p>
        pub fn set_simulation_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        ) -> Self {
            self.simulation_applications = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>The data sources for the simulation job.</p>
        pub fn data_sources(mut self, input: impl Into<crate::model::DataSource>) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input.into());
            self.data_sources = Some(v);
            self
        }
        /// <p>The data sources for the simulation job.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified simulation job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified simulation job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The VPC configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The network interface information for the simulation job.</p>
        pub fn network_interface(mut self, input: crate::model::NetworkInterface) -> Self {
            self.network_interface = Some(input);
            self
        }
        /// <p>The network interface information for the simulation job.</p>
        pub fn set_network_interface(
            mut self,
            input: std::option::Option<crate::model::NetworkInterface>,
        ) -> Self {
            self.network_interface = input;
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn compute(mut self, input: crate::model::ComputeResponse) -> Self {
            self.compute = Some(input);
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn set_compute(
            mut self,
            input: std::option::Option<crate::model::ComputeResponse>,
        ) -> Self {
            self.compute = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSimulationJobOutput`](crate::output::DescribeSimulationJobOutput)
        pub fn build(self) -> crate::output::DescribeSimulationJobOutput {
            crate::output::DescribeSimulationJobOutput {
                arn: self.arn,
                name: self.name,
                status: self.status,
                last_started_at: self.last_started_at,
                last_updated_at: self.last_updated_at,
                failure_behavior: self.failure_behavior,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
                client_request_token: self.client_request_token,
                output_location: self.output_location,
                logging_config: self.logging_config,
                max_job_duration_in_seconds: self.max_job_duration_in_seconds.unwrap_or_default(),
                simulation_time_millis: self.simulation_time_millis.unwrap_or_default(),
                iam_role: self.iam_role,
                robot_applications: self.robot_applications,
                simulation_applications: self.simulation_applications,
                data_sources: self.data_sources,
                tags: self.tags,
                vpc_config: self.vpc_config,
                network_interface: self.network_interface,
                compute: self.compute,
            }
        }
    }
}
impl DescribeSimulationJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSimulationJobOutput`](crate::output::DescribeSimulationJobOutput)
    pub fn builder() -> crate::output::describe_simulation_job_output::Builder {
        crate::output::describe_simulation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSimulationApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot simulation application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the simulation application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the simulation application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the simulation application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The simulation software suite used by the simulation application.</p>
    pub simulation_software_suite: std::option::Option<crate::model::SimulationSoftwareSuite>,
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The rendering engine for the simulation application.</p>
    pub rendering_engine: std::option::Option<crate::model::RenderingEngine>,
    /// <p>The revision id of the simulation application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of all tags added to the specified simulation application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The object that contains the Docker image URI used to create the simulation
    /// application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
    /// <p>A SHA256 identifier for the Docker image that you use for your simulation
    /// application.</p>
    pub image_digest: std::option::Option<std::string::String>,
}
impl DescribeSimulationApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot simulation application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the simulation application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the simulation application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the simulation application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The simulation software suite used by the simulation application.</p>
    pub fn simulation_software_suite(
        &self,
    ) -> std::option::Option<&crate::model::SimulationSoftwareSuite> {
        self.simulation_software_suite.as_ref()
    }
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The rendering engine for the simulation application.</p>
    pub fn rendering_engine(&self) -> std::option::Option<&crate::model::RenderingEngine> {
        self.rendering_engine.as_ref()
    }
    /// <p>The revision id of the simulation application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The list of all tags added to the specified simulation application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The object that contains the Docker image URI used to create the simulation
    /// application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
    /// <p>A SHA256 identifier for the Docker image that you use for your simulation
    /// application.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
}
impl std::fmt::Debug for DescribeSimulationApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSimulationApplicationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("simulation_software_suite", &self.simulation_software_suite);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("rendering_engine", &self.rendering_engine);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.field("environment", &self.environment);
        formatter.field("image_digest", &self.image_digest);
        formatter.finish()
    }
}
/// See [`DescribeSimulationApplicationOutput`](crate::output::DescribeSimulationApplicationOutput)
pub mod describe_simulation_application_output {
    /// A builder for [`DescribeSimulationApplicationOutput`](crate::output::DescribeSimulationApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) simulation_software_suite:
            std::option::Option<crate::model::SimulationSoftwareSuite>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) rendering_engine: std::option::Option<crate::model::RenderingEngine>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot simulation application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot simulation application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.simulation_software_suite = Some(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.simulation_software_suite = input;
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.rendering_engine = Some(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.rendering_engine = input;
            self
        }
        /// <p>The revision id of the simulation application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision id of the simulation application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified simulation application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified simulation application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The object that contains the Docker image URI used to create the simulation
        /// application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI used to create the simulation
        /// application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your simulation
        /// application.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your simulation
        /// application.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSimulationApplicationOutput`](crate::output::DescribeSimulationApplicationOutput)
        pub fn build(self) -> crate::output::DescribeSimulationApplicationOutput {
            crate::output::DescribeSimulationApplicationOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                simulation_software_suite: self.simulation_software_suite,
                robot_software_suite: self.robot_software_suite,
                rendering_engine: self.rendering_engine,
                revision_id: self.revision_id,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
                environment: self.environment,
                image_digest: self.image_digest,
            }
        }
    }
}
impl DescribeSimulationApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSimulationApplicationOutput`](crate::output::DescribeSimulationApplicationOutput)
    pub fn builder() -> crate::output::describe_simulation_application_output::Builder {
        crate::output::describe_simulation_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRobotApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the robot application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the robot application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the robot application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The revision id of the robot application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of all tags added to the specified robot application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The object that contains the Docker image URI used to create the robot
    /// application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
    /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
    pub image_digest: std::option::Option<std::string::String>,
}
impl DescribeRobotApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the robot application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the robot application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the robot application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The revision id of the robot application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The list of all tags added to the specified robot application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The object that contains the Docker image URI used to create the robot
    /// application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
    /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
}
impl std::fmt::Debug for DescribeRobotApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRobotApplicationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.field("environment", &self.environment);
        formatter.field("image_digest", &self.image_digest);
        formatter.finish()
    }
}
/// See [`DescribeRobotApplicationOutput`](crate::output::DescribeRobotApplicationOutput)
pub mod describe_robot_application_output {
    /// A builder for [`DescribeRobotApplicationOutput`](crate::output::DescribeRobotApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified robot application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified robot application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The object that contains the Docker image URI used to create the robot
        /// application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI used to create the robot
        /// application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>A SHA256 identifier for the Docker image that you use for your robot application.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRobotApplicationOutput`](crate::output::DescribeRobotApplicationOutput)
        pub fn build(self) -> crate::output::DescribeRobotApplicationOutput {
            crate::output::DescribeRobotApplicationOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                robot_software_suite: self.robot_software_suite,
                revision_id: self.revision_id,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
                environment: self.environment,
                image_digest: self.image_digest,
            }
        }
    }
}
impl DescribeRobotApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRobotApplicationOutput`](crate::output::DescribeRobotApplicationOutput)
    pub fn builder() -> crate::output::describe_robot_application_output::Builder {
        crate::output::describe_robot_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the robot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet_arn: std::option::Option<std::string::String>,
    /// <p>The status of the fleet.</p>
    pub status: std::option::Option<crate::model::RobotStatus>,
    /// <p>The Greengrass group id.</p>
    pub greengrass_group_id: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The target architecture of the robot application.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub last_deployment_job: std::option::Option<std::string::String>,
    /// <p>The time of the last deployment job.</p>
    pub last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of all tags added to the specified robot.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the robot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet_arn(&self) -> std::option::Option<&str> {
        self.fleet_arn.as_deref()
    }
    /// <p>The status of the fleet.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RobotStatus> {
        self.status.as_ref()
    }
    /// <p>The Greengrass group id.</p>
    pub fn greengrass_group_id(&self) -> std::option::Option<&str> {
        self.greengrass_group_id.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The target architecture of the robot application.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub fn last_deployment_job(&self) -> std::option::Option<&str> {
        self.last_deployment_job.as_deref()
    }
    /// <p>The time of the last deployment job.</p>
    pub fn last_deployment_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_time.as_ref()
    }
    /// <p>The list of all tags added to the specified robot.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeRobotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRobotOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("fleet_arn", &self.fleet_arn);
        formatter.field("status", &self.status);
        formatter.field("greengrass_group_id", &self.greengrass_group_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("architecture", &self.architecture);
        formatter.field("last_deployment_job", &self.last_deployment_job);
        formatter.field("last_deployment_time", &self.last_deployment_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeRobotOutput`](crate::output::DescribeRobotOutput)
pub mod describe_robot_output {
    /// A builder for [`DescribeRobotOutput`](crate::output::DescribeRobotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) fleet_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RobotStatus>,
        pub(crate) greengrass_group_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
        pub(crate) last_deployment_job: std::option::Option<std::string::String>,
        pub(crate) last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the robot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_arn = input;
            self
        }
        /// <p>The status of the fleet.</p>
        pub fn status(mut self, input: crate::model::RobotStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the fleet.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::RobotStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The Greengrass group id.</p>
        pub fn greengrass_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.greengrass_group_id = Some(input.into());
            self
        }
        /// <p>The Greengrass group id.</p>
        pub fn set_greengrass_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_group_id = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The target architecture of the robot application.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The target architecture of the robot application.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn last_deployment_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_deployment_job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn set_last_deployment_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_job = input;
            self
        }
        /// <p>The time of the last deployment job.</p>
        pub fn last_deployment_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_time = Some(input);
            self
        }
        /// <p>The time of the last deployment job.</p>
        pub fn set_last_deployment_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified robot.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified robot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRobotOutput`](crate::output::DescribeRobotOutput)
        pub fn build(self) -> crate::output::DescribeRobotOutput {
            crate::output::DescribeRobotOutput {
                arn: self.arn,
                name: self.name,
                fleet_arn: self.fleet_arn,
                status: self.status,
                greengrass_group_id: self.greengrass_group_id,
                created_at: self.created_at,
                architecture: self.architecture,
                last_deployment_job: self.last_deployment_job,
                last_deployment_time: self.last_deployment_time,
                tags: self.tags,
            }
        }
    }
}
impl DescribeRobotOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRobotOutput`](crate::output::DescribeRobotOutput)
    pub fn builder() -> crate::output::describe_robot_output::Builder {
        crate::output::describe_robot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetOutput {
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A list of robots.</p>
    pub robots: std::option::Option<std::vec::Vec<crate::model::Robot>>,
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the last deployment.</p>
    pub last_deployment_status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub last_deployment_job: std::option::Option<std::string::String>,
    /// <p>The time of the last deployment.</p>
    pub last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of all tags added to the specified fleet.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeFleetOutput {
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A list of robots.</p>
    pub fn robots(&self) -> std::option::Option<&[crate::model::Robot]> {
        self.robots.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The status of the last deployment.</p>
    pub fn last_deployment_status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.last_deployment_status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
    pub fn last_deployment_job(&self) -> std::option::Option<&str> {
        self.last_deployment_job.as_deref()
    }
    /// <p>The time of the last deployment.</p>
    pub fn last_deployment_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_deployment_time.as_ref()
    }
    /// <p>The list of all tags added to the specified fleet.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetOutput");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("robots", &self.robots);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_deployment_status", &self.last_deployment_status);
        formatter.field("last_deployment_job", &self.last_deployment_job);
        formatter.field("last_deployment_time", &self.last_deployment_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeFleetOutput`](crate::output::DescribeFleetOutput)
pub mod describe_fleet_output {
    /// A builder for [`DescribeFleetOutput`](crate::output::DescribeFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) robots: std::option::Option<std::vec::Vec<crate::model::Robot>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) last_deployment_job: std::option::Option<std::string::String>,
        pub(crate) last_deployment_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `robots`.
        ///
        /// To override the contents of this collection use [`set_robots`](Self::set_robots).
        ///
        /// <p>A list of robots.</p>
        pub fn robots(mut self, input: impl Into<crate::model::Robot>) -> Self {
            let mut v = self.robots.unwrap_or_default();
            v.push(input.into());
            self.robots = Some(v);
            self
        }
        /// <p>A list of robots.</p>
        pub fn set_robots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Robot>>,
        ) -> Self {
            self.robots = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the last deployment.</p>
        pub fn last_deployment_status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.last_deployment_status = Some(input);
            self
        }
        /// <p>The status of the last deployment.</p>
        pub fn set_last_deployment_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.last_deployment_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn last_deployment_job(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_deployment_job = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the last deployment job.</p>
        pub fn set_last_deployment_job(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_deployment_job = input;
            self
        }
        /// <p>The time of the last deployment.</p>
        pub fn last_deployment_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_deployment_time = Some(input);
            self
        }
        /// <p>The time of the last deployment.</p>
        pub fn set_last_deployment_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_deployment_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified fleet.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified fleet.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetOutput`](crate::output::DescribeFleetOutput)
        pub fn build(self) -> crate::output::DescribeFleetOutput {
            crate::output::DescribeFleetOutput {
                name: self.name,
                arn: self.arn,
                robots: self.robots,
                created_at: self.created_at,
                last_deployment_status: self.last_deployment_status,
                last_deployment_job: self.last_deployment_job,
                last_deployment_time: self.last_deployment_time,
                tags: self.tags,
            }
        }
    }
}
impl DescribeFleetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetOutput`](crate::output::DescribeFleetOutput)
    pub fn builder() -> crate::output::describe_fleet_output::Builder {
        crate::output::describe_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDeploymentJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The status of the deployment job.</p>
    pub status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>The deployment configuration.</p>
    pub deployment_config: std::option::Option<crate::model::DeploymentConfig>,
    /// <p>The deployment application configuration.</p>
    pub deployment_application_configs:
        std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
    /// <p>A short description of the reason why the deployment job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The deployment job failure code.</p>
    pub failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
    /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of robot deployment summaries.</p>
    pub robot_deployment_summary: std::option::Option<std::vec::Vec<crate::model::RobotDeployment>>,
    /// <p>The list of all tags added to the specified deployment job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeDeploymentJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The status of the deployment job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.status.as_ref()
    }
    /// <p>The deployment configuration.</p>
    pub fn deployment_config(&self) -> std::option::Option<&crate::model::DeploymentConfig> {
        self.deployment_config.as_ref()
    }
    /// <p>The deployment application configuration.</p>
    pub fn deployment_application_configs(
        &self,
    ) -> std::option::Option<&[crate::model::DeploymentApplicationConfig]> {
        self.deployment_application_configs.as_deref()
    }
    /// <p>A short description of the reason why the deployment job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The deployment job failure code.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::DeploymentJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>A list of robot deployment summaries.</p>
    pub fn robot_deployment_summary(
        &self,
    ) -> std::option::Option<&[crate::model::RobotDeployment]> {
        self.robot_deployment_summary.as_deref()
    }
    /// <p>The list of all tags added to the specified deployment job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeDeploymentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDeploymentJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("fleet", &self.fleet);
        formatter.field("status", &self.status);
        formatter.field("deployment_config", &self.deployment_config);
        formatter.field(
            "deployment_application_configs",
            &self.deployment_application_configs,
        );
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("robot_deployment_summary", &self.robot_deployment_summary);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeDeploymentJobOutput`](crate::output::DescribeDeploymentJobOutput)
pub mod describe_deployment_job_output {
    /// A builder for [`DescribeDeploymentJobOutput`](crate::output::DescribeDeploymentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_config: std::option::Option<crate::model::DeploymentConfig>,
        pub(crate) deployment_application_configs:
            std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) robot_deployment_summary:
            std::option::Option<std::vec::Vec<crate::model::RobotDeployment>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>The status of the deployment job.</p>
        pub fn status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the deployment job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The deployment configuration.</p>
        pub fn deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.deployment_config = Some(input);
            self
        }
        /// <p>The deployment configuration.</p>
        pub fn set_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.deployment_config = input;
            self
        }
        /// Appends an item to `deployment_application_configs`.
        ///
        /// To override the contents of this collection use [`set_deployment_application_configs`](Self::set_deployment_application_configs).
        ///
        /// <p>The deployment application configuration.</p>
        pub fn deployment_application_configs(
            mut self,
            input: impl Into<crate::model::DeploymentApplicationConfig>,
        ) -> Self {
            let mut v = self.deployment_application_configs.unwrap_or_default();
            v.push(input.into());
            self.deployment_application_configs = Some(v);
            self
        }
        /// <p>The deployment application configuration.</p>
        pub fn set_deployment_application_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        ) -> Self {
            self.deployment_application_configs = input;
            self
        }
        /// <p>A short description of the reason why the deployment job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>A short description of the reason why the deployment job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The deployment job failure code.</p>
        pub fn failure_code(mut self, input: crate::model::DeploymentJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The deployment job failure code.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::DeploymentJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the deployment job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Appends an item to `robot_deployment_summary`.
        ///
        /// To override the contents of this collection use [`set_robot_deployment_summary`](Self::set_robot_deployment_summary).
        ///
        /// <p>A list of robot deployment summaries.</p>
        pub fn robot_deployment_summary(
            mut self,
            input: impl Into<crate::model::RobotDeployment>,
        ) -> Self {
            let mut v = self.robot_deployment_summary.unwrap_or_default();
            v.push(input.into());
            self.robot_deployment_summary = Some(v);
            self
        }
        /// <p>A list of robot deployment summaries.</p>
        pub fn set_robot_deployment_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotDeployment>>,
        ) -> Self {
            self.robot_deployment_summary = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the specified deployment job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the specified deployment job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeploymentJobOutput`](crate::output::DescribeDeploymentJobOutput)
        pub fn build(self) -> crate::output::DescribeDeploymentJobOutput {
            crate::output::DescribeDeploymentJobOutput {
                arn: self.arn,
                fleet: self.fleet,
                status: self.status,
                deployment_config: self.deployment_config,
                deployment_application_configs: self.deployment_application_configs,
                failure_reason: self.failure_reason,
                failure_code: self.failure_code,
                created_at: self.created_at,
                robot_deployment_summary: self.robot_deployment_summary,
                tags: self.tags,
            }
        }
    }
}
impl DescribeDeploymentJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDeploymentJobOutput`](crate::output::DescribeDeploymentJobOutput)
    pub fn builder() -> crate::output::describe_deployment_job_output::Builder {
        crate::output::describe_deployment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub robot: std::option::Option<std::string::String>,
}
impl DeregisterRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn robot(&self) -> std::option::Option<&str> {
        self.robot.as_deref()
    }
}
impl std::fmt::Debug for DeregisterRobotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterRobotOutput");
        formatter.field("fleet", &self.fleet);
        formatter.field("robot", &self.robot);
        formatter.finish()
    }
}
/// See [`DeregisterRobotOutput`](crate::output::DeregisterRobotOutput)
pub mod deregister_robot_output {
    /// A builder for [`DeregisterRobotOutput`](crate::output::DeregisterRobotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) robot: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn robot(mut self, input: impl Into<std::string::String>) -> Self {
            self.robot = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_robot(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.robot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterRobotOutput`](crate::output::DeregisterRobotOutput)
        pub fn build(self) -> crate::output::DeregisterRobotOutput {
            crate::output::DeregisterRobotOutput {
                fleet: self.fleet,
                robot: self.robot,
            }
        }
    }
}
impl DeregisterRobotOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterRobotOutput`](crate::output::DeregisterRobotOutput)
    pub fn builder() -> crate::output::deregister_robot_output::Builder {
        crate::output::deregister_robot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorldTemplateOutput {}
impl std::fmt::Debug for DeleteWorldTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorldTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteWorldTemplateOutput`](crate::output::DeleteWorldTemplateOutput)
pub mod delete_world_template_output {
    /// A builder for [`DeleteWorldTemplateOutput`](crate::output::DeleteWorldTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWorldTemplateOutput`](crate::output::DeleteWorldTemplateOutput)
        pub fn build(self) -> crate::output::DeleteWorldTemplateOutput {
            crate::output::DeleteWorldTemplateOutput {}
        }
    }
}
impl DeleteWorldTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWorldTemplateOutput`](crate::output::DeleteWorldTemplateOutput)
    pub fn builder() -> crate::output::delete_world_template_output::Builder {
        crate::output::delete_world_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSimulationApplicationOutput {}
impl std::fmt::Debug for DeleteSimulationApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSimulationApplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteSimulationApplicationOutput`](crate::output::DeleteSimulationApplicationOutput)
pub mod delete_simulation_application_output {
    /// A builder for [`DeleteSimulationApplicationOutput`](crate::output::DeleteSimulationApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSimulationApplicationOutput`](crate::output::DeleteSimulationApplicationOutput)
        pub fn build(self) -> crate::output::DeleteSimulationApplicationOutput {
            crate::output::DeleteSimulationApplicationOutput {}
        }
    }
}
impl DeleteSimulationApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSimulationApplicationOutput`](crate::output::DeleteSimulationApplicationOutput)
    pub fn builder() -> crate::output::delete_simulation_application_output::Builder {
        crate::output::delete_simulation_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRobotApplicationOutput {}
impl std::fmt::Debug for DeleteRobotApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRobotApplicationOutput");
        formatter.finish()
    }
}
/// See [`DeleteRobotApplicationOutput`](crate::output::DeleteRobotApplicationOutput)
pub mod delete_robot_application_output {
    /// A builder for [`DeleteRobotApplicationOutput`](crate::output::DeleteRobotApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRobotApplicationOutput`](crate::output::DeleteRobotApplicationOutput)
        pub fn build(self) -> crate::output::DeleteRobotApplicationOutput {
            crate::output::DeleteRobotApplicationOutput {}
        }
    }
}
impl DeleteRobotApplicationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRobotApplicationOutput`](crate::output::DeleteRobotApplicationOutput)
    pub fn builder() -> crate::output::delete_robot_application_output::Builder {
        crate::output::delete_robot_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRobotOutput {}
impl std::fmt::Debug for DeleteRobotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRobotOutput");
        formatter.finish()
    }
}
/// See [`DeleteRobotOutput`](crate::output::DeleteRobotOutput)
pub mod delete_robot_output {
    /// A builder for [`DeleteRobotOutput`](crate::output::DeleteRobotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRobotOutput`](crate::output::DeleteRobotOutput)
        pub fn build(self) -> crate::output::DeleteRobotOutput {
            crate::output::DeleteRobotOutput {}
        }
    }
}
impl DeleteRobotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRobotOutput`](crate::output::DeleteRobotOutput)
    pub fn builder() -> crate::output::delete_robot_output::Builder {
        crate::output::delete_robot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFleetOutput {}
impl std::fmt::Debug for DeleteFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFleetOutput");
        formatter.finish()
    }
}
/// See [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
pub mod delete_fleet_output {
    /// A builder for [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
        pub fn build(self) -> crate::output::DeleteFleetOutput {
            crate::output::DeleteFleetOutput {}
        }
    }
}
impl DeleteFleetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
    pub fn builder() -> crate::output::delete_fleet_output::Builder {
        crate::output::delete_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorldTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the world template.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the world template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to the world
    /// template.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorldTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the world template.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The name of the world template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world
    /// template.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorldTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorldTemplateOutput");
        formatter.field("arn", &self.arn);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("created_at", &self.created_at);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateWorldTemplateOutput`](crate::output::CreateWorldTemplateOutput)
pub mod create_world_template_output {
    /// A builder for [`CreateWorldTemplateOutput`](crate::output::CreateWorldTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world template.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world template.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world template was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The name of the world template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the world template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world
        /// template.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world
        /// template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorldTemplateOutput`](crate::output::CreateWorldTemplateOutput)
        pub fn build(self) -> crate::output::CreateWorldTemplateOutput {
            crate::output::CreateWorldTemplateOutput {
                arn: self.arn,
                client_request_token: self.client_request_token,
                created_at: self.created_at,
                name: self.name,
                tags: self.tags,
            }
        }
    }
}
impl CreateWorldTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorldTemplateOutput`](crate::output::CreateWorldTemplateOutput)
    pub fn builder() -> crate::output::create_world_template_output::Builder {
        crate::output::create_world_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorldGenerationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the world generator job.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world generator job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world generator job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world generator job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world generator job failed. See <code>failureCode</code> for more
    /// information. </p>
    /// </dd>
    /// <dt>PartialFailed</dt>
    /// <dd>
    /// <p>Some worlds did not generate.</p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world generator job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world generator job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::WorldGenerationJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the world generator job was
    /// created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The failure code of the world generator job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub template: std::option::Option<std::string::String>,
    /// <p>Information about the world count. </p>
    pub world_count: std::option::Option<crate::model::WorldCount>,
    /// <p>A map that contains tag keys and tag values that are attached to the world generator
    /// job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A map that contains tag keys and tag values that are attached to the generated
    /// worlds.</p>
    pub world_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorldGenerationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the world generator job.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world generator job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world generator job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world generator job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world generator job failed. See <code>failureCode</code> for more
    /// information. </p>
    /// </dd>
    /// <dt>PartialFailed</dt>
    /// <dd>
    /// <p>Some worlds did not generate.</p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world generator job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world generator job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::WorldGenerationJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world generator job was
    /// created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The failure code of the world generator job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::WorldGenerationJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The Amazon Resource Name (arn) of the world template.</p>
    pub fn template(&self) -> std::option::Option<&str> {
        self.template.as_deref()
    }
    /// <p>Information about the world count. </p>
    pub fn world_count(&self) -> std::option::Option<&crate::model::WorldCount> {
        self.world_count.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world generator
    /// job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the generated
    /// worlds.</p>
    pub fn world_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.world_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorldGenerationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorldGenerationJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("template", &self.template);
        formatter.field("world_count", &self.world_count);
        formatter.field("tags", &self.tags);
        formatter.field("world_tags", &self.world_tags);
        formatter.finish()
    }
}
/// See [`CreateWorldGenerationJobOutput`](crate::output::CreateWorldGenerationJobOutput)
pub mod create_world_generation_job_output {
    /// A builder for [`CreateWorldGenerationJobOutput`](crate::output::CreateWorldGenerationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorldGenerationJobStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_code: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) template: std::option::Option<std::string::String>,
        pub(crate) world_count: std::option::Option<crate::model::WorldCount>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) world_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world generator job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the world generator job.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world generator job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world generator job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world generator job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world generator job failed. See <code>failureCode</code> for more
        /// information. </p>
        /// </dd>
        /// <dt>PartialFailed</dt>
        /// <dd>
        /// <p>Some worlds did not generate.</p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world generator job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world generator job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::WorldGenerationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the world generator job.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world generator job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world generator job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world generator job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world generator job failed. See <code>failureCode</code> for more
        /// information. </p>
        /// </dd>
        /// <dt>PartialFailed</dt>
        /// <dd>
        /// <p>Some worlds did not generate.</p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world generator job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world generator job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorldGenerationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world generator job was
        /// created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world generator job was
        /// created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The failure code of the world generator job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::WorldGenerationJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the world generator job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::WorldGenerationJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn template(mut self, input: impl Into<std::string::String>) -> Self {
            self.template = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (arn) of the world template.</p>
        pub fn set_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template = input;
            self
        }
        /// <p>Information about the world count. </p>
        pub fn world_count(mut self, input: crate::model::WorldCount) -> Self {
            self.world_count = Some(input);
            self
        }
        /// <p>Information about the world count. </p>
        pub fn set_world_count(
            mut self,
            input: std::option::Option<crate::model::WorldCount>,
        ) -> Self {
            self.world_count = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world generator
        /// job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world generator
        /// job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `world_tags`.
        ///
        /// To override the contents of this collection use [`set_world_tags`](Self::set_world_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the generated
        /// worlds.</p>
        pub fn world_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.world_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.world_tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the generated
        /// worlds.</p>
        pub fn set_world_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.world_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorldGenerationJobOutput`](crate::output::CreateWorldGenerationJobOutput)
        pub fn build(self) -> crate::output::CreateWorldGenerationJobOutput {
            crate::output::CreateWorldGenerationJobOutput {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                failure_code: self.failure_code,
                client_request_token: self.client_request_token,
                template: self.template,
                world_count: self.world_count,
                tags: self.tags,
                world_tags: self.world_tags,
            }
        }
    }
}
impl CreateWorldGenerationJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorldGenerationJobOutput`](crate::output::CreateWorldGenerationJobOutput)
    pub fn builder() -> crate::output::create_world_generation_job_output::Builder {
        crate::output::create_world_generation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorldExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the world export job.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world export job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world export job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world export job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world export job failed. See <code>failureCode</code> for more information.
    /// </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world export job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world export job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::WorldExportJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The failure code of the world export job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// <dt>AllWorldGenerationFailed</dt>
    /// <dd>
    /// <p>All of the worlds in the world generation job failed. This can happen if your
    /// <code>worldCount</code> is greater than 50 or less than 1. </p>
    /// </dd>
    /// </dl>
    /// <p>For more information about troubleshooting WorldForge, see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting-worldforge.html">Troubleshooting Simulation WorldForge</a>. </p>
    pub failure_code: std::option::Option<crate::model::WorldExportJobErrorCode>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The output location.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
    /// the export. </p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>A map that contains tag keys and tag values that are attached to the world export
    /// job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateWorldExportJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the world export job.</p>
    /// <dl>
    /// <dt>Pending</dt>
    /// <dd>
    /// <p>The world export job request is pending.</p>
    /// </dd>
    /// <dt>Running</dt>
    /// <dd>
    /// <p>The world export job is running. </p>
    /// </dd>
    /// <dt>Completed</dt>
    /// <dd>
    /// <p>The world export job completed. </p>
    /// </dd>
    /// <dt>Failed</dt>
    /// <dd>
    /// <p>The world export job failed. See <code>failureCode</code> for more information.
    /// </p>
    /// </dd>
    /// <dt>Canceled</dt>
    /// <dd>
    /// <p>The world export job was cancelled.</p>
    /// </dd>
    /// <dt>Canceling</dt>
    /// <dd>
    /// <p>The world export job is being cancelled.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::WorldExportJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The failure code of the world export job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>LimitExceeded</dt>
    /// <dd>
    /// <p>The requested resource exceeds the maximum number allowed, or the number of
    /// concurrent stream requests exceeds the maximum number allowed. </p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>The specified resource could not be found. </p>
    /// </dd>
    /// <dt>RequestThrottled</dt>
    /// <dd>
    /// <p>The request was throttled.</p>
    /// </dd>
    /// <dt>InvalidInput</dt>
    /// <dd>
    /// <p>An input parameter in the request is not valid.</p>
    /// </dd>
    /// <dt>AllWorldGenerationFailed</dt>
    /// <dd>
    /// <p>All of the worlds in the world generation job failed. This can happen if your
    /// <code>worldCount</code> is greater than 50 or less than 1. </p>
    /// </dd>
    /// </dl>
    /// <p>For more information about troubleshooting WorldForge, see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting-worldforge.html">Troubleshooting Simulation WorldForge</a>. </p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::WorldExportJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The output location.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
    /// the export. </p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>A map that contains tag keys and tag values that are attached to the world export
    /// job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateWorldExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorldExportJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("output_location", &self.output_location);
        formatter.field("iam_role", &self.iam_role);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateWorldExportJobOutput`](crate::output::CreateWorldExportJobOutput)
pub mod create_world_export_job_output {
    /// A builder for [`CreateWorldExportJobOutput`](crate::output::CreateWorldExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::WorldExportJobStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_code: std::option::Option<crate::model::WorldExportJobErrorCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the world export job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the world export job.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world export job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world export job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world export job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world export job failed. See <code>failureCode</code> for more information.
        /// </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world export job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world export job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::WorldExportJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the world export job.</p>
        /// <dl>
        /// <dt>Pending</dt>
        /// <dd>
        /// <p>The world export job request is pending.</p>
        /// </dd>
        /// <dt>Running</dt>
        /// <dd>
        /// <p>The world export job is running. </p>
        /// </dd>
        /// <dt>Completed</dt>
        /// <dd>
        /// <p>The world export job completed. </p>
        /// </dd>
        /// <dt>Failed</dt>
        /// <dd>
        /// <p>The world export job failed. See <code>failureCode</code> for more information.
        /// </p>
        /// </dd>
        /// <dt>Canceled</dt>
        /// <dd>
        /// <p>The world export job was cancelled.</p>
        /// </dd>
        /// <dt>Canceling</dt>
        /// <dd>
        /// <p>The world export job is being cancelled.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WorldExportJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the world export job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The failure code of the world export job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// <dt>AllWorldGenerationFailed</dt>
        /// <dd>
        /// <p>All of the worlds in the world generation job failed. This can happen if your
        /// <code>worldCount</code> is greater than 50 or less than 1. </p>
        /// </dd>
        /// </dl>
        /// <p>For more information about troubleshooting WorldForge, see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting-worldforge.html">Troubleshooting Simulation WorldForge</a>. </p>
        pub fn failure_code(mut self, input: crate::model::WorldExportJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the world export job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>LimitExceeded</dt>
        /// <dd>
        /// <p>The requested resource exceeds the maximum number allowed, or the number of
        /// concurrent stream requests exceeds the maximum number allowed. </p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>The specified resource could not be found. </p>
        /// </dd>
        /// <dt>RequestThrottled</dt>
        /// <dd>
        /// <p>The request was throttled.</p>
        /// </dd>
        /// <dt>InvalidInput</dt>
        /// <dd>
        /// <p>An input parameter in the request is not valid.</p>
        /// </dd>
        /// <dt>AllWorldGenerationFailed</dt>
        /// <dd>
        /// <p>All of the worlds in the world generation job failed. This can happen if your
        /// <code>worldCount</code> is greater than 50 or less than 1. </p>
        /// </dd>
        /// </dl>
        /// <p>For more information about troubleshooting WorldForge, see <a href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting-worldforge.html">Troubleshooting Simulation WorldForge</a>. </p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::WorldExportJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The output location.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>The output location.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
        /// the export. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role that the world export process uses to access the Amazon S3 bucket and put
        /// the export. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map that contains tag keys and tag values that are attached to the world export
        /// job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map that contains tag keys and tag values that are attached to the world export
        /// job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorldExportJobOutput`](crate::output::CreateWorldExportJobOutput)
        pub fn build(self) -> crate::output::CreateWorldExportJobOutput {
            crate::output::CreateWorldExportJobOutput {
                arn: self.arn,
                status: self.status,
                created_at: self.created_at,
                failure_code: self.failure_code,
                client_request_token: self.client_request_token,
                output_location: self.output_location,
                iam_role: self.iam_role,
                tags: self.tags,
            }
        }
    }
}
impl CreateWorldExportJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateWorldExportJobOutput`](crate::output::CreateWorldExportJobOutput)
    pub fn builder() -> crate::output::create_world_export_job_output::Builder {
        crate::output::create_world_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSimulationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The status of the simulation job.</p>
    pub status: std::option::Option<crate::model::SimulationJobStatus>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// started.</p>
    pub last_started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>the failure behavior for the simulation job.</p>
    pub failure_behavior: std::option::Option<crate::model::FailureBehavior>,
    /// <p>The failure code of the simulation job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>RobotApplicationCrash</dt>
    /// <dd>
    /// <p>Robot application exited abnormally.</p>
    /// </dd>
    /// <dt>SimulationApplicationCrash</dt>
    /// <dd>
    /// <p> Simulation application exited abnormally.</p>
    /// </dd>
    /// <dt>BadPermissionsRobotApplication</dt>
    /// <dd>
    /// <p>Robot application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsS3Output</dt>
    /// <dd>
    /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
    /// </dd>
    /// <dt>BadPermissionsCloudwatchLogs</dt>
    /// <dd>
    /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
    /// </dd>
    /// <dt>SubnetIpLimitExceeded</dt>
    /// <dd>
    /// <p>Subnet IP limit exceeded.</p>
    /// </dd>
    /// <dt>ENILimitExceeded</dt>
    /// <dd>
    /// <p>ENI limit exceeded.</p>
    /// </dd>
    /// <dt>BadPermissionsUserCredentials</dt>
    /// <dd>
    /// <p>Unable to use the Role provided.</p>
    /// </dd>
    /// <dt>InvalidBundleRobotApplication</dt>
    /// <dd>
    /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>InvalidBundleSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>RobotApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for RobotApplication does not match value during version creation.</p>
    /// </dd>
    /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for SimulationApplication does not match value during version
    /// creation.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Simulation job output files location.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
    /// <p>The logging configuration.</p>
    pub logging_config: std::option::Option<crate::model::LoggingConfig>,
    /// <p>The maximum simulation job duration in seconds. </p>
    pub max_job_duration_in_seconds: i64,
    /// <p>The simulation job execution duration in milliseconds.</p>
    pub simulation_time_millis: i64,
    /// <p>The IAM role that allows the simulation job to call the AWS APIs that are specified in
    /// its associated policies on your behalf.</p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>The robot application used by the simulation job.</p>
    pub robot_applications:
        std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
    /// <p>The simulation application used by the simulation job.</p>
    pub simulation_applications:
        std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
    /// <p>The data sources for the simulation job.</p>
    pub data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>The list of all tags added to the simulation job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Information about the vpc configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>Compute information for the simulation job.</p>
    pub compute: std::option::Option<crate::model::ComputeResponse>,
}
impl CreateSimulationJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The status of the simulation job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SimulationJobStatus> {
        self.status.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// started.</p>
    pub fn last_started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_started_at.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation job was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>the failure behavior for the simulation job.</p>
    pub fn failure_behavior(&self) -> std::option::Option<&crate::model::FailureBehavior> {
        self.failure_behavior.as_ref()
    }
    /// <p>The failure code of the simulation job if it failed:</p>
    /// <dl>
    /// <dt>InternalServiceError</dt>
    /// <dd>
    /// <p>Internal service error.</p>
    /// </dd>
    /// <dt>RobotApplicationCrash</dt>
    /// <dd>
    /// <p>Robot application exited abnormally.</p>
    /// </dd>
    /// <dt>SimulationApplicationCrash</dt>
    /// <dd>
    /// <p> Simulation application exited abnormally.</p>
    /// </dd>
    /// <dt>BadPermissionsRobotApplication</dt>
    /// <dd>
    /// <p>Robot application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation application bundle could not be downloaded.</p>
    /// </dd>
    /// <dt>BadPermissionsS3Output</dt>
    /// <dd>
    /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
    /// </dd>
    /// <dt>BadPermissionsCloudwatchLogs</dt>
    /// <dd>
    /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
    /// </dd>
    /// <dt>SubnetIpLimitExceeded</dt>
    /// <dd>
    /// <p>Subnet IP limit exceeded.</p>
    /// </dd>
    /// <dt>ENILimitExceeded</dt>
    /// <dd>
    /// <p>ENI limit exceeded.</p>
    /// </dd>
    /// <dt>BadPermissionsUserCredentials</dt>
    /// <dd>
    /// <p>Unable to use the Role provided.</p>
    /// </dd>
    /// <dt>InvalidBundleRobotApplication</dt>
    /// <dd>
    /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>InvalidBundleSimulationApplication</dt>
    /// <dd>
    /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
    /// issue).</p>
    /// </dd>
    /// <dt>RobotApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for RobotApplication does not match value during version creation.</p>
    /// </dd>
    /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
    /// <dd>
    /// <p>Etag for SimulationApplication does not match value during version
    /// creation.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::SimulationJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
    /// request.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Simulation job output files location.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
    /// <p>The logging configuration.</p>
    pub fn logging_config(&self) -> std::option::Option<&crate::model::LoggingConfig> {
        self.logging_config.as_ref()
    }
    /// <p>The maximum simulation job duration in seconds. </p>
    pub fn max_job_duration_in_seconds(&self) -> i64 {
        self.max_job_duration_in_seconds
    }
    /// <p>The simulation job execution duration in milliseconds.</p>
    pub fn simulation_time_millis(&self) -> i64 {
        self.simulation_time_millis
    }
    /// <p>The IAM role that allows the simulation job to call the AWS APIs that are specified in
    /// its associated policies on your behalf.</p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>The robot application used by the simulation job.</p>
    pub fn robot_applications(
        &self,
    ) -> std::option::Option<&[crate::model::RobotApplicationConfig]> {
        self.robot_applications.as_deref()
    }
    /// <p>The simulation application used by the simulation job.</p>
    pub fn simulation_applications(
        &self,
    ) -> std::option::Option<&[crate::model::SimulationApplicationConfig]> {
        self.simulation_applications.as_deref()
    }
    /// <p>The data sources for the simulation job.</p>
    pub fn data_sources(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.data_sources.as_deref()
    }
    /// <p>The list of all tags added to the simulation job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Information about the vpc configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>Compute information for the simulation job.</p>
    pub fn compute(&self) -> std::option::Option<&crate::model::ComputeResponse> {
        self.compute.as_ref()
    }
}
impl std::fmt::Debug for CreateSimulationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSimulationJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("last_started_at", &self.last_started_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("failure_behavior", &self.failure_behavior);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("output_location", &self.output_location);
        formatter.field("logging_config", &self.logging_config);
        formatter.field(
            "max_job_duration_in_seconds",
            &self.max_job_duration_in_seconds,
        );
        formatter.field("simulation_time_millis", &self.simulation_time_millis);
        formatter.field("iam_role", &self.iam_role);
        formatter.field("robot_applications", &self.robot_applications);
        formatter.field("simulation_applications", &self.simulation_applications);
        formatter.field("data_sources", &self.data_sources);
        formatter.field("tags", &self.tags);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("compute", &self.compute);
        formatter.finish()
    }
}
/// See [`CreateSimulationJobOutput`](crate::output::CreateSimulationJobOutput)
pub mod create_simulation_job_output {
    /// A builder for [`CreateSimulationJobOutput`](crate::output::CreateSimulationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::SimulationJobStatus>,
        pub(crate) last_started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_behavior: std::option::Option<crate::model::FailureBehavior>,
        pub(crate) failure_code: std::option::Option<crate::model::SimulationJobErrorCode>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
        pub(crate) logging_config: std::option::Option<crate::model::LoggingConfig>,
        pub(crate) max_job_duration_in_seconds: std::option::Option<i64>,
        pub(crate) simulation_time_millis: std::option::Option<i64>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) robot_applications:
            std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        pub(crate) simulation_applications:
            std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        pub(crate) data_sources: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) compute: std::option::Option<crate::model::ComputeResponse>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The status of the simulation job.</p>
        pub fn status(mut self, input: crate::model::SimulationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the simulation job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SimulationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// started.</p>
        pub fn last_started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_started_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// started.</p>
        pub fn set_last_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_started_at = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation job was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>the failure behavior for the simulation job.</p>
        pub fn failure_behavior(mut self, input: crate::model::FailureBehavior) -> Self {
            self.failure_behavior = Some(input);
            self
        }
        /// <p>the failure behavior for the simulation job.</p>
        pub fn set_failure_behavior(
            mut self,
            input: std::option::Option<crate::model::FailureBehavior>,
        ) -> Self {
            self.failure_behavior = input;
            self
        }
        /// <p>The failure code of the simulation job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>RobotApplicationCrash</dt>
        /// <dd>
        /// <p>Robot application exited abnormally.</p>
        /// </dd>
        /// <dt>SimulationApplicationCrash</dt>
        /// <dd>
        /// <p> Simulation application exited abnormally.</p>
        /// </dd>
        /// <dt>BadPermissionsRobotApplication</dt>
        /// <dd>
        /// <p>Robot application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsS3Output</dt>
        /// <dd>
        /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
        /// </dd>
        /// <dt>BadPermissionsCloudwatchLogs</dt>
        /// <dd>
        /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
        /// </dd>
        /// <dt>SubnetIpLimitExceeded</dt>
        /// <dd>
        /// <p>Subnet IP limit exceeded.</p>
        /// </dd>
        /// <dt>ENILimitExceeded</dt>
        /// <dd>
        /// <p>ENI limit exceeded.</p>
        /// </dd>
        /// <dt>BadPermissionsUserCredentials</dt>
        /// <dd>
        /// <p>Unable to use the Role provided.</p>
        /// </dd>
        /// <dt>InvalidBundleRobotApplication</dt>
        /// <dd>
        /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>InvalidBundleSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>RobotApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for RobotApplication does not match value during version creation.</p>
        /// </dd>
        /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for SimulationApplication does not match value during version
        /// creation.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::SimulationJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the simulation job if it failed:</p>
        /// <dl>
        /// <dt>InternalServiceError</dt>
        /// <dd>
        /// <p>Internal service error.</p>
        /// </dd>
        /// <dt>RobotApplicationCrash</dt>
        /// <dd>
        /// <p>Robot application exited abnormally.</p>
        /// </dd>
        /// <dt>SimulationApplicationCrash</dt>
        /// <dd>
        /// <p> Simulation application exited abnormally.</p>
        /// </dd>
        /// <dt>BadPermissionsRobotApplication</dt>
        /// <dd>
        /// <p>Robot application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation application bundle could not be downloaded.</p>
        /// </dd>
        /// <dt>BadPermissionsS3Output</dt>
        /// <dd>
        /// <p>Unable to publish outputs to customer-provided S3 bucket.</p>
        /// </dd>
        /// <dt>BadPermissionsCloudwatchLogs</dt>
        /// <dd>
        /// <p>Unable to publish logs to customer-provided CloudWatch Logs resource.</p>
        /// </dd>
        /// <dt>SubnetIpLimitExceeded</dt>
        /// <dd>
        /// <p>Subnet IP limit exceeded.</p>
        /// </dd>
        /// <dt>ENILimitExceeded</dt>
        /// <dd>
        /// <p>ENI limit exceeded.</p>
        /// </dd>
        /// <dt>BadPermissionsUserCredentials</dt>
        /// <dd>
        /// <p>Unable to use the Role provided.</p>
        /// </dd>
        /// <dt>InvalidBundleRobotApplication</dt>
        /// <dd>
        /// <p>Robot bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>InvalidBundleSimulationApplication</dt>
        /// <dd>
        /// <p>Simulation bundle cannot be extracted (invalid format, bundling error, or other
        /// issue).</p>
        /// </dd>
        /// <dt>RobotApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for RobotApplication does not match value during version creation.</p>
        /// </dd>
        /// <dt>SimulationApplicationVersionMismatchedEtag</dt>
        /// <dd>
        /// <p>Etag for SimulationApplication does not match value during version
        /// creation.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::SimulationJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Simulation job output files location.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Simulation job output files location.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>The logging configuration.</p>
        pub fn logging_config(mut self, input: crate::model::LoggingConfig) -> Self {
            self.logging_config = Some(input);
            self
        }
        /// <p>The logging configuration.</p>
        pub fn set_logging_config(
            mut self,
            input: std::option::Option<crate::model::LoggingConfig>,
        ) -> Self {
            self.logging_config = input;
            self
        }
        /// <p>The maximum simulation job duration in seconds. </p>
        pub fn max_job_duration_in_seconds(mut self, input: i64) -> Self {
            self.max_job_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum simulation job duration in seconds. </p>
        pub fn set_max_job_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.max_job_duration_in_seconds = input;
            self
        }
        /// <p>The simulation job execution duration in milliseconds.</p>
        pub fn simulation_time_millis(mut self, input: i64) -> Self {
            self.simulation_time_millis = Some(input);
            self
        }
        /// <p>The simulation job execution duration in milliseconds.</p>
        pub fn set_simulation_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.simulation_time_millis = input;
            self
        }
        /// <p>The IAM role that allows the simulation job to call the AWS APIs that are specified in
        /// its associated policies on your behalf.</p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role that allows the simulation job to call the AWS APIs that are specified in
        /// its associated policies on your behalf.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// Appends an item to `robot_applications`.
        ///
        /// To override the contents of this collection use [`set_robot_applications`](Self::set_robot_applications).
        ///
        /// <p>The robot application used by the simulation job.</p>
        pub fn robot_applications(
            mut self,
            input: impl Into<crate::model::RobotApplicationConfig>,
        ) -> Self {
            let mut v = self.robot_applications.unwrap_or_default();
            v.push(input.into());
            self.robot_applications = Some(v);
            self
        }
        /// <p>The robot application used by the simulation job.</p>
        pub fn set_robot_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RobotApplicationConfig>>,
        ) -> Self {
            self.robot_applications = input;
            self
        }
        /// Appends an item to `simulation_applications`.
        ///
        /// To override the contents of this collection use [`set_simulation_applications`](Self::set_simulation_applications).
        ///
        /// <p>The simulation application used by the simulation job.</p>
        pub fn simulation_applications(
            mut self,
            input: impl Into<crate::model::SimulationApplicationConfig>,
        ) -> Self {
            let mut v = self.simulation_applications.unwrap_or_default();
            v.push(input.into());
            self.simulation_applications = Some(v);
            self
        }
        /// <p>The simulation application used by the simulation job.</p>
        pub fn set_simulation_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationApplicationConfig>>,
        ) -> Self {
            self.simulation_applications = input;
            self
        }
        /// Appends an item to `data_sources`.
        ///
        /// To override the contents of this collection use [`set_data_sources`](Self::set_data_sources).
        ///
        /// <p>The data sources for the simulation job.</p>
        pub fn data_sources(mut self, input: impl Into<crate::model::DataSource>) -> Self {
            let mut v = self.data_sources.unwrap_or_default();
            v.push(input.into());
            self.data_sources = Some(v);
            self
        }
        /// <p>The data sources for the simulation job.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the simulation job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the simulation job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Information about the vpc configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Information about the vpc configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn compute(mut self, input: crate::model::ComputeResponse) -> Self {
            self.compute = Some(input);
            self
        }
        /// <p>Compute information for the simulation job.</p>
        pub fn set_compute(
            mut self,
            input: std::option::Option<crate::model::ComputeResponse>,
        ) -> Self {
            self.compute = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSimulationJobOutput`](crate::output::CreateSimulationJobOutput)
        pub fn build(self) -> crate::output::CreateSimulationJobOutput {
            crate::output::CreateSimulationJobOutput {
                arn: self.arn,
                status: self.status,
                last_started_at: self.last_started_at,
                last_updated_at: self.last_updated_at,
                failure_behavior: self.failure_behavior,
                failure_code: self.failure_code,
                client_request_token: self.client_request_token,
                output_location: self.output_location,
                logging_config: self.logging_config,
                max_job_duration_in_seconds: self.max_job_duration_in_seconds.unwrap_or_default(),
                simulation_time_millis: self.simulation_time_millis.unwrap_or_default(),
                iam_role: self.iam_role,
                robot_applications: self.robot_applications,
                simulation_applications: self.simulation_applications,
                data_sources: self.data_sources,
                tags: self.tags,
                vpc_config: self.vpc_config,
                compute: self.compute,
            }
        }
    }
}
impl CreateSimulationJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateSimulationJobOutput`](crate::output::CreateSimulationJobOutput)
    pub fn builder() -> crate::output::create_simulation_job_output::Builder {
        crate::output::create_simulation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSimulationApplicationVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the simulation application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the simulation application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the simulation application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The simulation software suite used by the simulation application.</p>
    pub simulation_software_suite: std::option::Option<crate::model::SimulationSoftwareSuite>,
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The rendering engine for the simulation application.</p>
    pub rendering_engine: std::option::Option<crate::model::RenderingEngine>,
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The revision ID of the simulation application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The object that contains the Docker image URI used to create the simulation
    /// application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CreateSimulationApplicationVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the simulation application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the simulation application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the simulation application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The simulation software suite used by the simulation application.</p>
    pub fn simulation_software_suite(
        &self,
    ) -> std::option::Option<&crate::model::SimulationSoftwareSuite> {
        self.simulation_software_suite.as_ref()
    }
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The rendering engine for the simulation application.</p>
    pub fn rendering_engine(&self) -> std::option::Option<&crate::model::RenderingEngine> {
        self.rendering_engine.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The revision ID of the simulation application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The object that contains the Docker image URI used to create the simulation
    /// application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CreateSimulationApplicationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSimulationApplicationVersionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("simulation_software_suite", &self.simulation_software_suite);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("rendering_engine", &self.rendering_engine);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`CreateSimulationApplicationVersionOutput`](crate::output::CreateSimulationApplicationVersionOutput)
pub mod create_simulation_application_version_output {
    /// A builder for [`CreateSimulationApplicationVersionOutput`](crate::output::CreateSimulationApplicationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) simulation_software_suite:
            std::option::Option<crate::model::SimulationSoftwareSuite>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) rendering_engine: std::option::Option<crate::model::RenderingEngine>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.simulation_software_suite = Some(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.simulation_software_suite = input;
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.rendering_engine = Some(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.rendering_engine = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The revision ID of the simulation application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the simulation application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The object that contains the Docker image URI used to create the simulation
        /// application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI used to create the simulation
        /// application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSimulationApplicationVersionOutput`](crate::output::CreateSimulationApplicationVersionOutput)
        pub fn build(self) -> crate::output::CreateSimulationApplicationVersionOutput {
            crate::output::CreateSimulationApplicationVersionOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                simulation_software_suite: self.simulation_software_suite,
                robot_software_suite: self.robot_software_suite,
                rendering_engine: self.rendering_engine,
                last_updated_at: self.last_updated_at,
                revision_id: self.revision_id,
                environment: self.environment,
            }
        }
    }
}
impl CreateSimulationApplicationVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateSimulationApplicationVersionOutput`](crate::output::CreateSimulationApplicationVersionOutput)
    pub fn builder() -> crate::output::create_simulation_application_version_output::Builder {
        crate::output::create_simulation_application_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSimulationApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the simulation application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the simulation application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the simulation application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The simulation software suite used by the simulation application.</p>
    pub simulation_software_suite: std::option::Option<crate::model::SimulationSoftwareSuite>,
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The rendering engine for the simulation application.</p>
    pub rendering_engine: std::option::Option<crate::model::RenderingEngine>,
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The revision id of the simulation application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The list of all tags added to the simulation application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The object that contains the Docker image URI that you used to create your simulation
    /// application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CreateSimulationApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the simulation application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the simulation application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the simulation application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The simulation software suite used by the simulation application.</p>
    pub fn simulation_software_suite(
        &self,
    ) -> std::option::Option<&crate::model::SimulationSoftwareSuite> {
        self.simulation_software_suite.as_ref()
    }
    /// <p>Information about the robot software suite (ROS distribution).</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The rendering engine for the simulation application.</p>
    pub fn rendering_engine(&self) -> std::option::Option<&crate::model::RenderingEngine> {
        self.rendering_engine.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the simulation application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The revision id of the simulation application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The list of all tags added to the simulation application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The object that contains the Docker image URI that you used to create your simulation
    /// application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CreateSimulationApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSimulationApplicationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("simulation_software_suite", &self.simulation_software_suite);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("rendering_engine", &self.rendering_engine);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("tags", &self.tags);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`CreateSimulationApplicationOutput`](crate::output::CreateSimulationApplicationOutput)
pub mod create_simulation_application_output {
    /// A builder for [`CreateSimulationApplicationOutput`](crate::output::CreateSimulationApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) simulation_software_suite:
            std::option::Option<crate::model::SimulationSoftwareSuite>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) rendering_engine: std::option::Option<crate::model::RenderingEngine>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the simulation application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the simulation application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the simulation application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the simulation application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the simulation application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn simulation_software_suite(
            mut self,
            input: crate::model::SimulationSoftwareSuite,
        ) -> Self {
            self.simulation_software_suite = Some(input);
            self
        }
        /// <p>The simulation software suite used by the simulation application.</p>
        pub fn set_simulation_software_suite(
            mut self,
            input: std::option::Option<crate::model::SimulationSoftwareSuite>,
        ) -> Self {
            self.simulation_software_suite = input;
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>Information about the robot software suite (ROS distribution).</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn rendering_engine(mut self, input: crate::model::RenderingEngine) -> Self {
            self.rendering_engine = Some(input);
            self
        }
        /// <p>The rendering engine for the simulation application.</p>
        pub fn set_rendering_engine(
            mut self,
            input: std::option::Option<crate::model::RenderingEngine>,
        ) -> Self {
            self.rendering_engine = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the simulation application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The revision id of the simulation application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision id of the simulation application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the simulation application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the simulation application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The object that contains the Docker image URI that you used to create your simulation
        /// application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI that you used to create your simulation
        /// application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSimulationApplicationOutput`](crate::output::CreateSimulationApplicationOutput)
        pub fn build(self) -> crate::output::CreateSimulationApplicationOutput {
            crate::output::CreateSimulationApplicationOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                simulation_software_suite: self.simulation_software_suite,
                robot_software_suite: self.robot_software_suite,
                rendering_engine: self.rendering_engine,
                last_updated_at: self.last_updated_at,
                revision_id: self.revision_id,
                tags: self.tags,
                environment: self.environment,
            }
        }
    }
}
impl CreateSimulationApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateSimulationApplicationOutput`](crate::output::CreateSimulationApplicationOutput)
    pub fn builder() -> crate::output::create_simulation_application_output::Builder {
        crate::output::create_simulation_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRobotApplicationVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the robot application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the robot application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the robot application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The revision id of the robot application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The object that contains the Docker image URI used to create your robot
    /// application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CreateRobotApplicationVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the robot application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the robot application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the robot application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The revision id of the robot application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The object that contains the Docker image URI used to create your robot
    /// application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CreateRobotApplicationVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRobotApplicationVersionOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`CreateRobotApplicationVersionOutput`](crate::output::CreateRobotApplicationVersionOutput)
pub mod create_robot_application_version_output {
    /// A builder for [`CreateRobotApplicationVersionOutput`](crate::output::CreateRobotApplicationVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The object that contains the Docker image URI used to create your robot
        /// application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The object that contains the Docker image URI used to create your robot
        /// application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRobotApplicationVersionOutput`](crate::output::CreateRobotApplicationVersionOutput)
        pub fn build(self) -> crate::output::CreateRobotApplicationVersionOutput {
            crate::output::CreateRobotApplicationVersionOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                robot_software_suite: self.robot_software_suite,
                last_updated_at: self.last_updated_at,
                revision_id: self.revision_id,
                environment: self.environment,
            }
        }
    }
}
impl CreateRobotApplicationVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateRobotApplicationVersionOutput`](crate::output::CreateRobotApplicationVersionOutput)
    pub fn builder() -> crate::output::create_robot_application_version_output::Builder {
        crate::output::create_robot_application_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRobotApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the robot application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the robot application.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The sources of the robot application.</p>
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The revision id of the robot application.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The list of all tags added to the robot application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An object that contains the Docker image URI used to a create your robot
    /// application.</p>
    pub environment: std::option::Option<crate::model::Environment>,
}
impl CreateRobotApplicationOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the robot application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the robot application.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The sources of the robot application.</p>
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
    /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
    pub fn robot_software_suite(&self) -> std::option::Option<&crate::model::RobotSoftwareSuite> {
        self.robot_software_suite.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot application was last
    /// updated.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The revision id of the robot application.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The list of all tags added to the robot application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>An object that contains the Docker image URI used to a create your robot
    /// application.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for CreateRobotApplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRobotApplicationOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("sources", &self.sources);
        formatter.field("robot_software_suite", &self.robot_software_suite);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("tags", &self.tags);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`CreateRobotApplicationOutput`](crate::output::CreateRobotApplicationOutput)
pub mod create_robot_application_output {
    /// A builder for [`CreateRobotApplicationOutput`](crate::output::CreateRobotApplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) robot_software_suite: std::option::Option<crate::model::RobotSoftwareSuite>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot application.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the robot application.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// <p>The sources of the robot application.</p>
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// <p>The sources of the robot application.</p>
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn robot_software_suite(mut self, input: crate::model::RobotSoftwareSuite) -> Self {
            self.robot_software_suite = Some(input);
            self
        }
        /// <p>The robot software suite (ROS distribution) used by the robot application.</p>
        pub fn set_robot_software_suite(
            mut self,
            input: std::option::Option<crate::model::RobotSoftwareSuite>,
        ) -> Self {
            self.robot_software_suite = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot application was last
        /// updated.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision id of the robot application.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the robot application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the robot application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An object that contains the Docker image URI used to a create your robot
        /// application.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>An object that contains the Docker image URI used to a create your robot
        /// application.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRobotApplicationOutput`](crate::output::CreateRobotApplicationOutput)
        pub fn build(self) -> crate::output::CreateRobotApplicationOutput {
            crate::output::CreateRobotApplicationOutput {
                arn: self.arn,
                name: self.name,
                version: self.version,
                sources: self.sources,
                robot_software_suite: self.robot_software_suite,
                last_updated_at: self.last_updated_at,
                revision_id: self.revision_id,
                tags: self.tags,
                environment: self.environment,
            }
        }
    }
}
impl CreateRobotApplicationOutput {
    /// Creates a new builder-style object to manufacture [`CreateRobotApplicationOutput`](crate::output::CreateRobotApplicationOutput)
    pub fn builder() -> crate::output::create_robot_application_output::Builder {
        crate::output::create_robot_application_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the robot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.</p>
    pub greengrass_group_id: std::option::Option<std::string::String>,
    /// <p>The target architecture of the robot.</p>
    pub architecture: std::option::Option<crate::model::Architecture>,
    /// <p>The list of all tags added to the robot.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRobotOutput {
    /// <p>The Amazon Resource Name (ARN) of the robot.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the robot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.</p>
    pub fn greengrass_group_id(&self) -> std::option::Option<&str> {
        self.greengrass_group_id.as_deref()
    }
    /// <p>The target architecture of the robot.</p>
    pub fn architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.architecture.as_ref()
    }
    /// <p>The list of all tags added to the robot.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRobotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRobotOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("created_at", &self.created_at);
        formatter.field("greengrass_group_id", &self.greengrass_group_id);
        formatter.field("architecture", &self.architecture);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateRobotOutput`](crate::output::CreateRobotOutput)
pub mod create_robot_output {
    /// A builder for [`CreateRobotOutput`](crate::output::CreateRobotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) greengrass_group_id: std::option::Option<std::string::String>,
        pub(crate) architecture: std::option::Option<crate::model::Architecture>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the robot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the robot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the robot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the robot was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.</p>
        pub fn greengrass_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.greengrass_group_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.</p>
        pub fn set_greengrass_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.greengrass_group_id = input;
            self
        }
        /// <p>The target architecture of the robot.</p>
        pub fn architecture(mut self, input: crate::model::Architecture) -> Self {
            self.architecture = Some(input);
            self
        }
        /// <p>The target architecture of the robot.</p>
        pub fn set_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.architecture = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the robot.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the robot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRobotOutput`](crate::output::CreateRobotOutput)
        pub fn build(self) -> crate::output::CreateRobotOutput {
            crate::output::CreateRobotOutput {
                arn: self.arn,
                name: self.name,
                created_at: self.created_at,
                greengrass_group_id: self.greengrass_group_id,
                architecture: self.architecture,
                tags: self.tags,
            }
        }
    }
}
impl CreateRobotOutput {
    /// Creates a new builder-style object to manufacture [`CreateRobotOutput`](crate::output::CreateRobotOutput)
    pub fn builder() -> crate::output::create_robot_output::Builder {
        crate::output::create_robot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFleetOutput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The list of all tags added to the fleet.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateFleetOutput {
    /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The list of all tags added to the fleet.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFleetOutput");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("created_at", &self.created_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateFleetOutput`](crate::output::CreateFleetOutput)
pub mod create_fleet_output {
    /// A builder for [`CreateFleetOutput`](crate::output::CreateFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the fleet.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the fleet.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the fleet.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetOutput`](crate::output::CreateFleetOutput)
        pub fn build(self) -> crate::output::CreateFleetOutput {
            crate::output::CreateFleetOutput {
                arn: self.arn,
                name: self.name,
                created_at: self.created_at,
                tags: self.tags,
            }
        }
    }
}
impl CreateFleetOutput {
    /// Creates a new builder-style object to manufacture [`CreateFleetOutput`](crate::output::CreateFleetOutput)
    pub fn builder() -> crate::output::create_fleet_output::Builder {
        crate::output::create_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDeploymentJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The target fleet for the deployment job.</p>
    pub fleet: std::option::Option<std::string::String>,
    /// <p>The status of the deployment job.</p>
    pub status: std::option::Option<crate::model::DeploymentStatus>,
    /// <p>The deployment application configuration.</p>
    pub deployment_application_configs:
        std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
    /// <p>The failure reason of the deployment job if it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The failure code of the simulation job if it failed:</p>
    /// <dl>
    /// <dt>BadPermissionError</dt>
    /// <dd>
    /// <p>AWS Greengrass requires a service-level role permission to access other
    /// services. The role must include the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor">
    /// <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
    /// </p>
    /// </dd>
    /// <dt>ExtractingBundleFailure</dt>
    /// <dd>
    /// <p>The robot application could not be extracted from the bundle.</p>
    /// </dd>
    /// <dt>FailureThresholdBreached</dt>
    /// <dd>
    /// <p>The percentage of robots that could not be updated exceeded the percentage set
    /// for the deployment.</p>
    /// </dd>
    /// <dt>GreengrassDeploymentFailed</dt>
    /// <dd>
    /// <p>The robot application could not be deployed to the robot.</p>
    /// </dd>
    /// <dt>GreengrassGroupVersionDoesNotExist</dt>
    /// <dd>
    /// <p>The AWS Greengrass group or version associated with a robot is missing.</p>
    /// </dd>
    /// <dt>InternalServerError</dt>
    /// <dd>
    /// <p>An internal error has occurred. Retry your request, but if the problem
    /// persists, contact us with details.</p>
    /// </dd>
    /// <dt>MissingRobotApplicationArchitecture</dt>
    /// <dd>
    /// <p>The robot application does not have a source that matches the architecture of
    /// the robot.</p>
    /// </dd>
    /// <dt>MissingRobotDeploymentResource</dt>
    /// <dd>
    /// <p>One or more of the resources specified for the robot application are missing.
    /// For example, does the robot application have the correct launch package and launch
    /// file?</p>
    /// </dd>
    /// <dt>PostLaunchFileFailure</dt>
    /// <dd>
    /// <p>The post-launch script failed.</p>
    /// </dd>
    /// <dt>PreLaunchFileFailure</dt>
    /// <dd>
    /// <p>The pre-launch script failed.</p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>One or more deployment resources are missing. For example, do robot application
    /// source bundles still exist? </p>
    /// </dd>
    /// <dt>RobotDeploymentNoResponse</dt>
    /// <dd>
    /// <p>There is no response from the robot. It might not be powered on or connected to
    /// the internet.</p>
    /// </dd>
    /// </dl>
    pub failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The deployment configuration.</p>
    pub deployment_config: std::option::Option<crate::model::DeploymentConfig>,
    /// <p>The list of all tags added to the deployment job.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDeploymentJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The target fleet for the deployment job.</p>
    pub fn fleet(&self) -> std::option::Option<&str> {
        self.fleet.as_deref()
    }
    /// <p>The status of the deployment job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeploymentStatus> {
        self.status.as_ref()
    }
    /// <p>The deployment application configuration.</p>
    pub fn deployment_application_configs(
        &self,
    ) -> std::option::Option<&[crate::model::DeploymentApplicationConfig]> {
        self.deployment_application_configs.as_deref()
    }
    /// <p>The failure reason of the deployment job if it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The failure code of the simulation job if it failed:</p>
    /// <dl>
    /// <dt>BadPermissionError</dt>
    /// <dd>
    /// <p>AWS Greengrass requires a service-level role permission to access other
    /// services. The role must include the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor">
    /// <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
    /// </p>
    /// </dd>
    /// <dt>ExtractingBundleFailure</dt>
    /// <dd>
    /// <p>The robot application could not be extracted from the bundle.</p>
    /// </dd>
    /// <dt>FailureThresholdBreached</dt>
    /// <dd>
    /// <p>The percentage of robots that could not be updated exceeded the percentage set
    /// for the deployment.</p>
    /// </dd>
    /// <dt>GreengrassDeploymentFailed</dt>
    /// <dd>
    /// <p>The robot application could not be deployed to the robot.</p>
    /// </dd>
    /// <dt>GreengrassGroupVersionDoesNotExist</dt>
    /// <dd>
    /// <p>The AWS Greengrass group or version associated with a robot is missing.</p>
    /// </dd>
    /// <dt>InternalServerError</dt>
    /// <dd>
    /// <p>An internal error has occurred. Retry your request, but if the problem
    /// persists, contact us with details.</p>
    /// </dd>
    /// <dt>MissingRobotApplicationArchitecture</dt>
    /// <dd>
    /// <p>The robot application does not have a source that matches the architecture of
    /// the robot.</p>
    /// </dd>
    /// <dt>MissingRobotDeploymentResource</dt>
    /// <dd>
    /// <p>One or more of the resources specified for the robot application are missing.
    /// For example, does the robot application have the correct launch package and launch
    /// file?</p>
    /// </dd>
    /// <dt>PostLaunchFileFailure</dt>
    /// <dd>
    /// <p>The post-launch script failed.</p>
    /// </dd>
    /// <dt>PreLaunchFileFailure</dt>
    /// <dd>
    /// <p>The pre-launch script failed.</p>
    /// </dd>
    /// <dt>ResourceNotFound</dt>
    /// <dd>
    /// <p>One or more deployment resources are missing. For example, do robot application
    /// source bundles still exist? </p>
    /// </dd>
    /// <dt>RobotDeploymentNoResponse</dt>
    /// <dd>
    /// <p>There is no response from the robot. It might not be powered on or connected to
    /// the internet.</p>
    /// </dd>
    /// </dl>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::DeploymentJobErrorCode> {
        self.failure_code.as_ref()
    }
    /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The deployment configuration.</p>
    pub fn deployment_config(&self) -> std::option::Option<&crate::model::DeploymentConfig> {
        self.deployment_config.as_ref()
    }
    /// <p>The list of all tags added to the deployment job.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDeploymentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDeploymentJobOutput");
        formatter.field("arn", &self.arn);
        formatter.field("fleet", &self.fleet);
        formatter.field("status", &self.status);
        formatter.field(
            "deployment_application_configs",
            &self.deployment_application_configs,
        );
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("deployment_config", &self.deployment_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateDeploymentJobOutput`](crate::output::CreateDeploymentJobOutput)
pub mod create_deployment_job_output {
    /// A builder for [`CreateDeploymentJobOutput`](crate::output::CreateDeploymentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) fleet: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DeploymentStatus>,
        pub(crate) deployment_application_configs:
            std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<crate::model::DeploymentJobErrorCode>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deployment_config: std::option::Option<crate::model::DeploymentConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deployment job.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The target fleet for the deployment job.</p>
        pub fn fleet(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet = Some(input.into());
            self
        }
        /// <p>The target fleet for the deployment job.</p>
        pub fn set_fleet(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet = input;
            self
        }
        /// <p>The status of the deployment job.</p>
        pub fn status(mut self, input: crate::model::DeploymentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the deployment job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeploymentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `deployment_application_configs`.
        ///
        /// To override the contents of this collection use [`set_deployment_application_configs`](Self::set_deployment_application_configs).
        ///
        /// <p>The deployment application configuration.</p>
        pub fn deployment_application_configs(
            mut self,
            input: impl Into<crate::model::DeploymentApplicationConfig>,
        ) -> Self {
            let mut v = self.deployment_application_configs.unwrap_or_default();
            v.push(input.into());
            self.deployment_application_configs = Some(v);
            self
        }
        /// <p>The deployment application configuration.</p>
        pub fn set_deployment_application_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeploymentApplicationConfig>>,
        ) -> Self {
            self.deployment_application_configs = input;
            self
        }
        /// <p>The failure reason of the deployment job if it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The failure reason of the deployment job if it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The failure code of the simulation job if it failed:</p>
        /// <dl>
        /// <dt>BadPermissionError</dt>
        /// <dd>
        /// <p>AWS Greengrass requires a service-level role permission to access other
        /// services. The role must include the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor">
        /// <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
        /// </p>
        /// </dd>
        /// <dt>ExtractingBundleFailure</dt>
        /// <dd>
        /// <p>The robot application could not be extracted from the bundle.</p>
        /// </dd>
        /// <dt>FailureThresholdBreached</dt>
        /// <dd>
        /// <p>The percentage of robots that could not be updated exceeded the percentage set
        /// for the deployment.</p>
        /// </dd>
        /// <dt>GreengrassDeploymentFailed</dt>
        /// <dd>
        /// <p>The robot application could not be deployed to the robot.</p>
        /// </dd>
        /// <dt>GreengrassGroupVersionDoesNotExist</dt>
        /// <dd>
        /// <p>The AWS Greengrass group or version associated with a robot is missing.</p>
        /// </dd>
        /// <dt>InternalServerError</dt>
        /// <dd>
        /// <p>An internal error has occurred. Retry your request, but if the problem
        /// persists, contact us with details.</p>
        /// </dd>
        /// <dt>MissingRobotApplicationArchitecture</dt>
        /// <dd>
        /// <p>The robot application does not have a source that matches the architecture of
        /// the robot.</p>
        /// </dd>
        /// <dt>MissingRobotDeploymentResource</dt>
        /// <dd>
        /// <p>One or more of the resources specified for the robot application are missing.
        /// For example, does the robot application have the correct launch package and launch
        /// file?</p>
        /// </dd>
        /// <dt>PostLaunchFileFailure</dt>
        /// <dd>
        /// <p>The post-launch script failed.</p>
        /// </dd>
        /// <dt>PreLaunchFileFailure</dt>
        /// <dd>
        /// <p>The pre-launch script failed.</p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>One or more deployment resources are missing. For example, do robot application
        /// source bundles still exist? </p>
        /// </dd>
        /// <dt>RobotDeploymentNoResponse</dt>
        /// <dd>
        /// <p>There is no response from the robot. It might not be powered on or connected to
        /// the internet.</p>
        /// </dd>
        /// </dl>
        pub fn failure_code(mut self, input: crate::model::DeploymentJobErrorCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>The failure code of the simulation job if it failed:</p>
        /// <dl>
        /// <dt>BadPermissionError</dt>
        /// <dd>
        /// <p>AWS Greengrass requires a service-level role permission to access other
        /// services. The role must include the <a href="https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor">
        /// <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
        /// </p>
        /// </dd>
        /// <dt>ExtractingBundleFailure</dt>
        /// <dd>
        /// <p>The robot application could not be extracted from the bundle.</p>
        /// </dd>
        /// <dt>FailureThresholdBreached</dt>
        /// <dd>
        /// <p>The percentage of robots that could not be updated exceeded the percentage set
        /// for the deployment.</p>
        /// </dd>
        /// <dt>GreengrassDeploymentFailed</dt>
        /// <dd>
        /// <p>The robot application could not be deployed to the robot.</p>
        /// </dd>
        /// <dt>GreengrassGroupVersionDoesNotExist</dt>
        /// <dd>
        /// <p>The AWS Greengrass group or version associated with a robot is missing.</p>
        /// </dd>
        /// <dt>InternalServerError</dt>
        /// <dd>
        /// <p>An internal error has occurred. Retry your request, but if the problem
        /// persists, contact us with details.</p>
        /// </dd>
        /// <dt>MissingRobotApplicationArchitecture</dt>
        /// <dd>
        /// <p>The robot application does not have a source that matches the architecture of
        /// the robot.</p>
        /// </dd>
        /// <dt>MissingRobotDeploymentResource</dt>
        /// <dd>
        /// <p>One or more of the resources specified for the robot application are missing.
        /// For example, does the robot application have the correct launch package and launch
        /// file?</p>
        /// </dd>
        /// <dt>PostLaunchFileFailure</dt>
        /// <dd>
        /// <p>The post-launch script failed.</p>
        /// </dd>
        /// <dt>PreLaunchFileFailure</dt>
        /// <dd>
        /// <p>The pre-launch script failed.</p>
        /// </dd>
        /// <dt>ResourceNotFound</dt>
        /// <dd>
        /// <p>One or more deployment resources are missing. For example, do robot application
        /// source bundles still exist? </p>
        /// </dd>
        /// <dt>RobotDeploymentNoResponse</dt>
        /// <dd>
        /// <p>There is no response from the robot. It might not be powered on or connected to
        /// the internet.</p>
        /// </dd>
        /// </dl>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::DeploymentJobErrorCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time, in milliseconds since the epoch, when the fleet was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The deployment configuration.</p>
        pub fn deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.deployment_config = Some(input);
            self
        }
        /// <p>The deployment configuration.</p>
        pub fn set_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.deployment_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of all tags added to the deployment job.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The list of all tags added to the deployment job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeploymentJobOutput`](crate::output::CreateDeploymentJobOutput)
        pub fn build(self) -> crate::output::CreateDeploymentJobOutput {
            crate::output::CreateDeploymentJobOutput {
                arn: self.arn,
                fleet: self.fleet,
                status: self.status,
                deployment_application_configs: self.deployment_application_configs,
                failure_reason: self.failure_reason,
                failure_code: self.failure_code,
                created_at: self.created_at,
                deployment_config: self.deployment_config,
                tags: self.tags,
            }
        }
    }
}
impl CreateDeploymentJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateDeploymentJobOutput`](crate::output::CreateDeploymentJobOutput)
    pub fn builder() -> crate::output::create_deployment_job_output::Builder {
        crate::output::create_deployment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelWorldGenerationJobOutput {}
impl std::fmt::Debug for CancelWorldGenerationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelWorldGenerationJobOutput");
        formatter.finish()
    }
}
/// See [`CancelWorldGenerationJobOutput`](crate::output::CancelWorldGenerationJobOutput)
pub mod cancel_world_generation_job_output {
    /// A builder for [`CancelWorldGenerationJobOutput`](crate::output::CancelWorldGenerationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelWorldGenerationJobOutput`](crate::output::CancelWorldGenerationJobOutput)
        pub fn build(self) -> crate::output::CancelWorldGenerationJobOutput {
            crate::output::CancelWorldGenerationJobOutput {}
        }
    }
}
impl CancelWorldGenerationJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelWorldGenerationJobOutput`](crate::output::CancelWorldGenerationJobOutput)
    pub fn builder() -> crate::output::cancel_world_generation_job_output::Builder {
        crate::output::cancel_world_generation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelWorldExportJobOutput {}
impl std::fmt::Debug for CancelWorldExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelWorldExportJobOutput");
        formatter.finish()
    }
}
/// See [`CancelWorldExportJobOutput`](crate::output::CancelWorldExportJobOutput)
pub mod cancel_world_export_job_output {
    /// A builder for [`CancelWorldExportJobOutput`](crate::output::CancelWorldExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelWorldExportJobOutput`](crate::output::CancelWorldExportJobOutput)
        pub fn build(self) -> crate::output::CancelWorldExportJobOutput {
            crate::output::CancelWorldExportJobOutput {}
        }
    }
}
impl CancelWorldExportJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelWorldExportJobOutput`](crate::output::CancelWorldExportJobOutput)
    pub fn builder() -> crate::output::cancel_world_export_job_output::Builder {
        crate::output::cancel_world_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSimulationJobBatchOutput {}
impl std::fmt::Debug for CancelSimulationJobBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSimulationJobBatchOutput");
        formatter.finish()
    }
}
/// See [`CancelSimulationJobBatchOutput`](crate::output::CancelSimulationJobBatchOutput)
pub mod cancel_simulation_job_batch_output {
    /// A builder for [`CancelSimulationJobBatchOutput`](crate::output::CancelSimulationJobBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelSimulationJobBatchOutput`](crate::output::CancelSimulationJobBatchOutput)
        pub fn build(self) -> crate::output::CancelSimulationJobBatchOutput {
            crate::output::CancelSimulationJobBatchOutput {}
        }
    }
}
impl CancelSimulationJobBatchOutput {
    /// Creates a new builder-style object to manufacture [`CancelSimulationJobBatchOutput`](crate::output::CancelSimulationJobBatchOutput)
    pub fn builder() -> crate::output::cancel_simulation_job_batch_output::Builder {
        crate::output::cancel_simulation_job_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelSimulationJobOutput {}
impl std::fmt::Debug for CancelSimulationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelSimulationJobOutput");
        formatter.finish()
    }
}
/// See [`CancelSimulationJobOutput`](crate::output::CancelSimulationJobOutput)
pub mod cancel_simulation_job_output {
    /// A builder for [`CancelSimulationJobOutput`](crate::output::CancelSimulationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelSimulationJobOutput`](crate::output::CancelSimulationJobOutput)
        pub fn build(self) -> crate::output::CancelSimulationJobOutput {
            crate::output::CancelSimulationJobOutput {}
        }
    }
}
impl CancelSimulationJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelSimulationJobOutput`](crate::output::CancelSimulationJobOutput)
    pub fn builder() -> crate::output::cancel_simulation_job_output::Builder {
        crate::output::cancel_simulation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelDeploymentJobOutput {}
impl std::fmt::Debug for CancelDeploymentJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelDeploymentJobOutput");
        formatter.finish()
    }
}
/// See [`CancelDeploymentJobOutput`](crate::output::CancelDeploymentJobOutput)
pub mod cancel_deployment_job_output {
    /// A builder for [`CancelDeploymentJobOutput`](crate::output::CancelDeploymentJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelDeploymentJobOutput`](crate::output::CancelDeploymentJobOutput)
        pub fn build(self) -> crate::output::CancelDeploymentJobOutput {
            crate::output::CancelDeploymentJobOutput {}
        }
    }
}
impl CancelDeploymentJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelDeploymentJobOutput`](crate::output::CancelDeploymentJobOutput)
    pub fn builder() -> crate::output::cancel_deployment_job_output::Builder {
        crate::output::cancel_deployment_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDescribeSimulationJobOutput {
    /// <p>A list of simulation jobs.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::SimulationJob>>,
    /// <p>A list of unprocessed simulation job Amazon Resource Names (ARNs).</p>
    pub unprocessed_jobs: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDescribeSimulationJobOutput {
    /// <p>A list of simulation jobs.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::SimulationJob]> {
        self.jobs.as_deref()
    }
    /// <p>A list of unprocessed simulation job Amazon Resource Names (ARNs).</p>
    pub fn unprocessed_jobs(&self) -> std::option::Option<&[std::string::String]> {
        self.unprocessed_jobs.as_deref()
    }
}
impl std::fmt::Debug for BatchDescribeSimulationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDescribeSimulationJobOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("unprocessed_jobs", &self.unprocessed_jobs);
        formatter.finish()
    }
}
/// See [`BatchDescribeSimulationJobOutput`](crate::output::BatchDescribeSimulationJobOutput)
pub mod batch_describe_simulation_job_output {
    /// A builder for [`BatchDescribeSimulationJobOutput`](crate::output::BatchDescribeSimulationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::SimulationJob>>,
        pub(crate) unprocessed_jobs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>A list of simulation jobs.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::SimulationJob>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>A list of simulation jobs.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SimulationJob>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Appends an item to `unprocessed_jobs`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_jobs`](Self::set_unprocessed_jobs).
        ///
        /// <p>A list of unprocessed simulation job Amazon Resource Names (ARNs).</p>
        pub fn unprocessed_jobs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.unprocessed_jobs.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_jobs = Some(v);
            self
        }
        /// <p>A list of unprocessed simulation job Amazon Resource Names (ARNs).</p>
        pub fn set_unprocessed_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.unprocessed_jobs = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeSimulationJobOutput`](crate::output::BatchDescribeSimulationJobOutput)
        pub fn build(self) -> crate::output::BatchDescribeSimulationJobOutput {
            crate::output::BatchDescribeSimulationJobOutput {
                jobs: self.jobs,
                unprocessed_jobs: self.unprocessed_jobs,
            }
        }
    }
}
impl BatchDescribeSimulationJobOutput {
    /// Creates a new builder-style object to manufacture [`BatchDescribeSimulationJobOutput`](crate::output::BatchDescribeSimulationJobOutput)
    pub fn builder() -> crate::output::batch_describe_simulation_job_output::Builder {
        crate::output::batch_describe_simulation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteWorldsOutput {
    /// <p>A list of unprocessed worlds associated with the call. These worlds were not
    /// deleted.</p>
    pub unprocessed_worlds: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDeleteWorldsOutput {
    /// <p>A list of unprocessed worlds associated with the call. These worlds were not
    /// deleted.</p>
    pub fn unprocessed_worlds(&self) -> std::option::Option<&[std::string::String]> {
        self.unprocessed_worlds.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteWorldsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteWorldsOutput");
        formatter.field("unprocessed_worlds", &self.unprocessed_worlds);
        formatter.finish()
    }
}
/// See [`BatchDeleteWorldsOutput`](crate::output::BatchDeleteWorldsOutput)
pub mod batch_delete_worlds_output {
    /// A builder for [`BatchDeleteWorldsOutput`](crate::output::BatchDeleteWorldsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unprocessed_worlds: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `unprocessed_worlds`.
        ///
        /// To override the contents of this collection use [`set_unprocessed_worlds`](Self::set_unprocessed_worlds).
        ///
        /// <p>A list of unprocessed worlds associated with the call. These worlds were not
        /// deleted.</p>
        pub fn unprocessed_worlds(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.unprocessed_worlds.unwrap_or_default();
            v.push(input.into());
            self.unprocessed_worlds = Some(v);
            self
        }
        /// <p>A list of unprocessed worlds associated with the call. These worlds were not
        /// deleted.</p>
        pub fn set_unprocessed_worlds(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.unprocessed_worlds = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteWorldsOutput`](crate::output::BatchDeleteWorldsOutput)
        pub fn build(self) -> crate::output::BatchDeleteWorldsOutput {
            crate::output::BatchDeleteWorldsOutput {
                unprocessed_worlds: self.unprocessed_worlds,
            }
        }
    }
}
impl BatchDeleteWorldsOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteWorldsOutput`](crate::output::BatchDeleteWorldsOutput)
    pub fn builder() -> crate::output::batch_delete_worlds_output::Builder {
        crate::output::batch_delete_worlds_output::Builder::default()
    }
}
