// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Resource Groups
///
/// Client for invoking operations on AWS Resource Groups. Each operation on AWS Resource Groups is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_resourcegroups::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_resourcegroups::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_resourcegroups::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateGroup`](crate::client::fluent_builders::CreateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_name): <p>The name of the group, which is the identifier of the group in other operations. You can't change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name must be unique within each AWS Region in your AWS account.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateGroup::set_description): <p>The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces.</p>
    ///   - [`resource_query(ResourceQuery)`](crate::client::fluent_builders::CreateGroup::resource_query) / [`set_resource_query(Option<ResourceQuery>)`](crate::client::fluent_builders::CreateGroup::set_resource_query): <p>The resource query that determines which AWS resources are members of this group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. </p> <note>   <p>A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.</p>  </note>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateGroup::set_tags): <p>The tags to add to the group. A tag is key-value pair string.</p>
    ///   - [`configuration(Vec<GroupConfigurationItem>)`](crate::client::fluent_builders::CreateGroup::configuration) / [`set_configuration(Option<Vec<GroupConfigurationItem>>)`](crate::client::fluent_builders::CreateGroup::set_configuration): <p>A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <code>GroupConfigurationItem</code> elements. For details about the syntax of service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note>   <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>  </note>
    /// - On success, responds with [`CreateGroupOutput`](crate::output::CreateGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::CreateGroupOutput::group): <p>The description of the resource group.</p>
    ///   - [`resource_query(Option<ResourceQuery>)`](crate::output::CreateGroupOutput::resource_query): <p>The resource query associated with the group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. </p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateGroupOutput::tags): <p>The tags associated with the group.</p>
    ///   - [`group_configuration(Option<GroupConfiguration>)`](crate::output::CreateGroupOutput::group_configuration): <p>The service configuration associated with the resource group. For details about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>
    /// - On failure, responds with [`SdkError<CreateGroupError>`](crate::error::CreateGroupError)
    pub fn create_group(&self) -> fluent_builders::CreateGroup {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_group_name): <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::DeleteGroup::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::DeleteGroup::set_group): <p>The name or the ARN of the resource group to delete.</p>
    /// - On success, responds with [`DeleteGroupOutput`](crate::output::DeleteGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::DeleteGroupOutput::group): <p>A full description of the deleted resource group.</p>
    /// - On failure, responds with [`SdkError<DeleteGroupError>`](crate::error::DeleteGroupError)
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGroup`](crate::client::fluent_builders::GetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::GetGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::GetGroup::set_group_name): <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::GetGroup::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::GetGroup::set_group): <p>The name or the ARN of the resource group to retrieve.</p>
    /// - On success, responds with [`GetGroupOutput`](crate::output::GetGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::GetGroupOutput::group): <p>A full description of the resource group.</p>
    /// - On failure, responds with [`SdkError<GetGroupError>`](crate::error::GetGroupError)
    pub fn get_group(&self) -> fluent_builders::GetGroup {
        fluent_builders::GetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGroupConfiguration`](crate::client::fluent_builders::GetGroupConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::GetGroupConfiguration::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::GetGroupConfiguration::set_group): <p>The name or the ARN of the resource group.</p>
    /// - On success, responds with [`GetGroupConfigurationOutput`](crate::output::GetGroupConfigurationOutput) with field(s):
    ///   - [`group_configuration(Option<GroupConfiguration>)`](crate::output::GetGroupConfigurationOutput::group_configuration): <p>The service configuration associated with the specified group. For details about the service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>
    /// - On failure, responds with [`SdkError<GetGroupConfigurationError>`](crate::error::GetGroupConfigurationError)
    pub fn get_group_configuration(&self) -> fluent_builders::GetGroupConfiguration {
        fluent_builders::GetGroupConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGroupQuery`](crate::client::fluent_builders::GetGroupQuery) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::GetGroupQuery::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::GetGroupQuery::set_group_name): <p>Don't use this parameter. Use <code>Group</code> instead.</p>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::GetGroupQuery::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::GetGroupQuery::set_group): <p>The name or the ARN of the resource group to query.</p>
    /// - On success, responds with [`GetGroupQueryOutput`](crate::output::GetGroupQueryOutput) with field(s):
    ///   - [`group_query(Option<GroupQuery>)`](crate::output::GetGroupQueryOutput::group_query): <p>The resource query associated with the specified group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>.</p>
    /// - On failure, responds with [`SdkError<GetGroupQueryError>`](crate::error::GetGroupQueryError)
    pub fn get_group_query(&self) -> fluent_builders::GetGroupQuery {
        fluent_builders::GetGroupQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTags`](crate::client::fluent_builders::GetTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetTags::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetTags::set_arn): <p>The ARN of the resource group whose tags you want to retrieve.</p>
    /// - On success, responds with [`GetTagsOutput`](crate::output::GetTagsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetTagsOutput::arn): <p>The ARN of the tagged resource group.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetTagsOutput::tags): <p>The tags associated with the specified resource group.</p>
    /// - On failure, responds with [`SdkError<GetTagsError>`](crate::error::GetTagsError)
    pub fn get_tags(&self) -> fluent_builders::GetTags {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GroupResources`](crate::client::fluent_builders::GroupResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::GroupResources::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::GroupResources::set_group): <p>The name or the ARN of the resource group to add resources to.</p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::GroupResources::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::GroupResources::set_resource_arns): <p>The list of ARNs for resources to be added to the group. </p>
    /// - On success, responds with [`GroupResourcesOutput`](crate::output::GroupResourcesOutput) with field(s):
    ///   - [`succeeded(Option<Vec<String>>)`](crate::output::GroupResourcesOutput::succeeded): <p>A list of ARNs of resources that were successfully added to the group by this operation.</p>
    ///   - [`failed(Option<Vec<FailedResource>>)`](crate::output::GroupResourcesOutput::failed): <p>A list of ARNs of any resources that failed to be added to the group by this operation.</p>
    ///   - [`pending(Option<Vec<PendingResource>>)`](crate::output::GroupResourcesOutput::pending): <p>A list of ARNs of any resources that are still in the process of being added to the group by this operation. These pending additions continue asynchronously. You can check the status of pending additions by using the <code> <code>ListGroupResources</code> </code> operation, and checking the <code>Resources</code> array in the response and the <code>Status</code> field of each object in that array. </p>
    /// - On failure, responds with [`SdkError<GroupResourcesError>`](crate::error::GroupResourcesError)
    pub fn group_resources(&self) -> fluent_builders::GroupResources {
        fluent_builders::GroupResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroupResources`](crate::client::fluent_builders::ListGroupResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGroupResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::ListGroupResources::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::ListGroupResources::set_group_name): <important>   <p> <i> <b>Deprecated - don't use this parameter. Use the <code>Group</code> request field instead.</b> </i> </p>  </important>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::ListGroupResources::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::ListGroupResources::set_group): <p>The name or the ARN of the resource group</p>
    ///   - [`filters(Vec<ResourceFilter>)`](crate::client::fluent_builders::ListGroupResources::filters) / [`set_filters(Option<Vec<ResourceFilter>>)`](crate::client::fluent_builders::ListGroupResources::set_filters): <p>Filters, formatted as <code>ResourceFilter</code> objects, that you want to apply to a <code>ListGroupResources</code> operation. Filters the results to include only those of the specified resource types.</p>  <ul>   <li> <p> <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>. </p> </li>  </ul>  <p>When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types against the types that are defined in the query associated with the group. For example, if a group contains only S3 buckets because its query specifies only that resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a <code>BadRequestException</code> error with a message similar to the following:</p>  <p> <code>The resource types specified as filters in the request are not valid.</code> </p>  <p>The error includes a list of resource types that failed the validation because they are not part of the query associated with the group. This validation doesn't occur when the group query specifies <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource types for the query type (tag-based or AWS CloudFormation stack-based queries).</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGroupResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGroupResources::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroupResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroupResources::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    /// - On success, responds with [`ListGroupResourcesOutput`](crate::output::ListGroupResourcesOutput) with field(s):
    ///   - [`resources(Option<Vec<ListGroupResourcesItem>>)`](crate::output::ListGroupResourcesOutput::resources): <p>An array of resources from which you can determine each resource's identity, type, and group membership status.</p>
    ///   - [`resource_identifiers(Option<Vec<ResourceIdentifier>>)`](crate::output::ListGroupResourcesOutput::resource_identifiers): <important>   <p> <b> <i>Deprecated - don't use this parameter. Use the <code>Resources</code> response field instead.</i> </b> </p>  </important>
    ///   - [`next_token(Option<String>)`](crate::output::ListGroupResourcesOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    ///   - [`query_errors(Option<Vec<QueryError>>)`](crate::output::ListGroupResourcesOutput::query_errors): <p>A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
    /// - On failure, responds with [`SdkError<ListGroupResourcesError>`](crate::error::ListGroupResourcesError)
    pub fn list_group_resources(&self) -> fluent_builders::ListGroupResources {
        fluent_builders::ListGroupResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGroups`](crate::client::fluent_builders::ListGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<GroupFilter>)`](crate::client::fluent_builders::ListGroups::filters) / [`set_filters(Option<Vec<GroupFilter>>)`](crate::client::fluent_builders::ListGroups::set_filters): <p>Filters, formatted as <code>GroupFilter</code> objects, that you want to apply to a <code>ListGroups</code> operation.</p>  <ul>   <li> <p> <code>resource-type</code> - Filter the results to include only those of the specified resource types. Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.</p> </li>   <li> <p> <code>configuration-type</code> - Filter the results to include only those groups that have the specified configuration types attached. The current supported values are:</p>    <ul>     <li> <p> <code>AWS:EC2::CapacityReservationPool</code> </p> </li>     <li> <p> <code>AWS:EC2::HostManagement</code> </p> </li>    </ul> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGroups::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGroups::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    /// - On success, responds with [`ListGroupsOutput`](crate::output::ListGroupsOutput) with field(s):
    ///   - [`group_identifiers(Option<Vec<GroupIdentifier>>)`](crate::output::ListGroupsOutput::group_identifiers): <p>A list of <code>GroupIdentifier</code> objects. Each identifier is an object that contains both the <code>Name</code> and the <code>GroupArn</code>.</p>
    ///   - [`groups(Option<Vec<Group>>)`](crate::output::ListGroupsOutput::groups): <important>   <p> <i> <b>Deprecated - don't use this field. Use the <code>GroupIdentifiers</code> response field instead.</b> </i> </p>  </important>
    ///   - [`next_token(Option<String>)`](crate::output::ListGroupsOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<ListGroupsError>`](crate::error::ListGroupsError)
    pub fn list_groups(&self) -> fluent_builders::ListGroups {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutGroupConfiguration`](crate::client::fluent_builders::PutGroupConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::PutGroupConfiguration::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::PutGroupConfiguration::set_group): <p>The name or ARN of the resource group with the configuration that you want to update.</p>
    ///   - [`configuration(Vec<GroupConfigurationItem>)`](crate::client::fluent_builders::PutGroupConfiguration::configuration) / [`set_configuration(Option<Vec<GroupConfigurationItem>>)`](crate::client::fluent_builders::PutGroupConfiguration::set_configuration): <p>The new configuration to associate with the specified group. A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <code>GroupConfigurationItem</code> elements.</p>  <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note>   <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>  </note>
    /// - On success, responds with [`PutGroupConfigurationOutput`](crate::output::PutGroupConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutGroupConfigurationError>`](crate::error::PutGroupConfigurationError)
    pub fn put_group_configuration(&self) -> fluent_builders::PutGroupConfiguration {
        fluent_builders::PutGroupConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchResources`](crate::client::fluent_builders::SearchResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_query(ResourceQuery)`](crate::client::fluent_builders::SearchResources::resource_query) / [`set_resource_query(Option<ResourceQuery>)`](crate::client::fluent_builders::SearchResources::set_resource_query): <p>The search query, using the same formats that are supported for resource group definition. For more information, see <code>CreateGroup</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchResources::set_max_results): <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchResources::set_next_token): <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    /// - On success, responds with [`SearchResourcesOutput`](crate::output::SearchResourcesOutput) with field(s):
    ///   - [`resource_identifiers(Option<Vec<ResourceIdentifier>>)`](crate::output::SearchResourcesOutput::resource_identifiers): <p>The ARNs and resource types of resources that are members of the group that you specified.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchResourcesOutput::next_token): <p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    ///   - [`query_errors(Option<Vec<QueryError>>)`](crate::output::SearchResourcesOutput::query_errors): <p>A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
    /// - On failure, responds with [`SdkError<SearchResourcesError>`](crate::error::SearchResourcesError)
    pub fn search_resources(&self) -> fluent_builders::SearchResources {
        fluent_builders::SearchResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Tag`](crate::client::fluent_builders::Tag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::Tag::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::Tag::set_arn): <p>The ARN of the resource group to which to add tags.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::Tag::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::Tag::set_tags): <p>The tags to add to the specified resource group. A tag is a string-to-string map of key-value pairs.</p>
    /// - On success, responds with [`TagOutput`](crate::output::TagOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::TagOutput::arn): <p>The ARN of the tagged resource.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::TagOutput::tags): <p>The tags that have been added to the specified resource group.</p>
    /// - On failure, responds with [`SdkError<TagError>`](crate::error::TagError)
    pub fn tag(&self) -> fluent_builders::Tag {
        fluent_builders::Tag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UngroupResources`](crate::client::fluent_builders::UngroupResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::UngroupResources::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::UngroupResources::set_group): <p>The name or the ARN of the resource group from which to remove the resources.</p>
    ///   - [`resource_arns(Vec<String>)`](crate::client::fluent_builders::UngroupResources::resource_arns) / [`set_resource_arns(Option<Vec<String>>)`](crate::client::fluent_builders::UngroupResources::set_resource_arns): <p>The ARNs of the resources to be removed from the group.</p>
    /// - On success, responds with [`UngroupResourcesOutput`](crate::output::UngroupResourcesOutput) with field(s):
    ///   - [`succeeded(Option<Vec<String>>)`](crate::output::UngroupResourcesOutput::succeeded): <p>A list of resources that were successfully removed from the group by this operation.</p>
    ///   - [`failed(Option<Vec<FailedResource>>)`](crate::output::UngroupResourcesOutput::failed): <p>A list of any resources that failed to be removed from the group by this operation.</p>
    ///   - [`pending(Option<Vec<PendingResource>>)`](crate::output::UngroupResourcesOutput::pending): <p>A list of any resources that are still in the process of being removed from the group by this operation. These pending removals continue asynchronously. You can check the status of pending removals by using the <code> <code>ListGroupResources</code> </code> operation. After the resource is successfully removed, it no longer appears in the response.</p>
    /// - On failure, responds with [`SdkError<UngroupResourcesError>`](crate::error::UngroupResourcesError)
    pub fn ungroup_resources(&self) -> fluent_builders::UngroupResources {
        fluent_builders::UngroupResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Untag`](crate::client::fluent_builders::Untag) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::Untag::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::Untag::set_arn): <p>The ARN of the resource group from which to remove tags. The command removed both the specified keys and any values associated with those keys.</p>
    ///   - [`keys(Vec<String>)`](crate::client::fluent_builders::Untag::keys) / [`set_keys(Option<Vec<String>>)`](crate::client::fluent_builders::Untag::set_keys): <p>The keys of the tags to be removed.</p>
    /// - On success, responds with [`UntagOutput`](crate::output::UntagOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UntagOutput::arn): <p>The ARN of the resource group from which tags have been removed.</p>
    ///   - [`keys(Option<Vec<String>>)`](crate::output::UntagOutput::keys): <p>The keys of the tags that were removed.</p>
    /// - On failure, responds with [`SdkError<UntagError>`](crate::error::UntagError)
    pub fn untag(&self) -> fluent_builders::Untag {
        fluent_builders::Untag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_group_name): <p>Don't use this parameter. Use <code>Group</code> instead.</p>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_group): <p>The name or the ARN of the resource group to modify.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateGroup::set_description): <p>The new description that you want to update the resource group with. Descriptions can contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
    /// - On success, responds with [`UpdateGroupOutput`](crate::output::UpdateGroupOutput) with field(s):
    ///   - [`group(Option<Group>)`](crate::output::UpdateGroupOutput::group): <p>The update description of the resource group.</p>
    /// - On failure, responds with [`SdkError<UpdateGroupError>`](crate::error::UpdateGroupError)
    pub fn update_group(&self) -> fluent_builders::UpdateGroup {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGroupQuery`](crate::client::fluent_builders::UpdateGroupQuery) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`group_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGroupQuery::group_name) / [`set_group_name(Option<String>)`](crate::client::fluent_builders::UpdateGroupQuery::set_group_name): <p>Don't use this parameter. Use <code>Group</code> instead.</p>
    ///   - [`group(impl Into<String>)`](crate::client::fluent_builders::UpdateGroupQuery::group) / [`set_group(Option<String>)`](crate::client::fluent_builders::UpdateGroupQuery::set_group): <p>The name or the ARN of the resource group to query.</p>
    ///   - [`resource_query(ResourceQuery)`](crate::client::fluent_builders::UpdateGroupQuery::resource_query) / [`set_resource_query(Option<ResourceQuery>)`](crate::client::fluent_builders::UpdateGroupQuery::set_resource_query): <p>The resource query to determine which AWS resources are members of this resource group.</p> <note>   <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>  </note>
    /// - On success, responds with [`UpdateGroupQueryOutput`](crate::output::UpdateGroupQueryOutput) with field(s):
    ///   - [`group_query(Option<GroupQuery>)`](crate::output::UpdateGroupQueryOutput::group_query): <p>The updated resource query associated with the resource group after the update.</p>
    /// - On failure, responds with [`SdkError<UpdateGroupQueryError>`](crate::error::UpdateGroupQueryError)
    pub fn update_group_query(&self) -> fluent_builders::UpdateGroupQuery {
        fluent_builders::UpdateGroupQuery::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a resource group with the specified name and description. You can optionally include a resource query, or a service configuration. For more information about constructing a resource query, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. For more information about service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:CreateGroup</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_group_input::Builder,
    }
    impl CreateGroup {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group, which is the identifier of the group in other operations. You can't change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name must be unique within each AWS Region in your AWS account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the group, which is the identifier of the group in other operations. You can't change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name must be unique within each AWS Region in your AWS account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The resource query that determines which AWS resources are members of this group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. </p> <note>
        /// <p>A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.</p>
        /// </note>
        pub fn resource_query(mut self, input: crate::model::ResourceQuery) -> Self {
            self.inner = self.inner.resource_query(input);
            self
        }
        /// <p>The resource query that determines which AWS resources are members of this group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. </p> <note>
        /// <p>A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.</p>
        /// </note>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.inner = self.inner.set_resource_query(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the group. A tag is key-value pair string.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the group. A tag is key-value pair string.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <code>GroupConfigurationItem</code> elements. For details about the syntax of service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn configuration(mut self, input: crate::model::GroupConfigurationItem) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <code>GroupConfigurationItem</code> elements. For details about the syntax of service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes the specified resource group. Deleting a resource group does not delete any resources that are members of the group; it only deletes the group structure.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:DeleteGroup</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl DeleteGroup {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to delete.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to delete.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroup`.
    ///
    /// <p>Returns information about a specified resource group.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:GetGroup</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_group_input::Builder,
    }
    impl GetGroup {
        /// Creates a new `GetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to retrieve.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to retrieve.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupConfiguration`.
    ///
    /// <p>Returns the service configuration associated with the specified resource group. For details about the service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:GetGroupConfiguration</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGroupConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_group_configuration_input::Builder,
    }
    impl GetGroupConfiguration {
        /// Creates a new `GetGroupConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the ARN of the resource group.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupQuery`.
    ///
    /// <p>Retrieves the resource query associated with the specified resource group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:GetGroupQuery</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGroupQuery {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_group_query_input::Builder,
    }
    impl GetGroupQuery {
        /// Creates a new `GetGroupQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupQueryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Returns a list of tags that are associated with a resource group, specified by an ARN.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:GetTags</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl GetTags {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource group whose tags you want to retrieve.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the resource group whose tags you want to retrieve.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GroupResources`.
    ///
    /// <p>Adds the specified resources to the specified group.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:GroupResources</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GroupResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::group_resources_input::Builder,
    }
    impl GroupResources {
        /// Creates a new `GroupResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GroupResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GroupResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the ARN of the resource group to add resources to.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to add resources to.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The list of ARNs for resources to be added to the group. </p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The list of ARNs for resources to be added to the group. </p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupResources`.
    ///
    /// <p>Returns a list of ARNs of the resources that are members of a specified resource group.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:ListGroupResources</code> </p> </li>
    /// <li> <p> <code>cloudformation:DescribeStacks</code> </p> </li>
    /// <li> <p> <code>cloudformation:ListStackResources</code> </p> </li>
    /// <li> <p> <code>tag:GetResources</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroupResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_group_resources_input::Builder,
    }
    impl ListGroupResources {
        /// Creates a new `ListGroupResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGroupResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGroupResourcesPaginator {
            crate::paginator::ListGroupResourcesPaginator::new(self.handle, self.inner)
        }
        /// <important>
        /// <p> <i> <b>Deprecated - don't use this parameter. Use the <code>Group</code> request field instead.</b> </i> </p>
        /// </important>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <important>
        /// <p> <i> <b>Deprecated - don't use this parameter. Use the <code>Group</code> request field instead.</b> </i> </p>
        /// </important>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters, formatted as <code>ResourceFilter</code> objects, that you want to apply to a <code>ListGroupResources</code> operation. Filters the results to include only those of the specified resource types.</p>
        /// <ul>
        /// <li> <p> <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>. </p> </li>
        /// </ul>
        /// <p>When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types against the types that are defined in the query associated with the group. For example, if a group contains only S3 buckets because its query specifies only that resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a <code>BadRequestException</code> error with a message similar to the following:</p>
        /// <p> <code>The resource types specified as filters in the request are not valid.</code> </p>
        /// <p>The error includes a list of resource types that failed the validation because they are not part of the query associated with the group. This validation doesn't occur when the group query specifies <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource types for the query type (tag-based or AWS CloudFormation stack-based queries).</p>
        pub fn filters(mut self, input: crate::model::ResourceFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters, formatted as <code>ResourceFilter</code> objects, that you want to apply to a <code>ListGroupResources</code> operation. Filters the results to include only those of the specified resource types.</p>
        /// <ul>
        /// <li> <p> <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>. </p> </li>
        /// </ul>
        /// <p>When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types against the types that are defined in the query associated with the group. For example, if a group contains only S3 buckets because its query specifies only that resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a <code>BadRequestException</code> error with a message similar to the following:</p>
        /// <p> <code>The resource types specified as filters in the request are not valid.</code> </p>
        /// <p>The error includes a list of resource types that failed the validation because they are not part of the query associated with the group. This validation doesn't occur when the group query specifies <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource types for the query type (tag-based or AWS CloudFormation stack-based queries).</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Returns a list of existing resource groups in your account.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:ListGroups</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl ListGroups {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGroupsPaginator {
            crate::paginator::ListGroupsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters, formatted as <code>GroupFilter</code> objects, that you want to apply to a <code>ListGroups</code> operation.</p>
        /// <ul>
        /// <li> <p> <code>resource-type</code> - Filter the results to include only those of the specified resource types. Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.</p> </li>
        /// <li> <p> <code>configuration-type</code> - Filter the results to include only those groups that have the specified configuration types attached. The current supported values are:</p>
        /// <ul>
        /// <li> <p> <code>AWS:EC2::CapacityReservationPool</code> </p> </li>
        /// <li> <p> <code>AWS:EC2::HostManagement</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::GroupFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters, formatted as <code>GroupFilter</code> objects, that you want to apply to a <code>ListGroups</code> operation.</p>
        /// <ul>
        /// <li> <p> <code>resource-type</code> - Filter the results to include only those of the specified resource types. Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.</p> </li>
        /// <li> <p> <code>configuration-type</code> - Filter the results to include only those groups that have the specified configuration types attached. The current supported values are:</p>
        /// <ul>
        /// <li> <p> <code>AWS:EC2::CapacityReservationPool</code> </p> </li>
        /// <li> <p> <code>AWS:EC2::HostManagement</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutGroupConfiguration`.
    ///
    /// <p>Attaches a service configuration to the specified group. This occurs asynchronously, and can take time to complete. You can use <code>GetGroupConfiguration</code> to check the status of the update.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:PutGroupConfiguration</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutGroupConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_group_configuration_input::Builder,
    }
    impl PutGroupConfiguration {
        /// Creates a new `PutGroupConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutGroupConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutGroupConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the resource group with the configuration that you want to update.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or ARN of the resource group with the configuration that you want to update.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `Configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>The new configuration to associate with the specified group. A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <code>GroupConfigurationItem</code> elements.</p>
        /// <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn configuration(mut self, input: crate::model::GroupConfigurationItem) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The new configuration to associate with the specified group. A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <code>GroupConfigurationItem</code> elements.</p>
        /// <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchResources`.
    ///
    /// <p>Returns a list of AWS resource identifiers that matches the specified query. The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery operation.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:SearchResources</code> </p> </li>
    /// <li> <p> <code>cloudformation:DescribeStacks</code> </p> </li>
    /// <li> <p> <code>cloudformation:ListStackResources</code> </p> </li>
    /// <li> <p> <code>tag:GetResources</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_resources_input::Builder,
    }
    impl SearchResources {
        /// Creates a new `SearchResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchResourcesPaginator {
            crate::paginator::SearchResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The search query, using the same formats that are supported for resource group definition. For more information, see <code>CreateGroup</code>.</p>
        pub fn resource_query(mut self, input: crate::model::ResourceQuery) -> Self {
            self.inner = self.inner.resource_query(input);
            self
        }
        /// <p>The search query, using the same formats that are supported for resource group definition. For more information, see <code>CreateGroup</code>.</p>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.inner = self.inner.set_resource_query(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Tag`.
    ///
    /// <p>Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they are not specified in the request parameters.</p> <important>
    /// <p>Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.</p>
    /// </important>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:Tag</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Tag {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_input::Builder,
    }
    impl Tag {
        /// Creates a new `Tag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagOutput,
            aws_smithy_http::result::SdkError<crate::error::TagError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource group to which to add tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the resource group to which to add tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the specified resource group. A tag is a string-to-string map of key-value pairs.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to add to the specified resource group. A tag is a string-to-string map of key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UngroupResources`.
    ///
    /// <p>Removes the specified resources from the specified group.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:UngroupResources</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UngroupResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::ungroup_resources_input::Builder,
    }
    impl UngroupResources {
        /// Creates a new `UngroupResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UngroupResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::UngroupResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the ARN of the resource group from which to remove the resources.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group from which to remove the resources.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The ARNs of the resources to be removed from the group.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(input.into());
            self
        }
        /// <p>The ARNs of the resources to be removed from the group.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Untag`.
    ///
    /// <p>Deletes tags from a specified resource group.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:Untag</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Untag {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_input::Builder,
    }
    impl Untag {
        /// Creates a new `Untag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource group from which to remove tags. The command removed both the specified keys and any values associated with those keys.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the resource group from which to remove tags. The command removed both the specified keys and any values associated with those keys.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `Keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keys(input.into());
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// <p>Updates the description for an existing group. You cannot update the name of a resource group.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:UpdateGroup</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_group_input::Builder,
    }
    impl UpdateGroup {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to modify.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to modify.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// <p>The new description that you want to update the resource group with. Descriptions can contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description that you want to update the resource group with. Descriptions can contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroupQuery`.
    ///
    /// <p>Updates the resource query of a group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>.</p>
    /// <p> <b>Minimum permissions</b> </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>resource-groups:UpdateGroupQuery</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGroupQuery {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_group_query_input::Builder,
    }
    impl UpdateGroupQuery {
        /// Creates a new `UpdateGroupQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupQueryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(input.into());
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// <p>The resource query to determine which AWS resources are members of this resource group.</p> <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn resource_query(mut self, input: crate::model::ResourceQuery) -> Self {
            self.inner = self.inner.resource_query(input);
            self
        }
        /// <p>The resource query to determine which AWS resources are members of this resource group.</p> <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.inner = self.inner.set_resource_query(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
