// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupQueryOutput {
    /// <p>The updated resource query associated with the resource group after the update.</p>
    pub group_query: std::option::Option<crate::model::GroupQuery>,
}
impl std::fmt::Debug for UpdateGroupQueryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupQueryOutput");
        formatter.field("group_query", &self.group_query);
        formatter.finish()
    }
}
/// See [`UpdateGroupQueryOutput`](crate::output::UpdateGroupQueryOutput)
pub mod update_group_query_output {
    /// A builder for [`UpdateGroupQueryOutput`](crate::output::UpdateGroupQueryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_query: std::option::Option<crate::model::GroupQuery>,
    }
    impl Builder {
        /// <p>The updated resource query associated with the resource group after the update.</p>
        pub fn group_query(mut self, input: crate::model::GroupQuery) -> Self {
            self.group_query = Some(input);
            self
        }
        /// <p>The updated resource query associated with the resource group after the update.</p>
        pub fn set_group_query(
            mut self,
            input: std::option::Option<crate::model::GroupQuery>,
        ) -> Self {
            self.group_query = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupQueryOutput`](crate::output::UpdateGroupQueryOutput)
        pub fn build(self) -> crate::output::UpdateGroupQueryOutput {
            crate::output::UpdateGroupQueryOutput {
                group_query: self.group_query,
            }
        }
    }
}
impl UpdateGroupQueryOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGroupQueryOutput`](crate::output::UpdateGroupQueryOutput)
    pub fn builder() -> crate::output::update_group_query_output::Builder {
        crate::output::update_group_query_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupOutput {
    /// <p>The update description of the resource group.</p>
    pub group: std::option::Option<crate::model::Group>,
}
impl std::fmt::Debug for UpdateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
pub mod update_group_output {
    /// A builder for [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
    }
    impl Builder {
        /// <p>The update description of the resource group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The update description of the resource group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
        pub fn build(self) -> crate::output::UpdateGroupOutput {
            crate::output::UpdateGroupOutput { group: self.group }
        }
    }
}
impl UpdateGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    pub fn builder() -> crate::output::update_group_output::Builder {
        crate::output::update_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagOutput {
    /// <p>The ARN of the resource group from which tags have been removed.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags that were removed.</p>
    pub keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagOutput");
        formatter.field("arn", &self.arn);
        formatter.field("keys", &self.keys);
        formatter.finish()
    }
}
/// See [`UntagOutput`](crate::output::UntagOutput)
pub mod untag_output {
    /// A builder for [`UntagOutput`](crate::output::UntagOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource group from which tags have been removed.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource group from which tags have been removed.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The keys of the tags that were removed.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>The keys of the tags that were removed.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagOutput`](crate::output::UntagOutput)
        pub fn build(self) -> crate::output::UntagOutput {
            crate::output::UntagOutput {
                arn: self.arn,
                keys: self.keys,
            }
        }
    }
}
impl UntagOutput {
    /// Creates a new builder-style object to manufacture [`UntagOutput`](crate::output::UntagOutput)
    pub fn builder() -> crate::output::untag_output::Builder {
        crate::output::untag_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UngroupResourcesOutput {
    /// <p>A list of resources that were successfully removed from the group by this
    /// operation.</p>
    pub succeeded: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of any resources that failed to be removed from the group by this
    /// operation.</p>
    pub failed: std::option::Option<std::vec::Vec<crate::model::FailedResource>>,
    /// <p>A list of any resources that are still in the process of being removed from the group
    /// by this operation. These pending removals continue asynchronously. You can check the
    /// status of pending removals by using the <code>
    /// <a>ListGroupResources</a>
    /// </code> operation. After the resource is successfully removed, it no longer
    /// appears in the response.</p>
    pub pending: std::option::Option<std::vec::Vec<crate::model::PendingResource>>,
}
impl std::fmt::Debug for UngroupResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UngroupResourcesOutput");
        formatter.field("succeeded", &self.succeeded);
        formatter.field("failed", &self.failed);
        formatter.field("pending", &self.pending);
        formatter.finish()
    }
}
/// See [`UngroupResourcesOutput`](crate::output::UngroupResourcesOutput)
pub mod ungroup_resources_output {
    /// A builder for [`UngroupResourcesOutput`](crate::output::UngroupResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) succeeded: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::FailedResource>>,
        pub(crate) pending: std::option::Option<std::vec::Vec<crate::model::PendingResource>>,
    }
    impl Builder {
        /// Appends an item to `succeeded`.
        ///
        /// To override the contents of this collection use [`set_succeeded`](Self::set_succeeded).
        ///
        /// <p>A list of resources that were successfully removed from the group by this
        /// operation.</p>
        pub fn succeeded(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.succeeded.unwrap_or_default();
            v.push(input.into());
            self.succeeded = Some(v);
            self
        }
        /// <p>A list of resources that were successfully removed from the group by this
        /// operation.</p>
        pub fn set_succeeded(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.succeeded = input;
            self
        }
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// <p>A list of any resources that failed to be removed from the group by this
        /// operation.</p>
        pub fn failed(mut self, input: impl Into<crate::model::FailedResource>) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input.into());
            self.failed = Some(v);
            self
        }
        /// <p>A list of any resources that failed to be removed from the group by this
        /// operation.</p>
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedResource>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Appends an item to `pending`.
        ///
        /// To override the contents of this collection use [`set_pending`](Self::set_pending).
        ///
        /// <p>A list of any resources that are still in the process of being removed from the group
        /// by this operation. These pending removals continue asynchronously. You can check the
        /// status of pending removals by using the <code>
        /// <a>ListGroupResources</a>
        /// </code> operation. After the resource is successfully removed, it no longer
        /// appears in the response.</p>
        pub fn pending(mut self, input: impl Into<crate::model::PendingResource>) -> Self {
            let mut v = self.pending.unwrap_or_default();
            v.push(input.into());
            self.pending = Some(v);
            self
        }
        /// <p>A list of any resources that are still in the process of being removed from the group
        /// by this operation. These pending removals continue asynchronously. You can check the
        /// status of pending removals by using the <code>
        /// <a>ListGroupResources</a>
        /// </code> operation. After the resource is successfully removed, it no longer
        /// appears in the response.</p>
        pub fn set_pending(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingResource>>,
        ) -> Self {
            self.pending = input;
            self
        }
        /// Consumes the builder and constructs a [`UngroupResourcesOutput`](crate::output::UngroupResourcesOutput)
        pub fn build(self) -> crate::output::UngroupResourcesOutput {
            crate::output::UngroupResourcesOutput {
                succeeded: self.succeeded,
                failed: self.failed,
                pending: self.pending,
            }
        }
    }
}
impl UngroupResourcesOutput {
    /// Creates a new builder-style object to manufacture [`UngroupResourcesOutput`](crate::output::UngroupResourcesOutput)
    pub fn builder() -> crate::output::ungroup_resources_output::Builder {
        crate::output::ungroup_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagOutput {
    /// <p>The ARN of the tagged resource.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags that have been added to the specified resource group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagOutput");
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`TagOutput`](crate::output::TagOutput)
pub mod tag_output {
    /// A builder for [`TagOutput`](crate::output::TagOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the tagged resource.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the tagged resource.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that have been added to the specified resource group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags that have been added to the specified resource group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagOutput`](crate::output::TagOutput)
        pub fn build(self) -> crate::output::TagOutput {
            crate::output::TagOutput {
                arn: self.arn,
                tags: self.tags,
            }
        }
    }
}
impl TagOutput {
    /// Creates a new builder-style object to manufacture [`TagOutput`](crate::output::TagOutput)
    pub fn builder() -> crate::output::tag_output::Builder {
        crate::output::tag_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesOutput {
    /// <p>The ARNs and resource types of resources that are members of the group that you
    /// specified.</p>
    pub resource_identifiers: std::option::Option<std::vec::Vec<crate::model::ResourceIdentifier>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of <code>QueryError</code> objects. Each error is an object that contains
    /// <code>ErrorCode</code> and <code>Message</code> structures. Possible values for
    /// <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
    /// <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
    pub query_errors: std::option::Option<std::vec::Vec<crate::model::QueryError>>,
}
impl std::fmt::Debug for SearchResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesOutput");
        formatter.field("resource_identifiers", &self.resource_identifiers);
        formatter.field("next_token", &self.next_token);
        formatter.field("query_errors", &self.query_errors);
        formatter.finish()
    }
}
/// See [`SearchResourcesOutput`](crate::output::SearchResourcesOutput)
pub mod search_resources_output {
    /// A builder for [`SearchResourcesOutput`](crate::output::SearchResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifiers:
            std::option::Option<std::vec::Vec<crate::model::ResourceIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) query_errors: std::option::Option<std::vec::Vec<crate::model::QueryError>>,
    }
    impl Builder {
        /// Appends an item to `resource_identifiers`.
        ///
        /// To override the contents of this collection use [`set_resource_identifiers`](Self::set_resource_identifiers).
        ///
        /// <p>The ARNs and resource types of resources that are members of the group that you
        /// specified.</p>
        pub fn resource_identifiers(
            mut self,
            input: impl Into<crate::model::ResourceIdentifier>,
        ) -> Self {
            let mut v = self.resource_identifiers.unwrap_or_default();
            v.push(input.into());
            self.resource_identifiers = Some(v);
            self
        }
        /// <p>The ARNs and resource types of resources that are members of the group that you
        /// specified.</p>
        pub fn set_resource_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceIdentifier>>,
        ) -> Self {
            self.resource_identifiers = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `query_errors`.
        ///
        /// To override the contents of this collection use [`set_query_errors`](Self::set_query_errors).
        ///
        /// <p>A list of <code>QueryError</code> objects. Each error is an object that contains
        /// <code>ErrorCode</code> and <code>Message</code> structures. Possible values for
        /// <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
        /// <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
        pub fn query_errors(mut self, input: impl Into<crate::model::QueryError>) -> Self {
            let mut v = self.query_errors.unwrap_or_default();
            v.push(input.into());
            self.query_errors = Some(v);
            self
        }
        /// <p>A list of <code>QueryError</code> objects. Each error is an object that contains
        /// <code>ErrorCode</code> and <code>Message</code> structures. Possible values for
        /// <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
        /// <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
        pub fn set_query_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueryError>>,
        ) -> Self {
            self.query_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesOutput`](crate::output::SearchResourcesOutput)
        pub fn build(self) -> crate::output::SearchResourcesOutput {
            crate::output::SearchResourcesOutput {
                resource_identifiers: self.resource_identifiers,
                next_token: self.next_token,
                query_errors: self.query_errors,
            }
        }
    }
}
impl SearchResourcesOutput {
    /// Creates a new builder-style object to manufacture [`SearchResourcesOutput`](crate::output::SearchResourcesOutput)
    pub fn builder() -> crate::output::search_resources_output::Builder {
        crate::output::search_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutGroupConfigurationOutput {}
impl std::fmt::Debug for PutGroupConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutGroupConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutGroupConfigurationOutput`](crate::output::PutGroupConfigurationOutput)
pub mod put_group_configuration_output {
    /// A builder for [`PutGroupConfigurationOutput`](crate::output::PutGroupConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutGroupConfigurationOutput`](crate::output::PutGroupConfigurationOutput)
        pub fn build(self) -> crate::output::PutGroupConfigurationOutput {
            crate::output::PutGroupConfigurationOutput {}
        }
    }
}
impl PutGroupConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutGroupConfigurationOutput`](crate::output::PutGroupConfigurationOutput)
    pub fn builder() -> crate::output::put_group_configuration_output::Builder {
        crate::output::put_group_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsOutput {
    /// <p>A list of <a>GroupIdentifier</a> objects. Each identifier is an object that
    /// contains both the <code>Name</code> and the <code>GroupArn</code>.</p>
    pub group_identifiers: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
    /// <important>
    /// <p>
    /// <i>
    /// <b>Deprecated - don't use this field. Use the
    /// <code>GroupIdentifiers</code> response field
    /// instead.</b>
    /// </i>
    /// </p>
    /// </important>
    pub groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsOutput");
        formatter.field("group_identifiers", &self.group_identifiers);
        formatter.field("groups", &self.groups);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGroupsOutput`](crate::output::ListGroupsOutput)
pub mod list_groups_output {
    /// A builder for [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_identifiers:
            std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `group_identifiers`.
        ///
        /// To override the contents of this collection use [`set_group_identifiers`](Self::set_group_identifiers).
        ///
        /// <p>A list of <a>GroupIdentifier</a> objects. Each identifier is an object that
        /// contains both the <code>Name</code> and the <code>GroupArn</code>.</p>
        pub fn group_identifiers(
            mut self,
            input: impl Into<crate::model::GroupIdentifier>,
        ) -> Self {
            let mut v = self.group_identifiers.unwrap_or_default();
            v.push(input.into());
            self.group_identifiers = Some(v);
            self
        }
        /// <p>A list of <a>GroupIdentifier</a> objects. Each identifier is an object that
        /// contains both the <code>Name</code> and the <code>GroupArn</code>.</p>
        pub fn set_group_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupIdentifier>>,
        ) -> Self {
            self.group_identifiers = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <important>
        /// <p>
        /// <i>
        /// <b>Deprecated - don't use this field. Use the
        /// <code>GroupIdentifiers</code> response field
        /// instead.</b>
        /// </i>
        /// </p>
        /// </important>
        pub fn groups(mut self, input: impl Into<crate::model::Group>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <important>
        /// <p>
        /// <i>
        /// <b>Deprecated - don't use this field. Use the
        /// <code>GroupIdentifiers</code> response field
        /// instead.</b>
        /// </i>
        /// </p>
        /// </important>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsOutput`](crate::output::ListGroupsOutput)
        pub fn build(self) -> crate::output::ListGroupsOutput {
            crate::output::ListGroupsOutput {
                group_identifiers: self.group_identifiers,
                groups: self.groups,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    pub fn builder() -> crate::output::list_groups_output::Builder {
        crate::output::list_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupResourcesOutput {
    /// <p>An array of resources from which you can determine each resource's identity, type, and
    /// group membership status.</p>
    pub resources: std::option::Option<std::vec::Vec<crate::model::ListGroupResourcesItem>>,
    /// <important>
    /// <p>
    /// <b>
    /// <i>Deprecated - don't use this parameter. Use the
    /// <code>Resources</code> response field
    /// instead.</i>
    /// </b>
    /// </p>
    /// </important>
    pub resource_identifiers: std::option::Option<std::vec::Vec<crate::model::ResourceIdentifier>>,
    /// <p>If present, indicates that more output is available than is
    /// included in the current response. Use this value in the <code>NextToken</code> request parameter
    /// in a subsequent call to the operation to get the next part of the output. You should repeat this
    /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of <code>QueryError</code> objects. Each error is an object that contains
    /// <code>ErrorCode</code> and <code>Message</code> structures. Possible values for
    /// <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
    /// <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
    pub query_errors: std::option::Option<std::vec::Vec<crate::model::QueryError>>,
}
impl std::fmt::Debug for ListGroupResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupResourcesOutput");
        formatter.field("resources", &self.resources);
        formatter.field("resource_identifiers", &self.resource_identifiers);
        formatter.field("next_token", &self.next_token);
        formatter.field("query_errors", &self.query_errors);
        formatter.finish()
    }
}
/// See [`ListGroupResourcesOutput`](crate::output::ListGroupResourcesOutput)
pub mod list_group_resources_output {
    /// A builder for [`ListGroupResourcesOutput`](crate::output::ListGroupResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources:
            std::option::Option<std::vec::Vec<crate::model::ListGroupResourcesItem>>,
        pub(crate) resource_identifiers:
            std::option::Option<std::vec::Vec<crate::model::ResourceIdentifier>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) query_errors: std::option::Option<std::vec::Vec<crate::model::QueryError>>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>An array of resources from which you can determine each resource's identity, type, and
        /// group membership status.</p>
        pub fn resources(mut self, input: impl Into<crate::model::ListGroupResourcesItem>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>An array of resources from which you can determine each resource's identity, type, and
        /// group membership status.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListGroupResourcesItem>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `resource_identifiers`.
        ///
        /// To override the contents of this collection use [`set_resource_identifiers`](Self::set_resource_identifiers).
        ///
        /// <important>
        /// <p>
        /// <b>
        /// <i>Deprecated - don't use this parameter. Use the
        /// <code>Resources</code> response field
        /// instead.</i>
        /// </b>
        /// </p>
        /// </important>
        pub fn resource_identifiers(
            mut self,
            input: impl Into<crate::model::ResourceIdentifier>,
        ) -> Self {
            let mut v = self.resource_identifiers.unwrap_or_default();
            v.push(input.into());
            self.resource_identifiers = Some(v);
            self
        }
        /// <important>
        /// <p>
        /// <b>
        /// <i>Deprecated - don't use this parameter. Use the
        /// <code>Resources</code> response field
        /// instead.</i>
        /// </b>
        /// </p>
        /// </important>
        pub fn set_resource_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceIdentifier>>,
        ) -> Self {
            self.resource_identifiers = input;
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If present, indicates that more output is available than is
        /// included in the current response. Use this value in the <code>NextToken</code> request parameter
        /// in a subsequent call to the operation to get the next part of the output. You should repeat this
        /// until the <code>NextToken</code> response element comes back as <code>null</code>.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `query_errors`.
        ///
        /// To override the contents of this collection use [`set_query_errors`](Self::set_query_errors).
        ///
        /// <p>A list of <code>QueryError</code> objects. Each error is an object that contains
        /// <code>ErrorCode</code> and <code>Message</code> structures. Possible values for
        /// <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
        /// <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
        pub fn query_errors(mut self, input: impl Into<crate::model::QueryError>) -> Self {
            let mut v = self.query_errors.unwrap_or_default();
            v.push(input.into());
            self.query_errors = Some(v);
            self
        }
        /// <p>A list of <code>QueryError</code> objects. Each error is an object that contains
        /// <code>ErrorCode</code> and <code>Message</code> structures. Possible values for
        /// <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
        /// <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>
        pub fn set_query_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueryError>>,
        ) -> Self {
            self.query_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupResourcesOutput`](crate::output::ListGroupResourcesOutput)
        pub fn build(self) -> crate::output::ListGroupResourcesOutput {
            crate::output::ListGroupResourcesOutput {
                resources: self.resources,
                resource_identifiers: self.resource_identifiers,
                next_token: self.next_token,
                query_errors: self.query_errors,
            }
        }
    }
}
impl ListGroupResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupResourcesOutput`](crate::output::ListGroupResourcesOutput)
    pub fn builder() -> crate::output::list_group_resources_output::Builder {
        crate::output::list_group_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupResourcesOutput {
    /// <p>A list of ARNs of resources that were successfully added to the group by this
    /// operation.</p>
    pub succeeded: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of ARNs of any resources that failed to be added to the group by this
    /// operation.</p>
    pub failed: std::option::Option<std::vec::Vec<crate::model::FailedResource>>,
    /// <p>A list of ARNs of any resources that are still in the process of being added to the
    /// group by this operation. These pending additions continue asynchronously. You can check
    /// the status of pending additions by using the <code>
    /// <a>ListGroupResources</a>
    /// </code> operation, and checking the <code>Resources</code> array in the response
    /// and the <code>Status</code> field of each object in that array. </p>
    pub pending: std::option::Option<std::vec::Vec<crate::model::PendingResource>>,
}
impl std::fmt::Debug for GroupResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupResourcesOutput");
        formatter.field("succeeded", &self.succeeded);
        formatter.field("failed", &self.failed);
        formatter.field("pending", &self.pending);
        formatter.finish()
    }
}
/// See [`GroupResourcesOutput`](crate::output::GroupResourcesOutput)
pub mod group_resources_output {
    /// A builder for [`GroupResourcesOutput`](crate::output::GroupResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) succeeded: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failed: std::option::Option<std::vec::Vec<crate::model::FailedResource>>,
        pub(crate) pending: std::option::Option<std::vec::Vec<crate::model::PendingResource>>,
    }
    impl Builder {
        /// Appends an item to `succeeded`.
        ///
        /// To override the contents of this collection use [`set_succeeded`](Self::set_succeeded).
        ///
        /// <p>A list of ARNs of resources that were successfully added to the group by this
        /// operation.</p>
        pub fn succeeded(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.succeeded.unwrap_or_default();
            v.push(input.into());
            self.succeeded = Some(v);
            self
        }
        /// <p>A list of ARNs of resources that were successfully added to the group by this
        /// operation.</p>
        pub fn set_succeeded(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.succeeded = input;
            self
        }
        /// Appends an item to `failed`.
        ///
        /// To override the contents of this collection use [`set_failed`](Self::set_failed).
        ///
        /// <p>A list of ARNs of any resources that failed to be added to the group by this
        /// operation.</p>
        pub fn failed(mut self, input: impl Into<crate::model::FailedResource>) -> Self {
            let mut v = self.failed.unwrap_or_default();
            v.push(input.into());
            self.failed = Some(v);
            self
        }
        /// <p>A list of ARNs of any resources that failed to be added to the group by this
        /// operation.</p>
        pub fn set_failed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedResource>>,
        ) -> Self {
            self.failed = input;
            self
        }
        /// Appends an item to `pending`.
        ///
        /// To override the contents of this collection use [`set_pending`](Self::set_pending).
        ///
        /// <p>A list of ARNs of any resources that are still in the process of being added to the
        /// group by this operation. These pending additions continue asynchronously. You can check
        /// the status of pending additions by using the <code>
        /// <a>ListGroupResources</a>
        /// </code> operation, and checking the <code>Resources</code> array in the response
        /// and the <code>Status</code> field of each object in that array. </p>
        pub fn pending(mut self, input: impl Into<crate::model::PendingResource>) -> Self {
            let mut v = self.pending.unwrap_or_default();
            v.push(input.into());
            self.pending = Some(v);
            self
        }
        /// <p>A list of ARNs of any resources that are still in the process of being added to the
        /// group by this operation. These pending additions continue asynchronously. You can check
        /// the status of pending additions by using the <code>
        /// <a>ListGroupResources</a>
        /// </code> operation, and checking the <code>Resources</code> array in the response
        /// and the <code>Status</code> field of each object in that array. </p>
        pub fn set_pending(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingResource>>,
        ) -> Self {
            self.pending = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupResourcesOutput`](crate::output::GroupResourcesOutput)
        pub fn build(self) -> crate::output::GroupResourcesOutput {
            crate::output::GroupResourcesOutput {
                succeeded: self.succeeded,
                failed: self.failed,
                pending: self.pending,
            }
        }
    }
}
impl GroupResourcesOutput {
    /// Creates a new builder-style object to manufacture [`GroupResourcesOutput`](crate::output::GroupResourcesOutput)
    pub fn builder() -> crate::output::group_resources_output::Builder {
        crate::output::group_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsOutput {
    /// <p>The ARN of the tagged resource group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags associated with the specified resource group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for GetTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsOutput");
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetTagsOutput`](crate::output::GetTagsOutput)
pub mod get_tags_output {
    /// A builder for [`GetTagsOutput`](crate::output::GetTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the tagged resource group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the tagged resource group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the specified resource group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the specified resource group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsOutput`](crate::output::GetTagsOutput)
        pub fn build(self) -> crate::output::GetTagsOutput {
            crate::output::GetTagsOutput {
                arn: self.arn,
                tags: self.tags,
            }
        }
    }
}
impl GetTagsOutput {
    /// Creates a new builder-style object to manufacture [`GetTagsOutput`](crate::output::GetTagsOutput)
    pub fn builder() -> crate::output::get_tags_output::Builder {
        crate::output::get_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupQueryOutput {
    /// <p>The resource query associated with the specified group. For more information about
    /// resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
    /// a tag-based group in Resource Groups</a>.</p>
    pub group_query: std::option::Option<crate::model::GroupQuery>,
}
impl std::fmt::Debug for GetGroupQueryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupQueryOutput");
        formatter.field("group_query", &self.group_query);
        formatter.finish()
    }
}
/// See [`GetGroupQueryOutput`](crate::output::GetGroupQueryOutput)
pub mod get_group_query_output {
    /// A builder for [`GetGroupQueryOutput`](crate::output::GetGroupQueryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_query: std::option::Option<crate::model::GroupQuery>,
    }
    impl Builder {
        /// <p>The resource query associated with the specified group. For more information about
        /// resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>.</p>
        pub fn group_query(mut self, input: crate::model::GroupQuery) -> Self {
            self.group_query = Some(input);
            self
        }
        /// <p>The resource query associated with the specified group. For more information about
        /// resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>.</p>
        pub fn set_group_query(
            mut self,
            input: std::option::Option<crate::model::GroupQuery>,
        ) -> Self {
            self.group_query = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupQueryOutput`](crate::output::GetGroupQueryOutput)
        pub fn build(self) -> crate::output::GetGroupQueryOutput {
            crate::output::GetGroupQueryOutput {
                group_query: self.group_query,
            }
        }
    }
}
impl GetGroupQueryOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupQueryOutput`](crate::output::GetGroupQueryOutput)
    pub fn builder() -> crate::output::get_group_query_output::Builder {
        crate::output::get_group_query_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupConfigurationOutput {
    /// <p>The service configuration associated with the specified group. For details about the
    /// service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
    /// groups</a>.</p>
    pub group_configuration: std::option::Option<crate::model::GroupConfiguration>,
}
impl std::fmt::Debug for GetGroupConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupConfigurationOutput");
        formatter.field("group_configuration", &self.group_configuration);
        formatter.finish()
    }
}
/// See [`GetGroupConfigurationOutput`](crate::output::GetGroupConfigurationOutput)
pub mod get_group_configuration_output {
    /// A builder for [`GetGroupConfigurationOutput`](crate::output::GetGroupConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_configuration: std::option::Option<crate::model::GroupConfiguration>,
    }
    impl Builder {
        /// <p>The service configuration associated with the specified group. For details about the
        /// service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        pub fn group_configuration(mut self, input: crate::model::GroupConfiguration) -> Self {
            self.group_configuration = Some(input);
            self
        }
        /// <p>The service configuration associated with the specified group. For details about the
        /// service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        pub fn set_group_configuration(
            mut self,
            input: std::option::Option<crate::model::GroupConfiguration>,
        ) -> Self {
            self.group_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupConfigurationOutput`](crate::output::GetGroupConfigurationOutput)
        pub fn build(self) -> crate::output::GetGroupConfigurationOutput {
            crate::output::GetGroupConfigurationOutput {
                group_configuration: self.group_configuration,
            }
        }
    }
}
impl GetGroupConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupConfigurationOutput`](crate::output::GetGroupConfigurationOutput)
    pub fn builder() -> crate::output::get_group_configuration_output::Builder {
        crate::output::get_group_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupOutput {
    /// <p>A full description of the resource group.</p>
    pub group: std::option::Option<crate::model::Group>,
}
impl std::fmt::Debug for GetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`GetGroupOutput`](crate::output::GetGroupOutput)
pub mod get_group_output {
    /// A builder for [`GetGroupOutput`](crate::output::GetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
    }
    impl Builder {
        /// <p>A full description of the resource group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>A full description of the resource group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupOutput`](crate::output::GetGroupOutput)
        pub fn build(self) -> crate::output::GetGroupOutput {
            crate::output::GetGroupOutput { group: self.group }
        }
    }
}
impl GetGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupOutput`](crate::output::GetGroupOutput)
    pub fn builder() -> crate::output::get_group_output::Builder {
        crate::output::get_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupOutput {
    /// <p>A full description of the deleted resource group.</p>
    pub group: std::option::Option<crate::model::Group>,
}
impl std::fmt::Debug for DeleteGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
pub mod delete_group_output {
    /// A builder for [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
    }
    impl Builder {
        /// <p>A full description of the deleted resource group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>A full description of the deleted resource group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
        pub fn build(self) -> crate::output::DeleteGroupOutput {
            crate::output::DeleteGroupOutput { group: self.group }
        }
    }
}
impl DeleteGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    pub fn builder() -> crate::output::delete_group_output::Builder {
        crate::output::delete_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupOutput {
    /// <p>The description of the resource group.</p>
    pub group: std::option::Option<crate::model::Group>,
    /// <p>The resource query associated with the group. For more information about resource
    /// queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
    /// a tag-based group in Resource Groups</a>. </p>
    pub resource_query: std::option::Option<crate::model::ResourceQuery>,
    /// <p>The tags associated with the group.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The service configuration associated with the resource group. For details about the
    /// syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
    /// groups</a>.</p>
    pub group_configuration: std::option::Option<crate::model::GroupConfiguration>,
}
impl std::fmt::Debug for CreateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupOutput");
        formatter.field("group", &self.group);
        formatter.field("resource_query", &self.resource_query);
        formatter.field("tags", &self.tags);
        formatter.field("group_configuration", &self.group_configuration);
        formatter.finish()
    }
}
/// See [`CreateGroupOutput`](crate::output::CreateGroupOutput)
pub mod create_group_output {
    /// A builder for [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
        pub(crate) resource_query: std::option::Option<crate::model::ResourceQuery>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) group_configuration: std::option::Option<crate::model::GroupConfiguration>,
    }
    impl Builder {
        /// <p>The description of the resource group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>The description of the resource group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// <p>The resource query associated with the group. For more information about resource
        /// queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>. </p>
        pub fn resource_query(mut self, input: crate::model::ResourceQuery) -> Self {
            self.resource_query = Some(input);
            self
        }
        /// <p>The resource query associated with the group. For more information about resource
        /// queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>. </p>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.resource_query = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the group.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The service configuration associated with the resource group. For details about the
        /// syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        pub fn group_configuration(mut self, input: crate::model::GroupConfiguration) -> Self {
            self.group_configuration = Some(input);
            self
        }
        /// <p>The service configuration associated with the resource group. For details about the
        /// syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        pub fn set_group_configuration(
            mut self,
            input: std::option::Option<crate::model::GroupConfiguration>,
        ) -> Self {
            self.group_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupOutput`](crate::output::CreateGroupOutput)
        pub fn build(self) -> crate::output::CreateGroupOutput {
            crate::output::CreateGroupOutput {
                group: self.group,
                resource_query: self.resource_query,
                tags: self.tags,
                group_configuration: self.group_configuration,
            }
        }
    }
}
impl CreateGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    pub fn builder() -> crate::output::create_group_output::Builder {
        crate::output::create_group_output::Builder::default()
    }
}
