// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateGroupInput`](crate::input::CreateGroupInput)
pub mod create_group_input {
    /// A builder for [`CreateGroupInput`](crate::input::CreateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) resource_query: std::option::Option<crate::model::ResourceQuery>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) configuration:
            std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
    }
    impl Builder {
        /// <p>The name of the group, which is the identifier of the group in other operations. You
        /// can't change the name of a resource group after you create it. A resource group name can
        /// consist of letters, numbers, hyphens, periods, and underscores. The name cannot start
        /// with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name
        /// must be unique within each AWS Region in your AWS account.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the group, which is the identifier of the group in other operations. You
        /// can't change the name of a resource group after you create it. A resource group name can
        /// consist of letters, numbers, hyphens, periods, and underscores. The name cannot start
        /// with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name
        /// must be unique within each AWS Region in your AWS account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the resource group. Descriptions can consist of letters, numbers,
        /// hyphens, underscores, periods, and spaces.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the resource group. Descriptions can consist of letters, numbers,
        /// hyphens, underscores, periods, and spaces.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The resource query that determines which AWS resources are members of this group.
        /// For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>. </p>
        /// <note>
        /// <p>A resource group can contain either a <code>ResourceQuery</code> or a
        /// <code>Configuration</code>, but not both.</p>
        /// </note>
        pub fn resource_query(mut self, input: crate::model::ResourceQuery) -> Self {
            self.resource_query = Some(input);
            self
        }
        /// <p>The resource query that determines which AWS resources are members of this group.
        /// For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>. </p>
        /// <note>
        /// <p>A resource group can contain either a <code>ResourceQuery</code> or a
        /// <code>Configuration</code>, but not both.</p>
        /// </note>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.resource_query = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the group. A tag is key-value pair string.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the group. A tag is key-value pair string.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>A configuration associates the resource group with an AWS service and specifies how
        /// the service can interact with the resources in the group. A configuration is an array of
        /// <a>GroupConfigurationItem</a> elements. For details about the syntax of
        /// service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn configuration(
            mut self,
            input: impl Into<crate::model::GroupConfigurationItem>,
        ) -> Self {
            let mut v = self.configuration.unwrap_or_default();
            v.push(input.into());
            self.configuration = Some(v);
            self
        }
        /// <p>A configuration associates the resource group with an AWS service and specifies how
        /// the service can interact with the resources in the group. A configuration is an array of
        /// <a>GroupConfigurationItem</a> elements. For details about the syntax of
        /// service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupInput`](crate::input::CreateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupInput {
                name: self.name,
                description: self.description,
                resource_query: self.resource_query,
                tags: self.tags,
                configuration: self.configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupInputOperationOutputAlias = crate::operation::CreateGroup;
#[doc(hidden)]
pub type CreateGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroup`](crate::operation::CreateGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/groups").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroup",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
}

/// See [`DeleteGroupInput`](crate::input::DeleteGroupInput)
pub mod delete_group_input {
    /// A builder for [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name or the ARN of the resource group to delete.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to delete.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupInput`](crate::input::DeleteGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupInput {
                group_name: self.group_name,
                group: self.group,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupInputOperationOutputAlias = crate::operation::DeleteGroup;
#[doc(hidden)]
pub type DeleteGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroup`](crate::operation::DeleteGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delete-group").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroup",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
}

/// See [`GetGroupInput`](crate::input::GetGroupInput)
pub mod get_group_input {
    /// A builder for [`GetGroupInput`](crate::input::GetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name or the ARN of the resource group to retrieve.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to retrieve.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupInput`](crate::input::GetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGroupInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGroupInput {
                group_name: self.group_name,
                group: self.group,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupInputOperationOutputAlias = crate::operation::GetGroup;
#[doc(hidden)]
pub type GetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetGroup`](crate::operation::GetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/get-group").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGroup::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetGroup",
                    "resourcegroups",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupInput`](crate::input::GetGroupInput)
    pub fn builder() -> crate::input::get_group_input::Builder {
        crate::input::get_group_input::Builder::default()
    }
}

/// See [`GetGroupConfigurationInput`](crate::input::GetGroupConfigurationInput)
pub mod get_group_configuration_input {
    /// A builder for [`GetGroupConfigurationInput`](crate::input::GetGroupConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or the ARN of the resource group.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupConfigurationInput`](crate::input::GetGroupConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGroupConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGroupConfigurationInput { group: self.group })
        }
    }
}
#[doc(hidden)]
pub type GetGroupConfigurationInputOperationOutputAlias = crate::operation::GetGroupConfiguration;
#[doc(hidden)]
pub type GetGroupConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetGroupConfiguration`](crate::operation::GetGroupConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroupConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/get-group-configuration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_group_configuration(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGroupConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGroupConfiguration",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupConfigurationInput`](crate::input::GetGroupConfigurationInput)
    pub fn builder() -> crate::input::get_group_configuration_input::Builder {
        crate::input::get_group_configuration_input::Builder::default()
    }
}

/// See [`GetGroupQueryInput`](crate::input::GetGroupQueryInput)
pub mod get_group_query_input {
    /// A builder for [`GetGroupQueryInput`](crate::input::GetGroupQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupQueryInput`](crate::input::GetGroupQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGroupQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGroupQueryInput {
                group_name: self.group_name,
                group: self.group,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupQueryInputOperationOutputAlias = crate::operation::GetGroupQuery;
#[doc(hidden)]
pub type GetGroupQueryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupQueryInput {
    /// Consumes the builder and constructs an Operation<[`GetGroupQuery`](crate::operation::GetGroupQuery)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroupQuery,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupQueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/get-group-query").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupQueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupQueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_group_query(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGroupQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGroupQuery",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupQueryInput`](crate::input::GetGroupQueryInput)
    pub fn builder() -> crate::input::get_group_query_input::Builder {
        crate::input::get_group_query_input::Builder::default()
    }
}

/// See [`GetTagsInput`](crate::input::GetTagsInput)
pub mod get_tags_input {
    /// A builder for [`GetTagsInput`](crate::input::GetTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource group whose tags you want to retrieve.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource group whose tags you want to retrieve.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsInput`](crate::input::GetTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTagsInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetTagsInputOperationOutputAlias = crate::operation::GetTags;
#[doc(hidden)]
pub type GetTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTagsInput {
    /// Consumes the builder and constructs an Operation<[`GetTags`](crate::operation::GetTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_1, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/resources/{Arn}/tags", Arn = arn).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTags",
                    "resourcegroups",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
}

/// See [`GroupResourcesInput`](crate::input::GroupResourcesInput)
pub mod group_resources_input {
    /// A builder for [`GroupResourcesInput`](crate::input::GroupResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name or the ARN of the resource group to add resources to.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to add resources to.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The list of ARNs for resources to be added to the group. </p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The list of ARNs for resources to be added to the group. </p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupResourcesInput`](crate::input::GroupResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GroupResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GroupResourcesInput {
                group: self.group,
                resource_arns: self.resource_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type GroupResourcesInputOperationOutputAlias = crate::operation::GroupResources;
#[doc(hidden)]
pub type GroupResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GroupResourcesInput {
    /// Consumes the builder and constructs an Operation<[`GroupResources`](crate::operation::GroupResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GroupResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GroupResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/group-resources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GroupResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GroupResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_group_resources(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GroupResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GroupResources",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GroupResourcesInput`](crate::input::GroupResourcesInput)
    pub fn builder() -> crate::input::group_resources_input::Builder {
        crate::input::group_resources_input::Builder::default()
    }
}

/// See [`ListGroupResourcesInput`](crate::input::ListGroupResourcesInput)
pub mod list_group_resources_input {
    /// A builder for [`ListGroupResourcesInput`](crate::input::ListGroupResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ResourceFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <important>
        /// <p>
        /// <i>
        /// <b>Deprecated - don't use this parameter. Use the
        /// <code>Group</code> request field instead.</b>
        /// </i>
        /// </p>
        /// </important>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <important>
        /// <p>
        /// <i>
        /// <b>Deprecated - don't use this parameter. Use the
        /// <code>Group</code> request field instead.</b>
        /// </i>
        /// </p>
        /// </important>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name or the ARN of the resource group</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply
        /// to a <code>ListGroupResources</code> operation. Filters the results to include only
        /// those of the specified resource types.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter resources by their type. Specify up to
        /// five resource types in the format <code>AWS::ServiceCode::ResourceType</code>.
        /// For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you specify a <code>resource-type</code> filter for
        /// <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types
        /// against the types that are defined in the query associated with the group. For example,
        /// if a group contains only S3 buckets because its query specifies only that resource type,
        /// but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
        /// does not filter for EC2 instances. In this case, a <code>ListGroupResources</code>
        /// request returns a <code>BadRequestException</code> error with a message similar to the
        /// following:</p>
        /// <p>
        /// <code>The resource types specified as filters in the request are not
        /// valid.</code>
        /// </p>
        /// <p>The error includes a list of resource types that failed the validation because they
        /// are not part of the query associated with the group. This validation doesn't occur when
        /// the group query specifies <code>AWS::AllSupported</code>, because a group based on such
        /// a query can contain any of the allowed resource types for the query type (tag-based or
        /// AWS CloudFormation stack-based queries).</p>
        pub fn filters(mut self, input: impl Into<crate::model::ResourceFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply
        /// to a <code>ListGroupResources</code> operation. Filters the results to include only
        /// those of the specified resource types.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter resources by their type. Specify up to
        /// five resource types in the format <code>AWS::ServiceCode::ResourceType</code>.
        /// For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you specify a <code>resource-type</code> filter for
        /// <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types
        /// against the types that are defined in the query associated with the group. For example,
        /// if a group contains only S3 buckets because its query specifies only that resource type,
        /// but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
        /// does not filter for EC2 instances. In this case, a <code>ListGroupResources</code>
        /// request returns a <code>BadRequestException</code> error with a message similar to the
        /// following:</p>
        /// <p>
        /// <code>The resource types specified as filters in the request are not
        /// valid.</code>
        /// </p>
        /// <p>The error includes a list of resource types that failed the validation because they
        /// are not part of the query associated with the group. This validation doesn't occur when
        /// the group query specifies <code>AWS::AllSupported</code>, because a group based on such
        /// a query can contain any of the allowed resource types for the query type (tag-based or
        /// AWS CloudFormation stack-based queries).</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupResourcesInput`](crate::input::ListGroupResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupResourcesInput {
                group_name: self.group_name,
                group: self.group,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupResourcesInputOperationOutputAlias = crate::operation::ListGroupResources;
#[doc(hidden)]
pub type ListGroupResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupResources`](crate::operation::ListGroupResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-group-resources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_group_resources(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupResources",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupResourcesInput`](crate::input::ListGroupResourcesInput)
    pub fn builder() -> crate::input::list_group_resources_input::Builder {
        crate::input::list_group_resources_input::Builder::default()
    }
}

/// See [`ListGroupsInput`](crate::input::ListGroupsInput)
pub mod list_groups_input {
    /// A builder for [`ListGroupsInput`](crate::input::ListGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::GroupFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to
        /// a <code>ListGroups</code> operation.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter the results to include only those of the
        /// specified resource types. Specify up to five resource types in the format
        /// <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i>
        /// </code>.
        /// For example, <code>AWS::EC2::Instance</code>, or
        /// <code>AWS::S3::Bucket</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>configuration-type</code> - Filter the results to include only those
        /// groups that have the specified configuration types attached. The current
        /// supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::CapacityReservationPool</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::HostManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn filters(mut self, input: impl Into<crate::model::GroupFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to
        /// a <code>ListGroups</code> operation.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter the results to include only those of the
        /// specified resource types. Specify up to five resource types in the format
        /// <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i>
        /// </code>.
        /// For example, <code>AWS::EC2::Instance</code>, or
        /// <code>AWS::S3::Bucket</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>configuration-type</code> - Filter the results to include only those
        /// groups that have the specified configuration types attached. The current
        /// supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::CapacityReservationPool</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::HostManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsInput`](crate::input::ListGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsInputOperationOutputAlias = crate::operation::ListGroups;
#[doc(hidden)]
pub type ListGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroups`](crate::operation::ListGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/groups-list").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListGroupsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_2) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_2).encode(),
                );
            }
            if let Some(inner_3) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_3));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_groups(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroups",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
}

/// See [`PutGroupConfigurationInput`](crate::input::PutGroupConfigurationInput)
pub mod put_group_configuration_input {
    /// A builder for [`PutGroupConfigurationInput`](crate::input::PutGroupConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) configuration:
            std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
    }
    impl Builder {
        /// <p>The name or ARN of the resource group with the configuration that you want to
        /// update.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or ARN of the resource group with the configuration that you want to
        /// update.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>The new configuration to associate with the specified group. A configuration
        /// associates the resource group with an AWS service and specifies how the service can
        /// interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
        /// <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
        /// resource groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn configuration(
            mut self,
            input: impl Into<crate::model::GroupConfigurationItem>,
        ) -> Self {
            let mut v = self.configuration.unwrap_or_default();
            v.push(input.into());
            self.configuration = Some(v);
            self
        }
        /// <p>The new configuration to associate with the specified group. A configuration
        /// associates the resource group with an AWS service and specifies how the service can
        /// interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
        /// <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
        /// resource groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutGroupConfigurationInput`](crate::input::PutGroupConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutGroupConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutGroupConfigurationInput {
                group: self.group,
                configuration: self.configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutGroupConfigurationInputOperationOutputAlias = crate::operation::PutGroupConfiguration;
#[doc(hidden)]
pub type PutGroupConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutGroupConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutGroupConfiguration`](crate::operation::PutGroupConfiguration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutGroupConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutGroupConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/put-group-configuration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutGroupConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutGroupConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_group_configuration(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutGroupConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutGroupConfiguration",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutGroupConfigurationInput`](crate::input::PutGroupConfigurationInput)
    pub fn builder() -> crate::input::put_group_configuration_input::Builder {
        crate::input::put_group_configuration_input::Builder::default()
    }
}

/// See [`SearchResourcesInput`](crate::input::SearchResourcesInput)
pub mod search_resources_input {
    /// A builder for [`SearchResourcesInput`](crate::input::SearchResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_query: std::option::Option<crate::model::ResourceQuery>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The search query, using the same formats that are supported for resource group
        /// definition. For more information, see <a>CreateGroup</a>.</p>
        pub fn resource_query(mut self, input: crate::model::ResourceQuery) -> Self {
            self.resource_query = Some(input);
            self
        }
        /// <p>The search query, using the same formats that are supported for resource group
        /// definition. For more information, see <a>CreateGroup</a>.</p>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.resource_query = input;
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesInput`](crate::input::SearchResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchResourcesInput {
                resource_query: self.resource_query,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchResourcesInputOperationOutputAlias = crate::operation::SearchResources;
#[doc(hidden)]
pub type SearchResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchResourcesInput {
    /// Consumes the builder and constructs an Operation<[`SearchResources`](crate::operation::SearchResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/resources/search").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_resources(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchResources",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchResourcesInput`](crate::input::SearchResourcesInput)
    pub fn builder() -> crate::input::search_resources_input::Builder {
        crate::input::search_resources_input::Builder::default()
    }
}

/// See [`TagInput`](crate::input::TagInput)
pub mod tag_input {
    /// A builder for [`TagInput`](crate::input::TagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource group to which to add tags.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource group to which to add tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the specified resource group. A tag is a string-to-string map of
        /// key-value pairs.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to add to the specified resource group. A tag is a string-to-string map of
        /// key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagInput`](crate::input::TagInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::TagInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::TagInput {
                arn: self.arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagInputOperationOutputAlias = crate::operation::Tag;
#[doc(hidden)]
pub type TagInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagInput {
    /// Consumes the builder and constructs an Operation<[`Tag`](crate::operation::Tag)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<crate::operation::Tag, aws_http::AwsErrorRetryPolicy>,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.arn;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_4, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/resources/{Arn}/tags", Arn = arn).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag(&self).map_err(
            |err| aws_smithy_http::operation::BuildError::SerializationError(err.into()),
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(request, crate::operation::Tag::new())
            .with_metadata(aws_smithy_http::operation::Metadata::new(
                "Tag",
                "resourcegroups",
            ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagInput`](crate::input::TagInput)
    pub fn builder() -> crate::input::tag_input::Builder {
        crate::input::tag_input::Builder::default()
    }
}

/// See [`UngroupResourcesInput`](crate::input::UngroupResourcesInput)
pub mod ungroup_resources_input {
    /// A builder for [`UngroupResourcesInput`](crate::input::UngroupResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name or the ARN of the resource group from which to remove the resources.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group from which to remove the resources.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `resource_arns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The ARNs of the resources to be removed from the group.</p>
        pub fn resource_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arns.unwrap_or_default();
            v.push(input.into());
            self.resource_arns = Some(v);
            self
        }
        /// <p>The ARNs of the resources to be removed from the group.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`UngroupResourcesInput`](crate::input::UngroupResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UngroupResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UngroupResourcesInput {
                group: self.group,
                resource_arns: self.resource_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type UngroupResourcesInputOperationOutputAlias = crate::operation::UngroupResources;
#[doc(hidden)]
pub type UngroupResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UngroupResourcesInput {
    /// Consumes the builder and constructs an Operation<[`UngroupResources`](crate::operation::UngroupResources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UngroupResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UngroupResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ungroup-resources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UngroupResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UngroupResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_ungroup_resources(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UngroupResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UngroupResources",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UngroupResourcesInput`](crate::input::UngroupResourcesInput)
    pub fn builder() -> crate::input::ungroup_resources_input::Builder {
        crate::input::ungroup_resources_input::Builder::default()
    }
}

/// See [`UntagInput`](crate::input::UntagInput)
pub mod untag_input {
    /// A builder for [`UntagInput`](crate::input::UntagInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource group from which to remove tags. The command removed both the
        /// specified keys and any values associated with those keys.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource group from which to remove tags. The command removed both the
        /// specified keys and any values associated with those keys.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagInput`](crate::input::UntagInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UntagInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UntagInput {
                arn: self.arn,
                keys: self.keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagInputOperationOutputAlias = crate::operation::Untag;
#[doc(hidden)]
pub type UntagInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagInput {
    /// Consumes the builder and constructs an Operation<[`Untag`](crate::operation::Untag)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Untag,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.arn;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "arn",
                        details: "cannot be empty or unset",
                    })?;
            let arn = aws_smithy_http::label::fmt_string(input_5, false);
            if arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/resources/{Arn}/tags", Arn = arn).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag(&self).map_err(
            |err| aws_smithy_http::operation::BuildError::SerializationError(err.into()),
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Untag::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "Untag",
                    "resourcegroups",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagInput`](crate::input::UntagInput)
    pub fn builder() -> crate::input::untag_input::Builder {
        crate::input::untag_input::Builder::default()
    }
}

/// See [`UpdateGroupInput`](crate::input::UpdateGroupInput)
pub mod update_group_input {
    /// A builder for [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name or the ARN of the resource group to modify.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to modify.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// <p>The new description that you want to update the resource group with. Descriptions can
        /// contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description that you want to update the resource group with. Descriptions can
        /// contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupInput`](crate::input::UpdateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGroupInput {
                group_name: self.group_name,
                group: self.group,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGroupInputOperationOutputAlias = crate::operation::UpdateGroup;
#[doc(hidden)]
pub type UpdateGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGroup`](crate::operation::UpdateGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/update-group").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGroup",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGroupInput`](crate::input::UpdateGroupInput)
    pub fn builder() -> crate::input::update_group_input::Builder {
        crate::input::update_group_input::Builder::default()
    }
}

/// See [`UpdateGroupQueryInput`](crate::input::UpdateGroupQueryInput)
pub mod update_group_query_input {
    /// A builder for [`UpdateGroupQueryInput`](crate::input::UpdateGroupQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) resource_query: std::option::Option<crate::model::ResourceQuery>,
    }
    impl Builder {
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// <p>The resource query to determine which AWS resources are members of this resource
        /// group.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn resource_query(mut self, input: crate::model::ResourceQuery) -> Self {
            self.resource_query = Some(input);
            self
        }
        /// <p>The resource query to determine which AWS resources are members of this resource
        /// group.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.resource_query = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGroupQueryInput`](crate::input::UpdateGroupQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGroupQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGroupQueryInput {
                group_name: self.group_name,
                group: self.group,
                resource_query: self.resource_query,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGroupQueryInputOperationOutputAlias = crate::operation::UpdateGroupQuery;
#[doc(hidden)]
pub type UpdateGroupQueryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateGroupQueryInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGroupQuery`](crate::operation::UpdateGroupQuery)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGroupQuery,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateGroupQueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/update-group-query").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateGroupQueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateGroupQueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_group_query(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGroupQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGroupQuery",
            "resourcegroups",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateGroupQueryInput`](crate::input::UpdateGroupQueryInput)
    pub fn builder() -> crate::input::update_group_query_input::Builder {
        crate::input::update_group_query_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupQueryInput {
    /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name or the ARN of the resource group to query.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The resource query to determine which AWS resources are members of this resource
    /// group.</p>
    /// <note>
    /// <p>A resource group can contain either a <code>Configuration</code> or a
    /// <code>ResourceQuery</code>, but not both.</p>
    /// </note>
    pub resource_query: std::option::Option<crate::model::ResourceQuery>,
}
impl std::fmt::Debug for UpdateGroupQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupQueryInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group", &self.group);
        formatter.field("resource_query", &self.resource_query);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupInput {
    /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name or the ARN of the resource group to modify.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The new description that you want to update the resource group with. Descriptions can
    /// contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group", &self.group);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagInput {
    /// <p>The ARN of the resource group from which to remove tags. The command removed both the
    /// specified keys and any values associated with those keys.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to be removed.</p>
    pub keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagInput");
        formatter.field("arn", &self.arn);
        formatter.field("keys", &self.keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UngroupResourcesInput {
    /// <p>The name or the ARN of the resource group from which to remove the resources.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The ARNs of the resources to be removed from the group.</p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UngroupResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UngroupResourcesInput");
        formatter.field("group", &self.group);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagInput {
    /// <p>The ARN of the resource group to which to add tags.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the specified resource group. A tag is a string-to-string map of
    /// key-value pairs.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagInput");
        formatter.field("arn", &self.arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesInput {
    /// <p>The search query, using the same formats that are supported for resource group
    /// definition. For more information, see <a>CreateGroup</a>.</p>
    pub resource_query: std::option::Option<crate::model::ResourceQuery>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that the service might return fewer results than the maximum even when there
    /// are more results available. You should check <code>NextToken</code> after every operation to
    /// ensure that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value provided by a previous
    /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SearchResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesInput");
        formatter.field("resource_query", &self.resource_query);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutGroupConfigurationInput {
    /// <p>The name or ARN of the resource group with the configuration that you want to
    /// update.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The new configuration to associate with the specified group. A configuration
    /// associates the resource group with an AWS service and specifies how the service can
    /// interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
    /// <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
    /// resource groups</a>.</p>
    /// <note>
    /// <p>A resource group can contain either a <code>Configuration</code> or a
    /// <code>ResourceQuery</code>, but not both.</p>
    /// </note>
    pub configuration: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
}
impl std::fmt::Debug for PutGroupConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutGroupConfigurationInput");
        formatter.field("group", &self.group);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsInput {
    /// <p>Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to
    /// a <code>ListGroups</code> operation.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-type</code> - Filter the results to include only those of the
    /// specified resource types. Specify up to five resource types in the format
    /// <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i>
    /// </code>.
    /// For example, <code>AWS::EC2::Instance</code>, or
    /// <code>AWS::S3::Bucket</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>configuration-type</code> - Filter the results to include only those
    /// groups that have the specified configuration types attached. The current
    /// supported values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AWS:EC2::CapacityReservationPool</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AWS:EC2::HostManagement</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::GroupFilter>>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that the service might return fewer results than the maximum even when there
    /// are more results available. You should check <code>NextToken</code> after every operation to
    /// ensure that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value provided by a previous
    /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupResourcesInput {
    /// <important>
    /// <p>
    /// <i>
    /// <b>Deprecated - don't use this parameter. Use the
    /// <code>Group</code> request field instead.</b>
    /// </i>
    /// </p>
    /// </important>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name or the ARN of the resource group</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply
    /// to a <code>ListGroupResources</code> operation. Filters the results to include only
    /// those of the specified resource types.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-type</code> - Filter resources by their type. Specify up to
    /// five resource types in the format <code>AWS::ServiceCode::ResourceType</code>.
    /// For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>When you specify a <code>resource-type</code> filter for
    /// <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types
    /// against the types that are defined in the query associated with the group. For example,
    /// if a group contains only S3 buckets because its query specifies only that resource type,
    /// but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
    /// does not filter for EC2 instances. In this case, a <code>ListGroupResources</code>
    /// request returns a <code>BadRequestException</code> error with a message similar to the
    /// following:</p>
    /// <p>
    /// <code>The resource types specified as filters in the request are not
    /// valid.</code>
    /// </p>
    /// <p>The error includes a list of resource types that failed the validation because they
    /// are not part of the query associated with the group. This validation doesn't occur when
    /// the group query specifies <code>AWS::AllSupported</code>, because a group based on such
    /// a query can contain any of the allowed resource types for the query type (tag-based or
    /// AWS CloudFormation stack-based queries).</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ResourceFilter>>,
    /// <p>The total number of results that you want included on each page of the
    /// response. If you do not include this parameter, it defaults to a value that is specific to the
    /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
    /// response element is present and has a value (is not null). Include that value as the
    /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
    /// of the results. Note that the service might return fewer results than the maximum even when there
    /// are more results available. You should check <code>NextToken</code> after every operation to
    /// ensure that you receive all of the results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The parameter for receiving additional results if you receive a
    /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
    /// indicates that more output is available. Set this parameter to the value provided by a previous
    /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListGroupResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupResourcesInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group", &self.group);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupResourcesInput {
    /// <p>The name or the ARN of the resource group to add resources to.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The list of ARNs for resources to be added to the group. </p>
    pub resource_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for GroupResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupResourcesInput");
        formatter.field("group", &self.group);
        formatter.field("resource_arns", &self.resource_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsInput {
    /// <p>The ARN of the resource group whose tags you want to retrieve.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupQueryInput {
    /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name or the ARN of the resource group to query.</p>
    pub group: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupQueryInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group", &self.group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupConfigurationInput {
    /// <p>The name or the ARN of the resource group.</p>
    pub group: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupConfigurationInput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupInput {
    /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name or the ARN of the resource group to retrieve.</p>
    pub group: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group", &self.group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupInput {
    /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name or the ARN of the resource group to delete.</p>
    pub group: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupInput");
        formatter.field("group_name", &self.group_name);
        formatter.field("group", &self.group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupInput {
    /// <p>The name of the group, which is the identifier of the group in other operations. You
    /// can't change the name of a resource group after you create it. A resource group name can
    /// consist of letters, numbers, hyphens, periods, and underscores. The name cannot start
    /// with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name
    /// must be unique within each AWS Region in your AWS account.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the resource group. Descriptions can consist of letters, numbers,
    /// hyphens, underscores, periods, and spaces.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The resource query that determines which AWS resources are members of this group.
    /// For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
    /// a tag-based group in Resource Groups</a>. </p>
    /// <note>
    /// <p>A resource group can contain either a <code>ResourceQuery</code> or a
    /// <code>Configuration</code>, but not both.</p>
    /// </note>
    pub resource_query: std::option::Option<crate::model::ResourceQuery>,
    /// <p>The tags to add to the group. A tag is key-value pair string.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A configuration associates the resource group with an AWS service and specifies how
    /// the service can interact with the resources in the group. A configuration is an array of
    /// <a>GroupConfigurationItem</a> elements. For details about the syntax of
    /// service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
    /// groups</a>.</p>
    /// <note>
    /// <p>A resource group can contain either a <code>Configuration</code> or a
    /// <code>ResourceQuery</code>, but not both.</p>
    /// </note>
    pub configuration: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
}
impl std::fmt::Debug for CreateGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("resource_query", &self.resource_query);
        formatter.field("tags", &self.tags);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
