// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `Ardi`.
///
/// This client allows ergonomic access to a `Ardi`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateGroup` operation.
    ///
    /// See [`CreateGroup`](crate::client::fluent_builders::CreateGroup) for more information about the
    /// operation and its arguments.
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroup` operation.
    ///
    /// See [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroup` operation.
    ///
    /// See [`GetGroup`](crate::client::fluent_builders::GetGroup) for more information about the
    /// operation and its arguments.
    pub fn get_group(&self) -> fluent_builders::GetGroup<C, M, R> {
        fluent_builders::GetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroupConfiguration` operation.
    ///
    /// See [`GetGroupConfiguration`](crate::client::fluent_builders::GetGroupConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_group_configuration(&self) -> fluent_builders::GetGroupConfiguration<C, M, R> {
        fluent_builders::GetGroupConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroupQuery` operation.
    ///
    /// See [`GetGroupQuery`](crate::client::fluent_builders::GetGroupQuery) for more information about the
    /// operation and its arguments.
    pub fn get_group_query(&self) -> fluent_builders::GetGroupQuery<C, M, R> {
        fluent_builders::GetGroupQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTags` operation.
    ///
    /// See [`GetTags`](crate::client::fluent_builders::GetTags) for more information about the
    /// operation and its arguments.
    pub fn get_tags(&self) -> fluent_builders::GetTags<C, M, R> {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GroupResources` operation.
    ///
    /// See [`GroupResources`](crate::client::fluent_builders::GroupResources) for more information about the
    /// operation and its arguments.
    pub fn group_resources(&self) -> fluent_builders::GroupResources<C, M, R> {
        fluent_builders::GroupResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupResources` operation.
    ///
    /// See [`ListGroupResources`](crate::client::fluent_builders::ListGroupResources) for more information about the
    /// operation and its arguments.
    pub fn list_group_resources(&self) -> fluent_builders::ListGroupResources<C, M, R> {
        fluent_builders::ListGroupResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroups` operation.
    ///
    /// See [`ListGroups`](crate::client::fluent_builders::ListGroups) for more information about the
    /// operation and its arguments.
    pub fn list_groups(&self) -> fluent_builders::ListGroups<C, M, R> {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutGroupConfiguration` operation.
    ///
    /// See [`PutGroupConfiguration`](crate::client::fluent_builders::PutGroupConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_group_configuration(&self) -> fluent_builders::PutGroupConfiguration<C, M, R> {
        fluent_builders::PutGroupConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchResources` operation.
    ///
    /// See [`SearchResources`](crate::client::fluent_builders::SearchResources) for more information about the
    /// operation and its arguments.
    pub fn search_resources(&self) -> fluent_builders::SearchResources<C, M, R> {
        fluent_builders::SearchResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Tag` operation.
    ///
    /// See [`Tag`](crate::client::fluent_builders::Tag) for more information about the
    /// operation and its arguments.
    pub fn tag(&self) -> fluent_builders::Tag<C, M, R> {
        fluent_builders::Tag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UngroupResources` operation.
    ///
    /// See [`UngroupResources`](crate::client::fluent_builders::UngroupResources) for more information about the
    /// operation and its arguments.
    pub fn ungroup_resources(&self) -> fluent_builders::UngroupResources<C, M, R> {
        fluent_builders::UngroupResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Untag` operation.
    ///
    /// See [`Untag`](crate::client::fluent_builders::Untag) for more information about the
    /// operation and its arguments.
    pub fn untag(&self) -> fluent_builders::Untag<C, M, R> {
        fluent_builders::Untag::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGroup` operation.
    ///
    /// See [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) for more information about the
    /// operation and its arguments.
    pub fn update_group(&self) -> fluent_builders::UpdateGroup<C, M, R> {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGroupQuery` operation.
    ///
    /// See [`UpdateGroupQuery`](crate::client::fluent_builders::UpdateGroupQuery) for more information about the
    /// operation and its arguments.
    pub fn update_group_query(&self) -> fluent_builders::UpdateGroupQuery<C, M, R> {
        fluent_builders::UpdateGroupQuery::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a resource group with the specified name and description. You can optionally
    /// include a resource query, or a service configuration. For more information about
    /// constructing a resource query, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. For more
    /// information about service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
    /// groups</a>.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:CreateGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group, which is the identifier of the group in other operations. You
        /// can't change the name of a resource group after you create it. A resource group name can
        /// consist of letters, numbers, hyphens, periods, and underscores. The name cannot start
        /// with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name
        /// must be unique within each AWS Region in your AWS account.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the group, which is the identifier of the group in other operations. You
        /// can't change the name of a resource group after you create it. A resource group name can
        /// consist of letters, numbers, hyphens, periods, and underscores. The name cannot start
        /// with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name
        /// must be unique within each AWS Region in your AWS account.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the resource group. Descriptions can consist of letters, numbers,
        /// hyphens, underscores, periods, and spaces.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the resource group. Descriptions can consist of letters, numbers,
        /// hyphens, underscores, periods, and spaces.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The resource query that determines which AWS resources are members of this group.
        /// For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>. </p>
        /// <note>
        /// <p>A resource group can contain either a <code>ResourceQuery</code> or a
        /// <code>Configuration</code>, but not both.</p>
        /// </note>
        pub fn resource_query(mut self, inp: crate::model::ResourceQuery) -> Self {
            self.inner = self.inner.resource_query(inp);
            self
        }
        /// <p>The resource query that determines which AWS resources are members of this group.
        /// For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
        /// a tag-based group in Resource Groups</a>. </p>
        /// <note>
        /// <p>A resource group can contain either a <code>ResourceQuery</code> or a
        /// <code>Configuration</code>, but not both.</p>
        /// </note>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.inner = self.inner.set_resource_query(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the group. A tag is key-value pair string.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to add to the group. A tag is key-value pair string.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>A configuration associates the resource group with an AWS service and specifies how
        /// the service can interact with the resources in the group. A configuration is an array of
        /// <a>GroupConfigurationItem</a> elements. For details about the syntax of
        /// service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn configuration(
            mut self,
            inp: impl Into<crate::model::GroupConfigurationItem>,
        ) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>A configuration associates the resource group with an AWS service and specifies how
        /// the service can interact with the resources in the group. A configuration is an array of
        /// <a>GroupConfigurationItem</a> elements. For details about the syntax of
        /// service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
        /// groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes the specified resource group. Deleting a resource group does not delete any
    /// resources that are members of the group; it only deletes the group structure.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:DeleteGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to delete.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group to delete.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroup`.
    ///
    /// <p>Returns information about a specified resource group.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:GetGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_input::Builder,
    }
    impl<C, M, R> GetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupInputOperationOutputAlias,
                crate::output::GetGroupOutput,
                crate::error::GetGroupError,
                crate::input::GetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>Deprecated - don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to retrieve.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group to retrieve.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupConfiguration`.
    ///
    /// <p>Returns the service configuration associated with the specified resource group. For
    /// details about the service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
    /// groups</a>.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:GetGroupConfiguration</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetGroupConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_configuration_input::Builder,
    }
    impl<C, M, R> GetGroupConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroupConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupConfigurationInputOperationOutputAlias,
                crate::output::GetGroupConfigurationOutput,
                crate::error::GetGroupConfigurationError,
                crate::input::GetGroupConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the ARN of the resource group.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupQuery`.
    ///
    /// <p>Retrieves the resource query associated with the specified resource group. For more
    /// information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
    /// a tag-based group in Resource Groups</a>.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:GetGroupQuery</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetGroupQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_query_input::Builder,
    }
    impl<C, M, R> GetGroupQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroupQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupQueryInputOperationOutputAlias,
                crate::output::GetGroupQueryOutput,
                crate::error::GetGroupQueryError,
                crate::input::GetGroupQueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Returns a list of tags that are associated with a resource group, specified by an
    /// ARN.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:GetTags</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl<C, M, R> GetTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTagsInputOperationOutputAlias,
                crate::output::GetTagsOutput,
                crate::error::GetTagsError,
                crate::input::GetTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource group whose tags you want to retrieve.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the resource group whose tags you want to retrieve.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GroupResources`.
    ///
    /// <p>Adds the specified resources to the specified group.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:GroupResources</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GroupResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::group_resources_input::Builder,
    }
    impl<C, M, R> GroupResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GroupResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GroupResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GroupResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GroupResourcesInputOperationOutputAlias,
                crate::output::GroupResourcesOutput,
                crate::error::GroupResourcesError,
                crate::input::GroupResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the ARN of the resource group to add resources to.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group to add resources to.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The list of ARNs for resources to be added to the group. </p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The list of ARNs for resources to be added to the group. </p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupResources`.
    ///
    /// <p>Returns a list of ARNs of the resources that are members of a specified resource
    /// group.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:ListGroupResources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudformation:DescribeStacks</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudformation:ListStackResources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tag:GetResources</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListGroupResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_group_resources_input::Builder,
    }
    impl<C, M, R> ListGroupResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupResourcesInputOperationOutputAlias,
                crate::output::ListGroupResourcesOutput,
                crate::error::ListGroupResourcesError,
                crate::input::ListGroupResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <important>
        /// <p>
        /// <i>
        /// <b>Deprecated - don't use this parameter. Use the
        /// <code>Group</code> request field instead.</b>
        /// </i>
        /// </p>
        /// </important>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <important>
        /// <p>
        /// <i>
        /// <b>Deprecated - don't use this parameter. Use the
        /// <code>Group</code> request field instead.</b>
        /// </i>
        /// </p>
        /// </important>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply
        /// to a <code>ListGroupResources</code> operation. Filters the results to include only
        /// those of the specified resource types.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter resources by their type. Specify up to
        /// five resource types in the format <code>AWS::ServiceCode::ResourceType</code>.
        /// For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you specify a <code>resource-type</code> filter for
        /// <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types
        /// against the types that are defined in the query associated with the group. For example,
        /// if a group contains only S3 buckets because its query specifies only that resource type,
        /// but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
        /// does not filter for EC2 instances. In this case, a <code>ListGroupResources</code>
        /// request returns a <code>BadRequestException</code> error with a message similar to the
        /// following:</p>
        /// <p>
        /// <code>The resource types specified as filters in the request are not
        /// valid.</code>
        /// </p>
        /// <p>The error includes a list of resource types that failed the validation because they
        /// are not part of the query associated with the group. This validation doesn't occur when
        /// the group query specifies <code>AWS::AllSupported</code>, because a group based on such
        /// a query can contain any of the allowed resource types for the query type (tag-based or
        /// AWS CloudFormation stack-based queries).</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ResourceFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply
        /// to a <code>ListGroupResources</code> operation. Filters the results to include only
        /// those of the specified resource types.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter resources by their type. Specify up to
        /// five resource types in the format <code>AWS::ServiceCode::ResourceType</code>.
        /// For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>When you specify a <code>resource-type</code> filter for
        /// <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types
        /// against the types that are defined in the query associated with the group. For example,
        /// if a group contains only S3 buckets because its query specifies only that resource type,
        /// but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
        /// does not filter for EC2 instances. In this case, a <code>ListGroupResources</code>
        /// request returns a <code>BadRequestException</code> error with a message similar to the
        /// following:</p>
        /// <p>
        /// <code>The resource types specified as filters in the request are not
        /// valid.</code>
        /// </p>
        /// <p>The error includes a list of resource types that failed the validation because they
        /// are not part of the query associated with the group. This validation doesn't occur when
        /// the group query specifies <code>AWS::AllSupported</code>, because a group based on such
        /// a query can contain any of the allowed resource types for the query type (tag-based or
        /// AWS CloudFormation stack-based queries).</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Returns a list of existing resource groups in your account.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:ListGroups</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl<C, M, R> ListGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsInputOperationOutputAlias,
                crate::output::ListGroupsOutput,
                crate::error::ListGroupsError,
                crate::input::ListGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to
        /// a <code>ListGroups</code> operation.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter the results to include only those of the
        /// specified resource types. Specify up to five resource types in the format
        /// <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i>
        /// </code>.
        /// For example, <code>AWS::EC2::Instance</code>, or
        /// <code>AWS::S3::Bucket</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>configuration-type</code> - Filter the results to include only those
        /// groups that have the specified configuration types attached. The current
        /// supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::CapacityReservationPool</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::HostManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::GroupFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to
        /// a <code>ListGroups</code> operation.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resource-type</code> - Filter the results to include only those of the
        /// specified resource types. Specify up to five resource types in the format
        /// <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i>
        /// </code>.
        /// For example, <code>AWS::EC2::Instance</code>, or
        /// <code>AWS::S3::Bucket</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>configuration-type</code> - Filter the results to include only those
        /// groups that have the specified configuration types attached. The current
        /// supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::CapacityReservationPool</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AWS:EC2::HostManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutGroupConfiguration`.
    ///
    /// <p>Attaches a service configuration to the specified group. This occurs asynchronously,
    /// and can take time to complete. You can use <a>GetGroupConfiguration</a> to
    /// check the status of the update.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:PutGroupConfiguration</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutGroupConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_group_configuration_input::Builder,
    }
    impl<C, M, R> PutGroupConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutGroupConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutGroupConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutGroupConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutGroupConfigurationInputOperationOutputAlias,
                crate::output::PutGroupConfigurationOutput,
                crate::error::PutGroupConfigurationError,
                crate::input::PutGroupConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the resource group with the configuration that you want to
        /// update.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or ARN of the resource group with the configuration that you want to
        /// update.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `Configuration`.
        ///
        /// To override the contents of this collection use [`set_configuration`](Self::set_configuration).
        ///
        /// <p>The new configuration to associate with the specified group. A configuration
        /// associates the resource group with an AWS service and specifies how the service can
        /// interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
        /// <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
        /// resource groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn configuration(
            mut self,
            inp: impl Into<crate::model::GroupConfigurationItem>,
        ) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The new configuration to associate with the specified group. A configuration
        /// associates the resource group with an AWS service and specifies how the service can
        /// interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
        /// <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
        /// resource groups</a>.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupConfigurationItem>>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchResources`.
    ///
    /// <p>Returns a list of AWS resource identifiers that matches the specified query. The
    /// query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery
    /// operation.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:SearchResources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudformation:DescribeStacks</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>cloudformation:ListStackResources</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tag:GetResources</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct SearchResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_resources_input::Builder,
    }
    impl<C, M, R> SearchResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchResourcesInputOperationOutputAlias,
                crate::output::SearchResourcesOutput,
                crate::error::SearchResourcesError,
                crate::input::SearchResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The search query, using the same formats that are supported for resource group
        /// definition. For more information, see <a>CreateGroup</a>.</p>
        pub fn resource_query(mut self, inp: crate::model::ResourceQuery) -> Self {
            self.inner = self.inner.resource_query(inp);
            self
        }
        /// <p>The search query, using the same formats that are supported for resource group
        /// definition. For more information, see <a>CreateGroup</a>.</p>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.inner = self.inner.set_resource_query(input);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The total number of results that you want included on each page of the
        /// response. If you do not include this parameter, it defaults to a value that is specific to the
        /// operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code>
        /// response element is present and has a value (is not null). Include that value as the
        /// <code>NextToken</code> request parameter in the next call to the operation to get the next part
        /// of the results. Note that the service might return fewer results than the maximum even when there
        /// are more results available. You should check <code>NextToken</code> after every operation to
        /// ensure that you receive all of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The parameter for receiving additional results if you receive a
        /// <code>NextToken</code> response in a previous request. A <code>NextToken</code> response
        /// indicates that more output is available. Set this parameter to the value provided by a previous
        /// call's <code>NextToken</code> response to indicate where the output should continue from.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Tag`.
    ///
    /// <p>Adds tags to a resource group with the specified ARN. Existing tags on a resource
    /// group are not changed if they are not specified in the request parameters.</p>
    /// <important>
    /// <p>Do not store personally identifiable information (PII) or other confidential or
    /// sensitive information in tags. We use tags to provide you with billing and
    /// administration services. Tags are not intended to be used for private or sensitive
    /// data.</p>
    /// </important>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:Tag</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct Tag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_input::Builder,
    }
    impl<C, M, R> Tag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Tag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagOutput,
            aws_smithy_http::result::SdkError<crate::error::TagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagInputOperationOutputAlias,
                crate::output::TagOutput,
                crate::error::TagError,
                crate::input::TagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource group to which to add tags.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the resource group to which to add tags.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the specified resource group. A tag is a string-to-string map of
        /// key-value pairs.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to add to the specified resource group. A tag is a string-to-string map of
        /// key-value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UngroupResources`.
    ///
    /// <p>Removes the specified resources from the specified group.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:UngroupResources</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UngroupResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::ungroup_resources_input::Builder,
    }
    impl<C, M, R> UngroupResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UngroupResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UngroupResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::UngroupResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UngroupResourcesInputOperationOutputAlias,
                crate::output::UngroupResourcesOutput,
                crate::error::UngroupResourcesError,
                crate::input::UngroupResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or the ARN of the resource group from which to remove the resources.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group from which to remove the resources.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>The ARNs of the resources to be removed from the group.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>The ARNs of the resources to be removed from the group.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Untag`.
    ///
    /// <p>Deletes tags from a specified resource group.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:Untag</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct Untag<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_input::Builder,
    }
    impl<C, M, R> Untag<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Untag`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagInputOperationOutputAlias,
                crate::output::UntagOutput,
                crate::error::UntagError,
                crate::input::UntagInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource group from which to remove tags. The command removed both the
        /// specified keys and any values associated with those keys.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the resource group from which to remove tags. The command removed both the
        /// specified keys and any values associated with those keys.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `Keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keys(inp);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroup`.
    ///
    /// <p>Updates the description for an existing group. You cannot update the name of a
    /// resource group.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:UpdateGroup</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_input::Builder,
    }
    impl<C, M, R> UpdateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupInputOperationOutputAlias,
                crate::output::UpdateGroupOutput,
                crate::error::UpdateGroupError,
                crate::input::UpdateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to modify.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group to modify.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// <p>The new description that you want to update the resource group with. Descriptions can
        /// contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description that you want to update the resource group with. Descriptions can
        /// contain letters, numbers, hyphens, underscores, periods, and spaces.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGroupQuery`.
    ///
    /// <p>Updates the resource query of a group. For more information about resource queries,
    /// see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>.</p>
    /// <p>
    /// <b>Minimum permissions</b>
    /// </p>
    /// <p>To run this command, you must have the following permissions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>resource-groups:UpdateGroupQuery</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGroupQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_group_query_input::Builder,
    }
    impl<C, M, R> UpdateGroupQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGroupQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGroupQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGroupQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGroupQueryInputOperationOutputAlias,
                crate::output::UpdateGroupQueryOutput,
                crate::error::UpdateGroupQueryError,
                crate::input::UpdateGroupQueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>Don't use this parameter. Use <code>Group</code> instead.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group(inp);
            self
        }
        /// <p>The name or the ARN of the resource group to query.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group(input);
            self
        }
        /// <p>The resource query to determine which AWS resources are members of this resource
        /// group.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn resource_query(mut self, inp: crate::model::ResourceQuery) -> Self {
            self.inner = self.inner.resource_query(inp);
            self
        }
        /// <p>The resource query to determine which AWS resources are members of this resource
        /// group.</p>
        /// <note>
        /// <p>A resource group can contain either a <code>Configuration</code> or a
        /// <code>ResourceQuery</code>, but not both.</p>
        /// </note>
        pub fn set_resource_query(
            mut self,
            input: std::option::Option<crate::model::ResourceQuery>,
        ) -> Self {
            self.inner = self.inner.set_resource_query(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
