// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGroupErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGroupError {
    fn code(&self) -> Option<&str> {
        CreateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGroupError {
    /// Creates a new `CreateGroupError`.
    pub fn new(kind: CreateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `CreateGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateGroupErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `CreateGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateGroupErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            CreateGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupError {
    /// Creates a new `DeleteGroupError`.
    pub fn new(kind: DeleteGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `DeleteGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGroupErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteGroupErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            DeleteGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupError {
    /// Kind of error that occurred.
    pub kind: GetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupError {
    fn code(&self) -> Option<&str> {
        GetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupError {
    /// Creates a new `GetGroupError`.
    pub fn new(kind: GetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `GetGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::MethodNotAllowedException(_))
    }
    /// Returns true if the error kind is `GetGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetGroupErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroupConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetGroupConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroupConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupConfigurationErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGroupConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetGroupConfigurationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetGroupConfigurationErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetGroupConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGroupConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetGroupConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupConfigurationError {
    fn code(&self) -> Option<&str> {
        GetGroupConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupConfigurationError {
    /// Creates a new `GetGroupConfigurationError`.
    pub fn new(kind: GetGroupConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGroupConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupConfigurationErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupConfigurationErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetGroupConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGroupConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetGroupConfigurationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetGroupConfigurationErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetGroupConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGroupConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetGroupConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroupQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupQueryError {
    /// Kind of error that occurred.
    pub kind: GetGroupQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroupQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupQueryErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupQueryErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGroupQueryErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetGroupQueryErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetGroupQueryErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetGroupQueryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGroupQueryErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetGroupQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupQueryError {
    fn code(&self) -> Option<&str> {
        GetGroupQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupQueryError {
    /// Creates a new `GetGroupQueryError`.
    pub fn new(kind: GetGroupQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGroupQueryErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetGroupQueryErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetGroupQueryErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetGroupQueryErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `GetGroupQueryErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupQueryErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupQueryErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupQueryErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `GetGroupQueryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGroupQueryErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetGroupQueryErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupQueryErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetGroupQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupQueryErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGroupQueryErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetGroupQueryErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetGroupQueryErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetGroupQueryErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGroupQueryErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetGroupQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTagsError {
    /// Kind of error that occurred.
    pub kind: GetTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTagsErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTagsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTagsError {
    fn code(&self) -> Option<&str> {
        GetTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTagsError {
    /// Creates a new `GetTagsError`.
    pub fn new(kind: GetTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTagsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTagsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GetTagsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::MethodNotAllowedException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetTagsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTagsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetTagsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetTagsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetTagsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GetTagsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTagsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GroupResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GroupResourcesError {
    /// Kind of error that occurred.
    pub kind: GroupResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GroupResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GroupResourcesErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GroupResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GroupResourcesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GroupResourcesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GroupResourcesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GroupResourcesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            GroupResourcesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GroupResourcesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GroupResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GroupResourcesError {
    fn code(&self) -> Option<&str> {
        GroupResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GroupResourcesError {
    /// Creates a new `GroupResourcesError`.
    pub fn new(kind: GroupResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GroupResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GroupResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GroupResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GroupResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GroupResourcesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GroupResourcesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GroupResourcesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GroupResourcesErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `GroupResourcesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GroupResourcesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `GroupResourcesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GroupResourcesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `GroupResourcesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GroupResourcesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GroupResourcesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GroupResourcesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GroupResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GroupResourcesErrorKind::BadRequestException(_inner) => Some(_inner),
            GroupResourcesErrorKind::ForbiddenException(_inner) => Some(_inner),
            GroupResourcesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GroupResourcesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            GroupResourcesErrorKind::NotFoundException(_inner) => Some(_inner),
            GroupResourcesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GroupResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroupResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupResourcesError {
    /// Kind of error that occurred.
    pub kind: ListGroupResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroupResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupResourcesErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request was rejected because it doesn't have valid credentials for the target
    /// resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupResourcesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListGroupResourcesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListGroupResourcesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListGroupResourcesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            ListGroupResourcesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListGroupResourcesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListGroupResourcesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListGroupResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupResourcesError {
    fn code(&self) -> Option<&str> {
        ListGroupResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupResourcesError {
    /// Creates a new `ListGroupResourcesError`.
    pub fn new(kind: ListGroupResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListGroupResourcesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupResourcesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupResourcesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupResourcesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupResourcesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupResourcesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupResourcesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupResourcesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupResourcesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupResourcesErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupResourcesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupResourcesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupResourcesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupResourcesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListGroupResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupResourcesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListGroupResourcesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListGroupResourcesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListGroupResourcesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            ListGroupResourcesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListGroupResourcesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListGroupResourcesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListGroupResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupsError {
    /// Kind of error that occurred.
    pub kind: ListGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupsErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupsError {
    fn code(&self) -> Option<&str> {
        ListGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupsError {
    /// Creates a new `ListGroupsError`.
    pub fn new(kind: ListGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListGroupsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListGroupsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `ListGroupsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupsErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `ListGroupsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListGroupsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListGroupsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListGroupsErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            ListGroupsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutGroupConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutGroupConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutGroupConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutGroupConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutGroupConfigurationErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutGroupConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutGroupConfigurationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutGroupConfigurationErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PutGroupConfigurationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutGroupConfigurationErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            PutGroupConfigurationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutGroupConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutGroupConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutGroupConfigurationError {
    fn code(&self) -> Option<&str> {
        PutGroupConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutGroupConfigurationError {
    /// Creates a new `PutGroupConfigurationError`.
    pub fn new(kind: PutGroupConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutGroupConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutGroupConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutGroupConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutGroupConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutGroupConfigurationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupConfigurationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutGroupConfigurationErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupConfigurationErrorKind::ForbiddenException(_)
        )
    }
    /// Returns true if the error kind is `PutGroupConfigurationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupConfigurationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `PutGroupConfigurationErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupConfigurationErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `PutGroupConfigurationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupConfigurationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutGroupConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutGroupConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutGroupConfigurationErrorKind::BadRequestException(_inner) => Some(_inner),
            PutGroupConfigurationErrorKind::ForbiddenException(_inner) => Some(_inner),
            PutGroupConfigurationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutGroupConfigurationErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            PutGroupConfigurationErrorKind::NotFoundException(_inner) => Some(_inner),
            PutGroupConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutGroupConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchResourcesError {
    /// Kind of error that occurred.
    pub kind: SearchResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchResourcesErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request was rejected because it doesn't have valid credentials for the target
    /// resource.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchResourcesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchResourcesError {
    fn code(&self) -> Option<&str> {
        SearchResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchResourcesError {
    /// Creates a new `SearchResourcesError`.
    pub fn new(kind: SearchResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchResourcesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, SearchResourcesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `SearchResourcesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, SearchResourcesErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `SearchResourcesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `SearchResourcesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `SearchResourcesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns true if the error kind is `SearchResourcesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for SearchResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchResourcesErrorKind::BadRequestException(_inner) => Some(_inner),
            SearchResourcesErrorKind::ForbiddenException(_inner) => Some(_inner),
            SearchResourcesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            SearchResourcesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            SearchResourcesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            SearchResourcesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            SearchResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Tag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagError {
    /// Kind of error that occurred.
    pub kind: TagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Tag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            TagErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            TagErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagError {
    fn code(&self) -> Option<&str> {
        TagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagError {
    /// Creates a new `TagError`.
    pub fn new(kind: TagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `TagErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, TagErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `TagErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(&self.kind, TagErrorKind::InternalServerErrorException(_))
    }
    /// Returns true if the error kind is `TagErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, TagErrorKind::MethodNotAllowedException(_))
    }
    /// Returns true if the error kind is `TagErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `TagErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, TagErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for TagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagErrorKind::BadRequestException(_inner) => Some(_inner),
            TagErrorKind::ForbiddenException(_inner) => Some(_inner),
            TagErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            TagErrorKind::NotFoundException(_inner) => Some(_inner),
            TagErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UngroupResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UngroupResourcesError {
    /// Kind of error that occurred.
    pub kind: UngroupResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UngroupResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UngroupResourcesErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UngroupResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UngroupResourcesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UngroupResourcesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UngroupResourcesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UngroupResourcesErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UngroupResourcesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UngroupResourcesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UngroupResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UngroupResourcesError {
    fn code(&self) -> Option<&str> {
        UngroupResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UngroupResourcesError {
    /// Creates a new `UngroupResourcesError`.
    pub fn new(kind: UngroupResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UngroupResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UngroupResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UngroupResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UngroupResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UngroupResourcesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UngroupResourcesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UngroupResourcesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UngroupResourcesErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UngroupResourcesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UngroupResourcesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UngroupResourcesErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UngroupResourcesErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `UngroupResourcesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UngroupResourcesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UngroupResourcesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UngroupResourcesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UngroupResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UngroupResourcesErrorKind::BadRequestException(_inner) => Some(_inner),
            UngroupResourcesErrorKind::ForbiddenException(_inner) => Some(_inner),
            UngroupResourcesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UngroupResourcesErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UngroupResourcesErrorKind::NotFoundException(_inner) => Some(_inner),
            UngroupResourcesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UngroupResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Untag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagError {
    /// Kind of error that occurred.
    pub kind: UntagErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Untag` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UntagErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UntagErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagError {
    fn code(&self) -> Option<&str> {
        UntagError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagError {
    /// Creates a new `UntagError`.
    pub fn new(kind: UntagErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UntagErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UntagErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UntagErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(&self.kind, UntagErrorKind::InternalServerErrorException(_))
    }
    /// Returns true if the error kind is `UntagErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(&self.kind, UntagErrorKind::MethodNotAllowedException(_))
    }
    /// Returns true if the error kind is `UntagErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UntagErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, UntagErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for UntagError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagErrorKind::ForbiddenException(_inner) => Some(_inner),
            UntagErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UntagErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGroupErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGroupErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGroupError {
    fn code(&self) -> Option<&str> {
        UpdateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGroupError {
    /// Creates a new `UpdateGroupError`.
    pub fn new(kind: UpdateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGroupErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateGroupErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UpdateGroupErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGroupErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGroupErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGroupErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateGroupErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateGroupErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateGroupErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateGroupErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGroupQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGroupQueryError {
    /// Kind of error that occurred.
    pub kind: UpdateGroupQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGroupQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGroupQueryErrorKind {
    /// <p>The request includes one or more parameters that violate validation rules.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The caller isn't authorized to make the request. Check permissions.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred while processing the request. Try again later.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
    MethodNotAllowedException(crate::error::MethodNotAllowedException),
    /// <p>One or more of the specified resources don't exist.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You've exceeded throttling limits by making too many requests in a period of
    /// time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGroupQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGroupQueryErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateGroupQueryErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateGroupQueryErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateGroupQueryErrorKind::MethodNotAllowedException(_inner) => _inner.fmt(f),
            UpdateGroupQueryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGroupQueryErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateGroupQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGroupQueryError {
    fn code(&self) -> Option<&str> {
        UpdateGroupQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGroupQueryError {
    /// Creates a new `UpdateGroupQueryError`.
    pub fn new(kind: UpdateGroupQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGroupQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGroupQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGroupQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGroupQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGroupQueryErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupQueryErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGroupQueryErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupQueryErrorKind::ForbiddenException(_))
    }
    /// Returns true if the error kind is `UpdateGroupQueryErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupQueryErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGroupQueryErrorKind::MethodNotAllowedException`.
    pub fn is_method_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupQueryErrorKind::MethodNotAllowedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGroupQueryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupQueryErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateGroupQueryErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupQueryErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateGroupQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGroupQueryErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateGroupQueryErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateGroupQueryErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateGroupQueryErrorKind::MethodNotAllowedException(_inner) => Some(_inner),
            UpdateGroupQueryErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGroupQueryErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateGroupQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>You've exceeded throttling limits by making too many requests in a period of
/// time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>One or more of the specified resources don't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The request uses an HTTP method that isn't allowed for the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MethodNotAllowedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MethodNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MethodNotAllowedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MethodNotAllowedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MethodNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MethodNotAllowedException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for MethodNotAllowedException {}
/// See [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
pub mod method_not_allowed_exception {
    /// A builder for [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
        pub fn build(self) -> crate::error::MethodNotAllowedException {
            crate::error::MethodNotAllowedException {
                message: self.message,
            }
        }
    }
}
impl MethodNotAllowedException {
    /// Creates a new builder-style object to manufacture [`MethodNotAllowedException`](crate::error::MethodNotAllowedException)
    pub fn builder() -> crate::error::method_not_allowed_exception::Builder {
        crate::error::method_not_allowed_exception::Builder::default()
    }
}

/// <p>An internal error occurred while processing the request. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>The caller isn't authorized to make the request. Check permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>The request includes one or more parameters that violate validation rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>The request was rejected because it doesn't have valid credentials for the target
/// resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}
