// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Resilience Hub
///
/// Client for invoking operations on AWS Resilience Hub. Each operation on AWS Resilience Hub is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_resiliencehub::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_resiliencehub::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_resiliencehub::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddDraftAppVersionResourceMappings`](crate::client::fluent_builders::AddDraftAppVersionResourceMappings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::AddDraftAppVersionResourceMappings::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::AddDraftAppVersionResourceMappings::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`resource_mappings(Vec<ResourceMapping>)`](crate::client::fluent_builders::AddDraftAppVersionResourceMappings::resource_mappings) / [`set_resource_mappings(Option<Vec<ResourceMapping>>)`](crate::client::fluent_builders::AddDraftAppVersionResourceMappings::set_resource_mappings): <p> Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>
    /// - On success, responds with [`AddDraftAppVersionResourceMappingsOutput`](crate::output::AddDraftAppVersionResourceMappingsOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::AddDraftAppVersionResourceMappingsOutput::app_arn): <p> The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::AddDraftAppVersionResourceMappingsOutput::app_version): <p>The version of the application.</p>
    ///   - [`resource_mappings(Option<Vec<ResourceMapping>>)`](crate::output::AddDraftAppVersionResourceMappingsOutput::resource_mappings): <p>Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>
    /// - On failure, responds with [`SdkError<AddDraftAppVersionResourceMappingsError>`](crate::error::AddDraftAppVersionResourceMappingsError)
    pub fn add_draft_app_version_resource_mappings(
        &self,
    ) -> fluent_builders::AddDraftAppVersionResourceMappings {
        fluent_builders::AddDraftAppVersionResourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApp`](crate::client::fluent_builders::CreateApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApp::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApp::set_name): <p>The name for the application.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApp::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApp::set_description): <p>The optional description for an app.</p>
    ///   - [`policy_arn(impl Into<String>)`](crate::client::fluent_builders::CreateApp::policy_arn) / [`set_policy_arn(Option<String>)`](crate::client::fluent_builders::CreateApp::set_policy_arn): <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApp::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApp::set_tags): <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateApp::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateApp::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    /// - On success, responds with [`CreateAppOutput`](crate::output::CreateAppOutput) with field(s):
    ///   - [`app(Option<App>)`](crate::output::CreateAppOutput::app): <p>The created application returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>
    /// - On failure, responds with [`SdkError<CreateAppError>`](crate::error::CreateAppError)
    pub fn create_app(&self) -> fluent_builders::CreateApp {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRecommendationTemplate`](crate::client::fluent_builders::CreateRecommendationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recommendation_ids(Vec<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::recommendation_ids) / [`set_recommendation_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_recommendation_ids): <p>Identifiers for the recommendations used to create a recommendation template.</p>
    ///   - [`format(TemplateFormat)`](crate::client::fluent_builders::CreateRecommendationTemplate::format) / [`set_format(Option<TemplateFormat>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_format): <p>The format for the recommendation template.</p>  <dl>   <dt>   CfnJson  </dt>   <dd>    <p>The template is CloudFormation JSON.</p>   </dd>   <dt>   CfnYaml  </dt>   <dd>    <p>The template is CloudFormation YAML.</p>   </dd>  </dl>
    ///   - [`recommendation_types(Vec<RenderRecommendationType>)`](crate::client::fluent_builders::CreateRecommendationTemplate::recommendation_types) / [`set_recommendation_types(Option<Vec<RenderRecommendationType>>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_recommendation_types): <p>An array of strings that specify the recommendation template type or types.</p>  <dl>   <dt>   Alarm  </dt>   <dd>    <p>The template is an <code>AlarmRecommendation</code> template.</p>   </dd>   <dt>   Sop  </dt>   <dd>    <p>The template is a <code>SopRecommendation</code> template.</p>   </dd>   <dt>   Test  </dt>   <dd>    <p>The template is a <code>TestRecommendation</code> template.</p>   </dd>  </dl>
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_name): <p>The name for the recommendation template.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_tags): <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    ///   - [`bucket_name(impl Into<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::bucket_name) / [`set_bucket_name(Option<String>)`](crate::client::fluent_builders::CreateRecommendationTemplate::set_bucket_name): <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
    /// - On success, responds with [`CreateRecommendationTemplateOutput`](crate::output::CreateRecommendationTemplateOutput) with field(s):
    ///   - [`recommendation_template(Option<RecommendationTemplate>)`](crate::output::CreateRecommendationTemplateOutput::recommendation_template): <p>The newly created recommendation template, returned as an object. This object includes the template's name, format, status, tags, Amazon S3 bucket location, and more.</p>
    /// - On failure, responds with [`SdkError<CreateRecommendationTemplateError>`](crate::error::CreateRecommendationTemplateError)
    pub fn create_recommendation_template(&self) -> fluent_builders::CreateRecommendationTemplate {
        fluent_builders::CreateRecommendationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResiliencyPolicy`](crate::client::fluent_builders::CreateResiliencyPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::CreateResiliencyPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::CreateResiliencyPolicy::set_policy_name): <p>The name of the policy</p>
    ///   - [`policy_description(impl Into<String>)`](crate::client::fluent_builders::CreateResiliencyPolicy::policy_description) / [`set_policy_description(Option<String>)`](crate::client::fluent_builders::CreateResiliencyPolicy::set_policy_description): <p>The description for the policy.</p>
    ///   - [`data_location_constraint(DataLocationConstraint)`](crate::client::fluent_builders::CreateResiliencyPolicy::data_location_constraint) / [`set_data_location_constraint(Option<DataLocationConstraint>)`](crate::client::fluent_builders::CreateResiliencyPolicy::set_data_location_constraint): <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
    ///   - [`tier(ResiliencyPolicyTier)`](crate::client::fluent_builders::CreateResiliencyPolicy::tier) / [`set_tier(Option<ResiliencyPolicyTier>)`](crate::client::fluent_builders::CreateResiliencyPolicy::set_tier): <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    ///   - [`policy(HashMap<DisruptionType, FailurePolicy>)`](crate::client::fluent_builders::CreateResiliencyPolicy::policy) / [`set_policy(Option<HashMap<DisruptionType, FailurePolicy>>)`](crate::client::fluent_builders::CreateResiliencyPolicy::set_policy): <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateResiliencyPolicy::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateResiliencyPolicy::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateResiliencyPolicy::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateResiliencyPolicy::set_tags): <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    /// - On success, responds with [`CreateResiliencyPolicyOutput`](crate::output::CreateResiliencyPolicyOutput) with field(s):
    ///   - [`policy(Option<ResiliencyPolicy>)`](crate::output::CreateResiliencyPolicyOutput::policy): <p>The type of resiliency policy that was created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
    /// - On failure, responds with [`SdkError<CreateResiliencyPolicyError>`](crate::error::CreateResiliencyPolicyError)
    pub fn create_resiliency_policy(&self) -> fluent_builders::CreateResiliencyPolicy {
        fluent_builders::CreateResiliencyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApp`](crate::client::fluent_builders::DeleteApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteApp::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::DeleteApp::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`force_delete(bool)`](crate::client::fluent_builders::DeleteApp::force_delete) / [`set_force_delete(Option<bool>)`](crate::client::fluent_builders::DeleteApp::set_force_delete): <p>A boolean option to force the deletion of a Resilience Hub application. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteApp::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteApp::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    /// - On success, responds with [`DeleteAppOutput`](crate::output::DeleteAppOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::DeleteAppOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On failure, responds with [`SdkError<DeleteAppError>`](crate::error::DeleteAppError)
    pub fn delete_app(&self) -> fluent_builders::DeleteApp {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppAssessment`](crate::client::fluent_builders::DeleteAppAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAppAssessment::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::DeleteAppAssessment::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteAppAssessment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteAppAssessment::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    /// - On success, responds with [`DeleteAppAssessmentOutput`](crate::output::DeleteAppAssessmentOutput) with field(s):
    ///   - [`assessment_arn(Option<String>)`](crate::output::DeleteAppAssessmentOutput::assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`assessment_status(Option<AssessmentStatus>)`](crate::output::DeleteAppAssessmentOutput::assessment_status): <p>The current status of the assessment for the resiliency policy.</p>
    /// - On failure, responds with [`SdkError<DeleteAppAssessmentError>`](crate::error::DeleteAppAssessmentError)
    pub fn delete_app_assessment(&self) -> fluent_builders::DeleteAppAssessment {
        fluent_builders::DeleteAppAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRecommendationTemplate`](crate::client::fluent_builders::DeleteRecommendationTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`recommendation_template_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteRecommendationTemplate::recommendation_template_arn) / [`set_recommendation_template_arn(Option<String>)`](crate::client::fluent_builders::DeleteRecommendationTemplate::set_recommendation_template_arn): <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteRecommendationTemplate::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteRecommendationTemplate::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    /// - On success, responds with [`DeleteRecommendationTemplateOutput`](crate::output::DeleteRecommendationTemplateOutput) with field(s):
    ///   - [`recommendation_template_arn(Option<String>)`](crate::output::DeleteRecommendationTemplateOutput::recommendation_template_arn): <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    ///   - [`status(Option<RecommendationTemplateStatus>)`](crate::output::DeleteRecommendationTemplateOutput::status): <p>The status of the action.</p>
    /// - On failure, responds with [`SdkError<DeleteRecommendationTemplateError>`](crate::error::DeleteRecommendationTemplateError)
    pub fn delete_recommendation_template(&self) -> fluent_builders::DeleteRecommendationTemplate {
        fluent_builders::DeleteRecommendationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResiliencyPolicy`](crate::client::fluent_builders::DeleteResiliencyPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResiliencyPolicy::policy_arn) / [`set_policy_arn(Option<String>)`](crate::client::fluent_builders::DeleteResiliencyPolicy::set_policy_arn): <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteResiliencyPolicy::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteResiliencyPolicy::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    /// - On success, responds with [`DeleteResiliencyPolicyOutput`](crate::output::DeleteResiliencyPolicyOutput) with field(s):
    ///   - [`policy_arn(Option<String>)`](crate::output::DeleteResiliencyPolicyOutput::policy_arn): <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On failure, responds with [`SdkError<DeleteResiliencyPolicyError>`](crate::error::DeleteResiliencyPolicyError)
    pub fn delete_resiliency_policy(&self) -> fluent_builders::DeleteResiliencyPolicy {
        fluent_builders::DeleteResiliencyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApp`](crate::client::fluent_builders::DescribeApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeApp::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::DescribeApp::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`DescribeAppOutput`](crate::output::DescribeAppOutput) with field(s):
    ///   - [`app(Option<App>)`](crate::output::DescribeAppOutput::app): <p>The specified application, returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>
    /// - On failure, responds with [`SdkError<DescribeAppError>`](crate::error::DescribeAppError)
    pub fn describe_app(&self) -> fluent_builders::DescribeApp {
        fluent_builders::DescribeApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppAssessment`](crate::client::fluent_builders::DescribeAppAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppAssessment::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppAssessment::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`DescribeAppAssessmentOutput`](crate::output::DescribeAppAssessmentOutput) with field(s):
    ///   - [`assessment(Option<AppAssessment>)`](crate::output::DescribeAppAssessmentOutput::assessment): <p>The assessment for an AWS Resilience Hub application, returned as an object. This object includes Amazon Resource Names (ARNs), compliance information, compliance status, cost, messages, resiliency scores, and more.</p>
    /// - On failure, responds with [`SdkError<DescribeAppAssessmentError>`](crate::error::DescribeAppAssessmentError)
    pub fn describe_app_assessment(&self) -> fluent_builders::DescribeAppAssessment {
        fluent_builders::DescribeAppAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppVersionResourcesResolutionStatus`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(impl Into<String>)`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus::app_version) / [`set_app_version(Option<String>)`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus::set_app_version): <p>The version of the application.</p>
    ///   - [`resolution_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus::resolution_id) / [`set_resolution_id(Option<String>)`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus::set_resolution_id): <p>The identifier for a specific resolution.</p>
    /// - On success, responds with [`DescribeAppVersionResourcesResolutionStatusOutput`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput::app_version): <p>The version of the application.</p>
    ///   - [`resolution_id(Option<String>)`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput::resolution_id): <p>The identifier for a specific resolution.</p>
    ///   - [`status(Option<ResourceResolutionStatusType>)`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput::status): <p>The status of the action.</p>
    ///   - [`error_message(Option<String>)`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput::error_message): <p>The returned error message for the request.</p>
    /// - On failure, responds with [`SdkError<DescribeAppVersionResourcesResolutionStatusError>`](crate::error::DescribeAppVersionResourcesResolutionStatusError)
    pub fn describe_app_version_resources_resolution_status(
        &self,
    ) -> fluent_builders::DescribeAppVersionResourcesResolutionStatus {
        fluent_builders::DescribeAppVersionResourcesResolutionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppVersionTemplate`](crate::client::fluent_builders::DescribeAppVersionTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAppVersionTemplate::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::DescribeAppVersionTemplate::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(impl Into<String>)`](crate::client::fluent_builders::DescribeAppVersionTemplate::app_version) / [`set_app_version(Option<String>)`](crate::client::fluent_builders::DescribeAppVersionTemplate::set_app_version): <p>The version of the application.</p>
    /// - On success, responds with [`DescribeAppVersionTemplateOutput`](crate::output::DescribeAppVersionTemplateOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::DescribeAppVersionTemplateOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::DescribeAppVersionTemplateOutput::app_version): <p>The version of the application.</p>
    ///   - [`app_template_body(Option<String>)`](crate::output::DescribeAppVersionTemplateOutput::app_template_body): <p>The body of the template.</p>
    /// - On failure, responds with [`SdkError<DescribeAppVersionTemplateError>`](crate::error::DescribeAppVersionTemplateError)
    pub fn describe_app_version_template(&self) -> fluent_builders::DescribeAppVersionTemplate {
        fluent_builders::DescribeAppVersionTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDraftAppVersionResourcesImportStatus`](crate::client::fluent_builders::DescribeDraftAppVersionResourcesImportStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDraftAppVersionResourcesImportStatus::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::DescribeDraftAppVersionResourcesImportStatus::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`DescribeDraftAppVersionResourcesImportStatusOutput`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput::app_version): <p>The version of the application.</p>
    ///   - [`status(Option<ResourceImportStatusType>)`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput::status): <p>The status of the action.</p>
    ///   - [`status_change_time(Option<DateTime>)`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput::status_change_time): <p>The timestamp for when the status last changed.</p>
    ///   - [`error_message(Option<String>)`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput::error_message): <p>The returned error message for the request.</p>
    /// - On failure, responds with [`SdkError<DescribeDraftAppVersionResourcesImportStatusError>`](crate::error::DescribeDraftAppVersionResourcesImportStatusError)
    pub fn describe_draft_app_version_resources_import_status(
        &self,
    ) -> fluent_builders::DescribeDraftAppVersionResourcesImportStatus {
        fluent_builders::DescribeDraftAppVersionResourcesImportStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResiliencyPolicy`](crate::client::fluent_builders::DescribeResiliencyPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeResiliencyPolicy::policy_arn) / [`set_policy_arn(Option<String>)`](crate::client::fluent_builders::DescribeResiliencyPolicy::set_policy_arn): <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`DescribeResiliencyPolicyOutput`](crate::output::DescribeResiliencyPolicyOutput) with field(s):
    ///   - [`policy(Option<ResiliencyPolicy>)`](crate::output::DescribeResiliencyPolicyOutput::policy): <p>Information about the specific resiliency policy, returned as an object. This object includes creation time, data location constraints, its name, description, tags, the recovery time objective (RTO) and recovery point objective (RPO) in seconds, and more.</p>
    /// - On failure, responds with [`SdkError<DescribeResiliencyPolicyError>`](crate::error::DescribeResiliencyPolicyError)
    pub fn describe_resiliency_policy(&self) -> fluent_builders::DescribeResiliencyPolicy {
        fluent_builders::DescribeResiliencyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportResourcesToDraftAppVersion`](crate::client::fluent_builders::ImportResourcesToDraftAppVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ImportResourcesToDraftAppVersion::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ImportResourcesToDraftAppVersion::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`source_arns(Vec<String>)`](crate::client::fluent_builders::ImportResourcesToDraftAppVersion::source_arns) / [`set_source_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ImportResourcesToDraftAppVersion::set_source_arns): <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
    /// - On success, responds with [`ImportResourcesToDraftAppVersionOutput`](crate::output::ImportResourcesToDraftAppVersionOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::ImportResourcesToDraftAppVersionOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::ImportResourcesToDraftAppVersionOutput::app_version): <p>The version of the application.</p>
    ///   - [`source_arns(Option<Vec<String>>)`](crate::output::ImportResourcesToDraftAppVersionOutput::source_arns): <p>The Amazon Resource Names (ARNs) for the resources that you imported.</p>
    ///   - [`status(Option<ResourceImportStatusType>)`](crate::output::ImportResourcesToDraftAppVersionOutput::status): <p>The status of the action.</p>
    /// - On failure, responds with [`SdkError<ImportResourcesToDraftAppVersionError>`](crate::error::ImportResourcesToDraftAppVersionError)
    pub fn import_resources_to_draft_app_version(
        &self,
    ) -> fluent_builders::ImportResourcesToDraftAppVersion {
        fluent_builders::ImportResourcesToDraftAppVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAlarmRecommendations`](crate::client::fluent_builders::ListAlarmRecommendations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAlarmRecommendations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::ListAlarmRecommendations::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::ListAlarmRecommendations::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAlarmRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAlarmRecommendations::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAlarmRecommendations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAlarmRecommendations::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListAlarmRecommendationsOutput`](crate::output::ListAlarmRecommendationsOutput) with field(s):
    ///   - [`alarm_recommendations(Option<Vec<AlarmRecommendation>>)`](crate::output::ListAlarmRecommendationsOutput::alarm_recommendations): <p>The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object includes application component names, descriptions, information about whether a recommendation has already been implemented or not, prerequisites, and more.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAlarmRecommendationsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAlarmRecommendationsError>`](crate::error::ListAlarmRecommendationsError)
    pub fn list_alarm_recommendations(&self) -> fluent_builders::ListAlarmRecommendations {
        fluent_builders::ListAlarmRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppAssessments`](crate::client::fluent_builders::ListAppAssessments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppAssessments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppAssessments::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ListAppAssessments::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`assessment_name(impl Into<String>)`](crate::client::fluent_builders::ListAppAssessments::assessment_name) / [`set_assessment_name(Option<String>)`](crate::client::fluent_builders::ListAppAssessments::set_assessment_name): <p>The name for the assessment.</p>
    ///   - [`assessment_status(Vec<AssessmentStatus>)`](crate::client::fluent_builders::ListAppAssessments::assessment_status) / [`set_assessment_status(Option<Vec<AssessmentStatus>>)`](crate::client::fluent_builders::ListAppAssessments::set_assessment_status): <p>The current status of the assessment for the resiliency policy.</p>
    ///   - [`compliance_status(ComplianceStatus)`](crate::client::fluent_builders::ListAppAssessments::compliance_status) / [`set_compliance_status(Option<ComplianceStatus>)`](crate::client::fluent_builders::ListAppAssessments::set_compliance_status): <p>The current status of compliance for the resiliency policy.</p>
    ///   - [`invoker(AssessmentInvoker)`](crate::client::fluent_builders::ListAppAssessments::invoker) / [`set_invoker(Option<AssessmentInvoker>)`](crate::client::fluent_builders::ListAppAssessments::set_invoker): <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.</p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::ListAppAssessments::reverse_order) / [`set_reverse_order(Option<bool>)`](crate::client::fluent_builders::ListAppAssessments::set_reverse_order): <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppAssessments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppAssessments::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppAssessments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppAssessments::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListAppAssessmentsOutput`](crate::output::ListAppAssessmentsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListAppAssessmentsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`assessment_summaries(Option<Vec<AppAssessmentSummary>>)`](crate::output::ListAppAssessmentsOutput::assessment_summaries): <p>The summaries for the specified assessments, returned as an object. This object includes application versions, associated Amazon Resource Numbers (ARNs), cost, messages, resiliency scores, and more.</p>
    /// - On failure, responds with [`SdkError<ListAppAssessmentsError>`](crate::error::ListAppAssessmentsError)
    pub fn list_app_assessments(&self) -> fluent_builders::ListAppAssessments {
        fluent_builders::ListAppAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppComponentCompliances`](crate::client::fluent_builders::ListAppComponentCompliances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppComponentCompliances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppComponentCompliances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppComponentCompliances::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppComponentCompliances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppComponentCompliances::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppComponentCompliances::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::ListAppComponentCompliances::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`ListAppComponentCompliancesOutput`](crate::output::ListAppComponentCompliancesOutput) with field(s):
    ///   - [`component_compliances(Option<Vec<AppComponentCompliance>>)`](crate::output::ListAppComponentCompliancesOutput::component_compliances): <p>The compliances for an AWS Resilience Hub application component, returned as an object. This object contains component names, compliances, costs, resiliency scores, outage scores, and more.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppComponentCompliancesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAppComponentCompliancesError>`](crate::error::ListAppComponentCompliancesError)
    pub fn list_app_component_compliances(&self) -> fluent_builders::ListAppComponentCompliances {
        fluent_builders::ListAppComponentCompliances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppComponentRecommendations`](crate::client::fluent_builders::ListAppComponentRecommendations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppComponentRecommendations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppComponentRecommendations::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::ListAppComponentRecommendations::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppComponentRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppComponentRecommendations::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppComponentRecommendations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppComponentRecommendations::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListAppComponentRecommendationsOutput`](crate::output::ListAppComponentRecommendationsOutput) with field(s):
    ///   - [`component_recommendations(Option<Vec<ComponentRecommendation>>)`](crate::output::ListAppComponentRecommendationsOutput::component_recommendations): <p>The recommendations for an Resilience Hub application component, returned as an object. This object contains component names, configuration recommendations, and recommendation statuses.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppComponentRecommendationsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAppComponentRecommendationsError>`](crate::error::ListAppComponentRecommendationsError)
    pub fn list_app_component_recommendations(
        &self,
    ) -> fluent_builders::ListAppComponentRecommendations {
        fluent_builders::ListAppComponentRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApps`](crate::client::fluent_builders::ListApps) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApps::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApps::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApps::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApps::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApps::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListApps::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListApps::set_name): <p>The name for the one of the listed applications.</p>
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ListApps::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ListApps::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`ListAppsOutput`](crate::output::ListAppsOutput) with field(s):
    ///   - [`app_summaries(Option<Vec<AppSummary>>)`](crate::output::ListAppsOutput::app_summaries): <p>Summaries for the Resilience Hub application.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAppsError>`](crate::error::ListAppsError)
    pub fn list_apps(&self) -> fluent_builders::ListApps {
        fluent_builders::ListApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppVersionResourceMappings`](crate::client::fluent_builders::ListAppVersionResourceMappings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppVersionResourceMappings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppVersionResourceMappings::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ListAppVersionResourceMappings::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(impl Into<String>)`](crate::client::fluent_builders::ListAppVersionResourceMappings::app_version) / [`set_app_version(Option<String>)`](crate::client::fluent_builders::ListAppVersionResourceMappings::set_app_version): <p>The version of the application.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppVersionResourceMappings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppVersionResourceMappings::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppVersionResourceMappings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppVersionResourceMappings::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListAppVersionResourceMappingsOutput`](crate::output::ListAppVersionResourceMappingsOutput) with field(s):
    ///   - [`resource_mappings(Option<Vec<ResourceMapping>>)`](crate::output::ListAppVersionResourceMappingsOutput::resource_mappings): <p>Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppVersionResourceMappingsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAppVersionResourceMappingsError>`](crate::error::ListAppVersionResourceMappingsError)
    pub fn list_app_version_resource_mappings(
        &self,
    ) -> fluent_builders::ListAppVersionResourceMappings {
        fluent_builders::ListAppVersionResourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppVersionResources`](crate::client::fluent_builders::ListAppVersionResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppVersionResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppVersionResources::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ListAppVersionResources::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(impl Into<String>)`](crate::client::fluent_builders::ListAppVersionResources::app_version) / [`set_app_version(Option<String>)`](crate::client::fluent_builders::ListAppVersionResources::set_app_version): <p>The version of the application.</p>
    ///   - [`resolution_id(impl Into<String>)`](crate::client::fluent_builders::ListAppVersionResources::resolution_id) / [`set_resolution_id(Option<String>)`](crate::client::fluent_builders::ListAppVersionResources::set_resolution_id): <p>The identifier for a specific resolution.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppVersionResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppVersionResources::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppVersionResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppVersionResources::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListAppVersionResourcesOutput`](crate::output::ListAppVersionResourcesOutput) with field(s):
    ///   - [`physical_resources(Option<Vec<PhysicalResource>>)`](crate::output::ListAppVersionResourcesOutput::physical_resources): <p>The physical resources in the application version.</p>
    ///   - [`resolution_id(Option<String>)`](crate::output::ListAppVersionResourcesOutput::resolution_id): <p>The identifier for a specific resolution.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppVersionResourcesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAppVersionResourcesError>`](crate::error::ListAppVersionResourcesError)
    pub fn list_app_version_resources(&self) -> fluent_builders::ListAppVersionResources {
        fluent_builders::ListAppVersionResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAppVersions`](crate::client::fluent_builders::ListAppVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAppVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ListAppVersions::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ListAppVersions::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAppVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAppVersions::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAppVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAppVersions::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListAppVersionsOutput`](crate::output::ListAppVersionsOutput) with field(s):
    ///   - [`app_versions(Option<Vec<AppVersionSummary>>)`](crate::output::ListAppVersionsOutput::app_versions): <p>The version of the application.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAppVersionsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListAppVersionsError>`](crate::error::ListAppVersionsError)
    pub fn list_app_versions(&self) -> fluent_builders::ListAppVersions {
        fluent_builders::ListAppVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecommendationTemplates`](crate::client::fluent_builders::ListRecommendationTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecommendationTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`reverse_order(bool)`](crate::client::fluent_builders::ListRecommendationTemplates::reverse_order) / [`set_reverse_order(Option<bool>)`](crate::client::fluent_builders::ListRecommendationTemplates::set_reverse_order): <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
    ///   - [`status(Vec<RecommendationTemplateStatus>)`](crate::client::fluent_builders::ListRecommendationTemplates::status) / [`set_status(Option<Vec<RecommendationTemplateStatus>>)`](crate::client::fluent_builders::ListRecommendationTemplates::set_status): <p>The status of the action.</p>
    ///   - [`recommendation_template_arn(impl Into<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::recommendation_template_arn) / [`set_recommendation_template_arn(Option<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::set_recommendation_template_arn): <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::set_name): <p>The name for one of the listed recommendation templates.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecommendationTemplates::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecommendationTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRecommendationTemplates::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListRecommendationTemplatesOutput`](crate::output::ListRecommendationTemplatesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRecommendationTemplatesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`recommendation_templates(Option<Vec<RecommendationTemplate>>)`](crate::output::ListRecommendationTemplatesOutput::recommendation_templates): <p>The recommendation templates for the Resilience Hub applications.</p>
    /// - On failure, responds with [`SdkError<ListRecommendationTemplatesError>`](crate::error::ListRecommendationTemplatesError)
    pub fn list_recommendation_templates(&self) -> fluent_builders::ListRecommendationTemplates {
        fluent_builders::ListRecommendationTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResiliencyPolicies`](crate::client::fluent_builders::ListResiliencyPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListResiliencyPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::ListResiliencyPolicies::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::ListResiliencyPolicies::set_policy_name): <p>The name of the policy</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResiliencyPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResiliencyPolicies::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResiliencyPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResiliencyPolicies::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListResiliencyPoliciesOutput`](crate::output::ListResiliencyPoliciesOutput) with field(s):
    ///   - [`resiliency_policies(Option<Vec<ResiliencyPolicy>>)`](crate::output::ListResiliencyPoliciesOutput::resiliency_policies): <p>The resiliency policies for the Resilience Hub applications.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResiliencyPoliciesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListResiliencyPoliciesError>`](crate::error::ListResiliencyPoliciesError)
    pub fn list_resiliency_policies(&self) -> fluent_builders::ListResiliencyPolicies {
        fluent_builders::ListResiliencyPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSopRecommendations`](crate::client::fluent_builders::ListSopRecommendations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSopRecommendations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSopRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSopRecommendations::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSopRecommendations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSopRecommendations::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::ListSopRecommendations::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::ListSopRecommendations::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`ListSopRecommendationsOutput`](crate::output::ListSopRecommendationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListSopRecommendationsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`sop_recommendations(Option<Vec<SopRecommendation>>)`](crate::output::ListSopRecommendationsOutput::sop_recommendations): <p>The standard operating procedure (SOP) recommendations for the Resilience Hub applications.</p>
    /// - On failure, responds with [`SdkError<ListSopRecommendationsError>`](crate::error::ListSopRecommendationsError)
    pub fn list_sop_recommendations(&self) -> fluent_builders::ListSopRecommendations {
        fluent_builders::ListSopRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSuggestedResiliencyPolicies`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListSuggestedResiliencyPoliciesOutput`](crate::output::ListSuggestedResiliencyPoliciesOutput) with field(s):
    ///   - [`resiliency_policies(Option<Vec<ResiliencyPolicy>>)`](crate::output::ListSuggestedResiliencyPoliciesOutput::resiliency_policies): <p>The suggested resiliency policies for the Resilience Hub applications.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSuggestedResiliencyPoliciesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListSuggestedResiliencyPoliciesError>`](crate::error::ListSuggestedResiliencyPoliciesError)
    pub fn list_suggested_resiliency_policies(
        &self,
    ) -> fluent_builders::ListSuggestedResiliencyPolicies {
        fluent_builders::ListSuggestedResiliencyPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub application.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTestRecommendations`](crate::client::fluent_builders::ListTestRecommendations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTestRecommendations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTestRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTestRecommendations::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTestRecommendations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTestRecommendations::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`assessment_arn(impl Into<String>)`](crate::client::fluent_builders::ListTestRecommendations::assessment_arn) / [`set_assessment_arn(Option<String>)`](crate::client::fluent_builders::ListTestRecommendations::set_assessment_arn): <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`ListTestRecommendationsOutput`](crate::output::ListTestRecommendationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListTestRecommendationsOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    ///   - [`test_recommendations(Option<Vec<TestRecommendation>>)`](crate::output::ListTestRecommendationsOutput::test_recommendations): <p>The test recommendations for the Resilience Hub application.</p>
    /// - On failure, responds with [`SdkError<ListTestRecommendationsError>`](crate::error::ListTestRecommendationsError)
    pub fn list_test_recommendations(&self) -> fluent_builders::ListTestRecommendations {
        fluent_builders::ListTestRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUnsupportedAppVersionResources`](crate::client::fluent_builders::ListUnsupportedAppVersionResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(impl Into<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::app_version) / [`set_app_version(Option<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::set_app_version): <p>The version of the application.</p>
    ///   - [`resolution_id(impl Into<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::resolution_id) / [`set_resolution_id(Option<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::set_resolution_id): <p>The identifier for a specific resolution.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::set_next_token): <p>Null, or the token from a previous call to get the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::set_max_results): <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    /// - On success, responds with [`ListUnsupportedAppVersionResourcesOutput`](crate::output::ListUnsupportedAppVersionResourcesOutput) with field(s):
    ///   - [`unsupported_resources(Option<Vec<UnsupportedResource>>)`](crate::output::ListUnsupportedAppVersionResourcesOutput::unsupported_resources): <p>The unsupported resources for the application.</p>
    ///   - [`resolution_id(Option<String>)`](crate::output::ListUnsupportedAppVersionResourcesOutput::resolution_id): <p>The identifier for a specific resolution.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUnsupportedAppVersionResourcesOutput::next_token): <p>The token for the next set of results, or null if there are no more results.</p>
    /// - On failure, responds with [`SdkError<ListUnsupportedAppVersionResourcesError>`](crate::error::ListUnsupportedAppVersionResourcesError)
    pub fn list_unsupported_app_version_resources(
        &self,
    ) -> fluent_builders::ListUnsupportedAppVersionResources {
        fluent_builders::ListUnsupportedAppVersionResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PublishAppVersion`](crate::client::fluent_builders::PublishAppVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::PublishAppVersion::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::PublishAppVersion::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`PublishAppVersionOutput`](crate::output::PublishAppVersionOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::PublishAppVersionOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::PublishAppVersionOutput::app_version): <p>The version of the application.</p>
    /// - On failure, responds with [`SdkError<PublishAppVersionError>`](crate::error::PublishAppVersionError)
    pub fn publish_app_version(&self) -> fluent_builders::PublishAppVersion {
        fluent_builders::PublishAppVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDraftAppVersionTemplate`](crate::client::fluent_builders::PutDraftAppVersionTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::PutDraftAppVersionTemplate::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::PutDraftAppVersionTemplate::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_template_body(impl Into<String>)`](crate::client::fluent_builders::PutDraftAppVersionTemplate::app_template_body) / [`set_app_template_body(Option<String>)`](crate::client::fluent_builders::PutDraftAppVersionTemplate::set_app_template_body): <p>A JSON string that contains the body of the app template.</p>
    /// - On success, responds with [`PutDraftAppVersionTemplateOutput`](crate::output::PutDraftAppVersionTemplateOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::PutDraftAppVersionTemplateOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::PutDraftAppVersionTemplateOutput::app_version): <p>The version of the application.</p>
    /// - On failure, responds with [`SdkError<PutDraftAppVersionTemplateError>`](crate::error::PutDraftAppVersionTemplateError)
    pub fn put_draft_app_version_template(&self) -> fluent_builders::PutDraftAppVersionTemplate {
        fluent_builders::PutDraftAppVersionTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveDraftAppVersionResourceMappings`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`resource_names(Vec<String>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::resource_names) / [`set_resource_names(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::set_resource_names): <p>The names of the resources to remove from the resource mappings.</p>
    ///   - [`logical_stack_names(Vec<String>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::logical_stack_names) / [`set_logical_stack_names(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::set_logical_stack_names): <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
    ///   - [`app_registry_app_names(Vec<String>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::app_registry_app_names) / [`set_app_registry_app_names(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::set_app_registry_app_names): <p>The names of the registered applications to remove from the resource mappings.</p>
    ///   - [`resource_group_names(Vec<String>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::resource_group_names) / [`set_resource_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings::set_resource_group_names): <p>The names of the resource groups to remove from the resource mappings.</p>
    /// - On success, responds with [`RemoveDraftAppVersionResourceMappingsOutput`](crate::output::RemoveDraftAppVersionResourceMappingsOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::RemoveDraftAppVersionResourceMappingsOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::RemoveDraftAppVersionResourceMappingsOutput::app_version): <p>The version of the application.</p>
    /// - On failure, responds with [`SdkError<RemoveDraftAppVersionResourceMappingsError>`](crate::error::RemoveDraftAppVersionResourceMappingsError)
    pub fn remove_draft_app_version_resource_mappings(
        &self,
    ) -> fluent_builders::RemoveDraftAppVersionResourceMappings {
        fluent_builders::RemoveDraftAppVersionResourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResolveAppVersionResources`](crate::client::fluent_builders::ResolveAppVersionResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::ResolveAppVersionResources::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::ResolveAppVersionResources::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(impl Into<String>)`](crate::client::fluent_builders::ResolveAppVersionResources::app_version) / [`set_app_version(Option<String>)`](crate::client::fluent_builders::ResolveAppVersionResources::set_app_version): <p>The version of the application.</p>
    /// - On success, responds with [`ResolveAppVersionResourcesOutput`](crate::output::ResolveAppVersionResourcesOutput) with field(s):
    ///   - [`app_arn(Option<String>)`](crate::output::ResolveAppVersionResourcesOutput::app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(Option<String>)`](crate::output::ResolveAppVersionResourcesOutput::app_version): <p>The version of the application.</p>
    ///   - [`resolution_id(Option<String>)`](crate::output::ResolveAppVersionResourcesOutput::resolution_id): <p>The identifier for a specific resolution.</p>
    ///   - [`status(Option<ResourceResolutionStatusType>)`](crate::output::ResolveAppVersionResourcesOutput::status): <p>The status of the action.</p>
    /// - On failure, responds with [`SdkError<ResolveAppVersionResourcesError>`](crate::error::ResolveAppVersionResourcesError)
    pub fn resolve_app_version_resources(&self) -> fluent_builders::ResolveAppVersionResources {
        fluent_builders::ResolveAppVersionResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAppAssessment`](crate::client::fluent_builders::StartAppAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::StartAppAssessment::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::StartAppAssessment::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`app_version(impl Into<String>)`](crate::client::fluent_builders::StartAppAssessment::app_version) / [`set_app_version(Option<String>)`](crate::client::fluent_builders::StartAppAssessment::set_app_version): <p>The version of the application.</p>
    ///   - [`assessment_name(impl Into<String>)`](crate::client::fluent_builders::StartAppAssessment::assessment_name) / [`set_assessment_name(Option<String>)`](crate::client::fluent_builders::StartAppAssessment::set_assessment_name): <p>The name for the assessment.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartAppAssessment::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartAppAssessment::set_client_token): <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::StartAppAssessment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartAppAssessment::set_tags): <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    /// - On success, responds with [`StartAppAssessmentOutput`](crate::output::StartAppAssessmentOutput) with field(s):
    ///   - [`assessment(Option<AppAssessment>)`](crate::output::StartAppAssessmentOutput::assessment): <p>The assessment created.</p>
    /// - On failure, responds with [`SdkError<StartAppAssessmentError>`](crate::error::StartAppAssessmentError)
    pub fn start_app_assessment(&self) -> fluent_builders::StartAppAssessment {
        fluent_builders::StartAppAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApp`](crate::client::fluent_builders::UpdateApp) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`app_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::app_arn) / [`set_app_arn(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_app_arn): <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_description): <p>The optional description for an app.</p>
    ///   - [`policy_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApp::policy_arn) / [`set_policy_arn(Option<String>)`](crate::client::fluent_builders::UpdateApp::set_policy_arn): <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`clear_resiliency_policy_arn(bool)`](crate::client::fluent_builders::UpdateApp::clear_resiliency_policy_arn) / [`set_clear_resiliency_policy_arn(Option<bool>)`](crate::client::fluent_builders::UpdateApp::set_clear_resiliency_policy_arn): <p>Specifies if the resiliency policy ARN should be cleared.</p>
    /// - On success, responds with [`UpdateAppOutput`](crate::output::UpdateAppOutput) with field(s):
    ///   - [`app(Option<App>)`](crate::output::UpdateAppOutput::app): <p>The specified application, returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>
    /// - On failure, responds with [`SdkError<UpdateAppError>`](crate::error::UpdateAppError)
    pub fn update_app(&self) -> fluent_builders::UpdateApp {
        fluent_builders::UpdateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResiliencyPolicy`](crate::client::fluent_builders::UpdateResiliencyPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::policy_arn) / [`set_policy_arn(Option<String>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::set_policy_arn): <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::set_policy_name): <p>The name of the policy</p>
    ///   - [`policy_description(impl Into<String>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::policy_description) / [`set_policy_description(Option<String>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::set_policy_description): <p>The description for the policy.</p>
    ///   - [`data_location_constraint(DataLocationConstraint)`](crate::client::fluent_builders::UpdateResiliencyPolicy::data_location_constraint) / [`set_data_location_constraint(Option<DataLocationConstraint>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::set_data_location_constraint): <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
    ///   - [`tier(ResiliencyPolicyTier)`](crate::client::fluent_builders::UpdateResiliencyPolicy::tier) / [`set_tier(Option<ResiliencyPolicyTier>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::set_tier): <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    ///   - [`policy(HashMap<DisruptionType, FailurePolicy>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::policy) / [`set_policy(Option<HashMap<DisruptionType, FailurePolicy>>)`](crate::client::fluent_builders::UpdateResiliencyPolicy::set_policy): <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
    /// - On success, responds with [`UpdateResiliencyPolicyOutput`](crate::output::UpdateResiliencyPolicyOutput) with field(s):
    ///   - [`policy(Option<ResiliencyPolicy>)`](crate::output::UpdateResiliencyPolicyOutput::policy): <p>The type of resiliency policy that was updated, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
    /// - On failure, responds with [`SdkError<UpdateResiliencyPolicyError>`](crate::error::UpdateResiliencyPolicyError)
    pub fn update_resiliency_policy(&self) -> fluent_builders::UpdateResiliencyPolicy {
        fluent_builders::UpdateResiliencyPolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddDraftAppVersionResourceMappings`.
    ///
    /// <p>Adds the resource mapping for the draft application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddDraftAppVersionResourceMappings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_draft_app_version_resource_mappings_input::Builder,
    }
    impl AddDraftAppVersionResourceMappings {
        /// Creates a new `AddDraftAppVersionResourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddDraftAppVersionResourceMappingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AddDraftAppVersionResourceMappingsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// Appends an item to `resourceMappings`.
        ///
        /// To override the contents of this collection use [`set_resource_mappings`](Self::set_resource_mappings).
        ///
        /// <p> Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>
        pub fn resource_mappings(mut self, input: crate::model::ResourceMapping) -> Self {
            self.inner = self.inner.resource_mappings(input);
            self
        }
        /// <p> Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>
        pub fn set_resource_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
        ) -> Self {
            self.inner = self.inner.set_resource_mappings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p>Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.</p>
    /// <p>After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_app_input::Builder,
    }
    impl CreateApp {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecommendationTemplate`.
    ///
    /// <p>Creates a new recommendation template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecommendationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_recommendation_template_input::Builder,
    }
    impl CreateRecommendationTemplate {
        /// Creates a new `CreateRecommendationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecommendationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecommendationTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `recommendationIds`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommendation_ids(input.into());
            self
        }
        /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_ids(input);
            self
        }
        /// <p>The format for the recommendation template.</p>
        /// <dl>
        /// <dt>
        /// CfnJson
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>
        /// CfnYaml
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn format(mut self, input: crate::model::TemplateFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The format for the recommendation template.</p>
        /// <dl>
        /// <dt>
        /// CfnJson
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>
        /// CfnYaml
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TemplateFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// Appends an item to `recommendationTypes`.
        ///
        /// To override the contents of this collection use [`set_recommendation_types`](Self::set_recommendation_types).
        ///
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>
        /// Alarm
        /// </dt>
        /// <dd>
        /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Sop
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>SopRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Test
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>TestRecommendation</code> template.</p>
        /// </dd>
        /// </dl>
        pub fn recommendation_types(
            mut self,
            input: crate::model::RenderRecommendationType,
        ) -> Self {
            self.inner = self.inner.recommendation_types(input);
            self
        }
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>
        /// Alarm
        /// </dt>
        /// <dd>
        /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Sop
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>SopRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Test
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>TestRecommendation</code> template.</p>
        /// </dd>
        /// </dl>
        pub fn set_recommendation_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_types(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResiliencyPolicy`.
    ///
    /// <p>Creates a resiliency policy for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResiliencyPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resiliency_policy_input::Builder,
    }
    impl CreateResiliencyPolicy {
        /// Creates a new `CreateResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResiliencyPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The description for the policy.</p>
        pub fn policy_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_description(input.into());
            self
        }
        /// <p>The description for the policy.</p>
        pub fn set_policy_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_description(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn data_location_constraint(
            mut self,
            input: crate::model::DataLocationConstraint,
        ) -> Self {
            self.inner = self.inner.data_location_constraint(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn set_data_location_constraint(
            mut self,
            input: std::option::Option<crate::model::DataLocationConstraint>,
        ) -> Self {
            self.inner = self.inner.set_data_location_constraint(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn tier(mut self, input: crate::model::ResiliencyPolicyTier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicyTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// Adds a key-value pair to `policy`.
        ///
        /// To override the contents of this collection use [`set_policy`](Self::set_policy).
        ///
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn policy(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::FailurePolicy,
        ) -> Self {
            self.inner = self.inner.policy(k, v);
            self
        }
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::FailurePolicy,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p>Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl DeleteApp {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppAssessment`.
    ///
    /// <p>Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_app_assessment_input::Builder,
    }
    impl DeleteAppAssessment {
        /// Creates a new `DeleteAppAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecommendationTemplate`.
    ///
    /// <p>Deletes a recommendation template. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecommendationTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_recommendation_template_input::Builder,
    }
    impl DeleteRecommendationTemplate {
        /// Creates a new `DeleteRecommendationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecommendationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecommendationTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.recommendation_template_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_template_arn(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResiliencyPolicy`.
    ///
    /// <p>Deletes a resiliency policy. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResiliencyPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resiliency_policy_input::Builder,
    }
    impl DeleteResiliencyPolicy {
        /// Creates a new `DeleteResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResiliencyPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApp`.
    ///
    /// <p>Describes an AWS Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_input::Builder,
    }
    impl DescribeApp {
        /// Creates a new `DescribeApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppAssessment`.
    ///
    /// <p>Describes an assessment for an AWS Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_assessment_input::Builder,
    }
    impl DescribeAppAssessment {
        /// Creates a new `DescribeAppAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppVersionResourcesResolutionStatus`.
    ///
    /// <p>Returns the resolution status for the specified resolution identifier for an application version. If <code>resolutionId</code> is not specified, the current resolution status is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppVersionResourcesResolutionStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_version_resources_resolution_status_input::Builder,
    }
    impl DescribeAppVersionResourcesResolutionStatus {
        /// Creates a new `DescribeAppVersionResourcesResolutionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppVersionResourcesResolutionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAppVersionResourcesResolutionStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution_id(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppVersionTemplate`.
    ///
    /// <p>Describes details about an AWS Resilience Hub </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppVersionTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_app_version_template_input::Builder,
    }
    impl DescribeAppVersionTemplate {
        /// Creates a new `DescribeAppVersionTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppVersionTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppVersionTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDraftAppVersionResourcesImportStatus`.
    ///
    /// <p>Describes the status of importing resources to an application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDraftAppVersionResourcesImportStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_draft_app_version_resources_import_status_input::Builder,
    }
    impl DescribeDraftAppVersionResourcesImportStatus {
        /// Creates a new `DescribeDraftAppVersionResourcesImportStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDraftAppVersionResourcesImportStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDraftAppVersionResourcesImportStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResiliencyPolicy`.
    ///
    /// <p>Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResiliencyPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resiliency_policy_input::Builder,
    }
    impl DescribeResiliencyPolicy {
        /// Creates a new `DescribeResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResiliencyPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportResourcesToDraftAppVersion`.
    ///
    /// <p>Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a draft application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportResourcesToDraftAppVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_resources_to_draft_app_version_input::Builder,
    }
    impl ImportResourcesToDraftAppVersion {
        /// Creates a new `ImportResourcesToDraftAppVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportResourcesToDraftAppVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportResourcesToDraftAppVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// Appends an item to `sourceArns`.
        ///
        /// To override the contents of this collection use [`set_source_arns`](Self::set_source_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
        pub fn source_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
        pub fn set_source_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlarmRecommendations`.
    ///
    /// <p>Lists the alarm recommendations for a AWS Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAlarmRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_alarm_recommendations_input::Builder,
    }
    impl ListAlarmRecommendations {
        /// Creates a new `ListAlarmRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlarmRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlarmRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAlarmRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAlarmRecommendationsPaginator {
            crate::paginator::ListAlarmRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppAssessments`.
    ///
    /// <p>Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results for the response object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppAssessments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_assessments_input::Builder,
    }
    impl ListAppAssessments {
        /// Creates a new `ListAppAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppAssessmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppAssessmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppAssessmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppAssessmentsPaginator {
            crate::paginator::ListAppAssessmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_name(input.into());
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_name(input);
            self
        }
        /// Appends an item to `assessmentStatus`.
        ///
        /// To override the contents of this collection use [`set_assessment_status`](Self::set_assessment_status).
        ///
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn assessment_status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.inner = self.inner.assessment_status(input);
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn set_assessment_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentStatus>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_status(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.inner = self.inner.compliance_status(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.inner = self.inner.set_compliance_status(input);
            self
        }
        /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.</p>
        pub fn invoker(mut self, input: crate::model::AssessmentInvoker) -> Self {
            self.inner = self.inner.invoker(input);
            self
        }
        /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.</p>
        pub fn set_invoker(
            mut self,
            input: std::option::Option<crate::model::AssessmentInvoker>,
        ) -> Self {
            self.inner = self.inner.set_invoker(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppComponentCompliances`.
    ///
    /// <p>Lists the compliances for an AWS Resilience Hub component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppComponentCompliances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_component_compliances_input::Builder,
    }
    impl ListAppComponentCompliances {
        /// Creates a new `ListAppComponentCompliances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppComponentCompliancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppComponentCompliancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppComponentCompliancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppComponentCompliancesPaginator {
            crate::paginator::ListAppComponentCompliancesPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppComponentRecommendations`.
    ///
    /// <p>Lists the recommendations for an AWS Resilience Hub component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppComponentRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_component_recommendations_input::Builder,
    }
    impl ListAppComponentRecommendations {
        /// Creates a new `ListAppComponentRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppComponentRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppComponentRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppComponentRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppComponentRecommendationsPaginator {
            crate::paginator::ListAppComponentRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApps`.
    ///
    /// <p>Lists your Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_apps_input::Builder,
    }
    impl ListApps {
        /// Creates a new `ListApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppsPaginator {
            crate::paginator::ListAppsPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name for the one of the listed applications.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the one of the listed applications.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppVersionResourceMappings`.
    ///
    /// <p>Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppVersionResourceMappings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_version_resource_mappings_input::Builder,
    }
    impl ListAppVersionResourceMappings {
        /// Creates a new `ListAppVersionResourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppVersionResourceMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppVersionResourceMappingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppVersionResourceMappingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppVersionResourceMappingsPaginator {
            crate::paginator::ListAppVersionResourceMappingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppVersionResources`.
    ///
    /// <p>Lists all the resources in an application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppVersionResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_version_resources_input::Builder,
    }
    impl ListAppVersionResources {
        /// Creates a new `ListAppVersionResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppVersionResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppVersionResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppVersionResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppVersionResourcesPaginator {
            crate::paginator::ListAppVersionResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution_id(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolution_id(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppVersions`.
    ///
    /// <p>Lists the different versions for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_app_versions_input::Builder,
    }
    impl ListAppVersions {
        /// Creates a new `ListAppVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppVersionsPaginator {
            crate::paginator::ListAppVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommendationTemplates`.
    ///
    /// <p>Lists the recommendation templates for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecommendationTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_recommendation_templates_input::Builder,
    }
    impl ListRecommendationTemplates {
        /// Creates a new `ListRecommendationTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendationTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendationTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecommendationTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRecommendationTemplatesPaginator {
            crate::paginator::ListRecommendationTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// Appends an item to `status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::RecommendationTemplateStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationTemplateStatus>>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.recommendation_template_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_template_arn(input);
            self
        }
        /// <p>The name for one of the listed recommendation templates.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for one of the listed recommendation templates.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResiliencyPolicies`.
    ///
    /// <p>Lists the resiliency policies for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResiliencyPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resiliency_policies_input::Builder,
    }
    impl ListResiliencyPolicies {
        /// Creates a new `ListResiliencyPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResiliencyPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResiliencyPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResiliencyPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResiliencyPoliciesPaginator {
            crate::paginator::ListResiliencyPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSopRecommendations`.
    ///
    /// <p>Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSopRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_sop_recommendations_input::Builder,
    }
    impl ListSopRecommendations {
        /// Creates a new `ListSopRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSopRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSopRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSopRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSopRecommendationsPaginator {
            crate::paginator::ListSopRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuggestedResiliencyPolicies`.
    ///
    /// <p>Lists the suggested resiliency policies for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSuggestedResiliencyPolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_suggested_resiliency_policies_input::Builder,
    }
    impl ListSuggestedResiliencyPolicies {
        /// Creates a new `ListSuggestedResiliencyPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuggestedResiliencyPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuggestedResiliencyPoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSuggestedResiliencyPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSuggestedResiliencyPoliciesPaginator {
            crate::paginator::ListSuggestedResiliencyPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for your resources in your Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub application.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub application.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTestRecommendations`.
    ///
    /// <p>Lists the test recommendations for the Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTestRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_test_recommendations_input::Builder,
    }
    impl ListTestRecommendations {
        /// Creates a new `ListTestRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTestRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTestRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTestRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTestRecommendationsPaginator {
            crate::paginator::ListTestRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUnsupportedAppVersionResources`.
    ///
    /// <p>Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUnsupportedAppVersionResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_unsupported_app_version_resources_input::Builder,
    }
    impl ListUnsupportedAppVersionResources {
        /// Creates a new `ListUnsupportedAppVersionResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUnsupportedAppVersionResourcesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListUnsupportedAppVersionResourcesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUnsupportedAppVersionResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListUnsupportedAppVersionResourcesPaginator {
            crate::paginator::ListUnsupportedAppVersionResourcesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution_id(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolution_id(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishAppVersion`.
    ///
    /// <p>Publishes a new version of a specific Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishAppVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::publish_app_version_input::Builder,
    }
    impl PublishAppVersion {
        /// Creates a new `PublishAppVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishAppVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishAppVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDraftAppVersionTemplate`.
    ///
    /// <p>Adds or updates the app template for a draft version of a Resilience Hub app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDraftAppVersionTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_draft_app_version_template_input::Builder,
    }
    impl PutDraftAppVersionTemplate {
        /// Creates a new `PutDraftAppVersionTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDraftAppVersionTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDraftAppVersionTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>A JSON string that contains the body of the app template.</p>
        pub fn app_template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_template_body(input.into());
            self
        }
        /// <p>A JSON string that contains the body of the app template.</p>
        pub fn set_app_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_template_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveDraftAppVersionResourceMappings`.
    ///
    /// <p>Removes resource mappings from a draft application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveDraftAppVersionResourceMappings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_draft_app_version_resource_mappings_input::Builder,
    }
    impl RemoveDraftAppVersionResourceMappings {
        /// Creates a new `RemoveDraftAppVersionResourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveDraftAppVersionResourceMappingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RemoveDraftAppVersionResourceMappingsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// Appends an item to `resourceNames`.
        ///
        /// To override the contents of this collection use [`set_resource_names`](Self::set_resource_names).
        ///
        /// <p>The names of the resources to remove from the resource mappings.</p>
        pub fn resource_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_names(input.into());
            self
        }
        /// <p>The names of the resources to remove from the resource mappings.</p>
        pub fn set_resource_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_names(input);
            self
        }
        /// Appends an item to `logicalStackNames`.
        ///
        /// To override the contents of this collection use [`set_logical_stack_names`](Self::set_logical_stack_names).
        ///
        /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
        pub fn logical_stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logical_stack_names(input.into());
            self
        }
        /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
        pub fn set_logical_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_logical_stack_names(input);
            self
        }
        /// Appends an item to `appRegistryAppNames`.
        ///
        /// To override the contents of this collection use [`set_app_registry_app_names`](Self::set_app_registry_app_names).
        ///
        /// <p>The names of the registered applications to remove from the resource mappings.</p>
        pub fn app_registry_app_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_registry_app_names(input.into());
            self
        }
        /// <p>The names of the registered applications to remove from the resource mappings.</p>
        pub fn set_app_registry_app_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_app_registry_app_names(input);
            self
        }
        /// Appends an item to `resourceGroupNames`.
        ///
        /// To override the contents of this collection use [`set_resource_group_names`](Self::set_resource_group_names).
        ///
        /// <p>The names of the resource groups to remove from the resource mappings.</p>
        pub fn resource_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_names(input.into());
            self
        }
        /// <p>The names of the resource groups to remove from the resource mappings.</p>
        pub fn set_resource_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResolveAppVersionResources`.
    ///
    /// <p>Resolves the resources for an application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResolveAppVersionResources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::resolve_app_version_resources_input::Builder,
    }
    impl ResolveAppVersionResources {
        /// Creates a new `ResolveAppVersionResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResolveAppVersionResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ResolveAppVersionResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAppAssessment`.
    ///
    /// <p>Creates a new application assessment for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartAppAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_app_assessment_input::Builder,
    }
    impl StartAppAssessment {
        /// Creates a new `StartAppAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAppAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAppAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_name(input.into());
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_name(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies one or more tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApp`.
    ///
    /// <p>Updates an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApp {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_app_input::Builder,
    }
    impl UpdateApp {
        /// Creates a new `UpdateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
        pub fn clear_resiliency_policy_arn(mut self, input: bool) -> Self {
            self.inner = self.inner.clear_resiliency_policy_arn(input);
            self
        }
        /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
        pub fn set_clear_resiliency_policy_arn(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_clear_resiliency_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResiliencyPolicy`.
    ///
    /// <p>Updates a resiliency policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResiliencyPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resiliency_policy_input::Builder,
    }
    impl UpdateResiliencyPolicy {
        /// Creates a new `UpdateResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResiliencyPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The description for the policy.</p>
        pub fn policy_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_description(input.into());
            self
        }
        /// <p>The description for the policy.</p>
        pub fn set_policy_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_description(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn data_location_constraint(
            mut self,
            input: crate::model::DataLocationConstraint,
        ) -> Self {
            self.inner = self.inner.data_location_constraint(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn set_data_location_constraint(
            mut self,
            input: std::option::Option<crate::model::DataLocationConstraint>,
        ) -> Self {
            self.inner = self.inner.set_data_location_constraint(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn tier(mut self, input: crate::model::ResiliencyPolicyTier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicyTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// Adds a key-value pair to `policy`.
        ///
        /// To override the contents of this collection use [`set_policy`](Self::set_policy).
        ///
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn policy(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::FailurePolicy,
        ) -> Self {
            self.inner = self.inner.policy(k, v);
            self
        }
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::FailurePolicy,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
