// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Defines a resiliency policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResiliencyPolicy {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The name of the policy</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The description for the policy.</p>
    pub policy_description: std::option::Option<std::string::String>,
    /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
    pub data_location_constraint: std::option::Option<crate::model::DataLocationConstraint>,
    /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    pub tier: std::option::Option<crate::model::ResiliencyPolicyTier>,
    /// <p>Specifies the estimated cost tier of the resiliency policy.</p>
    pub estimated_cost_tier: std::option::Option<crate::model::EstimatedCostTier>,
    /// <p>The resiliency policy.</p>
    pub policy: std::option::Option<
        std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
    >,
    /// <p>The timestamp for when the resiliency policy was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ResiliencyPolicy {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The name of the policy</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The description for the policy.</p>
    pub fn policy_description(&self) -> std::option::Option<&str> {
        self.policy_description.as_deref()
    }
    /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
    pub fn data_location_constraint(
        &self,
    ) -> std::option::Option<&crate::model::DataLocationConstraint> {
        self.data_location_constraint.as_ref()
    }
    /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::ResiliencyPolicyTier> {
        self.tier.as_ref()
    }
    /// <p>Specifies the estimated cost tier of the resiliency policy.</p>
    pub fn estimated_cost_tier(&self) -> std::option::Option<&crate::model::EstimatedCostTier> {
        self.estimated_cost_tier.as_ref()
    }
    /// <p>The resiliency policy.</p>
    pub fn policy(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
    > {
        self.policy.as_ref()
    }
    /// <p>The timestamp for when the resiliency policy was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ResiliencyPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResiliencyPolicy");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_description", &self.policy_description);
        formatter.field("data_location_constraint", &self.data_location_constraint);
        formatter.field("tier", &self.tier);
        formatter.field("estimated_cost_tier", &self.estimated_cost_tier);
        formatter.field("policy", &self.policy);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ResiliencyPolicy`](crate::model::ResiliencyPolicy)
pub mod resiliency_policy {
    /// A builder for [`ResiliencyPolicy`](crate::model::ResiliencyPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_description: std::option::Option<std::string::String>,
        pub(crate) data_location_constraint:
            std::option::Option<crate::model::DataLocationConstraint>,
        pub(crate) tier: std::option::Option<crate::model::ResiliencyPolicyTier>,
        pub(crate) estimated_cost_tier: std::option::Option<crate::model::EstimatedCostTier>,
        pub(crate) policy: std::option::Option<
            std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
        >,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The description for the policy.</p>
        pub fn policy_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_description = Some(input.into());
            self
        }
        /// <p>The description for the policy.</p>
        pub fn set_policy_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_description = input;
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn data_location_constraint(
            mut self,
            input: crate::model::DataLocationConstraint,
        ) -> Self {
            self.data_location_constraint = Some(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn set_data_location_constraint(
            mut self,
            input: std::option::Option<crate::model::DataLocationConstraint>,
        ) -> Self {
            self.data_location_constraint = input;
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn tier(mut self, input: crate::model::ResiliencyPolicyTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicyTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// <p>Specifies the estimated cost tier of the resiliency policy.</p>
        pub fn estimated_cost_tier(mut self, input: crate::model::EstimatedCostTier) -> Self {
            self.estimated_cost_tier = Some(input);
            self
        }
        /// <p>Specifies the estimated cost tier of the resiliency policy.</p>
        pub fn set_estimated_cost_tier(
            mut self,
            input: std::option::Option<crate::model::EstimatedCostTier>,
        ) -> Self {
            self.estimated_cost_tier = input;
            self
        }
        /// Adds a key-value pair to `policy`.
        ///
        /// To override the contents of this collection use [`set_policy`](Self::set_policy).
        ///
        /// <p>The resiliency policy.</p>
        pub fn policy(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::FailurePolicy,
        ) -> Self {
            let mut hash_map = self.policy.unwrap_or_default();
            hash_map.insert(k, v);
            self.policy = Some(hash_map);
            self
        }
        /// <p>The resiliency policy.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::FailurePolicy,
                >,
            >,
        ) -> Self {
            self.policy = input;
            self
        }
        /// <p>The timestamp for when the resiliency policy was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The timestamp for when the resiliency policy was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ResiliencyPolicy`](crate::model::ResiliencyPolicy)
        pub fn build(self) -> crate::model::ResiliencyPolicy {
            crate::model::ResiliencyPolicy {
                policy_arn: self.policy_arn,
                policy_name: self.policy_name,
                policy_description: self.policy_description,
                data_location_constraint: self.data_location_constraint,
                tier: self.tier,
                estimated_cost_tier: self.estimated_cost_tier,
                policy: self.policy,
                creation_time: self.creation_time,
                tags: self.tags,
            }
        }
    }
}
impl ResiliencyPolicy {
    /// Creates a new builder-style object to manufacture [`ResiliencyPolicy`](crate::model::ResiliencyPolicy)
    pub fn builder() -> crate::model::resiliency_policy::Builder {
        crate::model::resiliency_policy::Builder::default()
    }
}

/// <p>Defines a failure policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailurePolicy {
    /// <p>The Recovery Time Objective (RTO), in seconds.</p>
    pub rto_in_secs: i32,
    /// <p>The Recovery Point Objective (RPO), in seconds.</p>
    pub rpo_in_secs: i32,
}
impl FailurePolicy {
    /// <p>The Recovery Time Objective (RTO), in seconds.</p>
    pub fn rto_in_secs(&self) -> i32 {
        self.rto_in_secs
    }
    /// <p>The Recovery Point Objective (RPO), in seconds.</p>
    pub fn rpo_in_secs(&self) -> i32 {
        self.rpo_in_secs
    }
}
impl std::fmt::Debug for FailurePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailurePolicy");
        formatter.field("rto_in_secs", &self.rto_in_secs);
        formatter.field("rpo_in_secs", &self.rpo_in_secs);
        formatter.finish()
    }
}
/// See [`FailurePolicy`](crate::model::FailurePolicy)
pub mod failure_policy {
    /// A builder for [`FailurePolicy`](crate::model::FailurePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rto_in_secs: std::option::Option<i32>,
        pub(crate) rpo_in_secs: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Recovery Time Objective (RTO), in seconds.</p>
        pub fn rto_in_secs(mut self, input: i32) -> Self {
            self.rto_in_secs = Some(input);
            self
        }
        /// <p>The Recovery Time Objective (RTO), in seconds.</p>
        pub fn set_rto_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.rto_in_secs = input;
            self
        }
        /// <p>The Recovery Point Objective (RPO), in seconds.</p>
        pub fn rpo_in_secs(mut self, input: i32) -> Self {
            self.rpo_in_secs = Some(input);
            self
        }
        /// <p>The Recovery Point Objective (RPO), in seconds.</p>
        pub fn set_rpo_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.rpo_in_secs = input;
            self
        }
        /// Consumes the builder and constructs a [`FailurePolicy`](crate::model::FailurePolicy)
        pub fn build(self) -> crate::model::FailurePolicy {
            crate::model::FailurePolicy {
                rto_in_secs: self.rto_in_secs.unwrap_or_default(),
                rpo_in_secs: self.rpo_in_secs.unwrap_or_default(),
            }
        }
    }
}
impl FailurePolicy {
    /// Creates a new builder-style object to manufacture [`FailurePolicy`](crate::model::FailurePolicy)
    pub fn builder() -> crate::model::failure_policy::Builder {
        crate::model::failure_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DisruptionType {
    #[allow(missing_docs)] // documentation missing in model
    Az,
    #[allow(missing_docs)] // documentation missing in model
    Hardware,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    #[allow(missing_docs)] // documentation missing in model
    Software,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DisruptionType {
    fn from(s: &str) -> Self {
        match s {
            "AZ" => DisruptionType::Az,
            "Hardware" => DisruptionType::Hardware,
            "Region" => DisruptionType::Region,
            "Software" => DisruptionType::Software,
            other => DisruptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DisruptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DisruptionType::from(s))
    }
}
impl DisruptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DisruptionType::Az => "AZ",
            DisruptionType::Hardware => "Hardware",
            DisruptionType::Region => "Region",
            DisruptionType::Software => "Software",
            DisruptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AZ", "Hardware", "Region", "Software"]
    }
}
impl AsRef<str> for DisruptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EstimatedCostTier {
    #[allow(missing_docs)] // documentation missing in model
    L1,
    #[allow(missing_docs)] // documentation missing in model
    L2,
    #[allow(missing_docs)] // documentation missing in model
    L3,
    #[allow(missing_docs)] // documentation missing in model
    L4,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EstimatedCostTier {
    fn from(s: &str) -> Self {
        match s {
            "L1" => EstimatedCostTier::L1,
            "L2" => EstimatedCostTier::L2,
            "L3" => EstimatedCostTier::L3,
            "L4" => EstimatedCostTier::L4,
            other => EstimatedCostTier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EstimatedCostTier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EstimatedCostTier::from(s))
    }
}
impl EstimatedCostTier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EstimatedCostTier::L1 => "L1",
            EstimatedCostTier::L2 => "L2",
            EstimatedCostTier::L3 => "L3",
            EstimatedCostTier::L4 => "L4",
            EstimatedCostTier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["L1", "L2", "L3", "L4"]
    }
}
impl AsRef<str> for EstimatedCostTier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResiliencyPolicyTier {
    #[allow(missing_docs)] // documentation missing in model
    CoreServices,
    #[allow(missing_docs)] // documentation missing in model
    Critical,
    #[allow(missing_docs)] // documentation missing in model
    Important,
    #[allow(missing_docs)] // documentation missing in model
    MissionCritical,
    #[allow(missing_docs)] // documentation missing in model
    NonCritical,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResiliencyPolicyTier {
    fn from(s: &str) -> Self {
        match s {
            "CoreServices" => ResiliencyPolicyTier::CoreServices,
            "Critical" => ResiliencyPolicyTier::Critical,
            "Important" => ResiliencyPolicyTier::Important,
            "MissionCritical" => ResiliencyPolicyTier::MissionCritical,
            "NonCritical" => ResiliencyPolicyTier::NonCritical,
            other => ResiliencyPolicyTier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResiliencyPolicyTier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResiliencyPolicyTier::from(s))
    }
}
impl ResiliencyPolicyTier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResiliencyPolicyTier::CoreServices => "CoreServices",
            ResiliencyPolicyTier::Critical => "Critical",
            ResiliencyPolicyTier::Important => "Important",
            ResiliencyPolicyTier::MissionCritical => "MissionCritical",
            ResiliencyPolicyTier::NonCritical => "NonCritical",
            ResiliencyPolicyTier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CoreServices",
            "Critical",
            "Important",
            "MissionCritical",
            "NonCritical",
        ]
    }
}
impl AsRef<str> for ResiliencyPolicyTier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataLocationConstraint {
    #[allow(missing_docs)] // documentation missing in model
    AnyLocation,
    #[allow(missing_docs)] // documentation missing in model
    SameContinent,
    #[allow(missing_docs)] // documentation missing in model
    SameCountry,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataLocationConstraint {
    fn from(s: &str) -> Self {
        match s {
            "AnyLocation" => DataLocationConstraint::AnyLocation,
            "SameContinent" => DataLocationConstraint::SameContinent,
            "SameCountry" => DataLocationConstraint::SameCountry,
            other => DataLocationConstraint::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataLocationConstraint {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataLocationConstraint::from(s))
    }
}
impl DataLocationConstraint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataLocationConstraint::AnyLocation => "AnyLocation",
            DataLocationConstraint::SameContinent => "SameContinent",
            DataLocationConstraint::SameCountry => "SameCountry",
            DataLocationConstraint::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AnyLocation", "SameContinent", "SameCountry"]
    }
}
impl AsRef<str> for DataLocationConstraint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a Resilience Hub application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct App {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The name for the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The optional description for an app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the app was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::AppStatusType>,
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub compliance_status: std::option::Option<crate::model::AppComplianceStatusType>,
    /// <p>The timestamp for the most recent compliance evaluation.</p>
    pub last_app_compliance_evaluation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current resiliency score for the application.</p>
    pub resiliency_score: f64,
    /// <p>The timestamp for the most recent resiliency score evaluation.</p>
    pub last_resiliency_score_evaluation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl App {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The name for the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The optional description for an app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The timestamp for when the app was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AppStatusType> {
        self.status.as_ref()
    }
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub fn compliance_status(&self) -> std::option::Option<&crate::model::AppComplianceStatusType> {
        self.compliance_status.as_ref()
    }
    /// <p>The timestamp for the most recent compliance evaluation.</p>
    pub fn last_app_compliance_evaluation_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_app_compliance_evaluation_time.as_ref()
    }
    /// <p>The current resiliency score for the application.</p>
    pub fn resiliency_score(&self) -> f64 {
        self.resiliency_score
    }
    /// <p>The timestamp for the most recent resiliency score evaluation.</p>
    pub fn last_resiliency_score_evaluation_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_resiliency_score_evaluation_time.as_ref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for App {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("App");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("status", &self.status);
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field(
            "last_app_compliance_evaluation_time",
            &self.last_app_compliance_evaluation_time,
        );
        formatter.field("resiliency_score", &self.resiliency_score);
        formatter.field(
            "last_resiliency_score_evaluation_time",
            &self.last_resiliency_score_evaluation_time,
        );
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`App`](crate::model::App)
pub mod app {
    /// A builder for [`App`](crate::model::App)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AppStatusType>,
        pub(crate) compliance_status: std::option::Option<crate::model::AppComplianceStatusType>,
        pub(crate) last_app_compliance_evaluation_time:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resiliency_score: std::option::Option<f64>,
        pub(crate) last_resiliency_score_evaluation_time:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The name for the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The timestamp for when the app was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The timestamp for when the app was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::AppStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AppStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::AppComplianceStatusType) -> Self {
            self.compliance_status = Some(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::AppComplianceStatusType>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// <p>The timestamp for the most recent compliance evaluation.</p>
        pub fn last_app_compliance_evaluation_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.last_app_compliance_evaluation_time = Some(input);
            self
        }
        /// <p>The timestamp for the most recent compliance evaluation.</p>
        pub fn set_last_app_compliance_evaluation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_app_compliance_evaluation_time = input;
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn resiliency_score(mut self, input: f64) -> Self {
            self.resiliency_score = Some(input);
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn set_resiliency_score(mut self, input: std::option::Option<f64>) -> Self {
            self.resiliency_score = input;
            self
        }
        /// <p>The timestamp for the most recent resiliency score evaluation.</p>
        pub fn last_resiliency_score_evaluation_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.last_resiliency_score_evaluation_time = Some(input);
            self
        }
        /// <p>The timestamp for the most recent resiliency score evaluation.</p>
        pub fn set_last_resiliency_score_evaluation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_resiliency_score_evaluation_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`App`](crate::model::App)
        pub fn build(self) -> crate::model::App {
            crate::model::App {
                app_arn: self.app_arn,
                name: self.name,
                description: self.description,
                policy_arn: self.policy_arn,
                creation_time: self.creation_time,
                status: self.status,
                compliance_status: self.compliance_status,
                last_app_compliance_evaluation_time: self.last_app_compliance_evaluation_time,
                resiliency_score: self.resiliency_score.unwrap_or_default(),
                last_resiliency_score_evaluation_time: self.last_resiliency_score_evaluation_time,
                tags: self.tags,
            }
        }
    }
}
impl App {
    /// Creates a new builder-style object to manufacture [`App`](crate::model::App)
    pub fn builder() -> crate::model::app::Builder {
        crate::model::app::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppComplianceStatusType {
    #[allow(missing_docs)] // documentation missing in model
    ChangesDetected,
    #[allow(missing_docs)] // documentation missing in model
    NotAssessed,
    #[allow(missing_docs)] // documentation missing in model
    PolicyBreached,
    #[allow(missing_docs)] // documentation missing in model
    PolicyMet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppComplianceStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ChangesDetected" => AppComplianceStatusType::ChangesDetected,
            "NotAssessed" => AppComplianceStatusType::NotAssessed,
            "PolicyBreached" => AppComplianceStatusType::PolicyBreached,
            "PolicyMet" => AppComplianceStatusType::PolicyMet,
            other => AppComplianceStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppComplianceStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppComplianceStatusType::from(s))
    }
}
impl AppComplianceStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppComplianceStatusType::ChangesDetected => "ChangesDetected",
            AppComplianceStatusType::NotAssessed => "NotAssessed",
            AppComplianceStatusType::PolicyBreached => "PolicyBreached",
            AppComplianceStatusType::PolicyMet => "PolicyMet",
            AppComplianceStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ChangesDetected",
            "NotAssessed",
            "PolicyBreached",
            "PolicyMet",
        ]
    }
}
impl AsRef<str> for AppComplianceStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppStatusType {
    fn from(s: &str) -> Self {
        match s {
            "Active" => AppStatusType::Active,
            "Deleting" => AppStatusType::Deleting,
            other => AppStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppStatusType::from(s))
    }
}
impl AppStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppStatusType::Active => "Active",
            AppStatusType::Deleting => "Deleting",
            AppStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Deleting"]
    }
}
impl AsRef<str> for AppStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines an application assessment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppAssessment {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The entity that invoked the assessment.</p>
    pub invoker: std::option::Option<crate::model::AssessmentInvoker>,
    /// <p>The cost for the application.</p>
    pub cost: std::option::Option<crate::model::Cost>,
    /// <p>The current resiliency score for the application.</p>
    pub resiliency_score: std::option::Option<crate::model::ResiliencyScore>,
    /// <p>The application compliance against the resiliency policy.</p>
    pub compliance: std::option::Option<
        std::collections::HashMap<crate::model::DisruptionType, crate::model::DisruptionCompliance>,
    >,
    /// <p>The current status of the compliance for the resiliency policy.</p>
    pub compliance_status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub assessment_status: std::option::Option<crate::model::AssessmentStatus>,
    /// <p>The starting time for the action.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time for the action.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Error or warning message from the assessment execution</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The name of the assessment.</p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>The resiliency policy.</p>
    pub policy: std::option::Option<crate::model::ResiliencyPolicy>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AppAssessment {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The entity that invoked the assessment.</p>
    pub fn invoker(&self) -> std::option::Option<&crate::model::AssessmentInvoker> {
        self.invoker.as_ref()
    }
    /// <p>The cost for the application.</p>
    pub fn cost(&self) -> std::option::Option<&crate::model::Cost> {
        self.cost.as_ref()
    }
    /// <p>The current resiliency score for the application.</p>
    pub fn resiliency_score(&self) -> std::option::Option<&crate::model::ResiliencyScore> {
        self.resiliency_score.as_ref()
    }
    /// <p>The application compliance against the resiliency policy.</p>
    pub fn compliance(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::DisruptionType,
            crate::model::DisruptionCompliance,
        >,
    > {
        self.compliance.as_ref()
    }
    /// <p>The current status of the compliance for the resiliency policy.</p>
    pub fn compliance_status(&self) -> std::option::Option<&crate::model::ComplianceStatus> {
        self.compliance_status.as_ref()
    }
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub fn assessment_status(&self) -> std::option::Option<&crate::model::AssessmentStatus> {
        self.assessment_status.as_ref()
    }
    /// <p>The starting time for the action.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time for the action.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>Error or warning message from the assessment execution</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The name of the assessment.</p>
    pub fn assessment_name(&self) -> std::option::Option<&str> {
        self.assessment_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>The resiliency policy.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResiliencyPolicy> {
        self.policy.as_ref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for AppAssessment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppAssessment");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("invoker", &self.invoker);
        formatter.field("cost", &self.cost);
        formatter.field("resiliency_score", &self.resiliency_score);
        formatter.field("compliance", &self.compliance);
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field("assessment_status", &self.assessment_status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("message", &self.message);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("policy", &self.policy);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`AppAssessment`](crate::model::AppAssessment)
pub mod app_assessment {
    /// A builder for [`AppAssessment`](crate::model::AppAssessment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) invoker: std::option::Option<crate::model::AssessmentInvoker>,
        pub(crate) cost: std::option::Option<crate::model::Cost>,
        pub(crate) resiliency_score: std::option::Option<crate::model::ResiliencyScore>,
        pub(crate) compliance: std::option::Option<
            std::collections::HashMap<
                crate::model::DisruptionType,
                crate::model::DisruptionCompliance,
            >,
        >,
        pub(crate) compliance_status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) assessment_status: std::option::Option<crate::model::AssessmentStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<crate::model::ResiliencyPolicy>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The entity that invoked the assessment.</p>
        pub fn invoker(mut self, input: crate::model::AssessmentInvoker) -> Self {
            self.invoker = Some(input);
            self
        }
        /// <p>The entity that invoked the assessment.</p>
        pub fn set_invoker(
            mut self,
            input: std::option::Option<crate::model::AssessmentInvoker>,
        ) -> Self {
            self.invoker = input;
            self
        }
        /// <p>The cost for the application.</p>
        pub fn cost(mut self, input: crate::model::Cost) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The cost for the application.</p>
        pub fn set_cost(mut self, input: std::option::Option<crate::model::Cost>) -> Self {
            self.cost = input;
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn resiliency_score(mut self, input: crate::model::ResiliencyScore) -> Self {
            self.resiliency_score = Some(input);
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn set_resiliency_score(
            mut self,
            input: std::option::Option<crate::model::ResiliencyScore>,
        ) -> Self {
            self.resiliency_score = input;
            self
        }
        /// Adds a key-value pair to `compliance`.
        ///
        /// To override the contents of this collection use [`set_compliance`](Self::set_compliance).
        ///
        /// <p>The application compliance against the resiliency policy.</p>
        pub fn compliance(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::DisruptionCompliance,
        ) -> Self {
            let mut hash_map = self.compliance.unwrap_or_default();
            hash_map.insert(k, v);
            self.compliance = Some(hash_map);
            self
        }
        /// <p>The application compliance against the resiliency policy.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::DisruptionCompliance,
                >,
            >,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// <p>The current status of the compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.compliance_status = Some(input);
            self
        }
        /// <p>The current status of the compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn assessment_status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.assessment_status = Some(input);
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn set_assessment_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.assessment_status = input;
            self
        }
        /// <p>The starting time for the action.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The starting time for the action.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time for the action.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time for the action.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Error or warning message from the assessment execution</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Error or warning message from the assessment execution</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The name of the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p>The name of the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>The resiliency policy.</p>
        pub fn policy(mut self, input: crate::model::ResiliencyPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>The resiliency policy.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AppAssessment`](crate::model::AppAssessment)
        pub fn build(self) -> crate::model::AppAssessment {
            crate::model::AppAssessment {
                app_arn: self.app_arn,
                app_version: self.app_version,
                invoker: self.invoker,
                cost: self.cost,
                resiliency_score: self.resiliency_score,
                compliance: self.compliance,
                compliance_status: self.compliance_status,
                assessment_status: self.assessment_status,
                start_time: self.start_time,
                end_time: self.end_time,
                message: self.message,
                assessment_name: self.assessment_name,
                assessment_arn: self.assessment_arn,
                policy: self.policy,
                tags: self.tags,
            }
        }
    }
}
impl AppAssessment {
    /// Creates a new builder-style object to manufacture [`AppAssessment`](crate::model::AppAssessment)
    pub fn builder() -> crate::model::app_assessment::Builder {
        crate::model::app_assessment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inprogress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => AssessmentStatus::Failed,
            "InProgress" => AssessmentStatus::Inprogress,
            "Pending" => AssessmentStatus::Pending,
            "Success" => AssessmentStatus::Success,
            other => AssessmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentStatus::from(s))
    }
}
impl AssessmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentStatus::Failed => "Failed",
            AssessmentStatus::Inprogress => "InProgress",
            AssessmentStatus::Pending => "Pending",
            AssessmentStatus::Success => "Success",
            AssessmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Pending", "Success"]
    }
}
impl AsRef<str> for AssessmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComplianceStatus {
    #[allow(missing_docs)] // documentation missing in model
    PolicyBreached,
    #[allow(missing_docs)] // documentation missing in model
    PolicyMet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComplianceStatus {
    fn from(s: &str) -> Self {
        match s {
            "PolicyBreached" => ComplianceStatus::PolicyBreached,
            "PolicyMet" => ComplianceStatus::PolicyMet,
            other => ComplianceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComplianceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComplianceStatus::from(s))
    }
}
impl ComplianceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComplianceStatus::PolicyBreached => "PolicyBreached",
            ComplianceStatus::PolicyMet => "PolicyMet",
            ComplianceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PolicyBreached", "PolicyMet"]
    }
}
impl AsRef<str> for ComplianceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the compliance against the resiliency policy for a disruption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisruptionCompliance {
    /// <p>The Recovery Time Objective (RTO) that is achievable, in seconds</p>
    pub achievable_rto_in_secs: i32,
    /// <p>The current RTO, in seconds.</p>
    pub current_rto_in_secs: i32,
    /// <p>The RTO reference identifier.</p>
    pub rto_reference_id: std::option::Option<std::string::String>,
    /// <p>The RTO description.</p>
    pub rto_description: std::option::Option<std::string::String>,
    /// <p>The current RPO, in seconds.</p>
    pub current_rpo_in_secs: i32,
    /// <p>The RPO reference identifier.</p>
    pub rpo_reference_id: std::option::Option<std::string::String>,
    /// <p>The RPO description.</p>
    pub rpo_description: std::option::Option<std::string::String>,
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub compliance_status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>The Recovery Point Objective (RPO) that is achievable, in seconds.</p>
    pub achievable_rpo_in_secs: i32,
    /// <p>The disruption compliance message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DisruptionCompliance {
    /// <p>The Recovery Time Objective (RTO) that is achievable, in seconds</p>
    pub fn achievable_rto_in_secs(&self) -> i32 {
        self.achievable_rto_in_secs
    }
    /// <p>The current RTO, in seconds.</p>
    pub fn current_rto_in_secs(&self) -> i32 {
        self.current_rto_in_secs
    }
    /// <p>The RTO reference identifier.</p>
    pub fn rto_reference_id(&self) -> std::option::Option<&str> {
        self.rto_reference_id.as_deref()
    }
    /// <p>The RTO description.</p>
    pub fn rto_description(&self) -> std::option::Option<&str> {
        self.rto_description.as_deref()
    }
    /// <p>The current RPO, in seconds.</p>
    pub fn current_rpo_in_secs(&self) -> i32 {
        self.current_rpo_in_secs
    }
    /// <p>The RPO reference identifier.</p>
    pub fn rpo_reference_id(&self) -> std::option::Option<&str> {
        self.rpo_reference_id.as_deref()
    }
    /// <p>The RPO description.</p>
    pub fn rpo_description(&self) -> std::option::Option<&str> {
        self.rpo_description.as_deref()
    }
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub fn compliance_status(&self) -> std::option::Option<&crate::model::ComplianceStatus> {
        self.compliance_status.as_ref()
    }
    /// <p>The Recovery Point Objective (RPO) that is achievable, in seconds.</p>
    pub fn achievable_rpo_in_secs(&self) -> i32 {
        self.achievable_rpo_in_secs
    }
    /// <p>The disruption compliance message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DisruptionCompliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisruptionCompliance");
        formatter.field("achievable_rto_in_secs", &self.achievable_rto_in_secs);
        formatter.field("current_rto_in_secs", &self.current_rto_in_secs);
        formatter.field("rto_reference_id", &self.rto_reference_id);
        formatter.field("rto_description", &self.rto_description);
        formatter.field("current_rpo_in_secs", &self.current_rpo_in_secs);
        formatter.field("rpo_reference_id", &self.rpo_reference_id);
        formatter.field("rpo_description", &self.rpo_description);
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field("achievable_rpo_in_secs", &self.achievable_rpo_in_secs);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DisruptionCompliance`](crate::model::DisruptionCompliance)
pub mod disruption_compliance {
    /// A builder for [`DisruptionCompliance`](crate::model::DisruptionCompliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) achievable_rto_in_secs: std::option::Option<i32>,
        pub(crate) current_rto_in_secs: std::option::Option<i32>,
        pub(crate) rto_reference_id: std::option::Option<std::string::String>,
        pub(crate) rto_description: std::option::Option<std::string::String>,
        pub(crate) current_rpo_in_secs: std::option::Option<i32>,
        pub(crate) rpo_reference_id: std::option::Option<std::string::String>,
        pub(crate) rpo_description: std::option::Option<std::string::String>,
        pub(crate) compliance_status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) achievable_rpo_in_secs: std::option::Option<i32>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Recovery Time Objective (RTO) that is achievable, in seconds</p>
        pub fn achievable_rto_in_secs(mut self, input: i32) -> Self {
            self.achievable_rto_in_secs = Some(input);
            self
        }
        /// <p>The Recovery Time Objective (RTO) that is achievable, in seconds</p>
        pub fn set_achievable_rto_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.achievable_rto_in_secs = input;
            self
        }
        /// <p>The current RTO, in seconds.</p>
        pub fn current_rto_in_secs(mut self, input: i32) -> Self {
            self.current_rto_in_secs = Some(input);
            self
        }
        /// <p>The current RTO, in seconds.</p>
        pub fn set_current_rto_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.current_rto_in_secs = input;
            self
        }
        /// <p>The RTO reference identifier.</p>
        pub fn rto_reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rto_reference_id = Some(input.into());
            self
        }
        /// <p>The RTO reference identifier.</p>
        pub fn set_rto_reference_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rto_reference_id = input;
            self
        }
        /// <p>The RTO description.</p>
        pub fn rto_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.rto_description = Some(input.into());
            self
        }
        /// <p>The RTO description.</p>
        pub fn set_rto_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rto_description = input;
            self
        }
        /// <p>The current RPO, in seconds.</p>
        pub fn current_rpo_in_secs(mut self, input: i32) -> Self {
            self.current_rpo_in_secs = Some(input);
            self
        }
        /// <p>The current RPO, in seconds.</p>
        pub fn set_current_rpo_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.current_rpo_in_secs = input;
            self
        }
        /// <p>The RPO reference identifier.</p>
        pub fn rpo_reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rpo_reference_id = Some(input.into());
            self
        }
        /// <p>The RPO reference identifier.</p>
        pub fn set_rpo_reference_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rpo_reference_id = input;
            self
        }
        /// <p>The RPO description.</p>
        pub fn rpo_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.rpo_description = Some(input.into());
            self
        }
        /// <p>The RPO description.</p>
        pub fn set_rpo_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rpo_description = input;
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.compliance_status = Some(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// <p>The Recovery Point Objective (RPO) that is achievable, in seconds.</p>
        pub fn achievable_rpo_in_secs(mut self, input: i32) -> Self {
            self.achievable_rpo_in_secs = Some(input);
            self
        }
        /// <p>The Recovery Point Objective (RPO) that is achievable, in seconds.</p>
        pub fn set_achievable_rpo_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.achievable_rpo_in_secs = input;
            self
        }
        /// <p>The disruption compliance message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The disruption compliance message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DisruptionCompliance`](crate::model::DisruptionCompliance)
        pub fn build(self) -> crate::model::DisruptionCompliance {
            crate::model::DisruptionCompliance {
                achievable_rto_in_secs: self.achievable_rto_in_secs.unwrap_or_default(),
                current_rto_in_secs: self.current_rto_in_secs.unwrap_or_default(),
                rto_reference_id: self.rto_reference_id,
                rto_description: self.rto_description,
                current_rpo_in_secs: self.current_rpo_in_secs.unwrap_or_default(),
                rpo_reference_id: self.rpo_reference_id,
                rpo_description: self.rpo_description,
                compliance_status: self.compliance_status,
                achievable_rpo_in_secs: self.achievable_rpo_in_secs.unwrap_or_default(),
                message: self.message,
            }
        }
    }
}
impl DisruptionCompliance {
    /// Creates a new builder-style object to manufacture [`DisruptionCompliance`](crate::model::DisruptionCompliance)
    pub fn builder() -> crate::model::disruption_compliance::Builder {
        crate::model::disruption_compliance::Builder::default()
    }
}

/// <p>The overall resiliency score, returned as an object that includes the disruption score and outage score.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResiliencyScore {
    /// <p>The outage score for a valid key.</p>
    pub score: f64,
    /// <p>The disruption score for a valid key.</p>
    pub disruption_score:
        std::option::Option<std::collections::HashMap<crate::model::DisruptionType, f64>>,
}
impl ResiliencyScore {
    /// <p>The outage score for a valid key.</p>
    pub fn score(&self) -> f64 {
        self.score
    }
    /// <p>The disruption score for a valid key.</p>
    pub fn disruption_score(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::DisruptionType, f64>> {
        self.disruption_score.as_ref()
    }
}
impl std::fmt::Debug for ResiliencyScore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResiliencyScore");
        formatter.field("score", &self.score);
        formatter.field("disruption_score", &self.disruption_score);
        formatter.finish()
    }
}
/// See [`ResiliencyScore`](crate::model::ResiliencyScore)
pub mod resiliency_score {
    /// A builder for [`ResiliencyScore`](crate::model::ResiliencyScore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score: std::option::Option<f64>,
        pub(crate) disruption_score:
            std::option::Option<std::collections::HashMap<crate::model::DisruptionType, f64>>,
    }
    impl Builder {
        /// <p>The outage score for a valid key.</p>
        pub fn score(mut self, input: f64) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The outage score for a valid key.</p>
        pub fn set_score(mut self, input: std::option::Option<f64>) -> Self {
            self.score = input;
            self
        }
        /// Adds a key-value pair to `disruption_score`.
        ///
        /// To override the contents of this collection use [`set_disruption_score`](Self::set_disruption_score).
        ///
        /// <p>The disruption score for a valid key.</p>
        pub fn disruption_score(mut self, k: crate::model::DisruptionType, v: f64) -> Self {
            let mut hash_map = self.disruption_score.unwrap_or_default();
            hash_map.insert(k, v);
            self.disruption_score = Some(hash_map);
            self
        }
        /// <p>The disruption score for a valid key.</p>
        pub fn set_disruption_score(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::DisruptionType, f64>,
            >,
        ) -> Self {
            self.disruption_score = input;
            self
        }
        /// Consumes the builder and constructs a [`ResiliencyScore`](crate::model::ResiliencyScore)
        pub fn build(self) -> crate::model::ResiliencyScore {
            crate::model::ResiliencyScore {
                score: self.score.unwrap_or_default(),
                disruption_score: self.disruption_score,
            }
        }
    }
}
impl ResiliencyScore {
    /// Creates a new builder-style object to manufacture [`ResiliencyScore`](crate::model::ResiliencyScore)
    pub fn builder() -> crate::model::resiliency_score::Builder {
        crate::model::resiliency_score::Builder::default()
    }
}

/// <p>Defines a cost object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cost {
    /// <p>The cost amount.</p>
    pub amount: f64,
    /// <p>The cost currency, for example <code>USD</code>.</p>
    pub currency: std::option::Option<std::string::String>,
    /// <p>The cost frequency.</p>
    pub frequency: std::option::Option<crate::model::CostFrequency>,
}
impl Cost {
    /// <p>The cost amount.</p>
    pub fn amount(&self) -> f64 {
        self.amount
    }
    /// <p>The cost currency, for example <code>USD</code>.</p>
    pub fn currency(&self) -> std::option::Option<&str> {
        self.currency.as_deref()
    }
    /// <p>The cost frequency.</p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::CostFrequency> {
        self.frequency.as_ref()
    }
}
impl std::fmt::Debug for Cost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cost");
        formatter.field("amount", &self.amount);
        formatter.field("currency", &self.currency);
        formatter.field("frequency", &self.frequency);
        formatter.finish()
    }
}
/// See [`Cost`](crate::model::Cost)
pub mod cost {
    /// A builder for [`Cost`](crate::model::Cost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amount: std::option::Option<f64>,
        pub(crate) currency: std::option::Option<std::string::String>,
        pub(crate) frequency: std::option::Option<crate::model::CostFrequency>,
    }
    impl Builder {
        /// <p>The cost amount.</p>
        pub fn amount(mut self, input: f64) -> Self {
            self.amount = Some(input);
            self
        }
        /// <p>The cost amount.</p>
        pub fn set_amount(mut self, input: std::option::Option<f64>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The cost currency, for example <code>USD</code>.</p>
        pub fn currency(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency = Some(input.into());
            self
        }
        /// <p>The cost currency, for example <code>USD</code>.</p>
        pub fn set_currency(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.currency = input;
            self
        }
        /// <p>The cost frequency.</p>
        pub fn frequency(mut self, input: crate::model::CostFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The cost frequency.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::CostFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`Cost`](crate::model::Cost)
        pub fn build(self) -> crate::model::Cost {
            crate::model::Cost {
                amount: self.amount.unwrap_or_default(),
                currency: self.currency,
                frequency: self.frequency,
            }
        }
    }
}
impl Cost {
    /// Creates a new builder-style object to manufacture [`Cost`](crate::model::Cost)
    pub fn builder() -> crate::model::cost::Builder {
        crate::model::cost::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostFrequency {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Hourly,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    Yearly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostFrequency {
    fn from(s: &str) -> Self {
        match s {
            "Daily" => CostFrequency::Daily,
            "Hourly" => CostFrequency::Hourly,
            "Monthly" => CostFrequency::Monthly,
            "Yearly" => CostFrequency::Yearly,
            other => CostFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostFrequency::from(s))
    }
}
impl CostFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostFrequency::Daily => "Daily",
            CostFrequency::Hourly => "Hourly",
            CostFrequency::Monthly => "Monthly",
            CostFrequency::Yearly => "Yearly",
            CostFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Daily", "Hourly", "Monthly", "Yearly"]
    }
}
impl AsRef<str> for CostFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentInvoker {
    #[allow(missing_docs)] // documentation missing in model
    System,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentInvoker {
    fn from(s: &str) -> Self {
        match s {
            "System" => AssessmentInvoker::System,
            "User" => AssessmentInvoker::User,
            other => AssessmentInvoker::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentInvoker {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentInvoker::from(s))
    }
}
impl AssessmentInvoker {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentInvoker::System => "System",
            AssessmentInvoker::User => "User",
            AssessmentInvoker::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["System", "User"]
    }
}
impl AsRef<str> for AssessmentInvoker {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceResolutionStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceResolutionStatusType {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => ResourceResolutionStatusType::Failed,
            "InProgress" => ResourceResolutionStatusType::InProgress,
            "Pending" => ResourceResolutionStatusType::Pending,
            "Success" => ResourceResolutionStatusType::Success,
            other => ResourceResolutionStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceResolutionStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceResolutionStatusType::from(s))
    }
}
impl ResourceResolutionStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceResolutionStatusType::Failed => "Failed",
            ResourceResolutionStatusType::InProgress => "InProgress",
            ResourceResolutionStatusType::Pending => "Pending",
            ResourceResolutionStatusType::Success => "Success",
            ResourceResolutionStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Pending", "Success"]
    }
}
impl AsRef<str> for ResourceResolutionStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a resource that is not supported by Resilience Hub.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedResource {
    /// <p>The logical resource identifier for the unsupported resource.</p>
    pub logical_resource_id: std::option::Option<crate::model::LogicalResourceId>,
    /// <p>The physical resource identifier for the unsupported resource.</p>
    pub physical_resource_id: std::option::Option<crate::model::PhysicalResourceId>,
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl UnsupportedResource {
    /// <p>The logical resource identifier for the unsupported resource.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&crate::model::LogicalResourceId> {
        self.logical_resource_id.as_ref()
    }
    /// <p>The physical resource identifier for the unsupported resource.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&crate::model::PhysicalResourceId> {
        self.physical_resource_id.as_ref()
    }
    /// <p>The type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedResource");
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`UnsupportedResource`](crate::model::UnsupportedResource)
pub mod unsupported_resource {
    /// A builder for [`UnsupportedResource`](crate::model::UnsupportedResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logical_resource_id: std::option::Option<crate::model::LogicalResourceId>,
        pub(crate) physical_resource_id: std::option::Option<crate::model::PhysicalResourceId>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The logical resource identifier for the unsupported resource.</p>
        pub fn logical_resource_id(mut self, input: crate::model::LogicalResourceId) -> Self {
            self.logical_resource_id = Some(input);
            self
        }
        /// <p>The logical resource identifier for the unsupported resource.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<crate::model::LogicalResourceId>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The physical resource identifier for the unsupported resource.</p>
        pub fn physical_resource_id(mut self, input: crate::model::PhysicalResourceId) -> Self {
            self.physical_resource_id = Some(input);
            self
        }
        /// <p>The physical resource identifier for the unsupported resource.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<crate::model::PhysicalResourceId>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedResource`](crate::model::UnsupportedResource)
        pub fn build(self) -> crate::model::UnsupportedResource {
            crate::model::UnsupportedResource {
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl UnsupportedResource {
    /// Creates a new builder-style object to manufacture [`UnsupportedResource`](crate::model::UnsupportedResource)
    pub fn builder() -> crate::model::unsupported_resource::Builder {
        crate::model::unsupported_resource::Builder::default()
    }
}

/// <p>Defines a physical resource identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhysicalResourceId {
    /// <p>The identifier of the physical resource.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the type of physical resource identifier.</p>
    /// <dl>
    /// <dt>
    /// Arn
    /// </dt>
    /// <dd>
    /// <p>The resource identifier is an Amazon Resource Name (ARN) .</p>
    /// </dd>
    /// <dt>
    /// Native
    /// </dt>
    /// <dd>
    /// <p>The resource identifier is a Resilience Hub-native identifier.</p>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::PhysicalIdentifierType>,
    /// <p>The Amazon Web Services Region that the physical resource is located in.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account that owns the physical resource.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
}
impl PhysicalResourceId {
    /// <p>The identifier of the physical resource.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>Specifies the type of physical resource identifier.</p>
    /// <dl>
    /// <dt>
    /// Arn
    /// </dt>
    /// <dd>
    /// <p>The resource identifier is an Amazon Resource Name (ARN) .</p>
    /// </dd>
    /// <dt>
    /// Native
    /// </dt>
    /// <dd>
    /// <p>The resource identifier is a Resilience Hub-native identifier.</p>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PhysicalIdentifierType> {
        self.r#type.as_ref()
    }
    /// <p>The Amazon Web Services Region that the physical resource is located in.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The Amazon Web Services account that owns the physical resource.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
}
impl std::fmt::Debug for PhysicalResourceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhysicalResourceId");
        formatter.field("identifier", &self.identifier);
        formatter.field("r#type", &self.r#type);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.finish()
    }
}
/// See [`PhysicalResourceId`](crate::model::PhysicalResourceId)
pub mod physical_resource_id {
    /// A builder for [`PhysicalResourceId`](crate::model::PhysicalResourceId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PhysicalIdentifierType>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the physical resource.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the physical resource.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>Specifies the type of physical resource identifier.</p>
        /// <dl>
        /// <dt>
        /// Arn
        /// </dt>
        /// <dd>
        /// <p>The resource identifier is an Amazon Resource Name (ARN) .</p>
        /// </dd>
        /// <dt>
        /// Native
        /// </dt>
        /// <dd>
        /// <p>The resource identifier is a Resilience Hub-native identifier.</p>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::PhysicalIdentifierType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the type of physical resource identifier.</p>
        /// <dl>
        /// <dt>
        /// Arn
        /// </dt>
        /// <dd>
        /// <p>The resource identifier is an Amazon Resource Name (ARN) .</p>
        /// </dd>
        /// <dt>
        /// Native
        /// </dt>
        /// <dd>
        /// <p>The resource identifier is a Resilience Hub-native identifier.</p>
        /// </dd>
        /// </dl>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PhysicalIdentifierType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Amazon Web Services Region that the physical resource is located in.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region that the physical resource is located in.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The Amazon Web Services account that owns the physical resource.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account that owns the physical resource.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PhysicalResourceId`](crate::model::PhysicalResourceId)
        pub fn build(self) -> crate::model::PhysicalResourceId {
            crate::model::PhysicalResourceId {
                identifier: self.identifier,
                r#type: self.r#type,
                aws_region: self.aws_region,
                aws_account_id: self.aws_account_id,
            }
        }
    }
}
impl PhysicalResourceId {
    /// Creates a new builder-style object to manufacture [`PhysicalResourceId`](crate::model::PhysicalResourceId)
    pub fn builder() -> crate::model::physical_resource_id::Builder {
        crate::model::physical_resource_id::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PhysicalIdentifierType {
    #[allow(missing_docs)] // documentation missing in model
    Arn,
    #[allow(missing_docs)] // documentation missing in model
    Native,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PhysicalIdentifierType {
    fn from(s: &str) -> Self {
        match s {
            "Arn" => PhysicalIdentifierType::Arn,
            "Native" => PhysicalIdentifierType::Native,
            other => PhysicalIdentifierType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PhysicalIdentifierType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PhysicalIdentifierType::from(s))
    }
}
impl PhysicalIdentifierType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PhysicalIdentifierType::Arn => "Arn",
            PhysicalIdentifierType::Native => "Native",
            PhysicalIdentifierType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Arn", "Native"]
    }
}
impl AsRef<str> for PhysicalIdentifierType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a logical resource identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogicalResourceId {
    /// <p>The identifier of the resource.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>The name of the CloudFormation stack this resource belongs to.</p>
    pub logical_stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the resource group that this resource belongs to.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
}
impl LogicalResourceId {
    /// <p>The identifier of the resource.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The name of the CloudFormation stack this resource belongs to.</p>
    pub fn logical_stack_name(&self) -> std::option::Option<&str> {
        self.logical_stack_name.as_deref()
    }
    /// <p>The name of the resource group that this resource belongs to.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
}
impl std::fmt::Debug for LogicalResourceId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogicalResourceId");
        formatter.field("identifier", &self.identifier);
        formatter.field("logical_stack_name", &self.logical_stack_name);
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.finish()
    }
}
/// See [`LogicalResourceId`](crate::model::LogicalResourceId)
pub mod logical_resource_id {
    /// A builder for [`LogicalResourceId`](crate::model::LogicalResourceId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) logical_stack_name: std::option::Option<std::string::String>,
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the resource.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the resource.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p>The name of the CloudFormation stack this resource belongs to.</p>
        pub fn logical_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack this resource belongs to.</p>
        pub fn set_logical_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_stack_name = input;
            self
        }
        /// <p>The name of the resource group that this resource belongs to.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group that this resource belongs to.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LogicalResourceId`](crate::model::LogicalResourceId)
        pub fn build(self) -> crate::model::LogicalResourceId {
            crate::model::LogicalResourceId {
                identifier: self.identifier,
                logical_stack_name: self.logical_stack_name,
                resource_group_name: self.resource_group_name,
            }
        }
    }
}
impl LogicalResourceId {
    /// Creates a new builder-style object to manufacture [`LogicalResourceId`](crate::model::LogicalResourceId)
    pub fn builder() -> crate::model::logical_resource_id::Builder {
        crate::model::logical_resource_id::Builder::default()
    }
}

/// <p>Defines a test recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestRecommendation {
    /// <p>Identifier for the test recommendation.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>The reference identifier for the test recommendation.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>The name of the application component.</p>
    pub app_component_name: std::option::Option<std::string::String>,
    /// <p>The name of the test recommendation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The intent of the test recommendation.</p>
    pub intent: std::option::Option<std::string::String>,
    /// <p>The level of risk for this test recommendation.</p>
    pub risk: std::option::Option<crate::model::TestRisk>,
    /// <p>The type of test recommendation.</p>
    pub r#type: std::option::Option<crate::model::TestType>,
    /// <p>The description for the test recommendation.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The test recommendation items.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
    /// <p>The prerequisite of the test recommendation.</p>
    pub prerequisite: std::option::Option<std::string::String>,
}
impl TestRecommendation {
    /// <p>Identifier for the test recommendation.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>The reference identifier for the test recommendation.</p>
    pub fn reference_id(&self) -> std::option::Option<&str> {
        self.reference_id.as_deref()
    }
    /// <p>The name of the application component.</p>
    pub fn app_component_name(&self) -> std::option::Option<&str> {
        self.app_component_name.as_deref()
    }
    /// <p>The name of the test recommendation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The intent of the test recommendation.</p>
    pub fn intent(&self) -> std::option::Option<&str> {
        self.intent.as_deref()
    }
    /// <p>The level of risk for this test recommendation.</p>
    pub fn risk(&self) -> std::option::Option<&crate::model::TestRisk> {
        self.risk.as_ref()
    }
    /// <p>The type of test recommendation.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TestType> {
        self.r#type.as_ref()
    }
    /// <p>The description for the test recommendation.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The test recommendation items.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RecommendationItem]> {
        self.items.as_deref()
    }
    /// <p>The prerequisite of the test recommendation.</p>
    pub fn prerequisite(&self) -> std::option::Option<&str> {
        self.prerequisite.as_deref()
    }
}
impl std::fmt::Debug for TestRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestRecommendation");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("reference_id", &self.reference_id);
        formatter.field("app_component_name", &self.app_component_name);
        formatter.field("name", &self.name);
        formatter.field("intent", &self.intent);
        formatter.field("risk", &self.risk);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("items", &self.items);
        formatter.field("prerequisite", &self.prerequisite);
        formatter.finish()
    }
}
/// See [`TestRecommendation`](crate::model::TestRecommendation)
pub mod test_recommendation {
    /// A builder for [`TestRecommendation`](crate::model::TestRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) app_component_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) intent: std::option::Option<std::string::String>,
        pub(crate) risk: std::option::Option<crate::model::TestRisk>,
        pub(crate) r#type: std::option::Option<crate::model::TestType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
        pub(crate) prerequisite: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for the test recommendation.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>Identifier for the test recommendation.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>The reference identifier for the test recommendation.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>The reference identifier for the test recommendation.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>The name of the application component.</p>
        pub fn app_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_component_name = Some(input.into());
            self
        }
        /// <p>The name of the application component.</p>
        pub fn set_app_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_component_name = input;
            self
        }
        /// <p>The name of the test recommendation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the test recommendation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The intent of the test recommendation.</p>
        pub fn intent(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent = Some(input.into());
            self
        }
        /// <p>The intent of the test recommendation.</p>
        pub fn set_intent(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent = input;
            self
        }
        /// <p>The level of risk for this test recommendation.</p>
        pub fn risk(mut self, input: crate::model::TestRisk) -> Self {
            self.risk = Some(input);
            self
        }
        /// <p>The level of risk for this test recommendation.</p>
        pub fn set_risk(mut self, input: std::option::Option<crate::model::TestRisk>) -> Self {
            self.risk = input;
            self
        }
        /// <p>The type of test recommendation.</p>
        pub fn r#type(mut self, input: crate::model::TestType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of test recommendation.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TestType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description for the test recommendation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the test recommendation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The test recommendation items.</p>
        pub fn items(mut self, input: crate::model::RecommendationItem) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>The test recommendation items.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The prerequisite of the test recommendation.</p>
        pub fn prerequisite(mut self, input: impl Into<std::string::String>) -> Self {
            self.prerequisite = Some(input.into());
            self
        }
        /// <p>The prerequisite of the test recommendation.</p>
        pub fn set_prerequisite(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prerequisite = input;
            self
        }
        /// Consumes the builder and constructs a [`TestRecommendation`](crate::model::TestRecommendation)
        pub fn build(self) -> crate::model::TestRecommendation {
            crate::model::TestRecommendation {
                recommendation_id: self.recommendation_id,
                reference_id: self.reference_id,
                app_component_name: self.app_component_name,
                name: self.name,
                intent: self.intent,
                risk: self.risk,
                r#type: self.r#type,
                description: self.description,
                items: self.items,
                prerequisite: self.prerequisite,
            }
        }
    }
}
impl TestRecommendation {
    /// Creates a new builder-style object to manufacture [`TestRecommendation`](crate::model::TestRecommendation)
    pub fn builder() -> crate::model::test_recommendation::Builder {
        crate::model::test_recommendation::Builder::default()
    }
}

/// <p>Defines a recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationItem {
    /// <p>The resource identifier.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The target account identifier.</p>
    pub target_account_id: std::option::Option<std::string::String>,
    /// <p>The target region.</p>
    pub target_region: std::option::Option<std::string::String>,
    /// <p>Specifies if the recommendation has already been implemented.</p>
    pub already_implemented: std::option::Option<bool>,
}
impl RecommendationItem {
    /// <p>The resource identifier.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The target account identifier.</p>
    pub fn target_account_id(&self) -> std::option::Option<&str> {
        self.target_account_id.as_deref()
    }
    /// <p>The target region.</p>
    pub fn target_region(&self) -> std::option::Option<&str> {
        self.target_region.as_deref()
    }
    /// <p>Specifies if the recommendation has already been implemented.</p>
    pub fn already_implemented(&self) -> std::option::Option<bool> {
        self.already_implemented
    }
}
impl std::fmt::Debug for RecommendationItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationItem");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("target_account_id", &self.target_account_id);
        formatter.field("target_region", &self.target_region);
        formatter.field("already_implemented", &self.already_implemented);
        formatter.finish()
    }
}
/// See [`RecommendationItem`](crate::model::RecommendationItem)
pub mod recommendation_item {
    /// A builder for [`RecommendationItem`](crate::model::RecommendationItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) target_account_id: std::option::Option<std::string::String>,
        pub(crate) target_region: std::option::Option<std::string::String>,
        pub(crate) already_implemented: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The resource identifier.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The resource identifier.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The target account identifier.</p>
        pub fn target_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_account_id = Some(input.into());
            self
        }
        /// <p>The target account identifier.</p>
        pub fn set_target_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_account_id = input;
            self
        }
        /// <p>The target region.</p>
        pub fn target_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_region = Some(input.into());
            self
        }
        /// <p>The target region.</p>
        pub fn set_target_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_region = input;
            self
        }
        /// <p>Specifies if the recommendation has already been implemented.</p>
        pub fn already_implemented(mut self, input: bool) -> Self {
            self.already_implemented = Some(input);
            self
        }
        /// <p>Specifies if the recommendation has already been implemented.</p>
        pub fn set_already_implemented(mut self, input: std::option::Option<bool>) -> Self {
            self.already_implemented = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationItem`](crate::model::RecommendationItem)
        pub fn build(self) -> crate::model::RecommendationItem {
            crate::model::RecommendationItem {
                resource_id: self.resource_id,
                target_account_id: self.target_account_id,
                target_region: self.target_region,
                already_implemented: self.already_implemented,
            }
        }
    }
}
impl RecommendationItem {
    /// Creates a new builder-style object to manufacture [`RecommendationItem`](crate::model::RecommendationItem)
    pub fn builder() -> crate::model::recommendation_item::Builder {
        crate::model::recommendation_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TestType {
    #[allow(missing_docs)] // documentation missing in model
    Az,
    #[allow(missing_docs)] // documentation missing in model
    Hardware,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    #[allow(missing_docs)] // documentation missing in model
    Software,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TestType {
    fn from(s: &str) -> Self {
        match s {
            "AZ" => TestType::Az,
            "Hardware" => TestType::Hardware,
            "Region" => TestType::Region,
            "Software" => TestType::Software,
            other => TestType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TestType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TestType::from(s))
    }
}
impl TestType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TestType::Az => "AZ",
            TestType::Hardware => "Hardware",
            TestType::Region => "Region",
            TestType::Software => "Software",
            TestType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AZ", "Hardware", "Region", "Software"]
    }
}
impl AsRef<str> for TestType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TestRisk {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Small,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TestRisk {
    fn from(s: &str) -> Self {
        match s {
            "High" => TestRisk::High,
            "Medium" => TestRisk::Medium,
            "Small" => TestRisk::Small,
            other => TestRisk::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TestRisk {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TestRisk::from(s))
    }
}
impl TestRisk {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TestRisk::High => "High",
            TestRisk::Medium => "Medium",
            TestRisk::Small => "Small",
            TestRisk::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["High", "Medium", "Small"]
    }
}
impl AsRef<str> for TestRisk {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a standard operating procedure (SOP) recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SopRecommendation {
    /// <p>The service type.</p>
    pub service_type: std::option::Option<crate::model::SopServiceType>,
    /// <p>The application component name.</p>
    pub app_component_name: std::option::Option<std::string::String>,
    /// <p>The description of the SOP recommendation.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Identifier for the SOP recommendation.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>The name of the SOP recommendation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The recommendation items.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
    /// <p>The reference identifier for the SOP recommendation.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>The prerequisite for the SOP recommendation.</p>
    pub prerequisite: std::option::Option<std::string::String>,
}
impl SopRecommendation {
    /// <p>The service type.</p>
    pub fn service_type(&self) -> std::option::Option<&crate::model::SopServiceType> {
        self.service_type.as_ref()
    }
    /// <p>The application component name.</p>
    pub fn app_component_name(&self) -> std::option::Option<&str> {
        self.app_component_name.as_deref()
    }
    /// <p>The description of the SOP recommendation.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Identifier for the SOP recommendation.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>The name of the SOP recommendation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The recommendation items.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RecommendationItem]> {
        self.items.as_deref()
    }
    /// <p>The reference identifier for the SOP recommendation.</p>
    pub fn reference_id(&self) -> std::option::Option<&str> {
        self.reference_id.as_deref()
    }
    /// <p>The prerequisite for the SOP recommendation.</p>
    pub fn prerequisite(&self) -> std::option::Option<&str> {
        self.prerequisite.as_deref()
    }
}
impl std::fmt::Debug for SopRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SopRecommendation");
        formatter.field("service_type", &self.service_type);
        formatter.field("app_component_name", &self.app_component_name);
        formatter.field("description", &self.description);
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("name", &self.name);
        formatter.field("items", &self.items);
        formatter.field("reference_id", &self.reference_id);
        formatter.field("prerequisite", &self.prerequisite);
        formatter.finish()
    }
}
/// See [`SopRecommendation`](crate::model::SopRecommendation)
pub mod sop_recommendation {
    /// A builder for [`SopRecommendation`](crate::model::SopRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_type: std::option::Option<crate::model::SopServiceType>,
        pub(crate) app_component_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) prerequisite: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service type.</p>
        pub fn service_type(mut self, input: crate::model::SopServiceType) -> Self {
            self.service_type = Some(input);
            self
        }
        /// <p>The service type.</p>
        pub fn set_service_type(
            mut self,
            input: std::option::Option<crate::model::SopServiceType>,
        ) -> Self {
            self.service_type = input;
            self
        }
        /// <p>The application component name.</p>
        pub fn app_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_component_name = Some(input.into());
            self
        }
        /// <p>The application component name.</p>
        pub fn set_app_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_component_name = input;
            self
        }
        /// <p>The description of the SOP recommendation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the SOP recommendation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Identifier for the SOP recommendation.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>Identifier for the SOP recommendation.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>The name of the SOP recommendation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SOP recommendation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The recommendation items.</p>
        pub fn items(mut self, input: crate::model::RecommendationItem) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>The recommendation items.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The reference identifier for the SOP recommendation.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>The reference identifier for the SOP recommendation.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>The prerequisite for the SOP recommendation.</p>
        pub fn prerequisite(mut self, input: impl Into<std::string::String>) -> Self {
            self.prerequisite = Some(input.into());
            self
        }
        /// <p>The prerequisite for the SOP recommendation.</p>
        pub fn set_prerequisite(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prerequisite = input;
            self
        }
        /// Consumes the builder and constructs a [`SopRecommendation`](crate::model::SopRecommendation)
        pub fn build(self) -> crate::model::SopRecommendation {
            crate::model::SopRecommendation {
                service_type: self.service_type,
                app_component_name: self.app_component_name,
                description: self.description,
                recommendation_id: self.recommendation_id,
                name: self.name,
                items: self.items,
                reference_id: self.reference_id,
                prerequisite: self.prerequisite,
            }
        }
    }
}
impl SopRecommendation {
    /// Creates a new builder-style object to manufacture [`SopRecommendation`](crate::model::SopRecommendation)
    pub fn builder() -> crate::model::sop_recommendation::Builder {
        crate::model::sop_recommendation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SopServiceType {
    #[allow(missing_docs)] // documentation missing in model
    Ssm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SopServiceType {
    fn from(s: &str) -> Self {
        match s {
            "SSM" => SopServiceType::Ssm,
            other => SopServiceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SopServiceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SopServiceType::from(s))
    }
}
impl SopServiceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SopServiceType::Ssm => "SSM",
            SopServiceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SSM"]
    }
}
impl AsRef<str> for SopServiceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a recommendation template created with the <code>CreateRecommendationTemplate</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationTemplate {
    /// <p>The file location of the template.</p>
    pub templates_location: std::option::Option<crate::model::S3Location>,
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>Identifiers for the recommendations used in the recommendation template.</p>
    pub recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of strings that specify the recommendation template type or types.</p>
    /// <dl>
    /// <dt>
    /// Alarm
    /// </dt>
    /// <dd>
    /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
    /// </dd>
    /// <dt>
    /// Sop
    /// </dt>
    /// <dd>
    /// <p>The template is a <code>SopRecommendation</code> template.</p>
    /// </dd>
    /// <dt>
    /// Test
    /// </dt>
    /// <dd>
    /// <p>The template is a <code>TestRecommendation</code> template.</p>
    /// </dd>
    /// </dl>
    pub recommendation_types:
        std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
    /// <p>The format of the recommendation template.</p>
    /// <dl>
    /// <dt>
    /// CfnJson
    /// </dt>
    /// <dd>
    /// <p>The template is CloudFormation JSON.</p>
    /// </dd>
    /// <dt>
    /// CfnYaml
    /// </dt>
    /// <dd>
    /// <p>The template is CloudFormation YAML.</p>
    /// </dd>
    /// </dl>
    pub format: std::option::Option<crate::model::TemplateFormat>,
    /// <p>The Amazon Resource Name (ARN) for the recommendation template.</p>
    pub recommendation_template_arn: std::option::Option<std::string::String>,
    /// <p>The message for the recommendation template.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::RecommendationTemplateStatus>,
    /// <p>The name for the recommendation template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The start time for the action.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time for the action.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Indicates if replacements are needed.</p>
    pub needs_replacements: std::option::Option<bool>,
}
impl RecommendationTemplate {
    /// <p>The file location of the template.</p>
    pub fn templates_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.templates_location.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>Identifiers for the recommendations used in the recommendation template.</p>
    pub fn recommendation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.recommendation_ids.as_deref()
    }
    /// <p>An array of strings that specify the recommendation template type or types.</p>
    /// <dl>
    /// <dt>
    /// Alarm
    /// </dt>
    /// <dd>
    /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
    /// </dd>
    /// <dt>
    /// Sop
    /// </dt>
    /// <dd>
    /// <p>The template is a <code>SopRecommendation</code> template.</p>
    /// </dd>
    /// <dt>
    /// Test
    /// </dt>
    /// <dd>
    /// <p>The template is a <code>TestRecommendation</code> template.</p>
    /// </dd>
    /// </dl>
    pub fn recommendation_types(
        &self,
    ) -> std::option::Option<&[crate::model::RenderRecommendationType]> {
        self.recommendation_types.as_deref()
    }
    /// <p>The format of the recommendation template.</p>
    /// <dl>
    /// <dt>
    /// CfnJson
    /// </dt>
    /// <dd>
    /// <p>The template is CloudFormation JSON.</p>
    /// </dd>
    /// <dt>
    /// CfnYaml
    /// </dt>
    /// <dd>
    /// <p>The template is CloudFormation YAML.</p>
    /// </dd>
    /// </dl>
    pub fn format(&self) -> std::option::Option<&crate::model::TemplateFormat> {
        self.format.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the recommendation template.</p>
    pub fn recommendation_template_arn(&self) -> std::option::Option<&str> {
        self.recommendation_template_arn.as_deref()
    }
    /// <p>The message for the recommendation template.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RecommendationTemplateStatus> {
        self.status.as_ref()
    }
    /// <p>The name for the recommendation template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The start time for the action.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time for the action.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Indicates if replacements are needed.</p>
    pub fn needs_replacements(&self) -> std::option::Option<bool> {
        self.needs_replacements
    }
}
impl std::fmt::Debug for RecommendationTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationTemplate");
        formatter.field("templates_location", &self.templates_location);
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("app_arn", &self.app_arn);
        formatter.field("recommendation_ids", &self.recommendation_ids);
        formatter.field("recommendation_types", &self.recommendation_types);
        formatter.field("format", &self.format);
        formatter.field(
            "recommendation_template_arn",
            &self.recommendation_template_arn,
        );
        formatter.field("message", &self.message);
        formatter.field("status", &self.status);
        formatter.field("name", &self.name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("needs_replacements", &self.needs_replacements);
        formatter.finish()
    }
}
/// See [`RecommendationTemplate`](crate::model::RecommendationTemplate)
pub mod recommendation_template {
    /// A builder for [`RecommendationTemplate`](crate::model::RecommendationTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) templates_location: std::option::Option<crate::model::S3Location>,
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) recommendation_types:
            std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
        pub(crate) format: std::option::Option<crate::model::TemplateFormat>,
        pub(crate) recommendation_template_arn: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RecommendationTemplateStatus>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) needs_replacements: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The file location of the template.</p>
        pub fn templates_location(mut self, input: crate::model::S3Location) -> Self {
            self.templates_location = Some(input);
            self
        }
        /// <p>The file location of the template.</p>
        pub fn set_templates_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.templates_location = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Appends an item to `recommendation_ids`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>Identifiers for the recommendations used in the recommendation template.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommendation_ids.unwrap_or_default();
            v.push(input.into());
            self.recommendation_ids = Some(v);
            self
        }
        /// <p>Identifiers for the recommendations used in the recommendation template.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommendation_ids = input;
            self
        }
        /// Appends an item to `recommendation_types`.
        ///
        /// To override the contents of this collection use [`set_recommendation_types`](Self::set_recommendation_types).
        ///
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>
        /// Alarm
        /// </dt>
        /// <dd>
        /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Sop
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>SopRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Test
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>TestRecommendation</code> template.</p>
        /// </dd>
        /// </dl>
        pub fn recommendation_types(
            mut self,
            input: crate::model::RenderRecommendationType,
        ) -> Self {
            let mut v = self.recommendation_types.unwrap_or_default();
            v.push(input);
            self.recommendation_types = Some(v);
            self
        }
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>
        /// Alarm
        /// </dt>
        /// <dd>
        /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Sop
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>SopRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Test
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>TestRecommendation</code> template.</p>
        /// </dd>
        /// </dl>
        pub fn set_recommendation_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
        ) -> Self {
            self.recommendation_types = input;
            self
        }
        /// <p>The format of the recommendation template.</p>
        /// <dl>
        /// <dt>
        /// CfnJson
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>
        /// CfnYaml
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn format(mut self, input: crate::model::TemplateFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the recommendation template.</p>
        /// <dl>
        /// <dt>
        /// CfnJson
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>
        /// CfnYaml
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TemplateFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = input;
            self
        }
        /// <p>The message for the recommendation template.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message for the recommendation template.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::RecommendationTemplateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecommendationTemplateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The start time for the action.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time for the action.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time for the action.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time for the action.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Indicates if replacements are needed.</p>
        pub fn needs_replacements(mut self, input: bool) -> Self {
            self.needs_replacements = Some(input);
            self
        }
        /// <p>Indicates if replacements are needed.</p>
        pub fn set_needs_replacements(mut self, input: std::option::Option<bool>) -> Self {
            self.needs_replacements = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationTemplate`](crate::model::RecommendationTemplate)
        pub fn build(self) -> crate::model::RecommendationTemplate {
            crate::model::RecommendationTemplate {
                templates_location: self.templates_location,
                assessment_arn: self.assessment_arn,
                app_arn: self.app_arn,
                recommendation_ids: self.recommendation_ids,
                recommendation_types: self.recommendation_types,
                format: self.format,
                recommendation_template_arn: self.recommendation_template_arn,
                message: self.message,
                status: self.status,
                name: self.name,
                start_time: self.start_time,
                end_time: self.end_time,
                tags: self.tags,
                needs_replacements: self.needs_replacements,
            }
        }
    }
}
impl RecommendationTemplate {
    /// Creates a new builder-style object to manufacture [`RecommendationTemplate`](crate::model::RecommendationTemplate)
    pub fn builder() -> crate::model::recommendation_template::Builder {
        crate::model::recommendation_template::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationTemplateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationTemplateStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => RecommendationTemplateStatus::Failed,
            "InProgress" => RecommendationTemplateStatus::InProgress,
            "Pending" => RecommendationTemplateStatus::Pending,
            "Success" => RecommendationTemplateStatus::Success,
            other => RecommendationTemplateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationTemplateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationTemplateStatus::from(s))
    }
}
impl RecommendationTemplateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationTemplateStatus::Failed => "Failed",
            RecommendationTemplateStatus::InProgress => "InProgress",
            RecommendationTemplateStatus::Pending => "Pending",
            RecommendationTemplateStatus::Success => "Success",
            RecommendationTemplateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Pending", "Success"]
    }
}
impl AsRef<str> for RecommendationTemplateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemplateFormat {
    #[allow(missing_docs)] // documentation missing in model
    CfnJson,
    #[allow(missing_docs)] // documentation missing in model
    CfnYaml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemplateFormat {
    fn from(s: &str) -> Self {
        match s {
            "CfnJson" => TemplateFormat::CfnJson,
            "CfnYaml" => TemplateFormat::CfnYaml,
            other => TemplateFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemplateFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemplateFormat::from(s))
    }
}
impl TemplateFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemplateFormat::CfnJson => "CfnJson",
            TemplateFormat::CfnYaml => "CfnYaml",
            TemplateFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CfnJson", "CfnYaml"]
    }
}
impl AsRef<str> for TemplateFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RenderRecommendationType {
    #[allow(missing_docs)] // documentation missing in model
    Alarm,
    #[allow(missing_docs)] // documentation missing in model
    Sop,
    #[allow(missing_docs)] // documentation missing in model
    Test,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RenderRecommendationType {
    fn from(s: &str) -> Self {
        match s {
            "Alarm" => RenderRecommendationType::Alarm,
            "Sop" => RenderRecommendationType::Sop,
            "Test" => RenderRecommendationType::Test,
            other => RenderRecommendationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RenderRecommendationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RenderRecommendationType::from(s))
    }
}
impl RenderRecommendationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RenderRecommendationType::Alarm => "Alarm",
            RenderRecommendationType::Sop => "Sop",
            RenderRecommendationType::Test => "Test",
            RenderRecommendationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Alarm", "Sop", "Test"]
    }
}
impl AsRef<str> for RenderRecommendationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The location of the Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The name of the Amazon S3 bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The prefix for the Amazon S3 bucket.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>The name of the Amazon S3 bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The prefix for the Amazon S3 bucket.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix for the Amazon S3 bucket.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                prefix: self.prefix,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>The version of the application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppVersionSummary {
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
}
impl AppVersionSummary {
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
}
impl std::fmt::Debug for AppVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppVersionSummary");
        formatter.field("app_version", &self.app_version);
        formatter.finish()
    }
}
/// See [`AppVersionSummary`](crate::model::AppVersionSummary)
pub mod app_version_summary {
    /// A builder for [`AppVersionSummary`](crate::model::AppVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Consumes the builder and constructs a [`AppVersionSummary`](crate::model::AppVersionSummary)
        pub fn build(self) -> crate::model::AppVersionSummary {
            crate::model::AppVersionSummary {
                app_version: self.app_version,
            }
        }
    }
}
impl AppVersionSummary {
    /// Creates a new builder-style object to manufacture [`AppVersionSummary`](crate::model::AppVersionSummary)
    pub fn builder() -> crate::model::app_version_summary::Builder {
        crate::model::app_version_summary::Builder::default()
    }
}

/// <p>Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhysicalResource {
    /// <p>The name of the resource.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The logical identifier of the resource.</p>
    pub logical_resource_id: std::option::Option<crate::model::LogicalResourceId>,
    /// <p>The physical identifier of the resource.</p>
    pub physical_resource_id: std::option::Option<crate::model::PhysicalResourceId>,
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The application components that belong to this resource.</p>
    pub app_components: std::option::Option<std::vec::Vec<crate::model::AppComponent>>,
}
impl PhysicalResource {
    /// <p>The name of the resource.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The logical identifier of the resource.</p>
    pub fn logical_resource_id(&self) -> std::option::Option<&crate::model::LogicalResourceId> {
        self.logical_resource_id.as_ref()
    }
    /// <p>The physical identifier of the resource.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&crate::model::PhysicalResourceId> {
        self.physical_resource_id.as_ref()
    }
    /// <p>The type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The application components that belong to this resource.</p>
    pub fn app_components(&self) -> std::option::Option<&[crate::model::AppComponent]> {
        self.app_components.as_deref()
    }
}
impl std::fmt::Debug for PhysicalResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhysicalResource");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("logical_resource_id", &self.logical_resource_id);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("app_components", &self.app_components);
        formatter.finish()
    }
}
/// See [`PhysicalResource`](crate::model::PhysicalResource)
pub mod physical_resource {
    /// A builder for [`PhysicalResource`](crate::model::PhysicalResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) logical_resource_id: std::option::Option<crate::model::LogicalResourceId>,
        pub(crate) physical_resource_id: std::option::Option<crate::model::PhysicalResourceId>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) app_components: std::option::Option<std::vec::Vec<crate::model::AppComponent>>,
    }
    impl Builder {
        /// <p>The name of the resource.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The logical identifier of the resource.</p>
        pub fn logical_resource_id(mut self, input: crate::model::LogicalResourceId) -> Self {
            self.logical_resource_id = Some(input);
            self
        }
        /// <p>The logical identifier of the resource.</p>
        pub fn set_logical_resource_id(
            mut self,
            input: std::option::Option<crate::model::LogicalResourceId>,
        ) -> Self {
            self.logical_resource_id = input;
            self
        }
        /// <p>The physical identifier of the resource.</p>
        pub fn physical_resource_id(mut self, input: crate::model::PhysicalResourceId) -> Self {
            self.physical_resource_id = Some(input);
            self
        }
        /// <p>The physical identifier of the resource.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<crate::model::PhysicalResourceId>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `app_components`.
        ///
        /// To override the contents of this collection use [`set_app_components`](Self::set_app_components).
        ///
        /// <p>The application components that belong to this resource.</p>
        pub fn app_components(mut self, input: crate::model::AppComponent) -> Self {
            let mut v = self.app_components.unwrap_or_default();
            v.push(input);
            self.app_components = Some(v);
            self
        }
        /// <p>The application components that belong to this resource.</p>
        pub fn set_app_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppComponent>>,
        ) -> Self {
            self.app_components = input;
            self
        }
        /// Consumes the builder and constructs a [`PhysicalResource`](crate::model::PhysicalResource)
        pub fn build(self) -> crate::model::PhysicalResource {
            crate::model::PhysicalResource {
                resource_name: self.resource_name,
                logical_resource_id: self.logical_resource_id,
                physical_resource_id: self.physical_resource_id,
                resource_type: self.resource_type,
                app_components: self.app_components,
            }
        }
    }
}
impl PhysicalResource {
    /// Creates a new builder-style object to manufacture [`PhysicalResource`](crate::model::PhysicalResource)
    pub fn builder() -> crate::model::physical_resource::Builder {
        crate::model::physical_resource::Builder::default()
    }
}

/// <p>Defines an application component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppComponent {
    /// <p>The name of the application component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of application component.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl AppComponent {
    /// <p>The name of the application component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of application component.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for AppComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppComponent");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`AppComponent`](crate::model::AppComponent)
pub mod app_component {
    /// A builder for [`AppComponent`](crate::model::AppComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of application component.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of application component.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`AppComponent`](crate::model::AppComponent)
        pub fn build(self) -> crate::model::AppComponent {
            crate::model::AppComponent {
                name: self.name,
                r#type: self.r#type,
            }
        }
    }
}
impl AppComponent {
    /// Creates a new builder-style object to manufacture [`AppComponent`](crate::model::AppComponent)
    pub fn builder() -> crate::model::app_component::Builder {
        crate::model::app_component::Builder::default()
    }
}

/// <p>Defines a resource mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceMapping {
    /// <p>The name of the resource this resource is mapped to.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The name of the CloudFormation stack this resource is mapped to.</p>
    pub logical_stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the application this resource is mapped to.</p>
    pub app_registry_app_name: std::option::Option<std::string::String>,
    /// <p>The name of the resource group this resource is mapped to.</p>
    pub resource_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies the type of resource mapping.</p>
    /// <dl>
    /// <dt>
    /// AppRegistryApp
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to another application. The name of the application is contained in the <code>appRegistryAppName</code> property.</p>
    /// </dd>
    /// <dt>
    /// CfnStack
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the <code>logicalStackName</code> property.</p>
    /// </dd>
    /// <dt>
    /// Resource
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to another resource. The name of the resource is contained in the <code>resourceName</code> property.</p>
    /// </dd>
    /// <dt>
    /// ResourceGroup
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to a resource group. The name of the resource group is contained in the <code>resourceGroupName</code> property.</p>
    /// </dd>
    /// </dl>
    pub mapping_type: std::option::Option<crate::model::ResourceMappingType>,
    /// <p>The identifier of this resource.</p>
    pub physical_resource_id: std::option::Option<crate::model::PhysicalResourceId>,
}
impl ResourceMapping {
    /// <p>The name of the resource this resource is mapped to.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The name of the CloudFormation stack this resource is mapped to.</p>
    pub fn logical_stack_name(&self) -> std::option::Option<&str> {
        self.logical_stack_name.as_deref()
    }
    /// <p>The name of the application this resource is mapped to.</p>
    pub fn app_registry_app_name(&self) -> std::option::Option<&str> {
        self.app_registry_app_name.as_deref()
    }
    /// <p>The name of the resource group this resource is mapped to.</p>
    pub fn resource_group_name(&self) -> std::option::Option<&str> {
        self.resource_group_name.as_deref()
    }
    /// <p>Specifies the type of resource mapping.</p>
    /// <dl>
    /// <dt>
    /// AppRegistryApp
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to another application. The name of the application is contained in the <code>appRegistryAppName</code> property.</p>
    /// </dd>
    /// <dt>
    /// CfnStack
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the <code>logicalStackName</code> property.</p>
    /// </dd>
    /// <dt>
    /// Resource
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to another resource. The name of the resource is contained in the <code>resourceName</code> property.</p>
    /// </dd>
    /// <dt>
    /// ResourceGroup
    /// </dt>
    /// <dd>
    /// <p>The resource is mapped to a resource group. The name of the resource group is contained in the <code>resourceGroupName</code> property.</p>
    /// </dd>
    /// </dl>
    pub fn mapping_type(&self) -> std::option::Option<&crate::model::ResourceMappingType> {
        self.mapping_type.as_ref()
    }
    /// <p>The identifier of this resource.</p>
    pub fn physical_resource_id(&self) -> std::option::Option<&crate::model::PhysicalResourceId> {
        self.physical_resource_id.as_ref()
    }
}
impl std::fmt::Debug for ResourceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceMapping");
        formatter.field("resource_name", &self.resource_name);
        formatter.field("logical_stack_name", &self.logical_stack_name);
        formatter.field("app_registry_app_name", &self.app_registry_app_name);
        formatter.field("resource_group_name", &self.resource_group_name);
        formatter.field("mapping_type", &self.mapping_type);
        formatter.field("physical_resource_id", &self.physical_resource_id);
        formatter.finish()
    }
}
/// See [`ResourceMapping`](crate::model::ResourceMapping)
pub mod resource_mapping {
    /// A builder for [`ResourceMapping`](crate::model::ResourceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) logical_stack_name: std::option::Option<std::string::String>,
        pub(crate) app_registry_app_name: std::option::Option<std::string::String>,
        pub(crate) resource_group_name: std::option::Option<std::string::String>,
        pub(crate) mapping_type: std::option::Option<crate::model::ResourceMappingType>,
        pub(crate) physical_resource_id: std::option::Option<crate::model::PhysicalResourceId>,
    }
    impl Builder {
        /// <p>The name of the resource this resource is mapped to.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource this resource is mapped to.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The name of the CloudFormation stack this resource is mapped to.</p>
        pub fn logical_stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.logical_stack_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack this resource is mapped to.</p>
        pub fn set_logical_stack_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logical_stack_name = input;
            self
        }
        /// <p>The name of the application this resource is mapped to.</p>
        pub fn app_registry_app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_registry_app_name = Some(input.into());
            self
        }
        /// <p>The name of the application this resource is mapped to.</p>
        pub fn set_app_registry_app_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_registry_app_name = input;
            self
        }
        /// <p>The name of the resource group this resource is mapped to.</p>
        pub fn resource_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_group_name = Some(input.into());
            self
        }
        /// <p>The name of the resource group this resource is mapped to.</p>
        pub fn set_resource_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_group_name = input;
            self
        }
        /// <p>Specifies the type of resource mapping.</p>
        /// <dl>
        /// <dt>
        /// AppRegistryApp
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to another application. The name of the application is contained in the <code>appRegistryAppName</code> property.</p>
        /// </dd>
        /// <dt>
        /// CfnStack
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the <code>logicalStackName</code> property.</p>
        /// </dd>
        /// <dt>
        /// Resource
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to another resource. The name of the resource is contained in the <code>resourceName</code> property.</p>
        /// </dd>
        /// <dt>
        /// ResourceGroup
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to a resource group. The name of the resource group is contained in the <code>resourceGroupName</code> property.</p>
        /// </dd>
        /// </dl>
        pub fn mapping_type(mut self, input: crate::model::ResourceMappingType) -> Self {
            self.mapping_type = Some(input);
            self
        }
        /// <p>Specifies the type of resource mapping.</p>
        /// <dl>
        /// <dt>
        /// AppRegistryApp
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to another application. The name of the application is contained in the <code>appRegistryAppName</code> property.</p>
        /// </dd>
        /// <dt>
        /// CfnStack
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the <code>logicalStackName</code> property.</p>
        /// </dd>
        /// <dt>
        /// Resource
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to another resource. The name of the resource is contained in the <code>resourceName</code> property.</p>
        /// </dd>
        /// <dt>
        /// ResourceGroup
        /// </dt>
        /// <dd>
        /// <p>The resource is mapped to a resource group. The name of the resource group is contained in the <code>resourceGroupName</code> property.</p>
        /// </dd>
        /// </dl>
        pub fn set_mapping_type(
            mut self,
            input: std::option::Option<crate::model::ResourceMappingType>,
        ) -> Self {
            self.mapping_type = input;
            self
        }
        /// <p>The identifier of this resource.</p>
        pub fn physical_resource_id(mut self, input: crate::model::PhysicalResourceId) -> Self {
            self.physical_resource_id = Some(input);
            self
        }
        /// <p>The identifier of this resource.</p>
        pub fn set_physical_resource_id(
            mut self,
            input: std::option::Option<crate::model::PhysicalResourceId>,
        ) -> Self {
            self.physical_resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceMapping`](crate::model::ResourceMapping)
        pub fn build(self) -> crate::model::ResourceMapping {
            crate::model::ResourceMapping {
                resource_name: self.resource_name,
                logical_stack_name: self.logical_stack_name,
                app_registry_app_name: self.app_registry_app_name,
                resource_group_name: self.resource_group_name,
                mapping_type: self.mapping_type,
                physical_resource_id: self.physical_resource_id,
            }
        }
    }
}
impl ResourceMapping {
    /// Creates a new builder-style object to manufacture [`ResourceMapping`](crate::model::ResourceMapping)
    pub fn builder() -> crate::model::resource_mapping::Builder {
        crate::model::resource_mapping::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceMappingType {
    #[allow(missing_docs)] // documentation missing in model
    AppRegistryApp,
    #[allow(missing_docs)] // documentation missing in model
    CfnStack,
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    #[allow(missing_docs)] // documentation missing in model
    ResourceGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceMappingType {
    fn from(s: &str) -> Self {
        match s {
            "AppRegistryApp" => ResourceMappingType::AppRegistryApp,
            "CfnStack" => ResourceMappingType::CfnStack,
            "Resource" => ResourceMappingType::Resource,
            "ResourceGroup" => ResourceMappingType::ResourceGroup,
            other => ResourceMappingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceMappingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceMappingType::from(s))
    }
}
impl ResourceMappingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceMappingType::AppRegistryApp => "AppRegistryApp",
            ResourceMappingType::CfnStack => "CfnStack",
            ResourceMappingType::Resource => "Resource",
            ResourceMappingType::ResourceGroup => "ResourceGroup",
            ResourceMappingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AppRegistryApp", "CfnStack", "Resource", "ResourceGroup"]
    }
}
impl AsRef<str> for ResourceMappingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines an application summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppSummary {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The optional description for an app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the app was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub compliance_status: std::option::Option<crate::model::AppComplianceStatusType>,
    /// <p>The current resiliency score for the application.</p>
    pub resiliency_score: f64,
}
impl AppSummary {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The optional description for an app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp for when the app was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub fn compliance_status(&self) -> std::option::Option<&crate::model::AppComplianceStatusType> {
        self.compliance_status.as_ref()
    }
    /// <p>The current resiliency score for the application.</p>
    pub fn resiliency_score(&self) -> f64 {
        self.resiliency_score
    }
}
impl std::fmt::Debug for AppSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppSummary");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field("resiliency_score", &self.resiliency_score);
        formatter.finish()
    }
}
/// See [`AppSummary`](crate::model::AppSummary)
pub mod app_summary {
    /// A builder for [`AppSummary`](crate::model::AppSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) compliance_status: std::option::Option<crate::model::AppComplianceStatusType>,
        pub(crate) resiliency_score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp for when the app was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The timestamp for when the app was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::AppComplianceStatusType) -> Self {
            self.compliance_status = Some(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::AppComplianceStatusType>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn resiliency_score(mut self, input: f64) -> Self {
            self.resiliency_score = Some(input);
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn set_resiliency_score(mut self, input: std::option::Option<f64>) -> Self {
            self.resiliency_score = input;
            self
        }
        /// Consumes the builder and constructs a [`AppSummary`](crate::model::AppSummary)
        pub fn build(self) -> crate::model::AppSummary {
            crate::model::AppSummary {
                app_arn: self.app_arn,
                name: self.name,
                description: self.description,
                creation_time: self.creation_time,
                compliance_status: self.compliance_status,
                resiliency_score: self.resiliency_score.unwrap_or_default(),
            }
        }
    }
}
impl AppSummary {
    /// Creates a new builder-style object to manufacture [`AppSummary`](crate::model::AppSummary)
    pub fn builder() -> crate::model::app_summary::Builder {
        crate::model::app_summary::Builder::default()
    }
}

/// <p>Defines recommendations for a Resilience Hub application component, returned as an object. This object contains component names, configuration recommendations, and recommendation statuses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentRecommendation {
    /// <p>The name of the application component.</p>
    pub app_component_name: std::option::Option<std::string::String>,
    /// <p>The recommendation status.</p>
    pub recommendation_status: std::option::Option<crate::model::RecommendationComplianceStatus>,
    /// <p>The list of recommendations.</p>
    pub config_recommendations:
        std::option::Option<std::vec::Vec<crate::model::ConfigRecommendation>>,
}
impl ComponentRecommendation {
    /// <p>The name of the application component.</p>
    pub fn app_component_name(&self) -> std::option::Option<&str> {
        self.app_component_name.as_deref()
    }
    /// <p>The recommendation status.</p>
    pub fn recommendation_status(
        &self,
    ) -> std::option::Option<&crate::model::RecommendationComplianceStatus> {
        self.recommendation_status.as_ref()
    }
    /// <p>The list of recommendations.</p>
    pub fn config_recommendations(
        &self,
    ) -> std::option::Option<&[crate::model::ConfigRecommendation]> {
        self.config_recommendations.as_deref()
    }
}
impl std::fmt::Debug for ComponentRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentRecommendation");
        formatter.field("app_component_name", &self.app_component_name);
        formatter.field("recommendation_status", &self.recommendation_status);
        formatter.field("config_recommendations", &self.config_recommendations);
        formatter.finish()
    }
}
/// See [`ComponentRecommendation`](crate::model::ComponentRecommendation)
pub mod component_recommendation {
    /// A builder for [`ComponentRecommendation`](crate::model::ComponentRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_component_name: std::option::Option<std::string::String>,
        pub(crate) recommendation_status:
            std::option::Option<crate::model::RecommendationComplianceStatus>,
        pub(crate) config_recommendations:
            std::option::Option<std::vec::Vec<crate::model::ConfigRecommendation>>,
    }
    impl Builder {
        /// <p>The name of the application component.</p>
        pub fn app_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_component_name = Some(input.into());
            self
        }
        /// <p>The name of the application component.</p>
        pub fn set_app_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_component_name = input;
            self
        }
        /// <p>The recommendation status.</p>
        pub fn recommendation_status(
            mut self,
            input: crate::model::RecommendationComplianceStatus,
        ) -> Self {
            self.recommendation_status = Some(input);
            self
        }
        /// <p>The recommendation status.</p>
        pub fn set_recommendation_status(
            mut self,
            input: std::option::Option<crate::model::RecommendationComplianceStatus>,
        ) -> Self {
            self.recommendation_status = input;
            self
        }
        /// Appends an item to `config_recommendations`.
        ///
        /// To override the contents of this collection use [`set_config_recommendations`](Self::set_config_recommendations).
        ///
        /// <p>The list of recommendations.</p>
        pub fn config_recommendations(mut self, input: crate::model::ConfigRecommendation) -> Self {
            let mut v = self.config_recommendations.unwrap_or_default();
            v.push(input);
            self.config_recommendations = Some(v);
            self
        }
        /// <p>The list of recommendations.</p>
        pub fn set_config_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConfigRecommendation>>,
        ) -> Self {
            self.config_recommendations = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentRecommendation`](crate::model::ComponentRecommendation)
        pub fn build(self) -> crate::model::ComponentRecommendation {
            crate::model::ComponentRecommendation {
                app_component_name: self.app_component_name,
                recommendation_status: self.recommendation_status,
                config_recommendations: self.config_recommendations,
            }
        }
    }
}
impl ComponentRecommendation {
    /// Creates a new builder-style object to manufacture [`ComponentRecommendation`](crate::model::ComponentRecommendation)
    pub fn builder() -> crate::model::component_recommendation::Builder {
        crate::model::component_recommendation::Builder::default()
    }
}

/// <p>Defines a configuration recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfigRecommendation {
    /// <p>The cost for the application.</p>
    pub cost: std::option::Option<crate::model::Cost>,
    /// <p>The application component name.</p>
    pub app_component_name: std::option::Option<std::string::String>,
    /// <p>The current compliance against the resiliency policy before applying the configuration change.</p>
    pub compliance: std::option::Option<
        std::collections::HashMap<crate::model::DisruptionType, crate::model::DisruptionCompliance>,
    >,
    /// <p>The expected compliance against the resiliency policy after applying the configuration change.</p>
    pub recommendation_compliance: std::option::Option<
        std::collections::HashMap<
            crate::model::DisruptionType,
            crate::model::RecommendationDisruptionCompliance,
        >,
    >,
    /// <p>The type of optimization.</p>
    pub optimization_type: std::option::Option<crate::model::ConfigRecommendationOptimizationType>,
    /// <p>The name of the recommendation configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The optional description for an app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>List of the suggested configuration changes.</p>
    pub suggested_changes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The architecture type.</p>
    pub ha_architecture: std::option::Option<crate::model::HaArchitecture>,
    /// <p>The reference identifier for the recommendation configuration.</p>
    pub reference_id: std::option::Option<std::string::String>,
}
impl ConfigRecommendation {
    /// <p>The cost for the application.</p>
    pub fn cost(&self) -> std::option::Option<&crate::model::Cost> {
        self.cost.as_ref()
    }
    /// <p>The application component name.</p>
    pub fn app_component_name(&self) -> std::option::Option<&str> {
        self.app_component_name.as_deref()
    }
    /// <p>The current compliance against the resiliency policy before applying the configuration change.</p>
    pub fn compliance(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::DisruptionType,
            crate::model::DisruptionCompliance,
        >,
    > {
        self.compliance.as_ref()
    }
    /// <p>The expected compliance against the resiliency policy after applying the configuration change.</p>
    pub fn recommendation_compliance(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::DisruptionType,
            crate::model::RecommendationDisruptionCompliance,
        >,
    > {
        self.recommendation_compliance.as_ref()
    }
    /// <p>The type of optimization.</p>
    pub fn optimization_type(
        &self,
    ) -> std::option::Option<&crate::model::ConfigRecommendationOptimizationType> {
        self.optimization_type.as_ref()
    }
    /// <p>The name of the recommendation configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The optional description for an app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>List of the suggested configuration changes.</p>
    pub fn suggested_changes(&self) -> std::option::Option<&[std::string::String]> {
        self.suggested_changes.as_deref()
    }
    /// <p>The architecture type.</p>
    pub fn ha_architecture(&self) -> std::option::Option<&crate::model::HaArchitecture> {
        self.ha_architecture.as_ref()
    }
    /// <p>The reference identifier for the recommendation configuration.</p>
    pub fn reference_id(&self) -> std::option::Option<&str> {
        self.reference_id.as_deref()
    }
}
impl std::fmt::Debug for ConfigRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfigRecommendation");
        formatter.field("cost", &self.cost);
        formatter.field("app_component_name", &self.app_component_name);
        formatter.field("compliance", &self.compliance);
        formatter.field("recommendation_compliance", &self.recommendation_compliance);
        formatter.field("optimization_type", &self.optimization_type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("suggested_changes", &self.suggested_changes);
        formatter.field("ha_architecture", &self.ha_architecture);
        formatter.field("reference_id", &self.reference_id);
        formatter.finish()
    }
}
/// See [`ConfigRecommendation`](crate::model::ConfigRecommendation)
pub mod config_recommendation {
    /// A builder for [`ConfigRecommendation`](crate::model::ConfigRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost: std::option::Option<crate::model::Cost>,
        pub(crate) app_component_name: std::option::Option<std::string::String>,
        pub(crate) compliance: std::option::Option<
            std::collections::HashMap<
                crate::model::DisruptionType,
                crate::model::DisruptionCompliance,
            >,
        >,
        pub(crate) recommendation_compliance: std::option::Option<
            std::collections::HashMap<
                crate::model::DisruptionType,
                crate::model::RecommendationDisruptionCompliance,
            >,
        >,
        pub(crate) optimization_type:
            std::option::Option<crate::model::ConfigRecommendationOptimizationType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) suggested_changes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ha_architecture: std::option::Option<crate::model::HaArchitecture>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cost for the application.</p>
        pub fn cost(mut self, input: crate::model::Cost) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The cost for the application.</p>
        pub fn set_cost(mut self, input: std::option::Option<crate::model::Cost>) -> Self {
            self.cost = input;
            self
        }
        /// <p>The application component name.</p>
        pub fn app_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_component_name = Some(input.into());
            self
        }
        /// <p>The application component name.</p>
        pub fn set_app_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_component_name = input;
            self
        }
        /// Adds a key-value pair to `compliance`.
        ///
        /// To override the contents of this collection use [`set_compliance`](Self::set_compliance).
        ///
        /// <p>The current compliance against the resiliency policy before applying the configuration change.</p>
        pub fn compliance(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::DisruptionCompliance,
        ) -> Self {
            let mut hash_map = self.compliance.unwrap_or_default();
            hash_map.insert(k, v);
            self.compliance = Some(hash_map);
            self
        }
        /// <p>The current compliance against the resiliency policy before applying the configuration change.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::DisruptionCompliance,
                >,
            >,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// Adds a key-value pair to `recommendation_compliance`.
        ///
        /// To override the contents of this collection use [`set_recommendation_compliance`](Self::set_recommendation_compliance).
        ///
        /// <p>The expected compliance against the resiliency policy after applying the configuration change.</p>
        pub fn recommendation_compliance(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::RecommendationDisruptionCompliance,
        ) -> Self {
            let mut hash_map = self.recommendation_compliance.unwrap_or_default();
            hash_map.insert(k, v);
            self.recommendation_compliance = Some(hash_map);
            self
        }
        /// <p>The expected compliance against the resiliency policy after applying the configuration change.</p>
        pub fn set_recommendation_compliance(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::RecommendationDisruptionCompliance,
                >,
            >,
        ) -> Self {
            self.recommendation_compliance = input;
            self
        }
        /// <p>The type of optimization.</p>
        pub fn optimization_type(
            mut self,
            input: crate::model::ConfigRecommendationOptimizationType,
        ) -> Self {
            self.optimization_type = Some(input);
            self
        }
        /// <p>The type of optimization.</p>
        pub fn set_optimization_type(
            mut self,
            input: std::option::Option<crate::model::ConfigRecommendationOptimizationType>,
        ) -> Self {
            self.optimization_type = input;
            self
        }
        /// <p>The name of the recommendation configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the recommendation configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `suggested_changes`.
        ///
        /// To override the contents of this collection use [`set_suggested_changes`](Self::set_suggested_changes).
        ///
        /// <p>List of the suggested configuration changes.</p>
        pub fn suggested_changes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.suggested_changes.unwrap_or_default();
            v.push(input.into());
            self.suggested_changes = Some(v);
            self
        }
        /// <p>List of the suggested configuration changes.</p>
        pub fn set_suggested_changes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.suggested_changes = input;
            self
        }
        /// <p>The architecture type.</p>
        pub fn ha_architecture(mut self, input: crate::model::HaArchitecture) -> Self {
            self.ha_architecture = Some(input);
            self
        }
        /// <p>The architecture type.</p>
        pub fn set_ha_architecture(
            mut self,
            input: std::option::Option<crate::model::HaArchitecture>,
        ) -> Self {
            self.ha_architecture = input;
            self
        }
        /// <p>The reference identifier for the recommendation configuration.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>The reference identifier for the recommendation configuration.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfigRecommendation`](crate::model::ConfigRecommendation)
        pub fn build(self) -> crate::model::ConfigRecommendation {
            crate::model::ConfigRecommendation {
                cost: self.cost,
                app_component_name: self.app_component_name,
                compliance: self.compliance,
                recommendation_compliance: self.recommendation_compliance,
                optimization_type: self.optimization_type,
                name: self.name,
                description: self.description,
                suggested_changes: self.suggested_changes,
                ha_architecture: self.ha_architecture,
                reference_id: self.reference_id,
            }
        }
    }
}
impl ConfigRecommendation {
    /// Creates a new builder-style object to manufacture [`ConfigRecommendation`](crate::model::ConfigRecommendation)
    pub fn builder() -> crate::model::config_recommendation::Builder {
        crate::model::config_recommendation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HaArchitecture {
    #[allow(missing_docs)] // documentation missing in model
    BackupAndRestore,
    #[allow(missing_docs)] // documentation missing in model
    MultiSite,
    #[allow(missing_docs)] // documentation missing in model
    NoRecoveryPlan,
    #[allow(missing_docs)] // documentation missing in model
    PilotLight,
    #[allow(missing_docs)] // documentation missing in model
    WarmStandby,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HaArchitecture {
    fn from(s: &str) -> Self {
        match s {
            "BackupAndRestore" => HaArchitecture::BackupAndRestore,
            "MultiSite" => HaArchitecture::MultiSite,
            "NoRecoveryPlan" => HaArchitecture::NoRecoveryPlan,
            "PilotLight" => HaArchitecture::PilotLight,
            "WarmStandby" => HaArchitecture::WarmStandby,
            other => HaArchitecture::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HaArchitecture {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HaArchitecture::from(s))
    }
}
impl HaArchitecture {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HaArchitecture::BackupAndRestore => "BackupAndRestore",
            HaArchitecture::MultiSite => "MultiSite",
            HaArchitecture::NoRecoveryPlan => "NoRecoveryPlan",
            HaArchitecture::PilotLight => "PilotLight",
            HaArchitecture::WarmStandby => "WarmStandby",
            HaArchitecture::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BackupAndRestore",
            "MultiSite",
            "NoRecoveryPlan",
            "PilotLight",
            "WarmStandby",
        ]
    }
}
impl AsRef<str> for HaArchitecture {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigRecommendationOptimizationType {
    #[allow(missing_docs)] // documentation missing in model
    BestAzRecovery,
    #[allow(missing_docs)] // documentation missing in model
    BestAttainable,
    #[allow(missing_docs)] // documentation missing in model
    LeastChange,
    #[allow(missing_docs)] // documentation missing in model
    LeastCost,
    #[allow(missing_docs)] // documentation missing in model
    LeastErrors,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigRecommendationOptimizationType {
    fn from(s: &str) -> Self {
        match s {
            "BestAZRecovery" => ConfigRecommendationOptimizationType::BestAzRecovery,
            "BestAttainable" => ConfigRecommendationOptimizationType::BestAttainable,
            "LeastChange" => ConfigRecommendationOptimizationType::LeastChange,
            "LeastCost" => ConfigRecommendationOptimizationType::LeastCost,
            "LeastErrors" => ConfigRecommendationOptimizationType::LeastErrors,
            other => ConfigRecommendationOptimizationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigRecommendationOptimizationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigRecommendationOptimizationType::from(s))
    }
}
impl ConfigRecommendationOptimizationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigRecommendationOptimizationType::BestAzRecovery => "BestAZRecovery",
            ConfigRecommendationOptimizationType::BestAttainable => "BestAttainable",
            ConfigRecommendationOptimizationType::LeastChange => "LeastChange",
            ConfigRecommendationOptimizationType::LeastCost => "LeastCost",
            ConfigRecommendationOptimizationType::LeastErrors => "LeastErrors",
            ConfigRecommendationOptimizationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BestAZRecovery",
            "BestAttainable",
            "LeastChange",
            "LeastCost",
            "LeastErrors",
        ]
    }
}
impl AsRef<str> for ConfigRecommendationOptimizationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a disruption compliance recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecommendationDisruptionCompliance {
    /// <p>The expected compliance status after applying the recommended configuration change.</p>
    pub expected_compliance_status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>The expected RTO after applying the recommended configuration change.</p>
    pub expected_rto_in_secs: i32,
    /// <p>The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.</p>
    pub expected_rto_description: std::option::Option<std::string::String>,
    /// <p>The expected RPO after applying the recommended configuration change.</p>
    pub expected_rpo_in_secs: i32,
    /// <p>The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.</p>
    pub expected_rpo_description: std::option::Option<std::string::String>,
}
impl RecommendationDisruptionCompliance {
    /// <p>The expected compliance status after applying the recommended configuration change.</p>
    pub fn expected_compliance_status(
        &self,
    ) -> std::option::Option<&crate::model::ComplianceStatus> {
        self.expected_compliance_status.as_ref()
    }
    /// <p>The expected RTO after applying the recommended configuration change.</p>
    pub fn expected_rto_in_secs(&self) -> i32 {
        self.expected_rto_in_secs
    }
    /// <p>The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.</p>
    pub fn expected_rto_description(&self) -> std::option::Option<&str> {
        self.expected_rto_description.as_deref()
    }
    /// <p>The expected RPO after applying the recommended configuration change.</p>
    pub fn expected_rpo_in_secs(&self) -> i32 {
        self.expected_rpo_in_secs
    }
    /// <p>The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.</p>
    pub fn expected_rpo_description(&self) -> std::option::Option<&str> {
        self.expected_rpo_description.as_deref()
    }
}
impl std::fmt::Debug for RecommendationDisruptionCompliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecommendationDisruptionCompliance");
        formatter.field(
            "expected_compliance_status",
            &self.expected_compliance_status,
        );
        formatter.field("expected_rto_in_secs", &self.expected_rto_in_secs);
        formatter.field("expected_rto_description", &self.expected_rto_description);
        formatter.field("expected_rpo_in_secs", &self.expected_rpo_in_secs);
        formatter.field("expected_rpo_description", &self.expected_rpo_description);
        formatter.finish()
    }
}
/// See [`RecommendationDisruptionCompliance`](crate::model::RecommendationDisruptionCompliance)
pub mod recommendation_disruption_compliance {
    /// A builder for [`RecommendationDisruptionCompliance`](crate::model::RecommendationDisruptionCompliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expected_compliance_status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) expected_rto_in_secs: std::option::Option<i32>,
        pub(crate) expected_rto_description: std::option::Option<std::string::String>,
        pub(crate) expected_rpo_in_secs: std::option::Option<i32>,
        pub(crate) expected_rpo_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The expected compliance status after applying the recommended configuration change.</p>
        pub fn expected_compliance_status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.expected_compliance_status = Some(input);
            self
        }
        /// <p>The expected compliance status after applying the recommended configuration change.</p>
        pub fn set_expected_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.expected_compliance_status = input;
            self
        }
        /// <p>The expected RTO after applying the recommended configuration change.</p>
        pub fn expected_rto_in_secs(mut self, input: i32) -> Self {
            self.expected_rto_in_secs = Some(input);
            self
        }
        /// <p>The expected RTO after applying the recommended configuration change.</p>
        pub fn set_expected_rto_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.expected_rto_in_secs = input;
            self
        }
        /// <p>The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.</p>
        pub fn expected_rto_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_rto_description = Some(input.into());
            self
        }
        /// <p>The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.</p>
        pub fn set_expected_rto_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_rto_description = input;
            self
        }
        /// <p>The expected RPO after applying the recommended configuration change.</p>
        pub fn expected_rpo_in_secs(mut self, input: i32) -> Self {
            self.expected_rpo_in_secs = Some(input);
            self
        }
        /// <p>The expected RPO after applying the recommended configuration change.</p>
        pub fn set_expected_rpo_in_secs(mut self, input: std::option::Option<i32>) -> Self {
            self.expected_rpo_in_secs = input;
            self
        }
        /// <p>The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.</p>
        pub fn expected_rpo_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_rpo_description = Some(input.into());
            self
        }
        /// <p>The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.</p>
        pub fn set_expected_rpo_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_rpo_description = input;
            self
        }
        /// Consumes the builder and constructs a [`RecommendationDisruptionCompliance`](crate::model::RecommendationDisruptionCompliance)
        pub fn build(self) -> crate::model::RecommendationDisruptionCompliance {
            crate::model::RecommendationDisruptionCompliance {
                expected_compliance_status: self.expected_compliance_status,
                expected_rto_in_secs: self.expected_rto_in_secs.unwrap_or_default(),
                expected_rto_description: self.expected_rto_description,
                expected_rpo_in_secs: self.expected_rpo_in_secs.unwrap_or_default(),
                expected_rpo_description: self.expected_rpo_description,
            }
        }
    }
}
impl RecommendationDisruptionCompliance {
    /// Creates a new builder-style object to manufacture [`RecommendationDisruptionCompliance`](crate::model::RecommendationDisruptionCompliance)
    pub fn builder() -> crate::model::recommendation_disruption_compliance::Builder {
        crate::model::recommendation_disruption_compliance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationComplianceStatus {
    #[allow(missing_docs)] // documentation missing in model
    BreachedCanMeet,
    #[allow(missing_docs)] // documentation missing in model
    BreachedUnattainable,
    #[allow(missing_docs)] // documentation missing in model
    MetCanImprove,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationComplianceStatus {
    fn from(s: &str) -> Self {
        match s {
            "BreachedCanMeet" => RecommendationComplianceStatus::BreachedCanMeet,
            "BreachedUnattainable" => RecommendationComplianceStatus::BreachedUnattainable,
            "MetCanImprove" => RecommendationComplianceStatus::MetCanImprove,
            other => RecommendationComplianceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationComplianceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationComplianceStatus::from(s))
    }
}
impl RecommendationComplianceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationComplianceStatus::BreachedCanMeet => "BreachedCanMeet",
            RecommendationComplianceStatus::BreachedUnattainable => "BreachedUnattainable",
            RecommendationComplianceStatus::MetCanImprove => "MetCanImprove",
            RecommendationComplianceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BreachedCanMeet", "BreachedUnattainable", "MetCanImprove"]
    }
}
impl AsRef<str> for RecommendationComplianceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the compliance of an application component against the resiliency policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppComponentCompliance {
    /// <p>The cost for the application.</p>
    pub cost: std::option::Option<crate::model::Cost>,
    /// <p>The name of the application component.</p>
    pub app_component_name: std::option::Option<std::string::String>,
    /// <p>The compliance of the application component against the resiliency policy.</p>
    pub compliance: std::option::Option<
        std::collections::HashMap<crate::model::DisruptionType, crate::model::DisruptionCompliance>,
    >,
    /// <p>The compliance message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>The current resiliency score for the application.</p>
    pub resiliency_score: std::option::Option<crate::model::ResiliencyScore>,
}
impl AppComponentCompliance {
    /// <p>The cost for the application.</p>
    pub fn cost(&self) -> std::option::Option<&crate::model::Cost> {
        self.cost.as_ref()
    }
    /// <p>The name of the application component.</p>
    pub fn app_component_name(&self) -> std::option::Option<&str> {
        self.app_component_name.as_deref()
    }
    /// <p>The compliance of the application component against the resiliency policy.</p>
    pub fn compliance(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            crate::model::DisruptionType,
            crate::model::DisruptionCompliance,
        >,
    > {
        self.compliance.as_ref()
    }
    /// <p>The compliance message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ComplianceStatus> {
        self.status.as_ref()
    }
    /// <p>The current resiliency score for the application.</p>
    pub fn resiliency_score(&self) -> std::option::Option<&crate::model::ResiliencyScore> {
        self.resiliency_score.as_ref()
    }
}
impl std::fmt::Debug for AppComponentCompliance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppComponentCompliance");
        formatter.field("cost", &self.cost);
        formatter.field("app_component_name", &self.app_component_name);
        formatter.field("compliance", &self.compliance);
        formatter.field("message", &self.message);
        formatter.field("status", &self.status);
        formatter.field("resiliency_score", &self.resiliency_score);
        formatter.finish()
    }
}
/// See [`AppComponentCompliance`](crate::model::AppComponentCompliance)
pub mod app_component_compliance {
    /// A builder for [`AppComponentCompliance`](crate::model::AppComponentCompliance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost: std::option::Option<crate::model::Cost>,
        pub(crate) app_component_name: std::option::Option<std::string::String>,
        pub(crate) compliance: std::option::Option<
            std::collections::HashMap<
                crate::model::DisruptionType,
                crate::model::DisruptionCompliance,
            >,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) resiliency_score: std::option::Option<crate::model::ResiliencyScore>,
    }
    impl Builder {
        /// <p>The cost for the application.</p>
        pub fn cost(mut self, input: crate::model::Cost) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The cost for the application.</p>
        pub fn set_cost(mut self, input: std::option::Option<crate::model::Cost>) -> Self {
            self.cost = input;
            self
        }
        /// <p>The name of the application component.</p>
        pub fn app_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_component_name = Some(input.into());
            self
        }
        /// <p>The name of the application component.</p>
        pub fn set_app_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_component_name = input;
            self
        }
        /// Adds a key-value pair to `compliance`.
        ///
        /// To override the contents of this collection use [`set_compliance`](Self::set_compliance).
        ///
        /// <p>The compliance of the application component against the resiliency policy.</p>
        pub fn compliance(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::DisruptionCompliance,
        ) -> Self {
            let mut hash_map = self.compliance.unwrap_or_default();
            hash_map.insert(k, v);
            self.compliance = Some(hash_map);
            self
        }
        /// <p>The compliance of the application component against the resiliency policy.</p>
        pub fn set_compliance(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::DisruptionCompliance,
                >,
            >,
        ) -> Self {
            self.compliance = input;
            self
        }
        /// <p>The compliance message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The compliance message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn resiliency_score(mut self, input: crate::model::ResiliencyScore) -> Self {
            self.resiliency_score = Some(input);
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn set_resiliency_score(
            mut self,
            input: std::option::Option<crate::model::ResiliencyScore>,
        ) -> Self {
            self.resiliency_score = input;
            self
        }
        /// Consumes the builder and constructs a [`AppComponentCompliance`](crate::model::AppComponentCompliance)
        pub fn build(self) -> crate::model::AppComponentCompliance {
            crate::model::AppComponentCompliance {
                cost: self.cost,
                app_component_name: self.app_component_name,
                compliance: self.compliance,
                message: self.message,
                status: self.status,
                resiliency_score: self.resiliency_score,
            }
        }
    }
}
impl AppComponentCompliance {
    /// Creates a new builder-style object to manufacture [`AppComponentCompliance`](crate::model::AppComponentCompliance)
    pub fn builder() -> crate::model::app_component_compliance::Builder {
        crate::model::app_component_compliance::Builder::default()
    }
}

/// <p>Defines an application assessment summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppAssessmentSummary {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub assessment_status: std::option::Option<crate::model::AssessmentStatus>,
    /// <p>The entity that invoked the assessment.</p>
    pub invoker: std::option::Option<crate::model::AssessmentInvoker>,
    /// <p>The starting time for the action.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time for the action.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The message from the assessment run.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The name of the assessment.</p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub compliance_status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>The cost for the application.</p>
    pub cost: std::option::Option<crate::model::Cost>,
    /// <p>The current resiliency score for the application.</p>
    pub resiliency_score: f64,
}
impl AppAssessmentSummary {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub fn assessment_status(&self) -> std::option::Option<&crate::model::AssessmentStatus> {
        self.assessment_status.as_ref()
    }
    /// <p>The entity that invoked the assessment.</p>
    pub fn invoker(&self) -> std::option::Option<&crate::model::AssessmentInvoker> {
        self.invoker.as_ref()
    }
    /// <p>The starting time for the action.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time for the action.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The message from the assessment run.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The name of the assessment.</p>
    pub fn assessment_name(&self) -> std::option::Option<&str> {
        self.assessment_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub fn compliance_status(&self) -> std::option::Option<&crate::model::ComplianceStatus> {
        self.compliance_status.as_ref()
    }
    /// <p>The cost for the application.</p>
    pub fn cost(&self) -> std::option::Option<&crate::model::Cost> {
        self.cost.as_ref()
    }
    /// <p>The current resiliency score for the application.</p>
    pub fn resiliency_score(&self) -> f64 {
        self.resiliency_score
    }
}
impl std::fmt::Debug for AppAssessmentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppAssessmentSummary");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("assessment_status", &self.assessment_status);
        formatter.field("invoker", &self.invoker);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("message", &self.message);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field("cost", &self.cost);
        formatter.field("resiliency_score", &self.resiliency_score);
        formatter.finish()
    }
}
/// See [`AppAssessmentSummary`](crate::model::AppAssessmentSummary)
pub mod app_assessment_summary {
    /// A builder for [`AppAssessmentSummary`](crate::model::AppAssessmentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) assessment_status: std::option::Option<crate::model::AssessmentStatus>,
        pub(crate) invoker: std::option::Option<crate::model::AssessmentInvoker>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) compliance_status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) cost: std::option::Option<crate::model::Cost>,
        pub(crate) resiliency_score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn assessment_status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.assessment_status = Some(input);
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn set_assessment_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.assessment_status = input;
            self
        }
        /// <p>The entity that invoked the assessment.</p>
        pub fn invoker(mut self, input: crate::model::AssessmentInvoker) -> Self {
            self.invoker = Some(input);
            self
        }
        /// <p>The entity that invoked the assessment.</p>
        pub fn set_invoker(
            mut self,
            input: std::option::Option<crate::model::AssessmentInvoker>,
        ) -> Self {
            self.invoker = input;
            self
        }
        /// <p>The starting time for the action.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The starting time for the action.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time for the action.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time for the action.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The message from the assessment run.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message from the assessment run.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The name of the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p>The name of the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.compliance_status = Some(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// <p>The cost for the application.</p>
        pub fn cost(mut self, input: crate::model::Cost) -> Self {
            self.cost = Some(input);
            self
        }
        /// <p>The cost for the application.</p>
        pub fn set_cost(mut self, input: std::option::Option<crate::model::Cost>) -> Self {
            self.cost = input;
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn resiliency_score(mut self, input: f64) -> Self {
            self.resiliency_score = Some(input);
            self
        }
        /// <p>The current resiliency score for the application.</p>
        pub fn set_resiliency_score(mut self, input: std::option::Option<f64>) -> Self {
            self.resiliency_score = input;
            self
        }
        /// Consumes the builder and constructs a [`AppAssessmentSummary`](crate::model::AppAssessmentSummary)
        pub fn build(self) -> crate::model::AppAssessmentSummary {
            crate::model::AppAssessmentSummary {
                app_arn: self.app_arn,
                app_version: self.app_version,
                assessment_status: self.assessment_status,
                invoker: self.invoker,
                start_time: self.start_time,
                end_time: self.end_time,
                message: self.message,
                assessment_name: self.assessment_name,
                assessment_arn: self.assessment_arn,
                compliance_status: self.compliance_status,
                cost: self.cost,
                resiliency_score: self.resiliency_score.unwrap_or_default(),
            }
        }
    }
}
impl AppAssessmentSummary {
    /// Creates a new builder-style object to manufacture [`AppAssessmentSummary`](crate::model::AppAssessmentSummary)
    pub fn builder() -> crate::model::app_assessment_summary::Builder {
        crate::model::app_assessment_summary::Builder::default()
    }
}

/// <p>Defines a recommendation for a CloudWatch alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmRecommendation {
    /// <p>The identifier of the alarm recommendation.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>The reference identifier of the alarm recommendation.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>The name of the alarm recommendation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the recommendation.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of alarm recommendation.</p>
    pub r#type: std::option::Option<crate::model::AlarmType>,
    /// <p>The application component for the CloudWatch alarm recommendation.</p>
    pub app_component_name: std::option::Option<std::string::String>,
    /// <p>The list of CloudWatch alarm recommendations.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
    /// <p>The prerequisite for the alarm recommendation.</p>
    pub prerequisite: std::option::Option<std::string::String>,
}
impl AlarmRecommendation {
    /// <p>The identifier of the alarm recommendation.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>The reference identifier of the alarm recommendation.</p>
    pub fn reference_id(&self) -> std::option::Option<&str> {
        self.reference_id.as_deref()
    }
    /// <p>The name of the alarm recommendation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the recommendation.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of alarm recommendation.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::AlarmType> {
        self.r#type.as_ref()
    }
    /// <p>The application component for the CloudWatch alarm recommendation.</p>
    pub fn app_component_name(&self) -> std::option::Option<&str> {
        self.app_component_name.as_deref()
    }
    /// <p>The list of CloudWatch alarm recommendations.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::RecommendationItem]> {
        self.items.as_deref()
    }
    /// <p>The prerequisite for the alarm recommendation.</p>
    pub fn prerequisite(&self) -> std::option::Option<&str> {
        self.prerequisite.as_deref()
    }
}
impl std::fmt::Debug for AlarmRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmRecommendation");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("reference_id", &self.reference_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("app_component_name", &self.app_component_name);
        formatter.field("items", &self.items);
        formatter.field("prerequisite", &self.prerequisite);
        formatter.finish()
    }
}
/// See [`AlarmRecommendation`](crate::model::AlarmRecommendation)
pub mod alarm_recommendation {
    /// A builder for [`AlarmRecommendation`](crate::model::AlarmRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::AlarmType>,
        pub(crate) app_component_name: std::option::Option<std::string::String>,
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
        pub(crate) prerequisite: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the alarm recommendation.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the alarm recommendation.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>The reference identifier of the alarm recommendation.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>The reference identifier of the alarm recommendation.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// <p>The name of the alarm recommendation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alarm recommendation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the recommendation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the recommendation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of alarm recommendation.</p>
        pub fn r#type(mut self, input: crate::model::AlarmType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of alarm recommendation.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::AlarmType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The application component for the CloudWatch alarm recommendation.</p>
        pub fn app_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_component_name = Some(input.into());
            self
        }
        /// <p>The application component for the CloudWatch alarm recommendation.</p>
        pub fn set_app_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_component_name = input;
            self
        }
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of CloudWatch alarm recommendations.</p>
        pub fn items(mut self, input: crate::model::RecommendationItem) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input);
            self.items = Some(v);
            self
        }
        /// <p>The list of CloudWatch alarm recommendations.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The prerequisite for the alarm recommendation.</p>
        pub fn prerequisite(mut self, input: impl Into<std::string::String>) -> Self {
            self.prerequisite = Some(input.into());
            self
        }
        /// <p>The prerequisite for the alarm recommendation.</p>
        pub fn set_prerequisite(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prerequisite = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmRecommendation`](crate::model::AlarmRecommendation)
        pub fn build(self) -> crate::model::AlarmRecommendation {
            crate::model::AlarmRecommendation {
                recommendation_id: self.recommendation_id,
                reference_id: self.reference_id,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                app_component_name: self.app_component_name,
                items: self.items,
                prerequisite: self.prerequisite,
            }
        }
    }
}
impl AlarmRecommendation {
    /// Creates a new builder-style object to manufacture [`AlarmRecommendation`](crate::model::AlarmRecommendation)
    pub fn builder() -> crate::model::alarm_recommendation::Builder {
        crate::model::alarm_recommendation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlarmType {
    #[allow(missing_docs)] // documentation missing in model
    Canary,
    #[allow(missing_docs)] // documentation missing in model
    Composite,
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    Logs,
    #[allow(missing_docs)] // documentation missing in model
    Metric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlarmType {
    fn from(s: &str) -> Self {
        match s {
            "Canary" => AlarmType::Canary,
            "Composite" => AlarmType::Composite,
            "Event" => AlarmType::Event,
            "Logs" => AlarmType::Logs,
            "Metric" => AlarmType::Metric,
            other => AlarmType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlarmType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlarmType::from(s))
    }
}
impl AlarmType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlarmType::Canary => "Canary",
            AlarmType::Composite => "Composite",
            AlarmType::Event => "Event",
            AlarmType::Logs => "Logs",
            AlarmType::Metric => "Metric",
            AlarmType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Canary", "Composite", "Event", "Logs", "Metric"]
    }
}
impl AsRef<str> for AlarmType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceImportStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceImportStatusType {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => ResourceImportStatusType::Failed,
            "InProgress" => ResourceImportStatusType::InProgress,
            "Pending" => ResourceImportStatusType::Pending,
            "Success" => ResourceImportStatusType::Success,
            other => ResourceImportStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceImportStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceImportStatusType::from(s))
    }
}
impl ResourceImportStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceImportStatusType::Failed => "Failed",
            ResourceImportStatusType::InProgress => "InProgress",
            ResourceImportStatusType::Pending => "Pending",
            ResourceImportStatusType::Success => "Success",
            ResourceImportStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "Pending", "Success"]
    }
}
impl AsRef<str> for ResourceImportStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
