// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Resilience Hub
///
/// Client for invoking operations on AWS Resilience Hub. Each operation on AWS Resilience Hub is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_resiliencehub::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_resiliencehub::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_resiliencehub::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddDraftAppVersionResourceMappings` operation.
    ///
    /// See [`AddDraftAppVersionResourceMappings`](crate::client::fluent_builders::AddDraftAppVersionResourceMappings) for more information about the
    /// operation and its arguments.
    pub fn add_draft_app_version_resource_mappings(
        &self,
    ) -> fluent_builders::AddDraftAppVersionResourceMappings<C, M, R> {
        fluent_builders::AddDraftAppVersionResourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApp` operation.
    ///
    /// See [`CreateApp`](crate::client::fluent_builders::CreateApp) for more information about the
    /// operation and its arguments.
    pub fn create_app(&self) -> fluent_builders::CreateApp<C, M, R> {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRecommendationTemplate` operation.
    ///
    /// See [`CreateRecommendationTemplate`](crate::client::fluent_builders::CreateRecommendationTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_recommendation_template(
        &self,
    ) -> fluent_builders::CreateRecommendationTemplate<C, M, R> {
        fluent_builders::CreateRecommendationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResiliencyPolicy` operation.
    ///
    /// See [`CreateResiliencyPolicy`](crate::client::fluent_builders::CreateResiliencyPolicy) for more information about the
    /// operation and its arguments.
    pub fn create_resiliency_policy(&self) -> fluent_builders::CreateResiliencyPolicy<C, M, R> {
        fluent_builders::CreateResiliencyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApp` operation.
    ///
    /// See [`DeleteApp`](crate::client::fluent_builders::DeleteApp) for more information about the
    /// operation and its arguments.
    pub fn delete_app(&self) -> fluent_builders::DeleteApp<C, M, R> {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppAssessment` operation.
    ///
    /// See [`DeleteAppAssessment`](crate::client::fluent_builders::DeleteAppAssessment) for more information about the
    /// operation and its arguments.
    pub fn delete_app_assessment(&self) -> fluent_builders::DeleteAppAssessment<C, M, R> {
        fluent_builders::DeleteAppAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRecommendationTemplate` operation.
    ///
    /// See [`DeleteRecommendationTemplate`](crate::client::fluent_builders::DeleteRecommendationTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_recommendation_template(
        &self,
    ) -> fluent_builders::DeleteRecommendationTemplate<C, M, R> {
        fluent_builders::DeleteRecommendationTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResiliencyPolicy` operation.
    ///
    /// See [`DeleteResiliencyPolicy`](crate::client::fluent_builders::DeleteResiliencyPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resiliency_policy(&self) -> fluent_builders::DeleteResiliencyPolicy<C, M, R> {
        fluent_builders::DeleteResiliencyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApp` operation.
    ///
    /// See [`DescribeApp`](crate::client::fluent_builders::DescribeApp) for more information about the
    /// operation and its arguments.
    pub fn describe_app(&self) -> fluent_builders::DescribeApp<C, M, R> {
        fluent_builders::DescribeApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppAssessment` operation.
    ///
    /// See [`DescribeAppAssessment`](crate::client::fluent_builders::DescribeAppAssessment) for more information about the
    /// operation and its arguments.
    pub fn describe_app_assessment(&self) -> fluent_builders::DescribeAppAssessment<C, M, R> {
        fluent_builders::DescribeAppAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppVersionResourcesResolutionStatus` operation.
    ///
    /// See [`DescribeAppVersionResourcesResolutionStatus`](crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_app_version_resources_resolution_status(
        &self,
    ) -> fluent_builders::DescribeAppVersionResourcesResolutionStatus<C, M, R> {
        fluent_builders::DescribeAppVersionResourcesResolutionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppVersionTemplate` operation.
    ///
    /// See [`DescribeAppVersionTemplate`](crate::client::fluent_builders::DescribeAppVersionTemplate) for more information about the
    /// operation and its arguments.
    pub fn describe_app_version_template(
        &self,
    ) -> fluent_builders::DescribeAppVersionTemplate<C, M, R> {
        fluent_builders::DescribeAppVersionTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDraftAppVersionResourcesImportStatus` operation.
    ///
    /// See [`DescribeDraftAppVersionResourcesImportStatus`](crate::client::fluent_builders::DescribeDraftAppVersionResourcesImportStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_draft_app_version_resources_import_status(
        &self,
    ) -> fluent_builders::DescribeDraftAppVersionResourcesImportStatus<C, M, R> {
        fluent_builders::DescribeDraftAppVersionResourcesImportStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResiliencyPolicy` operation.
    ///
    /// See [`DescribeResiliencyPolicy`](crate::client::fluent_builders::DescribeResiliencyPolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_resiliency_policy(&self) -> fluent_builders::DescribeResiliencyPolicy<C, M, R> {
        fluent_builders::DescribeResiliencyPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportResourcesToDraftAppVersion` operation.
    ///
    /// See [`ImportResourcesToDraftAppVersion`](crate::client::fluent_builders::ImportResourcesToDraftAppVersion) for more information about the
    /// operation and its arguments.
    pub fn import_resources_to_draft_app_version(
        &self,
    ) -> fluent_builders::ImportResourcesToDraftAppVersion<C, M, R> {
        fluent_builders::ImportResourcesToDraftAppVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAlarmRecommendations` operation.
    ///
    /// See [`ListAlarmRecommendations`](crate::client::fluent_builders::ListAlarmRecommendations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAlarmRecommendations::into_paginator).
    pub fn list_alarm_recommendations(&self) -> fluent_builders::ListAlarmRecommendations<C, M, R> {
        fluent_builders::ListAlarmRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppAssessments` operation.
    ///
    /// See [`ListAppAssessments`](crate::client::fluent_builders::ListAppAssessments) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAppAssessments::into_paginator).
    pub fn list_app_assessments(&self) -> fluent_builders::ListAppAssessments<C, M, R> {
        fluent_builders::ListAppAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppComponentCompliances` operation.
    ///
    /// See [`ListAppComponentCompliances`](crate::client::fluent_builders::ListAppComponentCompliances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAppComponentCompliances::into_paginator).
    pub fn list_app_component_compliances(
        &self,
    ) -> fluent_builders::ListAppComponentCompliances<C, M, R> {
        fluent_builders::ListAppComponentCompliances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppComponentRecommendations` operation.
    ///
    /// See [`ListAppComponentRecommendations`](crate::client::fluent_builders::ListAppComponentRecommendations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAppComponentRecommendations::into_paginator).
    pub fn list_app_component_recommendations(
        &self,
    ) -> fluent_builders::ListAppComponentRecommendations<C, M, R> {
        fluent_builders::ListAppComponentRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApps` operation.
    ///
    /// See [`ListApps`](crate::client::fluent_builders::ListApps) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListApps::into_paginator).
    pub fn list_apps(&self) -> fluent_builders::ListApps<C, M, R> {
        fluent_builders::ListApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppVersionResourceMappings` operation.
    ///
    /// See [`ListAppVersionResourceMappings`](crate::client::fluent_builders::ListAppVersionResourceMappings) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAppVersionResourceMappings::into_paginator).
    pub fn list_app_version_resource_mappings(
        &self,
    ) -> fluent_builders::ListAppVersionResourceMappings<C, M, R> {
        fluent_builders::ListAppVersionResourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppVersionResources` operation.
    ///
    /// See [`ListAppVersionResources`](crate::client::fluent_builders::ListAppVersionResources) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAppVersionResources::into_paginator).
    pub fn list_app_version_resources(&self) -> fluent_builders::ListAppVersionResources<C, M, R> {
        fluent_builders::ListAppVersionResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppVersions` operation.
    ///
    /// See [`ListAppVersions`](crate::client::fluent_builders::ListAppVersions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAppVersions::into_paginator).
    pub fn list_app_versions(&self) -> fluent_builders::ListAppVersions<C, M, R> {
        fluent_builders::ListAppVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRecommendationTemplates` operation.
    ///
    /// See [`ListRecommendationTemplates`](crate::client::fluent_builders::ListRecommendationTemplates) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListRecommendationTemplates::into_paginator).
    pub fn list_recommendation_templates(
        &self,
    ) -> fluent_builders::ListRecommendationTemplates<C, M, R> {
        fluent_builders::ListRecommendationTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResiliencyPolicies` operation.
    ///
    /// See [`ListResiliencyPolicies`](crate::client::fluent_builders::ListResiliencyPolicies) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListResiliencyPolicies::into_paginator).
    pub fn list_resiliency_policies(&self) -> fluent_builders::ListResiliencyPolicies<C, M, R> {
        fluent_builders::ListResiliencyPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSopRecommendations` operation.
    ///
    /// See [`ListSopRecommendations`](crate::client::fluent_builders::ListSopRecommendations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSopRecommendations::into_paginator).
    pub fn list_sop_recommendations(&self) -> fluent_builders::ListSopRecommendations<C, M, R> {
        fluent_builders::ListSopRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSuggestedResiliencyPolicies` operation.
    ///
    /// See [`ListSuggestedResiliencyPolicies`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSuggestedResiliencyPolicies::into_paginator).
    pub fn list_suggested_resiliency_policies(
        &self,
    ) -> fluent_builders::ListSuggestedResiliencyPolicies<C, M, R> {
        fluent_builders::ListSuggestedResiliencyPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTestRecommendations` operation.
    ///
    /// See [`ListTestRecommendations`](crate::client::fluent_builders::ListTestRecommendations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTestRecommendations::into_paginator).
    pub fn list_test_recommendations(&self) -> fluent_builders::ListTestRecommendations<C, M, R> {
        fluent_builders::ListTestRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUnsupportedAppVersionResources` operation.
    ///
    /// See [`ListUnsupportedAppVersionResources`](crate::client::fluent_builders::ListUnsupportedAppVersionResources) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListUnsupportedAppVersionResources::into_paginator).
    pub fn list_unsupported_app_version_resources(
        &self,
    ) -> fluent_builders::ListUnsupportedAppVersionResources<C, M, R> {
        fluent_builders::ListUnsupportedAppVersionResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PublishAppVersion` operation.
    ///
    /// See [`PublishAppVersion`](crate::client::fluent_builders::PublishAppVersion) for more information about the
    /// operation and its arguments.
    pub fn publish_app_version(&self) -> fluent_builders::PublishAppVersion<C, M, R> {
        fluent_builders::PublishAppVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDraftAppVersionTemplate` operation.
    ///
    /// See [`PutDraftAppVersionTemplate`](crate::client::fluent_builders::PutDraftAppVersionTemplate) for more information about the
    /// operation and its arguments.
    pub fn put_draft_app_version_template(
        &self,
    ) -> fluent_builders::PutDraftAppVersionTemplate<C, M, R> {
        fluent_builders::PutDraftAppVersionTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveDraftAppVersionResourceMappings` operation.
    ///
    /// See [`RemoveDraftAppVersionResourceMappings`](crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings) for more information about the
    /// operation and its arguments.
    pub fn remove_draft_app_version_resource_mappings(
        &self,
    ) -> fluent_builders::RemoveDraftAppVersionResourceMappings<C, M, R> {
        fluent_builders::RemoveDraftAppVersionResourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResolveAppVersionResources` operation.
    ///
    /// See [`ResolveAppVersionResources`](crate::client::fluent_builders::ResolveAppVersionResources) for more information about the
    /// operation and its arguments.
    pub fn resolve_app_version_resources(
        &self,
    ) -> fluent_builders::ResolveAppVersionResources<C, M, R> {
        fluent_builders::ResolveAppVersionResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAppAssessment` operation.
    ///
    /// See [`StartAppAssessment`](crate::client::fluent_builders::StartAppAssessment) for more information about the
    /// operation and its arguments.
    pub fn start_app_assessment(&self) -> fluent_builders::StartAppAssessment<C, M, R> {
        fluent_builders::StartAppAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApp` operation.
    ///
    /// See [`UpdateApp`](crate::client::fluent_builders::UpdateApp) for more information about the
    /// operation and its arguments.
    pub fn update_app(&self) -> fluent_builders::UpdateApp<C, M, R> {
        fluent_builders::UpdateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResiliencyPolicy` operation.
    ///
    /// See [`UpdateResiliencyPolicy`](crate::client::fluent_builders::UpdateResiliencyPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_resiliency_policy(&self) -> fluent_builders::UpdateResiliencyPolicy<C, M, R> {
        fluent_builders::UpdateResiliencyPolicy::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddDraftAppVersionResourceMappings`.
    ///
    /// <p>Adds the resource mapping for the draft application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddDraftAppVersionResourceMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_draft_app_version_resource_mappings_input::Builder,
    }
    impl<C, M, R> AddDraftAppVersionResourceMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddDraftAppVersionResourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddDraftAppVersionResourceMappingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AddDraftAppVersionResourceMappingsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddDraftAppVersionResourceMappingsInputOperationOutputAlias,
                crate::output::AddDraftAppVersionResourceMappingsOutput,
                crate::error::AddDraftAppVersionResourceMappingsError,
                crate::input::AddDraftAppVersionResourceMappingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// Appends an item to `resourceMappings`.
        ///
        /// To override the contents of this collection use [`set_resource_mappings`](Self::set_resource_mappings).
        ///
        /// <p> Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>
        pub fn resource_mappings(mut self, input: crate::model::ResourceMapping) -> Self {
            self.inner = self.inner.resource_mappings(input);
            self
        }
        /// <p> Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>
        pub fn set_resource_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
        ) -> Self {
            self.inner = self.inner.set_resource_mappings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p>Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.</p>
    /// <p>After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_input::Builder,
    }
    impl<C, M, R> CreateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInputOperationOutputAlias,
                crate::output::CreateAppOutput,
                crate::error::CreateAppError,
                crate::input::CreateAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRecommendationTemplate`.
    ///
    /// <p>Creates a new recommendation template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRecommendationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_recommendation_template_input::Builder,
    }
    impl<C, M, R> CreateRecommendationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRecommendationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRecommendationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRecommendationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRecommendationTemplateInputOperationOutputAlias,
                crate::output::CreateRecommendationTemplateOutput,
                crate::error::CreateRecommendationTemplateError,
                crate::input::CreateRecommendationTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `recommendationIds`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recommendation_ids(input.into());
            self
        }
        /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_ids(input);
            self
        }
        /// <p>The format for the recommendation template.</p>
        /// <dl>
        /// <dt>
        /// CfnJson
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>
        /// CfnYaml
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn format(mut self, input: crate::model::TemplateFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The format for the recommendation template.</p>
        /// <dl>
        /// <dt>
        /// CfnJson
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>
        /// CfnYaml
        /// </dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TemplateFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// Appends an item to `recommendationTypes`.
        ///
        /// To override the contents of this collection use [`set_recommendation_types`](Self::set_recommendation_types).
        ///
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>
        /// Alarm
        /// </dt>
        /// <dd>
        /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Sop
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>SopRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Test
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>TestRecommendation</code> template.</p>
        /// </dd>
        /// </dl>
        pub fn recommendation_types(
            mut self,
            input: crate::model::RenderRecommendationType,
        ) -> Self {
            self.inner = self.inner.recommendation_types(input);
            self
        }
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>
        /// Alarm
        /// </dt>
        /// <dd>
        /// <p>The template is an <code>AlarmRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Sop
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>SopRecommendation</code> template.</p>
        /// </dd>
        /// <dt>
        /// Test
        /// </dt>
        /// <dd>
        /// <p>The template is a <code>TestRecommendation</code> template.</p>
        /// </dd>
        /// </dl>
        pub fn set_recommendation_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_types(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResiliencyPolicy`.
    ///
    /// <p>Creates a resiliency policy for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResiliencyPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resiliency_policy_input::Builder,
    }
    impl<C, M, R> CreateResiliencyPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResiliencyPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResiliencyPolicyInputOperationOutputAlias,
                crate::output::CreateResiliencyPolicyOutput,
                crate::error::CreateResiliencyPolicyError,
                crate::input::CreateResiliencyPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The description for the policy.</p>
        pub fn policy_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_description(input.into());
            self
        }
        /// <p>The description for the policy.</p>
        pub fn set_policy_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_description(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn data_location_constraint(
            mut self,
            input: crate::model::DataLocationConstraint,
        ) -> Self {
            self.inner = self.inner.data_location_constraint(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn set_data_location_constraint(
            mut self,
            input: std::option::Option<crate::model::DataLocationConstraint>,
        ) -> Self {
            self.inner = self.inner.set_data_location_constraint(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn tier(mut self, input: crate::model::ResiliencyPolicyTier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicyTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// Adds a key-value pair to `policy`.
        ///
        /// To override the contents of this collection use [`set_policy`](Self::set_policy).
        ///
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn policy(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::FailurePolicy,
        ) -> Self {
            self.inner = self.inner.policy(k, v);
            self
        }
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::FailurePolicy,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p>Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl<C, M, R> DeleteApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInputOperationOutputAlias,
                crate::output::DeleteAppOutput,
                crate::error::DeleteAppError,
                crate::input::DeleteAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.inner = self.inner.force_delete(input);
            self
        }
        /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppAssessment`.
    ///
    /// <p>Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_assessment_input::Builder,
    }
    impl<C, M, R> DeleteAppAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppAssessmentInputOperationOutputAlias,
                crate::output::DeleteAppAssessmentOutput,
                crate::error::DeleteAppAssessmentError,
                crate::input::DeleteAppAssessmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRecommendationTemplate`.
    ///
    /// <p>Deletes a recommendation template. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRecommendationTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_recommendation_template_input::Builder,
    }
    impl<C, M, R> DeleteRecommendationTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRecommendationTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRecommendationTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRecommendationTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRecommendationTemplateInputOperationOutputAlias,
                crate::output::DeleteRecommendationTemplateOutput,
                crate::error::DeleteRecommendationTemplateError,
                crate::input::DeleteRecommendationTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.recommendation_template_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_template_arn(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResiliencyPolicy`.
    ///
    /// <p>Deletes a resiliency policy. This is a destructive action that can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResiliencyPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resiliency_policy_input::Builder,
    }
    impl<C, M, R> DeleteResiliencyPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResiliencyPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResiliencyPolicyInputOperationOutputAlias,
                crate::output::DeleteResiliencyPolicyOutput,
                crate::error::DeleteResiliencyPolicyError,
                crate::input::DeleteResiliencyPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApp`.
    ///
    /// <p>Describes an AWS Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_input::Builder,
    }
    impl<C, M, R> DescribeApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInputOperationOutputAlias,
                crate::output::DescribeAppOutput,
                crate::error::DescribeAppError,
                crate::input::DescribeAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppAssessment`.
    ///
    /// <p>Describes an assessment for an AWS Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_assessment_input::Builder,
    }
    impl<C, M, R> DescribeAppAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppAssessmentInputOperationOutputAlias,
                crate::output::DescribeAppAssessmentOutput,
                crate::error::DescribeAppAssessmentError,
                crate::input::DescribeAppAssessmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppVersionResourcesResolutionStatus`.
    ///
    /// <p>Returns the resolution status for the specified resolution identifier for an application version. If <code>resolutionId</code> is not specified, the current resolution status is returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppVersionResourcesResolutionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_version_resources_resolution_status_input::Builder,
    }
    impl<C, M, R> DescribeAppVersionResourcesResolutionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppVersionResourcesResolutionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppVersionResourcesResolutionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAppVersionResourcesResolutionStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppVersionResourcesResolutionStatusInputOperationOutputAlias,
                crate::output::DescribeAppVersionResourcesResolutionStatusOutput,
                crate::error::DescribeAppVersionResourcesResolutionStatusError,
                crate::input::DescribeAppVersionResourcesResolutionStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution_id(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppVersionTemplate`.
    ///
    /// <p>Describes details about an AWS Resilience Hub </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppVersionTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_version_template_input::Builder,
    }
    impl<C, M, R> DescribeAppVersionTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppVersionTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppVersionTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppVersionTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppVersionTemplateInputOperationOutputAlias,
                crate::output::DescribeAppVersionTemplateOutput,
                crate::error::DescribeAppVersionTemplateError,
                crate::input::DescribeAppVersionTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDraftAppVersionResourcesImportStatus`.
    ///
    /// <p>Describes the status of importing resources to an application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDraftAppVersionResourcesImportStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_draft_app_version_resources_import_status_input::Builder,
    }
    impl<C, M, R> DescribeDraftAppVersionResourcesImportStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDraftAppVersionResourcesImportStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDraftAppVersionResourcesImportStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeDraftAppVersionResourcesImportStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDraftAppVersionResourcesImportStatusInputOperationOutputAlias,
                crate::output::DescribeDraftAppVersionResourcesImportStatusOutput,
                crate::error::DescribeDraftAppVersionResourcesImportStatusError,
                crate::input::DescribeDraftAppVersionResourcesImportStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResiliencyPolicy`.
    ///
    /// <p>Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResiliencyPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resiliency_policy_input::Builder,
    }
    impl<C, M, R> DescribeResiliencyPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResiliencyPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResiliencyPolicyInputOperationOutputAlias,
                crate::output::DescribeResiliencyPolicyOutput,
                crate::error::DescribeResiliencyPolicyError,
                crate::input::DescribeResiliencyPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportResourcesToDraftAppVersion`.
    ///
    /// <p>Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a draft application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportResourcesToDraftAppVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_resources_to_draft_app_version_input::Builder,
    }
    impl<C, M, R> ImportResourcesToDraftAppVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportResourcesToDraftAppVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportResourcesToDraftAppVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportResourcesToDraftAppVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportResourcesToDraftAppVersionInputOperationOutputAlias,
                crate::output::ImportResourcesToDraftAppVersionOutput,
                crate::error::ImportResourcesToDraftAppVersionError,
                crate::input::ImportResourcesToDraftAppVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// Appends an item to `sourceArns`.
        ///
        /// To override the contents of this collection use [`set_source_arns`](Self::set_source_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
        pub fn source_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arns(input.into());
            self
        }
        /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
        pub fn set_source_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlarmRecommendations`.
    ///
    /// <p>Lists the alarm recommendations for a AWS Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAlarmRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_alarm_recommendations_input::Builder,
    }
    impl<C, M, R> ListAlarmRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAlarmRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlarmRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlarmRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAlarmRecommendationsInputOperationOutputAlias,
                crate::output::ListAlarmRecommendationsOutput,
                crate::error::ListAlarmRecommendationsError,
                crate::input::ListAlarmRecommendationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAlarmRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAlarmRecommendationsPaginator<C, M, R> {
            crate::paginator::ListAlarmRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppAssessments`.
    ///
    /// <p>Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results for the response object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppAssessments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_assessments_input::Builder,
    }
    impl<C, M, R> ListAppAssessments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppAssessmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppAssessmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppAssessmentsInputOperationOutputAlias,
                crate::output::ListAppAssessmentsOutput,
                crate::error::ListAppAssessmentsError,
                crate::input::ListAppAssessmentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppAssessmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppAssessmentsPaginator<C, M, R> {
            crate::paginator::ListAppAssessmentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_name(input.into());
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_name(input);
            self
        }
        /// Appends an item to `assessmentStatus`.
        ///
        /// To override the contents of this collection use [`set_assessment_status`](Self::set_assessment_status).
        ///
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn assessment_status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.inner = self.inner.assessment_status(input);
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn set_assessment_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentStatus>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_status(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.inner = self.inner.compliance_status(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.inner = self.inner.set_compliance_status(input);
            self
        }
        /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.</p>
        pub fn invoker(mut self, input: crate::model::AssessmentInvoker) -> Self {
            self.inner = self.inner.invoker(input);
            self
        }
        /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.</p>
        pub fn set_invoker(
            mut self,
            input: std::option::Option<crate::model::AssessmentInvoker>,
        ) -> Self {
            self.inner = self.inner.set_invoker(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppComponentCompliances`.
    ///
    /// <p>Lists the compliances for an AWS Resilience Hub component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppComponentCompliances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_component_compliances_input::Builder,
    }
    impl<C, M, R> ListAppComponentCompliances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppComponentCompliances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppComponentCompliancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppComponentCompliancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppComponentCompliancesInputOperationOutputAlias,
                crate::output::ListAppComponentCompliancesOutput,
                crate::error::ListAppComponentCompliancesError,
                crate::input::ListAppComponentCompliancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppComponentCompliancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAppComponentCompliancesPaginator<C, M, R> {
            crate::paginator::ListAppComponentCompliancesPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppComponentRecommendations`.
    ///
    /// <p>Lists the recommendations for an AWS Resilience Hub component.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppComponentRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_component_recommendations_input::Builder,
    }
    impl<C, M, R> ListAppComponentRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppComponentRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppComponentRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppComponentRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppComponentRecommendationsInputOperationOutputAlias,
                crate::output::ListAppComponentRecommendationsOutput,
                crate::error::ListAppComponentRecommendationsError,
                crate::input::ListAppComponentRecommendationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppComponentRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAppComponentRecommendationsPaginator<C, M, R> {
            crate::paginator::ListAppComponentRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApps`.
    ///
    /// <p>Lists your Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApps<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_apps_input::Builder,
    }
    impl<C, M, R> ListApps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppsInputOperationOutputAlias,
                crate::output::ListAppsOutput,
                crate::error::ListAppsError,
                crate::input::ListAppsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppsPaginator<C, M, R> {
            crate::paginator::ListAppsPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name for the one of the listed applications.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the one of the listed applications.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppVersionResourceMappings`.
    ///
    /// <p>Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppVersionResourceMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_version_resource_mappings_input::Builder,
    }
    impl<C, M, R> ListAppVersionResourceMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppVersionResourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppVersionResourceMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppVersionResourceMappingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppVersionResourceMappingsInputOperationOutputAlias,
                crate::output::ListAppVersionResourceMappingsOutput,
                crate::error::ListAppVersionResourceMappingsError,
                crate::input::ListAppVersionResourceMappingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppVersionResourceMappingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAppVersionResourceMappingsPaginator<C, M, R> {
            crate::paginator::ListAppVersionResourceMappingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppVersionResources`.
    ///
    /// <p>Lists all the resources in an application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppVersionResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_version_resources_input::Builder,
    }
    impl<C, M, R> ListAppVersionResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppVersionResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppVersionResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppVersionResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppVersionResourcesInputOperationOutputAlias,
                crate::output::ListAppVersionResourcesOutput,
                crate::error::ListAppVersionResourcesError,
                crate::input::ListAppVersionResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppVersionResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppVersionResourcesPaginator<C, M, R> {
            crate::paginator::ListAppVersionResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution_id(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolution_id(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppVersions`.
    ///
    /// <p>Lists the different versions for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_versions_input::Builder,
    }
    impl<C, M, R> ListAppVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppVersionsInputOperationOutputAlias,
                crate::output::ListAppVersionsOutput,
                crate::error::ListAppVersionsError,
                crate::input::ListAppVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppVersionsPaginator<C, M, R> {
            crate::paginator::ListAppVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommendationTemplates`.
    ///
    /// <p>Lists the recommendation templates for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecommendationTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_recommendation_templates_input::Builder,
    }
    impl<C, M, R> ListRecommendationTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRecommendationTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendationTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendationTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRecommendationTemplatesInputOperationOutputAlias,
                crate::output::ListRecommendationTemplatesOutput,
                crate::error::ListRecommendationTemplatesError,
                crate::input::ListRecommendationTemplatesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecommendationTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRecommendationTemplatesPaginator<C, M, R> {
            crate::paginator::ListRecommendationTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.inner = self.inner.reverse_order(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reverse_order(input);
            self
        }
        /// Appends an item to `status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::RecommendationTemplateStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationTemplateStatus>>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.recommendation_template_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_recommendation_template_arn(input);
            self
        }
        /// <p>The name for one of the listed recommendation templates.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for one of the listed recommendation templates.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResiliencyPolicies`.
    ///
    /// <p>Lists the resiliency policies for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResiliencyPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resiliency_policies_input::Builder,
    }
    impl<C, M, R> ListResiliencyPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResiliencyPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResiliencyPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResiliencyPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResiliencyPoliciesInputOperationOutputAlias,
                crate::output::ListResiliencyPoliciesOutput,
                crate::error::ListResiliencyPoliciesError,
                crate::input::ListResiliencyPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListResiliencyPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListResiliencyPoliciesPaginator<C, M, R> {
            crate::paginator::ListResiliencyPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSopRecommendations`.
    ///
    /// <p>Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSopRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_sop_recommendations_input::Builder,
    }
    impl<C, M, R> ListSopRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSopRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSopRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSopRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSopRecommendationsInputOperationOutputAlias,
                crate::output::ListSopRecommendationsOutput,
                crate::error::ListSopRecommendationsError,
                crate::input::ListSopRecommendationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSopRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSopRecommendationsPaginator<C, M, R> {
            crate::paginator::ListSopRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSuggestedResiliencyPolicies`.
    ///
    /// <p>Lists the suggested resiliency policies for the Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSuggestedResiliencyPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_suggested_resiliency_policies_input::Builder,
    }
    impl<C, M, R> ListSuggestedResiliencyPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSuggestedResiliencyPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSuggestedResiliencyPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSuggestedResiliencyPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSuggestedResiliencyPoliciesInputOperationOutputAlias,
                crate::output::ListSuggestedResiliencyPoliciesOutput,
                crate::error::ListSuggestedResiliencyPoliciesError,
                crate::input::ListSuggestedResiliencyPoliciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSuggestedResiliencyPoliciesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListSuggestedResiliencyPoliciesPaginator<C, M, R> {
            crate::paginator::ListSuggestedResiliencyPoliciesPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for your resources in your Resilience Hub applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub application.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub application.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTestRecommendations`.
    ///
    /// <p>Lists the test recommendations for the Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTestRecommendations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_test_recommendations_input::Builder,
    }
    impl<C, M, R> ListTestRecommendations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTestRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTestRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTestRecommendationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTestRecommendationsInputOperationOutputAlias,
                crate::output::ListTestRecommendationsOutput,
                crate::error::ListTestRecommendationsError,
                crate::input::ListTestRecommendationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTestRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTestRecommendationsPaginator<C, M, R> {
            crate::paginator::ListTestRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUnsupportedAppVersionResources`.
    ///
    /// <p>Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUnsupportedAppVersionResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_unsupported_app_version_resources_input::Builder,
    }
    impl<C, M, R> ListUnsupportedAppVersionResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUnsupportedAppVersionResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUnsupportedAppVersionResourcesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListUnsupportedAppVersionResourcesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUnsupportedAppVersionResourcesInputOperationOutputAlias,
                crate::output::ListUnsupportedAppVersionResourcesOutput,
                crate::error::ListUnsupportedAppVersionResourcesError,
                crate::input::ListUnsupportedAppVersionResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUnsupportedAppVersionResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListUnsupportedAppVersionResourcesPaginator<C, M, R> {
            crate::paginator::ListUnsupportedAppVersionResourcesPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resolution_id(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resolution_id(input);
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishAppVersion`.
    ///
    /// <p>Publishes a new version of a specific Resilience Hub application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishAppVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::publish_app_version_input::Builder,
    }
    impl<C, M, R> PublishAppVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PublishAppVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishAppVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishAppVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PublishAppVersionInputOperationOutputAlias,
                crate::output::PublishAppVersionOutput,
                crate::error::PublishAppVersionError,
                crate::input::PublishAppVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDraftAppVersionTemplate`.
    ///
    /// <p>Adds or updates the app template for a draft version of a Resilience Hub app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDraftAppVersionTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_draft_app_version_template_input::Builder,
    }
    impl<C, M, R> PutDraftAppVersionTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDraftAppVersionTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDraftAppVersionTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDraftAppVersionTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDraftAppVersionTemplateInputOperationOutputAlias,
                crate::output::PutDraftAppVersionTemplateOutput,
                crate::error::PutDraftAppVersionTemplateError,
                crate::input::PutDraftAppVersionTemplateInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>A JSON string that contains the body of the app template.</p>
        pub fn app_template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_template_body(input.into());
            self
        }
        /// <p>A JSON string that contains the body of the app template.</p>
        pub fn set_app_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_template_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveDraftAppVersionResourceMappings`.
    ///
    /// <p>Removes resource mappings from a draft application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveDraftAppVersionResourceMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_draft_app_version_resource_mappings_input::Builder,
    }
    impl<C, M, R> RemoveDraftAppVersionResourceMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveDraftAppVersionResourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveDraftAppVersionResourceMappingsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RemoveDraftAppVersionResourceMappingsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveDraftAppVersionResourceMappingsInputOperationOutputAlias,
                crate::output::RemoveDraftAppVersionResourceMappingsOutput,
                crate::error::RemoveDraftAppVersionResourceMappingsError,
                crate::input::RemoveDraftAppVersionResourceMappingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// Appends an item to `resourceNames`.
        ///
        /// To override the contents of this collection use [`set_resource_names`](Self::set_resource_names).
        ///
        /// <p>The names of the resources to remove from the resource mappings.</p>
        pub fn resource_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_names(input.into());
            self
        }
        /// <p>The names of the resources to remove from the resource mappings.</p>
        pub fn set_resource_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_names(input);
            self
        }
        /// Appends an item to `logicalStackNames`.
        ///
        /// To override the contents of this collection use [`set_logical_stack_names`](Self::set_logical_stack_names).
        ///
        /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
        pub fn logical_stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.logical_stack_names(input.into());
            self
        }
        /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
        pub fn set_logical_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_logical_stack_names(input);
            self
        }
        /// Appends an item to `appRegistryAppNames`.
        ///
        /// To override the contents of this collection use [`set_app_registry_app_names`](Self::set_app_registry_app_names).
        ///
        /// <p>The names of the registered applications to remove from the resource mappings.</p>
        pub fn app_registry_app_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_registry_app_names(input.into());
            self
        }
        /// <p>The names of the registered applications to remove from the resource mappings.</p>
        pub fn set_app_registry_app_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_app_registry_app_names(input);
            self
        }
        /// Appends an item to `resourceGroupNames`.
        ///
        /// To override the contents of this collection use [`set_resource_group_names`](Self::set_resource_group_names).
        ///
        /// <p>The names of the resource groups to remove from the resource mappings.</p>
        pub fn resource_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_names(input.into());
            self
        }
        /// <p>The names of the resource groups to remove from the resource mappings.</p>
        pub fn set_resource_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResolveAppVersionResources`.
    ///
    /// <p>Resolves the resources for an application version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResolveAppVersionResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resolve_app_version_resources_input::Builder,
    }
    impl<C, M, R> ResolveAppVersionResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResolveAppVersionResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResolveAppVersionResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ResolveAppVersionResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResolveAppVersionResourcesInputOperationOutputAlias,
                crate::output::ResolveAppVersionResourcesOutput,
                crate::error::ResolveAppVersionResourcesError,
                crate::input::ResolveAppVersionResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAppAssessment`.
    ///
    /// <p>Creates a new application assessment for an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartAppAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_app_assessment_input::Builder,
    }
    impl<C, M, R> StartAppAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAppAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAppAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAppAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAppAssessmentInputOperationOutputAlias,
                crate::output::StartAppAssessmentOutput,
                crate::error::StartAppAssessmentError,
                crate::input::StartAppAssessmentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_version(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_version(input);
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_name(input.into());
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_name(input);
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Applies one or more tags to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApp`.
    ///
    /// <p>Updates an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_app_input::Builder,
    }
    impl<C, M, R> UpdateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAppInputOperationOutputAlias,
                crate::output::UpdateAppOutput,
                crate::error::UpdateAppError,
                crate::input::UpdateAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_arn(input);
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
        pub fn clear_resiliency_policy_arn(mut self, input: bool) -> Self {
            self.inner = self.inner.clear_resiliency_policy_arn(input);
            self
        }
        /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
        pub fn set_clear_resiliency_policy_arn(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_clear_resiliency_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResiliencyPolicy`.
    ///
    /// <p>Updates a resiliency policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResiliencyPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resiliency_policy_input::Builder,
    }
    impl<C, M, R> UpdateResiliencyPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResiliencyPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResiliencyPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResiliencyPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResiliencyPolicyInputOperationOutputAlias,
                crate::output::UpdateResiliencyPolicyOutput,
                crate::error::UpdateResiliencyPolicyError,
                crate::input::UpdateResiliencyPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The description for the policy.</p>
        pub fn policy_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_description(input.into());
            self
        }
        /// <p>The description for the policy.</p>
        pub fn set_policy_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_description(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn data_location_constraint(
            mut self,
            input: crate::model::DataLocationConstraint,
        ) -> Self {
            self.inner = self.inner.data_location_constraint(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>
        pub fn set_data_location_constraint(
            mut self,
            input: std::option::Option<crate::model::DataLocationConstraint>,
        ) -> Self {
            self.inner = self.inner.set_data_location_constraint(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn tier(mut self, input: crate::model::ResiliencyPolicyTier) -> Self {
            self.inner = self.inner.tier(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicyTier>,
        ) -> Self {
            self.inner = self.inner.set_tier(input);
            self
        }
        /// Adds a key-value pair to `policy`.
        ///
        /// To override the contents of this collection use [`set_policy`](Self::set_policy).
        ///
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn policy(
            mut self,
            k: crate::model::DisruptionType,
            v: crate::model::FailurePolicy,
        ) -> Self {
            self.inner = self.inner.policy(k, v);
            self
        }
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::FailurePolicy,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
