// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddDraftAppVersionResourceMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_draft_app_version_resource_mappings`](crate::client::Client::add_draft_app_version_resource_mappings).
///
/// See [`crate::client::fluent_builders::AddDraftAppVersionResourceMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddDraftAppVersionResourceMappings {
    _private: (),
}
impl AddDraftAppVersionResourceMappings {
    /// Creates a new builder-style object to manufacture [`AddDraftAppVersionResourceMappingsInput`](crate::input::AddDraftAppVersionResourceMappingsInput)
    pub fn builder() -> crate::input::add_draft_app_version_resource_mappings_input::Builder {
        crate::input::add_draft_app_version_resource_mappings_input::Builder::default()
    }
    /// Creates a new `AddDraftAppVersionResourceMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddDraftAppVersionResourceMappings {
    type Output = std::result::Result<
        crate::output::AddDraftAppVersionResourceMappingsOutput,
        crate::error::AddDraftAppVersionResourceMappingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_draft_app_version_resource_mappings_error(response)
        } else {
            crate::operation_deser::parse_add_draft_app_version_resource_mappings_response(response)
        }
    }
}

/// Operation shape for `CreateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app`](crate::client::Client::create_app).
///
/// See [`crate::client::fluent_builders::CreateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApp {
    _private: (),
}
impl CreateApp {
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
    /// Creates a new `CreateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApp {
    type Output = std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_app_error(response)
        } else {
            crate::operation_deser::parse_create_app_response(response)
        }
    }
}

/// Operation shape for `CreateRecommendationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_recommendation_template`](crate::client::Client::create_recommendation_template).
///
/// See [`crate::client::fluent_builders::CreateRecommendationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRecommendationTemplate {
    _private: (),
}
impl CreateRecommendationTemplate {
    /// Creates a new builder-style object to manufacture [`CreateRecommendationTemplateInput`](crate::input::CreateRecommendationTemplateInput)
    pub fn builder() -> crate::input::create_recommendation_template_input::Builder {
        crate::input::create_recommendation_template_input::Builder::default()
    }
    /// Creates a new `CreateRecommendationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRecommendationTemplate {
    type Output = std::result::Result<
        crate::output::CreateRecommendationTemplateOutput,
        crate::error::CreateRecommendationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_recommendation_template_error(response)
        } else {
            crate::operation_deser::parse_create_recommendation_template_response(response)
        }
    }
}

/// Operation shape for `CreateResiliencyPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resiliency_policy`](crate::client::Client::create_resiliency_policy).
///
/// See [`crate::client::fluent_builders::CreateResiliencyPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResiliencyPolicy {
    _private: (),
}
impl CreateResiliencyPolicy {
    /// Creates a new builder-style object to manufacture [`CreateResiliencyPolicyInput`](crate::input::CreateResiliencyPolicyInput)
    pub fn builder() -> crate::input::create_resiliency_policy_input::Builder {
        crate::input::create_resiliency_policy_input::Builder::default()
    }
    /// Creates a new `CreateResiliencyPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResiliencyPolicy {
    type Output = std::result::Result<
        crate::output::CreateResiliencyPolicyOutput,
        crate::error::CreateResiliencyPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resiliency_policy_error(response)
        } else {
            crate::operation_deser::parse_create_resiliency_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app`](crate::client::Client::delete_app).
///
/// See [`crate::client::fluent_builders::DeleteApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApp {
    _private: (),
}
impl DeleteApp {
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
    /// Creates a new `DeleteApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApp {
    type Output = std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_error(response)
        } else {
            crate::operation_deser::parse_delete_app_response(response)
        }
    }
}

/// Operation shape for `DeleteAppAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_assessment`](crate::client::Client::delete_app_assessment).
///
/// See [`crate::client::fluent_builders::DeleteAppAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppAssessment {
    _private: (),
}
impl DeleteAppAssessment {
    /// Creates a new builder-style object to manufacture [`DeleteAppAssessmentInput`](crate::input::DeleteAppAssessmentInput)
    pub fn builder() -> crate::input::delete_app_assessment_input::Builder {
        crate::input::delete_app_assessment_input::Builder::default()
    }
    /// Creates a new `DeleteAppAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppAssessment {
    type Output = std::result::Result<
        crate::output::DeleteAppAssessmentOutput,
        crate::error::DeleteAppAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_assessment_error(response)
        } else {
            crate::operation_deser::parse_delete_app_assessment_response(response)
        }
    }
}

/// Operation shape for `DeleteRecommendationTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_recommendation_template`](crate::client::Client::delete_recommendation_template).
///
/// See [`crate::client::fluent_builders::DeleteRecommendationTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRecommendationTemplate {
    _private: (),
}
impl DeleteRecommendationTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteRecommendationTemplateInput`](crate::input::DeleteRecommendationTemplateInput)
    pub fn builder() -> crate::input::delete_recommendation_template_input::Builder {
        crate::input::delete_recommendation_template_input::Builder::default()
    }
    /// Creates a new `DeleteRecommendationTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRecommendationTemplate {
    type Output = std::result::Result<
        crate::output::DeleteRecommendationTemplateOutput,
        crate::error::DeleteRecommendationTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_recommendation_template_error(response)
        } else {
            crate::operation_deser::parse_delete_recommendation_template_response(response)
        }
    }
}

/// Operation shape for `DeleteResiliencyPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resiliency_policy`](crate::client::Client::delete_resiliency_policy).
///
/// See [`crate::client::fluent_builders::DeleteResiliencyPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResiliencyPolicy {
    _private: (),
}
impl DeleteResiliencyPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResiliencyPolicyInput`](crate::input::DeleteResiliencyPolicyInput)
    pub fn builder() -> crate::input::delete_resiliency_policy_input::Builder {
        crate::input::delete_resiliency_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResiliencyPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResiliencyPolicy {
    type Output = std::result::Result<
        crate::output::DeleteResiliencyPolicyOutput,
        crate::error::DeleteResiliencyPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resiliency_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resiliency_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app`](crate::client::Client::describe_app).
///
/// See [`crate::client::fluent_builders::DescribeApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApp {
    _private: (),
}
impl DescribeApp {
    /// Creates a new builder-style object to manufacture [`DescribeAppInput`](crate::input::DescribeAppInput)
    pub fn builder() -> crate::input::describe_app_input::Builder {
        crate::input::describe_app_input::Builder::default()
    }
    /// Creates a new `DescribeApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApp {
    type Output =
        std::result::Result<crate::output::DescribeAppOutput, crate::error::DescribeAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_error(response)
        } else {
            crate::operation_deser::parse_describe_app_response(response)
        }
    }
}

/// Operation shape for `DescribeAppAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app_assessment`](crate::client::Client::describe_app_assessment).
///
/// See [`crate::client::fluent_builders::DescribeAppAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAppAssessment {
    _private: (),
}
impl DescribeAppAssessment {
    /// Creates a new builder-style object to manufacture [`DescribeAppAssessmentInput`](crate::input::DescribeAppAssessmentInput)
    pub fn builder() -> crate::input::describe_app_assessment_input::Builder {
        crate::input::describe_app_assessment_input::Builder::default()
    }
    /// Creates a new `DescribeAppAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAppAssessment {
    type Output = std::result::Result<
        crate::output::DescribeAppAssessmentOutput,
        crate::error::DescribeAppAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_assessment_error(response)
        } else {
            crate::operation_deser::parse_describe_app_assessment_response(response)
        }
    }
}

/// Operation shape for `DescribeAppVersionResourcesResolutionStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app_version_resources_resolution_status`](crate::client::Client::describe_app_version_resources_resolution_status).
///
/// See [`crate::client::fluent_builders::DescribeAppVersionResourcesResolutionStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAppVersionResourcesResolutionStatus {
    _private: (),
}
impl DescribeAppVersionResourcesResolutionStatus {
    /// Creates a new builder-style object to manufacture [`DescribeAppVersionResourcesResolutionStatusInput`](crate::input::DescribeAppVersionResourcesResolutionStatusInput)
    pub fn builder() -> crate::input::describe_app_version_resources_resolution_status_input::Builder
    {
        crate::input::describe_app_version_resources_resolution_status_input::Builder::default()
    }
    /// Creates a new `DescribeAppVersionResourcesResolutionStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeAppVersionResourcesResolutionStatus
{
    type Output = std::result::Result<
        crate::output::DescribeAppVersionResourcesResolutionStatusOutput,
        crate::error::DescribeAppVersionResourcesResolutionStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_version_resources_resolution_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_app_version_resources_resolution_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeAppVersionTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app_version_template`](crate::client::Client::describe_app_version_template).
///
/// See [`crate::client::fluent_builders::DescribeAppVersionTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAppVersionTemplate {
    _private: (),
}
impl DescribeAppVersionTemplate {
    /// Creates a new builder-style object to manufacture [`DescribeAppVersionTemplateInput`](crate::input::DescribeAppVersionTemplateInput)
    pub fn builder() -> crate::input::describe_app_version_template_input::Builder {
        crate::input::describe_app_version_template_input::Builder::default()
    }
    /// Creates a new `DescribeAppVersionTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAppVersionTemplate {
    type Output = std::result::Result<
        crate::output::DescribeAppVersionTemplateOutput,
        crate::error::DescribeAppVersionTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_version_template_error(response)
        } else {
            crate::operation_deser::parse_describe_app_version_template_response(response)
        }
    }
}

/// Operation shape for `DescribeDraftAppVersionResourcesImportStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_draft_app_version_resources_import_status`](crate::client::Client::describe_draft_app_version_resources_import_status).
///
/// See [`crate::client::fluent_builders::DescribeDraftAppVersionResourcesImportStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDraftAppVersionResourcesImportStatus {
    _private: (),
}
impl DescribeDraftAppVersionResourcesImportStatus {
    /// Creates a new builder-style object to manufacture [`DescribeDraftAppVersionResourcesImportStatusInput`](crate::input::DescribeDraftAppVersionResourcesImportStatusInput)
    pub fn builder(
    ) -> crate::input::describe_draft_app_version_resources_import_status_input::Builder {
        crate::input::describe_draft_app_version_resources_import_status_input::Builder::default()
    }
    /// Creates a new `DescribeDraftAppVersionResourcesImportStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for DescribeDraftAppVersionResourcesImportStatus
{
    type Output = std::result::Result<
        crate::output::DescribeDraftAppVersionResourcesImportStatusOutput,
        crate::error::DescribeDraftAppVersionResourcesImportStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_draft_app_version_resources_import_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_draft_app_version_resources_import_status_response(response)
        }
    }
}

/// Operation shape for `DescribeResiliencyPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resiliency_policy`](crate::client::Client::describe_resiliency_policy).
///
/// See [`crate::client::fluent_builders::DescribeResiliencyPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResiliencyPolicy {
    _private: (),
}
impl DescribeResiliencyPolicy {
    /// Creates a new builder-style object to manufacture [`DescribeResiliencyPolicyInput`](crate::input::DescribeResiliencyPolicyInput)
    pub fn builder() -> crate::input::describe_resiliency_policy_input::Builder {
        crate::input::describe_resiliency_policy_input::Builder::default()
    }
    /// Creates a new `DescribeResiliencyPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResiliencyPolicy {
    type Output = std::result::Result<
        crate::output::DescribeResiliencyPolicyOutput,
        crate::error::DescribeResiliencyPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resiliency_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_resiliency_policy_response(response)
        }
    }
}

/// Operation shape for `ImportResourcesToDraftAppVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_resources_to_draft_app_version`](crate::client::Client::import_resources_to_draft_app_version).
///
/// See [`crate::client::fluent_builders::ImportResourcesToDraftAppVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportResourcesToDraftAppVersion {
    _private: (),
}
impl ImportResourcesToDraftAppVersion {
    /// Creates a new builder-style object to manufacture [`ImportResourcesToDraftAppVersionInput`](crate::input::ImportResourcesToDraftAppVersionInput)
    pub fn builder() -> crate::input::import_resources_to_draft_app_version_input::Builder {
        crate::input::import_resources_to_draft_app_version_input::Builder::default()
    }
    /// Creates a new `ImportResourcesToDraftAppVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportResourcesToDraftAppVersion {
    type Output = std::result::Result<
        crate::output::ImportResourcesToDraftAppVersionOutput,
        crate::error::ImportResourcesToDraftAppVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_resources_to_draft_app_version_error(response)
        } else {
            crate::operation_deser::parse_import_resources_to_draft_app_version_response(response)
        }
    }
}

/// Operation shape for `ListAlarmRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_alarm_recommendations`](crate::client::Client::list_alarm_recommendations).
///
/// See [`crate::client::fluent_builders::ListAlarmRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAlarmRecommendations {
    _private: (),
}
impl ListAlarmRecommendations {
    /// Creates a new builder-style object to manufacture [`ListAlarmRecommendationsInput`](crate::input::ListAlarmRecommendationsInput)
    pub fn builder() -> crate::input::list_alarm_recommendations_input::Builder {
        crate::input::list_alarm_recommendations_input::Builder::default()
    }
    /// Creates a new `ListAlarmRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAlarmRecommendations {
    type Output = std::result::Result<
        crate::output::ListAlarmRecommendationsOutput,
        crate::error::ListAlarmRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_alarm_recommendations_error(response)
        } else {
            crate::operation_deser::parse_list_alarm_recommendations_response(response)
        }
    }
}

/// Operation shape for `ListAppAssessments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_assessments`](crate::client::Client::list_app_assessments).
///
/// See [`crate::client::fluent_builders::ListAppAssessments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppAssessments {
    _private: (),
}
impl ListAppAssessments {
    /// Creates a new builder-style object to manufacture [`ListAppAssessmentsInput`](crate::input::ListAppAssessmentsInput)
    pub fn builder() -> crate::input::list_app_assessments_input::Builder {
        crate::input::list_app_assessments_input::Builder::default()
    }
    /// Creates a new `ListAppAssessments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppAssessments {
    type Output = std::result::Result<
        crate::output::ListAppAssessmentsOutput,
        crate::error::ListAppAssessmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_assessments_error(response)
        } else {
            crate::operation_deser::parse_list_app_assessments_response(response)
        }
    }
}

/// Operation shape for `ListAppComponentCompliances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_component_compliances`](crate::client::Client::list_app_component_compliances).
///
/// See [`crate::client::fluent_builders::ListAppComponentCompliances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppComponentCompliances {
    _private: (),
}
impl ListAppComponentCompliances {
    /// Creates a new builder-style object to manufacture [`ListAppComponentCompliancesInput`](crate::input::ListAppComponentCompliancesInput)
    pub fn builder() -> crate::input::list_app_component_compliances_input::Builder {
        crate::input::list_app_component_compliances_input::Builder::default()
    }
    /// Creates a new `ListAppComponentCompliances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppComponentCompliances {
    type Output = std::result::Result<
        crate::output::ListAppComponentCompliancesOutput,
        crate::error::ListAppComponentCompliancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_component_compliances_error(response)
        } else {
            crate::operation_deser::parse_list_app_component_compliances_response(response)
        }
    }
}

/// Operation shape for `ListAppComponentRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_component_recommendations`](crate::client::Client::list_app_component_recommendations).
///
/// See [`crate::client::fluent_builders::ListAppComponentRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppComponentRecommendations {
    _private: (),
}
impl ListAppComponentRecommendations {
    /// Creates a new builder-style object to manufacture [`ListAppComponentRecommendationsInput`](crate::input::ListAppComponentRecommendationsInput)
    pub fn builder() -> crate::input::list_app_component_recommendations_input::Builder {
        crate::input::list_app_component_recommendations_input::Builder::default()
    }
    /// Creates a new `ListAppComponentRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppComponentRecommendations {
    type Output = std::result::Result<
        crate::output::ListAppComponentRecommendationsOutput,
        crate::error::ListAppComponentRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_component_recommendations_error(response)
        } else {
            crate::operation_deser::parse_list_app_component_recommendations_response(response)
        }
    }
}

/// Operation shape for `ListApps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_apps`](crate::client::Client::list_apps).
///
/// See [`crate::client::fluent_builders::ListApps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApps {
    _private: (),
}
impl ListApps {
    /// Creates a new builder-style object to manufacture [`ListAppsInput`](crate::input::ListAppsInput)
    pub fn builder() -> crate::input::list_apps_input::Builder {
        crate::input::list_apps_input::Builder::default()
    }
    /// Creates a new `ListApps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApps {
    type Output = std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_apps_error(response)
        } else {
            crate::operation_deser::parse_list_apps_response(response)
        }
    }
}

/// Operation shape for `ListAppVersionResourceMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_version_resource_mappings`](crate::client::Client::list_app_version_resource_mappings).
///
/// See [`crate::client::fluent_builders::ListAppVersionResourceMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppVersionResourceMappings {
    _private: (),
}
impl ListAppVersionResourceMappings {
    /// Creates a new builder-style object to manufacture [`ListAppVersionResourceMappingsInput`](crate::input::ListAppVersionResourceMappingsInput)
    pub fn builder() -> crate::input::list_app_version_resource_mappings_input::Builder {
        crate::input::list_app_version_resource_mappings_input::Builder::default()
    }
    /// Creates a new `ListAppVersionResourceMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppVersionResourceMappings {
    type Output = std::result::Result<
        crate::output::ListAppVersionResourceMappingsOutput,
        crate::error::ListAppVersionResourceMappingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_version_resource_mappings_error(response)
        } else {
            crate::operation_deser::parse_list_app_version_resource_mappings_response(response)
        }
    }
}

/// Operation shape for `ListAppVersionResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_version_resources`](crate::client::Client::list_app_version_resources).
///
/// See [`crate::client::fluent_builders::ListAppVersionResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppVersionResources {
    _private: (),
}
impl ListAppVersionResources {
    /// Creates a new builder-style object to manufacture [`ListAppVersionResourcesInput`](crate::input::ListAppVersionResourcesInput)
    pub fn builder() -> crate::input::list_app_version_resources_input::Builder {
        crate::input::list_app_version_resources_input::Builder::default()
    }
    /// Creates a new `ListAppVersionResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppVersionResources {
    type Output = std::result::Result<
        crate::output::ListAppVersionResourcesOutput,
        crate::error::ListAppVersionResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_version_resources_error(response)
        } else {
            crate::operation_deser::parse_list_app_version_resources_response(response)
        }
    }
}

/// Operation shape for `ListAppVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_versions`](crate::client::Client::list_app_versions).
///
/// See [`crate::client::fluent_builders::ListAppVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppVersions {
    _private: (),
}
impl ListAppVersions {
    /// Creates a new builder-style object to manufacture [`ListAppVersionsInput`](crate::input::ListAppVersionsInput)
    pub fn builder() -> crate::input::list_app_versions_input::Builder {
        crate::input::list_app_versions_input::Builder::default()
    }
    /// Creates a new `ListAppVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppVersions {
    type Output = std::result::Result<
        crate::output::ListAppVersionsOutput,
        crate::error::ListAppVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_versions_error(response)
        } else {
            crate::operation_deser::parse_list_app_versions_response(response)
        }
    }
}

/// Operation shape for `ListRecommendationTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recommendation_templates`](crate::client::Client::list_recommendation_templates).
///
/// See [`crate::client::fluent_builders::ListRecommendationTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecommendationTemplates {
    _private: (),
}
impl ListRecommendationTemplates {
    /// Creates a new builder-style object to manufacture [`ListRecommendationTemplatesInput`](crate::input::ListRecommendationTemplatesInput)
    pub fn builder() -> crate::input::list_recommendation_templates_input::Builder {
        crate::input::list_recommendation_templates_input::Builder::default()
    }
    /// Creates a new `ListRecommendationTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecommendationTemplates {
    type Output = std::result::Result<
        crate::output::ListRecommendationTemplatesOutput,
        crate::error::ListRecommendationTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recommendation_templates_error(response)
        } else {
            crate::operation_deser::parse_list_recommendation_templates_response(response)
        }
    }
}

/// Operation shape for `ListResiliencyPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resiliency_policies`](crate::client::Client::list_resiliency_policies).
///
/// See [`crate::client::fluent_builders::ListResiliencyPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResiliencyPolicies {
    _private: (),
}
impl ListResiliencyPolicies {
    /// Creates a new builder-style object to manufacture [`ListResiliencyPoliciesInput`](crate::input::ListResiliencyPoliciesInput)
    pub fn builder() -> crate::input::list_resiliency_policies_input::Builder {
        crate::input::list_resiliency_policies_input::Builder::default()
    }
    /// Creates a new `ListResiliencyPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResiliencyPolicies {
    type Output = std::result::Result<
        crate::output::ListResiliencyPoliciesOutput,
        crate::error::ListResiliencyPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resiliency_policies_error(response)
        } else {
            crate::operation_deser::parse_list_resiliency_policies_response(response)
        }
    }
}

/// Operation shape for `ListSopRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_sop_recommendations`](crate::client::Client::list_sop_recommendations).
///
/// See [`crate::client::fluent_builders::ListSopRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSopRecommendations {
    _private: (),
}
impl ListSopRecommendations {
    /// Creates a new builder-style object to manufacture [`ListSopRecommendationsInput`](crate::input::ListSopRecommendationsInput)
    pub fn builder() -> crate::input::list_sop_recommendations_input::Builder {
        crate::input::list_sop_recommendations_input::Builder::default()
    }
    /// Creates a new `ListSopRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSopRecommendations {
    type Output = std::result::Result<
        crate::output::ListSopRecommendationsOutput,
        crate::error::ListSopRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_sop_recommendations_error(response)
        } else {
            crate::operation_deser::parse_list_sop_recommendations_response(response)
        }
    }
}

/// Operation shape for `ListSuggestedResiliencyPolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_suggested_resiliency_policies`](crate::client::Client::list_suggested_resiliency_policies).
///
/// See [`crate::client::fluent_builders::ListSuggestedResiliencyPolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSuggestedResiliencyPolicies {
    _private: (),
}
impl ListSuggestedResiliencyPolicies {
    /// Creates a new builder-style object to manufacture [`ListSuggestedResiliencyPoliciesInput`](crate::input::ListSuggestedResiliencyPoliciesInput)
    pub fn builder() -> crate::input::list_suggested_resiliency_policies_input::Builder {
        crate::input::list_suggested_resiliency_policies_input::Builder::default()
    }
    /// Creates a new `ListSuggestedResiliencyPolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSuggestedResiliencyPolicies {
    type Output = std::result::Result<
        crate::output::ListSuggestedResiliencyPoliciesOutput,
        crate::error::ListSuggestedResiliencyPoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_suggested_resiliency_policies_error(response)
        } else {
            crate::operation_deser::parse_list_suggested_resiliency_policies_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTestRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_test_recommendations`](crate::client::Client::list_test_recommendations).
///
/// See [`crate::client::fluent_builders::ListTestRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTestRecommendations {
    _private: (),
}
impl ListTestRecommendations {
    /// Creates a new builder-style object to manufacture [`ListTestRecommendationsInput`](crate::input::ListTestRecommendationsInput)
    pub fn builder() -> crate::input::list_test_recommendations_input::Builder {
        crate::input::list_test_recommendations_input::Builder::default()
    }
    /// Creates a new `ListTestRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTestRecommendations {
    type Output = std::result::Result<
        crate::output::ListTestRecommendationsOutput,
        crate::error::ListTestRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_test_recommendations_error(response)
        } else {
            crate::operation_deser::parse_list_test_recommendations_response(response)
        }
    }
}

/// Operation shape for `ListUnsupportedAppVersionResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_unsupported_app_version_resources`](crate::client::Client::list_unsupported_app_version_resources).
///
/// See [`crate::client::fluent_builders::ListUnsupportedAppVersionResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUnsupportedAppVersionResources {
    _private: (),
}
impl ListUnsupportedAppVersionResources {
    /// Creates a new builder-style object to manufacture [`ListUnsupportedAppVersionResourcesInput`](crate::input::ListUnsupportedAppVersionResourcesInput)
    pub fn builder() -> crate::input::list_unsupported_app_version_resources_input::Builder {
        crate::input::list_unsupported_app_version_resources_input::Builder::default()
    }
    /// Creates a new `ListUnsupportedAppVersionResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUnsupportedAppVersionResources {
    type Output = std::result::Result<
        crate::output::ListUnsupportedAppVersionResourcesOutput,
        crate::error::ListUnsupportedAppVersionResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_unsupported_app_version_resources_error(response)
        } else {
            crate::operation_deser::parse_list_unsupported_app_version_resources_response(response)
        }
    }
}

/// Operation shape for `PublishAppVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_app_version`](crate::client::Client::publish_app_version).
///
/// See [`crate::client::fluent_builders::PublishAppVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishAppVersion {
    _private: (),
}
impl PublishAppVersion {
    /// Creates a new builder-style object to manufacture [`PublishAppVersionInput`](crate::input::PublishAppVersionInput)
    pub fn builder() -> crate::input::publish_app_version_input::Builder {
        crate::input::publish_app_version_input::Builder::default()
    }
    /// Creates a new `PublishAppVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishAppVersion {
    type Output = std::result::Result<
        crate::output::PublishAppVersionOutput,
        crate::error::PublishAppVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_publish_app_version_error(response)
        } else {
            crate::operation_deser::parse_publish_app_version_response(response)
        }
    }
}

/// Operation shape for `PutDraftAppVersionTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_draft_app_version_template`](crate::client::Client::put_draft_app_version_template).
///
/// See [`crate::client::fluent_builders::PutDraftAppVersionTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDraftAppVersionTemplate {
    _private: (),
}
impl PutDraftAppVersionTemplate {
    /// Creates a new builder-style object to manufacture [`PutDraftAppVersionTemplateInput`](crate::input::PutDraftAppVersionTemplateInput)
    pub fn builder() -> crate::input::put_draft_app_version_template_input::Builder {
        crate::input::put_draft_app_version_template_input::Builder::default()
    }
    /// Creates a new `PutDraftAppVersionTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDraftAppVersionTemplate {
    type Output = std::result::Result<
        crate::output::PutDraftAppVersionTemplateOutput,
        crate::error::PutDraftAppVersionTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_draft_app_version_template_error(response)
        } else {
            crate::operation_deser::parse_put_draft_app_version_template_response(response)
        }
    }
}

/// Operation shape for `RemoveDraftAppVersionResourceMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_draft_app_version_resource_mappings`](crate::client::Client::remove_draft_app_version_resource_mappings).
///
/// See [`crate::client::fluent_builders::RemoveDraftAppVersionResourceMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveDraftAppVersionResourceMappings {
    _private: (),
}
impl RemoveDraftAppVersionResourceMappings {
    /// Creates a new builder-style object to manufacture [`RemoveDraftAppVersionResourceMappingsInput`](crate::input::RemoveDraftAppVersionResourceMappingsInput)
    pub fn builder() -> crate::input::remove_draft_app_version_resource_mappings_input::Builder {
        crate::input::remove_draft_app_version_resource_mappings_input::Builder::default()
    }
    /// Creates a new `RemoveDraftAppVersionResourceMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveDraftAppVersionResourceMappings {
    type Output = std::result::Result<
        crate::output::RemoveDraftAppVersionResourceMappingsOutput,
        crate::error::RemoveDraftAppVersionResourceMappingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_draft_app_version_resource_mappings_error(response)
        } else {
            crate::operation_deser::parse_remove_draft_app_version_resource_mappings_response(
                response,
            )
        }
    }
}

/// Operation shape for `ResolveAppVersionResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resolve_app_version_resources`](crate::client::Client::resolve_app_version_resources).
///
/// See [`crate::client::fluent_builders::ResolveAppVersionResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResolveAppVersionResources {
    _private: (),
}
impl ResolveAppVersionResources {
    /// Creates a new builder-style object to manufacture [`ResolveAppVersionResourcesInput`](crate::input::ResolveAppVersionResourcesInput)
    pub fn builder() -> crate::input::resolve_app_version_resources_input::Builder {
        crate::input::resolve_app_version_resources_input::Builder::default()
    }
    /// Creates a new `ResolveAppVersionResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResolveAppVersionResources {
    type Output = std::result::Result<
        crate::output::ResolveAppVersionResourcesOutput,
        crate::error::ResolveAppVersionResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resolve_app_version_resources_error(response)
        } else {
            crate::operation_deser::parse_resolve_app_version_resources_response(response)
        }
    }
}

/// Operation shape for `StartAppAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_app_assessment`](crate::client::Client::start_app_assessment).
///
/// See [`crate::client::fluent_builders::StartAppAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAppAssessment {
    _private: (),
}
impl StartAppAssessment {
    /// Creates a new builder-style object to manufacture [`StartAppAssessmentInput`](crate::input::StartAppAssessmentInput)
    pub fn builder() -> crate::input::start_app_assessment_input::Builder {
        crate::input::start_app_assessment_input::Builder::default()
    }
    /// Creates a new `StartAppAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAppAssessment {
    type Output = std::result::Result<
        crate::output::StartAppAssessmentOutput,
        crate::error::StartAppAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_app_assessment_error(response)
        } else {
            crate::operation_deser::parse_start_app_assessment_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_app`](crate::client::Client::update_app).
///
/// See [`crate::client::fluent_builders::UpdateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApp {
    _private: (),
}
impl UpdateApp {
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
    /// Creates a new `UpdateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApp {
    type Output = std::result::Result<crate::output::UpdateAppOutput, crate::error::UpdateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_app_error(response)
        } else {
            crate::operation_deser::parse_update_app_response(response)
        }
    }
}

/// Operation shape for `UpdateResiliencyPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resiliency_policy`](crate::client::Client::update_resiliency_policy).
///
/// See [`crate::client::fluent_builders::UpdateResiliencyPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResiliencyPolicy {
    _private: (),
}
impl UpdateResiliencyPolicy {
    /// Creates a new builder-style object to manufacture [`UpdateResiliencyPolicyInput`](crate::input::UpdateResiliencyPolicyInput)
    pub fn builder() -> crate::input::update_resiliency_policy_input::Builder {
        crate::input::update_resiliency_policy_input::Builder::default()
    }
    /// Creates a new `UpdateResiliencyPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResiliencyPolicy {
    type Output = std::result::Result<
        crate::output::UpdateResiliencyPolicyOutput,
        crate::error::UpdateResiliencyPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resiliency_policy_error(response)
        } else {
            crate::operation_deser::parse_update_resiliency_policy_response(response)
        }
    }
}
