// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResiliencyPolicyOutput {
    /// <p>The type of resiliency policy that was updated, including the recovery time objective
    /// (RTO) and recovery point objective (RPO) in seconds.</p>
    pub policy: std::option::Option<crate::model::ResiliencyPolicy>,
}
impl UpdateResiliencyPolicyOutput {
    /// <p>The type of resiliency policy that was updated, including the recovery time objective
    /// (RTO) and recovery point objective (RPO) in seconds.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResiliencyPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for UpdateResiliencyPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResiliencyPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`UpdateResiliencyPolicyOutput`](crate::output::UpdateResiliencyPolicyOutput)
pub mod update_resiliency_policy_output {
    /// A builder for [`UpdateResiliencyPolicyOutput`](crate::output::UpdateResiliencyPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResiliencyPolicy>,
    }
    impl Builder {
        /// <p>The type of resiliency policy that was updated, including the recovery time objective
        /// (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn policy(mut self, input: crate::model::ResiliencyPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>The type of resiliency policy that was updated, including the recovery time objective
        /// (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResiliencyPolicyOutput`](crate::output::UpdateResiliencyPolicyOutput)
        pub fn build(self) -> crate::output::UpdateResiliencyPolicyOutput {
            crate::output::UpdateResiliencyPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl UpdateResiliencyPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResiliencyPolicyOutput`](crate::output::UpdateResiliencyPolicyOutput)
    pub fn builder() -> crate::output::update_resiliency_policy_output::Builder {
        crate::output::update_resiliency_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppOutput {
    /// <p>The specified application, returned as an object with details including compliance status,
    /// creation time, description, resiliency score, and more.</p>
    pub app: std::option::Option<crate::model::App>,
}
impl UpdateAppOutput {
    /// <p>The specified application, returned as an object with details including compliance status,
    /// creation time, description, resiliency score, and more.</p>
    pub fn app(&self) -> std::option::Option<&crate::model::App> {
        self.app.as_ref()
    }
}
impl std::fmt::Debug for UpdateAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppOutput");
        formatter.field("app", &self.app);
        formatter.finish()
    }
}
/// See [`UpdateAppOutput`](crate::output::UpdateAppOutput)
pub mod update_app_output {
    /// A builder for [`UpdateAppOutput`](crate::output::UpdateAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app: std::option::Option<crate::model::App>,
    }
    impl Builder {
        /// <p>The specified application, returned as an object with details including compliance status,
        /// creation time, description, resiliency score, and more.</p>
        pub fn app(mut self, input: crate::model::App) -> Self {
            self.app = Some(input);
            self
        }
        /// <p>The specified application, returned as an object with details including compliance status,
        /// creation time, description, resiliency score, and more.</p>
        pub fn set_app(mut self, input: std::option::Option<crate::model::App>) -> Self {
            self.app = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppOutput`](crate::output::UpdateAppOutput)
        pub fn build(self) -> crate::output::UpdateAppOutput {
            crate::output::UpdateAppOutput { app: self.app }
        }
    }
}
impl UpdateAppOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppOutput`](crate::output::UpdateAppOutput)
    pub fn builder() -> crate::output::update_app_output::Builder {
        crate::output::update_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAppAssessmentOutput {
    /// <p>The assessment created.</p>
    pub assessment: std::option::Option<crate::model::AppAssessment>,
}
impl StartAppAssessmentOutput {
    /// <p>The assessment created.</p>
    pub fn assessment(&self) -> std::option::Option<&crate::model::AppAssessment> {
        self.assessment.as_ref()
    }
}
impl std::fmt::Debug for StartAppAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAppAssessmentOutput");
        formatter.field("assessment", &self.assessment);
        formatter.finish()
    }
}
/// See [`StartAppAssessmentOutput`](crate::output::StartAppAssessmentOutput)
pub mod start_app_assessment_output {
    /// A builder for [`StartAppAssessmentOutput`](crate::output::StartAppAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment: std::option::Option<crate::model::AppAssessment>,
    }
    impl Builder {
        /// <p>The assessment created.</p>
        pub fn assessment(mut self, input: crate::model::AppAssessment) -> Self {
            self.assessment = Some(input);
            self
        }
        /// <p>The assessment created.</p>
        pub fn set_assessment(
            mut self,
            input: std::option::Option<crate::model::AppAssessment>,
        ) -> Self {
            self.assessment = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAppAssessmentOutput`](crate::output::StartAppAssessmentOutput)
        pub fn build(self) -> crate::output::StartAppAssessmentOutput {
            crate::output::StartAppAssessmentOutput {
                assessment: self.assessment,
            }
        }
    }
}
impl StartAppAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`StartAppAssessmentOutput`](crate::output::StartAppAssessmentOutput)
    pub fn builder() -> crate::output::start_app_assessment_output::Builder {
        crate::output::start_app_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveAppVersionResourcesOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The identifier for a specific resolution.</p>
    pub resolution_id: std::option::Option<std::string::String>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::ResourceResolutionStatusType>,
}
impl ResolveAppVersionResourcesOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The identifier for a specific resolution.</p>
    pub fn resolution_id(&self) -> std::option::Option<&str> {
        self.resolution_id.as_deref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceResolutionStatusType> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ResolveAppVersionResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveAppVersionResourcesOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("resolution_id", &self.resolution_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ResolveAppVersionResourcesOutput`](crate::output::ResolveAppVersionResourcesOutput)
pub mod resolve_app_version_resources_output {
    /// A builder for [`ResolveAppVersionResourcesOutput`](crate::output::ResolveAppVersionResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) resolution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResourceResolutionStatusType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_id = Some(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_id = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ResourceResolutionStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceResolutionStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveAppVersionResourcesOutput`](crate::output::ResolveAppVersionResourcesOutput)
        pub fn build(self) -> crate::output::ResolveAppVersionResourcesOutput {
            crate::output::ResolveAppVersionResourcesOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                resolution_id: self.resolution_id,
                status: self.status,
            }
        }
    }
}
impl ResolveAppVersionResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ResolveAppVersionResourcesOutput`](crate::output::ResolveAppVersionResourcesOutput)
    pub fn builder() -> crate::output::resolve_app_version_resources_output::Builder {
        crate::output::resolve_app_version_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveDraftAppVersionResourceMappingsOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
}
impl RemoveDraftAppVersionResourceMappingsOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
}
impl std::fmt::Debug for RemoveDraftAppVersionResourceMappingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveDraftAppVersionResourceMappingsOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.finish()
    }
}
/// See [`RemoveDraftAppVersionResourceMappingsOutput`](crate::output::RemoveDraftAppVersionResourceMappingsOutput)
pub mod remove_draft_app_version_resource_mappings_output {
    /// A builder for [`RemoveDraftAppVersionResourceMappingsOutput`](crate::output::RemoveDraftAppVersionResourceMappingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveDraftAppVersionResourceMappingsOutput`](crate::output::RemoveDraftAppVersionResourceMappingsOutput)
        pub fn build(self) -> crate::output::RemoveDraftAppVersionResourceMappingsOutput {
            crate::output::RemoveDraftAppVersionResourceMappingsOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
            }
        }
    }
}
impl RemoveDraftAppVersionResourceMappingsOutput {
    /// Creates a new builder-style object to manufacture [`RemoveDraftAppVersionResourceMappingsOutput`](crate::output::RemoveDraftAppVersionResourceMappingsOutput)
    pub fn builder() -> crate::output::remove_draft_app_version_resource_mappings_output::Builder {
        crate::output::remove_draft_app_version_resource_mappings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDraftAppVersionTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
}
impl PutDraftAppVersionTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
}
impl std::fmt::Debug for PutDraftAppVersionTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDraftAppVersionTemplateOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.finish()
    }
}
/// See [`PutDraftAppVersionTemplateOutput`](crate::output::PutDraftAppVersionTemplateOutput)
pub mod put_draft_app_version_template_output {
    /// A builder for [`PutDraftAppVersionTemplateOutput`](crate::output::PutDraftAppVersionTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDraftAppVersionTemplateOutput`](crate::output::PutDraftAppVersionTemplateOutput)
        pub fn build(self) -> crate::output::PutDraftAppVersionTemplateOutput {
            crate::output::PutDraftAppVersionTemplateOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
            }
        }
    }
}
impl PutDraftAppVersionTemplateOutput {
    /// Creates a new builder-style object to manufacture [`PutDraftAppVersionTemplateOutput`](crate::output::PutDraftAppVersionTemplateOutput)
    pub fn builder() -> crate::output::put_draft_app_version_template_output::Builder {
        crate::output::put_draft_app_version_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishAppVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
}
impl PublishAppVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
}
impl std::fmt::Debug for PublishAppVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishAppVersionOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.finish()
    }
}
/// See [`PublishAppVersionOutput`](crate::output::PublishAppVersionOutput)
pub mod publish_app_version_output {
    /// A builder for [`PublishAppVersionOutput`](crate::output::PublishAppVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishAppVersionOutput`](crate::output::PublishAppVersionOutput)
        pub fn build(self) -> crate::output::PublishAppVersionOutput {
            crate::output::PublishAppVersionOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
            }
        }
    }
}
impl PublishAppVersionOutput {
    /// Creates a new builder-style object to manufacture [`PublishAppVersionOutput`](crate::output::PublishAppVersionOutput)
    pub fn builder() -> crate::output::publish_app_version_output::Builder {
        crate::output::publish_app_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUnsupportedAppVersionResourcesOutput {
    /// <p>The unsupported resources for the application.</p>
    pub unsupported_resources:
        std::option::Option<std::vec::Vec<crate::model::UnsupportedResource>>,
    /// <p>The identifier for a specific resolution.</p>
    pub resolution_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUnsupportedAppVersionResourcesOutput {
    /// <p>The unsupported resources for the application.</p>
    pub fn unsupported_resources(
        &self,
    ) -> std::option::Option<&[crate::model::UnsupportedResource]> {
        self.unsupported_resources.as_deref()
    }
    /// <p>The identifier for a specific resolution.</p>
    pub fn resolution_id(&self) -> std::option::Option<&str> {
        self.resolution_id.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUnsupportedAppVersionResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUnsupportedAppVersionResourcesOutput");
        formatter.field("unsupported_resources", &self.unsupported_resources);
        formatter.field("resolution_id", &self.resolution_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUnsupportedAppVersionResourcesOutput`](crate::output::ListUnsupportedAppVersionResourcesOutput)
pub mod list_unsupported_app_version_resources_output {
    /// A builder for [`ListUnsupportedAppVersionResourcesOutput`](crate::output::ListUnsupportedAppVersionResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) unsupported_resources:
            std::option::Option<std::vec::Vec<crate::model::UnsupportedResource>>,
        pub(crate) resolution_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `unsupported_resources`.
        ///
        /// To override the contents of this collection use [`set_unsupported_resources`](Self::set_unsupported_resources).
        ///
        /// <p>The unsupported resources for the application.</p>
        pub fn unsupported_resources(
            mut self,
            input: impl Into<crate::model::UnsupportedResource>,
        ) -> Self {
            let mut v = self.unsupported_resources.unwrap_or_default();
            v.push(input.into());
            self.unsupported_resources = Some(v);
            self
        }
        /// <p>The unsupported resources for the application.</p>
        pub fn set_unsupported_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UnsupportedResource>>,
        ) -> Self {
            self.unsupported_resources = input;
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_id = Some(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUnsupportedAppVersionResourcesOutput`](crate::output::ListUnsupportedAppVersionResourcesOutput)
        pub fn build(self) -> crate::output::ListUnsupportedAppVersionResourcesOutput {
            crate::output::ListUnsupportedAppVersionResourcesOutput {
                unsupported_resources: self.unsupported_resources,
                resolution_id: self.resolution_id,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUnsupportedAppVersionResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListUnsupportedAppVersionResourcesOutput`](crate::output::ListUnsupportedAppVersionResourcesOutput)
    pub fn builder() -> crate::output::list_unsupported_app_version_resources_output::Builder {
        crate::output::list_unsupported_app_version_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestRecommendationsOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The test recommendations for the Resilience Hub application.</p>
    pub test_recommendations: std::option::Option<std::vec::Vec<crate::model::TestRecommendation>>,
}
impl ListTestRecommendationsOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The test recommendations for the Resilience Hub application.</p>
    pub fn test_recommendations(&self) -> std::option::Option<&[crate::model::TestRecommendation]> {
        self.test_recommendations.as_deref()
    }
}
impl std::fmt::Debug for ListTestRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestRecommendationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("test_recommendations", &self.test_recommendations);
        formatter.finish()
    }
}
/// See [`ListTestRecommendationsOutput`](crate::output::ListTestRecommendationsOutput)
pub mod list_test_recommendations_output {
    /// A builder for [`ListTestRecommendationsOutput`](crate::output::ListTestRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) test_recommendations:
            std::option::Option<std::vec::Vec<crate::model::TestRecommendation>>,
    }
    impl Builder {
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `test_recommendations`.
        ///
        /// To override the contents of this collection use [`set_test_recommendations`](Self::set_test_recommendations).
        ///
        /// <p>The test recommendations for the Resilience Hub application.</p>
        pub fn test_recommendations(
            mut self,
            input: impl Into<crate::model::TestRecommendation>,
        ) -> Self {
            let mut v = self.test_recommendations.unwrap_or_default();
            v.push(input.into());
            self.test_recommendations = Some(v);
            self
        }
        /// <p>The test recommendations for the Resilience Hub application.</p>
        pub fn set_test_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestRecommendation>>,
        ) -> Self {
            self.test_recommendations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestRecommendationsOutput`](crate::output::ListTestRecommendationsOutput)
        pub fn build(self) -> crate::output::ListTestRecommendationsOutput {
            crate::output::ListTestRecommendationsOutput {
                next_token: self.next_token,
                test_recommendations: self.test_recommendations,
            }
        }
    }
}
impl ListTestRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ListTestRecommendationsOutput`](crate::output::ListTestRecommendationsOutput)
    pub fn builder() -> crate::output::list_test_recommendations_output::Builder {
        crate::output::list_test_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuggestedResiliencyPoliciesOutput {
    /// <p>The suggested resiliency policies for the Resilience Hub applications.</p>
    pub resiliency_policies: std::option::Option<std::vec::Vec<crate::model::ResiliencyPolicy>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSuggestedResiliencyPoliciesOutput {
    /// <p>The suggested resiliency policies for the Resilience Hub applications.</p>
    pub fn resiliency_policies(&self) -> std::option::Option<&[crate::model::ResiliencyPolicy]> {
        self.resiliency_policies.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSuggestedResiliencyPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuggestedResiliencyPoliciesOutput");
        formatter.field("resiliency_policies", &self.resiliency_policies);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSuggestedResiliencyPoliciesOutput`](crate::output::ListSuggestedResiliencyPoliciesOutput)
pub mod list_suggested_resiliency_policies_output {
    /// A builder for [`ListSuggestedResiliencyPoliciesOutput`](crate::output::ListSuggestedResiliencyPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resiliency_policies:
            std::option::Option<std::vec::Vec<crate::model::ResiliencyPolicy>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resiliency_policies`.
        ///
        /// To override the contents of this collection use [`set_resiliency_policies`](Self::set_resiliency_policies).
        ///
        /// <p>The suggested resiliency policies for the Resilience Hub applications.</p>
        pub fn resiliency_policies(
            mut self,
            input: impl Into<crate::model::ResiliencyPolicy>,
        ) -> Self {
            let mut v = self.resiliency_policies.unwrap_or_default();
            v.push(input.into());
            self.resiliency_policies = Some(v);
            self
        }
        /// <p>The suggested resiliency policies for the Resilience Hub applications.</p>
        pub fn set_resiliency_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResiliencyPolicy>>,
        ) -> Self {
            self.resiliency_policies = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuggestedResiliencyPoliciesOutput`](crate::output::ListSuggestedResiliencyPoliciesOutput)
        pub fn build(self) -> crate::output::ListSuggestedResiliencyPoliciesOutput {
            crate::output::ListSuggestedResiliencyPoliciesOutput {
                resiliency_policies: self.resiliency_policies,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSuggestedResiliencyPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListSuggestedResiliencyPoliciesOutput`](crate::output::ListSuggestedResiliencyPoliciesOutput)
    pub fn builder() -> crate::output::list_suggested_resiliency_policies_output::Builder {
        crate::output::list_suggested_resiliency_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSopRecommendationsOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The standard operating procedure (SOP) recommendations for the Resilience Hub
    /// applications.</p>
    pub sop_recommendations: std::option::Option<std::vec::Vec<crate::model::SopRecommendation>>,
}
impl ListSopRecommendationsOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The standard operating procedure (SOP) recommendations for the Resilience Hub
    /// applications.</p>
    pub fn sop_recommendations(&self) -> std::option::Option<&[crate::model::SopRecommendation]> {
        self.sop_recommendations.as_deref()
    }
}
impl std::fmt::Debug for ListSopRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSopRecommendationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("sop_recommendations", &self.sop_recommendations);
        formatter.finish()
    }
}
/// See [`ListSopRecommendationsOutput`](crate::output::ListSopRecommendationsOutput)
pub mod list_sop_recommendations_output {
    /// A builder for [`ListSopRecommendationsOutput`](crate::output::ListSopRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) sop_recommendations:
            std::option::Option<std::vec::Vec<crate::model::SopRecommendation>>,
    }
    impl Builder {
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `sop_recommendations`.
        ///
        /// To override the contents of this collection use [`set_sop_recommendations`](Self::set_sop_recommendations).
        ///
        /// <p>The standard operating procedure (SOP) recommendations for the Resilience Hub
        /// applications.</p>
        pub fn sop_recommendations(
            mut self,
            input: impl Into<crate::model::SopRecommendation>,
        ) -> Self {
            let mut v = self.sop_recommendations.unwrap_or_default();
            v.push(input.into());
            self.sop_recommendations = Some(v);
            self
        }
        /// <p>The standard operating procedure (SOP) recommendations for the Resilience Hub
        /// applications.</p>
        pub fn set_sop_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SopRecommendation>>,
        ) -> Self {
            self.sop_recommendations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSopRecommendationsOutput`](crate::output::ListSopRecommendationsOutput)
        pub fn build(self) -> crate::output::ListSopRecommendationsOutput {
            crate::output::ListSopRecommendationsOutput {
                next_token: self.next_token,
                sop_recommendations: self.sop_recommendations,
            }
        }
    }
}
impl ListSopRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ListSopRecommendationsOutput`](crate::output::ListSopRecommendationsOutput)
    pub fn builder() -> crate::output::list_sop_recommendations_output::Builder {
        crate::output::list_sop_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResiliencyPoliciesOutput {
    /// <p>The resiliency policies for the Resilience Hub applications.</p>
    pub resiliency_policies: std::option::Option<std::vec::Vec<crate::model::ResiliencyPolicy>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListResiliencyPoliciesOutput {
    /// <p>The resiliency policies for the Resilience Hub applications.</p>
    pub fn resiliency_policies(&self) -> std::option::Option<&[crate::model::ResiliencyPolicy]> {
        self.resiliency_policies.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListResiliencyPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResiliencyPoliciesOutput");
        formatter.field("resiliency_policies", &self.resiliency_policies);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListResiliencyPoliciesOutput`](crate::output::ListResiliencyPoliciesOutput)
pub mod list_resiliency_policies_output {
    /// A builder for [`ListResiliencyPoliciesOutput`](crate::output::ListResiliencyPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resiliency_policies:
            std::option::Option<std::vec::Vec<crate::model::ResiliencyPolicy>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resiliency_policies`.
        ///
        /// To override the contents of this collection use [`set_resiliency_policies`](Self::set_resiliency_policies).
        ///
        /// <p>The resiliency policies for the Resilience Hub applications.</p>
        pub fn resiliency_policies(
            mut self,
            input: impl Into<crate::model::ResiliencyPolicy>,
        ) -> Self {
            let mut v = self.resiliency_policies.unwrap_or_default();
            v.push(input.into());
            self.resiliency_policies = Some(v);
            self
        }
        /// <p>The resiliency policies for the Resilience Hub applications.</p>
        pub fn set_resiliency_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResiliencyPolicy>>,
        ) -> Self {
            self.resiliency_policies = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResiliencyPoliciesOutput`](crate::output::ListResiliencyPoliciesOutput)
        pub fn build(self) -> crate::output::ListResiliencyPoliciesOutput {
            crate::output::ListResiliencyPoliciesOutput {
                resiliency_policies: self.resiliency_policies,
                next_token: self.next_token,
            }
        }
    }
}
impl ListResiliencyPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListResiliencyPoliciesOutput`](crate::output::ListResiliencyPoliciesOutput)
    pub fn builder() -> crate::output::list_resiliency_policies_output::Builder {
        crate::output::list_resiliency_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendationTemplatesOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The recommendation templates for the Resilience Hub applications.</p>
    pub recommendation_templates:
        std::option::Option<std::vec::Vec<crate::model::RecommendationTemplate>>,
}
impl ListRecommendationTemplatesOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The recommendation templates for the Resilience Hub applications.</p>
    pub fn recommendation_templates(
        &self,
    ) -> std::option::Option<&[crate::model::RecommendationTemplate]> {
        self.recommendation_templates.as_deref()
    }
}
impl std::fmt::Debug for ListRecommendationTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendationTemplatesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("recommendation_templates", &self.recommendation_templates);
        formatter.finish()
    }
}
/// See [`ListRecommendationTemplatesOutput`](crate::output::ListRecommendationTemplatesOutput)
pub mod list_recommendation_templates_output {
    /// A builder for [`ListRecommendationTemplatesOutput`](crate::output::ListRecommendationTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) recommendation_templates:
            std::option::Option<std::vec::Vec<crate::model::RecommendationTemplate>>,
    }
    impl Builder {
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `recommendation_templates`.
        ///
        /// To override the contents of this collection use [`set_recommendation_templates`](Self::set_recommendation_templates).
        ///
        /// <p>The recommendation templates for the Resilience Hub applications.</p>
        pub fn recommendation_templates(
            mut self,
            input: impl Into<crate::model::RecommendationTemplate>,
        ) -> Self {
            let mut v = self.recommendation_templates.unwrap_or_default();
            v.push(input.into());
            self.recommendation_templates = Some(v);
            self
        }
        /// <p>The recommendation templates for the Resilience Hub applications.</p>
        pub fn set_recommendation_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationTemplate>>,
        ) -> Self {
            self.recommendation_templates = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendationTemplatesOutput`](crate::output::ListRecommendationTemplatesOutput)
        pub fn build(self) -> crate::output::ListRecommendationTemplatesOutput {
            crate::output::ListRecommendationTemplatesOutput {
                next_token: self.next_token,
                recommendation_templates: self.recommendation_templates,
            }
        }
    }
}
impl ListRecommendationTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListRecommendationTemplatesOutput`](crate::output::ListRecommendationTemplatesOutput)
    pub fn builder() -> crate::output::list_recommendation_templates_output::Builder {
        crate::output::list_recommendation_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppVersionsOutput {
    /// <p>The version of the application.</p>
    pub app_versions: std::option::Option<std::vec::Vec<crate::model::AppVersionSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppVersionsOutput {
    /// <p>The version of the application.</p>
    pub fn app_versions(&self) -> std::option::Option<&[crate::model::AppVersionSummary]> {
        self.app_versions.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppVersionsOutput");
        formatter.field("app_versions", &self.app_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppVersionsOutput`](crate::output::ListAppVersionsOutput)
pub mod list_app_versions_output {
    /// A builder for [`ListAppVersionsOutput`](crate::output::ListAppVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_versions:
            std::option::Option<std::vec::Vec<crate::model::AppVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `app_versions`.
        ///
        /// To override the contents of this collection use [`set_app_versions`](Self::set_app_versions).
        ///
        /// <p>The version of the application.</p>
        pub fn app_versions(mut self, input: impl Into<crate::model::AppVersionSummary>) -> Self {
            let mut v = self.app_versions.unwrap_or_default();
            v.push(input.into());
            self.app_versions = Some(v);
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppVersionSummary>>,
        ) -> Self {
            self.app_versions = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppVersionsOutput`](crate::output::ListAppVersionsOutput)
        pub fn build(self) -> crate::output::ListAppVersionsOutput {
            crate::output::ListAppVersionsOutput {
                app_versions: self.app_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppVersionsOutput`](crate::output::ListAppVersionsOutput)
    pub fn builder() -> crate::output::list_app_versions_output::Builder {
        crate::output::list_app_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppVersionResourcesOutput {
    /// <p>The physical resources in the application version.</p>
    pub physical_resources: std::option::Option<std::vec::Vec<crate::model::PhysicalResource>>,
    /// <p>The identifier for a specific resolution.</p>
    pub resolution_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppVersionResourcesOutput {
    /// <p>The physical resources in the application version.</p>
    pub fn physical_resources(&self) -> std::option::Option<&[crate::model::PhysicalResource]> {
        self.physical_resources.as_deref()
    }
    /// <p>The identifier for a specific resolution.</p>
    pub fn resolution_id(&self) -> std::option::Option<&str> {
        self.resolution_id.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppVersionResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppVersionResourcesOutput");
        formatter.field("physical_resources", &self.physical_resources);
        formatter.field("resolution_id", &self.resolution_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppVersionResourcesOutput`](crate::output::ListAppVersionResourcesOutput)
pub mod list_app_version_resources_output {
    /// A builder for [`ListAppVersionResourcesOutput`](crate::output::ListAppVersionResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) physical_resources:
            std::option::Option<std::vec::Vec<crate::model::PhysicalResource>>,
        pub(crate) resolution_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `physical_resources`.
        ///
        /// To override the contents of this collection use [`set_physical_resources`](Self::set_physical_resources).
        ///
        /// <p>The physical resources in the application version.</p>
        pub fn physical_resources(
            mut self,
            input: impl Into<crate::model::PhysicalResource>,
        ) -> Self {
            let mut v = self.physical_resources.unwrap_or_default();
            v.push(input.into());
            self.physical_resources = Some(v);
            self
        }
        /// <p>The physical resources in the application version.</p>
        pub fn set_physical_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhysicalResource>>,
        ) -> Self {
            self.physical_resources = input;
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_id = Some(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_id = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppVersionResourcesOutput`](crate::output::ListAppVersionResourcesOutput)
        pub fn build(self) -> crate::output::ListAppVersionResourcesOutput {
            crate::output::ListAppVersionResourcesOutput {
                physical_resources: self.physical_resources,
                resolution_id: self.resolution_id,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppVersionResourcesOutput {
    /// Creates a new builder-style object to manufacture [`ListAppVersionResourcesOutput`](crate::output::ListAppVersionResourcesOutput)
    pub fn builder() -> crate::output::list_app_version_resources_output::Builder {
        crate::output::list_app_version_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppVersionResourceMappingsOutput {
    /// <p>Mappings used to map logical resources from the template to physical resources. You can
    /// use the mapping type <code>CFN_STACK</code> if the application template uses
    /// a logical stack name. Or you can map individual resources by using the mapping type
    /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
    /// application is backed by a CloudFormation stack.</p>
    pub resource_mappings: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppVersionResourceMappingsOutput {
    /// <p>Mappings used to map logical resources from the template to physical resources. You can
    /// use the mapping type <code>CFN_STACK</code> if the application template uses
    /// a logical stack name. Or you can map individual resources by using the mapping type
    /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
    /// application is backed by a CloudFormation stack.</p>
    pub fn resource_mappings(&self) -> std::option::Option<&[crate::model::ResourceMapping]> {
        self.resource_mappings.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppVersionResourceMappingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppVersionResourceMappingsOutput");
        formatter.field("resource_mappings", &self.resource_mappings);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppVersionResourceMappingsOutput`](crate::output::ListAppVersionResourceMappingsOutput)
pub mod list_app_version_resource_mappings_output {
    /// A builder for [`ListAppVersionResourceMappingsOutput`](crate::output::ListAppVersionResourceMappingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_mappings:
            std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `resource_mappings`.
        ///
        /// To override the contents of this collection use [`set_resource_mappings`](Self::set_resource_mappings).
        ///
        /// <p>Mappings used to map logical resources from the template to physical resources. You can
        /// use the mapping type <code>CFN_STACK</code> if the application template uses
        /// a logical stack name. Or you can map individual resources by using the mapping type
        /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
        /// application is backed by a CloudFormation stack.</p>
        pub fn resource_mappings(
            mut self,
            input: impl Into<crate::model::ResourceMapping>,
        ) -> Self {
            let mut v = self.resource_mappings.unwrap_or_default();
            v.push(input.into());
            self.resource_mappings = Some(v);
            self
        }
        /// <p>Mappings used to map logical resources from the template to physical resources. You can
        /// use the mapping type <code>CFN_STACK</code> if the application template uses
        /// a logical stack name. Or you can map individual resources by using the mapping type
        /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
        /// application is backed by a CloudFormation stack.</p>
        pub fn set_resource_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
        ) -> Self {
            self.resource_mappings = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppVersionResourceMappingsOutput`](crate::output::ListAppVersionResourceMappingsOutput)
        pub fn build(self) -> crate::output::ListAppVersionResourceMappingsOutput {
            crate::output::ListAppVersionResourceMappingsOutput {
                resource_mappings: self.resource_mappings,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppVersionResourceMappingsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppVersionResourceMappingsOutput`](crate::output::ListAppVersionResourceMappingsOutput)
    pub fn builder() -> crate::output::list_app_version_resource_mappings_output::Builder {
        crate::output::list_app_version_resource_mappings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppsOutput {
    /// <p>Summaries for the Resilience Hub application.</p>
    pub app_summaries: std::option::Option<std::vec::Vec<crate::model::AppSummary>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppsOutput {
    /// <p>Summaries for the Resilience Hub application.</p>
    pub fn app_summaries(&self) -> std::option::Option<&[crate::model::AppSummary]> {
        self.app_summaries.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppsOutput");
        formatter.field("app_summaries", &self.app_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppsOutput`](crate::output::ListAppsOutput)
pub mod list_apps_output {
    /// A builder for [`ListAppsOutput`](crate::output::ListAppsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_summaries: std::option::Option<std::vec::Vec<crate::model::AppSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `app_summaries`.
        ///
        /// To override the contents of this collection use [`set_app_summaries`](Self::set_app_summaries).
        ///
        /// <p>Summaries for the Resilience Hub application.</p>
        pub fn app_summaries(mut self, input: impl Into<crate::model::AppSummary>) -> Self {
            let mut v = self.app_summaries.unwrap_or_default();
            v.push(input.into());
            self.app_summaries = Some(v);
            self
        }
        /// <p>Summaries for the Resilience Hub application.</p>
        pub fn set_app_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppSummary>>,
        ) -> Self {
            self.app_summaries = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppsOutput`](crate::output::ListAppsOutput)
        pub fn build(self) -> crate::output::ListAppsOutput {
            crate::output::ListAppsOutput {
                app_summaries: self.app_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppsOutput`](crate::output::ListAppsOutput)
    pub fn builder() -> crate::output::list_apps_output::Builder {
        crate::output::list_apps_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppComponentRecommendationsOutput {
    /// <p>The recommendations for an Resilience Hub application component, returned as an object. This
    /// object contains component names, configuration recommendations, and recommendation
    /// statuses.</p>
    pub component_recommendations:
        std::option::Option<std::vec::Vec<crate::model::ComponentRecommendation>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppComponentRecommendationsOutput {
    /// <p>The recommendations for an Resilience Hub application component, returned as an object. This
    /// object contains component names, configuration recommendations, and recommendation
    /// statuses.</p>
    pub fn component_recommendations(
        &self,
    ) -> std::option::Option<&[crate::model::ComponentRecommendation]> {
        self.component_recommendations.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppComponentRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppComponentRecommendationsOutput");
        formatter.field("component_recommendations", &self.component_recommendations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppComponentRecommendationsOutput`](crate::output::ListAppComponentRecommendationsOutput)
pub mod list_app_component_recommendations_output {
    /// A builder for [`ListAppComponentRecommendationsOutput`](crate::output::ListAppComponentRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_recommendations:
            std::option::Option<std::vec::Vec<crate::model::ComponentRecommendation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `component_recommendations`.
        ///
        /// To override the contents of this collection use [`set_component_recommendations`](Self::set_component_recommendations).
        ///
        /// <p>The recommendations for an Resilience Hub application component, returned as an object. This
        /// object contains component names, configuration recommendations, and recommendation
        /// statuses.</p>
        pub fn component_recommendations(
            mut self,
            input: impl Into<crate::model::ComponentRecommendation>,
        ) -> Self {
            let mut v = self.component_recommendations.unwrap_or_default();
            v.push(input.into());
            self.component_recommendations = Some(v);
            self
        }
        /// <p>The recommendations for an Resilience Hub application component, returned as an object. This
        /// object contains component names, configuration recommendations, and recommendation
        /// statuses.</p>
        pub fn set_component_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentRecommendation>>,
        ) -> Self {
            self.component_recommendations = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppComponentRecommendationsOutput`](crate::output::ListAppComponentRecommendationsOutput)
        pub fn build(self) -> crate::output::ListAppComponentRecommendationsOutput {
            crate::output::ListAppComponentRecommendationsOutput {
                component_recommendations: self.component_recommendations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppComponentRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppComponentRecommendationsOutput`](crate::output::ListAppComponentRecommendationsOutput)
    pub fn builder() -> crate::output::list_app_component_recommendations_output::Builder {
        crate::output::list_app_component_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppComponentCompliancesOutput {
    /// <p>The compliances for an AWS Resilience Hub application component, returned as an object. This
    /// object contains component names, compliances, costs, resiliency scores, outage scores, and
    /// more.</p>
    pub component_compliances:
        std::option::Option<std::vec::Vec<crate::model::AppComponentCompliance>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppComponentCompliancesOutput {
    /// <p>The compliances for an AWS Resilience Hub application component, returned as an object. This
    /// object contains component names, compliances, costs, resiliency scores, outage scores, and
    /// more.</p>
    pub fn component_compliances(
        &self,
    ) -> std::option::Option<&[crate::model::AppComponentCompliance]> {
        self.component_compliances.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppComponentCompliancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppComponentCompliancesOutput");
        formatter.field("component_compliances", &self.component_compliances);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppComponentCompliancesOutput`](crate::output::ListAppComponentCompliancesOutput)
pub mod list_app_component_compliances_output {
    /// A builder for [`ListAppComponentCompliancesOutput`](crate::output::ListAppComponentCompliancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_compliances:
            std::option::Option<std::vec::Vec<crate::model::AppComponentCompliance>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `component_compliances`.
        ///
        /// To override the contents of this collection use [`set_component_compliances`](Self::set_component_compliances).
        ///
        /// <p>The compliances for an AWS Resilience Hub application component, returned as an object. This
        /// object contains component names, compliances, costs, resiliency scores, outage scores, and
        /// more.</p>
        pub fn component_compliances(
            mut self,
            input: impl Into<crate::model::AppComponentCompliance>,
        ) -> Self {
            let mut v = self.component_compliances.unwrap_or_default();
            v.push(input.into());
            self.component_compliances = Some(v);
            self
        }
        /// <p>The compliances for an AWS Resilience Hub application component, returned as an object. This
        /// object contains component names, compliances, costs, resiliency scores, outage scores, and
        /// more.</p>
        pub fn set_component_compliances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppComponentCompliance>>,
        ) -> Self {
            self.component_compliances = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppComponentCompliancesOutput`](crate::output::ListAppComponentCompliancesOutput)
        pub fn build(self) -> crate::output::ListAppComponentCompliancesOutput {
            crate::output::ListAppComponentCompliancesOutput {
                component_compliances: self.component_compliances,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppComponentCompliancesOutput {
    /// Creates a new builder-style object to manufacture [`ListAppComponentCompliancesOutput`](crate::output::ListAppComponentCompliancesOutput)
    pub fn builder() -> crate::output::list_app_component_compliances_output::Builder {
        crate::output::list_app_component_compliances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppAssessmentsOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The summaries for the specified assessments, returned as an object. This object includes
    /// application versions, associated Amazon Resource Numbers (ARNs), cost, messages, resiliency
    /// scores, and more.</p>
    pub assessment_summaries:
        std::option::Option<std::vec::Vec<crate::model::AppAssessmentSummary>>,
}
impl ListAppAssessmentsOutput {
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The summaries for the specified assessments, returned as an object. This object includes
    /// application versions, associated Amazon Resource Numbers (ARNs), cost, messages, resiliency
    /// scores, and more.</p>
    pub fn assessment_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::AppAssessmentSummary]> {
        self.assessment_summaries.as_deref()
    }
}
impl std::fmt::Debug for ListAppAssessmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppAssessmentsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("assessment_summaries", &self.assessment_summaries);
        formatter.finish()
    }
}
/// See [`ListAppAssessmentsOutput`](crate::output::ListAppAssessmentsOutput)
pub mod list_app_assessments_output {
    /// A builder for [`ListAppAssessmentsOutput`](crate::output::ListAppAssessmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) assessment_summaries:
            std::option::Option<std::vec::Vec<crate::model::AppAssessmentSummary>>,
    }
    impl Builder {
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `assessment_summaries`.
        ///
        /// To override the contents of this collection use [`set_assessment_summaries`](Self::set_assessment_summaries).
        ///
        /// <p>The summaries for the specified assessments, returned as an object. This object includes
        /// application versions, associated Amazon Resource Numbers (ARNs), cost, messages, resiliency
        /// scores, and more.</p>
        pub fn assessment_summaries(
            mut self,
            input: impl Into<crate::model::AppAssessmentSummary>,
        ) -> Self {
            let mut v = self.assessment_summaries.unwrap_or_default();
            v.push(input.into());
            self.assessment_summaries = Some(v);
            self
        }
        /// <p>The summaries for the specified assessments, returned as an object. This object includes
        /// application versions, associated Amazon Resource Numbers (ARNs), cost, messages, resiliency
        /// scores, and more.</p>
        pub fn set_assessment_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppAssessmentSummary>>,
        ) -> Self {
            self.assessment_summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppAssessmentsOutput`](crate::output::ListAppAssessmentsOutput)
        pub fn build(self) -> crate::output::ListAppAssessmentsOutput {
            crate::output::ListAppAssessmentsOutput {
                next_token: self.next_token,
                assessment_summaries: self.assessment_summaries,
            }
        }
    }
}
impl ListAppAssessmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppAssessmentsOutput`](crate::output::ListAppAssessmentsOutput)
    pub fn builder() -> crate::output::list_app_assessments_output::Builder {
        crate::output::list_app_assessments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlarmRecommendationsOutput {
    /// <p>The alarm recommendations for an AWS Resilience Hub application, returned as an object. This
    /// object includes application component names, descriptions, information about whether a
    /// recommendation has already been implemented or not, prerequisites, and more.</p>
    pub alarm_recommendations:
        std::option::Option<std::vec::Vec<crate::model::AlarmRecommendation>>,
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAlarmRecommendationsOutput {
    /// <p>The alarm recommendations for an AWS Resilience Hub application, returned as an object. This
    /// object includes application component names, descriptions, information about whether a
    /// recommendation has already been implemented or not, prerequisites, and more.</p>
    pub fn alarm_recommendations(
        &self,
    ) -> std::option::Option<&[crate::model::AlarmRecommendation]> {
        self.alarm_recommendations.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAlarmRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlarmRecommendationsOutput");
        formatter.field("alarm_recommendations", &self.alarm_recommendations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAlarmRecommendationsOutput`](crate::output::ListAlarmRecommendationsOutput)
pub mod list_alarm_recommendations_output {
    /// A builder for [`ListAlarmRecommendationsOutput`](crate::output::ListAlarmRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_recommendations:
            std::option::Option<std::vec::Vec<crate::model::AlarmRecommendation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `alarm_recommendations`.
        ///
        /// To override the contents of this collection use [`set_alarm_recommendations`](Self::set_alarm_recommendations).
        ///
        /// <p>The alarm recommendations for an AWS Resilience Hub application, returned as an object. This
        /// object includes application component names, descriptions, information about whether a
        /// recommendation has already been implemented or not, prerequisites, and more.</p>
        pub fn alarm_recommendations(
            mut self,
            input: impl Into<crate::model::AlarmRecommendation>,
        ) -> Self {
            let mut v = self.alarm_recommendations.unwrap_or_default();
            v.push(input.into());
            self.alarm_recommendations = Some(v);
            self
        }
        /// <p>The alarm recommendations for an AWS Resilience Hub application, returned as an object. This
        /// object includes application component names, descriptions, information about whether a
        /// recommendation has already been implemented or not, prerequisites, and more.</p>
        pub fn set_alarm_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlarmRecommendation>>,
        ) -> Self {
            self.alarm_recommendations = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlarmRecommendationsOutput`](crate::output::ListAlarmRecommendationsOutput)
        pub fn build(self) -> crate::output::ListAlarmRecommendationsOutput {
            crate::output::ListAlarmRecommendationsOutput {
                alarm_recommendations: self.alarm_recommendations,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAlarmRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAlarmRecommendationsOutput`](crate::output::ListAlarmRecommendationsOutput)
    pub fn builder() -> crate::output::list_alarm_recommendations_output::Builder {
        crate::output::list_alarm_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportResourcesToDraftAppVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) for the resources that you imported.</p>
    pub source_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::ResourceImportStatusType>,
}
impl ImportResourcesToDraftAppVersionOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) for the resources that you imported.</p>
    pub fn source_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.source_arns.as_deref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceImportStatusType> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ImportResourcesToDraftAppVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportResourcesToDraftAppVersionOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("source_arns", &self.source_arns);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ImportResourcesToDraftAppVersionOutput`](crate::output::ImportResourcesToDraftAppVersionOutput)
pub mod import_resources_to_draft_app_version_output {
    /// A builder for [`ImportResourcesToDraftAppVersionOutput`](crate::output::ImportResourcesToDraftAppVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) source_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::ResourceImportStatusType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Appends an item to `source_arns`.
        ///
        /// To override the contents of this collection use [`set_source_arns`](Self::set_source_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) for the resources that you imported.</p>
        pub fn source_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_arns.unwrap_or_default();
            v.push(input.into());
            self.source_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) for the resources that you imported.</p>
        pub fn set_source_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_arns = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ResourceImportStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceImportStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportResourcesToDraftAppVersionOutput`](crate::output::ImportResourcesToDraftAppVersionOutput)
        pub fn build(self) -> crate::output::ImportResourcesToDraftAppVersionOutput {
            crate::output::ImportResourcesToDraftAppVersionOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                source_arns: self.source_arns,
                status: self.status,
            }
        }
    }
}
impl ImportResourcesToDraftAppVersionOutput {
    /// Creates a new builder-style object to manufacture [`ImportResourcesToDraftAppVersionOutput`](crate::output::ImportResourcesToDraftAppVersionOutput)
    pub fn builder() -> crate::output::import_resources_to_draft_app_version_output::Builder {
        crate::output::import_resources_to_draft_app_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResiliencyPolicyOutput {
    /// <p>Information about the specific resiliency policy, returned as an object. This object
    /// includes creation time, data location constraints, its name, description, tags, the recovery
    /// time objective (RTO) and recovery point objective (RPO) in seconds, and more.</p>
    pub policy: std::option::Option<crate::model::ResiliencyPolicy>,
}
impl DescribeResiliencyPolicyOutput {
    /// <p>Information about the specific resiliency policy, returned as an object. This object
    /// includes creation time, data location constraints, its name, description, tags, the recovery
    /// time objective (RTO) and recovery point objective (RPO) in seconds, and more.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResiliencyPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for DescribeResiliencyPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResiliencyPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`DescribeResiliencyPolicyOutput`](crate::output::DescribeResiliencyPolicyOutput)
pub mod describe_resiliency_policy_output {
    /// A builder for [`DescribeResiliencyPolicyOutput`](crate::output::DescribeResiliencyPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResiliencyPolicy>,
    }
    impl Builder {
        /// <p>Information about the specific resiliency policy, returned as an object. This object
        /// includes creation time, data location constraints, its name, description, tags, the recovery
        /// time objective (RTO) and recovery point objective (RPO) in seconds, and more.</p>
        pub fn policy(mut self, input: crate::model::ResiliencyPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>Information about the specific resiliency policy, returned as an object. This object
        /// includes creation time, data location constraints, its name, description, tags, the recovery
        /// time objective (RTO) and recovery point objective (RPO) in seconds, and more.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResiliencyPolicyOutput`](crate::output::DescribeResiliencyPolicyOutput)
        pub fn build(self) -> crate::output::DescribeResiliencyPolicyOutput {
            crate::output::DescribeResiliencyPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl DescribeResiliencyPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeResiliencyPolicyOutput`](crate::output::DescribeResiliencyPolicyOutput)
    pub fn builder() -> crate::output::describe_resiliency_policy_output::Builder {
        crate::output::describe_resiliency_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDraftAppVersionResourcesImportStatusOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::ResourceImportStatusType>,
    /// <p>The timestamp for when the status last changed.</p>
    pub status_change_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The returned error message for the request.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl DescribeDraftAppVersionResourcesImportStatusOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceImportStatusType> {
        self.status.as_ref()
    }
    /// <p>The timestamp for when the status last changed.</p>
    pub fn status_change_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.status_change_time.as_ref()
    }
    /// <p>The returned error message for the request.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for DescribeDraftAppVersionResourcesImportStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDraftAppVersionResourcesImportStatusOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("status", &self.status);
        formatter.field("status_change_time", &self.status_change_time);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`DescribeDraftAppVersionResourcesImportStatusOutput`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput)
pub mod describe_draft_app_version_resources_import_status_output {
    /// A builder for [`DescribeDraftAppVersionResourcesImportStatusOutput`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResourceImportStatusType>,
        pub(crate) status_change_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ResourceImportStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceImportStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp for when the status last changed.</p>
        pub fn status_change_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.status_change_time = Some(input);
            self
        }
        /// <p>The timestamp for when the status last changed.</p>
        pub fn set_status_change_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.status_change_time = input;
            self
        }
        /// <p>The returned error message for the request.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The returned error message for the request.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDraftAppVersionResourcesImportStatusOutput`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput)
        pub fn build(self) -> crate::output::DescribeDraftAppVersionResourcesImportStatusOutput {
            crate::output::DescribeDraftAppVersionResourcesImportStatusOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                status: self.status,
                status_change_time: self.status_change_time,
                error_message: self.error_message,
            }
        }
    }
}
impl DescribeDraftAppVersionResourcesImportStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDraftAppVersionResourcesImportStatusOutput`](crate::output::DescribeDraftAppVersionResourcesImportStatusOutput)
    pub fn builder(
    ) -> crate::output::describe_draft_app_version_resources_import_status_output::Builder {
        crate::output::describe_draft_app_version_resources_import_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppVersionTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The body of the template.</p>
    pub app_template_body: std::option::Option<std::string::String>,
}
impl DescribeAppVersionTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The body of the template.</p>
    pub fn app_template_body(&self) -> std::option::Option<&str> {
        self.app_template_body.as_deref()
    }
}
impl std::fmt::Debug for DescribeAppVersionTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppVersionTemplateOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("app_template_body", &self.app_template_body);
        formatter.finish()
    }
}
/// See [`DescribeAppVersionTemplateOutput`](crate::output::DescribeAppVersionTemplateOutput)
pub mod describe_app_version_template_output {
    /// A builder for [`DescribeAppVersionTemplateOutput`](crate::output::DescribeAppVersionTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) app_template_body: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The body of the template.</p>
        pub fn app_template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_template_body = Some(input.into());
            self
        }
        /// <p>The body of the template.</p>
        pub fn set_app_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_template_body = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppVersionTemplateOutput`](crate::output::DescribeAppVersionTemplateOutput)
        pub fn build(self) -> crate::output::DescribeAppVersionTemplateOutput {
            crate::output::DescribeAppVersionTemplateOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                app_template_body: self.app_template_body,
            }
        }
    }
}
impl DescribeAppVersionTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppVersionTemplateOutput`](crate::output::DescribeAppVersionTemplateOutput)
    pub fn builder() -> crate::output::describe_app_version_template_output::Builder {
        crate::output::describe_app_version_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppVersionResourcesResolutionStatusOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The identifier for a specific resolution.</p>
    pub resolution_id: std::option::Option<std::string::String>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::ResourceResolutionStatusType>,
    /// <p>The returned error message for the request.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl DescribeAppVersionResourcesResolutionStatusOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The identifier for a specific resolution.</p>
    pub fn resolution_id(&self) -> std::option::Option<&str> {
        self.resolution_id.as_deref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ResourceResolutionStatusType> {
        self.status.as_ref()
    }
    /// <p>The returned error message for the request.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for DescribeAppVersionResourcesResolutionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppVersionResourcesResolutionStatusOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("resolution_id", &self.resolution_id);
        formatter.field("status", &self.status);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`DescribeAppVersionResourcesResolutionStatusOutput`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput)
pub mod describe_app_version_resources_resolution_status_output {
    /// A builder for [`DescribeAppVersionResourcesResolutionStatusOutput`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) resolution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ResourceResolutionStatusType>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_id = Some(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_id = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ResourceResolutionStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ResourceResolutionStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The returned error message for the request.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The returned error message for the request.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppVersionResourcesResolutionStatusOutput`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput)
        pub fn build(self) -> crate::output::DescribeAppVersionResourcesResolutionStatusOutput {
            crate::output::DescribeAppVersionResourcesResolutionStatusOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                resolution_id: self.resolution_id,
                status: self.status,
                error_message: self.error_message,
            }
        }
    }
}
impl DescribeAppVersionResourcesResolutionStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppVersionResourcesResolutionStatusOutput`](crate::output::DescribeAppVersionResourcesResolutionStatusOutput)
    pub fn builder(
    ) -> crate::output::describe_app_version_resources_resolution_status_output::Builder {
        crate::output::describe_app_version_resources_resolution_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppAssessmentOutput {
    /// <p>The assessment for an AWS Resilience Hub application, returned as an object. This object
    /// includes Amazon Resource Names (ARNs), compliance information, compliance status, cost,
    /// messages, resiliency scores, and more.</p>
    pub assessment: std::option::Option<crate::model::AppAssessment>,
}
impl DescribeAppAssessmentOutput {
    /// <p>The assessment for an AWS Resilience Hub application, returned as an object. This object
    /// includes Amazon Resource Names (ARNs), compliance information, compliance status, cost,
    /// messages, resiliency scores, and more.</p>
    pub fn assessment(&self) -> std::option::Option<&crate::model::AppAssessment> {
        self.assessment.as_ref()
    }
}
impl std::fmt::Debug for DescribeAppAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppAssessmentOutput");
        formatter.field("assessment", &self.assessment);
        formatter.finish()
    }
}
/// See [`DescribeAppAssessmentOutput`](crate::output::DescribeAppAssessmentOutput)
pub mod describe_app_assessment_output {
    /// A builder for [`DescribeAppAssessmentOutput`](crate::output::DescribeAppAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment: std::option::Option<crate::model::AppAssessment>,
    }
    impl Builder {
        /// <p>The assessment for an AWS Resilience Hub application, returned as an object. This object
        /// includes Amazon Resource Names (ARNs), compliance information, compliance status, cost,
        /// messages, resiliency scores, and more.</p>
        pub fn assessment(mut self, input: crate::model::AppAssessment) -> Self {
            self.assessment = Some(input);
            self
        }
        /// <p>The assessment for an AWS Resilience Hub application, returned as an object. This object
        /// includes Amazon Resource Names (ARNs), compliance information, compliance status, cost,
        /// messages, resiliency scores, and more.</p>
        pub fn set_assessment(
            mut self,
            input: std::option::Option<crate::model::AppAssessment>,
        ) -> Self {
            self.assessment = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppAssessmentOutput`](crate::output::DescribeAppAssessmentOutput)
        pub fn build(self) -> crate::output::DescribeAppAssessmentOutput {
            crate::output::DescribeAppAssessmentOutput {
                assessment: self.assessment,
            }
        }
    }
}
impl DescribeAppAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppAssessmentOutput`](crate::output::DescribeAppAssessmentOutput)
    pub fn builder() -> crate::output::describe_app_assessment_output::Builder {
        crate::output::describe_app_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppOutput {
    /// <p>The specified application, returned as an object with details including compliance status,
    /// creation time, description, resiliency score, and more.</p>
    pub app: std::option::Option<crate::model::App>,
}
impl DescribeAppOutput {
    /// <p>The specified application, returned as an object with details including compliance status,
    /// creation time, description, resiliency score, and more.</p>
    pub fn app(&self) -> std::option::Option<&crate::model::App> {
        self.app.as_ref()
    }
}
impl std::fmt::Debug for DescribeAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppOutput");
        formatter.field("app", &self.app);
        formatter.finish()
    }
}
/// See [`DescribeAppOutput`](crate::output::DescribeAppOutput)
pub mod describe_app_output {
    /// A builder for [`DescribeAppOutput`](crate::output::DescribeAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app: std::option::Option<crate::model::App>,
    }
    impl Builder {
        /// <p>The specified application, returned as an object with details including compliance status,
        /// creation time, description, resiliency score, and more.</p>
        pub fn app(mut self, input: crate::model::App) -> Self {
            self.app = Some(input);
            self
        }
        /// <p>The specified application, returned as an object with details including compliance status,
        /// creation time, description, resiliency score, and more.</p>
        pub fn set_app(mut self, input: std::option::Option<crate::model::App>) -> Self {
            self.app = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppOutput`](crate::output::DescribeAppOutput)
        pub fn build(self) -> crate::output::DescribeAppOutput {
            crate::output::DescribeAppOutput { app: self.app }
        }
    }
}
impl DescribeAppOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAppOutput`](crate::output::DescribeAppOutput)
    pub fn builder() -> crate::output::describe_app_output::Builder {
        crate::output::describe_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResiliencyPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
}
impl DeleteResiliencyPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteResiliencyPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResiliencyPolicyOutput");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.finish()
    }
}
/// See [`DeleteResiliencyPolicyOutput`](crate::output::DeleteResiliencyPolicyOutput)
pub mod delete_resiliency_policy_output {
    /// A builder for [`DeleteResiliencyPolicyOutput`](crate::output::DeleteResiliencyPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResiliencyPolicyOutput`](crate::output::DeleteResiliencyPolicyOutput)
        pub fn build(self) -> crate::output::DeleteResiliencyPolicyOutput {
            crate::output::DeleteResiliencyPolicyOutput {
                policy_arn: self.policy_arn,
            }
        }
    }
}
impl DeleteResiliencyPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResiliencyPolicyOutput`](crate::output::DeleteResiliencyPolicyOutput)
    pub fn builder() -> crate::output::delete_resiliency_policy_output::Builder {
        crate::output::delete_resiliency_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecommendationTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    pub recommendation_template_arn: std::option::Option<std::string::String>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<crate::model::RecommendationTemplateStatus>,
}
impl DeleteRecommendationTemplateOutput {
    /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    pub fn recommendation_template_arn(&self) -> std::option::Option<&str> {
        self.recommendation_template_arn.as_deref()
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RecommendationTemplateStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DeleteRecommendationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecommendationTemplateOutput");
        formatter.field(
            "recommendation_template_arn",
            &self.recommendation_template_arn,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteRecommendationTemplateOutput`](crate::output::DeleteRecommendationTemplateOutput)
pub mod delete_recommendation_template_output {
    /// A builder for [`DeleteRecommendationTemplateOutput`](crate::output::DeleteRecommendationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_template_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RecommendationTemplateStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::RecommendationTemplateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecommendationTemplateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecommendationTemplateOutput`](crate::output::DeleteRecommendationTemplateOutput)
        pub fn build(self) -> crate::output::DeleteRecommendationTemplateOutput {
            crate::output::DeleteRecommendationTemplateOutput {
                recommendation_template_arn: self.recommendation_template_arn,
                status: self.status,
            }
        }
    }
}
impl DeleteRecommendationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRecommendationTemplateOutput`](crate::output::DeleteRecommendationTemplateOutput)
    pub fn builder() -> crate::output::delete_recommendation_template_output::Builder {
        crate::output::delete_recommendation_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppAssessmentOutput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub assessment_status: std::option::Option<crate::model::AssessmentStatus>,
}
impl DeleteAppAssessmentOutput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub fn assessment_status(&self) -> std::option::Option<&crate::model::AssessmentStatus> {
        self.assessment_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteAppAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppAssessmentOutput");
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("assessment_status", &self.assessment_status);
        formatter.finish()
    }
}
/// See [`DeleteAppAssessmentOutput`](crate::output::DeleteAppAssessmentOutput)
pub mod delete_app_assessment_output {
    /// A builder for [`DeleteAppAssessmentOutput`](crate::output::DeleteAppAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_status: std::option::Option<crate::model::AssessmentStatus>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn assessment_status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.assessment_status = Some(input);
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn set_assessment_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.assessment_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppAssessmentOutput`](crate::output::DeleteAppAssessmentOutput)
        pub fn build(self) -> crate::output::DeleteAppAssessmentOutput {
            crate::output::DeleteAppAssessmentOutput {
                assessment_arn: self.assessment_arn,
                assessment_status: self.assessment_status,
            }
        }
    }
}
impl DeleteAppAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppAssessmentOutput`](crate::output::DeleteAppAssessmentOutput)
    pub fn builder() -> crate::output::delete_app_assessment_output::Builder {
        crate::output::delete_app_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
}
impl DeleteAppOutput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.finish()
    }
}
/// See [`DeleteAppOutput`](crate::output::DeleteAppOutput)
pub mod delete_app_output {
    /// A builder for [`DeleteAppOutput`](crate::output::DeleteAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppOutput`](crate::output::DeleteAppOutput)
        pub fn build(self) -> crate::output::DeleteAppOutput {
            crate::output::DeleteAppOutput {
                app_arn: self.app_arn,
            }
        }
    }
}
impl DeleteAppOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAppOutput`](crate::output::DeleteAppOutput)
    pub fn builder() -> crate::output::delete_app_output::Builder {
        crate::output::delete_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResiliencyPolicyOutput {
    /// <p>The type of resiliency policy that was created, including the recovery time objective
    /// (RTO) and recovery point objective (RPO) in seconds.</p>
    pub policy: std::option::Option<crate::model::ResiliencyPolicy>,
}
impl CreateResiliencyPolicyOutput {
    /// <p>The type of resiliency policy that was created, including the recovery time objective
    /// (RTO) and recovery point objective (RPO) in seconds.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResiliencyPolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for CreateResiliencyPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResiliencyPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`CreateResiliencyPolicyOutput`](crate::output::CreateResiliencyPolicyOutput)
pub mod create_resiliency_policy_output {
    /// A builder for [`CreateResiliencyPolicyOutput`](crate::output::CreateResiliencyPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResiliencyPolicy>,
    }
    impl Builder {
        /// <p>The type of resiliency policy that was created, including the recovery time objective
        /// (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn policy(mut self, input: crate::model::ResiliencyPolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>The type of resiliency policy that was created, including the recovery time objective
        /// (RTO) and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResiliencyPolicyOutput`](crate::output::CreateResiliencyPolicyOutput)
        pub fn build(self) -> crate::output::CreateResiliencyPolicyOutput {
            crate::output::CreateResiliencyPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl CreateResiliencyPolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateResiliencyPolicyOutput`](crate::output::CreateResiliencyPolicyOutput)
    pub fn builder() -> crate::output::create_resiliency_policy_output::Builder {
        crate::output::create_resiliency_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecommendationTemplateOutput {
    /// <p>The newly created recommendation template, returned as an object. This object includes the
    /// template's name, format, status, tags, Amazon S3 bucket location, and more.</p>
    pub recommendation_template: std::option::Option<crate::model::RecommendationTemplate>,
}
impl CreateRecommendationTemplateOutput {
    /// <p>The newly created recommendation template, returned as an object. This object includes the
    /// template's name, format, status, tags, Amazon S3 bucket location, and more.</p>
    pub fn recommendation_template(
        &self,
    ) -> std::option::Option<&crate::model::RecommendationTemplate> {
        self.recommendation_template.as_ref()
    }
}
impl std::fmt::Debug for CreateRecommendationTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecommendationTemplateOutput");
        formatter.field("recommendation_template", &self.recommendation_template);
        formatter.finish()
    }
}
/// See [`CreateRecommendationTemplateOutput`](crate::output::CreateRecommendationTemplateOutput)
pub mod create_recommendation_template_output {
    /// A builder for [`CreateRecommendationTemplateOutput`](crate::output::CreateRecommendationTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_template:
            std::option::Option<crate::model::RecommendationTemplate>,
    }
    impl Builder {
        /// <p>The newly created recommendation template, returned as an object. This object includes the
        /// template's name, format, status, tags, Amazon S3 bucket location, and more.</p>
        pub fn recommendation_template(
            mut self,
            input: crate::model::RecommendationTemplate,
        ) -> Self {
            self.recommendation_template = Some(input);
            self
        }
        /// <p>The newly created recommendation template, returned as an object. This object includes the
        /// template's name, format, status, tags, Amazon S3 bucket location, and more.</p>
        pub fn set_recommendation_template(
            mut self,
            input: std::option::Option<crate::model::RecommendationTemplate>,
        ) -> Self {
            self.recommendation_template = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecommendationTemplateOutput`](crate::output::CreateRecommendationTemplateOutput)
        pub fn build(self) -> crate::output::CreateRecommendationTemplateOutput {
            crate::output::CreateRecommendationTemplateOutput {
                recommendation_template: self.recommendation_template,
            }
        }
    }
}
impl CreateRecommendationTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateRecommendationTemplateOutput`](crate::output::CreateRecommendationTemplateOutput)
    pub fn builder() -> crate::output::create_recommendation_template_output::Builder {
        crate::output::create_recommendation_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppOutput {
    /// <p>The created application returned as an object with details including compliance status,
    /// creation time, description, resiliency score, and more.</p>
    pub app: std::option::Option<crate::model::App>,
}
impl CreateAppOutput {
    /// <p>The created application returned as an object with details including compliance status,
    /// creation time, description, resiliency score, and more.</p>
    pub fn app(&self) -> std::option::Option<&crate::model::App> {
        self.app.as_ref()
    }
}
impl std::fmt::Debug for CreateAppOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppOutput");
        formatter.field("app", &self.app);
        formatter.finish()
    }
}
/// See [`CreateAppOutput`](crate::output::CreateAppOutput)
pub mod create_app_output {
    /// A builder for [`CreateAppOutput`](crate::output::CreateAppOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app: std::option::Option<crate::model::App>,
    }
    impl Builder {
        /// <p>The created application returned as an object with details including compliance status,
        /// creation time, description, resiliency score, and more.</p>
        pub fn app(mut self, input: crate::model::App) -> Self {
            self.app = Some(input);
            self
        }
        /// <p>The created application returned as an object with details including compliance status,
        /// creation time, description, resiliency score, and more.</p>
        pub fn set_app(mut self, input: std::option::Option<crate::model::App>) -> Self {
            self.app = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppOutput`](crate::output::CreateAppOutput)
        pub fn build(self) -> crate::output::CreateAppOutput {
            crate::output::CreateAppOutput { app: self.app }
        }
    }
}
impl CreateAppOutput {
    /// Creates a new builder-style object to manufacture [`CreateAppOutput`](crate::output::CreateAppOutput)
    pub fn builder() -> crate::output::create_app_output::Builder {
        crate::output::create_app_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddDraftAppVersionResourceMappingsOutput {
    /// <p> The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>Mappings used to map logical resources from the template to physical resources. You can
    /// use the mapping type <code>CFN_STACK</code> if the application template uses
    /// a logical stack name. Or you can map individual resources by using the mapping type
    /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
    /// application is backed by a CloudFormation stack.</p>
    pub resource_mappings: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
}
impl AddDraftAppVersionResourceMappingsOutput {
    /// <p> The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>Mappings used to map logical resources from the template to physical resources. You can
    /// use the mapping type <code>CFN_STACK</code> if the application template uses
    /// a logical stack name. Or you can map individual resources by using the mapping type
    /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
    /// application is backed by a CloudFormation stack.</p>
    pub fn resource_mappings(&self) -> std::option::Option<&[crate::model::ResourceMapping]> {
        self.resource_mappings.as_deref()
    }
}
impl std::fmt::Debug for AddDraftAppVersionResourceMappingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddDraftAppVersionResourceMappingsOutput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("resource_mappings", &self.resource_mappings);
        formatter.finish()
    }
}
/// See [`AddDraftAppVersionResourceMappingsOutput`](crate::output::AddDraftAppVersionResourceMappingsOutput)
pub mod add_draft_app_version_resource_mappings_output {
    /// A builder for [`AddDraftAppVersionResourceMappingsOutput`](crate::output::AddDraftAppVersionResourceMappingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) resource_mappings:
            std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Appends an item to `resource_mappings`.
        ///
        /// To override the contents of this collection use [`set_resource_mappings`](Self::set_resource_mappings).
        ///
        /// <p>Mappings used to map logical resources from the template to physical resources. You can
        /// use the mapping type <code>CFN_STACK</code> if the application template uses
        /// a logical stack name. Or you can map individual resources by using the mapping type
        /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
        /// application is backed by a CloudFormation stack.</p>
        pub fn resource_mappings(
            mut self,
            input: impl Into<crate::model::ResourceMapping>,
        ) -> Self {
            let mut v = self.resource_mappings.unwrap_or_default();
            v.push(input.into());
            self.resource_mappings = Some(v);
            self
        }
        /// <p>Mappings used to map logical resources from the template to physical resources. You can
        /// use the mapping type <code>CFN_STACK</code> if the application template uses
        /// a logical stack name. Or you can map individual resources by using the mapping type
        /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
        /// application is backed by a CloudFormation stack.</p>
        pub fn set_resource_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
        ) -> Self {
            self.resource_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`AddDraftAppVersionResourceMappingsOutput`](crate::output::AddDraftAppVersionResourceMappingsOutput)
        pub fn build(self) -> crate::output::AddDraftAppVersionResourceMappingsOutput {
            crate::output::AddDraftAppVersionResourceMappingsOutput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                resource_mappings: self.resource_mappings,
            }
        }
    }
}
impl AddDraftAppVersionResourceMappingsOutput {
    /// Creates a new builder-style object to manufacture [`AddDraftAppVersionResourceMappingsOutput`](crate::output::AddDraftAppVersionResourceMappingsOutput)
    pub fn builder() -> crate::output::add_draft_app_version_resource_mappings_output::Builder {
        crate::output::add_draft_app_version_resource_mappings_output::Builder::default()
    }
}
