// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddDraftAppVersionResourceMappingsInput`](crate::input::AddDraftAppVersionResourceMappingsInput)
pub mod add_draft_app_version_resource_mappings_input {
    /// A builder for [`AddDraftAppVersionResourceMappingsInput`](crate::input::AddDraftAppVersionResourceMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) resource_mappings:
            std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Appends an item to `resource_mappings`.
        ///
        /// To override the contents of this collection use [`set_resource_mappings`](Self::set_resource_mappings).
        ///
        /// <p> Mappings used to map logical resources from the template to physical resources. You can
        /// use the mapping type <code>CFN_STACK</code> if the application template uses
        /// a logical stack name. Or you can map individual resources by using the mapping type
        /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
        /// application is backed by a CloudFormation stack.</p>
        pub fn resource_mappings(
            mut self,
            input: impl Into<crate::model::ResourceMapping>,
        ) -> Self {
            let mut v = self.resource_mappings.unwrap_or_default();
            v.push(input.into());
            self.resource_mappings = Some(v);
            self
        }
        /// <p> Mappings used to map logical resources from the template to physical resources. You can
        /// use the mapping type <code>CFN_STACK</code> if the application template uses
        /// a logical stack name. Or you can map individual resources by using the mapping type
        /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
        /// application is backed by a CloudFormation stack.</p>
        pub fn set_resource_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
        ) -> Self {
            self.resource_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`AddDraftAppVersionResourceMappingsInput`](crate::input::AddDraftAppVersionResourceMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddDraftAppVersionResourceMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddDraftAppVersionResourceMappingsInput {
                app_arn: self.app_arn,
                resource_mappings: self.resource_mappings,
            })
        }
    }
}
#[doc(hidden)]
pub type AddDraftAppVersionResourceMappingsInputOperationOutputAlias =
    crate::operation::AddDraftAppVersionResourceMappings;
#[doc(hidden)]
pub type AddDraftAppVersionResourceMappingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddDraftAppVersionResourceMappingsInput {
    /// Consumes the builder and constructs an Operation<[`AddDraftAppVersionResourceMappings`](crate::operation::AddDraftAppVersionResourceMappings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddDraftAppVersionResourceMappings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddDraftAppVersionResourceMappingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/add-draft-app-version-resource-mappings")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddDraftAppVersionResourceMappingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddDraftAppVersionResourceMappingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_draft_app_version_resource_mappings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddDraftAppVersionResourceMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddDraftAppVersionResourceMappings",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddDraftAppVersionResourceMappingsInput`](crate::input::AddDraftAppVersionResourceMappingsInput)
    pub fn builder() -> crate::input::add_draft_app_version_resource_mappings_input::Builder {
        crate::input::add_draft_app_version_resource_mappings_input::Builder::default()
    }
}

/// See [`CreateAppInput`](crate::input::CreateAppInput)
pub mod create_app_input {
    /// A builder for [`CreateAppInput`](crate::input::CreateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInput`](crate::input::CreateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateAppInput {
                name: self.name,
                description: self.description,
                policy_arn: self.policy_arn,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInputOperationOutputAlias = crate::operation::CreateApp;
#[doc(hidden)]
pub type CreateAppInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAppInput {
    /// Consumes the builder and constructs an Operation<[`CreateApp`](crate::operation::CreateApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApp,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/create-app").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateApp",
                    "resiliencehub",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
}

/// See [`CreateRecommendationTemplateInput`](crate::input::CreateRecommendationTemplateInput)
pub mod create_recommendation_template_input {
    /// A builder for [`CreateRecommendationTemplateInput`](crate::input::CreateRecommendationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) format: std::option::Option<crate::model::TemplateFormat>,
        pub(crate) recommendation_types:
            std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `recommendation_ids`.
        ///
        /// To override the contents of this collection use [`set_recommendation_ids`](Self::set_recommendation_ids).
        ///
        /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
        pub fn recommendation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommendation_ids.unwrap_or_default();
            v.push(input.into());
            self.recommendation_ids = Some(v);
            self
        }
        /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
        pub fn set_recommendation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommendation_ids = input;
            self
        }
        /// <p>The format for the recommendation template.</p>
        /// <dl>
        /// <dt>CfnJson</dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>CfnYaml</dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn format(mut self, input: crate::model::TemplateFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format for the recommendation template.</p>
        /// <dl>
        /// <dt>CfnJson</dt>
        /// <dd>
        /// <p>The template is CloudFormation JSON.</p>
        /// </dd>
        /// <dt>CfnYaml</dt>
        /// <dd>
        /// <p>The template is CloudFormation YAML.</p>
        /// </dd>
        /// </dl>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TemplateFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Appends an item to `recommendation_types`.
        ///
        /// To override the contents of this collection use [`set_recommendation_types`](Self::set_recommendation_types).
        ///
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>Alarm</dt>
        /// <dd>
        /// <p>The template is an <a>AlarmRecommendation</a> template.</p>
        /// </dd>
        /// <dt>Sop</dt>
        /// <dd>
        /// <p>The template is a <a>SopRecommendation</a> template.</p>
        /// </dd>
        /// <dt>Test</dt>
        /// <dd>
        /// <p>The template is a <a>TestRecommendation</a> template.</p>
        /// </dd>
        /// </dl>
        pub fn recommendation_types(
            mut self,
            input: impl Into<crate::model::RenderRecommendationType>,
        ) -> Self {
            let mut v = self.recommendation_types.unwrap_or_default();
            v.push(input.into());
            self.recommendation_types = Some(v);
            self
        }
        /// <p>An array of strings that specify the recommendation template type or types.</p>
        /// <dl>
        /// <dt>Alarm</dt>
        /// <dd>
        /// <p>The template is an <a>AlarmRecommendation</a> template.</p>
        /// </dd>
        /// <dt>Sop</dt>
        /// <dd>
        /// <p>The template is a <a>SopRecommendation</a> template.</p>
        /// </dd>
        /// <dt>Test</dt>
        /// <dd>
        /// <p>The template is a <a>TestRecommendation</a> template.</p>
        /// </dd>
        /// </dl>
        pub fn set_recommendation_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
        ) -> Self {
            self.recommendation_types = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the recommendation template.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRecommendationTemplateInput`](crate::input::CreateRecommendationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRecommendationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRecommendationTemplateInput {
                recommendation_ids: self.recommendation_ids,
                format: self.format,
                recommendation_types: self.recommendation_types,
                assessment_arn: self.assessment_arn,
                name: self.name,
                client_token: self.client_token,
                tags: self.tags,
                bucket_name: self.bucket_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRecommendationTemplateInputOperationOutputAlias =
    crate::operation::CreateRecommendationTemplate;
#[doc(hidden)]
pub type CreateRecommendationTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRecommendationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateRecommendationTemplate`](crate::operation::CreateRecommendationTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRecommendationTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRecommendationTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/create-recommendation-template").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRecommendationTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRecommendationTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_recommendation_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRecommendationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRecommendationTemplate",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRecommendationTemplateInput`](crate::input::CreateRecommendationTemplateInput)
    pub fn builder() -> crate::input::create_recommendation_template_input::Builder {
        crate::input::create_recommendation_template_input::Builder::default()
    }
}

/// See [`CreateResiliencyPolicyInput`](crate::input::CreateResiliencyPolicyInput)
pub mod create_resiliency_policy_input {
    /// A builder for [`CreateResiliencyPolicyInput`](crate::input::CreateResiliencyPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_description: std::option::Option<std::string::String>,
        pub(crate) data_location_constraint:
            std::option::Option<crate::model::DataLocationConstraint>,
        pub(crate) tier: std::option::Option<crate::model::ResiliencyPolicyTier>,
        pub(crate) policy: std::option::Option<
            std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The description for the policy.</p>
        pub fn policy_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_description = Some(input.into());
            self
        }
        /// <p>The description for the policy.</p>
        pub fn set_policy_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_description = input;
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy
        /// data can be stored.</p>
        pub fn data_location_constraint(
            mut self,
            input: crate::model::DataLocationConstraint,
        ) -> Self {
            self.data_location_constraint = Some(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy
        /// data can be stored.</p>
        pub fn set_data_location_constraint(
            mut self,
            input: std::option::Option<crate::model::DataLocationConstraint>,
        ) -> Self {
            self.data_location_constraint = input;
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity
        /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn tier(mut self, input: crate::model::ResiliencyPolicyTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity
        /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicyTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// Adds a key-value pair to `policy`.
        ///
        /// To override the contents of this collection use [`set_policy`](Self::set_policy).
        ///
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
        /// and recovery point objective (RPO) in seconds.</p>
        pub fn policy(
            mut self,
            k: impl Into<crate::model::DisruptionType>,
            v: impl Into<crate::model::FailurePolicy>,
        ) -> Self {
            let mut hash_map = self.policy.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.policy = Some(hash_map);
            self
        }
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
        /// and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::FailurePolicy,
                >,
            >,
        ) -> Self {
            self.policy = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResiliencyPolicyInput`](crate::input::CreateResiliencyPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResiliencyPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResiliencyPolicyInput {
                policy_name: self.policy_name,
                policy_description: self.policy_description,
                data_location_constraint: self.data_location_constraint,
                tier: self.tier,
                policy: self.policy,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResiliencyPolicyInputOperationOutputAlias = crate::operation::CreateResiliencyPolicy;
#[doc(hidden)]
pub type CreateResiliencyPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateResiliencyPolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateResiliencyPolicy`](crate::operation::CreateResiliencyPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResiliencyPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResiliencyPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/create-resiliency-policy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResiliencyPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResiliencyPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_resiliency_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResiliencyPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResiliencyPolicy",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResiliencyPolicyInput`](crate::input::CreateResiliencyPolicyInput)
    pub fn builder() -> crate::input::create_resiliency_policy_input::Builder {
        crate::input::create_resiliency_policy_input::Builder::default()
    }
}

/// See [`DeleteAppInput`](crate::input::DeleteAppInput)
pub mod delete_app_input {
    /// A builder for [`DeleteAppInput`](crate::input::DeleteAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInput`](crate::input::DeleteAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteAppInput {
                app_arn: self.app_arn,
                force_delete: self.force_delete,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInputOperationOutputAlias = crate::operation::DeleteApp;
#[doc(hidden)]
pub type DeleteAppInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAppInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApp`](crate::operation::DeleteApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApp,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delete-app").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteApp",
                    "resiliencehub",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
}

/// See [`DeleteAppAssessmentInput`](crate::input::DeleteAppAssessmentInput)
pub mod delete_app_assessment_input {
    /// A builder for [`DeleteAppAssessmentInput`](crate::input::DeleteAppAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppAssessmentInput`](crate::input::DeleteAppAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppAssessmentInput {
                assessment_arn: self.assessment_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppAssessmentInputOperationOutputAlias = crate::operation::DeleteAppAssessment;
#[doc(hidden)]
pub type DeleteAppAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAppAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppAssessment`](crate::operation::DeleteAppAssessment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delete-app-assessment").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_app_assessment(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppAssessment",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppAssessmentInput`](crate::input::DeleteAppAssessmentInput)
    pub fn builder() -> crate::input::delete_app_assessment_input::Builder {
        crate::input::delete_app_assessment_input::Builder::default()
    }
}

/// See [`DeleteRecommendationTemplateInput`](crate::input::DeleteRecommendationTemplateInput)
pub mod delete_recommendation_template_input {
    /// A builder for [`DeleteRecommendationTemplateInput`](crate::input::DeleteRecommendationTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_template_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRecommendationTemplateInput`](crate::input::DeleteRecommendationTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRecommendationTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRecommendationTemplateInput {
                recommendation_template_arn: self.recommendation_template_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRecommendationTemplateInputOperationOutputAlias =
    crate::operation::DeleteRecommendationTemplate;
#[doc(hidden)]
pub type DeleteRecommendationTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRecommendationTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRecommendationTemplate`](crate::operation::DeleteRecommendationTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRecommendationTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRecommendationTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delete-recommendation-template").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRecommendationTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRecommendationTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_recommendation_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRecommendationTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRecommendationTemplate",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRecommendationTemplateInput`](crate::input::DeleteRecommendationTemplateInput)
    pub fn builder() -> crate::input::delete_recommendation_template_input::Builder {
        crate::input::delete_recommendation_template_input::Builder::default()
    }
}

/// See [`DeleteResiliencyPolicyInput`](crate::input::DeleteResiliencyPolicyInput)
pub mod delete_resiliency_policy_input {
    /// A builder for [`DeleteResiliencyPolicyInput`](crate::input::DeleteResiliencyPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResiliencyPolicyInput`](crate::input::DeleteResiliencyPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResiliencyPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResiliencyPolicyInput {
                policy_arn: self.policy_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResiliencyPolicyInputOperationOutputAlias = crate::operation::DeleteResiliencyPolicy;
#[doc(hidden)]
pub type DeleteResiliencyPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteResiliencyPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResiliencyPolicy`](crate::operation::DeleteResiliencyPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResiliencyPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResiliencyPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delete-resiliency-policy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResiliencyPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResiliencyPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_resiliency_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResiliencyPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResiliencyPolicy",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResiliencyPolicyInput`](crate::input::DeleteResiliencyPolicyInput)
    pub fn builder() -> crate::input::delete_resiliency_policy_input::Builder {
        crate::input::delete_resiliency_policy_input::Builder::default()
    }
}

/// See [`DescribeAppInput`](crate::input::DescribeAppInput)
pub mod describe_app_input {
    /// A builder for [`DescribeAppInput`](crate::input::DescribeAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInput`](crate::input::DescribeAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppInput {
                app_arn: self.app_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppInputOperationOutputAlias = crate::operation::DescribeApp;
#[doc(hidden)]
pub type DescribeAppInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAppInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApp`](crate::operation::DescribeApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApp,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-app").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApp",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppInput`](crate::input::DescribeAppInput)
    pub fn builder() -> crate::input::describe_app_input::Builder {
        crate::input::describe_app_input::Builder::default()
    }
}

/// See [`DescribeAppAssessmentInput`](crate::input::DescribeAppAssessmentInput)
pub mod describe_app_assessment_input {
    /// A builder for [`DescribeAppAssessmentInput`](crate::input::DescribeAppAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppAssessmentInput`](crate::input::DescribeAppAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppAssessmentInput {
                assessment_arn: self.assessment_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppAssessmentInputOperationOutputAlias = crate::operation::DescribeAppAssessment;
#[doc(hidden)]
pub type DescribeAppAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAppAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppAssessment`](crate::operation::DescribeAppAssessment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-app-assessment").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_app_assessment(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppAssessment",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppAssessmentInput`](crate::input::DescribeAppAssessmentInput)
    pub fn builder() -> crate::input::describe_app_assessment_input::Builder {
        crate::input::describe_app_assessment_input::Builder::default()
    }
}

/// See [`DescribeAppVersionResourcesResolutionStatusInput`](crate::input::DescribeAppVersionResourcesResolutionStatusInput)
pub mod describe_app_version_resources_resolution_status_input {
    /// A builder for [`DescribeAppVersionResourcesResolutionStatusInput`](crate::input::DescribeAppVersionResourcesResolutionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) resolution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_id = Some(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppVersionResourcesResolutionStatusInput`](crate::input::DescribeAppVersionResourcesResolutionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppVersionResourcesResolutionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeAppVersionResourcesResolutionStatusInput {
                    app_arn: self.app_arn,
                    app_version: self.app_version,
                    resolution_id: self.resolution_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeAppVersionResourcesResolutionStatusInputOperationOutputAlias =
    crate::operation::DescribeAppVersionResourcesResolutionStatus;
#[doc(hidden)]
pub type DescribeAppVersionResourcesResolutionStatusInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeAppVersionResourcesResolutionStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppVersionResourcesResolutionStatus`](crate::operation::DescribeAppVersionResourcesResolutionStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppVersionResourcesResolutionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppVersionResourcesResolutionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-app-version-resources-resolution-status")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppVersionResourcesResolutionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppVersionResourcesResolutionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_app_version_resources_resolution_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppVersionResourcesResolutionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppVersionResourcesResolutionStatus",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppVersionResourcesResolutionStatusInput`](crate::input::DescribeAppVersionResourcesResolutionStatusInput)
    pub fn builder() -> crate::input::describe_app_version_resources_resolution_status_input::Builder
    {
        crate::input::describe_app_version_resources_resolution_status_input::Builder::default()
    }
}

/// See [`DescribeAppVersionTemplateInput`](crate::input::DescribeAppVersionTemplateInput)
pub mod describe_app_version_template_input {
    /// A builder for [`DescribeAppVersionTemplateInput`](crate::input::DescribeAppVersionTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppVersionTemplateInput`](crate::input::DescribeAppVersionTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppVersionTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppVersionTemplateInput {
                app_arn: self.app_arn,
                app_version: self.app_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppVersionTemplateInputOperationOutputAlias =
    crate::operation::DescribeAppVersionTemplate;
#[doc(hidden)]
pub type DescribeAppVersionTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAppVersionTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppVersionTemplate`](crate::operation::DescribeAppVersionTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppVersionTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppVersionTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-app-version-template").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppVersionTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppVersionTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_app_version_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppVersionTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppVersionTemplate",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppVersionTemplateInput`](crate::input::DescribeAppVersionTemplateInput)
    pub fn builder() -> crate::input::describe_app_version_template_input::Builder {
        crate::input::describe_app_version_template_input::Builder::default()
    }
}

/// See [`DescribeDraftAppVersionResourcesImportStatusInput`](crate::input::DescribeDraftAppVersionResourcesImportStatusInput)
pub mod describe_draft_app_version_resources_import_status_input {
    /// A builder for [`DescribeDraftAppVersionResourcesImportStatusInput`](crate::input::DescribeDraftAppVersionResourcesImportStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDraftAppVersionResourcesImportStatusInput`](crate::input::DescribeDraftAppVersionResourcesImportStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDraftAppVersionResourcesImportStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeDraftAppVersionResourcesImportStatusInput {
                    app_arn: self.app_arn,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeDraftAppVersionResourcesImportStatusInputOperationOutputAlias =
    crate::operation::DescribeDraftAppVersionResourcesImportStatus;
#[doc(hidden)]
pub type DescribeDraftAppVersionResourcesImportStatusInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeDraftAppVersionResourcesImportStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDraftAppVersionResourcesImportStatus`](crate::operation::DescribeDraftAppVersionResourcesImportStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDraftAppVersionResourcesImportStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDraftAppVersionResourcesImportStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(
                output,
                "/describe-draft-app-version-resources-import-status"
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDraftAppVersionResourcesImportStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDraftAppVersionResourcesImportStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_draft_app_version_resources_import_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDraftAppVersionResourcesImportStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDraftAppVersionResourcesImportStatus",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDraftAppVersionResourcesImportStatusInput`](crate::input::DescribeDraftAppVersionResourcesImportStatusInput)
    pub fn builder(
    ) -> crate::input::describe_draft_app_version_resources_import_status_input::Builder {
        crate::input::describe_draft_app_version_resources_import_status_input::Builder::default()
    }
}

/// See [`DescribeResiliencyPolicyInput`](crate::input::DescribeResiliencyPolicyInput)
pub mod describe_resiliency_policy_input {
    /// A builder for [`DescribeResiliencyPolicyInput`](crate::input::DescribeResiliencyPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResiliencyPolicyInput`](crate::input::DescribeResiliencyPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResiliencyPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResiliencyPolicyInput {
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResiliencyPolicyInputOperationOutputAlias =
    crate::operation::DescribeResiliencyPolicy;
#[doc(hidden)]
pub type DescribeResiliencyPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeResiliencyPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResiliencyPolicy`](crate::operation::DescribeResiliencyPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResiliencyPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeResiliencyPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/describe-resiliency-policy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeResiliencyPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeResiliencyPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_resiliency_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResiliencyPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResiliencyPolicy",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeResiliencyPolicyInput`](crate::input::DescribeResiliencyPolicyInput)
    pub fn builder() -> crate::input::describe_resiliency_policy_input::Builder {
        crate::input::describe_resiliency_policy_input::Builder::default()
    }
}

/// See [`ImportResourcesToDraftAppVersionInput`](crate::input::ImportResourcesToDraftAppVersionInput)
pub mod import_resources_to_draft_app_version_input {
    /// A builder for [`ImportResourcesToDraftAppVersionInput`](crate::input::ImportResourcesToDraftAppVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) source_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Appends an item to `source_arns`.
        ///
        /// To override the contents of this collection use [`set_source_arns`](Self::set_source_arns).
        ///
        /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
        pub fn source_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_arns.unwrap_or_default();
            v.push(input.into());
            self.source_arns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
        pub fn set_source_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportResourcesToDraftAppVersionInput`](crate::input::ImportResourcesToDraftAppVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportResourcesToDraftAppVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportResourcesToDraftAppVersionInput {
                app_arn: self.app_arn,
                source_arns: self.source_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportResourcesToDraftAppVersionInputOperationOutputAlias =
    crate::operation::ImportResourcesToDraftAppVersion;
#[doc(hidden)]
pub type ImportResourcesToDraftAppVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportResourcesToDraftAppVersionInput {
    /// Consumes the builder and constructs an Operation<[`ImportResourcesToDraftAppVersion`](crate::operation::ImportResourcesToDraftAppVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportResourcesToDraftAppVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportResourcesToDraftAppVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/import-resources-to-draft-app-version")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportResourcesToDraftAppVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportResourcesToDraftAppVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_resources_to_draft_app_version(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportResourcesToDraftAppVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportResourcesToDraftAppVersion",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportResourcesToDraftAppVersionInput`](crate::input::ImportResourcesToDraftAppVersionInput)
    pub fn builder() -> crate::input::import_resources_to_draft_app_version_input::Builder {
        crate::input::import_resources_to_draft_app_version_input::Builder::default()
    }
}

/// See [`ListAlarmRecommendationsInput`](crate::input::ListAlarmRecommendationsInput)
pub mod list_alarm_recommendations_input {
    /// A builder for [`ListAlarmRecommendationsInput`](crate::input::ListAlarmRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlarmRecommendationsInput`](crate::input::ListAlarmRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAlarmRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAlarmRecommendationsInput {
                assessment_arn: self.assessment_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAlarmRecommendationsInputOperationOutputAlias =
    crate::operation::ListAlarmRecommendations;
#[doc(hidden)]
pub type ListAlarmRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAlarmRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ListAlarmRecommendations`](crate::operation::ListAlarmRecommendations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAlarmRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAlarmRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-alarm-recommendations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAlarmRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAlarmRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_alarm_recommendations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAlarmRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAlarmRecommendations",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAlarmRecommendationsInput`](crate::input::ListAlarmRecommendationsInput)
    pub fn builder() -> crate::input::list_alarm_recommendations_input::Builder {
        crate::input::list_alarm_recommendations_input::Builder::default()
    }
}

/// See [`ListAppAssessmentsInput`](crate::input::ListAppAssessmentsInput)
pub mod list_app_assessments_input {
    /// A builder for [`ListAppAssessmentsInput`](crate::input::ListAppAssessmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) assessment_status:
            std::option::Option<std::vec::Vec<crate::model::AssessmentStatus>>,
        pub(crate) compliance_status: std::option::Option<crate::model::ComplianceStatus>,
        pub(crate) invoker: std::option::Option<crate::model::AssessmentInvoker>,
        pub(crate) reverse_order: std::option::Option<bool>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// Appends an item to `assessment_status`.
        ///
        /// To override the contents of this collection use [`set_assessment_status`](Self::set_assessment_status).
        ///
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn assessment_status(
            mut self,
            input: impl Into<crate::model::AssessmentStatus>,
        ) -> Self {
            let mut v = self.assessment_status.unwrap_or_default();
            v.push(input.into());
            self.assessment_status = Some(v);
            self
        }
        /// <p>The current status of the assessment for the resiliency policy.</p>
        pub fn set_assessment_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentStatus>>,
        ) -> Self {
            self.assessment_status = input;
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn compliance_status(mut self, input: crate::model::ComplianceStatus) -> Self {
            self.compliance_status = Some(input);
            self
        }
        /// <p>The current status of compliance for the resiliency policy.</p>
        pub fn set_compliance_status(
            mut self,
            input: std::option::Option<crate::model::ComplianceStatus>,
        ) -> Self {
            self.compliance_status = input;
            self
        }
        /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
        /// <code>System</code>.</p>
        pub fn invoker(mut self, input: crate::model::AssessmentInvoker) -> Self {
            self.invoker = Some(input);
            self
        }
        /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
        /// <code>System</code>.</p>
        pub fn set_invoker(
            mut self,
            input: std::option::Option<crate::model::AssessmentInvoker>,
        ) -> Self {
            self.invoker = input;
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>.
        /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>.
        /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppAssessmentsInput`](crate::input::ListAppAssessmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppAssessmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppAssessmentsInput {
                app_arn: self.app_arn,
                assessment_name: self.assessment_name,
                assessment_status: self.assessment_status,
                compliance_status: self.compliance_status,
                invoker: self.invoker,
                reverse_order: self.reverse_order,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppAssessmentsInputOperationOutputAlias = crate::operation::ListAppAssessments;
#[doc(hidden)]
pub type ListAppAssessmentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAppAssessmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListAppAssessments`](crate::operation::ListAppAssessments)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppAssessments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppAssessmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-app-assessments").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAppAssessmentsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_1) = &_input.app_arn {
                query.push_kv("appArn", &aws_smithy_http::query::fmt_string(&inner_1));
            }
            if let Some(inner_2) = &_input.assessment_name {
                query.push_kv(
                    "assessmentName",
                    &aws_smithy_http::query::fmt_string(&inner_2),
                );
            }
            if let Some(inner_3) = &_input.assessment_status {
                for inner_4 in inner_3 {
                    query.push_kv(
                        "assessmentStatus",
                        &aws_smithy_http::query::fmt_string(&inner_4),
                    );
                }
            }
            if let Some(inner_5) = &_input.compliance_status {
                query.push_kv(
                    "complianceStatus",
                    &aws_smithy_http::query::fmt_string(&inner_5),
                );
            }
            if let Some(inner_6) = &_input.invoker {
                query.push_kv("invoker", &aws_smithy_http::query::fmt_string(&inner_6));
            }
            if let Some(inner_7) = &_input.reverse_order {
                query.push_kv(
                    "reverseOrder",
                    aws_smithy_types::primitive::Encoder::from(*inner_7).encode(),
                );
            }
            if let Some(inner_8) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_8));
            }
            if let Some(inner_9) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_9).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppAssessmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppAssessmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppAssessments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppAssessments",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppAssessmentsInput`](crate::input::ListAppAssessmentsInput)
    pub fn builder() -> crate::input::list_app_assessments_input::Builder {
        crate::input::list_app_assessments_input::Builder::default()
    }
}

/// See [`ListAppComponentCompliancesInput`](crate::input::ListAppComponentCompliancesInput)
pub mod list_app_component_compliances_input {
    /// A builder for [`ListAppComponentCompliancesInput`](crate::input::ListAppComponentCompliancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppComponentCompliancesInput`](crate::input::ListAppComponentCompliancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppComponentCompliancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppComponentCompliancesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                assessment_arn: self.assessment_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppComponentCompliancesInputOperationOutputAlias =
    crate::operation::ListAppComponentCompliances;
#[doc(hidden)]
pub type ListAppComponentCompliancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAppComponentCompliancesInput {
    /// Consumes the builder and constructs an Operation<[`ListAppComponentCompliances`](crate::operation::ListAppComponentCompliances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppComponentCompliances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppComponentCompliancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-app-component-compliances").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppComponentCompliancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppComponentCompliancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_app_component_compliances(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppComponentCompliances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppComponentCompliances",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppComponentCompliancesInput`](crate::input::ListAppComponentCompliancesInput)
    pub fn builder() -> crate::input::list_app_component_compliances_input::Builder {
        crate::input::list_app_component_compliances_input::Builder::default()
    }
}

/// See [`ListAppComponentRecommendationsInput`](crate::input::ListAppComponentRecommendationsInput)
pub mod list_app_component_recommendations_input {
    /// A builder for [`ListAppComponentRecommendationsInput`](crate::input::ListAppComponentRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppComponentRecommendationsInput`](crate::input::ListAppComponentRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppComponentRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppComponentRecommendationsInput {
                assessment_arn: self.assessment_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppComponentRecommendationsInputOperationOutputAlias =
    crate::operation::ListAppComponentRecommendations;
#[doc(hidden)]
pub type ListAppComponentRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAppComponentRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ListAppComponentRecommendations`](crate::operation::ListAppComponentRecommendations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppComponentRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppComponentRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-app-component-recommendations")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppComponentRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppComponentRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_app_component_recommendations(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppComponentRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppComponentRecommendations",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppComponentRecommendationsInput`](crate::input::ListAppComponentRecommendationsInput)
    pub fn builder() -> crate::input::list_app_component_recommendations_input::Builder {
        crate::input::list_app_component_recommendations_input::Builder::default()
    }
}

/// See [`ListAppsInput`](crate::input::ListAppsInput)
pub mod list_apps_input {
    /// A builder for [`ListAppsInput`](crate::input::ListAppsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) app_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The name for the one of the listed applications.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the one of the listed applications.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppsInput`](crate::input::ListAppsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListAppsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListAppsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                name: self.name,
                app_arn: self.app_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppsInputOperationOutputAlias = crate::operation::ListApps;
#[doc(hidden)]
pub type ListAppsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAppsInput {
    /// Consumes the builder and constructs an Operation<[`ListApps`](crate::operation::ListApps)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApps,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-apps").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAppsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_10) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_10));
            }
            if let Some(inner_11) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_11).encode(),
                );
            }
            if let Some(inner_12) = &_input.name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_12));
            }
            if let Some(inner_13) = &_input.app_arn {
                query.push_kv("appArn", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListApps::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListApps",
                    "resiliencehub",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppsInput`](crate::input::ListAppsInput)
    pub fn builder() -> crate::input::list_apps_input::Builder {
        crate::input::list_apps_input::Builder::default()
    }
}

/// See [`ListAppVersionResourceMappingsInput`](crate::input::ListAppVersionResourceMappingsInput)
pub mod list_app_version_resource_mappings_input {
    /// A builder for [`ListAppVersionResourceMappingsInput`](crate::input::ListAppVersionResourceMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppVersionResourceMappingsInput`](crate::input::ListAppVersionResourceMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppVersionResourceMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppVersionResourceMappingsInput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppVersionResourceMappingsInputOperationOutputAlias =
    crate::operation::ListAppVersionResourceMappings;
#[doc(hidden)]
pub type ListAppVersionResourceMappingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAppVersionResourceMappingsInput {
    /// Consumes the builder and constructs an Operation<[`ListAppVersionResourceMappings`](crate::operation::ListAppVersionResourceMappings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppVersionResourceMappings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppVersionResourceMappingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-app-version-resource-mappings")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppVersionResourceMappingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppVersionResourceMappingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_app_version_resource_mappings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppVersionResourceMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppVersionResourceMappings",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppVersionResourceMappingsInput`](crate::input::ListAppVersionResourceMappingsInput)
    pub fn builder() -> crate::input::list_app_version_resource_mappings_input::Builder {
        crate::input::list_app_version_resource_mappings_input::Builder::default()
    }
}

/// See [`ListAppVersionResourcesInput`](crate::input::ListAppVersionResourcesInput)
pub mod list_app_version_resources_input {
    /// A builder for [`ListAppVersionResourcesInput`](crate::input::ListAppVersionResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) resolution_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_id = Some(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_id = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppVersionResourcesInput`](crate::input::ListAppVersionResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppVersionResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppVersionResourcesInput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                resolution_id: self.resolution_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppVersionResourcesInputOperationOutputAlias =
    crate::operation::ListAppVersionResources;
#[doc(hidden)]
pub type ListAppVersionResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAppVersionResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListAppVersionResources`](crate::operation::ListAppVersionResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppVersionResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppVersionResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-app-version-resources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppVersionResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppVersionResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_app_version_resources(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppVersionResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppVersionResources",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppVersionResourcesInput`](crate::input::ListAppVersionResourcesInput)
    pub fn builder() -> crate::input::list_app_version_resources_input::Builder {
        crate::input::list_app_version_resources_input::Builder::default()
    }
}

/// See [`ListAppVersionsInput`](crate::input::ListAppVersionsInput)
pub mod list_app_versions_input {
    /// A builder for [`ListAppVersionsInput`](crate::input::ListAppVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppVersionsInput`](crate::input::ListAppVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAppVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAppVersionsInput {
                app_arn: self.app_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAppVersionsInputOperationOutputAlias = crate::operation::ListAppVersions;
#[doc(hidden)]
pub type ListAppVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAppVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListAppVersions`](crate::operation::ListAppVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAppVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAppVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-app-versions").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAppVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAppVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_app_versions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAppVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAppVersions",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAppVersionsInput`](crate::input::ListAppVersionsInput)
    pub fn builder() -> crate::input::list_app_versions_input::Builder {
        crate::input::list_app_versions_input::Builder::default()
    }
}

/// See [`ListRecommendationTemplatesInput`](crate::input::ListRecommendationTemplatesInput)
pub mod list_recommendation_templates_input {
    /// A builder for [`ListRecommendationTemplatesInput`](crate::input::ListRecommendationTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
        pub(crate) reverse_order: std::option::Option<bool>,
        pub(crate) status:
            std::option::Option<std::vec::Vec<crate::model::RecommendationTemplateStatus>>,
        pub(crate) recommendation_template_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>.
        /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn reverse_order(mut self, input: bool) -> Self {
            self.reverse_order = Some(input);
            self
        }
        /// <p>The default is to sort by ascending <b>startTime</b>.
        /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
        pub fn set_reverse_order(mut self, input: std::option::Option<bool>) -> Self {
            self.reverse_order = input;
            self
        }
        /// Appends an item to `status`.
        ///
        /// To override the contents of this collection use [`set_status`](Self::set_status).
        ///
        /// <p>The status of the action.</p>
        pub fn status(
            mut self,
            input: impl Into<crate::model::RecommendationTemplateStatus>,
        ) -> Self {
            let mut v = self.status.unwrap_or_default();
            v.push(input.into());
            self.status = Some(v);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendationTemplateStatus>>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn recommendation_template_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
        pub fn set_recommendation_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_template_arn = input;
            self
        }
        /// <p>The name for one of the listed recommendation templates.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for one of the listed recommendation templates.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendationTemplatesInput`](crate::input::ListRecommendationTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecommendationTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecommendationTemplatesInput {
                assessment_arn: self.assessment_arn,
                reverse_order: self.reverse_order,
                status: self.status,
                recommendation_template_arn: self.recommendation_template_arn,
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecommendationTemplatesInputOperationOutputAlias =
    crate::operation::ListRecommendationTemplates;
#[doc(hidden)]
pub type ListRecommendationTemplatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRecommendationTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListRecommendationTemplates`](crate::operation::ListRecommendationTemplates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecommendationTemplates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecommendationTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-recommendation-templates").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRecommendationTemplatesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_14) = &_input.assessment_arn {
                query.push_kv(
                    "assessmentArn",
                    &aws_smithy_http::query::fmt_string(&inner_14),
                );
            }
            if let Some(inner_15) = &_input.reverse_order {
                query.push_kv(
                    "reverseOrder",
                    aws_smithy_types::primitive::Encoder::from(*inner_15).encode(),
                );
            }
            if let Some(inner_16) = &_input.status {
                for inner_17 in inner_16 {
                    query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_17));
                }
            }
            if let Some(inner_18) = &_input.recommendation_template_arn {
                query.push_kv(
                    "recommendationTemplateArn",
                    &aws_smithy_http::query::fmt_string(&inner_18),
                );
            }
            if let Some(inner_19) = &_input.name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_19));
            }
            if let Some(inner_20) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_20));
            }
            if let Some(inner_21) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_21).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecommendationTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecommendationTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecommendationTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecommendationTemplates",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecommendationTemplatesInput`](crate::input::ListRecommendationTemplatesInput)
    pub fn builder() -> crate::input::list_recommendation_templates_input::Builder {
        crate::input::list_recommendation_templates_input::Builder::default()
    }
}

/// See [`ListResiliencyPoliciesInput`](crate::input::ListResiliencyPoliciesInput)
pub mod list_resiliency_policies_input {
    /// A builder for [`ListResiliencyPoliciesInput`](crate::input::ListResiliencyPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResiliencyPoliciesInput`](crate::input::ListResiliencyPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResiliencyPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResiliencyPoliciesInput {
                policy_name: self.policy_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResiliencyPoliciesInputOperationOutputAlias = crate::operation::ListResiliencyPolicies;
#[doc(hidden)]
pub type ListResiliencyPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListResiliencyPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListResiliencyPolicies`](crate::operation::ListResiliencyPolicies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResiliencyPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListResiliencyPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-resiliency-policies").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListResiliencyPoliciesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_22) = &_input.policy_name {
                query.push_kv("policyName", &aws_smithy_http::query::fmt_string(&inner_22));
            }
            if let Some(inner_23) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            if let Some(inner_24) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_24).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListResiliencyPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListResiliencyPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResiliencyPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResiliencyPolicies",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListResiliencyPoliciesInput`](crate::input::ListResiliencyPoliciesInput)
    pub fn builder() -> crate::input::list_resiliency_policies_input::Builder {
        crate::input::list_resiliency_policies_input::Builder::default()
    }
}

/// See [`ListSopRecommendationsInput`](crate::input::ListSopRecommendationsInput)
pub mod list_sop_recommendations_input {
    /// A builder for [`ListSopRecommendationsInput`](crate::input::ListSopRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSopRecommendationsInput`](crate::input::ListSopRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSopRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSopRecommendationsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                assessment_arn: self.assessment_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSopRecommendationsInputOperationOutputAlias = crate::operation::ListSopRecommendations;
#[doc(hidden)]
pub type ListSopRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSopRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ListSopRecommendations`](crate::operation::ListSopRecommendations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSopRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSopRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-sop-recommendations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSopRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSopRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_sop_recommendations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSopRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSopRecommendations",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSopRecommendationsInput`](crate::input::ListSopRecommendationsInput)
    pub fn builder() -> crate::input::list_sop_recommendations_input::Builder {
        crate::input::list_sop_recommendations_input::Builder::default()
    }
}

/// See [`ListSuggestedResiliencyPoliciesInput`](crate::input::ListSuggestedResiliencyPoliciesInput)
pub mod list_suggested_resiliency_policies_input {
    /// A builder for [`ListSuggestedResiliencyPoliciesInput`](crate::input::ListSuggestedResiliencyPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSuggestedResiliencyPoliciesInput`](crate::input::ListSuggestedResiliencyPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSuggestedResiliencyPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSuggestedResiliencyPoliciesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSuggestedResiliencyPoliciesInputOperationOutputAlias =
    crate::operation::ListSuggestedResiliencyPolicies;
#[doc(hidden)]
pub type ListSuggestedResiliencyPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSuggestedResiliencyPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListSuggestedResiliencyPolicies`](crate::operation::ListSuggestedResiliencyPolicies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSuggestedResiliencyPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSuggestedResiliencyPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-suggested-resiliency-policies")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSuggestedResiliencyPoliciesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            if let Some(inner_26) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_26).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSuggestedResiliencyPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSuggestedResiliencyPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSuggestedResiliencyPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSuggestedResiliencyPolicies",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSuggestedResiliencyPoliciesInput`](crate::input::ListSuggestedResiliencyPoliciesInput)
    pub fn builder() -> crate::input::list_suggested_resiliency_policies_input::Builder {
        crate::input::list_suggested_resiliency_policies_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub
        /// application.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub
        /// application.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.resource_arn;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_27, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTestRecommendationsInput`](crate::input::ListTestRecommendationsInput)
pub mod list_test_recommendations_input {
    /// A builder for [`ListTestRecommendationsInput`](crate::input::ListTestRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) assessment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn assessment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTestRecommendationsInput`](crate::input::ListTestRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTestRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTestRecommendationsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                assessment_arn: self.assessment_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTestRecommendationsInputOperationOutputAlias =
    crate::operation::ListTestRecommendations;
#[doc(hidden)]
pub type ListTestRecommendationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTestRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ListTestRecommendations`](crate::operation::ListTestRecommendations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTestRecommendations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTestRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-test-recommendations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTestRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTestRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_test_recommendations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTestRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTestRecommendations",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTestRecommendationsInput`](crate::input::ListTestRecommendationsInput)
    pub fn builder() -> crate::input::list_test_recommendations_input::Builder {
        crate::input::list_test_recommendations_input::Builder::default()
    }
}

/// See [`ListUnsupportedAppVersionResourcesInput`](crate::input::ListUnsupportedAppVersionResourcesInput)
pub mod list_unsupported_app_version_resources_input {
    /// A builder for [`ListUnsupportedAppVersionResourcesInput`](crate::input::ListUnsupportedAppVersionResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) resolution_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn resolution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolution_id = Some(input.into());
            self
        }
        /// <p>The identifier for a specific resolution.</p>
        pub fn set_resolution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolution_id = input;
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Null, or the token from a previous call to get the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to include in the response. If more results exist than the specified
        /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUnsupportedAppVersionResourcesInput`](crate::input::ListUnsupportedAppVersionResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUnsupportedAppVersionResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUnsupportedAppVersionResourcesInput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                resolution_id: self.resolution_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUnsupportedAppVersionResourcesInputOperationOutputAlias =
    crate::operation::ListUnsupportedAppVersionResources;
#[doc(hidden)]
pub type ListUnsupportedAppVersionResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListUnsupportedAppVersionResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListUnsupportedAppVersionResources`](crate::operation::ListUnsupportedAppVersionResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUnsupportedAppVersionResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUnsupportedAppVersionResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/list-unsupported-app-version-resources")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUnsupportedAppVersionResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUnsupportedAppVersionResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_unsupported_app_version_resources(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUnsupportedAppVersionResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUnsupportedAppVersionResources",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUnsupportedAppVersionResourcesInput`](crate::input::ListUnsupportedAppVersionResourcesInput)
    pub fn builder() -> crate::input::list_unsupported_app_version_resources_input::Builder {
        crate::input::list_unsupported_app_version_resources_input::Builder::default()
    }
}

/// See [`PublishAppVersionInput`](crate::input::PublishAppVersionInput)
pub mod publish_app_version_input {
    /// A builder for [`PublishAppVersionInput`](crate::input::PublishAppVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishAppVersionInput`](crate::input::PublishAppVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PublishAppVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PublishAppVersionInput {
                app_arn: self.app_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishAppVersionInputOperationOutputAlias = crate::operation::PublishAppVersion;
#[doc(hidden)]
pub type PublishAppVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PublishAppVersionInput {
    /// Consumes the builder and constructs an Operation<[`PublishAppVersion`](crate::operation::PublishAppVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PublishAppVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PublishAppVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/publish-app-version").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PublishAppVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PublishAppVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_publish_app_version(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PublishAppVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PublishAppVersion",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PublishAppVersionInput`](crate::input::PublishAppVersionInput)
    pub fn builder() -> crate::input::publish_app_version_input::Builder {
        crate::input::publish_app_version_input::Builder::default()
    }
}

/// See [`PutDraftAppVersionTemplateInput`](crate::input::PutDraftAppVersionTemplateInput)
pub mod put_draft_app_version_template_input {
    /// A builder for [`PutDraftAppVersionTemplateInput`](crate::input::PutDraftAppVersionTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_template_body: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>A JSON string that contains the body of the app template.</p>
        pub fn app_template_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_template_body = Some(input.into());
            self
        }
        /// <p>A JSON string that contains the body of the app template.</p>
        pub fn set_app_template_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_template_body = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDraftAppVersionTemplateInput`](crate::input::PutDraftAppVersionTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDraftAppVersionTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDraftAppVersionTemplateInput {
                app_arn: self.app_arn,
                app_template_body: self.app_template_body,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDraftAppVersionTemplateInputOperationOutputAlias =
    crate::operation::PutDraftAppVersionTemplate;
#[doc(hidden)]
pub type PutDraftAppVersionTemplateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutDraftAppVersionTemplateInput {
    /// Consumes the builder and constructs an Operation<[`PutDraftAppVersionTemplate`](crate::operation::PutDraftAppVersionTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDraftAppVersionTemplate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutDraftAppVersionTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/put-draft-app-version-template").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutDraftAppVersionTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutDraftAppVersionTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_draft_app_version_template(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDraftAppVersionTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDraftAppVersionTemplate",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutDraftAppVersionTemplateInput`](crate::input::PutDraftAppVersionTemplateInput)
    pub fn builder() -> crate::input::put_draft_app_version_template_input::Builder {
        crate::input::put_draft_app_version_template_input::Builder::default()
    }
}

/// See [`RemoveDraftAppVersionResourceMappingsInput`](crate::input::RemoveDraftAppVersionResourceMappingsInput)
pub mod remove_draft_app_version_resource_mappings_input {
    /// A builder for [`RemoveDraftAppVersionResourceMappingsInput`](crate::input::RemoveDraftAppVersionResourceMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) resource_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) logical_stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) app_registry_app_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// Appends an item to `resource_names`.
        ///
        /// To override the contents of this collection use [`set_resource_names`](Self::set_resource_names).
        ///
        /// <p>The names of the resources to remove from the resource mappings.</p>
        pub fn resource_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_names.unwrap_or_default();
            v.push(input.into());
            self.resource_names = Some(v);
            self
        }
        /// <p>The names of the resources to remove from the resource mappings.</p>
        pub fn set_resource_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_names = input;
            self
        }
        /// Appends an item to `logical_stack_names`.
        ///
        /// To override the contents of this collection use [`set_logical_stack_names`](Self::set_logical_stack_names).
        ///
        /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
        pub fn logical_stack_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.logical_stack_names.unwrap_or_default();
            v.push(input.into());
            self.logical_stack_names = Some(v);
            self
        }
        /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
        pub fn set_logical_stack_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.logical_stack_names = input;
            self
        }
        /// Appends an item to `app_registry_app_names`.
        ///
        /// To override the contents of this collection use [`set_app_registry_app_names`](Self::set_app_registry_app_names).
        ///
        /// <p>The names of the registered applications to remove from the resource mappings.</p>
        pub fn app_registry_app_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.app_registry_app_names.unwrap_or_default();
            v.push(input.into());
            self.app_registry_app_names = Some(v);
            self
        }
        /// <p>The names of the registered applications to remove from the resource mappings.</p>
        pub fn set_app_registry_app_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.app_registry_app_names = input;
            self
        }
        /// Appends an item to `resource_group_names`.
        ///
        /// To override the contents of this collection use [`set_resource_group_names`](Self::set_resource_group_names).
        ///
        /// <p>The names of the resource groups to remove from the resource mappings.</p>
        pub fn resource_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_group_names.unwrap_or_default();
            v.push(input.into());
            self.resource_group_names = Some(v);
            self
        }
        /// <p>The names of the resource groups to remove from the resource mappings.</p>
        pub fn set_resource_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_group_names = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveDraftAppVersionResourceMappingsInput`](crate::input::RemoveDraftAppVersionResourceMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveDraftAppVersionResourceMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveDraftAppVersionResourceMappingsInput {
                app_arn: self.app_arn,
                resource_names: self.resource_names,
                logical_stack_names: self.logical_stack_names,
                app_registry_app_names: self.app_registry_app_names,
                resource_group_names: self.resource_group_names,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveDraftAppVersionResourceMappingsInputOperationOutputAlias =
    crate::operation::RemoveDraftAppVersionResourceMappings;
#[doc(hidden)]
pub type RemoveDraftAppVersionResourceMappingsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl RemoveDraftAppVersionResourceMappingsInput {
    /// Consumes the builder and constructs an Operation<[`RemoveDraftAppVersionResourceMappings`](crate::operation::RemoveDraftAppVersionResourceMappings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveDraftAppVersionResourceMappings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveDraftAppVersionResourceMappingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/remove-draft-app-version-resource-mappings")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveDraftAppVersionResourceMappingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveDraftAppVersionResourceMappingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_draft_app_version_resource_mappings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveDraftAppVersionResourceMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveDraftAppVersionResourceMappings",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveDraftAppVersionResourceMappingsInput`](crate::input::RemoveDraftAppVersionResourceMappingsInput)
    pub fn builder() -> crate::input::remove_draft_app_version_resource_mappings_input::Builder {
        crate::input::remove_draft_app_version_resource_mappings_input::Builder::default()
    }
}

/// See [`ResolveAppVersionResourcesInput`](crate::input::ResolveAppVersionResourcesInput)
pub mod resolve_app_version_resources_input {
    /// A builder for [`ResolveAppVersionResourcesInput`](crate::input::ResolveAppVersionResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveAppVersionResourcesInput`](crate::input::ResolveAppVersionResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResolveAppVersionResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResolveAppVersionResourcesInput {
                app_arn: self.app_arn,
                app_version: self.app_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ResolveAppVersionResourcesInputOperationOutputAlias =
    crate::operation::ResolveAppVersionResources;
#[doc(hidden)]
pub type ResolveAppVersionResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResolveAppVersionResourcesInput {
    /// Consumes the builder and constructs an Operation<[`ResolveAppVersionResources`](crate::operation::ResolveAppVersionResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResolveAppVersionResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResolveAppVersionResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/resolve-app-version-resources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResolveAppVersionResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResolveAppVersionResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_resolve_app_version_resources(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResolveAppVersionResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResolveAppVersionResources",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResolveAppVersionResourcesInput`](crate::input::ResolveAppVersionResourcesInput)
    pub fn builder() -> crate::input::resolve_app_version_resources_input::Builder {
        crate::input::resolve_app_version_resources_input::Builder::default()
    }
}

/// See [`StartAppAssessmentInput`](crate::input::StartAppAssessmentInput)
pub mod start_app_assessment_input {
    /// A builder for [`StartAppAssessmentInput`](crate::input::StartAppAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) app_version: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The version of the application.</p>
        pub fn app_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_version = Some(input.into());
            self
        }
        /// <p>The version of the application.</p>
        pub fn set_app_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_version = input;
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p>The name for the assessment.</p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
        /// You should not reuse the same client token for other API requests.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
        /// Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAppAssessmentInput`](crate::input::StartAppAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartAppAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartAppAssessmentInput {
                app_arn: self.app_arn,
                app_version: self.app_version,
                assessment_name: self.assessment_name,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartAppAssessmentInputOperationOutputAlias = crate::operation::StartAppAssessment;
#[doc(hidden)]
pub type StartAppAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartAppAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`StartAppAssessment`](crate::operation::StartAppAssessment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartAppAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartAppAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/start-app-assessment").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartAppAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartAppAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_app_assessment(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartAppAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartAppAssessment",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartAppAssessmentInput`](crate::input::StartAppAssessmentInput)
    pub fn builder() -> crate::input::start_app_assessment_input::Builder {
        crate::input::start_app_assessment_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.resource_arn;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_28, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.resource_arn;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_29, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_30) = &_input.tag_keys {
                for inner_31 in inner_30 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_31));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAppInput`](crate::input::UpdateAppInput)
pub mod update_app_input {
    /// A builder for [`UpdateAppInput`](crate::input::UpdateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) clear_resiliency_policy_arn: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn app_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_app_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_arn = input;
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for an app.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
        pub fn clear_resiliency_policy_arn(mut self, input: bool) -> Self {
            self.clear_resiliency_policy_arn = Some(input);
            self
        }
        /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
        pub fn set_clear_resiliency_policy_arn(mut self, input: std::option::Option<bool>) -> Self {
            self.clear_resiliency_policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppInput`](crate::input::UpdateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateAppInput {
                app_arn: self.app_arn,
                description: self.description,
                policy_arn: self.policy_arn,
                clear_resiliency_policy_arn: self.clear_resiliency_policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAppInputOperationOutputAlias = crate::operation::UpdateApp;
#[doc(hidden)]
pub type UpdateAppInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAppInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApp`](crate::operation::UpdateApp)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApp,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/update-app").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateApp",
                    "resiliencehub",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAppInput`](crate::input::UpdateAppInput)
    pub fn builder() -> crate::input::update_app_input::Builder {
        crate::input::update_app_input::Builder::default()
    }
}

/// See [`UpdateResiliencyPolicyInput`](crate::input::UpdateResiliencyPolicyInput)
pub mod update_resiliency_policy_input {
    /// A builder for [`UpdateResiliencyPolicyInput`](crate::input::UpdateResiliencyPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_description: std::option::Option<std::string::String>,
        pub(crate) data_location_constraint:
            std::option::Option<crate::model::DataLocationConstraint>,
        pub(crate) tier: std::option::Option<crate::model::ResiliencyPolicyTier>,
        pub(crate) policy: std::option::Option<
            std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
        /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
        /// Amazon Resource Names (ARNs)</a> in the
        /// <i>AWS General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The name of the policy</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The description for the policy.</p>
        pub fn policy_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_description = Some(input.into());
            self
        }
        /// <p>The description for the policy.</p>
        pub fn set_policy_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_description = input;
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy
        /// data can be stored.</p>
        pub fn data_location_constraint(
            mut self,
            input: crate::model::DataLocationConstraint,
        ) -> Self {
            self.data_location_constraint = Some(input);
            self
        }
        /// <p>Specifies a high-level geographical location constraint for where your resilience policy
        /// data can be stored.</p>
        pub fn set_data_location_constraint(
            mut self,
            input: std::option::Option<crate::model::DataLocationConstraint>,
        ) -> Self {
            self.data_location_constraint = input;
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity
        /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn tier(mut self, input: crate::model::ResiliencyPolicyTier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>The tier for this resiliency policy, ranging from the highest severity
        /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
        pub fn set_tier(
            mut self,
            input: std::option::Option<crate::model::ResiliencyPolicyTier>,
        ) -> Self {
            self.tier = input;
            self
        }
        /// Adds a key-value pair to `policy`.
        ///
        /// To override the contents of this collection use [`set_policy`](Self::set_policy).
        ///
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
        /// and recovery point objective (RPO) in seconds.</p>
        pub fn policy(
            mut self,
            k: impl Into<crate::model::DisruptionType>,
            v: impl Into<crate::model::FailurePolicy>,
        ) -> Self {
            let mut hash_map = self.policy.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.policy = Some(hash_map);
            self
        }
        /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
        /// and recovery point objective (RPO) in seconds.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::DisruptionType,
                    crate::model::FailurePolicy,
                >,
            >,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResiliencyPolicyInput`](crate::input::UpdateResiliencyPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResiliencyPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResiliencyPolicyInput {
                policy_arn: self.policy_arn,
                policy_name: self.policy_name,
                policy_description: self.policy_description,
                data_location_constraint: self.data_location_constraint,
                tier: self.tier,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResiliencyPolicyInputOperationOutputAlias = crate::operation::UpdateResiliencyPolicy;
#[doc(hidden)]
pub type UpdateResiliencyPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateResiliencyPolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResiliencyPolicy`](crate::operation::UpdateResiliencyPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResiliencyPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResiliencyPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/update-resiliency-policy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResiliencyPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResiliencyPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_resiliency_policy(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResiliencyPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResiliencyPolicy",
            "resiliencehub",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResiliencyPolicyInput`](crate::input::UpdateResiliencyPolicyInput)
    pub fn builder() -> crate::input::update_resiliency_policy_input::Builder {
        crate::input::update_resiliency_policy_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResiliencyPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The name of the policy</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The description for the policy.</p>
    pub policy_description: std::option::Option<std::string::String>,
    /// <p>Specifies a high-level geographical location constraint for where your resilience policy
    /// data can be stored.</p>
    pub data_location_constraint: std::option::Option<crate::model::DataLocationConstraint>,
    /// <p>The tier for this resiliency policy, ranging from the highest severity
    /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    pub tier: std::option::Option<crate::model::ResiliencyPolicyTier>,
    /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
    /// and recovery point objective (RPO) in seconds.</p>
    pub policy: std::option::Option<
        std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
    >,
}
impl UpdateResiliencyPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The name of the policy</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The description for the policy.</p>
    pub fn policy_description(&self) -> std::option::Option<&str> {
        self.policy_description.as_deref()
    }
    /// <p>Specifies a high-level geographical location constraint for where your resilience policy
    /// data can be stored.</p>
    pub fn data_location_constraint(
        &self,
    ) -> std::option::Option<&crate::model::DataLocationConstraint> {
        self.data_location_constraint.as_ref()
    }
    /// <p>The tier for this resiliency policy, ranging from the highest severity
    /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::ResiliencyPolicyTier> {
        self.tier.as_ref()
    }
    /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
    /// and recovery point objective (RPO) in seconds.</p>
    pub fn policy(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
    > {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for UpdateResiliencyPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResiliencyPolicyInput");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_description", &self.policy_description);
        formatter.field("data_location_constraint", &self.data_location_constraint);
        formatter.field("tier", &self.tier);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The optional description for an app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
    pub clear_resiliency_policy_arn: std::option::Option<bool>,
}
impl UpdateAppInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The optional description for an app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>Specifies if the resiliency policy ARN should be cleared.</p>
    pub fn clear_resiliency_policy_arn(&self) -> std::option::Option<bool> {
        self.clear_resiliency_policy_arn
    }
}
impl std::fmt::Debug for UpdateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("description", &self.description);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field(
            "clear_resiliency_policy_arn",
            &self.clear_resiliency_policy_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAppAssessmentInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The name for the assessment.</p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl StartAppAssessmentInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The name for the assessment.</p>
    pub fn assessment_name(&self) -> std::option::Option<&str> {
        self.assessment_name.as_deref()
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for StartAppAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAppAssessmentInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveAppVersionResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
}
impl ResolveAppVersionResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
}
impl std::fmt::Debug for ResolveAppVersionResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveAppVersionResourcesInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveDraftAppVersionResourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The names of the resources to remove from the resource mappings.</p>
    pub resource_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
    pub logical_stack_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the registered applications to remove from the resource mappings.</p>
    pub app_registry_app_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the resource groups to remove from the resource mappings.</p>
    pub resource_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RemoveDraftAppVersionResourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The names of the resources to remove from the resource mappings.</p>
    pub fn resource_names(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_names.as_deref()
    }
    /// <p>The names of the CloudFormation stacks to remove from the resource mappings.</p>
    pub fn logical_stack_names(&self) -> std::option::Option<&[std::string::String]> {
        self.logical_stack_names.as_deref()
    }
    /// <p>The names of the registered applications to remove from the resource mappings.</p>
    pub fn app_registry_app_names(&self) -> std::option::Option<&[std::string::String]> {
        self.app_registry_app_names.as_deref()
    }
    /// <p>The names of the resource groups to remove from the resource mappings.</p>
    pub fn resource_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.resource_group_names.as_deref()
    }
}
impl std::fmt::Debug for RemoveDraftAppVersionResourceMappingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveDraftAppVersionResourceMappingsInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("resource_names", &self.resource_names);
        formatter.field("logical_stack_names", &self.logical_stack_names);
        formatter.field("app_registry_app_names", &self.app_registry_app_names);
        formatter.field("resource_group_names", &self.resource_group_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDraftAppVersionTemplateInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>A JSON string that contains the body of the app template.</p>
    pub app_template_body: std::option::Option<std::string::String>,
}
impl PutDraftAppVersionTemplateInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>A JSON string that contains the body of the app template.</p>
    pub fn app_template_body(&self) -> std::option::Option<&str> {
        self.app_template_body.as_deref()
    }
}
impl std::fmt::Debug for PutDraftAppVersionTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDraftAppVersionTemplateInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_template_body", &self.app_template_body);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishAppVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
}
impl PublishAppVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
}
impl std::fmt::Debug for PublishAppVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishAppVersionInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUnsupportedAppVersionResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The identifier for a specific resolution.</p>
    pub resolution_id: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListUnsupportedAppVersionResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The identifier for a specific resolution.</p>
    pub fn resolution_id(&self) -> std::option::Option<&str> {
        self.resolution_id.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListUnsupportedAppVersionResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUnsupportedAppVersionResourcesInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("resolution_id", &self.resolution_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTestRecommendationsInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
}
impl ListTestRecommendationsInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTestRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTestRecommendationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub
    /// application.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub
    /// application.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSuggestedResiliencyPoliciesInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListSuggestedResiliencyPoliciesInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListSuggestedResiliencyPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSuggestedResiliencyPoliciesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSopRecommendationsInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
}
impl ListSopRecommendationsInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
}
impl std::fmt::Debug for ListSopRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSopRecommendationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResiliencyPoliciesInput {
    /// <p>The name of the policy</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListResiliencyPoliciesInput {
    /// <p>The name of the policy</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListResiliencyPoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResiliencyPoliciesInput");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendationTemplatesInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>The default is to sort by ascending <b>startTime</b>.
    /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
    pub reverse_order: std::option::Option<bool>,
    /// <p>The status of the action.</p>
    pub status: std::option::Option<std::vec::Vec<crate::model::RecommendationTemplateStatus>>,
    /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    pub recommendation_template_arn: std::option::Option<std::string::String>,
    /// <p>The name for one of the listed recommendation templates.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListRecommendationTemplatesInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>The default is to sort by ascending <b>startTime</b>.
    /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
    pub fn reverse_order(&self) -> std::option::Option<bool> {
        self.reverse_order
    }
    /// <p>The status of the action.</p>
    pub fn status(&self) -> std::option::Option<&[crate::model::RecommendationTemplateStatus]> {
        self.status.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    pub fn recommendation_template_arn(&self) -> std::option::Option<&str> {
        self.recommendation_template_arn.as_deref()
    }
    /// <p>The name for one of the listed recommendation templates.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRecommendationTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendationTemplatesInput");
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.field("status", &self.status);
        formatter.field(
            "recommendation_template_arn",
            &self.recommendation_template_arn,
        );
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppVersionsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAppVersionsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppVersionsInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppVersionResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The identifier for a specific resolution.</p>
    pub resolution_id: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAppVersionResourcesInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The identifier for a specific resolution.</p>
    pub fn resolution_id(&self) -> std::option::Option<&str> {
        self.resolution_id.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppVersionResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppVersionResourcesInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("resolution_id", &self.resolution_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppVersionResourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAppVersionResourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppVersionResourceMappingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppVersionResourceMappingsInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppsInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The name for the one of the listed applications.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
}
impl ListAppsInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The name for the one of the listed applications.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
}
impl std::fmt::Debug for ListAppsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("name", &self.name);
        formatter.field("app_arn", &self.app_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppComponentRecommendationsInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAppComponentRecommendationsInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppComponentRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppComponentRecommendationsInput");
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppComponentCompliancesInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
}
impl ListAppComponentCompliancesInput {
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
}
impl std::fmt::Debug for ListAppComponentCompliancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppComponentCompliancesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppAssessmentsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The name for the assessment.</p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub assessment_status: std::option::Option<std::vec::Vec<crate::model::AssessmentStatus>>,
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub compliance_status: std::option::Option<crate::model::ComplianceStatus>,
    /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
    /// <code>System</code>.</p>
    pub invoker: std::option::Option<crate::model::AssessmentInvoker>,
    /// <p>The default is to sort by ascending <b>startTime</b>.
    /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
    pub reverse_order: std::option::Option<bool>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAppAssessmentsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The name for the assessment.</p>
    pub fn assessment_name(&self) -> std::option::Option<&str> {
        self.assessment_name.as_deref()
    }
    /// <p>The current status of the assessment for the resiliency policy.</p>
    pub fn assessment_status(&self) -> std::option::Option<&[crate::model::AssessmentStatus]> {
        self.assessment_status.as_deref()
    }
    /// <p>The current status of compliance for the resiliency policy.</p>
    pub fn compliance_status(&self) -> std::option::Option<&crate::model::ComplianceStatus> {
        self.compliance_status.as_ref()
    }
    /// <p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
    /// <code>System</code>.</p>
    pub fn invoker(&self) -> std::option::Option<&crate::model::AssessmentInvoker> {
        self.invoker.as_ref()
    }
    /// <p>The default is to sort by ascending <b>startTime</b>.
    /// To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>
    pub fn reverse_order(&self) -> std::option::Option<bool> {
        self.reverse_order
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAppAssessmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppAssessmentsInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("assessment_status", &self.assessment_status);
        formatter.field("compliance_status", &self.compliance_status);
        formatter.field("invoker", &self.invoker);
        formatter.field("reverse_order", &self.reverse_order);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlarmRecommendationsInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAlarmRecommendationsInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>Null, or the token from a previous call to get the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to include in the response. If more results exist than the specified
    /// <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAlarmRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlarmRecommendationsInput");
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportResourcesToDraftAppVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
    pub source_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ImportResourcesToDraftAppVersionInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>
    pub fn source_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.source_arns.as_deref()
    }
}
impl std::fmt::Debug for ImportResourcesToDraftAppVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportResourcesToDraftAppVersionInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("source_arns", &self.source_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResiliencyPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
}
impl DescribeResiliencyPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeResiliencyPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResiliencyPolicyInput");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDraftAppVersionResourcesImportStatusInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
}
impl DescribeDraftAppVersionResourcesImportStatusInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeDraftAppVersionResourcesImportStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDraftAppVersionResourcesImportStatusInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppVersionTemplateInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
}
impl DescribeAppVersionTemplateInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeAppVersionTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppVersionTemplateInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppVersionResourcesResolutionStatusInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>The version of the application.</p>
    pub app_version: std::option::Option<std::string::String>,
    /// <p>The identifier for a specific resolution.</p>
    pub resolution_id: std::option::Option<std::string::String>,
}
impl DescribeAppVersionResourcesResolutionStatusInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>The version of the application.</p>
    pub fn app_version(&self) -> std::option::Option<&str> {
        self.app_version.as_deref()
    }
    /// <p>The identifier for a specific resolution.</p>
    pub fn resolution_id(&self) -> std::option::Option<&str> {
        self.resolution_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeAppVersionResourcesResolutionStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppVersionResourcesResolutionStatusInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("app_version", &self.app_version);
        formatter.field("resolution_id", &self.resolution_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppAssessmentInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
}
impl DescribeAppAssessmentInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAppAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppAssessmentInput");
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
}
impl DescribeAppInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResiliencyPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteResiliencyPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteResiliencyPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResiliencyPolicyInput");
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRecommendationTemplateInput {
    /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    pub recommendation_template_arn: std::option::Option<std::string::String>,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteRecommendationTemplateInput {
    /// <p>The Amazon Resource Name (ARN) for a recommendation template.</p>
    pub fn recommendation_template_arn(&self) -> std::option::Option<&str> {
        self.recommendation_template_arn.as_deref()
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteRecommendationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRecommendationTemplateInput");
        formatter.field(
            "recommendation_template_arn",
            &self.recommendation_template_arn,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppAssessmentInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteAppAssessmentInput {
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppAssessmentInput");
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
    pub force_delete: std::option::Option<bool>,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteAppInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p>A boolean option to force the deletion of a Resilience Hub application. </p>
    pub fn force_delete(&self) -> std::option::Option<bool> {
        self.force_delete
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("force_delete", &self.force_delete);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResiliencyPolicyInput {
    /// <p>The name of the policy</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The description for the policy.</p>
    pub policy_description: std::option::Option<std::string::String>,
    /// <p>Specifies a high-level geographical location constraint for where your resilience policy
    /// data can be stored.</p>
    pub data_location_constraint: std::option::Option<crate::model::DataLocationConstraint>,
    /// <p>The tier for this resiliency policy, ranging from the highest severity
    /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    pub tier: std::option::Option<crate::model::ResiliencyPolicyTier>,
    /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
    /// and recovery point objective (RPO) in seconds.</p>
    pub policy: std::option::Option<
        std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
    >,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateResiliencyPolicyInput {
    /// <p>The name of the policy</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The description for the policy.</p>
    pub fn policy_description(&self) -> std::option::Option<&str> {
        self.policy_description.as_deref()
    }
    /// <p>Specifies a high-level geographical location constraint for where your resilience policy
    /// data can be stored.</p>
    pub fn data_location_constraint(
        &self,
    ) -> std::option::Option<&crate::model::DataLocationConstraint> {
        self.data_location_constraint.as_ref()
    }
    /// <p>The tier for this resiliency policy, ranging from the highest severity
    /// (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::ResiliencyPolicyTier> {
        self.tier.as_ref()
    }
    /// <p>The type of resiliency policy to be created, including the recovery time objective (RTO)
    /// and recovery point objective (RPO) in seconds.</p>
    pub fn policy(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::DisruptionType, crate::model::FailurePolicy>,
    > {
        self.policy.as_ref()
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateResiliencyPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResiliencyPolicyInput");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_description", &self.policy_description);
        formatter.field("data_location_constraint", &self.data_location_constraint);
        formatter.field("tier", &self.tier);
        formatter.field("policy", &self.policy);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRecommendationTemplateInput {
    /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
    pub recommendation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The format for the recommendation template.</p>
    /// <dl>
    /// <dt>CfnJson</dt>
    /// <dd>
    /// <p>The template is CloudFormation JSON.</p>
    /// </dd>
    /// <dt>CfnYaml</dt>
    /// <dd>
    /// <p>The template is CloudFormation YAML.</p>
    /// </dd>
    /// </dl>
    pub format: std::option::Option<crate::model::TemplateFormat>,
    /// <p>An array of strings that specify the recommendation template type or types.</p>
    /// <dl>
    /// <dt>Alarm</dt>
    /// <dd>
    /// <p>The template is an <a>AlarmRecommendation</a> template.</p>
    /// </dd>
    /// <dt>Sop</dt>
    /// <dd>
    /// <p>The template is a <a>SopRecommendation</a> template.</p>
    /// </dd>
    /// <dt>Test</dt>
    /// <dd>
    /// <p>The template is a <a>TestRecommendation</a> template.</p>
    /// </dd>
    /// </dl>
    pub recommendation_types:
        std::option::Option<std::vec::Vec<crate::model::RenderRecommendationType>>,
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub assessment_arn: std::option::Option<std::string::String>,
    /// <p>The name for the recommendation template.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
    pub bucket_name: std::option::Option<std::string::String>,
}
impl CreateRecommendationTemplateInput {
    /// <p>Identifiers for the recommendations used to create a recommendation template.</p>
    pub fn recommendation_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.recommendation_ids.as_deref()
    }
    /// <p>The format for the recommendation template.</p>
    /// <dl>
    /// <dt>CfnJson</dt>
    /// <dd>
    /// <p>The template is CloudFormation JSON.</p>
    /// </dd>
    /// <dt>CfnYaml</dt>
    /// <dd>
    /// <p>The template is CloudFormation YAML.</p>
    /// </dd>
    /// </dl>
    pub fn format(&self) -> std::option::Option<&crate::model::TemplateFormat> {
        self.format.as_ref()
    }
    /// <p>An array of strings that specify the recommendation template type or types.</p>
    /// <dl>
    /// <dt>Alarm</dt>
    /// <dd>
    /// <p>The template is an <a>AlarmRecommendation</a> template.</p>
    /// </dd>
    /// <dt>Sop</dt>
    /// <dd>
    /// <p>The template is a <a>SopRecommendation</a> template.</p>
    /// </dd>
    /// <dt>Test</dt>
    /// <dd>
    /// <p>The template is a <a>TestRecommendation</a> template.</p>
    /// </dd>
    /// </dl>
    pub fn recommendation_types(
        &self,
    ) -> std::option::Option<&[crate::model::RenderRecommendationType]> {
        self.recommendation_types.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn assessment_arn(&self) -> std::option::Option<&str> {
        self.assessment_arn.as_deref()
    }
    /// <p>The name for the recommendation template.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
}
impl std::fmt::Debug for CreateRecommendationTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRecommendationTemplateInput");
        formatter.field("recommendation_ids", &self.recommendation_ids);
        formatter.field("format", &self.format);
        formatter.field("recommendation_types", &self.recommendation_types);
        formatter.field("assessment_arn", &self.assessment_arn);
        formatter.field("name", &self.name);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppInput {
    /// <p>The name for the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The optional description for an app.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateAppInput {
    /// <p>The name for the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The optional description for an app.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
    /// Each tag consists of a key/value pair.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
    /// You should not reuse the same client token for other API requests.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateAppInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("tags", &"*** Sensitive Data Redacted ***");
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddDraftAppVersionResourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub app_arn: std::option::Option<std::string::String>,
    /// <p> Mappings used to map logical resources from the template to physical resources. You can
    /// use the mapping type <code>CFN_STACK</code> if the application template uses
    /// a logical stack name. Or you can map individual resources by using the mapping type
    /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
    /// application is backed by a CloudFormation stack.</p>
    pub resource_mappings: std::option::Option<std::vec::Vec<crate::model::ResourceMapping>>,
}
impl AddDraftAppVersionResourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the application. The format for this ARN is:
    /// arn:<code>partition</code>:dcps:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
    /// Amazon Resource Names (ARNs)</a> in the
    /// <i>AWS General Reference</i>.</p>
    pub fn app_arn(&self) -> std::option::Option<&str> {
        self.app_arn.as_deref()
    }
    /// <p> Mappings used to map logical resources from the template to physical resources. You can
    /// use the mapping type <code>CFN_STACK</code> if the application template uses
    /// a logical stack name. Or you can map individual resources by using the mapping type
    /// <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the
    /// application is backed by a CloudFormation stack.</p>
    pub fn resource_mappings(&self) -> std::option::Option<&[crate::model::ResourceMapping]> {
        self.resource_mappings.as_deref()
    }
}
impl std::fmt::Debug for AddDraftAppVersionResourceMappingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddDraftAppVersionResourceMappingsInput");
        formatter.field("app_arn", &self.app_arn);
        formatter.field("resource_mappings", &self.resource_mappings);
        formatter.finish()
    }
}
