// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p> Describes updates or additions to a dataset. A Single update or addition is an entry (JSON Line) that provides information about a single image. To update an existing entry, you match the <code>source-ref</code> field of the update entry with the <code>source-ref</code> filed of the entry that you want to update. If the <code>source-ref</code> field doesn't match an existing entry, the entry is added to dataset as a new entry. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetChanges {
    /// <p>A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are additions to the dataset. You change a dataset by calling <code>UpdateDatasetEntries</code>. If you are using an AWS SDK to call <code>UpdateDatasetEntries</code>, you don't need to encode <code>Changes</code> as the SDK encodes the data for you. </p>
    /// <p>For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p>
    pub ground_truth: std::option::Option<aws_smithy_types::Blob>,
}
impl DatasetChanges {
    /// <p>A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are additions to the dataset. You change a dataset by calling <code>UpdateDatasetEntries</code>. If you are using an AWS SDK to call <code>UpdateDatasetEntries</code>, you don't need to encode <code>Changes</code> as the SDK encodes the data for you. </p>
    /// <p>For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p>
    pub fn ground_truth(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.ground_truth.as_ref()
    }
}
impl std::fmt::Debug for DatasetChanges {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetChanges");
        formatter.field("ground_truth", &self.ground_truth);
        formatter.finish()
    }
}
/// See [`DatasetChanges`](crate::model::DatasetChanges)
pub mod dataset_changes {
    /// A builder for [`DatasetChanges`](crate::model::DatasetChanges)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ground_truth: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are additions to the dataset. You change a dataset by calling <code>UpdateDatasetEntries</code>. If you are using an AWS SDK to call <code>UpdateDatasetEntries</code>, you don't need to encode <code>Changes</code> as the SDK encodes the data for you. </p>
        /// <p>For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p>
        pub fn ground_truth(mut self, input: aws_smithy_types::Blob) -> Self {
            self.ground_truth = Some(input);
            self
        }
        /// <p>A Base64-encoded binary data object containing one or JSON lines that either update the dataset or are additions to the dataset. You change a dataset by calling <code>UpdateDatasetEntries</code>. If you are using an AWS SDK to call <code>UpdateDatasetEntries</code>, you don't need to encode <code>Changes</code> as the SDK encodes the data for you. </p>
        /// <p>For example JSON lines, see Image-Level labels in manifest files and and Object localization in manifest files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p>
        pub fn set_ground_truth(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.ground_truth = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetChanges`](crate::model::DatasetChanges)
        pub fn build(self) -> crate::model::DatasetChanges {
            crate::model::DatasetChanges {
                ground_truth: self.ground_truth,
            }
        }
    }
}
impl DatasetChanges {
    /// Creates a new builder-style object to manufacture [`DatasetChanges`](crate::model::DatasetChanges)
    pub fn builder() -> crate::model::dataset_changes::Builder {
        crate::model::dataset_changes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProjectVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    TrainingCompleted,
    #[allow(missing_docs)] // documentation missing in model
    TrainingFailed,
    #[allow(missing_docs)] // documentation missing in model
    TrainingInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProjectVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => ProjectVersionStatus::Deleting,
            "FAILED" => ProjectVersionStatus::Failed,
            "RUNNING" => ProjectVersionStatus::Running,
            "STARTING" => ProjectVersionStatus::Starting,
            "STOPPED" => ProjectVersionStatus::Stopped,
            "STOPPING" => ProjectVersionStatus::Stopping,
            "TRAINING_COMPLETED" => ProjectVersionStatus::TrainingCompleted,
            "TRAINING_FAILED" => ProjectVersionStatus::TrainingFailed,
            "TRAINING_IN_PROGRESS" => ProjectVersionStatus::TrainingInProgress,
            other => ProjectVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProjectVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProjectVersionStatus::from(s))
    }
}
impl ProjectVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProjectVersionStatus::Deleting => "DELETING",
            ProjectVersionStatus::Failed => "FAILED",
            ProjectVersionStatus::Running => "RUNNING",
            ProjectVersionStatus::Starting => "STARTING",
            ProjectVersionStatus::Stopped => "STOPPED",
            ProjectVersionStatus::Stopping => "STOPPING",
            ProjectVersionStatus::TrainingCompleted => "TRAINING_COMPLETED",
            ProjectVersionStatus::TrainingFailed => "TRAINING_FAILED",
            ProjectVersionStatus::TrainingInProgress => "TRAINING_IN_PROGRESS",
            ProjectVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETING",
            "FAILED",
            "RUNNING",
            "STARTING",
            "STOPPED",
            "STOPPING",
            "TRAINING_COMPLETED",
            "TRAINING_FAILED",
            "TRAINING_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for ProjectVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Set of optional parameters that let you set the criteria text must meet to be included in your response. <code>WordFilter</code> looks at a word's height, width and minimum confidence. <code>RegionOfInterest</code> lets you set a specific region of the screen to look for text in.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTextDetectionFilters {
    /// <p>Filters focusing on qualities of the text, such as confidence or size.</p>
    pub word_filter: std::option::Option<crate::model::DetectionFilter>,
    /// <p>Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of the screen.</p>
    pub regions_of_interest: std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
}
impl StartTextDetectionFilters {
    /// <p>Filters focusing on qualities of the text, such as confidence or size.</p>
    pub fn word_filter(&self) -> std::option::Option<&crate::model::DetectionFilter> {
        self.word_filter.as_ref()
    }
    /// <p>Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of the screen.</p>
    pub fn regions_of_interest(&self) -> std::option::Option<&[crate::model::RegionOfInterest]> {
        self.regions_of_interest.as_deref()
    }
}
impl std::fmt::Debug for StartTextDetectionFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTextDetectionFilters");
        formatter.field("word_filter", &self.word_filter);
        formatter.field("regions_of_interest", &self.regions_of_interest);
        formatter.finish()
    }
}
/// See [`StartTextDetectionFilters`](crate::model::StartTextDetectionFilters)
pub mod start_text_detection_filters {
    /// A builder for [`StartTextDetectionFilters`](crate::model::StartTextDetectionFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) word_filter: std::option::Option<crate::model::DetectionFilter>,
        pub(crate) regions_of_interest:
            std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
    }
    impl Builder {
        /// <p>Filters focusing on qualities of the text, such as confidence or size.</p>
        pub fn word_filter(mut self, input: crate::model::DetectionFilter) -> Self {
            self.word_filter = Some(input);
            self
        }
        /// <p>Filters focusing on qualities of the text, such as confidence or size.</p>
        pub fn set_word_filter(
            mut self,
            input: std::option::Option<crate::model::DetectionFilter>,
        ) -> Self {
            self.word_filter = input;
            self
        }
        /// Appends an item to `regions_of_interest`.
        ///
        /// To override the contents of this collection use [`set_regions_of_interest`](Self::set_regions_of_interest).
        ///
        /// <p>Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of the screen.</p>
        pub fn regions_of_interest(mut self, input: crate::model::RegionOfInterest) -> Self {
            let mut v = self.regions_of_interest.unwrap_or_default();
            v.push(input);
            self.regions_of_interest = Some(v);
            self
        }
        /// <p>Filter focusing on a certain area of the frame. Uses a <code>BoundingBox</code> object to set the region of the screen.</p>
        pub fn set_regions_of_interest(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
        ) -> Self {
            self.regions_of_interest = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTextDetectionFilters`](crate::model::StartTextDetectionFilters)
        pub fn build(self) -> crate::model::StartTextDetectionFilters {
            crate::model::StartTextDetectionFilters {
                word_filter: self.word_filter,
                regions_of_interest: self.regions_of_interest,
            }
        }
    }
}
impl StartTextDetectionFilters {
    /// Creates a new builder-style object to manufacture [`StartTextDetectionFilters`](crate::model::StartTextDetectionFilters)
    pub fn builder() -> crate::model::start_text_detection_filters::Builder {
        crate::model::start_text_detection_filters::Builder::default()
    }
}

/// <p>Specifies a location within the frame that Rekognition checks for text. Uses a <code>BoundingBox</code> object to set a region of the screen.</p>
/// <p>A word is included in the region if the word is more than half in that region. If there is more than one region, the word will be compared with all regions of the screen. Any word more than half in a region is kept in the results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionOfInterest {
    /// <p>The box representing a region of interest on screen.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
}
impl RegionOfInterest {
    /// <p>The box representing a region of interest on screen.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
}
impl std::fmt::Debug for RegionOfInterest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionOfInterest");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.finish()
    }
}
/// See [`RegionOfInterest`](crate::model::RegionOfInterest)
pub mod region_of_interest {
    /// A builder for [`RegionOfInterest`](crate::model::RegionOfInterest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
    }
    impl Builder {
        /// <p>The box representing a region of interest on screen.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>The box representing a region of interest on screen.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionOfInterest`](crate::model::RegionOfInterest)
        pub fn build(self) -> crate::model::RegionOfInterest {
            crate::model::RegionOfInterest {
                bounding_box: self.bounding_box,
            }
        }
    }
}
impl RegionOfInterest {
    /// Creates a new builder-style object to manufacture [`RegionOfInterest`](crate::model::RegionOfInterest)
    pub fn builder() -> crate::model::region_of_interest::Builder {
        crate::model::region_of_interest::Builder::default()
    }
}

/// <p>Identifies the bounding box around the label, face, text or personal protective equipment. The <code>left</code> (x-coordinate) and <code>top</code> (y-coordinate) are coordinates representing the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0). </p>
/// <p>The <code>top</code> and <code>left</code> values returned are ratios of the overall image size. For example, if the input image is 700x200 pixels, and the top-left coordinate of the bounding box is 350x50 pixels, the API returns a <code>left</code> value of 0.5 (350/700) and a <code>top</code> value of 0.25 (50/200).</p>
/// <p>The <code>width</code> and <code>height</code> values represent the dimensions of the bounding box as a ratio of the overall image dimension. For example, if the input image is 700x200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1. </p> <note>
/// <p> The bounding box coordinates can have negative values. For example, if Amazon Rekognition is able to detect a face that is at the image edge and is only partially visible, the service can return coordinates that are outside the image bounds and, depending on the image edge, you might get negative values or values greater than 1 for the <code>left</code> or <code>top</code> values. </p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BoundingBox {
    /// <p>Width of the bounding box as a ratio of the overall image width.</p>
    pub width: std::option::Option<f32>,
    /// <p>Height of the bounding box as a ratio of the overall image height.</p>
    pub height: std::option::Option<f32>,
    /// <p>Left coordinate of the bounding box as a ratio of overall image width.</p>
    pub left: std::option::Option<f32>,
    /// <p>Top coordinate of the bounding box as a ratio of overall image height.</p>
    pub top: std::option::Option<f32>,
}
impl BoundingBox {
    /// <p>Width of the bounding box as a ratio of the overall image width.</p>
    pub fn width(&self) -> std::option::Option<f32> {
        self.width
    }
    /// <p>Height of the bounding box as a ratio of the overall image height.</p>
    pub fn height(&self) -> std::option::Option<f32> {
        self.height
    }
    /// <p>Left coordinate of the bounding box as a ratio of overall image width.</p>
    pub fn left(&self) -> std::option::Option<f32> {
        self.left
    }
    /// <p>Top coordinate of the bounding box as a ratio of overall image height.</p>
    pub fn top(&self) -> std::option::Option<f32> {
        self.top
    }
}
impl std::fmt::Debug for BoundingBox {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BoundingBox");
        formatter.field("width", &self.width);
        formatter.field("height", &self.height);
        formatter.field("left", &self.left);
        formatter.field("top", &self.top);
        formatter.finish()
    }
}
/// See [`BoundingBox`](crate::model::BoundingBox)
pub mod bounding_box {
    /// A builder for [`BoundingBox`](crate::model::BoundingBox)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) width: std::option::Option<f32>,
        pub(crate) height: std::option::Option<f32>,
        pub(crate) left: std::option::Option<f32>,
        pub(crate) top: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Width of the bounding box as a ratio of the overall image width.</p>
        pub fn width(mut self, input: f32) -> Self {
            self.width = Some(input);
            self
        }
        /// <p>Width of the bounding box as a ratio of the overall image width.</p>
        pub fn set_width(mut self, input: std::option::Option<f32>) -> Self {
            self.width = input;
            self
        }
        /// <p>Height of the bounding box as a ratio of the overall image height.</p>
        pub fn height(mut self, input: f32) -> Self {
            self.height = Some(input);
            self
        }
        /// <p>Height of the bounding box as a ratio of the overall image height.</p>
        pub fn set_height(mut self, input: std::option::Option<f32>) -> Self {
            self.height = input;
            self
        }
        /// <p>Left coordinate of the bounding box as a ratio of overall image width.</p>
        pub fn left(mut self, input: f32) -> Self {
            self.left = Some(input);
            self
        }
        /// <p>Left coordinate of the bounding box as a ratio of overall image width.</p>
        pub fn set_left(mut self, input: std::option::Option<f32>) -> Self {
            self.left = input;
            self
        }
        /// <p>Top coordinate of the bounding box as a ratio of overall image height.</p>
        pub fn top(mut self, input: f32) -> Self {
            self.top = Some(input);
            self
        }
        /// <p>Top coordinate of the bounding box as a ratio of overall image height.</p>
        pub fn set_top(mut self, input: std::option::Option<f32>) -> Self {
            self.top = input;
            self
        }
        /// Consumes the builder and constructs a [`BoundingBox`](crate::model::BoundingBox)
        pub fn build(self) -> crate::model::BoundingBox {
            crate::model::BoundingBox {
                width: self.width,
                height: self.height,
                left: self.left,
                top: self.top,
            }
        }
    }
}
impl BoundingBox {
    /// Creates a new builder-style object to manufacture [`BoundingBox`](crate::model::BoundingBox)
    pub fn builder() -> crate::model::bounding_box::Builder {
        crate::model::bounding_box::Builder::default()
    }
}

/// <p>A set of parameters that allow you to filter out certain results from your returned results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectionFilter {
    /// <p>Sets the confidence of word detection. Words with detection confidence below this will be excluded from the result. Values should be between 50 and 100 as Text in Video will not return any result below 50.</p>
    pub min_confidence: std::option::Option<f32>,
    /// <p>Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value will be excluded from the result. Value is relative to the video frame height.</p>
    pub min_bounding_box_height: std::option::Option<f32>,
    /// <p>Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value will be excluded from the result. Value is relative to the video frame width.</p>
    pub min_bounding_box_width: std::option::Option<f32>,
}
impl DetectionFilter {
    /// <p>Sets the confidence of word detection. Words with detection confidence below this will be excluded from the result. Values should be between 50 and 100 as Text in Video will not return any result below 50.</p>
    pub fn min_confidence(&self) -> std::option::Option<f32> {
        self.min_confidence
    }
    /// <p>Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value will be excluded from the result. Value is relative to the video frame height.</p>
    pub fn min_bounding_box_height(&self) -> std::option::Option<f32> {
        self.min_bounding_box_height
    }
    /// <p>Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value will be excluded from the result. Value is relative to the video frame width.</p>
    pub fn min_bounding_box_width(&self) -> std::option::Option<f32> {
        self.min_bounding_box_width
    }
}
impl std::fmt::Debug for DetectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectionFilter");
        formatter.field("min_confidence", &self.min_confidence);
        formatter.field("min_bounding_box_height", &self.min_bounding_box_height);
        formatter.field("min_bounding_box_width", &self.min_bounding_box_width);
        formatter.finish()
    }
}
/// See [`DetectionFilter`](crate::model::DetectionFilter)
pub mod detection_filter {
    /// A builder for [`DetectionFilter`](crate::model::DetectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_confidence: std::option::Option<f32>,
        pub(crate) min_bounding_box_height: std::option::Option<f32>,
        pub(crate) min_bounding_box_width: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Sets the confidence of word detection. Words with detection confidence below this will be excluded from the result. Values should be between 50 and 100 as Text in Video will not return any result below 50.</p>
        pub fn min_confidence(mut self, input: f32) -> Self {
            self.min_confidence = Some(input);
            self
        }
        /// <p>Sets the confidence of word detection. Words with detection confidence below this will be excluded from the result. Values should be between 50 and 100 as Text in Video will not return any result below 50.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.min_confidence = input;
            self
        }
        /// <p>Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value will be excluded from the result. Value is relative to the video frame height.</p>
        pub fn min_bounding_box_height(mut self, input: f32) -> Self {
            self.min_bounding_box_height = Some(input);
            self
        }
        /// <p>Sets the minimum height of the word bounding box. Words with bounding box heights lesser than this value will be excluded from the result. Value is relative to the video frame height.</p>
        pub fn set_min_bounding_box_height(mut self, input: std::option::Option<f32>) -> Self {
            self.min_bounding_box_height = input;
            self
        }
        /// <p>Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value will be excluded from the result. Value is relative to the video frame width.</p>
        pub fn min_bounding_box_width(mut self, input: f32) -> Self {
            self.min_bounding_box_width = Some(input);
            self
        }
        /// <p>Sets the minimum width of the word bounding box. Words with bounding boxes widths lesser than this value will be excluded from the result. Value is relative to the video frame width.</p>
        pub fn set_min_bounding_box_width(mut self, input: std::option::Option<f32>) -> Self {
            self.min_bounding_box_width = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectionFilter`](crate::model::DetectionFilter)
        pub fn build(self) -> crate::model::DetectionFilter {
            crate::model::DetectionFilter {
                min_confidence: self.min_confidence,
                min_bounding_box_height: self.min_bounding_box_height,
                min_bounding_box_width: self.min_bounding_box_width,
            }
        }
    }
}
impl DetectionFilter {
    /// Creates a new builder-style object to manufacture [`DetectionFilter`](crate::model::DetectionFilter)
    pub fn builder() -> crate::model::detection_filter::Builder {
        crate::model::detection_filter::Builder::default()
    }
}

/// <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see <code>api-video</code>. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics">Giving access to multiple Amazon SNS topics</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationChannel {
    /// <p>The Amazon SNS topic to which Amazon Rekognition to posts the completion status.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic. </p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl NotificationChannel {
    /// <p>The Amazon SNS topic to which Amazon Rekognition to posts the completion status.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for NotificationChannel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationChannel");
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`NotificationChannel`](crate::model::NotificationChannel)
pub mod notification_channel {
    /// A builder for [`NotificationChannel`](crate::model::NotificationChannel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon SNS topic to which Amazon Rekognition to posts the completion status.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon SNS topic to which Amazon Rekognition to posts the completion status.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role that gives Amazon Rekognition publishing permissions to the Amazon SNS topic. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationChannel`](crate::model::NotificationChannel)
        pub fn build(self) -> crate::model::NotificationChannel {
            crate::model::NotificationChannel {
                sns_topic_arn: self.sns_topic_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl NotificationChannel {
    /// Creates a new builder-style object to manufacture [`NotificationChannel`](crate::model::NotificationChannel)
    pub fn builder() -> crate::model::notification_channel::Builder {
        crate::model::notification_channel::Builder::default()
    }
}

/// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <code>StartLabelDetection</code> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Video {
    /// <p>The Amazon S3 bucket name and file name for the video.</p>
    pub s3_object: std::option::Option<crate::model::S3Object>,
}
impl Video {
    /// <p>The Amazon S3 bucket name and file name for the video.</p>
    pub fn s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.s3_object.as_ref()
    }
}
impl std::fmt::Debug for Video {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Video");
        formatter.field("s3_object", &self.s3_object);
        formatter.finish()
    }
}
/// See [`Video`](crate::model::Video)
pub mod video {
    /// A builder for [`Video`](crate::model::Video)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_object: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name and file name for the video.</p>
        pub fn s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.s3_object = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket name and file name for the video.</p>
        pub fn set_s3_object(mut self, input: std::option::Option<crate::model::S3Object>) -> Self {
            self.s3_object = input;
            self
        }
        /// Consumes the builder and constructs a [`Video`](crate::model::Video)
        pub fn build(self) -> crate::model::Video {
            crate::model::Video {
                s3_object: self.s3_object,
            }
        }
    }
}
impl Video {
    /// Creates a new builder-style object to manufacture [`Video`](crate::model::Video)
    pub fn builder() -> crate::model::video::Builder {
        crate::model::video::Builder::default()
    }
}

/// <p>Provides the S3 bucket name and object name.</p>
/// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
/// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Object {
    /// <p>Name of the S3 bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>S3 object key name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If the bucket is versioning enabled, you can specify the object version. </p>
    pub version: std::option::Option<std::string::String>,
}
impl S3Object {
    /// <p>Name of the S3 bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>S3 object key name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If the bucket is versioning enabled, you can specify the object version. </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for S3Object {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Object");
        formatter.field("bucket", &self.bucket);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`S3Object`](crate::model::S3Object)
pub mod s3_object {
    /// A builder for [`S3Object`](crate::model::S3Object)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the S3 bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Name of the S3 bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>S3 object key name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>S3 object key name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If the bucket is versioning enabled, you can specify the object version. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>If the bucket is versioning enabled, you can specify the object version. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Object`](crate::model::S3Object)
        pub fn build(self) -> crate::model::S3Object {
            crate::model::S3Object {
                bucket: self.bucket,
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl S3Object {
    /// Creates a new builder-style object to manufacture [`S3Object`](crate::model::S3Object)
    pub fn builder() -> crate::model::s3_object::Builder {
        crate::model::s3_object::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SegmentType {
    #[allow(missing_docs)] // documentation missing in model
    Shot,
    #[allow(missing_docs)] // documentation missing in model
    TechnicalCue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SegmentType {
    fn from(s: &str) -> Self {
        match s {
            "SHOT" => SegmentType::Shot,
            "TECHNICAL_CUE" => SegmentType::TechnicalCue,
            other => SegmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SegmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SegmentType::from(s))
    }
}
impl SegmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SegmentType::Shot => "SHOT",
            SegmentType::TechnicalCue => "TECHNICAL_CUE",
            SegmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SHOT", "TECHNICAL_CUE"]
    }
}
impl AsRef<str> for SegmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filters applied to the technical cue or shot detection segments. For more information, see <code>StartSegmentDetection</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSegmentDetectionFilters {
    /// <p>Filters that are specific to technical cues.</p>
    pub technical_cue_filter: std::option::Option<crate::model::StartTechnicalCueDetectionFilter>,
    /// <p>Filters that are specific to shot detections.</p>
    pub shot_filter: std::option::Option<crate::model::StartShotDetectionFilter>,
}
impl StartSegmentDetectionFilters {
    /// <p>Filters that are specific to technical cues.</p>
    pub fn technical_cue_filter(
        &self,
    ) -> std::option::Option<&crate::model::StartTechnicalCueDetectionFilter> {
        self.technical_cue_filter.as_ref()
    }
    /// <p>Filters that are specific to shot detections.</p>
    pub fn shot_filter(&self) -> std::option::Option<&crate::model::StartShotDetectionFilter> {
        self.shot_filter.as_ref()
    }
}
impl std::fmt::Debug for StartSegmentDetectionFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSegmentDetectionFilters");
        formatter.field("technical_cue_filter", &self.technical_cue_filter);
        formatter.field("shot_filter", &self.shot_filter);
        formatter.finish()
    }
}
/// See [`StartSegmentDetectionFilters`](crate::model::StartSegmentDetectionFilters)
pub mod start_segment_detection_filters {
    /// A builder for [`StartSegmentDetectionFilters`](crate::model::StartSegmentDetectionFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) technical_cue_filter:
            std::option::Option<crate::model::StartTechnicalCueDetectionFilter>,
        pub(crate) shot_filter: std::option::Option<crate::model::StartShotDetectionFilter>,
    }
    impl Builder {
        /// <p>Filters that are specific to technical cues.</p>
        pub fn technical_cue_filter(
            mut self,
            input: crate::model::StartTechnicalCueDetectionFilter,
        ) -> Self {
            self.technical_cue_filter = Some(input);
            self
        }
        /// <p>Filters that are specific to technical cues.</p>
        pub fn set_technical_cue_filter(
            mut self,
            input: std::option::Option<crate::model::StartTechnicalCueDetectionFilter>,
        ) -> Self {
            self.technical_cue_filter = input;
            self
        }
        /// <p>Filters that are specific to shot detections.</p>
        pub fn shot_filter(mut self, input: crate::model::StartShotDetectionFilter) -> Self {
            self.shot_filter = Some(input);
            self
        }
        /// <p>Filters that are specific to shot detections.</p>
        pub fn set_shot_filter(
            mut self,
            input: std::option::Option<crate::model::StartShotDetectionFilter>,
        ) -> Self {
            self.shot_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSegmentDetectionFilters`](crate::model::StartSegmentDetectionFilters)
        pub fn build(self) -> crate::model::StartSegmentDetectionFilters {
            crate::model::StartSegmentDetectionFilters {
                technical_cue_filter: self.technical_cue_filter,
                shot_filter: self.shot_filter,
            }
        }
    }
}
impl StartSegmentDetectionFilters {
    /// Creates a new builder-style object to manufacture [`StartSegmentDetectionFilters`](crate::model::StartSegmentDetectionFilters)
    pub fn builder() -> crate::model::start_segment_detection_filters::Builder {
        crate::model::start_segment_detection_filters::Builder::default()
    }
}

/// <p>Filters for the shot detection segments returned by <code>GetSegmentDetection</code>. For more information, see <code>StartSegmentDetectionFilters</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartShotDetectionFilter {
    /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
    /// <p>If you don't specify <code>MinSegmentConfidence</code>, the <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
    pub min_segment_confidence: std::option::Option<f32>,
}
impl StartShotDetectionFilter {
    /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
    /// <p>If you don't specify <code>MinSegmentConfidence</code>, the <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
    pub fn min_segment_confidence(&self) -> std::option::Option<f32> {
        self.min_segment_confidence
    }
}
impl std::fmt::Debug for StartShotDetectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartShotDetectionFilter");
        formatter.field("min_segment_confidence", &self.min_segment_confidence);
        formatter.finish()
    }
}
/// See [`StartShotDetectionFilter`](crate::model::StartShotDetectionFilter)
pub mod start_shot_detection_filter {
    /// A builder for [`StartShotDetectionFilter`](crate::model::StartShotDetectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_segment_confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinSegmentConfidence</code>, the <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
        pub fn min_segment_confidence(mut self, input: f32) -> Self {
            self.min_segment_confidence = Some(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinSegmentConfidence</code>, the <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
        pub fn set_min_segment_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.min_segment_confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`StartShotDetectionFilter`](crate::model::StartShotDetectionFilter)
        pub fn build(self) -> crate::model::StartShotDetectionFilter {
            crate::model::StartShotDetectionFilter {
                min_segment_confidence: self.min_segment_confidence,
            }
        }
    }
}
impl StartShotDetectionFilter {
    /// Creates a new builder-style object to manufacture [`StartShotDetectionFilter`](crate::model::StartShotDetectionFilter)
    pub fn builder() -> crate::model::start_shot_detection_filter::Builder {
        crate::model::start_shot_detection_filter::Builder::default()
    }
}

/// <p>Filters for the technical segments returned by <code>GetSegmentDetection</code>. For more information, see <code>StartSegmentDetectionFilters</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTechnicalCueDetectionFilter {
    /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
    /// <p>If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
    pub min_segment_confidence: std::option::Option<f32>,
    /// <p> A filter that allows you to control the black frame detection by specifying the black levels and pixel coverage of black pixels in a frame. Videos can come from multiple sources, formats, and time periods, with different standards and varying noise levels for black frames that need to be accounted for. </p>
    pub black_frame: std::option::Option<crate::model::BlackFrame>,
}
impl StartTechnicalCueDetectionFilter {
    /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
    /// <p>If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
    pub fn min_segment_confidence(&self) -> std::option::Option<f32> {
        self.min_segment_confidence
    }
    /// <p> A filter that allows you to control the black frame detection by specifying the black levels and pixel coverage of black pixels in a frame. Videos can come from multiple sources, formats, and time periods, with different standards and varying noise levels for black frames that need to be accounted for. </p>
    pub fn black_frame(&self) -> std::option::Option<&crate::model::BlackFrame> {
        self.black_frame.as_ref()
    }
}
impl std::fmt::Debug for StartTechnicalCueDetectionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTechnicalCueDetectionFilter");
        formatter.field("min_segment_confidence", &self.min_segment_confidence);
        formatter.field("black_frame", &self.black_frame);
        formatter.finish()
    }
}
/// See [`StartTechnicalCueDetectionFilter`](crate::model::StartTechnicalCueDetectionFilter)
pub mod start_technical_cue_detection_filter {
    /// A builder for [`StartTechnicalCueDetectionFilter`](crate::model::StartTechnicalCueDetectionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_segment_confidence: std::option::Option<f32>,
        pub(crate) black_frame: std::option::Option<crate::model::BlackFrame>,
    }
    impl Builder {
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
        pub fn min_segment_confidence(mut self, input: f32) -> Self {
            self.min_segment_confidence = Some(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected segment. Confidence represents how certain Amazon Rekognition is that a segment is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any segments with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinSegmentConfidence</code>, <code>GetSegmentDetection</code> returns segments with confidence values greater than or equal to 50 percent.</p>
        pub fn set_min_segment_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.min_segment_confidence = input;
            self
        }
        /// <p> A filter that allows you to control the black frame detection by specifying the black levels and pixel coverage of black pixels in a frame. Videos can come from multiple sources, formats, and time periods, with different standards and varying noise levels for black frames that need to be accounted for. </p>
        pub fn black_frame(mut self, input: crate::model::BlackFrame) -> Self {
            self.black_frame = Some(input);
            self
        }
        /// <p> A filter that allows you to control the black frame detection by specifying the black levels and pixel coverage of black pixels in a frame. Videos can come from multiple sources, formats, and time periods, with different standards and varying noise levels for black frames that need to be accounted for. </p>
        pub fn set_black_frame(
            mut self,
            input: std::option::Option<crate::model::BlackFrame>,
        ) -> Self {
            self.black_frame = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTechnicalCueDetectionFilter`](crate::model::StartTechnicalCueDetectionFilter)
        pub fn build(self) -> crate::model::StartTechnicalCueDetectionFilter {
            crate::model::StartTechnicalCueDetectionFilter {
                min_segment_confidence: self.min_segment_confidence,
                black_frame: self.black_frame,
            }
        }
    }
}
impl StartTechnicalCueDetectionFilter {
    /// Creates a new builder-style object to manufacture [`StartTechnicalCueDetectionFilter`](crate::model::StartTechnicalCueDetectionFilter)
    pub fn builder() -> crate::model::start_technical_cue_detection_filter::Builder {
        crate::model::start_technical_cue_detection_filter::Builder::default()
    }
}

/// <p> A filter that allows you to control the black frame detection by specifying the black levels and pixel coverage of black pixels in a frame. As videos can come from multiple sources, formats, and time periods, they may contain different standards and varying noise levels for black frames that need to be accounted for. For more information, see <code>StartSegmentDetection</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlackFrame {
    /// <p> A threshold used to determine the maximum luminance value for a pixel to be considered black. In a full color range video, luminance values range from 0-255. A pixel value of 0 is pure black, and the most strict filter. The maximum black pixel value is computed as follows: max_black_pixel_value = minimum_luminance + MaxPixelThreshold *luminance_range. </p>
    /// <p>For example, for a full range video with BlackPixelThreshold = 0.1, max_black_pixel_value is 0 + 0.1 * (255-0) = 25.5.</p>
    /// <p>The default value of MaxPixelThreshold is 0.2, which maps to a max_black_pixel_value of 51 for a full range video. You can lower this threshold to be more strict on black levels.</p>
    pub max_pixel_threshold: std::option::Option<f32>,
    /// <p> The minimum percentage of pixels in a frame that need to have a luminance below the max_black_pixel_value for a frame to be considered a black frame. Luminance is calculated using the BT.709 matrix. </p>
    /// <p>The default value is 99, which means at least 99% of all pixels in the frame are black pixels as per the <code>MaxPixelThreshold</code> set. You can reduce this value to allow more noise on the black frame.</p>
    pub min_coverage_percentage: std::option::Option<f32>,
}
impl BlackFrame {
    /// <p> A threshold used to determine the maximum luminance value for a pixel to be considered black. In a full color range video, luminance values range from 0-255. A pixel value of 0 is pure black, and the most strict filter. The maximum black pixel value is computed as follows: max_black_pixel_value = minimum_luminance + MaxPixelThreshold *luminance_range. </p>
    /// <p>For example, for a full range video with BlackPixelThreshold = 0.1, max_black_pixel_value is 0 + 0.1 * (255-0) = 25.5.</p>
    /// <p>The default value of MaxPixelThreshold is 0.2, which maps to a max_black_pixel_value of 51 for a full range video. You can lower this threshold to be more strict on black levels.</p>
    pub fn max_pixel_threshold(&self) -> std::option::Option<f32> {
        self.max_pixel_threshold
    }
    /// <p> The minimum percentage of pixels in a frame that need to have a luminance below the max_black_pixel_value for a frame to be considered a black frame. Luminance is calculated using the BT.709 matrix. </p>
    /// <p>The default value is 99, which means at least 99% of all pixels in the frame are black pixels as per the <code>MaxPixelThreshold</code> set. You can reduce this value to allow more noise on the black frame.</p>
    pub fn min_coverage_percentage(&self) -> std::option::Option<f32> {
        self.min_coverage_percentage
    }
}
impl std::fmt::Debug for BlackFrame {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlackFrame");
        formatter.field("max_pixel_threshold", &self.max_pixel_threshold);
        formatter.field("min_coverage_percentage", &self.min_coverage_percentage);
        formatter.finish()
    }
}
/// See [`BlackFrame`](crate::model::BlackFrame)
pub mod black_frame {
    /// A builder for [`BlackFrame`](crate::model::BlackFrame)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_pixel_threshold: std::option::Option<f32>,
        pub(crate) min_coverage_percentage: std::option::Option<f32>,
    }
    impl Builder {
        /// <p> A threshold used to determine the maximum luminance value for a pixel to be considered black. In a full color range video, luminance values range from 0-255. A pixel value of 0 is pure black, and the most strict filter. The maximum black pixel value is computed as follows: max_black_pixel_value = minimum_luminance + MaxPixelThreshold *luminance_range. </p>
        /// <p>For example, for a full range video with BlackPixelThreshold = 0.1, max_black_pixel_value is 0 + 0.1 * (255-0) = 25.5.</p>
        /// <p>The default value of MaxPixelThreshold is 0.2, which maps to a max_black_pixel_value of 51 for a full range video. You can lower this threshold to be more strict on black levels.</p>
        pub fn max_pixel_threshold(mut self, input: f32) -> Self {
            self.max_pixel_threshold = Some(input);
            self
        }
        /// <p> A threshold used to determine the maximum luminance value for a pixel to be considered black. In a full color range video, luminance values range from 0-255. A pixel value of 0 is pure black, and the most strict filter. The maximum black pixel value is computed as follows: max_black_pixel_value = minimum_luminance + MaxPixelThreshold *luminance_range. </p>
        /// <p>For example, for a full range video with BlackPixelThreshold = 0.1, max_black_pixel_value is 0 + 0.1 * (255-0) = 25.5.</p>
        /// <p>The default value of MaxPixelThreshold is 0.2, which maps to a max_black_pixel_value of 51 for a full range video. You can lower this threshold to be more strict on black levels.</p>
        pub fn set_max_pixel_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.max_pixel_threshold = input;
            self
        }
        /// <p> The minimum percentage of pixels in a frame that need to have a luminance below the max_black_pixel_value for a frame to be considered a black frame. Luminance is calculated using the BT.709 matrix. </p>
        /// <p>The default value is 99, which means at least 99% of all pixels in the frame are black pixels as per the <code>MaxPixelThreshold</code> set. You can reduce this value to allow more noise on the black frame.</p>
        pub fn min_coverage_percentage(mut self, input: f32) -> Self {
            self.min_coverage_percentage = Some(input);
            self
        }
        /// <p> The minimum percentage of pixels in a frame that need to have a luminance below the max_black_pixel_value for a frame to be considered a black frame. Luminance is calculated using the BT.709 matrix. </p>
        /// <p>The default value is 99, which means at least 99% of all pixels in the frame are black pixels as per the <code>MaxPixelThreshold</code> set. You can reduce this value to allow more noise on the black frame.</p>
        pub fn set_min_coverage_percentage(mut self, input: std::option::Option<f32>) -> Self {
            self.min_coverage_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`BlackFrame`](crate::model::BlackFrame)
        pub fn build(self) -> crate::model::BlackFrame {
            crate::model::BlackFrame {
                max_pixel_threshold: self.max_pixel_threshold,
                min_coverage_percentage: self.min_coverage_percentage,
            }
        }
    }
}
impl BlackFrame {
    /// Creates a new builder-style object to manufacture [`BlackFrame`](crate::model::BlackFrame)
    pub fn builder() -> crate::model::black_frame::Builder {
        crate::model::black_frame::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FaceAttributes {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FaceAttributes {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => FaceAttributes::All,
            "DEFAULT" => FaceAttributes::Default,
            other => FaceAttributes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FaceAttributes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FaceAttributes::from(s))
    }
}
impl FaceAttributes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FaceAttributes::All => "ALL",
            FaceAttributes::Default => "DEFAULT",
            FaceAttributes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "DEFAULT"]
    }
}
impl AsRef<str> for FaceAttributes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides face metadata. In addition, it also provides the confidence in the match of this face with the input face.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaceMatch {
    /// <p>Confidence in the match of this face with the input face.</p>
    pub similarity: std::option::Option<f32>,
    /// <p>Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image ID that you assigned.</p>
    pub face: std::option::Option<crate::model::Face>,
}
impl FaceMatch {
    /// <p>Confidence in the match of this face with the input face.</p>
    pub fn similarity(&self) -> std::option::Option<f32> {
        self.similarity
    }
    /// <p>Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image ID that you assigned.</p>
    pub fn face(&self) -> std::option::Option<&crate::model::Face> {
        self.face.as_ref()
    }
}
impl std::fmt::Debug for FaceMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaceMatch");
        formatter.field("similarity", &self.similarity);
        formatter.field("face", &self.face);
        formatter.finish()
    }
}
/// See [`FaceMatch`](crate::model::FaceMatch)
pub mod face_match {
    /// A builder for [`FaceMatch`](crate::model::FaceMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) similarity: std::option::Option<f32>,
        pub(crate) face: std::option::Option<crate::model::Face>,
    }
    impl Builder {
        /// <p>Confidence in the match of this face with the input face.</p>
        pub fn similarity(mut self, input: f32) -> Self {
            self.similarity = Some(input);
            self
        }
        /// <p>Confidence in the match of this face with the input face.</p>
        pub fn set_similarity(mut self, input: std::option::Option<f32>) -> Self {
            self.similarity = input;
            self
        }
        /// <p>Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image ID that you assigned.</p>
        pub fn face(mut self, input: crate::model::Face) -> Self {
            self.face = Some(input);
            self
        }
        /// <p>Describes the face properties such as the bounding box, face ID, image ID of the source image, and external image ID that you assigned.</p>
        pub fn set_face(mut self, input: std::option::Option<crate::model::Face>) -> Self {
            self.face = input;
            self
        }
        /// Consumes the builder and constructs a [`FaceMatch`](crate::model::FaceMatch)
        pub fn build(self) -> crate::model::FaceMatch {
            crate::model::FaceMatch {
                similarity: self.similarity,
                face: self.face,
            }
        }
    }
}
impl FaceMatch {
    /// Creates a new builder-style object to manufacture [`FaceMatch`](crate::model::FaceMatch)
    pub fn builder() -> crate::model::face_match::Builder {
        crate::model::face_match::Builder::default()
    }
}

/// <p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Face {
    /// <p>Unique identifier that Amazon Rekognition assigns to the face.</p>
    pub face_id: std::option::Option<std::string::String>,
    /// <p>Bounding box of the face.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>Unique identifier that Amazon Rekognition assigns to the input image.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>Identifier that you assign to all the faces in the input image.</p>
    pub external_image_id: std::option::Option<std::string::String>,
    /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree).</p>
    pub confidence: std::option::Option<f32>,
    /// <p> The version of the face detect and storage model that was used when indexing the face vector. </p>
    pub index_faces_model_version: std::option::Option<std::string::String>,
}
impl Face {
    /// <p>Unique identifier that Amazon Rekognition assigns to the face.</p>
    pub fn face_id(&self) -> std::option::Option<&str> {
        self.face_id.as_deref()
    }
    /// <p>Bounding box of the face.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>Unique identifier that Amazon Rekognition assigns to the input image.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>Identifier that you assign to all the faces in the input image.</p>
    pub fn external_image_id(&self) -> std::option::Option<&str> {
        self.external_image_id.as_deref()
    }
    /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree).</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p> The version of the face detect and storage model that was used when indexing the face vector. </p>
    pub fn index_faces_model_version(&self) -> std::option::Option<&str> {
        self.index_faces_model_version.as_deref()
    }
}
impl std::fmt::Debug for Face {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Face");
        formatter.field("face_id", &self.face_id);
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("image_id", &self.image_id);
        formatter.field("external_image_id", &self.external_image_id);
        formatter.field("confidence", &self.confidence);
        formatter.field("index_faces_model_version", &self.index_faces_model_version);
        formatter.finish()
    }
}
/// See [`Face`](crate::model::Face)
pub mod face {
    /// A builder for [`Face`](crate::model::Face)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) face_id: std::option::Option<std::string::String>,
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) external_image_id: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) index_faces_model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique identifier that Amazon Rekognition assigns to the face.</p>
        pub fn face_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.face_id = Some(input.into());
            self
        }
        /// <p>Unique identifier that Amazon Rekognition assigns to the face.</p>
        pub fn set_face_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.face_id = input;
            self
        }
        /// <p>Bounding box of the face.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>Bounding box of the face.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>Unique identifier that Amazon Rekognition assigns to the input image.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>Unique identifier that Amazon Rekognition assigns to the input image.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>Identifier that you assign to all the faces in the input image.</p>
        pub fn external_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_image_id = Some(input.into());
            self
        }
        /// <p>Identifier that you assign to all the faces in the input image.</p>
        pub fn set_external_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_image_id = input;
            self
        }
        /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree).</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree).</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p> The version of the face detect and storage model that was used when indexing the face vector. </p>
        pub fn index_faces_model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_faces_model_version = Some(input.into());
            self
        }
        /// <p> The version of the face detect and storage model that was used when indexing the face vector. </p>
        pub fn set_index_faces_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.index_faces_model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Face`](crate::model::Face)
        pub fn build(self) -> crate::model::Face {
            crate::model::Face {
                face_id: self.face_id,
                bounding_box: self.bounding_box,
                image_id: self.image_id,
                external_image_id: self.external_image_id,
                confidence: self.confidence,
                index_faces_model_version: self.index_faces_model_version,
            }
        }
    }
}
impl Face {
    /// Creates a new builder-style object to manufacture [`Face`](crate::model::Face)
    pub fn builder() -> crate::model::face::Builder {
        crate::model::face::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QualityFilter {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QualityFilter {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => QualityFilter::Auto,
            "HIGH" => QualityFilter::High,
            "LOW" => QualityFilter::Low,
            "MEDIUM" => QualityFilter::Medium,
            "NONE" => QualityFilter::None,
            other => QualityFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QualityFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QualityFilter::from(s))
    }
}
impl QualityFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QualityFilter::Auto => "AUTO",
            QualityFilter::High => "HIGH",
            QualityFilter::Low => "LOW",
            QualityFilter::Medium => "MEDIUM",
            QualityFilter::None => "NONE",
            QualityFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "HIGH", "LOW", "MEDIUM", "NONE"]
    }
}
impl AsRef<str> for QualityFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the input image either as bytes or an S3 object.</p>
/// <p>You pass image bytes to an Amazon Rekognition API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass an image loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations. </p>
/// <p>For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.</p>
/// <p> You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the <code>S3Object</code> property. Images stored in an S3 bucket do not need to be base64-encoded.</p>
/// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
/// <p>If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.</p>
/// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource Based Policies in the Amazon Rekognition Developer Guide. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Image {
    /// <p>Blob of image bytes up to 5 MBs.</p>
    pub bytes: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Identifies an S3 object as the image source.</p>
    pub s3_object: std::option::Option<crate::model::S3Object>,
}
impl Image {
    /// <p>Blob of image bytes up to 5 MBs.</p>
    pub fn bytes(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.bytes.as_ref()
    }
    /// <p>Identifies an S3 object as the image source.</p>
    pub fn s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.s3_object.as_ref()
    }
}
impl std::fmt::Debug for Image {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Image");
        formatter.field("bytes", &self.bytes);
        formatter.field("s3_object", &self.s3_object);
        formatter.finish()
    }
}
/// See [`Image`](crate::model::Image)
pub mod image {
    /// A builder for [`Image`](crate::model::Image)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bytes: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) s3_object: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>Blob of image bytes up to 5 MBs.</p>
        pub fn bytes(mut self, input: aws_smithy_types::Blob) -> Self {
            self.bytes = Some(input);
            self
        }
        /// <p>Blob of image bytes up to 5 MBs.</p>
        pub fn set_bytes(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.bytes = input;
            self
        }
        /// <p>Identifies an S3 object as the image source.</p>
        pub fn s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.s3_object = Some(input);
            self
        }
        /// <p>Identifies an S3 object as the image source.</p>
        pub fn set_s3_object(mut self, input: std::option::Option<crate::model::S3Object>) -> Self {
            self.s3_object = input;
            self
        }
        /// Consumes the builder and constructs a [`Image`](crate::model::Image)
        pub fn build(self) -> crate::model::Image {
            crate::model::Image {
                bytes: self.bytes,
                s3_object: self.s3_object,
            }
        }
    }
}
impl Image {
    /// Creates a new builder-style object to manufacture [`Image`](crate::model::Image)
    pub fn builder() -> crate::model::image::Builder {
        crate::model::image::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrientationCorrection {
    #[allow(missing_docs)] // documentation missing in model
    Rotate0,
    #[allow(missing_docs)] // documentation missing in model
    Rotate180,
    #[allow(missing_docs)] // documentation missing in model
    Rotate270,
    #[allow(missing_docs)] // documentation missing in model
    Rotate90,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrientationCorrection {
    fn from(s: &str) -> Self {
        match s {
            "ROTATE_0" => OrientationCorrection::Rotate0,
            "ROTATE_180" => OrientationCorrection::Rotate180,
            "ROTATE_270" => OrientationCorrection::Rotate270,
            "ROTATE_90" => OrientationCorrection::Rotate90,
            other => OrientationCorrection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrientationCorrection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrientationCorrection::from(s))
    }
}
impl OrientationCorrection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrientationCorrection::Rotate0 => "ROTATE_0",
            OrientationCorrection::Rotate180 => "ROTATE_180",
            OrientationCorrection::Rotate270 => "ROTATE_270",
            OrientationCorrection::Rotate90 => "ROTATE_90",
            OrientationCorrection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ROTATE_0", "ROTATE_180", "ROTATE_270", "ROTATE_90"]
    }
}
impl AsRef<str> for OrientationCorrection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides face metadata for target image faces that are analyzed by <code>CompareFaces</code> and <code>RecognizeCelebrities</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComparedFace {
    /// <p>Bounding box of the face.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>Level of confidence that what the bounding box contains is a face.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>An array of facial landmarks.</p>
    pub landmarks: std::option::Option<std::vec::Vec<crate::model::Landmark>>,
    /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>
    pub pose: std::option::Option<crate::model::Pose>,
    /// <p>Identifies face image brightness and sharpness. </p>
    pub quality: std::option::Option<crate::model::ImageQuality>,
    /// <p> The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear". </p>
    pub emotions: std::option::Option<std::vec::Vec<crate::model::Emotion>>,
    /// <p> Indicates whether or not the face is smiling, and the confidence level in the determination. </p>
    pub smile: std::option::Option<crate::model::Smile>,
}
impl ComparedFace {
    /// <p>Bounding box of the face.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>Level of confidence that what the bounding box contains is a face.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>An array of facial landmarks.</p>
    pub fn landmarks(&self) -> std::option::Option<&[crate::model::Landmark]> {
        self.landmarks.as_deref()
    }
    /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>
    pub fn pose(&self) -> std::option::Option<&crate::model::Pose> {
        self.pose.as_ref()
    }
    /// <p>Identifies face image brightness and sharpness. </p>
    pub fn quality(&self) -> std::option::Option<&crate::model::ImageQuality> {
        self.quality.as_ref()
    }
    /// <p> The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear". </p>
    pub fn emotions(&self) -> std::option::Option<&[crate::model::Emotion]> {
        self.emotions.as_deref()
    }
    /// <p> Indicates whether or not the face is smiling, and the confidence level in the determination. </p>
    pub fn smile(&self) -> std::option::Option<&crate::model::Smile> {
        self.smile.as_ref()
    }
}
impl std::fmt::Debug for ComparedFace {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComparedFace");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("confidence", &self.confidence);
        formatter.field("landmarks", &self.landmarks);
        formatter.field("pose", &self.pose);
        formatter.field("quality", &self.quality);
        formatter.field("emotions", &self.emotions);
        formatter.field("smile", &self.smile);
        formatter.finish()
    }
}
/// See [`ComparedFace`](crate::model::ComparedFace)
pub mod compared_face {
    /// A builder for [`ComparedFace`](crate::model::ComparedFace)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) landmarks: std::option::Option<std::vec::Vec<crate::model::Landmark>>,
        pub(crate) pose: std::option::Option<crate::model::Pose>,
        pub(crate) quality: std::option::Option<crate::model::ImageQuality>,
        pub(crate) emotions: std::option::Option<std::vec::Vec<crate::model::Emotion>>,
        pub(crate) smile: std::option::Option<crate::model::Smile>,
    }
    impl Builder {
        /// <p>Bounding box of the face.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>Bounding box of the face.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>Level of confidence that what the bounding box contains is a face.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence that what the bounding box contains is a face.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Appends an item to `landmarks`.
        ///
        /// To override the contents of this collection use [`set_landmarks`](Self::set_landmarks).
        ///
        /// <p>An array of facial landmarks.</p>
        pub fn landmarks(mut self, input: crate::model::Landmark) -> Self {
            let mut v = self.landmarks.unwrap_or_default();
            v.push(input);
            self.landmarks = Some(v);
            self
        }
        /// <p>An array of facial landmarks.</p>
        pub fn set_landmarks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Landmark>>,
        ) -> Self {
            self.landmarks = input;
            self
        }
        /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>
        pub fn pose(mut self, input: crate::model::Pose) -> Self {
            self.pose = Some(input);
            self
        }
        /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>
        pub fn set_pose(mut self, input: std::option::Option<crate::model::Pose>) -> Self {
            self.pose = input;
            self
        }
        /// <p>Identifies face image brightness and sharpness. </p>
        pub fn quality(mut self, input: crate::model::ImageQuality) -> Self {
            self.quality = Some(input);
            self
        }
        /// <p>Identifies face image brightness and sharpness. </p>
        pub fn set_quality(
            mut self,
            input: std::option::Option<crate::model::ImageQuality>,
        ) -> Self {
            self.quality = input;
            self
        }
        /// Appends an item to `emotions`.
        ///
        /// To override the contents of this collection use [`set_emotions`](Self::set_emotions).
        ///
        /// <p> The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear". </p>
        pub fn emotions(mut self, input: crate::model::Emotion) -> Self {
            let mut v = self.emotions.unwrap_or_default();
            v.push(input);
            self.emotions = Some(v);
            self
        }
        /// <p> The emotions that appear to be expressed on the face, and the confidence level in the determination. Valid values include "Happy", "Sad", "Angry", "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear". </p>
        pub fn set_emotions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Emotion>>,
        ) -> Self {
            self.emotions = input;
            self
        }
        /// <p> Indicates whether or not the face is smiling, and the confidence level in the determination. </p>
        pub fn smile(mut self, input: crate::model::Smile) -> Self {
            self.smile = Some(input);
            self
        }
        /// <p> Indicates whether or not the face is smiling, and the confidence level in the determination. </p>
        pub fn set_smile(mut self, input: std::option::Option<crate::model::Smile>) -> Self {
            self.smile = input;
            self
        }
        /// Consumes the builder and constructs a [`ComparedFace`](crate::model::ComparedFace)
        pub fn build(self) -> crate::model::ComparedFace {
            crate::model::ComparedFace {
                bounding_box: self.bounding_box,
                confidence: self.confidence,
                landmarks: self.landmarks,
                pose: self.pose,
                quality: self.quality,
                emotions: self.emotions,
                smile: self.smile,
            }
        }
    }
}
impl ComparedFace {
    /// Creates a new builder-style object to manufacture [`ComparedFace`](crate::model::ComparedFace)
    pub fn builder() -> crate::model::compared_face::Builder {
        crate::model::compared_face::Builder::default()
    }
}

/// <p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Smile {
    /// <p>Boolean value that indicates whether the face is smiling or not.</p>
    pub value: bool,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl Smile {
    /// <p>Boolean value that indicates whether the face is smiling or not.</p>
    pub fn value(&self) -> bool {
        self.value
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Smile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Smile");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Smile`](crate::model::Smile)
pub mod smile {
    /// A builder for [`Smile`](crate::model::Smile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<bool>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Boolean value that indicates whether the face is smiling or not.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the face is smiling or not.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Smile`](crate::model::Smile)
        pub fn build(self) -> crate::model::Smile {
            crate::model::Smile {
                value: self.value.unwrap_or_default(),
                confidence: self.confidence,
            }
        }
    }
}
impl Smile {
    /// Creates a new builder-style object to manufacture [`Smile`](crate::model::Smile)
    pub fn builder() -> crate::model::smile::Builder {
        crate::model::smile::Builder::default()
    }
}

/// <p>The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person's face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Emotion {
    /// <p>Type of emotion detected.</p>
    pub r#type: std::option::Option<crate::model::EmotionName>,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl Emotion {
    /// <p>Type of emotion detected.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EmotionName> {
        self.r#type.as_ref()
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Emotion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Emotion");
        formatter.field("r#type", &self.r#type);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Emotion`](crate::model::Emotion)
pub mod emotion {
    /// A builder for [`Emotion`](crate::model::Emotion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::EmotionName>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Type of emotion detected.</p>
        pub fn r#type(mut self, input: crate::model::EmotionName) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of emotion detected.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::EmotionName>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Emotion`](crate::model::Emotion)
        pub fn build(self) -> crate::model::Emotion {
            crate::model::Emotion {
                r#type: self.r#type,
                confidence: self.confidence,
            }
        }
    }
}
impl Emotion {
    /// Creates a new builder-style object to manufacture [`Emotion`](crate::model::Emotion)
    pub fn builder() -> crate::model::emotion::Builder {
        crate::model::emotion::Builder::default()
    }
}

/// _Note: `EmotionName::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EmotionName {
    #[allow(missing_docs)] // documentation missing in model
    Angry,
    #[allow(missing_docs)] // documentation missing in model
    Calm,
    #[allow(missing_docs)] // documentation missing in model
    Confused,
    #[allow(missing_docs)] // documentation missing in model
    Disgusted,
    #[allow(missing_docs)] // documentation missing in model
    Fear,
    #[allow(missing_docs)] // documentation missing in model
    Happy,
    #[allow(missing_docs)] // documentation missing in model
    Sad,
    #[allow(missing_docs)] // documentation missing in model
    Surprised,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EmotionName {
    fn from(s: &str) -> Self {
        match s {
            "ANGRY" => EmotionName::Angry,
            "CALM" => EmotionName::Calm,
            "CONFUSED" => EmotionName::Confused,
            "DISGUSTED" => EmotionName::Disgusted,
            "FEAR" => EmotionName::Fear,
            "HAPPY" => EmotionName::Happy,
            "SAD" => EmotionName::Sad,
            "SURPRISED" => EmotionName::Surprised,
            "UNKNOWN" => EmotionName::UnknownValue,
            other => EmotionName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EmotionName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EmotionName::from(s))
    }
}
impl EmotionName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EmotionName::Angry => "ANGRY",
            EmotionName::Calm => "CALM",
            EmotionName::Confused => "CONFUSED",
            EmotionName::Disgusted => "DISGUSTED",
            EmotionName::Fear => "FEAR",
            EmotionName::Happy => "HAPPY",
            EmotionName::Sad => "SAD",
            EmotionName::Surprised => "SURPRISED",
            EmotionName::UnknownValue => "UNKNOWN",
            EmotionName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANGRY",
            "CALM",
            "CONFUSED",
            "DISGUSTED",
            "FEAR",
            "HAPPY",
            "SAD",
            "SURPRISED",
            "UNKNOWN",
        ]
    }
}
impl AsRef<str> for EmotionName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifies face image brightness and sharpness. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageQuality {
    /// <p>Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a brighter face image.</p>
    pub brightness: std::option::Option<f32>,
    /// <p>Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a sharper face image.</p>
    pub sharpness: std::option::Option<f32>,
}
impl ImageQuality {
    /// <p>Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a brighter face image.</p>
    pub fn brightness(&self) -> std::option::Option<f32> {
        self.brightness
    }
    /// <p>Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a sharper face image.</p>
    pub fn sharpness(&self) -> std::option::Option<f32> {
        self.sharpness
    }
}
impl std::fmt::Debug for ImageQuality {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageQuality");
        formatter.field("brightness", &self.brightness);
        formatter.field("sharpness", &self.sharpness);
        formatter.finish()
    }
}
/// See [`ImageQuality`](crate::model::ImageQuality)
pub mod image_quality {
    /// A builder for [`ImageQuality`](crate::model::ImageQuality)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) brightness: std::option::Option<f32>,
        pub(crate) sharpness: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a brighter face image.</p>
        pub fn brightness(mut self, input: f32) -> Self {
            self.brightness = Some(input);
            self
        }
        /// <p>Value representing brightness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a brighter face image.</p>
        pub fn set_brightness(mut self, input: std::option::Option<f32>) -> Self {
            self.brightness = input;
            self
        }
        /// <p>Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a sharper face image.</p>
        pub fn sharpness(mut self, input: f32) -> Self {
            self.sharpness = Some(input);
            self
        }
        /// <p>Value representing sharpness of the face. The service returns a value between 0 and 100 (inclusive). A higher value indicates a sharper face image.</p>
        pub fn set_sharpness(mut self, input: std::option::Option<f32>) -> Self {
            self.sharpness = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageQuality`](crate::model::ImageQuality)
        pub fn build(self) -> crate::model::ImageQuality {
            crate::model::ImageQuality {
                brightness: self.brightness,
                sharpness: self.sharpness,
            }
        }
    }
}
impl ImageQuality {
    /// Creates a new builder-style object to manufacture [`ImageQuality`](crate::model::ImageQuality)
    pub fn builder() -> crate::model::image_quality::Builder {
        crate::model::image_quality::Builder::default()
    }
}

/// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Pose {
    /// <p>Value representing the face rotation on the roll axis.</p>
    pub roll: std::option::Option<f32>,
    /// <p>Value representing the face rotation on the yaw axis.</p>
    pub yaw: std::option::Option<f32>,
    /// <p>Value representing the face rotation on the pitch axis.</p>
    pub pitch: std::option::Option<f32>,
}
impl Pose {
    /// <p>Value representing the face rotation on the roll axis.</p>
    pub fn roll(&self) -> std::option::Option<f32> {
        self.roll
    }
    /// <p>Value representing the face rotation on the yaw axis.</p>
    pub fn yaw(&self) -> std::option::Option<f32> {
        self.yaw
    }
    /// <p>Value representing the face rotation on the pitch axis.</p>
    pub fn pitch(&self) -> std::option::Option<f32> {
        self.pitch
    }
}
impl std::fmt::Debug for Pose {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Pose");
        formatter.field("roll", &self.roll);
        formatter.field("yaw", &self.yaw);
        formatter.field("pitch", &self.pitch);
        formatter.finish()
    }
}
/// See [`Pose`](crate::model::Pose)
pub mod pose {
    /// A builder for [`Pose`](crate::model::Pose)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) roll: std::option::Option<f32>,
        pub(crate) yaw: std::option::Option<f32>,
        pub(crate) pitch: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Value representing the face rotation on the roll axis.</p>
        pub fn roll(mut self, input: f32) -> Self {
            self.roll = Some(input);
            self
        }
        /// <p>Value representing the face rotation on the roll axis.</p>
        pub fn set_roll(mut self, input: std::option::Option<f32>) -> Self {
            self.roll = input;
            self
        }
        /// <p>Value representing the face rotation on the yaw axis.</p>
        pub fn yaw(mut self, input: f32) -> Self {
            self.yaw = Some(input);
            self
        }
        /// <p>Value representing the face rotation on the yaw axis.</p>
        pub fn set_yaw(mut self, input: std::option::Option<f32>) -> Self {
            self.yaw = input;
            self
        }
        /// <p>Value representing the face rotation on the pitch axis.</p>
        pub fn pitch(mut self, input: f32) -> Self {
            self.pitch = Some(input);
            self
        }
        /// <p>Value representing the face rotation on the pitch axis.</p>
        pub fn set_pitch(mut self, input: std::option::Option<f32>) -> Self {
            self.pitch = input;
            self
        }
        /// Consumes the builder and constructs a [`Pose`](crate::model::Pose)
        pub fn build(self) -> crate::model::Pose {
            crate::model::Pose {
                roll: self.roll,
                yaw: self.yaw,
                pitch: self.pitch,
            }
        }
    }
}
impl Pose {
    /// Creates a new builder-style object to manufacture [`Pose`](crate::model::Pose)
    pub fn builder() -> crate::model::pose::Builder {
        crate::model::pose::Builder::default()
    }
}

/// <p>Indicates the location of the landmark on the face.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Landmark {
    /// <p>Type of landmark.</p>
    pub r#type: std::option::Option<crate::model::LandmarkType>,
    /// <p>The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is measured from the left-side of the image. For example, if the image is 700 pixels wide and the x-coordinate of the landmark is at 350 pixels, this value is 0.5. </p>
    pub x: std::option::Option<f32>,
    /// <p>The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is measured from the top of the image. For example, if the image height is 200 pixels and the y-coordinate of the landmark is at 50 pixels, this value is 0.25.</p>
    pub y: std::option::Option<f32>,
}
impl Landmark {
    /// <p>Type of landmark.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::LandmarkType> {
        self.r#type.as_ref()
    }
    /// <p>The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is measured from the left-side of the image. For example, if the image is 700 pixels wide and the x-coordinate of the landmark is at 350 pixels, this value is 0.5. </p>
    pub fn x(&self) -> std::option::Option<f32> {
        self.x
    }
    /// <p>The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is measured from the top of the image. For example, if the image height is 200 pixels and the y-coordinate of the landmark is at 50 pixels, this value is 0.25.</p>
    pub fn y(&self) -> std::option::Option<f32> {
        self.y
    }
}
impl std::fmt::Debug for Landmark {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Landmark");
        formatter.field("r#type", &self.r#type);
        formatter.field("x", &self.x);
        formatter.field("y", &self.y);
        formatter.finish()
    }
}
/// See [`Landmark`](crate::model::Landmark)
pub mod landmark {
    /// A builder for [`Landmark`](crate::model::Landmark)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::LandmarkType>,
        pub(crate) x: std::option::Option<f32>,
        pub(crate) y: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Type of landmark.</p>
        pub fn r#type(mut self, input: crate::model::LandmarkType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of landmark.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::LandmarkType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is measured from the left-side of the image. For example, if the image is 700 pixels wide and the x-coordinate of the landmark is at 350 pixels, this value is 0.5. </p>
        pub fn x(mut self, input: f32) -> Self {
            self.x = Some(input);
            self
        }
        /// <p>The x-coordinate of the landmark expressed as a ratio of the width of the image. The x-coordinate is measured from the left-side of the image. For example, if the image is 700 pixels wide and the x-coordinate of the landmark is at 350 pixels, this value is 0.5. </p>
        pub fn set_x(mut self, input: std::option::Option<f32>) -> Self {
            self.x = input;
            self
        }
        /// <p>The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is measured from the top of the image. For example, if the image height is 200 pixels and the y-coordinate of the landmark is at 50 pixels, this value is 0.25.</p>
        pub fn y(mut self, input: f32) -> Self {
            self.y = Some(input);
            self
        }
        /// <p>The y-coordinate of the landmark expressed as a ratio of the height of the image. The y-coordinate is measured from the top of the image. For example, if the image height is 200 pixels and the y-coordinate of the landmark is at 50 pixels, this value is 0.25.</p>
        pub fn set_y(mut self, input: std::option::Option<f32>) -> Self {
            self.y = input;
            self
        }
        /// Consumes the builder and constructs a [`Landmark`](crate::model::Landmark)
        pub fn build(self) -> crate::model::Landmark {
            crate::model::Landmark {
                r#type: self.r#type,
                x: self.x,
                y: self.y,
            }
        }
    }
}
impl Landmark {
    /// Creates a new builder-style object to manufacture [`Landmark`](crate::model::Landmark)
    pub fn builder() -> crate::model::landmark::Builder {
        crate::model::landmark::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LandmarkType {
    #[allow(missing_docs)] // documentation missing in model
    ChinBottom,
    #[allow(missing_docs)] // documentation missing in model
    EyeLeft,
    #[allow(missing_docs)] // documentation missing in model
    EyeRight,
    #[allow(missing_docs)] // documentation missing in model
    LeftEyeBrowLeft,
    #[allow(missing_docs)] // documentation missing in model
    LeftEyeBrowRight,
    #[allow(missing_docs)] // documentation missing in model
    LeftEyeBrowUp,
    #[allow(missing_docs)] // documentation missing in model
    LeftEyeDown,
    #[allow(missing_docs)] // documentation missing in model
    LeftEyeLeft,
    #[allow(missing_docs)] // documentation missing in model
    LeftEyeRight,
    #[allow(missing_docs)] // documentation missing in model
    LeftEyeUp,
    #[allow(missing_docs)] // documentation missing in model
    LeftPupil,
    #[allow(missing_docs)] // documentation missing in model
    MidJawlineLeft,
    #[allow(missing_docs)] // documentation missing in model
    MidJawlineRight,
    #[allow(missing_docs)] // documentation missing in model
    MouthDown,
    #[allow(missing_docs)] // documentation missing in model
    MouthLeft,
    #[allow(missing_docs)] // documentation missing in model
    MouthRight,
    #[allow(missing_docs)] // documentation missing in model
    MouthUp,
    #[allow(missing_docs)] // documentation missing in model
    Nose,
    #[allow(missing_docs)] // documentation missing in model
    NoseLeft,
    #[allow(missing_docs)] // documentation missing in model
    NoseRight,
    #[allow(missing_docs)] // documentation missing in model
    RightEyeBrowLeft,
    #[allow(missing_docs)] // documentation missing in model
    RightEyeBrowRight,
    #[allow(missing_docs)] // documentation missing in model
    RightEyeBrowUp,
    #[allow(missing_docs)] // documentation missing in model
    RightEyeDown,
    #[allow(missing_docs)] // documentation missing in model
    RightEyeLeft,
    #[allow(missing_docs)] // documentation missing in model
    RightEyeRight,
    #[allow(missing_docs)] // documentation missing in model
    RightEyeUp,
    #[allow(missing_docs)] // documentation missing in model
    RightPupil,
    #[allow(missing_docs)] // documentation missing in model
    UpperJawlineLeft,
    #[allow(missing_docs)] // documentation missing in model
    UpperJawlineRight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LandmarkType {
    fn from(s: &str) -> Self {
        match s {
            "chinBottom" => LandmarkType::ChinBottom,
            "eyeLeft" => LandmarkType::EyeLeft,
            "eyeRight" => LandmarkType::EyeRight,
            "leftEyeBrowLeft" => LandmarkType::LeftEyeBrowLeft,
            "leftEyeBrowRight" => LandmarkType::LeftEyeBrowRight,
            "leftEyeBrowUp" => LandmarkType::LeftEyeBrowUp,
            "leftEyeDown" => LandmarkType::LeftEyeDown,
            "leftEyeLeft" => LandmarkType::LeftEyeLeft,
            "leftEyeRight" => LandmarkType::LeftEyeRight,
            "leftEyeUp" => LandmarkType::LeftEyeUp,
            "leftPupil" => LandmarkType::LeftPupil,
            "midJawlineLeft" => LandmarkType::MidJawlineLeft,
            "midJawlineRight" => LandmarkType::MidJawlineRight,
            "mouthDown" => LandmarkType::MouthDown,
            "mouthLeft" => LandmarkType::MouthLeft,
            "mouthRight" => LandmarkType::MouthRight,
            "mouthUp" => LandmarkType::MouthUp,
            "nose" => LandmarkType::Nose,
            "noseLeft" => LandmarkType::NoseLeft,
            "noseRight" => LandmarkType::NoseRight,
            "rightEyeBrowLeft" => LandmarkType::RightEyeBrowLeft,
            "rightEyeBrowRight" => LandmarkType::RightEyeBrowRight,
            "rightEyeBrowUp" => LandmarkType::RightEyeBrowUp,
            "rightEyeDown" => LandmarkType::RightEyeDown,
            "rightEyeLeft" => LandmarkType::RightEyeLeft,
            "rightEyeRight" => LandmarkType::RightEyeRight,
            "rightEyeUp" => LandmarkType::RightEyeUp,
            "rightPupil" => LandmarkType::RightPupil,
            "upperJawlineLeft" => LandmarkType::UpperJawlineLeft,
            "upperJawlineRight" => LandmarkType::UpperJawlineRight,
            other => LandmarkType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LandmarkType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LandmarkType::from(s))
    }
}
impl LandmarkType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LandmarkType::ChinBottom => "chinBottom",
            LandmarkType::EyeLeft => "eyeLeft",
            LandmarkType::EyeRight => "eyeRight",
            LandmarkType::LeftEyeBrowLeft => "leftEyeBrowLeft",
            LandmarkType::LeftEyeBrowRight => "leftEyeBrowRight",
            LandmarkType::LeftEyeBrowUp => "leftEyeBrowUp",
            LandmarkType::LeftEyeDown => "leftEyeDown",
            LandmarkType::LeftEyeLeft => "leftEyeLeft",
            LandmarkType::LeftEyeRight => "leftEyeRight",
            LandmarkType::LeftEyeUp => "leftEyeUp",
            LandmarkType::LeftPupil => "leftPupil",
            LandmarkType::MidJawlineLeft => "midJawlineLeft",
            LandmarkType::MidJawlineRight => "midJawlineRight",
            LandmarkType::MouthDown => "mouthDown",
            LandmarkType::MouthLeft => "mouthLeft",
            LandmarkType::MouthRight => "mouthRight",
            LandmarkType::MouthUp => "mouthUp",
            LandmarkType::Nose => "nose",
            LandmarkType::NoseLeft => "noseLeft",
            LandmarkType::NoseRight => "noseRight",
            LandmarkType::RightEyeBrowLeft => "rightEyeBrowLeft",
            LandmarkType::RightEyeBrowRight => "rightEyeBrowRight",
            LandmarkType::RightEyeBrowUp => "rightEyeBrowUp",
            LandmarkType::RightEyeDown => "rightEyeDown",
            LandmarkType::RightEyeLeft => "rightEyeLeft",
            LandmarkType::RightEyeRight => "rightEyeRight",
            LandmarkType::RightEyeUp => "rightEyeUp",
            LandmarkType::RightPupil => "rightPupil",
            LandmarkType::UpperJawlineLeft => "upperJawlineLeft",
            LandmarkType::UpperJawlineRight => "upperJawlineRight",
            LandmarkType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "chinBottom",
            "eyeLeft",
            "eyeRight",
            "leftEyeBrowLeft",
            "leftEyeBrowRight",
            "leftEyeBrowUp",
            "leftEyeDown",
            "leftEyeLeft",
            "leftEyeRight",
            "leftEyeUp",
            "leftPupil",
            "midJawlineLeft",
            "midJawlineRight",
            "mouthDown",
            "mouthLeft",
            "mouthRight",
            "mouthUp",
            "nose",
            "noseLeft",
            "noseRight",
            "rightEyeBrowLeft",
            "rightEyeBrowRight",
            "rightEyeBrowUp",
            "rightEyeDown",
            "rightEyeLeft",
            "rightEyeRight",
            "rightEyeUp",
            "rightPupil",
            "upperJawlineLeft",
            "upperJawlineRight",
        ]
    }
}
impl AsRef<str> for LandmarkType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a celebrity recognized by the <code>RecognizeCelebrities</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Celebrity {
    /// <p>An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.</p>
    pub urls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the celebrity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the celebrity. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Provides information about the celebrity's face, such as its location on the image.</p>
    pub face: std::option::Option<crate::model::ComparedFace>,
    /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.</p>
    pub match_confidence: std::option::Option<f32>,
    /// <p>The known gender identity for the celebrity that matches the provided ID. The known gender identity can be Male, Female, Nonbinary, or Unlisted.</p>
    pub known_gender: std::option::Option<crate::model::KnownGender>,
}
impl Celebrity {
    /// <p>An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.</p>
    pub fn urls(&self) -> std::option::Option<&[std::string::String]> {
        self.urls.as_deref()
    }
    /// <p>The name of the celebrity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A unique identifier for the celebrity. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Provides information about the celebrity's face, such as its location on the image.</p>
    pub fn face(&self) -> std::option::Option<&crate::model::ComparedFace> {
        self.face.as_ref()
    }
    /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.</p>
    pub fn match_confidence(&self) -> std::option::Option<f32> {
        self.match_confidence
    }
    /// <p>The known gender identity for the celebrity that matches the provided ID. The known gender identity can be Male, Female, Nonbinary, or Unlisted.</p>
    pub fn known_gender(&self) -> std::option::Option<&crate::model::KnownGender> {
        self.known_gender.as_ref()
    }
}
impl std::fmt::Debug for Celebrity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Celebrity");
        formatter.field("urls", &self.urls);
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("face", &self.face);
        formatter.field("match_confidence", &self.match_confidence);
        formatter.field("known_gender", &self.known_gender);
        formatter.finish()
    }
}
/// See [`Celebrity`](crate::model::Celebrity)
pub mod celebrity {
    /// A builder for [`Celebrity`](crate::model::Celebrity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) urls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) face: std::option::Option<crate::model::ComparedFace>,
        pub(crate) match_confidence: std::option::Option<f32>,
        pub(crate) known_gender: std::option::Option<crate::model::KnownGender>,
    }
    impl Builder {
        /// Appends an item to `urls`.
        ///
        /// To override the contents of this collection use [`set_urls`](Self::set_urls).
        ///
        /// <p>An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.</p>
        pub fn urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.urls.unwrap_or_default();
            v.push(input.into());
            self.urls = Some(v);
            self
        }
        /// <p>An array of URLs pointing to additional information about the celebrity. If there is no additional information about the celebrity, this list is empty.</p>
        pub fn set_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.urls = input;
            self
        }
        /// <p>The name of the celebrity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the celebrity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A unique identifier for the celebrity. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the celebrity. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Provides information about the celebrity's face, such as its location on the image.</p>
        pub fn face(mut self, input: crate::model::ComparedFace) -> Self {
            self.face = Some(input);
            self
        }
        /// <p>Provides information about the celebrity's face, such as its location on the image.</p>
        pub fn set_face(mut self, input: std::option::Option<crate::model::ComparedFace>) -> Self {
            self.face = input;
            self
        }
        /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.</p>
        pub fn match_confidence(mut self, input: f32) -> Self {
            self.match_confidence = Some(input);
            self
        }
        /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity.</p>
        pub fn set_match_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.match_confidence = input;
            self
        }
        /// <p>The known gender identity for the celebrity that matches the provided ID. The known gender identity can be Male, Female, Nonbinary, or Unlisted.</p>
        pub fn known_gender(mut self, input: crate::model::KnownGender) -> Self {
            self.known_gender = Some(input);
            self
        }
        /// <p>The known gender identity for the celebrity that matches the provided ID. The known gender identity can be Male, Female, Nonbinary, or Unlisted.</p>
        pub fn set_known_gender(
            mut self,
            input: std::option::Option<crate::model::KnownGender>,
        ) -> Self {
            self.known_gender = input;
            self
        }
        /// Consumes the builder and constructs a [`Celebrity`](crate::model::Celebrity)
        pub fn build(self) -> crate::model::Celebrity {
            crate::model::Celebrity {
                urls: self.urls,
                name: self.name,
                id: self.id,
                face: self.face,
                match_confidence: self.match_confidence,
                known_gender: self.known_gender,
            }
        }
    }
}
impl Celebrity {
    /// Creates a new builder-style object to manufacture [`Celebrity`](crate::model::Celebrity)
    pub fn builder() -> crate::model::celebrity::Builder {
        crate::model::celebrity::Builder::default()
    }
}

/// <p>The known gender identity for the celebrity that matches the provided ID. The known gender identity can be Male, Female, Nonbinary, or Unlisted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KnownGender {
    /// <p>A string value of the KnownGender info about the Celebrity.</p>
    pub r#type: std::option::Option<crate::model::KnownGenderType>,
}
impl KnownGender {
    /// <p>A string value of the KnownGender info about the Celebrity.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::KnownGenderType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for KnownGender {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KnownGender");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`KnownGender`](crate::model::KnownGender)
pub mod known_gender {
    /// A builder for [`KnownGender`](crate::model::KnownGender)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::KnownGenderType>,
    }
    impl Builder {
        /// <p>A string value of the KnownGender info about the Celebrity.</p>
        pub fn r#type(mut self, input: crate::model::KnownGenderType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>A string value of the KnownGender info about the Celebrity.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::KnownGenderType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`KnownGender`](crate::model::KnownGender)
        pub fn build(self) -> crate::model::KnownGender {
            crate::model::KnownGender {
                r#type: self.r#type,
            }
        }
    }
}
impl KnownGender {
    /// Creates a new builder-style object to manufacture [`KnownGender`](crate::model::KnownGender)
    pub fn builder() -> crate::model::known_gender::Builder {
        crate::model::known_gender::Builder::default()
    }
}

/// <p>A list of enum string of possible gender values that Celebrity returns.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KnownGenderType {
    #[allow(missing_docs)] // documentation missing in model
    Female,
    #[allow(missing_docs)] // documentation missing in model
    Male,
    #[allow(missing_docs)] // documentation missing in model
    Nonbinary,
    #[allow(missing_docs)] // documentation missing in model
    Unlisted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KnownGenderType {
    fn from(s: &str) -> Self {
        match s {
            "Female" => KnownGenderType::Female,
            "Male" => KnownGenderType::Male,
            "Nonbinary" => KnownGenderType::Nonbinary,
            "Unlisted" => KnownGenderType::Unlisted,
            other => KnownGenderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KnownGenderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KnownGenderType::from(s))
    }
}
impl KnownGenderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KnownGenderType::Female => "Female",
            KnownGenderType::Male => "Male",
            KnownGenderType::Nonbinary => "Nonbinary",
            KnownGenderType::Unlisted => "Unlisted",
            KnownGenderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Female", "Male", "Nonbinary", "Unlisted"]
    }
}
impl AsRef<str> for KnownGenderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that recognizes faces in a streaming video. An Amazon Rekognition stream processor is created by a call to <code>CreateStreamProcessor</code>. The request parameters for <code>CreateStreamProcessor</code> describe the Kinesis video stream source for the streaming video, face recognition parameters, and where to stream the analysis resullts. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamProcessor {
    /// <p>Name of the Amazon Rekognition stream processor. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Current status of the Amazon Rekognition stream processor.</p>
    pub status: std::option::Option<crate::model::StreamProcessorStatus>,
}
impl StreamProcessor {
    /// <p>Name of the Amazon Rekognition stream processor. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Current status of the Amazon Rekognition stream processor.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StreamProcessorStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StreamProcessor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamProcessor");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StreamProcessor`](crate::model::StreamProcessor)
pub mod stream_processor {
    /// A builder for [`StreamProcessor`](crate::model::StreamProcessor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StreamProcessorStatus>,
    }
    impl Builder {
        /// <p>Name of the Amazon Rekognition stream processor. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon Rekognition stream processor. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Current status of the Amazon Rekognition stream processor.</p>
        pub fn status(mut self, input: crate::model::StreamProcessorStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Current status of the Amazon Rekognition stream processor.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamProcessor`](crate::model::StreamProcessor)
        pub fn build(self) -> crate::model::StreamProcessor {
            crate::model::StreamProcessor {
                name: self.name,
                status: self.status,
            }
        }
    }
}
impl StreamProcessor {
    /// Creates a new builder-style object to manufacture [`StreamProcessor`](crate::model::StreamProcessor)
    pub fn builder() -> crate::model::stream_processor::Builder {
        crate::model::stream_processor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamProcessorStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamProcessorStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => StreamProcessorStatus::Failed,
            "RUNNING" => StreamProcessorStatus::Running,
            "STARTING" => StreamProcessorStatus::Starting,
            "STOPPED" => StreamProcessorStatus::Stopped,
            "STOPPING" => StreamProcessorStatus::Stopping,
            other => StreamProcessorStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamProcessorStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamProcessorStatus::from(s))
    }
}
impl StreamProcessorStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamProcessorStatus::Failed => "FAILED",
            StreamProcessorStatus::Running => "RUNNING",
            StreamProcessorStatus::Starting => "STARTING",
            StreamProcessorStatus::Stopped => "STOPPED",
            StreamProcessorStatus::Stopping => "STOPPING",
            StreamProcessorStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "RUNNING", "STARTING", "STOPPED", "STOPPING"]
    }
}
impl AsRef<str> for StreamProcessorStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Describes a dataset label. For more information, see <code>ListDatasetLabels</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetLabelDescription {
    /// <p> The name of the label. </p>
    pub label_name: std::option::Option<std::string::String>,
    /// <p> Statistics about the label. </p>
    pub label_stats: std::option::Option<crate::model::DatasetLabelStats>,
}
impl DatasetLabelDescription {
    /// <p> The name of the label. </p>
    pub fn label_name(&self) -> std::option::Option<&str> {
        self.label_name.as_deref()
    }
    /// <p> Statistics about the label. </p>
    pub fn label_stats(&self) -> std::option::Option<&crate::model::DatasetLabelStats> {
        self.label_stats.as_ref()
    }
}
impl std::fmt::Debug for DatasetLabelDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetLabelDescription");
        formatter.field("label_name", &self.label_name);
        formatter.field("label_stats", &self.label_stats);
        formatter.finish()
    }
}
/// See [`DatasetLabelDescription`](crate::model::DatasetLabelDescription)
pub mod dataset_label_description {
    /// A builder for [`DatasetLabelDescription`](crate::model::DatasetLabelDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) label_name: std::option::Option<std::string::String>,
        pub(crate) label_stats: std::option::Option<crate::model::DatasetLabelStats>,
    }
    impl Builder {
        /// <p> The name of the label. </p>
        pub fn label_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.label_name = Some(input.into());
            self
        }
        /// <p> The name of the label. </p>
        pub fn set_label_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label_name = input;
            self
        }
        /// <p> Statistics about the label. </p>
        pub fn label_stats(mut self, input: crate::model::DatasetLabelStats) -> Self {
            self.label_stats = Some(input);
            self
        }
        /// <p> Statistics about the label. </p>
        pub fn set_label_stats(
            mut self,
            input: std::option::Option<crate::model::DatasetLabelStats>,
        ) -> Self {
            self.label_stats = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetLabelDescription`](crate::model::DatasetLabelDescription)
        pub fn build(self) -> crate::model::DatasetLabelDescription {
            crate::model::DatasetLabelDescription {
                label_name: self.label_name,
                label_stats: self.label_stats,
            }
        }
    }
}
impl DatasetLabelDescription {
    /// Creates a new builder-style object to manufacture [`DatasetLabelDescription`](crate::model::DatasetLabelDescription)
    pub fn builder() -> crate::model::dataset_label_description::Builder {
        crate::model::dataset_label_description::Builder::default()
    }
}

/// <p> Statistics about a label used in a dataset. For more information, see <code>DatasetLabelDescription</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetLabelStats {
    /// <p> The total number of images that use the label. </p>
    pub entry_count: std::option::Option<i32>,
    /// <p> The total number of images that have the label assigned to a bounding box. </p>
    pub bounding_box_count: std::option::Option<i32>,
}
impl DatasetLabelStats {
    /// <p> The total number of images that use the label. </p>
    pub fn entry_count(&self) -> std::option::Option<i32> {
        self.entry_count
    }
    /// <p> The total number of images that have the label assigned to a bounding box. </p>
    pub fn bounding_box_count(&self) -> std::option::Option<i32> {
        self.bounding_box_count
    }
}
impl std::fmt::Debug for DatasetLabelStats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetLabelStats");
        formatter.field("entry_count", &self.entry_count);
        formatter.field("bounding_box_count", &self.bounding_box_count);
        formatter.finish()
    }
}
/// See [`DatasetLabelStats`](crate::model::DatasetLabelStats)
pub mod dataset_label_stats {
    /// A builder for [`DatasetLabelStats`](crate::model::DatasetLabelStats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entry_count: std::option::Option<i32>,
        pub(crate) bounding_box_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The total number of images that use the label. </p>
        pub fn entry_count(mut self, input: i32) -> Self {
            self.entry_count = Some(input);
            self
        }
        /// <p> The total number of images that use the label. </p>
        pub fn set_entry_count(mut self, input: std::option::Option<i32>) -> Self {
            self.entry_count = input;
            self
        }
        /// <p> The total number of images that have the label assigned to a bounding box. </p>
        pub fn bounding_box_count(mut self, input: i32) -> Self {
            self.bounding_box_count = Some(input);
            self
        }
        /// <p> The total number of images that have the label assigned to a bounding box. </p>
        pub fn set_bounding_box_count(mut self, input: std::option::Option<i32>) -> Self {
            self.bounding_box_count = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetLabelStats`](crate::model::DatasetLabelStats)
        pub fn build(self) -> crate::model::DatasetLabelStats {
            crate::model::DatasetLabelStats {
                entry_count: self.entry_count,
                bounding_box_count: self.bounding_box_count,
            }
        }
    }
}
impl DatasetLabelStats {
    /// Creates a new builder-style object to manufacture [`DatasetLabelStats`](crate::model::DatasetLabelStats)
    pub fn builder() -> crate::model::dataset_label_stats::Builder {
        crate::model::dataset_label_stats::Builder::default()
    }
}

/// <p>A face that <code>IndexFaces</code> detected, but didn't index. Use the <code>Reasons</code> response attribute to determine why a face wasn't indexed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnindexedFace {
    /// <p>An array of reasons that specify why a face wasn't indexed. </p>
    /// <ul>
    /// <li> <p>EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from the camera.</p> </li>
    /// <li> <p>EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.</p> </li>
    /// <li> <p>LOW_BRIGHTNESS - The image is too dark.</p> </li>
    /// <li> <p>LOW_SHARPNESS - The image is too blurry.</p> </li>
    /// <li> <p>LOW_CONFIDENCE - The face was detected with a low confidence.</p> </li>
    /// <li> <p>SMALL_BOUNDING_BOX - The bounding box around the face is too small.</p> </li>
    /// </ul>
    pub reasons: std::option::Option<std::vec::Vec<crate::model::Reason>>,
    /// <p>The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index. </p>
    pub face_detail: std::option::Option<crate::model::FaceDetail>,
}
impl UnindexedFace {
    /// <p>An array of reasons that specify why a face wasn't indexed. </p>
    /// <ul>
    /// <li> <p>EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from the camera.</p> </li>
    /// <li> <p>EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.</p> </li>
    /// <li> <p>LOW_BRIGHTNESS - The image is too dark.</p> </li>
    /// <li> <p>LOW_SHARPNESS - The image is too blurry.</p> </li>
    /// <li> <p>LOW_CONFIDENCE - The face was detected with a low confidence.</p> </li>
    /// <li> <p>SMALL_BOUNDING_BOX - The bounding box around the face is too small.</p> </li>
    /// </ul>
    pub fn reasons(&self) -> std::option::Option<&[crate::model::Reason]> {
        self.reasons.as_deref()
    }
    /// <p>The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index. </p>
    pub fn face_detail(&self) -> std::option::Option<&crate::model::FaceDetail> {
        self.face_detail.as_ref()
    }
}
impl std::fmt::Debug for UnindexedFace {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnindexedFace");
        formatter.field("reasons", &self.reasons);
        formatter.field("face_detail", &self.face_detail);
        formatter.finish()
    }
}
/// See [`UnindexedFace`](crate::model::UnindexedFace)
pub mod unindexed_face {
    /// A builder for [`UnindexedFace`](crate::model::UnindexedFace)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reasons: std::option::Option<std::vec::Vec<crate::model::Reason>>,
        pub(crate) face_detail: std::option::Option<crate::model::FaceDetail>,
    }
    impl Builder {
        /// Appends an item to `reasons`.
        ///
        /// To override the contents of this collection use [`set_reasons`](Self::set_reasons).
        ///
        /// <p>An array of reasons that specify why a face wasn't indexed. </p>
        /// <ul>
        /// <li> <p>EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from the camera.</p> </li>
        /// <li> <p>EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.</p> </li>
        /// <li> <p>LOW_BRIGHTNESS - The image is too dark.</p> </li>
        /// <li> <p>LOW_SHARPNESS - The image is too blurry.</p> </li>
        /// <li> <p>LOW_CONFIDENCE - The face was detected with a low confidence.</p> </li>
        /// <li> <p>SMALL_BOUNDING_BOX - The bounding box around the face is too small.</p> </li>
        /// </ul>
        pub fn reasons(mut self, input: crate::model::Reason) -> Self {
            let mut v = self.reasons.unwrap_or_default();
            v.push(input);
            self.reasons = Some(v);
            self
        }
        /// <p>An array of reasons that specify why a face wasn't indexed. </p>
        /// <ul>
        /// <li> <p>EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from the camera.</p> </li>
        /// <li> <p>EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the <code>MaxFaces</code> input parameter for <code>IndexFaces</code>.</p> </li>
        /// <li> <p>LOW_BRIGHTNESS - The image is too dark.</p> </li>
        /// <li> <p>LOW_SHARPNESS - The image is too blurry.</p> </li>
        /// <li> <p>LOW_CONFIDENCE - The face was detected with a low confidence.</p> </li>
        /// <li> <p>SMALL_BOUNDING_BOX - The bounding box around the face is too small.</p> </li>
        /// </ul>
        pub fn set_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Reason>>,
        ) -> Self {
            self.reasons = input;
            self
        }
        /// <p>The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index. </p>
        pub fn face_detail(mut self, input: crate::model::FaceDetail) -> Self {
            self.face_detail = Some(input);
            self
        }
        /// <p>The structure that contains attributes of a face that <code>IndexFaces</code>detected, but didn't index. </p>
        pub fn set_face_detail(
            mut self,
            input: std::option::Option<crate::model::FaceDetail>,
        ) -> Self {
            self.face_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`UnindexedFace`](crate::model::UnindexedFace)
        pub fn build(self) -> crate::model::UnindexedFace {
            crate::model::UnindexedFace {
                reasons: self.reasons,
                face_detail: self.face_detail,
            }
        }
    }
}
impl UnindexedFace {
    /// Creates a new builder-style object to manufacture [`UnindexedFace`](crate::model::UnindexedFace)
    pub fn builder() -> crate::model::unindexed_face::Builder {
        crate::model::unindexed_face::Builder::default()
    }
}

/// <p>Structure containing attributes of the face that the algorithm detected.</p>
/// <p>A <code>FaceDetail</code> object contains either the default facial attributes or all facial attributes. The default attributes are <code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>.</p>
/// <p> <code>GetFaceDetection</code> is the only Amazon Rekognition Video stored video operation that can return a <code>FaceDetail</code> object with all attributes. To specify which attributes to return, use the <code>FaceAttributes</code> input parameter for <code>StartFaceDetection</code>. The following Amazon Rekognition Video operations return only the default attributes. The corresponding Start operations don't have a <code>FaceAttributes</code> input parameter.</p>
/// <ul>
/// <li> <p>GetCelebrityRecognition</p> </li>
/// <li> <p>GetPersonTracking</p> </li>
/// <li> <p>GetFaceSearch</p> </li>
/// </ul>
/// <p>The Amazon Rekognition Image <code>DetectFaces</code> and <code>IndexFaces</code> operations can return all facial attributes. To specify which attributes to return, use the <code>Attributes</code> input parameter for <code>DetectFaces</code>. For <code>IndexFaces</code>, use the <code>DetectAttributes</code> input parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaceDetail {
    /// <p>Bounding box of the face. Default attribute.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.</p>
    pub age_range: std::option::Option<crate::model::AgeRange>,
    /// <p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>
    pub smile: std::option::Option<crate::model::Smile>,
    /// <p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>
    pub eyeglasses: std::option::Option<crate::model::Eyeglasses>,
    /// <p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>
    pub sunglasses: std::option::Option<crate::model::Sunglasses>,
    /// <p>The predicted gender of a detected face. </p>
    pub gender: std::option::Option<crate::model::Gender>,
    /// <p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>
    pub beard: std::option::Option<crate::model::Beard>,
    /// <p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>
    pub mustache: std::option::Option<crate::model::Mustache>,
    /// <p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>
    pub eyes_open: std::option::Option<crate::model::EyeOpen>,
    /// <p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>
    pub mouth_open: std::option::Option<crate::model::MouthOpen>,
    /// <p>The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person's face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.</p>
    pub emotions: std::option::Option<std::vec::Vec<crate::model::Emotion>>,
    /// <p>Indicates the location of landmarks on the face. Default attribute.</p>
    pub landmarks: std::option::Option<std::vec::Vec<crate::model::Landmark>>,
    /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw. Default attribute.</p>
    pub pose: std::option::Option<crate::model::Pose>,
    /// <p>Identifies image brightness and sharpness. Default attribute.</p>
    pub quality: std::option::Option<crate::model::ImageQuality>,
    /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree). Default attribute.</p>
    pub confidence: std::option::Option<f32>,
}
impl FaceDetail {
    /// <p>Bounding box of the face. Default attribute.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.</p>
    pub fn age_range(&self) -> std::option::Option<&crate::model::AgeRange> {
        self.age_range.as_ref()
    }
    /// <p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>
    pub fn smile(&self) -> std::option::Option<&crate::model::Smile> {
        self.smile.as_ref()
    }
    /// <p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>
    pub fn eyeglasses(&self) -> std::option::Option<&crate::model::Eyeglasses> {
        self.eyeglasses.as_ref()
    }
    /// <p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>
    pub fn sunglasses(&self) -> std::option::Option<&crate::model::Sunglasses> {
        self.sunglasses.as_ref()
    }
    /// <p>The predicted gender of a detected face. </p>
    pub fn gender(&self) -> std::option::Option<&crate::model::Gender> {
        self.gender.as_ref()
    }
    /// <p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>
    pub fn beard(&self) -> std::option::Option<&crate::model::Beard> {
        self.beard.as_ref()
    }
    /// <p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>
    pub fn mustache(&self) -> std::option::Option<&crate::model::Mustache> {
        self.mustache.as_ref()
    }
    /// <p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>
    pub fn eyes_open(&self) -> std::option::Option<&crate::model::EyeOpen> {
        self.eyes_open.as_ref()
    }
    /// <p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>
    pub fn mouth_open(&self) -> std::option::Option<&crate::model::MouthOpen> {
        self.mouth_open.as_ref()
    }
    /// <p>The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person's face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.</p>
    pub fn emotions(&self) -> std::option::Option<&[crate::model::Emotion]> {
        self.emotions.as_deref()
    }
    /// <p>Indicates the location of landmarks on the face. Default attribute.</p>
    pub fn landmarks(&self) -> std::option::Option<&[crate::model::Landmark]> {
        self.landmarks.as_deref()
    }
    /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw. Default attribute.</p>
    pub fn pose(&self) -> std::option::Option<&crate::model::Pose> {
        self.pose.as_ref()
    }
    /// <p>Identifies image brightness and sharpness. Default attribute.</p>
    pub fn quality(&self) -> std::option::Option<&crate::model::ImageQuality> {
        self.quality.as_ref()
    }
    /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree). Default attribute.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for FaceDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaceDetail");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("age_range", &self.age_range);
        formatter.field("smile", &self.smile);
        formatter.field("eyeglasses", &self.eyeglasses);
        formatter.field("sunglasses", &self.sunglasses);
        formatter.field("gender", &self.gender);
        formatter.field("beard", &self.beard);
        formatter.field("mustache", &self.mustache);
        formatter.field("eyes_open", &self.eyes_open);
        formatter.field("mouth_open", &self.mouth_open);
        formatter.field("emotions", &self.emotions);
        formatter.field("landmarks", &self.landmarks);
        formatter.field("pose", &self.pose);
        formatter.field("quality", &self.quality);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`FaceDetail`](crate::model::FaceDetail)
pub mod face_detail {
    /// A builder for [`FaceDetail`](crate::model::FaceDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) age_range: std::option::Option<crate::model::AgeRange>,
        pub(crate) smile: std::option::Option<crate::model::Smile>,
        pub(crate) eyeglasses: std::option::Option<crate::model::Eyeglasses>,
        pub(crate) sunglasses: std::option::Option<crate::model::Sunglasses>,
        pub(crate) gender: std::option::Option<crate::model::Gender>,
        pub(crate) beard: std::option::Option<crate::model::Beard>,
        pub(crate) mustache: std::option::Option<crate::model::Mustache>,
        pub(crate) eyes_open: std::option::Option<crate::model::EyeOpen>,
        pub(crate) mouth_open: std::option::Option<crate::model::MouthOpen>,
        pub(crate) emotions: std::option::Option<std::vec::Vec<crate::model::Emotion>>,
        pub(crate) landmarks: std::option::Option<std::vec::Vec<crate::model::Landmark>>,
        pub(crate) pose: std::option::Option<crate::model::Pose>,
        pub(crate) quality: std::option::Option<crate::model::ImageQuality>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Bounding box of the face. Default attribute.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>Bounding box of the face. Default attribute.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.</p>
        pub fn age_range(mut self, input: crate::model::AgeRange) -> Self {
            self.age_range = Some(input);
            self
        }
        /// <p>The estimated age range, in years, for the face. Low represents the lowest estimated age and High represents the highest estimated age.</p>
        pub fn set_age_range(mut self, input: std::option::Option<crate::model::AgeRange>) -> Self {
            self.age_range = input;
            self
        }
        /// <p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>
        pub fn smile(mut self, input: crate::model::Smile) -> Self {
            self.smile = Some(input);
            self
        }
        /// <p>Indicates whether or not the face is smiling, and the confidence level in the determination.</p>
        pub fn set_smile(mut self, input: std::option::Option<crate::model::Smile>) -> Self {
            self.smile = input;
            self
        }
        /// <p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>
        pub fn eyeglasses(mut self, input: crate::model::Eyeglasses) -> Self {
            self.eyeglasses = Some(input);
            self
        }
        /// <p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>
        pub fn set_eyeglasses(
            mut self,
            input: std::option::Option<crate::model::Eyeglasses>,
        ) -> Self {
            self.eyeglasses = input;
            self
        }
        /// <p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>
        pub fn sunglasses(mut self, input: crate::model::Sunglasses) -> Self {
            self.sunglasses = Some(input);
            self
        }
        /// <p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>
        pub fn set_sunglasses(
            mut self,
            input: std::option::Option<crate::model::Sunglasses>,
        ) -> Self {
            self.sunglasses = input;
            self
        }
        /// <p>The predicted gender of a detected face. </p>
        pub fn gender(mut self, input: crate::model::Gender) -> Self {
            self.gender = Some(input);
            self
        }
        /// <p>The predicted gender of a detected face. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.gender = input;
            self
        }
        /// <p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>
        pub fn beard(mut self, input: crate::model::Beard) -> Self {
            self.beard = Some(input);
            self
        }
        /// <p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>
        pub fn set_beard(mut self, input: std::option::Option<crate::model::Beard>) -> Self {
            self.beard = input;
            self
        }
        /// <p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>
        pub fn mustache(mut self, input: crate::model::Mustache) -> Self {
            self.mustache = Some(input);
            self
        }
        /// <p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>
        pub fn set_mustache(mut self, input: std::option::Option<crate::model::Mustache>) -> Self {
            self.mustache = input;
            self
        }
        /// <p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>
        pub fn eyes_open(mut self, input: crate::model::EyeOpen) -> Self {
            self.eyes_open = Some(input);
            self
        }
        /// <p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>
        pub fn set_eyes_open(mut self, input: std::option::Option<crate::model::EyeOpen>) -> Self {
            self.eyes_open = input;
            self
        }
        /// <p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>
        pub fn mouth_open(mut self, input: crate::model::MouthOpen) -> Self {
            self.mouth_open = Some(input);
            self
        }
        /// <p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>
        pub fn set_mouth_open(
            mut self,
            input: std::option::Option<crate::model::MouthOpen>,
        ) -> Self {
            self.mouth_open = input;
            self
        }
        /// Appends an item to `emotions`.
        ///
        /// To override the contents of this collection use [`set_emotions`](Self::set_emotions).
        ///
        /// <p>The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person's face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.</p>
        pub fn emotions(mut self, input: crate::model::Emotion) -> Self {
            let mut v = self.emotions.unwrap_or_default();
            v.push(input);
            self.emotions = Some(v);
            self
        }
        /// <p>The emotions that appear to be expressed on the face, and the confidence level in the determination. The API is only making a determination of the physical appearance of a person's face. It is not a determination of the person’s internal emotional state and should not be used in such a way. For example, a person pretending to have a sad face might not be sad emotionally.</p>
        pub fn set_emotions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Emotion>>,
        ) -> Self {
            self.emotions = input;
            self
        }
        /// Appends an item to `landmarks`.
        ///
        /// To override the contents of this collection use [`set_landmarks`](Self::set_landmarks).
        ///
        /// <p>Indicates the location of landmarks on the face. Default attribute.</p>
        pub fn landmarks(mut self, input: crate::model::Landmark) -> Self {
            let mut v = self.landmarks.unwrap_or_default();
            v.push(input);
            self.landmarks = Some(v);
            self
        }
        /// <p>Indicates the location of landmarks on the face. Default attribute.</p>
        pub fn set_landmarks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Landmark>>,
        ) -> Self {
            self.landmarks = input;
            self
        }
        /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw. Default attribute.</p>
        pub fn pose(mut self, input: crate::model::Pose) -> Self {
            self.pose = Some(input);
            self
        }
        /// <p>Indicates the pose of the face as determined by its pitch, roll, and yaw. Default attribute.</p>
        pub fn set_pose(mut self, input: std::option::Option<crate::model::Pose>) -> Self {
            self.pose = input;
            self
        }
        /// <p>Identifies image brightness and sharpness. Default attribute.</p>
        pub fn quality(mut self, input: crate::model::ImageQuality) -> Self {
            self.quality = Some(input);
            self
        }
        /// <p>Identifies image brightness and sharpness. Default attribute.</p>
        pub fn set_quality(
            mut self,
            input: std::option::Option<crate::model::ImageQuality>,
        ) -> Self {
            self.quality = input;
            self
        }
        /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree). Default attribute.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Confidence level that the bounding box contains a face (and not a different object such as a tree). Default attribute.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`FaceDetail`](crate::model::FaceDetail)
        pub fn build(self) -> crate::model::FaceDetail {
            crate::model::FaceDetail {
                bounding_box: self.bounding_box,
                age_range: self.age_range,
                smile: self.smile,
                eyeglasses: self.eyeglasses,
                sunglasses: self.sunglasses,
                gender: self.gender,
                beard: self.beard,
                mustache: self.mustache,
                eyes_open: self.eyes_open,
                mouth_open: self.mouth_open,
                emotions: self.emotions,
                landmarks: self.landmarks,
                pose: self.pose,
                quality: self.quality,
                confidence: self.confidence,
            }
        }
    }
}
impl FaceDetail {
    /// Creates a new builder-style object to manufacture [`FaceDetail`](crate::model::FaceDetail)
    pub fn builder() -> crate::model::face_detail::Builder {
        crate::model::face_detail::Builder::default()
    }
}

/// <p>Indicates whether or not the mouth on the face is open, and the confidence level in the determination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MouthOpen {
    /// <p>Boolean value that indicates whether the mouth on the face is open or not.</p>
    pub value: bool,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl MouthOpen {
    /// <p>Boolean value that indicates whether the mouth on the face is open or not.</p>
    pub fn value(&self) -> bool {
        self.value
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for MouthOpen {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MouthOpen");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`MouthOpen`](crate::model::MouthOpen)
pub mod mouth_open {
    /// A builder for [`MouthOpen`](crate::model::MouthOpen)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<bool>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Boolean value that indicates whether the mouth on the face is open or not.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the mouth on the face is open or not.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`MouthOpen`](crate::model::MouthOpen)
        pub fn build(self) -> crate::model::MouthOpen {
            crate::model::MouthOpen {
                value: self.value.unwrap_or_default(),
                confidence: self.confidence,
            }
        }
    }
}
impl MouthOpen {
    /// Creates a new builder-style object to manufacture [`MouthOpen`](crate::model::MouthOpen)
    pub fn builder() -> crate::model::mouth_open::Builder {
        crate::model::mouth_open::Builder::default()
    }
}

/// <p>Indicates whether or not the eyes on the face are open, and the confidence level in the determination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EyeOpen {
    /// <p>Boolean value that indicates whether the eyes on the face are open.</p>
    pub value: bool,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl EyeOpen {
    /// <p>Boolean value that indicates whether the eyes on the face are open.</p>
    pub fn value(&self) -> bool {
        self.value
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for EyeOpen {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EyeOpen");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`EyeOpen`](crate::model::EyeOpen)
pub mod eye_open {
    /// A builder for [`EyeOpen`](crate::model::EyeOpen)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<bool>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Boolean value that indicates whether the eyes on the face are open.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the eyes on the face are open.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`EyeOpen`](crate::model::EyeOpen)
        pub fn build(self) -> crate::model::EyeOpen {
            crate::model::EyeOpen {
                value: self.value.unwrap_or_default(),
                confidence: self.confidence,
            }
        }
    }
}
impl EyeOpen {
    /// Creates a new builder-style object to manufacture [`EyeOpen`](crate::model::EyeOpen)
    pub fn builder() -> crate::model::eye_open::Builder {
        crate::model::eye_open::Builder::default()
    }
}

/// <p>Indicates whether or not the face has a mustache, and the confidence level in the determination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Mustache {
    /// <p>Boolean value that indicates whether the face has mustache or not.</p>
    pub value: bool,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl Mustache {
    /// <p>Boolean value that indicates whether the face has mustache or not.</p>
    pub fn value(&self) -> bool {
        self.value
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Mustache {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Mustache");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Mustache`](crate::model::Mustache)
pub mod mustache {
    /// A builder for [`Mustache`](crate::model::Mustache)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<bool>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Boolean value that indicates whether the face has mustache or not.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the face has mustache or not.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Mustache`](crate::model::Mustache)
        pub fn build(self) -> crate::model::Mustache {
            crate::model::Mustache {
                value: self.value.unwrap_or_default(),
                confidence: self.confidence,
            }
        }
    }
}
impl Mustache {
    /// Creates a new builder-style object to manufacture [`Mustache`](crate::model::Mustache)
    pub fn builder() -> crate::model::mustache::Builder {
        crate::model::mustache::Builder::default()
    }
}

/// <p>Indicates whether or not the face has a beard, and the confidence level in the determination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Beard {
    /// <p>Boolean value that indicates whether the face has beard or not.</p>
    pub value: bool,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl Beard {
    /// <p>Boolean value that indicates whether the face has beard or not.</p>
    pub fn value(&self) -> bool {
        self.value
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Beard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Beard");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Beard`](crate::model::Beard)
pub mod beard {
    /// A builder for [`Beard`](crate::model::Beard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<bool>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Boolean value that indicates whether the face has beard or not.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the face has beard or not.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Beard`](crate::model::Beard)
        pub fn build(self) -> crate::model::Beard {
            crate::model::Beard {
                value: self.value.unwrap_or_default(),
                confidence: self.confidence,
            }
        }
    }
}
impl Beard {
    /// Creates a new builder-style object to manufacture [`Beard`](crate::model::Beard)
    pub fn builder() -> crate::model::beard::Builder {
        crate::model::beard::Builder::default()
    }
}

/// <p>The predicted gender of a detected face. </p>
/// <p>Amazon Rekognition makes gender binary (male/female) predictions based on the physical appearance of a face in a particular image. This kind of prediction is not designed to categorize a person’s gender identity, and you shouldn't use Amazon Rekognition to make such a determination. For example, a male actor wearing a long-haired wig and earrings for a role might be predicted as female.</p>
/// <p>Using Amazon Rekognition to make gender binary predictions is best suited for use cases where aggregate gender distribution statistics need to be analyzed without identifying specific users. For example, the percentage of female users compared to male users on a social media platform. </p>
/// <p>We don't recommend using gender binary predictions to make decisions that impact  an individual's rights, privacy, or access to services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Gender {
    /// <p>The predicted gender of the face.</p>
    pub value: std::option::Option<crate::model::GenderType>,
    /// <p>Level of confidence in the prediction.</p>
    pub confidence: std::option::Option<f32>,
}
impl Gender {
    /// <p>The predicted gender of the face.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::GenderType> {
        self.value.as_ref()
    }
    /// <p>Level of confidence in the prediction.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Gender {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Gender");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Gender`](crate::model::Gender)
pub mod gender {
    /// A builder for [`Gender`](crate::model::Gender)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::GenderType>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The predicted gender of the face.</p>
        pub fn value(mut self, input: crate::model::GenderType) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The predicted gender of the face.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::GenderType>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the prediction.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the prediction.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Gender`](crate::model::Gender)
        pub fn build(self) -> crate::model::Gender {
            crate::model::Gender {
                value: self.value,
                confidence: self.confidence,
            }
        }
    }
}
impl Gender {
    /// Creates a new builder-style object to manufacture [`Gender`](crate::model::Gender)
    pub fn builder() -> crate::model::gender::Builder {
        crate::model::gender::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GenderType {
    #[allow(missing_docs)] // documentation missing in model
    Female,
    #[allow(missing_docs)] // documentation missing in model
    Male,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GenderType {
    fn from(s: &str) -> Self {
        match s {
            "Female" => GenderType::Female,
            "Male" => GenderType::Male,
            other => GenderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GenderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GenderType::from(s))
    }
}
impl GenderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GenderType::Female => "Female",
            GenderType::Male => "Male",
            GenderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Female", "Male"]
    }
}
impl AsRef<str> for GenderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Indicates whether or not the face is wearing sunglasses, and the confidence level in the determination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sunglasses {
    /// <p>Boolean value that indicates whether the face is wearing sunglasses or not.</p>
    pub value: bool,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl Sunglasses {
    /// <p>Boolean value that indicates whether the face is wearing sunglasses or not.</p>
    pub fn value(&self) -> bool {
        self.value
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Sunglasses {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sunglasses");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Sunglasses`](crate::model::Sunglasses)
pub mod sunglasses {
    /// A builder for [`Sunglasses`](crate::model::Sunglasses)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<bool>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Boolean value that indicates whether the face is wearing sunglasses or not.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the face is wearing sunglasses or not.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Sunglasses`](crate::model::Sunglasses)
        pub fn build(self) -> crate::model::Sunglasses {
            crate::model::Sunglasses {
                value: self.value.unwrap_or_default(),
                confidence: self.confidence,
            }
        }
    }
}
impl Sunglasses {
    /// Creates a new builder-style object to manufacture [`Sunglasses`](crate::model::Sunglasses)
    pub fn builder() -> crate::model::sunglasses::Builder {
        crate::model::sunglasses::Builder::default()
    }
}

/// <p>Indicates whether or not the face is wearing eye glasses, and the confidence level in the determination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Eyeglasses {
    /// <p>Boolean value that indicates whether the face is wearing eye glasses or not.</p>
    pub value: bool,
    /// <p>Level of confidence in the determination.</p>
    pub confidence: std::option::Option<f32>,
}
impl Eyeglasses {
    /// <p>Boolean value that indicates whether the face is wearing eye glasses or not.</p>
    pub fn value(&self) -> bool {
        self.value
    }
    /// <p>Level of confidence in the determination.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Eyeglasses {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Eyeglasses");
        formatter.field("value", &self.value);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Eyeglasses`](crate::model::Eyeglasses)
pub mod eyeglasses {
    /// A builder for [`Eyeglasses`](crate::model::Eyeglasses)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<bool>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Boolean value that indicates whether the face is wearing eye glasses or not.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Boolean value that indicates whether the face is wearing eye glasses or not.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence in the determination.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Eyeglasses`](crate::model::Eyeglasses)
        pub fn build(self) -> crate::model::Eyeglasses {
            crate::model::Eyeglasses {
                value: self.value.unwrap_or_default(),
                confidence: self.confidence,
            }
        }
    }
}
impl Eyeglasses {
    /// Creates a new builder-style object to manufacture [`Eyeglasses`](crate::model::Eyeglasses)
    pub fn builder() -> crate::model::eyeglasses::Builder {
        crate::model::eyeglasses::Builder::default()
    }
}

/// <p>Structure containing the estimated age range, in years, for a face.</p>
/// <p>Amazon Rekognition estimates an age range for faces detected in the input image. Estimated age ranges can overlap. A face of a 5-year-old might have an estimated range of 4-6, while the face of a 6-year-old might have an estimated range of 4-8.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AgeRange {
    /// <p>The lowest estimated age.</p>
    pub low: std::option::Option<i32>,
    /// <p>The highest estimated age.</p>
    pub high: std::option::Option<i32>,
}
impl AgeRange {
    /// <p>The lowest estimated age.</p>
    pub fn low(&self) -> std::option::Option<i32> {
        self.low
    }
    /// <p>The highest estimated age.</p>
    pub fn high(&self) -> std::option::Option<i32> {
        self.high
    }
}
impl std::fmt::Debug for AgeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AgeRange");
        formatter.field("low", &self.low);
        formatter.field("high", &self.high);
        formatter.finish()
    }
}
/// See [`AgeRange`](crate::model::AgeRange)
pub mod age_range {
    /// A builder for [`AgeRange`](crate::model::AgeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) low: std::option::Option<i32>,
        pub(crate) high: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The lowest estimated age.</p>
        pub fn low(mut self, input: i32) -> Self {
            self.low = Some(input);
            self
        }
        /// <p>The lowest estimated age.</p>
        pub fn set_low(mut self, input: std::option::Option<i32>) -> Self {
            self.low = input;
            self
        }
        /// <p>The highest estimated age.</p>
        pub fn high(mut self, input: i32) -> Self {
            self.high = Some(input);
            self
        }
        /// <p>The highest estimated age.</p>
        pub fn set_high(mut self, input: std::option::Option<i32>) -> Self {
            self.high = input;
            self
        }
        /// Consumes the builder and constructs a [`AgeRange`](crate::model::AgeRange)
        pub fn build(self) -> crate::model::AgeRange {
            crate::model::AgeRange {
                low: self.low,
                high: self.high,
            }
        }
    }
}
impl AgeRange {
    /// Creates a new builder-style object to manufacture [`AgeRange`](crate::model::AgeRange)
    pub fn builder() -> crate::model::age_range::Builder {
        crate::model::age_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Reason {
    #[allow(missing_docs)] // documentation missing in model
    ExceedsMaxFaces,
    #[allow(missing_docs)] // documentation missing in model
    ExtremePose,
    #[allow(missing_docs)] // documentation missing in model
    LowBrightness,
    #[allow(missing_docs)] // documentation missing in model
    LowConfidence,
    #[allow(missing_docs)] // documentation missing in model
    LowFaceQuality,
    #[allow(missing_docs)] // documentation missing in model
    LowSharpness,
    #[allow(missing_docs)] // documentation missing in model
    SmallBoundingBox,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Reason {
    fn from(s: &str) -> Self {
        match s {
            "EXCEEDS_MAX_FACES" => Reason::ExceedsMaxFaces,
            "EXTREME_POSE" => Reason::ExtremePose,
            "LOW_BRIGHTNESS" => Reason::LowBrightness,
            "LOW_CONFIDENCE" => Reason::LowConfidence,
            "LOW_FACE_QUALITY" => Reason::LowFaceQuality,
            "LOW_SHARPNESS" => Reason::LowSharpness,
            "SMALL_BOUNDING_BOX" => Reason::SmallBoundingBox,
            other => Reason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Reason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Reason::from(s))
    }
}
impl Reason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Reason::ExceedsMaxFaces => "EXCEEDS_MAX_FACES",
            Reason::ExtremePose => "EXTREME_POSE",
            Reason::LowBrightness => "LOW_BRIGHTNESS",
            Reason::LowConfidence => "LOW_CONFIDENCE",
            Reason::LowFaceQuality => "LOW_FACE_QUALITY",
            Reason::LowSharpness => "LOW_SHARPNESS",
            Reason::SmallBoundingBox => "SMALL_BOUNDING_BOX",
            Reason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXCEEDS_MAX_FACES",
            "EXTREME_POSE",
            "LOW_BRIGHTNESS",
            "LOW_CONFIDENCE",
            "LOW_FACE_QUALITY",
            "LOW_SHARPNESS",
            "SMALL_BOUNDING_BOX",
        ]
    }
}
impl AsRef<str> for Reason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Object containing both the face metadata (stored in the backend database), and facial attributes that are detected but aren't stored in the database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaceRecord {
    /// <p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>
    pub face: std::option::Option<crate::model::Face>,
    /// <p>Structure containing attributes of the face that the algorithm detected.</p>
    pub face_detail: std::option::Option<crate::model::FaceDetail>,
}
impl FaceRecord {
    /// <p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>
    pub fn face(&self) -> std::option::Option<&crate::model::Face> {
        self.face.as_ref()
    }
    /// <p>Structure containing attributes of the face that the algorithm detected.</p>
    pub fn face_detail(&self) -> std::option::Option<&crate::model::FaceDetail> {
        self.face_detail.as_ref()
    }
}
impl std::fmt::Debug for FaceRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaceRecord");
        formatter.field("face", &self.face);
        formatter.field("face_detail", &self.face_detail);
        formatter.finish()
    }
}
/// See [`FaceRecord`](crate::model::FaceRecord)
pub mod face_record {
    /// A builder for [`FaceRecord`](crate::model::FaceRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) face: std::option::Option<crate::model::Face>,
        pub(crate) face_detail: std::option::Option<crate::model::FaceDetail>,
    }
    impl Builder {
        /// <p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>
        pub fn face(mut self, input: crate::model::Face) -> Self {
            self.face = Some(input);
            self
        }
        /// <p>Describes the face properties such as the bounding box, face ID, image ID of the input image, and external image ID that you assigned. </p>
        pub fn set_face(mut self, input: std::option::Option<crate::model::Face>) -> Self {
            self.face = input;
            self
        }
        /// <p>Structure containing attributes of the face that the algorithm detected.</p>
        pub fn face_detail(mut self, input: crate::model::FaceDetail) -> Self {
            self.face_detail = Some(input);
            self
        }
        /// <p>Structure containing attributes of the face that the algorithm detected.</p>
        pub fn set_face_detail(
            mut self,
            input: std::option::Option<crate::model::FaceDetail>,
        ) -> Self {
            self.face_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`FaceRecord`](crate::model::FaceRecord)
        pub fn build(self) -> crate::model::FaceRecord {
            crate::model::FaceRecord {
                face: self.face,
                face_detail: self.face_detail,
            }
        }
    }
}
impl FaceRecord {
    /// Creates a new builder-style object to manufacture [`FaceRecord`](crate::model::FaceRecord)
    pub fn builder() -> crate::model::face_record::Builder {
        crate::model::face_record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Attribute {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Attribute {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => Attribute::All,
            "DEFAULT" => Attribute::Default,
            other => Attribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Attribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Attribute::from(s))
    }
}
impl Attribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Attribute::All => "ALL",
            Attribute::Default => "DEFAULT",
            Attribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "DEFAULT"]
    }
}
impl AsRef<str> for Attribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about text detected in a video. Incudes the detected text, the time in milliseconds from the start of the video that the text was detected, and where it was detected on the screen.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextDetectionResult {
    /// <p>The time, in milliseconds from the start of the video, that the text was detected.</p>
    pub timestamp: i64,
    /// <p>Details about text detected in a video.</p>
    pub text_detection: std::option::Option<crate::model::TextDetection>,
}
impl TextDetectionResult {
    /// <p>The time, in milliseconds from the start of the video, that the text was detected.</p>
    pub fn timestamp(&self) -> i64 {
        self.timestamp
    }
    /// <p>Details about text detected in a video.</p>
    pub fn text_detection(&self) -> std::option::Option<&crate::model::TextDetection> {
        self.text_detection.as_ref()
    }
}
impl std::fmt::Debug for TextDetectionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextDetectionResult");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("text_detection", &self.text_detection);
        formatter.finish()
    }
}
/// See [`TextDetectionResult`](crate::model::TextDetectionResult)
pub mod text_detection_result {
    /// A builder for [`TextDetectionResult`](crate::model::TextDetectionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) text_detection: std::option::Option<crate::model::TextDetection>,
    }
    impl Builder {
        /// <p>The time, in milliseconds from the start of the video, that the text was detected.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time, in milliseconds from the start of the video, that the text was detected.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Details about text detected in a video.</p>
        pub fn text_detection(mut self, input: crate::model::TextDetection) -> Self {
            self.text_detection = Some(input);
            self
        }
        /// <p>Details about text detected in a video.</p>
        pub fn set_text_detection(
            mut self,
            input: std::option::Option<crate::model::TextDetection>,
        ) -> Self {
            self.text_detection = input;
            self
        }
        /// Consumes the builder and constructs a [`TextDetectionResult`](crate::model::TextDetectionResult)
        pub fn build(self) -> crate::model::TextDetectionResult {
            crate::model::TextDetectionResult {
                timestamp: self.timestamp.unwrap_or_default(),
                text_detection: self.text_detection,
            }
        }
    }
}
impl TextDetectionResult {
    /// Creates a new builder-style object to manufacture [`TextDetectionResult`](crate::model::TextDetectionResult)
    pub fn builder() -> crate::model::text_detection_result::Builder {
        crate::model::text_detection_result::Builder::default()
    }
}

/// <p>Information about a word or line of text detected by <code>DetectText</code>.</p>
/// <p>The <code>DetectedText</code> field contains the text that Amazon Rekognition detected in the image. </p>
/// <p>Every word and line has an identifier (<code>Id</code>). Each word belongs to a line and has a parent identifier (<code>ParentId</code>) that identifies the line of text in which the word appears. The word <code>Id</code> is also an index for the word within a line of words. </p>
/// <p>For more information, see Detecting Text in the Amazon Rekognition Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextDetection {
    /// <p>The word or line of text recognized by Amazon Rekognition. </p>
    pub detected_text: std::option::Option<std::string::String>,
    /// <p>The type of text that was detected.</p>
    pub r#type: std::option::Option<crate::model::TextTypes>,
    /// <p>The identifier for the detected text. The identifier is only unique for a single call to <code>DetectText</code>. </p>
    pub id: std::option::Option<i32>,
    /// <p>The Parent identifier for the detected text identified by the value of <code>ID</code>. If the type of detected text is <code>LINE</code>, the value of <code>ParentId</code> is <code>Null</code>. </p>
    pub parent_id: std::option::Option<i32>,
    /// <p>The confidence that Amazon Rekognition has in the accuracy of the detected text and the accuracy of the geometry points around the detected text.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>The location of the detected text on the image. Includes an axis aligned coarse bounding box surrounding the text and a finer grain polygon for more accurate spatial information.</p>
    pub geometry: std::option::Option<crate::model::Geometry>,
}
impl TextDetection {
    /// <p>The word or line of text recognized by Amazon Rekognition. </p>
    pub fn detected_text(&self) -> std::option::Option<&str> {
        self.detected_text.as_deref()
    }
    /// <p>The type of text that was detected.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TextTypes> {
        self.r#type.as_ref()
    }
    /// <p>The identifier for the detected text. The identifier is only unique for a single call to <code>DetectText</code>. </p>
    pub fn id(&self) -> std::option::Option<i32> {
        self.id
    }
    /// <p>The Parent identifier for the detected text identified by the value of <code>ID</code>. If the type of detected text is <code>LINE</code>, the value of <code>ParentId</code> is <code>Null</code>. </p>
    pub fn parent_id(&self) -> std::option::Option<i32> {
        self.parent_id
    }
    /// <p>The confidence that Amazon Rekognition has in the accuracy of the detected text and the accuracy of the geometry points around the detected text.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>The location of the detected text on the image. Includes an axis aligned coarse bounding box surrounding the text and a finer grain polygon for more accurate spatial information.</p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::Geometry> {
        self.geometry.as_ref()
    }
}
impl std::fmt::Debug for TextDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextDetection");
        formatter.field("detected_text", &self.detected_text);
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("parent_id", &self.parent_id);
        formatter.field("confidence", &self.confidence);
        formatter.field("geometry", &self.geometry);
        formatter.finish()
    }
}
/// See [`TextDetection`](crate::model::TextDetection)
pub mod text_detection {
    /// A builder for [`TextDetection`](crate::model::TextDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detected_text: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::TextTypes>,
        pub(crate) id: std::option::Option<i32>,
        pub(crate) parent_id: std::option::Option<i32>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) geometry: std::option::Option<crate::model::Geometry>,
    }
    impl Builder {
        /// <p>The word or line of text recognized by Amazon Rekognition. </p>
        pub fn detected_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.detected_text = Some(input.into());
            self
        }
        /// <p>The word or line of text recognized by Amazon Rekognition. </p>
        pub fn set_detected_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detected_text = input;
            self
        }
        /// <p>The type of text that was detected.</p>
        pub fn r#type(mut self, input: crate::model::TextTypes) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of text that was detected.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TextTypes>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier for the detected text. The identifier is only unique for a single call to <code>DetectText</code>. </p>
        pub fn id(mut self, input: i32) -> Self {
            self.id = Some(input);
            self
        }
        /// <p>The identifier for the detected text. The identifier is only unique for a single call to <code>DetectText</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<i32>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Parent identifier for the detected text identified by the value of <code>ID</code>. If the type of detected text is <code>LINE</code>, the value of <code>ParentId</code> is <code>Null</code>. </p>
        pub fn parent_id(mut self, input: i32) -> Self {
            self.parent_id = Some(input);
            self
        }
        /// <p>The Parent identifier for the detected text identified by the value of <code>ID</code>. If the type of detected text is <code>LINE</code>, the value of <code>ParentId</code> is <code>Null</code>. </p>
        pub fn set_parent_id(mut self, input: std::option::Option<i32>) -> Self {
            self.parent_id = input;
            self
        }
        /// <p>The confidence that Amazon Rekognition has in the accuracy of the detected text and the accuracy of the geometry points around the detected text.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition has in the accuracy of the detected text and the accuracy of the geometry points around the detected text.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The location of the detected text on the image. Includes an axis aligned coarse bounding box surrounding the text and a finer grain polygon for more accurate spatial information.</p>
        pub fn geometry(mut self, input: crate::model::Geometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>The location of the detected text on the image. Includes an axis aligned coarse bounding box surrounding the text and a finer grain polygon for more accurate spatial information.</p>
        pub fn set_geometry(mut self, input: std::option::Option<crate::model::Geometry>) -> Self {
            self.geometry = input;
            self
        }
        /// Consumes the builder and constructs a [`TextDetection`](crate::model::TextDetection)
        pub fn build(self) -> crate::model::TextDetection {
            crate::model::TextDetection {
                detected_text: self.detected_text,
                r#type: self.r#type,
                id: self.id,
                parent_id: self.parent_id,
                confidence: self.confidence,
                geometry: self.geometry,
            }
        }
    }
}
impl TextDetection {
    /// Creates a new builder-style object to manufacture [`TextDetection`](crate::model::TextDetection)
    pub fn builder() -> crate::model::text_detection::Builder {
        crate::model::text_detection::Builder::default()
    }
}

/// <p>Information about where an object (<code>DetectCustomLabels</code>) or text (<code>DetectText</code>) is located on an image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Geometry {
    /// <p>An axis-aligned coarse representation of the detected item's location on the image.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>Within the bounding box, a fine-grained polygon around the detected item.</p>
    pub polygon: std::option::Option<std::vec::Vec<crate::model::Point>>,
}
impl Geometry {
    /// <p>An axis-aligned coarse representation of the detected item's location on the image.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>Within the bounding box, a fine-grained polygon around the detected item.</p>
    pub fn polygon(&self) -> std::option::Option<&[crate::model::Point]> {
        self.polygon.as_deref()
    }
}
impl std::fmt::Debug for Geometry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Geometry");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("polygon", &self.polygon);
        formatter.finish()
    }
}
/// See [`Geometry`](crate::model::Geometry)
pub mod geometry {
    /// A builder for [`Geometry`](crate::model::Geometry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) polygon: std::option::Option<std::vec::Vec<crate::model::Point>>,
    }
    impl Builder {
        /// <p>An axis-aligned coarse representation of the detected item's location on the image.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>An axis-aligned coarse representation of the detected item's location on the image.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// Appends an item to `polygon`.
        ///
        /// To override the contents of this collection use [`set_polygon`](Self::set_polygon).
        ///
        /// <p>Within the bounding box, a fine-grained polygon around the detected item.</p>
        pub fn polygon(mut self, input: crate::model::Point) -> Self {
            let mut v = self.polygon.unwrap_or_default();
            v.push(input);
            self.polygon = Some(v);
            self
        }
        /// <p>Within the bounding box, a fine-grained polygon around the detected item.</p>
        pub fn set_polygon(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Point>>,
        ) -> Self {
            self.polygon = input;
            self
        }
        /// Consumes the builder and constructs a [`Geometry`](crate::model::Geometry)
        pub fn build(self) -> crate::model::Geometry {
            crate::model::Geometry {
                bounding_box: self.bounding_box,
                polygon: self.polygon,
            }
        }
    }
}
impl Geometry {
    /// Creates a new builder-style object to manufacture [`Geometry`](crate::model::Geometry)
    pub fn builder() -> crate::model::geometry::Builder {
        crate::model::geometry::Builder::default()
    }
}

/// <p>The X and Y coordinates of a point on an image. The X and Y values returned are ratios of the overall image size. For example, if the input image is 700x200 and the operation returns X=0.5 and Y=0.25, then the point is at the (350,50) pixel coordinate on the image.</p>
/// <p>An array of <code>Point</code> objects, <code>Polygon</code>, is returned by <code>DetectText</code> and by <code>DetectCustomLabels</code>. <code>Polygon</code> represents a fine-grained polygon around a detected item. For more information, see Geometry in the Amazon Rekognition Developer Guide. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Point {
    /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
    pub x: std::option::Option<f32>,
    /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
    pub y: std::option::Option<f32>,
}
impl Point {
    /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
    pub fn x(&self) -> std::option::Option<f32> {
        self.x
    }
    /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
    pub fn y(&self) -> std::option::Option<f32> {
        self.y
    }
}
impl std::fmt::Debug for Point {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Point");
        formatter.field("x", &self.x);
        formatter.field("y", &self.y);
        formatter.finish()
    }
}
/// See [`Point`](crate::model::Point)
pub mod point {
    /// A builder for [`Point`](crate::model::Point)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) x: std::option::Option<f32>,
        pub(crate) y: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
        pub fn x(mut self, input: f32) -> Self {
            self.x = Some(input);
            self
        }
        /// <p>The value of the X coordinate for a point on a <code>Polygon</code>.</p>
        pub fn set_x(mut self, input: std::option::Option<f32>) -> Self {
            self.x = input;
            self
        }
        /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
        pub fn y(mut self, input: f32) -> Self {
            self.y = Some(input);
            self
        }
        /// <p>The value of the Y coordinate for a point on a <code>Polygon</code>.</p>
        pub fn set_y(mut self, input: std::option::Option<f32>) -> Self {
            self.y = input;
            self
        }
        /// Consumes the builder and constructs a [`Point`](crate::model::Point)
        pub fn build(self) -> crate::model::Point {
            crate::model::Point {
                x: self.x,
                y: self.y,
            }
        }
    }
}
impl Point {
    /// Creates a new builder-style object to manufacture [`Point`](crate::model::Point)
    pub fn builder() -> crate::model::point::Builder {
        crate::model::point::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TextTypes {
    #[allow(missing_docs)] // documentation missing in model
    Line,
    #[allow(missing_docs)] // documentation missing in model
    Word,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TextTypes {
    fn from(s: &str) -> Self {
        match s {
            "LINE" => TextTypes::Line,
            "WORD" => TextTypes::Word,
            other => TextTypes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TextTypes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TextTypes::from(s))
    }
}
impl TextTypes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TextTypes::Line => "LINE",
            TextTypes::Word => "WORD",
            TextTypes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINE", "WORD"]
    }
}
impl AsRef<str> for TextTypes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition video operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoMetadata {
    /// <p>Type of compression used in the analyzed video. </p>
    pub codec: std::option::Option<std::string::String>,
    /// <p>Length of the video in milliseconds.</p>
    pub duration_millis: std::option::Option<i64>,
    /// <p>Format of the analyzed video. Possible values are MP4, MOV and AVI. </p>
    pub format: std::option::Option<std::string::String>,
    /// <p>Number of frames per second in the video.</p>
    pub frame_rate: std::option::Option<f32>,
    /// <p>Vertical pixel dimension of the video.</p>
    pub frame_height: std::option::Option<i64>,
    /// <p>Horizontal pixel dimension of the video.</p>
    pub frame_width: std::option::Option<i64>,
    /// <p> A description of the range of luminance values in a video, either LIMITED (16 to 235) or FULL (0 to 255). </p>
    pub color_range: std::option::Option<crate::model::VideoColorRange>,
}
impl VideoMetadata {
    /// <p>Type of compression used in the analyzed video. </p>
    pub fn codec(&self) -> std::option::Option<&str> {
        self.codec.as_deref()
    }
    /// <p>Length of the video in milliseconds.</p>
    pub fn duration_millis(&self) -> std::option::Option<i64> {
        self.duration_millis
    }
    /// <p>Format of the analyzed video. Possible values are MP4, MOV and AVI. </p>
    pub fn format(&self) -> std::option::Option<&str> {
        self.format.as_deref()
    }
    /// <p>Number of frames per second in the video.</p>
    pub fn frame_rate(&self) -> std::option::Option<f32> {
        self.frame_rate
    }
    /// <p>Vertical pixel dimension of the video.</p>
    pub fn frame_height(&self) -> std::option::Option<i64> {
        self.frame_height
    }
    /// <p>Horizontal pixel dimension of the video.</p>
    pub fn frame_width(&self) -> std::option::Option<i64> {
        self.frame_width
    }
    /// <p> A description of the range of luminance values in a video, either LIMITED (16 to 235) or FULL (0 to 255). </p>
    pub fn color_range(&self) -> std::option::Option<&crate::model::VideoColorRange> {
        self.color_range.as_ref()
    }
}
impl std::fmt::Debug for VideoMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoMetadata");
        formatter.field("codec", &self.codec);
        formatter.field("duration_millis", &self.duration_millis);
        formatter.field("format", &self.format);
        formatter.field("frame_rate", &self.frame_rate);
        formatter.field("frame_height", &self.frame_height);
        formatter.field("frame_width", &self.frame_width);
        formatter.field("color_range", &self.color_range);
        formatter.finish()
    }
}
/// See [`VideoMetadata`](crate::model::VideoMetadata)
pub mod video_metadata {
    /// A builder for [`VideoMetadata`](crate::model::VideoMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) codec: std::option::Option<std::string::String>,
        pub(crate) duration_millis: std::option::Option<i64>,
        pub(crate) format: std::option::Option<std::string::String>,
        pub(crate) frame_rate: std::option::Option<f32>,
        pub(crate) frame_height: std::option::Option<i64>,
        pub(crate) frame_width: std::option::Option<i64>,
        pub(crate) color_range: std::option::Option<crate::model::VideoColorRange>,
    }
    impl Builder {
        /// <p>Type of compression used in the analyzed video. </p>
        pub fn codec(mut self, input: impl Into<std::string::String>) -> Self {
            self.codec = Some(input.into());
            self
        }
        /// <p>Type of compression used in the analyzed video. </p>
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.codec = input;
            self
        }
        /// <p>Length of the video in milliseconds.</p>
        pub fn duration_millis(mut self, input: i64) -> Self {
            self.duration_millis = Some(input);
            self
        }
        /// <p>Length of the video in milliseconds.</p>
        pub fn set_duration_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_millis = input;
            self
        }
        /// <p>Format of the analyzed video. Possible values are MP4, MOV and AVI. </p>
        pub fn format(mut self, input: impl Into<std::string::String>) -> Self {
            self.format = Some(input.into());
            self
        }
        /// <p>Format of the analyzed video. Possible values are MP4, MOV and AVI. </p>
        pub fn set_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.format = input;
            self
        }
        /// <p>Number of frames per second in the video.</p>
        pub fn frame_rate(mut self, input: f32) -> Self {
            self.frame_rate = Some(input);
            self
        }
        /// <p>Number of frames per second in the video.</p>
        pub fn set_frame_rate(mut self, input: std::option::Option<f32>) -> Self {
            self.frame_rate = input;
            self
        }
        /// <p>Vertical pixel dimension of the video.</p>
        pub fn frame_height(mut self, input: i64) -> Self {
            self.frame_height = Some(input);
            self
        }
        /// <p>Vertical pixel dimension of the video.</p>
        pub fn set_frame_height(mut self, input: std::option::Option<i64>) -> Self {
            self.frame_height = input;
            self
        }
        /// <p>Horizontal pixel dimension of the video.</p>
        pub fn frame_width(mut self, input: i64) -> Self {
            self.frame_width = Some(input);
            self
        }
        /// <p>Horizontal pixel dimension of the video.</p>
        pub fn set_frame_width(mut self, input: std::option::Option<i64>) -> Self {
            self.frame_width = input;
            self
        }
        /// <p> A description of the range of luminance values in a video, either LIMITED (16 to 235) or FULL (0 to 255). </p>
        pub fn color_range(mut self, input: crate::model::VideoColorRange) -> Self {
            self.color_range = Some(input);
            self
        }
        /// <p> A description of the range of luminance values in a video, either LIMITED (16 to 235) or FULL (0 to 255). </p>
        pub fn set_color_range(
            mut self,
            input: std::option::Option<crate::model::VideoColorRange>,
        ) -> Self {
            self.color_range = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoMetadata`](crate::model::VideoMetadata)
        pub fn build(self) -> crate::model::VideoMetadata {
            crate::model::VideoMetadata {
                codec: self.codec,
                duration_millis: self.duration_millis,
                format: self.format,
                frame_rate: self.frame_rate,
                frame_height: self.frame_height,
                frame_width: self.frame_width,
                color_range: self.color_range,
            }
        }
    }
}
impl VideoMetadata {
    /// Creates a new builder-style object to manufacture [`VideoMetadata`](crate::model::VideoMetadata)
    pub fn builder() -> crate::model::video_metadata::Builder {
        crate::model::video_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoColorRange {
    #[allow(missing_docs)] // documentation missing in model
    Full,
    #[allow(missing_docs)] // documentation missing in model
    Limited,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoColorRange {
    fn from(s: &str) -> Self {
        match s {
            "FULL" => VideoColorRange::Full,
            "LIMITED" => VideoColorRange::Limited,
            other => VideoColorRange::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoColorRange {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoColorRange::from(s))
    }
}
impl VideoColorRange {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoColorRange::Full => "FULL",
            VideoColorRange::Limited => "LIMITED",
            VideoColorRange::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL", "LIMITED"]
    }
}
impl AsRef<str> for VideoColorRange {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => VideoJobStatus::Failed,
            "IN_PROGRESS" => VideoJobStatus::InProgress,
            "SUCCEEDED" => VideoJobStatus::Succeeded,
            other => VideoJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoJobStatus::from(s))
    }
}
impl VideoJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoJobStatus::Failed => "FAILED",
            VideoJobStatus::InProgress => "IN_PROGRESS",
            VideoJobStatus::Succeeded => "SUCCEEDED",
            VideoJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for VideoJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the type of a segment requested in a call to <code>StartSegmentDetection</code>. An array of <code>SegmentTypeInfo</code> objects is returned by the response from <code>GetSegmentDetection</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentTypeInfo {
    /// <p>The type of a segment (technical cue or shot detection).</p>
    pub r#type: std::option::Option<crate::model::SegmentType>,
    /// <p>The version of the model used to detect segments.</p>
    pub model_version: std::option::Option<std::string::String>,
}
impl SegmentTypeInfo {
    /// <p>The type of a segment (technical cue or shot detection).</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SegmentType> {
        self.r#type.as_ref()
    }
    /// <p>The version of the model used to detect segments.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
}
impl std::fmt::Debug for SegmentTypeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentTypeInfo");
        formatter.field("r#type", &self.r#type);
        formatter.field("model_version", &self.model_version);
        formatter.finish()
    }
}
/// See [`SegmentTypeInfo`](crate::model::SegmentTypeInfo)
pub mod segment_type_info {
    /// A builder for [`SegmentTypeInfo`](crate::model::SegmentTypeInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SegmentType>,
        pub(crate) model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of a segment (technical cue or shot detection).</p>
        pub fn r#type(mut self, input: crate::model::SegmentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of a segment (technical cue or shot detection).</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SegmentType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The version of the model used to detect segments.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The version of the model used to detect segments.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentTypeInfo`](crate::model::SegmentTypeInfo)
        pub fn build(self) -> crate::model::SegmentTypeInfo {
            crate::model::SegmentTypeInfo {
                r#type: self.r#type,
                model_version: self.model_version,
            }
        }
    }
}
impl SegmentTypeInfo {
    /// Creates a new builder-style object to manufacture [`SegmentTypeInfo`](crate::model::SegmentTypeInfo)
    pub fn builder() -> crate::model::segment_type_info::Builder {
        crate::model::segment_type_info::Builder::default()
    }
}

/// <p>A technical cue or shot detection segment detected in a video. An array of <code>SegmentDetection</code> objects containing all segments detected in a stored video is returned by <code>GetSegmentDetection</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SegmentDetection {
    /// <p>The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.</p>
    pub r#type: std::option::Option<crate::model::SegmentType>,
    /// <p>The start time of the detected segment in milliseconds from the start of the video. This value is rounded down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100 millis.</p>
    pub start_timestamp_millis: i64,
    /// <p>The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded down.</p>
    pub end_timestamp_millis: i64,
    /// <p>The duration of the detected segment in milliseconds. </p>
    pub duration_millis: std::option::Option<i64>,
    /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment. <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates). </p>
    pub start_timecode_smpte: std::option::Option<std::string::String>,
    /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment. <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).</p>
    pub end_timecode_smpte: std::option::Option<std::string::String>,
    /// <p>The duration of the timecode for the detected segment in SMPTE format.</p>
    pub duration_smpte: std::option::Option<std::string::String>,
    /// <p>If the segment is a technical cue, contains information about the technical cue.</p>
    pub technical_cue_segment: std::option::Option<crate::model::TechnicalCueSegment>,
    /// <p>If the segment is a shot detection, contains information about the shot detection.</p>
    pub shot_segment: std::option::Option<crate::model::ShotSegment>,
    /// <p> The frame number of the start of a video segment, using a frame index that starts with 0. </p>
    pub start_frame_number: std::option::Option<i64>,
    /// <p> The frame number at the end of a video segment, using a frame index that starts with 0. </p>
    pub end_frame_number: std::option::Option<i64>,
    /// <p> The duration of a video segment, expressed in frames. </p>
    pub duration_frames: std::option::Option<i64>,
}
impl SegmentDetection {
    /// <p>The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SegmentType> {
        self.r#type.as_ref()
    }
    /// <p>The start time of the detected segment in milliseconds from the start of the video. This value is rounded down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100 millis.</p>
    pub fn start_timestamp_millis(&self) -> i64 {
        self.start_timestamp_millis
    }
    /// <p>The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded down.</p>
    pub fn end_timestamp_millis(&self) -> i64 {
        self.end_timestamp_millis
    }
    /// <p>The duration of the detected segment in milliseconds. </p>
    pub fn duration_millis(&self) -> std::option::Option<i64> {
        self.duration_millis
    }
    /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment. <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates). </p>
    pub fn start_timecode_smpte(&self) -> std::option::Option<&str> {
        self.start_timecode_smpte.as_deref()
    }
    /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment. <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).</p>
    pub fn end_timecode_smpte(&self) -> std::option::Option<&str> {
        self.end_timecode_smpte.as_deref()
    }
    /// <p>The duration of the timecode for the detected segment in SMPTE format.</p>
    pub fn duration_smpte(&self) -> std::option::Option<&str> {
        self.duration_smpte.as_deref()
    }
    /// <p>If the segment is a technical cue, contains information about the technical cue.</p>
    pub fn technical_cue_segment(&self) -> std::option::Option<&crate::model::TechnicalCueSegment> {
        self.technical_cue_segment.as_ref()
    }
    /// <p>If the segment is a shot detection, contains information about the shot detection.</p>
    pub fn shot_segment(&self) -> std::option::Option<&crate::model::ShotSegment> {
        self.shot_segment.as_ref()
    }
    /// <p> The frame number of the start of a video segment, using a frame index that starts with 0. </p>
    pub fn start_frame_number(&self) -> std::option::Option<i64> {
        self.start_frame_number
    }
    /// <p> The frame number at the end of a video segment, using a frame index that starts with 0. </p>
    pub fn end_frame_number(&self) -> std::option::Option<i64> {
        self.end_frame_number
    }
    /// <p> The duration of a video segment, expressed in frames. </p>
    pub fn duration_frames(&self) -> std::option::Option<i64> {
        self.duration_frames
    }
}
impl std::fmt::Debug for SegmentDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SegmentDetection");
        formatter.field("r#type", &self.r#type);
        formatter.field("start_timestamp_millis", &self.start_timestamp_millis);
        formatter.field("end_timestamp_millis", &self.end_timestamp_millis);
        formatter.field("duration_millis", &self.duration_millis);
        formatter.field("start_timecode_smpte", &self.start_timecode_smpte);
        formatter.field("end_timecode_smpte", &self.end_timecode_smpte);
        formatter.field("duration_smpte", &self.duration_smpte);
        formatter.field("technical_cue_segment", &self.technical_cue_segment);
        formatter.field("shot_segment", &self.shot_segment);
        formatter.field("start_frame_number", &self.start_frame_number);
        formatter.field("end_frame_number", &self.end_frame_number);
        formatter.field("duration_frames", &self.duration_frames);
        formatter.finish()
    }
}
/// See [`SegmentDetection`](crate::model::SegmentDetection)
pub mod segment_detection {
    /// A builder for [`SegmentDetection`](crate::model::SegmentDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SegmentType>,
        pub(crate) start_timestamp_millis: std::option::Option<i64>,
        pub(crate) end_timestamp_millis: std::option::Option<i64>,
        pub(crate) duration_millis: std::option::Option<i64>,
        pub(crate) start_timecode_smpte: std::option::Option<std::string::String>,
        pub(crate) end_timecode_smpte: std::option::Option<std::string::String>,
        pub(crate) duration_smpte: std::option::Option<std::string::String>,
        pub(crate) technical_cue_segment: std::option::Option<crate::model::TechnicalCueSegment>,
        pub(crate) shot_segment: std::option::Option<crate::model::ShotSegment>,
        pub(crate) start_frame_number: std::option::Option<i64>,
        pub(crate) end_frame_number: std::option::Option<i64>,
        pub(crate) duration_frames: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.</p>
        pub fn r#type(mut self, input: crate::model::SegmentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the segment. Valid values are <code>TECHNICAL_CUE</code> and <code>SHOT</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SegmentType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The start time of the detected segment in milliseconds from the start of the video. This value is rounded down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100 millis.</p>
        pub fn start_timestamp_millis(mut self, input: i64) -> Self {
            self.start_timestamp_millis = Some(input);
            self
        }
        /// <p>The start time of the detected segment in milliseconds from the start of the video. This value is rounded down. For example, if the actual timestamp is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100 millis.</p>
        pub fn set_start_timestamp_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.start_timestamp_millis = input;
            self
        }
        /// <p>The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded down.</p>
        pub fn end_timestamp_millis(mut self, input: i64) -> Self {
            self.end_timestamp_millis = Some(input);
            self
        }
        /// <p>The end time of the detected segment, in milliseconds, from the start of the video. This value is rounded down.</p>
        pub fn set_end_timestamp_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.end_timestamp_millis = input;
            self
        }
        /// <p>The duration of the detected segment in milliseconds. </p>
        pub fn duration_millis(mut self, input: i64) -> Self {
            self.duration_millis = Some(input);
            self
        }
        /// <p>The duration of the detected segment in milliseconds. </p>
        pub fn set_duration_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_millis = input;
            self
        }
        /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment. <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates). </p>
        pub fn start_timecode_smpte(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_timecode_smpte = Some(input.into());
            self
        }
        /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the start of a detected segment. <code>StartTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates). </p>
        pub fn set_start_timecode_smpte(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_timecode_smpte = input;
            self
        }
        /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment. <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).</p>
        pub fn end_timecode_smpte(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_timecode_smpte = Some(input.into());
            self
        }
        /// <p>The frame-accurate SMPTE timecode, from the start of a video, for the end of a detected segment. <code>EndTimecode</code> is in <i>HH:MM:SS:fr</i> format (and <i>;fr</i> for drop frame-rates).</p>
        pub fn set_end_timecode_smpte(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.end_timecode_smpte = input;
            self
        }
        /// <p>The duration of the timecode for the detected segment in SMPTE format.</p>
        pub fn duration_smpte(mut self, input: impl Into<std::string::String>) -> Self {
            self.duration_smpte = Some(input.into());
            self
        }
        /// <p>The duration of the timecode for the detected segment in SMPTE format.</p>
        pub fn set_duration_smpte(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.duration_smpte = input;
            self
        }
        /// <p>If the segment is a technical cue, contains information about the technical cue.</p>
        pub fn technical_cue_segment(mut self, input: crate::model::TechnicalCueSegment) -> Self {
            self.technical_cue_segment = Some(input);
            self
        }
        /// <p>If the segment is a technical cue, contains information about the technical cue.</p>
        pub fn set_technical_cue_segment(
            mut self,
            input: std::option::Option<crate::model::TechnicalCueSegment>,
        ) -> Self {
            self.technical_cue_segment = input;
            self
        }
        /// <p>If the segment is a shot detection, contains information about the shot detection.</p>
        pub fn shot_segment(mut self, input: crate::model::ShotSegment) -> Self {
            self.shot_segment = Some(input);
            self
        }
        /// <p>If the segment is a shot detection, contains information about the shot detection.</p>
        pub fn set_shot_segment(
            mut self,
            input: std::option::Option<crate::model::ShotSegment>,
        ) -> Self {
            self.shot_segment = input;
            self
        }
        /// <p> The frame number of the start of a video segment, using a frame index that starts with 0. </p>
        pub fn start_frame_number(mut self, input: i64) -> Self {
            self.start_frame_number = Some(input);
            self
        }
        /// <p> The frame number of the start of a video segment, using a frame index that starts with 0. </p>
        pub fn set_start_frame_number(mut self, input: std::option::Option<i64>) -> Self {
            self.start_frame_number = input;
            self
        }
        /// <p> The frame number at the end of a video segment, using a frame index that starts with 0. </p>
        pub fn end_frame_number(mut self, input: i64) -> Self {
            self.end_frame_number = Some(input);
            self
        }
        /// <p> The frame number at the end of a video segment, using a frame index that starts with 0. </p>
        pub fn set_end_frame_number(mut self, input: std::option::Option<i64>) -> Self {
            self.end_frame_number = input;
            self
        }
        /// <p> The duration of a video segment, expressed in frames. </p>
        pub fn duration_frames(mut self, input: i64) -> Self {
            self.duration_frames = Some(input);
            self
        }
        /// <p> The duration of a video segment, expressed in frames. </p>
        pub fn set_duration_frames(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_frames = input;
            self
        }
        /// Consumes the builder and constructs a [`SegmentDetection`](crate::model::SegmentDetection)
        pub fn build(self) -> crate::model::SegmentDetection {
            crate::model::SegmentDetection {
                r#type: self.r#type,
                start_timestamp_millis: self.start_timestamp_millis.unwrap_or_default(),
                end_timestamp_millis: self.end_timestamp_millis.unwrap_or_default(),
                duration_millis: self.duration_millis,
                start_timecode_smpte: self.start_timecode_smpte,
                end_timecode_smpte: self.end_timecode_smpte,
                duration_smpte: self.duration_smpte,
                technical_cue_segment: self.technical_cue_segment,
                shot_segment: self.shot_segment,
                start_frame_number: self.start_frame_number,
                end_frame_number: self.end_frame_number,
                duration_frames: self.duration_frames,
            }
        }
    }
}
impl SegmentDetection {
    /// Creates a new builder-style object to manufacture [`SegmentDetection`](crate::model::SegmentDetection)
    pub fn builder() -> crate::model::segment_detection::Builder {
        crate::model::segment_detection::Builder::default()
    }
}

/// <p>Information about a shot detection segment detected in a video. For more information, see <code>SegmentDetection</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ShotSegment {
    /// <p>An Identifier for a shot detection segment detected in a video. </p>
    pub index: std::option::Option<i64>,
    /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
    pub confidence: std::option::Option<f32>,
}
impl ShotSegment {
    /// <p>An Identifier for a shot detection segment detected in a video. </p>
    pub fn index(&self) -> std::option::Option<i64> {
        self.index
    }
    /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for ShotSegment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ShotSegment");
        formatter.field("index", &self.index);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`ShotSegment`](crate::model::ShotSegment)
pub mod shot_segment {
    /// A builder for [`ShotSegment`](crate::model::ShotSegment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i64>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>An Identifier for a shot detection segment detected in a video. </p>
        pub fn index(mut self, input: i64) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>An Identifier for a shot detection segment detected in a video. </p>
        pub fn set_index(mut self, input: std::option::Option<i64>) -> Self {
            self.index = input;
            self
        }
        /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`ShotSegment`](crate::model::ShotSegment)
        pub fn build(self) -> crate::model::ShotSegment {
            crate::model::ShotSegment {
                index: self.index,
                confidence: self.confidence,
            }
        }
    }
}
impl ShotSegment {
    /// Creates a new builder-style object to manufacture [`ShotSegment`](crate::model::ShotSegment)
    pub fn builder() -> crate::model::shot_segment::Builder {
        crate::model::shot_segment::Builder::default()
    }
}

/// <p>Information about a technical cue segment. For more information, see <code>SegmentDetection</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TechnicalCueSegment {
    /// <p>The type of the technical cue.</p>
    pub r#type: std::option::Option<crate::model::TechnicalCueType>,
    /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
    pub confidence: std::option::Option<f32>,
}
impl TechnicalCueSegment {
    /// <p>The type of the technical cue.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TechnicalCueType> {
        self.r#type.as_ref()
    }
    /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for TechnicalCueSegment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TechnicalCueSegment");
        formatter.field("r#type", &self.r#type);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`TechnicalCueSegment`](crate::model::TechnicalCueSegment)
pub mod technical_cue_segment {
    /// A builder for [`TechnicalCueSegment`](crate::model::TechnicalCueSegment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::TechnicalCueType>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The type of the technical cue.</p>
        pub fn r#type(mut self, input: crate::model::TechnicalCueType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the technical cue.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TechnicalCueType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition Video has in the accuracy of the detected segment.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`TechnicalCueSegment`](crate::model::TechnicalCueSegment)
        pub fn build(self) -> crate::model::TechnicalCueSegment {
            crate::model::TechnicalCueSegment {
                r#type: self.r#type,
                confidence: self.confidence,
            }
        }
    }
}
impl TechnicalCueSegment {
    /// Creates a new builder-style object to manufacture [`TechnicalCueSegment`](crate::model::TechnicalCueSegment)
    pub fn builder() -> crate::model::technical_cue_segment::Builder {
        crate::model::technical_cue_segment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TechnicalCueType {
    #[allow(missing_docs)] // documentation missing in model
    BlackFrames,
    #[allow(missing_docs)] // documentation missing in model
    ColorBars,
    #[allow(missing_docs)] // documentation missing in model
    Content,
    #[allow(missing_docs)] // documentation missing in model
    EndCredits,
    #[allow(missing_docs)] // documentation missing in model
    OpeningCredits,
    #[allow(missing_docs)] // documentation missing in model
    Slate,
    #[allow(missing_docs)] // documentation missing in model
    StudioLogo,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TechnicalCueType {
    fn from(s: &str) -> Self {
        match s {
            "BlackFrames" => TechnicalCueType::BlackFrames,
            "ColorBars" => TechnicalCueType::ColorBars,
            "Content" => TechnicalCueType::Content,
            "EndCredits" => TechnicalCueType::EndCredits,
            "OpeningCredits" => TechnicalCueType::OpeningCredits,
            "Slate" => TechnicalCueType::Slate,
            "StudioLogo" => TechnicalCueType::StudioLogo,
            other => TechnicalCueType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TechnicalCueType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TechnicalCueType::from(s))
    }
}
impl TechnicalCueType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TechnicalCueType::BlackFrames => "BlackFrames",
            TechnicalCueType::ColorBars => "ColorBars",
            TechnicalCueType::Content => "Content",
            TechnicalCueType::EndCredits => "EndCredits",
            TechnicalCueType::OpeningCredits => "OpeningCredits",
            TechnicalCueType::Slate => "Slate",
            TechnicalCueType::StudioLogo => "StudioLogo",
            TechnicalCueType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BlackFrames",
            "ColorBars",
            "Content",
            "EndCredits",
            "OpeningCredits",
            "Slate",
            "StudioLogo",
        ]
    }
}
impl AsRef<str> for TechnicalCueType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata information about an audio stream. An array of <code>AudioMetadata</code> objects for the audio streams found in a stored video is returned by <code>GetSegmentDetection</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioMetadata {
    /// <p>The audio codec used to encode or decode the audio stream. </p>
    pub codec: std::option::Option<std::string::String>,
    /// <p>The duration of the audio stream in milliseconds.</p>
    pub duration_millis: std::option::Option<i64>,
    /// <p>The sample rate for the audio stream.</p>
    pub sample_rate: std::option::Option<i64>,
    /// <p>The number of audio channels in the segment.</p>
    pub number_of_channels: std::option::Option<i64>,
}
impl AudioMetadata {
    /// <p>The audio codec used to encode or decode the audio stream. </p>
    pub fn codec(&self) -> std::option::Option<&str> {
        self.codec.as_deref()
    }
    /// <p>The duration of the audio stream in milliseconds.</p>
    pub fn duration_millis(&self) -> std::option::Option<i64> {
        self.duration_millis
    }
    /// <p>The sample rate for the audio stream.</p>
    pub fn sample_rate(&self) -> std::option::Option<i64> {
        self.sample_rate
    }
    /// <p>The number of audio channels in the segment.</p>
    pub fn number_of_channels(&self) -> std::option::Option<i64> {
        self.number_of_channels
    }
}
impl std::fmt::Debug for AudioMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioMetadata");
        formatter.field("codec", &self.codec);
        formatter.field("duration_millis", &self.duration_millis);
        formatter.field("sample_rate", &self.sample_rate);
        formatter.field("number_of_channels", &self.number_of_channels);
        formatter.finish()
    }
}
/// See [`AudioMetadata`](crate::model::AudioMetadata)
pub mod audio_metadata {
    /// A builder for [`AudioMetadata`](crate::model::AudioMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) codec: std::option::Option<std::string::String>,
        pub(crate) duration_millis: std::option::Option<i64>,
        pub(crate) sample_rate: std::option::Option<i64>,
        pub(crate) number_of_channels: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The audio codec used to encode or decode the audio stream. </p>
        pub fn codec(mut self, input: impl Into<std::string::String>) -> Self {
            self.codec = Some(input.into());
            self
        }
        /// <p>The audio codec used to encode or decode the audio stream. </p>
        pub fn set_codec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.codec = input;
            self
        }
        /// <p>The duration of the audio stream in milliseconds.</p>
        pub fn duration_millis(mut self, input: i64) -> Self {
            self.duration_millis = Some(input);
            self
        }
        /// <p>The duration of the audio stream in milliseconds.</p>
        pub fn set_duration_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_millis = input;
            self
        }
        /// <p>The sample rate for the audio stream.</p>
        pub fn sample_rate(mut self, input: i64) -> Self {
            self.sample_rate = Some(input);
            self
        }
        /// <p>The sample rate for the audio stream.</p>
        pub fn set_sample_rate(mut self, input: std::option::Option<i64>) -> Self {
            self.sample_rate = input;
            self
        }
        /// <p>The number of audio channels in the segment.</p>
        pub fn number_of_channels(mut self, input: i64) -> Self {
            self.number_of_channels = Some(input);
            self
        }
        /// <p>The number of audio channels in the segment.</p>
        pub fn set_number_of_channels(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_channels = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioMetadata`](crate::model::AudioMetadata)
        pub fn build(self) -> crate::model::AudioMetadata {
            crate::model::AudioMetadata {
                codec: self.codec,
                duration_millis: self.duration_millis,
                sample_rate: self.sample_rate,
                number_of_channels: self.number_of_channels,
            }
        }
    }
}
impl AudioMetadata {
    /// Creates a new builder-style object to manufacture [`AudioMetadata`](crate::model::AudioMetadata)
    pub fn builder() -> crate::model::audio_metadata::Builder {
        crate::model::audio_metadata::Builder::default()
    }
}

/// <p>Details and path tracking information for a single time a person's path is tracked in a video. Amazon Rekognition operations that track people's paths return an array of <code>PersonDetection</code> objects with elements for each time a person's path is tracked in a video. </p>
/// <p>For more information, see GetPersonTracking in the Amazon Rekognition Developer Guide. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PersonDetection {
    /// <p>The time, in milliseconds from the start of the video, that the person's path was tracked.</p>
    pub timestamp: i64,
    /// <p>Details about a person whose path was tracked in a video.</p>
    pub person: std::option::Option<crate::model::PersonDetail>,
}
impl PersonDetection {
    /// <p>The time, in milliseconds from the start of the video, that the person's path was tracked.</p>
    pub fn timestamp(&self) -> i64 {
        self.timestamp
    }
    /// <p>Details about a person whose path was tracked in a video.</p>
    pub fn person(&self) -> std::option::Option<&crate::model::PersonDetail> {
        self.person.as_ref()
    }
}
impl std::fmt::Debug for PersonDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PersonDetection");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("person", &self.person);
        formatter.finish()
    }
}
/// See [`PersonDetection`](crate::model::PersonDetection)
pub mod person_detection {
    /// A builder for [`PersonDetection`](crate::model::PersonDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) person: std::option::Option<crate::model::PersonDetail>,
    }
    impl Builder {
        /// <p>The time, in milliseconds from the start of the video, that the person's path was tracked.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time, in milliseconds from the start of the video, that the person's path was tracked.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Details about a person whose path was tracked in a video.</p>
        pub fn person(mut self, input: crate::model::PersonDetail) -> Self {
            self.person = Some(input);
            self
        }
        /// <p>Details about a person whose path was tracked in a video.</p>
        pub fn set_person(
            mut self,
            input: std::option::Option<crate::model::PersonDetail>,
        ) -> Self {
            self.person = input;
            self
        }
        /// Consumes the builder and constructs a [`PersonDetection`](crate::model::PersonDetection)
        pub fn build(self) -> crate::model::PersonDetection {
            crate::model::PersonDetection {
                timestamp: self.timestamp.unwrap_or_default(),
                person: self.person,
            }
        }
    }
}
impl PersonDetection {
    /// Creates a new builder-style object to manufacture [`PersonDetection`](crate::model::PersonDetection)
    pub fn builder() -> crate::model::person_detection::Builder {
        crate::model::person_detection::Builder::default()
    }
}

/// <p>Details about a person detected in a video analysis request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PersonDetail {
    /// <p>Identifier for the person detected person within a video. Use to keep track of the person throughout the video. The identifier is not stored by Amazon Rekognition.</p>
    pub index: i64,
    /// <p>Bounding box around the detected person.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>Face details for the detected person.</p>
    pub face: std::option::Option<crate::model::FaceDetail>,
}
impl PersonDetail {
    /// <p>Identifier for the person detected person within a video. Use to keep track of the person throughout the video. The identifier is not stored by Amazon Rekognition.</p>
    pub fn index(&self) -> i64 {
        self.index
    }
    /// <p>Bounding box around the detected person.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>Face details for the detected person.</p>
    pub fn face(&self) -> std::option::Option<&crate::model::FaceDetail> {
        self.face.as_ref()
    }
}
impl std::fmt::Debug for PersonDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PersonDetail");
        formatter.field("index", &self.index);
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("face", &self.face);
        formatter.finish()
    }
}
/// See [`PersonDetail`](crate::model::PersonDetail)
pub mod person_detail {
    /// A builder for [`PersonDetail`](crate::model::PersonDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index: std::option::Option<i64>,
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) face: std::option::Option<crate::model::FaceDetail>,
    }
    impl Builder {
        /// <p>Identifier for the person detected person within a video. Use to keep track of the person throughout the video. The identifier is not stored by Amazon Rekognition.</p>
        pub fn index(mut self, input: i64) -> Self {
            self.index = Some(input);
            self
        }
        /// <p>Identifier for the person detected person within a video. Use to keep track of the person throughout the video. The identifier is not stored by Amazon Rekognition.</p>
        pub fn set_index(mut self, input: std::option::Option<i64>) -> Self {
            self.index = input;
            self
        }
        /// <p>Bounding box around the detected person.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>Bounding box around the detected person.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>Face details for the detected person.</p>
        pub fn face(mut self, input: crate::model::FaceDetail) -> Self {
            self.face = Some(input);
            self
        }
        /// <p>Face details for the detected person.</p>
        pub fn set_face(mut self, input: std::option::Option<crate::model::FaceDetail>) -> Self {
            self.face = input;
            self
        }
        /// Consumes the builder and constructs a [`PersonDetail`](crate::model::PersonDetail)
        pub fn build(self) -> crate::model::PersonDetail {
            crate::model::PersonDetail {
                index: self.index.unwrap_or_default(),
                bounding_box: self.bounding_box,
                face: self.face,
            }
        }
    }
}
impl PersonDetail {
    /// Creates a new builder-style object to manufacture [`PersonDetail`](crate::model::PersonDetail)
    pub fn builder() -> crate::model::person_detail::Builder {
        crate::model::person_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PersonTrackingSortBy {
    #[allow(missing_docs)] // documentation missing in model
    Index,
    #[allow(missing_docs)] // documentation missing in model
    Timestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PersonTrackingSortBy {
    fn from(s: &str) -> Self {
        match s {
            "INDEX" => PersonTrackingSortBy::Index,
            "TIMESTAMP" => PersonTrackingSortBy::Timestamp,
            other => PersonTrackingSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PersonTrackingSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PersonTrackingSortBy::from(s))
    }
}
impl PersonTrackingSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PersonTrackingSortBy::Index => "INDEX",
            PersonTrackingSortBy::Timestamp => "TIMESTAMP",
            PersonTrackingSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INDEX", "TIMESTAMP"]
    }
}
impl AsRef<str> for PersonTrackingSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a label detected in a video analysis request and the time the label was detected in the video. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LabelDetection {
    /// <p>Time, in milliseconds from the start of the video, that the label was detected.</p>
    pub timestamp: i64,
    /// <p>Details about the detected label.</p>
    pub label: std::option::Option<crate::model::Label>,
}
impl LabelDetection {
    /// <p>Time, in milliseconds from the start of the video, that the label was detected.</p>
    pub fn timestamp(&self) -> i64 {
        self.timestamp
    }
    /// <p>Details about the detected label.</p>
    pub fn label(&self) -> std::option::Option<&crate::model::Label> {
        self.label.as_ref()
    }
}
impl std::fmt::Debug for LabelDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LabelDetection");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("label", &self.label);
        formatter.finish()
    }
}
/// See [`LabelDetection`](crate::model::LabelDetection)
pub mod label_detection {
    /// A builder for [`LabelDetection`](crate::model::LabelDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) label: std::option::Option<crate::model::Label>,
    }
    impl Builder {
        /// <p>Time, in milliseconds from the start of the video, that the label was detected.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Time, in milliseconds from the start of the video, that the label was detected.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Details about the detected label.</p>
        pub fn label(mut self, input: crate::model::Label) -> Self {
            self.label = Some(input);
            self
        }
        /// <p>Details about the detected label.</p>
        pub fn set_label(mut self, input: std::option::Option<crate::model::Label>) -> Self {
            self.label = input;
            self
        }
        /// Consumes the builder and constructs a [`LabelDetection`](crate::model::LabelDetection)
        pub fn build(self) -> crate::model::LabelDetection {
            crate::model::LabelDetection {
                timestamp: self.timestamp.unwrap_or_default(),
                label: self.label,
            }
        }
    }
}
impl LabelDetection {
    /// Creates a new builder-style object to manufacture [`LabelDetection`](crate::model::LabelDetection)
    pub fn builder() -> crate::model::label_detection::Builder {
        crate::model::label_detection::Builder::default()
    }
}

/// <p>Structure containing details about the detected label, including the name, detected instances, parent labels, and level of confidence.</p>
/// <p> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Label {
    /// <p>The name (label) of the object or scene.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Level of confidence.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each instance of the detected object. Bounding boxes are returned for common object labels such as people, cars, furniture, apparel or pets.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    /// <p>The parent labels for a label. The response includes all ancestor labels.</p>
    pub parents: std::option::Option<std::vec::Vec<crate::model::Parent>>,
}
impl Label {
    /// <p>The name (label) of the object or scene.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Level of confidence.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each instance of the detected object. Bounding boxes are returned for common object labels such as people, cars, furniture, apparel or pets.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::Instance]> {
        self.instances.as_deref()
    }
    /// <p>The parent labels for a label. The response includes all ancestor labels.</p>
    pub fn parents(&self) -> std::option::Option<&[crate::model::Parent]> {
        self.parents.as_deref()
    }
}
impl std::fmt::Debug for Label {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Label");
        formatter.field("name", &self.name);
        formatter.field("confidence", &self.confidence);
        formatter.field("instances", &self.instances);
        formatter.field("parents", &self.parents);
        formatter.finish()
    }
}
/// See [`Label`](crate::model::Label)
pub mod label {
    /// A builder for [`Label`](crate::model::Label)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        pub(crate) parents: std::option::Option<std::vec::Vec<crate::model::Parent>>,
    }
    impl Builder {
        /// <p>The name (label) of the object or scene.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name (label) of the object or scene.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Level of confidence.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Level of confidence.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each instance of the detected object. Bounding boxes are returned for common object labels such as people, cars, furniture, apparel or pets.</p>
        pub fn instances(mut self, input: crate::model::Instance) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input);
            self.instances = Some(v);
            self
        }
        /// <p>If <code>Label</code> represents an object, <code>Instances</code> contains the bounding boxes for each instance of the detected object. Bounding boxes are returned for common object labels such as people, cars, furniture, apparel or pets.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Appends an item to `parents`.
        ///
        /// To override the contents of this collection use [`set_parents`](Self::set_parents).
        ///
        /// <p>The parent labels for a label. The response includes all ancestor labels.</p>
        pub fn parents(mut self, input: crate::model::Parent) -> Self {
            let mut v = self.parents.unwrap_or_default();
            v.push(input);
            self.parents = Some(v);
            self
        }
        /// <p>The parent labels for a label. The response includes all ancestor labels.</p>
        pub fn set_parents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parent>>,
        ) -> Self {
            self.parents = input;
            self
        }
        /// Consumes the builder and constructs a [`Label`](crate::model::Label)
        pub fn build(self) -> crate::model::Label {
            crate::model::Label {
                name: self.name,
                confidence: self.confidence,
                instances: self.instances,
                parents: self.parents,
            }
        }
    }
}
impl Label {
    /// Creates a new builder-style object to manufacture [`Label`](crate::model::Label)
    pub fn builder() -> crate::model::label::Builder {
        crate::model::label::Builder::default()
    }
}

/// <p>A parent label for a label. A label can have 0, 1, or more parents. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parent {
    /// <p>The name of the parent label.</p>
    pub name: std::option::Option<std::string::String>,
}
impl Parent {
    /// <p>The name of the parent label.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for Parent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parent");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Parent`](crate::model::Parent)
pub mod parent {
    /// A builder for [`Parent`](crate::model::Parent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parent label.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parent label.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Parent`](crate::model::Parent)
        pub fn build(self) -> crate::model::Parent {
            crate::model::Parent { name: self.name }
        }
    }
}
impl Parent {
    /// Creates a new builder-style object to manufacture [`Parent`](crate::model::Parent)
    pub fn builder() -> crate::model::parent::Builder {
        crate::model::parent::Builder::default()
    }
}

/// <p>An instance of a label returned by Amazon Rekognition Image (<code>DetectLabels</code>) or by Amazon Rekognition Video (<code>GetLabelDetection</code>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The position of the label instance on the image.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>The confidence that Amazon Rekognition has in the accuracy of the bounding box.</p>
    pub confidence: std::option::Option<f32>,
}
impl Instance {
    /// <p>The position of the label instance on the image.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>The confidence that Amazon Rekognition has in the accuracy of the bounding box.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The position of the label instance on the image.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>The position of the label instance on the image.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>The confidence that Amazon Rekognition has in the accuracy of the bounding box.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition has in the accuracy of the bounding box.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                bounding_box: self.bounding_box,
                confidence: self.confidence,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LabelDetectionSortBy {
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Timestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LabelDetectionSortBy {
    fn from(s: &str) -> Self {
        match s {
            "NAME" => LabelDetectionSortBy::Name,
            "TIMESTAMP" => LabelDetectionSortBy::Timestamp,
            other => LabelDetectionSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LabelDetectionSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LabelDetectionSortBy::from(s))
    }
}
impl LabelDetectionSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LabelDetectionSortBy::Name => "NAME",
            LabelDetectionSortBy::Timestamp => "TIMESTAMP",
            LabelDetectionSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NAME", "TIMESTAMP"]
    }
}
impl AsRef<str> for LabelDetectionSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a person whose face matches a face(s) in an Amazon Rekognition collection. Includes information about the faces in the Amazon Rekognition collection (<code>FaceMatch</code>), information about the person (<code>PersonDetail</code>), and the time stamp for when the person was detected in a video. An array of <code>PersonMatch</code> objects is returned by <code>GetFaceSearch</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PersonMatch {
    /// <p>The time, in milliseconds from the beginning of the video, that the person was matched in the video.</p>
    pub timestamp: i64,
    /// <p>Information about the matched person.</p>
    pub person: std::option::Option<crate::model::PersonDetail>,
    /// <p>Information about the faces in the input collection that match the face of a person in the video.</p>
    pub face_matches: std::option::Option<std::vec::Vec<crate::model::FaceMatch>>,
}
impl PersonMatch {
    /// <p>The time, in milliseconds from the beginning of the video, that the person was matched in the video.</p>
    pub fn timestamp(&self) -> i64 {
        self.timestamp
    }
    /// <p>Information about the matched person.</p>
    pub fn person(&self) -> std::option::Option<&crate::model::PersonDetail> {
        self.person.as_ref()
    }
    /// <p>Information about the faces in the input collection that match the face of a person in the video.</p>
    pub fn face_matches(&self) -> std::option::Option<&[crate::model::FaceMatch]> {
        self.face_matches.as_deref()
    }
}
impl std::fmt::Debug for PersonMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PersonMatch");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("person", &self.person);
        formatter.field("face_matches", &self.face_matches);
        formatter.finish()
    }
}
/// See [`PersonMatch`](crate::model::PersonMatch)
pub mod person_match {
    /// A builder for [`PersonMatch`](crate::model::PersonMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) person: std::option::Option<crate::model::PersonDetail>,
        pub(crate) face_matches: std::option::Option<std::vec::Vec<crate::model::FaceMatch>>,
    }
    impl Builder {
        /// <p>The time, in milliseconds from the beginning of the video, that the person was matched in the video.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time, in milliseconds from the beginning of the video, that the person was matched in the video.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Information about the matched person.</p>
        pub fn person(mut self, input: crate::model::PersonDetail) -> Self {
            self.person = Some(input);
            self
        }
        /// <p>Information about the matched person.</p>
        pub fn set_person(
            mut self,
            input: std::option::Option<crate::model::PersonDetail>,
        ) -> Self {
            self.person = input;
            self
        }
        /// Appends an item to `face_matches`.
        ///
        /// To override the contents of this collection use [`set_face_matches`](Self::set_face_matches).
        ///
        /// <p>Information about the faces in the input collection that match the face of a person in the video.</p>
        pub fn face_matches(mut self, input: crate::model::FaceMatch) -> Self {
            let mut v = self.face_matches.unwrap_or_default();
            v.push(input);
            self.face_matches = Some(v);
            self
        }
        /// <p>Information about the faces in the input collection that match the face of a person in the video.</p>
        pub fn set_face_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FaceMatch>>,
        ) -> Self {
            self.face_matches = input;
            self
        }
        /// Consumes the builder and constructs a [`PersonMatch`](crate::model::PersonMatch)
        pub fn build(self) -> crate::model::PersonMatch {
            crate::model::PersonMatch {
                timestamp: self.timestamp.unwrap_or_default(),
                person: self.person,
                face_matches: self.face_matches,
            }
        }
    }
}
impl PersonMatch {
    /// Creates a new builder-style object to manufacture [`PersonMatch`](crate::model::PersonMatch)
    pub fn builder() -> crate::model::person_match::Builder {
        crate::model::person_match::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FaceSearchSortBy {
    #[allow(missing_docs)] // documentation missing in model
    Index,
    #[allow(missing_docs)] // documentation missing in model
    Timestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FaceSearchSortBy {
    fn from(s: &str) -> Self {
        match s {
            "INDEX" => FaceSearchSortBy::Index,
            "TIMESTAMP" => FaceSearchSortBy::Timestamp,
            other => FaceSearchSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FaceSearchSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FaceSearchSortBy::from(s))
    }
}
impl FaceSearchSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FaceSearchSortBy::Index => "INDEX",
            FaceSearchSortBy::Timestamp => "TIMESTAMP",
            FaceSearchSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INDEX", "TIMESTAMP"]
    }
}
impl AsRef<str> for FaceSearchSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a face detected in a video analysis request and the time the face was detected in the video. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaceDetection {
    /// <p>Time, in milliseconds from the start of the video, that the face was detected.</p>
    pub timestamp: i64,
    /// <p>The face properties for the detected face.</p>
    pub face: std::option::Option<crate::model::FaceDetail>,
}
impl FaceDetection {
    /// <p>Time, in milliseconds from the start of the video, that the face was detected.</p>
    pub fn timestamp(&self) -> i64 {
        self.timestamp
    }
    /// <p>The face properties for the detected face.</p>
    pub fn face(&self) -> std::option::Option<&crate::model::FaceDetail> {
        self.face.as_ref()
    }
}
impl std::fmt::Debug for FaceDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaceDetection");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("face", &self.face);
        formatter.finish()
    }
}
/// See [`FaceDetection`](crate::model::FaceDetection)
pub mod face_detection {
    /// A builder for [`FaceDetection`](crate::model::FaceDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) face: std::option::Option<crate::model::FaceDetail>,
    }
    impl Builder {
        /// <p>Time, in milliseconds from the start of the video, that the face was detected.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Time, in milliseconds from the start of the video, that the face was detected.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The face properties for the detected face.</p>
        pub fn face(mut self, input: crate::model::FaceDetail) -> Self {
            self.face = Some(input);
            self
        }
        /// <p>The face properties for the detected face.</p>
        pub fn set_face(mut self, input: std::option::Option<crate::model::FaceDetail>) -> Self {
            self.face = input;
            self
        }
        /// Consumes the builder and constructs a [`FaceDetection`](crate::model::FaceDetection)
        pub fn build(self) -> crate::model::FaceDetection {
            crate::model::FaceDetection {
                timestamp: self.timestamp.unwrap_or_default(),
                face: self.face,
            }
        }
    }
}
impl FaceDetection {
    /// Creates a new builder-style object to manufacture [`FaceDetection`](crate::model::FaceDetection)
    pub fn builder() -> crate::model::face_detection::Builder {
        crate::model::face_detection::Builder::default()
    }
}

/// <p>Information about an inappropriate, unwanted, or offensive content label detection in a stored video.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContentModerationDetection {
    /// <p>Time, in milliseconds from the beginning of the video, that the content moderation label was detected.</p>
    pub timestamp: i64,
    /// <p>The content moderation label detected by in the stored video.</p>
    pub moderation_label: std::option::Option<crate::model::ModerationLabel>,
}
impl ContentModerationDetection {
    /// <p>Time, in milliseconds from the beginning of the video, that the content moderation label was detected.</p>
    pub fn timestamp(&self) -> i64 {
        self.timestamp
    }
    /// <p>The content moderation label detected by in the stored video.</p>
    pub fn moderation_label(&self) -> std::option::Option<&crate::model::ModerationLabel> {
        self.moderation_label.as_ref()
    }
}
impl std::fmt::Debug for ContentModerationDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContentModerationDetection");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("moderation_label", &self.moderation_label);
        formatter.finish()
    }
}
/// See [`ContentModerationDetection`](crate::model::ContentModerationDetection)
pub mod content_moderation_detection {
    /// A builder for [`ContentModerationDetection`](crate::model::ContentModerationDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) moderation_label: std::option::Option<crate::model::ModerationLabel>,
    }
    impl Builder {
        /// <p>Time, in milliseconds from the beginning of the video, that the content moderation label was detected.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Time, in milliseconds from the beginning of the video, that the content moderation label was detected.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The content moderation label detected by in the stored video.</p>
        pub fn moderation_label(mut self, input: crate::model::ModerationLabel) -> Self {
            self.moderation_label = Some(input);
            self
        }
        /// <p>The content moderation label detected by in the stored video.</p>
        pub fn set_moderation_label(
            mut self,
            input: std::option::Option<crate::model::ModerationLabel>,
        ) -> Self {
            self.moderation_label = input;
            self
        }
        /// Consumes the builder and constructs a [`ContentModerationDetection`](crate::model::ContentModerationDetection)
        pub fn build(self) -> crate::model::ContentModerationDetection {
            crate::model::ContentModerationDetection {
                timestamp: self.timestamp.unwrap_or_default(),
                moderation_label: self.moderation_label,
            }
        }
    }
}
impl ContentModerationDetection {
    /// Creates a new builder-style object to manufacture [`ContentModerationDetection`](crate::model::ContentModerationDetection)
    pub fn builder() -> crate::model::content_moderation_detection::Builder {
        crate::model::content_moderation_detection::Builder::default()
    }
}

/// <p>Provides information about a single type of inappropriate, unwanted, or offensive content found in an image or video. Each type of moderated content has a label within a hierarchical taxonomy. For more information, see Content moderation in the Amazon Rekognition Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModerationLabel {
    /// <p>Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
    /// <p>If you don't specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or equal to 50 percent.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>The label name for the type of unsafe content detected in the image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name for the parent label. Labels at the top level of the hierarchy have the parent label <code>""</code>.</p>
    pub parent_name: std::option::Option<std::string::String>,
}
impl ModerationLabel {
    /// <p>Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
    /// <p>If you don't specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or equal to 50 percent.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>The label name for the type of unsafe content detected in the image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name for the parent label. Labels at the top level of the hierarchy have the parent label <code>""</code>.</p>
    pub fn parent_name(&self) -> std::option::Option<&str> {
        self.parent_name.as_deref()
    }
}
impl std::fmt::Debug for ModerationLabel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModerationLabel");
        formatter.field("confidence", &self.confidence);
        formatter.field("name", &self.name);
        formatter.field("parent_name", &self.parent_name);
        formatter.finish()
    }
}
/// See [`ModerationLabel`](crate::model::ModerationLabel)
pub mod moderation_label {
    /// A builder for [`ModerationLabel`](crate::model::ModerationLabel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
        /// <p>If you don't specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or equal to 50 percent.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
        /// <p>If you don't specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or equal to 50 percent.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The label name for the type of unsafe content detected in the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The label name for the type of unsafe content detected in the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name for the parent label. Labels at the top level of the hierarchy have the parent label <code>""</code>.</p>
        pub fn parent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_name = Some(input.into());
            self
        }
        /// <p>The name for the parent label. Labels at the top level of the hierarchy have the parent label <code>""</code>.</p>
        pub fn set_parent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ModerationLabel`](crate::model::ModerationLabel)
        pub fn build(self) -> crate::model::ModerationLabel {
            crate::model::ModerationLabel {
                confidence: self.confidence,
                name: self.name,
                parent_name: self.parent_name,
            }
        }
    }
}
impl ModerationLabel {
    /// Creates a new builder-style object to manufacture [`ModerationLabel`](crate::model::ModerationLabel)
    pub fn builder() -> crate::model::moderation_label::Builder {
        crate::model::moderation_label::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentModerationSortBy {
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Timestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentModerationSortBy {
    fn from(s: &str) -> Self {
        match s {
            "NAME" => ContentModerationSortBy::Name,
            "TIMESTAMP" => ContentModerationSortBy::Timestamp,
            other => ContentModerationSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentModerationSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentModerationSortBy::from(s))
    }
}
impl ContentModerationSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentModerationSortBy::Name => "NAME",
            ContentModerationSortBy::Timestamp => "TIMESTAMP",
            ContentModerationSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NAME", "TIMESTAMP"]
    }
}
impl AsRef<str> for ContentModerationSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a detected celebrity and the time the celebrity was detected in a stored video. For more information, see GetCelebrityRecognition in the Amazon Rekognition Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CelebrityRecognition {
    /// <p>The time, in milliseconds from the start of the video, that the celebrity was recognized.</p>
    pub timestamp: i64,
    /// <p>Information about a recognized celebrity.</p>
    pub celebrity: std::option::Option<crate::model::CelebrityDetail>,
}
impl CelebrityRecognition {
    /// <p>The time, in milliseconds from the start of the video, that the celebrity was recognized.</p>
    pub fn timestamp(&self) -> i64 {
        self.timestamp
    }
    /// <p>Information about a recognized celebrity.</p>
    pub fn celebrity(&self) -> std::option::Option<&crate::model::CelebrityDetail> {
        self.celebrity.as_ref()
    }
}
impl std::fmt::Debug for CelebrityRecognition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CelebrityRecognition");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("celebrity", &self.celebrity);
        formatter.finish()
    }
}
/// See [`CelebrityRecognition`](crate::model::CelebrityRecognition)
pub mod celebrity_recognition {
    /// A builder for [`CelebrityRecognition`](crate::model::CelebrityRecognition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) celebrity: std::option::Option<crate::model::CelebrityDetail>,
    }
    impl Builder {
        /// <p>The time, in milliseconds from the start of the video, that the celebrity was recognized.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time, in milliseconds from the start of the video, that the celebrity was recognized.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>Information about a recognized celebrity.</p>
        pub fn celebrity(mut self, input: crate::model::CelebrityDetail) -> Self {
            self.celebrity = Some(input);
            self
        }
        /// <p>Information about a recognized celebrity.</p>
        pub fn set_celebrity(
            mut self,
            input: std::option::Option<crate::model::CelebrityDetail>,
        ) -> Self {
            self.celebrity = input;
            self
        }
        /// Consumes the builder and constructs a [`CelebrityRecognition`](crate::model::CelebrityRecognition)
        pub fn build(self) -> crate::model::CelebrityRecognition {
            crate::model::CelebrityRecognition {
                timestamp: self.timestamp.unwrap_or_default(),
                celebrity: self.celebrity,
            }
        }
    }
}
impl CelebrityRecognition {
    /// Creates a new builder-style object to manufacture [`CelebrityRecognition`](crate::model::CelebrityRecognition)
    pub fn builder() -> crate::model::celebrity_recognition::Builder {
        crate::model::celebrity_recognition::Builder::default()
    }
}

/// <p>Information about a recognized celebrity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CelebrityDetail {
    /// <p>An array of URLs pointing to additional celebrity information. </p>
    pub urls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the celebrity.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the celebrity. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity. </p>
    pub confidence: std::option::Option<f32>,
    /// <p>Bounding box around the body of a celebrity.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>Face details for the recognized celebrity.</p>
    pub face: std::option::Option<crate::model::FaceDetail>,
    /// <p>Retrieves the known gender for the celebrity.</p>
    pub known_gender: std::option::Option<crate::model::KnownGender>,
}
impl CelebrityDetail {
    /// <p>An array of URLs pointing to additional celebrity information. </p>
    pub fn urls(&self) -> std::option::Option<&[std::string::String]> {
        self.urls.as_deref()
    }
    /// <p>The name of the celebrity.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The unique identifier for the celebrity. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity. </p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>Bounding box around the body of a celebrity.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>Face details for the recognized celebrity.</p>
    pub fn face(&self) -> std::option::Option<&crate::model::FaceDetail> {
        self.face.as_ref()
    }
    /// <p>Retrieves the known gender for the celebrity.</p>
    pub fn known_gender(&self) -> std::option::Option<&crate::model::KnownGender> {
        self.known_gender.as_ref()
    }
}
impl std::fmt::Debug for CelebrityDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CelebrityDetail");
        formatter.field("urls", &self.urls);
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("confidence", &self.confidence);
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("face", &self.face);
        formatter.field("known_gender", &self.known_gender);
        formatter.finish()
    }
}
/// See [`CelebrityDetail`](crate::model::CelebrityDetail)
pub mod celebrity_detail {
    /// A builder for [`CelebrityDetail`](crate::model::CelebrityDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) urls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) face: std::option::Option<crate::model::FaceDetail>,
        pub(crate) known_gender: std::option::Option<crate::model::KnownGender>,
    }
    impl Builder {
        /// Appends an item to `urls`.
        ///
        /// To override the contents of this collection use [`set_urls`](Self::set_urls).
        ///
        /// <p>An array of URLs pointing to additional celebrity information. </p>
        pub fn urls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.urls.unwrap_or_default();
            v.push(input.into());
            self.urls = Some(v);
            self
        }
        /// <p>An array of URLs pointing to additional celebrity information. </p>
        pub fn set_urls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.urls = input;
            self
        }
        /// <p>The name of the celebrity.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the celebrity.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The unique identifier for the celebrity. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the celebrity. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity. </p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence, in percentage, that Amazon Rekognition has that the recognized face is the celebrity. </p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>Bounding box around the body of a celebrity.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>Bounding box around the body of a celebrity.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>Face details for the recognized celebrity.</p>
        pub fn face(mut self, input: crate::model::FaceDetail) -> Self {
            self.face = Some(input);
            self
        }
        /// <p>Face details for the recognized celebrity.</p>
        pub fn set_face(mut self, input: std::option::Option<crate::model::FaceDetail>) -> Self {
            self.face = input;
            self
        }
        /// <p>Retrieves the known gender for the celebrity.</p>
        pub fn known_gender(mut self, input: crate::model::KnownGender) -> Self {
            self.known_gender = Some(input);
            self
        }
        /// <p>Retrieves the known gender for the celebrity.</p>
        pub fn set_known_gender(
            mut self,
            input: std::option::Option<crate::model::KnownGender>,
        ) -> Self {
            self.known_gender = input;
            self
        }
        /// Consumes the builder and constructs a [`CelebrityDetail`](crate::model::CelebrityDetail)
        pub fn build(self) -> crate::model::CelebrityDetail {
            crate::model::CelebrityDetail {
                urls: self.urls,
                name: self.name,
                id: self.id,
                confidence: self.confidence,
                bounding_box: self.bounding_box,
                face: self.face,
                known_gender: self.known_gender,
            }
        }
    }
}
impl CelebrityDetail {
    /// Creates a new builder-style object to manufacture [`CelebrityDetail`](crate::model::CelebrityDetail)
    pub fn builder() -> crate::model::celebrity_detail::Builder {
        crate::model::celebrity_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CelebrityRecognitionSortBy {
    #[allow(missing_docs)] // documentation missing in model
    Id,
    #[allow(missing_docs)] // documentation missing in model
    Timestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CelebrityRecognitionSortBy {
    fn from(s: &str) -> Self {
        match s {
            "ID" => CelebrityRecognitionSortBy::Id,
            "TIMESTAMP" => CelebrityRecognitionSortBy::Timestamp,
            other => CelebrityRecognitionSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CelebrityRecognitionSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CelebrityRecognitionSortBy::from(s))
    }
}
impl CelebrityRecognitionSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CelebrityRecognitionSortBy::Id => "ID",
            CelebrityRecognitionSortBy::Timestamp => "TIMESTAMP",
            CelebrityRecognitionSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ID", "TIMESTAMP"]
    }
}
impl AsRef<str> for CelebrityRecognitionSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A training dataset or a test dataset used in a dataset distribution operation. For more information, see <code>DistributeDatasetEntries</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DistributeDataset {
    /// <p>The Amazon Resource Name (ARN) of the dataset that you want to use. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl DistributeDataset {
    /// <p>The Amazon Resource Name (ARN) of the dataset that you want to use. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for DistributeDataset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DistributeDataset");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DistributeDataset`](crate::model::DistributeDataset)
pub mod distribute_dataset {
    /// A builder for [`DistributeDataset`](crate::model::DistributeDataset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the dataset that you want to use. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dataset that you want to use. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DistributeDataset`](crate::model::DistributeDataset)
        pub fn build(self) -> crate::model::DistributeDataset {
            crate::model::DistributeDataset { arn: self.arn }
        }
    }
}
impl DistributeDataset {
    /// Creates a new builder-style object to manufacture [`DistributeDataset`](crate::model::DistributeDataset)
    pub fn builder() -> crate::model::distribute_dataset::Builder {
        crate::model::distribute_dataset::Builder::default()
    }
}

/// <p>A set of optional parameters that you can use to set the criteria that the text must meet to be included in your response. <code>WordFilter</code> looks at a word’s height, width, and minimum confidence. <code>RegionOfInterest</code> lets you set a specific region of the image to look for text in. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectTextFilters {
    /// <p>A set of parameters that allow you to filter out certain results from your returned results.</p>
    pub word_filter: std::option::Option<crate::model::DetectionFilter>,
    /// <p> A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of the image.</p>
    pub regions_of_interest: std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
}
impl DetectTextFilters {
    /// <p>A set of parameters that allow you to filter out certain results from your returned results.</p>
    pub fn word_filter(&self) -> std::option::Option<&crate::model::DetectionFilter> {
        self.word_filter.as_ref()
    }
    /// <p> A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of the image.</p>
    pub fn regions_of_interest(&self) -> std::option::Option<&[crate::model::RegionOfInterest]> {
        self.regions_of_interest.as_deref()
    }
}
impl std::fmt::Debug for DetectTextFilters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectTextFilters");
        formatter.field("word_filter", &self.word_filter);
        formatter.field("regions_of_interest", &self.regions_of_interest);
        formatter.finish()
    }
}
/// See [`DetectTextFilters`](crate::model::DetectTextFilters)
pub mod detect_text_filters {
    /// A builder for [`DetectTextFilters`](crate::model::DetectTextFilters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) word_filter: std::option::Option<crate::model::DetectionFilter>,
        pub(crate) regions_of_interest:
            std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
    }
    impl Builder {
        /// <p>A set of parameters that allow you to filter out certain results from your returned results.</p>
        pub fn word_filter(mut self, input: crate::model::DetectionFilter) -> Self {
            self.word_filter = Some(input);
            self
        }
        /// <p>A set of parameters that allow you to filter out certain results from your returned results.</p>
        pub fn set_word_filter(
            mut self,
            input: std::option::Option<crate::model::DetectionFilter>,
        ) -> Self {
            self.word_filter = input;
            self
        }
        /// Appends an item to `regions_of_interest`.
        ///
        /// To override the contents of this collection use [`set_regions_of_interest`](Self::set_regions_of_interest).
        ///
        /// <p> A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of the image.</p>
        pub fn regions_of_interest(mut self, input: crate::model::RegionOfInterest) -> Self {
            let mut v = self.regions_of_interest.unwrap_or_default();
            v.push(input);
            self.regions_of_interest = Some(v);
            self
        }
        /// <p> A Filter focusing on a certain area of the image. Uses a <code>BoundingBox</code> object to set the region of the image.</p>
        pub fn set_regions_of_interest(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
        ) -> Self {
            self.regions_of_interest = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectTextFilters`](crate::model::DetectTextFilters)
        pub fn build(self) -> crate::model::DetectTextFilters {
            crate::model::DetectTextFilters {
                word_filter: self.word_filter,
                regions_of_interest: self.regions_of_interest,
            }
        }
    }
}
impl DetectTextFilters {
    /// Creates a new builder-style object to manufacture [`DetectTextFilters`](crate::model::DetectTextFilters)
    pub fn builder() -> crate::model::detect_text_filters::Builder {
        crate::model::detect_text_filters::Builder::default()
    }
}

/// <p>Summary information for required items of personal protective equipment (PPE) detected on persons by a call to <code>DetectProtectiveEquipment</code>. You specify the required type of PPE in the <code>SummarizationAttributes</code> (<code>ProtectiveEquipmentSummarizationAttributes</code>) input parameter. The summary includes which persons were detected wearing the required personal protective equipment (<code>PersonsWithRequiredEquipment</code>), which persons were detected as not wearing the required PPE (<code>PersonsWithoutRequiredEquipment</code>), and the persons in which a determination could not be made (<code>PersonsIndeterminate</code>).</p>
/// <p>To get a total for each category, use the size of the field array. For example, to find out how many people were detected as wearing the specified PPE, use the size of the <code>PersonsWithRequiredEquipment</code> array. If you want to find out more about a person, such as the location (<code>BoundingBox</code>) of the person on the image, use the person ID in each array element. Each person ID matches the ID field of a <code>ProtectiveEquipmentPerson</code> object returned in the <code>Persons</code> array by <code>DetectProtectiveEquipment</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectiveEquipmentSummary {
    /// <p>An array of IDs for persons who are wearing detected personal protective equipment. </p>
    pub persons_with_required_equipment: std::option::Option<std::vec::Vec<i32>>,
    /// <p>An array of IDs for persons who are not wearing all of the types of PPE specified in the <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment. </p>
    pub persons_without_required_equipment: std::option::Option<std::vec::Vec<i32>>,
    /// <p>An array of IDs for persons where it was not possible to determine if they are wearing personal protective equipment. </p>
    pub persons_indeterminate: std::option::Option<std::vec::Vec<i32>>,
}
impl ProtectiveEquipmentSummary {
    /// <p>An array of IDs for persons who are wearing detected personal protective equipment. </p>
    pub fn persons_with_required_equipment(&self) -> std::option::Option<&[i32]> {
        self.persons_with_required_equipment.as_deref()
    }
    /// <p>An array of IDs for persons who are not wearing all of the types of PPE specified in the <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment. </p>
    pub fn persons_without_required_equipment(&self) -> std::option::Option<&[i32]> {
        self.persons_without_required_equipment.as_deref()
    }
    /// <p>An array of IDs for persons where it was not possible to determine if they are wearing personal protective equipment. </p>
    pub fn persons_indeterminate(&self) -> std::option::Option<&[i32]> {
        self.persons_indeterminate.as_deref()
    }
}
impl std::fmt::Debug for ProtectiveEquipmentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectiveEquipmentSummary");
        formatter.field(
            "persons_with_required_equipment",
            &self.persons_with_required_equipment,
        );
        formatter.field(
            "persons_without_required_equipment",
            &self.persons_without_required_equipment,
        );
        formatter.field("persons_indeterminate", &self.persons_indeterminate);
        formatter.finish()
    }
}
/// See [`ProtectiveEquipmentSummary`](crate::model::ProtectiveEquipmentSummary)
pub mod protective_equipment_summary {
    /// A builder for [`ProtectiveEquipmentSummary`](crate::model::ProtectiveEquipmentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) persons_with_required_equipment: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) persons_without_required_equipment: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) persons_indeterminate: std::option::Option<std::vec::Vec<i32>>,
    }
    impl Builder {
        /// Appends an item to `persons_with_required_equipment`.
        ///
        /// To override the contents of this collection use [`set_persons_with_required_equipment`](Self::set_persons_with_required_equipment).
        ///
        /// <p>An array of IDs for persons who are wearing detected personal protective equipment. </p>
        pub fn persons_with_required_equipment(mut self, input: i32) -> Self {
            let mut v = self.persons_with_required_equipment.unwrap_or_default();
            v.push(input);
            self.persons_with_required_equipment = Some(v);
            self
        }
        /// <p>An array of IDs for persons who are wearing detected personal protective equipment. </p>
        pub fn set_persons_with_required_equipment(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.persons_with_required_equipment = input;
            self
        }
        /// Appends an item to `persons_without_required_equipment`.
        ///
        /// To override the contents of this collection use [`set_persons_without_required_equipment`](Self::set_persons_without_required_equipment).
        ///
        /// <p>An array of IDs for persons who are not wearing all of the types of PPE specified in the <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment. </p>
        pub fn persons_without_required_equipment(mut self, input: i32) -> Self {
            let mut v = self.persons_without_required_equipment.unwrap_or_default();
            v.push(input);
            self.persons_without_required_equipment = Some(v);
            self
        }
        /// <p>An array of IDs for persons who are not wearing all of the types of PPE specified in the <code>RequiredEquipmentTypes</code> field of the detected personal protective equipment. </p>
        pub fn set_persons_without_required_equipment(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.persons_without_required_equipment = input;
            self
        }
        /// Appends an item to `persons_indeterminate`.
        ///
        /// To override the contents of this collection use [`set_persons_indeterminate`](Self::set_persons_indeterminate).
        ///
        /// <p>An array of IDs for persons where it was not possible to determine if they are wearing personal protective equipment. </p>
        pub fn persons_indeterminate(mut self, input: i32) -> Self {
            let mut v = self.persons_indeterminate.unwrap_or_default();
            v.push(input);
            self.persons_indeterminate = Some(v);
            self
        }
        /// <p>An array of IDs for persons where it was not possible to determine if they are wearing personal protective equipment. </p>
        pub fn set_persons_indeterminate(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.persons_indeterminate = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectiveEquipmentSummary`](crate::model::ProtectiveEquipmentSummary)
        pub fn build(self) -> crate::model::ProtectiveEquipmentSummary {
            crate::model::ProtectiveEquipmentSummary {
                persons_with_required_equipment: self.persons_with_required_equipment,
                persons_without_required_equipment: self.persons_without_required_equipment,
                persons_indeterminate: self.persons_indeterminate,
            }
        }
    }
}
impl ProtectiveEquipmentSummary {
    /// Creates a new builder-style object to manufacture [`ProtectiveEquipmentSummary`](crate::model::ProtectiveEquipmentSummary)
    pub fn builder() -> crate::model::protective_equipment_summary::Builder {
        crate::model::protective_equipment_summary::Builder::default()
    }
}

/// <p>A person detected by a call to <code>DetectProtectiveEquipment</code>. The API returns all persons detected in the input image in an array of <code>ProtectiveEquipmentPerson</code> objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectiveEquipmentPerson {
    /// <p>An array of body parts detected on a person's body (including body parts without PPE). </p>
    pub body_parts: std::option::Option<std::vec::Vec<crate::model::ProtectiveEquipmentBodyPart>>,
    /// <p>A bounding box around the detected person.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>The confidence that Amazon Rekognition has that the bounding box contains a person.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>The identifier for the detected person. The identifier is only unique for a single call to <code>DetectProtectiveEquipment</code>.</p>
    pub id: std::option::Option<i32>,
}
impl ProtectiveEquipmentPerson {
    /// <p>An array of body parts detected on a person's body (including body parts without PPE). </p>
    pub fn body_parts(&self) -> std::option::Option<&[crate::model::ProtectiveEquipmentBodyPart]> {
        self.body_parts.as_deref()
    }
    /// <p>A bounding box around the detected person.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>The confidence that Amazon Rekognition has that the bounding box contains a person.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>The identifier for the detected person. The identifier is only unique for a single call to <code>DetectProtectiveEquipment</code>.</p>
    pub fn id(&self) -> std::option::Option<i32> {
        self.id
    }
}
impl std::fmt::Debug for ProtectiveEquipmentPerson {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectiveEquipmentPerson");
        formatter.field("body_parts", &self.body_parts);
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("confidence", &self.confidence);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`ProtectiveEquipmentPerson`](crate::model::ProtectiveEquipmentPerson)
pub mod protective_equipment_person {
    /// A builder for [`ProtectiveEquipmentPerson`](crate::model::ProtectiveEquipmentPerson)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) body_parts:
            std::option::Option<std::vec::Vec<crate::model::ProtectiveEquipmentBodyPart>>,
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) id: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `body_parts`.
        ///
        /// To override the contents of this collection use [`set_body_parts`](Self::set_body_parts).
        ///
        /// <p>An array of body parts detected on a person's body (including body parts without PPE). </p>
        pub fn body_parts(mut self, input: crate::model::ProtectiveEquipmentBodyPart) -> Self {
            let mut v = self.body_parts.unwrap_or_default();
            v.push(input);
            self.body_parts = Some(v);
            self
        }
        /// <p>An array of body parts detected on a person's body (including body parts without PPE). </p>
        pub fn set_body_parts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProtectiveEquipmentBodyPart>>,
        ) -> Self {
            self.body_parts = input;
            self
        }
        /// <p>A bounding box around the detected person.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>A bounding box around the detected person.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>The confidence that Amazon Rekognition has that the bounding box contains a person.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition has that the bounding box contains a person.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The identifier for the detected person. The identifier is only unique for a single call to <code>DetectProtectiveEquipment</code>.</p>
        pub fn id(mut self, input: i32) -> Self {
            self.id = Some(input);
            self
        }
        /// <p>The identifier for the detected person. The identifier is only unique for a single call to <code>DetectProtectiveEquipment</code>.</p>
        pub fn set_id(mut self, input: std::option::Option<i32>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectiveEquipmentPerson`](crate::model::ProtectiveEquipmentPerson)
        pub fn build(self) -> crate::model::ProtectiveEquipmentPerson {
            crate::model::ProtectiveEquipmentPerson {
                body_parts: self.body_parts,
                bounding_box: self.bounding_box,
                confidence: self.confidence,
                id: self.id,
            }
        }
    }
}
impl ProtectiveEquipmentPerson {
    /// Creates a new builder-style object to manufacture [`ProtectiveEquipmentPerson`](crate::model::ProtectiveEquipmentPerson)
    pub fn builder() -> crate::model::protective_equipment_person::Builder {
        crate::model::protective_equipment_person::Builder::default()
    }
}

/// <p>Information about a body part detected by <code>DetectProtectiveEquipment</code> that contains PPE. An array of <code>ProtectiveEquipmentBodyPart</code> objects is returned for each person detected by <code>DetectProtectiveEquipment</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectiveEquipmentBodyPart {
    /// <p>The detected body part.</p>
    pub name: std::option::Option<crate::model::BodyPart>,
    /// <p>The confidence that Amazon Rekognition has in the detection accuracy of the detected body part. </p>
    pub confidence: std::option::Option<f32>,
    /// <p>An array of Personal Protective Equipment items detected around a body part.</p>
    pub equipment_detections: std::option::Option<std::vec::Vec<crate::model::EquipmentDetection>>,
}
impl ProtectiveEquipmentBodyPart {
    /// <p>The detected body part.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::BodyPart> {
        self.name.as_ref()
    }
    /// <p>The confidence that Amazon Rekognition has in the detection accuracy of the detected body part. </p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>An array of Personal Protective Equipment items detected around a body part.</p>
    pub fn equipment_detections(&self) -> std::option::Option<&[crate::model::EquipmentDetection]> {
        self.equipment_detections.as_deref()
    }
}
impl std::fmt::Debug for ProtectiveEquipmentBodyPart {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectiveEquipmentBodyPart");
        formatter.field("name", &self.name);
        formatter.field("confidence", &self.confidence);
        formatter.field("equipment_detections", &self.equipment_detections);
        formatter.finish()
    }
}
/// See [`ProtectiveEquipmentBodyPart`](crate::model::ProtectiveEquipmentBodyPart)
pub mod protective_equipment_body_part {
    /// A builder for [`ProtectiveEquipmentBodyPart`](crate::model::ProtectiveEquipmentBodyPart)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::BodyPart>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) equipment_detections:
            std::option::Option<std::vec::Vec<crate::model::EquipmentDetection>>,
    }
    impl Builder {
        /// <p>The detected body part.</p>
        pub fn name(mut self, input: crate::model::BodyPart) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The detected body part.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::BodyPart>) -> Self {
            self.name = input;
            self
        }
        /// <p>The confidence that Amazon Rekognition has in the detection accuracy of the detected body part. </p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition has in the detection accuracy of the detected body part. </p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Appends an item to `equipment_detections`.
        ///
        /// To override the contents of this collection use [`set_equipment_detections`](Self::set_equipment_detections).
        ///
        /// <p>An array of Personal Protective Equipment items detected around a body part.</p>
        pub fn equipment_detections(mut self, input: crate::model::EquipmentDetection) -> Self {
            let mut v = self.equipment_detections.unwrap_or_default();
            v.push(input);
            self.equipment_detections = Some(v);
            self
        }
        /// <p>An array of Personal Protective Equipment items detected around a body part.</p>
        pub fn set_equipment_detections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EquipmentDetection>>,
        ) -> Self {
            self.equipment_detections = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectiveEquipmentBodyPart`](crate::model::ProtectiveEquipmentBodyPart)
        pub fn build(self) -> crate::model::ProtectiveEquipmentBodyPart {
            crate::model::ProtectiveEquipmentBodyPart {
                name: self.name,
                confidence: self.confidence,
                equipment_detections: self.equipment_detections,
            }
        }
    }
}
impl ProtectiveEquipmentBodyPart {
    /// Creates a new builder-style object to manufacture [`ProtectiveEquipmentBodyPart`](crate::model::ProtectiveEquipmentBodyPart)
    pub fn builder() -> crate::model::protective_equipment_body_part::Builder {
        crate::model::protective_equipment_body_part::Builder::default()
    }
}

/// <p>Information about an item of Personal Protective Equipment (PPE) detected by <code>DetectProtectiveEquipment</code>. For more information, see <code>DetectProtectiveEquipment</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EquipmentDetection {
    /// <p>A bounding box surrounding the item of detected PPE.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains an item of PPE.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>The type of detected PPE.</p>
    pub r#type: std::option::Option<crate::model::ProtectiveEquipmentType>,
    /// <p>Information about the body part covered by the detected PPE.</p>
    pub covers_body_part: std::option::Option<crate::model::CoversBodyPart>,
}
impl EquipmentDetection {
    /// <p>A bounding box surrounding the item of detected PPE.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains an item of PPE.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>The type of detected PPE.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ProtectiveEquipmentType> {
        self.r#type.as_ref()
    }
    /// <p>Information about the body part covered by the detected PPE.</p>
    pub fn covers_body_part(&self) -> std::option::Option<&crate::model::CoversBodyPart> {
        self.covers_body_part.as_ref()
    }
}
impl std::fmt::Debug for EquipmentDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EquipmentDetection");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("confidence", &self.confidence);
        formatter.field("r#type", &self.r#type);
        formatter.field("covers_body_part", &self.covers_body_part);
        formatter.finish()
    }
}
/// See [`EquipmentDetection`](crate::model::EquipmentDetection)
pub mod equipment_detection {
    /// A builder for [`EquipmentDetection`](crate::model::EquipmentDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) r#type: std::option::Option<crate::model::ProtectiveEquipmentType>,
        pub(crate) covers_body_part: std::option::Option<crate::model::CoversBodyPart>,
    }
    impl Builder {
        /// <p>A bounding box surrounding the item of detected PPE.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>A bounding box surrounding the item of detected PPE.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains an item of PPE.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition has that the bounding box (<code>BoundingBox</code>) contains an item of PPE.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The type of detected PPE.</p>
        pub fn r#type(mut self, input: crate::model::ProtectiveEquipmentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of detected PPE.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ProtectiveEquipmentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Information about the body part covered by the detected PPE.</p>
        pub fn covers_body_part(mut self, input: crate::model::CoversBodyPart) -> Self {
            self.covers_body_part = Some(input);
            self
        }
        /// <p>Information about the body part covered by the detected PPE.</p>
        pub fn set_covers_body_part(
            mut self,
            input: std::option::Option<crate::model::CoversBodyPart>,
        ) -> Self {
            self.covers_body_part = input;
            self
        }
        /// Consumes the builder and constructs a [`EquipmentDetection`](crate::model::EquipmentDetection)
        pub fn build(self) -> crate::model::EquipmentDetection {
            crate::model::EquipmentDetection {
                bounding_box: self.bounding_box,
                confidence: self.confidence,
                r#type: self.r#type,
                covers_body_part: self.covers_body_part,
            }
        }
    }
}
impl EquipmentDetection {
    /// Creates a new builder-style object to manufacture [`EquipmentDetection`](crate::model::EquipmentDetection)
    pub fn builder() -> crate::model::equipment_detection::Builder {
        crate::model::equipment_detection::Builder::default()
    }
}

/// <p>Information about an item of Personal Protective Equipment covering a corresponding body part. For more information, see <code>DetectProtectiveEquipment</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoversBodyPart {
    /// <p>The confidence that Amazon Rekognition has in the value of <code>Value</code>.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>True if the PPE covers the corresponding body part, otherwise false.</p>
    pub value: bool,
}
impl CoversBodyPart {
    /// <p>The confidence that Amazon Rekognition has in the value of <code>Value</code>.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>True if the PPE covers the corresponding body part, otherwise false.</p>
    pub fn value(&self) -> bool {
        self.value
    }
}
impl std::fmt::Debug for CoversBodyPart {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoversBodyPart");
        formatter.field("confidence", &self.confidence);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CoversBodyPart`](crate::model::CoversBodyPart)
pub mod covers_body_part {
    /// A builder for [`CoversBodyPart`](crate::model::CoversBodyPart)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) value: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The confidence that Amazon Rekognition has in the value of <code>Value</code>.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that Amazon Rekognition has in the value of <code>Value</code>.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>True if the PPE covers the corresponding body part, otherwise false.</p>
        pub fn value(mut self, input: bool) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>True if the PPE covers the corresponding body part, otherwise false.</p>
        pub fn set_value(mut self, input: std::option::Option<bool>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CoversBodyPart`](crate::model::CoversBodyPart)
        pub fn build(self) -> crate::model::CoversBodyPart {
            crate::model::CoversBodyPart {
                confidence: self.confidence,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl CoversBodyPart {
    /// Creates a new builder-style object to manufacture [`CoversBodyPart`](crate::model::CoversBodyPart)
    pub fn builder() -> crate::model::covers_body_part::Builder {
        crate::model::covers_body_part::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProtectiveEquipmentType {
    #[allow(missing_docs)] // documentation missing in model
    FaceCover,
    #[allow(missing_docs)] // documentation missing in model
    HandCover,
    #[allow(missing_docs)] // documentation missing in model
    HeadCover,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProtectiveEquipmentType {
    fn from(s: &str) -> Self {
        match s {
            "FACE_COVER" => ProtectiveEquipmentType::FaceCover,
            "HAND_COVER" => ProtectiveEquipmentType::HandCover,
            "HEAD_COVER" => ProtectiveEquipmentType::HeadCover,
            other => ProtectiveEquipmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProtectiveEquipmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProtectiveEquipmentType::from(s))
    }
}
impl ProtectiveEquipmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProtectiveEquipmentType::FaceCover => "FACE_COVER",
            ProtectiveEquipmentType::HandCover => "HAND_COVER",
            ProtectiveEquipmentType::HeadCover => "HEAD_COVER",
            ProtectiveEquipmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FACE_COVER", "HAND_COVER", "HEAD_COVER"]
    }
}
impl AsRef<str> for ProtectiveEquipmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BodyPart {
    #[allow(missing_docs)] // documentation missing in model
    Face,
    #[allow(missing_docs)] // documentation missing in model
    Head,
    #[allow(missing_docs)] // documentation missing in model
    LeftHand,
    #[allow(missing_docs)] // documentation missing in model
    RightHand,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BodyPart {
    fn from(s: &str) -> Self {
        match s {
            "FACE" => BodyPart::Face,
            "HEAD" => BodyPart::Head,
            "LEFT_HAND" => BodyPart::LeftHand,
            "RIGHT_HAND" => BodyPart::RightHand,
            other => BodyPart::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BodyPart {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BodyPart::from(s))
    }
}
impl BodyPart {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BodyPart::Face => "FACE",
            BodyPart::Head => "HEAD",
            BodyPart::LeftHand => "LEFT_HAND",
            BodyPart::RightHand => "RIGHT_HAND",
            BodyPart::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FACE", "HEAD", "LEFT_HAND", "RIGHT_HAND"]
    }
}
impl AsRef<str> for BodyPart {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies summary attributes to return from a call to <code>DetectProtectiveEquipment</code>. You can specify which types of PPE to summarize. You can also specify a minimum confidence value for detections. Summary information is returned in the <code>Summary</code> (<code>ProtectiveEquipmentSummary</code>) field of the response from <code>DetectProtectiveEquipment</code>. The summary includes which persons in an image were detected wearing the requested types of person protective equipment (PPE), which persons were detected as not wearing PPE, and the persons in which a determination could not be made. For more information, see <code>ProtectiveEquipmentSummary</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProtectiveEquipmentSummarizationAttributes {
    /// <p>The minimum confidence level for which you want summary information. The confidence level applies to person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't return summary information with a confidence than this specified value. There isn't a default value.</p>
    /// <p>Specify a <code>MinConfidence</code> value that is between 50-100% as <code>DetectProtectiveEquipment</code> returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is less than 50%, the results are the same specifying a value of 50%.</p>
    /// <p> </p>
    pub min_confidence: std::option::Option<f32>,
    /// <p>An array of personal protective equipment types for which you want summary information. If a person is detected wearing a required requipment type, the person's ID is added to the <code>PersonsWithRequiredEquipment</code> array field returned in <code>ProtectiveEquipmentSummary</code> by <code>DetectProtectiveEquipment</code>. </p>
    pub required_equipment_types:
        std::option::Option<std::vec::Vec<crate::model::ProtectiveEquipmentType>>,
}
impl ProtectiveEquipmentSummarizationAttributes {
    /// <p>The minimum confidence level for which you want summary information. The confidence level applies to person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't return summary information with a confidence than this specified value. There isn't a default value.</p>
    /// <p>Specify a <code>MinConfidence</code> value that is between 50-100% as <code>DetectProtectiveEquipment</code> returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is less than 50%, the results are the same specifying a value of 50%.</p>
    /// <p> </p>
    pub fn min_confidence(&self) -> std::option::Option<f32> {
        self.min_confidence
    }
    /// <p>An array of personal protective equipment types for which you want summary information. If a person is detected wearing a required requipment type, the person's ID is added to the <code>PersonsWithRequiredEquipment</code> array field returned in <code>ProtectiveEquipmentSummary</code> by <code>DetectProtectiveEquipment</code>. </p>
    pub fn required_equipment_types(
        &self,
    ) -> std::option::Option<&[crate::model::ProtectiveEquipmentType]> {
        self.required_equipment_types.as_deref()
    }
}
impl std::fmt::Debug for ProtectiveEquipmentSummarizationAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProtectiveEquipmentSummarizationAttributes");
        formatter.field("min_confidence", &self.min_confidence);
        formatter.field("required_equipment_types", &self.required_equipment_types);
        formatter.finish()
    }
}
/// See [`ProtectiveEquipmentSummarizationAttributes`](crate::model::ProtectiveEquipmentSummarizationAttributes)
pub mod protective_equipment_summarization_attributes {
    /// A builder for [`ProtectiveEquipmentSummarizationAttributes`](crate::model::ProtectiveEquipmentSummarizationAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_confidence: std::option::Option<f32>,
        pub(crate) required_equipment_types:
            std::option::Option<std::vec::Vec<crate::model::ProtectiveEquipmentType>>,
    }
    impl Builder {
        /// <p>The minimum confidence level for which you want summary information. The confidence level applies to person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't return summary information with a confidence than this specified value. There isn't a default value.</p>
        /// <p>Specify a <code>MinConfidence</code> value that is between 50-100% as <code>DetectProtectiveEquipment</code> returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is less than 50%, the results are the same specifying a value of 50%.</p>
        /// <p> </p>
        pub fn min_confidence(mut self, input: f32) -> Self {
            self.min_confidence = Some(input);
            self
        }
        /// <p>The minimum confidence level for which you want summary information. The confidence level applies to person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't return summary information with a confidence than this specified value. There isn't a default value.</p>
        /// <p>Specify a <code>MinConfidence</code> value that is between 50-100% as <code>DetectProtectiveEquipment</code> returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is less than 50%, the results are the same specifying a value of 50%.</p>
        /// <p> </p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.min_confidence = input;
            self
        }
        /// Appends an item to `required_equipment_types`.
        ///
        /// To override the contents of this collection use [`set_required_equipment_types`](Self::set_required_equipment_types).
        ///
        /// <p>An array of personal protective equipment types for which you want summary information. If a person is detected wearing a required requipment type, the person's ID is added to the <code>PersonsWithRequiredEquipment</code> array field returned in <code>ProtectiveEquipmentSummary</code> by <code>DetectProtectiveEquipment</code>. </p>
        pub fn required_equipment_types(
            mut self,
            input: crate::model::ProtectiveEquipmentType,
        ) -> Self {
            let mut v = self.required_equipment_types.unwrap_or_default();
            v.push(input);
            self.required_equipment_types = Some(v);
            self
        }
        /// <p>An array of personal protective equipment types for which you want summary information. If a person is detected wearing a required requipment type, the person's ID is added to the <code>PersonsWithRequiredEquipment</code> array field returned in <code>ProtectiveEquipmentSummary</code> by <code>DetectProtectiveEquipment</code>. </p>
        pub fn set_required_equipment_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProtectiveEquipmentType>>,
        ) -> Self {
            self.required_equipment_types = input;
            self
        }
        /// Consumes the builder and constructs a [`ProtectiveEquipmentSummarizationAttributes`](crate::model::ProtectiveEquipmentSummarizationAttributes)
        pub fn build(self) -> crate::model::ProtectiveEquipmentSummarizationAttributes {
            crate::model::ProtectiveEquipmentSummarizationAttributes {
                min_confidence: self.min_confidence,
                required_equipment_types: self.required_equipment_types,
            }
        }
    }
}
impl ProtectiveEquipmentSummarizationAttributes {
    /// Creates a new builder-style object to manufacture [`ProtectiveEquipmentSummarizationAttributes`](crate::model::ProtectiveEquipmentSummarizationAttributes)
    pub fn builder() -> crate::model::protective_equipment_summarization_attributes::Builder {
        crate::model::protective_equipment_summarization_attributes::Builder::default()
    }
}

/// <p>Shows the results of the human in the loop evaluation. If there is no HumanLoopArn, the input did not trigger human review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HumanLoopActivationOutput {
    /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
    pub human_loop_arn: std::option::Option<std::string::String>,
    /// <p>Shows if and why human review was needed.</p>
    pub human_loop_activation_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Shows the result of condition evaluations, including those conditions which activated a human review.</p>
    pub human_loop_activation_conditions_evaluation_results:
        std::option::Option<std::string::String>,
}
impl HumanLoopActivationOutput {
    /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
    pub fn human_loop_arn(&self) -> std::option::Option<&str> {
        self.human_loop_arn.as_deref()
    }
    /// <p>Shows if and why human review was needed.</p>
    pub fn human_loop_activation_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.human_loop_activation_reasons.as_deref()
    }
    /// <p>Shows the result of condition evaluations, including those conditions which activated a human review.</p>
    pub fn human_loop_activation_conditions_evaluation_results(&self) -> std::option::Option<&str> {
        self.human_loop_activation_conditions_evaluation_results
            .as_deref()
    }
}
impl std::fmt::Debug for HumanLoopActivationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HumanLoopActivationOutput");
        formatter.field("human_loop_arn", &self.human_loop_arn);
        formatter.field(
            "human_loop_activation_reasons",
            &self.human_loop_activation_reasons,
        );
        formatter.field(
            "human_loop_activation_conditions_evaluation_results",
            &self.human_loop_activation_conditions_evaluation_results,
        );
        formatter.finish()
    }
}
/// See [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
pub mod human_loop_activation_output {
    /// A builder for [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_arn: std::option::Option<std::string::String>,
        pub(crate) human_loop_activation_reasons:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) human_loop_activation_conditions_evaluation_results:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
        pub fn human_loop_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the HumanLoop created.</p>
        pub fn set_human_loop_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_arn = input;
            self
        }
        /// Appends an item to `human_loop_activation_reasons`.
        ///
        /// To override the contents of this collection use [`set_human_loop_activation_reasons`](Self::set_human_loop_activation_reasons).
        ///
        /// <p>Shows if and why human review was needed.</p>
        pub fn human_loop_activation_reasons(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.human_loop_activation_reasons.unwrap_or_default();
            v.push(input.into());
            self.human_loop_activation_reasons = Some(v);
            self
        }
        /// <p>Shows if and why human review was needed.</p>
        pub fn set_human_loop_activation_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.human_loop_activation_reasons = input;
            self
        }
        /// <p>Shows the result of condition evaluations, including those conditions which activated a human review.</p>
        pub fn human_loop_activation_conditions_evaluation_results(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.human_loop_activation_conditions_evaluation_results = Some(input.into());
            self
        }
        /// <p>Shows the result of condition evaluations, including those conditions which activated a human review.</p>
        pub fn set_human_loop_activation_conditions_evaluation_results(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_activation_conditions_evaluation_results = input;
            self
        }
        /// Consumes the builder and constructs a [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
        pub fn build(self) -> crate::model::HumanLoopActivationOutput {
            crate::model::HumanLoopActivationOutput {
                human_loop_arn: self.human_loop_arn,
                human_loop_activation_reasons: self.human_loop_activation_reasons,
                human_loop_activation_conditions_evaluation_results: self
                    .human_loop_activation_conditions_evaluation_results,
            }
        }
    }
}
impl HumanLoopActivationOutput {
    /// Creates a new builder-style object to manufacture [`HumanLoopActivationOutput`](crate::model::HumanLoopActivationOutput)
    pub fn builder() -> crate::model::human_loop_activation_output::Builder {
        crate::model::human_loop_activation_output::Builder::default()
    }
}

/// <p>Sets up the flow definition the image will be sent to if one of the conditions is met. You can also set certain attributes of the image before review.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HumanLoopConfig {
    /// <p>The name of the human review used for this image. This should be kept unique within a region.</p>
    pub human_loop_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the Amazon Sagemaker <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">CreateFlowDefinition</a> Operation. </p>
    pub flow_definition_arn: std::option::Option<std::string::String>,
    /// <p>Sets attributes of the input data.</p>
    pub data_attributes: std::option::Option<crate::model::HumanLoopDataAttributes>,
}
impl HumanLoopConfig {
    /// <p>The name of the human review used for this image. This should be kept unique within a region.</p>
    pub fn human_loop_name(&self) -> std::option::Option<&str> {
        self.human_loop_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the Amazon Sagemaker <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">CreateFlowDefinition</a> Operation. </p>
    pub fn flow_definition_arn(&self) -> std::option::Option<&str> {
        self.flow_definition_arn.as_deref()
    }
    /// <p>Sets attributes of the input data.</p>
    pub fn data_attributes(&self) -> std::option::Option<&crate::model::HumanLoopDataAttributes> {
        self.data_attributes.as_ref()
    }
}
impl std::fmt::Debug for HumanLoopConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HumanLoopConfig");
        formatter.field("human_loop_name", &self.human_loop_name);
        formatter.field("flow_definition_arn", &self.flow_definition_arn);
        formatter.field("data_attributes", &self.data_attributes);
        formatter.finish()
    }
}
/// See [`HumanLoopConfig`](crate::model::HumanLoopConfig)
pub mod human_loop_config {
    /// A builder for [`HumanLoopConfig`](crate::model::HumanLoopConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_loop_name: std::option::Option<std::string::String>,
        pub(crate) flow_definition_arn: std::option::Option<std::string::String>,
        pub(crate) data_attributes: std::option::Option<crate::model::HumanLoopDataAttributes>,
    }
    impl Builder {
        /// <p>The name of the human review used for this image. This should be kept unique within a region.</p>
        pub fn human_loop_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_loop_name = Some(input.into());
            self
        }
        /// <p>The name of the human review used for this image. This should be kept unique within a region.</p>
        pub fn set_human_loop_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_loop_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the Amazon Sagemaker <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">CreateFlowDefinition</a> Operation. </p>
        pub fn flow_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition. You can create a flow definition by using the Amazon Sagemaker <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html">CreateFlowDefinition</a> Operation. </p>
        pub fn set_flow_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_arn = input;
            self
        }
        /// <p>Sets attributes of the input data.</p>
        pub fn data_attributes(mut self, input: crate::model::HumanLoopDataAttributes) -> Self {
            self.data_attributes = Some(input);
            self
        }
        /// <p>Sets attributes of the input data.</p>
        pub fn set_data_attributes(
            mut self,
            input: std::option::Option<crate::model::HumanLoopDataAttributes>,
        ) -> Self {
            self.data_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`HumanLoopConfig`](crate::model::HumanLoopConfig)
        pub fn build(self) -> crate::model::HumanLoopConfig {
            crate::model::HumanLoopConfig {
                human_loop_name: self.human_loop_name,
                flow_definition_arn: self.flow_definition_arn,
                data_attributes: self.data_attributes,
            }
        }
    }
}
impl HumanLoopConfig {
    /// Creates a new builder-style object to manufacture [`HumanLoopConfig`](crate::model::HumanLoopConfig)
    pub fn builder() -> crate::model::human_loop_config::Builder {
        crate::model::human_loop_config::Builder::default()
    }
}

/// <p>Allows you to set attributes of the image. Currently, you can declare an image as free of personally identifiable information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HumanLoopDataAttributes {
    /// <p>Sets whether the input image is free of personally identifiable information.</p>
    pub content_classifiers: std::option::Option<std::vec::Vec<crate::model::ContentClassifier>>,
}
impl HumanLoopDataAttributes {
    /// <p>Sets whether the input image is free of personally identifiable information.</p>
    pub fn content_classifiers(&self) -> std::option::Option<&[crate::model::ContentClassifier]> {
        self.content_classifiers.as_deref()
    }
}
impl std::fmt::Debug for HumanLoopDataAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HumanLoopDataAttributes");
        formatter.field("content_classifiers", &self.content_classifiers);
        formatter.finish()
    }
}
/// See [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
pub mod human_loop_data_attributes {
    /// A builder for [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_classifiers:
            std::option::Option<std::vec::Vec<crate::model::ContentClassifier>>,
    }
    impl Builder {
        /// Appends an item to `content_classifiers`.
        ///
        /// To override the contents of this collection use [`set_content_classifiers`](Self::set_content_classifiers).
        ///
        /// <p>Sets whether the input image is free of personally identifiable information.</p>
        pub fn content_classifiers(mut self, input: crate::model::ContentClassifier) -> Self {
            let mut v = self.content_classifiers.unwrap_or_default();
            v.push(input);
            self.content_classifiers = Some(v);
            self
        }
        /// <p>Sets whether the input image is free of personally identifiable information.</p>
        pub fn set_content_classifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContentClassifier>>,
        ) -> Self {
            self.content_classifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
        pub fn build(self) -> crate::model::HumanLoopDataAttributes {
            crate::model::HumanLoopDataAttributes {
                content_classifiers: self.content_classifiers,
            }
        }
    }
}
impl HumanLoopDataAttributes {
    /// Creates a new builder-style object to manufacture [`HumanLoopDataAttributes`](crate::model::HumanLoopDataAttributes)
    pub fn builder() -> crate::model::human_loop_data_attributes::Builder {
        crate::model::human_loop_data_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentClassifier {
    #[allow(missing_docs)] // documentation missing in model
    FreeOfAdultContent,
    #[allow(missing_docs)] // documentation missing in model
    FreeOfPersonallyIdentifiableInformation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentClassifier {
    fn from(s: &str) -> Self {
        match s {
            "FreeOfAdultContent" => ContentClassifier::FreeOfAdultContent,
            "FreeOfPersonallyIdentifiableInformation" => {
                ContentClassifier::FreeOfPersonallyIdentifiableInformation
            }
            other => ContentClassifier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentClassifier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentClassifier::from(s))
    }
}
impl ContentClassifier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentClassifier::FreeOfAdultContent => "FreeOfAdultContent",
            ContentClassifier::FreeOfPersonallyIdentifiableInformation => {
                "FreeOfPersonallyIdentifiableInformation"
            }
            ContentClassifier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FreeOfAdultContent",
            "FreeOfPersonallyIdentifiableInformation",
        ]
    }
}
impl AsRef<str> for ContentClassifier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A custom label detected in an image by a call to <code>DetectCustomLabels</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomLabel {
    /// <p>The name of the custom label.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The confidence that the model has in the detection of the custom label. The range is 0-100. A higher value indicates a higher confidence.</p>
    pub confidence: std::option::Option<f32>,
    /// <p>The location of the detected object on the image that corresponds to the custom label. Includes an axis aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial information.</p>
    pub geometry: std::option::Option<crate::model::Geometry>,
}
impl CustomLabel {
    /// <p>The name of the custom label.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The confidence that the model has in the detection of the custom label. The range is 0-100. A higher value indicates a higher confidence.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
    /// <p>The location of the detected object on the image that corresponds to the custom label. Includes an axis aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial information.</p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::Geometry> {
        self.geometry.as_ref()
    }
}
impl std::fmt::Debug for CustomLabel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomLabel");
        formatter.field("name", &self.name);
        formatter.field("confidence", &self.confidence);
        formatter.field("geometry", &self.geometry);
        formatter.finish()
    }
}
/// See [`CustomLabel`](crate::model::CustomLabel)
pub mod custom_label {
    /// A builder for [`CustomLabel`](crate::model::CustomLabel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) confidence: std::option::Option<f32>,
        pub(crate) geometry: std::option::Option<crate::model::Geometry>,
    }
    impl Builder {
        /// <p>The name of the custom label.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom label.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The confidence that the model has in the detection of the custom label. The range is 0-100. A higher value indicates a higher confidence.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>The confidence that the model has in the detection of the custom label. The range is 0-100. A higher value indicates a higher confidence.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// <p>The location of the detected object on the image that corresponds to the custom label. Includes an axis aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial information.</p>
        pub fn geometry(mut self, input: crate::model::Geometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>The location of the detected object on the image that corresponds to the custom label. Includes an axis aligned coarse bounding box surrounding the object and a finer grain polygon for more accurate spatial information.</p>
        pub fn set_geometry(mut self, input: std::option::Option<crate::model::Geometry>) -> Self {
            self.geometry = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomLabel`](crate::model::CustomLabel)
        pub fn build(self) -> crate::model::CustomLabel {
            crate::model::CustomLabel {
                name: self.name,
                confidence: self.confidence,
                geometry: self.geometry,
            }
        }
    }
}
impl CustomLabel {
    /// Creates a new builder-style object to manufacture [`CustomLabel`](crate::model::CustomLabel)
    pub fn builder() -> crate::model::custom_label::Builder {
        crate::model::custom_label::Builder::default()
    }
}

/// <p>Input parameters used to recognize faces in a streaming video analyzed by a Amazon Rekognition stream processor.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamProcessorSettings {
    /// <p>Face search settings to use on a streaming video. </p>
    pub face_search: std::option::Option<crate::model::FaceSearchSettings>,
}
impl StreamProcessorSettings {
    /// <p>Face search settings to use on a streaming video. </p>
    pub fn face_search(&self) -> std::option::Option<&crate::model::FaceSearchSettings> {
        self.face_search.as_ref()
    }
}
impl std::fmt::Debug for StreamProcessorSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamProcessorSettings");
        formatter.field("face_search", &self.face_search);
        formatter.finish()
    }
}
/// See [`StreamProcessorSettings`](crate::model::StreamProcessorSettings)
pub mod stream_processor_settings {
    /// A builder for [`StreamProcessorSettings`](crate::model::StreamProcessorSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) face_search: std::option::Option<crate::model::FaceSearchSettings>,
    }
    impl Builder {
        /// <p>Face search settings to use on a streaming video. </p>
        pub fn face_search(mut self, input: crate::model::FaceSearchSettings) -> Self {
            self.face_search = Some(input);
            self
        }
        /// <p>Face search settings to use on a streaming video. </p>
        pub fn set_face_search(
            mut self,
            input: std::option::Option<crate::model::FaceSearchSettings>,
        ) -> Self {
            self.face_search = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamProcessorSettings`](crate::model::StreamProcessorSettings)
        pub fn build(self) -> crate::model::StreamProcessorSettings {
            crate::model::StreamProcessorSettings {
                face_search: self.face_search,
            }
        }
    }
}
impl StreamProcessorSettings {
    /// Creates a new builder-style object to manufacture [`StreamProcessorSettings`](crate::model::StreamProcessorSettings)
    pub fn builder() -> crate::model::stream_processor_settings::Builder {
        crate::model::stream_processor_settings::Builder::default()
    }
}

/// <p>Input face recognition parameters for an Amazon Rekognition stream processor. <code>FaceRecognitionSettings</code> is a request parameter for <code>CreateStreamProcessor</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FaceSearchSettings {
    /// <p>The ID of a collection that contains faces that you want to search for.</p>
    pub collection_id: std::option::Option<std::string::String>,
    /// <p>Minimum face match confidence score that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.</p>
    pub face_match_threshold: std::option::Option<f32>,
}
impl FaceSearchSettings {
    /// <p>The ID of a collection that contains faces that you want to search for.</p>
    pub fn collection_id(&self) -> std::option::Option<&str> {
        self.collection_id.as_deref()
    }
    /// <p>Minimum face match confidence score that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.</p>
    pub fn face_match_threshold(&self) -> std::option::Option<f32> {
        self.face_match_threshold
    }
}
impl std::fmt::Debug for FaceSearchSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FaceSearchSettings");
        formatter.field("collection_id", &self.collection_id);
        formatter.field("face_match_threshold", &self.face_match_threshold);
        formatter.finish()
    }
}
/// See [`FaceSearchSettings`](crate::model::FaceSearchSettings)
pub mod face_search_settings {
    /// A builder for [`FaceSearchSettings`](crate::model::FaceSearchSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_id: std::option::Option<std::string::String>,
        pub(crate) face_match_threshold: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The ID of a collection that contains faces that you want to search for.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_id = Some(input.into());
            self
        }
        /// <p>The ID of a collection that contains faces that you want to search for.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_id = input;
            self
        }
        /// <p>Minimum face match confidence score that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.</p>
        pub fn face_match_threshold(mut self, input: f32) -> Self {
            self.face_match_threshold = Some(input);
            self
        }
        /// <p>Minimum face match confidence score that must be met to return a result for a recognized face. The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.</p>
        pub fn set_face_match_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.face_match_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`FaceSearchSettings`](crate::model::FaceSearchSettings)
        pub fn build(self) -> crate::model::FaceSearchSettings {
            crate::model::FaceSearchSettings {
                collection_id: self.collection_id,
                face_match_threshold: self.face_match_threshold,
            }
        }
    }
}
impl FaceSearchSettings {
    /// Creates a new builder-style object to manufacture [`FaceSearchSettings`](crate::model::FaceSearchSettings)
    pub fn builder() -> crate::model::face_search_settings::Builder {
        crate::model::face_search_settings::Builder::default()
    }
}

/// <p>Information about the Amazon Kinesis Data Streams stream to which a Amazon Rekognition Video stream processor streams the results of a video analysis. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamProcessorOutput {
    /// <p>The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results.</p>
    pub kinesis_data_stream: std::option::Option<crate::model::KinesisDataStream>,
}
impl StreamProcessorOutput {
    /// <p>The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results.</p>
    pub fn kinesis_data_stream(&self) -> std::option::Option<&crate::model::KinesisDataStream> {
        self.kinesis_data_stream.as_ref()
    }
}
impl std::fmt::Debug for StreamProcessorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamProcessorOutput");
        formatter.field("kinesis_data_stream", &self.kinesis_data_stream);
        formatter.finish()
    }
}
/// See [`StreamProcessorOutput`](crate::model::StreamProcessorOutput)
pub mod stream_processor_output {
    /// A builder for [`StreamProcessorOutput`](crate::model::StreamProcessorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kinesis_data_stream: std::option::Option<crate::model::KinesisDataStream>,
    }
    impl Builder {
        /// <p>The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results.</p>
        pub fn kinesis_data_stream(mut self, input: crate::model::KinesisDataStream) -> Self {
            self.kinesis_data_stream = Some(input);
            self
        }
        /// <p>The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results.</p>
        pub fn set_kinesis_data_stream(
            mut self,
            input: std::option::Option<crate::model::KinesisDataStream>,
        ) -> Self {
            self.kinesis_data_stream = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamProcessorOutput`](crate::model::StreamProcessorOutput)
        pub fn build(self) -> crate::model::StreamProcessorOutput {
            crate::model::StreamProcessorOutput {
                kinesis_data_stream: self.kinesis_data_stream,
            }
        }
    }
}
impl StreamProcessorOutput {
    /// Creates a new builder-style object to manufacture [`StreamProcessorOutput`](crate::model::StreamProcessorOutput)
    pub fn builder() -> crate::model::stream_processor_output::Builder {
        crate::model::stream_processor_output::Builder::default()
    }
}

/// <p>The Kinesis data stream Amazon Rekognition to which the analysis results of a Amazon Rekognition stream processor are streamed. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisDataStream {
    /// <p>ARN of the output Amazon Kinesis Data Streams stream.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl KinesisDataStream {
    /// <p>ARN of the output Amazon Kinesis Data Streams stream.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisDataStream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisDataStream");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`KinesisDataStream`](crate::model::KinesisDataStream)
pub mod kinesis_data_stream {
    /// A builder for [`KinesisDataStream`](crate::model::KinesisDataStream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the output Amazon Kinesis Data Streams stream.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>ARN of the output Amazon Kinesis Data Streams stream.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisDataStream`](crate::model::KinesisDataStream)
        pub fn build(self) -> crate::model::KinesisDataStream {
            crate::model::KinesisDataStream { arn: self.arn }
        }
    }
}
impl KinesisDataStream {
    /// Creates a new builder-style object to manufacture [`KinesisDataStream`](crate::model::KinesisDataStream)
    pub fn builder() -> crate::model::kinesis_data_stream::Builder {
        crate::model::kinesis_data_stream::Builder::default()
    }
}

/// <p>Information about the source streaming video. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StreamProcessorInput {
    /// <p>The Kinesis video stream input stream for the source streaming video.</p>
    pub kinesis_video_stream: std::option::Option<crate::model::KinesisVideoStream>,
}
impl StreamProcessorInput {
    /// <p>The Kinesis video stream input stream for the source streaming video.</p>
    pub fn kinesis_video_stream(&self) -> std::option::Option<&crate::model::KinesisVideoStream> {
        self.kinesis_video_stream.as_ref()
    }
}
impl std::fmt::Debug for StreamProcessorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StreamProcessorInput");
        formatter.field("kinesis_video_stream", &self.kinesis_video_stream);
        formatter.finish()
    }
}
/// See [`StreamProcessorInput`](crate::model::StreamProcessorInput)
pub mod stream_processor_input {
    /// A builder for [`StreamProcessorInput`](crate::model::StreamProcessorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kinesis_video_stream: std::option::Option<crate::model::KinesisVideoStream>,
    }
    impl Builder {
        /// <p>The Kinesis video stream input stream for the source streaming video.</p>
        pub fn kinesis_video_stream(mut self, input: crate::model::KinesisVideoStream) -> Self {
            self.kinesis_video_stream = Some(input);
            self
        }
        /// <p>The Kinesis video stream input stream for the source streaming video.</p>
        pub fn set_kinesis_video_stream(
            mut self,
            input: std::option::Option<crate::model::KinesisVideoStream>,
        ) -> Self {
            self.kinesis_video_stream = input;
            self
        }
        /// Consumes the builder and constructs a [`StreamProcessorInput`](crate::model::StreamProcessorInput)
        pub fn build(self) -> crate::model::StreamProcessorInput {
            crate::model::StreamProcessorInput {
                kinesis_video_stream: self.kinesis_video_stream,
            }
        }
    }
}
impl StreamProcessorInput {
    /// Creates a new builder-style object to manufacture [`StreamProcessorInput`](crate::model::StreamProcessorInput)
    pub fn builder() -> crate::model::stream_processor_input::Builder {
        crate::model::stream_processor_input::Builder::default()
    }
}

/// <p>Kinesis video stream stream that provides the source streaming video for a Amazon Rekognition Video stream processor. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisVideoStream {
    /// <p>ARN of the Kinesis video stream stream that streams the source video.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl KinesisVideoStream {
    /// <p>ARN of the Kinesis video stream stream that streams the source video.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for KinesisVideoStream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisVideoStream");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`KinesisVideoStream`](crate::model::KinesisVideoStream)
pub mod kinesis_video_stream {
    /// A builder for [`KinesisVideoStream`](crate::model::KinesisVideoStream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ARN of the Kinesis video stream stream that streams the source video.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>ARN of the Kinesis video stream stream that streams the source video.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisVideoStream`](crate::model::KinesisVideoStream)
        pub fn build(self) -> crate::model::KinesisVideoStream {
            crate::model::KinesisVideoStream { arn: self.arn }
        }
    }
}
impl KinesisVideoStream {
    /// Creates a new builder-style object to manufacture [`KinesisVideoStream`](crate::model::KinesisVideoStream)
    pub fn builder() -> crate::model::kinesis_video_stream::Builder {
        crate::model::kinesis_video_stream::Builder::default()
    }
}

/// <p>A description of a version of an Amazon Rekognition Custom Labels model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectVersionDescription {
    /// <p>The Amazon Resource Name (ARN) of the model version. </p>
    pub project_version_arn: std::option::Option<std::string::String>,
    /// <p>The Unix datetime for the date and time that training started.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The minimum number of inference units used by the model. For more information, see <code>StartProjectVersion</code>.</p>
    pub min_inference_units: std::option::Option<i32>,
    /// <p>The current status of the model version.</p>
    pub status: std::option::Option<crate::model::ProjectVersionStatus>,
    /// <p>A descriptive message for an error or warning that occurred.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The duration, in seconds, that you were billed for a successful training of the model version. This value is only returned if the model version has been successfully trained.</p>
    pub billable_training_time_in_seconds: std::option::Option<i64>,
    /// <p>The Unix date and time that training of the model ended.</p>
    pub training_end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The location where training results are saved.</p>
    pub output_config: std::option::Option<crate::model::OutputConfig>,
    /// <p>Contains information about the training results.</p>
    pub training_data_result: std::option::Option<crate::model::TrainingDataResult>,
    /// <p>Contains information about the testing results.</p>
    pub testing_data_result: std::option::Option<crate::model::TestingDataResult>,
    /// <p>The training results. <code>EvaluationResult</code> is only returned if training is successful.</p>
    pub evaluation_result: std::option::Option<crate::model::EvaluationResult>,
    /// <p>The location of the summary manifest. The summary manifest provides aggregate data validation results for the training and test datasets.</p>
    pub manifest_summary: std::option::Option<crate::model::GroundTruthManifest>,
    /// <p>The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during training. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl ProjectVersionDescription {
    /// <p>The Amazon Resource Name (ARN) of the model version. </p>
    pub fn project_version_arn(&self) -> std::option::Option<&str> {
        self.project_version_arn.as_deref()
    }
    /// <p>The Unix datetime for the date and time that training started.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The minimum number of inference units used by the model. For more information, see <code>StartProjectVersion</code>.</p>
    pub fn min_inference_units(&self) -> std::option::Option<i32> {
        self.min_inference_units
    }
    /// <p>The current status of the model version.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProjectVersionStatus> {
        self.status.as_ref()
    }
    /// <p>A descriptive message for an error or warning that occurred.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The duration, in seconds, that you were billed for a successful training of the model version. This value is only returned if the model version has been successfully trained.</p>
    pub fn billable_training_time_in_seconds(&self) -> std::option::Option<i64> {
        self.billable_training_time_in_seconds
    }
    /// <p>The Unix date and time that training of the model ended.</p>
    pub fn training_end_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.training_end_timestamp.as_ref()
    }
    /// <p>The location where training results are saved.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::OutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>Contains information about the training results.</p>
    pub fn training_data_result(&self) -> std::option::Option<&crate::model::TrainingDataResult> {
        self.training_data_result.as_ref()
    }
    /// <p>Contains information about the testing results.</p>
    pub fn testing_data_result(&self) -> std::option::Option<&crate::model::TestingDataResult> {
        self.testing_data_result.as_ref()
    }
    /// <p>The training results. <code>EvaluationResult</code> is only returned if training is successful.</p>
    pub fn evaluation_result(&self) -> std::option::Option<&crate::model::EvaluationResult> {
        self.evaluation_result.as_ref()
    }
    /// <p>The location of the summary manifest. The summary manifest provides aggregate data validation results for the training and test datasets.</p>
    pub fn manifest_summary(&self) -> std::option::Option<&crate::model::GroundTruthManifest> {
        self.manifest_summary.as_ref()
    }
    /// <p>The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during training. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for ProjectVersionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectVersionDescription");
        formatter.field("project_version_arn", &self.project_version_arn);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("min_inference_units", &self.min_inference_units);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field(
            "billable_training_time_in_seconds",
            &self.billable_training_time_in_seconds,
        );
        formatter.field("training_end_timestamp", &self.training_end_timestamp);
        formatter.field("output_config", &self.output_config);
        formatter.field("training_data_result", &self.training_data_result);
        formatter.field("testing_data_result", &self.testing_data_result);
        formatter.field("evaluation_result", &self.evaluation_result);
        formatter.field("manifest_summary", &self.manifest_summary);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`ProjectVersionDescription`](crate::model::ProjectVersionDescription)
pub mod project_version_description {
    /// A builder for [`ProjectVersionDescription`](crate::model::ProjectVersionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_version_arn: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) min_inference_units: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::ProjectVersionStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) billable_training_time_in_seconds: std::option::Option<i64>,
        pub(crate) training_end_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) output_config: std::option::Option<crate::model::OutputConfig>,
        pub(crate) training_data_result: std::option::Option<crate::model::TrainingDataResult>,
        pub(crate) testing_data_result: std::option::Option<crate::model::TestingDataResult>,
        pub(crate) evaluation_result: std::option::Option<crate::model::EvaluationResult>,
        pub(crate) manifest_summary: std::option::Option<crate::model::GroundTruthManifest>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model version. </p>
        pub fn project_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model version. </p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_version_arn = input;
            self
        }
        /// <p>The Unix datetime for the date and time that training started.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The Unix datetime for the date and time that training started.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The minimum number of inference units used by the model. For more information, see <code>StartProjectVersion</code>.</p>
        pub fn min_inference_units(mut self, input: i32) -> Self {
            self.min_inference_units = Some(input);
            self
        }
        /// <p>The minimum number of inference units used by the model. For more information, see <code>StartProjectVersion</code>.</p>
        pub fn set_min_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.min_inference_units = input;
            self
        }
        /// <p>The current status of the model version.</p>
        pub fn status(mut self, input: crate::model::ProjectVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the model version.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProjectVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A descriptive message for an error or warning that occurred.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A descriptive message for an error or warning that occurred.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The duration, in seconds, that you were billed for a successful training of the model version. This value is only returned if the model version has been successfully trained.</p>
        pub fn billable_training_time_in_seconds(mut self, input: i64) -> Self {
            self.billable_training_time_in_seconds = Some(input);
            self
        }
        /// <p>The duration, in seconds, that you were billed for a successful training of the model version. This value is only returned if the model version has been successfully trained.</p>
        pub fn set_billable_training_time_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.billable_training_time_in_seconds = input;
            self
        }
        /// <p>The Unix date and time that training of the model ended.</p>
        pub fn training_end_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.training_end_timestamp = Some(input);
            self
        }
        /// <p>The Unix date and time that training of the model ended.</p>
        pub fn set_training_end_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.training_end_timestamp = input;
            self
        }
        /// <p>The location where training results are saved.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>The location where training results are saved.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>Contains information about the training results.</p>
        pub fn training_data_result(mut self, input: crate::model::TrainingDataResult) -> Self {
            self.training_data_result = Some(input);
            self
        }
        /// <p>Contains information about the training results.</p>
        pub fn set_training_data_result(
            mut self,
            input: std::option::Option<crate::model::TrainingDataResult>,
        ) -> Self {
            self.training_data_result = input;
            self
        }
        /// <p>Contains information about the testing results.</p>
        pub fn testing_data_result(mut self, input: crate::model::TestingDataResult) -> Self {
            self.testing_data_result = Some(input);
            self
        }
        /// <p>Contains information about the testing results.</p>
        pub fn set_testing_data_result(
            mut self,
            input: std::option::Option<crate::model::TestingDataResult>,
        ) -> Self {
            self.testing_data_result = input;
            self
        }
        /// <p>The training results. <code>EvaluationResult</code> is only returned if training is successful.</p>
        pub fn evaluation_result(mut self, input: crate::model::EvaluationResult) -> Self {
            self.evaluation_result = Some(input);
            self
        }
        /// <p>The training results. <code>EvaluationResult</code> is only returned if training is successful.</p>
        pub fn set_evaluation_result(
            mut self,
            input: std::option::Option<crate::model::EvaluationResult>,
        ) -> Self {
            self.evaluation_result = input;
            self
        }
        /// <p>The location of the summary manifest. The summary manifest provides aggregate data validation results for the training and test datasets.</p>
        pub fn manifest_summary(mut self, input: crate::model::GroundTruthManifest) -> Self {
            self.manifest_summary = Some(input);
            self
        }
        /// <p>The location of the summary manifest. The summary manifest provides aggregate data validation results for the training and test datasets.</p>
        pub fn set_manifest_summary(
            mut self,
            input: std::option::Option<crate::model::GroundTruthManifest>,
        ) -> Self {
            self.manifest_summary = input;
            self
        }
        /// <p>The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during training. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during training. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectVersionDescription`](crate::model::ProjectVersionDescription)
        pub fn build(self) -> crate::model::ProjectVersionDescription {
            crate::model::ProjectVersionDescription {
                project_version_arn: self.project_version_arn,
                creation_timestamp: self.creation_timestamp,
                min_inference_units: self.min_inference_units,
                status: self.status,
                status_message: self.status_message,
                billable_training_time_in_seconds: self.billable_training_time_in_seconds,
                training_end_timestamp: self.training_end_timestamp,
                output_config: self.output_config,
                training_data_result: self.training_data_result,
                testing_data_result: self.testing_data_result,
                evaluation_result: self.evaluation_result,
                manifest_summary: self.manifest_summary,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl ProjectVersionDescription {
    /// Creates a new builder-style object to manufacture [`ProjectVersionDescription`](crate::model::ProjectVersionDescription)
    pub fn builder() -> crate::model::project_version_description::Builder {
        crate::model::project_version_description::Builder::default()
    }
}

/// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroundTruthManifest {
    /// <p>Provides the S3 bucket name and object name.</p>
    /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
    /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
    pub s3_object: std::option::Option<crate::model::S3Object>,
}
impl GroundTruthManifest {
    /// <p>Provides the S3 bucket name and object name.</p>
    /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
    /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
    pub fn s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.s3_object.as_ref()
    }
}
impl std::fmt::Debug for GroundTruthManifest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroundTruthManifest");
        formatter.field("s3_object", &self.s3_object);
        formatter.finish()
    }
}
/// See [`GroundTruthManifest`](crate::model::GroundTruthManifest)
pub mod ground_truth_manifest {
    /// A builder for [`GroundTruthManifest`](crate::model::GroundTruthManifest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_object: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>Provides the S3 bucket name and object name.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
        pub fn s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.s3_object = Some(input);
            self
        }
        /// <p>Provides the S3 bucket name and object name.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
        pub fn set_s3_object(mut self, input: std::option::Option<crate::model::S3Object>) -> Self {
            self.s3_object = input;
            self
        }
        /// Consumes the builder and constructs a [`GroundTruthManifest`](crate::model::GroundTruthManifest)
        pub fn build(self) -> crate::model::GroundTruthManifest {
            crate::model::GroundTruthManifest {
                s3_object: self.s3_object,
            }
        }
    }
}
impl GroundTruthManifest {
    /// Creates a new builder-style object to manufacture [`GroundTruthManifest`](crate::model::GroundTruthManifest)
    pub fn builder() -> crate::model::ground_truth_manifest::Builder {
        crate::model::ground_truth_manifest::Builder::default()
    }
}

/// <p>The evaluation results for the training of a model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResult {
    /// <p>The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall performance of the model as a single value. A higher value indicates better precision and recall performance. A lower score indicates that precision, recall, or both are performing poorly. </p>
    pub f1_score: std::option::Option<f32>,
    /// <p>The S3 bucket that contains the training summary.</p>
    pub summary: std::option::Option<crate::model::Summary>,
}
impl EvaluationResult {
    /// <p>The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall performance of the model as a single value. A higher value indicates better precision and recall performance. A lower score indicates that precision, recall, or both are performing poorly. </p>
    pub fn f1_score(&self) -> std::option::Option<f32> {
        self.f1_score
    }
    /// <p>The S3 bucket that contains the training summary.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::Summary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for EvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResult");
        formatter.field("f1_score", &self.f1_score);
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`EvaluationResult`](crate::model::EvaluationResult)
pub mod evaluation_result {
    /// A builder for [`EvaluationResult`](crate::model::EvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) f1_score: std::option::Option<f32>,
        pub(crate) summary: std::option::Option<crate::model::Summary>,
    }
    impl Builder {
        /// <p>The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall performance of the model as a single value. A higher value indicates better precision and recall performance. A lower score indicates that precision, recall, or both are performing poorly. </p>
        pub fn f1_score(mut self, input: f32) -> Self {
            self.f1_score = Some(input);
            self
        }
        /// <p>The F1 score for the evaluation of all labels. The F1 score metric evaluates the overall precision and recall performance of the model as a single value. A higher value indicates better precision and recall performance. A lower score indicates that precision, recall, or both are performing poorly. </p>
        pub fn set_f1_score(mut self, input: std::option::Option<f32>) -> Self {
            self.f1_score = input;
            self
        }
        /// <p>The S3 bucket that contains the training summary.</p>
        pub fn summary(mut self, input: crate::model::Summary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>The S3 bucket that contains the training summary.</p>
        pub fn set_summary(mut self, input: std::option::Option<crate::model::Summary>) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResult`](crate::model::EvaluationResult)
        pub fn build(self) -> crate::model::EvaluationResult {
            crate::model::EvaluationResult {
                f1_score: self.f1_score,
                summary: self.summary,
            }
        }
    }
}
impl EvaluationResult {
    /// Creates a new builder-style object to manufacture [`EvaluationResult`](crate::model::EvaluationResult)
    pub fn builder() -> crate::model::evaluation_result::Builder {
        crate::model::evaluation_result::Builder::default()
    }
}

/// <p>The S3 bucket that contains the training summary. The training summary includes aggregated evaluation metrics for the entire testing dataset and metrics for each individual label. </p>
/// <p>You get the training summary S3 bucket location by calling <code>DescribeProjectVersions</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Summary {
    /// <p>Provides the S3 bucket name and object name.</p>
    /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
    /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
    pub s3_object: std::option::Option<crate::model::S3Object>,
}
impl Summary {
    /// <p>Provides the S3 bucket name and object name.</p>
    /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
    /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
    pub fn s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.s3_object.as_ref()
    }
}
impl std::fmt::Debug for Summary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Summary");
        formatter.field("s3_object", &self.s3_object);
        formatter.finish()
    }
}
/// See [`Summary`](crate::model::Summary)
pub mod summary {
    /// A builder for [`Summary`](crate::model::Summary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_object: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>Provides the S3 bucket name and object name.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
        pub fn s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.s3_object = Some(input);
            self
        }
        /// <p>Provides the S3 bucket name and object name.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see Resource-Based Policies in the Amazon Rekognition Developer Guide. </p>
        pub fn set_s3_object(mut self, input: std::option::Option<crate::model::S3Object>) -> Self {
            self.s3_object = input;
            self
        }
        /// Consumes the builder and constructs a [`Summary`](crate::model::Summary)
        pub fn build(self) -> crate::model::Summary {
            crate::model::Summary {
                s3_object: self.s3_object,
            }
        }
    }
}
impl Summary {
    /// Creates a new builder-style object to manufacture [`Summary`](crate::model::Summary)
    pub fn builder() -> crate::model::summary::Builder {
        crate::model::summary::Builder::default()
    }
}

/// <p>Sagemaker Groundtruth format manifest files for the input, output and validation datasets that are used and created during testing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestingDataResult {
    /// <p>The testing dataset that was supplied for training.</p>
    pub input: std::option::Option<crate::model::TestingData>,
    /// <p>The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file formatting and other issues. </p>
    pub output: std::option::Option<crate::model::TestingData>,
    /// <p>The location of the data validation manifest. The data validation manifest is created for the test dataset during model training.</p>
    pub validation: std::option::Option<crate::model::ValidationData>,
}
impl TestingDataResult {
    /// <p>The testing dataset that was supplied for training.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::TestingData> {
        self.input.as_ref()
    }
    /// <p>The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file formatting and other issues. </p>
    pub fn output(&self) -> std::option::Option<&crate::model::TestingData> {
        self.output.as_ref()
    }
    /// <p>The location of the data validation manifest. The data validation manifest is created for the test dataset during model training.</p>
    pub fn validation(&self) -> std::option::Option<&crate::model::ValidationData> {
        self.validation.as_ref()
    }
}
impl std::fmt::Debug for TestingDataResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestingDataResult");
        formatter.field("input", &self.input);
        formatter.field("output", &self.output);
        formatter.field("validation", &self.validation);
        formatter.finish()
    }
}
/// See [`TestingDataResult`](crate::model::TestingDataResult)
pub mod testing_data_result {
    /// A builder for [`TestingDataResult`](crate::model::TestingDataResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<crate::model::TestingData>,
        pub(crate) output: std::option::Option<crate::model::TestingData>,
        pub(crate) validation: std::option::Option<crate::model::ValidationData>,
    }
    impl Builder {
        /// <p>The testing dataset that was supplied for training.</p>
        pub fn input(mut self, input: crate::model::TestingData) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>The testing dataset that was supplied for training.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::TestingData>) -> Self {
            self.input = input;
            self
        }
        /// <p>The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file formatting and other issues. </p>
        pub fn output(mut self, input: crate::model::TestingData) -> Self {
            self.output = Some(input);
            self
        }
        /// <p>The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file formatting and other issues. </p>
        pub fn set_output(mut self, input: std::option::Option<crate::model::TestingData>) -> Self {
            self.output = input;
            self
        }
        /// <p>The location of the data validation manifest. The data validation manifest is created for the test dataset during model training.</p>
        pub fn validation(mut self, input: crate::model::ValidationData) -> Self {
            self.validation = Some(input);
            self
        }
        /// <p>The location of the data validation manifest. The data validation manifest is created for the test dataset during model training.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::ValidationData>,
        ) -> Self {
            self.validation = input;
            self
        }
        /// Consumes the builder and constructs a [`TestingDataResult`](crate::model::TestingDataResult)
        pub fn build(self) -> crate::model::TestingDataResult {
            crate::model::TestingDataResult {
                input: self.input,
                output: self.output,
                validation: self.validation,
            }
        }
    }
}
impl TestingDataResult {
    /// Creates a new builder-style object to manufacture [`TestingDataResult`](crate::model::TestingDataResult)
    pub fn builder() -> crate::model::testing_data_result::Builder {
        crate::model::testing_data_result::Builder::default()
    }
}

/// <p>Contains the Amazon S3 bucket location of the validation data for a model training job. </p>
/// <p>The validation data includes error information for individual JSON Lines in the dataset. For more information, see <i>Debugging a Failed Model Training</i> in the Amazon Rekognition Custom Labels Developer Guide. </p>
/// <p>You get the <code>ValidationData</code> object for the training dataset (<code>TrainingDataResult</code>) and the test dataset (<code>TestingDataResult</code>) by calling <code>DescribeProjectVersions</code>. </p>
/// <p>The assets array contains a single <code>Asset</code> object. The <code>GroundTruthManifest</code> field of the Asset object contains the S3 bucket location of the validation data. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationData {
    /// <p>The assets that comprise the validation data. </p>
    pub assets: std::option::Option<std::vec::Vec<crate::model::Asset>>,
}
impl ValidationData {
    /// <p>The assets that comprise the validation data. </p>
    pub fn assets(&self) -> std::option::Option<&[crate::model::Asset]> {
        self.assets.as_deref()
    }
}
impl std::fmt::Debug for ValidationData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationData");
        formatter.field("assets", &self.assets);
        formatter.finish()
    }
}
/// See [`ValidationData`](crate::model::ValidationData)
pub mod validation_data {
    /// A builder for [`ValidationData`](crate::model::ValidationData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assets: std::option::Option<std::vec::Vec<crate::model::Asset>>,
    }
    impl Builder {
        /// Appends an item to `assets`.
        ///
        /// To override the contents of this collection use [`set_assets`](Self::set_assets).
        ///
        /// <p>The assets that comprise the validation data. </p>
        pub fn assets(mut self, input: crate::model::Asset) -> Self {
            let mut v = self.assets.unwrap_or_default();
            v.push(input);
            self.assets = Some(v);
            self
        }
        /// <p>The assets that comprise the validation data. </p>
        pub fn set_assets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Asset>>,
        ) -> Self {
            self.assets = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationData`](crate::model::ValidationData)
        pub fn build(self) -> crate::model::ValidationData {
            crate::model::ValidationData {
                assets: self.assets,
            }
        }
    }
}
impl ValidationData {
    /// Creates a new builder-style object to manufacture [`ValidationData`](crate::model::ValidationData)
    pub fn builder() -> crate::model::validation_data::Builder {
        crate::model::validation_data::Builder::default()
    }
}

/// <p>Assets are the images that you use to train and evaluate a model version. Assets can also contain validation information that you use to debug a failed model training. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Asset {
    /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
    pub ground_truth_manifest: std::option::Option<crate::model::GroundTruthManifest>,
}
impl Asset {
    /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
    pub fn ground_truth_manifest(&self) -> std::option::Option<&crate::model::GroundTruthManifest> {
        self.ground_truth_manifest.as_ref()
    }
}
impl std::fmt::Debug for Asset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Asset");
        formatter.field("ground_truth_manifest", &self.ground_truth_manifest);
        formatter.finish()
    }
}
/// See [`Asset`](crate::model::Asset)
pub mod asset {
    /// A builder for [`Asset`](crate::model::Asset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ground_truth_manifest: std::option::Option<crate::model::GroundTruthManifest>,
    }
    impl Builder {
        /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
        pub fn ground_truth_manifest(mut self, input: crate::model::GroundTruthManifest) -> Self {
            self.ground_truth_manifest = Some(input);
            self
        }
        /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
        pub fn set_ground_truth_manifest(
            mut self,
            input: std::option::Option<crate::model::GroundTruthManifest>,
        ) -> Self {
            self.ground_truth_manifest = input;
            self
        }
        /// Consumes the builder and constructs a [`Asset`](crate::model::Asset)
        pub fn build(self) -> crate::model::Asset {
            crate::model::Asset {
                ground_truth_manifest: self.ground_truth_manifest,
            }
        }
    }
}
impl Asset {
    /// Creates a new builder-style object to manufacture [`Asset`](crate::model::Asset)
    pub fn builder() -> crate::model::asset::Builder {
        crate::model::asset::Builder::default()
    }
}

/// <p>The dataset used for testing. Optionally, if <code>AutoCreate</code> is set, Amazon Rekognition Custom Labels uses the training dataset to create a test dataset with a temporary split of the training dataset. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestingData {
    /// <p>The assets used for testing.</p>
    pub assets: std::option::Option<std::vec::Vec<crate::model::Asset>>,
    /// <p>If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create a test dataset (20%) for the training job. After training completes, the test dataset is not stored and the training dataset reverts to its previous size.</p>
    pub auto_create: bool,
}
impl TestingData {
    /// <p>The assets used for testing.</p>
    pub fn assets(&self) -> std::option::Option<&[crate::model::Asset]> {
        self.assets.as_deref()
    }
    /// <p>If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create a test dataset (20%) for the training job. After training completes, the test dataset is not stored and the training dataset reverts to its previous size.</p>
    pub fn auto_create(&self) -> bool {
        self.auto_create
    }
}
impl std::fmt::Debug for TestingData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestingData");
        formatter.field("assets", &self.assets);
        formatter.field("auto_create", &self.auto_create);
        formatter.finish()
    }
}
/// See [`TestingData`](crate::model::TestingData)
pub mod testing_data {
    /// A builder for [`TestingData`](crate::model::TestingData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assets: std::option::Option<std::vec::Vec<crate::model::Asset>>,
        pub(crate) auto_create: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `assets`.
        ///
        /// To override the contents of this collection use [`set_assets`](Self::set_assets).
        ///
        /// <p>The assets used for testing.</p>
        pub fn assets(mut self, input: crate::model::Asset) -> Self {
            let mut v = self.assets.unwrap_or_default();
            v.push(input);
            self.assets = Some(v);
            self
        }
        /// <p>The assets used for testing.</p>
        pub fn set_assets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Asset>>,
        ) -> Self {
            self.assets = input;
            self
        }
        /// <p>If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create a test dataset (20%) for the training job. After training completes, the test dataset is not stored and the training dataset reverts to its previous size.</p>
        pub fn auto_create(mut self, input: bool) -> Self {
            self.auto_create = Some(input);
            self
        }
        /// <p>If specified, Amazon Rekognition Custom Labels temporarily splits the training dataset (80%) to create a test dataset (20%) for the training job. After training completes, the test dataset is not stored and the training dataset reverts to its previous size.</p>
        pub fn set_auto_create(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_create = input;
            self
        }
        /// Consumes the builder and constructs a [`TestingData`](crate::model::TestingData)
        pub fn build(self) -> crate::model::TestingData {
            crate::model::TestingData {
                assets: self.assets,
                auto_create: self.auto_create.unwrap_or_default(),
            }
        }
    }
}
impl TestingData {
    /// Creates a new builder-style object to manufacture [`TestingData`](crate::model::TestingData)
    pub fn builder() -> crate::model::testing_data::Builder {
        crate::model::testing_data::Builder::default()
    }
}

/// <p>Sagemaker Groundtruth format manifest files for the input, output and validation datasets that are used and created during testing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrainingDataResult {
    /// <p>The training assets that you supplied for training.</p>
    pub input: std::option::Option<crate::model::TrainingData>,
    /// <p>The images (assets) that were actually trained by Amazon Rekognition Custom Labels. </p>
    pub output: std::option::Option<crate::model::TrainingData>,
    /// <p>The location of the data validation manifest. The data validation manifest is created for the training dataset during model training.</p>
    pub validation: std::option::Option<crate::model::ValidationData>,
}
impl TrainingDataResult {
    /// <p>The training assets that you supplied for training.</p>
    pub fn input(&self) -> std::option::Option<&crate::model::TrainingData> {
        self.input.as_ref()
    }
    /// <p>The images (assets) that were actually trained by Amazon Rekognition Custom Labels. </p>
    pub fn output(&self) -> std::option::Option<&crate::model::TrainingData> {
        self.output.as_ref()
    }
    /// <p>The location of the data validation manifest. The data validation manifest is created for the training dataset during model training.</p>
    pub fn validation(&self) -> std::option::Option<&crate::model::ValidationData> {
        self.validation.as_ref()
    }
}
impl std::fmt::Debug for TrainingDataResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrainingDataResult");
        formatter.field("input", &self.input);
        formatter.field("output", &self.output);
        formatter.field("validation", &self.validation);
        formatter.finish()
    }
}
/// See [`TrainingDataResult`](crate::model::TrainingDataResult)
pub mod training_data_result {
    /// A builder for [`TrainingDataResult`](crate::model::TrainingDataResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input: std::option::Option<crate::model::TrainingData>,
        pub(crate) output: std::option::Option<crate::model::TrainingData>,
        pub(crate) validation: std::option::Option<crate::model::ValidationData>,
    }
    impl Builder {
        /// <p>The training assets that you supplied for training.</p>
        pub fn input(mut self, input: crate::model::TrainingData) -> Self {
            self.input = Some(input);
            self
        }
        /// <p>The training assets that you supplied for training.</p>
        pub fn set_input(mut self, input: std::option::Option<crate::model::TrainingData>) -> Self {
            self.input = input;
            self
        }
        /// <p>The images (assets) that were actually trained by Amazon Rekognition Custom Labels. </p>
        pub fn output(mut self, input: crate::model::TrainingData) -> Self {
            self.output = Some(input);
            self
        }
        /// <p>The images (assets) that were actually trained by Amazon Rekognition Custom Labels. </p>
        pub fn set_output(
            mut self,
            input: std::option::Option<crate::model::TrainingData>,
        ) -> Self {
            self.output = input;
            self
        }
        /// <p>The location of the data validation manifest. The data validation manifest is created for the training dataset during model training.</p>
        pub fn validation(mut self, input: crate::model::ValidationData) -> Self {
            self.validation = Some(input);
            self
        }
        /// <p>The location of the data validation manifest. The data validation manifest is created for the training dataset during model training.</p>
        pub fn set_validation(
            mut self,
            input: std::option::Option<crate::model::ValidationData>,
        ) -> Self {
            self.validation = input;
            self
        }
        /// Consumes the builder and constructs a [`TrainingDataResult`](crate::model::TrainingDataResult)
        pub fn build(self) -> crate::model::TrainingDataResult {
            crate::model::TrainingDataResult {
                input: self.input,
                output: self.output,
                validation: self.validation,
            }
        }
    }
}
impl TrainingDataResult {
    /// Creates a new builder-style object to manufacture [`TrainingDataResult`](crate::model::TrainingDataResult)
    pub fn builder() -> crate::model::training_data_result::Builder {
        crate::model::training_data_result::Builder::default()
    }
}

/// <p>The dataset used for training.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrainingData {
    /// <p>A Sagemaker GroundTruth manifest file that contains the training images (assets).</p>
    pub assets: std::option::Option<std::vec::Vec<crate::model::Asset>>,
}
impl TrainingData {
    /// <p>A Sagemaker GroundTruth manifest file that contains the training images (assets).</p>
    pub fn assets(&self) -> std::option::Option<&[crate::model::Asset]> {
        self.assets.as_deref()
    }
}
impl std::fmt::Debug for TrainingData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrainingData");
        formatter.field("assets", &self.assets);
        formatter.finish()
    }
}
/// See [`TrainingData`](crate::model::TrainingData)
pub mod training_data {
    /// A builder for [`TrainingData`](crate::model::TrainingData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assets: std::option::Option<std::vec::Vec<crate::model::Asset>>,
    }
    impl Builder {
        /// Appends an item to `assets`.
        ///
        /// To override the contents of this collection use [`set_assets`](Self::set_assets).
        ///
        /// <p>A Sagemaker GroundTruth manifest file that contains the training images (assets).</p>
        pub fn assets(mut self, input: crate::model::Asset) -> Self {
            let mut v = self.assets.unwrap_or_default();
            v.push(input);
            self.assets = Some(v);
            self
        }
        /// <p>A Sagemaker GroundTruth manifest file that contains the training images (assets).</p>
        pub fn set_assets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Asset>>,
        ) -> Self {
            self.assets = input;
            self
        }
        /// Consumes the builder and constructs a [`TrainingData`](crate::model::TrainingData)
        pub fn build(self) -> crate::model::TrainingData {
            crate::model::TrainingData {
                assets: self.assets,
            }
        }
    }
}
impl TrainingData {
    /// Creates a new builder-style object to manufacture [`TrainingData`](crate::model::TrainingData)
    pub fn builder() -> crate::model::training_data::Builder {
        crate::model::training_data::Builder::default()
    }
}

/// <p>The S3 bucket and folder location where training output is placed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputConfig {
    /// <p>The S3 bucket where training output is placed.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The prefix applied to the training output files. </p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
}
impl OutputConfig {
    /// <p>The S3 bucket where training output is placed.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The prefix applied to the training output files. </p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
}
impl std::fmt::Debug for OutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputConfig");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.finish()
    }
}
/// See [`OutputConfig`](crate::model::OutputConfig)
pub mod output_config {
    /// A builder for [`OutputConfig`](crate::model::OutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket where training output is placed.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The S3 bucket where training output is placed.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The prefix applied to the training output files. </p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix applied to the training output files. </p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputConfig`](crate::model::OutputConfig)
        pub fn build(self) -> crate::model::OutputConfig {
            crate::model::OutputConfig {
                s3_bucket: self.s3_bucket,
                s3_key_prefix: self.s3_key_prefix,
            }
        }
    }
}
impl OutputConfig {
    /// Creates a new builder-style object to manufacture [`OutputConfig`](crate::model::OutputConfig)
    pub fn builder() -> crate::model::output_config::Builder {
        crate::model::output_config::Builder::default()
    }
}

/// <p>A description of an Amazon Rekognition Custom Labels project. For more information, see <code>DescribeProjects</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectDescription {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The Unix timestamp for the date and time that the project was created.</p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current status of the project.</p>
    pub status: std::option::Option<crate::model::ProjectStatus>,
    /// <p> Information about the training and test datasets in the project. </p>
    pub datasets: std::option::Option<std::vec::Vec<crate::model::DatasetMetadata>>,
}
impl ProjectDescription {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The Unix timestamp for the date and time that the project was created.</p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_timestamp.as_ref()
    }
    /// <p>The current status of the project.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProjectStatus> {
        self.status.as_ref()
    }
    /// <p> Information about the training and test datasets in the project. </p>
    pub fn datasets(&self) -> std::option::Option<&[crate::model::DatasetMetadata]> {
        self.datasets.as_deref()
    }
}
impl std::fmt::Debug for ProjectDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectDescription");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("status", &self.status);
        formatter.field("datasets", &self.datasets);
        formatter.finish()
    }
}
/// See [`ProjectDescription`](crate::model::ProjectDescription)
pub mod project_description {
    /// A builder for [`ProjectDescription`](crate::model::ProjectDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ProjectStatus>,
        pub(crate) datasets: std::option::Option<std::vec::Vec<crate::model::DatasetMetadata>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The Unix timestamp for the date and time that the project was created.</p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p>The Unix timestamp for the date and time that the project was created.</p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p>The current status of the project.</p>
        pub fn status(mut self, input: crate::model::ProjectStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the project.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProjectStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// <p> Information about the training and test datasets in the project. </p>
        pub fn datasets(mut self, input: crate::model::DatasetMetadata) -> Self {
            let mut v = self.datasets.unwrap_or_default();
            v.push(input);
            self.datasets = Some(v);
            self
        }
        /// <p> Information about the training and test datasets in the project. </p>
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatasetMetadata>>,
        ) -> Self {
            self.datasets = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectDescription`](crate::model::ProjectDescription)
        pub fn build(self) -> crate::model::ProjectDescription {
            crate::model::ProjectDescription {
                project_arn: self.project_arn,
                creation_timestamp: self.creation_timestamp,
                status: self.status,
                datasets: self.datasets,
            }
        }
    }
}
impl ProjectDescription {
    /// Creates a new builder-style object to manufacture [`ProjectDescription`](crate::model::ProjectDescription)
    pub fn builder() -> crate::model::project_description::Builder {
        crate::model::project_description::Builder::default()
    }
}

/// <p> Summary information for an Amazon Rekognition Custom Labels dataset. For more information, see <code>ProjectDescription</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetMetadata {
    /// <p> The Unix timestamp for the date and time that the dataset was created. </p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The type of the dataset. </p>
    pub dataset_type: std::option::Option<crate::model::DatasetType>,
    /// <p> The Amazon Resource Name (ARN) for the dataset. </p>
    pub dataset_arn: std::option::Option<std::string::String>,
    /// <p> The status for the dataset. </p>
    pub status: std::option::Option<crate::model::DatasetStatus>,
    /// <p> The status message for the dataset. </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
    pub status_message_code: std::option::Option<crate::model::DatasetStatusMessageCode>,
}
impl DatasetMetadata {
    /// <p> The Unix timestamp for the date and time that the dataset was created. </p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_timestamp.as_ref()
    }
    /// <p> The type of the dataset. </p>
    pub fn dataset_type(&self) -> std::option::Option<&crate::model::DatasetType> {
        self.dataset_type.as_ref()
    }
    /// <p> The Amazon Resource Name (ARN) for the dataset. </p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
    /// <p> The status for the dataset. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::DatasetStatus> {
        self.status.as_ref()
    }
    /// <p> The status message for the dataset. </p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
    pub fn status_message_code(
        &self,
    ) -> std::option::Option<&crate::model::DatasetStatusMessageCode> {
        self.status_message_code.as_ref()
    }
}
impl std::fmt::Debug for DatasetMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetMetadata");
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("status_message_code", &self.status_message_code);
        formatter.finish()
    }
}
/// See [`DatasetMetadata`](crate::model::DatasetMetadata)
pub mod dataset_metadata {
    /// A builder for [`DatasetMetadata`](crate::model::DatasetMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dataset_type: std::option::Option<crate::model::DatasetType>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DatasetStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) status_message_code: std::option::Option<crate::model::DatasetStatusMessageCode>,
    }
    impl Builder {
        /// <p> The Unix timestamp for the date and time that the dataset was created. </p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p> The Unix timestamp for the date and time that the dataset was created. </p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p> The type of the dataset. </p>
        pub fn dataset_type(mut self, input: crate::model::DatasetType) -> Self {
            self.dataset_type = Some(input);
            self
        }
        /// <p> The type of the dataset. </p>
        pub fn set_dataset_type(
            mut self,
            input: std::option::Option<crate::model::DatasetType>,
        ) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the dataset. </p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the dataset. </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// <p> The status for the dataset. </p>
        pub fn status(mut self, input: crate::model::DatasetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status for the dataset. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatasetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The status message for the dataset. </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p> The status message for the dataset. </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
        pub fn status_message_code(
            mut self,
            input: crate::model::DatasetStatusMessageCode,
        ) -> Self {
            self.status_message_code = Some(input);
            self
        }
        /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
        pub fn set_status_message_code(
            mut self,
            input: std::option::Option<crate::model::DatasetStatusMessageCode>,
        ) -> Self {
            self.status_message_code = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetMetadata`](crate::model::DatasetMetadata)
        pub fn build(self) -> crate::model::DatasetMetadata {
            crate::model::DatasetMetadata {
                creation_timestamp: self.creation_timestamp,
                dataset_type: self.dataset_type,
                dataset_arn: self.dataset_arn,
                status: self.status,
                status_message: self.status_message,
                status_message_code: self.status_message_code,
            }
        }
    }
}
impl DatasetMetadata {
    /// Creates a new builder-style object to manufacture [`DatasetMetadata`](crate::model::DatasetMetadata)
    pub fn builder() -> crate::model::dataset_metadata::Builder {
        crate::model::dataset_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetStatusMessageCode {
    #[allow(missing_docs)] // documentation missing in model
    ClientError,
    #[allow(missing_docs)] // documentation missing in model
    ServiceError,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetStatusMessageCode {
    fn from(s: &str) -> Self {
        match s {
            "CLIENT_ERROR" => DatasetStatusMessageCode::ClientError,
            "SERVICE_ERROR" => DatasetStatusMessageCode::ServiceError,
            "SUCCESS" => DatasetStatusMessageCode::Success,
            other => DatasetStatusMessageCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetStatusMessageCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetStatusMessageCode::from(s))
    }
}
impl DatasetStatusMessageCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetStatusMessageCode::ClientError => "CLIENT_ERROR",
            DatasetStatusMessageCode::ServiceError => "SERVICE_ERROR",
            DatasetStatusMessageCode::Success => "SUCCESS",
            DatasetStatusMessageCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLIENT_ERROR", "SERVICE_ERROR", "SUCCESS"]
    }
}
impl AsRef<str> for DatasetStatusMessageCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateComplete,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    UpdateComplete,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_COMPLETE" => DatasetStatus::CreateComplete,
            "CREATE_FAILED" => DatasetStatus::CreateFailed,
            "CREATE_IN_PROGRESS" => DatasetStatus::CreateInProgress,
            "DELETE_IN_PROGRESS" => DatasetStatus::DeleteInProgress,
            "UPDATE_COMPLETE" => DatasetStatus::UpdateComplete,
            "UPDATE_FAILED" => DatasetStatus::UpdateFailed,
            "UPDATE_IN_PROGRESS" => DatasetStatus::UpdateInProgress,
            other => DatasetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetStatus::from(s))
    }
}
impl DatasetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetStatus::CreateComplete => "CREATE_COMPLETE",
            DatasetStatus::CreateFailed => "CREATE_FAILED",
            DatasetStatus::CreateInProgress => "CREATE_IN_PROGRESS",
            DatasetStatus::DeleteInProgress => "DELETE_IN_PROGRESS",
            DatasetStatus::UpdateComplete => "UPDATE_COMPLETE",
            DatasetStatus::UpdateFailed => "UPDATE_FAILED",
            DatasetStatus::UpdateInProgress => "UPDATE_IN_PROGRESS",
            DatasetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_COMPLETE",
            "CREATE_FAILED",
            "CREATE_IN_PROGRESS",
            "DELETE_IN_PROGRESS",
            "UPDATE_COMPLETE",
            "UPDATE_FAILED",
            "UPDATE_IN_PROGRESS",
        ]
    }
}
impl AsRef<str> for DatasetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatasetType {
    #[allow(missing_docs)] // documentation missing in model
    Test,
    #[allow(missing_docs)] // documentation missing in model
    Train,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatasetType {
    fn from(s: &str) -> Self {
        match s {
            "TEST" => DatasetType::Test,
            "TRAIN" => DatasetType::Train,
            other => DatasetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatasetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatasetType::from(s))
    }
}
impl DatasetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatasetType::Test => "TEST",
            DatasetType::Train => "TRAIN",
            DatasetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TEST", "TRAIN"]
    }
}
impl AsRef<str> for DatasetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProjectStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProjectStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => ProjectStatus::Created,
            "CREATING" => ProjectStatus::Creating,
            "DELETING" => ProjectStatus::Deleting,
            other => ProjectStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProjectStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProjectStatus::from(s))
    }
}
impl ProjectStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProjectStatus::Created => "CREATED",
            ProjectStatus::Creating => "CREATING",
            ProjectStatus::Deleting => "DELETING",
            ProjectStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED", "CREATING", "DELETING"]
    }
}
impl AsRef<str> for ProjectStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A description for a dataset. For more information, see <code>DescribeDataset</code>.</p>
/// <p>The status fields <code>Status</code>, <code>StatusMessage</code>, and <code>StatusMessageCode</code> reflect the last operation on the dataset. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetDescription {
    /// <p> The Unix timestamp for the time and date that the dataset was created. </p>
    pub creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The Unix timestamp for the date and time that the dataset was last updated. </p>
    pub last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The status of the dataset. </p>
    pub status: std::option::Option<crate::model::DatasetStatus>,
    /// <p> The status message for the dataset. </p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
    pub status_message_code: std::option::Option<crate::model::DatasetStatusMessageCode>,
    /// <p> The status message code for the dataset. </p>
    pub dataset_stats: std::option::Option<crate::model::DatasetStats>,
}
impl DatasetDescription {
    /// <p> The Unix timestamp for the time and date that the dataset was created. </p>
    pub fn creation_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_timestamp.as_ref()
    }
    /// <p> The Unix timestamp for the date and time that the dataset was last updated. </p>
    pub fn last_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_timestamp.as_ref()
    }
    /// <p> The status of the dataset. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::DatasetStatus> {
        self.status.as_ref()
    }
    /// <p> The status message for the dataset. </p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
    pub fn status_message_code(
        &self,
    ) -> std::option::Option<&crate::model::DatasetStatusMessageCode> {
        self.status_message_code.as_ref()
    }
    /// <p> The status message code for the dataset. </p>
    pub fn dataset_stats(&self) -> std::option::Option<&crate::model::DatasetStats> {
        self.dataset_stats.as_ref()
    }
}
impl std::fmt::Debug for DatasetDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetDescription");
        formatter.field("creation_timestamp", &self.creation_timestamp);
        formatter.field("last_updated_timestamp", &self.last_updated_timestamp);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("status_message_code", &self.status_message_code);
        formatter.field("dataset_stats", &self.dataset_stats);
        formatter.finish()
    }
}
/// See [`DatasetDescription`](crate::model::DatasetDescription)
pub mod dataset_description {
    /// A builder for [`DatasetDescription`](crate::model::DatasetDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::DatasetStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) status_message_code: std::option::Option<crate::model::DatasetStatusMessageCode>,
        pub(crate) dataset_stats: std::option::Option<crate::model::DatasetStats>,
    }
    impl Builder {
        /// <p> The Unix timestamp for the time and date that the dataset was created. </p>
        pub fn creation_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_timestamp = Some(input);
            self
        }
        /// <p> The Unix timestamp for the time and date that the dataset was created. </p>
        pub fn set_creation_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_timestamp = input;
            self
        }
        /// <p> The Unix timestamp for the date and time that the dataset was last updated. </p>
        pub fn last_updated_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_timestamp = Some(input);
            self
        }
        /// <p> The Unix timestamp for the date and time that the dataset was last updated. </p>
        pub fn set_last_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_timestamp = input;
            self
        }
        /// <p> The status of the dataset. </p>
        pub fn status(mut self, input: crate::model::DatasetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the dataset. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatasetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The status message for the dataset. </p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p> The status message for the dataset. </p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
        pub fn status_message_code(
            mut self,
            input: crate::model::DatasetStatusMessageCode,
        ) -> Self {
            self.status_message_code = Some(input);
            self
        }
        /// <p> The status message code for the dataset operation. If a service error occurs, try the API call again later. If a client error occurs, check the input parameters to the dataset API call that failed. </p>
        pub fn set_status_message_code(
            mut self,
            input: std::option::Option<crate::model::DatasetStatusMessageCode>,
        ) -> Self {
            self.status_message_code = input;
            self
        }
        /// <p> The status message code for the dataset. </p>
        pub fn dataset_stats(mut self, input: crate::model::DatasetStats) -> Self {
            self.dataset_stats = Some(input);
            self
        }
        /// <p> The status message code for the dataset. </p>
        pub fn set_dataset_stats(
            mut self,
            input: std::option::Option<crate::model::DatasetStats>,
        ) -> Self {
            self.dataset_stats = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetDescription`](crate::model::DatasetDescription)
        pub fn build(self) -> crate::model::DatasetDescription {
            crate::model::DatasetDescription {
                creation_timestamp: self.creation_timestamp,
                last_updated_timestamp: self.last_updated_timestamp,
                status: self.status,
                status_message: self.status_message,
                status_message_code: self.status_message_code,
                dataset_stats: self.dataset_stats,
            }
        }
    }
}
impl DatasetDescription {
    /// Creates a new builder-style object to manufacture [`DatasetDescription`](crate::model::DatasetDescription)
    pub fn builder() -> crate::model::dataset_description::Builder {
        crate::model::dataset_description::Builder::default()
    }
}

/// <p> Provides statistics about a dataset. For more information, see <code>DescribeDataset</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetStats {
    /// <p> The total number of images in the dataset that have labels. </p>
    pub labeled_entries: std::option::Option<i32>,
    /// <p> The total number of images in the dataset. </p>
    pub total_entries: std::option::Option<i32>,
    /// <p> The total number of labels declared in the dataset. </p>
    pub total_labels: std::option::Option<i32>,
    /// <p> The total number of entries that contain at least one error. </p>
    pub error_entries: std::option::Option<i32>,
}
impl DatasetStats {
    /// <p> The total number of images in the dataset that have labels. </p>
    pub fn labeled_entries(&self) -> std::option::Option<i32> {
        self.labeled_entries
    }
    /// <p> The total number of images in the dataset. </p>
    pub fn total_entries(&self) -> std::option::Option<i32> {
        self.total_entries
    }
    /// <p> The total number of labels declared in the dataset. </p>
    pub fn total_labels(&self) -> std::option::Option<i32> {
        self.total_labels
    }
    /// <p> The total number of entries that contain at least one error. </p>
    pub fn error_entries(&self) -> std::option::Option<i32> {
        self.error_entries
    }
}
impl std::fmt::Debug for DatasetStats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetStats");
        formatter.field("labeled_entries", &self.labeled_entries);
        formatter.field("total_entries", &self.total_entries);
        formatter.field("total_labels", &self.total_labels);
        formatter.field("error_entries", &self.error_entries);
        formatter.finish()
    }
}
/// See [`DatasetStats`](crate::model::DatasetStats)
pub mod dataset_stats {
    /// A builder for [`DatasetStats`](crate::model::DatasetStats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) labeled_entries: std::option::Option<i32>,
        pub(crate) total_entries: std::option::Option<i32>,
        pub(crate) total_labels: std::option::Option<i32>,
        pub(crate) error_entries: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The total number of images in the dataset that have labels. </p>
        pub fn labeled_entries(mut self, input: i32) -> Self {
            self.labeled_entries = Some(input);
            self
        }
        /// <p> The total number of images in the dataset that have labels. </p>
        pub fn set_labeled_entries(mut self, input: std::option::Option<i32>) -> Self {
            self.labeled_entries = input;
            self
        }
        /// <p> The total number of images in the dataset. </p>
        pub fn total_entries(mut self, input: i32) -> Self {
            self.total_entries = Some(input);
            self
        }
        /// <p> The total number of images in the dataset. </p>
        pub fn set_total_entries(mut self, input: std::option::Option<i32>) -> Self {
            self.total_entries = input;
            self
        }
        /// <p> The total number of labels declared in the dataset. </p>
        pub fn total_labels(mut self, input: i32) -> Self {
            self.total_labels = Some(input);
            self
        }
        /// <p> The total number of labels declared in the dataset. </p>
        pub fn set_total_labels(mut self, input: std::option::Option<i32>) -> Self {
            self.total_labels = input;
            self
        }
        /// <p> The total number of entries that contain at least one error. </p>
        pub fn error_entries(mut self, input: i32) -> Self {
            self.error_entries = Some(input);
            self
        }
        /// <p> The total number of entries that contain at least one error. </p>
        pub fn set_error_entries(mut self, input: std::option::Option<i32>) -> Self {
            self.error_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetStats`](crate::model::DatasetStats)
        pub fn build(self) -> crate::model::DatasetStats {
            crate::model::DatasetStats {
                labeled_entries: self.labeled_entries,
                total_entries: self.total_entries,
                total_labels: self.total_labels,
                error_entries: self.error_entries,
            }
        }
    }
}
impl DatasetStats {
    /// Creates a new builder-style object to manufacture [`DatasetStats`](crate::model::DatasetStats)
    pub fn builder() -> crate::model::dataset_stats::Builder {
        crate::model::dataset_stats::Builder::default()
    }
}

/// <p> The source that Amazon Rekognition Custom Labels uses to create a dataset. To use an Amazon Sagemaker format manifest file, specify the S3 bucket location in the <code>GroundTruthManifest</code> field. The S3 bucket must be in your AWS account. To create a copy of an existing dataset, specify the Amazon Resource Name (ARN) of an existing dataset in <code>DatasetArn</code>.</p>
/// <p>You need to specify a value for <code>DatasetArn</code> or <code>GroundTruthManifest</code>, but not both. if you supply both values, or if you don't specify any values, an InvalidParameterException exception occurs. </p>
/// <p>For more information, see <code>CreateDataset</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatasetSource {
    /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
    pub ground_truth_manifest: std::option::Option<crate::model::GroundTruthManifest>,
    /// <p> The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy. </p>
    pub dataset_arn: std::option::Option<std::string::String>,
}
impl DatasetSource {
    /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
    pub fn ground_truth_manifest(&self) -> std::option::Option<&crate::model::GroundTruthManifest> {
        self.ground_truth_manifest.as_ref()
    }
    /// <p> The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy. </p>
    pub fn dataset_arn(&self) -> std::option::Option<&str> {
        self.dataset_arn.as_deref()
    }
}
impl std::fmt::Debug for DatasetSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatasetSource");
        formatter.field("ground_truth_manifest", &self.ground_truth_manifest);
        formatter.field("dataset_arn", &self.dataset_arn);
        formatter.finish()
    }
}
/// See [`DatasetSource`](crate::model::DatasetSource)
pub mod dataset_source {
    /// A builder for [`DatasetSource`](crate::model::DatasetSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ground_truth_manifest: std::option::Option<crate::model::GroundTruthManifest>,
        pub(crate) dataset_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
        pub fn ground_truth_manifest(mut self, input: crate::model::GroundTruthManifest) -> Self {
            self.ground_truth_manifest = Some(input);
            self
        }
        /// <p>The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest file. </p>
        pub fn set_ground_truth_manifest(
            mut self,
            input: std::option::Option<crate::model::GroundTruthManifest>,
        ) -> Self {
            self.ground_truth_manifest = input;
            self
        }
        /// <p> The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy. </p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_arn = Some(input.into());
            self
        }
        /// <p> The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy. </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DatasetSource`](crate::model::DatasetSource)
        pub fn build(self) -> crate::model::DatasetSource {
            crate::model::DatasetSource {
                ground_truth_manifest: self.ground_truth_manifest,
                dataset_arn: self.dataset_arn,
            }
        }
    }
}
impl DatasetSource {
    /// Creates a new builder-style object to manufacture [`DatasetSource`](crate::model::DatasetSource)
    pub fn builder() -> crate::model::dataset_source::Builder {
        crate::model::dataset_source::Builder::default()
    }
}

/// <p>Provides information about a face in a target image that matches the source image face analyzed by <code>CompareFaces</code>. The <code>Face</code> property contains the bounding box of the face in the target image. The <code>Similarity</code> property is the confidence that the source image face matches the face in the bounding box.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompareFacesMatch {
    /// <p>Level of confidence that the faces match.</p>
    pub similarity: std::option::Option<f32>,
    /// <p>Provides face metadata (bounding box and confidence that the bounding box actually contains a face).</p>
    pub face: std::option::Option<crate::model::ComparedFace>,
}
impl CompareFacesMatch {
    /// <p>Level of confidence that the faces match.</p>
    pub fn similarity(&self) -> std::option::Option<f32> {
        self.similarity
    }
    /// <p>Provides face metadata (bounding box and confidence that the bounding box actually contains a face).</p>
    pub fn face(&self) -> std::option::Option<&crate::model::ComparedFace> {
        self.face.as_ref()
    }
}
impl std::fmt::Debug for CompareFacesMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompareFacesMatch");
        formatter.field("similarity", &self.similarity);
        formatter.field("face", &self.face);
        formatter.finish()
    }
}
/// See [`CompareFacesMatch`](crate::model::CompareFacesMatch)
pub mod compare_faces_match {
    /// A builder for [`CompareFacesMatch`](crate::model::CompareFacesMatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) similarity: std::option::Option<f32>,
        pub(crate) face: std::option::Option<crate::model::ComparedFace>,
    }
    impl Builder {
        /// <p>Level of confidence that the faces match.</p>
        pub fn similarity(mut self, input: f32) -> Self {
            self.similarity = Some(input);
            self
        }
        /// <p>Level of confidence that the faces match.</p>
        pub fn set_similarity(mut self, input: std::option::Option<f32>) -> Self {
            self.similarity = input;
            self
        }
        /// <p>Provides face metadata (bounding box and confidence that the bounding box actually contains a face).</p>
        pub fn face(mut self, input: crate::model::ComparedFace) -> Self {
            self.face = Some(input);
            self
        }
        /// <p>Provides face metadata (bounding box and confidence that the bounding box actually contains a face).</p>
        pub fn set_face(mut self, input: std::option::Option<crate::model::ComparedFace>) -> Self {
            self.face = input;
            self
        }
        /// Consumes the builder and constructs a [`CompareFacesMatch`](crate::model::CompareFacesMatch)
        pub fn build(self) -> crate::model::CompareFacesMatch {
            crate::model::CompareFacesMatch {
                similarity: self.similarity,
                face: self.face,
            }
        }
    }
}
impl CompareFacesMatch {
    /// Creates a new builder-style object to manufacture [`CompareFacesMatch`](crate::model::CompareFacesMatch)
    pub fn builder() -> crate::model::compare_faces_match::Builder {
        crate::model::compare_faces_match::Builder::default()
    }
}

/// <p>Type that describes the face Amazon Rekognition chose to compare with the faces in the target. This contains a bounding box for the selected face and confidence level that the bounding box contains a face. Note that Amazon Rekognition selects the largest face in the source image for this comparison. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComparedSourceImageFace {
    /// <p>Bounding box of the face.</p>
    pub bounding_box: std::option::Option<crate::model::BoundingBox>,
    /// <p>Confidence level that the selected bounding box contains a face.</p>
    pub confidence: std::option::Option<f32>,
}
impl ComparedSourceImageFace {
    /// <p>Bounding box of the face.</p>
    pub fn bounding_box(&self) -> std::option::Option<&crate::model::BoundingBox> {
        self.bounding_box.as_ref()
    }
    /// <p>Confidence level that the selected bounding box contains a face.</p>
    pub fn confidence(&self) -> std::option::Option<f32> {
        self.confidence
    }
}
impl std::fmt::Debug for ComparedSourceImageFace {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComparedSourceImageFace");
        formatter.field("bounding_box", &self.bounding_box);
        formatter.field("confidence", &self.confidence);
        formatter.finish()
    }
}
/// See [`ComparedSourceImageFace`](crate::model::ComparedSourceImageFace)
pub mod compared_source_image_face {
    /// A builder for [`ComparedSourceImageFace`](crate::model::ComparedSourceImageFace)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bounding_box: std::option::Option<crate::model::BoundingBox>,
        pub(crate) confidence: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>Bounding box of the face.</p>
        pub fn bounding_box(mut self, input: crate::model::BoundingBox) -> Self {
            self.bounding_box = Some(input);
            self
        }
        /// <p>Bounding box of the face.</p>
        pub fn set_bounding_box(
            mut self,
            input: std::option::Option<crate::model::BoundingBox>,
        ) -> Self {
            self.bounding_box = input;
            self
        }
        /// <p>Confidence level that the selected bounding box contains a face.</p>
        pub fn confidence(mut self, input: f32) -> Self {
            self.confidence = Some(input);
            self
        }
        /// <p>Confidence level that the selected bounding box contains a face.</p>
        pub fn set_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.confidence = input;
            self
        }
        /// Consumes the builder and constructs a [`ComparedSourceImageFace`](crate::model::ComparedSourceImageFace)
        pub fn build(self) -> crate::model::ComparedSourceImageFace {
            crate::model::ComparedSourceImageFace {
                bounding_box: self.bounding_box,
                confidence: self.confidence,
            }
        }
    }
}
impl ComparedSourceImageFace {
    /// Creates a new builder-style object to manufacture [`ComparedSourceImageFace`](crate::model::ComparedSourceImageFace)
    pub fn builder() -> crate::model::compared_source_image_face::Builder {
        crate::model::compared_source_image_face::Builder::default()
    }
}
