// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Rekognition
///
/// Client for invoking operations on Amazon Rekognition. Each operation on Amazon Rekognition is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_rekognition::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_rekognition::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_rekognition::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CompareFaces`](crate::client::fluent_builders::CompareFaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_image(Image)`](crate::client::fluent_builders::CompareFaces::source_image) / [`set_source_image(Option<Image>)`](crate::client::fluent_builders::CompareFaces::set_source_image): <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`target_image(Image)`](crate::client::fluent_builders::CompareFaces::target_image) / [`set_target_image(Option<Image>)`](crate::client::fluent_builders::CompareFaces::set_target_image): <p>The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`similarity_threshold(f32)`](crate::client::fluent_builders::CompareFaces::similarity_threshold) / [`set_similarity_threshold(Option<f32>)`](crate::client::fluent_builders::CompareFaces::set_similarity_threshold): <p>The minimum level of confidence in the face matches that a match must meet to be included in the <code>FaceMatches</code> array.</p>
    ///   - [`quality_filter(QualityFilter)`](crate::client::fluent_builders::CompareFaces::quality_filter) / [`set_quality_filter(Option<QualityFilter>)`](crate::client::fluent_builders::CompareFaces::set_quality_filter): <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>  <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
    /// - On success, responds with [`CompareFacesOutput`](crate::output::CompareFacesOutput) with field(s):
    ///   - [`source_image_face(Option<ComparedSourceImageFace>)`](crate::output::CompareFacesOutput::source_image_face): <p>The face in the source image that was used for comparison.</p>
    ///   - [`face_matches(Option<Vec<CompareFacesMatch>>)`](crate::output::CompareFacesOutput::face_matches): <p>An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the bounding box contains a face, and the similarity score for the face in the bounding box and the face in the source image.</p>
    ///   - [`unmatched_faces(Option<Vec<ComparedFace>>)`](crate::output::CompareFacesOutput::unmatched_faces): <p>An array of faces in the target image that did not match the source image face.</p>
    ///   - [`source_image_orientation_correction(Option<OrientationCorrection>)`](crate::output::CompareFacesOutput::source_image_orientation_correction): <p>The value of <code>SourceImageOrientationCorrection</code> is always null.</p>  <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.</p>  <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated. </p>
    ///   - [`target_image_orientation_correction(Option<OrientationCorrection>)`](crate::output::CompareFacesOutput::target_image_orientation_correction): <p>The value of <code>TargetImageOrientationCorrection</code> is always null.</p>  <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.</p>  <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated. </p>
    /// - On failure, responds with [`SdkError<CompareFacesError>`](crate::error::CompareFacesError)
    pub fn compare_faces(&self) -> fluent_builders::CompareFaces {
        fluent_builders::CompareFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCollection`](crate::client::fluent_builders::CreateCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::CreateCollection::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::CreateCollection::set_collection_id): <p>ID for the collection that you are creating.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateCollection::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateCollection::set_tags): <p> A set of tags (key-value pairs) that you want to attach to the collection. </p>
    /// - On success, responds with [`CreateCollectionOutput`](crate::output::CreateCollectionOutput) with field(s):
    ///   - [`status_code(Option<i32>)`](crate::output::CreateCollectionOutput::status_code): <p>HTTP status code indicating the result of the operation.</p>
    ///   - [`collection_arn(Option<String>)`](crate::output::CreateCollectionOutput::collection_arn): <p>Amazon Resource Name (ARN) of the collection. You can use this to manage permissions on your resources. </p>
    ///   - [`face_model_version(Option<String>)`](crate::output::CreateCollectionOutput::face_model_version): <p>Version number of the face detection model associated with the collection you are creating.</p>
    /// - On failure, responds with [`SdkError<CreateCollectionError>`](crate::error::CreateCollectionError)
    pub fn create_collection(&self) -> fluent_builders::CreateCollection {
        fluent_builders::CreateCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataset`](crate::client::fluent_builders::CreateDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_source(DatasetSource)`](crate::client::fluent_builders::CreateDataset::dataset_source) / [`set_dataset_source(Option<DatasetSource>)`](crate::client::fluent_builders::CreateDataset::set_dataset_source): <p> The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3 bucket location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>, an empty dataset is created. To add labeled images to the dataset, You can use the console or call <code>UpdateDatasetEntries</code>. </p>
    ///   - [`dataset_type(DatasetType)`](crate::client::fluent_builders::CreateDataset::dataset_type) / [`set_dataset_type(Option<DatasetType>)`](crate::client::fluent_builders::CreateDataset::set_dataset_type): <p> The type of the dataset. Specify <code>train</code> to create a training dataset. Specify <code>test</code> to create a test dataset. </p>
    ///   - [`project_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDataset::project_arn) / [`set_project_arn(Option<String>)`](crate::client::fluent_builders::CreateDataset::set_project_arn): <p> The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset. </p>
    /// - On success, responds with [`CreateDatasetOutput`](crate::output::CreateDatasetOutput) with field(s):
    ///   - [`dataset_arn(Option<String>)`](crate::output::CreateDatasetOutput::dataset_arn): <p> The ARN of the created Amazon Rekognition Custom Labels dataset. </p>
    /// - On failure, responds with [`SdkError<CreateDatasetError>`](crate::error::CreateDatasetError)
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProject`](crate::client::fluent_builders::CreateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_project_name): <p>The name of the project to create.</p>
    /// - On success, responds with [`CreateProjectOutput`](crate::output::CreateProjectOutput) with field(s):
    ///   - [`project_arn(Option<String>)`](crate::output::CreateProjectOutput::project_arn): <p>The Amazon Resource Name (ARN) of the new project. You can use the ARN to configure IAM access to the project. </p>
    /// - On failure, responds with [`SdkError<CreateProjectError>`](crate::error::CreateProjectError)
    pub fn create_project(&self) -> fluent_builders::CreateProject {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProjectVersion`](crate::client::fluent_builders::CreateProjectVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_arn(impl Into<String>)`](crate::client::fluent_builders::CreateProjectVersion::project_arn) / [`set_project_arn(Option<String>)`](crate::client::fluent_builders::CreateProjectVersion::set_project_arn): <p>The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.</p>
    ///   - [`version_name(impl Into<String>)`](crate::client::fluent_builders::CreateProjectVersion::version_name) / [`set_version_name(Option<String>)`](crate::client::fluent_builders::CreateProjectVersion::set_version_name): <p>A name for the version of the model. This value must be unique.</p>
    ///   - [`output_config(OutputConfig)`](crate::client::fluent_builders::CreateProjectVersion::output_config) / [`set_output_config(Option<OutputConfig>)`](crate::client::fluent_builders::CreateProjectVersion::set_output_config): <p>The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS account as long as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.</p>
    ///   - [`training_data(TrainingData)`](crate::client::fluent_builders::CreateProjectVersion::training_data) / [`set_training_data(Option<TrainingData>)`](crate::client::fluent_builders::CreateProjectVersion::set_training_data): <p>Specifies an external manifest that the services uses to train the model. If you specify <code>TrainingData</code> you must also specify <code>TestingData</code>. The project must not have any associated datasets. </p>
    ///   - [`testing_data(TestingData)`](crate::client::fluent_builders::CreateProjectVersion::testing_data) / [`set_testing_data(Option<TestingData>)`](crate::client::fluent_builders::CreateProjectVersion::set_testing_data): <p>Specifies an external manifest that the service uses to test the model. If you specify <code>TestingData</code> you must also specify <code>TrainingData</code>. The project must not have any associated datasets.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateProjectVersion::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProjectVersion::set_tags): <p> A set of tags (key-value pairs) that you want to attach to the model. </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateProjectVersion::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateProjectVersion::set_kms_key_id): <p>The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. The key is also used to encrypt training results and manifest files written to the output Amazon S3 bucket (<code>OutputConfig</code>).</p>  <p>If you choose to use your own KMS key, you need the following permissions on the KMS key.</p>  <ul>   <li> <p>kms:CreateGrant</p> </li>   <li> <p>kms:DescribeKey</p> </li>   <li> <p>kms:GenerateDataKey</p> </li>   <li> <p>kms:Decrypt</p> </li>  </ul>  <p>If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted using a key that AWS owns and manages.</p>
    /// - On success, responds with [`CreateProjectVersionOutput`](crate::output::CreateProjectVersionOutput) with field(s):
    ///   - [`project_version_arn(Option<String>)`](crate::output::CreateProjectVersionOutput::project_version_arn): <p>The ARN of the model version that was created. Use <code>DescribeProjectVersion</code> to get the current status of the training operation.</p>
    /// - On failure, responds with [`SdkError<CreateProjectVersionError>`](crate::error::CreateProjectVersionError)
    pub fn create_project_version(&self) -> fluent_builders::CreateProjectVersion {
        fluent_builders::CreateProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamProcessor`](crate::client::fluent_builders::CreateStreamProcessor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`input(StreamProcessorInput)`](crate::client::fluent_builders::CreateStreamProcessor::input) / [`set_input(Option<StreamProcessorInput>)`](crate::client::fluent_builders::CreateStreamProcessor::set_input): <p>Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is <code>StreamProcessorInput</code>. This is required for both face search and label detection stream processors.</p>
    ///   - [`output(StreamProcessorOutput)`](crate::client::fluent_builders::CreateStreamProcessor::output) / [`set_output(Option<StreamProcessorOutput>)`](crate::client::fluent_builders::CreateStreamProcessor::set_output): <p>Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>. This must be a <code>S3Destination</code> of an Amazon S3 bucket that you own for a label detection stream processor or a Kinesis data stream ARN for a face search stream processor.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateStreamProcessor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateStreamProcessor::set_name): <p>An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream processor. For example, you can get the current status of the stream processor by calling <code>DescribeStreamProcessor</code>. <code>Name</code> is idempotent. This is required for both face search and label detection stream processors. </p>
    ///   - [`settings(StreamProcessorSettings)`](crate::client::fluent_builders::CreateStreamProcessor::settings) / [`set_settings(Option<StreamProcessorSettings>)`](crate::client::fluent_builders::CreateStreamProcessor::set_settings): <p>Input parameters used in a streaming video analyzed by a stream processor. You can use <code>FaceSearch</code> to recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to detect labels.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateStreamProcessor::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateStreamProcessor::set_role_arn): <p>The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStreamProcessor::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStreamProcessor::set_tags): <p> A set of tags (key-value pairs) that you want to attach to the stream processor. </p>
    ///   - [`notification_channel(StreamProcessorNotificationChannel)`](crate::client::fluent_builders::CreateStreamProcessor::notification_channel) / [`set_notification_channel(Option<StreamProcessorNotificationChannel>)`](crate::client::fluent_builders::CreateStreamProcessor::set_notification_channel): <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.</p>  <p>Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a pet at second 4.</p>  <p>Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamProcessor::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateStreamProcessor::set_kms_key_id): <p> The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt results and data published to your Amazon S3 bucket, which includes image frames and hero images. Your source images are unaffected. </p>  <p> </p>
    ///   - [`regions_of_interest(Vec<RegionOfInterest>)`](crate::client::fluent_builders::CreateStreamProcessor::regions_of_interest) / [`set_regions_of_interest(Option<Vec<RegionOfInterest>>)`](crate::client::fluent_builders::CreateStreamProcessor::set_regions_of_interest): <p> Specifies locations in the frames where Amazon Rekognition checks for objects or people. You can specify up to 10 regions of interest. This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. </p>
    ///   - [`data_sharing_preference(StreamProcessorDataSharingPreference)`](crate::client::fluent_builders::CreateStreamProcessor::data_sharing_preference) / [`set_data_sharing_preference(Option<StreamProcessorDataSharingPreference>)`](crate::client::fluent_builders::CreateStreamProcessor::set_data_sharing_preference): <p> Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. </p>
    /// - On success, responds with [`CreateStreamProcessorOutput`](crate::output::CreateStreamProcessorOutput) with field(s):
    ///   - [`stream_processor_arn(Option<String>)`](crate::output::CreateStreamProcessorOutput::stream_processor_arn): <p>Amazon Resource Number for the newly created stream processor.</p>
    /// - On failure, responds with [`SdkError<CreateStreamProcessorError>`](crate::error::CreateStreamProcessorError)
    pub fn create_stream_processor(&self) -> fluent_builders::CreateStreamProcessor {
        fluent_builders::CreateStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCollection`](crate::client::fluent_builders::DeleteCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCollection::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::DeleteCollection::set_collection_id): <p>ID of the collection to delete.</p>
    /// - On success, responds with [`DeleteCollectionOutput`](crate::output::DeleteCollectionOutput) with field(s):
    ///   - [`status_code(Option<i32>)`](crate::output::DeleteCollectionOutput::status_code): <p>HTTP status code that indicates the result of the operation.</p>
    /// - On failure, responds with [`SdkError<DeleteCollectionError>`](crate::error::DeleteCollectionError)
    pub fn delete_collection(&self) -> fluent_builders::DeleteCollection {
        fluent_builders::DeleteCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::dataset_arn) / [`set_dataset_arn(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_dataset_arn): <p> The ARN of the Amazon Rekognition Custom Labels dataset that you want to delete. </p>
    /// - On success, responds with [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)

    /// - On failure, responds with [`SdkError<DeleteDatasetError>`](crate::error::DeleteDatasetError)
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFaces`](crate::client::fluent_builders::DeleteFaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFaces::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::DeleteFaces::set_collection_id): <p>Collection from which to remove the specific faces.</p>
    ///   - [`face_ids(Vec<String>)`](crate::client::fluent_builders::DeleteFaces::face_ids) / [`set_face_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteFaces::set_face_ids): <p>An array of face IDs to delete.</p>
    /// - On success, responds with [`DeleteFacesOutput`](crate::output::DeleteFacesOutput) with field(s):
    ///   - [`deleted_faces(Option<Vec<String>>)`](crate::output::DeleteFacesOutput::deleted_faces): <p>An array of strings (face IDs) of the faces that were deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteFacesError>`](crate::error::DeleteFacesError)
    pub fn delete_faces(&self) -> fluent_builders::DeleteFaces {
        fluent_builders::DeleteFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProject`](crate::client::fluent_builders::DeleteProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::project_arn) / [`set_project_arn(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_project_arn): <p>The Amazon Resource Name (ARN) of the project that you want to delete.</p>
    /// - On success, responds with [`DeleteProjectOutput`](crate::output::DeleteProjectOutput) with field(s):
    ///   - [`status(Option<ProjectStatus>)`](crate::output::DeleteProjectOutput::status): <p>The current status of the delete project operation.</p>
    /// - On failure, responds with [`SdkError<DeleteProjectError>`](crate::error::DeleteProjectError)
    pub fn delete_project(&self) -> fluent_builders::DeleteProject {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProjectVersion`](crate::client::fluent_builders::DeleteProjectVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_version_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteProjectVersion::project_version_arn) / [`set_project_version_arn(Option<String>)`](crate::client::fluent_builders::DeleteProjectVersion::set_project_version_arn): <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
    /// - On success, responds with [`DeleteProjectVersionOutput`](crate::output::DeleteProjectVersionOutput) with field(s):
    ///   - [`status(Option<ProjectVersionStatus>)`](crate::output::DeleteProjectVersionOutput::status): <p>The status of the deletion operation.</p>
    /// - On failure, responds with [`SdkError<DeleteProjectVersionError>`](crate::error::DeleteProjectVersionError)
    pub fn delete_project_version(&self) -> fluent_builders::DeleteProjectVersion {
        fluent_builders::DeleteProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStreamProcessor`](crate::client::fluent_builders::DeleteStreamProcessor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteStreamProcessor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteStreamProcessor::set_name): <p>The name of the stream processor you want to delete.</p>
    /// - On success, responds with [`DeleteStreamProcessorOutput`](crate::output::DeleteStreamProcessorOutput)

    /// - On failure, responds with [`SdkError<DeleteStreamProcessorError>`](crate::error::DeleteStreamProcessorError)
    pub fn delete_stream_processor(&self) -> fluent_builders::DeleteStreamProcessor {
        fluent_builders::DeleteStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCollection`](crate::client::fluent_builders::DescribeCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCollection::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::DescribeCollection::set_collection_id): <p>The ID of the collection to describe.</p>
    /// - On success, responds with [`DescribeCollectionOutput`](crate::output::DescribeCollectionOutput) with field(s):
    ///   - [`face_count(Option<i64>)`](crate::output::DescribeCollectionOutput::face_count): <p>The number of faces that are indexed into the collection. To index faces into a collection, use <code>IndexFaces</code>.</p>
    ///   - [`face_model_version(Option<String>)`](crate::output::DescribeCollectionOutput::face_model_version): <p>The version of the face model that's used by the collection for face detection.</p>  <p>For more information, see Model versioning in the Amazon Rekognition Developer Guide.</p>
    ///   - [`collection_arn(Option<String>)`](crate::output::DescribeCollectionOutput::collection_arn): <p>The Amazon Resource Name (ARN) of the collection.</p>
    ///   - [`creation_timestamp(Option<DateTime>)`](crate::output::DescribeCollectionOutput::creation_timestamp): <p>The number of milliseconds since the Unix epoch time until the creation of the collection. The Unix epoch time is 00:00:00 Coordinated Universal Time (UTC), Thursday, 1 January 1970.</p>
    /// - On failure, responds with [`SdkError<DescribeCollectionError>`](crate::error::DescribeCollectionError)
    pub fn describe_collection(&self) -> fluent_builders::DescribeCollection {
        fluent_builders::DescribeCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::dataset_arn) / [`set_dataset_arn(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_dataset_arn): <p> The Amazon Resource Name (ARN) of the dataset that you want to describe. </p>
    /// - On success, responds with [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput) with field(s):
    ///   - [`dataset_description(Option<DatasetDescription>)`](crate::output::DescribeDatasetOutput::dataset_description): <p> The description for the dataset. </p>
    /// - On failure, responds with [`SdkError<DescribeDatasetError>`](crate::error::DescribeDatasetError)
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProjects`](crate::client::fluent_builders::DescribeProjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeProjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeProjects::set_next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeProjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeProjects::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
    ///   - [`project_names(Vec<String>)`](crate::client::fluent_builders::DescribeProjects::project_names) / [`set_project_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeProjects::set_project_names): <p>A list of the projects that you want Amazon Rekognition Custom Labels to describe. If you don't specify a value, the response includes descriptions for all the projects in your AWS account.</p>
    /// - On success, responds with [`DescribeProjectsOutput`](crate::output::DescribeProjectsOutput) with field(s):
    ///   - [`project_descriptions(Option<Vec<ProjectDescription>>)`](crate::output::DescribeProjectsOutput::project_descriptions): <p>A list of project descriptions. The list is sorted by the date and time the projects are created.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeProjectsOutput::next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    /// - On failure, responds with [`SdkError<DescribeProjectsError>`](crate::error::DescribeProjectsError)
    pub fn describe_projects(&self) -> fluent_builders::DescribeProjects {
        fluent_builders::DescribeProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProjectVersions`](crate::client::fluent_builders::DescribeProjectVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeProjectVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeProjectVersions::project_arn) / [`set_project_arn(Option<String>)`](crate::client::fluent_builders::DescribeProjectVersions::set_project_arn): <p>The Amazon Resource Name (ARN) of the project that contains the models you want to describe.</p>
    ///   - [`version_names(Vec<String>)`](crate::client::fluent_builders::DescribeProjectVersions::version_names) / [`set_version_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeProjectVersions::set_version_names): <p>A list of model version names that you want to describe. You can add up to 10 model version names to the list. If you don't specify a value, all model descriptions are returned. A version name is part of a model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the following ARN. <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeProjectVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeProjectVersions::set_next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeProjectVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeProjectVersions::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
    /// - On success, responds with [`DescribeProjectVersionsOutput`](crate::output::DescribeProjectVersionsOutput) with field(s):
    ///   - [`project_version_descriptions(Option<Vec<ProjectVersionDescription>>)`](crate::output::DescribeProjectVersionsOutput::project_version_descriptions): <p>A list of model descriptions. The list is sorted by the creation date and time of the model versions, latest to earliest.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeProjectVersionsOutput::next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    /// - On failure, responds with [`SdkError<DescribeProjectVersionsError>`](crate::error::DescribeProjectVersionsError)
    pub fn describe_project_versions(&self) -> fluent_builders::DescribeProjectVersions {
        fluent_builders::DescribeProjectVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStreamProcessor`](crate::client::fluent_builders::DescribeStreamProcessor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeStreamProcessor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeStreamProcessor::set_name): <p>Name of the stream processor for which you want information.</p>
    /// - On success, responds with [`DescribeStreamProcessorOutput`](crate::output::DescribeStreamProcessorOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeStreamProcessorOutput::name): <p>Name of the stream processor. </p>
    ///   - [`stream_processor_arn(Option<String>)`](crate::output::DescribeStreamProcessorOutput::stream_processor_arn): <p>ARN of the stream processor.</p>
    ///   - [`status(Option<StreamProcessorStatus>)`](crate::output::DescribeStreamProcessorOutput::status): <p>Current status of the stream processor.</p>
    ///   - [`status_message(Option<String>)`](crate::output::DescribeStreamProcessorOutput::status_message): <p>Detailed status message about the stream processor.</p>
    ///   - [`creation_timestamp(Option<DateTime>)`](crate::output::DescribeStreamProcessorOutput::creation_timestamp): <p>Date and time the stream processor was created</p>
    ///   - [`last_update_timestamp(Option<DateTime>)`](crate::output::DescribeStreamProcessorOutput::last_update_timestamp): <p>The time, in Unix format, the stream processor was last updated. For example, when the stream processor moves from a running state to a failed state, or when the user starts or stops the stream processor.</p>
    ///   - [`input(Option<StreamProcessorInput>)`](crate::output::DescribeStreamProcessorOutput::input): <p>Kinesis video stream that provides the source streaming video.</p>
    ///   - [`output(Option<StreamProcessorOutput>)`](crate::output::DescribeStreamProcessorOutput::output): <p>Kinesis data stream to which Amazon Rekognition Video puts the analysis results.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeStreamProcessorOutput::role_arn): <p>ARN of the IAM role that allows access to the stream processor.</p>
    ///   - [`settings(Option<StreamProcessorSettings>)`](crate::output::DescribeStreamProcessorOutput::settings): <p>Input parameters used in a streaming video analyzed by a stream processor. You can use <code>FaceSearch</code> to recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to detect labels.</p>
    ///   - [`notification_channel(Option<StreamProcessorNotificationChannel>)`](crate::output::DescribeStreamProcessorOutput::notification_channel): <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.</p>  <p>Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a pet at second 4.</p>  <p>Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::DescribeStreamProcessorOutput::kms_key_id): <p> The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label detection stream processors. </p>
    ///   - [`regions_of_interest(Option<Vec<RegionOfInterest>>)`](crate::output::DescribeStreamProcessorOutput::regions_of_interest): <p> Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional parameter for label detection stream processors. </p>
    ///   - [`data_sharing_preference(Option<StreamProcessorDataSharingPreference>)`](crate::output::DescribeStreamProcessorOutput::data_sharing_preference): <p> Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. </p>
    /// - On failure, responds with [`SdkError<DescribeStreamProcessorError>`](crate::error::DescribeStreamProcessorError)
    pub fn describe_stream_processor(&self) -> fluent_builders::DescribeStreamProcessor {
        fluent_builders::DescribeStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectCustomLabels`](crate::client::fluent_builders::DetectCustomLabels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_version_arn(impl Into<String>)`](crate::client::fluent_builders::DetectCustomLabels::project_version_arn) / [`set_project_version_arn(Option<String>)`](crate::client::fluent_builders::DetectCustomLabels::set_project_version_arn): <p>The ARN of the model version that you want to use.</p>
    ///   - [`image(Image)`](crate::client::fluent_builders::DetectCustomLabels::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::DetectCustomLabels::set_image): <p>Provides the input image either as bytes or an S3 object.</p>  <p>You pass image bytes to an Amazon Rekognition API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass an image loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations. </p>  <p>For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.</p>  <p> You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the <code>S3Object</code> property. Images stored in an S3 bucket do not need to be base64-encoded.</p>  <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>  <p>If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.</p>  <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DetectCustomLabels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DetectCustomLabels::set_max_results): <p>Maximum number of results you want the service to return in the response. The service returns the specified number of highest confidence labels ranked from highest confidence to lowest.</p>
    ///   - [`min_confidence(f32)`](crate::client::fluent_builders::DetectCustomLabels::min_confidence) / [`set_min_confidence(Option<f32>)`](crate::client::fluent_builders::DetectCustomLabels::set_min_confidence): <p>Specifies the minimum confidence level for the labels to return. <code>DetectCustomLabels</code> doesn't return any labels with a confidence value that's lower than this specified value. If you specify a value of 0, <code>DetectCustomLabels</code> returns all labels, regardless of the assumed threshold applied to each label. If you don't specify a value for <code>MinConfidence</code>, <code>DetectCustomLabels</code> returns labels based on the assumed threshold of each label.</p>
    /// - On success, responds with [`DetectCustomLabelsOutput`](crate::output::DetectCustomLabelsOutput) with field(s):
    ///   - [`custom_labels(Option<Vec<CustomLabel>>)`](crate::output::DetectCustomLabelsOutput::custom_labels): <p>An array of custom labels detected in the input image.</p>
    /// - On failure, responds with [`SdkError<DetectCustomLabelsError>`](crate::error::DetectCustomLabelsError)
    pub fn detect_custom_labels(&self) -> fluent_builders::DetectCustomLabels {
        fluent_builders::DetectCustomLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectFaces`](crate::client::fluent_builders::DetectFaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image(Image)`](crate::client::fluent_builders::DetectFaces::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::DetectFaces::set_image): <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`attributes(Vec<Attribute>)`](crate::client::fluent_builders::DetectFaces::attributes) / [`set_attributes(Option<Vec<Attribute>>)`](crate::client::fluent_builders::DetectFaces::set_attributes): <p>An array of facial attributes you want to be returned. This can be the default list of attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p>  <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>
    /// - On success, responds with [`DetectFacesOutput`](crate::output::DetectFacesOutput) with field(s):
    ///   - [`face_details(Option<Vec<FaceDetail>>)`](crate::output::DetectFacesOutput::face_details): <p>Details of each face found in the image. </p>
    ///   - [`orientation_correction(Option<OrientationCorrection>)`](crate::output::DetectFacesOutput::orientation_correction): <p>The value of <code>OrientationCorrection</code> is always null.</p>  <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.</p>  <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated. </p>
    /// - On failure, responds with [`SdkError<DetectFacesError>`](crate::error::DetectFacesError)
    pub fn detect_faces(&self) -> fluent_builders::DetectFaces {
        fluent_builders::DetectFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectLabels`](crate::client::fluent_builders::DetectLabels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image(Image)`](crate::client::fluent_builders::DetectLabels::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::DetectLabels::set_image): <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be base64-encoded.</p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`max_labels(i32)`](crate::client::fluent_builders::DetectLabels::max_labels) / [`set_max_labels(Option<i32>)`](crate::client::fluent_builders::DetectLabels::set_max_labels): <p>Maximum number of labels you want the service to return in the response. The service returns the specified number of highest confidence labels. </p>
    ///   - [`min_confidence(f32)`](crate::client::fluent_builders::DetectLabels::min_confidence) / [`set_min_confidence(Option<f32>)`](crate::client::fluent_builders::DetectLabels::set_min_confidence): <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with confidence lower than this specified value.</p>  <p>If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values greater than or equal to 55 percent.</p>
    /// - On success, responds with [`DetectLabelsOutput`](crate::output::DetectLabelsOutput) with field(s):
    ///   - [`labels(Option<Vec<Label>>)`](crate::output::DetectLabelsOutput::labels): <p>An array of labels for the real-world objects detected. </p>
    ///   - [`orientation_correction(Option<OrientationCorrection>)`](crate::output::DetectLabelsOutput::orientation_correction): <p>The value of <code>OrientationCorrection</code> is always null.</p>  <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction. The bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.</p>  <p>Amazon Rekognition doesn’t perform image correction for images in .png format and .jpeg images without orientation information in the image Exif metadata. The bounding box coordinates aren't translated and represent the object locations before the image is rotated. </p>
    ///   - [`label_model_version(Option<String>)`](crate::output::DetectLabelsOutput::label_model_version): <p>Version number of the label detection model that was used to detect labels.</p>
    /// - On failure, responds with [`SdkError<DetectLabelsError>`](crate::error::DetectLabelsError)
    pub fn detect_labels(&self) -> fluent_builders::DetectLabels {
        fluent_builders::DetectLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectModerationLabels`](crate::client::fluent_builders::DetectModerationLabels) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image(Image)`](crate::client::fluent_builders::DetectModerationLabels::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::DetectModerationLabels::set_image): <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`min_confidence(f32)`](crate::client::fluent_builders::DetectModerationLabels::min_confidence) / [`set_min_confidence(Option<f32>)`](crate::client::fluent_builders::DetectModerationLabels::set_min_confidence): <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with a confidence level lower than this specified value.</p>  <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>
    ///   - [`human_loop_config(HumanLoopConfig)`](crate::client::fluent_builders::DetectModerationLabels::human_loop_config) / [`set_human_loop_config(Option<HumanLoopConfig>)`](crate::client::fluent_builders::DetectModerationLabels::set_human_loop_config): <p>Sets up the configuration for human evaluation, including the FlowDefinition the image will be sent to.</p>
    /// - On success, responds with [`DetectModerationLabelsOutput`](crate::output::DetectModerationLabelsOutput) with field(s):
    ///   - [`moderation_labels(Option<Vec<ModerationLabel>>)`](crate::output::DetectModerationLabelsOutput::moderation_labels): <p>Array of detected Moderation labels and the time, in milliseconds from the start of the video, they were detected.</p>
    ///   - [`moderation_model_version(Option<String>)`](crate::output::DetectModerationLabelsOutput::moderation_model_version): <p>Version number of the moderation detection model that was used to detect unsafe content.</p>
    ///   - [`human_loop_activation_output(Option<HumanLoopActivationOutput>)`](crate::output::DetectModerationLabelsOutput::human_loop_activation_output): <p>Shows the results of the human in the loop evaluation.</p>
    /// - On failure, responds with [`SdkError<DetectModerationLabelsError>`](crate::error::DetectModerationLabelsError)
    pub fn detect_moderation_labels(&self) -> fluent_builders::DetectModerationLabels {
        fluent_builders::DetectModerationLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectProtectiveEquipment`](crate::client::fluent_builders::DetectProtectiveEquipment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image(Image)`](crate::client::fluent_builders::DetectProtectiveEquipment::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::DetectProtectiveEquipment::set_image): <p>The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you can reference an image stored in an Amazon S3 bucket. </p>
    ///   - [`summarization_attributes(ProtectiveEquipmentSummarizationAttributes)`](crate::client::fluent_builders::DetectProtectiveEquipment::summarization_attributes) / [`set_summarization_attributes(Option<ProtectiveEquipmentSummarizationAttributes>)`](crate::client::fluent_builders::DetectProtectiveEquipment::set_summarization_attributes): <p>An array of PPE types that you want to summarize.</p>
    /// - On success, responds with [`DetectProtectiveEquipmentOutput`](crate::output::DetectProtectiveEquipmentOutput) with field(s):
    ///   - [`protective_equipment_model_version(Option<String>)`](crate::output::DetectProtectiveEquipmentOutput::protective_equipment_model_version): <p>The version number of the PPE detection model used to detect PPE in the image.</p>
    ///   - [`persons(Option<Vec<ProtectiveEquipmentPerson>>)`](crate::output::DetectProtectiveEquipmentOutput::persons): <p>An array of persons detected in the image (including persons not wearing PPE).</p>
    ///   - [`summary(Option<ProtectiveEquipmentSummary>)`](crate::output::DetectProtectiveEquipmentOutput::summary): <p>Summary information for the types of PPE specified in the <code>SummarizationAttributes</code> input parameter.</p>
    /// - On failure, responds with [`SdkError<DetectProtectiveEquipmentError>`](crate::error::DetectProtectiveEquipmentError)
    pub fn detect_protective_equipment(&self) -> fluent_builders::DetectProtectiveEquipment {
        fluent_builders::DetectProtectiveEquipment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectText`](crate::client::fluent_builders::DetectText) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image(Image)`](crate::client::fluent_builders::DetectText::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::DetectText::set_image): <p>The input image as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Rekognition operations, you can't pass image bytes. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`filters(DetectTextFilters)`](crate::client::fluent_builders::DetectText::filters) / [`set_filters(Option<DetectTextFilters>)`](crate::client::fluent_builders::DetectText::set_filters): <p>Optional parameters that let you set the criteria that the text must meet to be included in your response.</p>
    /// - On success, responds with [`DetectTextOutput`](crate::output::DetectTextOutput) with field(s):
    ///   - [`text_detections(Option<Vec<TextDetection>>)`](crate::output::DetectTextOutput::text_detections): <p>An array of text that was detected in the input image.</p>
    ///   - [`text_model_version(Option<String>)`](crate::output::DetectTextOutput::text_model_version): <p>The model version used to detect text.</p>
    /// - On failure, responds with [`SdkError<DetectTextError>`](crate::error::DetectTextError)
    pub fn detect_text(&self) -> fluent_builders::DetectText {
        fluent_builders::DetectText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DistributeDatasetEntries`](crate::client::fluent_builders::DistributeDatasetEntries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datasets(Vec<DistributeDataset>)`](crate::client::fluent_builders::DistributeDatasetEntries::datasets) / [`set_datasets(Option<Vec<DistributeDataset>>)`](crate::client::fluent_builders::DistributeDatasetEntries::set_datasets): <p>The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the same project. The test dataset must be empty. </p>
    /// - On success, responds with [`DistributeDatasetEntriesOutput`](crate::output::DistributeDatasetEntriesOutput)

    /// - On failure, responds with [`SdkError<DistributeDatasetEntriesError>`](crate::error::DistributeDatasetEntriesError)
    pub fn distribute_dataset_entries(&self) -> fluent_builders::DistributeDatasetEntries {
        fluent_builders::DistributeDatasetEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCelebrityInfo`](crate::client::fluent_builders::GetCelebrityInfo) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetCelebrityInfo::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetCelebrityInfo::set_id): <p>The ID for the celebrity. You get the celebrity ID from a call to the <code>RecognizeCelebrities</code> operation, which recognizes celebrities in an image. </p>
    /// - On success, responds with [`GetCelebrityInfoOutput`](crate::output::GetCelebrityInfoOutput) with field(s):
    ///   - [`urls(Option<Vec<String>>)`](crate::output::GetCelebrityInfoOutput::urls): <p>An array of URLs pointing to additional celebrity information. </p>
    ///   - [`name(Option<String>)`](crate::output::GetCelebrityInfoOutput::name): <p>The name of the celebrity.</p>
    ///   - [`known_gender(Option<KnownGender>)`](crate::output::GetCelebrityInfoOutput::known_gender): <p>Retrieves the known gender for the celebrity.</p>
    /// - On failure, responds with [`SdkError<GetCelebrityInfoError>`](crate::error::GetCelebrityInfoError)
    pub fn get_celebrity_info(&self) -> fluent_builders::GetCelebrityInfo {
        fluent_builders::GetCelebrityInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCelebrityRecognition`](crate::client::fluent_builders::GetCelebrityRecognition) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCelebrityRecognition::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetCelebrityRecognition::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetCelebrityRecognition::set_job_id): <p>Job identifier for the required celebrity recognition analysis. You can get the job identifer from a call to <code>StartCelebrityRecognition</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCelebrityRecognition::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetCelebrityRecognition::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCelebrityRecognition::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCelebrityRecognition::set_next_token): <p>If the previous response was incomplete (because there is more recognized celebrities to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of celebrities. </p>
    ///   - [`sort_by(CelebrityRecognitionSortBy)`](crate::client::fluent_builders::GetCelebrityRecognition::sort_by) / [`set_sort_by(Option<CelebrityRecognitionSortBy>)`](crate::client::fluent_builders::GetCelebrityRecognition::set_sort_by): <p>Sort to use for celebrities returned in <code>Celebrities</code> field. Specify <code>ID</code> to sort by the celebrity identifier, specify <code>TIMESTAMP</code> to sort by the time the celebrity was recognized.</p>
    /// - On success, responds with [`GetCelebrityRecognitionOutput`](crate::output::GetCelebrityRecognitionOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetCelebrityRecognitionOutput::job_status): <p>The current status of the celebrity recognition job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetCelebrityRecognitionOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`video_metadata(Option<VideoMetadata>)`](crate::output::GetCelebrityRecognitionOutput::video_metadata): <p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition Video operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetCelebrityRecognitionOutput::next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of celebrities.</p>
    ///   - [`celebrities(Option<Vec<CelebrityRecognition>>)`](crate::output::GetCelebrityRecognitionOutput::celebrities): <p>Array of celebrities recognized in the video.</p>
    /// - On failure, responds with [`SdkError<GetCelebrityRecognitionError>`](crate::error::GetCelebrityRecognitionError)
    pub fn get_celebrity_recognition(&self) -> fluent_builders::GetCelebrityRecognition {
        fluent_builders::GetCelebrityRecognition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContentModeration`](crate::client::fluent_builders::GetContentModeration) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetContentModeration::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetContentModeration::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetContentModeration::set_job_id): <p>The identifier for the inappropriate, unwanted, or offensive content moderation job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetContentModeration</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetContentModeration::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetContentModeration::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetContentModeration::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetContentModeration::set_next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of content moderation labels.</p>
    ///   - [`sort_by(ContentModerationSortBy)`](crate::client::fluent_builders::GetContentModeration::sort_by) / [`set_sort_by(Option<ContentModerationSortBy>)`](crate::client::fluent_builders::GetContentModeration::set_sort_by): <p>Sort to use for elements in the <code>ModerationLabelDetections</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
    /// - On success, responds with [`GetContentModerationOutput`](crate::output::GetContentModerationOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetContentModerationOutput::job_status): <p>The current status of the content moderation analysis job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetContentModerationOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`video_metadata(Option<VideoMetadata>)`](crate::output::GetContentModerationOutput::video_metadata): <p>Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of paginated responses from <code>GetContentModeration</code>. </p>
    ///   - [`moderation_labels(Option<Vec<ContentModerationDetection>>)`](crate::output::GetContentModerationOutput::moderation_labels): <p>The detected inappropriate, unwanted, or offensive content moderation labels and the time(s) they were detected.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetContentModerationOutput::next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of content moderation labels. </p>
    ///   - [`moderation_model_version(Option<String>)`](crate::output::GetContentModerationOutput::moderation_model_version): <p>Version number of the moderation detection model that was used to detect inappropriate, unwanted, or offensive content.</p>
    /// - On failure, responds with [`SdkError<GetContentModerationError>`](crate::error::GetContentModerationError)
    pub fn get_content_moderation(&self) -> fluent_builders::GetContentModeration {
        fluent_builders::GetContentModeration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFaceDetection`](crate::client::fluent_builders::GetFaceDetection) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetFaceDetection::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetFaceDetection::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetFaceDetection::set_job_id): <p>Unique identifier for the face detection job. The <code>JobId</code> is returned from <code>StartFaceDetection</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetFaceDetection::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetFaceDetection::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetFaceDetection::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetFaceDetection::set_next_token): <p>If the previous response was incomplete (because there are more faces to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>
    /// - On success, responds with [`GetFaceDetectionOutput`](crate::output::GetFaceDetectionOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetFaceDetectionOutput::job_status): <p>The current status of the face detection job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetFaceDetectionOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`video_metadata(Option<VideoMetadata>)`](crate::output::GetFaceDetectionOutput::video_metadata): <p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition video operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetFaceDetectionOutput::next_token): <p>If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to retrieve the next set of faces. </p>
    ///   - [`faces(Option<Vec<FaceDetection>>)`](crate::output::GetFaceDetectionOutput::faces): <p>An array of faces detected in the video. Each element contains a detected face's details and the time, in milliseconds from the start of the video, the face was detected. </p>
    /// - On failure, responds with [`SdkError<GetFaceDetectionError>`](crate::error::GetFaceDetectionError)
    pub fn get_face_detection(&self) -> fluent_builders::GetFaceDetection {
        fluent_builders::GetFaceDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFaceSearch`](crate::client::fluent_builders::GetFaceSearch) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetFaceSearch::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetFaceSearch::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetFaceSearch::set_job_id): <p>The job identifer for the search request. You get the job identifier from an initial call to <code>StartFaceSearch</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetFaceSearch::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetFaceSearch::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetFaceSearch::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetFaceSearch::set_next_token): <p>If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of search results. </p>
    ///   - [`sort_by(FaceSearchSortBy)`](crate::client::fluent_builders::GetFaceSearch::sort_by) / [`set_sort_by(Option<FaceSearchSortBy>)`](crate::client::fluent_builders::GetFaceSearch::set_sort_by): <p>Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that they are recognized. Use <code>INDEX</code> to sort by recognized faces. </p>
    /// - On success, responds with [`GetFaceSearchOutput`](crate::output::GetFaceSearchOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetFaceSearchOutput::job_status): <p>The current status of the face search job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetFaceSearchOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetFaceSearchOutput::next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of search results. </p>
    ///   - [`video_metadata(Option<VideoMetadata>)`](crate::output::GetFaceSearchOutput::video_metadata): <p>Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition Video operation. </p>
    ///   - [`persons(Option<Vec<PersonMatch>>)`](crate::output::GetFaceSearchOutput::persons): <p>An array of persons, <code>PersonMatch</code>, in the video whose face(s) match the face(s) in an Amazon Rekognition collection. It also includes time information for when persons are matched in the video. You specify the input collection in an initial call to <code>StartFaceSearch</code>. Each <code>Persons</code> element includes a time the person was matched, face match details (<code>FaceMatches</code>) for matching faces in the collection, and person information (<code>Person</code>) for the matched person. </p>
    /// - On failure, responds with [`SdkError<GetFaceSearchError>`](crate::error::GetFaceSearchError)
    pub fn get_face_search(&self) -> fluent_builders::GetFaceSearch {
        fluent_builders::GetFaceSearch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLabelDetection`](crate::client::fluent_builders::GetLabelDetection) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetLabelDetection::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetLabelDetection::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetLabelDetection::set_job_id): <p>Job identifier for the label detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartlabelDetection</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetLabelDetection::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetLabelDetection::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetLabelDetection::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetLabelDetection::set_next_token): <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of labels. </p>
    ///   - [`sort_by(LabelDetectionSortBy)`](crate::client::fluent_builders::GetLabelDetection::sort_by) / [`set_sort_by(Option<LabelDetectionSortBy>)`](crate::client::fluent_builders::GetLabelDetection::set_sort_by): <p>Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
    /// - On success, responds with [`GetLabelDetectionOutput`](crate::output::GetLabelDetectionOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetLabelDetectionOutput::job_status): <p>The current status of the label detection job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetLabelDetectionOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`video_metadata(Option<VideoMetadata>)`](crate::output::GetLabelDetectionOutput::video_metadata): <p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition video operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetLabelDetectionOutput::next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of labels.</p>
    ///   - [`labels(Option<Vec<LabelDetection>>)`](crate::output::GetLabelDetectionOutput::labels): <p>An array of labels detected in the video. Each element contains the detected label and the time, in milliseconds from the start of the video, that the label was detected. </p>
    ///   - [`label_model_version(Option<String>)`](crate::output::GetLabelDetectionOutput::label_model_version): <p>Version number of the label detection model that was used to detect labels.</p>
    /// - On failure, responds with [`SdkError<GetLabelDetectionError>`](crate::error::GetLabelDetectionError)
    pub fn get_label_detection(&self) -> fluent_builders::GetLabelDetection {
        fluent_builders::GetLabelDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPersonTracking`](crate::client::fluent_builders::GetPersonTracking) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetPersonTracking::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetPersonTracking::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetPersonTracking::set_job_id): <p>The identifier for a job that tracks persons in a video. You get the <code>JobId</code> from a call to <code>StartPersonTracking</code>. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetPersonTracking::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetPersonTracking::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetPersonTracking::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetPersonTracking::set_next_token): <p>If the previous response was incomplete (because there are more persons to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of persons. </p>
    ///   - [`sort_by(PersonTrackingSortBy)`](crate::client::fluent_builders::GetPersonTracking::sort_by) / [`set_sort_by(Option<PersonTrackingSortBy>)`](crate::client::fluent_builders::GetPersonTracking::set_sort_by): <p>Sort to use for elements in the <code>Persons</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time persons are detected. Use <code>INDEX</code> to sort by the tracked persons. If you sort by <code>INDEX</code>, the array elements for each person are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
    /// - On success, responds with [`GetPersonTrackingOutput`](crate::output::GetPersonTrackingOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetPersonTrackingOutput::job_status): <p>The current status of the person tracking job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetPersonTrackingOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`video_metadata(Option<VideoMetadata>)`](crate::output::GetPersonTrackingOutput::video_metadata): <p>Information about a video that Amazon Rekognition Video analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition Video operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetPersonTrackingOutput::next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of persons. </p>
    ///   - [`persons(Option<Vec<PersonDetection>>)`](crate::output::GetPersonTrackingOutput::persons): <p>An array of the persons detected in the video and the time(s) their path was tracked throughout the video. An array element will exist for each time a person's path is tracked. </p>
    /// - On failure, responds with [`SdkError<GetPersonTrackingError>`](crate::error::GetPersonTrackingError)
    pub fn get_person_tracking(&self) -> fluent_builders::GetPersonTracking {
        fluent_builders::GetPersonTracking::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSegmentDetection`](crate::client::fluent_builders::GetSegmentDetection) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSegmentDetection::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetSegmentDetection::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetSegmentDetection::set_job_id): <p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartSegmentDetection</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetSegmentDetection::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetSegmentDetection::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSegmentDetection::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSegmentDetection::set_next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of text.</p>
    /// - On success, responds with [`GetSegmentDetectionOutput`](crate::output::GetSegmentDetectionOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetSegmentDetectionOutput::job_status): <p>Current status of the segment detection job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetSegmentDetectionOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`video_metadata(Option<Vec<VideoMetadata>>)`](crate::output::GetSegmentDetectionOutput::video_metadata): <p>Currently, Amazon Rekognition Video returns a single object in the <code>VideoMetadata</code> array. The object contains information about the video stream in the input file that Amazon Rekognition Video chose to analyze. The <code>VideoMetadata</code> object includes the video codec, video format and other information. Video metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.</p>
    ///   - [`audio_metadata(Option<Vec<AudioMetadata>>)`](crate::output::GetSegmentDetectionOutput::audio_metadata): <p>An array of objects. There can be multiple audio streams. Each <code>AudioMetadata</code> object contains metadata for a single audio stream. Audio information in an <code>AudioMetadata</code> objects includes the audio codec, the number of audio channels, the duration of the audio stream, and the sample rate. Audio metadata is returned in each page of information returned by <code>GetSegmentDetection</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSegmentDetectionOutput::next_token): <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>
    ///   - [`segments(Option<Vec<SegmentDetection>>)`](crate::output::GetSegmentDetectionOutput::segments): <p>An array of segments detected in a video. The array is sorted by the segment types (TECHNICAL_CUE or SHOT) specified in the <code>SegmentTypes</code> input parameter of <code>StartSegmentDetection</code>. Within each segment type the array is sorted by timestamp values.</p>
    ///   - [`selected_segment_types(Option<Vec<SegmentTypeInfo>>)`](crate::output::GetSegmentDetectionOutput::selected_segment_types): <p>An array containing the segment types requested in the call to <code>StartSegmentDetection</code>. </p>
    /// - On failure, responds with [`SdkError<GetSegmentDetectionError>`](crate::error::GetSegmentDetectionError)
    pub fn get_segment_detection(&self) -> fluent_builders::GetSegmentDetection {
        fluent_builders::GetSegmentDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTextDetection`](crate::client::fluent_builders::GetTextDetection) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetTextDetection::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetTextDetection::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetTextDetection::set_job_id): <p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartTextDetection</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetTextDetection::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetTextDetection::set_max_results): <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetTextDetection::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetTextDetection::set_next_token): <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>
    /// - On success, responds with [`GetTextDetectionOutput`](crate::output::GetTextDetectionOutput) with field(s):
    ///   - [`job_status(Option<VideoJobStatus>)`](crate::output::GetTextDetectionOutput::job_status): <p>Current status of the text detection job.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetTextDetectionOutput::status_message): <p>If the job fails, <code>StatusMessage</code> provides a descriptive error message.</p>
    ///   - [`video_metadata(Option<VideoMetadata>)`](crate::output::GetTextDetectionOutput::video_metadata): <p>Information about a video that Amazon Rekognition analyzed. <code>Videometadata</code> is returned in every page of paginated responses from a Amazon Rekognition video operation.</p>
    ///   - [`text_detections(Option<Vec<TextDetectionResult>>)`](crate::output::GetTextDetectionOutput::text_detections): <p>An array of text detected in the video. Each element contains the detected text, the time in milliseconds from the start of the video that the text was detected, and where it was detected on the screen.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetTextDetectionOutput::next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of text.</p>
    ///   - [`text_model_version(Option<String>)`](crate::output::GetTextDetectionOutput::text_model_version): <p>Version number of the text detection model that was used to detect text.</p>
    /// - On failure, responds with [`SdkError<GetTextDetectionError>`](crate::error::GetTextDetectionError)
    pub fn get_text_detection(&self) -> fluent_builders::GetTextDetection {
        fluent_builders::GetTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`IndexFaces`](crate::client::fluent_builders::IndexFaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::IndexFaces::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::IndexFaces::set_collection_id): <p>The ID of an existing collection to which you want to add the faces that are detected in the input images.</p>
    ///   - [`image(Image)`](crate::client::fluent_builders::IndexFaces::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::IndexFaces::set_image): <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes isn't supported. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`external_image_id(impl Into<String>)`](crate::client::fluent_builders::IndexFaces::external_image_id) / [`set_external_image_id(Option<String>)`](crate::client::fluent_builders::IndexFaces::set_external_image_id): <p>The ID you want to assign to all the faces detected in the image.</p>
    ///   - [`detection_attributes(Vec<Attribute>)`](crate::client::fluent_builders::IndexFaces::detection_attributes) / [`set_detection_attributes(Option<Vec<Attribute>>)`](crate::client::fluent_builders::IndexFaces::set_detection_attributes): <p>An array of facial attributes that you want to be returned. This can be the default list of attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p>  <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>
    ///   - [`max_faces(i32)`](crate::client::fluent_builders::IndexFaces::max_faces) / [`set_max_faces(Option<i32>)`](crate::client::fluent_builders::IndexFaces::set_max_faces): <p>The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal to 1. <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify a larger value for <code>MaxFaces</code>.</p>  <p>If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with the lowest quality are filtered out first. If there are still more faces than the value of <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out (up to the number that's needed to satisfy the value of <code>MaxFaces</code>). Information about the unindexed faces is available in the <code>UnindexedFaces</code> array. </p>  <p>The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box size to the smallest size, in descending order.</p>  <p> <code>MaxFaces</code> can be used with a collection associated with any version of the face model.</p>
    ///   - [`quality_filter(QualityFilter)`](crate::client::fluent_builders::IndexFaces::quality_filter) / [`set_quality_filter(Option<QualityFilter>)`](crate::client::fluent_builders::IndexFaces::set_quality_filter): <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p>  <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
    /// - On success, responds with [`IndexFacesOutput`](crate::output::IndexFacesOutput) with field(s):
    ///   - [`face_records(Option<Vec<FaceRecord>>)`](crate::output::IndexFacesOutput::face_records): <p>An array of faces detected and added to the collection. For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide. </p>
    ///   - [`orientation_correction(Option<OrientationCorrection>)`](crate::output::IndexFacesOutput::orientation_correction): <p>If your collection is associated with a face detection model that's later than version 3.0, the value of <code>OrientationCorrection</code> is always null and no orientation information is returned.</p>  <p>If your collection is associated with a face detection model that's version 3.0 or earlier, the following applies:</p>  <ul>   <li> <p>If the input image is in .jpeg format, it might contain exchangeable image file format (Exif) metadata that includes the image's orientation. Amazon Rekognition uses this orientation information to perform image correction - the bounding box coordinates are translated to represent object locations after the orientation information in the Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata. The value of <code>OrientationCorrection</code> is null.</p> </li>   <li> <p>If the image doesn't contain orientation information in its Exif metadata, Amazon Rekognition returns an estimated orientation (ROTATE_0, ROTATE_90, ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image correction for images. The bounding box coordinates aren't translated and represent the object locations before the image is rotated.</p> </li>  </ul>  <p>Bounding box information is returned in the <code>FaceRecords</code> array. You can get the version of the face detection model by calling <code>DescribeCollection</code>. </p>
    ///   - [`face_model_version(Option<String>)`](crate::output::IndexFacesOutput::face_model_version): <p>The version number of the face detection model that's associated with the input collection (<code>CollectionId</code>).</p>
    ///   - [`unindexed_faces(Option<Vec<UnindexedFace>>)`](crate::output::IndexFacesOutput::unindexed_faces): <p>An array of faces that were detected in the image but weren't indexed. They weren't indexed because the quality filter identified them as low quality, or the <code>MaxFaces</code> request parameter filtered them out. To use the quality filter, you specify the <code>QualityFilter</code> request parameter.</p>
    /// - On failure, responds with [`SdkError<IndexFacesError>`](crate::error::IndexFacesError)
    pub fn index_faces(&self) -> fluent_builders::IndexFaces {
        fluent_builders::IndexFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCollections`](crate::client::fluent_builders::ListCollections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCollections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCollections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCollections::set_next_token): <p>Pagination token from the previous response.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCollections::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCollections::set_max_results): <p>Maximum number of collection IDs to return. </p>
    /// - On success, responds with [`ListCollectionsOutput`](crate::output::ListCollectionsOutput) with field(s):
    ///   - [`collection_ids(Option<Vec<String>>)`](crate::output::ListCollectionsOutput::collection_ids): <p>An array of collection IDs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCollectionsOutput::next_token): <p>If the result is truncated, the response provides a <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.</p>
    ///   - [`face_model_versions(Option<Vec<String>>)`](crate::output::ListCollectionsOutput::face_model_versions): <p>Version numbers of the face detection models associated with the collections in the array <code>CollectionIds</code>. For example, the value of <code>FaceModelVersions[2]</code> is the version number for the face detection model used by the collection in <code>CollectionId[2]</code>.</p>
    /// - On failure, responds with [`SdkError<ListCollectionsError>`](crate::error::ListCollectionsError)
    pub fn list_collections(&self) -> fluent_builders::ListCollections {
        fluent_builders::ListCollections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatasetEntries`](crate::client::fluent_builders::ListDatasetEntries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatasetEntries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_arn(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::dataset_arn) / [`set_dataset_arn(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_dataset_arn): <p> The Amazon Resource Name (ARN) for the dataset that you want to use. </p>
    ///   - [`contains_labels(Vec<String>)`](crate::client::fluent_builders::ListDatasetEntries::contains_labels) / [`set_contains_labels(Option<Vec<String>>)`](crate::client::fluent_builders::ListDatasetEntries::set_contains_labels): <p>Specifies a label filter for the response. The response includes an entry only if one or more of the labels in <code>ContainsLabels</code> exist in the entry. </p>
    ///   - [`labeled(bool)`](crate::client::fluent_builders::ListDatasetEntries::labeled) / [`set_labeled(Option<bool>)`](crate::client::fluent_builders::ListDatasetEntries::set_labeled): <p> Specify <code>true</code> to get only the JSON Lines where the image is labeled. Specify <code>false</code> to get only the JSON Lines where the image isn't labeled. If you don't specify <code>Labeled</code>, <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled images. </p>
    ///   - [`source_ref_contains(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::source_ref_contains) / [`set_source_ref_contains(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_source_ref_contains): <p>If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of <code>SourceRefContains</code> is part of the <code>source-ref</code> field. The <code>source-ref</code> field contains the Amazon S3 location of the image. You can use <code>SouceRefContains</code> for tasks such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.</p>
    ///   - [`has_errors(bool)`](crate::client::fluent_builders::ListDatasetEntries::has_errors) / [`set_has_errors(Option<bool>)`](crate::client::fluent_builders::ListDatasetEntries::set_has_errors): <p>Specifies an error filter for the response. Specify <code>True</code> to only include entries that have errors. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatasetEntries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDatasetEntries::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
    /// - On success, responds with [`ListDatasetEntriesOutput`](crate::output::ListDatasetEntriesOutput) with field(s):
    ///   - [`dataset_entries(Option<Vec<String>>)`](crate::output::ListDatasetEntriesOutput::dataset_entries): <p> A list of entries (images) in the dataset. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatasetEntriesOutput::next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListDatasetEntriesError>`](crate::error::ListDatasetEntriesError)
    pub fn list_dataset_entries(&self) -> fluent_builders::ListDatasetEntries {
        fluent_builders::ListDatasetEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatasetLabels`](crate::client::fluent_builders::ListDatasetLabels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatasetLabels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_arn(impl Into<String>)`](crate::client::fluent_builders::ListDatasetLabels::dataset_arn) / [`set_dataset_arn(Option<String>)`](crate::client::fluent_builders::ListDatasetLabels::set_dataset_arn): <p> The Amazon Resource Name (ARN) of the dataset that you want to use. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatasetLabels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatasetLabels::set_next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatasetLabels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDatasetLabels::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
    /// - On success, responds with [`ListDatasetLabelsOutput`](crate::output::ListDatasetLabelsOutput) with field(s):
    ///   - [`dataset_label_descriptions(Option<Vec<DatasetLabelDescription>>)`](crate::output::ListDatasetLabelsOutput::dataset_label_descriptions): <p> A list of the labels in the dataset. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatasetLabelsOutput::next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListDatasetLabelsError>`](crate::error::ListDatasetLabelsError)
    pub fn list_dataset_labels(&self) -> fluent_builders::ListDatasetLabels {
        fluent_builders::ListDatasetLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFaces`](crate::client::fluent_builders::ListFaces) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFaces::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::ListFaces::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::ListFaces::set_collection_id): <p>ID of the collection from which to list the faces.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFaces::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFaces::set_next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFaces::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFaces::set_max_results): <p>Maximum number of faces to return.</p>
    /// - On success, responds with [`ListFacesOutput`](crate::output::ListFacesOutput) with field(s):
    ///   - [`faces(Option<Vec<Face>>)`](crate::output::ListFacesOutput::faces): <p>An array of <code>Face</code> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFacesOutput::next_token): <p>If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to retrieve the next set of faces.</p>
    ///   - [`face_model_version(Option<String>)`](crate::output::ListFacesOutput::face_model_version): <p>Version number of the face detection model associated with the input collection (<code>CollectionId</code>).</p>
    /// - On failure, responds with [`SdkError<ListFacesError>`](crate::error::ListFacesError)
    pub fn list_faces(&self) -> fluent_builders::ListFaces {
        fluent_builders::ListFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStreamProcessors`](crate::client::fluent_builders::ListStreamProcessors) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStreamProcessors::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStreamProcessors::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStreamProcessors::set_next_token): <p>If the previous response was incomplete (because there are more stream processors to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of stream processors. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStreamProcessors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListStreamProcessors::set_max_results): <p>Maximum number of stream processors you want Amazon Rekognition Video to return in the response. The default is 1000. </p>
    /// - On success, responds with [`ListStreamProcessorsOutput`](crate::output::ListStreamProcessorsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListStreamProcessorsOutput::next_token): <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of stream processors. </p>
    ///   - [`stream_processors(Option<Vec<StreamProcessor>>)`](crate::output::ListStreamProcessorsOutput::stream_processors): <p>List of stream processors that you have created.</p>
    /// - On failure, responds with [`SdkError<ListStreamProcessorsError>`](crate::error::ListStreamProcessorsError)
    pub fn list_stream_processors(&self) -> fluent_builders::ListStreamProcessors {
        fluent_builders::ListStreamProcessors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that contains the tags that you want a list of. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p> A list of key-value tags assigned to the resource. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RecognizeCelebrities`](crate::client::fluent_builders::RecognizeCelebrities) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image(Image)`](crate::client::fluent_builders::RecognizeCelebrities::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::RecognizeCelebrities::set_image): <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    /// - On success, responds with [`RecognizeCelebritiesOutput`](crate::output::RecognizeCelebritiesOutput) with field(s):
    ///   - [`celebrity_faces(Option<Vec<Celebrity>>)`](crate::output::RecognizeCelebritiesOutput::celebrity_faces): <p>Details about each celebrity found in the image. Amazon Rekognition can detect a maximum of 64 celebrities in an image. Each celebrity object includes the following attributes: <code>Face</code>, <code>Confidence</code>, <code>Emotions</code>, <code>Landmarks</code>, <code>Pose</code>, <code>Quality</code>, <code>Smile</code>, <code>Id</code>, <code>KnownGender</code>, <code>MatchConfidence</code>, <code>Name</code>, <code>Urls</code>.</p>
    ///   - [`unrecognized_faces(Option<Vec<ComparedFace>>)`](crate::output::RecognizeCelebritiesOutput::unrecognized_faces): <p>Details about each unrecognized face in the image.</p>
    ///   - [`orientation_correction(Option<OrientationCorrection>)`](crate::output::RecognizeCelebritiesOutput::orientation_correction): <note>   <p>Support for estimating image orientation using the the OrientationCorrection field has ceased as of August 2021. Any returned values for this field included in an API response will always be NULL.</p>  </note>  <p>The orientation of the input image (counterclockwise direction). If your application displays the image, you can use this value to correct the orientation. The bounding box coordinates returned in <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> represent face locations before the image orientation is corrected. </p> <note>   <p>If the input image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the image's orientation. If so, and the Exif metadata for the input image populates the orientation field, the value of <code>OrientationCorrection</code> is null. The <code>CelebrityFaces</code> and <code>UnrecognizedFaces</code> bounding box coordinates represent face locations after Exif metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata. </p>  </note>
    /// - On failure, responds with [`SdkError<RecognizeCelebritiesError>`](crate::error::RecognizeCelebritiesError)
    pub fn recognize_celebrities(&self) -> fluent_builders::RecognizeCelebrities {
        fluent_builders::RecognizeCelebrities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchFaces`](crate::client::fluent_builders::SearchFaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::SearchFaces::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::SearchFaces::set_collection_id): <p>ID of the collection the face belongs to.</p>
    ///   - [`face_id(impl Into<String>)`](crate::client::fluent_builders::SearchFaces::face_id) / [`set_face_id(Option<String>)`](crate::client::fluent_builders::SearchFaces::set_face_id): <p>ID of a face to find matches for in the collection.</p>
    ///   - [`max_faces(i32)`](crate::client::fluent_builders::SearchFaces::max_faces) / [`set_max_faces(Option<i32>)`](crate::client::fluent_builders::SearchFaces::set_max_faces): <p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>
    ///   - [`face_match_threshold(f32)`](crate::client::fluent_builders::SearchFaces::face_match_threshold) / [`set_face_match_threshold(Option<f32>)`](crate::client::fluent_builders::SearchFaces::set_face_match_threshold): <p>Optional value specifying the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%. </p>
    /// - On success, responds with [`SearchFacesOutput`](crate::output::SearchFacesOutput) with field(s):
    ///   - [`searched_face_id(Option<String>)`](crate::output::SearchFacesOutput::searched_face_id): <p>ID of the face that was searched for matches in a collection.</p>
    ///   - [`face_matches(Option<Vec<FaceMatch>>)`](crate::output::SearchFacesOutput::face_matches): <p>An array of faces that matched the input face, along with the confidence in the match.</p>
    ///   - [`face_model_version(Option<String>)`](crate::output::SearchFacesOutput::face_model_version): <p>Version number of the face detection model associated with the input collection (<code>CollectionId</code>).</p>
    /// - On failure, responds with [`SdkError<SearchFacesError>`](crate::error::SearchFacesError)
    pub fn search_faces(&self) -> fluent_builders::SearchFaces {
        fluent_builders::SearchFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchFacesByImage`](crate::client::fluent_builders::SearchFacesByImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::SearchFacesByImage::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::SearchFacesByImage::set_collection_id): <p>ID of the collection to search.</p>
    ///   - [`image(Image)`](crate::client::fluent_builders::SearchFacesByImage::image) / [`set_image(Option<Image>)`](crate::client::fluent_builders::SearchFacesByImage::set_image): <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>  <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
    ///   - [`max_faces(i32)`](crate::client::fluent_builders::SearchFacesByImage::max_faces) / [`set_max_faces(Option<i32>)`](crate::client::fluent_builders::SearchFacesByImage::set_max_faces): <p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>
    ///   - [`face_match_threshold(f32)`](crate::client::fluent_builders::SearchFacesByImage::face_match_threshold) / [`set_face_match_threshold(Option<f32>)`](crate::client::fluent_builders::SearchFacesByImage::set_face_match_threshold): <p>(Optional) Specifies the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.</p>
    ///   - [`quality_filter(QualityFilter)`](crate::client::fluent_builders::SearchFacesByImage::quality_filter) / [`set_quality_filter(Option<QualityFilter>)`](crate::client::fluent_builders::SearchFacesByImage::set_quality_filter): <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>  <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
    /// - On success, responds with [`SearchFacesByImageOutput`](crate::output::SearchFacesByImageOutput) with field(s):
    ///   - [`searched_face_bounding_box(Option<BoundingBox>)`](crate::output::SearchFacesByImageOutput::searched_face_bounding_box): <p>The bounding box around the face in the input image that Amazon Rekognition used for the search.</p>
    ///   - [`searched_face_confidence(Option<f32>)`](crate::output::SearchFacesByImageOutput::searched_face_confidence): <p>The level of confidence that the <code>searchedFaceBoundingBox</code>, contains a face.</p>
    ///   - [`face_matches(Option<Vec<FaceMatch>>)`](crate::output::SearchFacesByImageOutput::face_matches): <p>An array of faces that match the input face, along with the confidence in the match.</p>
    ///   - [`face_model_version(Option<String>)`](crate::output::SearchFacesByImageOutput::face_model_version): <p>Version number of the face detection model associated with the input collection (<code>CollectionId</code>).</p>
    /// - On failure, responds with [`SdkError<SearchFacesByImageError>`](crate::error::SearchFacesByImageError)
    pub fn search_faces_by_image(&self) -> fluent_builders::SearchFacesByImage {
        fluent_builders::SearchFacesByImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartCelebrityRecognition`](crate::client::fluent_builders::StartCelebrityRecognition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartCelebrityRecognition::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartCelebrityRecognition::set_video): <p>The video in which you want to recognize celebrities. The video must be stored in an Amazon S3 bucket.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartCelebrityRecognition::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartCelebrityRecognition::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartCelebrityRecognition</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartCelebrityRecognition::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartCelebrityRecognition::set_notification_channel): <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the celebrity recognition analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartCelebrityRecognition::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartCelebrityRecognition::set_job_tag): <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    /// - On success, responds with [`StartCelebrityRecognitionOutput`](crate::output::StartCelebrityRecognitionOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartCelebrityRecognitionOutput::job_id): <p>The identifier for the celebrity recognition analysis job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetCelebrityRecognition</code>.</p>
    /// - On failure, responds with [`SdkError<StartCelebrityRecognitionError>`](crate::error::StartCelebrityRecognitionError)
    pub fn start_celebrity_recognition(&self) -> fluent_builders::StartCelebrityRecognition {
        fluent_builders::StartCelebrityRecognition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartContentModeration`](crate::client::fluent_builders::StartContentModeration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartContentModeration::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartContentModeration::set_video): <p>The video in which you want to detect inappropriate, unwanted, or offensive content. The video must be stored in an Amazon S3 bucket.</p>
    ///   - [`min_confidence(f32)`](crate::client::fluent_builders::StartContentModeration::min_confidence) / [`set_min_confidence(Option<f32>)`](crate::client::fluent_builders::StartContentModeration::set_min_confidence): <p>Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition doesn't return any moderated content labels with a confidence level lower than this specified value. If you don't specify <code>MinConfidence</code>, <code>GetContentModeration</code> returns labels with confidence values greater than or equal to 50 percent.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartContentModeration::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartContentModeration::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartContentModeration</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartContentModeration::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartContentModeration::set_notification_channel): <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the content analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartContentModeration::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartContentModeration::set_job_tag): <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    /// - On success, responds with [`StartContentModerationOutput`](crate::output::StartContentModerationOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartContentModerationOutput::job_id): <p>The identifier for the content analysis job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetContentModeration</code>.</p>
    /// - On failure, responds with [`SdkError<StartContentModerationError>`](crate::error::StartContentModerationError)
    pub fn start_content_moderation(&self) -> fluent_builders::StartContentModeration {
        fluent_builders::StartContentModeration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFaceDetection`](crate::client::fluent_builders::StartFaceDetection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartFaceDetection::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartFaceDetection::set_video): <p>The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartFaceDetection::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartFaceDetection::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartFaceDetection::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartFaceDetection::set_notification_channel): <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the face detection operation. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
    ///   - [`face_attributes(FaceAttributes)`](crate::client::fluent_builders::StartFaceDetection::face_attributes) / [`set_face_attributes(Option<FaceAttributes>)`](crate::client::fluent_builders::StartFaceDetection::set_face_attributes): <p>The face attributes you want returned.</p>  <p> <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and Landmarks. </p>  <p> <code>ALL</code> - All facial attributes are returned.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartFaceDetection::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartFaceDetection::set_job_tag): <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    /// - On success, responds with [`StartFaceDetectionOutput`](crate::output::StartFaceDetectionOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartFaceDetectionOutput::job_id): <p>The identifier for the face detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetFaceDetection</code>.</p>
    /// - On failure, responds with [`SdkError<StartFaceDetectionError>`](crate::error::StartFaceDetectionError)
    pub fn start_face_detection(&self) -> fluent_builders::StartFaceDetection {
        fluent_builders::StartFaceDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFaceSearch`](crate::client::fluent_builders::StartFaceSearch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartFaceSearch::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartFaceSearch::set_video): <p>The video you want to search. The video must be stored in an Amazon S3 bucket. </p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartFaceSearch::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartFaceSearch::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceSearch</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
    ///   - [`face_match_threshold(f32)`](crate::client::fluent_builders::StartFaceSearch::face_match_threshold) / [`set_face_match_threshold(Option<f32>)`](crate::client::fluent_builders::StartFaceSearch::set_face_match_threshold): <p>The minimum confidence in the person match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.</p>
    ///   - [`collection_id(impl Into<String>)`](crate::client::fluent_builders::StartFaceSearch::collection_id) / [`set_collection_id(Option<String>)`](crate::client::fluent_builders::StartFaceSearch::set_collection_id): <p>ID of the collection that contains the faces you want to search for.</p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartFaceSearch::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartFaceSearch::set_notification_channel): <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the search. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartFaceSearch::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartFaceSearch::set_job_tag): <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    /// - On success, responds with [`StartFaceSearchOutput`](crate::output::StartFaceSearchOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartFaceSearchOutput::job_id): <p>The identifier for the search job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetFaceSearch</code>. </p>
    /// - On failure, responds with [`SdkError<StartFaceSearchError>`](crate::error::StartFaceSearchError)
    pub fn start_face_search(&self) -> fluent_builders::StartFaceSearch {
        fluent_builders::StartFaceSearch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartLabelDetection`](crate::client::fluent_builders::StartLabelDetection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartLabelDetection::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartLabelDetection::set_video): <p>The video in which you want to detect labels. The video must be stored in an Amazon S3 bucket.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartLabelDetection::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartLabelDetection::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartLabelDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
    ///   - [`min_confidence(f32)`](crate::client::fluent_builders::StartLabelDetection::min_confidence) / [`set_min_confidence(Option<f32>)`](crate::client::fluent_builders::StartLabelDetection::set_min_confidence): <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any labels with a confidence level lower than this specified value.</p>  <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartLabelDetection::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartLabelDetection::set_notification_channel): <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartLabelDetection::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartLabelDetection::set_job_tag): <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    /// - On success, responds with [`StartLabelDetectionOutput`](crate::output::StartLabelDetectionOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartLabelDetectionOutput::job_id): <p>The identifier for the label detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetLabelDetection</code>. </p>
    /// - On failure, responds with [`SdkError<StartLabelDetectionError>`](crate::error::StartLabelDetectionError)
    pub fn start_label_detection(&self) -> fluent_builders::StartLabelDetection {
        fluent_builders::StartLabelDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartPersonTracking`](crate::client::fluent_builders::StartPersonTracking) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartPersonTracking::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartPersonTracking::set_video): <p>The video in which you want to detect people. The video must be stored in an Amazon S3 bucket.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartPersonTracking::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartPersonTracking::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartPersonTracking</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartPersonTracking::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartPersonTracking::set_notification_channel): <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the people detection operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartPersonTracking::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartPersonTracking::set_job_tag): <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    /// - On success, responds with [`StartPersonTrackingOutput`](crate::output::StartPersonTrackingOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartPersonTrackingOutput::job_id): <p>The identifier for the person detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetPersonTracking</code>.</p>
    /// - On failure, responds with [`SdkError<StartPersonTrackingError>`](crate::error::StartPersonTrackingError)
    pub fn start_person_tracking(&self) -> fluent_builders::StartPersonTracking {
        fluent_builders::StartPersonTracking::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartProjectVersion`](crate::client::fluent_builders::StartProjectVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_version_arn(impl Into<String>)`](crate::client::fluent_builders::StartProjectVersion::project_version_arn) / [`set_project_version_arn(Option<String>)`](crate::client::fluent_builders::StartProjectVersion::set_project_version_arn): <p>The Amazon Resource Name(ARN) of the model version that you want to start.</p>
    ///   - [`min_inference_units(i32)`](crate::client::fluent_builders::StartProjectVersion::min_inference_units) / [`set_min_inference_units(Option<i32>)`](crate::client::fluent_builders::StartProjectVersion::set_min_inference_units): <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
    /// - On success, responds with [`StartProjectVersionOutput`](crate::output::StartProjectVersionOutput) with field(s):
    ///   - [`status(Option<ProjectVersionStatus>)`](crate::output::StartProjectVersionOutput::status): <p>The current running status of the model. </p>
    /// - On failure, responds with [`SdkError<StartProjectVersionError>`](crate::error::StartProjectVersionError)
    pub fn start_project_version(&self) -> fluent_builders::StartProjectVersion {
        fluent_builders::StartProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSegmentDetection`](crate::client::fluent_builders::StartSegmentDetection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartSegmentDetection::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartSegmentDetection::set_video): <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <code>StartLabelDetection</code> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartSegmentDetection::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartSegmentDetection::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartSegmentDetection::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartSegmentDetection::set_notification_channel): <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the segment detection operation. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartSegmentDetection::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartSegmentDetection::set_job_tag): <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    ///   - [`filters(StartSegmentDetectionFilters)`](crate::client::fluent_builders::StartSegmentDetection::filters) / [`set_filters(Option<StartSegmentDetectionFilters>)`](crate::client::fluent_builders::StartSegmentDetection::set_filters): <p>Filters for technical cue or shot detection.</p>
    ///   - [`segment_types(Vec<SegmentType>)`](crate::client::fluent_builders::StartSegmentDetection::segment_types) / [`set_segment_types(Option<Vec<SegmentType>>)`](crate::client::fluent_builders::StartSegmentDetection::set_segment_types): <p>An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.</p>
    /// - On success, responds with [`StartSegmentDetectionOutput`](crate::output::StartSegmentDetectionOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartSegmentDetectionOutput::job_id): <p>Unique identifier for the segment detection job. The <code>JobId</code> is returned from <code>StartSegmentDetection</code>. </p>
    /// - On failure, responds with [`SdkError<StartSegmentDetectionError>`](crate::error::StartSegmentDetectionError)
    pub fn start_segment_detection(&self) -> fluent_builders::StartSegmentDetection {
        fluent_builders::StartSegmentDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartStreamProcessor`](crate::client::fluent_builders::StartStreamProcessor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartStreamProcessor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartStreamProcessor::set_name): <p>The name of the stream processor to start processing.</p>
    ///   - [`start_selector(StreamProcessingStartSelector)`](crate::client::fluent_builders::StartStreamProcessor::start_selector) / [`set_start_selector(Option<StreamProcessingStartSelector>)`](crate::client::fluent_builders::StartStreamProcessor::set_start_selector): <p> Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or the fragment number. For more information, see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>. </p>  <p>This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.</p>
    ///   - [`stop_selector(StreamProcessingStopSelector)`](crate::client::fluent_builders::StartStreamProcessor::stop_selector) / [`set_stop_selector(Option<StreamProcessingStopSelector>)`](crate::client::fluent_builders::StartStreamProcessor::set_stop_selector): <p> Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video. </p>  <p>This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.</p>
    /// - On success, responds with [`StartStreamProcessorOutput`](crate::output::StartStreamProcessorOutput) with field(s):
    ///   - [`session_id(Option<String>)`](crate::output::StartStreamProcessorOutput::session_id): <p> A unique identifier for the stream processing session. </p>
    /// - On failure, responds with [`SdkError<StartStreamProcessorError>`](crate::error::StartStreamProcessorError)
    pub fn start_stream_processor(&self) -> fluent_builders::StartStreamProcessor {
        fluent_builders::StartStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTextDetection`](crate::client::fluent_builders::StartTextDetection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`video(Video)`](crate::client::fluent_builders::StartTextDetection::video) / [`set_video(Option<Video>)`](crate::client::fluent_builders::StartTextDetection::set_video): <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <code>StartLabelDetection</code> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::StartTextDetection::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::StartTextDetection::set_client_request_token): <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentaly started more than once.</p>
    ///   - [`notification_channel(NotificationChannel)`](crate::client::fluent_builders::StartTextDetection::notification_channel) / [`set_notification_channel(Option<NotificationChannel>)`](crate::client::fluent_builders::StartTextDetection::set_notification_channel): <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html">Calling Amazon Rekognition Video operations</a>. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics">Giving access to multiple Amazon SNS topics</a>.</p>
    ///   - [`job_tag(impl Into<String>)`](crate::client::fluent_builders::StartTextDetection::job_tag) / [`set_job_tag(Option<String>)`](crate::client::fluent_builders::StartTextDetection::set_job_tag): <p>An identifier returned in the completion status published by your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
    ///   - [`filters(StartTextDetectionFilters)`](crate::client::fluent_builders::StartTextDetection::filters) / [`set_filters(Option<StartTextDetectionFilters>)`](crate::client::fluent_builders::StartTextDetection::set_filters): <p>Optional parameters that let you set criteria the text must meet to be included in your response.</p>
    /// - On success, responds with [`StartTextDetectionOutput`](crate::output::StartTextDetectionOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartTextDetectionOutput::job_id): <p>Identifier for the text detection job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetTextDetection</code>.</p>
    /// - On failure, responds with [`SdkError<StartTextDetectionError>`](crate::error::StartTextDetectionError)
    pub fn start_text_detection(&self) -> fluent_builders::StartTextDetection {
        fluent_builders::StartTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopProjectVersion`](crate::client::fluent_builders::StopProjectVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_version_arn(impl Into<String>)`](crate::client::fluent_builders::StopProjectVersion::project_version_arn) / [`set_project_version_arn(Option<String>)`](crate::client::fluent_builders::StopProjectVersion::set_project_version_arn): <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>  <p>This operation requires permissions to perform the <code>rekognition:StopProjectVersion</code> action.</p>
    /// - On success, responds with [`StopProjectVersionOutput`](crate::output::StopProjectVersionOutput) with field(s):
    ///   - [`status(Option<ProjectVersionStatus>)`](crate::output::StopProjectVersionOutput::status): <p>The current status of the stop operation. </p>
    /// - On failure, responds with [`SdkError<StopProjectVersionError>`](crate::error::StopProjectVersionError)
    pub fn stop_project_version(&self) -> fluent_builders::StopProjectVersion {
        fluent_builders::StopProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopStreamProcessor`](crate::client::fluent_builders::StopStreamProcessor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StopStreamProcessor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StopStreamProcessor::set_name): <p>The name of a stream processor created by <code>CreateStreamProcessor</code>.</p>
    /// - On success, responds with [`StopStreamProcessorOutput`](crate::output::StopStreamProcessorOutput)

    /// - On failure, responds with [`SdkError<StopStreamProcessorError>`](crate::error::StopStreamProcessorError)
    pub fn stop_stream_processor(&self) -> fluent_builders::StopStreamProcessor {
        fluent_builders::StopStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to assign the tags to. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p> The key-value tags to assign to the resource. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to remove the tags from. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> A list of the tags that you want to remove. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDatasetEntries`](crate::client::fluent_builders::UpdateDatasetEntries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dataset_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::dataset_arn) / [`set_dataset_arn(Option<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::set_dataset_arn): <p> The Amazon Resource Name (ARN) of the dataset that you want to update. </p>
    ///   - [`changes(DatasetChanges)`](crate::client::fluent_builders::UpdateDatasetEntries::changes) / [`set_changes(Option<DatasetChanges>)`](crate::client::fluent_builders::UpdateDatasetEntries::set_changes): <p> The changes that you want to make to the dataset. </p>
    /// - On success, responds with [`UpdateDatasetEntriesOutput`](crate::output::UpdateDatasetEntriesOutput)

    /// - On failure, responds with [`SdkError<UpdateDatasetEntriesError>`](crate::error::UpdateDatasetEntriesError)
    pub fn update_dataset_entries(&self) -> fluent_builders::UpdateDatasetEntries {
        fluent_builders::UpdateDatasetEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStreamProcessor`](crate::client::fluent_builders::UpdateStreamProcessor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateStreamProcessor::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateStreamProcessor::set_name): <p> Name of the stream processor that you want to update. </p>
    ///   - [`settings_for_update(StreamProcessorSettingsForUpdate)`](crate::client::fluent_builders::UpdateStreamProcessor::settings_for_update) / [`set_settings_for_update(Option<StreamProcessorSettingsForUpdate>)`](crate::client::fluent_builders::UpdateStreamProcessor::set_settings_for_update): <p> The stream processor settings that you want to update. Label detection settings can be updated to detect different labels with a different minimum confidence. </p>
    ///   - [`regions_of_interest_for_update(Vec<RegionOfInterest>)`](crate::client::fluent_builders::UpdateStreamProcessor::regions_of_interest_for_update) / [`set_regions_of_interest_for_update(Option<Vec<RegionOfInterest>>)`](crate::client::fluent_builders::UpdateStreamProcessor::set_regions_of_interest_for_update): <p> Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional parameter for label detection stream processors. </p>
    ///   - [`data_sharing_preference_for_update(StreamProcessorDataSharingPreference)`](crate::client::fluent_builders::UpdateStreamProcessor::data_sharing_preference_for_update) / [`set_data_sharing_preference_for_update(Option<StreamProcessorDataSharingPreference>)`](crate::client::fluent_builders::UpdateStreamProcessor::set_data_sharing_preference_for_update): <p> Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. </p>
    ///   - [`parameters_to_delete(Vec<StreamProcessorParameterToDelete>)`](crate::client::fluent_builders::UpdateStreamProcessor::parameters_to_delete) / [`set_parameters_to_delete(Option<Vec<StreamProcessorParameterToDelete>>)`](crate::client::fluent_builders::UpdateStreamProcessor::set_parameters_to_delete): <p> A list of parameters you want to delete from the stream processor. </p>
    /// - On success, responds with [`UpdateStreamProcessorOutput`](crate::output::UpdateStreamProcessorOutput)

    /// - On failure, responds with [`SdkError<UpdateStreamProcessorError>`](crate::error::UpdateStreamProcessorError)
    pub fn update_stream_processor(&self) -> fluent_builders::UpdateStreamProcessor {
        fluent_builders::UpdateStreamProcessor::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CompareFaces`.
    ///
    /// <p>Compares a face in the <i>source</i> input image with each of the 100 largest faces detected in the <i>target</i> input image. </p>
    /// <p> If the source image contains multiple faces, the service detects the largest face and compares it with each face detected in the target image. </p> <note>
    /// <p>CompareFaces uses machine learning algorithms, which are probabilistic. A false negative is an incorrect prediction that a face in the target image has a low similarity confidence score when compared to the face in the source image. To reduce the probability of false negatives, we recommend that you compare the target image against multiple source images. If you plan to use <code>CompareFaces</code> to make a decision that impacts an individual's rights, privacy, or access to services, we recommend that you pass the result to a human for review and further validation before taking action.</p>
    /// </note>
    /// <p>You pass the input and target images either as base64-encoded image bytes or as references to images in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The image must be formatted as a PNG or JPEG file. </p>
    /// <p>In response, the operation returns an array of face matches ordered by similarity score in descending order. For each face match, the response provides a bounding box of the face, facial landmarks, pose details (pitch, roll, and yaw), quality (brightness and sharpness), and confidence value (indicating the level of confidence that the bounding box contains a face). The response also provides a similarity score, which indicates how closely the faces match. </p> <note>
    /// <p>By default, only faces with a similarity score of greater than or equal to 80% are returned in the response. You can change this value by specifying the <code>SimilarityThreshold</code> parameter.</p>
    /// </note>
    /// <p> <code>CompareFaces</code> also returns an array of faces that don't match the source image. For each face, it returns a bounding box, confidence value, landmarks, pose details, and quality. The response also returns information about the face in the source image, including the bounding box of the face and confidence value.</p>
    /// <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required quality bar. The quality bar is based on a variety of common use cases. Use <code>QualityFilter</code> to set the quality bar by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do not want to filter detected faces, specify <code>NONE</code>. The default value is <code>NONE</code>. </p>
    /// <p>If the image doesn't contain Exif metadata, <code>CompareFaces</code> returns orientation information for the source and target images. Use these values to display the images with the correct image orientation.</p>
    /// <p>If no faces are detected in the source or target images, <code>CompareFaces</code> returns an <code>InvalidParameterException</code> error. </p> <note>
    /// <p> This is a stateless API operation. That is, data returned by this operation doesn't persist.</p>
    /// </note>
    /// <p>For an example, see Comparing Faces in Images in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CompareFaces</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CompareFaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::compare_faces_input::Builder,
    }
    impl CompareFaces {
        /// Creates a new `CompareFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompareFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::CompareFacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn source_image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.source_image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_source_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_source_image(input);
            self
        }
        /// <p>The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn target_image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.target_image(input);
            self
        }
        /// <p>The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_target_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_target_image(input);
            self
        }
        /// <p>The minimum level of confidence in the face matches that a match must meet to be included in the <code>FaceMatches</code> array.</p>
        pub fn similarity_threshold(mut self, input: f32) -> Self {
            self.inner = self.inner.similarity_threshold(input);
            self
        }
        /// <p>The minimum level of confidence in the face matches that a match must meet to be included in the <code>FaceMatches</code> array.</p>
        pub fn set_similarity_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_similarity_threshold(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn quality_filter(mut self, input: crate::model::QualityFilter) -> Self {
            self.inner = self.inner.quality_filter(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn set_quality_filter(
            mut self,
            input: std::option::Option<crate::model::QualityFilter>,
        ) -> Self {
            self.inner = self.inner.set_quality_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCollection`.
    ///
    /// <p>Creates a collection in an AWS Region. You can add faces to the collection using the <code>IndexFaces</code> operation. </p>
    /// <p>For example, you might create collections, one for each of your application users. A user can then index faces using the <code>IndexFaces</code> operation and persist results in a specific collection. Then, a user can search the collection for faces in the user-specific container. </p>
    /// <p>When you create a collection, it is associated with the latest version of the face model version.</p> <note>
    /// <p>Collection names are case-sensitive.</p>
    /// </note>
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateCollection</code> action. If you want to tag your collection, you also require permission to perform the <code>rekognition:TagResource</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_collection_input::Builder,
    }
    impl CreateCollection {
        /// Creates a new `CreateCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID for the collection that you are creating.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>ID for the collection that you are creating.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A set of tags (key-value pairs) that you want to attach to the collection. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A set of tags (key-value pairs) that you want to attach to the collection. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates a new Amazon Rekognition Custom Labels dataset. You can create a dataset by using an Amazon Sagemaker format manifest file or by copying an existing Amazon Rekognition Custom Labels dataset.</p>
    /// <p>To create a training dataset for a project, specify <code>train</code> for the value of <code>DatasetType</code>. To create the test dataset for a project, specify <code>test</code> for the value of <code>DatasetType</code>. </p>
    /// <p>The response from <code>CreateDataset</code> is the Amazon Resource Name (ARN) for the dataset. Creating a dataset takes a while to complete. Use <code>DescribeDataset</code> to check the current status. The dataset created successfully if the value of <code>Status</code> is <code>CREATE_COMPLETE</code>. </p>
    /// <p>To check if any non-terminal errors occurred, call <code>ListDatasetEntries</code> and check for the presence of <code>errors</code> lists in the JSON Lines.</p>
    /// <p>Dataset creation fails if a terminal error occurs (<code>Status</code> = <code>CREATE_FAILED</code>). Currently, you can't access the terminal error information. </p>
    /// <p>For more information, see Creating dataset in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateDataset</code> action. If you want to copy an existing dataset, you also require permission to perform the <code>rekognition:ListDatasetEntries</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl CreateDataset {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3 bucket location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>, an empty dataset is created. To add labeled images to the dataset, You can use the console or call <code>UpdateDatasetEntries</code>. </p>
        pub fn dataset_source(mut self, input: crate::model::DatasetSource) -> Self {
            self.inner = self.inner.dataset_source(input);
            self
        }
        /// <p> The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3 bucket location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>, an empty dataset is created. To add labeled images to the dataset, You can use the console or call <code>UpdateDatasetEntries</code>. </p>
        pub fn set_dataset_source(
            mut self,
            input: std::option::Option<crate::model::DatasetSource>,
        ) -> Self {
            self.inner = self.inner.set_dataset_source(input);
            self
        }
        /// <p> The type of the dataset. Specify <code>train</code> to create a training dataset. Specify <code>test</code> to create a test dataset. </p>
        pub fn dataset_type(mut self, input: crate::model::DatasetType) -> Self {
            self.inner = self.inner.dataset_type(input);
            self
        }
        /// <p> The type of the dataset. Specify <code>train</code> to create a training dataset. Specify <code>test</code> to create a test dataset. </p>
        pub fn set_dataset_type(
            mut self,
            input: std::option::Option<crate::model::DatasetType>,
        ) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p> The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset. </p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(input.into());
            self
        }
        /// <p> The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset. </p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a new Amazon Rekognition Custom Labels project. A project is a group of resources (datasets, model versions) that you use to create and manage Amazon Rekognition Custom Labels models. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateProject</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_project_input::Builder,
    }
    impl CreateProject {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to create.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project to create.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProjectVersion`.
    ///
    /// <p>Creates a new version of a model and begins training. Models are managed as part of an Amazon Rekognition Custom Labels project. The response from <code>CreateProjectVersion</code> is an Amazon Resource Name (ARN) for the version of the model. </p>
    /// <p>Training uses the training and test datasets associated with the project. For more information, see Creating training and test dataset in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p> <note>
    /// <p>You can train a modelin a project that doesn't have associated datasets by specifying manifest files in the <code>TrainingData</code> and <code>TestingData</code> fields. </p>
    /// <p>If you open the console after training a model with manifest files, Amazon Rekognition Custom Labels creates the datasets for you using the most recent manifest files. You can no longer train a model version for the project by specifying manifest files. </p>
    /// <p>Instead of training with a project without associated datasets, we recommend that you use the manifest files to create training and test datasets for the project.</p>
    /// </note>
    /// <p>Training takes a while to complete. You can get the current status by calling <code>DescribeProjectVersions</code>. Training completed successfully if the value of the <code>Status</code> field is <code>TRAINING_COMPLETED</code>.</p>
    /// <p>If training fails, see Debugging a failed model training in the <i>Amazon Rekognition Custom Labels</i> developer guide. </p>
    /// <p>Once training has successfully completed, call <code>DescribeProjectVersions</code> to get the training results and evaluate the model. For more information, see Improving a trained Amazon Rekognition Custom Labels model in the <i>Amazon Rekognition Custom Labels</i> developers guide. </p>
    /// <p>After evaluating the model, you start the model by calling <code>StartProjectVersion</code>.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateProjectVersion</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProjectVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_project_version_input::Builder,
    }
    impl CreateProjectVersion {
        /// Creates a new `CreateProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>A name for the version of the model. This value must be unique.</p>
        pub fn version_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(input.into());
            self
        }
        /// <p>A name for the version of the model. This value must be unique.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS account as long as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>The Amazon S3 bucket location to store the results of training. The S3 bucket can be in any AWS account as long as the caller has <code>s3:PutObject</code> permissions on the S3 bucket.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>Specifies an external manifest that the services uses to train the model. If you specify <code>TrainingData</code> you must also specify <code>TestingData</code>. The project must not have any associated datasets. </p>
        pub fn training_data(mut self, input: crate::model::TrainingData) -> Self {
            self.inner = self.inner.training_data(input);
            self
        }
        /// <p>Specifies an external manifest that the services uses to train the model. If you specify <code>TrainingData</code> you must also specify <code>TestingData</code>. The project must not have any associated datasets. </p>
        pub fn set_training_data(
            mut self,
            input: std::option::Option<crate::model::TrainingData>,
        ) -> Self {
            self.inner = self.inner.set_training_data(input);
            self
        }
        /// <p>Specifies an external manifest that the service uses to test the model. If you specify <code>TestingData</code> you must also specify <code>TrainingData</code>. The project must not have any associated datasets.</p>
        pub fn testing_data(mut self, input: crate::model::TestingData) -> Self {
            self.inner = self.inner.testing_data(input);
            self
        }
        /// <p>Specifies an external manifest that the service uses to test the model. If you specify <code>TestingData</code> you must also specify <code>TrainingData</code>. The project must not have any associated datasets.</p>
        pub fn set_testing_data(
            mut self,
            input: std::option::Option<crate::model::TestingData>,
        ) -> Self {
            self.inner = self.inner.set_testing_data(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A set of tags (key-value pairs) that you want to attach to the model. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A set of tags (key-value pairs) that you want to attach to the model. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. The key is also used to encrypt training results and manifest files written to the output Amazon S3 bucket (<code>OutputConfig</code>).</p>
        /// <p>If you choose to use your own KMS key, you need the following permissions on the KMS key.</p>
        /// <ul>
        /// <li> <p>kms:CreateGrant</p> </li>
        /// <li> <p>kms:DescribeKey</p> </li>
        /// <li> <p>kms:GenerateDataKey</p> </li>
        /// <li> <p>kms:Decrypt</p> </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted using a key that AWS owns and manages.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The identifier for your AWS Key Management Service key (AWS KMS key). You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. The key is also used to encrypt training results and manifest files written to the output Amazon S3 bucket (<code>OutputConfig</code>).</p>
        /// <p>If you choose to use your own KMS key, you need the following permissions on the KMS key.</p>
        /// <ul>
        /// <li> <p>kms:CreateGrant</p> </li>
        /// <li> <p>kms:DescribeKey</p> </li>
        /// <li> <p>kms:GenerateDataKey</p> </li>
        /// <li> <p>kms:Decrypt</p> </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted using a key that AWS owns and manages.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamProcessor`.
    ///
    /// <p>Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces or to detect labels in a streaming video.</p>
    /// <p>Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. There are two different settings for stream processors in Amazon Rekognition: detecting faces and detecting labels.</p>
    /// <ul>
    /// <li> <p>If you are creating a stream processor for detecting faces, you provide as input a Kinesis video stream (<code>Input</code>) and a Kinesis data stream (<code>Output</code>) stream. You also specify the face recognition criteria in <code>Settings</code>. For example, the collection containing faces that you want to recognize. After you have finished analyzing a streaming video, use <code>StopStreamProcessor</code> to stop processing.</p> </li>
    /// <li> <p>If you are creating a stream processor to detect labels, you provide as input a Kinesis video stream (<code>Input</code>), Amazon S3 bucket information (<code>Output</code>), and an Amazon SNS topic ARN (<code>NotificationChannel</code>). You can also provide a KMS key ID to encrypt the data sent to your Amazon S3 bucket. You specify what you want to detect in <code>ConnectedHomeSettings</code>, such as people, packages and people, or pets, people, and packages. You can also specify where in the frame you want Amazon Rekognition to monitor with <code>RegionsOfInterest</code>. When you run the <code>StartStreamProcessor</code> operation on a label detection stream processor, you input start and stop information to determine the length of the processing time.</p> </li>
    /// </ul>
    /// <p> Use <code>Name</code> to assign an identifier for the stream processor. You use <code>Name</code> to manage the stream processor. For example, you can start processing the source video by calling <code>StartStreamProcessor</code> with the <code>Name</code> field. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateStreamProcessor</code> action. If you want to tag your stream processor, you also require permission to perform the <code>rekognition:TagResource</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamProcessor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_stream_processor_input::Builder,
    }
    impl CreateStreamProcessor {
        /// Creates a new `CreateStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamProcessorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is <code>StreamProcessorInput</code>. This is required for both face search and label detection stream processors.</p>
        pub fn input(mut self, input: crate::model::StreamProcessorInput) -> Self {
            self.inner = self.inner.input(input);
            self
        }
        /// <p>Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is <code>StreamProcessorInput</code>. This is required for both face search and label detection stream processors.</p>
        pub fn set_input(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorInput>,
        ) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>. This must be a <code>S3Destination</code> of an Amazon S3 bucket that you own for a label detection stream processor or a Kinesis data stream ARN for a face search stream processor.</p>
        pub fn output(mut self, input: crate::model::StreamProcessorOutput) -> Self {
            self.inner = self.inner.output(input);
            self
        }
        /// <p>Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>. This must be a <code>S3Destination</code> of an Amazon S3 bucket that you own for a label detection stream processor or a Kinesis data stream ARN for a face search stream processor.</p>
        pub fn set_output(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorOutput>,
        ) -> Self {
            self.inner = self.inner.set_output(input);
            self
        }
        /// <p>An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream processor. For example, you can get the current status of the stream processor by calling <code>DescribeStreamProcessor</code>. <code>Name</code> is idempotent. This is required for both face search and label detection stream processors. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>An identifier you assign to the stream processor. You can use <code>Name</code> to manage the stream processor. For example, you can get the current status of the stream processor by calling <code>DescribeStreamProcessor</code>. <code>Name</code> is idempotent. This is required for both face search and label detection stream processors. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Input parameters used in a streaming video analyzed by a stream processor. You can use <code>FaceSearch</code> to recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to detect labels.</p>
        pub fn settings(mut self, input: crate::model::StreamProcessorSettings) -> Self {
            self.inner = self.inner.settings(input);
            self
        }
        /// <p>Input parameters used in a streaming video analyzed by a stream processor. You can use <code>FaceSearch</code> to recognize faces in a streaming video, or you can use <code>ConnectedHome</code> to detect labels.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A set of tags (key-value pairs) that you want to attach to the stream processor. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> A set of tags (key-value pairs) that you want to attach to the stream processor. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.</p>
        /// <p>Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a pet at second 4.</p>
        /// <p>Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete.</p>
        pub fn notification_channel(
            mut self,
            input: crate::model::StreamProcessorNotificationChannel,
        ) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.</p>
        /// <p>Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. For example, if Amazon Rekognition detects a person at second 2, a pet at second 4, and a person again at second 5, Amazon Rekognition sends 2 object class detected notifications, one for a person at second 2 and one for a pet at second 4.</p>
        /// <p>Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorNotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p> The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt results and data published to your Amazon S3 bucket, which includes image frames and hero images. Your source images are unaffected. </p>
        /// <p> </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p> The identifier for your AWS Key Management Service key (AWS KMS key). This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt results and data published to your Amazon S3 bucket, which includes image frames and hero images. Your source images are unaffected. </p>
        /// <p> </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `RegionsOfInterest`.
        ///
        /// To override the contents of this collection use [`set_regions_of_interest`](Self::set_regions_of_interest).
        ///
        /// <p> Specifies locations in the frames where Amazon Rekognition checks for objects or people. You can specify up to 10 regions of interest. This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. </p>
        pub fn regions_of_interest(mut self, input: crate::model::RegionOfInterest) -> Self {
            self.inner = self.inner.regions_of_interest(input);
            self
        }
        /// <p> Specifies locations in the frames where Amazon Rekognition checks for objects or people. You can specify up to 10 regions of interest. This is an optional parameter for label detection stream processors and should not be used to create a face search stream processor. </p>
        pub fn set_regions_of_interest(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
        ) -> Self {
            self.inner = self.inner.set_regions_of_interest(input);
            self
        }
        /// <p> Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. </p>
        pub fn data_sharing_preference(
            mut self,
            input: crate::model::StreamProcessorDataSharingPreference,
        ) -> Self {
            self.inner = self.inner.data_sharing_preference(input);
            self
        }
        /// <p> Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. </p>
        pub fn set_data_sharing_preference(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorDataSharingPreference>,
        ) -> Self {
            self.inner = self.inner.set_data_sharing_preference(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCollection`.
    ///
    /// <p>Deletes the specified collection. Note that this operation removes all faces in the collection. For an example, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/delete-collection-procedure.html">Deleting a collection</a>.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DeleteCollection</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_collection_input::Builder,
    }
    impl DeleteCollection {
        /// Creates a new `DeleteCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the collection to delete.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>ID of the collection to delete.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes an existing Amazon Rekognition Custom Labels dataset. Deleting a dataset might take while. Use <code>DescribeDataset</code> to check the current status. The dataset is still deleting if the value of <code>Status</code> is <code>DELETE_IN_PROGRESS</code>. If you try to access the dataset after it is deleted, you get a <code>ResourceNotFoundException</code> exception. </p>
    /// <p>You can't delete a dataset while it is creating (<code>Status</code> = <code>CREATE_IN_PROGRESS</code>) or if the dataset is updating (<code>Status</code> = <code>UPDATE_IN_PROGRESS</code>).</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DeleteDataset</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl DeleteDataset {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the Amazon Rekognition Custom Labels dataset that you want to delete. </p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(input.into());
            self
        }
        /// <p> The ARN of the Amazon Rekognition Custom Labels dataset that you want to delete. </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFaces`.
    ///
    /// <p>Deletes faces from a collection. You specify a collection ID and an array of face IDs to remove from the collection.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DeleteFaces</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_faces_input::Builder,
    }
    impl DeleteFaces {
        /// Creates a new `DeleteFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Collection from which to remove the specific faces.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>Collection from which to remove the specific faces.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// Appends an item to `FaceIds`.
        ///
        /// To override the contents of this collection use [`set_face_ids`](Self::set_face_ids).
        ///
        /// <p>An array of face IDs to delete.</p>
        pub fn face_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.face_ids(input.into());
            self
        }
        /// <p>An array of face IDs to delete.</p>
        pub fn set_face_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_face_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an Amazon Rekognition Custom Labels project. To delete a project you must first delete all models associated with the project. To delete a model, see <code>DeleteProjectVersion</code>.</p>
    /// <p> <code>DeleteProject</code> is an asynchronous operation. To check if the project is deleted, call <code>DescribeProjects</code>. The project is deleted when the project no longer appears in the response.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DeleteProject</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl DeleteProject {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project that you want to delete.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project that you want to delete.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProjectVersion`.
    ///
    /// <p>Deletes an Amazon Rekognition Custom Labels model. </p>
    /// <p>You can't delete a model if it is running or if it is training. To check the status of a model, use the <code>Status</code> field returned from <code>DescribeProjectVersions</code>. To stop a running model call <code>StopProjectVersion</code>. If the model is training, wait until it finishes.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DeleteProjectVersion</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProjectVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_project_version_input::Builder,
    }
    impl DeleteProjectVersion {
        /// Creates a new `DeleteProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        pub fn project_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamProcessor`.
    ///
    /// <p>Deletes the stream processor identified by <code>Name</code>. You assign the value for <code>Name</code> when you create the stream processor with <code>CreateStreamProcessor</code>. You might not be able to use the same name for a stream processor for a few seconds after calling <code>DeleteStreamProcessor</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStreamProcessor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_stream_processor_input::Builder,
    }
    impl DeleteStreamProcessor {
        /// Creates a new `DeleteStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamProcessorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream processor you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the stream processor you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCollection`.
    ///
    /// <p>Describes the specified collection. You can use <code>DescribeCollection</code> to get information, such as the number of faces indexed into a collection and the version of the model used by the collection for face detection.</p>
    /// <p>For more information, see Describing a Collection in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_collection_input::Builder,
    }
    impl DescribeCollection {
        /// Creates a new `DescribeCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the collection to describe.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>The ID of the collection to describe.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p> Describes an Amazon Rekognition Custom Labels dataset. You can get information such as the current status of a dataset and statistics about the images and labels in a dataset. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DescribeDataset</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl DescribeDataset {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the dataset that you want to describe. </p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the dataset that you want to describe. </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProjects`.
    ///
    /// <p>Gets information about your Amazon Rekognition Custom Labels projects. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DescribeProjects</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_projects_input::Builder,
    }
    impl DescribeProjects {
        /// Creates a new `DescribeProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeProjectsPaginator {
            crate::paginator::DescribeProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `ProjectNames`.
        ///
        /// To override the contents of this collection use [`set_project_names`](Self::set_project_names).
        ///
        /// <p>A list of the projects that you want Amazon Rekognition Custom Labels to describe. If you don't specify a value, the response includes descriptions for all the projects in your AWS account.</p>
        pub fn project_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_names(input.into());
            self
        }
        /// <p>A list of the projects that you want Amazon Rekognition Custom Labels to describe. If you don't specify a value, the response includes descriptions for all the projects in your AWS account.</p>
        pub fn set_project_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_project_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProjectVersions`.
    ///
    /// <p>Lists and describes the versions of a model in an Amazon Rekognition Custom Labels project. You can specify up to 10 model versions in <code>ProjectVersionArns</code>. If you don't specify a value, descriptions for all model versions in the project are returned.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DescribeProjectVersions</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProjectVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_project_versions_input::Builder,
    }
    impl DescribeProjectVersions {
        /// Creates a new `DescribeProjectVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeProjectVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeProjectVersionsPaginator {
            crate::paginator::DescribeProjectVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the project that contains the models you want to describe.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project that contains the models you want to describe.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// Appends an item to `VersionNames`.
        ///
        /// To override the contents of this collection use [`set_version_names`](Self::set_version_names).
        ///
        /// <p>A list of model version names that you want to describe. You can add up to 10 model version names to the list. If you don't specify a value, all model descriptions are returned. A version name is part of a model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the following ARN. <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>.</p>
        pub fn version_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_names(input.into());
            self
        }
        /// <p>A list of model version names that you want to describe. You can add up to 10 model version names to the list. If you don't specify a value, all model descriptions are returned. A version name is part of a model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the following ARN. <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>.</p>
        pub fn set_version_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_names(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStreamProcessor`.
    ///
    /// <p>Provides information about a stream processor created by <code>CreateStreamProcessor</code>. You can get information about the input and output streams, the input parameters for the face recognition being performed, and the current status of the stream processor.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStreamProcessor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_stream_processor_input::Builder,
    }
    impl DescribeStreamProcessor {
        /// Creates a new `DescribeStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStreamProcessorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the stream processor for which you want information.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of the stream processor for which you want information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectCustomLabels`.
    ///
    /// <p>Detects custom labels in a supplied image by using an Amazon Rekognition Custom Labels model. </p>
    /// <p>You specify which version of a model version to use by using the <code>ProjectVersionArn</code> input parameter. </p>
    /// <p>You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p>
    /// <p> For each object that the model version detects on an image, the API returns a (<code>CustomLabel</code>) object in an array (<code>CustomLabels</code>). Each <code>CustomLabel</code> object provides the label name (<code>Name</code>), the level of confidence that the image contains the object (<code>Confidence</code>), and object location information, if it exists, for the label on the image (<code>Geometry</code>). </p>
    /// <p>To filter labels that are returned, specify a value for <code>MinConfidence</code>. <code>DetectCustomLabelsLabels</code> only returns labels with a confidence that's higher than the specified value. The value of <code>MinConfidence</code> maps to the assumed threshold values created during training. For more information, see <i>Assumed threshold</i> in the Amazon Rekognition Custom Labels Developer Guide. Amazon Rekognition Custom Labels metrics expresses an assumed threshold as a floating point value between 0-1. The range of <code>MinConfidence</code> normalizes the threshold value to a percentage value (0-100). Confidence responses from <code>DetectCustomLabels</code> are also returned as a percentage. You can use <code>MinConfidence</code> to change the precision and recall or your model. For more information, see <i>Analyzing an image</i> in the Amazon Rekognition Custom Labels Developer Guide. </p>
    /// <p>If you don't specify a value for <code>MinConfidence</code>, <code>DetectCustomLabels</code> returns labels based on the assumed threshold of each label.</p>
    /// <p>This is a stateless API operation. That is, the operation does not persist any data.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DetectCustomLabels</code> action. </p>
    /// <p>For more information, see <i>Analyzing an image</i> in the Amazon Rekognition Custom Labels Developer Guide. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectCustomLabels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_custom_labels_input::Builder,
    }
    impl DetectCustomLabels {
        /// Creates a new `DetectCustomLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectCustomLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectCustomLabelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the model version that you want to use.</p>
        pub fn project_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(input.into());
            self
        }
        /// <p>The ARN of the model version that you want to use.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
        /// <p>Provides the input image either as bytes or an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Rekognition API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass an image loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations. </p>
        /// <p>For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.</p>
        /// <p> You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the <code>S3Object</code> property. Images stored in an S3 bucket do not need to be base64-encoded.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.</p>
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide. </p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>Provides the input image either as bytes or an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Rekognition API operation by using the <code>Bytes</code> property. For example, you would use the <code>Bytes</code> property to pass an image loaded from a local file system. Image bytes passed by using the <code>Bytes</code> property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations. </p>
        /// <p>For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.</p>
        /// <p> You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the <code>S3Object</code> property. Images stored in an S3 bucket do not need to be base64-encoded.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.</p>
        /// <p>If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.</p>
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide. </p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Maximum number of results you want the service to return in the response. The service returns the specified number of highest confidence labels ranked from highest confidence to lowest.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results you want the service to return in the response. The service returns the specified number of highest confidence labels ranked from highest confidence to lowest.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. <code>DetectCustomLabels</code> doesn't return any labels with a confidence value that's lower than this specified value. If you specify a value of 0, <code>DetectCustomLabels</code> returns all labels, regardless of the assumed threshold applied to each label. If you don't specify a value for <code>MinConfidence</code>, <code>DetectCustomLabels</code> returns labels based on the assumed threshold of each label.</p>
        pub fn min_confidence(mut self, input: f32) -> Self {
            self.inner = self.inner.min_confidence(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. <code>DetectCustomLabels</code> doesn't return any labels with a confidence value that's lower than this specified value. If you specify a value of 0, <code>DetectCustomLabels</code> returns all labels, regardless of the assumed threshold applied to each label. If you don't specify a value for <code>MinConfidence</code>, <code>DetectCustomLabels</code> returns labels based on the assumed threshold of each label.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectFaces`.
    ///
    /// <p>Detects faces within an image that is provided as input.</p>
    /// <p> <code>DetectFaces</code> detects the 100 largest faces in the image. For each face detected, the operation returns face details. These details include a bounding box of the face, a confidence value (that the bounding box contains a face), and a fixed set of attributes such as facial landmarks (for example, coordinates of eye and mouth), presence of beard, sunglasses, and so on. </p>
    /// <p>The face-detection algorithm is most effective on frontal faces. For non-frontal or obscured faces, the algorithm might not detect the faces or might detect faces with lower confidence. </p>
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p> <note>
    /// <p>This is a stateless API operation. That is, the operation does not persist any data.</p>
    /// </note>
    /// <p>This operation requires permissions to perform the <code>rekognition:DetectFaces</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectFaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_faces_input::Builder,
    }
    impl DetectFaces {
        /// Creates a new `DetectFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectFacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>An array of facial attributes you want to be returned. This can be the default list of attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>An array of facial attributes you want to be returned. This can be the default list of attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectLabels`.
    ///
    /// <p>Detects instances of real-world entities within an image (JPEG or PNG) provided as input. This includes objects like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape, evening, and nature. </p>
    /// <p>For an example, see Analyzing images stored in an Amazon S3 bucket in the Amazon Rekognition Developer Guide.</p> <note>
    /// <p> <code>DetectLabels</code> does not support the detection of activities. However, activity detection is supported for label detection in videos. For more information, see StartLabelDetection in the Amazon Rekognition Developer Guide.</p>
    /// </note>
    /// <p>You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p>
    /// <p> For each object, scene, and concept the API returns one or more labels. Each label provides the object name, and the level of confidence that the image contains the object. For example, suppose the input image has a lighthouse, the sea, and a rock. The response includes all three labels, one for each object. </p>
    /// <p> <code>{Name: lighthouse, Confidence: 98.4629}</code> </p>
    /// <p> <code>{Name: rock,Confidence: 79.2097}</code> </p>
    /// <p> <code> {Name: sea,Confidence: 75.061}</code> </p>
    /// <p>In the preceding example, the operation returns one label for each of the three objects. The operation can also return multiple labels for the same object in the image. For example, if the input image shows a flower (for example, a tulip), the operation might return the following three labels. </p>
    /// <p> <code>{Name: flower,Confidence: 99.0562}</code> </p>
    /// <p> <code>{Name: plant,Confidence: 99.0562}</code> </p>
    /// <p> <code>{Name: tulip,Confidence: 99.0562}</code> </p>
    /// <p>In this example, the detection algorithm more precisely identifies the flower as a tulip.</p>
    /// <p>In response, the API returns an array of labels. In addition, the response also includes the orientation correction. Optionally, you can specify <code>MinConfidence</code> to control the confidence threshold for the labels returned. The default is 55%. You can also add the <code>MaxLabels</code> parameter to limit the number of labels returned. </p> <note>
    /// <p>If the object detected is a person, the operation doesn't provide the same facial details that the <code>DetectFaces</code> operation provides.</p>
    /// </note>
    /// <p> <code>DetectLabels</code> returns bounding boxes for instances of common object labels in an array of <code>Instance</code> objects. An <code>Instance</code> object contains a <code>BoundingBox</code> object, for the location of the label on the image. It also includes the confidence by which the bounding box was detected.</p>
    /// <p> <code>DetectLabels</code> also returns a hierarchical taxonomy of detected labels. For example, a detected car might be assigned the label <i>car</i>. The label <i>car</i> has two parent labels: <i>Vehicle</i> (its parent) and <i>Transportation</i> (its grandparent). The response returns the entire list of ancestors for a label. Each ancestor is a unique label in the response. In the previous example, <i>Car</i>, <i>Vehicle</i>, and <i>Transportation</i> are returned as unique labels in the response. </p>
    /// <p>This is a stateless API operation. That is, the operation does not persist any data.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DetectLabels</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectLabels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_labels_input::Builder,
    }
    impl DetectLabels {
        /// Creates a new `DetectLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectLabelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be base64-encoded.</p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do not need to be base64-encoded.</p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Maximum number of labels you want the service to return in the response. The service returns the specified number of highest confidence labels. </p>
        pub fn max_labels(mut self, input: i32) -> Self {
            self.inner = self.inner.max_labels(input);
            self
        }
        /// <p>Maximum number of labels you want the service to return in the response. The service returns the specified number of highest confidence labels. </p>
        pub fn set_max_labels(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_labels(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with confidence lower than this specified value.</p>
        /// <p>If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values greater than or equal to 55 percent.</p>
        pub fn min_confidence(mut self, input: f32) -> Self {
            self.inner = self.inner.min_confidence(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with confidence lower than this specified value.</p>
        /// <p>If <code>MinConfidence</code> is not specified, the operation returns labels with a confidence values greater than or equal to 55 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectModerationLabels`.
    ///
    /// <p>Detects unsafe content in a specified JPEG or PNG format image. Use <code>DetectModerationLabels</code> to moderate images depending on your requirements. For example, you might want to filter images that contain nudity, but not images containing suggestive content.</p>
    /// <p>To filter images, use the labels returned by <code>DetectModerationLabels</code> to determine which types of content are appropriate.</p>
    /// <p>For information about moderation labels, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.</p>
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectModerationLabels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_moderation_labels_input::Builder,
    }
    impl DetectModerationLabels {
        /// Creates a new `DetectModerationLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectModerationLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectModerationLabelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn min_confidence(mut self, input: f32) -> Self {
            self.inner = self.inner.min_confidence(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
        /// <p>Sets up the configuration for human evaluation, including the FlowDefinition the image will be sent to.</p>
        pub fn human_loop_config(mut self, input: crate::model::HumanLoopConfig) -> Self {
            self.inner = self.inner.human_loop_config(input);
            self
        }
        /// <p>Sets up the configuration for human evaluation, including the FlowDefinition the image will be sent to.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.inner = self.inner.set_human_loop_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectProtectiveEquipment`.
    ///
    /// <p>Detects Personal Protective Equipment (PPE) worn by people detected in an image. Amazon Rekognition can detect the following types of PPE.</p>
    /// <ul>
    /// <li> <p>Face cover</p> </li>
    /// <li> <p>Hand cover</p> </li>
    /// <li> <p>Head cover</p> </li>
    /// </ul>
    /// <p>You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. The image must be either a PNG or JPG formatted file. </p>
    /// <p> <code>DetectProtectiveEquipment</code> detects PPE worn by up to 15 persons detected in an image.</p>
    /// <p>For each person detected in the image the API returns an array of body parts (face, head, left-hand, right-hand). For each body part, an array of detected items of PPE is returned, including an indicator of whether or not the PPE covers the body part. The API returns the confidence it has in each detection (person, PPE, body part and body part coverage). It also returns a bounding box (<code>BoundingBox</code>) for each detected person and each detected item of PPE. </p>
    /// <p>You can optionally request a summary of detected PPE items with the <code>SummarizationAttributes</code> input parameter. The summary provides the following information. </p>
    /// <ul>
    /// <li> <p>The persons detected as wearing all of the types of PPE that you specify.</p> </li>
    /// <li> <p>The persons detected as not wearing all of the types PPE that you specify.</p> </li>
    /// <li> <p>The persons detected where PPE adornment could not be determined. </p> </li>
    /// </ul>
    /// <p>This is a stateless API operation. That is, the operation does not persist any data.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DetectProtectiveEquipment</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectProtectiveEquipment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_protective_equipment_input::Builder,
    }
    impl DetectProtectiveEquipment {
        /// Creates a new `DetectProtectiveEquipment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectProtectiveEquipmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectProtectiveEquipmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you can reference an image stored in an Amazon S3 bucket. </p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you can reference an image stored in an Amazon S3 bucket. </p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>An array of PPE types that you want to summarize.</p>
        pub fn summarization_attributes(
            mut self,
            input: crate::model::ProtectiveEquipmentSummarizationAttributes,
        ) -> Self {
            self.inner = self.inner.summarization_attributes(input);
            self
        }
        /// <p>An array of PPE types that you want to summarize.</p>
        pub fn set_summarization_attributes(
            mut self,
            input: std::option::Option<crate::model::ProtectiveEquipmentSummarizationAttributes>,
        ) -> Self {
            self.inner = self.inner.set_summarization_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectText`.
    ///
    /// <p>Detects text in the input image and converts it into machine-readable text.</p>
    /// <p>Pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, you must pass it as a reference to an image in an Amazon S3 bucket. For the AWS CLI, passing image bytes is not supported. The image must be either a .png or .jpeg formatted file. </p>
    /// <p>The <code>DetectText</code> operation returns text in an array of <code>TextDetection</code> elements, <code>TextDetections</code>. Each <code>TextDetection</code> element provides information about a single word or line of text that was detected in the image. </p>
    /// <p>A word is one or more script characters that are not separated by spaces. <code>DetectText</code> can detect up to 100 words in an image.</p>
    /// <p>A line is a string of equally spaced words. A line isn't necessarily a complete sentence. For example, a driver's license number is detected as a line. A line ends when there is no aligned text after it. Also, a line ends when there is a large gap between words, relative to the length of the words. This means, depending on the gap between words, Amazon Rekognition may detect multiple lines in text aligned in the same direction. Periods don't represent the end of a line. If a sentence spans multiple lines, the <code>DetectText</code> operation returns multiple lines.</p>
    /// <p>To determine whether a <code>TextDetection</code> element is a line of text or a word, use the <code>TextDetection</code> object <code>Type</code> field. </p>
    /// <p>To be detected, text must be within +/- 90 degrees orientation of the horizontal axis.</p>
    /// <p>For more information, see Detecting text in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DetectText {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_text_input::Builder,
    }
    impl DetectText {
        /// Creates a new `DetectText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectTextOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectTextError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Rekognition operations, you can't pass image bytes. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI to call Amazon Rekognition operations, you can't pass image bytes. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Optional parameters that let you set the criteria that the text must meet to be included in your response.</p>
        pub fn filters(mut self, input: crate::model::DetectTextFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional parameters that let you set the criteria that the text must meet to be included in your response.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DetectTextFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DistributeDatasetEntries`.
    ///
    /// <p>Distributes the entries (images) in a training dataset across the training dataset and the test dataset for a project. <code>DistributeDatasetEntries</code> moves 20% of the training dataset images to the test dataset. An entry is a JSON Line that describes an image. </p>
    /// <p>You supply the Amazon Resource Names (ARN) of a project's training dataset and test dataset. The training dataset must contain the images that you want to split. The test dataset must be empty. The datasets must belong to the same project. To create training and test datasets for a project, call <code>CreateDataset</code>.</p>
    /// <p>Distributing a dataset takes a while to complete. To check the status call <code>DescribeDataset</code>. The operation is complete when the <code>Status</code> field for the training dataset and the test dataset is <code>UPDATE_COMPLETE</code>. If the dataset split fails, the value of <code>Status</code> is <code>UPDATE_FAILED</code>.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DistributeDatasetEntries</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DistributeDatasetEntries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::distribute_dataset_entries_input::Builder,
    }
    impl DistributeDatasetEntries {
        /// Creates a new `DistributeDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DistributeDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DistributeDatasetEntriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// <p>The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the same project. The test dataset must be empty. </p>
        pub fn datasets(mut self, input: crate::model::DistributeDataset) -> Self {
            self.inner = self.inner.datasets(input);
            self
        }
        /// <p>The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to the same project. The test dataset must be empty. </p>
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DistributeDataset>>,
        ) -> Self {
            self.inner = self.inner.set_datasets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCelebrityInfo`.
    ///
    /// <p>Gets the name and additional information about a celebrity based on their Amazon Rekognition ID. The additional information is returned as an array of URLs. If there is no additional information about the celebrity, this list is empty.</p>
    /// <p>For more information, see Getting information about a celebrity in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:GetCelebrityInfo</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCelebrityInfo {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_celebrity_info_input::Builder,
    }
    impl GetCelebrityInfo {
        /// Creates a new `GetCelebrityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCelebrityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCelebrityInfoError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the celebrity. You get the celebrity ID from a call to the <code>RecognizeCelebrities</code> operation, which recognizes celebrities in an image. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID for the celebrity. You get the celebrity ID from a call to the <code>RecognizeCelebrities</code> operation, which recognizes celebrities in an image. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCelebrityRecognition`.
    ///
    /// <p>Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by <code>StartCelebrityRecognition</code>.</p>
    /// <p>Celebrity recognition in a video is an asynchronous operation. Analysis is started by a call to <code>StartCelebrityRecognition</code> which returns a job identifier (<code>JobId</code>). </p>
    /// <p>When the celebrity recognition operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartCelebrityRecognition</code>. To get the results of the celebrity recognition analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetCelebrityDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartCelebrityDetection</code>. </p>
    /// <p>For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.</p>
    /// <p> <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they are detected in an array (<code>Celebrities</code>) of <code>CelebrityRecognition</code> objects. Each <code>CelebrityRecognition</code> contains information about the celebrity in a <code>CelebrityDetail</code> object and the time, <code>Timestamp</code>, the celebrity was detected. This <code>CelebrityDetail</code> object stores information about the detected celebrity's face attributes, a face bounding box, known gender, the celebrity's name, and a confidence estimate.</p> <note>
    /// <p> <code>GetCelebrityRecognition</code> only returns the default facial attributes (<code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The <code>BoundingBox</code> field only applies to the detected face instance. The other facial attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more information, see FaceDetail in the Amazon Rekognition Developer Guide. </p>
    /// </note>
    /// <p>By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video). You can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input parameter.</p>
    /// <p>The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you don't store the additional information urls, you can get them later by calling <code>GetCelebrityInfo</code> with the celebrity identifer.</p>
    /// <p>No information is returned for faces not recognized as celebrities.</p>
    /// <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetCelebrityDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetCelebrityRecognition</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCelebrityRecognition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_celebrity_recognition_input::Builder,
    }
    impl GetCelebrityRecognition {
        /// Creates a new `GetCelebrityRecognition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCelebrityRecognitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCelebrityRecognitionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCelebrityRecognitionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCelebrityRecognitionPaginator {
            crate::paginator::GetCelebrityRecognitionPaginator::new(self.handle, self.inner)
        }
        /// <p>Job identifier for the required celebrity recognition analysis. You can get the job identifer from a call to <code>StartCelebrityRecognition</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>Job identifier for the required celebrity recognition analysis. You can get the job identifer from a call to <code>StartCelebrityRecognition</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more recognized celebrities to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of celebrities. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more recognized celebrities to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of celebrities. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for celebrities returned in <code>Celebrities</code> field. Specify <code>ID</code> to sort by the celebrity identifier, specify <code>TIMESTAMP</code> to sort by the time the celebrity was recognized.</p>
        pub fn sort_by(mut self, input: crate::model::CelebrityRecognitionSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Sort to use for celebrities returned in <code>Celebrities</code> field. Specify <code>ID</code> to sort by the celebrity identifier, specify <code>TIMESTAMP</code> to sort by the time the celebrity was recognized.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::CelebrityRecognitionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContentModeration`.
    ///
    /// <p>Gets the inappropriate, unwanted, or offensive content analysis results for a Amazon Rekognition Video analysis started by <code>StartContentModeration</code>. For a list of moderation labels in Amazon Rekognition, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api">Using the image and video moderation APIs</a>.</p>
    /// <p>Amazon Rekognition Video inappropriate or offensive content detection in a stored video is an asynchronous operation. You start analysis by calling <code>StartContentModeration</code> which returns a job identifier (<code>JobId</code>). When analysis finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartContentModeration</code>. To get the results of the content analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetContentModeration</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartContentModeration</code>. </p>
    /// <p>For more information, see Working with Stored Videos in the Amazon Rekognition Devlopers Guide.</p>
    /// <p> <code>GetContentModeration</code> returns detected inappropriate, unwanted, or offensive content moderation labels, and the time they are detected, in an array, <code>ModerationLabels</code>, of <code>ContentModerationDetection</code> objects. </p>
    /// <p>By default, the moderated labels are returned sorted by time, in milliseconds from the start of the video. You can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code> input parameter. </p>
    /// <p>Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit the number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetContentModeration</code> and populate the <code>NextToken</code> request parameter with the value of <code>NextToken</code> returned from the previous call to <code>GetContentModeration</code>.</p>
    /// <p>For more information, see moderating content in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContentModeration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_content_moderation_input::Builder,
    }
    impl GetContentModeration {
        /// Creates a new `GetContentModeration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContentModerationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContentModerationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetContentModerationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetContentModerationPaginator {
            crate::paginator::GetContentModerationPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the inappropriate, unwanted, or offensive content moderation job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetContentModeration</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier for the inappropriate, unwanted, or offensive content moderation job. Use <code>JobId</code> to identify the job in a subsequent call to <code>GetContentModeration</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of content moderation labels.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of content moderation labels.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for elements in the <code>ModerationLabelDetections</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn sort_by(mut self, input: crate::model::ContentModerationSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Sort to use for elements in the <code>ModerationLabelDetections</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ContentModerationSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFaceDetection`.
    ///
    /// <p>Gets face detection results for a Amazon Rekognition Video analysis started by <code>StartFaceDetection</code>.</p>
    /// <p>Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling <code>StartFaceDetection</code> which returns a job identifier (<code>JobId</code>). When the face detection operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartFaceDetection</code>. To get the results of the face detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.</p>
    /// <p> <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the faces were detected. </p>
    /// <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetFaceDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetFaceDetection</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFaceDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_face_detection_input::Builder,
    }
    impl GetFaceDetection {
        /// Creates a new `GetFaceDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFaceDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFaceDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetFaceDetectionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetFaceDetectionPaginator {
            crate::paginator::GetFaceDetectionPaginator::new(self.handle, self.inner)
        }
        /// <p>Unique identifier for the face detection job. The <code>JobId</code> is returned from <code>StartFaceDetection</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>Unique identifier for the face detection job. The <code>JobId</code> is returned from <code>StartFaceDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more faces to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more faces to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFaceSearch`.
    ///
    /// <p>Gets the face search results for Amazon Rekognition Video face search started by <code>StartFaceSearch</code>. The search returns faces in a collection that match the faces of persons detected in a video. It also includes the time(s) that faces are matched in the video.</p>
    /// <p>Face search in a video is an asynchronous operation. You start face search by calling to <code>StartFaceSearch</code> which returns a job identifier (<code>JobId</code>). When the search operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartFaceSearch</code>. To get the search results, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.</p>
    /// <p>For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.</p>
    /// <p>The search results are retured in an array, <code>Persons</code>, of <code>PersonMatch</code> objects. Each<code>PersonMatch</code> element contains details about the matching faces in the input collection, person information (facial attributes, bounding boxes, and person identifer) for the matched person, and the time the person was matched in the video.</p> <note>
    /// <p> <code>GetFaceSearch</code> only returns the default facial attributes (<code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial attributes listed in the <code>Face</code> object of the following response syntax are not returned. For more information, see FaceDetail in the Amazon Rekognition Developer Guide. </p>
    /// </note>
    /// <p>By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the start of the video, persons are matched. You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code> input parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFaceSearch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_face_search_input::Builder,
    }
    impl GetFaceSearch {
        /// Creates a new `GetFaceSearch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFaceSearchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFaceSearchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetFaceSearchPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetFaceSearchPaginator {
            crate::paginator::GetFaceSearchPaginator::new(self.handle, self.inner)
        }
        /// <p>The job identifer for the search request. You get the job identifier from an initial call to <code>StartFaceSearch</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The job identifer for the search request. You get the job identifier from an initial call to <code>StartFaceSearch</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of search results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of search results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that they are recognized. Use <code>INDEX</code> to sort by recognized faces. </p>
        pub fn sort_by(mut self, input: crate::model::FaceSearchSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time that they are recognized. Use <code>INDEX</code> to sort by recognized faces. </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::FaceSearchSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLabelDetection`.
    ///
    /// <p>Gets the label detection results of a Amazon Rekognition Video analysis started by <code>StartLabelDetection</code>. </p>
    /// <p>The label detection operation is started by a call to <code>StartLabelDetection</code> which returns a job identifier (<code>JobId</code>). When the label detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartlabelDetection</code>. To get the results of the label detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetLabelDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.</p>
    /// <p> <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time the labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the <code>SortBy</code> input parameter.</p>
    /// <p>The labels returned include the label name, the percentage confidence in the accuracy of the detected label, and the time the label was detected in the video.</p>
    /// <p>The returned labels also include bounding box information for common objects, a hierarchical taxonomy of detected labels, and the version of the label model used for detection.</p>
    /// <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetlabelDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetLabelDetection</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLabelDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_label_detection_input::Builder,
    }
    impl GetLabelDetection {
        /// Creates a new `GetLabelDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLabelDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLabelDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLabelDetectionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLabelDetectionPaginator {
            crate::paginator::GetLabelDetectionPaginator::new(self.handle, self.inner)
        }
        /// <p>Job identifier for the label detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartlabelDetection</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>Job identifier for the label detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartlabelDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of labels. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of labels. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn sort_by(mut self, input: crate::model::LabelDetectionSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Sort to use for elements in the <code>Labels</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected. Use <code>NAME</code> to alphabetically group elements for a label together. Within each label group, the array element are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::LabelDetectionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPersonTracking`.
    ///
    /// <p>Gets the path tracking results of a Amazon Rekognition Video analysis started by <code>StartPersonTracking</code>.</p>
    /// <p>The person path tracking operation is started by a call to <code>StartPersonTracking</code> which returns a job identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartPersonTracking</code>.</p>
    /// <p>To get the results of the person path tracking operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetPersonTracking</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.</p>
    /// <p> <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their paths were tracked in the video. </p> <note>
    /// <p> <code>GetPersonTracking</code> only returns the default facial attributes (<code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial attributes listed in the <code>Face</code> object of the following response syntax are not returned. </p>
    /// <p>For more information, see FaceDetail in the Amazon Rekognition Developer Guide.</p>
    /// </note>
    /// <p>By default, the array is sorted by the time(s) a person's path is tracked in the video. You can sort by tracked persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.</p>
    /// <p>Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetPersonTracking</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPersonTracking {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_person_tracking_input::Builder,
    }
    impl GetPersonTracking {
        /// Creates a new `GetPersonTracking`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPersonTrackingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPersonTrackingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetPersonTrackingPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetPersonTrackingPaginator {
            crate::paginator::GetPersonTrackingPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for a job that tracks persons in a video. You get the <code>JobId</code> from a call to <code>StartPersonTracking</code>. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The identifier for a job that tracks persons in a video. You get the <code>JobId</code> from a call to <code>StartPersonTracking</code>. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more persons to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of persons. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more persons to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of persons. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for elements in the <code>Persons</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time persons are detected. Use <code>INDEX</code> to sort by the tracked persons. If you sort by <code>INDEX</code>, the array elements for each person are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn sort_by(mut self, input: crate::model::PersonTrackingSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Sort to use for elements in the <code>Persons</code> array. Use <code>TIMESTAMP</code> to sort array elements by the time persons are detected. Use <code>INDEX</code> to sort by the tracked persons. If you sort by <code>INDEX</code>, the array elements for each person are sorted by detection confidence. The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::PersonTrackingSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentDetection`.
    ///
    /// <p>Gets the segment detection results of a Amazon Rekognition Video analysis started by <code>StartSegmentDetection</code>.</p>
    /// <p>Segment detection with Amazon Rekognition Video is an asynchronous operation. You start segment detection by calling <code>StartSegmentDetection</code> which returns a job identifier (<code>JobId</code>). When the segment detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartSegmentDetection</code>. To get the results of the segment detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <code>GetSegmentDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call of <code>StartSegmentDetection</code>.</p>
    /// <p> <code>GetSegmentDetection</code> returns detected segments in an array (<code>Segments</code>) of <code>SegmentDetection</code> objects. <code>Segments</code> is sorted by the segment types specified in the <code>SegmentTypes</code> input parameter of <code>StartSegmentDetection</code>. Each element of the array includes the detected segment, the precentage confidence in the acuracy of the detected segment, the type of the segment, and the frame in which the segment was detected.</p>
    /// <p>Use <code>SelectedSegmentTypes</code> to find out the type of segment detection requested in the call to <code>StartSegmentDetection</code>.</p>
    /// <p>Use the <code>MaxResults</code> parameter to limit the number of segment detections returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetSegmentDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetSegmentDetection</code>.</p>
    /// <p>For more information, see Detecting video segments in stored video in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSegmentDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_segment_detection_input::Builder,
    }
    impl GetSegmentDetection {
        /// Creates a new `GetSegmentDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSegmentDetectionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSegmentDetectionPaginator {
            crate::paginator::GetSegmentDetectionPaginator::new(self.handle, self.inner)
        }
        /// <p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartSegmentDetection</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartSegmentDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of text.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent request to retrieve the next set of text.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTextDetection`.
    ///
    /// <p>Gets the text detection results of a Amazon Rekognition Video analysis started by <code>StartTextDetection</code>.</p>
    /// <p>Text detection with Amazon Rekognition Video is an asynchronous operation. You start text detection by calling <code>StartTextDetection</code> which returns a job identifier (<code>JobId</code>) When the text detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to <code>StartTextDetection</code>. To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <code>GetTextDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call of <code>StartLabelDetection</code>.</p>
    /// <p> <code>GetTextDetection</code> returns an array of detected text (<code>TextDetections</code>) sorted by the time the text was detected, up to 50 words per frame of video.</p>
    /// <p>Each element of the array includes the detected text, the precentage confidence in the acuracy of the detected text, the time the text was detected, bounding box information for where the text was located, and unique identifiers for words and their lines.</p>
    /// <p>Use MaxResults parameter to limit the number of text detections returned. If there are more results than specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call <code>GetTextDetection</code> and populate the <code>NextToken</code> request parameter with the token value returned from the previous call to <code>GetTextDetection</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTextDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_text_detection_input::Builder,
    }
    impl GetTextDetection {
        /// Creates a new `GetTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTextDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetTextDetectionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetTextDetectionPaginator {
            crate::paginator::GetTextDetectionPaginator::new(self.handle, self.inner)
        }
        /// <p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartTextDetection</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>Job identifier for the text detection operation for which you want results returned. You get the job identifer from an initial call to <code>StartTextDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `IndexFaces`.
    ///
    /// <p>Detects faces in the input image and adds them to the specified collection. </p>
    /// <p>Amazon Rekognition doesn't save the actual faces that are detected. Instead, the underlying detection algorithm first detects the faces in the input image. For each face, the algorithm extracts facial features into a feature vector, and stores it in the backend database. Amazon Rekognition uses feature vectors when it performs face match and search operations using the <code>SearchFaces</code> and <code>SearchFacesByImage</code> operations.</p>
    /// <p>For more information, see Adding faces to a collection in the Amazon Rekognition Developer Guide.</p>
    /// <p>To get the number of faces in a collection, call <code>DescribeCollection</code>. </p>
    /// <p>If you're using version 1.0 of the face detection model, <code>IndexFaces</code> indexes the 15 largest faces in the input image. Later versions of the face detection model index the 100 largest faces in the input image. </p>
    /// <p>If you're using version 4 or later of the face model, image orientation information is not returned in the <code>OrientationCorrection</code> field. </p>
    /// <p>To determine which version of the model you're using, call <code>DescribeCollection</code> and supply the collection ID. You can also get the model version from the value of <code>FaceModelVersion</code> in the response from <code>IndexFaces</code> </p>
    /// <p>For more information, see Model Versioning in the Amazon Rekognition Developer Guide.</p>
    /// <p>If you provide the optional <code>ExternalImageId</code> for the input image you provided, Amazon Rekognition associates this ID with all faces that it detects. When you call the <code>ListFaces</code> operation, the response returns the external ID. You can use this external image ID to create a client-side index to associate the faces with each image. You can then use the index to find all faces in an image.</p>
    /// <p>You can specify the maximum number of faces to index with the <code>MaxFaces</code> input parameter. This is useful when you want to index the largest faces in an image and don't want to index smaller faces, such as those belonging to people standing in the background.</p>
    /// <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required quality bar. The quality bar is based on a variety of common use cases. By default, <code>IndexFaces</code> chooses the quality bar that's used to filter faces. You can also explicitly choose the quality bar. Use <code>QualityFilter</code>, to set the quality bar by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do not want to filter detected faces, specify <code>NONE</code>. </p> <note>
    /// <p>To use quality filtering, you need a collection associated with version 3 of the face model or higher. To get the version of the face model associated with a collection, call <code>DescribeCollection</code>. </p>
    /// </note>
    /// <p>Information about faces detected in an image, but not indexed, is returned in an array of <code>UnindexedFace</code> objects, <code>UnindexedFaces</code>. Faces aren't indexed for reasons such as:</p>
    /// <ul>
    /// <li> <p>The number of faces detected exceeds the value of the <code>MaxFaces</code> request parameter.</p> </li>
    /// <li> <p>The face is too small compared to the image dimensions.</p> </li>
    /// <li> <p>The face is too blurry.</p> </li>
    /// <li> <p>The image is too dark.</p> </li>
    /// <li> <p>The face has an extreme pose.</p> </li>
    /// <li> <p>The face doesn’t have enough detail to be suitable for face search.</p> </li>
    /// </ul>
    /// <p>In response, the <code>IndexFaces</code> operation returns an array of metadata for all detected faces, <code>FaceRecords</code>. This includes: </p>
    /// <ul>
    /// <li> <p>The bounding box, <code>BoundingBox</code>, of the detected face. </p> </li>
    /// <li> <p>A confidence value, <code>Confidence</code>, which indicates the confidence that the bounding box contains a face.</p> </li>
    /// <li> <p>A face ID, <code>FaceId</code>, assigned by the service for each face that's detected and stored.</p> </li>
    /// <li> <p>An image ID, <code>ImageId</code>, assigned by the service for the input image.</p> </li>
    /// </ul>
    /// <p>If you request all facial attributes (by using the <code>detectionAttributes</code> parameter), Amazon Rekognition returns detailed facial attributes, such as facial landmarks (for example, location of eye and mouth) and other facial attributes. If you provide the same image, specify the same collection, and use the same external ID in the <code>IndexFaces</code> operation, Amazon Rekognition doesn't save duplicate face metadata.</p>
    /// <p></p>
    /// <p>The input image is passed either as base64-encoded image bytes, or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes isn't supported. The image must be formatted as a PNG or JPEG file. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:IndexFaces</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct IndexFaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::index_faces_input::Builder,
    }
    impl IndexFaces {
        /// Creates a new `IndexFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::IndexFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::IndexFacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of an existing collection to which you want to add the faces that are detected in the input images.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>The ID of an existing collection to which you want to add the faces that are detected in the input images.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes isn't supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes isn't supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>The ID you want to assign to all the faces detected in the image.</p>
        pub fn external_image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_image_id(input.into());
            self
        }
        /// <p>The ID you want to assign to all the faces detected in the image.</p>
        pub fn set_external_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_image_id(input);
            self
        }
        /// Appends an item to `DetectionAttributes`.
        ///
        /// To override the contents of this collection use [`set_detection_attributes`](Self::set_detection_attributes).
        ///
        /// <p>An array of facial attributes that you want to be returned. This can be the default list of attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn detection_attributes(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.detection_attributes(input);
            self
        }
        /// <p>An array of facial attributes that you want to be returned. This can be the default list of attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn set_detection_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_detection_attributes(input);
            self
        }
        /// <p>The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal to 1. <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify a larger value for <code>MaxFaces</code>.</p>
        /// <p>If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with the lowest quality are filtered out first. If there are still more faces than the value of <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out (up to the number that's needed to satisfy the value of <code>MaxFaces</code>). Information about the unindexed faces is available in the <code>UnindexedFaces</code> array. </p>
        /// <p>The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box size to the smallest size, in descending order.</p>
        /// <p> <code>MaxFaces</code> can be used with a collection associated with any version of the face model.</p>
        pub fn max_faces(mut self, input: i32) -> Self {
            self.inner = self.inner.max_faces(input);
            self
        }
        /// <p>The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater than or equal to 1. <code>IndexFaces</code> returns no more than 100 detected faces in an image, even if you specify a larger value for <code>MaxFaces</code>.</p>
        /// <p>If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the faces with the lowest quality are filtered out first. If there are still more faces than the value of <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out (up to the number that's needed to satisfy the value of <code>MaxFaces</code>). Information about the unindexed faces is available in the <code>UnindexedFaces</code> array. </p>
        /// <p>The faces that are returned by <code>IndexFaces</code> are sorted by the largest face bounding box size to the smallest size, in descending order.</p>
        /// <p> <code>MaxFaces</code> can be used with a collection associated with any version of the face model.</p>
        pub fn set_max_faces(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_faces(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn quality_filter(mut self, input: crate::model::QualityFilter) -> Self {
            self.inner = self.inner.quality_filter(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The default value is <code>AUTO</code>. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn set_quality_filter(
            mut self,
            input: std::option::Option<crate::model::QualityFilter>,
        ) -> Self {
            self.inner = self.inner.set_quality_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCollections`.
    ///
    /// <p>Returns list of collection IDs in your account. If the result is truncated, the response also provides a <code>NextToken</code> that you can use in the subsequent request to fetch the next set of collection IDs.</p>
    /// <p>For an example, see Listing collections in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCollections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_collections_input::Builder,
    }
    impl ListCollections {
        /// Creates a new `ListCollections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCollectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCollectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCollectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCollectionsPaginator {
            crate::paginator::ListCollectionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Pagination token from the previous response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Pagination token from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of collection IDs to return. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of collection IDs to return. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetEntries`.
    ///
    /// <p> Lists the entries (images) within a dataset. An entry is a JSON Line that contains the information for a single image, including the image location, assigned labels, and object location bounding boxes. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-manifest-files.html">Creating a manifest file</a>.</p>
    /// <p>JSON Lines in the response include information about non-terminal errors found in the dataset. Non terminal errors are reported in <code>errors</code> lists within each JSON Line. The same information is reported in the training and testing validation result manifests that Amazon Rekognition Custom Labels creates during model training. </p>
    /// <p>You can filter the response in variety of ways, such as choosing which labels to return and returning JSON Lines created after a specific date. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:ListDatasetEntries</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatasetEntries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dataset_entries_input::Builder,
    }
    impl ListDatasetEntries {
        /// Creates a new `ListDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetEntriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatasetEntriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatasetEntriesPaginator {
            crate::paginator::ListDatasetEntriesPaginator::new(self.handle, self.inner)
        }
        /// <p> The Amazon Resource Name (ARN) for the dataset that you want to use. </p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the dataset that you want to use. </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// Appends an item to `ContainsLabels`.
        ///
        /// To override the contents of this collection use [`set_contains_labels`](Self::set_contains_labels).
        ///
        /// <p>Specifies a label filter for the response. The response includes an entry only if one or more of the labels in <code>ContainsLabels</code> exist in the entry. </p>
        pub fn contains_labels(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contains_labels(input.into());
            self
        }
        /// <p>Specifies a label filter for the response. The response includes an entry only if one or more of the labels in <code>ContainsLabels</code> exist in the entry. </p>
        pub fn set_contains_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_contains_labels(input);
            self
        }
        /// <p> Specify <code>true</code> to get only the JSON Lines where the image is labeled. Specify <code>false</code> to get only the JSON Lines where the image isn't labeled. If you don't specify <code>Labeled</code>, <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled images. </p>
        pub fn labeled(mut self, input: bool) -> Self {
            self.inner = self.inner.labeled(input);
            self
        }
        /// <p> Specify <code>true</code> to get only the JSON Lines where the image is labeled. Specify <code>false</code> to get only the JSON Lines where the image isn't labeled. If you don't specify <code>Labeled</code>, <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled images. </p>
        pub fn set_labeled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_labeled(input);
            self
        }
        /// <p>If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of <code>SourceRefContains</code> is part of the <code>source-ref</code> field. The <code>source-ref</code> field contains the Amazon S3 location of the image. You can use <code>SouceRefContains</code> for tasks such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.</p>
        pub fn source_ref_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ref_contains(input.into());
            self
        }
        /// <p>If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of <code>SourceRefContains</code> is part of the <code>source-ref</code> field. The <code>source-ref</code> field contains the Amazon S3 location of the image. You can use <code>SouceRefContains</code> for tasks such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.</p>
        pub fn set_source_ref_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_ref_contains(input);
            self
        }
        /// <p>Specifies an error filter for the response. Specify <code>True</code> to only include entries that have errors. </p>
        pub fn has_errors(mut self, input: bool) -> Self {
            self.inner = self.inner.has_errors(input);
            self
        }
        /// <p>Specifies an error filter for the response. Specify <code>True</code> to only include entries that have errors. </p>
        pub fn set_has_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_has_errors(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetLabels`.
    ///
    /// <p>Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels to describe images. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-labeling-images.html">Labeling images</a>. </p>
    /// <p> Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels to describe images. For more information, see Labeling images in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatasetLabels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dataset_labels_input::Builder,
    }
    impl ListDatasetLabels {
        /// Creates a new `ListDatasetLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetLabelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatasetLabelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatasetLabelsPaginator {
            crate::paginator::ListDatasetLabelsPaginator::new(self.handle, self.inner)
        }
        /// <p> The Amazon Resource Name (ARN) of the dataset that you want to use. </p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the dataset that you want to use. </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFaces`.
    ///
    /// <p>Returns metadata for faces in the specified collection. This metadata includes information such as the bounding box coordinates, the confidence (that the bounding box contains a face), and face ID. For an example, see Listing Faces in a Collection in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:ListFaces</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_faces_input::Builder,
    }
    impl ListFaces {
        /// Creates a new `ListFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFacesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFacesPaginator {
            crate::paginator::ListFacesPaginator::new(self.handle, self.inner)
        }
        /// <p>ID of the collection from which to list the faces.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>ID of the collection from which to list the faces.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of faces to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of faces to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamProcessors`.
    ///
    /// <p>Gets a list of stream processors that you have created with <code>CreateStreamProcessor</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStreamProcessors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_stream_processors_input::Builder,
    }
    impl ListStreamProcessors {
        /// Creates a new `ListStreamProcessors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamProcessorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamProcessorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStreamProcessorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStreamProcessorsPaginator {
            crate::paginator::ListStreamProcessorsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous response was incomplete (because there are more stream processors to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of stream processors. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there are more stream processors to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of stream processors. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of stream processors you want Amazon Rekognition Video to return in the response. The default is 1000. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of stream processors you want Amazon Rekognition Video to return in the response. The default is 1000. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of tags in an Amazon Rekognition collection, stream processor, or Custom Labels model. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:ListTagsForResource</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that contains the tags that you want a list of. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that contains the tags that you want a list of. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RecognizeCelebrities`.
    ///
    /// <p>Returns an array of celebrities recognized in the input image. For more information, see Recognizing celebrities in the Amazon Rekognition Developer Guide. </p>
    /// <p> <code>RecognizeCelebrities</code> returns the 64 largest faces in the image. It lists the recognized celebrities in the <code>CelebrityFaces</code> array and any unrecognized faces in the <code>UnrecognizedFaces</code> array. <code>RecognizeCelebrities</code> doesn't return celebrities whose faces aren't among the largest 64 faces in the image.</p>
    /// <p>For each celebrity recognized, <code>RecognizeCelebrities</code> returns a <code>Celebrity</code> object. The <code>Celebrity</code> object contains the celebrity name, ID, URL links to additional information, match confidence, and a <code>ComparedFace</code> object that you can use to locate the celebrity's face on the image.</p>
    /// <p>Amazon Rekognition doesn't retain information about which images a celebrity has been recognized in. Your application must store this information and use the <code>Celebrity</code> ID property as a unique identifier for the celebrity. If you don't store the celebrity name or additional information URLs returned by <code>RecognizeCelebrities</code>, you will need the ID to identify the celebrity in a call to the <code>GetCelebrityInfo</code> operation.</p>
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p>
    /// <p>For an example, see Recognizing celebrities in an image in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:RecognizeCelebrities</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RecognizeCelebrities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::recognize_celebrities_input::Builder,
    }
    impl RecognizeCelebrities {
        /// Creates a new `RecognizeCelebrities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RecognizeCelebritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::RecognizeCelebritiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFaces`.
    ///
    /// <p>For a given input face ID, searches for matching faces in the collection the face belongs to. You get a face ID when you add a face to the collection using the <code>IndexFaces</code> operation. The operation compares the features of the input face with faces in the specified collection. </p> <note>
    /// <p>You can also search faces without indexing faces by using the <code>SearchFacesByImage</code> operation.</p>
    /// </note>
    /// <p> The operation response returns an array of faces that match, ordered by similarity score with the highest similarity first. More specifically, it is an array of metadata for each face match that is found. Along with the metadata, the response also includes a <code>confidence</code> value for each face match, indicating the confidence that the specific face matches the input face. </p>
    /// <p>For an example, see Searching for a face using its face ID in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:SearchFaces</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchFaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_faces_input::Builder,
    }
    impl SearchFaces {
        /// Creates a new `SearchFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the collection the face belongs to.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>ID of the collection the face belongs to.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>ID of a face to find matches for in the collection.</p>
        pub fn face_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.face_id(input.into());
            self
        }
        /// <p>ID of a face to find matches for in the collection.</p>
        pub fn set_face_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_face_id(input);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>
        pub fn max_faces(mut self, input: i32) -> Self {
            self.inner = self.inner.max_faces(input);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>
        pub fn set_max_faces(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_faces(input);
            self
        }
        /// <p>Optional value specifying the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%. </p>
        pub fn face_match_threshold(mut self, input: f32) -> Self {
            self.inner = self.inner.face_match_threshold(input);
            self
        }
        /// <p>Optional value specifying the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%. </p>
        pub fn set_face_match_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_face_match_threshold(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFacesByImage`.
    ///
    /// <p>For a given input image, first detects the largest face in the image, and then searches the specified collection for matching faces. The operation compares the features of the input face with faces in the specified collection. </p> <note>
    /// <p>To search for all faces in an input image, you might first call the <code>IndexFaces</code> operation, and then use the face IDs returned in subsequent calls to the <code>SearchFaces</code> operation. </p>
    /// <p> You can also call the <code>DetectFaces</code> operation and use the bounding boxes in the response to make face crops, which then you can pass in to the <code>SearchFacesByImage</code> operation. </p>
    /// </note>
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p>
    /// <p> The response returns an array of faces that match, ordered by similarity score with the highest similarity first. More specifically, it is an array of metadata for each face match found. Along with the metadata, the response also includes a <code>similarity</code> indicating how similar the face is to the input face. In the response, the operation also returns the bounding box (and a confidence level that the bounding box contains a face) of the face that Amazon Rekognition used for the input image. </p>
    /// <p>If no faces are detected in the input image, <code>SearchFacesByImage</code> returns an <code>InvalidParameterException</code> error. </p>
    /// <p>For an example, Searching for a Face Using an Image in the Amazon Rekognition Developer Guide.</p>
    /// <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces that don’t meet a required quality bar. The quality bar is based on a variety of common use cases. Use <code>QualityFilter</code> to set the quality bar for filtering by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>. If you do not want to filter detected faces, specify <code>NONE</code>. The default value is <code>NONE</code>.</p> <note>
    /// <p>To use quality filtering, you need a collection associated with version 3 of the face model or higher. To get the version of the face model associated with a collection, call <code>DescribeCollection</code>. </p>
    /// </note>
    /// <p>This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchFacesByImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_faces_by_image_input::Builder,
    }
    impl SearchFacesByImage {
        /// Creates a new `SearchFacesByImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFacesByImageOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFacesByImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the collection to search.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>ID of the collection to search.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.inner = self.inner.image(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>
        pub fn max_faces(mut self, input: i32) -> Self {
            self.inner = self.inner.max_faces(input);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces with the highest confidence in the match.</p>
        pub fn set_max_faces(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_faces(input);
            self
        }
        /// <p>(Optional) Specifies the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.</p>
        pub fn face_match_threshold(mut self, input: f32) -> Self {
            self.inner = self.inner.face_match_threshold(input);
            self
        }
        /// <p>(Optional) Specifies the minimum confidence in the face match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.</p>
        pub fn set_face_match_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_face_match_threshold(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn quality_filter(mut self, input: crate::model::QualityFilter) -> Self {
            self.inner = self.inner.quality_filter(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar. If you specify <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that don’t meet the chosen quality bar. The quality bar is based on a variety of common use cases. Low-quality detections can occur for a number of reasons. Some examples are an object that's misidentified as a face, a face that's too blurry, or a face with a pose that's too extreme to use. If you specify <code>NONE</code>, no filtering is performed. The default value is <code>NONE</code>. </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn set_quality_filter(
            mut self,
            input: std::option::Option<crate::model::QualityFilter>,
        ) -> Self {
            self.inner = self.inner.set_quality_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCelebrityRecognition`.
    ///
    /// <p>Starts asynchronous recognition of celebrities in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect celebrities in a video must be stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartCelebrityRecognition</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis. When celebrity recognition analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. To get the results of the celebrity recognition analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetCelebrityRecognition</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartCelebrityRecognition</code>. </p>
    /// <p>For more information, see Recognizing celebrities in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartCelebrityRecognition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_celebrity_recognition_input::Builder,
    }
    impl StartCelebrityRecognition {
        /// Creates a new `StartCelebrityRecognition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCelebrityRecognitionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCelebrityRecognitionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to recognize celebrities. The video must be stored in an Amazon S3 bucket.</p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>The video in which you want to recognize celebrities. The video must be stored in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartCelebrityRecognition</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartCelebrityRecognition</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the celebrity recognition analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the celebrity recognition analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContentModeration`.
    ///
    /// <p> Starts asynchronous detection of inappropriate, unwanted, or offensive content in a stored video. For a list of moderation labels in Amazon Rekognition, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api">Using the image and video moderation APIs</a>.</p>
    /// <p>Amazon Rekognition Video can moderate content in a video stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartContentModeration</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis. When content analysis is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p>
    /// <p>To get the results of the content analysis, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetContentModeration</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartContentModeration</code>. </p>
    /// <p>For more information, see Moderating content in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartContentModeration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_content_moderation_input::Builder,
    }
    impl StartContentModeration {
        /// Creates a new `StartContentModeration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContentModerationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContentModerationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect inappropriate, unwanted, or offensive content. The video must be stored in an Amazon S3 bucket.</p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>The video in which you want to detect inappropriate, unwanted, or offensive content. The video must be stored in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition doesn't return any moderated content labels with a confidence level lower than this specified value. If you don't specify <code>MinConfidence</code>, <code>GetContentModeration</code> returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn min_confidence(mut self, input: f32) -> Self {
            self.inner = self.inner.min_confidence(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition doesn't return any moderated content labels with a confidence level lower than this specified value. If you don't specify <code>MinConfidence</code>, <code>GetContentModeration</code> returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartContentModeration</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartContentModeration</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the content analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the content analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFaceDetection`.
    ///
    /// <p>Starts asynchronous detection of faces in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect faces in a video stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartFaceDetection</code> returns a job identifier (<code>JobId</code>) that you use to get the results of the operation. When face detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. To get the results of the face detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.</p>
    /// <p>For more information, see Detecting faces in a stored video in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFaceDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_face_detection_input::Builder,
    }
    impl StartFaceDetection {
        /// Creates a new `StartFaceDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFaceDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFaceDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.</p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the face detection operation. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the face detection operation. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>The face attributes you want returned.</p>
        /// <p> <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and Landmarks. </p>
        /// <p> <code>ALL</code> - All facial attributes are returned.</p>
        pub fn face_attributes(mut self, input: crate::model::FaceAttributes) -> Self {
            self.inner = self.inner.face_attributes(input);
            self
        }
        /// <p>The face attributes you want returned.</p>
        /// <p> <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and Landmarks. </p>
        /// <p> <code>ALL</code> - All facial attributes are returned.</p>
        pub fn set_face_attributes(
            mut self,
            input: std::option::Option<crate::model::FaceAttributes>,
        ) -> Self {
            self.inner = self.inner.set_face_attributes(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFaceSearch`.
    ///
    /// <p>Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored video.</p>
    /// <p>The video must be stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartFaceSearch</code> returns a job identifier (<code>JobId</code>) which you use to get the search results once the search has completed. When searching is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. To get the search results, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetFaceSearch</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartFaceSearch</code>. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/procedure-person-search-videos.html">Searching stored videos for faces</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFaceSearch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_face_search_input::Builder,
    }
    impl StartFaceSearch {
        /// Creates a new `StartFaceSearch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFaceSearchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFaceSearchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video you want to search. The video must be stored in an Amazon S3 bucket. </p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>The video you want to search. The video must be stored in an Amazon S3 bucket. </p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceSearch</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartFaceSearch</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The minimum confidence in the person match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.</p>
        pub fn face_match_threshold(mut self, input: f32) -> Self {
            self.inner = self.inner.face_match_threshold(input);
            self
        }
        /// <p>The minimum confidence in the person match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%.</p>
        pub fn set_face_match_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_face_match_threshold(input);
            self
        }
        /// <p>ID of the collection that contains the faces you want to search for.</p>
        pub fn collection_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(input.into());
            self
        }
        /// <p>ID of the collection that contains the faces you want to search for.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the search. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the search. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartLabelDetection`.
    ///
    /// <p>Starts asynchronous detection of labels in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect labels in a video. Labels are instances of real-world entities. This includes objects like flower, tree, and table; events like wedding, graduation, and birthday party; concepts like landscape, evening, and nature; and activities like a person getting out of a car or a person skiing.</p>
    /// <p>The video must be stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartLabelDetection</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When label detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p>
    /// <p>To get the results of the label detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetLabelDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.</p>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartLabelDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_label_detection_input::Builder,
    }
    impl StartLabelDetection {
        /// Creates a new `StartLabelDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartLabelDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartLabelDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect labels. The video must be stored in an Amazon S3 bucket.</p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>The video in which you want to detect labels. The video must be stored in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartLabelDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartLabelDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any labels with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn min_confidence(mut self, input: f32) -> Self {
            self.inner = self.inner.min_confidence(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any labels with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPersonTracking`.
    ///
    /// <p>Starts the asynchronous tracking of a person's path in a stored video.</p>
    /// <p>Amazon Rekognition Video can track the path of people in a video stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartPersonTracking</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When label detection is finished, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. </p>
    /// <p>To get the results of the person detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. If so, call <code>GetPersonTracking</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartPersonTracking {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_person_tracking_input::Builder,
    }
    impl StartPersonTracking {
        /// Creates a new `StartPersonTracking`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPersonTrackingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPersonTrackingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect people. The video must be stored in an Amazon S3 bucket.</p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>The video in which you want to detect people. The video must be stored in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartPersonTracking</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartPersonTracking</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the people detection operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the people detection operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartProjectVersion`.
    ///
    /// <p>Starts the running of the version of a model. Starting a model takes a while to complete. To check the current state of the model, use <code>DescribeProjectVersions</code>.</p>
    /// <p>Once the model is running, you can detect custom labels in new images by calling <code>DetectCustomLabels</code>.</p> <note>
    /// <p>You are charged for the amount of time that the model is running. To stop a running model, call <code>StopProjectVersion</code>.</p>
    /// </note>
    /// <p>This operation requires permissions to perform the <code>rekognition:StartProjectVersion</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartProjectVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_project_version_input::Builder,
    }
    impl StartProjectVersion {
        /// Creates a new `StartProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartProjectVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name(ARN) of the model version that you want to start.</p>
        pub fn project_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name(ARN) of the model version that you want to start.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
        /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
        pub fn min_inference_units(mut self, input: i32) -> Self {
            self.inner = self.inner.min_inference_units(input);
            self
        }
        /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
        pub fn set_min_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_inference_units(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSegmentDetection`.
    ///
    /// <p>Starts asynchronous detection of segment detection in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect segments in a video stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartSegmentDetection</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When segment detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p>
    /// <p>You can use the <code>Filters</code> (<code>StartSegmentDetectionFilters</code>) input parameter to specify the minimum detection confidence returned in the response. Within <code>Filters</code>, use <code>ShotFilter</code> (<code>StartShotDetectionFilter</code>) to filter detected shots. Use <code>TechnicalCueFilter</code> (<code>StartTechnicalCueDetectionFilter</code>) to filter technical cues. </p>
    /// <p>To get the results of the segment detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <code>GetSegmentDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartSegmentDetection</code>. </p>
    /// <p>For more information, see Detecting video segments in stored video in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSegmentDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_segment_detection_input::Builder,
    }
    impl StartSegmentDetection {
        /// Creates a new `StartSegmentDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSegmentDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSegmentDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <code>StartLabelDetection</code> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <code>StartLabelDetection</code> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the segment detection operation. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the segment detection operation. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>Filters for technical cue or shot detection.</p>
        pub fn filters(mut self, input: crate::model::StartSegmentDetectionFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters for technical cue or shot detection.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::StartSegmentDetectionFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SegmentTypes`.
        ///
        /// To override the contents of this collection use [`set_segment_types`](Self::set_segment_types).
        ///
        /// <p>An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.</p>
        pub fn segment_types(mut self, input: crate::model::SegmentType) -> Self {
            self.inner = self.inner.segment_types(input);
            self
        }
        /// <p>An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.</p>
        pub fn set_segment_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SegmentType>>,
        ) -> Self {
            self.inner = self.inner.set_segment_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStreamProcessor`.
    ///
    /// <p>Starts processing a stream processor. You create a stream processor by calling <code>CreateStreamProcessor</code>. To tell <code>StartStreamProcessor</code> which stream processor to start, use the value of the <code>Name</code> field specified in the call to <code>CreateStreamProcessor</code>.</p>
    /// <p>If you are using a label detection stream processor to detect labels, you need to provide a <code>Start selector</code> and a <code>Stop selector</code> to determine the length of the stream processing time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartStreamProcessor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_stream_processor_input::Builder,
    }
    impl StartStreamProcessor {
        /// Creates a new `StartStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStreamProcessorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream processor to start processing.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the stream processor to start processing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or the fragment number. For more information, see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>. </p>
        /// <p>This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.</p>
        pub fn start_selector(
            mut self,
            input: crate::model::StreamProcessingStartSelector,
        ) -> Self {
            self.inner = self.inner.start_selector(input);
            self
        }
        /// <p> Specifies the starting point in the Kinesis stream to start processing. You can use the producer timestamp or the fragment number. For more information, see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html">Fragment</a>. </p>
        /// <p>This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.</p>
        pub fn set_start_selector(
            mut self,
            input: std::option::Option<crate::model::StreamProcessingStartSelector>,
        ) -> Self {
            self.inner = self.inner.set_start_selector(input);
            self
        }
        /// <p> Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video. </p>
        /// <p>This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.</p>
        pub fn stop_selector(mut self, input: crate::model::StreamProcessingStopSelector) -> Self {
            self.inner = self.inner.stop_selector(input);
            self
        }
        /// <p> Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video. </p>
        /// <p>This is a required parameter for label detection stream processors and should not be used to start a face search stream processor.</p>
        pub fn set_stop_selector(
            mut self,
            input: std::option::Option<crate::model::StreamProcessingStopSelector>,
        ) -> Self {
            self.inner = self.inner.set_stop_selector(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTextDetection`.
    ///
    /// <p>Starts asynchronous detection of text in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect text in a video stored in an Amazon S3 bucket. Use <code>Video</code> to specify the bucket name and the filename of the video. <code>StartTextDetection</code> returns a job identifier (<code>JobId</code>) which you use to get the results of the operation. When text detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p>
    /// <p>To get the results of the text detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>. if so, call <code>GetTextDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call to <code>StartTextDetection</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTextDetection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_text_detection_input::Builder,
    }
    impl StartTextDetection {
        /// Creates a new `StartTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTextDetectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <code>StartLabelDetection</code> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn video(mut self, input: crate::model::Video) -> Self {
            self.inner = self.inner.video(input);
            self
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <code>StartLabelDetection</code> use <code>Video</code> to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentaly started more than once.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartTextDetection</code> requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job from being accidentaly started more than once.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html">Calling Amazon Rekognition Video operations</a>. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics">Giving access to multiple Amazon SNS topics</a>.</p>
        pub fn notification_channel(mut self, input: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(input);
            self
        }
        /// <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html">Calling Amazon Rekognition Video operations</a>. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics">Giving access to multiple Amazon SNS topics</a>.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier returned in the completion status published by your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(input.into());
            self
        }
        /// <p>An identifier returned in the completion status published by your Amazon Simple Notification Service topic. For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>Optional parameters that let you set criteria the text must meet to be included in your response.</p>
        pub fn filters(mut self, input: crate::model::StartTextDetectionFilters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Optional parameters that let you set criteria the text must meet to be included in your response.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::StartTextDetectionFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopProjectVersion`.
    ///
    /// <p>Stops a running model. The operation might take a while to complete. To check the current status, call <code>DescribeProjectVersions</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopProjectVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_project_version_input::Builder,
    }
    impl StopProjectVersion {
        /// Creates a new `StopProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopProjectVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        /// <p>This operation requires permissions to perform the <code>rekognition:StopProjectVersion</code> action.</p>
        pub fn project_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        /// <p>This operation requires permissions to perform the <code>rekognition:StopProjectVersion</code> action.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopStreamProcessor`.
    ///
    /// <p>Stops a running stream processor that was created by <code>CreateStreamProcessor</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopStreamProcessor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_stream_processor_input::Builder,
    }
    impl StopStreamProcessor {
        /// Creates a new `StopStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::StopStreamProcessorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a stream processor created by <code>CreateStreamProcessor</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of a stream processor created by <code>CreateStreamProcessor</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Adds one or more key-value tags to an Amazon Rekognition collection, stream processor, or Custom Labels model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:TagResource</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to assign the tags to. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to assign the tags to. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The key-value tags to assign to the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The key-value tags to assign to the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Removes one or more tags from an Amazon Rekognition collection, stream processor, or Custom Labels model. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:UntagResource</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to remove the tags from. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to remove the tags from. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> A list of the tags that you want to remove. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> A list of the tags that you want to remove. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatasetEntries`.
    ///
    /// <p>Adds or updates one or more entries (images) in a dataset. An entry is a JSON Line which contains the information for a single image, including the image location, assigned labels, and object location bounding boxes. For more information, see Image-Level labels in manifest files and Object localization in manifest files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p>
    /// <p>If the <code>source-ref</code> field in the JSON line references an existing image, the existing image in the dataset is updated. If <code>source-ref</code> field doesn't reference an existing image, the image is added as a new image to the dataset. </p>
    /// <p>You specify the changes that you want to make in the <code>Changes</code> input parameter. There isn't a limit to the number JSON Lines that you can change, but the size of <code>Changes</code> must be less than 5MB.</p>
    /// <p> <code>UpdateDatasetEntries</code> returns immediatly, but the dataset update might take a while to complete. Use <code>DescribeDataset</code> to check the current status. The dataset updated successfully if the value of <code>Status</code> is <code>UPDATE_COMPLETE</code>. </p>
    /// <p>To check if any non-terminal errors occured, call <code>ListDatasetEntries</code> and check for the presence of <code>errors</code> lists in the JSON Lines.</p>
    /// <p>Dataset update fails if a terminal error occurs (<code>Status</code> = <code>UPDATE_FAILED</code>). Currently, you can't access the terminal error information from the Amazon Rekognition Custom Labels SDK. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:UpdateDatasetEntries</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDatasetEntries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_dataset_entries_input::Builder,
    }
    impl UpdateDatasetEntries {
        /// Creates a new `UpdateDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetEntriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the dataset that you want to update. </p>
        pub fn dataset_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the dataset that you want to update. </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p> The changes that you want to make to the dataset. </p>
        pub fn changes(mut self, input: crate::model::DatasetChanges) -> Self {
            self.inner = self.inner.changes(input);
            self
        }
        /// <p> The changes that you want to make to the dataset. </p>
        pub fn set_changes(
            mut self,
            input: std::option::Option<crate::model::DatasetChanges>,
        ) -> Self {
            self.inner = self.inner.set_changes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStreamProcessor`.
    ///
    /// <p> Allows you to update a stream processor. You can change some settings and regions of interest and delete certain parameters. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStreamProcessor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_stream_processor_input::Builder,
    }
    impl UpdateStreamProcessor {
        /// Creates a new `UpdateStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStreamProcessorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> Name of the stream processor that you want to update. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> Name of the stream processor that you want to update. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The stream processor settings that you want to update. Label detection settings can be updated to detect different labels with a different minimum confidence. </p>
        pub fn settings_for_update(
            mut self,
            input: crate::model::StreamProcessorSettingsForUpdate,
        ) -> Self {
            self.inner = self.inner.settings_for_update(input);
            self
        }
        /// <p> The stream processor settings that you want to update. Label detection settings can be updated to detect different labels with a different minimum confidence. </p>
        pub fn set_settings_for_update(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorSettingsForUpdate>,
        ) -> Self {
            self.inner = self.inner.set_settings_for_update(input);
            self
        }
        /// Appends an item to `RegionsOfInterestForUpdate`.
        ///
        /// To override the contents of this collection use [`set_regions_of_interest_for_update`](Self::set_regions_of_interest_for_update).
        ///
        /// <p> Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional parameter for label detection stream processors. </p>
        pub fn regions_of_interest_for_update(
            mut self,
            input: crate::model::RegionOfInterest,
        ) -> Self {
            self.inner = self.inner.regions_of_interest_for_update(input);
            self
        }
        /// <p> Specifies locations in the frames where Amazon Rekognition checks for objects or people. This is an optional parameter for label detection stream processors. </p>
        pub fn set_regions_of_interest_for_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionOfInterest>>,
        ) -> Self {
            self.inner = self.inner.set_regions_of_interest_for_update(input);
            self
        }
        /// <p> Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. </p>
        pub fn data_sharing_preference_for_update(
            mut self,
            input: crate::model::StreamProcessorDataSharingPreference,
        ) -> Self {
            self.inner = self.inner.data_sharing_preference_for_update(input);
            self
        }
        /// <p> Shows whether you are sharing data with Rekognition to improve model performance. You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. </p>
        pub fn set_data_sharing_preference_for_update(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorDataSharingPreference>,
        ) -> Self {
            self.inner = self.inner.set_data_sharing_preference_for_update(input);
            self
        }
        /// Appends an item to `ParametersToDelete`.
        ///
        /// To override the contents of this collection use [`set_parameters_to_delete`](Self::set_parameters_to_delete).
        ///
        /// <p> A list of parameters you want to delete from the stream processor. </p>
        pub fn parameters_to_delete(
            mut self,
            input: crate::model::StreamProcessorParameterToDelete,
        ) -> Self {
            self.inner = self.inner.parameters_to_delete(input);
            self
        }
        /// <p> A list of parameters you want to delete from the stream processor. </p>
        pub fn set_parameters_to_delete(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::StreamProcessorParameterToDelete>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters_to_delete(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
