// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CompareFaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`compare_faces`](crate::client::Client::compare_faces).
///
/// See [`crate::client::fluent_builders::CompareFaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompareFaces {
    _private: (),
}
impl CompareFaces {
    /// Creates a new builder-style object to manufacture [`CompareFacesInput`](crate::input::CompareFacesInput)
    pub fn builder() -> crate::input::compare_faces_input::Builder {
        crate::input::compare_faces_input::Builder::default()
    }
    /// Creates a new `CompareFaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompareFaces {
    type Output =
        std::result::Result<crate::output::CompareFacesOutput, crate::error::CompareFacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_compare_faces_error(response)
        } else {
            crate::operation_deser::parse_compare_faces_response(response)
        }
    }
}

/// Operation shape for `CreateCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_collection`](crate::client::Client::create_collection).
///
/// See [`crate::client::fluent_builders::CreateCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCollection {
    _private: (),
}
impl CreateCollection {
    /// Creates a new builder-style object to manufacture [`CreateCollectionInput`](crate::input::CreateCollectionInput)
    pub fn builder() -> crate::input::create_collection_input::Builder {
        crate::input::create_collection_input::Builder::default()
    }
    /// Creates a new `CreateCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCollection {
    type Output = std::result::Result<
        crate::output::CreateCollectionOutput,
        crate::error::CreateCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_collection_error(response)
        } else {
            crate::operation_deser::parse_create_collection_response(response)
        }
    }
}

/// Operation shape for `CreateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset`](crate::client::Client::create_dataset).
///
/// See [`crate::client::fluent_builders::CreateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataset {
    _private: (),
}
impl CreateDataset {
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
    /// Creates a new `CreateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataset {
    type Output =
        std::result::Result<crate::output::CreateDatasetOutput, crate::error::CreateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_dataset_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `CreateProjectVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project_version`](crate::client::Client::create_project_version).
///
/// See [`crate::client::fluent_builders::CreateProjectVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProjectVersion {
    _private: (),
}
impl CreateProjectVersion {
    /// Creates a new builder-style object to manufacture [`CreateProjectVersionInput`](crate::input::CreateProjectVersionInput)
    pub fn builder() -> crate::input::create_project_version_input::Builder {
        crate::input::create_project_version_input::Builder::default()
    }
    /// Creates a new `CreateProjectVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProjectVersion {
    type Output = std::result::Result<
        crate::output::CreateProjectVersionOutput,
        crate::error::CreateProjectVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_version_error(response)
        } else {
            crate::operation_deser::parse_create_project_version_response(response)
        }
    }
}

/// Operation shape for `CreateStreamProcessor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stream_processor`](crate::client::Client::create_stream_processor).
///
/// See [`crate::client::fluent_builders::CreateStreamProcessor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStreamProcessor {
    _private: (),
}
impl CreateStreamProcessor {
    /// Creates a new builder-style object to manufacture [`CreateStreamProcessorInput`](crate::input::CreateStreamProcessorInput)
    pub fn builder() -> crate::input::create_stream_processor_input::Builder {
        crate::input::create_stream_processor_input::Builder::default()
    }
    /// Creates a new `CreateStreamProcessor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStreamProcessor {
    type Output = std::result::Result<
        crate::output::CreateStreamProcessorOutput,
        crate::error::CreateStreamProcessorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stream_processor_error(response)
        } else {
            crate::operation_deser::parse_create_stream_processor_response(response)
        }
    }
}

/// Operation shape for `DeleteCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_collection`](crate::client::Client::delete_collection).
///
/// See [`crate::client::fluent_builders::DeleteCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCollection {
    _private: (),
}
impl DeleteCollection {
    /// Creates a new builder-style object to manufacture [`DeleteCollectionInput`](crate::input::DeleteCollectionInput)
    pub fn builder() -> crate::input::delete_collection_input::Builder {
        crate::input::delete_collection_input::Builder::default()
    }
    /// Creates a new `DeleteCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCollection {
    type Output = std::result::Result<
        crate::output::DeleteCollectionOutput,
        crate::error::DeleteCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_collection_error(response)
        } else {
            crate::operation_deser::parse_delete_collection_response(response)
        }
    }
}

/// Operation shape for `DeleteDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset`](crate::client::Client::delete_dataset).
///
/// See [`crate::client::fluent_builders::DeleteDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataset {
    _private: (),
}
impl DeleteDataset {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
    /// Creates a new `DeleteDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataset {
    type Output =
        std::result::Result<crate::output::DeleteDatasetOutput, crate::error::DeleteDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dataset_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_response(response)
        }
    }
}

/// Operation shape for `DeleteFaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_faces`](crate::client::Client::delete_faces).
///
/// See [`crate::client::fluent_builders::DeleteFaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFaces {
    _private: (),
}
impl DeleteFaces {
    /// Creates a new builder-style object to manufacture [`DeleteFacesInput`](crate::input::DeleteFacesInput)
    pub fn builder() -> crate::input::delete_faces_input::Builder {
        crate::input::delete_faces_input::Builder::default()
    }
    /// Creates a new `DeleteFaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFaces {
    type Output =
        std::result::Result<crate::output::DeleteFacesOutput, crate::error::DeleteFacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_faces_error(response)
        } else {
            crate::operation_deser::parse_delete_faces_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `DeleteProjectVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project_version`](crate::client::Client::delete_project_version).
///
/// See [`crate::client::fluent_builders::DeleteProjectVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProjectVersion {
    _private: (),
}
impl DeleteProjectVersion {
    /// Creates a new builder-style object to manufacture [`DeleteProjectVersionInput`](crate::input::DeleteProjectVersionInput)
    pub fn builder() -> crate::input::delete_project_version_input::Builder {
        crate::input::delete_project_version_input::Builder::default()
    }
    /// Creates a new `DeleteProjectVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProjectVersion {
    type Output = std::result::Result<
        crate::output::DeleteProjectVersionOutput,
        crate::error::DeleteProjectVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_version_error(response)
        } else {
            crate::operation_deser::parse_delete_project_version_response(response)
        }
    }
}

/// Operation shape for `DeleteStreamProcessor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stream_processor`](crate::client::Client::delete_stream_processor).
///
/// See [`crate::client::fluent_builders::DeleteStreamProcessor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStreamProcessor {
    _private: (),
}
impl DeleteStreamProcessor {
    /// Creates a new builder-style object to manufacture [`DeleteStreamProcessorInput`](crate::input::DeleteStreamProcessorInput)
    pub fn builder() -> crate::input::delete_stream_processor_input::Builder {
        crate::input::delete_stream_processor_input::Builder::default()
    }
    /// Creates a new `DeleteStreamProcessor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStreamProcessor {
    type Output = std::result::Result<
        crate::output::DeleteStreamProcessorOutput,
        crate::error::DeleteStreamProcessorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stream_processor_error(response)
        } else {
            crate::operation_deser::parse_delete_stream_processor_response(response)
        }
    }
}

/// Operation shape for `DescribeCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_collection`](crate::client::Client::describe_collection).
///
/// See [`crate::client::fluent_builders::DescribeCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCollection {
    _private: (),
}
impl DescribeCollection {
    /// Creates a new builder-style object to manufacture [`DescribeCollectionInput`](crate::input::DescribeCollectionInput)
    pub fn builder() -> crate::input::describe_collection_input::Builder {
        crate::input::describe_collection_input::Builder::default()
    }
    /// Creates a new `DescribeCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCollection {
    type Output = std::result::Result<
        crate::output::DescribeCollectionOutput,
        crate::error::DescribeCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_collection_error(response)
        } else {
            crate::operation_deser::parse_describe_collection_response(response)
        }
    }
}

/// Operation shape for `DescribeDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset`](crate::client::Client::describe_dataset).
///
/// See [`crate::client::fluent_builders::DescribeDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataset {
    _private: (),
}
impl DescribeDataset {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
    /// Creates a new `DescribeDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataset {
    type Output = std::result::Result<
        crate::output::DescribeDatasetOutput,
        crate::error::DescribeDatasetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_response(response)
        }
    }
}

/// Operation shape for `DescribeProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_projects`](crate::client::Client::describe_projects).
///
/// See [`crate::client::fluent_builders::DescribeProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProjects {
    _private: (),
}
impl DescribeProjects {
    /// Creates a new builder-style object to manufacture [`DescribeProjectsInput`](crate::input::DescribeProjectsInput)
    pub fn builder() -> crate::input::describe_projects_input::Builder {
        crate::input::describe_projects_input::Builder::default()
    }
    /// Creates a new `DescribeProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProjects {
    type Output = std::result::Result<
        crate::output::DescribeProjectsOutput,
        crate::error::DescribeProjectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_projects_error(response)
        } else {
            crate::operation_deser::parse_describe_projects_response(response)
        }
    }
}

/// Operation shape for `DescribeProjectVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_project_versions`](crate::client::Client::describe_project_versions).
///
/// See [`crate::client::fluent_builders::DescribeProjectVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProjectVersions {
    _private: (),
}
impl DescribeProjectVersions {
    /// Creates a new builder-style object to manufacture [`DescribeProjectVersionsInput`](crate::input::DescribeProjectVersionsInput)
    pub fn builder() -> crate::input::describe_project_versions_input::Builder {
        crate::input::describe_project_versions_input::Builder::default()
    }
    /// Creates a new `DescribeProjectVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProjectVersions {
    type Output = std::result::Result<
        crate::output::DescribeProjectVersionsOutput,
        crate::error::DescribeProjectVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_project_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_project_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeStreamProcessor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stream_processor`](crate::client::Client::describe_stream_processor).
///
/// See [`crate::client::fluent_builders::DescribeStreamProcessor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStreamProcessor {
    _private: (),
}
impl DescribeStreamProcessor {
    /// Creates a new builder-style object to manufacture [`DescribeStreamProcessorInput`](crate::input::DescribeStreamProcessorInput)
    pub fn builder() -> crate::input::describe_stream_processor_input::Builder {
        crate::input::describe_stream_processor_input::Builder::default()
    }
    /// Creates a new `DescribeStreamProcessor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStreamProcessor {
    type Output = std::result::Result<
        crate::output::DescribeStreamProcessorOutput,
        crate::error::DescribeStreamProcessorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stream_processor_error(response)
        } else {
            crate::operation_deser::parse_describe_stream_processor_response(response)
        }
    }
}

/// Operation shape for `DetectCustomLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_custom_labels`](crate::client::Client::detect_custom_labels).
///
/// See [`crate::client::fluent_builders::DetectCustomLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectCustomLabels {
    _private: (),
}
impl DetectCustomLabels {
    /// Creates a new builder-style object to manufacture [`DetectCustomLabelsInput`](crate::input::DetectCustomLabelsInput)
    pub fn builder() -> crate::input::detect_custom_labels_input::Builder {
        crate::input::detect_custom_labels_input::Builder::default()
    }
    /// Creates a new `DetectCustomLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectCustomLabels {
    type Output = std::result::Result<
        crate::output::DetectCustomLabelsOutput,
        crate::error::DetectCustomLabelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_custom_labels_error(response)
        } else {
            crate::operation_deser::parse_detect_custom_labels_response(response)
        }
    }
}

/// Operation shape for `DetectFaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_faces`](crate::client::Client::detect_faces).
///
/// See [`crate::client::fluent_builders::DetectFaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectFaces {
    _private: (),
}
impl DetectFaces {
    /// Creates a new builder-style object to manufacture [`DetectFacesInput`](crate::input::DetectFacesInput)
    pub fn builder() -> crate::input::detect_faces_input::Builder {
        crate::input::detect_faces_input::Builder::default()
    }
    /// Creates a new `DetectFaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectFaces {
    type Output =
        std::result::Result<crate::output::DetectFacesOutput, crate::error::DetectFacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_faces_error(response)
        } else {
            crate::operation_deser::parse_detect_faces_response(response)
        }
    }
}

/// Operation shape for `DetectLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_labels`](crate::client::Client::detect_labels).
///
/// See [`crate::client::fluent_builders::DetectLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectLabels {
    _private: (),
}
impl DetectLabels {
    /// Creates a new builder-style object to manufacture [`DetectLabelsInput`](crate::input::DetectLabelsInput)
    pub fn builder() -> crate::input::detect_labels_input::Builder {
        crate::input::detect_labels_input::Builder::default()
    }
    /// Creates a new `DetectLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectLabels {
    type Output =
        std::result::Result<crate::output::DetectLabelsOutput, crate::error::DetectLabelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_labels_error(response)
        } else {
            crate::operation_deser::parse_detect_labels_response(response)
        }
    }
}

/// Operation shape for `DetectModerationLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_moderation_labels`](crate::client::Client::detect_moderation_labels).
///
/// See [`crate::client::fluent_builders::DetectModerationLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectModerationLabels {
    _private: (),
}
impl DetectModerationLabels {
    /// Creates a new builder-style object to manufacture [`DetectModerationLabelsInput`](crate::input::DetectModerationLabelsInput)
    pub fn builder() -> crate::input::detect_moderation_labels_input::Builder {
        crate::input::detect_moderation_labels_input::Builder::default()
    }
    /// Creates a new `DetectModerationLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectModerationLabels {
    type Output = std::result::Result<
        crate::output::DetectModerationLabelsOutput,
        crate::error::DetectModerationLabelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_moderation_labels_error(response)
        } else {
            crate::operation_deser::parse_detect_moderation_labels_response(response)
        }
    }
}

/// Operation shape for `DetectProtectiveEquipment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_protective_equipment`](crate::client::Client::detect_protective_equipment).
///
/// See [`crate::client::fluent_builders::DetectProtectiveEquipment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectProtectiveEquipment {
    _private: (),
}
impl DetectProtectiveEquipment {
    /// Creates a new builder-style object to manufacture [`DetectProtectiveEquipmentInput`](crate::input::DetectProtectiveEquipmentInput)
    pub fn builder() -> crate::input::detect_protective_equipment_input::Builder {
        crate::input::detect_protective_equipment_input::Builder::default()
    }
    /// Creates a new `DetectProtectiveEquipment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectProtectiveEquipment {
    type Output = std::result::Result<
        crate::output::DetectProtectiveEquipmentOutput,
        crate::error::DetectProtectiveEquipmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_protective_equipment_error(response)
        } else {
            crate::operation_deser::parse_detect_protective_equipment_response(response)
        }
    }
}

/// Operation shape for `DetectText`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_text`](crate::client::Client::detect_text).
///
/// See [`crate::client::fluent_builders::DetectText`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectText {
    _private: (),
}
impl DetectText {
    /// Creates a new builder-style object to manufacture [`DetectTextInput`](crate::input::DetectTextInput)
    pub fn builder() -> crate::input::detect_text_input::Builder {
        crate::input::detect_text_input::Builder::default()
    }
    /// Creates a new `DetectText` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectText {
    type Output =
        std::result::Result<crate::output::DetectTextOutput, crate::error::DetectTextError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_text_error(response)
        } else {
            crate::operation_deser::parse_detect_text_response(response)
        }
    }
}

/// Operation shape for `DistributeDatasetEntries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`distribute_dataset_entries`](crate::client::Client::distribute_dataset_entries).
///
/// See [`crate::client::fluent_builders::DistributeDatasetEntries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DistributeDatasetEntries {
    _private: (),
}
impl DistributeDatasetEntries {
    /// Creates a new builder-style object to manufacture [`DistributeDatasetEntriesInput`](crate::input::DistributeDatasetEntriesInput)
    pub fn builder() -> crate::input::distribute_dataset_entries_input::Builder {
        crate::input::distribute_dataset_entries_input::Builder::default()
    }
    /// Creates a new `DistributeDatasetEntries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DistributeDatasetEntries {
    type Output = std::result::Result<
        crate::output::DistributeDatasetEntriesOutput,
        crate::error::DistributeDatasetEntriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_distribute_dataset_entries_error(response)
        } else {
            crate::operation_deser::parse_distribute_dataset_entries_response(response)
        }
    }
}

/// Operation shape for `GetCelebrityInfo`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_celebrity_info`](crate::client::Client::get_celebrity_info).
///
/// See [`crate::client::fluent_builders::GetCelebrityInfo`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCelebrityInfo {
    _private: (),
}
impl GetCelebrityInfo {
    /// Creates a new builder-style object to manufacture [`GetCelebrityInfoInput`](crate::input::GetCelebrityInfoInput)
    pub fn builder() -> crate::input::get_celebrity_info_input::Builder {
        crate::input::get_celebrity_info_input::Builder::default()
    }
    /// Creates a new `GetCelebrityInfo` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCelebrityInfo {
    type Output = std::result::Result<
        crate::output::GetCelebrityInfoOutput,
        crate::error::GetCelebrityInfoError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_celebrity_info_error(response)
        } else {
            crate::operation_deser::parse_get_celebrity_info_response(response)
        }
    }
}

/// Operation shape for `GetCelebrityRecognition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_celebrity_recognition`](crate::client::Client::get_celebrity_recognition).
///
/// See [`crate::client::fluent_builders::GetCelebrityRecognition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCelebrityRecognition {
    _private: (),
}
impl GetCelebrityRecognition {
    /// Creates a new builder-style object to manufacture [`GetCelebrityRecognitionInput`](crate::input::GetCelebrityRecognitionInput)
    pub fn builder() -> crate::input::get_celebrity_recognition_input::Builder {
        crate::input::get_celebrity_recognition_input::Builder::default()
    }
    /// Creates a new `GetCelebrityRecognition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCelebrityRecognition {
    type Output = std::result::Result<
        crate::output::GetCelebrityRecognitionOutput,
        crate::error::GetCelebrityRecognitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_celebrity_recognition_error(response)
        } else {
            crate::operation_deser::parse_get_celebrity_recognition_response(response)
        }
    }
}

/// Operation shape for `GetContentModeration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_content_moderation`](crate::client::Client::get_content_moderation).
///
/// See [`crate::client::fluent_builders::GetContentModeration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContentModeration {
    _private: (),
}
impl GetContentModeration {
    /// Creates a new builder-style object to manufacture [`GetContentModerationInput`](crate::input::GetContentModerationInput)
    pub fn builder() -> crate::input::get_content_moderation_input::Builder {
        crate::input::get_content_moderation_input::Builder::default()
    }
    /// Creates a new `GetContentModeration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContentModeration {
    type Output = std::result::Result<
        crate::output::GetContentModerationOutput,
        crate::error::GetContentModerationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_content_moderation_error(response)
        } else {
            crate::operation_deser::parse_get_content_moderation_response(response)
        }
    }
}

/// Operation shape for `GetFaceDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_face_detection`](crate::client::Client::get_face_detection).
///
/// See [`crate::client::fluent_builders::GetFaceDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFaceDetection {
    _private: (),
}
impl GetFaceDetection {
    /// Creates a new builder-style object to manufacture [`GetFaceDetectionInput`](crate::input::GetFaceDetectionInput)
    pub fn builder() -> crate::input::get_face_detection_input::Builder {
        crate::input::get_face_detection_input::Builder::default()
    }
    /// Creates a new `GetFaceDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFaceDetection {
    type Output = std::result::Result<
        crate::output::GetFaceDetectionOutput,
        crate::error::GetFaceDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_face_detection_error(response)
        } else {
            crate::operation_deser::parse_get_face_detection_response(response)
        }
    }
}

/// Operation shape for `GetFaceSearch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_face_search`](crate::client::Client::get_face_search).
///
/// See [`crate::client::fluent_builders::GetFaceSearch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFaceSearch {
    _private: (),
}
impl GetFaceSearch {
    /// Creates a new builder-style object to manufacture [`GetFaceSearchInput`](crate::input::GetFaceSearchInput)
    pub fn builder() -> crate::input::get_face_search_input::Builder {
        crate::input::get_face_search_input::Builder::default()
    }
    /// Creates a new `GetFaceSearch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFaceSearch {
    type Output =
        std::result::Result<crate::output::GetFaceSearchOutput, crate::error::GetFaceSearchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_face_search_error(response)
        } else {
            crate::operation_deser::parse_get_face_search_response(response)
        }
    }
}

/// Operation shape for `GetLabelDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_label_detection`](crate::client::Client::get_label_detection).
///
/// See [`crate::client::fluent_builders::GetLabelDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLabelDetection {
    _private: (),
}
impl GetLabelDetection {
    /// Creates a new builder-style object to manufacture [`GetLabelDetectionInput`](crate::input::GetLabelDetectionInput)
    pub fn builder() -> crate::input::get_label_detection_input::Builder {
        crate::input::get_label_detection_input::Builder::default()
    }
    /// Creates a new `GetLabelDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLabelDetection {
    type Output = std::result::Result<
        crate::output::GetLabelDetectionOutput,
        crate::error::GetLabelDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_label_detection_error(response)
        } else {
            crate::operation_deser::parse_get_label_detection_response(response)
        }
    }
}

/// Operation shape for `GetPersonTracking`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_person_tracking`](crate::client::Client::get_person_tracking).
///
/// See [`crate::client::fluent_builders::GetPersonTracking`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPersonTracking {
    _private: (),
}
impl GetPersonTracking {
    /// Creates a new builder-style object to manufacture [`GetPersonTrackingInput`](crate::input::GetPersonTrackingInput)
    pub fn builder() -> crate::input::get_person_tracking_input::Builder {
        crate::input::get_person_tracking_input::Builder::default()
    }
    /// Creates a new `GetPersonTracking` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPersonTracking {
    type Output = std::result::Result<
        crate::output::GetPersonTrackingOutput,
        crate::error::GetPersonTrackingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_person_tracking_error(response)
        } else {
            crate::operation_deser::parse_get_person_tracking_response(response)
        }
    }
}

/// Operation shape for `GetSegmentDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_segment_detection`](crate::client::Client::get_segment_detection).
///
/// See [`crate::client::fluent_builders::GetSegmentDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSegmentDetection {
    _private: (),
}
impl GetSegmentDetection {
    /// Creates a new builder-style object to manufacture [`GetSegmentDetectionInput`](crate::input::GetSegmentDetectionInput)
    pub fn builder() -> crate::input::get_segment_detection_input::Builder {
        crate::input::get_segment_detection_input::Builder::default()
    }
    /// Creates a new `GetSegmentDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSegmentDetection {
    type Output = std::result::Result<
        crate::output::GetSegmentDetectionOutput,
        crate::error::GetSegmentDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_segment_detection_error(response)
        } else {
            crate::operation_deser::parse_get_segment_detection_response(response)
        }
    }
}

/// Operation shape for `GetTextDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_text_detection`](crate::client::Client::get_text_detection).
///
/// See [`crate::client::fluent_builders::GetTextDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTextDetection {
    _private: (),
}
impl GetTextDetection {
    /// Creates a new builder-style object to manufacture [`GetTextDetectionInput`](crate::input::GetTextDetectionInput)
    pub fn builder() -> crate::input::get_text_detection_input::Builder {
        crate::input::get_text_detection_input::Builder::default()
    }
    /// Creates a new `GetTextDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTextDetection {
    type Output = std::result::Result<
        crate::output::GetTextDetectionOutput,
        crate::error::GetTextDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_text_detection_error(response)
        } else {
            crate::operation_deser::parse_get_text_detection_response(response)
        }
    }
}

/// Operation shape for `IndexFaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`index_faces`](crate::client::Client::index_faces).
///
/// See [`crate::client::fluent_builders::IndexFaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct IndexFaces {
    _private: (),
}
impl IndexFaces {
    /// Creates a new builder-style object to manufacture [`IndexFacesInput`](crate::input::IndexFacesInput)
    pub fn builder() -> crate::input::index_faces_input::Builder {
        crate::input::index_faces_input::Builder::default()
    }
    /// Creates a new `IndexFaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for IndexFaces {
    type Output =
        std::result::Result<crate::output::IndexFacesOutput, crate::error::IndexFacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_index_faces_error(response)
        } else {
            crate::operation_deser::parse_index_faces_response(response)
        }
    }
}

/// Operation shape for `ListCollections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_collections`](crate::client::Client::list_collections).
///
/// See [`crate::client::fluent_builders::ListCollections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCollections {
    _private: (),
}
impl ListCollections {
    /// Creates a new builder-style object to manufacture [`ListCollectionsInput`](crate::input::ListCollectionsInput)
    pub fn builder() -> crate::input::list_collections_input::Builder {
        crate::input::list_collections_input::Builder::default()
    }
    /// Creates a new `ListCollections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCollections {
    type Output = std::result::Result<
        crate::output::ListCollectionsOutput,
        crate::error::ListCollectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_collections_error(response)
        } else {
            crate::operation_deser::parse_list_collections_response(response)
        }
    }
}

/// Operation shape for `ListDatasetEntries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_entries`](crate::client::Client::list_dataset_entries).
///
/// See [`crate::client::fluent_builders::ListDatasetEntries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetEntries {
    _private: (),
}
impl ListDatasetEntries {
    /// Creates a new builder-style object to manufacture [`ListDatasetEntriesInput`](crate::input::ListDatasetEntriesInput)
    pub fn builder() -> crate::input::list_dataset_entries_input::Builder {
        crate::input::list_dataset_entries_input::Builder::default()
    }
    /// Creates a new `ListDatasetEntries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetEntries {
    type Output = std::result::Result<
        crate::output::ListDatasetEntriesOutput,
        crate::error::ListDatasetEntriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_entries_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_entries_response(response)
        }
    }
}

/// Operation shape for `ListDatasetLabels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_labels`](crate::client::Client::list_dataset_labels).
///
/// See [`crate::client::fluent_builders::ListDatasetLabels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetLabels {
    _private: (),
}
impl ListDatasetLabels {
    /// Creates a new builder-style object to manufacture [`ListDatasetLabelsInput`](crate::input::ListDatasetLabelsInput)
    pub fn builder() -> crate::input::list_dataset_labels_input::Builder {
        crate::input::list_dataset_labels_input::Builder::default()
    }
    /// Creates a new `ListDatasetLabels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetLabels {
    type Output = std::result::Result<
        crate::output::ListDatasetLabelsOutput,
        crate::error::ListDatasetLabelsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_labels_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_labels_response(response)
        }
    }
}

/// Operation shape for `ListFaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_faces`](crate::client::Client::list_faces).
///
/// See [`crate::client::fluent_builders::ListFaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFaces {
    _private: (),
}
impl ListFaces {
    /// Creates a new builder-style object to manufacture [`ListFacesInput`](crate::input::ListFacesInput)
    pub fn builder() -> crate::input::list_faces_input::Builder {
        crate::input::list_faces_input::Builder::default()
    }
    /// Creates a new `ListFaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFaces {
    type Output = std::result::Result<crate::output::ListFacesOutput, crate::error::ListFacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_faces_error(response)
        } else {
            crate::operation_deser::parse_list_faces_response(response)
        }
    }
}

/// Operation shape for `ListStreamProcessors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_stream_processors`](crate::client::Client::list_stream_processors).
///
/// See [`crate::client::fluent_builders::ListStreamProcessors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStreamProcessors {
    _private: (),
}
impl ListStreamProcessors {
    /// Creates a new builder-style object to manufacture [`ListStreamProcessorsInput`](crate::input::ListStreamProcessorsInput)
    pub fn builder() -> crate::input::list_stream_processors_input::Builder {
        crate::input::list_stream_processors_input::Builder::default()
    }
    /// Creates a new `ListStreamProcessors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStreamProcessors {
    type Output = std::result::Result<
        crate::output::ListStreamProcessorsOutput,
        crate::error::ListStreamProcessorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_stream_processors_error(response)
        } else {
            crate::operation_deser::parse_list_stream_processors_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RecognizeCelebrities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`recognize_celebrities`](crate::client::Client::recognize_celebrities).
///
/// See [`crate::client::fluent_builders::RecognizeCelebrities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RecognizeCelebrities {
    _private: (),
}
impl RecognizeCelebrities {
    /// Creates a new builder-style object to manufacture [`RecognizeCelebritiesInput`](crate::input::RecognizeCelebritiesInput)
    pub fn builder() -> crate::input::recognize_celebrities_input::Builder {
        crate::input::recognize_celebrities_input::Builder::default()
    }
    /// Creates a new `RecognizeCelebrities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RecognizeCelebrities {
    type Output = std::result::Result<
        crate::output::RecognizeCelebritiesOutput,
        crate::error::RecognizeCelebritiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_recognize_celebrities_error(response)
        } else {
            crate::operation_deser::parse_recognize_celebrities_response(response)
        }
    }
}

/// Operation shape for `SearchFaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_faces`](crate::client::Client::search_faces).
///
/// See [`crate::client::fluent_builders::SearchFaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchFaces {
    _private: (),
}
impl SearchFaces {
    /// Creates a new builder-style object to manufacture [`SearchFacesInput`](crate::input::SearchFacesInput)
    pub fn builder() -> crate::input::search_faces_input::Builder {
        crate::input::search_faces_input::Builder::default()
    }
    /// Creates a new `SearchFaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchFaces {
    type Output =
        std::result::Result<crate::output::SearchFacesOutput, crate::error::SearchFacesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_faces_error(response)
        } else {
            crate::operation_deser::parse_search_faces_response(response)
        }
    }
}

/// Operation shape for `SearchFacesByImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_faces_by_image`](crate::client::Client::search_faces_by_image).
///
/// See [`crate::client::fluent_builders::SearchFacesByImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchFacesByImage {
    _private: (),
}
impl SearchFacesByImage {
    /// Creates a new builder-style object to manufacture [`SearchFacesByImageInput`](crate::input::SearchFacesByImageInput)
    pub fn builder() -> crate::input::search_faces_by_image_input::Builder {
        crate::input::search_faces_by_image_input::Builder::default()
    }
    /// Creates a new `SearchFacesByImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchFacesByImage {
    type Output = std::result::Result<
        crate::output::SearchFacesByImageOutput,
        crate::error::SearchFacesByImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_faces_by_image_error(response)
        } else {
            crate::operation_deser::parse_search_faces_by_image_response(response)
        }
    }
}

/// Operation shape for `StartCelebrityRecognition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_celebrity_recognition`](crate::client::Client::start_celebrity_recognition).
///
/// See [`crate::client::fluent_builders::StartCelebrityRecognition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartCelebrityRecognition {
    _private: (),
}
impl StartCelebrityRecognition {
    /// Creates a new builder-style object to manufacture [`StartCelebrityRecognitionInput`](crate::input::StartCelebrityRecognitionInput)
    pub fn builder() -> crate::input::start_celebrity_recognition_input::Builder {
        crate::input::start_celebrity_recognition_input::Builder::default()
    }
    /// Creates a new `StartCelebrityRecognition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartCelebrityRecognition {
    type Output = std::result::Result<
        crate::output::StartCelebrityRecognitionOutput,
        crate::error::StartCelebrityRecognitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_celebrity_recognition_error(response)
        } else {
            crate::operation_deser::parse_start_celebrity_recognition_response(response)
        }
    }
}

/// Operation shape for `StartContentModeration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_content_moderation`](crate::client::Client::start_content_moderation).
///
/// See [`crate::client::fluent_builders::StartContentModeration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartContentModeration {
    _private: (),
}
impl StartContentModeration {
    /// Creates a new builder-style object to manufacture [`StartContentModerationInput`](crate::input::StartContentModerationInput)
    pub fn builder() -> crate::input::start_content_moderation_input::Builder {
        crate::input::start_content_moderation_input::Builder::default()
    }
    /// Creates a new `StartContentModeration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartContentModeration {
    type Output = std::result::Result<
        crate::output::StartContentModerationOutput,
        crate::error::StartContentModerationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_content_moderation_error(response)
        } else {
            crate::operation_deser::parse_start_content_moderation_response(response)
        }
    }
}

/// Operation shape for `StartFaceDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_face_detection`](crate::client::Client::start_face_detection).
///
/// See [`crate::client::fluent_builders::StartFaceDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartFaceDetection {
    _private: (),
}
impl StartFaceDetection {
    /// Creates a new builder-style object to manufacture [`StartFaceDetectionInput`](crate::input::StartFaceDetectionInput)
    pub fn builder() -> crate::input::start_face_detection_input::Builder {
        crate::input::start_face_detection_input::Builder::default()
    }
    /// Creates a new `StartFaceDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartFaceDetection {
    type Output = std::result::Result<
        crate::output::StartFaceDetectionOutput,
        crate::error::StartFaceDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_face_detection_error(response)
        } else {
            crate::operation_deser::parse_start_face_detection_response(response)
        }
    }
}

/// Operation shape for `StartFaceSearch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_face_search`](crate::client::Client::start_face_search).
///
/// See [`crate::client::fluent_builders::StartFaceSearch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartFaceSearch {
    _private: (),
}
impl StartFaceSearch {
    /// Creates a new builder-style object to manufacture [`StartFaceSearchInput`](crate::input::StartFaceSearchInput)
    pub fn builder() -> crate::input::start_face_search_input::Builder {
        crate::input::start_face_search_input::Builder::default()
    }
    /// Creates a new `StartFaceSearch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartFaceSearch {
    type Output = std::result::Result<
        crate::output::StartFaceSearchOutput,
        crate::error::StartFaceSearchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_face_search_error(response)
        } else {
            crate::operation_deser::parse_start_face_search_response(response)
        }
    }
}

/// Operation shape for `StartLabelDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_label_detection`](crate::client::Client::start_label_detection).
///
/// See [`crate::client::fluent_builders::StartLabelDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartLabelDetection {
    _private: (),
}
impl StartLabelDetection {
    /// Creates a new builder-style object to manufacture [`StartLabelDetectionInput`](crate::input::StartLabelDetectionInput)
    pub fn builder() -> crate::input::start_label_detection_input::Builder {
        crate::input::start_label_detection_input::Builder::default()
    }
    /// Creates a new `StartLabelDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartLabelDetection {
    type Output = std::result::Result<
        crate::output::StartLabelDetectionOutput,
        crate::error::StartLabelDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_label_detection_error(response)
        } else {
            crate::operation_deser::parse_start_label_detection_response(response)
        }
    }
}

/// Operation shape for `StartPersonTracking`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_person_tracking`](crate::client::Client::start_person_tracking).
///
/// See [`crate::client::fluent_builders::StartPersonTracking`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartPersonTracking {
    _private: (),
}
impl StartPersonTracking {
    /// Creates a new builder-style object to manufacture [`StartPersonTrackingInput`](crate::input::StartPersonTrackingInput)
    pub fn builder() -> crate::input::start_person_tracking_input::Builder {
        crate::input::start_person_tracking_input::Builder::default()
    }
    /// Creates a new `StartPersonTracking` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartPersonTracking {
    type Output = std::result::Result<
        crate::output::StartPersonTrackingOutput,
        crate::error::StartPersonTrackingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_person_tracking_error(response)
        } else {
            crate::operation_deser::parse_start_person_tracking_response(response)
        }
    }
}

/// Operation shape for `StartProjectVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_project_version`](crate::client::Client::start_project_version).
///
/// See [`crate::client::fluent_builders::StartProjectVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartProjectVersion {
    _private: (),
}
impl StartProjectVersion {
    /// Creates a new builder-style object to manufacture [`StartProjectVersionInput`](crate::input::StartProjectVersionInput)
    pub fn builder() -> crate::input::start_project_version_input::Builder {
        crate::input::start_project_version_input::Builder::default()
    }
    /// Creates a new `StartProjectVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartProjectVersion {
    type Output = std::result::Result<
        crate::output::StartProjectVersionOutput,
        crate::error::StartProjectVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_project_version_error(response)
        } else {
            crate::operation_deser::parse_start_project_version_response(response)
        }
    }
}

/// Operation shape for `StartSegmentDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_segment_detection`](crate::client::Client::start_segment_detection).
///
/// See [`crate::client::fluent_builders::StartSegmentDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSegmentDetection {
    _private: (),
}
impl StartSegmentDetection {
    /// Creates a new builder-style object to manufacture [`StartSegmentDetectionInput`](crate::input::StartSegmentDetectionInput)
    pub fn builder() -> crate::input::start_segment_detection_input::Builder {
        crate::input::start_segment_detection_input::Builder::default()
    }
    /// Creates a new `StartSegmentDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSegmentDetection {
    type Output = std::result::Result<
        crate::output::StartSegmentDetectionOutput,
        crate::error::StartSegmentDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_segment_detection_error(response)
        } else {
            crate::operation_deser::parse_start_segment_detection_response(response)
        }
    }
}

/// Operation shape for `StartStreamProcessor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_stream_processor`](crate::client::Client::start_stream_processor).
///
/// See [`crate::client::fluent_builders::StartStreamProcessor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartStreamProcessor {
    _private: (),
}
impl StartStreamProcessor {
    /// Creates a new builder-style object to manufacture [`StartStreamProcessorInput`](crate::input::StartStreamProcessorInput)
    pub fn builder() -> crate::input::start_stream_processor_input::Builder {
        crate::input::start_stream_processor_input::Builder::default()
    }
    /// Creates a new `StartStreamProcessor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartStreamProcessor {
    type Output = std::result::Result<
        crate::output::StartStreamProcessorOutput,
        crate::error::StartStreamProcessorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_stream_processor_error(response)
        } else {
            crate::operation_deser::parse_start_stream_processor_response(response)
        }
    }
}

/// Operation shape for `StartTextDetection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_text_detection`](crate::client::Client::start_text_detection).
///
/// See [`crate::client::fluent_builders::StartTextDetection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartTextDetection {
    _private: (),
}
impl StartTextDetection {
    /// Creates a new builder-style object to manufacture [`StartTextDetectionInput`](crate::input::StartTextDetectionInput)
    pub fn builder() -> crate::input::start_text_detection_input::Builder {
        crate::input::start_text_detection_input::Builder::default()
    }
    /// Creates a new `StartTextDetection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartTextDetection {
    type Output = std::result::Result<
        crate::output::StartTextDetectionOutput,
        crate::error::StartTextDetectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_text_detection_error(response)
        } else {
            crate::operation_deser::parse_start_text_detection_response(response)
        }
    }
}

/// Operation shape for `StopProjectVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_project_version`](crate::client::Client::stop_project_version).
///
/// See [`crate::client::fluent_builders::StopProjectVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopProjectVersion {
    _private: (),
}
impl StopProjectVersion {
    /// Creates a new builder-style object to manufacture [`StopProjectVersionInput`](crate::input::StopProjectVersionInput)
    pub fn builder() -> crate::input::stop_project_version_input::Builder {
        crate::input::stop_project_version_input::Builder::default()
    }
    /// Creates a new `StopProjectVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopProjectVersion {
    type Output = std::result::Result<
        crate::output::StopProjectVersionOutput,
        crate::error::StopProjectVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_project_version_error(response)
        } else {
            crate::operation_deser::parse_stop_project_version_response(response)
        }
    }
}

/// Operation shape for `StopStreamProcessor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_stream_processor`](crate::client::Client::stop_stream_processor).
///
/// See [`crate::client::fluent_builders::StopStreamProcessor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopStreamProcessor {
    _private: (),
}
impl StopStreamProcessor {
    /// Creates a new builder-style object to manufacture [`StopStreamProcessorInput`](crate::input::StopStreamProcessorInput)
    pub fn builder() -> crate::input::stop_stream_processor_input::Builder {
        crate::input::stop_stream_processor_input::Builder::default()
    }
    /// Creates a new `StopStreamProcessor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopStreamProcessor {
    type Output = std::result::Result<
        crate::output::StopStreamProcessorOutput,
        crate::error::StopStreamProcessorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_stream_processor_error(response)
        } else {
            crate::operation_deser::parse_stop_stream_processor_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDatasetEntries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dataset_entries`](crate::client::Client::update_dataset_entries).
///
/// See [`crate::client::fluent_builders::UpdateDatasetEntries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDatasetEntries {
    _private: (),
}
impl UpdateDatasetEntries {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetEntriesInput`](crate::input::UpdateDatasetEntriesInput)
    pub fn builder() -> crate::input::update_dataset_entries_input::Builder {
        crate::input::update_dataset_entries_input::Builder::default()
    }
    /// Creates a new `UpdateDatasetEntries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDatasetEntries {
    type Output = std::result::Result<
        crate::output::UpdateDatasetEntriesOutput,
        crate::error::UpdateDatasetEntriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_dataset_entries_error(response)
        } else {
            crate::operation_deser::parse_update_dataset_entries_response(response)
        }
    }
}
