// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `RekognitionService`.
///
/// This client allows ergonomic access to a `RekognitionService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CompareFaces` operation.
    ///
    /// See [`CompareFaces`](crate::client::fluent_builders::CompareFaces) for more information about the
    /// operation and its arguments.
    pub fn compare_faces(&self) -> fluent_builders::CompareFaces<C, M, R> {
        fluent_builders::CompareFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCollection` operation.
    ///
    /// See [`CreateCollection`](crate::client::fluent_builders::CreateCollection) for more information about the
    /// operation and its arguments.
    pub fn create_collection(&self) -> fluent_builders::CreateCollection<C, M, R> {
        fluent_builders::CreateCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataset` operation.
    ///
    /// See [`CreateDataset`](crate::client::fluent_builders::CreateDataset) for more information about the
    /// operation and its arguments.
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset<C, M, R> {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProjectVersion` operation.
    ///
    /// See [`CreateProjectVersion`](crate::client::fluent_builders::CreateProjectVersion) for more information about the
    /// operation and its arguments.
    pub fn create_project_version(&self) -> fluent_builders::CreateProjectVersion<C, M, R> {
        fluent_builders::CreateProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamProcessor` operation.
    ///
    /// See [`CreateStreamProcessor`](crate::client::fluent_builders::CreateStreamProcessor) for more information about the
    /// operation and its arguments.
    pub fn create_stream_processor(&self) -> fluent_builders::CreateStreamProcessor<C, M, R> {
        fluent_builders::CreateStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCollection` operation.
    ///
    /// See [`DeleteCollection`](crate::client::fluent_builders::DeleteCollection) for more information about the
    /// operation and its arguments.
    pub fn delete_collection(&self) -> fluent_builders::DeleteCollection<C, M, R> {
        fluent_builders::DeleteCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataset` operation.
    ///
    /// See [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset<C, M, R> {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFaces` operation.
    ///
    /// See [`DeleteFaces`](crate::client::fluent_builders::DeleteFaces) for more information about the
    /// operation and its arguments.
    pub fn delete_faces(&self) -> fluent_builders::DeleteFaces<C, M, R> {
        fluent_builders::DeleteFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProjectVersion` operation.
    ///
    /// See [`DeleteProjectVersion`](crate::client::fluent_builders::DeleteProjectVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_project_version(&self) -> fluent_builders::DeleteProjectVersion<C, M, R> {
        fluent_builders::DeleteProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStreamProcessor` operation.
    ///
    /// See [`DeleteStreamProcessor`](crate::client::fluent_builders::DeleteStreamProcessor) for more information about the
    /// operation and its arguments.
    pub fn delete_stream_processor(&self) -> fluent_builders::DeleteStreamProcessor<C, M, R> {
        fluent_builders::DeleteStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCollection` operation.
    ///
    /// See [`DescribeCollection`](crate::client::fluent_builders::DescribeCollection) for more information about the
    /// operation and its arguments.
    pub fn describe_collection(&self) -> fluent_builders::DescribeCollection<C, M, R> {
        fluent_builders::DescribeCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataset` operation.
    ///
    /// See [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset<C, M, R> {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProjects` operation.
    ///
    /// See [`DescribeProjects`](crate::client::fluent_builders::DescribeProjects) for more information about the
    /// operation and its arguments.
    pub fn describe_projects(&self) -> fluent_builders::DescribeProjects<C, M, R> {
        fluent_builders::DescribeProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProjectVersions` operation.
    ///
    /// See [`DescribeProjectVersions`](crate::client::fluent_builders::DescribeProjectVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_project_versions(&self) -> fluent_builders::DescribeProjectVersions<C, M, R> {
        fluent_builders::DescribeProjectVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStreamProcessor` operation.
    ///
    /// See [`DescribeStreamProcessor`](crate::client::fluent_builders::DescribeStreamProcessor) for more information about the
    /// operation and its arguments.
    pub fn describe_stream_processor(&self) -> fluent_builders::DescribeStreamProcessor<C, M, R> {
        fluent_builders::DescribeStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectCustomLabels` operation.
    ///
    /// See [`DetectCustomLabels`](crate::client::fluent_builders::DetectCustomLabels) for more information about the
    /// operation and its arguments.
    pub fn detect_custom_labels(&self) -> fluent_builders::DetectCustomLabels<C, M, R> {
        fluent_builders::DetectCustomLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectFaces` operation.
    ///
    /// See [`DetectFaces`](crate::client::fluent_builders::DetectFaces) for more information about the
    /// operation and its arguments.
    pub fn detect_faces(&self) -> fluent_builders::DetectFaces<C, M, R> {
        fluent_builders::DetectFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectLabels` operation.
    ///
    /// See [`DetectLabels`](crate::client::fluent_builders::DetectLabels) for more information about the
    /// operation and its arguments.
    pub fn detect_labels(&self) -> fluent_builders::DetectLabels<C, M, R> {
        fluent_builders::DetectLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectModerationLabels` operation.
    ///
    /// See [`DetectModerationLabels`](crate::client::fluent_builders::DetectModerationLabels) for more information about the
    /// operation and its arguments.
    pub fn detect_moderation_labels(&self) -> fluent_builders::DetectModerationLabels<C, M, R> {
        fluent_builders::DetectModerationLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectProtectiveEquipment` operation.
    ///
    /// See [`DetectProtectiveEquipment`](crate::client::fluent_builders::DetectProtectiveEquipment) for more information about the
    /// operation and its arguments.
    pub fn detect_protective_equipment(
        &self,
    ) -> fluent_builders::DetectProtectiveEquipment<C, M, R> {
        fluent_builders::DetectProtectiveEquipment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectText` operation.
    ///
    /// See [`DetectText`](crate::client::fluent_builders::DetectText) for more information about the
    /// operation and its arguments.
    pub fn detect_text(&self) -> fluent_builders::DetectText<C, M, R> {
        fluent_builders::DetectText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DistributeDatasetEntries` operation.
    ///
    /// See [`DistributeDatasetEntries`](crate::client::fluent_builders::DistributeDatasetEntries) for more information about the
    /// operation and its arguments.
    pub fn distribute_dataset_entries(&self) -> fluent_builders::DistributeDatasetEntries<C, M, R> {
        fluent_builders::DistributeDatasetEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCelebrityInfo` operation.
    ///
    /// See [`GetCelebrityInfo`](crate::client::fluent_builders::GetCelebrityInfo) for more information about the
    /// operation and its arguments.
    pub fn get_celebrity_info(&self) -> fluent_builders::GetCelebrityInfo<C, M, R> {
        fluent_builders::GetCelebrityInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCelebrityRecognition` operation.
    ///
    /// See [`GetCelebrityRecognition`](crate::client::fluent_builders::GetCelebrityRecognition) for more information about the
    /// operation and its arguments.
    pub fn get_celebrity_recognition(&self) -> fluent_builders::GetCelebrityRecognition<C, M, R> {
        fluent_builders::GetCelebrityRecognition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContentModeration` operation.
    ///
    /// See [`GetContentModeration`](crate::client::fluent_builders::GetContentModeration) for more information about the
    /// operation and its arguments.
    pub fn get_content_moderation(&self) -> fluent_builders::GetContentModeration<C, M, R> {
        fluent_builders::GetContentModeration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFaceDetection` operation.
    ///
    /// See [`GetFaceDetection`](crate::client::fluent_builders::GetFaceDetection) for more information about the
    /// operation and its arguments.
    pub fn get_face_detection(&self) -> fluent_builders::GetFaceDetection<C, M, R> {
        fluent_builders::GetFaceDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFaceSearch` operation.
    ///
    /// See [`GetFaceSearch`](crate::client::fluent_builders::GetFaceSearch) for more information about the
    /// operation and its arguments.
    pub fn get_face_search(&self) -> fluent_builders::GetFaceSearch<C, M, R> {
        fluent_builders::GetFaceSearch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLabelDetection` operation.
    ///
    /// See [`GetLabelDetection`](crate::client::fluent_builders::GetLabelDetection) for more information about the
    /// operation and its arguments.
    pub fn get_label_detection(&self) -> fluent_builders::GetLabelDetection<C, M, R> {
        fluent_builders::GetLabelDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPersonTracking` operation.
    ///
    /// See [`GetPersonTracking`](crate::client::fluent_builders::GetPersonTracking) for more information about the
    /// operation and its arguments.
    pub fn get_person_tracking(&self) -> fluent_builders::GetPersonTracking<C, M, R> {
        fluent_builders::GetPersonTracking::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSegmentDetection` operation.
    ///
    /// See [`GetSegmentDetection`](crate::client::fluent_builders::GetSegmentDetection) for more information about the
    /// operation and its arguments.
    pub fn get_segment_detection(&self) -> fluent_builders::GetSegmentDetection<C, M, R> {
        fluent_builders::GetSegmentDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTextDetection` operation.
    ///
    /// See [`GetTextDetection`](crate::client::fluent_builders::GetTextDetection) for more information about the
    /// operation and its arguments.
    pub fn get_text_detection(&self) -> fluent_builders::GetTextDetection<C, M, R> {
        fluent_builders::GetTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `IndexFaces` operation.
    ///
    /// See [`IndexFaces`](crate::client::fluent_builders::IndexFaces) for more information about the
    /// operation and its arguments.
    pub fn index_faces(&self) -> fluent_builders::IndexFaces<C, M, R> {
        fluent_builders::IndexFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCollections` operation.
    ///
    /// See [`ListCollections`](crate::client::fluent_builders::ListCollections) for more information about the
    /// operation and its arguments.
    pub fn list_collections(&self) -> fluent_builders::ListCollections<C, M, R> {
        fluent_builders::ListCollections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetEntries` operation.
    ///
    /// See [`ListDatasetEntries`](crate::client::fluent_builders::ListDatasetEntries) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_entries(&self) -> fluent_builders::ListDatasetEntries<C, M, R> {
        fluent_builders::ListDatasetEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetLabels` operation.
    ///
    /// See [`ListDatasetLabels`](crate::client::fluent_builders::ListDatasetLabels) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_labels(&self) -> fluent_builders::ListDatasetLabels<C, M, R> {
        fluent_builders::ListDatasetLabels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFaces` operation.
    ///
    /// See [`ListFaces`](crate::client::fluent_builders::ListFaces) for more information about the
    /// operation and its arguments.
    pub fn list_faces(&self) -> fluent_builders::ListFaces<C, M, R> {
        fluent_builders::ListFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStreamProcessors` operation.
    ///
    /// See [`ListStreamProcessors`](crate::client::fluent_builders::ListStreamProcessors) for more information about the
    /// operation and its arguments.
    pub fn list_stream_processors(&self) -> fluent_builders::ListStreamProcessors<C, M, R> {
        fluent_builders::ListStreamProcessors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RecognizeCelebrities` operation.
    ///
    /// See [`RecognizeCelebrities`](crate::client::fluent_builders::RecognizeCelebrities) for more information about the
    /// operation and its arguments.
    pub fn recognize_celebrities(&self) -> fluent_builders::RecognizeCelebrities<C, M, R> {
        fluent_builders::RecognizeCelebrities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchFaces` operation.
    ///
    /// See [`SearchFaces`](crate::client::fluent_builders::SearchFaces) for more information about the
    /// operation and its arguments.
    pub fn search_faces(&self) -> fluent_builders::SearchFaces<C, M, R> {
        fluent_builders::SearchFaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchFacesByImage` operation.
    ///
    /// See [`SearchFacesByImage`](crate::client::fluent_builders::SearchFacesByImage) for more information about the
    /// operation and its arguments.
    pub fn search_faces_by_image(&self) -> fluent_builders::SearchFacesByImage<C, M, R> {
        fluent_builders::SearchFacesByImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartCelebrityRecognition` operation.
    ///
    /// See [`StartCelebrityRecognition`](crate::client::fluent_builders::StartCelebrityRecognition) for more information about the
    /// operation and its arguments.
    pub fn start_celebrity_recognition(
        &self,
    ) -> fluent_builders::StartCelebrityRecognition<C, M, R> {
        fluent_builders::StartCelebrityRecognition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartContentModeration` operation.
    ///
    /// See [`StartContentModeration`](crate::client::fluent_builders::StartContentModeration) for more information about the
    /// operation and its arguments.
    pub fn start_content_moderation(&self) -> fluent_builders::StartContentModeration<C, M, R> {
        fluent_builders::StartContentModeration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFaceDetection` operation.
    ///
    /// See [`StartFaceDetection`](crate::client::fluent_builders::StartFaceDetection) for more information about the
    /// operation and its arguments.
    pub fn start_face_detection(&self) -> fluent_builders::StartFaceDetection<C, M, R> {
        fluent_builders::StartFaceDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFaceSearch` operation.
    ///
    /// See [`StartFaceSearch`](crate::client::fluent_builders::StartFaceSearch) for more information about the
    /// operation and its arguments.
    pub fn start_face_search(&self) -> fluent_builders::StartFaceSearch<C, M, R> {
        fluent_builders::StartFaceSearch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartLabelDetection` operation.
    ///
    /// See [`StartLabelDetection`](crate::client::fluent_builders::StartLabelDetection) for more information about the
    /// operation and its arguments.
    pub fn start_label_detection(&self) -> fluent_builders::StartLabelDetection<C, M, R> {
        fluent_builders::StartLabelDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartPersonTracking` operation.
    ///
    /// See [`StartPersonTracking`](crate::client::fluent_builders::StartPersonTracking) for more information about the
    /// operation and its arguments.
    pub fn start_person_tracking(&self) -> fluent_builders::StartPersonTracking<C, M, R> {
        fluent_builders::StartPersonTracking::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartProjectVersion` operation.
    ///
    /// See [`StartProjectVersion`](crate::client::fluent_builders::StartProjectVersion) for more information about the
    /// operation and its arguments.
    pub fn start_project_version(&self) -> fluent_builders::StartProjectVersion<C, M, R> {
        fluent_builders::StartProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSegmentDetection` operation.
    ///
    /// See [`StartSegmentDetection`](crate::client::fluent_builders::StartSegmentDetection) for more information about the
    /// operation and its arguments.
    pub fn start_segment_detection(&self) -> fluent_builders::StartSegmentDetection<C, M, R> {
        fluent_builders::StartSegmentDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartStreamProcessor` operation.
    ///
    /// See [`StartStreamProcessor`](crate::client::fluent_builders::StartStreamProcessor) for more information about the
    /// operation and its arguments.
    pub fn start_stream_processor(&self) -> fluent_builders::StartStreamProcessor<C, M, R> {
        fluent_builders::StartStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTextDetection` operation.
    ///
    /// See [`StartTextDetection`](crate::client::fluent_builders::StartTextDetection) for more information about the
    /// operation and its arguments.
    pub fn start_text_detection(&self) -> fluent_builders::StartTextDetection<C, M, R> {
        fluent_builders::StartTextDetection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopProjectVersion` operation.
    ///
    /// See [`StopProjectVersion`](crate::client::fluent_builders::StopProjectVersion) for more information about the
    /// operation and its arguments.
    pub fn stop_project_version(&self) -> fluent_builders::StopProjectVersion<C, M, R> {
        fluent_builders::StopProjectVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopStreamProcessor` operation.
    ///
    /// See [`StopStreamProcessor`](crate::client::fluent_builders::StopStreamProcessor) for more information about the
    /// operation and its arguments.
    pub fn stop_stream_processor(&self) -> fluent_builders::StopStreamProcessor<C, M, R> {
        fluent_builders::StopStreamProcessor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDatasetEntries` operation.
    ///
    /// See [`UpdateDatasetEntries`](crate::client::fluent_builders::UpdateDatasetEntries) for more information about the
    /// operation and its arguments.
    pub fn update_dataset_entries(&self) -> fluent_builders::UpdateDatasetEntries<C, M, R> {
        fluent_builders::UpdateDatasetEntries::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CompareFaces`.
    ///
    /// <p>Compares a face in the <i>source</i> input image with
    /// each of the 100 largest faces detected in the <i>target</i> input image.
    /// </p>
    ///
    /// <p> If the source image contains multiple faces, the service detects the largest face
    /// and compares it with each face detected in the target image. </p>
    ///
    ///
    /// <note>
    /// <p>CompareFaces uses machine learning algorithms, which are probabilistic.
    /// A false negative is an incorrect prediction that
    /// a face in the target image has a low similarity confidence score when compared to the face
    /// in the source image. To reduce the probability of false negatives,
    /// we recommend that you compare the target image against multiple source images.
    /// If you plan to use <code>CompareFaces</code> to make a decision that impacts an individual's rights,
    /// privacy, or access to services, we recommend that you pass the result to a human for review and further
    /// validation before taking action.</p>
    /// </note>
    ///
    ///
    /// <p>You pass the input and target images either as base64-encoded image bytes or as
    /// references to images in an Amazon S3 bucket. If you use the
    /// AWS
    /// CLI to call Amazon Rekognition operations, passing image bytes isn't
    /// supported. The image must be formatted as a PNG or JPEG file. </p>
    /// <p>In response, the operation returns an array of face matches ordered by similarity score
    /// in descending order. For each face match, the response provides a bounding box of the face,
    /// facial landmarks, pose details (pitch, role, and yaw), quality (brightness and sharpness), and
    /// confidence value (indicating the level of confidence that the bounding box contains a face).
    /// The response also provides a similarity score, which indicates how closely the faces match. </p>
    ///
    /// <note>
    /// <p>By default, only faces with a similarity score of greater than or equal to 80% are
    /// returned in the response. You can change this value by specifying the
    /// <code>SimilarityThreshold</code> parameter.</p>
    /// </note>
    ///
    /// <p>
    /// <code>CompareFaces</code> also returns an array of faces that don't match the source image.
    /// For each face, it returns a bounding box, confidence value, landmarks, pose details, and quality.
    /// The response also returns information about the face in the source image, including the bounding box
    /// of the face and confidence value.</p>
    ///
    /// <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces
    /// that don’t meet a required quality bar. The quality bar is based on a
    /// variety of common use cases.  Use <code>QualityFilter</code> to set the quality bar
    /// by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>.
    /// If you do not want to filter detected faces, specify <code>NONE</code>. The default value is <code>NONE</code>. </p>
    ///
    /// <p>If the image doesn't contain Exif metadata, <code>CompareFaces</code> returns orientation information for the
    /// source and target images. Use these values to display the images with the correct image orientation.</p>
    /// <p>If no faces are detected in the source or target images, <code>CompareFaces</code> returns an
    /// <code>InvalidParameterException</code> error. </p>
    ///
    ///
    /// <note>
    /// <p> This is a stateless API operation. That is, data returned by this operation doesn't persist.</p>
    /// </note>
    ///
    ///
    /// <p>For an example, see Comparing Faces in Images in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CompareFaces</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct CompareFaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::compare_faces_input::Builder,
    }
    impl<C, M, R> CompareFaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CompareFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompareFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::CompareFacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CompareFacesInputOperationOutputAlias,
                crate::output::CompareFacesOutput,
                crate::error::CompareFacesError,
                crate::input::CompareFacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object.
        /// If you use the AWS CLI to call Amazon Rekognition operations,
        /// passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn source_image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.source_image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object.
        /// If you use the AWS CLI to call Amazon Rekognition operations,
        /// passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_source_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_source_image(input);
            self
        }
        /// <p>The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to
        /// call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
        /// </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn target_image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.target_image(inp);
            self
        }
        /// <p>The target image as base64-encoded bytes or an S3 object. If you use the AWS CLI to
        /// call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.
        /// </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_target_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_target_image(input);
            self
        }
        /// <p>The minimum level of confidence in the face matches that a match must meet to be
        /// included in the <code>FaceMatches</code> array.</p>
        pub fn similarity_threshold(mut self, inp: f32) -> Self {
            self.inner = self.inner.similarity_threshold(inp);
            self
        }
        /// <p>The minimum level of confidence in the face matches that a match must meet to be
        /// included in the <code>FaceMatches</code> array.</p>
        pub fn set_similarity_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_similarity_threshold(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces.
        /// Filtered faces aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar.
        /// If you specify <code>LOW</code>,
        /// <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
        /// don’t meet the chosen quality bar.
        ///
        /// The quality bar is based on a variety of common use cases. Low-quality
        /// detections can occur for a number of reasons. Some examples are an object that's misidentified
        /// as a face, a face that's too blurry, or a face with a
        /// pose that's too extreme to use. If you specify <code>NONE</code>, no
        /// filtering is performed. The default value is <code>NONE</code>.
        /// </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn quality_filter(mut self, inp: crate::model::QualityFilter) -> Self {
            self.inner = self.inner.quality_filter(inp);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces.
        /// Filtered faces aren't compared. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar.
        /// If you specify <code>LOW</code>,
        /// <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
        /// don’t meet the chosen quality bar.
        ///
        /// The quality bar is based on a variety of common use cases. Low-quality
        /// detections can occur for a number of reasons. Some examples are an object that's misidentified
        /// as a face, a face that's too blurry, or a face with a
        /// pose that's too extreme to use. If you specify <code>NONE</code>, no
        /// filtering is performed. The default value is <code>NONE</code>.
        /// </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn set_quality_filter(
            mut self,
            input: std::option::Option<crate::model::QualityFilter>,
        ) -> Self {
            self.inner = self.inner.set_quality_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCollection`.
    ///
    /// <p>Creates a collection in an AWS Region. You can add faces to the collection using the
    /// <a>IndexFaces</a> operation. </p>
    /// <p>For example, you might create collections, one for each of your application users. A
    /// user can then index faces using the <code>IndexFaces</code> operation and persist results in a
    /// specific collection. Then, a user can search the collection for faces in the user-specific
    /// container. </p>
    /// <p>When you create a collection, it is associated with the latest version of the face model version.</p>
    /// <note>
    /// <p>Collection names are case-sensitive.</p>
    /// </note>
    ///
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:CreateCollection</code> action. If you want to tag your collection, you also require permission to perform the <code>rekognition:TagResource</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_collection_input::Builder,
    }
    impl<C, M, R> CreateCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCollectionInputOperationOutputAlias,
                crate::output::CreateCollectionOutput,
                crate::error::CreateCollectionError,
                crate::input::CreateCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID for the collection that you are creating.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>ID for the collection that you are creating.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// A set of tags (key-value pairs) that you want to attach to the collection.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// A set of tags (key-value pairs) that you want to attach to the collection.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates a new Amazon Rekognition Custom Labels dataset. You can create a dataset by using
    /// an Amazon Sagemaker format manifest file or by copying an existing Amazon Rekognition Custom Labels dataset.</p>
    ///
    /// <p>To create a training dataset for a project, specify <code>train</code> for the value of
    /// <code>DatasetType</code>. To create the test dataset for a project,
    /// specify <code>test</code> for the value of <code>DatasetType</code>.
    /// </p>
    ///
    ///
    /// <p>The response from <code>CreateDataset</code> is the Amazon Resource Name (ARN) for the dataset.
    /// Creating a dataset takes a while to complete. Use <a>DescribeDataset</a> to check the
    /// current status. The dataset created successfully if the value of <code>Status</code> is
    /// <code>CREATE_COMPLETE</code>. </p>
    /// <p>To check if any non-terminal errors occurred, call <a>ListDatasetEntries</a>
    /// and check for the presence of <code>errors</code> lists in the JSON Lines.</p>
    /// <p>Dataset creation fails if a terminal error occurs (<code>Status</code> = <code>CREATE_FAILED</code>).
    /// Currently, you can't access the terminal error information.
    ///
    /// </p>
    ///
    ///
    /// <p>For more information, see Creating dataset in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.</p>
    ///
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateDataset</code> action.
    /// If you want to copy an existing dataset, you also require permission to perform the <code>rekognition:ListDatasetEntries</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl<C, M, R> CreateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetInputOperationOutputAlias,
                crate::output::CreateDatasetOutput,
                crate::error::CreateDatasetError,
                crate::input::CreateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3 bucket location
        /// of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>, an empty dataset is created.
        /// To add labeled images to the dataset,  You can use the console or call <a>UpdateDatasetEntries</a>.
        ///
        /// </p>
        pub fn dataset_source(mut self, inp: crate::model::DatasetSource) -> Self {
            self.inner = self.inner.dataset_source(inp);
            self
        }
        /// <p>
        /// The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3 bucket location
        /// of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>, an empty dataset is created.
        /// To add labeled images to the dataset,  You can use the console or call <a>UpdateDatasetEntries</a>.
        ///
        /// </p>
        pub fn set_dataset_source(
            mut self,
            input: std::option::Option<crate::model::DatasetSource>,
        ) -> Self {
            self.inner = self.inner.set_dataset_source(input);
            self
        }
        /// <p>
        /// The type of the dataset. Specify <code>train</code> to create a training dataset. Specify <code>test</code>
        /// to create a test dataset.
        /// </p>
        pub fn dataset_type(mut self, inp: crate::model::DatasetType) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>
        /// The type of the dataset. Specify <code>train</code> to create a training dataset. Specify <code>test</code>
        /// to create a test dataset.
        /// </p>
        pub fn set_dataset_type(
            mut self,
            input: std::option::Option<crate::model::DatasetType>,
        ) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>
        /// The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
        /// </p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>
        /// The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
        /// </p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a new Amazon Rekognition Custom Labels project. A project is a group of resources (datasets, model versions)
    /// that you use to create and manage Amazon Rekognition Custom Labels models.  </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateProject</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to create.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project to create.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProjectVersion`.
    ///
    /// <p>Creates a new version of a model and begins training.
    /// Models are managed as part of an Amazon Rekognition Custom Labels project.
    /// The response from <code>CreateProjectVersion</code>
    /// is an Amazon Resource Name (ARN) for the version of the model. </p>
    ///
    ///
    /// <p>Training uses the training and test datasets associated with the project.
    /// For more information, see Creating training and test dataset in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
    /// </p>
    ///
    ///
    /// <note>
    /// <p>You can train a modelin a project that doesn't have associated datasets by specifying manifest files in the
    /// <code>TrainingData</code> and <code>TestingData</code> fields.
    /// </p>
    /// <p>If you open the console after training a model with manifest files, Amazon Rekognition Custom Labels creates
    /// the datasets for you using the most recent manifest files. You can no longer train
    /// a model version for the project by specifying manifest files. </p>
    /// <p>Instead of training with a project without associated datasets,
    /// we recommend that you use the manifest
    /// files to create training and test datasets for the project.</p>
    /// </note>
    ///
    ///
    /// <p>Training takes a while to complete. You can get the current status by calling
    /// <a>DescribeProjectVersions</a>. Training completed successfully if
    /// the value of the <code>Status</code> field is <code>TRAINING_COMPLETED</code>.</p>
    ///
    /// <p>If training
    /// fails, see Debugging a failed model training in the <i>Amazon Rekognition Custom Labels</i> developer guide. </p>
    ///
    ///
    /// <p>Once training has successfully completed, call <a>DescribeProjectVersions</a> to
    /// get the training results and evaluate the model.  For more information, see Improving a trained Amazon Rekognition Custom Labels model
    /// in the <i>Amazon Rekognition Custom Labels</i> developers guide.
    /// </p>
    ///
    /// <p>After evaluating the model, you start the model
    /// by calling <a>StartProjectVersion</a>.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:CreateProjectVersion</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProjectVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_version_input::Builder,
    }
    impl<C, M, R> CreateProjectVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectVersionInputOperationOutputAlias,
                crate::output::CreateProjectVersionOutput,
                crate::error::CreateProjectVersionError,
                crate::input::CreateProjectVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Amazon Rekognition Custom Labels project that
        /// manages the model that you want to train.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The ARN of the Amazon Rekognition Custom Labels project that
        /// manages the model that you want to train.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>A name for the version of the model. This value must be unique.</p>
        pub fn version_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_name(inp);
            self
        }
        /// <p>A name for the version of the model. This value must be unique.</p>
        pub fn set_version_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_name(input);
            self
        }
        /// <p>The Amazon S3 bucket location to store the results of training.
        /// The S3 bucket can be in any AWS account as long as the caller has
        /// <code>s3:PutObject</code> permissions on the S3 bucket.</p>
        pub fn output_config(mut self, inp: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(inp);
            self
        }
        /// <p>The Amazon S3 bucket location to store the results of training.
        /// The S3 bucket can be in any AWS account as long as the caller has
        /// <code>s3:PutObject</code> permissions on the S3 bucket.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>Specifies an external manifest that the services uses to train the model.
        /// If you specify <code>TrainingData</code> you must also specify <code>TestingData</code>.
        /// The project must not have any associated datasets.
        /// </p>
        pub fn training_data(mut self, inp: crate::model::TrainingData) -> Self {
            self.inner = self.inner.training_data(inp);
            self
        }
        /// <p>Specifies an external manifest that the services uses to train the model.
        /// If you specify <code>TrainingData</code> you must also specify <code>TestingData</code>.
        /// The project must not have any associated datasets.
        /// </p>
        pub fn set_training_data(
            mut self,
            input: std::option::Option<crate::model::TrainingData>,
        ) -> Self {
            self.inner = self.inner.set_training_data(input);
            self
        }
        /// <p>Specifies an external manifest that the service uses to test the model.
        /// If you specify <code>TestingData</code> you must also specify <code>TrainingData</code>.
        /// The project must not have any associated datasets.</p>
        pub fn testing_data(mut self, inp: crate::model::TestingData) -> Self {
            self.inner = self.inner.testing_data(inp);
            self
        }
        /// <p>Specifies an external manifest that the service uses to test the model.
        /// If you specify <code>TestingData</code> you must also specify <code>TrainingData</code>.
        /// The project must not have any associated datasets.</p>
        pub fn set_testing_data(
            mut self,
            input: std::option::Option<crate::model::TestingData>,
        ) -> Self {
            self.inner = self.inner.set_testing_data(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// A set of tags (key-value pairs) that you want to attach to the model.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// A set of tags (key-value pairs) that you want to attach to the model.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The identifier for your AWS Key Management Service key (AWS KMS key).
        /// You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key,
        /// an alias for your KMS key, or an alias ARN.
        /// The key is used to encrypt training and test images copied into the service for model training.
        /// Your source images are unaffected. The key is also used to encrypt training results
        /// and manifest files written to the output Amazon S3 bucket (<code>OutputConfig</code>).</p>
        /// <p>If you choose to use your own KMS key, you need the following permissions on the KMS key.</p>
        /// <ul>
        /// <li>
        /// <p>kms:CreateGrant</p>
        /// </li>
        /// <li>
        /// <p>kms:DescribeKey</p>
        /// </li>
        /// <li>
        /// <p>kms:GenerateDataKey</p>
        /// </li>
        /// <li>
        /// <p>kms:Decrypt</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted
        /// using a key that AWS owns and manages.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The identifier for your AWS Key Management Service key (AWS KMS key).
        /// You can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key,
        /// an alias for your KMS key, or an alias ARN.
        /// The key is used to encrypt training and test images copied into the service for model training.
        /// Your source images are unaffected. The key is also used to encrypt training results
        /// and manifest files written to the output Amazon S3 bucket (<code>OutputConfig</code>).</p>
        /// <p>If you choose to use your own KMS key, you need the following permissions on the KMS key.</p>
        /// <ul>
        /// <li>
        /// <p>kms:CreateGrant</p>
        /// </li>
        /// <li>
        /// <p>kms:DescribeKey</p>
        /// </li>
        /// <li>
        /// <p>kms:GenerateDataKey</p>
        /// </li>
        /// <li>
        /// <p>kms:Decrypt</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify a value for <code>KmsKeyId</code>, images copied into the service are encrypted
        /// using a key that AWS owns and manages.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamProcessor`.
    ///
    /// <p>Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces in a streaming video.</p>
    /// <p>Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. Amazon Rekognition Video sends analysis results to Amazon Kinesis Data Streams.</p>
    /// <p>You provide as input a Kinesis video stream (<code>Input</code>) and a Kinesis data stream (<code>Output</code>) stream. You also specify the
    /// face recognition criteria in <code>Settings</code>. For example, the collection containing faces that you want to recognize.
    /// Use <code>Name</code> to assign an identifier for the stream processor. You use <code>Name</code>
    /// to manage the stream processor. For example, you can start processing the source video by calling <a>StartStreamProcessor</a> with
    /// the <code>Name</code> field. </p>
    /// <p>After you have finished analyzing a streaming video, use <a>StopStreamProcessor</a> to
    /// stop processing. You can delete the stream processor by calling <a>DeleteStreamProcessor</a>.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:CreateStreamProcessor</code> action. If you want to tag your stream processor, you also require permission to perform the <code>rekognition:TagResource</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamProcessor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stream_processor_input::Builder,
    }
    impl<C, M, R> CreateStreamProcessor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamProcessorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamProcessorInputOperationOutputAlias,
                crate::output::CreateStreamProcessorOutput,
                crate::error::CreateStreamProcessorError,
                crate::input::CreateStreamProcessorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is <code>StreamProcessorInput</code>.</p>
        pub fn input(mut self, inp: crate::model::StreamProcessorInput) -> Self {
            self.inner = self.inner.input(inp);
            self
        }
        /// <p>Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is <code>StreamProcessorInput</code>.</p>
        pub fn set_input(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorInput>,
        ) -> Self {
            self.inner = self.inner.set_input(input);
            self
        }
        /// <p>Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.</p>
        pub fn output(mut self, inp: crate::model::StreamProcessorOutput) -> Self {
            self.inner = self.inner.output(inp);
            self
        }
        /// <p>Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is <code>StreamProcessorOutput</code>.</p>
        pub fn set_output(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorOutput>,
        ) -> Self {
            self.inner = self.inner.set_output(input);
            self
        }
        /// <p>An identifier you assign to the stream processor. You can use <code>Name</code> to
        /// manage the stream processor. For example, you can get the current status of the stream processor by calling <a>DescribeStreamProcessor</a>.
        /// <code>Name</code> is idempotent.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>An identifier you assign to the stream processor. You can use <code>Name</code> to
        /// manage the stream processor. For example, you can get the current status of the stream processor by calling <a>DescribeStreamProcessor</a>.
        /// <code>Name</code> is idempotent.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Face recognition input parameters to be used by the stream processor. Includes the collection to use for face recognition and the face
        /// attributes to detect.</p>
        pub fn settings(mut self, inp: crate::model::StreamProcessorSettings) -> Self {
            self.inner = self.inner.settings(inp);
            self
        }
        /// <p>Face recognition input parameters to be used by the stream processor. Includes the collection to use for face recognition and the face
        /// attributes to detect.</p>
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::StreamProcessorSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// <p>ARN of the IAM role that allows access to the stream processor.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>ARN of the IAM role that allows access to the stream processor.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// A set of tags (key-value pairs) that you want to attach to the stream processor.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// A set of tags (key-value pairs) that you want to attach to the stream processor.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCollection`.
    ///
    /// <p>Deletes the specified collection. Note that this operation
    /// removes all faces in the collection. For an example, see <a>delete-collection-procedure</a>.</p>
    ///
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:DeleteCollection</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_collection_input::Builder,
    }
    impl<C, M, R> DeleteCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCollectionInputOperationOutputAlias,
                crate::output::DeleteCollectionOutput,
                crate::error::DeleteCollectionError,
                crate::input::DeleteCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the collection to delete.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>ID of the collection to delete.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes an existing Amazon Rekognition Custom Labels dataset.
    /// Deleting a dataset might take while. Use <a>DescribeDataset</a> to check the
    /// current status. The dataset is still deleting if the value of <code>Status</code> is
    /// <code>DELETE_IN_PROGRESS</code>. If you try to access the dataset after it is deleted, you get
    /// a <code>ResourceNotFoundException</code> exception.
    ///
    /// </p>
    /// <p>You can't delete a dataset while it is creating (<code>Status</code> =  <code>CREATE_IN_PROGRESS</code>)
    /// or if the dataset is updating (<code>Status</code> =  <code>UPDATE_IN_PROGRESS</code>).</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DeleteDataset</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl<C, M, R> DeleteDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetInputOperationOutputAlias,
                crate::output::DeleteDatasetOutput,
                crate::error::DeleteDatasetError,
                crate::input::DeleteDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ARN of the Amazon Rekognition Custom Labels dataset that you want to delete.
        /// </p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>
        /// The ARN of the Amazon Rekognition Custom Labels dataset that you want to delete.
        /// </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFaces`.
    ///
    /// <p>Deletes faces from a collection. You specify a collection ID and an array of face IDs
    /// to remove from the collection.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DeleteFaces</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_faces_input::Builder,
    }
    impl<C, M, R> DeleteFaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFacesInputOperationOutputAlias,
                crate::output::DeleteFacesOutput,
                crate::error::DeleteFacesError,
                crate::input::DeleteFacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Collection from which to remove the specific faces.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>Collection from which to remove the specific faces.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// Appends an item to `FaceIds`.
        ///
        /// To override the contents of this collection use [`set_face_ids`](Self::set_face_ids).
        ///
        /// <p>An array of face IDs to delete.</p>
        pub fn face_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.face_ids(inp);
            self
        }
        /// <p>An array of face IDs to delete.</p>
        pub fn set_face_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_face_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an Amazon Rekognition Custom Labels project.  To delete a project you must first delete all models associated
    /// with the project. To delete a model, see <a>DeleteProjectVersion</a>.</p>
    /// <p>
    /// <code>DeleteProject</code> is an asynchronous operation. To check if the project is deleted,
    /// call <a>DescribeProjects</a>. The project is deleted when the project no longer appears in the
    /// response.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:DeleteProject</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project that you want to delete.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project that you want to delete.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProjectVersion`.
    ///
    /// <p>Deletes an Amazon Rekognition Custom Labels model.  </p>
    /// <p>You can't delete a model if it is running or if it is training.
    /// To check the status of a model, use the <code>Status</code> field returned
    /// from <a>DescribeProjectVersions</a>.
    /// To stop a running model call <a>StopProjectVersion</a>. If the model
    /// is training, wait until it finishes.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:DeleteProjectVersion</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProjectVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_version_input::Builder,
    }
    impl<C, M, R> DeleteProjectVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectVersionInputOperationOutputAlias,
                crate::output::DeleteProjectVersionOutput,
                crate::error::DeleteProjectVersionError,
                crate::input::DeleteProjectVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        pub fn project_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStreamProcessor`.
    ///
    /// <p>Deletes the stream processor identified by <code>Name</code>. You assign the value for <code>Name</code> when you create the stream processor with
    /// <a>CreateStreamProcessor</a>. You might not be able to use the same name for a stream processor for a few seconds after calling <code>DeleteStreamProcessor</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStreamProcessor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stream_processor_input::Builder,
    }
    impl<C, M, R> DeleteStreamProcessor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStreamProcessorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStreamProcessorInputOperationOutputAlias,
                crate::output::DeleteStreamProcessorOutput,
                crate::error::DeleteStreamProcessorError,
                crate::input::DeleteStreamProcessorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream processor you want to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the stream processor you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCollection`.
    ///
    /// <p>Describes the specified collection. You can use <code>DescribeCollection</code> to get
    /// information, such as the number of faces indexed into a collection and the version of the
    /// model used by the collection for face detection.</p>
    ///
    /// <p>For more information, see Describing a Collection in the
    /// Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_collection_input::Builder,
    }
    impl<C, M, R> DescribeCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCollectionInputOperationOutputAlias,
                crate::output::DescribeCollectionOutput,
                crate::error::DescribeCollectionError,
                crate::input::DescribeCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the collection to describe.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>The ID of the collection to describe.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>
    /// Describes an Amazon Rekognition Custom Labels dataset. You can get information such as the current status of a dataset and
    /// statistics about the images and labels in a dataset.  
    /// </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DescribeDataset</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl<C, M, R> DescribeDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetInputOperationOutputAlias,
                crate::output::DescribeDatasetOutput,
                crate::error::DescribeDatasetError,
                crate::input::DescribeDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the dataset that you want to describe.
        /// </p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the dataset that you want to describe.
        /// </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProjects`.
    ///
    /// <p>Gets information about your Amazon Rekognition Custom Labels projects. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DescribeProjects</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_projects_input::Builder,
    }
    impl<C, M, R> DescribeProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectsInputOperationOutputAlias,
                crate::output::DescribeProjectsOutput,
                crate::error::DescribeProjectsError,
                crate::input::DescribeProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `ProjectNames`.
        ///
        /// To override the contents of this collection use [`set_project_names`](Self::set_project_names).
        ///
        /// <p>A list of the projects that you want Amazon Rekognition Custom Labels to describe. If you don't specify a value,
        /// the response includes descriptions for all the projects in your AWS account.</p>
        pub fn project_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_names(inp);
            self
        }
        /// <p>A list of the projects that you want Amazon Rekognition Custom Labels to describe. If you don't specify a value,
        /// the response includes descriptions for all the projects in your AWS account.</p>
        pub fn set_project_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_project_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProjectVersions`.
    ///
    /// <p>Lists and describes the versions of a model in an Amazon Rekognition Custom Labels project. You
    /// can specify up to 10 model versions in <code>ProjectVersionArns</code>. If
    /// you don't specify a value, descriptions for all model versions in the project are returned.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:DescribeProjectVersions</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProjectVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_versions_input::Builder,
    }
    impl<C, M, R> DescribeProjectVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProjectVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectVersionsInputOperationOutputAlias,
                crate::output::DescribeProjectVersionsOutput,
                crate::error::DescribeProjectVersionsError,
                crate::input::DescribeProjectVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the project that contains the models you want to describe.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project that contains the models you want to describe.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// Appends an item to `VersionNames`.
        ///
        /// To override the contents of this collection use [`set_version_names`](Self::set_version_names).
        ///
        /// <p>A list of model version names that you want to describe. You can add up to 10 model version names
        /// to the list. If you don't specify a value, all model descriptions are returned.  A version name is part of a
        /// model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the following ARN.
        /// <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>.</p>
        pub fn version_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_names(inp);
            self
        }
        /// <p>A list of model version names that you want to describe. You can add up to 10 model version names
        /// to the list. If you don't specify a value, all model descriptions are returned.  A version name is part of a
        /// model (ProjectVersion) ARN. For example, <code>my-model.2020-01-21T09.10.15</code> is the version name in the following ARN.
        /// <code>arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/<i>my-model.2020-01-21T09.10.15</i>/1234567890123</code>.</p>
        pub fn set_version_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_version_names(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response.
        /// You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response.
        /// You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call.
        /// The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call.
        /// The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStreamProcessor`.
    ///
    /// <p>Provides information about a stream processor created by <a>CreateStreamProcessor</a>. You can get information about the input and output streams, the input parameters for the face recognition being performed,
    /// and the current status of the stream processor.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStreamProcessor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stream_processor_input::Builder,
    }
    impl<C, M, R> DescribeStreamProcessor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStreamProcessorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStreamProcessorInputOperationOutputAlias,
                crate::output::DescribeStreamProcessorOutput,
                crate::error::DescribeStreamProcessorError,
                crate::input::DescribeStreamProcessorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the stream processor for which you want information.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the stream processor for which you want information.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectCustomLabels`.
    ///
    /// <p>Detects custom labels in a supplied image by using an Amazon Rekognition Custom Labels model. </p>
    /// <p>You specify which version of a model version to use by using the <code>ProjectVersionArn</code> input
    /// parameter. </p>      
    /// <p>You pass the input image as base64-encoded image bytes or as a reference to an image in
    /// an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing
    /// image bytes is not supported. The image must be either a PNG or JPEG formatted file. </p>
    /// <p> For each object that the model version detects on an image, the API returns a
    /// (<code>CustomLabel</code>) object in an array (<code>CustomLabels</code>).
    /// Each <code>CustomLabel</code> object provides the label name (<code>Name</code>), the level
    /// of confidence that the image contains the object (<code>Confidence</code>), and
    /// object location information, if it exists,  for the label on the image (<code>Geometry</code>). </p>
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    ///
    /// <p>To filter labels that are returned, specify a value for <code>MinConfidence</code>.
    /// <code>DetectCustomLabelsLabels</code> only returns labels with a confidence that's higher than
    /// the specified value.
    ///
    /// The value of <code>MinConfidence</code> maps to the assumed threshold values
    /// created during training. For more information, see <i>Assumed threshold</i>
    /// in the Amazon Rekognition Custom Labels Developer Guide.
    /// Amazon Rekognition Custom Labels metrics expresses an assumed threshold as a floating point value between 0-1. The range of
    /// <code>MinConfidence</code> normalizes the threshold value to a percentage value (0-100). Confidence
    /// responses from <code>DetectCustomLabels</code> are also returned as a percentage.
    /// You can use <code>MinConfidence</code> to change the precision and recall or your model.
    /// For more information, see
    /// <i>Analyzing an image</i> in the Amazon Rekognition Custom Labels Developer Guide. </p>
    ///
    /// <p>If you don't specify a value for <code>MinConfidence</code>,  <code>DetectCustomLabels</code>
    /// returns labels based on the assumed threshold of each label.</p>
    ///
    ///
    ///
    ///
    ///
    /// <p>This is a stateless API operation. That is, the operation does not persist any
    /// data.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:DetectCustomLabels</code> action. </p>
    ///
    ///
    ///
    /// <p>For more information, see
    /// <i>Analyzing an image</i> in the Amazon Rekognition Custom Labels Developer Guide. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectCustomLabels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_custom_labels_input::Builder,
    }
    impl<C, M, R> DetectCustomLabels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectCustomLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectCustomLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectCustomLabelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectCustomLabelsInputOperationOutputAlias,
                crate::output::DetectCustomLabelsOutput,
                crate::error::DetectCustomLabelsError,
                crate::input::DetectCustomLabelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the model version that you want to use.</p>
        pub fn project_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(inp);
            self
        }
        /// <p>The ARN of the model version that you want to use.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
        /// <p>Provides the input image either as bytes or an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Rekognition API operation by using the <code>Bytes</code>
        /// property. For example, you would use the <code>Bytes</code> property to pass an image loaded
        /// from a local file system. Image bytes passed by using the <code>Bytes</code> property must be
        /// base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to
        /// call Amazon Rekognition API operations. </p>
        ///
        /// <p>For more information, see Analyzing an Image Loaded from a Local File System
        /// in the Amazon Rekognition Developer Guide.</p>
        /// <p> You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the
        /// <code>S3Object</code> property. Images stored in an S3 bucket do not need to be
        /// base64-encoded.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for
        /// Amazon Rekognition operations.</p>
        /// <p>If you use the
        /// AWS
        /// CLI to call Amazon Rekognition operations, passing image bytes using the Bytes
        /// property is not supported. You must first upload the image to an Amazon S3 bucket and then
        /// call the operation using the S3Object property.</p>
        ///
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3
        /// object. For more information, see Resource Based Policies in the Amazon Rekognition Developer Guide.
        /// </p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>Provides the input image either as bytes or an S3 object.</p>
        /// <p>You pass image bytes to an Amazon Rekognition API operation by using the <code>Bytes</code>
        /// property. For example, you would use the <code>Bytes</code> property to pass an image loaded
        /// from a local file system. Image bytes passed by using the <code>Bytes</code> property must be
        /// base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to
        /// call Amazon Rekognition API operations. </p>
        ///
        /// <p>For more information, see Analyzing an Image Loaded from a Local File System
        /// in the Amazon Rekognition Developer Guide.</p>
        /// <p> You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the
        /// <code>S3Object</code> property. Images stored in an S3 bucket do not need to be
        /// base64-encoded.</p>
        /// <p>The region for the S3 bucket containing the S3 object must match the region you use for
        /// Amazon Rekognition operations.</p>
        /// <p>If you use the
        /// AWS
        /// CLI to call Amazon Rekognition operations, passing image bytes using the Bytes
        /// property is not supported. You must first upload the image to an Amazon S3 bucket and then
        /// call the operation using the S3Object property.</p>
        ///
        /// <p>For Amazon Rekognition to process an S3 object, the user must have permission to access the S3
        /// object. For more information, see Resource Based Policies in the Amazon Rekognition Developer Guide.
        /// </p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Maximum number of results you want the service to return in the response.
        /// The service returns the specified number of highest confidence labels ranked from highest confidence
        /// to lowest.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results you want the service to return in the response.
        /// The service returns the specified number of highest confidence labels ranked from highest confidence
        /// to lowest.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return.
        /// <code>DetectCustomLabels</code> doesn't return any labels with a confidence value that's lower than
        /// this specified value. If you specify a
        /// value of 0, <code>DetectCustomLabels</code> returns all labels, regardless of the assumed
        /// threshold applied to each label.
        /// If you don't specify a value for <code>MinConfidence</code>,  <code>DetectCustomLabels</code>
        /// returns labels based on the assumed threshold of each label.</p>
        pub fn min_confidence(mut self, inp: f32) -> Self {
            self.inner = self.inner.min_confidence(inp);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return.
        /// <code>DetectCustomLabels</code> doesn't return any labels with a confidence value that's lower than
        /// this specified value. If you specify a
        /// value of 0, <code>DetectCustomLabels</code> returns all labels, regardless of the assumed
        /// threshold applied to each label.
        /// If you don't specify a value for <code>MinConfidence</code>,  <code>DetectCustomLabels</code>
        /// returns labels based on the assumed threshold of each label.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectFaces`.
    ///
    /// <p>Detects faces within an image that is provided as input.</p>
    ///
    /// <p>
    /// <code>DetectFaces</code> detects the 100 largest faces in the image. For each face
    /// detected, the operation returns face details. These details include a bounding box of the
    /// face, a confidence value (that the bounding box contains a face), and a fixed set of
    /// attributes such as facial landmarks (for example, coordinates of eye and mouth),
    /// presence of beard, sunglasses, and so on. </p>
    /// <p>The face-detection algorithm is most effective on frontal faces. For non-frontal or
    /// obscured faces, the algorithm might not detect the faces or might detect faces with lower
    /// confidence. </p>
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an
    /// image in an Amazon S3 bucket. If you use the AWS CLI
    /// to call Amazon Rekognition operations, passing image bytes is not
    /// supported. The image must be either a PNG or JPEG formatted file. </p>
    ///
    /// <note>
    /// <p>This is a stateless API operation. That is, the operation does not persist any
    /// data.</p>
    /// </note>
    ///
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:DetectFaces</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectFaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_faces_input::Builder,
    }
    impl<C, M, R> DetectFaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectFacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectFacesInputOperationOutputAlias,
                crate::output::DetectFacesOutput,
                crate::error::DetectFacesError,
                crate::input::DetectFacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>An array of facial attributes you want to be returned. This can be the default list of
        /// attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if
        /// you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial
        /// attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>,
        /// <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
        /// facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND
        /// operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn attributes(mut self, inp: impl Into<crate::model::Attribute>) -> Self {
            self.inner = self.inner.attributes(inp);
            self
        }
        /// <p>An array of facial attributes you want to be returned. This can be the default list of
        /// attributes or all attributes. If you don't specify a value for <code>Attributes</code> or if
        /// you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial
        /// attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>,
        /// <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
        /// facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND
        /// operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectLabels`.
    ///
    /// <p>Detects instances of real-world entities within an image (JPEG or PNG)
    /// provided as input. This includes objects like flower, tree, and table; events like
    /// wedding, graduation, and birthday party; and concepts like landscape, evening, and nature.
    /// </p>
    ///
    /// <p>For an example, see Analyzing Images Stored in an Amazon S3 Bucket in the Amazon Rekognition Developer Guide.</p>
    /// <note>
    /// <p>
    /// <code>DetectLabels</code> does not support the detection of activities. However, activity detection
    /// is supported for label detection in videos. For more information, see StartLabelDetection in the Amazon Rekognition Developer Guide.</p>
    /// </note>
    ///
    /// <p>You pass the input image as base64-encoded image bytes or as a reference to an image in
    /// an Amazon S3 bucket. If you use the
    /// AWS
    /// CLI to call Amazon Rekognition operations, passing image bytes is not
    /// supported. The image must be either a PNG or JPEG formatted file. </p>
    /// <p> For each object, scene, and concept the API returns one or more labels. Each label
    /// provides the object name, and the level of confidence that the image contains the object. For
    /// example, suppose the input image has a lighthouse, the sea, and a rock. The response includes
    /// all three labels, one for each object. </p>
    ///
    /// <p>
    /// <code>{Name: lighthouse, Confidence: 98.4629}</code>
    /// </p>
    /// <p>
    /// <code>{Name: rock,Confidence: 79.2097}</code>
    /// </p>
    /// <p>
    /// <code> {Name: sea,Confidence: 75.061}</code>
    /// </p>
    /// <p>In the preceding example, the operation returns one label for each of the three
    /// objects. The operation can also return multiple labels for the same object in the image. For
    /// example, if the input image shows a flower (for example, a tulip), the operation might return
    /// the following three labels. </p>
    /// <p>
    /// <code>{Name: flower,Confidence: 99.0562}</code>
    /// </p>
    /// <p>
    /// <code>{Name: plant,Confidence: 99.0562}</code>
    /// </p>
    /// <p>
    /// <code>{Name: tulip,Confidence: 99.0562}</code>
    /// </p>
    ///
    /// <p>In this example, the detection algorithm more precisely identifies the flower as a
    /// tulip.</p>
    /// <p>In response, the API returns an array of labels. In addition, the response also
    /// includes the orientation correction. Optionally, you can specify <code>MinConfidence</code> to
    /// control the confidence threshold for the labels returned. The default is 55%. You can also add
    /// the <code>MaxLabels</code> parameter to limit the number of labels returned. </p>
    /// <note>
    /// <p>If the object detected is a person, the operation doesn't provide the same facial
    /// details that the <a>DetectFaces</a> operation provides.</p>
    /// </note>
    /// <p>
    /// <code>DetectLabels</code> returns bounding boxes for instances of common object labels in an array of
    /// <a>Instance</a> objects. An <code>Instance</code> object contains a
    /// <a>BoundingBox</a> object, for the location of the label on the image. It also includes
    /// the confidence by which the bounding box was detected.</p>
    /// <p>
    /// <code>DetectLabels</code> also returns a hierarchical taxonomy of detected labels. For example,
    /// a detected car might be assigned the label <i>car</i>. The label <i>car</i>
    /// has two parent labels: <i>Vehicle</i> (its parent) and <i>Transportation</i> (its
    /// grandparent).  
    /// The response returns the entire list of ancestors for a label. Each ancestor is a unique label in the response.
    /// In the previous example, <i>Car</i>, <i>Vehicle</i>, and <i>Transportation</i>
    /// are returned as unique labels in the response.
    /// </p>
    /// <p>This is a stateless API operation. That is, the operation does not persist any
    /// data.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:DetectLabels</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectLabels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_labels_input::Builder,
    }
    impl<C, M, R> DetectLabels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectLabelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectLabelsInputOperationOutputAlias,
                crate::output::DetectLabelsOutput,
                crate::error::DetectLabelsError,
                crate::input::DetectLabelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do
        /// not need to be base64-encoded.</p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing image bytes is not supported. Images stored in an S3 Bucket do
        /// not need to be base64-encoded.</p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Maximum number of labels you want the service to return in the response. The service
        /// returns the specified number of highest confidence labels. </p>
        pub fn max_labels(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_labels(inp);
            self
        }
        /// <p>Maximum number of labels you want the service to return in the response. The service
        /// returns the specified number of highest confidence labels. </p>
        pub fn set_max_labels(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_labels(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't
        /// return any labels with confidence lower than this specified value.</p>
        /// <p>If <code>MinConfidence</code> is not specified, the operation returns labels with a
        /// confidence values greater than or equal to 55 percent.</p>
        pub fn min_confidence(mut self, inp: f32) -> Self {
            self.inner = self.inner.min_confidence(inp);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't
        /// return any labels with confidence lower than this specified value.</p>
        /// <p>If <code>MinConfidence</code> is not specified, the operation returns labels with a
        /// confidence values greater than or equal to 55 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectModerationLabels`.
    ///
    /// <p>Detects unsafe content in a specified JPEG or PNG format image.
    /// Use <code>DetectModerationLabels</code> to moderate images depending on your requirements.
    /// For example, you might want to filter images that contain nudity, but not images containing
    /// suggestive content.</p>
    /// <p>To filter images, use the labels returned by <code>DetectModerationLabels</code>
    /// to determine which types of content are appropriate.</p>
    ///
    /// <p>For information about moderation labels,
    /// see Detecting Unsafe Content in the Amazon Rekognition Developer Guide.</p>
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an
    /// image in an Amazon S3 bucket. If you use the
    /// AWS
    /// CLI to call Amazon Rekognition operations, passing image bytes is not
    /// supported. The image must be either a PNG or JPEG formatted file. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectModerationLabels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_moderation_labels_input::Builder,
    }
    impl<C, M, R> DetectModerationLabels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectModerationLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectModerationLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectModerationLabelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectModerationLabelsInputOperationOutputAlias,
                crate::output::DetectModerationLabelsOutput,
                crate::error::DetectModerationLabelsError,
                crate::input::DetectModerationLabelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object.
        /// If you use the AWS CLI to call Amazon Rekognition operations,
        /// passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object.
        /// If you use the AWS CLI to call Amazon Rekognition operations,
        /// passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't
        /// return any labels with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with
        /// confidence values greater than or equal to 50 percent.</p>
        pub fn min_confidence(mut self, inp: f32) -> Self {
            self.inner = self.inner.min_confidence(inp);
            self
        }
        /// <p>Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't
        /// return any labels with a confidence level lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with
        /// confidence values greater than or equal to 50 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
        /// <p>Sets up the configuration for human evaluation, including the FlowDefinition
        /// the image will be sent to.</p>
        pub fn human_loop_config(mut self, inp: crate::model::HumanLoopConfig) -> Self {
            self.inner = self.inner.human_loop_config(inp);
            self
        }
        /// <p>Sets up the configuration for human evaluation, including the FlowDefinition
        /// the image will be sent to.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.inner = self.inner.set_human_loop_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectProtectiveEquipment`.
    ///
    /// <p>Detects Personal Protective Equipment (PPE) worn by people detected in an image. Amazon Rekognition can detect the
    /// following types of PPE.</p>
    /// <ul>
    /// <li>
    /// <p>Face cover</p>
    /// </li>
    /// <li>
    /// <p>Hand cover</p>
    /// </li>
    /// <li>
    /// <p>Head cover</p>
    /// </li>
    /// </ul>
    ///
    /// <p>You pass the input image as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket.
    /// The image must be either a PNG or JPG formatted file. </p>
    ///
    /// <p>
    /// <code>DetectProtectiveEquipment</code> detects PPE worn by up to 15 persons detected in an image.</p>
    /// <p>For each person detected in the image the API returns an array of body parts (face, head, left-hand, right-hand).
    /// For each body part, an array of detected items of PPE is returned, including an indicator of whether or not the PPE
    /// covers the body part. The API returns the confidence it has in each detection
    /// (person, PPE, body part and body part coverage). It also returns a bounding box (<a>BoundingBox</a>) for each detected
    /// person and each detected item of PPE. </p>
    /// <p>You can optionally request a summary of detected PPE items with the <code>SummarizationAttributes</code> input parameter.
    /// The summary provides the following information. </p>
    /// <ul>
    /// <li>
    /// <p>The persons detected as wearing all of the types of PPE that you specify.</p>
    /// </li>
    /// <li>
    /// <p>The persons detected as not wearing all of the types PPE that you specify.</p>
    /// </li>
    /// <li>
    /// <p>The persons detected where PPE adornment could not be determined. </p>
    /// </li>
    /// </ul>
    /// <p>This is a stateless API operation. That is, the operation does not persist any data.</p>
    ///
    /// <p>This operation requires permissions to perform the <code>rekognition:DetectProtectiveEquipment</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct DetectProtectiveEquipment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_protective_equipment_input::Builder,
    }
    impl<C, M, R> DetectProtectiveEquipment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectProtectiveEquipment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectProtectiveEquipmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectProtectiveEquipmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectProtectiveEquipmentInputOperationOutputAlias,
                crate::output::DetectProtectiveEquipmentOutput,
                crate::error::DetectProtectiveEquipmentError,
                crate::input::DetectProtectiveEquipmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you can
        /// reference an image stored in an Amazon S3 bucket. </p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The image in which you want to detect PPE on detected persons. The image can be passed as image bytes or you can
        /// reference an image stored in an Amazon S3 bucket. </p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>An array of PPE types that you want to summarize.</p>
        pub fn summarization_attributes(
            mut self,
            inp: crate::model::ProtectiveEquipmentSummarizationAttributes,
        ) -> Self {
            self.inner = self.inner.summarization_attributes(inp);
            self
        }
        /// <p>An array of PPE types that you want to summarize.</p>
        pub fn set_summarization_attributes(
            mut self,
            input: std::option::Option<crate::model::ProtectiveEquipmentSummarizationAttributes>,
        ) -> Self {
            self.inner = self.inner.set_summarization_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectText`.
    ///
    /// <p>Detects text in the input image and converts it into machine-readable text.</p>
    /// <p>Pass the input image as base64-encoded image bytes or as a reference to an image in an
    /// Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, you must pass it as a
    /// reference to an image in an Amazon S3 bucket. For the AWS CLI, passing image bytes is not
    /// supported. The image must be either a .png or .jpeg formatted file. </p>
    /// <p>The <code>DetectText</code> operation returns text in an array of <a>TextDetection</a> elements, <code>TextDetections</code>. Each
    /// <code>TextDetection</code> element provides information about a single word or line of text
    /// that was detected in the image. </p>
    /// <p>A word is one or more ISO basic latin script characters that are not separated by spaces.
    /// <code>DetectText</code> can detect up to 100 words in an image.</p>
    /// <p>A line is a string of equally spaced words. A line isn't necessarily a complete
    /// sentence. For example, a driver's license number is detected as a line. A line ends when there
    /// is no aligned text after it. Also, a line ends when there is a large gap between words,
    /// relative to the length of the words. This means, depending on the gap between words, Amazon Rekognition
    /// may detect multiple lines in text aligned in the same direction. Periods don't represent the
    /// end of a line. If a sentence spans multiple lines, the <code>DetectText</code> operation
    /// returns multiple lines.</p>
    /// <p>To determine whether a <code>TextDetection</code> element is a line of text or a word,
    /// use the <code>TextDetection</code> object <code>Type</code> field. </p>
    /// <p>To be detected, text must be within +/- 90 degrees orientation of the horizontal axis.</p>
    ///
    /// <p>For more information, see DetectText in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectText<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_text_input::Builder,
    }
    impl<C, M, R> DetectText<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectTextOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectTextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectTextInputOperationOutputAlias,
                crate::output::DetectTextOutput,
                crate::error::DetectTextError,
                crate::input::DetectTextInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Rekognition operations, you can't pass image bytes. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an Amazon S3 object. If you use the AWS CLI
        /// to call Amazon Rekognition operations, you can't pass image bytes. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Optional parameters that let you set the criteria that the text must meet to be included in your response.</p>
        pub fn filters(mut self, inp: crate::model::DetectTextFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional parameters that let you set the criteria that the text must meet to be included in your response.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::DetectTextFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DistributeDatasetEntries`.
    ///
    /// <p>Distributes the entries (images) in a training dataset across the training dataset and the test dataset for a project.
    /// <code>DistributeDatasetEntries</code> moves 20% of the training dataset images to the test dataset.
    /// An entry is a JSON Line that describes an image.
    /// </p>
    /// <p>You supply the Amazon Resource Names (ARN) of a project's training dataset and test dataset.
    /// The training dataset must contain the images that you want to split. The test dataset
    /// must be empty. The datasets must belong to the same project. To create training and test datasets for a project, call <a>CreateDataset</a>.</p>
    /// <p>Distributing a dataset takes a while to complete. To check the status call <code>DescribeDataset</code>. The operation
    /// is complete when the <code>Status</code> field for the training dataset and the test dataset is <code>UPDATE_COMPLETE</code>.
    /// If the dataset split fails, the value of <code>Status</code> is <code>UPDATE_FAILED</code>.</p>
    ///
    /// <p>This operation requires permissions to perform the <code>rekognition:DistributeDatasetEntries</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct DistributeDatasetEntries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::distribute_dataset_entries_input::Builder,
    }
    impl<C, M, R> DistributeDatasetEntries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DistributeDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DistributeDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DistributeDatasetEntriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DistributeDatasetEntriesInputOperationOutputAlias,
                crate::output::DistributeDatasetEntriesOutput,
                crate::error::DistributeDatasetEntriesError,
                crate::input::DistributeDatasetEntriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Datasets`.
        ///
        /// To override the contents of this collection use [`set_datasets`](Self::set_datasets).
        ///
        /// <p>The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to
        /// the same project. The test dataset must be empty.
        /// </p>
        pub fn datasets(mut self, inp: impl Into<crate::model::DistributeDataset>) -> Self {
            self.inner = self.inner.datasets(inp);
            self
        }
        /// <p>The ARNS for the training dataset and test dataset that you want to use. The datasets must belong to
        /// the same project. The test dataset must be empty.
        /// </p>
        pub fn set_datasets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DistributeDataset>>,
        ) -> Self {
            self.inner = self.inner.set_datasets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCelebrityInfo`.
    ///
    /// <p>Gets the name and additional information about a celebrity based on their Amazon Rekognition ID.
    /// The additional information is returned as an array of URLs. If there is no additional
    /// information about the celebrity, this list is empty.</p>
    ///
    /// <p>For more information, see Recognizing Celebrities in an Image in
    /// the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:GetCelebrityInfo</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetCelebrityInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_celebrity_info_input::Builder,
    }
    impl<C, M, R> GetCelebrityInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCelebrityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCelebrityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCelebrityInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCelebrityInfoInputOperationOutputAlias,
                crate::output::GetCelebrityInfoOutput,
                crate::error::GetCelebrityInfoError,
                crate::input::GetCelebrityInfoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the celebrity. You get the celebrity ID from a call to the <a>RecognizeCelebrities</a> operation,
        /// which recognizes celebrities in an image. </p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID for the celebrity. You get the celebrity ID from a call to the <a>RecognizeCelebrities</a> operation,
        /// which recognizes celebrities in an image. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCelebrityRecognition`.
    ///
    /// <p>Gets the celebrity recognition results for a Amazon Rekognition Video analysis started by
    /// <a>StartCelebrityRecognition</a>.</p>
    /// <p>Celebrity recognition in a video is an asynchronous operation. Analysis is started by a
    /// call to <a>StartCelebrityRecognition</a> which returns a job identifier
    /// (<code>JobId</code>). </p>
    /// <p>When the celebrity recognition operation finishes, Amazon Rekognition Video publishes a completion
    /// status to the Amazon Simple Notification Service topic registered in the initial call to
    /// <code>StartCelebrityRecognition</code>. To get the results of the celebrity recognition
    /// analysis, first check that the status value published to the Amazon SNS topic is
    /// <code>SUCCEEDED</code>. If so, call <code>GetCelebrityDetection</code> and pass the job
    /// identifier (<code>JobId</code>) from the initial call to <code>StartCelebrityDetection</code>. </p>
    ///
    /// <p>For more information, see Working With Stored Videos in the Amazon Rekognition Developer Guide.</p>
    /// <p>
    /// <code>GetCelebrityRecognition</code> returns detected celebrities and the time(s) they
    /// are detected in an array (<code>Celebrities</code>) of <a>CelebrityRecognition</a>
    /// objects. Each <code>CelebrityRecognition</code>
    /// contains information about the celebrity in a <a>CelebrityDetail</a> object and the
    /// time, <code>Timestamp</code>, the celebrity was detected.  This <a>CelebrityDetail</a> object stores information about the detected celebrity's face
    /// attributes, a face bounding box, known gender, the celebrity's name, and a confidence
    /// estimate.</p>
    /// <note>
    /// <p>
    /// <code>GetCelebrityRecognition</code> only returns the default facial
    /// attributes (<code>BoundingBox</code>, <code>Confidence</code>, <code>Landmarks</code>,
    /// <code>Pose</code>, and <code>Quality</code>). The <code>BoundingBox</code> field only
    /// applies to the detected face instance. The other facial attributes listed in the
    /// <code>Face</code> object of the following response syntax are not returned. For more
    /// information, see FaceDetail in the Amazon Rekognition Developer Guide. </p>
    /// </note>
    /// <p>By default, the <code>Celebrities</code> array is sorted by time (milliseconds from the start of the video).
    /// You can also sort the array by celebrity by specifying the value <code>ID</code> in the <code>SortBy</code> input parameter.</p>
    /// <p>The <code>CelebrityDetail</code> object includes the celebrity identifer and additional information urls. If you don't store
    /// the additional information urls, you can get them later by calling <a>GetCelebrityInfo</a> with the celebrity identifer.</p>
    /// <p>No information is returned for faces not recognized as celebrities.</p>
    /// <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than
    /// specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
    /// pagination token for getting the next set of results. To get the next page of results, call <code>GetCelebrityDetection</code>
    /// and populate the <code>NextToken</code> request parameter with the token
    /// value returned from the previous call to <code>GetCelebrityRecognition</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCelebrityRecognition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_celebrity_recognition_input::Builder,
    }
    impl<C, M, R> GetCelebrityRecognition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCelebrityRecognition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCelebrityRecognitionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCelebrityRecognitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCelebrityRecognitionInputOperationOutputAlias,
                crate::output::GetCelebrityRecognitionOutput,
                crate::error::GetCelebrityRecognitionError,
                crate::input::GetCelebrityRecognitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Job identifier for the required celebrity recognition analysis. You can get the job identifer from
        /// a call to <code>StartCelebrityRecognition</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>Job identifier for the required celebrity recognition analysis. You can get the job identifer from
        /// a call to <code>StartCelebrityRecognition</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more recognized celebrities to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of celebrities. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more recognized celebrities to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of celebrities. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for celebrities returned in <code>Celebrities</code> field. Specify <code>ID</code> to sort by the celebrity identifier,
        /// specify <code>TIMESTAMP</code> to sort by the time the celebrity was recognized.</p>
        pub fn sort_by(mut self, inp: crate::model::CelebrityRecognitionSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Sort to use for celebrities returned in <code>Celebrities</code> field. Specify <code>ID</code> to sort by the celebrity identifier,
        /// specify <code>TIMESTAMP</code> to sort by the time the celebrity was recognized.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::CelebrityRecognitionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContentModeration`.
    ///
    /// <p>Gets the inappropriate, unwanted, or offensive content analysis results for a Amazon Rekognition Video analysis started by
    /// <a>StartContentModeration</a>. For a list of moderation labels in Amazon Rekognition, see
    /// <a href="https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api">Using the image and video moderation APIs</a>.</p>
    ///
    /// <p>Amazon Rekognition Video inappropriate or offensive content detection in a stored video is an asynchronous operation. You start analysis by calling
    /// <a>StartContentModeration</a> which returns a job identifier (<code>JobId</code>).
    /// When analysis finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service
    /// topic registered in the initial call to <code>StartContentModeration</code>.
    /// To get the results of the content analysis, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call  <code>GetContentModeration</code> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartContentModeration</code>. </p>
    ///
    /// <p>For more information, see Working with Stored Videos in the
    /// Amazon Rekognition Devlopers Guide.</p>
    /// <p>
    /// <code>GetContentModeration</code> returns detected inappropriate, unwanted, or offensive content moderation labels,
    /// and the time they are detected, in an array, <code>ModerationLabels</code>, of
    /// <a>ContentModerationDetection</a> objects.
    /// </p>
    /// <p>By default, the moderated labels are returned sorted by time, in milliseconds from the start of the
    /// video. You can also sort them by moderated label by specifying <code>NAME</code> for the <code>SortBy</code>
    /// input parameter. </p>
    /// <p>Since video analysis can return a large number of results, use the <code>MaxResults</code> parameter to limit
    /// the number of labels returned in a single call to <code>GetContentModeration</code>. If there are more results than
    /// specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a
    /// pagination token for getting the next set of results. To get the next page of results, call <code>GetContentModeration</code>
    /// and populate the <code>NextToken</code> request parameter with the value of <code>NextToken</code>
    /// returned from the previous call to <code>GetContentModeration</code>.</p>
    ///
    /// <p>For more information, see Content moderation in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContentModeration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_content_moderation_input::Builder,
    }
    impl<C, M, R> GetContentModeration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContentModeration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContentModerationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContentModerationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContentModerationInputOperationOutputAlias,
                crate::output::GetContentModerationOutput,
                crate::error::GetContentModerationError,
                crate::input::GetContentModerationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the inappropriate, unwanted, or offensive content moderation job. Use <code>JobId</code> to identify the job in
        /// a subsequent call to <code>GetContentModeration</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier for the inappropriate, unwanted, or offensive content moderation job. Use <code>JobId</code> to identify the job in
        /// a subsequent call to <code>GetContentModeration</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of content moderation labels.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Rekognition
        /// returns a pagination token in the response. You can use this pagination token
        /// to retrieve the next set of content moderation labels.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for elements in the <code>ModerationLabelDetections</code> array.
        /// Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected.
        /// Use <code>NAME</code> to alphabetically group elements for a label together.
        /// Within each label group, the array element are sorted by detection confidence.
        /// The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn sort_by(mut self, inp: crate::model::ContentModerationSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Sort to use for elements in the <code>ModerationLabelDetections</code> array.
        /// Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected.
        /// Use <code>NAME</code> to alphabetically group elements for a label together.
        /// Within each label group, the array element are sorted by detection confidence.
        /// The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ContentModerationSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFaceDetection`.
    ///
    /// <p>Gets face detection results for a Amazon Rekognition Video analysis started by <a>StartFaceDetection</a>.</p>
    /// <p>Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling <a>StartFaceDetection</a>
    /// which returns a job identifier (<code>JobId</code>). When the face detection operation finishes, Amazon Rekognition Video publishes a completion status to
    /// the Amazon Simple Notification Service topic registered in the initial call to <code>StartFaceDetection</code>. To get the results
    /// of the face detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>.
    /// If so, call  <a>GetFaceDetection</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.</p>
    /// <p>
    /// <code>GetFaceDetection</code> returns an array of detected faces (<code>Faces</code>) sorted by the time the faces were detected. </p>
    /// <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than
    /// specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set
    /// of results. To get the next page of results, call <code>GetFaceDetection</code> and populate the <code>NextToken</code> request parameter with the token
    /// value returned from the previous call to <code>GetFaceDetection</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFaceDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_face_detection_input::Builder,
    }
    impl<C, M, R> GetFaceDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFaceDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFaceDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFaceDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFaceDetectionInputOperationOutputAlias,
                crate::output::GetFaceDetectionOutput,
                crate::error::GetFaceDetectionError,
                crate::input::GetFaceDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique identifier for the face detection job. The <code>JobId</code> is returned from <code>StartFaceDetection</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>Unique identifier for the face detection job. The <code>JobId</code> is returned from <code>StartFaceDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more faces to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of faces.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more faces to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of faces.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFaceSearch`.
    ///
    /// <p>Gets the face search results for Amazon Rekognition Video face search started by
    /// <a>StartFaceSearch</a>. The search returns faces in a collection that match the faces
    /// of persons detected in a video. It also includes the time(s) that faces are matched in the video.</p>
    /// <p>Face search in a video is an asynchronous operation. You start face search by calling
    /// to <a>StartFaceSearch</a> which returns a job identifier (<code>JobId</code>).
    /// When the search operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service
    /// topic registered in the initial call to <code>StartFaceSearch</code>.
    /// To get the search results, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call  <code>GetFaceSearch</code> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartFaceSearch</code>.</p>
    ///
    /// <p>For more information, see Searching Faces in a Collection in the
    /// Amazon Rekognition Developer Guide.</p>
    /// <p>The search results are retured in an array, <code>Persons</code>, of
    /// <a>PersonMatch</a> objects. Each<code>PersonMatch</code> element contains
    /// details about the matching faces in the input collection, person information (facial attributes,
    /// bounding boxes, and person identifer)
    /// for the matched person, and the time the person was matched in the video.</p>
    /// <note>
    /// <p>
    /// <code>GetFaceSearch</code> only returns the default  
    /// facial attributes (<code>BoundingBox</code>, <code>Confidence</code>,
    /// <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial attributes listed
    /// in the <code>Face</code> object of the following response syntax are not returned. For more information,
    /// see FaceDetail in the Amazon Rekognition Developer Guide. </p>
    /// </note>
    ///
    /// <p>By default, the <code>Persons</code> array is sorted by the time, in milliseconds from the
    /// start of the video, persons are matched.
    /// You can also sort by persons by specifying <code>INDEX</code> for the <code>SORTBY</code> input
    /// parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFaceSearch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_face_search_input::Builder,
    }
    impl<C, M, R> GetFaceSearch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFaceSearch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFaceSearchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFaceSearchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFaceSearchInputOperationOutputAlias,
                crate::output::GetFaceSearchOutput,
                crate::error::GetFaceSearchError,
                crate::input::GetFaceSearchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The job identifer for the search request. You get the job identifier from an initial call to <code>StartFaceSearch</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The job identifer for the search request. You get the job identifier from an initial call to <code>StartFaceSearch</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of search results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of search results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time
        /// that they are recognized. Use <code>INDEX</code> to sort by recognized faces. </p>
        pub fn sort_by(mut self, inp: crate::model::FaceSearchSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Sort to use for grouping faces in the response. Use <code>TIMESTAMP</code> to group faces by the time
        /// that they are recognized. Use <code>INDEX</code> to sort by recognized faces. </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::FaceSearchSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLabelDetection`.
    ///
    /// <p>Gets the label detection results of a Amazon Rekognition Video analysis started by <a>StartLabelDetection</a>.  </p>
    ///
    /// <p>The label detection operation is started by a call to <a>StartLabelDetection</a>
    /// which returns a job identifier (<code>JobId</code>). When the label detection operation finishes, Amazon Rekognition publishes a completion status to
    /// the Amazon Simple Notification Service topic registered in the initial call to <code>StartlabelDetection</code>. To get the results
    /// of the label detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>.
    /// If so, call  <a>GetLabelDetection</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.</p>
    /// <p>
    /// <code>GetLabelDetection</code> returns an array of detected labels (<code>Labels</code>) sorted by the time
    /// the labels were detected. You can also sort by the label name by specifying <code>NAME</code> for the
    /// <code>SortBy</code> input parameter.</p>
    /// <p>The labels returned include the label name, the percentage confidence in the accuracy of the detected label,
    /// and the time the label was detected in the video.</p>
    /// <p>The returned labels also include bounding box information for common objects, a
    /// hierarchical taxonomy of detected labels, and the version of the label model used for detection.</p>
    ///
    /// <p>Use MaxResults parameter to limit the number of labels returned. If there are more results than
    /// specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set
    /// of results. To get the next page of results, call <code>GetlabelDetection</code> and populate the <code>NextToken</code> request parameter with the token
    /// value returned from the previous call to <code>GetLabelDetection</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLabelDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_label_detection_input::Builder,
    }
    impl<C, M, R> GetLabelDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLabelDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLabelDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLabelDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLabelDetectionInputOperationOutputAlias,
                crate::output::GetLabelDetectionOutput,
                crate::error::GetLabelDetectionError,
                crate::input::GetLabelDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Job identifier for the label detection operation for which you want results returned. You get the job identifer from
        /// an initial call to <code>StartlabelDetection</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>Job identifier for the label detection operation for which you want results returned. You get the job identifer from
        /// an initial call to <code>StartlabelDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of labels. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of labels. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for elements in the <code>Labels</code> array.
        /// Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected.
        /// Use <code>NAME</code> to alphabetically group elements for a label together.
        /// Within each label group, the array element are sorted by detection confidence.
        /// The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn sort_by(mut self, inp: crate::model::LabelDetectionSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Sort to use for elements in the <code>Labels</code> array.
        /// Use <code>TIMESTAMP</code> to sort array elements by the time labels are detected.
        /// Use <code>NAME</code> to alphabetically group elements for a label together.
        /// Within each label group, the array element are sorted by detection confidence.
        /// The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::LabelDetectionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPersonTracking`.
    ///
    /// <p>Gets the path tracking results of a Amazon Rekognition Video analysis started by <a>StartPersonTracking</a>.</p>
    ///
    /// <p>The person path tracking operation is started by a call to <code>StartPersonTracking</code>
    /// which returns a job identifier (<code>JobId</code>). When the operation finishes, Amazon Rekognition Video publishes a completion status to
    /// the Amazon Simple Notification Service topic registered in the initial call to <code>StartPersonTracking</code>.</p>
    /// <p>To get the results of the person path tracking operation, first check
    /// that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>.
    /// If so, call  <a>GetPersonTracking</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.</p>
    /// <p>
    /// <code>GetPersonTracking</code> returns an array, <code>Persons</code>, of tracked persons and the time(s) their
    /// paths were tracked in the video. </p>
    /// <note>
    /// <p>
    /// <code>GetPersonTracking</code> only returns the default  
    /// facial attributes (<code>BoundingBox</code>, <code>Confidence</code>,
    /// <code>Landmarks</code>, <code>Pose</code>, and <code>Quality</code>). The other facial attributes listed
    /// in the <code>Face</code> object of the following response syntax are not returned. </p>
    ///
    /// <p>For more information, see FaceDetail in the Amazon Rekognition Developer Guide.</p>
    /// </note>
    ///
    ///
    /// <p>By default, the array is sorted by the time(s) a person's path is tracked in the video.
    /// You can sort by tracked persons by specifying <code>INDEX</code> for the <code>SortBy</code> input parameter.</p>
    ///
    /// <p>Use the <code>MaxResults</code> parameter to limit the number of items returned. If there are more results than
    /// specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains a pagination token for getting the next set
    /// of results. To get the next page of results, call <code>GetPersonTracking</code> and populate the <code>NextToken</code> request parameter with the token
    /// value returned from the previous call to <code>GetPersonTracking</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPersonTracking<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_person_tracking_input::Builder,
    }
    impl<C, M, R> GetPersonTracking<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPersonTracking`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPersonTrackingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPersonTrackingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPersonTrackingInputOperationOutputAlias,
                crate::output::GetPersonTrackingOutput,
                crate::error::GetPersonTrackingError,
                crate::input::GetPersonTrackingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for a job that tracks persons in a video. You get the <code>JobId</code> from a call to <code>StartPersonTracking</code>.
        /// </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier for a job that tracks persons in a video. You get the <code>JobId</code> from a call to <code>StartPersonTracking</code>.
        /// </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.
        /// If you specify a value greater than 1000, a maximum of 1000 results is returned.
        /// The default value is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more persons to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of persons. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more persons to retrieve), Amazon Rekognition Video returns a pagination
        /// token in the response. You can use this pagination token to retrieve the next set of persons. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Sort to use for elements in the <code>Persons</code> array. Use <code>TIMESTAMP</code> to sort array elements
        /// by the time persons are detected. Use <code>INDEX</code> to sort by the tracked persons.
        /// If you sort by <code>INDEX</code>, the array elements for each person are sorted by detection confidence.
        /// The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn sort_by(mut self, inp: crate::model::PersonTrackingSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Sort to use for elements in the <code>Persons</code> array. Use <code>TIMESTAMP</code> to sort array elements
        /// by the time persons are detected. Use <code>INDEX</code> to sort by the tracked persons.
        /// If you sort by <code>INDEX</code>, the array elements for each person are sorted by detection confidence.
        /// The default sort is by <code>TIMESTAMP</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::PersonTrackingSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSegmentDetection`.
    ///
    /// <p>Gets the segment detection results of a Amazon Rekognition Video analysis started by <a>StartSegmentDetection</a>.</p>
    /// <p>Segment detection with Amazon Rekognition Video is an asynchronous operation. You start segment detection by
    /// calling <a>StartSegmentDetection</a> which returns a job identifier (<code>JobId</code>).
    /// When the segment detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service
    /// topic registered in the initial call to <code>StartSegmentDetection</code>. To get the results
    /// of the segment detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>.
    /// if so, call <code>GetSegmentDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call
    /// of <code>StartSegmentDetection</code>.</p>
    /// <p>
    /// <code>GetSegmentDetection</code> returns detected segments in an array (<code>Segments</code>)
    /// of <a>SegmentDetection</a> objects. <code>Segments</code> is sorted by the segment types
    /// specified in the <code>SegmentTypes</code> input parameter of <code>StartSegmentDetection</code>.
    /// Each element of the array includes the detected segment, the precentage confidence in the acuracy
    /// of the detected segment, the type of the segment, and the frame in which the segment was detected.</p>
    /// <p>Use <code>SelectedSegmentTypes</code> to find out the type of segment detection requested in the
    /// call to <code>StartSegmentDetection</code>.</p>
    /// <p>Use the <code>MaxResults</code> parameter to limit the number of segment detections returned. If there are more results than
    /// specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains
    /// a pagination token for getting the next set of results. To get the next page of results, call <code>GetSegmentDetection</code>
    /// and populate the <code>NextToken</code> request parameter with the token value returned from the previous
    /// call to <code>GetSegmentDetection</code>.</p>
    ///
    /// <p>For more information, see Detecting Video Segments in Stored Video in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSegmentDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_segment_detection_input::Builder,
    }
    impl<C, M, R> GetSegmentDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSegmentDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSegmentDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSegmentDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSegmentDetectionInputOperationOutputAlias,
                crate::output::GetSegmentDetectionOutput,
                crate::error::GetSegmentDetectionError,
                crate::input::GetSegmentDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Job identifier for the text detection operation for which you want results returned.
        /// You get the job identifer from an initial call to <code>StartSegmentDetection</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>Job identifier for the text detection operation for which you want results returned.
        /// You get the job identifer from an initial call to <code>StartSegmentDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
        /// request to retrieve the next set of text.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response is truncated, Amazon Rekognition Video returns this token that you can use in the subsequent
        /// request to retrieve the next set of text.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTextDetection`.
    ///
    /// <p>Gets the text detection results of a Amazon Rekognition Video analysis started by <a>StartTextDetection</a>.</p>
    /// <p>Text detection with Amazon Rekognition Video is an asynchronous operation. You start text detection by
    /// calling <a>StartTextDetection</a> which returns a job identifier (<code>JobId</code>)
    /// When the text detection operation finishes, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service
    /// topic registered in the initial call to <code>StartTextDetection</code>. To get the results
    /// of the text detection operation, first check that the status value published to the Amazon SNS topic is <code>SUCCEEDED</code>.
    /// if so, call <code>GetTextDetection</code> and pass the job identifier (<code>JobId</code>) from the initial call
    /// of <code>StartLabelDetection</code>.</p>
    /// <p>
    /// <code>GetTextDetection</code> returns an array of detected text (<code>TextDetections</code>) sorted by
    /// the time the text was detected, up to 50 words per frame of video.</p>
    /// <p>Each element of the array includes the detected text, the precentage confidence in the acuracy
    /// of the detected text, the time the text was detected, bounding box information for where the text
    /// was located, and unique identifiers for words and their lines.</p>
    /// <p>Use MaxResults parameter to limit the number of text detections returned. If there are more results than
    /// specified in <code>MaxResults</code>, the value of <code>NextToken</code> in the operation response contains
    /// a pagination token for getting the next set of results. To get the next page of results, call <code>GetTextDetection</code>
    /// and populate the <code>NextToken</code> request parameter with the token value returned from the previous
    /// call to <code>GetTextDetection</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTextDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_text_detection_input::Builder,
    }
    impl<C, M, R> GetTextDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTextDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTextDetectionInputOperationOutputAlias,
                crate::output::GetTextDetectionOutput,
                crate::error::GetTextDetectionError,
                crate::input::GetTextDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Job identifier for the text detection operation for which you want results returned.
        /// You get the job identifer from an initial call to <code>StartTextDetection</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>Job identifier for the text detection operation for which you want results returned.
        /// You get the job identifer from an initial call to <code>StartTextDetection</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return per paginated call. The largest value you can specify is 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns
        /// a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more labels to retrieve), Amazon Rekognition Video returns
        /// a pagination token in the response. You can use this pagination token to retrieve the next set of text.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `IndexFaces`.
    ///
    /// <p>Detects faces in the input image and adds them to the specified collection. </p>
    /// <p>Amazon Rekognition doesn't save the actual faces that are detected. Instead, the underlying
    /// detection algorithm first detects the faces in the input image. For each face, the algorithm
    /// extracts facial features into a feature vector, and stores it in the backend database.
    /// Amazon Rekognition uses feature vectors when it performs face match and search operations using the
    /// <a>SearchFaces</a> and <a>SearchFacesByImage</a>
    /// operations.</p>
    ///
    /// <p>For more information, see Adding Faces to a Collection in the Amazon Rekognition
    /// Developer Guide.</p>
    /// <p>To get the number of faces in a collection, call <a>DescribeCollection</a>. </p>
    ///
    /// <p>If you're using version 1.0 of the face detection model, <code>IndexFaces</code>
    /// indexes the 15 largest faces in the input image. Later versions of the face detection model
    /// index the 100 largest faces in the input image. </p>
    /// <p>If you're using version 4 or later of the face model, image orientation information
    /// is not returned in the <code>OrientationCorrection</code> field. </p>
    /// <p>To determine which version of the model you're using, call <a>DescribeCollection</a>
    /// and supply the collection ID. You can also get the model version from the value of <code>FaceModelVersion</code> in the response
    /// from <code>IndexFaces</code>
    /// </p>
    ///
    /// <p>For more information, see Model Versioning in the Amazon Rekognition Developer
    /// Guide.</p>
    /// <p>If you provide the optional <code>ExternalImageId</code> for the input image you
    /// provided, Amazon Rekognition associates this ID with all faces that it detects. When you call the <a>ListFaces</a> operation, the response returns the external ID. You can use this
    /// external image ID to create a client-side index to associate the faces with each image. You
    /// can then use the index to find all faces in an image.</p>
    /// <p>You can specify the maximum number of faces to index with the <code>MaxFaces</code> input
    /// parameter. This is useful when you want to index the largest faces in an image and don't want to index
    /// smaller faces, such as those belonging to people standing in the background.</p>
    /// <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces
    /// that don’t meet a required quality bar. The quality bar is based on a
    /// variety of common use cases. By default, <code>IndexFaces</code> chooses the quality bar that's
    /// used to filter faces.  You can also explicitly choose
    /// the quality bar. Use <code>QualityFilter</code>, to set the quality bar
    /// by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>.
    /// If you do not want to filter detected faces, specify <code>NONE</code>. </p>
    /// <note>
    /// <p>To use quality filtering, you need a collection associated with version 3 of the
    /// face model or higher. To get the version of the face model associated with a collection, call
    /// <a>DescribeCollection</a>. </p>
    /// </note>
    /// <p>Information about faces detected in an image, but not indexed, is returned in an array of
    /// <a>UnindexedFace</a> objects, <code>UnindexedFaces</code>. Faces aren't
    /// indexed for reasons such as:</p>
    /// <ul>
    /// <li>
    /// <p>The number of faces detected exceeds the value of the <code>MaxFaces</code> request
    /// parameter.</p>
    /// </li>
    /// <li>
    /// <p>The face is too small compared to the image dimensions.</p>
    /// </li>
    /// <li>
    /// <p>The face is too blurry.</p>
    /// </li>
    /// <li>
    /// <p>The image is too dark.</p>
    /// </li>
    /// <li>
    /// <p>The face has an extreme pose.</p>
    /// </li>
    /// <li>
    /// <p>The face doesn’t have enough detail to be suitable for face search.</p>
    /// </li>
    /// </ul>
    /// <p>In response, the <code>IndexFaces</code> operation returns an array of metadata for
    /// all detected faces, <code>FaceRecords</code>. This includes: </p>
    /// <ul>
    /// <li>
    /// <p>The bounding box, <code>BoundingBox</code>, of the detected face. </p>
    /// </li>
    /// <li>
    /// <p>A confidence value, <code>Confidence</code>, which indicates the confidence that the
    /// bounding box contains a face.</p>
    /// </li>
    /// <li>
    /// <p>A face ID, <code>FaceId</code>, assigned by the service for each face that's detected
    /// and stored.</p>
    /// </li>
    /// <li>
    /// <p>An image ID, <code>ImageId</code>, assigned by the service for the input image.</p>
    /// </li>
    /// </ul>
    /// <p>If you request all facial attributes (by using the <code>detectionAttributes</code>
    /// parameter), Amazon Rekognition returns detailed facial attributes, such as facial landmarks (for
    /// example, location of eye and mouth) and other facial attributes. If you provide
    /// the same image, specify the same collection, and use the same external ID in the
    /// <code>IndexFaces</code> operation, Amazon Rekognition doesn't save duplicate face metadata.</p>
    ///
    ///
    /// <p></p>
    ///
    ///
    /// <p>The input image is passed either as base64-encoded image bytes, or as a reference to an
    /// image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations,
    /// passing image bytes isn't supported. The image must be formatted as a PNG or JPEG file. </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:IndexFaces</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct IndexFaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::index_faces_input::Builder,
    }
    impl<C, M, R> IndexFaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `IndexFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::IndexFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::IndexFacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::IndexFacesInputOperationOutputAlias,
                crate::output::IndexFacesOutput,
                crate::error::IndexFacesError,
                crate::input::IndexFacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of an existing collection to which you want to add the faces that are detected
        /// in the input images.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>The ID of an existing collection to which you want to add the faces that are detected
        /// in the input images.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing base64-encoded image bytes isn't supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing base64-encoded image bytes isn't supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>The ID you want to assign to all the faces detected in the image.</p>
        pub fn external_image_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_image_id(inp);
            self
        }
        /// <p>The ID you want to assign to all the faces detected in the image.</p>
        pub fn set_external_image_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_image_id(input);
            self
        }
        /// Appends an item to `DetectionAttributes`.
        ///
        /// To override the contents of this collection use [`set_detection_attributes`](Self::set_detection_attributes).
        ///
        /// <p>An array of facial attributes that you want to be returned. This can be the default
        /// list of attributes or all attributes. If you don't specify a value for <code>Attributes</code>
        /// or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial
        /// attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>,
        /// <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
        /// facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND
        /// operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn detection_attributes(mut self, inp: impl Into<crate::model::Attribute>) -> Self {
            self.inner = self.inner.detection_attributes(inp);
            self
        }
        /// <p>An array of facial attributes that you want to be returned. This can be the default
        /// list of attributes or all attributes. If you don't specify a value for <code>Attributes</code>
        /// or if you specify <code>["DEFAULT"]</code>, the API returns the following subset of facial
        /// attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>,
        /// <code>Quality</code>, and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
        /// facial attributes are returned, but the operation takes longer to complete.</p>
        /// <p>If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND
        /// operator to determine which attributes to return (in this case, all attributes). </p>
        pub fn set_detection_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_detection_attributes(input);
            self
        }
        /// <p>The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater
        /// than or equal to 1. <code>IndexFaces</code> returns no more than 100 detected faces in an
        /// image, even if you specify a larger value for <code>MaxFaces</code>.</p>
        /// <p>If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the
        /// faces with the lowest quality are filtered out first. If there are still more faces than the
        /// value of <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out
        /// (up to the number that's needed to satisfy the value of <code>MaxFaces</code>). Information
        /// about the unindexed faces is available in the <code>UnindexedFaces</code> array. </p>
        /// <p>The faces that are returned by <code>IndexFaces</code> are sorted by the largest face
        /// bounding box size to the smallest size, in descending order.</p>
        /// <p>
        /// <code>MaxFaces</code> can be used with a collection associated with any version of
        /// the face model.</p>
        pub fn max_faces(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_faces(inp);
            self
        }
        /// <p>The maximum number of faces to index. The value of <code>MaxFaces</code> must be greater
        /// than or equal to 1. <code>IndexFaces</code> returns no more than 100 detected faces in an
        /// image, even if you specify a larger value for <code>MaxFaces</code>.</p>
        /// <p>If <code>IndexFaces</code> detects more faces than the value of <code>MaxFaces</code>, the
        /// faces with the lowest quality are filtered out first. If there are still more faces than the
        /// value of <code>MaxFaces</code>, the faces with the smallest bounding boxes are filtered out
        /// (up to the number that's needed to satisfy the value of <code>MaxFaces</code>). Information
        /// about the unindexed faces is available in the <code>UnindexedFaces</code> array. </p>
        /// <p>The faces that are returned by <code>IndexFaces</code> are sorted by the largest face
        /// bounding box size to the smallest size, in descending order.</p>
        /// <p>
        /// <code>MaxFaces</code> can be used with a collection associated with any version of
        /// the face model.</p>
        pub fn set_max_faces(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_faces(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces.
        /// Filtered faces aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar.
        /// If you specify <code>LOW</code>,
        /// <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
        /// don’t meet the chosen quality bar.  The default value is <code>AUTO</code>.
        ///
        /// The quality bar is based on a variety of common use cases. Low-quality
        /// detections can occur for a number of reasons. Some examples are an object that's misidentified
        /// as a face, a face that's too blurry, or a face with a
        /// pose that's too extreme to use. If you specify <code>NONE</code>, no
        /// filtering is performed.
        /// </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn quality_filter(mut self, inp: crate::model::QualityFilter) -> Self {
            self.inner = self.inner.quality_filter(inp);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces.
        /// Filtered faces aren't indexed. If you specify <code>AUTO</code>, Amazon Rekognition chooses the quality bar.
        /// If you specify <code>LOW</code>,
        /// <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
        /// don’t meet the chosen quality bar.  The default value is <code>AUTO</code>.
        ///
        /// The quality bar is based on a variety of common use cases. Low-quality
        /// detections can occur for a number of reasons. Some examples are an object that's misidentified
        /// as a face, a face that's too blurry, or a face with a
        /// pose that's too extreme to use. If you specify <code>NONE</code>, no
        /// filtering is performed.
        /// </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn set_quality_filter(
            mut self,
            input: std::option::Option<crate::model::QualityFilter>,
        ) -> Self {
            self.inner = self.inner.set_quality_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCollections`.
    ///
    /// <p>Returns list of collection IDs in your account.
    /// If the result is truncated, the response also provides a <code>NextToken</code>
    /// that you can use in the subsequent request to fetch the next set of collection IDs.</p>
    ///
    /// <p>For an example, see Listing Collections in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the <code>rekognition:ListCollections</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCollections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_collections_input::Builder,
    }
    impl<C, M, R> ListCollections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCollections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCollectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCollectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCollectionsInputOperationOutputAlias,
                crate::output::ListCollectionsOutput,
                crate::error::ListCollectionsError,
                crate::input::ListCollectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Pagination token from the previous response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Pagination token from the previous response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of collection IDs to return. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of collection IDs to return. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetEntries`.
    ///
    /// <p>
    /// Lists the entries (images) within a dataset. An entry is a
    /// JSON Line that contains the information for a single image, including
    /// the image location, assigned labels, and object location bounding boxes. For
    /// more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-manifest-files.html">Creating a manifest file</a>.</p>
    /// <p>JSON Lines in the response include information about non-terminal
    /// errors found in the dataset.
    /// Non terminal errors are reported in <code>errors</code> lists within each JSON Line. The
    /// same information is reported in the training and testing validation result manifests that
    /// Amazon Rekognition Custom Labels creates during model training.
    /// </p>
    ///
    /// <p>You can filter the response in variety of ways, such as choosing which labels to return and returning JSON Lines created after a specific date.
    /// </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:ListDatasetEntries</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetEntries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_entries_input::Builder,
    }
    impl<C, M, R> ListDatasetEntries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetEntriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetEntriesInputOperationOutputAlias,
                crate::output::ListDatasetEntriesOutput,
                crate::error::ListDatasetEntriesError,
                crate::input::ListDatasetEntriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) for the dataset that you want to use.
        /// </p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) for the dataset that you want to use.
        /// </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// Appends an item to `ContainsLabels`.
        ///
        /// To override the contents of this collection use [`set_contains_labels`](Self::set_contains_labels).
        ///
        /// <p>Specifies a label filter for the response. The response includes an entry only if one or more of the labels in <code>ContainsLabels</code> exist in the entry.       
        /// </p>
        pub fn contains_labels(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contains_labels(inp);
            self
        }
        /// <p>Specifies a label filter for the response. The response includes an entry only if one or more of the labels in <code>ContainsLabels</code> exist in the entry.       
        /// </p>
        pub fn set_contains_labels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_contains_labels(input);
            self
        }
        /// <p>
        /// Specify <code>true</code> to get only the JSON Lines where the image is labeled.
        /// Specify <code>false</code> to get only the JSON Lines where the image isn't labeled. If you
        /// don't specify <code>Labeled</code>, <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled
        /// images.
        /// </p>
        pub fn labeled(mut self, inp: bool) -> Self {
            self.inner = self.inner.labeled(inp);
            self
        }
        /// <p>
        /// Specify <code>true</code> to get only the JSON Lines where the image is labeled.
        /// Specify <code>false</code> to get only the JSON Lines where the image isn't labeled. If you
        /// don't specify <code>Labeled</code>, <code>ListDatasetEntries</code> returns JSON Lines for labeled and unlabeled
        /// images.
        /// </p>
        pub fn set_labeled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_labeled(input);
            self
        }
        /// <p>If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of <code>SourceRefContains</code> is
        /// part of the <code>source-ref</code> field. The <code>source-ref</code> field contains the Amazon S3 location of the image.
        /// You can use <code>SouceRefContains</code> for tasks such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.</p>
        pub fn source_ref_contains(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ref_contains(inp);
            self
        }
        /// <p>If specified, <code>ListDatasetEntries</code> only returns JSON Lines where the value of <code>SourceRefContains</code> is
        /// part of the <code>source-ref</code> field. The <code>source-ref</code> field contains the Amazon S3 location of the image.
        /// You can use <code>SouceRefContains</code> for tasks such as getting the JSON Line for a single image, or gettting JSON Lines for all images within a specific folder.</p>
        pub fn set_source_ref_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_ref_contains(input);
            self
        }
        /// <p>Specifies an error filter for the response. Specify <code>True</code> to only include entries that have errors.
        /// </p>
        pub fn has_errors(mut self, inp: bool) -> Self {
            self.inner = self.inner.has_errors(inp);
            self
        }
        /// <p>Specifies an error filter for the response. Specify <code>True</code> to only include entries that have errors.
        /// </p>
        pub fn set_has_errors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_has_errors(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetLabels`.
    ///
    /// <p>Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels to describe images. For more information, see
    /// <a href="https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-labeling-images.html">Labeling images</a>.
    /// </p>   
    /// <p>
    /// Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels to describe images. For more information, see Labeling images
    /// in the <i>Amazon Rekognition Custom Labels Developer Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetLabels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_labels_input::Builder,
    }
    impl<C, M, R> ListDatasetLabels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetLabels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetLabelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetLabelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetLabelsInputOperationOutputAlias,
                crate::output::ListDatasetLabelsOutput,
                crate::error::ListDatasetLabelsError,
                crate::input::ListDatasetLabelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the dataset that you want to use.
        /// </p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the dataset that you want to use.
        /// </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more
        /// results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination
        /// token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFaces`.
    ///
    /// <p>Returns metadata for faces in the specified collection.
    /// This metadata includes information such as the bounding box coordinates, the confidence
    /// (that the bounding box contains a face), and face ID. For an example, see Listing Faces in a Collection
    /// in the Amazon Rekognition Developer Guide.</p>
    ///
    ///
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:ListFaces</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_faces_input::Builder,
    }
    impl<C, M, R> ListFaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFacesInputOperationOutputAlias,
                crate::output::ListFacesOutput,
                crate::error::ListFacesError,
                crate::input::ListFacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the collection from which to list the faces.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>ID of the collection from which to list the faces.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Rekognition returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of faces.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Rekognition returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of faces.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of faces to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of faces to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStreamProcessors`.
    ///
    /// <p>Gets a list of stream processors that you have created with <a>CreateStreamProcessor</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListStreamProcessors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_stream_processors_input::Builder,
    }
    impl<C, M, R> ListStreamProcessors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStreamProcessors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStreamProcessorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStreamProcessorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStreamProcessorsInputOperationOutputAlias,
                crate::output::ListStreamProcessorsOutput,
                crate::error::ListStreamProcessorsError,
                crate::input::ListStreamProcessorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If the previous response was incomplete (because there are more stream processors to retrieve), Amazon Rekognition Video
        /// returns a pagination token in the response. You can use this pagination token to retrieve the next set of stream processors. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there are more stream processors to retrieve), Amazon Rekognition Video
        /// returns a pagination token in the response. You can use this pagination token to retrieve the next set of stream processors. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of stream processors you want Amazon Rekognition Video to return in the response. The default is 1000. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of stream processors you want Amazon Rekognition Video to return in the response. The default is 1000. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>
    /// Returns a list of tags in an Amazon Rekognition collection, stream processor, or Custom Labels model.
    /// </p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:ListTagsForResource</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Amazon Resource Name (ARN) of the model, collection, or stream processor that contains the tags that you want a list of.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// Amazon Resource Name (ARN) of the model, collection, or stream processor that contains the tags that you want a list of.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RecognizeCelebrities`.
    ///
    /// <p>Returns an array of celebrities recognized in the input image.  For more information, see Recognizing Celebrities
    /// in the Amazon Rekognition Developer Guide. </p>
    /// <p>
    /// <code>RecognizeCelebrities</code> returns the 64 largest faces in the image. It lists the
    /// recognized celebrities in the <code>CelebrityFaces</code> array and any unrecognized faces in
    /// the <code>UnrecognizedFaces</code> array. <code>RecognizeCelebrities</code> doesn't return
    /// celebrities whose faces aren't among the largest 64 faces in the image.</p>
    ///
    /// <p>For each celebrity recognized, <code>RecognizeCelebrities</code> returns a
    /// <code>Celebrity</code> object. The <code>Celebrity</code> object contains the celebrity
    /// name, ID, URL links to additional information, match confidence, and a
    /// <code>ComparedFace</code> object that you can use to locate the celebrity's face on the
    /// image.</p>
    /// <p>Amazon Rekognition doesn't retain information about which images a celebrity has been recognized
    /// in. Your application must store this information and use the <code>Celebrity</code> ID
    /// property as a unique identifier for the celebrity. If you don't store the celebrity name or
    /// additional information URLs returned by <code>RecognizeCelebrities</code>, you will need the
    /// ID to identify the celebrity in a call to the <a>GetCelebrityInfo</a>
    /// operation.</p>
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an
    /// image in an Amazon S3 bucket. If you use the
    /// AWS
    /// CLI to call Amazon Rekognition operations, passing image bytes is not
    /// supported. The image must be either a PNG or JPEG formatted file. </p>
    ///
    ///
    ///
    ///
    /// <p>For an example, see Recognizing Celebrities in an Image in the Amazon Rekognition Developer Guide.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:RecognizeCelebrities</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct RecognizeCelebrities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::recognize_celebrities_input::Builder,
    }
    impl<C, M, R> RecognizeCelebrities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RecognizeCelebrities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RecognizeCelebritiesOutput,
            aws_smithy_http::result::SdkError<crate::error::RecognizeCelebritiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RecognizeCelebritiesInputOperationOutputAlias,
                crate::output::RecognizeCelebritiesOutput,
                crate::error::RecognizeCelebritiesError,
                crate::input::RecognizeCelebritiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to
        /// base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see
        /// Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call
        /// Amazon Rekognition operations, passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to
        /// base64-encode image bytes passed using the <code>Bytes</code> field. For more information, see
        /// Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFaces`.
    ///
    /// <p>For a given input face ID, searches for matching faces in the collection the face
    /// belongs to. You get a face ID when you add a face to the collection using the <a>IndexFaces</a> operation. The operation compares the features of the input face with
    /// faces in the specified collection. </p>
    /// <note>
    /// <p>You can also search faces without indexing faces by using the
    /// <code>SearchFacesByImage</code> operation.</p>
    /// </note>
    ///
    /// <p>
    /// The operation response returns
    /// an array of faces that match, ordered by similarity score with the highest
    /// similarity first. More specifically, it is an
    /// array of metadata for each face match that is found. Along with the metadata, the response also
    /// includes a <code>confidence</code> value for each face match, indicating the confidence
    /// that the specific face matches the input face.
    /// </p>
    ///
    /// <p>For an example, see Searching for a Face Using Its Face ID in the Amazon Rekognition Developer Guide.</p>
    ///
    /// <p>This operation requires permissions to perform the <code>rekognition:SearchFaces</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchFaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_faces_input::Builder,
    }
    impl<C, M, R> SearchFaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchFaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFacesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchFacesInputOperationOutputAlias,
                crate::output::SearchFacesOutput,
                crate::error::SearchFacesError,
                crate::input::SearchFacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the collection the face belongs to.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>ID of the collection the face belongs to.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>ID of a face to find matches for in the collection.</p>
        pub fn face_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.face_id(inp);
            self
        }
        /// <p>ID of a face to find matches for in the collection.</p>
        pub fn set_face_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_face_id(input);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces
        /// with the highest confidence in the match.</p>
        pub fn max_faces(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_faces(inp);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces
        /// with the highest confidence in the match.</p>
        pub fn set_max_faces(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_faces(input);
            self
        }
        /// <p>Optional value specifying the minimum confidence in the face match to return. For
        /// example, don't return any matches where confidence in matches is less than 70%.
        /// The default value is 80%.
        /// </p>
        pub fn face_match_threshold(mut self, inp: f32) -> Self {
            self.inner = self.inner.face_match_threshold(inp);
            self
        }
        /// <p>Optional value specifying the minimum confidence in the face match to return. For
        /// example, don't return any matches where confidence in matches is less than 70%.
        /// The default value is 80%.
        /// </p>
        pub fn set_face_match_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_face_match_threshold(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchFacesByImage`.
    ///
    /// <p>For a given input image, first detects the largest face in the image, and then searches
    /// the specified collection for matching faces. The operation compares the features of the input
    /// face with faces in the specified collection. </p>
    /// <note>
    /// <p>To search for all faces in an input image, you might first call the <a>IndexFaces</a> operation, and then use the face IDs returned in subsequent
    /// calls to the <a>SearchFaces</a> operation. </p>
    /// <p> You can also call the <code>DetectFaces</code> operation and use the bounding boxes
    /// in the response to make face crops, which then you can pass in to the
    /// <code>SearchFacesByImage</code> operation. </p>
    /// </note>
    ///
    /// <p>You pass the input image either as base64-encoded image bytes or as a reference to an
    /// image in an Amazon S3 bucket. If you use the
    /// AWS
    /// CLI to call Amazon Rekognition operations, passing image bytes is not
    /// supported. The image must be either a PNG or JPEG formatted file. </p>
    /// <p>
    /// The response returns an array of faces that match, ordered by similarity score with the
    /// highest similarity first. More specifically, it is an
    /// array of metadata for each face match found. Along with the metadata, the response also
    /// includes a <code>similarity</code> indicating how similar the face is
    /// to the input face.
    ///
    /// In the response, the operation also returns the bounding
    /// box (and a confidence level that the bounding box contains a face) of the face that Amazon Rekognition
    /// used for the input image.
    /// </p>
    /// <p>If no faces are detected in the input image, <code>SearchFacesByImage</code> returns an
    /// <code>InvalidParameterException</code> error. </p>
    ///
    /// <p>For an example, Searching for a Face Using an Image in the Amazon Rekognition Developer Guide.</p>
    ///
    /// <p>The <code>QualityFilter</code> input parameter allows you to filter out detected faces
    /// that don’t meet a required quality bar. The quality bar is based on a
    /// variety of common use cases.
    /// Use <code>QualityFilter</code> to set the quality bar for
    /// filtering by specifying <code>LOW</code>, <code>MEDIUM</code>, or <code>HIGH</code>.
    /// If you do not want to filter detected faces, specify <code>NONE</code>. The default
    /// value is <code>NONE</code>.</p>
    /// <note>
    /// <p>To use quality filtering, you need a collection associated with version 3 of the
    /// face model or higher. To get the version of the face model associated with a collection, call
    /// <a>DescribeCollection</a>. </p>
    /// </note>
    ///
    /// <p>This operation requires permissions to perform the <code>rekognition:SearchFacesByImage</code>
    /// action.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchFacesByImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_faces_by_image_input::Builder,
    }
    impl<C, M, R> SearchFacesByImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchFacesByImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchFacesByImageOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchFacesByImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchFacesByImageInputOperationOutputAlias,
                crate::output::SearchFacesByImageOutput,
                crate::error::SearchFacesByImageError,
                crate::input::SearchFacesByImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the collection to search.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>ID of the collection to search.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object.
        /// If you use the AWS CLI to call Amazon Rekognition operations,
        /// passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn image(mut self, inp: crate::model::Image) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The input image as base64-encoded bytes or an S3 object.
        /// If you use the AWS CLI to call Amazon Rekognition operations,
        /// passing base64-encoded image bytes is not supported. </p>
        /// <p>If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes
        /// passed using the <code>Bytes</code> field.
        /// For more information, see Images in the Amazon Rekognition developer guide.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces
        /// with the highest confidence in the match.</p>
        pub fn max_faces(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_faces(inp);
            self
        }
        /// <p>Maximum number of faces to return. The operation returns the maximum number of faces
        /// with the highest confidence in the match.</p>
        pub fn set_max_faces(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_faces(input);
            self
        }
        /// <p>(Optional) Specifies the minimum confidence in the face match to return. For example,
        /// don't return any matches where confidence in matches is less than 70%.
        /// The default value is 80%.</p>
        pub fn face_match_threshold(mut self, inp: f32) -> Self {
            self.inner = self.inner.face_match_threshold(inp);
            self
        }
        /// <p>(Optional) Specifies the minimum confidence in the face match to return. For example,
        /// don't return any matches where confidence in matches is less than 70%.
        /// The default value is 80%.</p>
        pub fn set_face_match_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_face_match_threshold(input);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces.
        /// Filtered faces aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition
        /// chooses the quality bar.  If you specify <code>LOW</code>,
        /// <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
        /// don’t meet the chosen quality bar.  
        ///
        /// The quality bar is based on a variety of common use cases. Low-quality
        /// detections can occur for a number of reasons. Some examples are an object that's misidentified
        /// as a face, a face that's too blurry, or a face with a
        /// pose that's too extreme to use. If you specify <code>NONE</code>, no
        /// filtering is performed.  The default value is <code>NONE</code>.
        /// </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn quality_filter(mut self, inp: crate::model::QualityFilter) -> Self {
            self.inner = self.inner.quality_filter(inp);
            self
        }
        /// <p>A filter that specifies a quality bar for how much filtering is done to identify faces.
        /// Filtered faces aren't searched for in the collection. If you specify <code>AUTO</code>, Amazon Rekognition
        /// chooses the quality bar.  If you specify <code>LOW</code>,
        /// <code>MEDIUM</code>, or <code>HIGH</code>, filtering removes all faces that
        /// don’t meet the chosen quality bar.  
        ///
        /// The quality bar is based on a variety of common use cases. Low-quality
        /// detections can occur for a number of reasons. Some examples are an object that's misidentified
        /// as a face, a face that's too blurry, or a face with a
        /// pose that's too extreme to use. If you specify <code>NONE</code>, no
        /// filtering is performed.  The default value is <code>NONE</code>.
        /// </p>
        /// <p>To use quality filtering, the collection you are using must be associated with version 3 of the face model or higher.</p>
        pub fn set_quality_filter(
            mut self,
            input: std::option::Option<crate::model::QualityFilter>,
        ) -> Self {
            self.inner = self.inner.set_quality_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartCelebrityRecognition`.
    ///
    /// <p>Starts asynchronous recognition of celebrities in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect celebrities in a video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name
    /// and the filename of the video.
    /// <code>StartCelebrityRecognition</code>
    /// returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis.
    /// When celebrity recognition analysis is finished, Amazon Rekognition Video publishes a completion status
    /// to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.
    /// To get the results of the celebrity recognition analysis, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call  <a>GetCelebrityRecognition</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartCelebrityRecognition</code>. </p>
    ///
    /// <p>For more information, see Recognizing Celebrities in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartCelebrityRecognition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_celebrity_recognition_input::Builder,
    }
    impl<C, M, R> StartCelebrityRecognition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartCelebrityRecognition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartCelebrityRecognitionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartCelebrityRecognitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartCelebrityRecognitionInputOperationOutputAlias,
                crate::output::StartCelebrityRecognitionOutput,
                crate::error::StartCelebrityRecognitionError,
                crate::input::StartCelebrityRecognitionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to recognize celebrities. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>The video in which you want to recognize celebrities. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartCelebrityRecognition</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartCelebrityRecognition</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the
        /// celebrity recognition analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the
        /// celebrity recognition analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContentModeration`.
    ///
    /// <p> Starts asynchronous detection of inappropriate, unwanted, or offensive content in a stored video. For a list of moderation labels in Amazon Rekognition, see
    /// <a href="https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api">Using the image and video moderation APIs</a>.</p>
    /// <p>Amazon Rekognition Video can moderate content in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name
    /// and the filename of the video. <code>StartContentModeration</code>
    /// returns a job identifier (<code>JobId</code>) which you use to get the results of the analysis.
    /// When content analysis is finished, Amazon Rekognition Video publishes a completion status
    /// to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p>
    /// <p>To get the results of the content analysis, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call <a>GetContentModeration</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartContentModeration</code>. </p>
    ///
    /// <p>For more information, see Content moderation in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartContentModeration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_content_moderation_input::Builder,
    }
    impl<C, M, R> StartContentModeration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartContentModeration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContentModerationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContentModerationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartContentModerationInputOperationOutputAlias,
                crate::output::StartContentModerationOutput,
                crate::error::StartContentModerationError,
                crate::input::StartContentModerationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect inappropriate, unwanted, or offensive content. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>The video in which you want to detect inappropriate, unwanted, or offensive content. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence
        /// represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence.
        /// 100 is the highest confidence.  Amazon Rekognition doesn't return any moderated content labels with a confidence level
        /// lower than this specified value. If you don't specify <code>MinConfidence</code>, <code>GetContentModeration</code>
        /// returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn min_confidence(mut self, inp: f32) -> Self {
            self.inner = self.inner.min_confidence(inp);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition must have in order to return a moderated content label. Confidence
        /// represents how certain Amazon Rekognition is that the moderated content is correctly identified. 0 is the lowest confidence.
        /// 100 is the highest confidence.  Amazon Rekognition doesn't return any moderated content labels with a confidence level
        /// lower than this specified value. If you don't specify <code>MinConfidence</code>, <code>GetContentModeration</code>
        /// returns labels with confidence values greater than or equal to 50 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartContentModeration</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartContentModeration</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the
        /// content analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish the completion status of the
        /// content analysis to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFaceDetection`.
    ///
    /// <p>Starts asynchronous detection of faces in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect faces in a video stored in an Amazon S3 bucket.
    /// Use <a>Video</a> to specify the bucket name and the filename of the video.
    /// <code>StartFaceDetection</code> returns a job identifier (<code>JobId</code>) that you
    /// use to get the results of the operation.
    /// When face detection is finished, Amazon Rekognition Video publishes a completion status
    /// to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.
    /// To get the results of the face detection operation, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call  <a>GetFaceDetection</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartFaceDetection</code>.</p>
    ///
    /// <p>For more information, see Detecting Faces in a Stored Video in the
    /// Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartFaceDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_face_detection_input::Builder,
    }
    impl<C, M, R> StartFaceDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFaceDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFaceDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFaceDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFaceDetectionInputOperationOutputAlias,
                crate::output::StartFaceDetectionOutput,
                crate::error::StartFaceDetectionError,
                crate::input::StartFaceDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect faces. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>The video in which you want to detect faces. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartFaceDetection</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the
        /// face detection operation. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the
        /// face detection operation. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>The face attributes you want returned.</p>
        /// <p>
        /// <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and Landmarks. </p>
        /// <p>
        /// <code>ALL</code> - All facial attributes are returned.</p>
        pub fn face_attributes(mut self, inp: crate::model::FaceAttributes) -> Self {
            self.inner = self.inner.face_attributes(inp);
            self
        }
        /// <p>The face attributes you want returned.</p>
        /// <p>
        /// <code>DEFAULT</code> - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and Landmarks. </p>
        /// <p>
        /// <code>ALL</code> - All facial attributes are returned.</p>
        pub fn set_face_attributes(
            mut self,
            input: std::option::Option<crate::model::FaceAttributes>,
        ) -> Self {
            self.inner = self.inner.set_face_attributes(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFaceSearch`.
    ///
    /// <p>Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored video.</p>
    /// <p>The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name
    /// and the filename of the video. <code>StartFaceSearch</code>
    /// returns a job identifier (<code>JobId</code>) which you use to get the search results once the search has completed.
    /// When searching is finished, Amazon Rekognition Video publishes a completion status
    /// to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.
    /// To get the search results, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call <a>GetFaceSearch</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartFaceSearch</code>. For more information, see
    /// <a>procedure-person-search-videos</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartFaceSearch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_face_search_input::Builder,
    }
    impl<C, M, R> StartFaceSearch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFaceSearch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFaceSearchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFaceSearchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFaceSearchInputOperationOutputAlias,
                crate::output::StartFaceSearchOutput,
                crate::error::StartFaceSearchError,
                crate::input::StartFaceSearchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video you want to search. The video must be stored in an Amazon S3 bucket. </p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>The video you want to search. The video must be stored in an Amazon S3 bucket. </p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartFaceSearch</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartFaceSearch</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The minimum confidence in the person match to return. For example, don't return any matches where confidence in matches is less than 70%.
        /// The default value is 80%.</p>
        pub fn face_match_threshold(mut self, inp: f32) -> Self {
            self.inner = self.inner.face_match_threshold(inp);
            self
        }
        /// <p>The minimum confidence in the person match to return. For example, don't return any matches where confidence in matches is less than 70%.
        /// The default value is 80%.</p>
        pub fn set_face_match_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_face_match_threshold(input);
            self
        }
        /// <p>ID of the collection that contains the faces you want to search for.</p>
        pub fn collection_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_id(inp);
            self
        }
        /// <p>ID of the collection that contains the faces you want to search for.</p>
        pub fn set_collection_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_id(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the search. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the search. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartLabelDetection`.
    ///
    /// <p>Starts asynchronous detection of labels in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect labels in a video. Labels are instances of real-world entities.
    /// This includes objects like flower, tree, and table; events like
    /// wedding, graduation, and birthday party; concepts like landscape, evening, and nature; and activities
    /// like a person getting out of a car or a person skiing.</p>
    ///
    /// <p>The video must be stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name
    /// and the filename of the video.
    /// <code>StartLabelDetection</code> returns a job identifier (<code>JobId</code>) which you use to get the
    /// results of the operation. When label detection is finished, Amazon Rekognition Video publishes a completion status
    /// to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>.</p>
    /// <p>To get the results of the label detection operation, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call  <a>GetLabelDetection</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartLabelDetection</code>.</p>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct StartLabelDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_label_detection_input::Builder,
    }
    impl<C, M, R> StartLabelDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartLabelDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartLabelDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartLabelDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartLabelDetectionInputOperationOutputAlias,
                crate::output::StartLabelDetectionOutput,
                crate::error::StartLabelDetectionError,
                crate::input::StartLabelDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect labels. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>The video in which you want to detect labels. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartLabelDetection</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartLabelDetection</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence
        /// represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence.
        /// 100 is the highest confidence.  Amazon Rekognition Video doesn't return any labels with a confidence level
        /// lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence
        /// values greater than or equal to 50 percent.</p>
        pub fn min_confidence(mut self, inp: f32) -> Self {
            self.inner = self.inner.min_confidence(inp);
            self
        }
        /// <p>Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence
        /// represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence.
        /// 100 is the highest confidence.  Amazon Rekognition Video doesn't return any labels with a confidence level
        /// lower than this specified value.</p>
        /// <p>If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence
        /// values greater than or equal to 50 percent.</p>
        pub fn set_min_confidence(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_min_confidence(input);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection
        /// operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection
        /// operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartPersonTracking`.
    ///
    /// <p>Starts the asynchronous tracking of a person's path in a stored video.</p>
    /// <p>Amazon Rekognition Video can track the path of people in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name
    /// and the filename of the video. <code>StartPersonTracking</code>
    /// returns a job identifier (<code>JobId</code>) which you use to get the results of the operation.
    /// When label detection is finished, Amazon Rekognition publishes a completion status
    /// to the Amazon Simple Notification Service topic that you specify in <code>NotificationChannel</code>. </p>
    /// <p>To get the results of the person detection operation, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. If so, call  <a>GetPersonTracking</a> and pass the job identifier
    /// (<code>JobId</code>) from the initial call to <code>StartPersonTracking</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartPersonTracking<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_person_tracking_input::Builder,
    }
    impl<C, M, R> StartPersonTracking<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartPersonTracking`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartPersonTrackingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartPersonTrackingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartPersonTrackingInputOperationOutputAlias,
                crate::output::StartPersonTrackingOutput,
                crate::error::StartPersonTrackingError,
                crate::input::StartPersonTrackingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The video in which you want to detect people. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>The video in which you want to detect people. The video must be stored
        /// in an Amazon S3 bucket.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartPersonTracking</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartPersonTracking</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the people detection
        /// operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the people detection
        /// operation to. The Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartProjectVersion`.
    ///
    /// <p>Starts the running of the version of a model. Starting a model takes a while
    /// to complete. To check the current state of the model, use <a>DescribeProjectVersions</a>.</p>
    /// <p>Once the model is running, you can detect custom labels in new images by calling
    /// <a>DetectCustomLabels</a>.</p>
    /// <note>
    /// <p>You are charged for the amount of time that the model is running. To stop a running
    /// model, call <a>StopProjectVersion</a>.</p>
    /// </note>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:StartProjectVersion</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartProjectVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_project_version_input::Builder,
    }
    impl<C, M, R> StartProjectVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartProjectVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartProjectVersionInputOperationOutputAlias,
                crate::output::StartProjectVersionOutput,
                crate::error::StartProjectVersionError,
                crate::input::StartProjectVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name(ARN) of the model version that you want to start.</p>
        pub fn project_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name(ARN) of the model version that you want to start.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
        /// <p>The minimum number of inference units to use. A single
        /// inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS).
        /// Use a higher number to increase the TPS throughput of your model. You are charged for the number
        /// of inference units that you use.
        /// </p>
        pub fn min_inference_units(mut self, inp: i32) -> Self {
            self.inner = self.inner.min_inference_units(inp);
            self
        }
        /// <p>The minimum number of inference units to use. A single
        /// inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS).
        /// Use a higher number to increase the TPS throughput of your model. You are charged for the number
        /// of inference units that you use.
        /// </p>
        pub fn set_min_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_inference_units(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSegmentDetection`.
    ///
    /// <p>Starts asynchronous detection of segment detection in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect segments in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and
    /// the filename of the video. <code>StartSegmentDetection</code> returns a job identifier (<code>JobId</code>) which you use to get
    /// the results of the operation. When segment detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic
    /// that you specify in <code>NotificationChannel</code>.</p>
    /// <p>You can use the <code>Filters</code> (<a>StartSegmentDetectionFilters</a>)
    /// input parameter to specify the minimum detection confidence returned in the response.
    /// Within <code>Filters</code>, use <code>ShotFilter</code> (<a>StartShotDetectionFilter</a>)
    /// to filter detected shots. Use  <code>TechnicalCueFilter</code> (<a>StartTechnicalCueDetectionFilter</a>)
    /// to filter technical cues. </p>
    /// <p>To get the results of the segment detection operation, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. if so, call <a>GetSegmentDetection</a> and pass the job identifier (<code>JobId</code>)
    /// from the initial call to <code>StartSegmentDetection</code>. </p>
    ///
    ///
    /// <p>For more information, see Detecting Video Segments in Stored Video in the Amazon Rekognition Developer Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSegmentDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_segment_detection_input::Builder,
    }
    impl<C, M, R> StartSegmentDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSegmentDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSegmentDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSegmentDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSegmentDetectionInputOperationOutputAlias,
                crate::output::StartSegmentDetectionOutput,
                crate::error::StartSegmentDetectionError,
                crate::input::StartSegmentDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <a>StartLabelDetection</a> use <code>Video</code> to
        /// specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <a>StartLabelDetection</a> use <code>Video</code> to
        /// specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple
        /// <code>StartSegmentDetection</code> requests, the same <code>JobId</code> is returned. Use
        /// <code>ClientRequestToken</code> to prevent the same job from being accidently started more than once. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the
        /// segment detection operation. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the
        /// segment detection operation. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic.
        /// For example, you can use <code>JobTag</code> to group related jobs and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>Filters for technical cue or shot detection.</p>
        pub fn filters(mut self, inp: crate::model::StartSegmentDetectionFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters for technical cue or shot detection.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::StartSegmentDetectionFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `SegmentTypes`.
        ///
        /// To override the contents of this collection use [`set_segment_types`](Self::set_segment_types).
        ///
        /// <p>An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.</p>
        pub fn segment_types(mut self, inp: impl Into<crate::model::SegmentType>) -> Self {
            self.inner = self.inner.segment_types(inp);
            self
        }
        /// <p>An array of segment types to detect in the video. Valid values are TECHNICAL_CUE and SHOT.</p>
        pub fn set_segment_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SegmentType>>,
        ) -> Self {
            self.inner = self.inner.set_segment_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartStreamProcessor`.
    ///
    /// <p>Starts processing a stream processor. You create a stream processor by calling <a>CreateStreamProcessor</a>.
    /// To tell <code>StartStreamProcessor</code> which stream processor to start, use the value of the <code>Name</code> field specified in the call to
    /// <code>CreateStreamProcessor</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartStreamProcessor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_stream_processor_input::Builder,
    }
    impl<C, M, R> StartStreamProcessor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::StartStreamProcessorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartStreamProcessorInputOperationOutputAlias,
                crate::output::StartStreamProcessorOutput,
                crate::error::StartStreamProcessorError,
                crate::input::StartStreamProcessorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stream processor to start processing.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the stream processor to start processing.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTextDetection`.
    ///
    /// <p>Starts asynchronous detection of text in a stored video.</p>
    /// <p>Amazon Rekognition Video can detect text in a video stored in an Amazon S3 bucket. Use <a>Video</a> to specify the bucket name and
    /// the filename of the video. <code>StartTextDetection</code> returns a job identifier (<code>JobId</code>) which you use to get
    /// the results of the operation. When text detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic
    /// that you specify in <code>NotificationChannel</code>.</p>
    /// <p>To get the results of the text detection operation, first check that the status value published to the Amazon SNS
    /// topic is <code>SUCCEEDED</code>. if so, call <a>GetTextDetection</a> and pass the job identifier (<code>JobId</code>)
    /// from the initial call to <code>StartTextDetection</code>. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartTextDetection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_text_detection_input::Builder,
    }
    impl<C, M, R> StartTextDetection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTextDetection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTextDetectionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTextDetectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTextDetectionInputOperationOutputAlias,
                crate::output::StartTextDetectionOutput,
                crate::error::StartTextDetectionError,
                crate::input::StartTextDetectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <a>StartLabelDetection</a> use <code>Video</code> to
        /// specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn video(mut self, inp: crate::model::Video) -> Self {
            self.inner = self.inner.video(inp);
            self
        }
        /// <p>Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as <a>StartLabelDetection</a> use <code>Video</code> to
        /// specify a video for analysis. The supported file formats are .mp4, .mov and .avi.</p>
        pub fn set_video(mut self, input: std::option::Option<crate::model::Video>) -> Self {
            self.inner = self.inner.set_video(input);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartTextDetection</code>
        /// requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job
        /// from being accidentaly started more than once.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>Idempotent token used to identify the start request. If you use the same token with multiple <code>StartTextDetection</code>
        /// requests, the same <code>JobId</code> is returned. Use <code>ClientRequestToken</code> to prevent the same job
        /// from being accidentaly started more than once.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see
        /// <a>api-video</a>. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.
        /// For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics">Giving access to multiple Amazon SNS topics</a>.</p>
        pub fn notification_channel(mut self, inp: crate::model::NotificationChannel) -> Self {
            self.inner = self.inner.notification_channel(inp);
            self
        }
        /// <p>The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see
        /// <a>api-video</a>. Note that the Amazon SNS topic must have a topic name that begins with <i>AmazonRekognition</i> if you are using the AmazonRekognitionServiceRole permissions policy to access the topic.
        /// For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics">Giving access to multiple Amazon SNS topics</a>.</p>
        pub fn set_notification_channel(
            mut self,
            input: std::option::Option<crate::model::NotificationChannel>,
        ) -> Self {
            self.inner = self.inner.set_notification_channel(input);
            self
        }
        /// <p>An identifier returned in the completion status published by your Amazon Simple Notification Service topic.  For example, you can use <code>JobTag</code> to group related jobs
        /// and identify them in the completion notification.</p>
        pub fn job_tag(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_tag(inp);
            self
        }
        /// <p>An identifier returned in the completion status published by your Amazon Simple Notification Service topic.  For example, you can use <code>JobTag</code> to group related jobs
        /// and identify them in the completion notification.</p>
        pub fn set_job_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_tag(input);
            self
        }
        /// <p>Optional parameters that let you set criteria the text must meet to be included in your response.</p>
        pub fn filters(mut self, inp: crate::model::StartTextDetectionFilters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Optional parameters that let you set criteria the text must meet to be included in your response.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<crate::model::StartTextDetectionFilters>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopProjectVersion`.
    ///
    /// <p>Stops a running model. The operation might take a while to complete. To
    /// check the current status, call <a>DescribeProjectVersions</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct StopProjectVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_project_version_input::Builder,
    }
    impl<C, M, R> StopProjectVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopProjectVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopProjectVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopProjectVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopProjectVersionInputOperationOutputAlias,
                crate::output::StopProjectVersionOutput,
                crate::error::StopProjectVersionError,
                crate::input::StopProjectVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        /// <p>This operation requires permissions to perform the <code>rekognition:StopProjectVersion</code> action.</p>
        pub fn project_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model version that you want to delete.</p>
        /// <p>This operation requires permissions to perform the <code>rekognition:StopProjectVersion</code> action.</p>
        pub fn set_project_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopStreamProcessor`.
    ///
    /// <p>Stops a running stream processor that was created by <a>CreateStreamProcessor</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopStreamProcessor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_stream_processor_input::Builder,
    }
    impl<C, M, R> StopStreamProcessor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopStreamProcessor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopStreamProcessorOutput,
            aws_smithy_http::result::SdkError<crate::error::StopStreamProcessorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopStreamProcessorInputOperationOutputAlias,
                crate::output::StopStreamProcessorOutput,
                crate::error::StopStreamProcessorError,
                crate::input::StopStreamProcessorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a stream processor created by <a>CreateStreamProcessor</a>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of a stream processor created by <a>CreateStreamProcessor</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>
    /// Adds one or more key-value tags to an Amazon Rekognition collection, stream processor, or Custom Labels model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
    /// </p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:TagResource</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to assign the tags to.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to assign the tags to.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The key-value tags to assign to the resource.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// The key-value tags to assign to the resource.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>
    /// Removes one or more tags from an Amazon Rekognition collection, stream processor, or Custom Labels model.
    /// </p>
    /// <p>This operation requires permissions to perform the
    /// <code>rekognition:UntagResource</code> action. </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to remove the tags from.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// Amazon Resource Name (ARN) of the model, collection, or stream processor that you want to remove the tags from.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>
        /// A list of the tags that you want to remove.
        /// </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>
        /// A list of the tags that you want to remove.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatasetEntries`.
    ///
    /// <p>Adds or updates one or more entries (images) in a dataset. An entry is a JSON Line which contains the
    /// information for a single image,  including
    /// the image location, assigned labels, and object location bounding boxes.  For more information,
    /// see Image-Level labels in manifest files and Object localization in manifest files in the <i>Amazon Rekognition Custom Labels Developer Guide</i>.
    /// </p>
    ///
    ///
    ///
    /// <p>If the <code>source-ref</code> field in the JSON line references an existing image, the existing image in the dataset
    /// is updated.
    /// If <code>source-ref</code> field doesn't reference an existing image, the image is added as a new image to the dataset. </p>
    ///
    /// <p>You specify the changes that you want to make in the <code>Changes</code> input parameter.
    /// There isn't a limit to the number JSON Lines that you can change, but the size of <code>Changes</code> must be less
    /// than 5MB.</p>
    ///
    ///
    /// <p>
    /// <code>UpdateDatasetEntries</code> returns immediatly, but the dataset update might take a while to complete.
    /// Use <a>DescribeDataset</a> to check the
    /// current status. The dataset updated successfully if the value of <code>Status</code> is
    /// <code>UPDATE_COMPLETE</code>. </p>
    /// <p>To check if any non-terminal errors occured, call <a>ListDatasetEntries</a>
    /// and check for the presence of <code>errors</code> lists in the JSON Lines.</p>
    /// <p>Dataset update fails if a terminal error occurs (<code>Status</code> = <code>UPDATE_FAILED</code>).
    /// Currently, you can't access the terminal error information from the Amazon Rekognition Custom Labels SDK.
    /// </p>
    /// <p>This operation requires permissions to perform the <code>rekognition:UpdateDatasetEntries</code> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDatasetEntries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dataset_entries_input::Builder,
    }
    impl<C, M, R> UpdateDatasetEntries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetEntriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDatasetEntriesInputOperationOutputAlias,
                crate::output::UpdateDatasetEntriesOutput,
                crate::error::UpdateDatasetEntriesError,
                crate::input::UpdateDatasetEntriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the dataset that you want to update.
        /// </p>
        pub fn dataset_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the dataset that you want to update.
        /// </p>
        pub fn set_dataset_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_arn(input);
            self
        }
        /// <p>
        /// The changes that you want to make to the dataset.
        /// </p>
        pub fn changes(mut self, inp: crate::model::DatasetChanges) -> Self {
            self.inner = self.inner.changes(inp);
            self
        }
        /// <p>
        /// The changes that you want to make to the dataset.
        /// </p>
        pub fn set_changes(
            mut self,
            input: std::option::Option<crate::model::DatasetChanges>,
        ) -> Self {
            self.inner = self.inner.set_changes(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
