// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The number of in-progress human reviews you have has exceeded the number allowed.</p>
    HumanLoopQuotaExceededException(crate::error::HumanLoopQuotaExceededException),
    /// <p>A <code>ClientRequestToken</code> input parameter was reused with an operation, but at least one of the other input
    /// parameters is different from the previous call to the operation.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>The input image size exceeds the allowed limit. If you are calling
    /// DetectProtectiveEquipment, the image size or resolution exceeds the allowed limit. For more information, see
    /// Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide. </p>
    ImageTooLargeException(crate::error::ImageTooLargeException),
    /// <p>Amazon Rekognition experienced a service issue. Try your call again.</p>
    InternalServerError(crate::error::InternalServerError),
    /// <p>The provided image format is not supported. </p>
    InvalidImageFormatException(crate::error::InvalidImageFormatException),
    /// <p>Pagination token in the request is not valid.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>Input parameter violated a constraint. Validate your parameter before calling the API
    /// operation again.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Amazon Rekognition is unable to access the S3 object specified in the request.</p>
    InvalidS3ObjectException(crate::error::InvalidS3ObjectException),
    /// <p>An Amazon Rekognition service limit was exceeded. For example, if you start too many Amazon Rekognition Video jobs concurrently, calls to start operations
    /// (<code>StartLabelDetection</code>, for example) will raise a <code>LimitExceededException</code> exception (HTTP status code: 400) until
    /// the number of concurrently running jobs is below the Amazon Rekognition service limit.  </p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The number of requests exceeded your throughput limit. If you want to increase this
    /// limit, contact Amazon Rekognition.</p>
    ProvisionedThroughputExceededException(crate::error::ProvisionedThroughputExceededException),
    /// <p>A resource with the specified ID already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource is already being used.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource specified in the request cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource isn't ready. For example,  
    /// this exception occurs when you call <code>DetectCustomLabels</code> with a
    /// model version that isn't deployed. </p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p></p>
    ///
    ///
    /// <p>The size of the collection exceeds the allowed limit. For more information, see
    /// Limits in Amazon Rekognition in the Amazon Rekognition Developer Guide. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Amazon Rekognition is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The file size or duration of the supplied media is too large. The maximum file size is 10GB.
    /// The maximum duration is 6 hours. </p>
    VideoTooLargeException(crate::error::VideoTooLargeException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::HumanLoopQuotaExceededException(inner) => inner.fmt(f),
            Error::IdempotentParameterMismatchException(inner) => inner.fmt(f),
            Error::ImageTooLargeException(inner) => inner.fmt(f),
            Error::InternalServerError(inner) => inner.fmt(f),
            Error::InvalidImageFormatException(inner) => inner.fmt(f),
            Error::InvalidPaginationTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidS3ObjectException(inner) => inner.fmt(f),
            Error::LimitExceededException(inner) => inner.fmt(f),
            Error::ProvisionedThroughputExceededException(inner) => inner.fmt(f),
            Error::ResourceAlreadyExistsException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ResourceNotReadyException(inner) => inner.fmt(f),
            Error::ServiceQuotaExceededException(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::VideoTooLargeException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CompareFacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CompareFacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CompareFacesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CompareFacesErrorKind::ImageTooLargeException(inner) => {
                    Error::ImageTooLargeException(inner)
                }
                crate::error::CompareFacesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CompareFacesErrorKind::InvalidImageFormatException(inner) => {
                    Error::InvalidImageFormatException(inner)
                }
                crate::error::CompareFacesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CompareFacesErrorKind::InvalidS3ObjectException(inner) => {
                    Error::InvalidS3ObjectException(inner)
                }
                crate::error::CompareFacesErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::CompareFacesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CompareFacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCollectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCollectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCollectionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateCollectionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateCollectionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateCollectionErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::CreateCollectionErrorKind::ResourceAlreadyExistsException(inner) => {
                    Error::ResourceAlreadyExistsException(inner)
                }
                crate::error::CreateCollectionErrorKind::ServiceQuotaExceededException(inner) => {
                    Error::ServiceQuotaExceededException(inner)
                }
                crate::error::CreateCollectionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateCollectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateProjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateProjectError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateProjectErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateProjectErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::CreateProjectErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::CreateProjectErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::CreateProjectErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::CreateProjectErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::CreateProjectErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::CreateProjectErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateProjectVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateProjectVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateProjectVersionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateProjectVersionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::CreateProjectVersionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateProjectVersionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateProjectVersionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::CreateProjectVersionErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CreateProjectVersionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CreateProjectVersionErrorKind::ServiceQuotaExceededException(inner) => Error::ServiceQuotaExceededException(inner),
                crate::error::CreateProjectVersionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::CreateProjectVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateStreamProcessorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateStreamProcessorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateStreamProcessorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateStreamProcessorErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::CreateStreamProcessorErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::CreateStreamProcessorErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::CreateStreamProcessorErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::CreateStreamProcessorErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CreateStreamProcessorErrorKind::ServiceQuotaExceededException(inner) => Error::ServiceQuotaExceededException(inner),
                crate::error::CreateStreamProcessorErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::CreateStreamProcessorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCollectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCollectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCollectionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteCollectionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteCollectionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteCollectionErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DeleteCollectionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteCollectionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteCollectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteFacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFacesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteFacesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteFacesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteFacesErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DeleteFacesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteFacesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteFacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteProjectError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteProjectError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteProjectErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteProjectErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DeleteProjectErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DeleteProjectErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DeleteProjectErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::DeleteProjectErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteProjectErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DeleteProjectErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteProjectVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteProjectVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteProjectVersionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteProjectVersionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeleteProjectVersionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteProjectVersionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DeleteProjectVersionErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::DeleteProjectVersionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteProjectVersionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DeleteProjectVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteStreamProcessorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteStreamProcessorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteStreamProcessorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteStreamProcessorErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DeleteStreamProcessorErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DeleteStreamProcessorErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DeleteStreamProcessorErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::DeleteStreamProcessorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteStreamProcessorErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DeleteStreamProcessorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCollectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCollectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCollectionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeCollectionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeCollectionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DescribeCollectionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DescribeCollectionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeCollectionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeCollectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeProjectsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeProjectsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeProjectsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DescribeProjectsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DescribeProjectsErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::DescribeProjectsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DescribeProjectsErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DescribeProjectsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DescribeProjectsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeProjectVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeProjectVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeProjectVersionsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeProjectVersionsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeProjectVersionsErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::DescribeProjectVersionsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DescribeProjectVersionsErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DescribeProjectVersionsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeProjectVersionsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeProjectVersionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStreamProcessorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeStreamProcessorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeStreamProcessorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DescribeStreamProcessorErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DescribeStreamProcessorErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DescribeStreamProcessorErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DescribeStreamProcessorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DescribeStreamProcessorErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DescribeStreamProcessorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectCustomLabelsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectCustomLabelsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DetectCustomLabelsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DetectCustomLabelsErrorKind::ImageTooLargeException(inner) => Error::ImageTooLargeException(inner),
                crate::error::DetectCustomLabelsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DetectCustomLabelsErrorKind::InvalidImageFormatException(inner) => Error::InvalidImageFormatException(inner),
                crate::error::DetectCustomLabelsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DetectCustomLabelsErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::DetectCustomLabelsErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::DetectCustomLabelsErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DetectCustomLabelsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DetectCustomLabelsErrorKind::ResourceNotReadyException(inner) => Error::ResourceNotReadyException(inner),
                crate::error::DetectCustomLabelsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DetectCustomLabelsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectFacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetectFacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectFacesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DetectFacesErrorKind::ImageTooLargeException(inner) => {
                    Error::ImageTooLargeException(inner)
                }
                crate::error::DetectFacesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DetectFacesErrorKind::InvalidImageFormatException(inner) => {
                    Error::InvalidImageFormatException(inner)
                }
                crate::error::DetectFacesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DetectFacesErrorKind::InvalidS3ObjectException(inner) => {
                    Error::InvalidS3ObjectException(inner)
                }
                crate::error::DetectFacesErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DetectFacesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DetectFacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectLabelsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetectLabelsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectLabelsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DetectLabelsErrorKind::ImageTooLargeException(inner) => {
                    Error::ImageTooLargeException(inner)
                }
                crate::error::DetectLabelsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DetectLabelsErrorKind::InvalidImageFormatException(inner) => {
                    Error::InvalidImageFormatException(inner)
                }
                crate::error::DetectLabelsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DetectLabelsErrorKind::InvalidS3ObjectException(inner) => {
                    Error::InvalidS3ObjectException(inner)
                }
                crate::error::DetectLabelsErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DetectLabelsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DetectLabelsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectModerationLabelsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectModerationLabelsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DetectModerationLabelsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DetectModerationLabelsErrorKind::HumanLoopQuotaExceededException(inner) => Error::HumanLoopQuotaExceededException(inner),
                crate::error::DetectModerationLabelsErrorKind::ImageTooLargeException(inner) => Error::ImageTooLargeException(inner),
                crate::error::DetectModerationLabelsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DetectModerationLabelsErrorKind::InvalidImageFormatException(inner) => Error::InvalidImageFormatException(inner),
                crate::error::DetectModerationLabelsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DetectModerationLabelsErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::DetectModerationLabelsErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DetectModerationLabelsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DetectModerationLabelsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectProtectiveEquipmentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DetectProtectiveEquipmentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DetectProtectiveEquipmentErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::ImageTooLargeException(inner) => Error::ImageTooLargeException(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::InvalidImageFormatException(inner) => Error::InvalidImageFormatException(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::DetectProtectiveEquipmentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetectTextError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetectTextError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetectTextErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DetectTextErrorKind::ImageTooLargeException(inner) => {
                    Error::ImageTooLargeException(inner)
                }
                crate::error::DetectTextErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::DetectTextErrorKind::InvalidImageFormatException(inner) => {
                    Error::InvalidImageFormatException(inner)
                }
                crate::error::DetectTextErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::DetectTextErrorKind::InvalidS3ObjectException(inner) => {
                    Error::InvalidS3ObjectException(inner)
                }
                crate::error::DetectTextErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::DetectTextErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::DetectTextErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCelebrityInfoError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCelebrityInfoError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCelebrityInfoErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetCelebrityInfoErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetCelebrityInfoErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetCelebrityInfoErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetCelebrityInfoErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetCelebrityInfoErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetCelebrityInfoErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCelebrityRecognitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCelebrityRecognitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCelebrityRecognitionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetCelebrityRecognitionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetCelebrityRecognitionErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::GetCelebrityRecognitionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetCelebrityRecognitionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetCelebrityRecognitionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetCelebrityRecognitionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetCelebrityRecognitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContentModerationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContentModerationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetContentModerationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetContentModerationErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetContentModerationErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::GetContentModerationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetContentModerationErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetContentModerationErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetContentModerationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetContentModerationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFaceDetectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetFaceDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFaceDetectionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetFaceDetectionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetFaceDetectionErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::GetFaceDetectionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetFaceDetectionErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetFaceDetectionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetFaceDetectionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetFaceDetectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFaceSearchError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetFaceSearchError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFaceSearchErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetFaceSearchErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetFaceSearchErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::GetFaceSearchErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetFaceSearchErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetFaceSearchErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetFaceSearchErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetFaceSearchErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLabelDetectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetLabelDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetLabelDetectionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetLabelDetectionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetLabelDetectionErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::GetLabelDetectionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetLabelDetectionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetLabelDetectionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetLabelDetectionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetLabelDetectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPersonTrackingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPersonTrackingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetPersonTrackingErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetPersonTrackingErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetPersonTrackingErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::GetPersonTrackingErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetPersonTrackingErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetPersonTrackingErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetPersonTrackingErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetPersonTrackingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetSegmentDetectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetSegmentDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetSegmentDetectionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetSegmentDetectionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::GetSegmentDetectionErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::GetSegmentDetectionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::GetSegmentDetectionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetSegmentDetectionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetSegmentDetectionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::GetSegmentDetectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetTextDetectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetTextDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetTextDetectionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetTextDetectionErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::GetTextDetectionErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::GetTextDetectionErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::GetTextDetectionErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::GetTextDetectionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetTextDetectionErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::GetTextDetectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::IndexFacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::IndexFacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::IndexFacesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::IndexFacesErrorKind::ImageTooLargeException(inner) => {
                    Error::ImageTooLargeException(inner)
                }
                crate::error::IndexFacesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::IndexFacesErrorKind::InvalidImageFormatException(inner) => {
                    Error::InvalidImageFormatException(inner)
                }
                crate::error::IndexFacesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::IndexFacesErrorKind::InvalidS3ObjectException(inner) => {
                    Error::InvalidS3ObjectException(inner)
                }
                crate::error::IndexFacesErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::IndexFacesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::IndexFacesErrorKind::ServiceQuotaExceededException(inner) => {
                    Error::ServiceQuotaExceededException(inner)
                }
                crate::error::IndexFacesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::IndexFacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListCollectionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListCollectionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListCollectionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListCollectionsErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListCollectionsErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::ListCollectionsErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListCollectionsErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::ListCollectionsErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListCollectionsErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListCollectionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListFacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListFacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListFacesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListFacesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::ListFacesErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::ListFacesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListFacesErrorKind::ProvisionedThroughputExceededException(inner) => {
                    Error::ProvisionedThroughputExceededException(inner)
                }
                crate::error::ListFacesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListFacesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::ListFacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListStreamProcessorsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListStreamProcessorsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListStreamProcessorsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListStreamProcessorsErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::ListStreamProcessorsErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListStreamProcessorsErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListStreamProcessorsErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::ListStreamProcessorsErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListStreamProcessorsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListTagsForResourceErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::ListTagsForResourceErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::ListTagsForResourceErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ListTagsForResourceErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RecognizeCelebritiesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RecognizeCelebritiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RecognizeCelebritiesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RecognizeCelebritiesErrorKind::ImageTooLargeException(inner) => Error::ImageTooLargeException(inner),
                crate::error::RecognizeCelebritiesErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::RecognizeCelebritiesErrorKind::InvalidImageFormatException(inner) => Error::InvalidImageFormatException(inner),
                crate::error::RecognizeCelebritiesErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::RecognizeCelebritiesErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::RecognizeCelebritiesErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::RecognizeCelebritiesErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::RecognizeCelebritiesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchFacesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::SearchFacesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SearchFacesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SearchFacesErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::SearchFacesErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::SearchFacesErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::SearchFacesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::SearchFacesErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::SearchFacesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SearchFacesByImageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SearchFacesByImageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::SearchFacesByImageErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::SearchFacesByImageErrorKind::ImageTooLargeException(inner) => Error::ImageTooLargeException(inner),
                crate::error::SearchFacesByImageErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::SearchFacesByImageErrorKind::InvalidImageFormatException(inner) => Error::InvalidImageFormatException(inner),
                crate::error::SearchFacesByImageErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::SearchFacesByImageErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::SearchFacesByImageErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::SearchFacesByImageErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::SearchFacesByImageErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::SearchFacesByImageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartCelebrityRecognitionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartCelebrityRecognitionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartCelebrityRecognitionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartCelebrityRecognitionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::VideoTooLargeException(inner) => Error::VideoTooLargeException(inner),
                crate::error::StartCelebrityRecognitionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartContentModerationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartContentModerationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartContentModerationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartContentModerationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartContentModerationErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartContentModerationErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartContentModerationErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::StartContentModerationErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartContentModerationErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartContentModerationErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartContentModerationErrorKind::VideoTooLargeException(inner) => Error::VideoTooLargeException(inner),
                crate::error::StartContentModerationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartFaceDetectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartFaceDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartFaceDetectionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartFaceDetectionErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartFaceDetectionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartFaceDetectionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartFaceDetectionErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::StartFaceDetectionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartFaceDetectionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartFaceDetectionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartFaceDetectionErrorKind::VideoTooLargeException(inner) => Error::VideoTooLargeException(inner),
                crate::error::StartFaceDetectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartFaceSearchError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartFaceSearchError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartFaceSearchErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::StartFaceSearchErrorKind::IdempotentParameterMismatchException(
                    inner,
                ) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartFaceSearchErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::StartFaceSearchErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::StartFaceSearchErrorKind::InvalidS3ObjectException(inner) => {
                    Error::InvalidS3ObjectException(inner)
                }
                crate::error::StartFaceSearchErrorKind::LimitExceededException(inner) => {
                    Error::LimitExceededException(inner)
                }
                crate::error::StartFaceSearchErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartFaceSearchErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::StartFaceSearchErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::StartFaceSearchErrorKind::VideoTooLargeException(inner) => {
                    Error::VideoTooLargeException(inner)
                }
                crate::error::StartFaceSearchErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartLabelDetectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartLabelDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartLabelDetectionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartLabelDetectionErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartLabelDetectionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartLabelDetectionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartLabelDetectionErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::StartLabelDetectionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartLabelDetectionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartLabelDetectionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartLabelDetectionErrorKind::VideoTooLargeException(inner) => Error::VideoTooLargeException(inner),
                crate::error::StartLabelDetectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartPersonTrackingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartPersonTrackingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartPersonTrackingErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartPersonTrackingErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartPersonTrackingErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartPersonTrackingErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartPersonTrackingErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::StartPersonTrackingErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartPersonTrackingErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartPersonTrackingErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartPersonTrackingErrorKind::VideoTooLargeException(inner) => Error::VideoTooLargeException(inner),
                crate::error::StartPersonTrackingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartProjectVersionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartProjectVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartProjectVersionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartProjectVersionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartProjectVersionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartProjectVersionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartProjectVersionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartProjectVersionErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::StartProjectVersionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StartProjectVersionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartProjectVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartSegmentDetectionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartSegmentDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartSegmentDetectionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartSegmentDetectionErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartSegmentDetectionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartSegmentDetectionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartSegmentDetectionErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::StartSegmentDetectionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartSegmentDetectionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartSegmentDetectionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartSegmentDetectionErrorKind::VideoTooLargeException(inner) => Error::VideoTooLargeException(inner),
                crate::error::StartSegmentDetectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartStreamProcessorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartStreamProcessorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartStreamProcessorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartStreamProcessorErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartStreamProcessorErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartStreamProcessorErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartStreamProcessorErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::StartStreamProcessorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StartStreamProcessorErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartStreamProcessorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartTextDetectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartTextDetectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartTextDetectionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StartTextDetectionErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartTextDetectionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StartTextDetectionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StartTextDetectionErrorKind::InvalidS3ObjectException(inner) => Error::InvalidS3ObjectException(inner),
                crate::error::StartTextDetectionErrorKind::LimitExceededException(inner) => Error::LimitExceededException(inner),
                crate::error::StartTextDetectionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StartTextDetectionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StartTextDetectionErrorKind::VideoTooLargeException(inner) => Error::VideoTooLargeException(inner),
                crate::error::StartTextDetectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopProjectVersionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopProjectVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopProjectVersionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StopProjectVersionErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StopProjectVersionErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StopProjectVersionErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StopProjectVersionErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::StopProjectVersionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StopProjectVersionErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StopProjectVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopStreamProcessorError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopStreamProcessorError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopStreamProcessorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::StopStreamProcessorErrorKind::InternalServerError(inner) => Error::InternalServerError(inner),
                crate::error::StopStreamProcessorErrorKind::InvalidParameterException(inner) => Error::InvalidParameterException(inner),
                crate::error::StopStreamProcessorErrorKind::ProvisionedThroughputExceededException(inner) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::StopStreamProcessorErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::StopStreamProcessorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StopStreamProcessorErrorKind::ThrottlingException(inner) => Error::ThrottlingException(inner),
                crate::error::StopStreamProcessorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::TagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::TagResourceErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::ServiceQuotaExceededException(inner) => {
                    Error::ServiceQuotaExceededException(inner)
                }
                crate::error::TagResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UntagResourceErrorKind::InternalServerError(inner) => {
                    Error::InternalServerError(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UntagResourceErrorKind::ProvisionedThroughputExceededException(
                    inner,
                ) => Error::ProvisionedThroughputExceededException(inner),
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::ThrottlingException(inner) => {
                    Error::ThrottlingException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
