// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The properties of a table. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableMember {
    /// <p>The name of the table. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the table. Possible values include TABLE, VIEW, SYSTEM TABLE, GLOBAL TEMPORARY, LOCAL TEMPORARY, ALIAS, and SYNONYM. </p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The schema containing the table. </p>
    pub schema: std::option::Option<std::string::String>,
}
impl TableMember {
    /// <p>The name of the table. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the table. Possible values include TABLE, VIEW, SYSTEM TABLE, GLOBAL TEMPORARY, LOCAL TEMPORARY, ALIAS, and SYNONYM. </p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The schema containing the table. </p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for TableMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableMember");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`TableMember`](crate::model::TableMember)
pub mod table_member {
    /// A builder for [`TableMember`](crate::model::TableMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the table. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the table. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the table. Possible values include TABLE, VIEW, SYSTEM TABLE, GLOBAL TEMPORARY, LOCAL TEMPORARY, ALIAS, and SYNONYM. </p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of the table. Possible values include TABLE, VIEW, SYSTEM TABLE, GLOBAL TEMPORARY, LOCAL TEMPORARY, ALIAS, and SYNONYM. </p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The schema containing the table. </p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema containing the table. </p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`TableMember`](crate::model::TableMember)
        pub fn build(self) -> crate::model::TableMember {
            crate::model::TableMember {
                name: self.name,
                r#type: self.r#type,
                schema: self.schema,
            }
        }
    }
}
impl TableMember {
    /// Creates a new builder-style object to manufacture [`TableMember`](crate::model::TableMember)
    pub fn builder() -> crate::model::table_member::Builder {
        crate::model::table_member::Builder::default()
    }
}

/// <p>The SQL statement to run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatementData {
    /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The SQL statement.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query request.</p>
    pub query_strings: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
    pub status: std::option::Option<crate::model::StatusString>,
    /// <p>The name of the SQL statement. </p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The date and time (UTC) the statement was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The parameters used in a SQL statement.</p>
    pub query_parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
    /// <p>A value that indicates whether the statement is a batch query request.</p>
    pub is_batch_statement: std::option::Option<bool>,
}
impl StatementData {
    /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The SQL statement.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query request.</p>
    pub fn query_strings(&self) -> std::option::Option<&[std::string::String]> {
        self.query_strings.as_deref()
    }
    /// <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusString> {
        self.status.as_ref()
    }
    /// <p>The name of the SQL statement. </p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
    /// <p>The date and time (UTC) the statement was created. </p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The parameters used in a SQL statement.</p>
    pub fn query_parameters(&self) -> std::option::Option<&[crate::model::SqlParameter]> {
        self.query_parameters.as_deref()
    }
    /// <p>A value that indicates whether the statement is a batch query request.</p>
    pub fn is_batch_statement(&self) -> std::option::Option<bool> {
        self.is_batch_statement
    }
}
impl std::fmt::Debug for StatementData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatementData");
        formatter.field("id", &self.id);
        formatter.field("query_string", &self.query_string);
        formatter.field("query_strings", &self.query_strings);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("status", &self.status);
        formatter.field("statement_name", &self.statement_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("query_parameters", &self.query_parameters);
        formatter.field("is_batch_statement", &self.is_batch_statement);
        formatter.finish()
    }
}
/// See [`StatementData`](crate::model::StatementData)
pub mod statement_data {
    /// A builder for [`StatementData`](crate::model::StatementData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) query_strings: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusString>,
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) query_parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        pub(crate) is_batch_statement: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The SQL statement.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The SQL statement.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// Appends an item to `query_strings`.
        ///
        /// To override the contents of this collection use [`set_query_strings`](Self::set_query_strings).
        ///
        /// <p>One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query request.</p>
        pub fn query_strings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.query_strings.unwrap_or_default();
            v.push(input.into());
            self.query_strings = Some(v);
            self
        }
        /// <p>One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query request.</p>
        pub fn set_query_strings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.query_strings = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
        pub fn status(mut self, input: crate::model::StatusString) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusString>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the SQL statement. </p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the SQL statement. </p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Appends an item to `query_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_parameters`](Self::set_query_parameters).
        ///
        /// <p>The parameters used in a SQL statement.</p>
        pub fn query_parameters(mut self, input: crate::model::SqlParameter) -> Self {
            let mut v = self.query_parameters.unwrap_or_default();
            v.push(input);
            self.query_parameters = Some(v);
            self
        }
        /// <p>The parameters used in a SQL statement.</p>
        pub fn set_query_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.query_parameters = input;
            self
        }
        /// <p>A value that indicates whether the statement is a batch query request.</p>
        pub fn is_batch_statement(mut self, input: bool) -> Self {
            self.is_batch_statement = Some(input);
            self
        }
        /// <p>A value that indicates whether the statement is a batch query request.</p>
        pub fn set_is_batch_statement(mut self, input: std::option::Option<bool>) -> Self {
            self.is_batch_statement = input;
            self
        }
        /// Consumes the builder and constructs a [`StatementData`](crate::model::StatementData)
        pub fn build(self) -> crate::model::StatementData {
            crate::model::StatementData {
                id: self.id,
                query_string: self.query_string,
                query_strings: self.query_strings,
                secret_arn: self.secret_arn,
                status: self.status,
                statement_name: self.statement_name,
                created_at: self.created_at,
                updated_at: self.updated_at,
                query_parameters: self.query_parameters,
                is_batch_statement: self.is_batch_statement,
            }
        }
    }
}
impl StatementData {
    /// Creates a new builder-style object to manufacture [`StatementData`](crate::model::StatementData)
    pub fn builder() -> crate::model::statement_data::Builder {
        crate::model::statement_data::Builder::default()
    }
}

/// <p>A parameter used in a SQL statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlParameter {
    /// <p>The name of the parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter. Amazon Redshift implicitly converts to the proper data type. For more inforation, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html">Data types</a> in the <i>Amazon Redshift Database Developer Guide</i>. </p>
    pub value: std::option::Option<std::string::String>,
}
impl SqlParameter {
    /// <p>The name of the parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the parameter. Amazon Redshift implicitly converts to the proper data type. For more inforation, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html">Data types</a> in the <i>Amazon Redshift Database Developer Guide</i>. </p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SqlParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlParameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SqlParameter`](crate::model::SqlParameter)
pub mod sql_parameter {
    /// A builder for [`SqlParameter`](crate::model::SqlParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the parameter. Amazon Redshift implicitly converts to the proper data type. For more inforation, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html">Data types</a> in the <i>Amazon Redshift Database Developer Guide</i>. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the parameter. Amazon Redshift implicitly converts to the proper data type. For more inforation, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html">Data types</a> in the <i>Amazon Redshift Database Developer Guide</i>. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlParameter`](crate::model::SqlParameter)
        pub fn build(self) -> crate::model::SqlParameter {
            crate::model::SqlParameter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SqlParameter {
    /// Creates a new builder-style object to manufacture [`SqlParameter`](crate::model::SqlParameter)
    pub fn builder() -> crate::model::sql_parameter::Builder {
        crate::model::sql_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusString {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Finished,
    #[allow(missing_docs)] // documentation missing in model
    Picked,
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusString {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => StatusString::Aborted,
            "ALL" => StatusString::All,
            "FAILED" => StatusString::Failed,
            "FINISHED" => StatusString::Finished,
            "PICKED" => StatusString::Picked,
            "STARTED" => StatusString::Started,
            "SUBMITTED" => StatusString::Submitted,
            other => StatusString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusString::from(s))
    }
}
impl StatusString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusString::Aborted => "ABORTED",
            StatusString::All => "ALL",
            StatusString::Failed => "FAILED",
            StatusString::Finished => "FINISHED",
            StatusString::Picked => "PICKED",
            StatusString::Started => "STARTED",
            StatusString::Submitted => "SUBMITTED",
            StatusString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ABORTED",
            "ALL",
            "FAILED",
            "FINISHED",
            "PICKED",
            "STARTED",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for StatusString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The properties (metadata) of a column. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnMetadata {
    /// <p>A value that indicates whether the column is case-sensitive. </p>
    pub is_case_sensitive: bool,
    /// <p>A value that indicates whether the column contains currency values.</p>
    pub is_currency: bool,
    /// <p>A value that indicates whether an integer column is signed.</p>
    pub is_signed: bool,
    /// <p>The label for the column. </p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The name of the column. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the column is nullable. </p>
    pub nullable: i32,
    /// <p>The precision value of a decimal number column. </p>
    pub precision: i32,
    /// <p>The scale value of a decimal number column. </p>
    pub scale: i32,
    /// <p>The name of the schema that contains the table that includes the column.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the table that includes the column. </p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The database-specific data type of the column. </p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The length of the column.</p>
    pub length: i32,
    /// <p>The default value of the column. </p>
    pub column_default: std::option::Option<std::string::String>,
}
impl ColumnMetadata {
    /// <p>A value that indicates whether the column is case-sensitive. </p>
    pub fn is_case_sensitive(&self) -> bool {
        self.is_case_sensitive
    }
    /// <p>A value that indicates whether the column contains currency values.</p>
    pub fn is_currency(&self) -> bool {
        self.is_currency
    }
    /// <p>A value that indicates whether an integer column is signed.</p>
    pub fn is_signed(&self) -> bool {
        self.is_signed
    }
    /// <p>The label for the column. </p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>The name of the column. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A value that indicates whether the column is nullable. </p>
    pub fn nullable(&self) -> i32 {
        self.nullable
    }
    /// <p>The precision value of a decimal number column. </p>
    pub fn precision(&self) -> i32 {
        self.precision
    }
    /// <p>The scale value of a decimal number column. </p>
    pub fn scale(&self) -> i32 {
        self.scale
    }
    /// <p>The name of the schema that contains the table that includes the column.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The name of the table that includes the column. </p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The database-specific data type of the column. </p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The length of the column.</p>
    pub fn length(&self) -> i32 {
        self.length
    }
    /// <p>The default value of the column. </p>
    pub fn column_default(&self) -> std::option::Option<&str> {
        self.column_default.as_deref()
    }
}
impl std::fmt::Debug for ColumnMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnMetadata");
        formatter.field("is_case_sensitive", &self.is_case_sensitive);
        formatter.field("is_currency", &self.is_currency);
        formatter.field("is_signed", &self.is_signed);
        formatter.field("label", &self.label);
        formatter.field("name", &self.name);
        formatter.field("nullable", &self.nullable);
        formatter.field("precision", &self.precision);
        formatter.field("scale", &self.scale);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("type_name", &self.type_name);
        formatter.field("length", &self.length);
        formatter.field("column_default", &self.column_default);
        formatter.finish()
    }
}
/// See [`ColumnMetadata`](crate::model::ColumnMetadata)
pub mod column_metadata {
    /// A builder for [`ColumnMetadata`](crate::model::ColumnMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_case_sensitive: std::option::Option<bool>,
        pub(crate) is_currency: std::option::Option<bool>,
        pub(crate) is_signed: std::option::Option<bool>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) nullable: std::option::Option<i32>,
        pub(crate) precision: std::option::Option<i32>,
        pub(crate) scale: std::option::Option<i32>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) length: std::option::Option<i32>,
        pub(crate) column_default: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that indicates whether the column is case-sensitive. </p>
        pub fn is_case_sensitive(mut self, input: bool) -> Self {
            self.is_case_sensitive = Some(input);
            self
        }
        /// <p>A value that indicates whether the column is case-sensitive. </p>
        pub fn set_is_case_sensitive(mut self, input: std::option::Option<bool>) -> Self {
            self.is_case_sensitive = input;
            self
        }
        /// <p>A value that indicates whether the column contains currency values.</p>
        pub fn is_currency(mut self, input: bool) -> Self {
            self.is_currency = Some(input);
            self
        }
        /// <p>A value that indicates whether the column contains currency values.</p>
        pub fn set_is_currency(mut self, input: std::option::Option<bool>) -> Self {
            self.is_currency = input;
            self
        }
        /// <p>A value that indicates whether an integer column is signed.</p>
        pub fn is_signed(mut self, input: bool) -> Self {
            self.is_signed = Some(input);
            self
        }
        /// <p>A value that indicates whether an integer column is signed.</p>
        pub fn set_is_signed(mut self, input: std::option::Option<bool>) -> Self {
            self.is_signed = input;
            self
        }
        /// <p>The label for the column. </p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label for the column. </p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>The name of the column. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A value that indicates whether the column is nullable. </p>
        pub fn nullable(mut self, input: i32) -> Self {
            self.nullable = Some(input);
            self
        }
        /// <p>A value that indicates whether the column is nullable. </p>
        pub fn set_nullable(mut self, input: std::option::Option<i32>) -> Self {
            self.nullable = input;
            self
        }
        /// <p>The precision value of a decimal number column. </p>
        pub fn precision(mut self, input: i32) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>The precision value of a decimal number column. </p>
        pub fn set_precision(mut self, input: std::option::Option<i32>) -> Self {
            self.precision = input;
            self
        }
        /// <p>The scale value of a decimal number column. </p>
        pub fn scale(mut self, input: i32) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>The scale value of a decimal number column. </p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.scale = input;
            self
        }
        /// <p>The name of the schema that contains the table that includes the column.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema that contains the table that includes the column.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The name of the table that includes the column. </p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table that includes the column. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The database-specific data type of the column. </p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The database-specific data type of the column. </p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The length of the column.</p>
        pub fn length(mut self, input: i32) -> Self {
            self.length = Some(input);
            self
        }
        /// <p>The length of the column.</p>
        pub fn set_length(mut self, input: std::option::Option<i32>) -> Self {
            self.length = input;
            self
        }
        /// <p>The default value of the column. </p>
        pub fn column_default(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_default = Some(input.into());
            self
        }
        /// <p>The default value of the column. </p>
        pub fn set_column_default(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.column_default = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnMetadata`](crate::model::ColumnMetadata)
        pub fn build(self) -> crate::model::ColumnMetadata {
            crate::model::ColumnMetadata {
                is_case_sensitive: self.is_case_sensitive.unwrap_or_default(),
                is_currency: self.is_currency.unwrap_or_default(),
                is_signed: self.is_signed.unwrap_or_default(),
                label: self.label,
                name: self.name,
                nullable: self.nullable.unwrap_or_default(),
                precision: self.precision.unwrap_or_default(),
                scale: self.scale.unwrap_or_default(),
                schema_name: self.schema_name,
                table_name: self.table_name,
                type_name: self.type_name,
                length: self.length.unwrap_or_default(),
                column_default: self.column_default,
            }
        }
    }
}
impl ColumnMetadata {
    /// Creates a new builder-style object to manufacture [`ColumnMetadata`](crate::model::ColumnMetadata)
    pub fn builder() -> crate::model::column_metadata::Builder {
        crate::model::column_metadata::Builder::default()
    }
}

/// <p>A data value in a column. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Field {
    /// <p>A value of the BLOB data type. </p>
    BlobValue(aws_smithy_types::Blob),
    /// <p>A value of the Boolean data type. </p>
    BooleanValue(bool),
    /// <p>A value of the double data type. </p>
    DoubleValue(f64),
    /// <p>A value that indicates whether the data is NULL. </p>
    IsNull(bool),
    /// <p>A value of the long data type. </p>
    LongValue(i64),
    /// <p>A value of the string data type. </p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Field {
    /// Tries to convert the enum instance into [`BlobValue`](crate::model::Field::BlobValue), extracting the inner [`Blob`](aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_blob_value(&self) -> std::result::Result<&aws_smithy_types::Blob, &Self> {
        if let Field::BlobValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`BlobValue`](crate::model::Field::BlobValue).
    pub fn is_blob_value(&self) -> bool {
        self.as_blob_value().is_ok()
    }
    /// Tries to convert the enum instance into [`BooleanValue`](crate::model::Field::BooleanValue), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_boolean_value(&self) -> std::result::Result<&bool, &Self> {
        if let Field::BooleanValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`BooleanValue`](crate::model::Field::BooleanValue).
    pub fn is_boolean_value(&self) -> bool {
        self.as_boolean_value().is_ok()
    }
    /// Tries to convert the enum instance into [`DoubleValue`](crate::model::Field::DoubleValue), extracting the inner [`f64`](f64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_double_value(&self) -> std::result::Result<&f64, &Self> {
        if let Field::DoubleValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`DoubleValue`](crate::model::Field::DoubleValue).
    pub fn is_double_value(&self) -> bool {
        self.as_double_value().is_ok()
    }
    /// Tries to convert the enum instance into [`IsNull`](crate::model::Field::IsNull), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_is_null(&self) -> std::result::Result<&bool, &Self> {
        if let Field::IsNull(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`IsNull`](crate::model::Field::IsNull).
    pub fn is_is_null(&self) -> bool {
        self.as_is_null().is_ok()
    }
    /// Tries to convert the enum instance into [`LongValue`](crate::model::Field::LongValue), extracting the inner [`i64`](i64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_long_value(&self) -> std::result::Result<&i64, &Self> {
        if let Field::LongValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`LongValue`](crate::model::Field::LongValue).
    pub fn is_long_value(&self) -> bool {
        self.as_long_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::Field::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let Field::StringValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::Field::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Information about an SQL statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubStatementData {
    /// <p>The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The amount of time in nanoseconds that the statement ran.</p>
    pub duration: i64,
    /// <p>The error message from the cluster if the SQL statement encountered an error while running.</p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
    pub status: std::option::Option<crate::model::StatementStatusString>,
    /// <p>The date and time (UTC) the statement was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The SQL statement text.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>Either the number of rows returned from the SQL statement or the number of rows affected. If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.</p>
    pub result_rows: i64,
    /// <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
    pub result_size: i64,
    /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    pub redshift_query_id: i64,
    /// <p>A value that indicates whether the statement has a result set. The result set can be empty. The value is true for an empty result set.</p>
    pub has_result_set: std::option::Option<bool>,
}
impl SubStatementData {
    /// <p>The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The amount of time in nanoseconds that the statement ran.</p>
    pub fn duration(&self) -> i64 {
        self.duration
    }
    /// <p>The error message from the cluster if the SQL statement encountered an error while running.</p>
    pub fn error(&self) -> std::option::Option<&str> {
        self.error.as_deref()
    }
    /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatementStatusString> {
        self.status.as_ref()
    }
    /// <p>The date and time (UTC) the statement was created. </p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The SQL statement text.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>Either the number of rows returned from the SQL statement or the number of rows affected. If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.</p>
    pub fn result_rows(&self) -> i64 {
        self.result_rows
    }
    /// <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
    pub fn result_size(&self) -> i64 {
        self.result_size
    }
    /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    pub fn redshift_query_id(&self) -> i64 {
        self.redshift_query_id
    }
    /// <p>A value that indicates whether the statement has a result set. The result set can be empty. The value is true for an empty result set.</p>
    pub fn has_result_set(&self) -> std::option::Option<bool> {
        self.has_result_set
    }
}
impl std::fmt::Debug for SubStatementData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubStatementData");
        formatter.field("id", &self.id);
        formatter.field("duration", &self.duration);
        formatter.field("error", &self.error);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("query_string", &self.query_string);
        formatter.field("result_rows", &self.result_rows);
        formatter.field("result_size", &self.result_size);
        formatter.field("redshift_query_id", &self.redshift_query_id);
        formatter.field("has_result_set", &self.has_result_set);
        formatter.finish()
    }
}
/// See [`SubStatementData`](crate::model::SubStatementData)
pub mod sub_statement_data {
    /// A builder for [`SubStatementData`](crate::model::SubStatementData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i64>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatementStatusString>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) result_rows: std::option::Option<i64>,
        pub(crate) result_size: std::option::Option<i64>,
        pub(crate) redshift_query_id: std::option::Option<i64>,
        pub(crate) has_result_set: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The amount of time in nanoseconds that the statement ran.</p>
        pub fn duration(mut self, input: i64) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The amount of time in nanoseconds that the statement ran.</p>
        pub fn set_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The error message from the cluster if the SQL statement encountered an error while running.</p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error message from the cluster if the SQL statement encountered an error while running.</p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
        pub fn status(mut self, input: crate::model::StatementStatusString) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SQL statement. An example is the that the SQL statement finished. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatementStatusString>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) that the statement metadata was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The SQL statement text.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The SQL statement text.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>Either the number of rows returned from the SQL statement or the number of rows affected. If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.</p>
        pub fn result_rows(mut self, input: i64) -> Self {
            self.result_rows = Some(input);
            self
        }
        /// <p>Either the number of rows returned from the SQL statement or the number of rows affected. If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.</p>
        pub fn set_result_rows(mut self, input: std::option::Option<i64>) -> Self {
            self.result_rows = input;
            self
        }
        /// <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
        pub fn result_size(mut self, input: i64) -> Self {
            self.result_size = Some(input);
            self
        }
        /// <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
        pub fn set_result_size(mut self, input: std::option::Option<i64>) -> Self {
            self.result_size = input;
            self
        }
        /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn redshift_query_id(mut self, input: i64) -> Self {
            self.redshift_query_id = Some(input);
            self
        }
        /// <p>The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn set_redshift_query_id(mut self, input: std::option::Option<i64>) -> Self {
            self.redshift_query_id = input;
            self
        }
        /// <p>A value that indicates whether the statement has a result set. The result set can be empty. The value is true for an empty result set.</p>
        pub fn has_result_set(mut self, input: bool) -> Self {
            self.has_result_set = Some(input);
            self
        }
        /// <p>A value that indicates whether the statement has a result set. The result set can be empty. The value is true for an empty result set.</p>
        pub fn set_has_result_set(mut self, input: std::option::Option<bool>) -> Self {
            self.has_result_set = input;
            self
        }
        /// Consumes the builder and constructs a [`SubStatementData`](crate::model::SubStatementData)
        pub fn build(self) -> crate::model::SubStatementData {
            crate::model::SubStatementData {
                id: self.id,
                duration: self.duration.unwrap_or_default(),
                error: self.error,
                status: self.status,
                created_at: self.created_at,
                updated_at: self.updated_at,
                query_string: self.query_string,
                result_rows: self.result_rows.unwrap_or_default(),
                result_size: self.result_size.unwrap_or_default(),
                redshift_query_id: self.redshift_query_id.unwrap_or_default(),
                has_result_set: self.has_result_set,
            }
        }
    }
}
impl SubStatementData {
    /// Creates a new builder-style object to manufacture [`SubStatementData`](crate::model::SubStatementData)
    pub fn builder() -> crate::model::sub_statement_data::Builder {
        crate::model::sub_statement_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatementStatusString {
    #[allow(missing_docs)] // documentation missing in model
    Aborted,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Finished,
    #[allow(missing_docs)] // documentation missing in model
    Picked,
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatementStatusString {
    fn from(s: &str) -> Self {
        match s {
            "ABORTED" => StatementStatusString::Aborted,
            "FAILED" => StatementStatusString::Failed,
            "FINISHED" => StatementStatusString::Finished,
            "PICKED" => StatementStatusString::Picked,
            "STARTED" => StatementStatusString::Started,
            "SUBMITTED" => StatementStatusString::Submitted,
            other => StatementStatusString::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatementStatusString {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatementStatusString::from(s))
    }
}
impl StatementStatusString {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatementStatusString::Aborted => "ABORTED",
            StatementStatusString::Failed => "FAILED",
            StatementStatusString::Finished => "FINISHED",
            StatementStatusString::Picked => "PICKED",
            StatementStatusString::Started => "STARTED",
            StatementStatusString::Submitted => "SUBMITTED",
            StatementStatusString::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ABORTED",
            "FAILED",
            "FINISHED",
            "PICKED",
            "STARTED",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for StatementStatusString {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
