// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
pub mod batch_execute_statement_input {
    /// A builder for [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sqls: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) with_event: std::option::Option<bool>,
        pub(crate) statement_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sqls`.
        ///
        /// To override the contents of this collection use [`set_sqls`](Self::set_sqls).
        ///
        /// <p>One or more SQL statements to run. </p>
        pub fn sqls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sqls.unwrap_or_default();
            v.push(input.into());
            self.sqls = Some(v);
            self
        }
        /// <p>One or more SQL statements to run. </p>
        pub fn set_sqls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sqls = input;
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. </p>
        pub fn with_event(mut self, input: bool) -> Self {
            self.with_event = Some(input);
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. </p>
        pub fn set_with_event(mut self, input: std::option::Option<bool>) -> Self {
            self.with_event = input;
            self
        }
        /// <p>The name of the SQL statements. You can name the SQL statements when you create them to identify the query. </p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the SQL statements. You can name the SQL statements when you create them to identify the query. </p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchExecuteStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchExecuteStatementInput {
                sqls: self.sqls,
                cluster_identifier: self.cluster_identifier,
                secret_arn: self.secret_arn,
                db_user: self.db_user,
                database: self.database,
                with_event: self.with_event,
                statement_name: self.statement_name,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchExecuteStatementInputOperationOutputAlias = crate::operation::BatchExecuteStatement;
#[doc(hidden)]
pub type BatchExecuteStatementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchExecuteStatementInput {
    /// Consumes the builder and constructs an Operation<[`BatchExecuteStatement`](crate::operation::BatchExecuteStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchExecuteStatement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchExecuteStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchExecuteStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchExecuteStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.BatchExecuteStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_execute_statement(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchExecuteStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchExecuteStatement",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
    pub fn builder() -> crate::input::batch_execute_statement_input::Builder {
        crate::input::batch_execute_statement_input::Builder::default()
    }
}

/// See [`CancelStatementInput`](crate::input::CancelStatementInput)
pub mod cancel_statement_input {
    /// A builder for [`CancelStatementInput`](crate::input::CancelStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelStatementInput`](crate::input::CancelStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelStatementInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type CancelStatementInputOperationOutputAlias = crate::operation::CancelStatement;
#[doc(hidden)]
pub type CancelStatementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelStatementInput {
    /// Consumes the builder and constructs an Operation<[`CancelStatement`](crate::operation::CancelStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelStatement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.CancelStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_statement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelStatement",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelStatementInput`](crate::input::CancelStatementInput)
    pub fn builder() -> crate::input::cancel_statement_input::Builder {
        crate::input::cancel_statement_input::Builder::default()
    }
}

/// See [`DescribeStatementInput`](crate::input::DescribeStatementInput)
pub mod describe_statement_input {
    /// A builder for [`DescribeStatementInput`](crate::input::DescribeStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatement</code>, and <code>ListStatements</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatement</code>, and <code>ListStatements</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStatementInput`](crate::input::DescribeStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStatementInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DescribeStatementInputOperationOutputAlias = crate::operation::DescribeStatement;
#[doc(hidden)]
pub type DescribeStatementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeStatementInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStatement`](crate::operation::DescribeStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStatement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.DescribeStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_statement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStatement",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStatementInput`](crate::input::DescribeStatementInput)
    pub fn builder() -> crate::input::describe_statement_input::Builder {
        crate::input::describe_statement_input::Builder::default()
    }
}

/// See [`DescribeTableInput`](crate::input::DescribeTableInput)
pub mod describe_table_input {
    /// A builder for [`DescribeTableInput`](crate::input::DescribeTableInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) connected_database: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) table: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database that contains the tables to be described. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database that contains the tables to be described. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn connected_database(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_database = Some(input.into());
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn set_connected_database(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_database = input;
            self
        }
        /// <p>The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. </p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. </p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned</p>
        pub fn table(mut self, input: impl Into<std::string::String>) -> Self {
            self.table = Some(input.into());
            self
        }
        /// <p>The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned</p>
        pub fn set_table(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableInput`](crate::input::DescribeTableInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTableInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTableInput {
                cluster_identifier: self.cluster_identifier,
                secret_arn: self.secret_arn,
                db_user: self.db_user,
                database: self.database,
                connected_database: self.connected_database,
                schema: self.schema,
                table: self.table,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTableInputOperationOutputAlias = crate::operation::DescribeTable;
#[doc(hidden)]
pub type DescribeTableInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTableInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTable`](crate::operation::DescribeTable)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTable,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTableInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTableInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTableInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.DescribeTable",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_table(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTable::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTable",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTableInput`](crate::input::DescribeTableInput)
    pub fn builder() -> crate::input::describe_table_input::Builder {
        crate::input::describe_table_input::Builder::default()
    }
}

/// See [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
pub mod execute_statement_input {
    /// A builder for [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sql: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) with_event: std::option::Option<bool>,
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
    }
    impl Builder {
        /// <p>The SQL statement text to run. </p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql = Some(input.into());
            self
        }
        /// <p>The SQL statement text to run. </p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql = input;
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. </p>
        pub fn with_event(mut self, input: bool) -> Self {
            self.with_event = Some(input);
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. </p>
        pub fn set_with_event(mut self, input: std::option::Option<bool>) -> Self {
            self.with_event = input;
            self
        }
        /// <p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query. </p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query. </p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the SQL statement.</p>
        pub fn parameters(mut self, input: crate::model::SqlParameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>The parameters for the SQL statement.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteStatementInput {
                sql: self.sql,
                cluster_identifier: self.cluster_identifier,
                secret_arn: self.secret_arn,
                db_user: self.db_user,
                database: self.database,
                with_event: self.with_event,
                statement_name: self.statement_name,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteStatementInputOperationOutputAlias = crate::operation::ExecuteStatement;
#[doc(hidden)]
pub type ExecuteStatementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExecuteStatementInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteStatement`](crate::operation::ExecuteStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteStatement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.ExecuteStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_execute_statement(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteStatement",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
    pub fn builder() -> crate::input::execute_statement_input::Builder {
        crate::input::execute_statement_input::Builder::default()
    }
}

/// See [`GetStatementResultInput`](crate::input::GetStatementResultInput)
pub mod get_statement_result_input {
    /// A builder for [`GetStatementResultInput`](crate::input::GetStatementResultInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStatementResultInput`](crate::input::GetStatementResultInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStatementResultInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStatementResultInput {
                id: self.id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStatementResultInputOperationOutputAlias = crate::operation::GetStatementResult;
#[doc(hidden)]
pub type GetStatementResultInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStatementResultInput {
    /// Consumes the builder and constructs an Operation<[`GetStatementResult`](crate::operation::GetStatementResult)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStatementResult,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetStatementResultInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetStatementResultInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetStatementResultInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.GetStatementResult",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_statement_result(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStatementResult::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStatementResult",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetStatementResultInput`](crate::input::GetStatementResultInput)
    pub fn builder() -> crate::input::get_statement_result_input::Builder {
        crate::input::get_statement_result_input::Builder::default()
    }
}

/// See [`ListDatabasesInput`](crate::input::ListDatabasesInput)
pub mod list_databases_input {
    /// A builder for [`ListDatabasesInput`](crate::input::ListDatabasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of databases to return in the response. If more databases exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of databases to return in the response. If more databases exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatabasesInput`](crate::input::ListDatabasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatabasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatabasesInput {
                cluster_identifier: self.cluster_identifier,
                database: self.database,
                secret_arn: self.secret_arn,
                db_user: self.db_user,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatabasesInputOperationOutputAlias = crate::operation::ListDatabases;
#[doc(hidden)]
pub type ListDatabasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDatabasesInput {
    /// Consumes the builder and constructs an Operation<[`ListDatabases`](crate::operation::ListDatabases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatabases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatabasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatabasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatabasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.ListDatabases",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_databases(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatabases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatabases",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatabasesInput`](crate::input::ListDatabasesInput)
    pub fn builder() -> crate::input::list_databases_input::Builder {
        crate::input::list_databases_input::Builder::default()
    }
}

/// See [`ListSchemasInput`](crate::input::ListSchemasInput)
pub mod list_schemas_input {
    /// A builder for [`ListSchemasInput`](crate::input::ListSchemasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) connected_database: std::option::Option<std::string::String>,
        pub(crate) schema_pattern: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database that contains the schemas to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database that contains the schemas to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn connected_database(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_database = Some(input.into());
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn set_connected_database(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_database = input;
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. </p>
        pub fn schema_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_pattern = Some(input.into());
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. </p>
        pub fn set_schema_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_pattern = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemasInput`](crate::input::ListSchemasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSchemasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSchemasInput {
                cluster_identifier: self.cluster_identifier,
                secret_arn: self.secret_arn,
                db_user: self.db_user,
                database: self.database,
                connected_database: self.connected_database,
                schema_pattern: self.schema_pattern,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListSchemasInputOperationOutputAlias = crate::operation::ListSchemas;
#[doc(hidden)]
pub type ListSchemasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSchemasInput {
    /// Consumes the builder and constructs an Operation<[`ListSchemas`](crate::operation::ListSchemas)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSchemas,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSchemasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSchemasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSchemasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.ListSchemas",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_schemas(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSchemas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSchemas",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSchemasInput`](crate::input::ListSchemasInput)
    pub fn builder() -> crate::input::list_schemas_input::Builder {
        crate::input::list_schemas_input::Builder::default()
    }
}

/// See [`ListStatementsInput`](crate::input::ListStatementsInput)
pub mod list_statements_input {
    /// A builder for [`ListStatementsInput`](crate::input::ListStatementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusString>,
        pub(crate) role_level: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. </p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. </p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The status of the SQL statement to list. Status values are defined as follows: </p>
        /// <ul>
        /// <li> <p>ABORTED - The query run was stopped by the user. </p> </li>
        /// <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>
        /// <li> <p>FAILED - The query run failed. </p> </li>
        /// <li> <p>FINISHED - The query has finished running. </p> </li>
        /// <li> <p>PICKED - The query has been chosen to be run. </p> </li>
        /// <li> <p>STARTED - The query run has started. </p> </li>
        /// <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StatusString) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SQL statement to list. Status values are defined as follows: </p>
        /// <ul>
        /// <li> <p>ABORTED - The query run was stopped by the user. </p> </li>
        /// <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>
        /// <li> <p>FAILED - The query run failed. </p> </li>
        /// <li> <p>FINISHED - The query has finished running. </p> </li>
        /// <li> <p>PICKED - The query has been chosen to be run. </p> </li>
        /// <li> <p>STARTED - The query run has started. </p> </li>
        /// <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusString>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. </p>
        pub fn role_level(mut self, input: bool) -> Self {
            self.role_level = Some(input);
            self
        }
        /// <p>A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. </p>
        pub fn set_role_level(mut self, input: std::option::Option<bool>) -> Self {
            self.role_level = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStatementsInput`](crate::input::ListStatementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStatementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStatementsInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
                statement_name: self.statement_name,
                status: self.status,
                role_level: self.role_level,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStatementsInputOperationOutputAlias = crate::operation::ListStatements;
#[doc(hidden)]
pub type ListStatementsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListStatementsInput {
    /// Consumes the builder and constructs an Operation<[`ListStatements`](crate::operation::ListStatements)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStatements,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStatementsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStatementsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStatementsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.ListStatements",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_statements(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStatements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStatements",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStatementsInput`](crate::input::ListStatementsInput)
    pub fn builder() -> crate::input::list_statements_input::Builder {
        crate::input::list_statements_input::Builder::default()
    }
}

/// See [`ListTablesInput`](crate::input::ListTablesInput)
pub mod list_tables_input {
    /// A builder for [`ListTablesInput`](crate::input::ListTablesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) connected_database: std::option::Option<std::string::String>,
        pub(crate) schema_pattern: std::option::Option<std::string::String>,
        pub(crate) table_pattern: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn connected_database(mut self, input: impl Into<std::string::String>) -> Self {
            self.connected_database = Some(input.into());
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn set_connected_database(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connected_database = input;
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn schema_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_pattern = Some(input.into());
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn set_schema_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_pattern = input;
            self
        }
        /// <p>A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn table_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_pattern = Some(input.into());
            self
        }
        /// <p>A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn set_table_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_pattern = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesInput`](crate::input::ListTablesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTablesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTablesInput {
                cluster_identifier: self.cluster_identifier,
                secret_arn: self.secret_arn,
                db_user: self.db_user,
                database: self.database,
                connected_database: self.connected_database,
                schema_pattern: self.schema_pattern,
                table_pattern: self.table_pattern,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListTablesInputOperationOutputAlias = crate::operation::ListTables;
#[doc(hidden)]
pub type ListTablesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTablesInput {
    /// Consumes the builder and constructs an Operation<[`ListTables`](crate::operation::ListTables)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTables,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTablesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTablesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTablesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "RedshiftData.ListTables",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tables(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTables::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTables",
            "redshiftdata",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTablesInput`](crate::input::ListTablesInput)
    pub fn builder() -> crate::input::list_tables_input::Builder {
        crate::input::list_tables_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    pub connected_database: std::option::Option<std::string::String>,
    /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
    pub schema_pattern: std::option::Option<std::string::String>,
    /// <p>A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
    pub table_pattern: std::option::Option<std::string::String>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub max_results: i32,
}
impl ListTablesInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    pub fn connected_database(&self) -> std::option::Option<&str> {
        self.connected_database.as_deref()
    }
    /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
    pub fn schema_pattern(&self) -> std::option::Option<&str> {
        self.schema_pattern.as_deref()
    }
    /// <p>A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
    pub fn table_pattern(&self) -> std::option::Option<&str> {
        self.table_pattern.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListTablesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesInput");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("connected_database", &self.connected_database);
        formatter.field("schema_pattern", &self.schema_pattern);
        formatter.field("table_pattern", &self.table_pattern);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStatementsInput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub max_results: i32,
    /// <p>The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. </p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The status of the SQL statement to list. Status values are defined as follows: </p>
    /// <ul>
    /// <li> <p>ABORTED - The query run was stopped by the user. </p> </li>
    /// <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>
    /// <li> <p>FAILED - The query run failed. </p> </li>
    /// <li> <p>FINISHED - The query has finished running. </p> </li>
    /// <li> <p>PICKED - The query has been chosen to be run. </p> </li>
    /// <li> <p>STARTED - The query run has started. </p> </li>
    /// <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StatusString>,
    /// <p>A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. </p>
    pub role_level: std::option::Option<bool>,
}
impl ListStatementsInput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. </p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
    /// <p>The status of the SQL statement to list. Status values are defined as follows: </p>
    /// <ul>
    /// <li> <p>ABORTED - The query run was stopped by the user. </p> </li>
    /// <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>
    /// <li> <p>FAILED - The query run failed. </p> </li>
    /// <li> <p>FINISHED - The query has finished running. </p> </li>
    /// <li> <p>PICKED - The query has been chosen to be run. </p> </li>
    /// <li> <p>STARTED - The query run has started. </p> </li>
    /// <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusString> {
        self.status.as_ref()
    }
    /// <p>A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. </p>
    pub fn role_level(&self) -> std::option::Option<bool> {
        self.role_level
    }
}
impl std::fmt::Debug for ListStatementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStatementsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("statement_name", &self.statement_name);
        formatter.field("status", &self.status);
        formatter.field("role_level", &self.role_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemasInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database that contains the schemas to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    pub connected_database: std::option::Option<std::string::String>,
    /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. </p>
    pub schema_pattern: std::option::Option<std::string::String>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub max_results: i32,
}
impl ListSchemasInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>The name of the database that contains the schemas to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    pub fn connected_database(&self) -> std::option::Option<&str> {
        self.connected_database.as_deref()
    }
    /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. </p>
    pub fn schema_pattern(&self) -> std::option::Option<&str> {
        self.schema_pattern.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListSchemasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemasInput");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("connected_database", &self.connected_database);
        formatter.field("schema_pattern", &self.schema_pattern);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatabasesInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of databases to return in the response. If more databases exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub max_results: i32,
}
impl ListDatabasesInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of databases to return in the response. If more databases exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListDatabasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatabasesInput");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("database", &self.database);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStatementResultInput {
    /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetStatementResultInput {
    /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetStatementResultInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStatementResultInput");
        formatter.field("id", &self.id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementInput {
    /// <p>The SQL statement text to run. </p>
    pub sql: std::option::Option<std::string::String>,
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    pub database: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. </p>
    pub with_event: std::option::Option<bool>,
    /// <p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query. </p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The parameters for the SQL statement.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
}
impl ExecuteStatementInput {
    /// <p>The SQL statement text to run. </p>
    pub fn sql(&self) -> std::option::Option<&str> {
        self.sql.as_deref()
    }
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. </p>
    pub fn with_event(&self) -> std::option::Option<bool> {
        self.with_event
    }
    /// <p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query. </p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
    /// <p>The parameters for the SQL statement.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::SqlParameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for ExecuteStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementInput");
        formatter.field("sql", &self.sql);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("with_event", &self.with_event);
        formatter.field("statement_name", &self.statement_name);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database that contains the tables to be described. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    pub connected_database: std::option::Option<std::string::String>,
    /// <p>The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. </p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned</p>
    pub table: std::option::Option<std::string::String>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub max_results: i32,
}
impl DescribeTableInput {
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>The name of the database that contains the tables to be described. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    pub fn connected_database(&self) -> std::option::Option<&str> {
        self.connected_database.as_deref()
    }
    /// <p>The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. </p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned</p>
    pub fn table(&self) -> std::option::Option<&str> {
        self.table.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeTableInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableInput");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("connected_database", &self.connected_database);
        formatter.field("schema", &self.schema);
        formatter.field("table", &self.table);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStatementInput {
    /// <p>The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatement</code>, and <code>ListStatements</code>. </p>
    pub id: std::option::Option<std::string::String>,
}
impl DescribeStatementInput {
    /// <p>The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatement</code>, and <code>ListStatements</code>. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DescribeStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStatementInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelStatementInput {
    /// <p>The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
    pub id: std::option::Option<std::string::String>,
}
impl CancelStatementInput {
    /// <p>The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for CancelStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelStatementInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchExecuteStatementInput {
    /// <p>One or more SQL statements to run. </p>
    pub sqls: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    pub database: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. </p>
    pub with_event: std::option::Option<bool>,
    /// <p>The name of the SQL statements. You can name the SQL statements when you create them to identify the query. </p>
    pub statement_name: std::option::Option<std::string::String>,
}
impl BatchExecuteStatementInput {
    /// <p>One or more SQL statements to run. </p>
    pub fn sqls(&self) -> std::option::Option<&[std::string::String]> {
        self.sqls.as_deref()
    }
    /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. </p>
    pub fn with_event(&self) -> std::option::Option<bool> {
        self.with_event
    }
    /// <p>The name of the SQL statements. You can name the SQL statements when you create them to identify the query. </p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
}
impl std::fmt::Debug for BatchExecuteStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchExecuteStatementInput");
        formatter.field("sqls", &self.sqls);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("with_event", &self.with_event);
        formatter.field("statement_name", &self.statement_name);
        formatter.finish()
    }
}
