// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Redshift Data API Service
///
/// Client for invoking operations on Redshift Data API Service. Each operation on Redshift Data API Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_redshiftdata::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_redshiftdata::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_redshiftdata::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`BatchExecuteStatement`](crate::client::fluent_builders::BatchExecuteStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sqls(Vec<String>)`](crate::client::fluent_builders::BatchExecuteStatement::sqls) / [`set_sqls(Option<Vec<String>>)`](crate::client::fluent_builders::BatchExecuteStatement::set_sqls): <p>One or more SQL statements to run. </p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_cluster_identifier): <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_secret_arn): <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    ///   - [`db_user(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::db_user) / [`set_db_user(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_db_user): <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_database): <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`with_event(bool)`](crate::client::fluent_builders::BatchExecuteStatement::with_event) / [`set_with_event(Option<bool>)`](crate::client::fluent_builders::BatchExecuteStatement::set_with_event): <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. </p>
    ///   - [`statement_name(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::statement_name) / [`set_statement_name(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_statement_name): <p>The name of the SQL statements. You can name the SQL statements when you create them to identify the query. </p>
    /// - On success, responds with [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::BatchExecuteStatementOutput::id): <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>. </p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::BatchExecuteStatementOutput::created_at): <p>The date and time (UTC) the statement was created. </p>
    ///   - [`cluster_identifier(Option<String>)`](crate::output::BatchExecuteStatementOutput::cluster_identifier): <p>The cluster identifier. This parameter is not returned when connecting to a serverless endpoint. </p>
    ///   - [`db_user(Option<String>)`](crate::output::BatchExecuteStatementOutput::db_user): <p>The database user name.</p>
    ///   - [`database(Option<String>)`](crate::output::BatchExecuteStatementOutput::database): <p>The name of the database.</p>
    ///   - [`secret_arn(Option<String>)`](crate::output::BatchExecuteStatementOutput::secret_arn): <p>The name or ARN of the secret that enables access to the database. </p>
    /// - On failure, responds with [`SdkError<BatchExecuteStatementError>`](crate::error::BatchExecuteStatementError)
    pub fn batch_execute_statement(&self) -> fluent_builders::BatchExecuteStatement<C, M, R> {
        fluent_builders::BatchExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelStatement`](crate::client::fluent_builders::CancelStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::CancelStatement::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::CancelStatement::set_id): <p>The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
    /// - On success, responds with [`CancelStatementOutput`](crate::output::CancelStatementOutput) with field(s):
    ///   - [`status(Option<bool>)`](crate::output::CancelStatementOutput::status): <p>A value that indicates whether the cancel statement succeeded (true). </p>
    /// - On failure, responds with [`SdkError<CancelStatementError>`](crate::error::CancelStatementError)
    pub fn cancel_statement(&self) -> fluent_builders::CancelStatement<C, M, R> {
        fluent_builders::CancelStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStatement`](crate::client::fluent_builders::DescribeStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DescribeStatement::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DescribeStatement::set_id): <p>The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatement</code>, and <code>ListStatements</code>. </p>
    /// - On success, responds with [`DescribeStatementOutput`](crate::output::DescribeStatementOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::DescribeStatementOutput::id): <p>The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    ///   - [`secret_arn(Option<String>)`](crate::output::DescribeStatementOutput::secret_arn): <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
    ///   - [`db_user(Option<String>)`](crate::output::DescribeStatementOutput::db_user): <p>The database user name. </p>
    ///   - [`database(Option<String>)`](crate::output::DescribeStatementOutput::database): <p>The name of the database. </p>
    ///   - [`cluster_identifier(Option<String>)`](crate::output::DescribeStatementOutput::cluster_identifier): <p>The cluster identifier. </p>
    ///   - [`duration(i64)`](crate::output::DescribeStatementOutput::duration): <p>The amount of time in nanoseconds that the statement ran. </p>
    ///   - [`error(Option<String>)`](crate::output::DescribeStatementOutput::error): <p>The error message from the cluster if the SQL statement encountered an error while running. </p>
    ///   - [`status(Option<StatusString>)`](crate::output::DescribeStatementOutput::status): <p>The status of the SQL statement being described. Status values are defined as follows: </p>  <ul>   <li> <p>ABORTED - The query run was stopped by the user. </p> </li>   <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>   <li> <p>FAILED - The query run failed. </p> </li>   <li> <p>FINISHED - The query has finished running. </p> </li>   <li> <p>PICKED - The query has been chosen to be run. </p> </li>   <li> <p>STARTED - The query run has started. </p> </li>   <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>  </ul>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DescribeStatementOutput::created_at): <p>The date and time (UTC) when the SQL statement was submitted to run. </p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::DescribeStatementOutput::updated_at): <p>The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the status last changed. </p>
    ///   - [`redshift_pid(i64)`](crate::output::DescribeStatementOutput::redshift_pid): <p>The process identifier from Amazon Redshift. </p>
    ///   - [`has_result_set(Option<bool>)`](crate::output::DescribeStatementOutput::has_result_set): <p>A value that indicates whether the statement has a result set. The result set can be empty. The value is true for an empty result set. The value is true if any substatement returns a result set.</p>
    ///   - [`query_string(Option<String>)`](crate::output::DescribeStatementOutput::query_string): <p>The SQL statement text. </p>
    ///   - [`result_rows(i64)`](crate::output::DescribeStatementOutput::result_rows): <p>Either the number of rows returned from the SQL statement or the number of rows affected. If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.</p>
    ///   - [`result_size(i64)`](crate::output::DescribeStatementOutput::result_size): <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
    ///   - [`redshift_query_id(i64)`](crate::output::DescribeStatementOutput::redshift_query_id): <p>The identifier of the query generated by Amazon Redshift. These identifiers are also available in the <code>query</code> column of the <code>STL_QUERY</code> system view. </p>
    ///   - [`query_parameters(Option<Vec<SqlParameter>>)`](crate::output::DescribeStatementOutput::query_parameters): <p>The parameters for the SQL statement.</p>
    ///   - [`sub_statements(Option<Vec<SubStatementData>>)`](crate::output::DescribeStatementOutput::sub_statements): <p>The SQL statements from a multiple statement run.</p>
    /// - On failure, responds with [`SdkError<DescribeStatementError>`](crate::error::DescribeStatementError)
    pub fn describe_statement(&self) -> fluent_builders::DescribeStatement<C, M, R> {
        fluent_builders::DescribeStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTable`](crate::client::fluent_builders::DescribeTable) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTable::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_cluster_identifier): <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_secret_arn): <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    ///   - [`db_user(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::db_user) / [`set_db_user(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_db_user): <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_database): <p>The name of the database that contains the tables to be described. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    ///   - [`connected_database(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::connected_database) / [`set_connected_database(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_connected_database): <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_schema): <p>The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. </p>
    ///   - [`table(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::table) / [`set_table(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_table): <p>The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTable::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTable::set_next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTable::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeTable::set_max_results): <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    /// - On success, responds with [`DescribeTableOutput`](crate::output::DescribeTableOutput) with field(s):
    ///   - [`table_name(Option<String>)`](crate::output::DescribeTableOutput::table_name): <p>The table name. </p>
    ///   - [`column_list(Option<Vec<ColumnMetadata>>)`](crate::output::DescribeTableOutput::column_list): <p>A list of columns in the table. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTableOutput::next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<DescribeTableError>`](crate::error::DescribeTableError)
    pub fn describe_table(&self) -> fluent_builders::DescribeTable<C, M, R> {
        fluent_builders::DescribeTable::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteStatement`](crate::client::fluent_builders::ExecuteStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sql(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::sql) / [`set_sql(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_sql): <p>The SQL statement text to run. </p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_cluster_identifier): <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_secret_arn): <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    ///   - [`db_user(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::db_user) / [`set_db_user(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_db_user): <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_database): <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`with_event(bool)`](crate::client::fluent_builders::ExecuteStatement::with_event) / [`set_with_event(Option<bool>)`](crate::client::fluent_builders::ExecuteStatement::set_with_event): <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. </p>
    ///   - [`statement_name(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::statement_name) / [`set_statement_name(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_statement_name): <p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query. </p>
    ///   - [`parameters(Vec<SqlParameter>)`](crate::client::fluent_builders::ExecuteStatement::parameters) / [`set_parameters(Option<Vec<SqlParameter>>)`](crate::client::fluent_builders::ExecuteStatement::set_parameters): <p>The parameters for the SQL statement.</p>
    /// - On success, responds with [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::ExecuteStatementOutput::id): <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::ExecuteStatementOutput::created_at): <p>The date and time (UTC) the statement was created. </p>
    ///   - [`cluster_identifier(Option<String>)`](crate::output::ExecuteStatementOutput::cluster_identifier): <p>The cluster identifier. This parameter is not returned when connecting to a serverless endpoint. </p>
    ///   - [`db_user(Option<String>)`](crate::output::ExecuteStatementOutput::db_user): <p>The database user name.</p>
    ///   - [`database(Option<String>)`](crate::output::ExecuteStatementOutput::database): <p>The name of the database.</p>
    ///   - [`secret_arn(Option<String>)`](crate::output::ExecuteStatementOutput::secret_arn): <p>The name or ARN of the secret that enables access to the database. </p>
    /// - On failure, responds with [`SdkError<ExecuteStatementError>`](crate::error::ExecuteStatementError)
    pub fn execute_statement(&self) -> fluent_builders::ExecuteStatement<C, M, R> {
        fluent_builders::ExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStatementResult`](crate::client::fluent_builders::GetStatementResult) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetStatementResult::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetStatementResult::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetStatementResult::set_id): <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetStatementResult::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetStatementResult::set_next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    /// - On success, responds with [`GetStatementResultOutput`](crate::output::GetStatementResultOutput) with field(s):
    ///   - [`records(Option<Vec<Vec<Field>>>)`](crate::output::GetStatementResultOutput::records): <p>The results of the SQL statement.</p>
    ///   - [`column_metadata(Option<Vec<ColumnMetadata>>)`](crate::output::GetStatementResultOutput::column_metadata): <p>The properties (metadata) of a column. </p>
    ///   - [`total_num_rows(i64)`](crate::output::GetStatementResultOutput::total_num_rows): <p>The total number of rows in the result set returned from a query. You can use this number to estimate the number of calls to the <code>GetStatementResult</code> operation needed to page through the results. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetStatementResultOutput::next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<GetStatementResultError>`](crate::error::GetStatementResultError)
    pub fn get_statement_result(&self) -> fluent_builders::GetStatementResult<C, M, R> {
        fluent_builders::GetStatementResult::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatabases`](crate::client::fluent_builders::ListDatabases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatabases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ListDatabases::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ListDatabases::set_cluster_identifier): <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::ListDatabases::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::ListDatabases::set_database): <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::ListDatabases::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::ListDatabases::set_secret_arn): <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    ///   - [`db_user(impl Into<String>)`](crate::client::fluent_builders::ListDatabases::db_user) / [`set_db_user(Option<String>)`](crate::client::fluent_builders::ListDatabases::set_db_user): <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatabases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatabases::set_next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatabases::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDatabases::set_max_results): <p>The maximum number of databases to return in the response. If more databases exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    /// - On success, responds with [`ListDatabasesOutput`](crate::output::ListDatabasesOutput) with field(s):
    ///   - [`databases(Option<Vec<String>>)`](crate::output::ListDatabasesOutput::databases): <p>The names of databases. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatabasesOutput::next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<ListDatabasesError>`](crate::error::ListDatabasesError)
    pub fn list_databases(&self) -> fluent_builders::ListDatabases<C, M, R> {
        fluent_builders::ListDatabases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSchemas`](crate::client::fluent_builders::ListSchemas) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSchemas::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ListSchemas::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ListSchemas::set_cluster_identifier): <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::ListSchemas::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::ListSchemas::set_secret_arn): <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    ///   - [`db_user(impl Into<String>)`](crate::client::fluent_builders::ListSchemas::db_user) / [`set_db_user(Option<String>)`](crate::client::fluent_builders::ListSchemas::set_db_user): <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::ListSchemas::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::ListSchemas::set_database): <p>The name of the database that contains the schemas to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    ///   - [`connected_database(impl Into<String>)`](crate::client::fluent_builders::ListSchemas::connected_database) / [`set_connected_database(Option<String>)`](crate::client::fluent_builders::ListSchemas::set_connected_database): <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    ///   - [`schema_pattern(impl Into<String>)`](crate::client::fluent_builders::ListSchemas::schema_pattern) / [`set_schema_pattern(Option<String>)`](crate::client::fluent_builders::ListSchemas::set_schema_pattern): <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSchemas::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSchemas::set_next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSchemas::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListSchemas::set_max_results): <p>The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    /// - On success, responds with [`ListSchemasOutput`](crate::output::ListSchemasOutput) with field(s):
    ///   - [`schemas(Option<Vec<String>>)`](crate::output::ListSchemasOutput::schemas): <p>The schemas that match the request pattern. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSchemasOutput::next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<ListSchemasError>`](crate::error::ListSchemasError)
    pub fn list_schemas(&self) -> fluent_builders::ListSchemas<C, M, R> {
        fluent_builders::ListSchemas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStatements`](crate::client::fluent_builders::ListStatements) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStatements::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStatements::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStatements::set_next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListStatements::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListStatements::set_max_results): <p>The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    ///   - [`statement_name(impl Into<String>)`](crate::client::fluent_builders::ListStatements::statement_name) / [`set_statement_name(Option<String>)`](crate::client::fluent_builders::ListStatements::set_statement_name): <p>The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. </p>
    ///   - [`status(StatusString)`](crate::client::fluent_builders::ListStatements::status) / [`set_status(Option<StatusString>)`](crate::client::fluent_builders::ListStatements::set_status): <p>The status of the SQL statement to list. Status values are defined as follows: </p>  <ul>   <li> <p>ABORTED - The query run was stopped by the user. </p> </li>   <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>   <li> <p>FAILED - The query run failed. </p> </li>   <li> <p>FINISHED - The query has finished running. </p> </li>   <li> <p>PICKED - The query has been chosen to be run. </p> </li>   <li> <p>STARTED - The query run has started. </p> </li>   <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>  </ul>
    ///   - [`role_level(bool)`](crate::client::fluent_builders::ListStatements::role_level) / [`set_role_level(Option<bool>)`](crate::client::fluent_builders::ListStatements::set_role_level): <p>A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. </p>
    /// - On success, responds with [`ListStatementsOutput`](crate::output::ListStatementsOutput) with field(s):
    ///   - [`statements(Option<Vec<StatementData>>)`](crate::output::ListStatementsOutput::statements): <p>The SQL statements. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListStatementsOutput::next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<ListStatementsError>`](crate::error::ListStatementsError)
    pub fn list_statements(&self) -> fluent_builders::ListStatements<C, M, R> {
        fluent_builders::ListStatements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTables`](crate::client::fluent_builders::ListTables) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTables::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ListTables::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ListTables::set_cluster_identifier): <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::ListTables::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::ListTables::set_secret_arn): <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
    ///   - [`db_user(impl Into<String>)`](crate::client::fluent_builders::ListTables::db_user) / [`set_db_user(Option<String>)`](crate::client::fluent_builders::ListTables::set_db_user): <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::ListTables::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::ListTables::set_database): <p>The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
    ///   - [`connected_database(impl Into<String>)`](crate::client::fluent_builders::ListTables::connected_database) / [`set_connected_database(Option<String>)`](crate::client::fluent_builders::ListTables::set_connected_database): <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
    ///   - [`schema_pattern(impl Into<String>)`](crate::client::fluent_builders::ListTables::schema_pattern) / [`set_schema_pattern(Option<String>)`](crate::client::fluent_builders::ListTables::set_schema_pattern): <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
    ///   - [`table_pattern(impl Into<String>)`](crate::client::fluent_builders::ListTables::table_pattern) / [`set_table_pattern(Option<String>)`](crate::client::fluent_builders::ListTables::set_table_pattern): <p>A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTables::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTables::set_next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTables::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListTables::set_max_results): <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
    /// - On success, responds with [`ListTablesOutput`](crate::output::ListTablesOutput) with field(s):
    ///   - [`tables(Option<Vec<TableMember>>)`](crate::output::ListTablesOutput::tables): <p>The tables that match the request pattern. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTablesOutput::next_token): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<ListTablesError>`](crate::error::ListTablesError)
    pub fn list_tables(&self) -> fluent_builders::ListTables<C, M, R> {
        fluent_builders::ListTables::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchExecuteStatement`.
    ///
    /// <p>Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL). Depending on the authorization method, use one of the following combinations of request parameters: </p>
    /// <ul>
    /// <li> <p>Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless endpoint, specify the Amazon Resource Name (ARN) of the secret and the database name. </p> </li>
    /// <li> <p>Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is required. When connecting to a serverless endpoint, specify the database name. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchExecuteStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_execute_statement_input::Builder,
    }
    impl<C, M, R> BatchExecuteStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchExecuteStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchExecuteStatementInputOperationOutputAlias,
                crate::output::BatchExecuteStatementOutput,
                crate::error::BatchExecuteStatementError,
                crate::input::BatchExecuteStatementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Sqls`.
        ///
        /// To override the contents of this collection use [`set_sqls`](Self::set_sqls).
        ///
        /// <p>One or more SQL statements to run. </p>
        pub fn sqls(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sqls(input.into());
            self
        }
        /// <p>One or more SQL statements to run. </p>
        pub fn set_sqls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_sqls(input);
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. </p>
        pub fn with_event(mut self, input: bool) -> Self {
            self.inner = self.inner.with_event(input);
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. </p>
        pub fn set_with_event(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_event(input);
            self
        }
        /// <p>The name of the SQL statements. You can name the SQL statements when you create them to identify the query. </p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_name(input.into());
            self
        }
        /// <p>The name of the SQL statements. You can name the SQL statements when you create them to identify the query. </p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_statement_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelStatement`.
    ///
    /// <p>Cancels a running query. To be canceled, a query must be running. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_statement_input::Builder,
    }
    impl<C, M, R> CancelStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelStatementInputOperationOutputAlias,
                crate::output::CancelStatementOutput,
                crate::error::CancelStatementError,
                crate::input::CancelStatementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStatement`.
    ///
    /// <p>Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information includes when the query started, when it finished, the query status, the number of rows returned, and the SQL statement. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_statement_input::Builder,
    }
    impl<C, M, R> DescribeStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStatementInputOperationOutputAlias,
                crate::output::DescribeStatementOutput,
                crate::error::DescribeStatementError,
                crate::input::DescribeStatementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatement</code>, and <code>ListStatements</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatement</code>, and <code>ListStatements</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTable`.
    ///
    /// <p>Describes the detailed information about a table from metadata in the cluster. The information includes its columns. A token is returned to page through the column list. Depending on the authorization method, use one of the following combinations of request parameters: </p>
    /// <ul>
    /// <li> <p>Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless endpoint, specify the Amazon Resource Name (ARN) of the secret and the database name. </p> </li>
    /// <li> <p>Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is required. When connecting to a serverless endpoint, specify the database name. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTable<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_table_input::Builder,
    }
    impl<C, M, R> DescribeTable<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTable`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTableInputOperationOutputAlias,
                crate::output::DescribeTableOutput,
                crate::error::DescribeTableError,
                crate::input::DescribeTableInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTablePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTablePaginator<C, M, R> {
            crate::paginator::DescribeTablePaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>The name of the database that contains the tables to be described. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database that contains the tables to be described. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn connected_database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_database(input.into());
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn set_connected_database(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_database(input);
            self
        }
        /// <p>The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. </p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. </p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// <p>The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned</p>
        pub fn table(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table(input.into());
            self
        }
        /// <p>The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned</p>
        pub fn set_table(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteStatement`.
    ///
    /// <p>Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This statement must be a single SQL statement. Depending on the authorization method, use one of the following combinations of request parameters: </p>
    /// <ul>
    /// <li> <p>Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless endpoint, specify the Amazon Resource Name (ARN) of the secret and the database name. </p> </li>
    /// <li> <p>Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is required. When connecting to a serverless endpoint, specify the database name. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_statement_input::Builder,
    }
    impl<C, M, R> ExecuteStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteStatementInputOperationOutputAlias,
                crate::output::ExecuteStatementOutput,
                crate::error::ExecuteStatementError,
                crate::input::ExecuteStatementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The SQL statement text to run. </p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql(input.into());
            self
        }
        /// <p>The SQL statement text to run. </p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sql(input);
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. </p>
        pub fn with_event(mut self, input: bool) -> Self {
            self.inner = self.inner.with_event(input);
            self
        }
        /// <p>A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. </p>
        pub fn set_with_event(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_with_event(input);
            self
        }
        /// <p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query. </p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_name(input.into());
            self
        }
        /// <p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query. </p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_statement_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the SQL statement.</p>
        pub fn parameters(mut self, input: crate::model::SqlParameter) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>The parameters for the SQL statement.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStatementResult`.
    ///
    /// <p>Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement results. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStatementResult<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_statement_result_input::Builder,
    }
    impl<C, M, R> GetStatementResult<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStatementResult`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStatementResultOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStatementResultError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStatementResultInputOperationOutputAlias,
                crate::output::GetStatementResultOutput,
                crate::error::GetStatementResultError,
                crate::input::GetStatementResultInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetStatementResultPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetStatementResultPaginator<C, M, R> {
            crate::paginator::GetStatementResultPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL statement of a batch query. This identifier is returned by <code>BatchExecuteStatment</code>, <code>ExecuteStatment</code>, and <code>ListStatements</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatabases`.
    ///
    /// <p>List the databases in a cluster. A token is returned to page through the database list. Depending on the authorization method, use one of the following combinations of request parameters: </p>
    /// <ul>
    /// <li> <p>Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless endpoint, specify the Amazon Resource Name (ARN) of the secret and the database name. </p> </li>
    /// <li> <p>Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is required. When connecting to a serverless endpoint, specify the database name. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatabases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_databases_input::Builder,
    }
    impl<C, M, R> ListDatabases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatabases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatabasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatabasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatabasesInputOperationOutputAlias,
                crate::output::ListDatabasesOutput,
                crate::error::ListDatabasesError,
                crate::input::ListDatabasesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatabasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatabasesPaginator<C, M, R> {
            crate::paginator::ListDatabasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of databases to return in the response. If more databases exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of databases to return in the response. If more databases exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSchemas`.
    ///
    /// <p>Lists the schemas in a database. A token is returned to page through the schema list. Depending on the authorization method, use one of the following combinations of request parameters: </p>
    /// <ul>
    /// <li> <p>Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless endpoint, specify the Amazon Resource Name (ARN) of the secret and the database name. </p> </li>
    /// <li> <p>Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is required. When connecting to a serverless endpoint, specify the database name. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSchemas<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_schemas_input::Builder,
    }
    impl<C, M, R> ListSchemas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSchemas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSchemasOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSchemasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSchemasInputOperationOutputAlias,
                crate::output::ListSchemasOutput,
                crate::error::ListSchemasError,
                crate::input::ListSchemasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSchemasPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSchemasPaginator<C, M, R> {
            crate::paginator::ListSchemasPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>The name of the database that contains the schemas to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database that contains the schemas to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn connected_database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_database(input.into());
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn set_connected_database(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_database(input);
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. </p>
        pub fn schema_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_pattern(input.into());
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. </p>
        pub fn set_schema_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_pattern(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStatements`.
    ///
    /// <p>List of SQL statements. By default, only finished statements are shown. A token is returned to page through the statement list. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStatements<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_statements_input::Builder,
    }
    impl<C, M, R> ListStatements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStatements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStatementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStatementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStatementsInputOperationOutputAlias,
                crate::output::ListStatementsOutput,
                crate::error::ListStatementsError,
                crate::input::ListStatementsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStatementsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStatementsPaginator<C, M, R> {
            crate::paginator::ListStatementsPaginator::new(self.handle, self.inner)
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. </p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_name(input.into());
            self
        }
        /// <p>The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. </p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_statement_name(input);
            self
        }
        /// <p>The status of the SQL statement to list. Status values are defined as follows: </p>
        /// <ul>
        /// <li> <p>ABORTED - The query run was stopped by the user. </p> </li>
        /// <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>
        /// <li> <p>FAILED - The query run failed. </p> </li>
        /// <li> <p>FINISHED - The query has finished running. </p> </li>
        /// <li> <p>PICKED - The query has been chosen to be run. </p> </li>
        /// <li> <p>STARTED - The query run has started. </p> </li>
        /// <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StatusString) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the SQL statement to list. Status values are defined as follows: </p>
        /// <ul>
        /// <li> <p>ABORTED - The query run was stopped by the user. </p> </li>
        /// <li> <p>ALL - A status value that includes all query statuses. This value can be used to filter results. </p> </li>
        /// <li> <p>FAILED - The query run failed. </p> </li>
        /// <li> <p>FINISHED - The query has finished running. </p> </li>
        /// <li> <p>PICKED - The query has been chosen to be run. </p> </li>
        /// <li> <p>STARTED - The query run has started. </p> </li>
        /// <li> <p>SUBMITTED - The query was submitted, but not yet processed. </p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusString>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. </p>
        pub fn role_level(mut self, input: bool) -> Self {
            self.inner = self.inner.role_level(input);
            self
        }
        /// <p>A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. </p>
        pub fn set_role_level(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_role_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTables`.
    ///
    /// <p>List the tables in a database. If neither <code>SchemaPattern</code> nor <code>TablePattern</code> are specified, then all tables in the database are returned. A token is returned to page through the table list. Depending on the authorization method, use one of the following combinations of request parameters: </p>
    /// <ul>
    /// <li> <p>Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless endpoint, specify the Amazon Resource Name (ARN) of the secret and the database name. </p> </li>
    /// <li> <p>Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is required. When connecting to a serverless endpoint, specify the database name. </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTables<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tables_input::Builder,
    }
    impl<C, M, R> ListTables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTablesInputOperationOutputAlias,
                crate::output::ListTablesOutput,
                crate::error::ListTablesError,
                crate::input::ListTablesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTablesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTablesPaginator<C, M, R> {
            crate::paginator::ListTablesPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either Secrets Manager or temporary credentials. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(input.into());
            self
        }
        /// <p>The database user name. This parameter is required when connecting to a cluster and authenticating using temporary credentials. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database that contains the tables to list. If <code>ConnectedDatabase</code> is not specified, this is also the database to connect to with your authentication credentials.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn connected_database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connected_database(input.into());
            self
        }
        /// <p>A database name. The connected database is specified when you connect with your authentication credentials. </p>
        pub fn set_connected_database(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connected_database(input);
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn schema_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema_pattern(input.into());
            self
        }
        /// <p>A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn set_schema_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schema_pattern(input);
            self
        }
        /// <p>A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn table_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_pattern(input.into());
            self
        }
        /// <p>A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are returned. </p>
        pub fn set_table_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_pattern(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of tables to return in the response. If more tables exist than fit in one response, then <code>NextToken</code> is returned to page through the results. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
