// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchExecuteStatementError {
    /// Kind of error that occurred.
    pub kind: BatchExecuteStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchExecuteStatementErrorKind {
    /// <p>The number of active statements exceeds the limit.</p>
    ActiveStatementsExceededException(crate::error::ActiveStatementsExceededException),
    /// <p>An SQL statement encountered an environmental error while running.</p>
    BatchExecuteStatementException(crate::error::BatchExecuteStatementException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchExecuteStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchExecuteStatementErrorKind::ActiveStatementsExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchExecuteStatementErrorKind::BatchExecuteStatementException(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchExecuteStatementError {
    fn code(&self) -> Option<&str> {
        BatchExecuteStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchExecuteStatementError {
    /// Creates a new `BatchExecuteStatementError`.
    pub fn new(kind: BatchExecuteStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchExecuteStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchExecuteStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchExecuteStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchExecuteStatementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::ActiveStatementsExceededException`.
    pub fn is_active_statements_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::ActiveStatementsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::BatchExecuteStatementException`.
    pub fn is_batch_execute_statement_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::BatchExecuteStatementException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchExecuteStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchExecuteStatementErrorKind::ActiveStatementsExceededException(_inner) => {
                Some(_inner)
            }
            BatchExecuteStatementErrorKind::BatchExecuteStatementException(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::ValidationException(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelStatementError {
    /// Kind of error that occurred.
    pub kind: CancelStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelStatementErrorKind {
    /// <p>Connection to a database failed.</p>
    DatabaseConnectionException(crate::error::DatabaseConnectionException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to a missing resource. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelStatementErrorKind::DatabaseConnectionException(_inner) => _inner.fmt(f),
            CancelStatementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CancelStatementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelStatementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CancelStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelStatementError {
    fn code(&self) -> Option<&str> {
        CancelStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelStatementError {
    /// Creates a new `CancelStatementError`.
    pub fn new(kind: CancelStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelStatementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelStatementErrorKind::DatabaseConnectionException`.
    pub fn is_database_connection_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelStatementErrorKind::DatabaseConnectionException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelStatementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelStatementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CancelStatementErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CancelStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelStatementErrorKind::DatabaseConnectionException(_inner) => Some(_inner),
            CancelStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            CancelStatementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelStatementErrorKind::ValidationException(_inner) => Some(_inner),
            CancelStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStatementError {
    /// Kind of error that occurred.
    pub kind: DescribeStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStatementErrorKind {
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to a missing resource. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStatementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeStatementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStatementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStatementError {
    fn code(&self) -> Option<&str> {
        DescribeStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStatementError {
    /// Creates a new `DescribeStatementError`.
    pub fn new(kind: DescribeStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStatementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStatementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeStatementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStatementErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeStatementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeStatementErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTableError {
    /// Kind of error that occurred.
    pub kind: DescribeTableErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTable` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTableErrorKind {
    /// <p>Connection to a database failed.</p>
    DatabaseConnectionException(crate::error::DatabaseConnectionException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTableErrorKind::DatabaseConnectionException(_inner) => _inner.fmt(f),
            DescribeTableErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeTableErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeTableErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTableError {
    fn code(&self) -> Option<&str> {
        DescribeTableError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTableError {
    /// Creates a new `DescribeTableError`.
    pub fn new(kind: DescribeTableErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTableError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTableErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTableError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTableErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTableErrorKind::DatabaseConnectionException`.
    pub fn is_database_connection_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableErrorKind::DatabaseConnectionException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTableErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTableErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeTableErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeTableError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTableErrorKind::DatabaseConnectionException(_inner) => Some(_inner),
            DescribeTableErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeTableErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeTableErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteStatementError {
    /// Kind of error that occurred.
    pub kind: ExecuteStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteStatementErrorKind {
    /// <p>The number of active statements exceeds the limit.</p>
    ActiveStatementsExceededException(crate::error::ActiveStatementsExceededException),
    /// <p>The SQL statement encountered an environmental error while running.</p>
    ExecuteStatementException(crate::error::ExecuteStatementException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteStatementErrorKind::ActiveStatementsExceededException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::ExecuteStatementException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteStatementError {
    fn code(&self) -> Option<&str> {
        ExecuteStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteStatementError {
    /// Creates a new `ExecuteStatementError`.
    pub fn new(kind: ExecuteStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteStatementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ActiveStatementsExceededException`.
    pub fn is_active_statements_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ActiveStatementsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ExecuteStatementException`.
    pub fn is_execute_statement_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ExecuteStatementException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ExecuteStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteStatementErrorKind::ActiveStatementsExceededException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::ExecuteStatementException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::ValidationException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStatementResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStatementResultError {
    /// Kind of error that occurred.
    pub kind: GetStatementResultErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStatementResult` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStatementResultErrorKind {
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to a missing resource. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStatementResultError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStatementResultErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetStatementResultErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetStatementResultErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetStatementResultErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStatementResultError {
    fn code(&self) -> Option<&str> {
        GetStatementResultError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStatementResultError {
    /// Creates a new `GetStatementResultError`.
    pub fn new(kind: GetStatementResultErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStatementResultError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStatementResultErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStatementResultError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStatementResultErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStatementResultErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatementResultErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatementResultErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatementResultErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStatementResultErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStatementResultErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetStatementResultError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStatementResultErrorKind::InternalServerException(_inner) => Some(_inner),
            GetStatementResultErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetStatementResultErrorKind::ValidationException(_inner) => Some(_inner),
            GetStatementResultErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatabasesError {
    /// Kind of error that occurred.
    pub kind: ListDatabasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatabasesErrorKind {
    /// <p>Connection to a database failed.</p>
    DatabaseConnectionException(crate::error::DatabaseConnectionException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatabasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatabasesErrorKind::DatabaseConnectionException(_inner) => _inner.fmt(f),
            ListDatabasesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDatabasesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDatabasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatabasesError {
    fn code(&self) -> Option<&str> {
        ListDatabasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatabasesError {
    /// Creates a new `ListDatabasesError`.
    pub fn new(kind: ListDatabasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatabasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatabasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatabasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatabasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDatabasesErrorKind::DatabaseConnectionException`.
    pub fn is_database_connection_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatabasesErrorKind::DatabaseConnectionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatabasesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatabasesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDatabasesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDatabasesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDatabasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatabasesErrorKind::DatabaseConnectionException(_inner) => Some(_inner),
            ListDatabasesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDatabasesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDatabasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSchemasError {
    /// Kind of error that occurred.
    pub kind: ListSchemasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSchemasErrorKind {
    /// <p>Connection to a database failed.</p>
    DatabaseConnectionException(crate::error::DatabaseConnectionException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSchemasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSchemasErrorKind::DatabaseConnectionException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSchemasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSchemasError {
    fn code(&self) -> Option<&str> {
        ListSchemasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSchemasError {
    /// Creates a new `ListSchemasError`.
    pub fn new(kind: ListSchemasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSchemasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSchemasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSchemasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::DatabaseConnectionException`.
    pub fn is_database_connection_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSchemasErrorKind::DatabaseConnectionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListSchemasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListSchemasErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListSchemasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSchemasErrorKind::DatabaseConnectionException(_inner) => Some(_inner),
            ListSchemasErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSchemasErrorKind::ValidationException(_inner) => Some(_inner),
            ListSchemasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListStatements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListStatementsError {
    /// Kind of error that occurred.
    pub kind: ListStatementsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListStatements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListStatementsErrorKind {
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListStatementsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListStatementsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListStatementsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListStatementsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListStatementsError {
    fn code(&self) -> Option<&str> {
        ListStatementsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListStatementsError {
    /// Creates a new `ListStatementsError`.
    pub fn new(kind: ListStatementsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListStatementsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListStatementsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListStatementsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListStatementsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListStatementsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListStatementsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListStatementsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListStatementsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListStatementsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListStatementsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListStatementsErrorKind::ValidationException(_inner) => Some(_inner),
            ListStatementsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTablesError {
    /// Kind of error that occurred.
    pub kind: ListTablesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTablesErrorKind {
    /// <p>Connection to a database failed.</p>
    DatabaseConnectionException(crate::error::DatabaseConnectionException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTablesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTablesErrorKind::DatabaseConnectionException(_inner) => _inner.fmt(f),
            ListTablesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTablesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTablesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTablesError {
    fn code(&self) -> Option<&str> {
        ListTablesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTablesError {
    /// Creates a new `ListTablesError`.
    pub fn new(kind: ListTablesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTablesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTablesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTablesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTablesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTablesErrorKind::DatabaseConnectionException`.
    pub fn is_database_connection_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTablesErrorKind::DatabaseConnectionException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTablesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListTablesErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListTablesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListTablesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListTablesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTablesErrorKind::DatabaseConnectionException(_inner) => Some(_inner),
            ListTablesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTablesErrorKind::ValidationException(_inner) => Some(_inner),
            ListTablesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The Amazon Redshift Data API operation failed due to invalid input. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Connection to a database failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatabaseConnectionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DatabaseConnectionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatabaseConnectionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DatabaseConnectionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DatabaseConnectionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DatabaseConnectionException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for DatabaseConnectionException {}
/// See [`DatabaseConnectionException`](crate::error::DatabaseConnectionException)
pub mod database_connection_exception {
    /// A builder for [`DatabaseConnectionException`](crate::error::DatabaseConnectionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DatabaseConnectionException`](crate::error::DatabaseConnectionException)
        pub fn build(self) -> crate::error::DatabaseConnectionException {
            crate::error::DatabaseConnectionException {
                message: self.message,
            }
        }
    }
}
impl DatabaseConnectionException {
    /// Creates a new builder-style object to manufacture [`DatabaseConnectionException`](crate::error::DatabaseConnectionException)
    pub fn builder() -> crate::error::database_connection_exception::Builder {
        crate::error::database_connection_exception::Builder::default()
    }
}

/// <p>The Amazon Redshift Data API operation failed due to a missing resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Resource identifier associated with the exception.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>Resource identifier associated with the exception.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Resource identifier associated with the exception.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Resource identifier associated with the exception.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The SQL statement encountered an environmental error while running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementException {
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Statement identifier of the exception.</p>
    pub statement_id: std::option::Option<std::string::String>,
}
impl ExecuteStatementException {
    /// <p>Statement identifier of the exception.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
}
impl std::fmt::Debug for ExecuteStatementException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementException");
        formatter.field("message", &self.message);
        formatter.field("statement_id", &self.statement_id);
        formatter.finish()
    }
}
impl ExecuteStatementException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExecuteStatementException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExecuteStatementException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExecuteStatementException {}
/// See [`ExecuteStatementException`](crate::error::ExecuteStatementException)
pub mod execute_statement_exception {
    /// A builder for [`ExecuteStatementException`](crate::error::ExecuteStatementException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Statement identifier of the exception.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>Statement identifier of the exception.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementException`](crate::error::ExecuteStatementException)
        pub fn build(self) -> crate::error::ExecuteStatementException {
            crate::error::ExecuteStatementException {
                message: self.message,
                statement_id: self.statement_id,
            }
        }
    }
}
impl ExecuteStatementException {
    /// Creates a new builder-style object to manufacture [`ExecuteStatementException`](crate::error::ExecuteStatementException)
    pub fn builder() -> crate::error::execute_statement_exception::Builder {
        crate::error::execute_statement_exception::Builder::default()
    }
}

/// <p>The number of active statements exceeds the limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveStatementsExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ActiveStatementsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveStatementsExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ActiveStatementsExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ActiveStatementsExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ActiveStatementsExceededException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ActiveStatementsExceededException {}
/// See [`ActiveStatementsExceededException`](crate::error::ActiveStatementsExceededException)
pub mod active_statements_exceeded_exception {
    /// A builder for [`ActiveStatementsExceededException`](crate::error::ActiveStatementsExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveStatementsExceededException`](crate::error::ActiveStatementsExceededException)
        pub fn build(self) -> crate::error::ActiveStatementsExceededException {
            crate::error::ActiveStatementsExceededException {
                message: self.message,
            }
        }
    }
}
impl ActiveStatementsExceededException {
    /// Creates a new builder-style object to manufacture [`ActiveStatementsExceededException`](crate::error::ActiveStatementsExceededException)
    pub fn builder() -> crate::error::active_statements_exceeded_exception::Builder {
        crate::error::active_statements_exceeded_exception::Builder::default()
    }
}

/// <p>An SQL statement encountered an environmental error while running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchExecuteStatementException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>Statement identifier of the exception.</p>
    pub statement_id: std::option::Option<std::string::String>,
}
impl BatchExecuteStatementException {
    /// <p>Statement identifier of the exception.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
}
impl std::fmt::Debug for BatchExecuteStatementException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchExecuteStatementException");
        formatter.field("message", &self.message);
        formatter.field("statement_id", &self.statement_id);
        formatter.finish()
    }
}
impl BatchExecuteStatementException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchExecuteStatementException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchExecuteStatementException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchExecuteStatementException {}
/// See [`BatchExecuteStatementException`](crate::error::BatchExecuteStatementException)
pub mod batch_execute_statement_exception {
    /// A builder for [`BatchExecuteStatementException`](crate::error::BatchExecuteStatementException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Statement identifier of the exception.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>Statement identifier of the exception.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchExecuteStatementException`](crate::error::BatchExecuteStatementException)
        pub fn build(self) -> crate::error::BatchExecuteStatementException {
            crate::error::BatchExecuteStatementException {
                message: self.message,
                statement_id: self.statement_id,
            }
        }
    }
}
impl BatchExecuteStatementException {
    /// Creates a new builder-style object to manufacture [`BatchExecuteStatementException`](crate::error::BatchExecuteStatementException)
    pub fn builder() -> crate::error::batch_execute_statement_exception::Builder {
        crate::error::batch_execute_statement_exception::Builder::default()
    }
}
