// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesOutput {
    /// <p>The tables that match the request pattern. </p>
    pub tables: std::option::Option<std::vec::Vec<crate::model::TableMember>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesOutput");
        formatter.field("tables", &self.tables);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTablesOutput`](crate::output::ListTablesOutput)
pub mod list_tables_output {
    /// A builder for [`ListTablesOutput`](crate::output::ListTablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tables: std::option::Option<std::vec::Vec<crate::model::TableMember>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tables`.
        ///
        /// To override the contents of this collection use [`set_tables`](Self::set_tables).
        ///
        /// <p>The tables that match the request pattern. </p>
        pub fn tables(mut self, input: impl Into<crate::model::TableMember>) -> Self {
            let mut v = self.tables.unwrap_or_default();
            v.push(input.into());
            self.tables = Some(v);
            self
        }
        /// <p>The tables that match the request pattern. </p>
        pub fn set_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableMember>>,
        ) -> Self {
            self.tables = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesOutput`](crate::output::ListTablesOutput)
        pub fn build(self) -> crate::output::ListTablesOutput {
            crate::output::ListTablesOutput {
                tables: self.tables,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTablesOutput {
    /// Creates a new builder-style object to manufacture [`ListTablesOutput`](crate::output::ListTablesOutput)
    pub fn builder() -> crate::output::list_tables_output::Builder {
        crate::output::list_tables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStatementsOutput {
    /// <p>The SQL statements. </p>
    pub statements: std::option::Option<std::vec::Vec<crate::model::StatementData>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListStatementsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStatementsOutput");
        formatter.field("statements", &self.statements);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListStatementsOutput`](crate::output::ListStatementsOutput)
pub mod list_statements_output {
    /// A builder for [`ListStatementsOutput`](crate::output::ListStatementsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statements: std::option::Option<std::vec::Vec<crate::model::StatementData>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `statements`.
        ///
        /// To override the contents of this collection use [`set_statements`](Self::set_statements).
        ///
        /// <p>The SQL statements. </p>
        pub fn statements(mut self, input: impl Into<crate::model::StatementData>) -> Self {
            let mut v = self.statements.unwrap_or_default();
            v.push(input.into());
            self.statements = Some(v);
            self
        }
        /// <p>The SQL statements. </p>
        pub fn set_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StatementData>>,
        ) -> Self {
            self.statements = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStatementsOutput`](crate::output::ListStatementsOutput)
        pub fn build(self) -> crate::output::ListStatementsOutput {
            crate::output::ListStatementsOutput {
                statements: self.statements,
                next_token: self.next_token,
            }
        }
    }
}
impl ListStatementsOutput {
    /// Creates a new builder-style object to manufacture [`ListStatementsOutput`](crate::output::ListStatementsOutput)
    pub fn builder() -> crate::output::list_statements_output::Builder {
        crate::output::list_statements_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSchemasOutput {
    /// <p>The schemas that match the request pattern. </p>
    pub schemas: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListSchemasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSchemasOutput");
        formatter.field("schemas", &self.schemas);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSchemasOutput`](crate::output::ListSchemasOutput)
pub mod list_schemas_output {
    /// A builder for [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schemas: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `schemas`.
        ///
        /// To override the contents of this collection use [`set_schemas`](Self::set_schemas).
        ///
        /// <p>The schemas that match the request pattern. </p>
        pub fn schemas(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schemas.unwrap_or_default();
            v.push(input.into());
            self.schemas = Some(v);
            self
        }
        /// <p>The schemas that match the request pattern. </p>
        pub fn set_schemas(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schemas = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSchemasOutput`](crate::output::ListSchemasOutput)
        pub fn build(self) -> crate::output::ListSchemasOutput {
            crate::output::ListSchemasOutput {
                schemas: self.schemas,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSchemasOutput {
    /// Creates a new builder-style object to manufacture [`ListSchemasOutput`](crate::output::ListSchemasOutput)
    pub fn builder() -> crate::output::list_schemas_output::Builder {
        crate::output::list_schemas_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatabasesOutput {
    /// <p>The names of databases. </p>
    pub databases: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDatabasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatabasesOutput");
        formatter.field("databases", &self.databases);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatabasesOutput`](crate::output::ListDatabasesOutput)
pub mod list_databases_output {
    /// A builder for [`ListDatabasesOutput`](crate::output::ListDatabasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) databases: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `databases`.
        ///
        /// To override the contents of this collection use [`set_databases`](Self::set_databases).
        ///
        /// <p>The names of databases. </p>
        pub fn databases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.databases.unwrap_or_default();
            v.push(input.into());
            self.databases = Some(v);
            self
        }
        /// <p>The names of databases. </p>
        pub fn set_databases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.databases = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatabasesOutput`](crate::output::ListDatabasesOutput)
        pub fn build(self) -> crate::output::ListDatabasesOutput {
            crate::output::ListDatabasesOutput {
                databases: self.databases,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatabasesOutput {
    /// Creates a new builder-style object to manufacture [`ListDatabasesOutput`](crate::output::ListDatabasesOutput)
    pub fn builder() -> crate::output::list_databases_output::Builder {
        crate::output::list_databases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStatementResultOutput {
    /// <p>The results of the SQL statement.</p>
    pub records: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::Field>>>,
    /// <p>The properties (metadata) of a column. </p>
    pub column_metadata: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
    /// <p>The total number of rows in the result set returned from a query.
    /// You can use this number to estimate the number of calls to the <code>GetStatementResult</code> operation needed to page through the results. </p>
    pub total_num_rows: i64,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetStatementResultOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStatementResultOutput");
        formatter.field("records", &self.records);
        formatter.field("column_metadata", &self.column_metadata);
        formatter.field("total_num_rows", &self.total_num_rows);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetStatementResultOutput`](crate::output::GetStatementResultOutput)
pub mod get_statement_result_output {
    /// A builder for [`GetStatementResultOutput`](crate::output::GetStatementResultOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) records: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::Field>>>,
        pub(crate) column_metadata:
            std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
        pub(crate) total_num_rows: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// <p>The results of the SQL statement.</p>
        pub fn records(mut self, input: impl Into<std::vec::Vec<crate::model::Field>>) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input.into());
            self.records = Some(v);
            self
        }
        /// <p>The results of the SQL statement.</p>
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::Field>>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// Appends an item to `column_metadata`.
        ///
        /// To override the contents of this collection use [`set_column_metadata`](Self::set_column_metadata).
        ///
        /// <p>The properties (metadata) of a column. </p>
        pub fn column_metadata(mut self, input: impl Into<crate::model::ColumnMetadata>) -> Self {
            let mut v = self.column_metadata.unwrap_or_default();
            v.push(input.into());
            self.column_metadata = Some(v);
            self
        }
        /// <p>The properties (metadata) of a column. </p>
        pub fn set_column_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
        ) -> Self {
            self.column_metadata = input;
            self
        }
        /// <p>The total number of rows in the result set returned from a query.
        /// You can use this number to estimate the number of calls to the <code>GetStatementResult</code> operation needed to page through the results. </p>
        pub fn total_num_rows(mut self, input: i64) -> Self {
            self.total_num_rows = Some(input);
            self
        }
        /// <p>The total number of rows in the result set returned from a query.
        /// You can use this number to estimate the number of calls to the <code>GetStatementResult</code> operation needed to page through the results. </p>
        pub fn set_total_num_rows(mut self, input: std::option::Option<i64>) -> Self {
            self.total_num_rows = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStatementResultOutput`](crate::output::GetStatementResultOutput)
        pub fn build(self) -> crate::output::GetStatementResultOutput {
            crate::output::GetStatementResultOutput {
                records: self.records,
                column_metadata: self.column_metadata,
                total_num_rows: self.total_num_rows.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl GetStatementResultOutput {
    /// Creates a new builder-style object to manufacture [`GetStatementResultOutput`](crate::output::GetStatementResultOutput)
    pub fn builder() -> crate::output::get_statement_result_output::Builder {
        crate::output::get_statement_result_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementOutput {
    /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time (UTC) the statement was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The cluster identifier. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The database user name.</p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. </p>
    pub secret_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExecuteStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementOutput");
        formatter.field("id", &self.id);
        formatter.field("created_at", &self.created_at);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.finish()
    }
}
/// See [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
pub mod execute_statement_output {
    /// A builder for [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The cluster identifier. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The database user name.</p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name.</p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
        pub fn build(self) -> crate::output::ExecuteStatementOutput {
            crate::output::ExecuteStatementOutput {
                id: self.id,
                created_at: self.created_at,
                cluster_identifier: self.cluster_identifier,
                db_user: self.db_user,
                database: self.database,
                secret_arn: self.secret_arn,
            }
        }
    }
}
impl ExecuteStatementOutput {
    /// Creates a new builder-style object to manufacture [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput)
    pub fn builder() -> crate::output::execute_statement_output::Builder {
        crate::output::execute_statement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableOutput {
    /// <p>The table name. </p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A list of columns in the table. </p>
    pub column_list: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeTableOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableOutput");
        formatter.field("table_name", &self.table_name);
        formatter.field("column_list", &self.column_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeTableOutput`](crate::output::DescribeTableOutput)
pub mod describe_table_output {
    /// A builder for [`DescribeTableOutput`](crate::output::DescribeTableOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) column_list: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The table name. </p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The table name. </p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Appends an item to `column_list`.
        ///
        /// To override the contents of this collection use [`set_column_list`](Self::set_column_list).
        ///
        /// <p>A list of columns in the table. </p>
        pub fn column_list(mut self, input: impl Into<crate::model::ColumnMetadata>) -> Self {
            let mut v = self.column_list.unwrap_or_default();
            v.push(input.into());
            self.column_list = Some(v);
            self
        }
        /// <p>A list of columns in the table. </p>
        pub fn set_column_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
        ) -> Self {
            self.column_list = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableOutput`](crate::output::DescribeTableOutput)
        pub fn build(self) -> crate::output::DescribeTableOutput {
            crate::output::DescribeTableOutput {
                table_name: self.table_name,
                column_list: self.column_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeTableOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTableOutput`](crate::output::DescribeTableOutput)
    pub fn builder() -> crate::output::describe_table_output::Builder {
        crate::output::describe_table_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStatementOutput {
    /// <p>The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The database user name. </p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database. </p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The cluster identifier. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The amount of time in nanoseconds that the statement ran. </p>
    pub duration: i64,
    /// <p>The error message from the cluster if the SQL statement encountered an error while running. </p>
    pub error: std::option::Option<std::string::String>,
    /// <p>The status of the SQL statement being described. Status values are defined as follows: </p>
    /// <ul>
    /// <li>
    /// <p>ABORTED - The query run was stopped by the user. </p>
    /// </li>
    /// <li>
    /// <p>ALL -  A status value that includes all query statuses. This value can be used to filter results. </p>
    /// </li>
    /// <li>
    /// <p>FAILED - The query run failed. </p>
    /// </li>
    /// <li>
    /// <p>FINISHED - The query has finished running. </p>
    /// </li>
    /// <li>
    /// <p>PICKED - The query has been chosen to be run. </p>
    /// </li>
    /// <li>
    /// <p>STARTED - The query run has started. </p>
    /// </li>
    /// <li>
    /// <p>SUBMITTED - The query was submitted, but not yet processed. </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::StatusString>,
    /// <p>The date and time (UTC) when the SQL statement was submitted to run. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time (UTC) that the metadata for the SQL statement was last updated. An
    /// example is the time the status last changed. </p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The process identifier from Amazon Redshift. </p>
    pub redshift_pid: i64,
    /// <p>A value that indicates whether the statement has a result set. The result set can be empty. </p>
    pub has_result_set: std::option::Option<bool>,
    /// <p>The SQL statement text. </p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>Either the number of rows returned from the SQL statement or the number of rows affected.
    /// If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
    /// A <code>-1</code> indicates the value is null.</p>
    pub result_rows: i64,
    /// <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
    pub result_size: i64,
    /// <p>The identifier of the query generated by Amazon Redshift.
    /// These identifiers are also available in the <code>query</code> column of the <code>STL_QUERY</code> system view. </p>
    pub redshift_query_id: i64,
    /// <p>The parameters for the SQL statement.</p>
    pub query_parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
    /// <p>The SQL statements from a multiple statement run.</p>
    pub sub_statements: std::option::Option<std::vec::Vec<crate::model::SubStatementData>>,
}
impl std::fmt::Debug for DescribeStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStatementOutput");
        formatter.field("id", &self.id);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("duration", &self.duration);
        formatter.field("error", &self.error);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("redshift_pid", &self.redshift_pid);
        formatter.field("has_result_set", &self.has_result_set);
        formatter.field("query_string", &self.query_string);
        formatter.field("result_rows", &self.result_rows);
        formatter.field("result_size", &self.result_size);
        formatter.field("redshift_query_id", &self.redshift_query_id);
        formatter.field("query_parameters", &self.query_parameters);
        formatter.field("sub_statements", &self.sub_statements);
        formatter.finish()
    }
}
/// See [`DescribeStatementOutput`](crate::output::DescribeStatementOutput)
pub mod describe_statement_output {
    /// A builder for [`DescribeStatementOutput`](crate::output::DescribeStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i64>,
        pub(crate) error: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusString>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) redshift_pid: std::option::Option<i64>,
        pub(crate) has_result_set: std::option::Option<bool>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) result_rows: std::option::Option<i64>,
        pub(crate) result_size: std::option::Option<i64>,
        pub(crate) redshift_query_id: std::option::Option<i64>,
        pub(crate) query_parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        pub(crate) sub_statements:
            std::option::Option<std::vec::Vec<crate::model::SubStatementData>>,
    }
    impl Builder {
        /// <p>The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the secret that enables access to the database. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The database user name. </p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. </p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database. </p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database. </p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The cluster identifier. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The amount of time in nanoseconds that the statement ran. </p>
        pub fn duration(mut self, input: i64) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The amount of time in nanoseconds that the statement ran. </p>
        pub fn set_duration(mut self, input: std::option::Option<i64>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The error message from the cluster if the SQL statement encountered an error while running. </p>
        pub fn error(mut self, input: impl Into<std::string::String>) -> Self {
            self.error = Some(input.into());
            self
        }
        /// <p>The error message from the cluster if the SQL statement encountered an error while running. </p>
        pub fn set_error(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error = input;
            self
        }
        /// <p>The status of the SQL statement being described. Status values are defined as follows: </p>
        /// <ul>
        /// <li>
        /// <p>ABORTED - The query run was stopped by the user. </p>
        /// </li>
        /// <li>
        /// <p>ALL -  A status value that includes all query statuses. This value can be used to filter results. </p>
        /// </li>
        /// <li>
        /// <p>FAILED - The query run failed. </p>
        /// </li>
        /// <li>
        /// <p>FINISHED - The query has finished running. </p>
        /// </li>
        /// <li>
        /// <p>PICKED - The query has been chosen to be run. </p>
        /// </li>
        /// <li>
        /// <p>STARTED - The query run has started. </p>
        /// </li>
        /// <li>
        /// <p>SUBMITTED - The query was submitted, but not yet processed. </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::StatusString) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SQL statement being described. Status values are defined as follows: </p>
        /// <ul>
        /// <li>
        /// <p>ABORTED - The query run was stopped by the user. </p>
        /// </li>
        /// <li>
        /// <p>ALL -  A status value that includes all query statuses. This value can be used to filter results. </p>
        /// </li>
        /// <li>
        /// <p>FAILED - The query run failed. </p>
        /// </li>
        /// <li>
        /// <p>FINISHED - The query has finished running. </p>
        /// </li>
        /// <li>
        /// <p>PICKED - The query has been chosen to be run. </p>
        /// </li>
        /// <li>
        /// <p>STARTED - The query run has started. </p>
        /// </li>
        /// <li>
        /// <p>SUBMITTED - The query was submitted, but not yet processed. </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::StatusString>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time (UTC) when the SQL statement was submitted to run. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) when the SQL statement was submitted to run. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date and time (UTC) that the metadata for the SQL statement was last updated. An
        /// example is the time the status last changed. </p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) that the metadata for the SQL statement was last updated. An
        /// example is the time the status last changed. </p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The process identifier from Amazon Redshift. </p>
        pub fn redshift_pid(mut self, input: i64) -> Self {
            self.redshift_pid = Some(input);
            self
        }
        /// <p>The process identifier from Amazon Redshift. </p>
        pub fn set_redshift_pid(mut self, input: std::option::Option<i64>) -> Self {
            self.redshift_pid = input;
            self
        }
        /// <p>A value that indicates whether the statement has a result set. The result set can be empty. </p>
        pub fn has_result_set(mut self, input: bool) -> Self {
            self.has_result_set = Some(input);
            self
        }
        /// <p>A value that indicates whether the statement has a result set. The result set can be empty. </p>
        pub fn set_has_result_set(mut self, input: std::option::Option<bool>) -> Self {
            self.has_result_set = input;
            self
        }
        /// <p>The SQL statement text. </p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The SQL statement text. </p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>Either the number of rows returned from the SQL statement or the number of rows affected.
        /// If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
        /// A <code>-1</code> indicates the value is null.</p>
        pub fn result_rows(mut self, input: i64) -> Self {
            self.result_rows = Some(input);
            self
        }
        /// <p>Either the number of rows returned from the SQL statement or the number of rows affected.
        /// If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
        /// A <code>-1</code> indicates the value is null.</p>
        pub fn set_result_rows(mut self, input: std::option::Option<i64>) -> Self {
            self.result_rows = input;
            self
        }
        /// <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
        pub fn result_size(mut self, input: i64) -> Self {
            self.result_size = Some(input);
            self
        }
        /// <p>The size in bytes of the returned results. A <code>-1</code> indicates the value is null.</p>
        pub fn set_result_size(mut self, input: std::option::Option<i64>) -> Self {
            self.result_size = input;
            self
        }
        /// <p>The identifier of the query generated by Amazon Redshift.
        /// These identifiers are also available in the <code>query</code> column of the <code>STL_QUERY</code> system view. </p>
        pub fn redshift_query_id(mut self, input: i64) -> Self {
            self.redshift_query_id = Some(input);
            self
        }
        /// <p>The identifier of the query generated by Amazon Redshift.
        /// These identifiers are also available in the <code>query</code> column of the <code>STL_QUERY</code> system view. </p>
        pub fn set_redshift_query_id(mut self, input: std::option::Option<i64>) -> Self {
            self.redshift_query_id = input;
            self
        }
        /// Appends an item to `query_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_parameters`](Self::set_query_parameters).
        ///
        /// <p>The parameters for the SQL statement.</p>
        pub fn query_parameters(mut self, input: impl Into<crate::model::SqlParameter>) -> Self {
            let mut v = self.query_parameters.unwrap_or_default();
            v.push(input.into());
            self.query_parameters = Some(v);
            self
        }
        /// <p>The parameters for the SQL statement.</p>
        pub fn set_query_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.query_parameters = input;
            self
        }
        /// Appends an item to `sub_statements`.
        ///
        /// To override the contents of this collection use [`set_sub_statements`](Self::set_sub_statements).
        ///
        /// <p>The SQL statements from a multiple statement run.</p>
        pub fn sub_statements(mut self, input: impl Into<crate::model::SubStatementData>) -> Self {
            let mut v = self.sub_statements.unwrap_or_default();
            v.push(input.into());
            self.sub_statements = Some(v);
            self
        }
        /// <p>The SQL statements from a multiple statement run.</p>
        pub fn set_sub_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubStatementData>>,
        ) -> Self {
            self.sub_statements = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStatementOutput`](crate::output::DescribeStatementOutput)
        pub fn build(self) -> crate::output::DescribeStatementOutput {
            crate::output::DescribeStatementOutput {
                id: self.id,
                secret_arn: self.secret_arn,
                db_user: self.db_user,
                database: self.database,
                cluster_identifier: self.cluster_identifier,
                duration: self.duration.unwrap_or_default(),
                error: self.error,
                status: self.status,
                created_at: self.created_at,
                updated_at: self.updated_at,
                redshift_pid: self.redshift_pid.unwrap_or_default(),
                has_result_set: self.has_result_set,
                query_string: self.query_string,
                result_rows: self.result_rows.unwrap_or_default(),
                result_size: self.result_size.unwrap_or_default(),
                redshift_query_id: self.redshift_query_id.unwrap_or_default(),
                query_parameters: self.query_parameters,
                sub_statements: self.sub_statements,
            }
        }
    }
}
impl DescribeStatementOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStatementOutput`](crate::output::DescribeStatementOutput)
    pub fn builder() -> crate::output::describe_statement_output::Builder {
        crate::output::describe_statement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelStatementOutput {
    /// <p>A value that indicates whether the cancel statement succeeded (true). </p>
    pub status: std::option::Option<bool>,
}
impl std::fmt::Debug for CancelStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelStatementOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CancelStatementOutput`](crate::output::CancelStatementOutput)
pub mod cancel_statement_output {
    /// A builder for [`CancelStatementOutput`](crate::output::CancelStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A value that indicates whether the cancel statement succeeded (true). </p>
        pub fn status(mut self, input: bool) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A value that indicates whether the cancel statement succeeded (true). </p>
        pub fn set_status(mut self, input: std::option::Option<bool>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelStatementOutput`](crate::output::CancelStatementOutput)
        pub fn build(self) -> crate::output::CancelStatementOutput {
            crate::output::CancelStatementOutput {
                status: self.status,
            }
        }
    }
}
impl CancelStatementOutput {
    /// Creates a new builder-style object to manufacture [`CancelStatementOutput`](crate::output::CancelStatementOutput)
    pub fn builder() -> crate::output::cancel_statement_output::Builder {
        crate::output::cancel_statement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchExecuteStatementOutput {
    /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
    /// This identifier is returned by <code>BatchExecuteStatment</code>. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The date and time (UTC) the statement was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The cluster identifier. </p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The database user name.</p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The name of the database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the database. </p>
    pub secret_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchExecuteStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchExecuteStatementOutput");
        formatter.field("id", &self.id);
        formatter.field("created_at", &self.created_at);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("db_user", &self.db_user);
        formatter.field("database", &self.database);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.finish()
    }
}
/// See [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
pub mod batch_execute_statement_output {
    /// A builder for [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
        /// This identifier is returned by <code>BatchExecuteStatment</code>. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
        /// This identifier is returned by <code>BatchExecuteStatment</code>. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time (UTC) the statement was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The cluster identifier. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The database user name.</p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name.</p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
        pub fn build(self) -> crate::output::BatchExecuteStatementOutput {
            crate::output::BatchExecuteStatementOutput {
                id: self.id,
                created_at: self.created_at,
                cluster_identifier: self.cluster_identifier,
                db_user: self.db_user,
                database: self.database,
                secret_arn: self.secret_arn,
            }
        }
    }
}
impl BatchExecuteStatementOutput {
    /// Creates a new builder-style object to manufacture [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput)
    pub fn builder() -> crate::output::batch_execute_statement_output::Builder {
        crate::output::batch_execute_statement_output::Builder::default()
    }
}
