// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptReservedNodeExchange`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_reserved_node_exchange`](crate::client::Client::accept_reserved_node_exchange).
///
/// See [`crate::client::fluent_builders::AcceptReservedNodeExchange`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptReservedNodeExchange {
    _private: (),
}
impl AcceptReservedNodeExchange {
    /// Creates a new builder-style object to manufacture [`AcceptReservedNodeExchangeInput`](crate::input::AcceptReservedNodeExchangeInput)
    pub fn builder() -> crate::input::accept_reserved_node_exchange_input::Builder {
        crate::input::accept_reserved_node_exchange_input::Builder::default()
    }
    /// Creates a new `AcceptReservedNodeExchange` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptReservedNodeExchange {
    type Output = std::result::Result<
        crate::output::AcceptReservedNodeExchangeOutput,
        crate::error::AcceptReservedNodeExchangeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_reserved_node_exchange_error(response)
        } else {
            crate::operation_deser::parse_accept_reserved_node_exchange_response(response)
        }
    }
}

/// Operation shape for `AddPartner`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_partner`](crate::client::Client::add_partner).
///
/// See [`crate::client::fluent_builders::AddPartner`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddPartner {
    _private: (),
}
impl AddPartner {
    /// Creates a new builder-style object to manufacture [`AddPartnerInput`](crate::input::AddPartnerInput)
    pub fn builder() -> crate::input::add_partner_input::Builder {
        crate::input::add_partner_input::Builder::default()
    }
    /// Creates a new `AddPartner` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddPartner {
    type Output =
        std::result::Result<crate::output::AddPartnerOutput, crate::error::AddPartnerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_partner_error(response)
        } else {
            crate::operation_deser::parse_add_partner_response(response)
        }
    }
}

/// Operation shape for `AssociateDataShareConsumer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_data_share_consumer`](crate::client::Client::associate_data_share_consumer).
///
/// See [`crate::client::fluent_builders::AssociateDataShareConsumer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateDataShareConsumer {
    _private: (),
}
impl AssociateDataShareConsumer {
    /// Creates a new builder-style object to manufacture [`AssociateDataShareConsumerInput`](crate::input::AssociateDataShareConsumerInput)
    pub fn builder() -> crate::input::associate_data_share_consumer_input::Builder {
        crate::input::associate_data_share_consumer_input::Builder::default()
    }
    /// Creates a new `AssociateDataShareConsumer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateDataShareConsumer {
    type Output = std::result::Result<
        crate::output::AssociateDataShareConsumerOutput,
        crate::error::AssociateDataShareConsumerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_data_share_consumer_error(response)
        } else {
            crate::operation_deser::parse_associate_data_share_consumer_response(response)
        }
    }
}

/// Operation shape for `AuthorizeClusterSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_cluster_security_group_ingress`](crate::client::Client::authorize_cluster_security_group_ingress).
///
/// See [`crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeClusterSecurityGroupIngress {
    _private: (),
}
impl AuthorizeClusterSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`AuthorizeClusterSecurityGroupIngressInput`](crate::input::AuthorizeClusterSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_cluster_security_group_ingress_input::Builder {
        crate::input::authorize_cluster_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `AuthorizeClusterSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeClusterSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::AuthorizeClusterSecurityGroupIngressOutput,
        crate::error::AuthorizeClusterSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_cluster_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_authorize_cluster_security_group_ingress_response(
                response,
            )
        }
    }
}

/// Operation shape for `AuthorizeDataShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_data_share`](crate::client::Client::authorize_data_share).
///
/// See [`crate::client::fluent_builders::AuthorizeDataShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeDataShare {
    _private: (),
}
impl AuthorizeDataShare {
    /// Creates a new builder-style object to manufacture [`AuthorizeDataShareInput`](crate::input::AuthorizeDataShareInput)
    pub fn builder() -> crate::input::authorize_data_share_input::Builder {
        crate::input::authorize_data_share_input::Builder::default()
    }
    /// Creates a new `AuthorizeDataShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeDataShare {
    type Output = std::result::Result<
        crate::output::AuthorizeDataShareOutput,
        crate::error::AuthorizeDataShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_data_share_error(response)
        } else {
            crate::operation_deser::parse_authorize_data_share_response(response)
        }
    }
}

/// Operation shape for `AuthorizeEndpointAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_endpoint_access`](crate::client::Client::authorize_endpoint_access).
///
/// See [`crate::client::fluent_builders::AuthorizeEndpointAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeEndpointAccess {
    _private: (),
}
impl AuthorizeEndpointAccess {
    /// Creates a new builder-style object to manufacture [`AuthorizeEndpointAccessInput`](crate::input::AuthorizeEndpointAccessInput)
    pub fn builder() -> crate::input::authorize_endpoint_access_input::Builder {
        crate::input::authorize_endpoint_access_input::Builder::default()
    }
    /// Creates a new `AuthorizeEndpointAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeEndpointAccess {
    type Output = std::result::Result<
        crate::output::AuthorizeEndpointAccessOutput,
        crate::error::AuthorizeEndpointAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_endpoint_access_error(response)
        } else {
            crate::operation_deser::parse_authorize_endpoint_access_response(response)
        }
    }
}

/// Operation shape for `AuthorizeSnapshotAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`authorize_snapshot_access`](crate::client::Client::authorize_snapshot_access).
///
/// See [`crate::client::fluent_builders::AuthorizeSnapshotAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AuthorizeSnapshotAccess {
    _private: (),
}
impl AuthorizeSnapshotAccess {
    /// Creates a new builder-style object to manufacture [`AuthorizeSnapshotAccessInput`](crate::input::AuthorizeSnapshotAccessInput)
    pub fn builder() -> crate::input::authorize_snapshot_access_input::Builder {
        crate::input::authorize_snapshot_access_input::Builder::default()
    }
    /// Creates a new `AuthorizeSnapshotAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AuthorizeSnapshotAccess {
    type Output = std::result::Result<
        crate::output::AuthorizeSnapshotAccessOutput,
        crate::error::AuthorizeSnapshotAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_authorize_snapshot_access_error(response)
        } else {
            crate::operation_deser::parse_authorize_snapshot_access_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteClusterSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_cluster_snapshots`](crate::client::Client::batch_delete_cluster_snapshots).
///
/// See [`crate::client::fluent_builders::BatchDeleteClusterSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteClusterSnapshots {
    _private: (),
}
impl BatchDeleteClusterSnapshots {
    /// Creates a new builder-style object to manufacture [`BatchDeleteClusterSnapshotsInput`](crate::input::BatchDeleteClusterSnapshotsInput)
    pub fn builder() -> crate::input::batch_delete_cluster_snapshots_input::Builder {
        crate::input::batch_delete_cluster_snapshots_input::Builder::default()
    }
    /// Creates a new `BatchDeleteClusterSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteClusterSnapshots {
    type Output = std::result::Result<
        crate::output::BatchDeleteClusterSnapshotsOutput,
        crate::error::BatchDeleteClusterSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_cluster_snapshots_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_cluster_snapshots_response(response)
        }
    }
}

/// Operation shape for `BatchModifyClusterSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_modify_cluster_snapshots`](crate::client::Client::batch_modify_cluster_snapshots).
///
/// See [`crate::client::fluent_builders::BatchModifyClusterSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchModifyClusterSnapshots {
    _private: (),
}
impl BatchModifyClusterSnapshots {
    /// Creates a new builder-style object to manufacture [`BatchModifyClusterSnapshotsInput`](crate::input::BatchModifyClusterSnapshotsInput)
    pub fn builder() -> crate::input::batch_modify_cluster_snapshots_input::Builder {
        crate::input::batch_modify_cluster_snapshots_input::Builder::default()
    }
    /// Creates a new `BatchModifyClusterSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchModifyClusterSnapshots {
    type Output = std::result::Result<
        crate::output::BatchModifyClusterSnapshotsOutput,
        crate::error::BatchModifyClusterSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_modify_cluster_snapshots_error(response)
        } else {
            crate::operation_deser::parse_batch_modify_cluster_snapshots_response(response)
        }
    }
}

/// Operation shape for `CancelResize`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_resize`](crate::client::Client::cancel_resize).
///
/// See [`crate::client::fluent_builders::CancelResize`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelResize {
    _private: (),
}
impl CancelResize {
    /// Creates a new builder-style object to manufacture [`CancelResizeInput`](crate::input::CancelResizeInput)
    pub fn builder() -> crate::input::cancel_resize_input::Builder {
        crate::input::cancel_resize_input::Builder::default()
    }
    /// Creates a new `CancelResize` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelResize {
    type Output =
        std::result::Result<crate::output::CancelResizeOutput, crate::error::CancelResizeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_resize_error(response)
        } else {
            crate::operation_deser::parse_cancel_resize_response(response)
        }
    }
}

/// Operation shape for `CopyClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_cluster_snapshot`](crate::client::Client::copy_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::CopyClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyClusterSnapshot {
    _private: (),
}
impl CopyClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`CopyClusterSnapshotInput`](crate::input::CopyClusterSnapshotInput)
    pub fn builder() -> crate::input::copy_cluster_snapshot_input::Builder {
        crate::input::copy_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `CopyClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyClusterSnapshot {
    type Output = std::result::Result<
        crate::output::CopyClusterSnapshotOutput,
        crate::error::CopyClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateAuthenticationProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_authentication_profile`](crate::client::Client::create_authentication_profile).
///
/// See [`crate::client::fluent_builders::CreateAuthenticationProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAuthenticationProfile {
    _private: (),
}
impl CreateAuthenticationProfile {
    /// Creates a new builder-style object to manufacture [`CreateAuthenticationProfileInput`](crate::input::CreateAuthenticationProfileInput)
    pub fn builder() -> crate::input::create_authentication_profile_input::Builder {
        crate::input::create_authentication_profile_input::Builder::default()
    }
    /// Creates a new `CreateAuthenticationProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAuthenticationProfile {
    type Output = std::result::Result<
        crate::output::CreateAuthenticationProfileOutput,
        crate::error::CreateAuthenticationProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_authentication_profile_error(response)
        } else {
            crate::operation_deser::parse_create_authentication_profile_response(response)
        }
    }
}

/// Operation shape for `CreateCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster`](crate::client::Client::create_cluster).
///
/// See [`crate::client::fluent_builders::CreateCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCluster {
    _private: (),
}
impl CreateCluster {
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
    /// Creates a new `CreateCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCluster {
    type Output =
        std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_response(response)
        }
    }
}

/// Operation shape for `CreateClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster_parameter_group`](crate::client::Client::create_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::CreateClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClusterParameterGroup {
    _private: (),
}
impl CreateClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`CreateClusterParameterGroupInput`](crate::input::CreateClusterParameterGroupInput)
    pub fn builder() -> crate::input::create_cluster_parameter_group_input::Builder {
        crate::input::create_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `CreateClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::CreateClusterParameterGroupOutput,
        crate::error::CreateClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `CreateClusterSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster_security_group`](crate::client::Client::create_cluster_security_group).
///
/// See [`crate::client::fluent_builders::CreateClusterSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClusterSecurityGroup {
    _private: (),
}
impl CreateClusterSecurityGroup {
    /// Creates a new builder-style object to manufacture [`CreateClusterSecurityGroupInput`](crate::input::CreateClusterSecurityGroupInput)
    pub fn builder() -> crate::input::create_cluster_security_group_input::Builder {
        crate::input::create_cluster_security_group_input::Builder::default()
    }
    /// Creates a new `CreateClusterSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClusterSecurityGroup {
    type Output = std::result::Result<
        crate::output::CreateClusterSecurityGroupOutput,
        crate::error::CreateClusterSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_security_group_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_security_group_response(response)
        }
    }
}

/// Operation shape for `CreateClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster_snapshot`](crate::client::Client::create_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::CreateClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClusterSnapshot {
    _private: (),
}
impl CreateClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateClusterSnapshotInput`](crate::input::CreateClusterSnapshotInput)
    pub fn builder() -> crate::input::create_cluster_snapshot_input::Builder {
        crate::input::create_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClusterSnapshot {
    type Output = std::result::Result<
        crate::output::CreateClusterSnapshotOutput,
        crate::error::CreateClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateClusterSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cluster_subnet_group`](crate::client::Client::create_cluster_subnet_group).
///
/// See [`crate::client::fluent_builders::CreateClusterSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClusterSubnetGroup {
    _private: (),
}
impl CreateClusterSubnetGroup {
    /// Creates a new builder-style object to manufacture [`CreateClusterSubnetGroupInput`](crate::input::CreateClusterSubnetGroupInput)
    pub fn builder() -> crate::input::create_cluster_subnet_group_input::Builder {
        crate::input::create_cluster_subnet_group_input::Builder::default()
    }
    /// Creates a new `CreateClusterSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClusterSubnetGroup {
    type Output = std::result::Result<
        crate::output::CreateClusterSubnetGroupOutput,
        crate::error::CreateClusterSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cluster_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_create_cluster_subnet_group_response(response)
        }
    }
}

/// Operation shape for `CreateEndpointAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_endpoint_access`](crate::client::Client::create_endpoint_access).
///
/// See [`crate::client::fluent_builders::CreateEndpointAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEndpointAccess {
    _private: (),
}
impl CreateEndpointAccess {
    /// Creates a new builder-style object to manufacture [`CreateEndpointAccessInput`](crate::input::CreateEndpointAccessInput)
    pub fn builder() -> crate::input::create_endpoint_access_input::Builder {
        crate::input::create_endpoint_access_input::Builder::default()
    }
    /// Creates a new `CreateEndpointAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEndpointAccess {
    type Output = std::result::Result<
        crate::output::CreateEndpointAccessOutput,
        crate::error::CreateEndpointAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_endpoint_access_error(response)
        } else {
            crate::operation_deser::parse_create_endpoint_access_response(response)
        }
    }
}

/// Operation shape for `CreateEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_subscription`](crate::client::Client::create_event_subscription).
///
/// See [`crate::client::fluent_builders::CreateEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventSubscription {
    _private: (),
}
impl CreateEventSubscription {
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
    /// Creates a new `CreateEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventSubscription {
    type Output = std::result::Result<
        crate::output::CreateEventSubscriptionOutput,
        crate::error::CreateEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_event_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateHsmClientCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hsm_client_certificate`](crate::client::Client::create_hsm_client_certificate).
///
/// See [`crate::client::fluent_builders::CreateHsmClientCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHsmClientCertificate {
    _private: (),
}
impl CreateHsmClientCertificate {
    /// Creates a new builder-style object to manufacture [`CreateHsmClientCertificateInput`](crate::input::CreateHsmClientCertificateInput)
    pub fn builder() -> crate::input::create_hsm_client_certificate_input::Builder {
        crate::input::create_hsm_client_certificate_input::Builder::default()
    }
    /// Creates a new `CreateHsmClientCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHsmClientCertificate {
    type Output = std::result::Result<
        crate::output::CreateHsmClientCertificateOutput,
        crate::error::CreateHsmClientCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_hsm_client_certificate_error(response)
        } else {
            crate::operation_deser::parse_create_hsm_client_certificate_response(response)
        }
    }
}

/// Operation shape for `CreateHsmConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hsm_configuration`](crate::client::Client::create_hsm_configuration).
///
/// See [`crate::client::fluent_builders::CreateHsmConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHsmConfiguration {
    _private: (),
}
impl CreateHsmConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateHsmConfigurationInput`](crate::input::CreateHsmConfigurationInput)
    pub fn builder() -> crate::input::create_hsm_configuration_input::Builder {
        crate::input::create_hsm_configuration_input::Builder::default()
    }
    /// Creates a new `CreateHsmConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHsmConfiguration {
    type Output = std::result::Result<
        crate::output::CreateHsmConfigurationOutput,
        crate::error::CreateHsmConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_hsm_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_hsm_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateScheduledAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_scheduled_action`](crate::client::Client::create_scheduled_action).
///
/// See [`crate::client::fluent_builders::CreateScheduledAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateScheduledAction {
    _private: (),
}
impl CreateScheduledAction {
    /// Creates a new builder-style object to manufacture [`CreateScheduledActionInput`](crate::input::CreateScheduledActionInput)
    pub fn builder() -> crate::input::create_scheduled_action_input::Builder {
        crate::input::create_scheduled_action_input::Builder::default()
    }
    /// Creates a new `CreateScheduledAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateScheduledAction {
    type Output = std::result::Result<
        crate::output::CreateScheduledActionOutput,
        crate::error::CreateScheduledActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_scheduled_action_error(response)
        } else {
            crate::operation_deser::parse_create_scheduled_action_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshotCopyGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot_copy_grant`](crate::client::Client::create_snapshot_copy_grant).
///
/// See [`crate::client::fluent_builders::CreateSnapshotCopyGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshotCopyGrant {
    _private: (),
}
impl CreateSnapshotCopyGrant {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotCopyGrantInput`](crate::input::CreateSnapshotCopyGrantInput)
    pub fn builder() -> crate::input::create_snapshot_copy_grant_input::Builder {
        crate::input::create_snapshot_copy_grant_input::Builder::default()
    }
    /// Creates a new `CreateSnapshotCopyGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshotCopyGrant {
    type Output = std::result::Result<
        crate::output::CreateSnapshotCopyGrantOutput,
        crate::error::CreateSnapshotCopyGrantError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_copy_grant_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_copy_grant_response(response)
        }
    }
}

/// Operation shape for `CreateSnapshotSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_snapshot_schedule`](crate::client::Client::create_snapshot_schedule).
///
/// See [`crate::client::fluent_builders::CreateSnapshotSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSnapshotSchedule {
    _private: (),
}
impl CreateSnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotScheduleInput`](crate::input::CreateSnapshotScheduleInput)
    pub fn builder() -> crate::input::create_snapshot_schedule_input::Builder {
        crate::input::create_snapshot_schedule_input::Builder::default()
    }
    /// Creates a new `CreateSnapshotSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSnapshotSchedule {
    type Output = std::result::Result<
        crate::output::CreateSnapshotScheduleOutput,
        crate::error::CreateSnapshotScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_snapshot_schedule_error(response)
        } else {
            crate::operation_deser::parse_create_snapshot_schedule_response(response)
        }
    }
}

/// Operation shape for `CreateTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tags`](crate::client::Client::create_tags).
///
/// See [`crate::client::fluent_builders::CreateTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTags {
    _private: (),
}
impl CreateTags {
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
    /// Creates a new `CreateTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTags {
    type Output =
        std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tags_error(response)
        } else {
            crate::operation_deser::parse_create_tags_response(response)
        }
    }
}

/// Operation shape for `CreateUsageLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_usage_limit`](crate::client::Client::create_usage_limit).
///
/// See [`crate::client::fluent_builders::CreateUsageLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUsageLimit {
    _private: (),
}
impl CreateUsageLimit {
    /// Creates a new builder-style object to manufacture [`CreateUsageLimitInput`](crate::input::CreateUsageLimitInput)
    pub fn builder() -> crate::input::create_usage_limit_input::Builder {
        crate::input::create_usage_limit_input::Builder::default()
    }
    /// Creates a new `CreateUsageLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUsageLimit {
    type Output = std::result::Result<
        crate::output::CreateUsageLimitOutput,
        crate::error::CreateUsageLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_usage_limit_error(response)
        } else {
            crate::operation_deser::parse_create_usage_limit_response(response)
        }
    }
}

/// Operation shape for `DeauthorizeDataShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deauthorize_data_share`](crate::client::Client::deauthorize_data_share).
///
/// See [`crate::client::fluent_builders::DeauthorizeDataShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeauthorizeDataShare {
    _private: (),
}
impl DeauthorizeDataShare {
    /// Creates a new builder-style object to manufacture [`DeauthorizeDataShareInput`](crate::input::DeauthorizeDataShareInput)
    pub fn builder() -> crate::input::deauthorize_data_share_input::Builder {
        crate::input::deauthorize_data_share_input::Builder::default()
    }
    /// Creates a new `DeauthorizeDataShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeauthorizeDataShare {
    type Output = std::result::Result<
        crate::output::DeauthorizeDataShareOutput,
        crate::error::DeauthorizeDataShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deauthorize_data_share_error(response)
        } else {
            crate::operation_deser::parse_deauthorize_data_share_response(response)
        }
    }
}

/// Operation shape for `DeleteAuthenticationProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_authentication_profile`](crate::client::Client::delete_authentication_profile).
///
/// See [`crate::client::fluent_builders::DeleteAuthenticationProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAuthenticationProfile {
    _private: (),
}
impl DeleteAuthenticationProfile {
    /// Creates a new builder-style object to manufacture [`DeleteAuthenticationProfileInput`](crate::input::DeleteAuthenticationProfileInput)
    pub fn builder() -> crate::input::delete_authentication_profile_input::Builder {
        crate::input::delete_authentication_profile_input::Builder::default()
    }
    /// Creates a new `DeleteAuthenticationProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAuthenticationProfile {
    type Output = std::result::Result<
        crate::output::DeleteAuthenticationProfileOutput,
        crate::error::DeleteAuthenticationProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_authentication_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_authentication_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster`](crate::client::Client::delete_cluster).
///
/// See [`crate::client::fluent_builders::DeleteCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCluster {
    _private: (),
}
impl DeleteCluster {
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
    /// Creates a new `DeleteCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCluster {
    type Output =
        std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_response(response)
        }
    }
}

/// Operation shape for `DeleteClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster_parameter_group`](crate::client::Client::delete_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::DeleteClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClusterParameterGroup {
    _private: (),
}
impl DeleteClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`DeleteClusterParameterGroupInput`](crate::input::DeleteClusterParameterGroupInput)
    pub fn builder() -> crate::input::delete_cluster_parameter_group_input::Builder {
        crate::input::delete_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `DeleteClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::DeleteClusterParameterGroupOutput,
        crate::error::DeleteClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `DeleteClusterSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster_security_group`](crate::client::Client::delete_cluster_security_group).
///
/// See [`crate::client::fluent_builders::DeleteClusterSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClusterSecurityGroup {
    _private: (),
}
impl DeleteClusterSecurityGroup {
    /// Creates a new builder-style object to manufacture [`DeleteClusterSecurityGroupInput`](crate::input::DeleteClusterSecurityGroupInput)
    pub fn builder() -> crate::input::delete_cluster_security_group_input::Builder {
        crate::input::delete_cluster_security_group_input::Builder::default()
    }
    /// Creates a new `DeleteClusterSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClusterSecurityGroup {
    type Output = std::result::Result<
        crate::output::DeleteClusterSecurityGroupOutput,
        crate::error::DeleteClusterSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_security_group_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_security_group_response(response)
        }
    }
}

/// Operation shape for `DeleteClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster_snapshot`](crate::client::Client::delete_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClusterSnapshot {
    _private: (),
}
impl DeleteClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteClusterSnapshotInput`](crate::input::DeleteClusterSnapshotInput)
    pub fn builder() -> crate::input::delete_cluster_snapshot_input::Builder {
        crate::input::delete_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClusterSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteClusterSnapshotOutput,
        crate::error::DeleteClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteClusterSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cluster_subnet_group`](crate::client::Client::delete_cluster_subnet_group).
///
/// See [`crate::client::fluent_builders::DeleteClusterSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteClusterSubnetGroup {
    _private: (),
}
impl DeleteClusterSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DeleteClusterSubnetGroupInput`](crate::input::DeleteClusterSubnetGroupInput)
    pub fn builder() -> crate::input::delete_cluster_subnet_group_input::Builder {
        crate::input::delete_cluster_subnet_group_input::Builder::default()
    }
    /// Creates a new `DeleteClusterSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteClusterSubnetGroup {
    type Output = std::result::Result<
        crate::output::DeleteClusterSubnetGroupOutput,
        crate::error::DeleteClusterSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cluster_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_delete_cluster_subnet_group_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpointAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint_access`](crate::client::Client::delete_endpoint_access).
///
/// See [`crate::client::fluent_builders::DeleteEndpointAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpointAccess {
    _private: (),
}
impl DeleteEndpointAccess {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointAccessInput`](crate::input::DeleteEndpointAccessInput)
    pub fn builder() -> crate::input::delete_endpoint_access_input::Builder {
        crate::input::delete_endpoint_access_input::Builder::default()
    }
    /// Creates a new `DeleteEndpointAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpointAccess {
    type Output = std::result::Result<
        crate::output::DeleteEndpointAccessOutput,
        crate::error::DeleteEndpointAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_access_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_access_response(response)
        }
    }
}

/// Operation shape for `DeleteEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_subscription`](crate::client::Client::delete_event_subscription).
///
/// See [`crate::client::fluent_builders::DeleteEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventSubscription {
    _private: (),
}
impl DeleteEventSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventSubscription {
    type Output = std::result::Result<
        crate::output::DeleteEventSubscriptionOutput,
        crate::error::DeleteEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_event_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteHsmClientCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_hsm_client_certificate`](crate::client::Client::delete_hsm_client_certificate).
///
/// See [`crate::client::fluent_builders::DeleteHsmClientCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHsmClientCertificate {
    _private: (),
}
impl DeleteHsmClientCertificate {
    /// Creates a new builder-style object to manufacture [`DeleteHsmClientCertificateInput`](crate::input::DeleteHsmClientCertificateInput)
    pub fn builder() -> crate::input::delete_hsm_client_certificate_input::Builder {
        crate::input::delete_hsm_client_certificate_input::Builder::default()
    }
    /// Creates a new `DeleteHsmClientCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHsmClientCertificate {
    type Output = std::result::Result<
        crate::output::DeleteHsmClientCertificateOutput,
        crate::error::DeleteHsmClientCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_hsm_client_certificate_error(response)
        } else {
            crate::operation_deser::parse_delete_hsm_client_certificate_response(response)
        }
    }
}

/// Operation shape for `DeleteHsmConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_hsm_configuration`](crate::client::Client::delete_hsm_configuration).
///
/// See [`crate::client::fluent_builders::DeleteHsmConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHsmConfiguration {
    _private: (),
}
impl DeleteHsmConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteHsmConfigurationInput`](crate::input::DeleteHsmConfigurationInput)
    pub fn builder() -> crate::input::delete_hsm_configuration_input::Builder {
        crate::input::delete_hsm_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteHsmConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHsmConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteHsmConfigurationOutput,
        crate::error::DeleteHsmConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_hsm_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_hsm_configuration_response(response)
        }
    }
}

/// Operation shape for `DeletePartner`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_partner`](crate::client::Client::delete_partner).
///
/// See [`crate::client::fluent_builders::DeletePartner`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePartner {
    _private: (),
}
impl DeletePartner {
    /// Creates a new builder-style object to manufacture [`DeletePartnerInput`](crate::input::DeletePartnerInput)
    pub fn builder() -> crate::input::delete_partner_input::Builder {
        crate::input::delete_partner_input::Builder::default()
    }
    /// Creates a new `DeletePartner` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePartner {
    type Output =
        std::result::Result<crate::output::DeletePartnerOutput, crate::error::DeletePartnerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_partner_error(response)
        } else {
            crate::operation_deser::parse_delete_partner_response(response)
        }
    }
}

/// Operation shape for `DeleteScheduledAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_scheduled_action`](crate::client::Client::delete_scheduled_action).
///
/// See [`crate::client::fluent_builders::DeleteScheduledAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteScheduledAction {
    _private: (),
}
impl DeleteScheduledAction {
    /// Creates a new builder-style object to manufacture [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
    pub fn builder() -> crate::input::delete_scheduled_action_input::Builder {
        crate::input::delete_scheduled_action_input::Builder::default()
    }
    /// Creates a new `DeleteScheduledAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteScheduledAction {
    type Output = std::result::Result<
        crate::output::DeleteScheduledActionOutput,
        crate::error::DeleteScheduledActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_scheduled_action_error(response)
        } else {
            crate::operation_deser::parse_delete_scheduled_action_response(response)
        }
    }
}

/// Operation shape for `DeleteSnapshotCopyGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_snapshot_copy_grant`](crate::client::Client::delete_snapshot_copy_grant).
///
/// See [`crate::client::fluent_builders::DeleteSnapshotCopyGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSnapshotCopyGrant {
    _private: (),
}
impl DeleteSnapshotCopyGrant {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotCopyGrantInput`](crate::input::DeleteSnapshotCopyGrantInput)
    pub fn builder() -> crate::input::delete_snapshot_copy_grant_input::Builder {
        crate::input::delete_snapshot_copy_grant_input::Builder::default()
    }
    /// Creates a new `DeleteSnapshotCopyGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSnapshotCopyGrant {
    type Output = std::result::Result<
        crate::output::DeleteSnapshotCopyGrantOutput,
        crate::error::DeleteSnapshotCopyGrantError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_snapshot_copy_grant_error(response)
        } else {
            crate::operation_deser::parse_delete_snapshot_copy_grant_response(response)
        }
    }
}

/// Operation shape for `DeleteSnapshotSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_snapshot_schedule`](crate::client::Client::delete_snapshot_schedule).
///
/// See [`crate::client::fluent_builders::DeleteSnapshotSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSnapshotSchedule {
    _private: (),
}
impl DeleteSnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
    pub fn builder() -> crate::input::delete_snapshot_schedule_input::Builder {
        crate::input::delete_snapshot_schedule_input::Builder::default()
    }
    /// Creates a new `DeleteSnapshotSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSnapshotSchedule {
    type Output = std::result::Result<
        crate::output::DeleteSnapshotScheduleOutput,
        crate::error::DeleteSnapshotScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_snapshot_schedule_error(response)
        } else {
            crate::operation_deser::parse_delete_snapshot_schedule_response(response)
        }
    }
}

/// Operation shape for `DeleteTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tags`](crate::client::Client::delete_tags).
///
/// See [`crate::client::fluent_builders::DeleteTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTags {
    _private: (),
}
impl DeleteTags {
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
    /// Creates a new `DeleteTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTags {
    type Output =
        std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tags_error(response)
        } else {
            crate::operation_deser::parse_delete_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteUsageLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_usage_limit`](crate::client::Client::delete_usage_limit).
///
/// See [`crate::client::fluent_builders::DeleteUsageLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUsageLimit {
    _private: (),
}
impl DeleteUsageLimit {
    /// Creates a new builder-style object to manufacture [`DeleteUsageLimitInput`](crate::input::DeleteUsageLimitInput)
    pub fn builder() -> crate::input::delete_usage_limit_input::Builder {
        crate::input::delete_usage_limit_input::Builder::default()
    }
    /// Creates a new `DeleteUsageLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUsageLimit {
    type Output = std::result::Result<
        crate::output::DeleteUsageLimitOutput,
        crate::error::DeleteUsageLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_usage_limit_error(response)
        } else {
            crate::operation_deser::parse_delete_usage_limit_response(response)
        }
    }
}

/// Operation shape for `DescribeAccountAttributes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_account_attributes`](crate::client::Client::describe_account_attributes).
///
/// See [`crate::client::fluent_builders::DescribeAccountAttributes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAccountAttributes {
    _private: (),
}
impl DescribeAccountAttributes {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
    /// Creates a new `DescribeAccountAttributes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAccountAttributes {
    type Output = std::result::Result<
        crate::output::DescribeAccountAttributesOutput,
        crate::error::DescribeAccountAttributesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_account_attributes_error(response)
        } else {
            crate::operation_deser::parse_describe_account_attributes_response(response)
        }
    }
}

/// Operation shape for `DescribeAuthenticationProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_authentication_profiles`](crate::client::Client::describe_authentication_profiles).
///
/// See [`crate::client::fluent_builders::DescribeAuthenticationProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAuthenticationProfiles {
    _private: (),
}
impl DescribeAuthenticationProfiles {
    /// Creates a new builder-style object to manufacture [`DescribeAuthenticationProfilesInput`](crate::input::DescribeAuthenticationProfilesInput)
    pub fn builder() -> crate::input::describe_authentication_profiles_input::Builder {
        crate::input::describe_authentication_profiles_input::Builder::default()
    }
    /// Creates a new `DescribeAuthenticationProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAuthenticationProfiles {
    type Output = std::result::Result<
        crate::output::DescribeAuthenticationProfilesOutput,
        crate::error::DescribeAuthenticationProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_authentication_profiles_error(response)
        } else {
            crate::operation_deser::parse_describe_authentication_profiles_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterDbRevisions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_db_revisions`](crate::client::Client::describe_cluster_db_revisions).
///
/// See [`crate::client::fluent_builders::DescribeClusterDbRevisions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterDbRevisions {
    _private: (),
}
impl DescribeClusterDbRevisions {
    /// Creates a new builder-style object to manufacture [`DescribeClusterDbRevisionsInput`](crate::input::DescribeClusterDbRevisionsInput)
    pub fn builder() -> crate::input::describe_cluster_db_revisions_input::Builder {
        crate::input::describe_cluster_db_revisions_input::Builder::default()
    }
    /// Creates a new `DescribeClusterDbRevisions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterDbRevisions {
    type Output = std::result::Result<
        crate::output::DescribeClusterDbRevisionsOutput,
        crate::error::DescribeClusterDbRevisionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_db_revisions_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_db_revisions_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterParameterGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_parameter_groups`](crate::client::Client::describe_cluster_parameter_groups).
///
/// See [`crate::client::fluent_builders::DescribeClusterParameterGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterParameterGroups {
    _private: (),
}
impl DescribeClusterParameterGroups {
    /// Creates a new builder-style object to manufacture [`DescribeClusterParameterGroupsInput`](crate::input::DescribeClusterParameterGroupsInput)
    pub fn builder() -> crate::input::describe_cluster_parameter_groups_input::Builder {
        crate::input::describe_cluster_parameter_groups_input::Builder::default()
    }
    /// Creates a new `DescribeClusterParameterGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterParameterGroups {
    type Output = std::result::Result<
        crate::output::DescribeClusterParameterGroupsOutput,
        crate::error::DescribeClusterParameterGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_parameter_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_parameter_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_parameters`](crate::client::Client::describe_cluster_parameters).
///
/// See [`crate::client::fluent_builders::DescribeClusterParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterParameters {
    _private: (),
}
impl DescribeClusterParameters {
    /// Creates a new builder-style object to manufacture [`DescribeClusterParametersInput`](crate::input::DescribeClusterParametersInput)
    pub fn builder() -> crate::input::describe_cluster_parameters_input::Builder {
        crate::input::describe_cluster_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeClusterParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterParameters {
    type Output = std::result::Result<
        crate::output::DescribeClusterParametersOutput,
        crate::error::DescribeClusterParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeClusters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_clusters`](crate::client::Client::describe_clusters).
///
/// See [`crate::client::fluent_builders::DescribeClusters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusters {
    _private: (),
}
impl DescribeClusters {
    /// Creates a new builder-style object to manufacture [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    pub fn builder() -> crate::input::describe_clusters_input::Builder {
        crate::input::describe_clusters_input::Builder::default()
    }
    /// Creates a new `DescribeClusters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusters {
    type Output = std::result::Result<
        crate::output::DescribeClustersOutput,
        crate::error::DescribeClustersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_clusters_error(response)
        } else {
            crate::operation_deser::parse_describe_clusters_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_security_groups`](crate::client::Client::describe_cluster_security_groups).
///
/// See [`crate::client::fluent_builders::DescribeClusterSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterSecurityGroups {
    _private: (),
}
impl DescribeClusterSecurityGroups {
    /// Creates a new builder-style object to manufacture [`DescribeClusterSecurityGroupsInput`](crate::input::DescribeClusterSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_cluster_security_groups_input::Builder {
        crate::input::describe_cluster_security_groups_input::Builder::default()
    }
    /// Creates a new `DescribeClusterSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterSecurityGroups {
    type Output = std::result::Result<
        crate::output::DescribeClusterSecurityGroupsOutput,
        crate::error::DescribeClusterSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_security_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_security_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_snapshots`](crate::client::Client::describe_cluster_snapshots).
///
/// See [`crate::client::fluent_builders::DescribeClusterSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterSnapshots {
    _private: (),
}
impl DescribeClusterSnapshots {
    /// Creates a new builder-style object to manufacture [`DescribeClusterSnapshotsInput`](crate::input::DescribeClusterSnapshotsInput)
    pub fn builder() -> crate::input::describe_cluster_snapshots_input::Builder {
        crate::input::describe_cluster_snapshots_input::Builder::default()
    }
    /// Creates a new `DescribeClusterSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterSnapshots {
    type Output = std::result::Result<
        crate::output::DescribeClusterSnapshotsOutput,
        crate::error::DescribeClusterSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_snapshots_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_snapshots_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterSubnetGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_subnet_groups`](crate::client::Client::describe_cluster_subnet_groups).
///
/// See [`crate::client::fluent_builders::DescribeClusterSubnetGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterSubnetGroups {
    _private: (),
}
impl DescribeClusterSubnetGroups {
    /// Creates a new builder-style object to manufacture [`DescribeClusterSubnetGroupsInput`](crate::input::DescribeClusterSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_cluster_subnet_groups_input::Builder {
        crate::input::describe_cluster_subnet_groups_input::Builder::default()
    }
    /// Creates a new `DescribeClusterSubnetGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterSubnetGroups {
    type Output = std::result::Result<
        crate::output::DescribeClusterSubnetGroupsOutput,
        crate::error::DescribeClusterSubnetGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_subnet_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_subnet_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterTracks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_tracks`](crate::client::Client::describe_cluster_tracks).
///
/// See [`crate::client::fluent_builders::DescribeClusterTracks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterTracks {
    _private: (),
}
impl DescribeClusterTracks {
    /// Creates a new builder-style object to manufacture [`DescribeClusterTracksInput`](crate::input::DescribeClusterTracksInput)
    pub fn builder() -> crate::input::describe_cluster_tracks_input::Builder {
        crate::input::describe_cluster_tracks_input::Builder::default()
    }
    /// Creates a new `DescribeClusterTracks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterTracks {
    type Output = std::result::Result<
        crate::output::DescribeClusterTracksOutput,
        crate::error::DescribeClusterTracksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_tracks_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_tracks_response(response)
        }
    }
}

/// Operation shape for `DescribeClusterVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cluster_versions`](crate::client::Client::describe_cluster_versions).
///
/// See [`crate::client::fluent_builders::DescribeClusterVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClusterVersions {
    _private: (),
}
impl DescribeClusterVersions {
    /// Creates a new builder-style object to manufacture [`DescribeClusterVersionsInput`](crate::input::DescribeClusterVersionsInput)
    pub fn builder() -> crate::input::describe_cluster_versions_input::Builder {
        crate::input::describe_cluster_versions_input::Builder::default()
    }
    /// Creates a new `DescribeClusterVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClusterVersions {
    type Output = std::result::Result<
        crate::output::DescribeClusterVersionsOutput,
        crate::error::DescribeClusterVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cluster_versions_error(response)
        } else {
            crate::operation_deser::parse_describe_cluster_versions_response(response)
        }
    }
}

/// Operation shape for `DescribeDataShares`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_shares`](crate::client::Client::describe_data_shares).
///
/// See [`crate::client::fluent_builders::DescribeDataShares`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataShares {
    _private: (),
}
impl DescribeDataShares {
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesInput`](crate::input::DescribeDataSharesInput)
    pub fn builder() -> crate::input::describe_data_shares_input::Builder {
        crate::input::describe_data_shares_input::Builder::default()
    }
    /// Creates a new `DescribeDataShares` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataShares {
    type Output = std::result::Result<
        crate::output::DescribeDataSharesOutput,
        crate::error::DescribeDataSharesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_shares_error(response)
        } else {
            crate::operation_deser::parse_describe_data_shares_response(response)
        }
    }
}

/// Operation shape for `DescribeDataSharesForConsumer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_shares_for_consumer`](crate::client::Client::describe_data_shares_for_consumer).
///
/// See [`crate::client::fluent_builders::DescribeDataSharesForConsumer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataSharesForConsumer {
    _private: (),
}
impl DescribeDataSharesForConsumer {
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesForConsumerInput`](crate::input::DescribeDataSharesForConsumerInput)
    pub fn builder() -> crate::input::describe_data_shares_for_consumer_input::Builder {
        crate::input::describe_data_shares_for_consumer_input::Builder::default()
    }
    /// Creates a new `DescribeDataSharesForConsumer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataSharesForConsumer {
    type Output = std::result::Result<
        crate::output::DescribeDataSharesForConsumerOutput,
        crate::error::DescribeDataSharesForConsumerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_shares_for_consumer_error(response)
        } else {
            crate::operation_deser::parse_describe_data_shares_for_consumer_response(response)
        }
    }
}

/// Operation shape for `DescribeDataSharesForProducer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_shares_for_producer`](crate::client::Client::describe_data_shares_for_producer).
///
/// See [`crate::client::fluent_builders::DescribeDataSharesForProducer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataSharesForProducer {
    _private: (),
}
impl DescribeDataSharesForProducer {
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesForProducerInput`](crate::input::DescribeDataSharesForProducerInput)
    pub fn builder() -> crate::input::describe_data_shares_for_producer_input::Builder {
        crate::input::describe_data_shares_for_producer_input::Builder::default()
    }
    /// Creates a new `DescribeDataSharesForProducer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataSharesForProducer {
    type Output = std::result::Result<
        crate::output::DescribeDataSharesForProducerOutput,
        crate::error::DescribeDataSharesForProducerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_shares_for_producer_error(response)
        } else {
            crate::operation_deser::parse_describe_data_shares_for_producer_response(response)
        }
    }
}

/// Operation shape for `DescribeDefaultClusterParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_default_cluster_parameters`](crate::client::Client::describe_default_cluster_parameters).
///
/// See [`crate::client::fluent_builders::DescribeDefaultClusterParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDefaultClusterParameters {
    _private: (),
}
impl DescribeDefaultClusterParameters {
    /// Creates a new builder-style object to manufacture [`DescribeDefaultClusterParametersInput`](crate::input::DescribeDefaultClusterParametersInput)
    pub fn builder() -> crate::input::describe_default_cluster_parameters_input::Builder {
        crate::input::describe_default_cluster_parameters_input::Builder::default()
    }
    /// Creates a new `DescribeDefaultClusterParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDefaultClusterParameters {
    type Output = std::result::Result<
        crate::output::DescribeDefaultClusterParametersOutput,
        crate::error::DescribeDefaultClusterParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_default_cluster_parameters_error(response)
        } else {
            crate::operation_deser::parse_describe_default_cluster_parameters_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpointAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint_access`](crate::client::Client::describe_endpoint_access).
///
/// See [`crate::client::fluent_builders::DescribeEndpointAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpointAccess {
    _private: (),
}
impl DescribeEndpointAccess {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointAccessInput`](crate::input::DescribeEndpointAccessInput)
    pub fn builder() -> crate::input::describe_endpoint_access_input::Builder {
        crate::input::describe_endpoint_access_input::Builder::default()
    }
    /// Creates a new `DescribeEndpointAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpointAccess {
    type Output = std::result::Result<
        crate::output::DescribeEndpointAccessOutput,
        crate::error::DescribeEndpointAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_access_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_access_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpointAuthorization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint_authorization`](crate::client::Client::describe_endpoint_authorization).
///
/// See [`crate::client::fluent_builders::DescribeEndpointAuthorization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpointAuthorization {
    _private: (),
}
impl DescribeEndpointAuthorization {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointAuthorizationInput`](crate::input::DescribeEndpointAuthorizationInput)
    pub fn builder() -> crate::input::describe_endpoint_authorization_input::Builder {
        crate::input::describe_endpoint_authorization_input::Builder::default()
    }
    /// Creates a new `DescribeEndpointAuthorization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpointAuthorization {
    type Output = std::result::Result<
        crate::output::DescribeEndpointAuthorizationOutput,
        crate::error::DescribeEndpointAuthorizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_authorization_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_authorization_response(response)
        }
    }
}

/// Operation shape for `DescribeEventCategories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_categories`](crate::client::Client::describe_event_categories).
///
/// See [`crate::client::fluent_builders::DescribeEventCategories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventCategories {
    _private: (),
}
impl DescribeEventCategories {
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
    /// Creates a new `DescribeEventCategories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventCategories {
    type Output = std::result::Result<
        crate::output::DescribeEventCategoriesOutput,
        crate::error::DescribeEventCategoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_categories_error(response)
        } else {
            crate::operation_deser::parse_describe_event_categories_response(response)
        }
    }
}

/// Operation shape for `DescribeEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_events`](crate::client::Client::describe_events).
///
/// See [`crate::client::fluent_builders::DescribeEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEvents {
    _private: (),
}
impl DescribeEvents {
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
    /// Creates a new `DescribeEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEvents {
    type Output =
        std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_events_error(response)
        } else {
            crate::operation_deser::parse_describe_events_response(response)
        }
    }
}

/// Operation shape for `DescribeEventSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_event_subscriptions`](crate::client::Client::describe_event_subscriptions).
///
/// See [`crate::client::fluent_builders::DescribeEventSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEventSubscriptions {
    _private: (),
}
impl DescribeEventSubscriptions {
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
    /// Creates a new `DescribeEventSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEventSubscriptions {
    type Output = std::result::Result<
        crate::output::DescribeEventSubscriptionsOutput,
        crate::error::DescribeEventSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_event_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_describe_event_subscriptions_response(response)
        }
    }
}

/// Operation shape for `DescribeHsmClientCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_hsm_client_certificates`](crate::client::Client::describe_hsm_client_certificates).
///
/// See [`crate::client::fluent_builders::DescribeHsmClientCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHsmClientCertificates {
    _private: (),
}
impl DescribeHsmClientCertificates {
    /// Creates a new builder-style object to manufacture [`DescribeHsmClientCertificatesInput`](crate::input::DescribeHsmClientCertificatesInput)
    pub fn builder() -> crate::input::describe_hsm_client_certificates_input::Builder {
        crate::input::describe_hsm_client_certificates_input::Builder::default()
    }
    /// Creates a new `DescribeHsmClientCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHsmClientCertificates {
    type Output = std::result::Result<
        crate::output::DescribeHsmClientCertificatesOutput,
        crate::error::DescribeHsmClientCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_hsm_client_certificates_error(response)
        } else {
            crate::operation_deser::parse_describe_hsm_client_certificates_response(response)
        }
    }
}

/// Operation shape for `DescribeHsmConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_hsm_configurations`](crate::client::Client::describe_hsm_configurations).
///
/// See [`crate::client::fluent_builders::DescribeHsmConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHsmConfigurations {
    _private: (),
}
impl DescribeHsmConfigurations {
    /// Creates a new builder-style object to manufacture [`DescribeHsmConfigurationsInput`](crate::input::DescribeHsmConfigurationsInput)
    pub fn builder() -> crate::input::describe_hsm_configurations_input::Builder {
        crate::input::describe_hsm_configurations_input::Builder::default()
    }
    /// Creates a new `DescribeHsmConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHsmConfigurations {
    type Output = std::result::Result<
        crate::output::DescribeHsmConfigurationsOutput,
        crate::error::DescribeHsmConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_hsm_configurations_error(response)
        } else {
            crate::operation_deser::parse_describe_hsm_configurations_response(response)
        }
    }
}

/// Operation shape for `DescribeLoggingStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_logging_status`](crate::client::Client::describe_logging_status).
///
/// See [`crate::client::fluent_builders::DescribeLoggingStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLoggingStatus {
    _private: (),
}
impl DescribeLoggingStatus {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingStatusInput`](crate::input::DescribeLoggingStatusInput)
    pub fn builder() -> crate::input::describe_logging_status_input::Builder {
        crate::input::describe_logging_status_input::Builder::default()
    }
    /// Creates a new `DescribeLoggingStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLoggingStatus {
    type Output = std::result::Result<
        crate::output::DescribeLoggingStatusOutput,
        crate::error::DescribeLoggingStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_logging_status_error(response)
        } else {
            crate::operation_deser::parse_describe_logging_status_response(response)
        }
    }
}

/// Operation shape for `DescribeNodeConfigurationOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_node_configuration_options`](crate::client::Client::describe_node_configuration_options).
///
/// See [`crate::client::fluent_builders::DescribeNodeConfigurationOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNodeConfigurationOptions {
    _private: (),
}
impl DescribeNodeConfigurationOptions {
    /// Creates a new builder-style object to manufacture [`DescribeNodeConfigurationOptionsInput`](crate::input::DescribeNodeConfigurationOptionsInput)
    pub fn builder() -> crate::input::describe_node_configuration_options_input::Builder {
        crate::input::describe_node_configuration_options_input::Builder::default()
    }
    /// Creates a new `DescribeNodeConfigurationOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNodeConfigurationOptions {
    type Output = std::result::Result<
        crate::output::DescribeNodeConfigurationOptionsOutput,
        crate::error::DescribeNodeConfigurationOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_node_configuration_options_error(response)
        } else {
            crate::operation_deser::parse_describe_node_configuration_options_response(response)
        }
    }
}

/// Operation shape for `DescribeOrderableClusterOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_orderable_cluster_options`](crate::client::Client::describe_orderable_cluster_options).
///
/// See [`crate::client::fluent_builders::DescribeOrderableClusterOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrderableClusterOptions {
    _private: (),
}
impl DescribeOrderableClusterOptions {
    /// Creates a new builder-style object to manufacture [`DescribeOrderableClusterOptionsInput`](crate::input::DescribeOrderableClusterOptionsInput)
    pub fn builder() -> crate::input::describe_orderable_cluster_options_input::Builder {
        crate::input::describe_orderable_cluster_options_input::Builder::default()
    }
    /// Creates a new `DescribeOrderableClusterOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrderableClusterOptions {
    type Output = std::result::Result<
        crate::output::DescribeOrderableClusterOptionsOutput,
        crate::error::DescribeOrderableClusterOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_orderable_cluster_options_error(response)
        } else {
            crate::operation_deser::parse_describe_orderable_cluster_options_response(response)
        }
    }
}

/// Operation shape for `DescribePartners`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_partners`](crate::client::Client::describe_partners).
///
/// See [`crate::client::fluent_builders::DescribePartners`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePartners {
    _private: (),
}
impl DescribePartners {
    /// Creates a new builder-style object to manufacture [`DescribePartnersInput`](crate::input::DescribePartnersInput)
    pub fn builder() -> crate::input::describe_partners_input::Builder {
        crate::input::describe_partners_input::Builder::default()
    }
    /// Creates a new `DescribePartners` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePartners {
    type Output = std::result::Result<
        crate::output::DescribePartnersOutput,
        crate::error::DescribePartnersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_partners_error(response)
        } else {
            crate::operation_deser::parse_describe_partners_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedNodeExchangeStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_node_exchange_status`](crate::client::Client::describe_reserved_node_exchange_status).
///
/// See [`crate::client::fluent_builders::DescribeReservedNodeExchangeStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedNodeExchangeStatus {
    _private: (),
}
impl DescribeReservedNodeExchangeStatus {
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodeExchangeStatusInput`](crate::input::DescribeReservedNodeExchangeStatusInput)
    pub fn builder() -> crate::input::describe_reserved_node_exchange_status_input::Builder {
        crate::input::describe_reserved_node_exchange_status_input::Builder::default()
    }
    /// Creates a new `DescribeReservedNodeExchangeStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedNodeExchangeStatus {
    type Output = std::result::Result<
        crate::output::DescribeReservedNodeExchangeStatusOutput,
        crate::error::DescribeReservedNodeExchangeStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_node_exchange_status_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_node_exchange_status_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedNodeOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_node_offerings`](crate::client::Client::describe_reserved_node_offerings).
///
/// See [`crate::client::fluent_builders::DescribeReservedNodeOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedNodeOfferings {
    _private: (),
}
impl DescribeReservedNodeOfferings {
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodeOfferingsInput`](crate::input::DescribeReservedNodeOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_node_offerings_input::Builder {
        crate::input::describe_reserved_node_offerings_input::Builder::default()
    }
    /// Creates a new `DescribeReservedNodeOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedNodeOfferings {
    type Output = std::result::Result<
        crate::output::DescribeReservedNodeOfferingsOutput,
        crate::error::DescribeReservedNodeOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_node_offerings_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_node_offerings_response(response)
        }
    }
}

/// Operation shape for `DescribeReservedNodes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reserved_nodes`](crate::client::Client::describe_reserved_nodes).
///
/// See [`crate::client::fluent_builders::DescribeReservedNodes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservedNodes {
    _private: (),
}
impl DescribeReservedNodes {
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodesInput`](crate::input::DescribeReservedNodesInput)
    pub fn builder() -> crate::input::describe_reserved_nodes_input::Builder {
        crate::input::describe_reserved_nodes_input::Builder::default()
    }
    /// Creates a new `DescribeReservedNodes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservedNodes {
    type Output = std::result::Result<
        crate::output::DescribeReservedNodesOutput,
        crate::error::DescribeReservedNodesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reserved_nodes_error(response)
        } else {
            crate::operation_deser::parse_describe_reserved_nodes_response(response)
        }
    }
}

/// Operation shape for `DescribeResize`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resize`](crate::client::Client::describe_resize).
///
/// See [`crate::client::fluent_builders::DescribeResize`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResize {
    _private: (),
}
impl DescribeResize {
    /// Creates a new builder-style object to manufacture [`DescribeResizeInput`](crate::input::DescribeResizeInput)
    pub fn builder() -> crate::input::describe_resize_input::Builder {
        crate::input::describe_resize_input::Builder::default()
    }
    /// Creates a new `DescribeResize` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResize {
    type Output =
        std::result::Result<crate::output::DescribeResizeOutput, crate::error::DescribeResizeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resize_error(response)
        } else {
            crate::operation_deser::parse_describe_resize_response(response)
        }
    }
}

/// Operation shape for `DescribeScheduledActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_scheduled_actions`](crate::client::Client::describe_scheduled_actions).
///
/// See [`crate::client::fluent_builders::DescribeScheduledActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeScheduledActions {
    _private: (),
}
impl DescribeScheduledActions {
    /// Creates a new builder-style object to manufacture [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
    pub fn builder() -> crate::input::describe_scheduled_actions_input::Builder {
        crate::input::describe_scheduled_actions_input::Builder::default()
    }
    /// Creates a new `DescribeScheduledActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeScheduledActions {
    type Output = std::result::Result<
        crate::output::DescribeScheduledActionsOutput,
        crate::error::DescribeScheduledActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_scheduled_actions_error(response)
        } else {
            crate::operation_deser::parse_describe_scheduled_actions_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshotCopyGrants`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshot_copy_grants`](crate::client::Client::describe_snapshot_copy_grants).
///
/// See [`crate::client::fluent_builders::DescribeSnapshotCopyGrants`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshotCopyGrants {
    _private: (),
}
impl DescribeSnapshotCopyGrants {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotCopyGrantsInput`](crate::input::DescribeSnapshotCopyGrantsInput)
    pub fn builder() -> crate::input::describe_snapshot_copy_grants_input::Builder {
        crate::input::describe_snapshot_copy_grants_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshotCopyGrants` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshotCopyGrants {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotCopyGrantsOutput,
        crate::error::DescribeSnapshotCopyGrantsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshot_copy_grants_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshot_copy_grants_response(response)
        }
    }
}

/// Operation shape for `DescribeSnapshotSchedules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_snapshot_schedules`](crate::client::Client::describe_snapshot_schedules).
///
/// See [`crate::client::fluent_builders::DescribeSnapshotSchedules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSnapshotSchedules {
    _private: (),
}
impl DescribeSnapshotSchedules {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotSchedulesInput`](crate::input::DescribeSnapshotSchedulesInput)
    pub fn builder() -> crate::input::describe_snapshot_schedules_input::Builder {
        crate::input::describe_snapshot_schedules_input::Builder::default()
    }
    /// Creates a new `DescribeSnapshotSchedules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSnapshotSchedules {
    type Output = std::result::Result<
        crate::output::DescribeSnapshotSchedulesOutput,
        crate::error::DescribeSnapshotSchedulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_snapshot_schedules_error(response)
        } else {
            crate::operation_deser::parse_describe_snapshot_schedules_response(response)
        }
    }
}

/// Operation shape for `DescribeStorage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_storage`](crate::client::Client::describe_storage).
///
/// See [`crate::client::fluent_builders::DescribeStorage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStorage {
    _private: (),
}
impl DescribeStorage {
    /// Creates a new builder-style object to manufacture [`DescribeStorageInput`](crate::input::DescribeStorageInput)
    pub fn builder() -> crate::input::describe_storage_input::Builder {
        crate::input::describe_storage_input::Builder::default()
    }
    /// Creates a new `DescribeStorage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStorage {
    type Output = std::result::Result<
        crate::output::DescribeStorageOutput,
        crate::error::DescribeStorageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_storage_error(response)
        } else {
            crate::operation_deser::parse_describe_storage_response(response)
        }
    }
}

/// Operation shape for `DescribeTableRestoreStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_table_restore_status`](crate::client::Client::describe_table_restore_status).
///
/// See [`crate::client::fluent_builders::DescribeTableRestoreStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTableRestoreStatus {
    _private: (),
}
impl DescribeTableRestoreStatus {
    /// Creates a new builder-style object to manufacture [`DescribeTableRestoreStatusInput`](crate::input::DescribeTableRestoreStatusInput)
    pub fn builder() -> crate::input::describe_table_restore_status_input::Builder {
        crate::input::describe_table_restore_status_input::Builder::default()
    }
    /// Creates a new `DescribeTableRestoreStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTableRestoreStatus {
    type Output = std::result::Result<
        crate::output::DescribeTableRestoreStatusOutput,
        crate::error::DescribeTableRestoreStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_table_restore_status_error(response)
        } else {
            crate::operation_deser::parse_describe_table_restore_status_response(response)
        }
    }
}

/// Operation shape for `DescribeTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tags`](crate::client::Client::describe_tags).
///
/// See [`crate::client::fluent_builders::DescribeTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTags {
    _private: (),
}
impl DescribeTags {
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
    /// Creates a new `DescribeTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTags {
    type Output =
        std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tags_error(response)
        } else {
            crate::operation_deser::parse_describe_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeUsageLimits`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_usage_limits`](crate::client::Client::describe_usage_limits).
///
/// See [`crate::client::fluent_builders::DescribeUsageLimits`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUsageLimits {
    _private: (),
}
impl DescribeUsageLimits {
    /// Creates a new builder-style object to manufacture [`DescribeUsageLimitsInput`](crate::input::DescribeUsageLimitsInput)
    pub fn builder() -> crate::input::describe_usage_limits_input::Builder {
        crate::input::describe_usage_limits_input::Builder::default()
    }
    /// Creates a new `DescribeUsageLimits` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUsageLimits {
    type Output = std::result::Result<
        crate::output::DescribeUsageLimitsOutput,
        crate::error::DescribeUsageLimitsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_usage_limits_error(response)
        } else {
            crate::operation_deser::parse_describe_usage_limits_response(response)
        }
    }
}

/// Operation shape for `DisableLogging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_logging`](crate::client::Client::disable_logging).
///
/// See [`crate::client::fluent_builders::DisableLogging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableLogging {
    _private: (),
}
impl DisableLogging {
    /// Creates a new builder-style object to manufacture [`DisableLoggingInput`](crate::input::DisableLoggingInput)
    pub fn builder() -> crate::input::disable_logging_input::Builder {
        crate::input::disable_logging_input::Builder::default()
    }
    /// Creates a new `DisableLogging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableLogging {
    type Output =
        std::result::Result<crate::output::DisableLoggingOutput, crate::error::DisableLoggingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_logging_error(response)
        } else {
            crate::operation_deser::parse_disable_logging_response(response)
        }
    }
}

/// Operation shape for `DisableSnapshotCopy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_snapshot_copy`](crate::client::Client::disable_snapshot_copy).
///
/// See [`crate::client::fluent_builders::DisableSnapshotCopy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableSnapshotCopy {
    _private: (),
}
impl DisableSnapshotCopy {
    /// Creates a new builder-style object to manufacture [`DisableSnapshotCopyInput`](crate::input::DisableSnapshotCopyInput)
    pub fn builder() -> crate::input::disable_snapshot_copy_input::Builder {
        crate::input::disable_snapshot_copy_input::Builder::default()
    }
    /// Creates a new `DisableSnapshotCopy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableSnapshotCopy {
    type Output = std::result::Result<
        crate::output::DisableSnapshotCopyOutput,
        crate::error::DisableSnapshotCopyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_snapshot_copy_error(response)
        } else {
            crate::operation_deser::parse_disable_snapshot_copy_response(response)
        }
    }
}

/// Operation shape for `DisassociateDataShareConsumer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_data_share_consumer`](crate::client::Client::disassociate_data_share_consumer).
///
/// See [`crate::client::fluent_builders::DisassociateDataShareConsumer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateDataShareConsumer {
    _private: (),
}
impl DisassociateDataShareConsumer {
    /// Creates a new builder-style object to manufacture [`DisassociateDataShareConsumerInput`](crate::input::DisassociateDataShareConsumerInput)
    pub fn builder() -> crate::input::disassociate_data_share_consumer_input::Builder {
        crate::input::disassociate_data_share_consumer_input::Builder::default()
    }
    /// Creates a new `DisassociateDataShareConsumer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateDataShareConsumer {
    type Output = std::result::Result<
        crate::output::DisassociateDataShareConsumerOutput,
        crate::error::DisassociateDataShareConsumerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_data_share_consumer_error(response)
        } else {
            crate::operation_deser::parse_disassociate_data_share_consumer_response(response)
        }
    }
}

/// Operation shape for `EnableLogging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_logging`](crate::client::Client::enable_logging).
///
/// See [`crate::client::fluent_builders::EnableLogging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableLogging {
    _private: (),
}
impl EnableLogging {
    /// Creates a new builder-style object to manufacture [`EnableLoggingInput`](crate::input::EnableLoggingInput)
    pub fn builder() -> crate::input::enable_logging_input::Builder {
        crate::input::enable_logging_input::Builder::default()
    }
    /// Creates a new `EnableLogging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableLogging {
    type Output =
        std::result::Result<crate::output::EnableLoggingOutput, crate::error::EnableLoggingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_logging_error(response)
        } else {
            crate::operation_deser::parse_enable_logging_response(response)
        }
    }
}

/// Operation shape for `EnableSnapshotCopy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_snapshot_copy`](crate::client::Client::enable_snapshot_copy).
///
/// See [`crate::client::fluent_builders::EnableSnapshotCopy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableSnapshotCopy {
    _private: (),
}
impl EnableSnapshotCopy {
    /// Creates a new builder-style object to manufacture [`EnableSnapshotCopyInput`](crate::input::EnableSnapshotCopyInput)
    pub fn builder() -> crate::input::enable_snapshot_copy_input::Builder {
        crate::input::enable_snapshot_copy_input::Builder::default()
    }
    /// Creates a new `EnableSnapshotCopy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableSnapshotCopy {
    type Output = std::result::Result<
        crate::output::EnableSnapshotCopyOutput,
        crate::error::EnableSnapshotCopyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_snapshot_copy_error(response)
        } else {
            crate::operation_deser::parse_enable_snapshot_copy_response(response)
        }
    }
}

/// Operation shape for `GetClusterCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cluster_credentials`](crate::client::Client::get_cluster_credentials).
///
/// See [`crate::client::fluent_builders::GetClusterCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetClusterCredentials {
    _private: (),
}
impl GetClusterCredentials {
    /// Creates a new builder-style object to manufacture [`GetClusterCredentialsInput`](crate::input::GetClusterCredentialsInput)
    pub fn builder() -> crate::input::get_cluster_credentials_input::Builder {
        crate::input::get_cluster_credentials_input::Builder::default()
    }
    /// Creates a new `GetClusterCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetClusterCredentials {
    type Output = std::result::Result<
        crate::output::GetClusterCredentialsOutput,
        crate::error::GetClusterCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cluster_credentials_error(response)
        } else {
            crate::operation_deser::parse_get_cluster_credentials_response(response)
        }
    }
}

/// Operation shape for `GetReservedNodeExchangeConfigurationOptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reserved_node_exchange_configuration_options`](crate::client::Client::get_reserved_node_exchange_configuration_options).
///
/// See [`crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReservedNodeExchangeConfigurationOptions {
    _private: (),
}
impl GetReservedNodeExchangeConfigurationOptions {
    /// Creates a new builder-style object to manufacture [`GetReservedNodeExchangeConfigurationOptionsInput`](crate::input::GetReservedNodeExchangeConfigurationOptionsInput)
    pub fn builder() -> crate::input::get_reserved_node_exchange_configuration_options_input::Builder
    {
        crate::input::get_reserved_node_exchange_configuration_options_input::Builder::default()
    }
    /// Creates a new `GetReservedNodeExchangeConfigurationOptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for GetReservedNodeExchangeConfigurationOptions
{
    type Output = std::result::Result<
        crate::output::GetReservedNodeExchangeConfigurationOptionsOutput,
        crate::error::GetReservedNodeExchangeConfigurationOptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reserved_node_exchange_configuration_options_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_reserved_node_exchange_configuration_options_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetReservedNodeExchangeOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reserved_node_exchange_offerings`](crate::client::Client::get_reserved_node_exchange_offerings).
///
/// See [`crate::client::fluent_builders::GetReservedNodeExchangeOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReservedNodeExchangeOfferings {
    _private: (),
}
impl GetReservedNodeExchangeOfferings {
    /// Creates a new builder-style object to manufacture [`GetReservedNodeExchangeOfferingsInput`](crate::input::GetReservedNodeExchangeOfferingsInput)
    pub fn builder() -> crate::input::get_reserved_node_exchange_offerings_input::Builder {
        crate::input::get_reserved_node_exchange_offerings_input::Builder::default()
    }
    /// Creates a new `GetReservedNodeExchangeOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReservedNodeExchangeOfferings {
    type Output = std::result::Result<
        crate::output::GetReservedNodeExchangeOfferingsOutput,
        crate::error::GetReservedNodeExchangeOfferingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reserved_node_exchange_offerings_error(response)
        } else {
            crate::operation_deser::parse_get_reserved_node_exchange_offerings_response(response)
        }
    }
}

/// Operation shape for `ModifyAquaConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_aqua_configuration`](crate::client::Client::modify_aqua_configuration).
///
/// See [`crate::client::fluent_builders::ModifyAquaConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyAquaConfiguration {
    _private: (),
}
impl ModifyAquaConfiguration {
    /// Creates a new builder-style object to manufacture [`ModifyAquaConfigurationInput`](crate::input::ModifyAquaConfigurationInput)
    pub fn builder() -> crate::input::modify_aqua_configuration_input::Builder {
        crate::input::modify_aqua_configuration_input::Builder::default()
    }
    /// Creates a new `ModifyAquaConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyAquaConfiguration {
    type Output = std::result::Result<
        crate::output::ModifyAquaConfigurationOutput,
        crate::error::ModifyAquaConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_aqua_configuration_error(response)
        } else {
            crate::operation_deser::parse_modify_aqua_configuration_response(response)
        }
    }
}

/// Operation shape for `ModifyAuthenticationProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_authentication_profile`](crate::client::Client::modify_authentication_profile).
///
/// See [`crate::client::fluent_builders::ModifyAuthenticationProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyAuthenticationProfile {
    _private: (),
}
impl ModifyAuthenticationProfile {
    /// Creates a new builder-style object to manufacture [`ModifyAuthenticationProfileInput`](crate::input::ModifyAuthenticationProfileInput)
    pub fn builder() -> crate::input::modify_authentication_profile_input::Builder {
        crate::input::modify_authentication_profile_input::Builder::default()
    }
    /// Creates a new `ModifyAuthenticationProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyAuthenticationProfile {
    type Output = std::result::Result<
        crate::output::ModifyAuthenticationProfileOutput,
        crate::error::ModifyAuthenticationProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_authentication_profile_error(response)
        } else {
            crate::operation_deser::parse_modify_authentication_profile_response(response)
        }
    }
}

/// Operation shape for `ModifyCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster`](crate::client::Client::modify_cluster).
///
/// See [`crate::client::fluent_builders::ModifyCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyCluster {
    _private: (),
}
impl ModifyCluster {
    /// Creates a new builder-style object to manufacture [`ModifyClusterInput`](crate::input::ModifyClusterInput)
    pub fn builder() -> crate::input::modify_cluster_input::Builder {
        crate::input::modify_cluster_input::Builder::default()
    }
    /// Creates a new `ModifyCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyCluster {
    type Output =
        std::result::Result<crate::output::ModifyClusterOutput, crate::error::ModifyClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_response(response)
        }
    }
}

/// Operation shape for `ModifyClusterDbRevision`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster_db_revision`](crate::client::Client::modify_cluster_db_revision).
///
/// See [`crate::client::fluent_builders::ModifyClusterDbRevision`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClusterDbRevision {
    _private: (),
}
impl ModifyClusterDbRevision {
    /// Creates a new builder-style object to manufacture [`ModifyClusterDbRevisionInput`](crate::input::ModifyClusterDbRevisionInput)
    pub fn builder() -> crate::input::modify_cluster_db_revision_input::Builder {
        crate::input::modify_cluster_db_revision_input::Builder::default()
    }
    /// Creates a new `ModifyClusterDbRevision` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClusterDbRevision {
    type Output = std::result::Result<
        crate::output::ModifyClusterDbRevisionOutput,
        crate::error::ModifyClusterDbRevisionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_db_revision_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_db_revision_response(response)
        }
    }
}

/// Operation shape for `ModifyClusterIamRoles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster_iam_roles`](crate::client::Client::modify_cluster_iam_roles).
///
/// See [`crate::client::fluent_builders::ModifyClusterIamRoles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClusterIamRoles {
    _private: (),
}
impl ModifyClusterIamRoles {
    /// Creates a new builder-style object to manufacture [`ModifyClusterIamRolesInput`](crate::input::ModifyClusterIamRolesInput)
    pub fn builder() -> crate::input::modify_cluster_iam_roles_input::Builder {
        crate::input::modify_cluster_iam_roles_input::Builder::default()
    }
    /// Creates a new `ModifyClusterIamRoles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClusterIamRoles {
    type Output = std::result::Result<
        crate::output::ModifyClusterIamRolesOutput,
        crate::error::ModifyClusterIamRolesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_iam_roles_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_iam_roles_response(response)
        }
    }
}

/// Operation shape for `ModifyClusterMaintenance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster_maintenance`](crate::client::Client::modify_cluster_maintenance).
///
/// See [`crate::client::fluent_builders::ModifyClusterMaintenance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClusterMaintenance {
    _private: (),
}
impl ModifyClusterMaintenance {
    /// Creates a new builder-style object to manufacture [`ModifyClusterMaintenanceInput`](crate::input::ModifyClusterMaintenanceInput)
    pub fn builder() -> crate::input::modify_cluster_maintenance_input::Builder {
        crate::input::modify_cluster_maintenance_input::Builder::default()
    }
    /// Creates a new `ModifyClusterMaintenance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClusterMaintenance {
    type Output = std::result::Result<
        crate::output::ModifyClusterMaintenanceOutput,
        crate::error::ModifyClusterMaintenanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_maintenance_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_maintenance_response(response)
        }
    }
}

/// Operation shape for `ModifyClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster_parameter_group`](crate::client::Client::modify_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::ModifyClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClusterParameterGroup {
    _private: (),
}
impl ModifyClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`ModifyClusterParameterGroupInput`](crate::input::ModifyClusterParameterGroupInput)
    pub fn builder() -> crate::input::modify_cluster_parameter_group_input::Builder {
        crate::input::modify_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `ModifyClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::ModifyClusterParameterGroupOutput,
        crate::error::ModifyClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `ModifyClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster_snapshot`](crate::client::Client::modify_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::ModifyClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClusterSnapshot {
    _private: (),
}
impl ModifyClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`ModifyClusterSnapshotInput`](crate::input::ModifyClusterSnapshotInput)
    pub fn builder() -> crate::input::modify_cluster_snapshot_input::Builder {
        crate::input::modify_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `ModifyClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClusterSnapshot {
    type Output = std::result::Result<
        crate::output::ModifyClusterSnapshotOutput,
        crate::error::ModifyClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `ModifyClusterSnapshotSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster_snapshot_schedule`](crate::client::Client::modify_cluster_snapshot_schedule).
///
/// See [`crate::client::fluent_builders::ModifyClusterSnapshotSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClusterSnapshotSchedule {
    _private: (),
}
impl ModifyClusterSnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`ModifyClusterSnapshotScheduleInput`](crate::input::ModifyClusterSnapshotScheduleInput)
    pub fn builder() -> crate::input::modify_cluster_snapshot_schedule_input::Builder {
        crate::input::modify_cluster_snapshot_schedule_input::Builder::default()
    }
    /// Creates a new `ModifyClusterSnapshotSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClusterSnapshotSchedule {
    type Output = std::result::Result<
        crate::output::ModifyClusterSnapshotScheduleOutput,
        crate::error::ModifyClusterSnapshotScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_snapshot_schedule_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_snapshot_schedule_response(response)
        }
    }
}

/// Operation shape for `ModifyClusterSubnetGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_cluster_subnet_group`](crate::client::Client::modify_cluster_subnet_group).
///
/// See [`crate::client::fluent_builders::ModifyClusterSubnetGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyClusterSubnetGroup {
    _private: (),
}
impl ModifyClusterSubnetGroup {
    /// Creates a new builder-style object to manufacture [`ModifyClusterSubnetGroupInput`](crate::input::ModifyClusterSubnetGroupInput)
    pub fn builder() -> crate::input::modify_cluster_subnet_group_input::Builder {
        crate::input::modify_cluster_subnet_group_input::Builder::default()
    }
    /// Creates a new `ModifyClusterSubnetGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyClusterSubnetGroup {
    type Output = std::result::Result<
        crate::output::ModifyClusterSubnetGroupOutput,
        crate::error::ModifyClusterSubnetGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_cluster_subnet_group_error(response)
        } else {
            crate::operation_deser::parse_modify_cluster_subnet_group_response(response)
        }
    }
}

/// Operation shape for `ModifyEndpointAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_endpoint_access`](crate::client::Client::modify_endpoint_access).
///
/// See [`crate::client::fluent_builders::ModifyEndpointAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyEndpointAccess {
    _private: (),
}
impl ModifyEndpointAccess {
    /// Creates a new builder-style object to manufacture [`ModifyEndpointAccessInput`](crate::input::ModifyEndpointAccessInput)
    pub fn builder() -> crate::input::modify_endpoint_access_input::Builder {
        crate::input::modify_endpoint_access_input::Builder::default()
    }
    /// Creates a new `ModifyEndpointAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyEndpointAccess {
    type Output = std::result::Result<
        crate::output::ModifyEndpointAccessOutput,
        crate::error::ModifyEndpointAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_endpoint_access_error(response)
        } else {
            crate::operation_deser::parse_modify_endpoint_access_response(response)
        }
    }
}

/// Operation shape for `ModifyEventSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_event_subscription`](crate::client::Client::modify_event_subscription).
///
/// See [`crate::client::fluent_builders::ModifyEventSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyEventSubscription {
    _private: (),
}
impl ModifyEventSubscription {
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    pub fn builder() -> crate::input::modify_event_subscription_input::Builder {
        crate::input::modify_event_subscription_input::Builder::default()
    }
    /// Creates a new `ModifyEventSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyEventSubscription {
    type Output = std::result::Result<
        crate::output::ModifyEventSubscriptionOutput,
        crate::error::ModifyEventSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_event_subscription_error(response)
        } else {
            crate::operation_deser::parse_modify_event_subscription_response(response)
        }
    }
}

/// Operation shape for `ModifyScheduledAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_scheduled_action`](crate::client::Client::modify_scheduled_action).
///
/// See [`crate::client::fluent_builders::ModifyScheduledAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyScheduledAction {
    _private: (),
}
impl ModifyScheduledAction {
    /// Creates a new builder-style object to manufacture [`ModifyScheduledActionInput`](crate::input::ModifyScheduledActionInput)
    pub fn builder() -> crate::input::modify_scheduled_action_input::Builder {
        crate::input::modify_scheduled_action_input::Builder::default()
    }
    /// Creates a new `ModifyScheduledAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyScheduledAction {
    type Output = std::result::Result<
        crate::output::ModifyScheduledActionOutput,
        crate::error::ModifyScheduledActionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_scheduled_action_error(response)
        } else {
            crate::operation_deser::parse_modify_scheduled_action_response(response)
        }
    }
}

/// Operation shape for `ModifySnapshotCopyRetentionPeriod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_snapshot_copy_retention_period`](crate::client::Client::modify_snapshot_copy_retention_period).
///
/// See [`crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySnapshotCopyRetentionPeriod {
    _private: (),
}
impl ModifySnapshotCopyRetentionPeriod {
    /// Creates a new builder-style object to manufacture [`ModifySnapshotCopyRetentionPeriodInput`](crate::input::ModifySnapshotCopyRetentionPeriodInput)
    pub fn builder() -> crate::input::modify_snapshot_copy_retention_period_input::Builder {
        crate::input::modify_snapshot_copy_retention_period_input::Builder::default()
    }
    /// Creates a new `ModifySnapshotCopyRetentionPeriod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySnapshotCopyRetentionPeriod {
    type Output = std::result::Result<
        crate::output::ModifySnapshotCopyRetentionPeriodOutput,
        crate::error::ModifySnapshotCopyRetentionPeriodError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_snapshot_copy_retention_period_error(response)
        } else {
            crate::operation_deser::parse_modify_snapshot_copy_retention_period_response(response)
        }
    }
}

/// Operation shape for `ModifySnapshotSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_snapshot_schedule`](crate::client::Client::modify_snapshot_schedule).
///
/// See [`crate::client::fluent_builders::ModifySnapshotSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifySnapshotSchedule {
    _private: (),
}
impl ModifySnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`ModifySnapshotScheduleInput`](crate::input::ModifySnapshotScheduleInput)
    pub fn builder() -> crate::input::modify_snapshot_schedule_input::Builder {
        crate::input::modify_snapshot_schedule_input::Builder::default()
    }
    /// Creates a new `ModifySnapshotSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifySnapshotSchedule {
    type Output = std::result::Result<
        crate::output::ModifySnapshotScheduleOutput,
        crate::error::ModifySnapshotScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_snapshot_schedule_error(response)
        } else {
            crate::operation_deser::parse_modify_snapshot_schedule_response(response)
        }
    }
}

/// Operation shape for `ModifyUsageLimit`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`modify_usage_limit`](crate::client::Client::modify_usage_limit).
///
/// See [`crate::client::fluent_builders::ModifyUsageLimit`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ModifyUsageLimit {
    _private: (),
}
impl ModifyUsageLimit {
    /// Creates a new builder-style object to manufacture [`ModifyUsageLimitInput`](crate::input::ModifyUsageLimitInput)
    pub fn builder() -> crate::input::modify_usage_limit_input::Builder {
        crate::input::modify_usage_limit_input::Builder::default()
    }
    /// Creates a new `ModifyUsageLimit` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ModifyUsageLimit {
    type Output = std::result::Result<
        crate::output::ModifyUsageLimitOutput,
        crate::error::ModifyUsageLimitError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_modify_usage_limit_error(response)
        } else {
            crate::operation_deser::parse_modify_usage_limit_response(response)
        }
    }
}

/// Operation shape for `PauseCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`pause_cluster`](crate::client::Client::pause_cluster).
///
/// See [`crate::client::fluent_builders::PauseCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PauseCluster {
    _private: (),
}
impl PauseCluster {
    /// Creates a new builder-style object to manufacture [`PauseClusterInput`](crate::input::PauseClusterInput)
    pub fn builder() -> crate::input::pause_cluster_input::Builder {
        crate::input::pause_cluster_input::Builder::default()
    }
    /// Creates a new `PauseCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PauseCluster {
    type Output =
        std::result::Result<crate::output::PauseClusterOutput, crate::error::PauseClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_pause_cluster_error(response)
        } else {
            crate::operation_deser::parse_pause_cluster_response(response)
        }
    }
}

/// Operation shape for `PurchaseReservedNodeOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_reserved_node_offering`](crate::client::Client::purchase_reserved_node_offering).
///
/// See [`crate::client::fluent_builders::PurchaseReservedNodeOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseReservedNodeOffering {
    _private: (),
}
impl PurchaseReservedNodeOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedNodeOfferingInput`](crate::input::PurchaseReservedNodeOfferingInput)
    pub fn builder() -> crate::input::purchase_reserved_node_offering_input::Builder {
        crate::input::purchase_reserved_node_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseReservedNodeOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseReservedNodeOffering {
    type Output = std::result::Result<
        crate::output::PurchaseReservedNodeOfferingOutput,
        crate::error::PurchaseReservedNodeOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_purchase_reserved_node_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_reserved_node_offering_response(response)
        }
    }
}

/// Operation shape for `RebootCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_cluster`](crate::client::Client::reboot_cluster).
///
/// See [`crate::client::fluent_builders::RebootCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootCluster {
    _private: (),
}
impl RebootCluster {
    /// Creates a new builder-style object to manufacture [`RebootClusterInput`](crate::input::RebootClusterInput)
    pub fn builder() -> crate::input::reboot_cluster_input::Builder {
        crate::input::reboot_cluster_input::Builder::default()
    }
    /// Creates a new `RebootCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootCluster {
    type Output =
        std::result::Result<crate::output::RebootClusterOutput, crate::error::RebootClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_cluster_error(response)
        } else {
            crate::operation_deser::parse_reboot_cluster_response(response)
        }
    }
}

/// Operation shape for `RejectDataShare`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_data_share`](crate::client::Client::reject_data_share).
///
/// See [`crate::client::fluent_builders::RejectDataShare`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectDataShare {
    _private: (),
}
impl RejectDataShare {
    /// Creates a new builder-style object to manufacture [`RejectDataShareInput`](crate::input::RejectDataShareInput)
    pub fn builder() -> crate::input::reject_data_share_input::Builder {
        crate::input::reject_data_share_input::Builder::default()
    }
    /// Creates a new `RejectDataShare` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectDataShare {
    type Output = std::result::Result<
        crate::output::RejectDataShareOutput,
        crate::error::RejectDataShareError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_data_share_error(response)
        } else {
            crate::operation_deser::parse_reject_data_share_response(response)
        }
    }
}

/// Operation shape for `ResetClusterParameterGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_cluster_parameter_group`](crate::client::Client::reset_cluster_parameter_group).
///
/// See [`crate::client::fluent_builders::ResetClusterParameterGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetClusterParameterGroup {
    _private: (),
}
impl ResetClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`ResetClusterParameterGroupInput`](crate::input::ResetClusterParameterGroupInput)
    pub fn builder() -> crate::input::reset_cluster_parameter_group_input::Builder {
        crate::input::reset_cluster_parameter_group_input::Builder::default()
    }
    /// Creates a new `ResetClusterParameterGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetClusterParameterGroup {
    type Output = std::result::Result<
        crate::output::ResetClusterParameterGroupOutput,
        crate::error::ResetClusterParameterGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_cluster_parameter_group_error(response)
        } else {
            crate::operation_deser::parse_reset_cluster_parameter_group_response(response)
        }
    }
}

/// Operation shape for `ResizeCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resize_cluster`](crate::client::Client::resize_cluster).
///
/// See [`crate::client::fluent_builders::ResizeCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResizeCluster {
    _private: (),
}
impl ResizeCluster {
    /// Creates a new builder-style object to manufacture [`ResizeClusterInput`](crate::input::ResizeClusterInput)
    pub fn builder() -> crate::input::resize_cluster_input::Builder {
        crate::input::resize_cluster_input::Builder::default()
    }
    /// Creates a new `ResizeCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResizeCluster {
    type Output =
        std::result::Result<crate::output::ResizeClusterOutput, crate::error::ResizeClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resize_cluster_error(response)
        } else {
            crate::operation_deser::parse_resize_cluster_response(response)
        }
    }
}

/// Operation shape for `RestoreFromClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_from_cluster_snapshot`](crate::client::Client::restore_from_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::RestoreFromClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreFromClusterSnapshot {
    _private: (),
}
impl RestoreFromClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`RestoreFromClusterSnapshotInput`](crate::input::RestoreFromClusterSnapshotInput)
    pub fn builder() -> crate::input::restore_from_cluster_snapshot_input::Builder {
        crate::input::restore_from_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `RestoreFromClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreFromClusterSnapshot {
    type Output = std::result::Result<
        crate::output::RestoreFromClusterSnapshotOutput,
        crate::error::RestoreFromClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_from_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_restore_from_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `RestoreTableFromClusterSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`restore_table_from_cluster_snapshot`](crate::client::Client::restore_table_from_cluster_snapshot).
///
/// See [`crate::client::fluent_builders::RestoreTableFromClusterSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RestoreTableFromClusterSnapshot {
    _private: (),
}
impl RestoreTableFromClusterSnapshot {
    /// Creates a new builder-style object to manufacture [`RestoreTableFromClusterSnapshotInput`](crate::input::RestoreTableFromClusterSnapshotInput)
    pub fn builder() -> crate::input::restore_table_from_cluster_snapshot_input::Builder {
        crate::input::restore_table_from_cluster_snapshot_input::Builder::default()
    }
    /// Creates a new `RestoreTableFromClusterSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RestoreTableFromClusterSnapshot {
    type Output = std::result::Result<
        crate::output::RestoreTableFromClusterSnapshotOutput,
        crate::error::RestoreTableFromClusterSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_restore_table_from_cluster_snapshot_error(response)
        } else {
            crate::operation_deser::parse_restore_table_from_cluster_snapshot_response(response)
        }
    }
}

/// Operation shape for `ResumeCluster`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resume_cluster`](crate::client::Client::resume_cluster).
///
/// See [`crate::client::fluent_builders::ResumeCluster`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResumeCluster {
    _private: (),
}
impl ResumeCluster {
    /// Creates a new builder-style object to manufacture [`ResumeClusterInput`](crate::input::ResumeClusterInput)
    pub fn builder() -> crate::input::resume_cluster_input::Builder {
        crate::input::resume_cluster_input::Builder::default()
    }
    /// Creates a new `ResumeCluster` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResumeCluster {
    type Output =
        std::result::Result<crate::output::ResumeClusterOutput, crate::error::ResumeClusterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resume_cluster_error(response)
        } else {
            crate::operation_deser::parse_resume_cluster_response(response)
        }
    }
}

/// Operation shape for `RevokeClusterSecurityGroupIngress`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_cluster_security_group_ingress`](crate::client::Client::revoke_cluster_security_group_ingress).
///
/// See [`crate::client::fluent_builders::RevokeClusterSecurityGroupIngress`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeClusterSecurityGroupIngress {
    _private: (),
}
impl RevokeClusterSecurityGroupIngress {
    /// Creates a new builder-style object to manufacture [`RevokeClusterSecurityGroupIngressInput`](crate::input::RevokeClusterSecurityGroupIngressInput)
    pub fn builder() -> crate::input::revoke_cluster_security_group_ingress_input::Builder {
        crate::input::revoke_cluster_security_group_ingress_input::Builder::default()
    }
    /// Creates a new `RevokeClusterSecurityGroupIngress` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeClusterSecurityGroupIngress {
    type Output = std::result::Result<
        crate::output::RevokeClusterSecurityGroupIngressOutput,
        crate::error::RevokeClusterSecurityGroupIngressError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_cluster_security_group_ingress_error(response)
        } else {
            crate::operation_deser::parse_revoke_cluster_security_group_ingress_response(response)
        }
    }
}

/// Operation shape for `RevokeEndpointAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_endpoint_access`](crate::client::Client::revoke_endpoint_access).
///
/// See [`crate::client::fluent_builders::RevokeEndpointAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeEndpointAccess {
    _private: (),
}
impl RevokeEndpointAccess {
    /// Creates a new builder-style object to manufacture [`RevokeEndpointAccessInput`](crate::input::RevokeEndpointAccessInput)
    pub fn builder() -> crate::input::revoke_endpoint_access_input::Builder {
        crate::input::revoke_endpoint_access_input::Builder::default()
    }
    /// Creates a new `RevokeEndpointAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeEndpointAccess {
    type Output = std::result::Result<
        crate::output::RevokeEndpointAccessOutput,
        crate::error::RevokeEndpointAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_endpoint_access_error(response)
        } else {
            crate::operation_deser::parse_revoke_endpoint_access_response(response)
        }
    }
}

/// Operation shape for `RevokeSnapshotAccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_snapshot_access`](crate::client::Client::revoke_snapshot_access).
///
/// See [`crate::client::fluent_builders::RevokeSnapshotAccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeSnapshotAccess {
    _private: (),
}
impl RevokeSnapshotAccess {
    /// Creates a new builder-style object to manufacture [`RevokeSnapshotAccessInput`](crate::input::RevokeSnapshotAccessInput)
    pub fn builder() -> crate::input::revoke_snapshot_access_input::Builder {
        crate::input::revoke_snapshot_access_input::Builder::default()
    }
    /// Creates a new `RevokeSnapshotAccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeSnapshotAccess {
    type Output = std::result::Result<
        crate::output::RevokeSnapshotAccessOutput,
        crate::error::RevokeSnapshotAccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_revoke_snapshot_access_error(response)
        } else {
            crate::operation_deser::parse_revoke_snapshot_access_response(response)
        }
    }
}

/// Operation shape for `RotateEncryptionKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`rotate_encryption_key`](crate::client::Client::rotate_encryption_key).
///
/// See [`crate::client::fluent_builders::RotateEncryptionKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RotateEncryptionKey {
    _private: (),
}
impl RotateEncryptionKey {
    /// Creates a new builder-style object to manufacture [`RotateEncryptionKeyInput`](crate::input::RotateEncryptionKeyInput)
    pub fn builder() -> crate::input::rotate_encryption_key_input::Builder {
        crate::input::rotate_encryption_key_input::Builder::default()
    }
    /// Creates a new `RotateEncryptionKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RotateEncryptionKey {
    type Output = std::result::Result<
        crate::output::RotateEncryptionKeyOutput,
        crate::error::RotateEncryptionKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_rotate_encryption_key_error(response)
        } else {
            crate::operation_deser::parse_rotate_encryption_key_response(response)
        }
    }
}

/// Operation shape for `UpdatePartnerStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_partner_status`](crate::client::Client::update_partner_status).
///
/// See [`crate::client::fluent_builders::UpdatePartnerStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePartnerStatus {
    _private: (),
}
impl UpdatePartnerStatus {
    /// Creates a new builder-style object to manufacture [`UpdatePartnerStatusInput`](crate::input::UpdatePartnerStatusInput)
    pub fn builder() -> crate::input::update_partner_status_input::Builder {
        crate::input::update_partner_status_input::Builder::default()
    }
    /// Creates a new `UpdatePartnerStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePartnerStatus {
    type Output = std::result::Result<
        crate::output::UpdatePartnerStatusOutput,
        crate::error::UpdatePartnerStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_partner_status_error(response)
        } else {
            crate::operation_deser::parse_update_partner_status_response(response)
        }
    }
}
