// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_dependent_service_unavailable_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::dependent_service_unavailable_fault::Builder,
) -> Result<
    crate::error::dependent_service_unavailable_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#DependentServiceUnavailableFault$message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_reserved_node_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_reserved_node_state_fault::Builder,
) -> Result<
    crate::error::invalid_reserved_node_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidReservedNodeStateFault$message */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_reserved_node_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::reserved_node_already_exists_fault::Builder,
) -> Result<
    crate::error::reserved_node_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ReservedNodeAlreadyExistsFault$message */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_reserved_node_already_migrated_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::reserved_node_already_migrated_fault::Builder,
) -> Result<
    crate::error::reserved_node_already_migrated_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ReservedNodeAlreadyMigratedFault$message */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_4);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_reserved_node_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::reserved_node_not_found_fault::Builder,
) -> Result<crate::error::reserved_node_not_found_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ReservedNodeNotFoundFault$message */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_5);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_reserved_node_offering_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::reserved_node_offering_not_found_fault::Builder,
) -> Result<
    crate::error::reserved_node_offering_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ReservedNodeOfferingNotFoundFault$message */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unsupported_operation_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::unsupported_operation_fault::Builder,
) -> Result<crate::error::unsupported_operation_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#UnsupportedOperationFault$message */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_accept_reserved_node_exchange(
    inp: &[u8],
    mut builder: crate::output::accept_reserved_node_exchange_output::Builder,
) -> Result<
    crate::output::accept_reserved_node_exchange_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AcceptReservedNodeExchangeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AcceptReservedNodeExchangeResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AcceptReservedNodeExchangeResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected AcceptReservedNodeExchangeResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ExchangedReservedNode") /* ExchangedReservedNode com.amazonaws.redshift.synthetic#AcceptReservedNodeExchangeOutput$ExchangedReservedNode */ =>  {
                let var_8 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_reserved_node(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_exchanged_reserved_node(var_8);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected AcceptReservedNodeExchangeResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_not_found_fault::Builder,
) -> Result<crate::error::cluster_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterNotFoundFault$message */ =>  {
                let var_9 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_9);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_partner_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::partner_not_found_fault::Builder,
) -> Result<crate::error::partner_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#PartnerNotFoundFault$message */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_10);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unauthorized_partner_integration_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::unauthorized_partner_integration_fault::Builder,
) -> Result<
    crate::error::unauthorized_partner_integration_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#UnauthorizedPartnerIntegrationFault$message */ =>  {
                let var_11 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_11);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_add_partner(
    inp: &[u8],
    mut builder: crate::output::add_partner_output::Builder,
) -> Result<crate::output::add_partner_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AddPartnerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AddPartnerResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AddPartnerResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected AddPartnerResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DatabaseName") /* DatabaseName com.amazonaws.redshift.synthetic#AddPartnerOutput$DatabaseName */ =>  {
                let var_12 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_database_name(var_12);
            }
            ,
            s if s.matches("PartnerName") /* PartnerName com.amazonaws.redshift.synthetic#AddPartnerOutput$PartnerName */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_partner_name(var_13);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected AddPartnerResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_data_share_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_data_share_fault::Builder,
) -> Result<crate::error::invalid_data_share_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidDataShareFault$message */ =>  {
                let var_14 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_14);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_namespace_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_namespace_fault::Builder,
) -> Result<crate::error::invalid_namespace_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidNamespaceFault$message */ =>  {
                let var_15 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_15);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_associate_data_share_consumer(
    inp: &[u8],
    mut builder: crate::output::associate_data_share_consumer_output::Builder,
) -> Result<
    crate::output::associate_data_share_consumer_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AssociateDataShareConsumerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AssociateDataShareConsumerResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AssociateDataShareConsumerResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected AssociateDataShareConsumerResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShareArn") /* DataShareArn com.amazonaws.redshift.synthetic#AssociateDataShareConsumerOutput$DataShareArn */ =>  {
                let var_16 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_share_arn(var_16);
            }
            ,
            s if s.matches("ProducerArn") /* ProducerArn com.amazonaws.redshift.synthetic#AssociateDataShareConsumerOutput$ProducerArn */ =>  {
                let var_17 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_producer_arn(var_17);
            }
            ,
            s if s.matches("AllowPubliclyAccessibleConsumers") /* AllowPubliclyAccessibleConsumers com.amazonaws.redshift.synthetic#AssociateDataShareConsumerOutput$AllowPubliclyAccessibleConsumers */ =>  {
                let var_18 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_publicly_accessible_consumers(var_18);
            }
            ,
            s if s.matches("DataShareAssociations") /* DataShareAssociations com.amazonaws.redshift.synthetic#AssociateDataShareConsumerOutput$DataShareAssociations */ =>  {
                let var_19 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_share_associations(var_19);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected AssociateDataShareConsumerResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_authorization_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::authorization_already_exists_fault::Builder,
) -> Result<
    crate::error::authorization_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AuthorizationAlreadyExistsFault$message */ =>  {
                let var_20 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_20);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_authorization_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::authorization_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::authorization_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AuthorizationQuotaExceededFault$message */ =>  {
                let var_21 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_21);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_security_group_not_found_fault::Builder,
) -> Result<
    crate::error::cluster_security_group_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSecurityGroupNotFoundFault$message */ =>  {
                let var_22 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_22);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_security_group_state_fault::Builder,
) -> Result<
    crate::error::invalid_cluster_security_group_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterSecurityGroupStateFault$message */ =>  {
                let var_23 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_23);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_authorize_cluster_security_group_ingress(
    inp: &[u8],
    mut builder: crate::output::authorize_cluster_security_group_ingress_output::Builder,
) -> Result<
    crate::output::authorize_cluster_security_group_ingress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AuthorizeClusterSecurityGroupIngressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AuthorizeClusterSecurityGroupIngressResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AuthorizeClusterSecurityGroupIngressResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected AuthorizeClusterSecurityGroupIngressResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterSecurityGroup") /* ClusterSecurityGroup com.amazonaws.redshift.synthetic#AuthorizeClusterSecurityGroupIngressOutput$ClusterSecurityGroup */ =>  {
                let var_24 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster_security_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_security_group(var_24);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected AuthorizeClusterSecurityGroupIngressResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_authorize_data_share(
    inp: &[u8],
    mut builder: crate::output::authorize_data_share_output::Builder,
) -> Result<crate::output::authorize_data_share_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AuthorizeDataShareResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AuthorizeDataShareResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AuthorizeDataShareResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected AuthorizeDataShareResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShareArn") /* DataShareArn com.amazonaws.redshift.synthetic#AuthorizeDataShareOutput$DataShareArn */ =>  {
                let var_25 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_share_arn(var_25);
            }
            ,
            s if s.matches("ProducerArn") /* ProducerArn com.amazonaws.redshift.synthetic#AuthorizeDataShareOutput$ProducerArn */ =>  {
                let var_26 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_producer_arn(var_26);
            }
            ,
            s if s.matches("AllowPubliclyAccessibleConsumers") /* AllowPubliclyAccessibleConsumers com.amazonaws.redshift.synthetic#AuthorizeDataShareOutput$AllowPubliclyAccessibleConsumers */ =>  {
                let var_27 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_publicly_accessible_consumers(var_27);
            }
            ,
            s if s.matches("DataShareAssociations") /* DataShareAssociations com.amazonaws.redshift.synthetic#AuthorizeDataShareOutput$DataShareAssociations */ =>  {
                let var_28 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_share_associations(var_28);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected AuthorizeDataShareResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_endpoint_authorization_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::endpoint_authorization_already_exists_fault::Builder,
) -> Result<
    crate::error::endpoint_authorization_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EndpointAuthorizationAlreadyExistsFault$message */ =>  {
                let var_29 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_29);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_endpoint_authorizations_per_cluster_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::endpoint_authorizations_per_cluster_limit_exceeded_fault::Builder,
) -> Result<
    crate::error::endpoint_authorizations_per_cluster_limit_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EndpointAuthorizationsPerClusterLimitExceededFault$message */ =>  {
                let var_30 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_30);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_authorization_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_authorization_state_fault::Builder,
) -> Result<
    crate::error::invalid_authorization_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidAuthorizationStateFault$message */ =>  {
                let var_31 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_31);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_state_fault::Builder,
) -> Result<crate::error::invalid_cluster_state_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterStateFault$message */ =>  {
                let var_32 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_32);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_authorize_endpoint_access(
    inp: &[u8],
    mut builder: crate::output::authorize_endpoint_access_output::Builder,
) -> Result<
    crate::output::authorize_endpoint_access_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AuthorizeEndpointAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AuthorizeEndpointAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AuthorizeEndpointAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected AuthorizeEndpointAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Grantor") /* Grantor com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$Grantor */ =>  {
                let var_33 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_grantor(var_33);
            }
            ,
            s if s.matches("Grantee") /* Grantee com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$Grantee */ =>  {
                let var_34 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_grantee(var_34);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$ClusterIdentifier */ =>  {
                let var_35 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_35);
            }
            ,
            s if s.matches("AuthorizeTime") /* AuthorizeTime com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$AuthorizeTime */ =>  {
                let var_36 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_authorize_time(var_36);
            }
            ,
            s if s.matches("ClusterStatus") /* ClusterStatus com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$ClusterStatus */ =>  {
                let var_37 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_status(var_37);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$Status */ =>  {
                let var_38 =
                    Some(
                        Result::<crate::model::AuthorizationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AuthorizationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_38);
            }
            ,
            s if s.matches("AllowedAllVPCs") /* AllowedAllVPCs com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$AllowedAllVPCs */ =>  {
                let var_39 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allowed_all_vp_cs(var_39);
            }
            ,
            s if s.matches("AllowedVPCs") /* AllowedVPCs com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$AllowedVPCs */ =>  {
                let var_40 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_allowed_vp_cs(var_40);
            }
            ,
            s if s.matches("EndpointCount") /* EndpointCount com.amazonaws.redshift.synthetic#AuthorizeEndpointAccessOutput$EndpointCount */ =>  {
                let var_41 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_endpoint_count(var_41);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected AuthorizeEndpointAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_snapshot_not_found_fault::Builder,
) -> Result<crate::error::cluster_snapshot_not_found_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSnapshotNotFoundFault$message */ =>  {
                let var_42 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_42);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::dependent_service_request_throttling_fault::Builder,
) -> Result<
    crate::error::dependent_service_request_throttling_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#DependentServiceRequestThrottlingFault$message */ =>  {
                let var_43 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_43);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_snapshot_state_fault::Builder,
) -> Result<
    crate::error::invalid_cluster_snapshot_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterSnapshotStateFault$message */ =>  {
                let var_44 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_44);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::limit_exceeded_fault::Builder,
) -> Result<crate::error::limit_exceeded_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#LimitExceededFault$message */ =>  {
                let var_45 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_45);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_authorize_snapshot_access(
    inp: &[u8],
    mut builder: crate::output::authorize_snapshot_access_output::Builder,
) -> Result<
    crate::output::authorize_snapshot_access_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("AuthorizeSnapshotAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected AuthorizeSnapshotAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AuthorizeSnapshotAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected AuthorizeSnapshotAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Snapshot") /* Snapshot com.amazonaws.redshift.synthetic#AuthorizeSnapshotAccessOutput$Snapshot */ =>  {
                let var_46 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot(var_46);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected AuthorizeSnapshotAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_batch_delete_request_size_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::batch_delete_request_size_exceeded_fault::Builder,
) -> Result<
    crate::error::batch_delete_request_size_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#BatchDeleteRequestSizeExceededFault$message */ =>  {
                let var_47 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_47);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_batch_delete_cluster_snapshots(
    inp: &[u8],
    mut builder: crate::output::batch_delete_cluster_snapshots_output::Builder,
) -> Result<
    crate::output::batch_delete_cluster_snapshots_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("BatchDeleteClusterSnapshotsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected BatchDeleteClusterSnapshotsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("BatchDeleteClusterSnapshotsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected BatchDeleteClusterSnapshotsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Resources") /* Resources com.amazonaws.redshift.synthetic#BatchDeleteClusterSnapshotsOutput$Resources */ =>  {
                let var_48 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_snapshot_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resources(var_48);
            }
            ,
            s if s.matches("Errors") /* Errors com.amazonaws.redshift.synthetic#BatchDeleteClusterSnapshotsOutput$Errors */ =>  {
                let var_49 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_batch_snapshot_operation_error_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_errors(var_49);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected BatchDeleteClusterSnapshotsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_batch_modify_cluster_snapshots_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::batch_modify_cluster_snapshots_limit_exceeded_fault::Builder,
) -> Result<
    crate::error::batch_modify_cluster_snapshots_limit_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#BatchModifyClusterSnapshotsLimitExceededFault$message */ =>  {
                let var_50 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_50);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_retention_period_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_retention_period_fault::Builder,
) -> Result<crate::error::invalid_retention_period_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidRetentionPeriodFault$message */ =>  {
                let var_51 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_51);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_batch_modify_cluster_snapshots(
    inp: &[u8],
    mut builder: crate::output::batch_modify_cluster_snapshots_output::Builder,
) -> Result<
    crate::output::batch_modify_cluster_snapshots_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("BatchModifyClusterSnapshotsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected BatchModifyClusterSnapshotsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("BatchModifyClusterSnapshotsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected BatchModifyClusterSnapshotsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Resources") /* Resources com.amazonaws.redshift.synthetic#BatchModifyClusterSnapshotsOutput$Resources */ =>  {
                let var_52 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_snapshot_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resources(var_52);
            }
            ,
            s if s.matches("Errors") /* Errors com.amazonaws.redshift.synthetic#BatchModifyClusterSnapshotsOutput$Errors */ =>  {
                let var_53 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_batch_snapshot_operation_errors(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_errors(var_53);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected BatchModifyClusterSnapshotsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resize_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::resize_not_found_fault::Builder,
) -> Result<crate::error::resize_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ResizeNotFoundFault$message */ =>  {
                let var_54 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_54);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_cancel_resize(
    inp: &[u8],
    mut builder: crate::output::cancel_resize_output::Builder,
) -> Result<crate::output::cancel_resize_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CancelResizeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CancelResizeResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CancelResizeResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CancelResizeResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TargetNodeType") /* TargetNodeType com.amazonaws.redshift.synthetic#CancelResizeOutput$TargetNodeType */ =>  {
                let var_55 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_node_type(var_55);
            }
            ,
            s if s.matches("TargetNumberOfNodes") /* TargetNumberOfNodes com.amazonaws.redshift.synthetic#CancelResizeOutput$TargetNumberOfNodes */ =>  {
                let var_56 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_target_number_of_nodes(var_56);
            }
            ,
            s if s.matches("TargetClusterType") /* TargetClusterType com.amazonaws.redshift.synthetic#CancelResizeOutput$TargetClusterType */ =>  {
                let var_57 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_cluster_type(var_57);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift.synthetic#CancelResizeOutput$Status */ =>  {
                let var_58 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_58);
            }
            ,
            s if s.matches("ImportTablesCompleted") /* ImportTablesCompleted com.amazonaws.redshift.synthetic#CancelResizeOutput$ImportTablesCompleted */ =>  {
                let var_59 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_import_tables_completed(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_tables_completed(var_59);
            }
            ,
            s if s.matches("ImportTablesInProgress") /* ImportTablesInProgress com.amazonaws.redshift.synthetic#CancelResizeOutput$ImportTablesInProgress */ =>  {
                let var_60 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_import_tables_in_progress(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_tables_in_progress(var_60);
            }
            ,
            s if s.matches("ImportTablesNotStarted") /* ImportTablesNotStarted com.amazonaws.redshift.synthetic#CancelResizeOutput$ImportTablesNotStarted */ =>  {
                let var_61 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_import_tables_not_started(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_tables_not_started(var_61);
            }
            ,
            s if s.matches("AvgResizeRateInMegaBytesPerSecond") /* AvgResizeRateInMegaBytesPerSecond com.amazonaws.redshift.synthetic#CancelResizeOutput$AvgResizeRateInMegaBytesPerSecond */ =>  {
                let var_62 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#DoubleOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_avg_resize_rate_in_mega_bytes_per_second(var_62);
            }
            ,
            s if s.matches("TotalResizeDataInMegaBytes") /* TotalResizeDataInMegaBytes com.amazonaws.redshift.synthetic#CancelResizeOutput$TotalResizeDataInMegaBytes */ =>  {
                let var_63 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_resize_data_in_mega_bytes(var_63);
            }
            ,
            s if s.matches("ProgressInMegaBytes") /* ProgressInMegaBytes com.amazonaws.redshift.synthetic#CancelResizeOutput$ProgressInMegaBytes */ =>  {
                let var_64 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_progress_in_mega_bytes(var_64);
            }
            ,
            s if s.matches("ElapsedTimeInSeconds") /* ElapsedTimeInSeconds com.amazonaws.redshift.synthetic#CancelResizeOutput$ElapsedTimeInSeconds */ =>  {
                let var_65 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_elapsed_time_in_seconds(var_65);
            }
            ,
            s if s.matches("EstimatedTimeToCompletionInSeconds") /* EstimatedTimeToCompletionInSeconds com.amazonaws.redshift.synthetic#CancelResizeOutput$EstimatedTimeToCompletionInSeconds */ =>  {
                let var_66 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_estimated_time_to_completion_in_seconds(var_66);
            }
            ,
            s if s.matches("ResizeType") /* ResizeType com.amazonaws.redshift.synthetic#CancelResizeOutput$ResizeType */ =>  {
                let var_67 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resize_type(var_67);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.redshift.synthetic#CancelResizeOutput$Message */ =>  {
                let var_68 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_68);
            }
            ,
            s if s.matches("TargetEncryptionType") /* TargetEncryptionType com.amazonaws.redshift.synthetic#CancelResizeOutput$TargetEncryptionType */ =>  {
                let var_69 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_encryption_type(var_69);
            }
            ,
            s if s.matches("DataTransferProgressPercent") /* DataTransferProgressPercent com.amazonaws.redshift.synthetic#CancelResizeOutput$DataTransferProgressPercent */ =>  {
                let var_70 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#DoubleOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_data_transfer_progress_percent(var_70);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CancelResizeResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_snapshot_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_snapshot_already_exists_fault::Builder,
) -> Result<
    crate::error::cluster_snapshot_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSnapshotAlreadyExistsFault$message */ =>  {
                let var_71 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_71);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_snapshot_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_snapshot_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::cluster_snapshot_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSnapshotQuotaExceededFault$message */ =>  {
                let var_72 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_72);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_copy_cluster_snapshot(
    inp: &[u8],
    mut builder: crate::output::copy_cluster_snapshot_output::Builder,
) -> Result<crate::output::copy_cluster_snapshot_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CopyClusterSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CopyClusterSnapshotResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CopyClusterSnapshotResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CopyClusterSnapshotResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Snapshot") /* Snapshot com.amazonaws.redshift.synthetic#CopyClusterSnapshotOutput$Snapshot */ =>  {
                let var_73 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot(var_73);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CopyClusterSnapshotResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_authentication_profile_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::authentication_profile_already_exists_fault::Builder,
) -> Result<
    crate::error::authentication_profile_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AuthenticationProfileAlreadyExistsFault$message */ =>  {
                let var_74 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_74);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_authentication_profile_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::authentication_profile_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::authentication_profile_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AuthenticationProfileQuotaExceededFault$message */ =>  {
                let var_75 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_75);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_authentication_profile_request_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_authentication_profile_request_fault::Builder,
) -> Result<
    crate::error::invalid_authentication_profile_request_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidAuthenticationProfileRequestFault$message */ =>  {
                let var_76 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_76);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_authentication_profile(
    inp: &[u8],
    mut builder: crate::output::create_authentication_profile_output::Builder,
) -> Result<
    crate::output::create_authentication_profile_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateAuthenticationProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateAuthenticationProfileResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateAuthenticationProfileResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateAuthenticationProfileResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AuthenticationProfileName") /* AuthenticationProfileName com.amazonaws.redshift.synthetic#CreateAuthenticationProfileOutput$AuthenticationProfileName */ =>  {
                let var_77 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_authentication_profile_name(var_77);
            }
            ,
            s if s.matches("AuthenticationProfileContent") /* AuthenticationProfileContent com.amazonaws.redshift.synthetic#CreateAuthenticationProfileOutput$AuthenticationProfileContent */ =>  {
                let var_78 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_authentication_profile_content(var_78);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateAuthenticationProfileResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_already_exists_fault::Builder,
) -> Result<crate::error::cluster_already_exists_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterAlreadyExistsFault$message */ =>  {
                let var_79 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_79);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_parameter_group_not_found_fault::Builder,
) -> Result<
    crate::error::cluster_parameter_group_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterParameterGroupNotFoundFault$message */ =>  {
                let var_80 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_80);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_quota_exceeded_fault::Builder,
) -> Result<crate::error::cluster_quota_exceeded_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterQuotaExceededFault$message */ =>  {
                let var_81 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_81);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_subnet_group_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_subnet_group_not_found_fault::Builder,
) -> Result<
    crate::error::cluster_subnet_group_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSubnetGroupNotFoundFault$message */ =>  {
                let var_82 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_82);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_hsm_client_certificate_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::hsm_client_certificate_not_found_fault::Builder,
) -> Result<
    crate::error::hsm_client_certificate_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#HsmClientCertificateNotFoundFault$message */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_83);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_hsm_configuration_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::hsm_configuration_not_found_fault::Builder,
) -> Result<
    crate::error::hsm_configuration_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#HsmConfigurationNotFoundFault$message */ =>  {
                let var_84 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_84);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_insufficient_cluster_capacity_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::insufficient_cluster_capacity_fault::Builder,
) -> Result<
    crate::error::insufficient_cluster_capacity_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InsufficientClusterCapacityFault$message */ =>  {
                let var_85 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_85);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_subnet_group_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_subnet_group_state_fault::Builder,
) -> Result<
    crate::error::invalid_cluster_subnet_group_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterSubnetGroupStateFault$message */ =>  {
                let var_86 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_86);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_track_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_track_fault::Builder,
) -> Result<crate::error::invalid_cluster_track_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterTrackFault$message */ =>  {
                let var_87 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_87);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_elastic_ip_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_elastic_ip_fault::Builder,
) -> Result<crate::error::invalid_elastic_ip_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidElasticIpFault$message */ =>  {
                let var_88 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_88);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_subnet_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_subnet::Builder,
) -> Result<crate::error::invalid_subnet::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidSubnet$message */ =>  {
                let var_89 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_89);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_tag_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_tag_fault::Builder,
) -> Result<crate::error::invalid_tag_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidTagFault$message */ =>  {
                let var_90 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_90);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_vpc_network_state_fault::Builder,
) -> Result<crate::error::invalid_vpc_network_state_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidVPCNetworkStateFault$message */ =>  {
                let var_91 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_91);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_number_of_nodes_per_cluster_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder,
) -> Result<
    crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#NumberOfNodesPerClusterLimitExceededFault$message */ =>  {
                let var_92 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_92);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_number_of_nodes_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::number_of_nodes_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::number_of_nodes_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#NumberOfNodesQuotaExceededFault$message */ =>  {
                let var_93 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_93);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_schedule_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_schedule_not_found_fault::Builder,
) -> Result<
    crate::error::snapshot_schedule_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotScheduleNotFoundFault$message */ =>  {
                let var_94 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_94);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::tag_limit_exceeded_fault::Builder,
) -> Result<crate::error::tag_limit_exceeded_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#TagLimitExceededFault$message */ =>  {
                let var_95 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_95);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unauthorized_operation_xml_err(
    inp: &[u8],
    mut builder: crate::error::unauthorized_operation::Builder,
) -> Result<crate::error::unauthorized_operation::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#UnauthorizedOperation$message */ =>  {
                let var_96 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_96);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_cluster(
    inp: &[u8],
    mut builder: crate::output::create_cluster_output::Builder,
) -> Result<crate::output::create_cluster_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateClusterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateClusterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateClusterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateClusterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#CreateClusterOutput$Cluster */ =>  {
                let var_97 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_97);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateClusterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_parameter_group_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_parameter_group_already_exists_fault::Builder,
) -> Result<
    crate::error::cluster_parameter_group_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterParameterGroupAlreadyExistsFault$message */ =>  {
                let var_98 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_98);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_parameter_group_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_parameter_group_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::cluster_parameter_group_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterParameterGroupQuotaExceededFault$message */ =>  {
                let var_99 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_99);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_cluster_parameter_group(
    inp: &[u8],
    mut builder: crate::output::create_cluster_parameter_group_output::Builder,
) -> Result<
    crate::output::create_cluster_parameter_group_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateClusterParameterGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateClusterParameterGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateClusterParameterGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateClusterParameterGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterParameterGroup") /* ClusterParameterGroup com.amazonaws.redshift.synthetic#CreateClusterParameterGroupOutput$ClusterParameterGroup */ =>  {
                let var_100 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster_parameter_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_parameter_group(var_100);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateClusterParameterGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_security_group_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_security_group_already_exists_fault::Builder,
) -> Result<
    crate::error::cluster_security_group_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSecurityGroupAlreadyExistsFault$message */ =>  {
                let var_101 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_101);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_security_group_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_security_group_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::cluster_security_group_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSecurityGroupQuotaExceededFault$message */ =>  {
                let var_102 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_102);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_cluster_security_group(
    inp: &[u8],
    mut builder: crate::output::create_cluster_security_group_output::Builder,
) -> Result<
    crate::output::create_cluster_security_group_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateClusterSecurityGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateClusterSecurityGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateClusterSecurityGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateClusterSecurityGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterSecurityGroup") /* ClusterSecurityGroup com.amazonaws.redshift.synthetic#CreateClusterSecurityGroupOutput$ClusterSecurityGroup */ =>  {
                let var_103 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster_security_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_security_group(var_103);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateClusterSecurityGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_cluster_snapshot(
    inp: &[u8],
    mut builder: crate::output::create_cluster_snapshot_output::Builder,
) -> Result<crate::output::create_cluster_snapshot_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateClusterSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateClusterSnapshotResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateClusterSnapshotResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateClusterSnapshotResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Snapshot") /* Snapshot com.amazonaws.redshift.synthetic#CreateClusterSnapshotOutput$Snapshot */ =>  {
                let var_104 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot(var_104);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateClusterSnapshotResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_subnet_group_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_subnet_group_already_exists_fault::Builder,
) -> Result<
    crate::error::cluster_subnet_group_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSubnetGroupAlreadyExistsFault$message */ =>  {
                let var_105 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_105);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_subnet_group_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_subnet_group_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::cluster_subnet_group_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSubnetGroupQuotaExceededFault$message */ =>  {
                let var_106 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_106);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_subnet_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_subnet_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::cluster_subnet_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterSubnetQuotaExceededFault$message */ =>  {
                let var_107 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_107);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_cluster_subnet_group(
    inp: &[u8],
    mut builder: crate::output::create_cluster_subnet_group_output::Builder,
) -> Result<
    crate::output::create_cluster_subnet_group_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateClusterSubnetGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateClusterSubnetGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateClusterSubnetGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateClusterSubnetGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterSubnetGroup") /* ClusterSubnetGroup com.amazonaws.redshift.synthetic#CreateClusterSubnetGroupOutput$ClusterSubnetGroup */ =>  {
                let var_108 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster_subnet_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_subnet_group(var_108);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateClusterSubnetGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_access_to_cluster_denied_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::access_to_cluster_denied_fault::Builder,
) -> Result<crate::error::access_to_cluster_denied_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AccessToClusterDeniedFault$message */ =>  {
                let var_109 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_109);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_endpoint_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::endpoint_already_exists_fault::Builder,
) -> Result<crate::error::endpoint_already_exists_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EndpointAlreadyExistsFault$message */ =>  {
                let var_110 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_110);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_endpoints_per_authorization_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::endpoints_per_authorization_limit_exceeded_fault::Builder,
) -> Result<
    crate::error::endpoints_per_authorization_limit_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EndpointsPerAuthorizationLimitExceededFault$message */ =>  {
                let var_111 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_111);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_endpoints_per_cluster_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::endpoints_per_cluster_limit_exceeded_fault::Builder,
) -> Result<
    crate::error::endpoints_per_cluster_limit_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EndpointsPerClusterLimitExceededFault$message */ =>  {
                let var_112 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_112);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_endpoint_access(
    inp: &[u8],
    mut builder: crate::output::create_endpoint_access_output::Builder,
) -> Result<crate::output::create_endpoint_access_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateEndpointAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateEndpointAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateEndpointAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateEndpointAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$ClusterIdentifier */ =>  {
                let var_113 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_113);
            }
            ,
            s if s.matches("ResourceOwner") /* ResourceOwner com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$ResourceOwner */ =>  {
                let var_114 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_owner(var_114);
            }
            ,
            s if s.matches("SubnetGroupName") /* SubnetGroupName com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$SubnetGroupName */ =>  {
                let var_115 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_group_name(var_115);
            }
            ,
            s if s.matches("EndpointStatus") /* EndpointStatus com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$EndpointStatus */ =>  {
                let var_116 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_status(var_116);
            }
            ,
            s if s.matches("EndpointName") /* EndpointName com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$EndpointName */ =>  {
                let var_117 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_name(var_117);
            }
            ,
            s if s.matches("EndpointCreateTime") /* EndpointCreateTime com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$EndpointCreateTime */ =>  {
                let var_118 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_endpoint_create_time(var_118);
            }
            ,
            s if s.matches("Port") /* Port com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$Port */ =>  {
                let var_119 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_port(var_119);
            }
            ,
            s if s.matches("Address") /* Address com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$Address */ =>  {
                let var_120 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_address(var_120);
            }
            ,
            s if s.matches("VpcSecurityGroups") /* VpcSecurityGroups com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$VpcSecurityGroups */ =>  {
                let var_121 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_security_group_membership_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_security_groups(var_121);
            }
            ,
            s if s.matches("VpcEndpoint") /* VpcEndpoint com.amazonaws.redshift.synthetic#CreateEndpointAccessOutput$VpcEndpoint */ =>  {
                let var_122 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoint(var_122);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateEndpointAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_event_subscription_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::event_subscription_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::event_subscription_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EventSubscriptionQuotaExceededFault$message */ =>  {
                let var_123 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_123);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_sns_invalid_topic_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::sns_invalid_topic_fault::Builder,
) -> Result<crate::error::sns_invalid_topic_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SNSInvalidTopicFault$message */ =>  {
                let var_124 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_124);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_sns_no_authorization_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::sns_no_authorization_fault::Builder,
) -> Result<crate::error::sns_no_authorization_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SNSNoAuthorizationFault$message */ =>  {
                let var_125 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_125);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_sns_topic_arn_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::sns_topic_arn_not_found_fault::Builder,
) -> Result<crate::error::sns_topic_arn_not_found_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SNSTopicArnNotFoundFault$message */ =>  {
                let var_126 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_126);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_source_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::source_not_found_fault::Builder,
) -> Result<crate::error::source_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SourceNotFoundFault$message */ =>  {
                let var_127 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_127);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_subscription_already_exist_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::subscription_already_exist_fault::Builder,
) -> Result<crate::error::subscription_already_exist_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SubscriptionAlreadyExistFault$message */ =>  {
                let var_128 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_128);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_subscription_category_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::subscription_category_not_found_fault::Builder,
) -> Result<
    crate::error::subscription_category_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SubscriptionCategoryNotFoundFault$message */ =>  {
                let var_129 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_129);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_subscription_event_id_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::subscription_event_id_not_found_fault::Builder,
) -> Result<
    crate::error::subscription_event_id_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SubscriptionEventIdNotFoundFault$message */ =>  {
                let var_130 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_130);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_subscription_severity_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::subscription_severity_not_found_fault::Builder,
) -> Result<
    crate::error::subscription_severity_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SubscriptionSeverityNotFoundFault$message */ =>  {
                let var_131 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_131);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_event_subscription(
    inp: &[u8],
    mut builder: crate::output::create_event_subscription_output::Builder,
) -> Result<
    crate::output::create_event_subscription_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateEventSubscriptionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateEventSubscriptionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateEventSubscriptionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateEventSubscriptionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EventSubscription") /* EventSubscription com.amazonaws.redshift.synthetic#CreateEventSubscriptionOutput$EventSubscription */ =>  {
                let var_132 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_event_subscription(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_subscription(var_132);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateEventSubscriptionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_hsm_client_certificate_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::hsm_client_certificate_already_exists_fault::Builder,
) -> Result<
    crate::error::hsm_client_certificate_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#HsmClientCertificateAlreadyExistsFault$message */ =>  {
                let var_133 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_133);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_hsm_client_certificate_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::hsm_client_certificate_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::hsm_client_certificate_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#HsmClientCertificateQuotaExceededFault$message */ =>  {
                let var_134 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_134);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_hsm_client_certificate(
    inp: &[u8],
    mut builder: crate::output::create_hsm_client_certificate_output::Builder,
) -> Result<
    crate::output::create_hsm_client_certificate_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateHsmClientCertificateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateHsmClientCertificateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateHsmClientCertificateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateHsmClientCertificateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("HsmClientCertificate") /* HsmClientCertificate com.amazonaws.redshift.synthetic#CreateHsmClientCertificateOutput$HsmClientCertificate */ =>  {
                let var_135 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_hsm_client_certificate(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_hsm_client_certificate(var_135);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateHsmClientCertificateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_hsm_configuration_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::hsm_configuration_already_exists_fault::Builder,
) -> Result<
    crate::error::hsm_configuration_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#HsmConfigurationAlreadyExistsFault$message */ =>  {
                let var_136 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_136);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_hsm_configuration_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::hsm_configuration_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::hsm_configuration_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#HsmConfigurationQuotaExceededFault$message */ =>  {
                let var_137 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_137);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_hsm_configuration(
    inp: &[u8],
    mut builder: crate::output::create_hsm_configuration_output::Builder,
) -> Result<crate::output::create_hsm_configuration_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateHsmConfigurationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateHsmConfigurationResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateHsmConfigurationResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateHsmConfigurationResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("HsmConfiguration") /* HsmConfiguration com.amazonaws.redshift.synthetic#CreateHsmConfigurationOutput$HsmConfiguration */ =>  {
                let var_138 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_hsm_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_hsm_configuration(var_138);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateHsmConfigurationResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_scheduled_action_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_scheduled_action_fault::Builder,
) -> Result<crate::error::invalid_scheduled_action_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidScheduledActionFault$message */ =>  {
                let var_139 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_139);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_schedule_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_schedule_fault::Builder,
) -> Result<crate::error::invalid_schedule_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidScheduleFault$message */ =>  {
                let var_140 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_140);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_scheduled_action_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::scheduled_action_already_exists_fault::Builder,
) -> Result<
    crate::error::scheduled_action_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ScheduledActionAlreadyExistsFault$message */ =>  {
                let var_141 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_141);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_scheduled_action_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::scheduled_action_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::scheduled_action_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ScheduledActionQuotaExceededFault$message */ =>  {
                let var_142 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_142);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_scheduled_action_type_unsupported_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::scheduled_action_type_unsupported_fault::Builder,
) -> Result<
    crate::error::scheduled_action_type_unsupported_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ScheduledActionTypeUnsupportedFault$message */ =>  {
                let var_143 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_143);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_scheduled_action(
    inp: &[u8],
    mut builder: crate::output::create_scheduled_action_output::Builder,
) -> Result<crate::output::create_scheduled_action_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateScheduledActionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateScheduledActionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateScheduledActionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateScheduledActionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ScheduledActionName") /* ScheduledActionName com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$ScheduledActionName */ =>  {
                let var_144 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_scheduled_action_name(var_144);
            }
            ,
            s if s.matches("TargetAction") /* TargetAction com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$TargetAction */ =>  {
                let var_145 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_scheduled_action_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_target_action(var_145);
            }
            ,
            s if s.matches("Schedule") /* Schedule com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$Schedule */ =>  {
                let var_146 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule(var_146);
            }
            ,
            s if s.matches("IamRole") /* IamRole com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$IamRole */ =>  {
                let var_147 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_iam_role(var_147);
            }
            ,
            s if s.matches("ScheduledActionDescription") /* ScheduledActionDescription com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$ScheduledActionDescription */ =>  {
                let var_148 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_scheduled_action_description(var_148);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$State */ =>  {
                let var_149 =
                    Some(
                        Result::<crate::model::ScheduledActionState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ScheduledActionState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_149);
            }
            ,
            s if s.matches("NextInvocations") /* NextInvocations com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$NextInvocations */ =>  {
                let var_150 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_scheduled_action_time_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_next_invocations(var_150);
            }
            ,
            s if s.matches("StartTime") /* StartTime com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$StartTime */ =>  {
                let var_151 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_151);
            }
            ,
            s if s.matches("EndTime") /* EndTime com.amazonaws.redshift.synthetic#CreateScheduledActionOutput$EndTime */ =>  {
                let var_152 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_end_time(var_152);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateScheduledActionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_copy_grant_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_copy_grant_already_exists_fault::Builder,
) -> Result<
    crate::error::snapshot_copy_grant_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotCopyGrantAlreadyExistsFault$message */ =>  {
                let var_153 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_153);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_copy_grant_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_copy_grant_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::snapshot_copy_grant_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotCopyGrantQuotaExceededFault$message */ =>  {
                let var_154 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_154);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_snapshot_copy_grant(
    inp: &[u8],
    mut builder: crate::output::create_snapshot_copy_grant_output::Builder,
) -> Result<
    crate::output::create_snapshot_copy_grant_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSnapshotCopyGrantResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSnapshotCopyGrantResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateSnapshotCopyGrantResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateSnapshotCopyGrantResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SnapshotCopyGrant") /* SnapshotCopyGrant com.amazonaws.redshift.synthetic#CreateSnapshotCopyGrantOutput$SnapshotCopyGrant */ =>  {
                let var_155 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot_copy_grant(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot_copy_grant(var_155);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateSnapshotCopyGrantResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_schedule_definition_type_unsupported_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::schedule_definition_type_unsupported_fault::Builder,
) -> Result<
    crate::error::schedule_definition_type_unsupported_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ScheduleDefinitionTypeUnsupportedFault$message */ =>  {
                let var_156 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_156);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_schedule_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_schedule_already_exists_fault::Builder,
) -> Result<
    crate::error::snapshot_schedule_already_exists_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotScheduleAlreadyExistsFault$message */ =>  {
                let var_157 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_157);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_schedule_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_schedule_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::snapshot_schedule_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotScheduleQuotaExceededFault$message */ =>  {
                let var_158 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_158);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_snapshot_schedule(
    inp: &[u8],
    mut builder: crate::output::create_snapshot_schedule_output::Builder,
) -> Result<crate::output::create_snapshot_schedule_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSnapshotScheduleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSnapshotScheduleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateSnapshotScheduleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateSnapshotScheduleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ScheduleDefinitions") /* ScheduleDefinitions com.amazonaws.redshift.synthetic#CreateSnapshotScheduleOutput$ScheduleDefinitions */ =>  {
                let var_159 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_schedule_definition_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_schedule_definitions(var_159);
            }
            ,
            s if s.matches("ScheduleIdentifier") /* ScheduleIdentifier com.amazonaws.redshift.synthetic#CreateSnapshotScheduleOutput$ScheduleIdentifier */ =>  {
                let var_160 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule_identifier(var_160);
            }
            ,
            s if s.matches("ScheduleDescription") /* ScheduleDescription com.amazonaws.redshift.synthetic#CreateSnapshotScheduleOutput$ScheduleDescription */ =>  {
                let var_161 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule_description(var_161);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift.synthetic#CreateSnapshotScheduleOutput$Tags */ =>  {
                let var_162 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_162);
            }
            ,
            s if s.matches("NextInvocations") /* NextInvocations com.amazonaws.redshift.synthetic#CreateSnapshotScheduleOutput$NextInvocations */ =>  {
                let var_163 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_scheduled_snapshot_time_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_next_invocations(var_163);
            }
            ,
            s if s.matches("AssociatedClusterCount") /* AssociatedClusterCount com.amazonaws.redshift.synthetic#CreateSnapshotScheduleOutput$AssociatedClusterCount */ =>  {
                let var_164 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_associated_cluster_count(var_164);
            }
            ,
            s if s.matches("AssociatedClusters") /* AssociatedClusters com.amazonaws.redshift.synthetic#CreateSnapshotScheduleOutput$AssociatedClusters */ =>  {
                let var_165 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_associated_cluster_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associated_clusters(var_165);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateSnapshotScheduleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resource_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::resource_not_found_fault::Builder,
) -> Result<crate::error::resource_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ResourceNotFoundFault$message */ =>  {
                let var_166 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_166);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_usage_limit_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_usage_limit_fault::Builder,
) -> Result<crate::error::invalid_usage_limit_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidUsageLimitFault$message */ =>  {
                let var_167 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_167);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_usage_limit_already_exists_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::usage_limit_already_exists_fault::Builder,
) -> Result<crate::error::usage_limit_already_exists_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#UsageLimitAlreadyExistsFault$message */ =>  {
                let var_168 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_168);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_usage_limit(
    inp: &[u8],
    mut builder: crate::output::create_usage_limit_output::Builder,
) -> Result<crate::output::create_usage_limit_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateUsageLimitResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateUsageLimitResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateUsageLimitResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateUsageLimitResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("UsageLimitId") /* UsageLimitId com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$UsageLimitId */ =>  {
                let var_169 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_usage_limit_id(var_169);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$ClusterIdentifier */ =>  {
                let var_170 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_170);
            }
            ,
            s if s.matches("FeatureType") /* FeatureType com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$FeatureType */ =>  {
                let var_171 =
                    Some(
                        Result::<crate::model::UsageLimitFeatureType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitFeatureType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_feature_type(var_171);
            }
            ,
            s if s.matches("LimitType") /* LimitType com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$LimitType */ =>  {
                let var_172 =
                    Some(
                        Result::<crate::model::UsageLimitLimitType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitLimitType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_limit_type(var_172);
            }
            ,
            s if s.matches("Amount") /* Amount com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$Amount */ =>  {
                let var_173 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_amount(var_173);
            }
            ,
            s if s.matches("Period") /* Period com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$Period */ =>  {
                let var_174 =
                    Some(
                        Result::<crate::model::UsageLimitPeriod, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitPeriod::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_period(var_174);
            }
            ,
            s if s.matches("BreachAction") /* BreachAction com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$BreachAction */ =>  {
                let var_175 =
                    Some(
                        Result::<crate::model::UsageLimitBreachAction, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitBreachAction::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_breach_action(var_175);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift.synthetic#CreateUsageLimitOutput$Tags */ =>  {
                let var_176 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_176);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateUsageLimitResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_deauthorize_data_share(
    inp: &[u8],
    mut builder: crate::output::deauthorize_data_share_output::Builder,
) -> Result<crate::output::deauthorize_data_share_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeauthorizeDataShareResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeauthorizeDataShareResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeauthorizeDataShareResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeauthorizeDataShareResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShareArn") /* DataShareArn com.amazonaws.redshift.synthetic#DeauthorizeDataShareOutput$DataShareArn */ =>  {
                let var_177 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_share_arn(var_177);
            }
            ,
            s if s.matches("ProducerArn") /* ProducerArn com.amazonaws.redshift.synthetic#DeauthorizeDataShareOutput$ProducerArn */ =>  {
                let var_178 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_producer_arn(var_178);
            }
            ,
            s if s.matches("AllowPubliclyAccessibleConsumers") /* AllowPubliclyAccessibleConsumers com.amazonaws.redshift.synthetic#DeauthorizeDataShareOutput$AllowPubliclyAccessibleConsumers */ =>  {
                let var_179 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_publicly_accessible_consumers(var_179);
            }
            ,
            s if s.matches("DataShareAssociations") /* DataShareAssociations com.amazonaws.redshift.synthetic#DeauthorizeDataShareOutput$DataShareAssociations */ =>  {
                let var_180 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_share_associations(var_180);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeauthorizeDataShareResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_authentication_profile_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::authentication_profile_not_found_fault::Builder,
) -> Result<
    crate::error::authentication_profile_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AuthenticationProfileNotFoundFault$message */ =>  {
                let var_181 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_181);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_authentication_profile(
    inp: &[u8],
    mut builder: crate::output::delete_authentication_profile_output::Builder,
) -> Result<
    crate::output::delete_authentication_profile_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteAuthenticationProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteAuthenticationProfileResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteAuthenticationProfileResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteAuthenticationProfileResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AuthenticationProfileName") /* AuthenticationProfileName com.amazonaws.redshift.synthetic#DeleteAuthenticationProfileOutput$AuthenticationProfileName */ =>  {
                let var_182 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_authentication_profile_name(var_182);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteAuthenticationProfileResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_cluster(
    inp: &[u8],
    mut builder: crate::output::delete_cluster_output::Builder,
) -> Result<crate::output::delete_cluster_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteClusterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteClusterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteClusterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteClusterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#DeleteClusterOutput$Cluster */ =>  {
                let var_183 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_183);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteClusterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_parameter_group_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_parameter_group_state_fault::Builder,
) -> Result<
    crate::error::invalid_cluster_parameter_group_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterParameterGroupStateFault$message */ =>  {
                let var_184 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_184);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_cluster_snapshot(
    inp: &[u8],
    mut builder: crate::output::delete_cluster_snapshot_output::Builder,
) -> Result<crate::output::delete_cluster_snapshot_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteClusterSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteClusterSnapshotResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteClusterSnapshotResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteClusterSnapshotResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Snapshot") /* Snapshot com.amazonaws.redshift.synthetic#DeleteClusterSnapshotOutput$Snapshot */ =>  {
                let var_185 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot(var_185);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteClusterSnapshotResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_subnet_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_subnet_state_fault::Builder,
) -> Result<
    crate::error::invalid_cluster_subnet_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterSubnetStateFault$message */ =>  {
                let var_186 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_186);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_endpoint_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::endpoint_not_found_fault::Builder,
) -> Result<crate::error::endpoint_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EndpointNotFoundFault$message */ =>  {
                let var_187 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_187);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_endpoint_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_endpoint_state_fault::Builder,
) -> Result<crate::error::invalid_endpoint_state_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidEndpointStateFault$message */ =>  {
                let var_188 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_188);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_endpoint_access(
    inp: &[u8],
    mut builder: crate::output::delete_endpoint_access_output::Builder,
) -> Result<crate::output::delete_endpoint_access_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteEndpointAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteEndpointAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteEndpointAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteEndpointAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$ClusterIdentifier */ =>  {
                let var_189 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_189);
            }
            ,
            s if s.matches("ResourceOwner") /* ResourceOwner com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$ResourceOwner */ =>  {
                let var_190 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_owner(var_190);
            }
            ,
            s if s.matches("SubnetGroupName") /* SubnetGroupName com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$SubnetGroupName */ =>  {
                let var_191 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_group_name(var_191);
            }
            ,
            s if s.matches("EndpointStatus") /* EndpointStatus com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$EndpointStatus */ =>  {
                let var_192 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_status(var_192);
            }
            ,
            s if s.matches("EndpointName") /* EndpointName com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$EndpointName */ =>  {
                let var_193 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_name(var_193);
            }
            ,
            s if s.matches("EndpointCreateTime") /* EndpointCreateTime com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$EndpointCreateTime */ =>  {
                let var_194 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_endpoint_create_time(var_194);
            }
            ,
            s if s.matches("Port") /* Port com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$Port */ =>  {
                let var_195 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_port(var_195);
            }
            ,
            s if s.matches("Address") /* Address com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$Address */ =>  {
                let var_196 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_address(var_196);
            }
            ,
            s if s.matches("VpcSecurityGroups") /* VpcSecurityGroups com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$VpcSecurityGroups */ =>  {
                let var_197 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_security_group_membership_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_security_groups(var_197);
            }
            ,
            s if s.matches("VpcEndpoint") /* VpcEndpoint com.amazonaws.redshift.synthetic#DeleteEndpointAccessOutput$VpcEndpoint */ =>  {
                let var_198 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoint(var_198);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteEndpointAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_subscription_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_subscription_state_fault::Builder,
) -> Result<crate::error::invalid_subscription_state_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidSubscriptionStateFault$message */ =>  {
                let var_199 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_199);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_subscription_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::subscription_not_found_fault::Builder,
) -> Result<crate::error::subscription_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SubscriptionNotFoundFault$message */ =>  {
                let var_200 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_200);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_hsm_client_certificate_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_hsm_client_certificate_state_fault::Builder,
) -> Result<
    crate::error::invalid_hsm_client_certificate_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidHsmClientCertificateStateFault$message */ =>  {
                let var_201 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_201);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_hsm_configuration_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_hsm_configuration_state_fault::Builder,
) -> Result<
    crate::error::invalid_hsm_configuration_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidHsmConfigurationStateFault$message */ =>  {
                let var_202 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_202);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_partner(
    inp: &[u8],
    mut builder: crate::output::delete_partner_output::Builder,
) -> Result<crate::output::delete_partner_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeletePartnerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeletePartnerResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeletePartnerResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeletePartnerResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DatabaseName") /* DatabaseName com.amazonaws.redshift.synthetic#DeletePartnerOutput$DatabaseName */ =>  {
                let var_203 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_database_name(var_203);
            }
            ,
            s if s.matches("PartnerName") /* PartnerName com.amazonaws.redshift.synthetic#DeletePartnerOutput$PartnerName */ =>  {
                let var_204 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_partner_name(var_204);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeletePartnerResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_scheduled_action_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::scheduled_action_not_found_fault::Builder,
) -> Result<crate::error::scheduled_action_not_found_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ScheduledActionNotFoundFault$message */ =>  {
                let var_205 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_205);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_snapshot_copy_grant_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_snapshot_copy_grant_state_fault::Builder,
) -> Result<
    crate::error::invalid_snapshot_copy_grant_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidSnapshotCopyGrantStateFault$message */ =>  {
                let var_206 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_206);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_copy_grant_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_copy_grant_not_found_fault::Builder,
) -> Result<
    crate::error::snapshot_copy_grant_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotCopyGrantNotFoundFault$message */ =>  {
                let var_207 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_207);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_cluster_snapshot_schedule_state_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_cluster_snapshot_schedule_state_fault::Builder,
) -> Result<
    crate::error::invalid_cluster_snapshot_schedule_state_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidClusterSnapshotScheduleStateFault$message */ =>  {
                let var_208 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_208);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_usage_limit_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::usage_limit_not_found_fault::Builder,
) -> Result<crate::error::usage_limit_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#UsageLimitNotFoundFault$message */ =>  {
                let var_209 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_209);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_account_attributes(
    inp: &[u8],
    mut builder: crate::output::describe_account_attributes_output::Builder,
) -> Result<
    crate::output::describe_account_attributes_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAccountAttributesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAccountAttributesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAccountAttributesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAccountAttributesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AccountAttributes") /* AccountAttributes com.amazonaws.redshift.synthetic#DescribeAccountAttributesOutput$AccountAttributes */ =>  {
                let var_210 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_attribute_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_account_attributes(var_210);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAccountAttributesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_authentication_profiles(
    inp: &[u8],
    mut builder: crate::output::describe_authentication_profiles_output::Builder,
) -> Result<
    crate::output::describe_authentication_profiles_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAuthenticationProfilesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAuthenticationProfilesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAuthenticationProfilesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAuthenticationProfilesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AuthenticationProfiles") /* AuthenticationProfiles com.amazonaws.redshift.synthetic#DescribeAuthenticationProfilesOutput$AuthenticationProfiles */ =>  {
                let var_211 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_authentication_profile_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_authentication_profiles(var_211);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAuthenticationProfilesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_db_revisions(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_db_revisions_output::Builder,
) -> Result<
    crate::output::describe_cluster_db_revisions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterDbRevisionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterDbRevisionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterDbRevisionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterDbRevisionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterDbRevisionsOutput$Marker */ =>  {
                let var_212 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_212);
            }
            ,
            s if s.matches("ClusterDbRevisions") /* ClusterDbRevisions com.amazonaws.redshift.synthetic#DescribeClusterDbRevisionsOutput$ClusterDbRevisions */ =>  {
                let var_213 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_db_revisions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_db_revisions(var_213);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterDbRevisionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_parameter_groups(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_parameter_groups_output::Builder,
) -> Result<
    crate::output::describe_cluster_parameter_groups_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterParameterGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterParameterGroupsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterParameterGroupsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterParameterGroupsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterParameterGroupsOutput$Marker */ =>  {
                let var_214 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_214);
            }
            ,
            s if s.matches("ParameterGroups") /* ParameterGroups com.amazonaws.redshift.synthetic#DescribeClusterParameterGroupsOutput$ParameterGroups */ =>  {
                let var_215 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_parameter_group_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_parameter_groups(var_215);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterParameterGroupsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_parameters(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_parameters_output::Builder,
) -> Result<
    crate::output::describe_cluster_parameters_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterParametersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterParametersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterParametersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterParametersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Parameters") /* Parameters com.amazonaws.redshift.synthetic#DescribeClusterParametersOutput$Parameters */ =>  {
                let var_216 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_parameters_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_parameters(var_216);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterParametersOutput$Marker */ =>  {
                let var_217 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_217);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterParametersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_clusters(
    inp: &[u8],
    mut builder: crate::output::describe_clusters_output::Builder,
) -> Result<crate::output::describe_clusters_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClustersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClustersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClustersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClustersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClustersOutput$Marker */ =>  {
                let var_218 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_218);
            }
            ,
            s if s.matches("Clusters") /* Clusters com.amazonaws.redshift.synthetic#DescribeClustersOutput$Clusters */ =>  {
                let var_219 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_clusters(var_219);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClustersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_security_groups(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_security_groups_output::Builder,
) -> Result<
    crate::output::describe_cluster_security_groups_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterSecurityGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterSecurityGroupsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterSecurityGroupsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterSecurityGroupsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterSecurityGroupsOutput$Marker */ =>  {
                let var_220 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_220);
            }
            ,
            s if s.matches("ClusterSecurityGroups") /* ClusterSecurityGroups com.amazonaws.redshift.synthetic#DescribeClusterSecurityGroupsOutput$ClusterSecurityGroups */ =>  {
                let var_221 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_security_groups(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_security_groups(var_221);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterSecurityGroupsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_snapshots(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_snapshots_output::Builder,
) -> Result<
    crate::output::describe_cluster_snapshots_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterSnapshotsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterSnapshotsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterSnapshotsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterSnapshotsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterSnapshotsOutput$Marker */ =>  {
                let var_222 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_222);
            }
            ,
            s if s.matches("Snapshots") /* Snapshots com.amazonaws.redshift.synthetic#DescribeClusterSnapshotsOutput$Snapshots */ =>  {
                let var_223 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_snapshot_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshots(var_223);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterSnapshotsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_subnet_groups(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_subnet_groups_output::Builder,
) -> Result<
    crate::output::describe_cluster_subnet_groups_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterSubnetGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterSubnetGroupsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterSubnetGroupsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterSubnetGroupsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterSubnetGroupsOutput$Marker */ =>  {
                let var_224 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_224);
            }
            ,
            s if s.matches("ClusterSubnetGroups") /* ClusterSubnetGroups com.amazonaws.redshift.synthetic#DescribeClusterSubnetGroupsOutput$ClusterSubnetGroups */ =>  {
                let var_225 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_subnet_groups(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_subnet_groups(var_225);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterSubnetGroupsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_tracks(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_tracks_output::Builder,
) -> Result<crate::output::describe_cluster_tracks_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterTracksResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterTracksResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterTracksResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterTracksResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MaintenanceTracks") /* MaintenanceTracks com.amazonaws.redshift.synthetic#DescribeClusterTracksOutput$MaintenanceTracks */ =>  {
                let var_226 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_track_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_maintenance_tracks(var_226);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterTracksOutput$Marker */ =>  {
                let var_227 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_227);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterTracksResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_cluster_versions(
    inp: &[u8],
    mut builder: crate::output::describe_cluster_versions_output::Builder,
) -> Result<
    crate::output::describe_cluster_versions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeClusterVersionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeClusterVersionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeClusterVersionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeClusterVersionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeClusterVersionsOutput$Marker */ =>  {
                let var_228 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_228);
            }
            ,
            s if s.matches("ClusterVersions") /* ClusterVersions com.amazonaws.redshift.synthetic#DescribeClusterVersionsOutput$ClusterVersions */ =>  {
                let var_229 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_version_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_versions(var_229);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeClusterVersionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_data_shares(
    inp: &[u8],
    mut builder: crate::output::describe_data_shares_output::Builder,
) -> Result<crate::output::describe_data_shares_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeDataSharesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeDataSharesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeDataSharesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeDataSharesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShares") /* DataShares com.amazonaws.redshift.synthetic#DescribeDataSharesOutput$DataShares */ =>  {
                let var_230 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_shares(var_230);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeDataSharesOutput$Marker */ =>  {
                let var_231 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_231);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeDataSharesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_data_shares_for_consumer(
    inp: &[u8],
    mut builder: crate::output::describe_data_shares_for_consumer_output::Builder,
) -> Result<
    crate::output::describe_data_shares_for_consumer_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeDataSharesForConsumerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeDataSharesForConsumerResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeDataSharesForConsumerResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeDataSharesForConsumerResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShares") /* DataShares com.amazonaws.redshift.synthetic#DescribeDataSharesForConsumerOutput$DataShares */ =>  {
                let var_232 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_shares(var_232);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeDataSharesForConsumerOutput$Marker */ =>  {
                let var_233 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_233);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeDataSharesForConsumerResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_data_shares_for_producer(
    inp: &[u8],
    mut builder: crate::output::describe_data_shares_for_producer_output::Builder,
) -> Result<
    crate::output::describe_data_shares_for_producer_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeDataSharesForProducerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeDataSharesForProducerResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeDataSharesForProducerResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeDataSharesForProducerResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShares") /* DataShares com.amazonaws.redshift.synthetic#DescribeDataSharesForProducerOutput$DataShares */ =>  {
                let var_234 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_shares(var_234);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeDataSharesForProducerOutput$Marker */ =>  {
                let var_235 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_235);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeDataSharesForProducerResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_default_cluster_parameters(
    inp: &[u8],
    mut builder: crate::output::describe_default_cluster_parameters_output::Builder,
) -> Result<
    crate::output::describe_default_cluster_parameters_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeDefaultClusterParametersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeDefaultClusterParametersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeDefaultClusterParametersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeDefaultClusterParametersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DefaultClusterParameters") /* DefaultClusterParameters com.amazonaws.redshift.synthetic#DescribeDefaultClusterParametersOutput$DefaultClusterParameters */ =>  {
                let var_236 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_default_cluster_parameters(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_default_cluster_parameters(var_236);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeDefaultClusterParametersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_endpoint_access(
    inp: &[u8],
    mut builder: crate::output::describe_endpoint_access_output::Builder,
) -> Result<crate::output::describe_endpoint_access_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEndpointAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEndpointAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEndpointAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEndpointAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EndpointAccessList") /* EndpointAccessList com.amazonaws.redshift.synthetic#DescribeEndpointAccessOutput$EndpointAccessList */ =>  {
                let var_237 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_endpoint_accesses(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_endpoint_access_list(var_237);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeEndpointAccessOutput$Marker */ =>  {
                let var_238 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_238);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEndpointAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_endpoint_authorization(
    inp: &[u8],
    mut builder: crate::output::describe_endpoint_authorization_output::Builder,
) -> Result<
    crate::output::describe_endpoint_authorization_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEndpointAuthorizationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEndpointAuthorizationResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEndpointAuthorizationResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEndpointAuthorizationResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EndpointAuthorizationList") /* EndpointAuthorizationList com.amazonaws.redshift.synthetic#DescribeEndpointAuthorizationOutput$EndpointAuthorizationList */ =>  {
                let var_239 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_endpoint_authorizations(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_endpoint_authorization_list(var_239);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeEndpointAuthorizationOutput$Marker */ =>  {
                let var_240 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_240);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEndpointAuthorizationResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_event_categories(
    inp: &[u8],
    mut builder: crate::output::describe_event_categories_output::Builder,
) -> Result<
    crate::output::describe_event_categories_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEventCategoriesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEventCategoriesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEventCategoriesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEventCategoriesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EventCategoriesMapList") /* EventCategoriesMapList com.amazonaws.redshift.synthetic#DescribeEventCategoriesOutput$EventCategoriesMapList */ =>  {
                let var_241 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_event_categories_map_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_categories_map_list(var_241);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEventCategoriesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_events(
    inp: &[u8],
    mut builder: crate::output::describe_events_output::Builder,
) -> Result<crate::output::describe_events_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEventsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEventsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEventsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEventsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeEventsOutput$Marker */ =>  {
                let var_242 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_242);
            }
            ,
            s if s.matches("Events") /* Events com.amazonaws.redshift.synthetic#DescribeEventsOutput$Events */ =>  {
                let var_243 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_event_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_events(var_243);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEventsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_event_subscriptions(
    inp: &[u8],
    mut builder: crate::output::describe_event_subscriptions_output::Builder,
) -> Result<
    crate::output::describe_event_subscriptions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeEventSubscriptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeEventSubscriptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeEventSubscriptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeEventSubscriptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeEventSubscriptionsOutput$Marker */ =>  {
                let var_244 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_244);
            }
            ,
            s if s.matches("EventSubscriptionsList") /* EventSubscriptionsList com.amazonaws.redshift.synthetic#DescribeEventSubscriptionsOutput$EventSubscriptionsList */ =>  {
                let var_245 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_event_subscriptions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_subscriptions_list(var_245);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeEventSubscriptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_hsm_client_certificates(
    inp: &[u8],
    mut builder: crate::output::describe_hsm_client_certificates_output::Builder,
) -> Result<
    crate::output::describe_hsm_client_certificates_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeHsmClientCertificatesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeHsmClientCertificatesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeHsmClientCertificatesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeHsmClientCertificatesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeHsmClientCertificatesOutput$Marker */ =>  {
                let var_246 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_246);
            }
            ,
            s if s.matches("HsmClientCertificates") /* HsmClientCertificates com.amazonaws.redshift.synthetic#DescribeHsmClientCertificatesOutput$HsmClientCertificates */ =>  {
                let var_247 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_hsm_client_certificate_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_hsm_client_certificates(var_247);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeHsmClientCertificatesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_hsm_configurations(
    inp: &[u8],
    mut builder: crate::output::describe_hsm_configurations_output::Builder,
) -> Result<
    crate::output::describe_hsm_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeHsmConfigurationsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeHsmConfigurationsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeHsmConfigurationsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeHsmConfigurationsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeHsmConfigurationsOutput$Marker */ =>  {
                let var_248 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_248);
            }
            ,
            s if s.matches("HsmConfigurations") /* HsmConfigurations com.amazonaws.redshift.synthetic#DescribeHsmConfigurationsOutput$HsmConfigurations */ =>  {
                let var_249 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_hsm_configuration_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_hsm_configurations(var_249);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeHsmConfigurationsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_logging_status(
    inp: &[u8],
    mut builder: crate::output::describe_logging_status_output::Builder,
) -> Result<crate::output::describe_logging_status_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeLoggingStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeLoggingStatusResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeLoggingStatusResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeLoggingStatusResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("LoggingEnabled") /* LoggingEnabled com.amazonaws.redshift.synthetic#DescribeLoggingStatusOutput$LoggingEnabled */ =>  {
                let var_250 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_logging_enabled(var_250);
            }
            ,
            s if s.matches("BucketName") /* BucketName com.amazonaws.redshift.synthetic#DescribeLoggingStatusOutput$BucketName */ =>  {
                let var_251 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket_name(var_251);
            }
            ,
            s if s.matches("S3KeyPrefix") /* S3KeyPrefix com.amazonaws.redshift.synthetic#DescribeLoggingStatusOutput$S3KeyPrefix */ =>  {
                let var_252 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_s3_key_prefix(var_252);
            }
            ,
            s if s.matches("LastSuccessfulDeliveryTime") /* LastSuccessfulDeliveryTime com.amazonaws.redshift.synthetic#DescribeLoggingStatusOutput$LastSuccessfulDeliveryTime */ =>  {
                let var_253 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_successful_delivery_time(var_253);
            }
            ,
            s if s.matches("LastFailureTime") /* LastFailureTime com.amazonaws.redshift.synthetic#DescribeLoggingStatusOutput$LastFailureTime */ =>  {
                let var_254 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_failure_time(var_254);
            }
            ,
            s if s.matches("LastFailureMessage") /* LastFailureMessage com.amazonaws.redshift.synthetic#DescribeLoggingStatusOutput$LastFailureMessage */ =>  {
                let var_255 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_last_failure_message(var_255);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeLoggingStatusResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_access_to_snapshot_denied_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::access_to_snapshot_denied_fault::Builder,
) -> Result<crate::error::access_to_snapshot_denied_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AccessToSnapshotDeniedFault$message */ =>  {
                let var_256 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_256);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_node_configuration_options(
    inp: &[u8],
    mut builder: crate::output::describe_node_configuration_options_output::Builder,
) -> Result<
    crate::output::describe_node_configuration_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeNodeConfigurationOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeNodeConfigurationOptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeNodeConfigurationOptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeNodeConfigurationOptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("NodeConfigurationOptionList") /* NodeConfigurationOptionList com.amazonaws.redshift.synthetic#DescribeNodeConfigurationOptionsOutput$NodeConfigurationOptionList */ =>  {
                let var_257 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_node_configuration_option_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_node_configuration_option_list(var_257);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeNodeConfigurationOptionsOutput$Marker */ =>  {
                let var_258 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_258);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeNodeConfigurationOptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_orderable_cluster_options(
    inp: &[u8],
    mut builder: crate::output::describe_orderable_cluster_options_output::Builder,
) -> Result<
    crate::output::describe_orderable_cluster_options_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeOrderableClusterOptionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeOrderableClusterOptionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeOrderableClusterOptionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeOrderableClusterOptionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("OrderableClusterOptions") /* OrderableClusterOptions com.amazonaws.redshift.synthetic#DescribeOrderableClusterOptionsOutput$OrderableClusterOptions */ =>  {
                let var_259 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_orderable_cluster_options_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_orderable_cluster_options(var_259);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeOrderableClusterOptionsOutput$Marker */ =>  {
                let var_260 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_260);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeOrderableClusterOptionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_partners(
    inp: &[u8],
    mut builder: crate::output::describe_partners_output::Builder,
) -> Result<crate::output::describe_partners_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribePartnersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribePartnersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribePartnersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribePartnersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PartnerIntegrationInfoList") /* PartnerIntegrationInfoList com.amazonaws.redshift.synthetic#DescribePartnersOutput$PartnerIntegrationInfoList */ =>  {
                let var_261 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_partner_integration_info_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_partner_integration_info_list(var_261);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribePartnersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_reserved_node_offerings(
    inp: &[u8],
    mut builder: crate::output::describe_reserved_node_offerings_output::Builder,
) -> Result<
    crate::output::describe_reserved_node_offerings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReservedNodeOfferingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReservedNodeOfferingsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeReservedNodeOfferingsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeReservedNodeOfferingsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeReservedNodeOfferingsOutput$Marker */ =>  {
                let var_262 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_262);
            }
            ,
            s if s.matches("ReservedNodeOfferings") /* ReservedNodeOfferings com.amazonaws.redshift.synthetic#DescribeReservedNodeOfferingsOutput$ReservedNodeOfferings */ =>  {
                let var_263 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_reserved_node_offering_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_node_offerings(var_263);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeReservedNodeOfferingsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_reserved_nodes(
    inp: &[u8],
    mut builder: crate::output::describe_reserved_nodes_output::Builder,
) -> Result<crate::output::describe_reserved_nodes_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeReservedNodesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeReservedNodesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeReservedNodesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeReservedNodesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeReservedNodesOutput$Marker */ =>  {
                let var_264 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_264);
            }
            ,
            s if s.matches("ReservedNodes") /* ReservedNodes com.amazonaws.redshift.synthetic#DescribeReservedNodesOutput$ReservedNodes */ =>  {
                let var_265 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_reserved_node_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_nodes(var_265);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeReservedNodesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_resize(
    inp: &[u8],
    mut builder: crate::output::describe_resize_output::Builder,
) -> Result<crate::output::describe_resize_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeResizeResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeResizeResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeResizeResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeResizeResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TargetNodeType") /* TargetNodeType com.amazonaws.redshift.synthetic#DescribeResizeOutput$TargetNodeType */ =>  {
                let var_266 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_node_type(var_266);
            }
            ,
            s if s.matches("TargetNumberOfNodes") /* TargetNumberOfNodes com.amazonaws.redshift.synthetic#DescribeResizeOutput$TargetNumberOfNodes */ =>  {
                let var_267 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_target_number_of_nodes(var_267);
            }
            ,
            s if s.matches("TargetClusterType") /* TargetClusterType com.amazonaws.redshift.synthetic#DescribeResizeOutput$TargetClusterType */ =>  {
                let var_268 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_cluster_type(var_268);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift.synthetic#DescribeResizeOutput$Status */ =>  {
                let var_269 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_269);
            }
            ,
            s if s.matches("ImportTablesCompleted") /* ImportTablesCompleted com.amazonaws.redshift.synthetic#DescribeResizeOutput$ImportTablesCompleted */ =>  {
                let var_270 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_import_tables_completed(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_tables_completed(var_270);
            }
            ,
            s if s.matches("ImportTablesInProgress") /* ImportTablesInProgress com.amazonaws.redshift.synthetic#DescribeResizeOutput$ImportTablesInProgress */ =>  {
                let var_271 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_import_tables_in_progress(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_tables_in_progress(var_271);
            }
            ,
            s if s.matches("ImportTablesNotStarted") /* ImportTablesNotStarted com.amazonaws.redshift.synthetic#DescribeResizeOutput$ImportTablesNotStarted */ =>  {
                let var_272 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_import_tables_not_started(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_import_tables_not_started(var_272);
            }
            ,
            s if s.matches("AvgResizeRateInMegaBytesPerSecond") /* AvgResizeRateInMegaBytesPerSecond com.amazonaws.redshift.synthetic#DescribeResizeOutput$AvgResizeRateInMegaBytesPerSecond */ =>  {
                let var_273 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#DoubleOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_avg_resize_rate_in_mega_bytes_per_second(var_273);
            }
            ,
            s if s.matches("TotalResizeDataInMegaBytes") /* TotalResizeDataInMegaBytes com.amazonaws.redshift.synthetic#DescribeResizeOutput$TotalResizeDataInMegaBytes */ =>  {
                let var_274 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_resize_data_in_mega_bytes(var_274);
            }
            ,
            s if s.matches("ProgressInMegaBytes") /* ProgressInMegaBytes com.amazonaws.redshift.synthetic#DescribeResizeOutput$ProgressInMegaBytes */ =>  {
                let var_275 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_progress_in_mega_bytes(var_275);
            }
            ,
            s if s.matches("ElapsedTimeInSeconds") /* ElapsedTimeInSeconds com.amazonaws.redshift.synthetic#DescribeResizeOutput$ElapsedTimeInSeconds */ =>  {
                let var_276 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_elapsed_time_in_seconds(var_276);
            }
            ,
            s if s.matches("EstimatedTimeToCompletionInSeconds") /* EstimatedTimeToCompletionInSeconds com.amazonaws.redshift.synthetic#DescribeResizeOutput$EstimatedTimeToCompletionInSeconds */ =>  {
                let var_277 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_estimated_time_to_completion_in_seconds(var_277);
            }
            ,
            s if s.matches("ResizeType") /* ResizeType com.amazonaws.redshift.synthetic#DescribeResizeOutput$ResizeType */ =>  {
                let var_278 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resize_type(var_278);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.redshift.synthetic#DescribeResizeOutput$Message */ =>  {
                let var_279 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_279);
            }
            ,
            s if s.matches("TargetEncryptionType") /* TargetEncryptionType com.amazonaws.redshift.synthetic#DescribeResizeOutput$TargetEncryptionType */ =>  {
                let var_280 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_encryption_type(var_280);
            }
            ,
            s if s.matches("DataTransferProgressPercent") /* DataTransferProgressPercent com.amazonaws.redshift.synthetic#DescribeResizeOutput$DataTransferProgressPercent */ =>  {
                let var_281 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#DoubleOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_data_transfer_progress_percent(var_281);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeResizeResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_scheduled_actions(
    inp: &[u8],
    mut builder: crate::output::describe_scheduled_actions_output::Builder,
) -> Result<
    crate::output::describe_scheduled_actions_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeScheduledActionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeScheduledActionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeScheduledActionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeScheduledActionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeScheduledActionsOutput$Marker */ =>  {
                let var_282 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_282);
            }
            ,
            s if s.matches("ScheduledActions") /* ScheduledActions com.amazonaws.redshift.synthetic#DescribeScheduledActionsOutput$ScheduledActions */ =>  {
                let var_283 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_scheduled_action_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_scheduled_actions(var_283);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeScheduledActionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_snapshot_copy_grants(
    inp: &[u8],
    mut builder: crate::output::describe_snapshot_copy_grants_output::Builder,
) -> Result<
    crate::output::describe_snapshot_copy_grants_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSnapshotCopyGrantsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSnapshotCopyGrantsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeSnapshotCopyGrantsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeSnapshotCopyGrantsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeSnapshotCopyGrantsOutput$Marker */ =>  {
                let var_284 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_284);
            }
            ,
            s if s.matches("SnapshotCopyGrants") /* SnapshotCopyGrants com.amazonaws.redshift.synthetic#DescribeSnapshotCopyGrantsOutput$SnapshotCopyGrants */ =>  {
                let var_285 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_snapshot_copy_grant_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot_copy_grants(var_285);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeSnapshotCopyGrantsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_snapshot_schedules(
    inp: &[u8],
    mut builder: crate::output::describe_snapshot_schedules_output::Builder,
) -> Result<
    crate::output::describe_snapshot_schedules_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeSnapshotSchedulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeSnapshotSchedulesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeSnapshotSchedulesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeSnapshotSchedulesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SnapshotSchedules") /* SnapshotSchedules com.amazonaws.redshift.synthetic#DescribeSnapshotSchedulesOutput$SnapshotSchedules */ =>  {
                let var_286 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_snapshot_schedule_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot_schedules(var_286);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeSnapshotSchedulesOutput$Marker */ =>  {
                let var_287 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_287);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeSnapshotSchedulesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_storage(
    inp: &[u8],
    mut builder: crate::output::describe_storage_output::Builder,
) -> Result<crate::output::describe_storage_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeStorageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeStorageResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeStorageResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeStorageResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TotalBackupSizeInMegaBytes") /* TotalBackupSizeInMegaBytes com.amazonaws.redshift.synthetic#DescribeStorageOutput$TotalBackupSizeInMegaBytes */ =>  {
                let var_288 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_backup_size_in_mega_bytes(var_288);
            }
            ,
            s if s.matches("TotalProvisionedStorageInMegaBytes") /* TotalProvisionedStorageInMegaBytes com.amazonaws.redshift.synthetic#DescribeStorageOutput$TotalProvisionedStorageInMegaBytes */ =>  {
                let var_289 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_provisioned_storage_in_mega_bytes(var_289);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeStorageResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_table_restore_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::table_restore_not_found_fault::Builder,
) -> Result<crate::error::table_restore_not_found_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#TableRestoreNotFoundFault$message */ =>  {
                let var_290 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_290);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_table_restore_status(
    inp: &[u8],
    mut builder: crate::output::describe_table_restore_status_output::Builder,
) -> Result<
    crate::output::describe_table_restore_status_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTableRestoreStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTableRestoreStatusResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeTableRestoreStatusResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeTableRestoreStatusResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TableRestoreStatusDetails") /* TableRestoreStatusDetails com.amazonaws.redshift.synthetic#DescribeTableRestoreStatusOutput$TableRestoreStatusDetails */ =>  {
                let var_291 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_table_restore_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_table_restore_status_details(var_291);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeTableRestoreStatusOutput$Marker */ =>  {
                let var_292 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_292);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeTableRestoreStatusResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_tags(
    inp: &[u8],
    mut builder: crate::output::describe_tags_output::Builder,
) -> Result<crate::output::describe_tags_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TaggedResources") /* TaggedResources com.amazonaws.redshift.synthetic#DescribeTagsOutput$TaggedResources */ =>  {
                let var_293 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tagged_resource_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tagged_resources(var_293);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeTagsOutput$Marker */ =>  {
                let var_294 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_294);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_usage_limits(
    inp: &[u8],
    mut builder: crate::output::describe_usage_limits_output::Builder,
) -> Result<crate::output::describe_usage_limits_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeUsageLimitsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeUsageLimitsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeUsageLimitsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeUsageLimitsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("UsageLimits") /* UsageLimits com.amazonaws.redshift.synthetic#DescribeUsageLimitsOutput$UsageLimits */ =>  {
                let var_295 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_usage_limits(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_usage_limits(var_295);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#DescribeUsageLimitsOutput$Marker */ =>  {
                let var_296 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_296);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeUsageLimitsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_logging(
    inp: &[u8],
    mut builder: crate::output::disable_logging_output::Builder,
) -> Result<crate::output::disable_logging_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableLoggingResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableLoggingResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DisableLoggingResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DisableLoggingResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("LoggingEnabled") /* LoggingEnabled com.amazonaws.redshift.synthetic#DisableLoggingOutput$LoggingEnabled */ =>  {
                let var_297 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_logging_enabled(var_297);
            }
            ,
            s if s.matches("BucketName") /* BucketName com.amazonaws.redshift.synthetic#DisableLoggingOutput$BucketName */ =>  {
                let var_298 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket_name(var_298);
            }
            ,
            s if s.matches("S3KeyPrefix") /* S3KeyPrefix com.amazonaws.redshift.synthetic#DisableLoggingOutput$S3KeyPrefix */ =>  {
                let var_299 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_s3_key_prefix(var_299);
            }
            ,
            s if s.matches("LastSuccessfulDeliveryTime") /* LastSuccessfulDeliveryTime com.amazonaws.redshift.synthetic#DisableLoggingOutput$LastSuccessfulDeliveryTime */ =>  {
                let var_300 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_successful_delivery_time(var_300);
            }
            ,
            s if s.matches("LastFailureTime") /* LastFailureTime com.amazonaws.redshift.synthetic#DisableLoggingOutput$LastFailureTime */ =>  {
                let var_301 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_failure_time(var_301);
            }
            ,
            s if s.matches("LastFailureMessage") /* LastFailureMessage com.amazonaws.redshift.synthetic#DisableLoggingOutput$LastFailureMessage */ =>  {
                let var_302 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_last_failure_message(var_302);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DisableLoggingResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_copy_already_disabled_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_copy_already_disabled_fault::Builder,
) -> Result<
    crate::error::snapshot_copy_already_disabled_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotCopyAlreadyDisabledFault$message */ =>  {
                let var_303 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_303);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_snapshot_copy(
    inp: &[u8],
    mut builder: crate::output::disable_snapshot_copy_output::Builder,
) -> Result<crate::output::disable_snapshot_copy_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableSnapshotCopyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableSnapshotCopyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DisableSnapshotCopyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DisableSnapshotCopyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#DisableSnapshotCopyOutput$Cluster */ =>  {
                let var_304 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_304);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DisableSnapshotCopyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disassociate_data_share_consumer(
    inp: &[u8],
    mut builder: crate::output::disassociate_data_share_consumer_output::Builder,
) -> Result<
    crate::output::disassociate_data_share_consumer_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisassociateDataShareConsumerResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisassociateDataShareConsumerResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DisassociateDataShareConsumerResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DisassociateDataShareConsumerResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShareArn") /* DataShareArn com.amazonaws.redshift.synthetic#DisassociateDataShareConsumerOutput$DataShareArn */ =>  {
                let var_305 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_share_arn(var_305);
            }
            ,
            s if s.matches("ProducerArn") /* ProducerArn com.amazonaws.redshift.synthetic#DisassociateDataShareConsumerOutput$ProducerArn */ =>  {
                let var_306 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_producer_arn(var_306);
            }
            ,
            s if s.matches("AllowPubliclyAccessibleConsumers") /* AllowPubliclyAccessibleConsumers com.amazonaws.redshift.synthetic#DisassociateDataShareConsumerOutput$AllowPubliclyAccessibleConsumers */ =>  {
                let var_307 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_publicly_accessible_consumers(var_307);
            }
            ,
            s if s.matches("DataShareAssociations") /* DataShareAssociations com.amazonaws.redshift.synthetic#DisassociateDataShareConsumerOutput$DataShareAssociations */ =>  {
                let var_308 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_share_associations(var_308);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DisassociateDataShareConsumerResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_bucket_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::bucket_not_found_fault::Builder,
) -> Result<crate::error::bucket_not_found_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#BucketNotFoundFault$message */ =>  {
                let var_309 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_309);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_insufficient_s3_bucket_policy_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::insufficient_s3_bucket_policy_fault::Builder,
) -> Result<
    crate::error::insufficient_s3_bucket_policy_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InsufficientS3BucketPolicyFault$message */ =>  {
                let var_310 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_310);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_s3_bucket_name_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_s3_bucket_name_fault::Builder,
) -> Result<crate::error::invalid_s3_bucket_name_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidS3BucketNameFault$message */ =>  {
                let var_311 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_311);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_s3_key_prefix_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_s3_key_prefix_fault::Builder,
) -> Result<crate::error::invalid_s3_key_prefix_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidS3KeyPrefixFault$message */ =>  {
                let var_312 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_312);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_logging(
    inp: &[u8],
    mut builder: crate::output::enable_logging_output::Builder,
) -> Result<crate::output::enable_logging_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableLoggingResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableLoggingResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("EnableLoggingResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected EnableLoggingResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("LoggingEnabled") /* LoggingEnabled com.amazonaws.redshift.synthetic#EnableLoggingOutput$LoggingEnabled */ =>  {
                let var_313 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_logging_enabled(var_313);
            }
            ,
            s if s.matches("BucketName") /* BucketName com.amazonaws.redshift.synthetic#EnableLoggingOutput$BucketName */ =>  {
                let var_314 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket_name(var_314);
            }
            ,
            s if s.matches("S3KeyPrefix") /* S3KeyPrefix com.amazonaws.redshift.synthetic#EnableLoggingOutput$S3KeyPrefix */ =>  {
                let var_315 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_s3_key_prefix(var_315);
            }
            ,
            s if s.matches("LastSuccessfulDeliveryTime") /* LastSuccessfulDeliveryTime com.amazonaws.redshift.synthetic#EnableLoggingOutput$LastSuccessfulDeliveryTime */ =>  {
                let var_316 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_successful_delivery_time(var_316);
            }
            ,
            s if s.matches("LastFailureTime") /* LastFailureTime com.amazonaws.redshift.synthetic#EnableLoggingOutput$LastFailureTime */ =>  {
                let var_317 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_failure_time(var_317);
            }
            ,
            s if s.matches("LastFailureMessage") /* LastFailureMessage com.amazonaws.redshift.synthetic#EnableLoggingOutput$LastFailureMessage */ =>  {
                let var_318 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_last_failure_message(var_318);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected EnableLoggingResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_copy_to_region_disabled_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::copy_to_region_disabled_fault::Builder,
) -> Result<crate::error::copy_to_region_disabled_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#CopyToRegionDisabledFault$message */ =>  {
                let var_319 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_319);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_incompatible_orderable_options_xml_err(
    inp: &[u8],
    mut builder: crate::error::incompatible_orderable_options::Builder,
) -> Result<crate::error::incompatible_orderable_options::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#IncompatibleOrderableOptions$message */ =>  {
                let var_320 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_320);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_copy_already_enabled_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_copy_already_enabled_fault::Builder,
) -> Result<
    crate::error::snapshot_copy_already_enabled_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotCopyAlreadyEnabledFault$message */ =>  {
                let var_321 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_321);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unknown_snapshot_copy_region_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::unknown_snapshot_copy_region_fault::Builder,
) -> Result<
    crate::error::unknown_snapshot_copy_region_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#UnknownSnapshotCopyRegionFault$message */ =>  {
                let var_322 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_322);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_snapshot_copy(
    inp: &[u8],
    mut builder: crate::output::enable_snapshot_copy_output::Builder,
) -> Result<crate::output::enable_snapshot_copy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableSnapshotCopyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableSnapshotCopyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("EnableSnapshotCopyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected EnableSnapshotCopyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#EnableSnapshotCopyOutput$Cluster */ =>  {
                let var_323 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_323);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected EnableSnapshotCopyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_cluster_credentials(
    inp: &[u8],
    mut builder: crate::output::get_cluster_credentials_output::Builder,
) -> Result<crate::output::get_cluster_credentials_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetClusterCredentialsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetClusterCredentialsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetClusterCredentialsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetClusterCredentialsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DbUser") /* DbUser com.amazonaws.redshift.synthetic#GetClusterCredentialsOutput$DbUser */ =>  {
                let var_324 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_db_user(var_324);
            }
            ,
            s if s.matches("DbPassword") /* DbPassword com.amazonaws.redshift.synthetic#GetClusterCredentialsOutput$DbPassword */ =>  {
                let var_325 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_db_password(var_325);
            }
            ,
            s if s.matches("Expiration") /* Expiration com.amazonaws.redshift.synthetic#GetClusterCredentialsOutput$Expiration */ =>  {
                let var_326 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_expiration(var_326);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetClusterCredentialsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_reserved_node_exchange_offerings(
    inp: &[u8],
    mut builder: crate::output::get_reserved_node_exchange_offerings_output::Builder,
) -> Result<
    crate::output::get_reserved_node_exchange_offerings_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetReservedNodeExchangeOfferingsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetReservedNodeExchangeOfferingsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetReservedNodeExchangeOfferingsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetReservedNodeExchangeOfferingsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Marker") /* Marker com.amazonaws.redshift.synthetic#GetReservedNodeExchangeOfferingsOutput$Marker */ =>  {
                let var_327 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_327);
            }
            ,
            s if s.matches("ReservedNodeOfferings") /* ReservedNodeOfferings com.amazonaws.redshift.synthetic#GetReservedNodeExchangeOfferingsOutput$ReservedNodeOfferings */ =>  {
                let var_328 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_reserved_node_offering_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_node_offerings(var_328);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetReservedNodeExchangeOfferingsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_aqua_configuration(
    inp: &[u8],
    mut builder: crate::output::modify_aqua_configuration_output::Builder,
) -> Result<
    crate::output::modify_aqua_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyAquaConfigurationResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyAquaConfigurationResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyAquaConfigurationResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyAquaConfigurationResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AquaConfiguration") /* AquaConfiguration com.amazonaws.redshift.synthetic#ModifyAquaConfigurationOutput$AquaConfiguration */ =>  {
                let var_329 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_aqua_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_aqua_configuration(var_329);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyAquaConfigurationResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_authentication_profile(
    inp: &[u8],
    mut builder: crate::output::modify_authentication_profile_output::Builder,
) -> Result<
    crate::output::modify_authentication_profile_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyAuthenticationProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyAuthenticationProfileResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyAuthenticationProfileResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyAuthenticationProfileResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AuthenticationProfileName") /* AuthenticationProfileName com.amazonaws.redshift.synthetic#ModifyAuthenticationProfileOutput$AuthenticationProfileName */ =>  {
                let var_330 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_authentication_profile_name(var_330);
            }
            ,
            s if s.matches("AuthenticationProfileContent") /* AuthenticationProfileContent com.amazonaws.redshift.synthetic#ModifyAuthenticationProfileOutput$AuthenticationProfileContent */ =>  {
                let var_331 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_authentication_profile_content(var_331);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyAuthenticationProfileResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_table_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::table_limit_exceeded_fault::Builder,
) -> Result<crate::error::table_limit_exceeded_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#TableLimitExceededFault$message */ =>  {
                let var_332 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_332);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unsupported_option_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::unsupported_option_fault::Builder,
) -> Result<crate::error::unsupported_option_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#UnsupportedOptionFault$message */ =>  {
                let var_333 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_333);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_cluster(
    inp: &[u8],
    mut builder: crate::output::modify_cluster_output::Builder,
) -> Result<crate::output::modify_cluster_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClusterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClusterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyClusterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyClusterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#ModifyClusterOutput$Cluster */ =>  {
                let var_334 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_334);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyClusterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_cluster_on_latest_revision_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::cluster_on_latest_revision_fault::Builder,
) -> Result<crate::error::cluster_on_latest_revision_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ClusterOnLatestRevisionFault$message */ =>  {
                let var_335 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_335);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_cluster_db_revision(
    inp: &[u8],
    mut builder: crate::output::modify_cluster_db_revision_output::Builder,
) -> Result<
    crate::output::modify_cluster_db_revision_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClusterDbRevisionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClusterDbRevisionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyClusterDbRevisionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyClusterDbRevisionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#ModifyClusterDbRevisionOutput$Cluster */ =>  {
                let var_336 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_336);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyClusterDbRevisionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_cluster_iam_roles(
    inp: &[u8],
    mut builder: crate::output::modify_cluster_iam_roles_output::Builder,
) -> Result<crate::output::modify_cluster_iam_roles_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClusterIamRolesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClusterIamRolesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyClusterIamRolesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyClusterIamRolesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#ModifyClusterIamRolesOutput$Cluster */ =>  {
                let var_337 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_337);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyClusterIamRolesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_cluster_maintenance(
    inp: &[u8],
    mut builder: crate::output::modify_cluster_maintenance_output::Builder,
) -> Result<
    crate::output::modify_cluster_maintenance_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClusterMaintenanceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClusterMaintenanceResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyClusterMaintenanceResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyClusterMaintenanceResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#ModifyClusterMaintenanceOutput$Cluster */ =>  {
                let var_338 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_338);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyClusterMaintenanceResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_cluster_parameter_group(
    inp: &[u8],
    mut builder: crate::output::modify_cluster_parameter_group_output::Builder,
) -> Result<
    crate::output::modify_cluster_parameter_group_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClusterParameterGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClusterParameterGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyClusterParameterGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyClusterParameterGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ParameterGroupName") /* ParameterGroupName com.amazonaws.redshift.synthetic#ModifyClusterParameterGroupOutput$ParameterGroupName */ =>  {
                let var_339 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_name(var_339);
            }
            ,
            s if s.matches("ParameterGroupStatus") /* ParameterGroupStatus com.amazonaws.redshift.synthetic#ModifyClusterParameterGroupOutput$ParameterGroupStatus */ =>  {
                let var_340 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_status(var_340);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyClusterParameterGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_cluster_snapshot(
    inp: &[u8],
    mut builder: crate::output::modify_cluster_snapshot_output::Builder,
) -> Result<crate::output::modify_cluster_snapshot_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClusterSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClusterSnapshotResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyClusterSnapshotResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyClusterSnapshotResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Snapshot") /* Snapshot com.amazonaws.redshift.synthetic#ModifyClusterSnapshotOutput$Snapshot */ =>  {
                let var_341 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot(var_341);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyClusterSnapshotResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_subnet_already_in_use_xml_err(
    inp: &[u8],
    mut builder: crate::error::subnet_already_in_use::Builder,
) -> Result<crate::error::subnet_already_in_use::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SubnetAlreadyInUse$message */ =>  {
                let var_342 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_342);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_cluster_subnet_group(
    inp: &[u8],
    mut builder: crate::output::modify_cluster_subnet_group_output::Builder,
) -> Result<
    crate::output::modify_cluster_subnet_group_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyClusterSubnetGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyClusterSubnetGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyClusterSubnetGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyClusterSubnetGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterSubnetGroup") /* ClusterSubnetGroup com.amazonaws.redshift.synthetic#ModifyClusterSubnetGroupOutput$ClusterSubnetGroup */ =>  {
                let var_343 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster_subnet_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_subnet_group(var_343);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyClusterSubnetGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_endpoint_access(
    inp: &[u8],
    mut builder: crate::output::modify_endpoint_access_output::Builder,
) -> Result<crate::output::modify_endpoint_access_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyEndpointAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyEndpointAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyEndpointAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyEndpointAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$ClusterIdentifier */ =>  {
                let var_344 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_344);
            }
            ,
            s if s.matches("ResourceOwner") /* ResourceOwner com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$ResourceOwner */ =>  {
                let var_345 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_owner(var_345);
            }
            ,
            s if s.matches("SubnetGroupName") /* SubnetGroupName com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$SubnetGroupName */ =>  {
                let var_346 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_group_name(var_346);
            }
            ,
            s if s.matches("EndpointStatus") /* EndpointStatus com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$EndpointStatus */ =>  {
                let var_347 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_status(var_347);
            }
            ,
            s if s.matches("EndpointName") /* EndpointName com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$EndpointName */ =>  {
                let var_348 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_name(var_348);
            }
            ,
            s if s.matches("EndpointCreateTime") /* EndpointCreateTime com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$EndpointCreateTime */ =>  {
                let var_349 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_endpoint_create_time(var_349);
            }
            ,
            s if s.matches("Port") /* Port com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$Port */ =>  {
                let var_350 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_port(var_350);
            }
            ,
            s if s.matches("Address") /* Address com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$Address */ =>  {
                let var_351 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_address(var_351);
            }
            ,
            s if s.matches("VpcSecurityGroups") /* VpcSecurityGroups com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$VpcSecurityGroups */ =>  {
                let var_352 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_security_group_membership_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_security_groups(var_352);
            }
            ,
            s if s.matches("VpcEndpoint") /* VpcEndpoint com.amazonaws.redshift.synthetic#ModifyEndpointAccessOutput$VpcEndpoint */ =>  {
                let var_353 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoint(var_353);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyEndpointAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_event_subscription(
    inp: &[u8],
    mut builder: crate::output::modify_event_subscription_output::Builder,
) -> Result<
    crate::output::modify_event_subscription_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyEventSubscriptionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyEventSubscriptionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyEventSubscriptionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyEventSubscriptionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EventSubscription") /* EventSubscription com.amazonaws.redshift.synthetic#ModifyEventSubscriptionOutput$EventSubscription */ =>  {
                let var_354 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_event_subscription(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_subscription(var_354);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyEventSubscriptionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_scheduled_action(
    inp: &[u8],
    mut builder: crate::output::modify_scheduled_action_output::Builder,
) -> Result<crate::output::modify_scheduled_action_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyScheduledActionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyScheduledActionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyScheduledActionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyScheduledActionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ScheduledActionName") /* ScheduledActionName com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$ScheduledActionName */ =>  {
                let var_355 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_scheduled_action_name(var_355);
            }
            ,
            s if s.matches("TargetAction") /* TargetAction com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$TargetAction */ =>  {
                let var_356 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_scheduled_action_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_target_action(var_356);
            }
            ,
            s if s.matches("Schedule") /* Schedule com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$Schedule */ =>  {
                let var_357 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule(var_357);
            }
            ,
            s if s.matches("IamRole") /* IamRole com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$IamRole */ =>  {
                let var_358 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_iam_role(var_358);
            }
            ,
            s if s.matches("ScheduledActionDescription") /* ScheduledActionDescription com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$ScheduledActionDescription */ =>  {
                let var_359 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_scheduled_action_description(var_359);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$State */ =>  {
                let var_360 =
                    Some(
                        Result::<crate::model::ScheduledActionState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ScheduledActionState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_360);
            }
            ,
            s if s.matches("NextInvocations") /* NextInvocations com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$NextInvocations */ =>  {
                let var_361 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_scheduled_action_time_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_next_invocations(var_361);
            }
            ,
            s if s.matches("StartTime") /* StartTime com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$StartTime */ =>  {
                let var_362 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_362);
            }
            ,
            s if s.matches("EndTime") /* EndTime com.amazonaws.redshift.synthetic#ModifyScheduledActionOutput$EndTime */ =>  {
                let var_363 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_end_time(var_363);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyScheduledActionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_copy_disabled_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_copy_disabled_fault::Builder,
) -> Result<crate::error::snapshot_copy_disabled_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotCopyDisabledFault$message */ =>  {
                let var_364 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_364);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_snapshot_copy_retention_period(
    inp: &[u8],
    mut builder: crate::output::modify_snapshot_copy_retention_period_output::Builder,
) -> Result<
    crate::output::modify_snapshot_copy_retention_period_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifySnapshotCopyRetentionPeriodResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifySnapshotCopyRetentionPeriodResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifySnapshotCopyRetentionPeriodResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifySnapshotCopyRetentionPeriodResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#ModifySnapshotCopyRetentionPeriodOutput$Cluster */ =>  {
                let var_365 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_365);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifySnapshotCopyRetentionPeriodResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_snapshot_schedule_update_in_progress_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::snapshot_schedule_update_in_progress_fault::Builder,
) -> Result<
    crate::error::snapshot_schedule_update_in_progress_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#SnapshotScheduleUpdateInProgressFault$message */ =>  {
                let var_366 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_366);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_snapshot_schedule(
    inp: &[u8],
    mut builder: crate::output::modify_snapshot_schedule_output::Builder,
) -> Result<crate::output::modify_snapshot_schedule_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifySnapshotScheduleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifySnapshotScheduleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifySnapshotScheduleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifySnapshotScheduleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ScheduleDefinitions") /* ScheduleDefinitions com.amazonaws.redshift.synthetic#ModifySnapshotScheduleOutput$ScheduleDefinitions */ =>  {
                let var_367 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_schedule_definition_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_schedule_definitions(var_367);
            }
            ,
            s if s.matches("ScheduleIdentifier") /* ScheduleIdentifier com.amazonaws.redshift.synthetic#ModifySnapshotScheduleOutput$ScheduleIdentifier */ =>  {
                let var_368 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule_identifier(var_368);
            }
            ,
            s if s.matches("ScheduleDescription") /* ScheduleDescription com.amazonaws.redshift.synthetic#ModifySnapshotScheduleOutput$ScheduleDescription */ =>  {
                let var_369 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule_description(var_369);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift.synthetic#ModifySnapshotScheduleOutput$Tags */ =>  {
                let var_370 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_370);
            }
            ,
            s if s.matches("NextInvocations") /* NextInvocations com.amazonaws.redshift.synthetic#ModifySnapshotScheduleOutput$NextInvocations */ =>  {
                let var_371 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_scheduled_snapshot_time_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_next_invocations(var_371);
            }
            ,
            s if s.matches("AssociatedClusterCount") /* AssociatedClusterCount com.amazonaws.redshift.synthetic#ModifySnapshotScheduleOutput$AssociatedClusterCount */ =>  {
                let var_372 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_associated_cluster_count(var_372);
            }
            ,
            s if s.matches("AssociatedClusters") /* AssociatedClusters com.amazonaws.redshift.synthetic#ModifySnapshotScheduleOutput$AssociatedClusters */ =>  {
                let var_373 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_associated_cluster_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associated_clusters(var_373);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifySnapshotScheduleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_modify_usage_limit(
    inp: &[u8],
    mut builder: crate::output::modify_usage_limit_output::Builder,
) -> Result<crate::output::modify_usage_limit_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ModifyUsageLimitResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ModifyUsageLimitResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ModifyUsageLimitResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ModifyUsageLimitResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("UsageLimitId") /* UsageLimitId com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$UsageLimitId */ =>  {
                let var_374 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_usage_limit_id(var_374);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$ClusterIdentifier */ =>  {
                let var_375 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_375);
            }
            ,
            s if s.matches("FeatureType") /* FeatureType com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$FeatureType */ =>  {
                let var_376 =
                    Some(
                        Result::<crate::model::UsageLimitFeatureType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitFeatureType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_feature_type(var_376);
            }
            ,
            s if s.matches("LimitType") /* LimitType com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$LimitType */ =>  {
                let var_377 =
                    Some(
                        Result::<crate::model::UsageLimitLimitType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitLimitType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_limit_type(var_377);
            }
            ,
            s if s.matches("Amount") /* Amount com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$Amount */ =>  {
                let var_378 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_amount(var_378);
            }
            ,
            s if s.matches("Period") /* Period com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$Period */ =>  {
                let var_379 =
                    Some(
                        Result::<crate::model::UsageLimitPeriod, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitPeriod::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_period(var_379);
            }
            ,
            s if s.matches("BreachAction") /* BreachAction com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$BreachAction */ =>  {
                let var_380 =
                    Some(
                        Result::<crate::model::UsageLimitBreachAction, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitBreachAction::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_breach_action(var_380);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift.synthetic#ModifyUsageLimitOutput$Tags */ =>  {
                let var_381 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_381);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ModifyUsageLimitResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_pause_cluster(
    inp: &[u8],
    mut builder: crate::output::pause_cluster_output::Builder,
) -> Result<crate::output::pause_cluster_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PauseClusterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PauseClusterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("PauseClusterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected PauseClusterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#PauseClusterOutput$Cluster */ =>  {
                let var_382 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_382);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected PauseClusterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_reserved_node_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::reserved_node_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::reserved_node_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#ReservedNodeQuotaExceededFault$message */ =>  {
                let var_383 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_383);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_purchase_reserved_node_offering(
    inp: &[u8],
    mut builder: crate::output::purchase_reserved_node_offering_output::Builder,
) -> Result<
    crate::output::purchase_reserved_node_offering_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PurchaseReservedNodeOfferingResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PurchaseReservedNodeOfferingResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("PurchaseReservedNodeOfferingResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected PurchaseReservedNodeOfferingResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ReservedNode") /* ReservedNode com.amazonaws.redshift.synthetic#PurchaseReservedNodeOfferingOutput$ReservedNode */ =>  {
                let var_384 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_reserved_node(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reserved_node(var_384);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected PurchaseReservedNodeOfferingResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reboot_cluster(
    inp: &[u8],
    mut builder: crate::output::reboot_cluster_output::Builder,
) -> Result<crate::output::reboot_cluster_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RebootClusterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RebootClusterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RebootClusterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RebootClusterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#RebootClusterOutput$Cluster */ =>  {
                let var_385 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_385);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RebootClusterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reject_data_share(
    inp: &[u8],
    mut builder: crate::output::reject_data_share_output::Builder,
) -> Result<crate::output::reject_data_share_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RejectDataShareResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RejectDataShareResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RejectDataShareResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RejectDataShareResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DataShareArn") /* DataShareArn com.amazonaws.redshift.synthetic#RejectDataShareOutput$DataShareArn */ =>  {
                let var_386 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_share_arn(var_386);
            }
            ,
            s if s.matches("ProducerArn") /* ProducerArn com.amazonaws.redshift.synthetic#RejectDataShareOutput$ProducerArn */ =>  {
                let var_387 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_producer_arn(var_387);
            }
            ,
            s if s.matches("AllowPubliclyAccessibleConsumers") /* AllowPubliclyAccessibleConsumers com.amazonaws.redshift.synthetic#RejectDataShareOutput$AllowPubliclyAccessibleConsumers */ =>  {
                let var_388 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_publicly_accessible_consumers(var_388);
            }
            ,
            s if s.matches("DataShareAssociations") /* DataShareAssociations com.amazonaws.redshift.synthetic#RejectDataShareOutput$DataShareAssociations */ =>  {
                let var_389 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_share_associations(var_389);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RejectDataShareResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reset_cluster_parameter_group(
    inp: &[u8],
    mut builder: crate::output::reset_cluster_parameter_group_output::Builder,
) -> Result<
    crate::output::reset_cluster_parameter_group_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ResetClusterParameterGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ResetClusterParameterGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ResetClusterParameterGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ResetClusterParameterGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ParameterGroupName") /* ParameterGroupName com.amazonaws.redshift.synthetic#ResetClusterParameterGroupOutput$ParameterGroupName */ =>  {
                let var_390 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_name(var_390);
            }
            ,
            s if s.matches("ParameterGroupStatus") /* ParameterGroupStatus com.amazonaws.redshift.synthetic#ResetClusterParameterGroupOutput$ParameterGroupStatus */ =>  {
                let var_391 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_status(var_391);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ResetClusterParameterGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_resize_cluster(
    inp: &[u8],
    mut builder: crate::output::resize_cluster_output::Builder,
) -> Result<crate::output::resize_cluster_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ResizeClusterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ResizeClusterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ResizeClusterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ResizeClusterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#ResizeClusterOutput$Cluster */ =>  {
                let var_392 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_392);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ResizeClusterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_restore_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_restore_fault::Builder,
) -> Result<crate::error::invalid_restore_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidRestoreFault$message */ =>  {
                let var_393 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_393);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_restore_from_cluster_snapshot(
    inp: &[u8],
    mut builder: crate::output::restore_from_cluster_snapshot_output::Builder,
) -> Result<
    crate::output::restore_from_cluster_snapshot_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RestoreFromClusterSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RestoreFromClusterSnapshotResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RestoreFromClusterSnapshotResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RestoreFromClusterSnapshotResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#RestoreFromClusterSnapshotOutput$Cluster */ =>  {
                let var_394 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_394);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RestoreFromClusterSnapshotResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_in_progress_table_restore_quota_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::in_progress_table_restore_quota_exceeded_fault::Builder,
) -> Result<
    crate::error::in_progress_table_restore_quota_exceeded_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InProgressTableRestoreQuotaExceededFault$message */ =>  {
                let var_395 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_395);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_table_restore_argument_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_table_restore_argument_fault::Builder,
) -> Result<
    crate::error::invalid_table_restore_argument_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#InvalidTableRestoreArgumentFault$message */ =>  {
                let var_396 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_396);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_restore_table_from_cluster_snapshot(
    inp: &[u8],
    mut builder: crate::output::restore_table_from_cluster_snapshot_output::Builder,
) -> Result<
    crate::output::restore_table_from_cluster_snapshot_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RestoreTableFromClusterSnapshotResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RestoreTableFromClusterSnapshotResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RestoreTableFromClusterSnapshotResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RestoreTableFromClusterSnapshotResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("TableRestoreStatus") /* TableRestoreStatus com.amazonaws.redshift.synthetic#RestoreTableFromClusterSnapshotOutput$TableRestoreStatus */ =>  {
                let var_397 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_table_restore_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_table_restore_status(var_397);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RestoreTableFromClusterSnapshotResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_resume_cluster(
    inp: &[u8],
    mut builder: crate::output::resume_cluster_output::Builder,
) -> Result<crate::output::resume_cluster_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ResumeClusterResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ResumeClusterResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ResumeClusterResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ResumeClusterResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#ResumeClusterOutput$Cluster */ =>  {
                let var_398 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_398);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ResumeClusterResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_authorization_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::authorization_not_found_fault::Builder,
) -> Result<crate::error::authorization_not_found_fault::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#AuthorizationNotFoundFault$message */ =>  {
                let var_399 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_399);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_revoke_cluster_security_group_ingress(
    inp: &[u8],
    mut builder: crate::output::revoke_cluster_security_group_ingress_output::Builder,
) -> Result<
    crate::output::revoke_cluster_security_group_ingress_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RevokeClusterSecurityGroupIngressResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RevokeClusterSecurityGroupIngressResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RevokeClusterSecurityGroupIngressResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RevokeClusterSecurityGroupIngressResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ClusterSecurityGroup") /* ClusterSecurityGroup com.amazonaws.redshift.synthetic#RevokeClusterSecurityGroupIngressOutput$ClusterSecurityGroup */ =>  {
                let var_400 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster_security_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_security_group(var_400);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RevokeClusterSecurityGroupIngressResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_endpoint_authorization_not_found_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::endpoint_authorization_not_found_fault::Builder,
) -> Result<
    crate::error::endpoint_authorization_not_found_fault::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.redshift#EndpointAuthorizationNotFoundFault$message */ =>  {
                let var_401 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_401);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_revoke_endpoint_access(
    inp: &[u8],
    mut builder: crate::output::revoke_endpoint_access_output::Builder,
) -> Result<crate::output::revoke_endpoint_access_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RevokeEndpointAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RevokeEndpointAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RevokeEndpointAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RevokeEndpointAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Grantor") /* Grantor com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$Grantor */ =>  {
                let var_402 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_grantor(var_402);
            }
            ,
            s if s.matches("Grantee") /* Grantee com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$Grantee */ =>  {
                let var_403 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_grantee(var_403);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$ClusterIdentifier */ =>  {
                let var_404 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_404);
            }
            ,
            s if s.matches("AuthorizeTime") /* AuthorizeTime com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$AuthorizeTime */ =>  {
                let var_405 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_authorize_time(var_405);
            }
            ,
            s if s.matches("ClusterStatus") /* ClusterStatus com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$ClusterStatus */ =>  {
                let var_406 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_status(var_406);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$Status */ =>  {
                let var_407 =
                    Some(
                        Result::<crate::model::AuthorizationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AuthorizationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_407);
            }
            ,
            s if s.matches("AllowedAllVPCs") /* AllowedAllVPCs com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$AllowedAllVPCs */ =>  {
                let var_408 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allowed_all_vp_cs(var_408);
            }
            ,
            s if s.matches("AllowedVPCs") /* AllowedVPCs com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$AllowedVPCs */ =>  {
                let var_409 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_allowed_vp_cs(var_409);
            }
            ,
            s if s.matches("EndpointCount") /* EndpointCount com.amazonaws.redshift.synthetic#RevokeEndpointAccessOutput$EndpointCount */ =>  {
                let var_410 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_endpoint_count(var_410);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RevokeEndpointAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_revoke_snapshot_access(
    inp: &[u8],
    mut builder: crate::output::revoke_snapshot_access_output::Builder,
) -> Result<crate::output::revoke_snapshot_access_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RevokeSnapshotAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RevokeSnapshotAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RevokeSnapshotAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RevokeSnapshotAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Snapshot") /* Snapshot com.amazonaws.redshift.synthetic#RevokeSnapshotAccessOutput$Snapshot */ =>  {
                let var_411 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_snapshot(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_snapshot(var_411);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RevokeSnapshotAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_rotate_encryption_key(
    inp: &[u8],
    mut builder: crate::output::rotate_encryption_key_output::Builder,
) -> Result<crate::output::rotate_encryption_key_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("RotateEncryptionKeyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected RotateEncryptionKeyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("RotateEncryptionKeyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected RotateEncryptionKeyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Cluster") /* Cluster com.amazonaws.redshift.synthetic#RotateEncryptionKeyOutput$Cluster */ =>  {
                let var_412 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster(var_412);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected RotateEncryptionKeyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_partner_status(
    inp: &[u8],
    mut builder: crate::output::update_partner_status_output::Builder,
) -> Result<crate::output::update_partner_status_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdatePartnerStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdatePartnerStatusResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdatePartnerStatusResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdatePartnerStatusResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DatabaseName") /* DatabaseName com.amazonaws.redshift.synthetic#UpdatePartnerStatusOutput$DatabaseName */ =>  {
                let var_413 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_database_name(var_413);
            }
            ,
            s if s.matches("PartnerName") /* PartnerName com.amazonaws.redshift.synthetic#UpdatePartnerStatusOutput$PartnerName */ =>  {
                let var_414 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_partner_name(var_414);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdatePartnerStatusResult tag",
        ));
    };
    Ok(builder)
}

pub fn deser_structure_crate_model_reserved_node(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReservedNode, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReservedNode::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ReservedNodeId") /* ReservedNodeId com.amazonaws.redshift#ReservedNode$ReservedNodeId */ =>  {
                let var_415 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_reserved_node_id(var_415);
            }
            ,
            s if s.matches("ReservedNodeOfferingId") /* ReservedNodeOfferingId com.amazonaws.redshift#ReservedNode$ReservedNodeOfferingId */ =>  {
                let var_416 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_reserved_node_offering_id(var_416);
            }
            ,
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#ReservedNode$NodeType */ =>  {
                let var_417 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_417);
            }
            ,
            s if s.matches("StartTime") /* StartTime com.amazonaws.redshift#ReservedNode$StartTime */ =>  {
                let var_418 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_418);
            }
            ,
            s if s.matches("Duration") /* Duration com.amazonaws.redshift#ReservedNode$Duration */ =>  {
                let var_419 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_duration(var_419);
            }
            ,
            s if s.matches("FixedPrice") /* FixedPrice com.amazonaws.redshift#ReservedNode$FixedPrice */ =>  {
                let var_420 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_fixed_price(var_420);
            }
            ,
            s if s.matches("UsagePrice") /* UsagePrice com.amazonaws.redshift#ReservedNode$UsagePrice */ =>  {
                let var_421 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_usage_price(var_421);
            }
            ,
            s if s.matches("CurrencyCode") /* CurrencyCode com.amazonaws.redshift#ReservedNode$CurrencyCode */ =>  {
                let var_422 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_currency_code(var_422);
            }
            ,
            s if s.matches("NodeCount") /* NodeCount com.amazonaws.redshift#ReservedNode$NodeCount */ =>  {
                let var_423 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_node_count(var_423);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.redshift#ReservedNode$State */ =>  {
                let var_424 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_424);
            }
            ,
            s if s.matches("OfferingType") /* OfferingType com.amazonaws.redshift#ReservedNode$OfferingType */ =>  {
                let var_425 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_offering_type(var_425);
            }
            ,
            s if s.matches("RecurringCharges") /* RecurringCharges com.amazonaws.redshift#ReservedNode$RecurringCharges */ =>  {
                let var_426 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_recurring_charge_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_recurring_charges(var_426);
            }
            ,
            s if s.matches("ReservedNodeOfferingType") /* ReservedNodeOfferingType com.amazonaws.redshift#ReservedNode$ReservedNodeOfferingType */ =>  {
                let var_427 =
                    Some(
                        Result::<crate::model::ReservedNodeOfferingType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReservedNodeOfferingType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_reserved_node_offering_type(var_427);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_data_share_association_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::DataShareAssociation>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#DataShareAssociationList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_data_share_association(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_cluster_security_group(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterSecurityGroup, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterSecurityGroup::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterSecurityGroupName") /* ClusterSecurityGroupName com.amazonaws.redshift#ClusterSecurityGroup$ClusterSecurityGroupName */ =>  {
                let var_428 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_security_group_name(var_428);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.redshift#ClusterSecurityGroup$Description */ =>  {
                let var_429 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_429);
            }
            ,
            s if s.matches("EC2SecurityGroups") /* EC2SecurityGroups com.amazonaws.redshift#ClusterSecurityGroup$EC2SecurityGroups */ =>  {
                let var_430 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_ec2_security_group_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ec2_security_groups(var_430);
            }
            ,
            s if s.matches("IPRanges") /* IPRanges com.amazonaws.redshift#ClusterSecurityGroup$IPRanges */ =>  {
                let var_431 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_ip_range_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ip_ranges(var_431);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#ClusterSecurityGroup$Tags */ =>  {
                let var_432 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_432);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_vpc_identifier_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VpcIdentifier") /* member com.amazonaws.redshift#VpcIdentifierList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_snapshot(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Snapshot, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Snapshot::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotIdentifier") /* SnapshotIdentifier com.amazonaws.redshift#Snapshot$SnapshotIdentifier */ =>  {
                let var_433 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_identifier(var_433);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#Snapshot$ClusterIdentifier */ =>  {
                let var_434 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_434);
            }
            ,
            s if s.matches("SnapshotCreateTime") /* SnapshotCreateTime com.amazonaws.redshift#Snapshot$SnapshotCreateTime */ =>  {
                let var_435 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_snapshot_create_time(var_435);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#Snapshot$Status */ =>  {
                let var_436 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_436);
            }
            ,
            s if s.matches("Port") /* Port com.amazonaws.redshift#Snapshot$Port */ =>  {
                let var_437 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_port(var_437);
            }
            ,
            s if s.matches("AvailabilityZone") /* AvailabilityZone com.amazonaws.redshift#Snapshot$AvailabilityZone */ =>  {
                let var_438 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone(var_438);
            }
            ,
            s if s.matches("ClusterCreateTime") /* ClusterCreateTime com.amazonaws.redshift#Snapshot$ClusterCreateTime */ =>  {
                let var_439 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_cluster_create_time(var_439);
            }
            ,
            s if s.matches("MasterUsername") /* MasterUsername com.amazonaws.redshift#Snapshot$MasterUsername */ =>  {
                let var_440 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_master_username(var_440);
            }
            ,
            s if s.matches("ClusterVersion") /* ClusterVersion com.amazonaws.redshift#Snapshot$ClusterVersion */ =>  {
                let var_441 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_version(var_441);
            }
            ,
            s if s.matches("EngineFullVersion") /* EngineFullVersion com.amazonaws.redshift#Snapshot$EngineFullVersion */ =>  {
                let var_442 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_engine_full_version(var_442);
            }
            ,
            s if s.matches("SnapshotType") /* SnapshotType com.amazonaws.redshift#Snapshot$SnapshotType */ =>  {
                let var_443 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_type(var_443);
            }
            ,
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#Snapshot$NodeType */ =>  {
                let var_444 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_444);
            }
            ,
            s if s.matches("NumberOfNodes") /* NumberOfNodes com.amazonaws.redshift#Snapshot$NumberOfNodes */ =>  {
                let var_445 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_nodes(var_445);
            }
            ,
            s if s.matches("DBName") /* DBName com.amazonaws.redshift#Snapshot$DBName */ =>  {
                let var_446 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_db_name(var_446);
            }
            ,
            s if s.matches("VpcId") /* VpcId com.amazonaws.redshift#Snapshot$VpcId */ =>  {
                let var_447 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_447);
            }
            ,
            s if s.matches("Encrypted") /* Encrypted com.amazonaws.redshift#Snapshot$Encrypted */ =>  {
                let var_448 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_encrypted(var_448);
            }
            ,
            s if s.matches("KmsKeyId") /* KmsKeyId com.amazonaws.redshift#Snapshot$KmsKeyId */ =>  {
                let var_449 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_449);
            }
            ,
            s if s.matches("EncryptedWithHSM") /* EncryptedWithHSM com.amazonaws.redshift#Snapshot$EncryptedWithHSM */ =>  {
                let var_450 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_encrypted_with_hsm(var_450);
            }
            ,
            s if s.matches("AccountsWithRestoreAccess") /* AccountsWithRestoreAccess com.amazonaws.redshift#Snapshot$AccountsWithRestoreAccess */ =>  {
                let var_451 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_accounts_with_restore_access_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_accounts_with_restore_access(var_451);
            }
            ,
            s if s.matches("OwnerAccount") /* OwnerAccount com.amazonaws.redshift#Snapshot$OwnerAccount */ =>  {
                let var_452 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_owner_account(var_452);
            }
            ,
            s if s.matches("TotalBackupSizeInMegaBytes") /* TotalBackupSizeInMegaBytes com.amazonaws.redshift#Snapshot$TotalBackupSizeInMegaBytes */ =>  {
                let var_453 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_backup_size_in_mega_bytes(var_453);
            }
            ,
            s if s.matches("ActualIncrementalBackupSizeInMegaBytes") /* ActualIncrementalBackupSizeInMegaBytes com.amazonaws.redshift#Snapshot$ActualIncrementalBackupSizeInMegaBytes */ =>  {
                let var_454 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_actual_incremental_backup_size_in_mega_bytes(var_454);
            }
            ,
            s if s.matches("BackupProgressInMegaBytes") /* BackupProgressInMegaBytes com.amazonaws.redshift#Snapshot$BackupProgressInMegaBytes */ =>  {
                let var_455 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_backup_progress_in_mega_bytes(var_455);
            }
            ,
            s if s.matches("CurrentBackupRateInMegaBytesPerSecond") /* CurrentBackupRateInMegaBytesPerSecond com.amazonaws.redshift#Snapshot$CurrentBackupRateInMegaBytesPerSecond */ =>  {
                let var_456 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_current_backup_rate_in_mega_bytes_per_second(var_456);
            }
            ,
            s if s.matches("EstimatedSecondsToCompletion") /* EstimatedSecondsToCompletion com.amazonaws.redshift#Snapshot$EstimatedSecondsToCompletion */ =>  {
                let var_457 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_estimated_seconds_to_completion(var_457);
            }
            ,
            s if s.matches("ElapsedTimeInSeconds") /* ElapsedTimeInSeconds com.amazonaws.redshift#Snapshot$ElapsedTimeInSeconds */ =>  {
                let var_458 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_elapsed_time_in_seconds(var_458);
            }
            ,
            s if s.matches("SourceRegion") /* SourceRegion com.amazonaws.redshift#Snapshot$SourceRegion */ =>  {
                let var_459 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_region(var_459);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#Snapshot$Tags */ =>  {
                let var_460 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_460);
            }
            ,
            s if s.matches("RestorableNodeTypes") /* RestorableNodeTypes com.amazonaws.redshift#Snapshot$RestorableNodeTypes */ =>  {
                let var_461 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_restorable_node_type_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_restorable_node_types(var_461);
            }
            ,
            s if s.matches("EnhancedVpcRouting") /* EnhancedVpcRouting com.amazonaws.redshift#Snapshot$EnhancedVpcRouting */ =>  {
                let var_462 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enhanced_vpc_routing(var_462);
            }
            ,
            s if s.matches("MaintenanceTrackName") /* MaintenanceTrackName com.amazonaws.redshift#Snapshot$MaintenanceTrackName */ =>  {
                let var_463 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_maintenance_track_name(var_463);
            }
            ,
            s if s.matches("ManualSnapshotRetentionPeriod") /* ManualSnapshotRetentionPeriod com.amazonaws.redshift#Snapshot$ManualSnapshotRetentionPeriod */ =>  {
                let var_464 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_manual_snapshot_retention_period(var_464);
            }
            ,
            s if s.matches("ManualSnapshotRemainingDays") /* ManualSnapshotRemainingDays com.amazonaws.redshift#Snapshot$ManualSnapshotRemainingDays */ =>  {
                let var_465 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_manual_snapshot_remaining_days(var_465);
            }
            ,
            s if s.matches("SnapshotRetentionStartTime") /* SnapshotRetentionStartTime com.amazonaws.redshift#Snapshot$SnapshotRetentionStartTime */ =>  {
                let var_466 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_snapshot_retention_start_time(var_466);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_snapshot_identifier_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("String") /* member com.amazonaws.redshift#SnapshotIdentifierList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_batch_snapshot_operation_error_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SnapshotErrorMessage>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotErrorMessage") /* member com.amazonaws.redshift#BatchSnapshotOperationErrorList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_snapshot_error_message(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_batch_snapshot_operation_errors(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SnapshotErrorMessage>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotErrorMessage") /* member com.amazonaws.redshift#BatchSnapshotOperationErrors$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_snapshot_error_message(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_import_tables_completed(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#ImportTablesCompleted$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_import_tables_in_progress(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#ImportTablesInProgress$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_import_tables_not_started(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#ImportTablesNotStarted$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_cluster(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Cluster, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Cluster::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#Cluster$ClusterIdentifier */ =>  {
                let var_467 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_467);
            }
            ,
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#Cluster$NodeType */ =>  {
                let var_468 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_468);
            }
            ,
            s if s.matches("ClusterStatus") /* ClusterStatus com.amazonaws.redshift#Cluster$ClusterStatus */ =>  {
                let var_469 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_status(var_469);
            }
            ,
            s if s.matches("ClusterAvailabilityStatus") /* ClusterAvailabilityStatus com.amazonaws.redshift#Cluster$ClusterAvailabilityStatus */ =>  {
                let var_470 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_availability_status(var_470);
            }
            ,
            s if s.matches("ModifyStatus") /* ModifyStatus com.amazonaws.redshift#Cluster$ModifyStatus */ =>  {
                let var_471 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_modify_status(var_471);
            }
            ,
            s if s.matches("MasterUsername") /* MasterUsername com.amazonaws.redshift#Cluster$MasterUsername */ =>  {
                let var_472 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_master_username(var_472);
            }
            ,
            s if s.matches("DBName") /* DBName com.amazonaws.redshift#Cluster$DBName */ =>  {
                let var_473 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_db_name(var_473);
            }
            ,
            s if s.matches("Endpoint") /* Endpoint com.amazonaws.redshift#Cluster$Endpoint */ =>  {
                let var_474 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_endpoint(var_474);
            }
            ,
            s if s.matches("ClusterCreateTime") /* ClusterCreateTime com.amazonaws.redshift#Cluster$ClusterCreateTime */ =>  {
                let var_475 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_cluster_create_time(var_475);
            }
            ,
            s if s.matches("AutomatedSnapshotRetentionPeriod") /* AutomatedSnapshotRetentionPeriod com.amazonaws.redshift#Cluster$AutomatedSnapshotRetentionPeriod */ =>  {
                let var_476 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_automated_snapshot_retention_period(var_476);
            }
            ,
            s if s.matches("ManualSnapshotRetentionPeriod") /* ManualSnapshotRetentionPeriod com.amazonaws.redshift#Cluster$ManualSnapshotRetentionPeriod */ =>  {
                let var_477 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_manual_snapshot_retention_period(var_477);
            }
            ,
            s if s.matches("ClusterSecurityGroups") /* ClusterSecurityGroups com.amazonaws.redshift#Cluster$ClusterSecurityGroups */ =>  {
                let var_478 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_security_group_membership_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_security_groups(var_478);
            }
            ,
            s if s.matches("VpcSecurityGroups") /* VpcSecurityGroups com.amazonaws.redshift#Cluster$VpcSecurityGroups */ =>  {
                let var_479 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_security_group_membership_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_security_groups(var_479);
            }
            ,
            s if s.matches("ClusterParameterGroups") /* ClusterParameterGroups com.amazonaws.redshift#Cluster$ClusterParameterGroups */ =>  {
                let var_480 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_parameter_group_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_parameter_groups(var_480);
            }
            ,
            s if s.matches("ClusterSubnetGroupName") /* ClusterSubnetGroupName com.amazonaws.redshift#Cluster$ClusterSubnetGroupName */ =>  {
                let var_481 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_subnet_group_name(var_481);
            }
            ,
            s if s.matches("VpcId") /* VpcId com.amazonaws.redshift#Cluster$VpcId */ =>  {
                let var_482 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_482);
            }
            ,
            s if s.matches("AvailabilityZone") /* AvailabilityZone com.amazonaws.redshift#Cluster$AvailabilityZone */ =>  {
                let var_483 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone(var_483);
            }
            ,
            s if s.matches("PreferredMaintenanceWindow") /* PreferredMaintenanceWindow com.amazonaws.redshift#Cluster$PreferredMaintenanceWindow */ =>  {
                let var_484 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_preferred_maintenance_window(var_484);
            }
            ,
            s if s.matches("PendingModifiedValues") /* PendingModifiedValues com.amazonaws.redshift#Cluster$PendingModifiedValues */ =>  {
                let var_485 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_pending_modified_values(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_pending_modified_values(var_485);
            }
            ,
            s if s.matches("ClusterVersion") /* ClusterVersion com.amazonaws.redshift#Cluster$ClusterVersion */ =>  {
                let var_486 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_version(var_486);
            }
            ,
            s if s.matches("AllowVersionUpgrade") /* AllowVersionUpgrade com.amazonaws.redshift#Cluster$AllowVersionUpgrade */ =>  {
                let var_487 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_version_upgrade(var_487);
            }
            ,
            s if s.matches("NumberOfNodes") /* NumberOfNodes com.amazonaws.redshift#Cluster$NumberOfNodes */ =>  {
                let var_488 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_nodes(var_488);
            }
            ,
            s if s.matches("PubliclyAccessible") /* PubliclyAccessible com.amazonaws.redshift#Cluster$PubliclyAccessible */ =>  {
                let var_489 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_publicly_accessible(var_489);
            }
            ,
            s if s.matches("Encrypted") /* Encrypted com.amazonaws.redshift#Cluster$Encrypted */ =>  {
                let var_490 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_encrypted(var_490);
            }
            ,
            s if s.matches("RestoreStatus") /* RestoreStatus com.amazonaws.redshift#Cluster$RestoreStatus */ =>  {
                let var_491 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_restore_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_restore_status(var_491);
            }
            ,
            s if s.matches("DataTransferProgress") /* DataTransferProgress com.amazonaws.redshift#Cluster$DataTransferProgress */ =>  {
                let var_492 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_data_transfer_progress(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_transfer_progress(var_492);
            }
            ,
            s if s.matches("HsmStatus") /* HsmStatus com.amazonaws.redshift#Cluster$HsmStatus */ =>  {
                let var_493 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_hsm_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_hsm_status(var_493);
            }
            ,
            s if s.matches("ClusterSnapshotCopyStatus") /* ClusterSnapshotCopyStatus com.amazonaws.redshift#Cluster$ClusterSnapshotCopyStatus */ =>  {
                let var_494 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_cluster_snapshot_copy_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_snapshot_copy_status(var_494);
            }
            ,
            s if s.matches("ClusterPublicKey") /* ClusterPublicKey com.amazonaws.redshift#Cluster$ClusterPublicKey */ =>  {
                let var_495 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_public_key(var_495);
            }
            ,
            s if s.matches("ClusterNodes") /* ClusterNodes com.amazonaws.redshift#Cluster$ClusterNodes */ =>  {
                let var_496 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_nodes_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_nodes(var_496);
            }
            ,
            s if s.matches("ElasticIpStatus") /* ElasticIpStatus com.amazonaws.redshift#Cluster$ElasticIpStatus */ =>  {
                let var_497 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_elastic_ip_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_elastic_ip_status(var_497);
            }
            ,
            s if s.matches("ClusterRevisionNumber") /* ClusterRevisionNumber com.amazonaws.redshift#Cluster$ClusterRevisionNumber */ =>  {
                let var_498 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_revision_number(var_498);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#Cluster$Tags */ =>  {
                let var_499 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_499);
            }
            ,
            s if s.matches("KmsKeyId") /* KmsKeyId com.amazonaws.redshift#Cluster$KmsKeyId */ =>  {
                let var_500 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_500);
            }
            ,
            s if s.matches("EnhancedVpcRouting") /* EnhancedVpcRouting com.amazonaws.redshift#Cluster$EnhancedVpcRouting */ =>  {
                let var_501 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enhanced_vpc_routing(var_501);
            }
            ,
            s if s.matches("IamRoles") /* IamRoles com.amazonaws.redshift#Cluster$IamRoles */ =>  {
                let var_502 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_iam_role_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_iam_roles(var_502);
            }
            ,
            s if s.matches("PendingActions") /* PendingActions com.amazonaws.redshift#Cluster$PendingActions */ =>  {
                let var_503 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_pending_actions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_pending_actions(var_503);
            }
            ,
            s if s.matches("MaintenanceTrackName") /* MaintenanceTrackName com.amazonaws.redshift#Cluster$MaintenanceTrackName */ =>  {
                let var_504 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_maintenance_track_name(var_504);
            }
            ,
            s if s.matches("ElasticResizeNumberOfNodeOptions") /* ElasticResizeNumberOfNodeOptions com.amazonaws.redshift#Cluster$ElasticResizeNumberOfNodeOptions */ =>  {
                let var_505 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_elastic_resize_number_of_node_options(var_505);
            }
            ,
            s if s.matches("DeferredMaintenanceWindows") /* DeferredMaintenanceWindows com.amazonaws.redshift#Cluster$DeferredMaintenanceWindows */ =>  {
                let var_506 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_deferred_maintenance_windows_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_deferred_maintenance_windows(var_506);
            }
            ,
            s if s.matches("SnapshotScheduleIdentifier") /* SnapshotScheduleIdentifier com.amazonaws.redshift#Cluster$SnapshotScheduleIdentifier */ =>  {
                let var_507 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_schedule_identifier(var_507);
            }
            ,
            s if s.matches("SnapshotScheduleState") /* SnapshotScheduleState com.amazonaws.redshift#Cluster$SnapshotScheduleState */ =>  {
                let var_508 =
                    Some(
                        Result::<crate::model::ScheduleState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ScheduleState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_schedule_state(var_508);
            }
            ,
            s if s.matches("ExpectedNextSnapshotScheduleTime") /* ExpectedNextSnapshotScheduleTime com.amazonaws.redshift#Cluster$ExpectedNextSnapshotScheduleTime */ =>  {
                let var_509 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_expected_next_snapshot_schedule_time(var_509);
            }
            ,
            s if s.matches("ExpectedNextSnapshotScheduleTimeStatus") /* ExpectedNextSnapshotScheduleTimeStatus com.amazonaws.redshift#Cluster$ExpectedNextSnapshotScheduleTimeStatus */ =>  {
                let var_510 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_expected_next_snapshot_schedule_time_status(var_510);
            }
            ,
            s if s.matches("NextMaintenanceWindowStartTime") /* NextMaintenanceWindowStartTime com.amazonaws.redshift#Cluster$NextMaintenanceWindowStartTime */ =>  {
                let var_511 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_next_maintenance_window_start_time(var_511);
            }
            ,
            s if s.matches("ResizeInfo") /* ResizeInfo com.amazonaws.redshift#Cluster$ResizeInfo */ =>  {
                let var_512 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resize_info(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resize_info(var_512);
            }
            ,
            s if s.matches("AvailabilityZoneRelocationStatus") /* AvailabilityZoneRelocationStatus com.amazonaws.redshift#Cluster$AvailabilityZoneRelocationStatus */ =>  {
                let var_513 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone_relocation_status(var_513);
            }
            ,
            s if s.matches("ClusterNamespaceArn") /* ClusterNamespaceArn com.amazonaws.redshift#Cluster$ClusterNamespaceArn */ =>  {
                let var_514 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_namespace_arn(var_514);
            }
            ,
            s if s.matches("TotalStorageCapacityInMegaBytes") /* TotalStorageCapacityInMegaBytes com.amazonaws.redshift#Cluster$TotalStorageCapacityInMegaBytes */ =>  {
                let var_515 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_storage_capacity_in_mega_bytes(var_515);
            }
            ,
            s if s.matches("AquaConfiguration") /* AquaConfiguration com.amazonaws.redshift#Cluster$AquaConfiguration */ =>  {
                let var_516 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_aqua_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_aqua_configuration(var_516);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_parameter_group(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterParameterGroup, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterParameterGroup::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ParameterGroupName") /* ParameterGroupName com.amazonaws.redshift#ClusterParameterGroup$ParameterGroupName */ =>  {
                let var_517 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_name(var_517);
            }
            ,
            s if s.matches("ParameterGroupFamily") /* ParameterGroupFamily com.amazonaws.redshift#ClusterParameterGroup$ParameterGroupFamily */ =>  {
                let var_518 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_family(var_518);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.redshift#ClusterParameterGroup$Description */ =>  {
                let var_519 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_519);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#ClusterParameterGroup$Tags */ =>  {
                let var_520 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_520);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_subnet_group(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterSubnetGroup, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterSubnetGroup::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterSubnetGroupName") /* ClusterSubnetGroupName com.amazonaws.redshift#ClusterSubnetGroup$ClusterSubnetGroupName */ =>  {
                let var_521 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_subnet_group_name(var_521);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.redshift#ClusterSubnetGroup$Description */ =>  {
                let var_522 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_522);
            }
            ,
            s if s.matches("VpcId") /* VpcId com.amazonaws.redshift#ClusterSubnetGroup$VpcId */ =>  {
                let var_523 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_523);
            }
            ,
            s if s.matches("SubnetGroupStatus") /* SubnetGroupStatus com.amazonaws.redshift#ClusterSubnetGroup$SubnetGroupStatus */ =>  {
                let var_524 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_group_status(var_524);
            }
            ,
            s if s.matches("Subnets") /* Subnets com.amazonaws.redshift#ClusterSubnetGroup$Subnets */ =>  {
                let var_525 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_subnet_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnets(var_525);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#ClusterSubnetGroup$Tags */ =>  {
                let var_526 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_526);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_vpc_security_group_membership_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::VpcSecurityGroupMembership>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VpcSecurityGroup") /* member com.amazonaws.redshift#VpcSecurityGroupMembershipList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_vpc_security_group_membership(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_vpc_endpoint(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VpcEndpoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VpcEndpoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VpcEndpointId") /* VpcEndpointId com.amazonaws.redshift#VpcEndpoint$VpcEndpointId */ =>  {
                let var_527 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoint_id(var_527);
            }
            ,
            s if s.matches("VpcId") /* VpcId com.amazonaws.redshift#VpcEndpoint$VpcId */ =>  {
                let var_528 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_528);
            }
            ,
            s if s.matches("NetworkInterfaces") /* NetworkInterfaces com.amazonaws.redshift#VpcEndpoint$NetworkInterfaces */ =>  {
                let var_529 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_network_interface_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_network_interfaces(var_529);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_event_subscription(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EventSubscription, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EventSubscription::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CustomerAwsId") /* CustomerAwsId com.amazonaws.redshift#EventSubscription$CustomerAwsId */ =>  {
                let var_530 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_customer_aws_id(var_530);
            }
            ,
            s if s.matches("CustSubscriptionId") /* CustSubscriptionId com.amazonaws.redshift#EventSubscription$CustSubscriptionId */ =>  {
                let var_531 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cust_subscription_id(var_531);
            }
            ,
            s if s.matches("SnsTopicArn") /* SnsTopicArn com.amazonaws.redshift#EventSubscription$SnsTopicArn */ =>  {
                let var_532 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_sns_topic_arn(var_532);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#EventSubscription$Status */ =>  {
                let var_533 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_533);
            }
            ,
            s if s.matches("SubscriptionCreationTime") /* SubscriptionCreationTime com.amazonaws.redshift#EventSubscription$SubscriptionCreationTime */ =>  {
                let var_534 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_subscription_creation_time(var_534);
            }
            ,
            s if s.matches("SourceType") /* SourceType com.amazonaws.redshift#EventSubscription$SourceType */ =>  {
                let var_535 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_type(var_535);
            }
            ,
            s if s.matches("SourceIdsList") /* SourceIdsList com.amazonaws.redshift#EventSubscription$SourceIdsList */ =>  {
                let var_536 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_source_ids_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_source_ids_list(var_536);
            }
            ,
            s if s.matches("EventCategoriesList") /* EventCategoriesList com.amazonaws.redshift#EventSubscription$EventCategoriesList */ =>  {
                let var_537 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_event_categories_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_categories_list(var_537);
            }
            ,
            s if s.matches("Severity") /* Severity com.amazonaws.redshift#EventSubscription$Severity */ =>  {
                let var_538 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_severity(var_538);
            }
            ,
            s if s.matches("Enabled") /* Enabled com.amazonaws.redshift#EventSubscription$Enabled */ =>  {
                let var_539 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enabled(var_539);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#EventSubscription$Tags */ =>  {
                let var_540 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_540);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_hsm_client_certificate(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::HsmClientCertificate, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::HsmClientCertificate::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HsmClientCertificateIdentifier") /* HsmClientCertificateIdentifier com.amazonaws.redshift#HsmClientCertificate$HsmClientCertificateIdentifier */ =>  {
                let var_541 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hsm_client_certificate_identifier(var_541);
            }
            ,
            s if s.matches("HsmClientCertificatePublicKey") /* HsmClientCertificatePublicKey com.amazonaws.redshift#HsmClientCertificate$HsmClientCertificatePublicKey */ =>  {
                let var_542 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hsm_client_certificate_public_key(var_542);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#HsmClientCertificate$Tags */ =>  {
                let var_543 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_543);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_hsm_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::HsmConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::HsmConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HsmConfigurationIdentifier") /* HsmConfigurationIdentifier com.amazonaws.redshift#HsmConfiguration$HsmConfigurationIdentifier */ =>  {
                let var_544 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hsm_configuration_identifier(var_544);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.redshift#HsmConfiguration$Description */ =>  {
                let var_545 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_545);
            }
            ,
            s if s.matches("HsmIpAddress") /* HsmIpAddress com.amazonaws.redshift#HsmConfiguration$HsmIpAddress */ =>  {
                let var_546 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hsm_ip_address(var_546);
            }
            ,
            s if s.matches("HsmPartitionName") /* HsmPartitionName com.amazonaws.redshift#HsmConfiguration$HsmPartitionName */ =>  {
                let var_547 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hsm_partition_name(var_547);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#HsmConfiguration$Tags */ =>  {
                let var_548 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_548);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_scheduled_action_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ScheduledActionType, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ScheduledActionType::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ResizeCluster") /* ResizeCluster com.amazonaws.redshift#ScheduledActionType$ResizeCluster */ =>  {
                let var_549 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resize_cluster_message(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resize_cluster(var_549);
            }
            ,
            s if s.matches("PauseCluster") /* PauseCluster com.amazonaws.redshift#ScheduledActionType$PauseCluster */ =>  {
                let var_550 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_pause_cluster_message(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_pause_cluster(var_550);
            }
            ,
            s if s.matches("ResumeCluster") /* ResumeCluster com.amazonaws.redshift#ScheduledActionType$ResumeCluster */ =>  {
                let var_551 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_resume_cluster_message(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resume_cluster(var_551);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_scheduled_action_time_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<aws_smithy_types::DateTime>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ScheduledActionTime") /* member com.amazonaws.redshift#ScheduledActionTimeList$member */ =>  {
                out.push(
                    aws_smithy_types::DateTime::from_str(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        , aws_smithy_types::date_time::Format::DateTime
                    )
                    .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_snapshot_copy_grant(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SnapshotCopyGrant, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SnapshotCopyGrant::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotCopyGrantName") /* SnapshotCopyGrantName com.amazonaws.redshift#SnapshotCopyGrant$SnapshotCopyGrantName */ =>  {
                let var_552 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_copy_grant_name(var_552);
            }
            ,
            s if s.matches("KmsKeyId") /* KmsKeyId com.amazonaws.redshift#SnapshotCopyGrant$KmsKeyId */ =>  {
                let var_553 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_kms_key_id(var_553);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#SnapshotCopyGrant$Tags */ =>  {
                let var_554 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_554);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_schedule_definition_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ScheduleDefinition") /* member com.amazonaws.redshift#ScheduleDefinitionList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_tag_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Tag") /* member com.amazonaws.redshift#TagList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_scheduled_snapshot_time_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<aws_smithy_types::DateTime>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotTime") /* member com.amazonaws.redshift#ScheduledSnapshotTimeList$member */ =>  {
                out.push(
                    aws_smithy_types::DateTime::from_str(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        , aws_smithy_types::date_time::Format::DateTime
                    )
                    .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_associated_cluster_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ClusterAssociatedToSchedule>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterAssociatedToSchedule") /* member com.amazonaws.redshift#AssociatedClusterList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_associated_to_schedule(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_attribute_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AccountAttribute>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccountAttribute") /* member com.amazonaws.redshift#AttributeList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_account_attribute(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_authentication_profile_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AuthenticationProfile>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#AuthenticationProfileList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_authentication_profile(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_cluster_db_revisions_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterDbRevision>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterDbRevision") /* member com.amazonaws.redshift#ClusterDbRevisionsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_db_revision(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_parameter_group_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterParameterGroup>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterParameterGroup") /* member com.amazonaws.redshift#ParameterGroupList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_parameter_group(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_parameters_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Parameter>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Parameter") /* member com.amazonaws.redshift#ParametersList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_parameter(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_cluster_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Cluster>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Cluster") /* member com.amazonaws.redshift#ClusterList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_cluster_security_groups(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterSecurityGroup>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterSecurityGroup") /* member com.amazonaws.redshift#ClusterSecurityGroups$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_security_group(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_snapshot_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Snapshot>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Snapshot") /* member com.amazonaws.redshift#SnapshotList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_snapshot(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_cluster_subnet_groups(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterSubnetGroup>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterSubnetGroup") /* member com.amazonaws.redshift#ClusterSubnetGroups$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_subnet_group(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_track_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MaintenanceTrack>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MaintenanceTrack") /* member com.amazonaws.redshift#TrackList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_maintenance_track(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_cluster_version_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterVersion>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterVersion") /* member com.amazonaws.redshift#ClusterVersionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_version(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_data_share_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::DataShare>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#DataShareList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_data_share(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_default_cluster_parameters(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DefaultClusterParameters, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DefaultClusterParameters::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ParameterGroupFamily") /* ParameterGroupFamily com.amazonaws.redshift#DefaultClusterParameters$ParameterGroupFamily */ =>  {
                let var_555 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_family(var_555);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.redshift#DefaultClusterParameters$Marker */ =>  {
                let var_556 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_556);
            }
            ,
            s if s.matches("Parameters") /* Parameters com.amazonaws.redshift#DefaultClusterParameters$Parameters */ =>  {
                let var_557 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_parameters_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_parameters(var_557);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_endpoint_accesses(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EndpointAccess>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#EndpointAccesses$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_endpoint_access(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_endpoint_authorizations(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EndpointAuthorization>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#EndpointAuthorizations$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_endpoint_authorization(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_event_categories_map_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EventCategoriesMap>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventCategoriesMap") /* member com.amazonaws.redshift#EventCategoriesMapList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_event_categories_map(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_event_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Event>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Event") /* member com.amazonaws.redshift#EventList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_event(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_event_subscriptions_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EventSubscription>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventSubscription") /* member com.amazonaws.redshift#EventSubscriptionsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_event_subscription(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_hsm_client_certificate_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::HsmClientCertificate>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HsmClientCertificate") /* member com.amazonaws.redshift#HsmClientCertificateList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_hsm_client_certificate(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_hsm_configuration_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::HsmConfiguration>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HsmConfiguration") /* member com.amazonaws.redshift#HsmConfigurationList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_hsm_configuration(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_node_configuration_option_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::NodeConfigurationOption>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NodeConfigurationOption") /* member com.amazonaws.redshift#NodeConfigurationOptionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_node_configuration_option(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_orderable_cluster_options_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::OrderableClusterOption>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("OrderableClusterOption") /* member com.amazonaws.redshift#OrderableClusterOptionsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_orderable_cluster_option(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_partner_integration_info_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PartnerIntegrationInfo>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PartnerIntegrationInfo") /* member com.amazonaws.redshift#PartnerIntegrationInfoList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_partner_integration_info(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_reserved_node_offering_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ReservedNodeOffering>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ReservedNodeOffering") /* member com.amazonaws.redshift#ReservedNodeOfferingList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_reserved_node_offering(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_reserved_node_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ReservedNode>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ReservedNode") /* member com.amazonaws.redshift#ReservedNodeList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_reserved_node(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_scheduled_action_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ScheduledAction>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ScheduledAction") /* member com.amazonaws.redshift#ScheduledActionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_scheduled_action(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_snapshot_copy_grant_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SnapshotCopyGrant>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotCopyGrant") /* member com.amazonaws.redshift#SnapshotCopyGrantList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_snapshot_copy_grant(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_snapshot_schedule_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SnapshotSchedule>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotSchedule") /* member com.amazonaws.redshift#SnapshotScheduleList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_snapshot_schedule(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_table_restore_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::TableRestoreStatus>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TableRestoreStatus") /* member com.amazonaws.redshift#TableRestoreStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_table_restore_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_tagged_resource_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::TaggedResource>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TaggedResource") /* member com.amazonaws.redshift#TaggedResourceList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tagged_resource(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_usage_limits(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::UsageLimit>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#UsageLimits$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_usage_limit(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_aqua_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AquaConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AquaConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AquaStatus") /* AquaStatus com.amazonaws.redshift#AquaConfiguration$AquaStatus */ =>  {
                let var_558 =
                    Some(
                        Result::<crate::model::AquaStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AquaStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_aqua_status(var_558);
            }
            ,
            s if s.matches("AquaConfigurationStatus") /* AquaConfigurationStatus com.amazonaws.redshift#AquaConfiguration$AquaConfigurationStatus */ =>  {
                let var_559 =
                    Some(
                        Result::<crate::model::AquaConfigurationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AquaConfigurationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_aqua_configuration_status(var_559);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_table_restore_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TableRestoreStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TableRestoreStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TableRestoreRequestId") /* TableRestoreRequestId com.amazonaws.redshift#TableRestoreStatus$TableRestoreRequestId */ =>  {
                let var_560 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_table_restore_request_id(var_560);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#TableRestoreStatus$Status */ =>  {
                let var_561 =
                    Some(
                        Result::<crate::model::TableRestoreStatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TableRestoreStatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_561);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.redshift#TableRestoreStatus$Message */ =>  {
                let var_562 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_562);
            }
            ,
            s if s.matches("RequestTime") /* RequestTime com.amazonaws.redshift#TableRestoreStatus$RequestTime */ =>  {
                let var_563 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_request_time(var_563);
            }
            ,
            s if s.matches("ProgressInMegaBytes") /* ProgressInMegaBytes com.amazonaws.redshift#TableRestoreStatus$ProgressInMegaBytes */ =>  {
                let var_564 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_progress_in_mega_bytes(var_564);
            }
            ,
            s if s.matches("TotalDataInMegaBytes") /* TotalDataInMegaBytes com.amazonaws.redshift#TableRestoreStatus$TotalDataInMegaBytes */ =>  {
                let var_565 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_data_in_mega_bytes(var_565);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#TableRestoreStatus$ClusterIdentifier */ =>  {
                let var_566 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_566);
            }
            ,
            s if s.matches("SnapshotIdentifier") /* SnapshotIdentifier com.amazonaws.redshift#TableRestoreStatus$SnapshotIdentifier */ =>  {
                let var_567 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_identifier(var_567);
            }
            ,
            s if s.matches("SourceDatabaseName") /* SourceDatabaseName com.amazonaws.redshift#TableRestoreStatus$SourceDatabaseName */ =>  {
                let var_568 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_database_name(var_568);
            }
            ,
            s if s.matches("SourceSchemaName") /* SourceSchemaName com.amazonaws.redshift#TableRestoreStatus$SourceSchemaName */ =>  {
                let var_569 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_schema_name(var_569);
            }
            ,
            s if s.matches("SourceTableName") /* SourceTableName com.amazonaws.redshift#TableRestoreStatus$SourceTableName */ =>  {
                let var_570 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_table_name(var_570);
            }
            ,
            s if s.matches("TargetDatabaseName") /* TargetDatabaseName com.amazonaws.redshift#TableRestoreStatus$TargetDatabaseName */ =>  {
                let var_571 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_database_name(var_571);
            }
            ,
            s if s.matches("TargetSchemaName") /* TargetSchemaName com.amazonaws.redshift#TableRestoreStatus$TargetSchemaName */ =>  {
                let var_572 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_schema_name(var_572);
            }
            ,
            s if s.matches("NewTableName") /* NewTableName com.amazonaws.redshift#TableRestoreStatus$NewTableName */ =>  {
                let var_573 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_new_table_name(var_573);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_recurring_charge_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::RecurringCharge>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RecurringCharge") /* member com.amazonaws.redshift#RecurringChargeList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_recurring_charge(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_data_share_association(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DataShareAssociation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DataShareAssociation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ConsumerIdentifier") /* ConsumerIdentifier com.amazonaws.redshift#DataShareAssociation$ConsumerIdentifier */ =>  {
                let var_574 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_consumer_identifier(var_574);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#DataShareAssociation$Status */ =>  {
                let var_575 =
                    Some(
                        Result::<crate::model::DataShareStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::DataShareStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_575);
            }
            ,
            s if s.matches("CreatedDate") /* CreatedDate com.amazonaws.redshift#DataShareAssociation$CreatedDate */ =>  {
                let var_576 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_created_date(var_576);
            }
            ,
            s if s.matches("StatusChangeDate") /* StatusChangeDate com.amazonaws.redshift#DataShareAssociation$StatusChangeDate */ =>  {
                let var_577 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_status_change_date(var_577);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_ec2_security_group_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Ec2SecurityGroup>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EC2SecurityGroup") /* member com.amazonaws.redshift#EC2SecurityGroupList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_ec2_security_group(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_ip_range_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::IpRange>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IPRange") /* member com.amazonaws.redshift#IPRangeList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_ip_range(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_accounts_with_restore_access_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AccountWithRestoreAccess>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccountWithRestoreAccess") /* member com.amazonaws.redshift#AccountsWithRestoreAccessList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_account_with_restore_access(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_restorable_node_type_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NodeType") /* member com.amazonaws.redshift#RestorableNodeTypeList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_snapshot_error_message(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SnapshotErrorMessage, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SnapshotErrorMessage::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SnapshotIdentifier") /* SnapshotIdentifier com.amazonaws.redshift#SnapshotErrorMessage$SnapshotIdentifier */ =>  {
                let var_578 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_identifier(var_578);
            }
            ,
            s if s.matches("SnapshotClusterIdentifier") /* SnapshotClusterIdentifier com.amazonaws.redshift#SnapshotErrorMessage$SnapshotClusterIdentifier */ =>  {
                let var_579 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_cluster_identifier(var_579);
            }
            ,
            s if s.matches("FailureCode") /* FailureCode com.amazonaws.redshift#SnapshotErrorMessage$FailureCode */ =>  {
                let var_580 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_code(var_580);
            }
            ,
            s if s.matches("FailureReason") /* FailureReason com.amazonaws.redshift#SnapshotErrorMessage$FailureReason */ =>  {
                let var_581 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_reason(var_581);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_endpoint(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Endpoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Endpoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Address") /* Address com.amazonaws.redshift#Endpoint$Address */ =>  {
                let var_582 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_address(var_582);
            }
            ,
            s if s.matches("Port") /* Port com.amazonaws.redshift#Endpoint$Port */ =>  {
                let var_583 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_port(var_583);
            }
            ,
            s if s.matches("VpcEndpoints") /* VpcEndpoints com.amazonaws.redshift#Endpoint$VpcEndpoints */ =>  {
                let var_584 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_endpoints_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoints(var_584);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_cluster_security_group_membership_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ClusterSecurityGroupMembership>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterSecurityGroup") /* member com.amazonaws.redshift#ClusterSecurityGroupMembershipList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_security_group_membership(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_cluster_parameter_group_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ClusterParameterGroupStatus>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterParameterGroup") /* member com.amazonaws.redshift#ClusterParameterGroupStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_parameter_group_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_pending_modified_values(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PendingModifiedValues, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PendingModifiedValues::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MasterUserPassword") /* MasterUserPassword com.amazonaws.redshift#PendingModifiedValues$MasterUserPassword */ =>  {
                let var_585 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_master_user_password(var_585);
            }
            ,
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#PendingModifiedValues$NodeType */ =>  {
                let var_586 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_586);
            }
            ,
            s if s.matches("NumberOfNodes") /* NumberOfNodes com.amazonaws.redshift#PendingModifiedValues$NumberOfNodes */ =>  {
                let var_587 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_nodes(var_587);
            }
            ,
            s if s.matches("ClusterType") /* ClusterType com.amazonaws.redshift#PendingModifiedValues$ClusterType */ =>  {
                let var_588 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_type(var_588);
            }
            ,
            s if s.matches("ClusterVersion") /* ClusterVersion com.amazonaws.redshift#PendingModifiedValues$ClusterVersion */ =>  {
                let var_589 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_version(var_589);
            }
            ,
            s if s.matches("AutomatedSnapshotRetentionPeriod") /* AutomatedSnapshotRetentionPeriod com.amazonaws.redshift#PendingModifiedValues$AutomatedSnapshotRetentionPeriod */ =>  {
                let var_590 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_automated_snapshot_retention_period(var_590);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#PendingModifiedValues$ClusterIdentifier */ =>  {
                let var_591 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_591);
            }
            ,
            s if s.matches("PubliclyAccessible") /* PubliclyAccessible com.amazonaws.redshift#PendingModifiedValues$PubliclyAccessible */ =>  {
                let var_592 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#BooleanOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_publicly_accessible(var_592);
            }
            ,
            s if s.matches("EnhancedVpcRouting") /* EnhancedVpcRouting com.amazonaws.redshift#PendingModifiedValues$EnhancedVpcRouting */ =>  {
                let var_593 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#BooleanOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enhanced_vpc_routing(var_593);
            }
            ,
            s if s.matches("MaintenanceTrackName") /* MaintenanceTrackName com.amazonaws.redshift#PendingModifiedValues$MaintenanceTrackName */ =>  {
                let var_594 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_maintenance_track_name(var_594);
            }
            ,
            s if s.matches("EncryptionType") /* EncryptionType com.amazonaws.redshift#PendingModifiedValues$EncryptionType */ =>  {
                let var_595 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_encryption_type(var_595);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_restore_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RestoreStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RestoreStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.redshift#RestoreStatus$Status */ =>  {
                let var_596 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_596);
            }
            ,
            s if s.matches("CurrentRestoreRateInMegaBytesPerSecond") /* CurrentRestoreRateInMegaBytesPerSecond com.amazonaws.redshift#RestoreStatus$CurrentRestoreRateInMegaBytesPerSecond */ =>  {
                let var_597 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_current_restore_rate_in_mega_bytes_per_second(var_597);
            }
            ,
            s if s.matches("SnapshotSizeInMegaBytes") /* SnapshotSizeInMegaBytes com.amazonaws.redshift#RestoreStatus$SnapshotSizeInMegaBytes */ =>  {
                let var_598 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_snapshot_size_in_mega_bytes(var_598);
            }
            ,
            s if s.matches("ProgressInMegaBytes") /* ProgressInMegaBytes com.amazonaws.redshift#RestoreStatus$ProgressInMegaBytes */ =>  {
                let var_599 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_progress_in_mega_bytes(var_599);
            }
            ,
            s if s.matches("ElapsedTimeInSeconds") /* ElapsedTimeInSeconds com.amazonaws.redshift#RestoreStatus$ElapsedTimeInSeconds */ =>  {
                let var_600 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_elapsed_time_in_seconds(var_600);
            }
            ,
            s if s.matches("EstimatedTimeToCompletionInSeconds") /* EstimatedTimeToCompletionInSeconds com.amazonaws.redshift#RestoreStatus$EstimatedTimeToCompletionInSeconds */ =>  {
                let var_601 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_estimated_time_to_completion_in_seconds(var_601);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_data_transfer_progress(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DataTransferProgress, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DataTransferProgress::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.redshift#DataTransferProgress$Status */ =>  {
                let var_602 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_602);
            }
            ,
            s if s.matches("CurrentRateInMegaBytesPerSecond") /* CurrentRateInMegaBytesPerSecond com.amazonaws.redshift#DataTransferProgress$CurrentRateInMegaBytesPerSecond */ =>  {
                let var_603 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#DoubleOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_current_rate_in_mega_bytes_per_second(var_603);
            }
            ,
            s if s.matches("TotalDataInMegaBytes") /* TotalDataInMegaBytes com.amazonaws.redshift#DataTransferProgress$TotalDataInMegaBytes */ =>  {
                let var_604 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_data_in_mega_bytes(var_604);
            }
            ,
            s if s.matches("DataTransferredInMegaBytes") /* DataTransferredInMegaBytes com.amazonaws.redshift#DataTransferProgress$DataTransferredInMegaBytes */ =>  {
                let var_605 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_data_transferred_in_mega_bytes(var_605);
            }
            ,
            s if s.matches("EstimatedTimeToCompletionInSeconds") /* EstimatedTimeToCompletionInSeconds com.amazonaws.redshift#DataTransferProgress$EstimatedTimeToCompletionInSeconds */ =>  {
                let var_606 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_estimated_time_to_completion_in_seconds(var_606);
            }
            ,
            s if s.matches("ElapsedTimeInSeconds") /* ElapsedTimeInSeconds com.amazonaws.redshift#DataTransferProgress$ElapsedTimeInSeconds */ =>  {
                let var_607 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#LongOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_elapsed_time_in_seconds(var_607);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_hsm_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::HsmStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::HsmStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("HsmClientCertificateIdentifier") /* HsmClientCertificateIdentifier com.amazonaws.redshift#HsmStatus$HsmClientCertificateIdentifier */ =>  {
                let var_608 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hsm_client_certificate_identifier(var_608);
            }
            ,
            s if s.matches("HsmConfigurationIdentifier") /* HsmConfigurationIdentifier com.amazonaws.redshift#HsmStatus$HsmConfigurationIdentifier */ =>  {
                let var_609 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_hsm_configuration_identifier(var_609);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#HsmStatus$Status */ =>  {
                let var_610 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_610);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_snapshot_copy_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterSnapshotCopyStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterSnapshotCopyStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DestinationRegion") /* DestinationRegion com.amazonaws.redshift#ClusterSnapshotCopyStatus$DestinationRegion */ =>  {
                let var_611 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_destination_region(var_611);
            }
            ,
            s if s.matches("RetentionPeriod") /* RetentionPeriod com.amazonaws.redshift#ClusterSnapshotCopyStatus$RetentionPeriod */ =>  {
                let var_612 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_retention_period(var_612);
            }
            ,
            s if s.matches("ManualSnapshotRetentionPeriod") /* ManualSnapshotRetentionPeriod com.amazonaws.redshift#ClusterSnapshotCopyStatus$ManualSnapshotRetentionPeriod */ =>  {
                let var_613 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_manual_snapshot_retention_period(var_613);
            }
            ,
            s if s.matches("SnapshotCopyGrantName") /* SnapshotCopyGrantName com.amazonaws.redshift#ClusterSnapshotCopyStatus$SnapshotCopyGrantName */ =>  {
                let var_614 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_snapshot_copy_grant_name(var_614);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_cluster_nodes_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterNode>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#ClusterNodesList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_node(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_elastic_ip_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ElasticIpStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ElasticIpStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ElasticIp") /* ElasticIp com.amazonaws.redshift#ElasticIpStatus$ElasticIp */ =>  {
                let var_615 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_elastic_ip(var_615);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#ElasticIpStatus$Status */ =>  {
                let var_616 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_616);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_cluster_iam_role_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterIamRole>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIamRole") /* member com.amazonaws.redshift#ClusterIamRoleList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_iam_role(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_pending_actions_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#PendingActionsList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_deferred_maintenance_windows_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::DeferredMaintenanceWindow>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DeferredMaintenanceWindow") /* member com.amazonaws.redshift#DeferredMaintenanceWindowsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_deferred_maintenance_window(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_resize_info(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ResizeInfo, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ResizeInfo::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ResizeType") /* ResizeType com.amazonaws.redshift#ResizeInfo$ResizeType */ =>  {
                let var_617 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resize_type(var_617);
            }
            ,
            s if s.matches("AllowCancelResize") /* AllowCancelResize com.amazonaws.redshift#ResizeInfo$AllowCancelResize */ =>  {
                let var_618 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_cancel_resize(var_618);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_subnet_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Subnet>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Subnet") /* member com.amazonaws.redshift#SubnetList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_subnet(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_vpc_security_group_membership(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VpcSecurityGroupMembership, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VpcSecurityGroupMembership::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VpcSecurityGroupId") /* VpcSecurityGroupId com.amazonaws.redshift#VpcSecurityGroupMembership$VpcSecurityGroupId */ =>  {
                let var_619 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_security_group_id(var_619);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#VpcSecurityGroupMembership$Status */ =>  {
                let var_620 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_620);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_network_interface_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::NetworkInterface>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NetworkInterface") /* member com.amazonaws.redshift#NetworkInterfaceList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_network_interface(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_source_ids_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SourceId") /* member com.amazonaws.redshift#SourceIdsList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_event_categories_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventCategory") /* member com.amazonaws.redshift#EventCategoriesList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_resize_cluster_message(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ResizeClusterMessage, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ResizeClusterMessage::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#ResizeClusterMessage$ClusterIdentifier */ =>  {
                let var_621 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_621);
            }
            ,
            s if s.matches("ClusterType") /* ClusterType com.amazonaws.redshift#ResizeClusterMessage$ClusterType */ =>  {
                let var_622 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_type(var_622);
            }
            ,
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#ResizeClusterMessage$NodeType */ =>  {
                let var_623 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_623);
            }
            ,
            s if s.matches("NumberOfNodes") /* NumberOfNodes com.amazonaws.redshift#ResizeClusterMessage$NumberOfNodes */ =>  {
                let var_624 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_nodes(var_624);
            }
            ,
            s if s.matches("Classic") /* Classic com.amazonaws.redshift#ResizeClusterMessage$Classic */ =>  {
                let var_625 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#BooleanOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_classic(var_625);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_pause_cluster_message(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PauseClusterMessage, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PauseClusterMessage::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#PauseClusterMessage$ClusterIdentifier */ =>  {
                let var_626 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_626);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_resume_cluster_message(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ResumeClusterMessage, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ResumeClusterMessage::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#ResumeClusterMessage$ClusterIdentifier */ =>  {
                let var_627 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_627);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tag(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Tag, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Tag::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.redshift#Tag$Key */ =>  {
                let var_628 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_628);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.redshift#Tag$Value */ =>  {
                let var_629 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_629);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_associated_to_schedule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterAssociatedToSchedule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterAssociatedToSchedule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#ClusterAssociatedToSchedule$ClusterIdentifier */ =>  {
                let var_630 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_630);
            }
            ,
            s if s.matches("ScheduleAssociationState") /* ScheduleAssociationState com.amazonaws.redshift#ClusterAssociatedToSchedule$ScheduleAssociationState */ =>  {
                let var_631 =
                    Some(
                        Result::<crate::model::ScheduleState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ScheduleState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule_association_state(var_631);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_account_attribute(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccountAttribute, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccountAttribute::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AttributeName") /* AttributeName com.amazonaws.redshift#AccountAttribute$AttributeName */ =>  {
                let var_632 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_attribute_name(var_632);
            }
            ,
            s if s.matches("AttributeValues") /* AttributeValues com.amazonaws.redshift#AccountAttribute$AttributeValues */ =>  {
                let var_633 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_attribute_value_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attribute_values(var_633);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_authentication_profile(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AuthenticationProfile, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AuthenticationProfile::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AuthenticationProfileName") /* AuthenticationProfileName com.amazonaws.redshift#AuthenticationProfile$AuthenticationProfileName */ =>  {
                let var_634 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_authentication_profile_name(var_634);
            }
            ,
            s if s.matches("AuthenticationProfileContent") /* AuthenticationProfileContent com.amazonaws.redshift#AuthenticationProfile$AuthenticationProfileContent */ =>  {
                let var_635 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_authentication_profile_content(var_635);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_db_revision(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterDbRevision, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterDbRevision::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#ClusterDbRevision$ClusterIdentifier */ =>  {
                let var_636 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_636);
            }
            ,
            s if s.matches("CurrentDatabaseRevision") /* CurrentDatabaseRevision com.amazonaws.redshift#ClusterDbRevision$CurrentDatabaseRevision */ =>  {
                let var_637 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_current_database_revision(var_637);
            }
            ,
            s if s.matches("DatabaseRevisionReleaseDate") /* DatabaseRevisionReleaseDate com.amazonaws.redshift#ClusterDbRevision$DatabaseRevisionReleaseDate */ =>  {
                let var_638 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_database_revision_release_date(var_638);
            }
            ,
            s if s.matches("RevisionTargets") /* RevisionTargets com.amazonaws.redshift#ClusterDbRevision$RevisionTargets */ =>  {
                let var_639 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_revision_targets_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_revision_targets(var_639);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_parameter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Parameter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Parameter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ParameterName") /* ParameterName com.amazonaws.redshift#Parameter$ParameterName */ =>  {
                let var_640 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_name(var_640);
            }
            ,
            s if s.matches("ParameterValue") /* ParameterValue com.amazonaws.redshift#Parameter$ParameterValue */ =>  {
                let var_641 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_value(var_641);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.redshift#Parameter$Description */ =>  {
                let var_642 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_642);
            }
            ,
            s if s.matches("Source") /* Source com.amazonaws.redshift#Parameter$Source */ =>  {
                let var_643 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source(var_643);
            }
            ,
            s if s.matches("DataType") /* DataType com.amazonaws.redshift#Parameter$DataType */ =>  {
                let var_644 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_type(var_644);
            }
            ,
            s if s.matches("AllowedValues") /* AllowedValues com.amazonaws.redshift#Parameter$AllowedValues */ =>  {
                let var_645 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_allowed_values(var_645);
            }
            ,
            s if s.matches("ApplyType") /* ApplyType com.amazonaws.redshift#Parameter$ApplyType */ =>  {
                let var_646 =
                    Some(
                        Result::<crate::model::ParameterApplyType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ParameterApplyType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_apply_type(var_646);
            }
            ,
            s if s.matches("IsModifiable") /* IsModifiable com.amazonaws.redshift#Parameter$IsModifiable */ =>  {
                let var_647 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_modifiable(var_647);
            }
            ,
            s if s.matches("MinimumEngineVersion") /* MinimumEngineVersion com.amazonaws.redshift#Parameter$MinimumEngineVersion */ =>  {
                let var_648 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_minimum_engine_version(var_648);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_maintenance_track(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MaintenanceTrack, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MaintenanceTrack::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MaintenanceTrackName") /* MaintenanceTrackName com.amazonaws.redshift#MaintenanceTrack$MaintenanceTrackName */ =>  {
                let var_649 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_maintenance_track_name(var_649);
            }
            ,
            s if s.matches("DatabaseVersion") /* DatabaseVersion com.amazonaws.redshift#MaintenanceTrack$DatabaseVersion */ =>  {
                let var_650 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_database_version(var_650);
            }
            ,
            s if s.matches("UpdateTargets") /* UpdateTargets com.amazonaws.redshift#MaintenanceTrack$UpdateTargets */ =>  {
                let var_651 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_eligible_tracks_to_update_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_update_targets(var_651);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_version(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterVersion, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterVersion::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterVersion") /* ClusterVersion com.amazonaws.redshift#ClusterVersion$ClusterVersion */ =>  {
                let var_652 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_version(var_652);
            }
            ,
            s if s.matches("ClusterParameterGroupFamily") /* ClusterParameterGroupFamily com.amazonaws.redshift#ClusterVersion$ClusterParameterGroupFamily */ =>  {
                let var_653 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_parameter_group_family(var_653);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.redshift#ClusterVersion$Description */ =>  {
                let var_654 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_654);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_data_share(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DataShare, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DataShare::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DataShareArn") /* DataShareArn com.amazonaws.redshift#DataShare$DataShareArn */ =>  {
                let var_655 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_share_arn(var_655);
            }
            ,
            s if s.matches("ProducerArn") /* ProducerArn com.amazonaws.redshift#DataShare$ProducerArn */ =>  {
                let var_656 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_producer_arn(var_656);
            }
            ,
            s if s.matches("AllowPubliclyAccessibleConsumers") /* AllowPubliclyAccessibleConsumers com.amazonaws.redshift#DataShare$AllowPubliclyAccessibleConsumers */ =>  {
                let var_657 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_publicly_accessible_consumers(var_657);
            }
            ,
            s if s.matches("DataShareAssociations") /* DataShareAssociations com.amazonaws.redshift#DataShare$DataShareAssociations */ =>  {
                let var_658 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_data_share_association_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_share_associations(var_658);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_endpoint_access(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EndpointAccess, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EndpointAccess::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#EndpointAccess$ClusterIdentifier */ =>  {
                let var_659 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_659);
            }
            ,
            s if s.matches("ResourceOwner") /* ResourceOwner com.amazonaws.redshift#EndpointAccess$ResourceOwner */ =>  {
                let var_660 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_owner(var_660);
            }
            ,
            s if s.matches("SubnetGroupName") /* SubnetGroupName com.amazonaws.redshift#EndpointAccess$SubnetGroupName */ =>  {
                let var_661 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_group_name(var_661);
            }
            ,
            s if s.matches("EndpointStatus") /* EndpointStatus com.amazonaws.redshift#EndpointAccess$EndpointStatus */ =>  {
                let var_662 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_status(var_662);
            }
            ,
            s if s.matches("EndpointName") /* EndpointName com.amazonaws.redshift#EndpointAccess$EndpointName */ =>  {
                let var_663 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_endpoint_name(var_663);
            }
            ,
            s if s.matches("EndpointCreateTime") /* EndpointCreateTime com.amazonaws.redshift#EndpointAccess$EndpointCreateTime */ =>  {
                let var_664 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_endpoint_create_time(var_664);
            }
            ,
            s if s.matches("Port") /* Port com.amazonaws.redshift#EndpointAccess$Port */ =>  {
                let var_665 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_port(var_665);
            }
            ,
            s if s.matches("Address") /* Address com.amazonaws.redshift#EndpointAccess$Address */ =>  {
                let var_666 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_address(var_666);
            }
            ,
            s if s.matches("VpcSecurityGroups") /* VpcSecurityGroups com.amazonaws.redshift#EndpointAccess$VpcSecurityGroups */ =>  {
                let var_667 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_security_group_membership_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_security_groups(var_667);
            }
            ,
            s if s.matches("VpcEndpoint") /* VpcEndpoint com.amazonaws.redshift#EndpointAccess$VpcEndpoint */ =>  {
                let var_668 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_endpoint(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_endpoint(var_668);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_endpoint_authorization(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EndpointAuthorization, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EndpointAuthorization::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Grantor") /* Grantor com.amazonaws.redshift#EndpointAuthorization$Grantor */ =>  {
                let var_669 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_grantor(var_669);
            }
            ,
            s if s.matches("Grantee") /* Grantee com.amazonaws.redshift#EndpointAuthorization$Grantee */ =>  {
                let var_670 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_grantee(var_670);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#EndpointAuthorization$ClusterIdentifier */ =>  {
                let var_671 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_671);
            }
            ,
            s if s.matches("AuthorizeTime") /* AuthorizeTime com.amazonaws.redshift#EndpointAuthorization$AuthorizeTime */ =>  {
                let var_672 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_authorize_time(var_672);
            }
            ,
            s if s.matches("ClusterStatus") /* ClusterStatus com.amazonaws.redshift#EndpointAuthorization$ClusterStatus */ =>  {
                let var_673 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_status(var_673);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#EndpointAuthorization$Status */ =>  {
                let var_674 =
                    Some(
                        Result::<crate::model::AuthorizationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AuthorizationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_674);
            }
            ,
            s if s.matches("AllowedAllVPCs") /* AllowedAllVPCs com.amazonaws.redshift#EndpointAuthorization$AllowedAllVPCs */ =>  {
                let var_675 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.redshift#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allowed_all_vp_cs(var_675);
            }
            ,
            s if s.matches("AllowedVPCs") /* AllowedVPCs com.amazonaws.redshift#EndpointAuthorization$AllowedVPCs */ =>  {
                let var_676 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_vpc_identifier_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_allowed_vp_cs(var_676);
            }
            ,
            s if s.matches("EndpointCount") /* EndpointCount com.amazonaws.redshift#EndpointAuthorization$EndpointCount */ =>  {
                let var_677 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_endpoint_count(var_677);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_event_categories_map(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EventCategoriesMap, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EventCategoriesMap::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SourceType") /* SourceType com.amazonaws.redshift#EventCategoriesMap$SourceType */ =>  {
                let var_678 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_type(var_678);
            }
            ,
            s if s.matches("Events") /* Events com.amazonaws.redshift#EventCategoriesMap$Events */ =>  {
                let var_679 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_event_info_map_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_events(var_679);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_event(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Event, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Event::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SourceIdentifier") /* SourceIdentifier com.amazonaws.redshift#Event$SourceIdentifier */ =>  {
                let var_680 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_identifier(var_680);
            }
            ,
            s if s.matches("SourceType") /* SourceType com.amazonaws.redshift#Event$SourceType */ =>  {
                let var_681 =
                    Some(
                        Result::<crate::model::SourceType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::SourceType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_source_type(var_681);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.redshift#Event$Message */ =>  {
                let var_682 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_682);
            }
            ,
            s if s.matches("EventCategories") /* EventCategories com.amazonaws.redshift#Event$EventCategories */ =>  {
                let var_683 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_event_categories_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_categories(var_683);
            }
            ,
            s if s.matches("Severity") /* Severity com.amazonaws.redshift#Event$Severity */ =>  {
                let var_684 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_severity(var_684);
            }
            ,
            s if s.matches("Date") /* Date com.amazonaws.redshift#Event$Date */ =>  {
                let var_685 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_date(var_685);
            }
            ,
            s if s.matches("EventId") /* EventId com.amazonaws.redshift#Event$EventId */ =>  {
                let var_686 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_id(var_686);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_node_configuration_option(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::NodeConfigurationOption, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::NodeConfigurationOption::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#NodeConfigurationOption$NodeType */ =>  {
                let var_687 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_687);
            }
            ,
            s if s.matches("NumberOfNodes") /* NumberOfNodes com.amazonaws.redshift#NodeConfigurationOption$NumberOfNodes */ =>  {
                let var_688 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_nodes(var_688);
            }
            ,
            s if s.matches("EstimatedDiskUtilizationPercent") /* EstimatedDiskUtilizationPercent com.amazonaws.redshift#NodeConfigurationOption$EstimatedDiskUtilizationPercent */ =>  {
                let var_689 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#DoubleOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_estimated_disk_utilization_percent(var_689);
            }
            ,
            s if s.matches("Mode") /* Mode com.amazonaws.redshift#NodeConfigurationOption$Mode */ =>  {
                let var_690 =
                    Some(
                        Result::<crate::model::Mode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Mode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_mode(var_690);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_orderable_cluster_option(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::OrderableClusterOption, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::OrderableClusterOption::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterVersion") /* ClusterVersion com.amazonaws.redshift#OrderableClusterOption$ClusterVersion */ =>  {
                let var_691 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_version(var_691);
            }
            ,
            s if s.matches("ClusterType") /* ClusterType com.amazonaws.redshift#OrderableClusterOption$ClusterType */ =>  {
                let var_692 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_type(var_692);
            }
            ,
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#OrderableClusterOption$NodeType */ =>  {
                let var_693 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_693);
            }
            ,
            s if s.matches("AvailabilityZones") /* AvailabilityZones com.amazonaws.redshift#OrderableClusterOption$AvailabilityZones */ =>  {
                let var_694 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_availability_zone_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_availability_zones(var_694);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_partner_integration_info(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PartnerIntegrationInfo, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PartnerIntegrationInfo::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DatabaseName") /* DatabaseName com.amazonaws.redshift#PartnerIntegrationInfo$DatabaseName */ =>  {
                let var_695 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_database_name(var_695);
            }
            ,
            s if s.matches("PartnerName") /* PartnerName com.amazonaws.redshift#PartnerIntegrationInfo$PartnerName */ =>  {
                let var_696 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_partner_name(var_696);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#PartnerIntegrationInfo$Status */ =>  {
                let var_697 =
                    Some(
                        Result::<crate::model::PartnerIntegrationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PartnerIntegrationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_697);
            }
            ,
            s if s.matches("StatusMessage") /* StatusMessage com.amazonaws.redshift#PartnerIntegrationInfo$StatusMessage */ =>  {
                let var_698 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_message(var_698);
            }
            ,
            s if s.matches("CreatedAt") /* CreatedAt com.amazonaws.redshift#PartnerIntegrationInfo$CreatedAt */ =>  {
                let var_699 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_created_at(var_699);
            }
            ,
            s if s.matches("UpdatedAt") /* UpdatedAt com.amazonaws.redshift#PartnerIntegrationInfo$UpdatedAt */ =>  {
                let var_700 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_updated_at(var_700);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_reserved_node_offering(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ReservedNodeOffering, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ReservedNodeOffering::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ReservedNodeOfferingId") /* ReservedNodeOfferingId com.amazonaws.redshift#ReservedNodeOffering$ReservedNodeOfferingId */ =>  {
                let var_701 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_reserved_node_offering_id(var_701);
            }
            ,
            s if s.matches("NodeType") /* NodeType com.amazonaws.redshift#ReservedNodeOffering$NodeType */ =>  {
                let var_702 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_type(var_702);
            }
            ,
            s if s.matches("Duration") /* Duration com.amazonaws.redshift#ReservedNodeOffering$Duration */ =>  {
                let var_703 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#Integer`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_duration(var_703);
            }
            ,
            s if s.matches("FixedPrice") /* FixedPrice com.amazonaws.redshift#ReservedNodeOffering$FixedPrice */ =>  {
                let var_704 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_fixed_price(var_704);
            }
            ,
            s if s.matches("UsagePrice") /* UsagePrice com.amazonaws.redshift#ReservedNodeOffering$UsagePrice */ =>  {
                let var_705 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_usage_price(var_705);
            }
            ,
            s if s.matches("CurrencyCode") /* CurrencyCode com.amazonaws.redshift#ReservedNodeOffering$CurrencyCode */ =>  {
                let var_706 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_currency_code(var_706);
            }
            ,
            s if s.matches("OfferingType") /* OfferingType com.amazonaws.redshift#ReservedNodeOffering$OfferingType */ =>  {
                let var_707 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_offering_type(var_707);
            }
            ,
            s if s.matches("RecurringCharges") /* RecurringCharges com.amazonaws.redshift#ReservedNodeOffering$RecurringCharges */ =>  {
                let var_708 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_recurring_charge_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_recurring_charges(var_708);
            }
            ,
            s if s.matches("ReservedNodeOfferingType") /* ReservedNodeOfferingType com.amazonaws.redshift#ReservedNodeOffering$ReservedNodeOfferingType */ =>  {
                let var_709 =
                    Some(
                        Result::<crate::model::ReservedNodeOfferingType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReservedNodeOfferingType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_reserved_node_offering_type(var_709);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_scheduled_action(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ScheduledAction, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ScheduledAction::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ScheduledActionName") /* ScheduledActionName com.amazonaws.redshift#ScheduledAction$ScheduledActionName */ =>  {
                let var_710 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_scheduled_action_name(var_710);
            }
            ,
            s if s.matches("TargetAction") /* TargetAction com.amazonaws.redshift#ScheduledAction$TargetAction */ =>  {
                let var_711 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_scheduled_action_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_target_action(var_711);
            }
            ,
            s if s.matches("Schedule") /* Schedule com.amazonaws.redshift#ScheduledAction$Schedule */ =>  {
                let var_712 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule(var_712);
            }
            ,
            s if s.matches("IamRole") /* IamRole com.amazonaws.redshift#ScheduledAction$IamRole */ =>  {
                let var_713 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_iam_role(var_713);
            }
            ,
            s if s.matches("ScheduledActionDescription") /* ScheduledActionDescription com.amazonaws.redshift#ScheduledAction$ScheduledActionDescription */ =>  {
                let var_714 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_scheduled_action_description(var_714);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.redshift#ScheduledAction$State */ =>  {
                let var_715 =
                    Some(
                        Result::<crate::model::ScheduledActionState, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ScheduledActionState::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_715);
            }
            ,
            s if s.matches("NextInvocations") /* NextInvocations com.amazonaws.redshift#ScheduledAction$NextInvocations */ =>  {
                let var_716 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_scheduled_action_time_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_next_invocations(var_716);
            }
            ,
            s if s.matches("StartTime") /* StartTime com.amazonaws.redshift#ScheduledAction$StartTime */ =>  {
                let var_717 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_717);
            }
            ,
            s if s.matches("EndTime") /* EndTime com.amazonaws.redshift#ScheduledAction$EndTime */ =>  {
                let var_718 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_end_time(var_718);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_snapshot_schedule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SnapshotSchedule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SnapshotSchedule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ScheduleDefinitions") /* ScheduleDefinitions com.amazonaws.redshift#SnapshotSchedule$ScheduleDefinitions */ =>  {
                let var_719 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_schedule_definition_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_schedule_definitions(var_719);
            }
            ,
            s if s.matches("ScheduleIdentifier") /* ScheduleIdentifier com.amazonaws.redshift#SnapshotSchedule$ScheduleIdentifier */ =>  {
                let var_720 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule_identifier(var_720);
            }
            ,
            s if s.matches("ScheduleDescription") /* ScheduleDescription com.amazonaws.redshift#SnapshotSchedule$ScheduleDescription */ =>  {
                let var_721 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schedule_description(var_721);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#SnapshotSchedule$Tags */ =>  {
                let var_722 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_722);
            }
            ,
            s if s.matches("NextInvocations") /* NextInvocations com.amazonaws.redshift#SnapshotSchedule$NextInvocations */ =>  {
                let var_723 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_scheduled_snapshot_time_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_next_invocations(var_723);
            }
            ,
            s if s.matches("AssociatedClusterCount") /* AssociatedClusterCount com.amazonaws.redshift#SnapshotSchedule$AssociatedClusterCount */ =>  {
                let var_724 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.redshift#IntegerOptional`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_associated_cluster_count(var_724);
            }
            ,
            s if s.matches("AssociatedClusters") /* AssociatedClusters com.amazonaws.redshift#SnapshotSchedule$AssociatedClusters */ =>  {
                let var_725 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_associated_cluster_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_associated_clusters(var_725);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tagged_resource(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TaggedResource, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TaggedResource::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Tag") /* Tag com.amazonaws.redshift#TaggedResource$Tag */ =>  {
                let var_726 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tag(var_726);
            }
            ,
            s if s.matches("ResourceName") /* ResourceName com.amazonaws.redshift#TaggedResource$ResourceName */ =>  {
                let var_727 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_name(var_727);
            }
            ,
            s if s.matches("ResourceType") /* ResourceType com.amazonaws.redshift#TaggedResource$ResourceType */ =>  {
                let var_728 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_type(var_728);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_usage_limit(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::UsageLimit, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::UsageLimit::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UsageLimitId") /* UsageLimitId com.amazonaws.redshift#UsageLimit$UsageLimitId */ =>  {
                let var_729 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_usage_limit_id(var_729);
            }
            ,
            s if s.matches("ClusterIdentifier") /* ClusterIdentifier com.amazonaws.redshift#UsageLimit$ClusterIdentifier */ =>  {
                let var_730 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_identifier(var_730);
            }
            ,
            s if s.matches("FeatureType") /* FeatureType com.amazonaws.redshift#UsageLimit$FeatureType */ =>  {
                let var_731 =
                    Some(
                        Result::<crate::model::UsageLimitFeatureType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitFeatureType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_feature_type(var_731);
            }
            ,
            s if s.matches("LimitType") /* LimitType com.amazonaws.redshift#UsageLimit$LimitType */ =>  {
                let var_732 =
                    Some(
                        Result::<crate::model::UsageLimitLimitType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitLimitType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_limit_type(var_732);
            }
            ,
            s if s.matches("Amount") /* Amount com.amazonaws.redshift#UsageLimit$Amount */ =>  {
                let var_733 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.redshift#Long`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_amount(var_733);
            }
            ,
            s if s.matches("Period") /* Period com.amazonaws.redshift#UsageLimit$Period */ =>  {
                let var_734 =
                    Some(
                        Result::<crate::model::UsageLimitPeriod, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitPeriod::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_period(var_734);
            }
            ,
            s if s.matches("BreachAction") /* BreachAction com.amazonaws.redshift#UsageLimit$BreachAction */ =>  {
                let var_735 =
                    Some(
                        Result::<crate::model::UsageLimitBreachAction, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::UsageLimitBreachAction::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_breach_action(var_735);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#UsageLimit$Tags */ =>  {
                let var_736 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_736);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_recurring_charge(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RecurringCharge, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RecurringCharge::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RecurringChargeAmount") /* RecurringChargeAmount com.amazonaws.redshift#RecurringCharge$RecurringChargeAmount */ =>  {
                let var_737 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.redshift#Double`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_recurring_charge_amount(var_737);
            }
            ,
            s if s.matches("RecurringChargeFrequency") /* RecurringChargeFrequency com.amazonaws.redshift#RecurringCharge$RecurringChargeFrequency */ =>  {
                let var_738 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_recurring_charge_frequency(var_738);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ec2_security_group(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Ec2SecurityGroup, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Ec2SecurityGroup::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.redshift#EC2SecurityGroup$Status */ =>  {
                let var_739 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_739);
            }
            ,
            s if s.matches("EC2SecurityGroupName") /* EC2SecurityGroupName com.amazonaws.redshift#EC2SecurityGroup$EC2SecurityGroupName */ =>  {
                let var_740 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ec2_security_group_name(var_740);
            }
            ,
            s if s.matches("EC2SecurityGroupOwnerId") /* EC2SecurityGroupOwnerId com.amazonaws.redshift#EC2SecurityGroup$EC2SecurityGroupOwnerId */ =>  {
                let var_741 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ec2_security_group_owner_id(var_741);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#EC2SecurityGroup$Tags */ =>  {
                let var_742 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_742);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ip_range(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::IpRange, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::IpRange::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.redshift#IPRange$Status */ =>  {
                let var_743 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_743);
            }
            ,
            s if s.matches("CIDRIP") /* CIDRIP com.amazonaws.redshift#IPRange$CIDRIP */ =>  {
                let var_744 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cidrip(var_744);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.redshift#IPRange$Tags */ =>  {
                let var_745 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_745);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_account_with_restore_access(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccountWithRestoreAccess, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccountWithRestoreAccess::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccountId") /* AccountId com.amazonaws.redshift#AccountWithRestoreAccess$AccountId */ =>  {
                let var_746 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_account_id(var_746);
            }
            ,
            s if s.matches("AccountAlias") /* AccountAlias com.amazonaws.redshift#AccountWithRestoreAccess$AccountAlias */ =>  {
                let var_747 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_account_alias(var_747);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_vpc_endpoints_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::VpcEndpoint>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VpcEndpoint") /* member com.amazonaws.redshift#VpcEndpointsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_vpc_endpoint(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_cluster_security_group_membership(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterSecurityGroupMembership, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterSecurityGroupMembership::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ClusterSecurityGroupName") /* ClusterSecurityGroupName com.amazonaws.redshift#ClusterSecurityGroupMembership$ClusterSecurityGroupName */ =>  {
                let var_748 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cluster_security_group_name(var_748);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.redshift#ClusterSecurityGroupMembership$Status */ =>  {
                let var_749 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_749);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_parameter_group_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterParameterGroupStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterParameterGroupStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ParameterGroupName") /* ParameterGroupName com.amazonaws.redshift#ClusterParameterGroupStatus$ParameterGroupName */ =>  {
                let var_750 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_group_name(var_750);
            }
            ,
            s if s.matches("ParameterApplyStatus") /* ParameterApplyStatus com.amazonaws.redshift#ClusterParameterGroupStatus$ParameterApplyStatus */ =>  {
                let var_751 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_apply_status(var_751);
            }
            ,
            s if s.matches("ClusterParameterStatusList") /* ClusterParameterStatusList com.amazonaws.redshift#ClusterParameterGroupStatus$ClusterParameterStatusList */ =>  {
                let var_752 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_cluster_parameter_status_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_cluster_parameter_status_list(var_752);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_node(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterNode, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterNode::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NodeRole") /* NodeRole com.amazonaws.redshift#ClusterNode$NodeRole */ =>  {
                let var_753 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_node_role(var_753);
            }
            ,
            s if s.matches("PrivateIPAddress") /* PrivateIPAddress com.amazonaws.redshift#ClusterNode$PrivateIPAddress */ =>  {
                let var_754 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_private_ip_address(var_754);
            }
            ,
            s if s.matches("PublicIPAddress") /* PublicIPAddress com.amazonaws.redshift#ClusterNode$PublicIPAddress */ =>  {
                let var_755 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_public_ip_address(var_755);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_iam_role(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterIamRole, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterIamRole::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IamRoleArn") /* IamRoleArn com.amazonaws.redshift#ClusterIamRole$IamRoleArn */ =>  {
                let var_756 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_iam_role_arn(var_756);
            }
            ,
            s if s.matches("ApplyStatus") /* ApplyStatus com.amazonaws.redshift#ClusterIamRole$ApplyStatus */ =>  {
                let var_757 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_apply_status(var_757);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_deferred_maintenance_window(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeferredMaintenanceWindow, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeferredMaintenanceWindow::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DeferMaintenanceIdentifier") /* DeferMaintenanceIdentifier com.amazonaws.redshift#DeferredMaintenanceWindow$DeferMaintenanceIdentifier */ =>  {
                let var_758 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_defer_maintenance_identifier(var_758);
            }
            ,
            s if s.matches("DeferMaintenanceStartTime") /* DeferMaintenanceStartTime com.amazonaws.redshift#DeferredMaintenanceWindow$DeferMaintenanceStartTime */ =>  {
                let var_759 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_defer_maintenance_start_time(var_759);
            }
            ,
            s if s.matches("DeferMaintenanceEndTime") /* DeferMaintenanceEndTime com.amazonaws.redshift#DeferredMaintenanceWindow$DeferMaintenanceEndTime */ =>  {
                let var_760 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_defer_maintenance_end_time(var_760);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_subnet(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Subnet, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Subnet::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SubnetIdentifier") /* SubnetIdentifier com.amazonaws.redshift#Subnet$SubnetIdentifier */ =>  {
                let var_761 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_identifier(var_761);
            }
            ,
            s if s.matches("SubnetAvailabilityZone") /* SubnetAvailabilityZone com.amazonaws.redshift#Subnet$SubnetAvailabilityZone */ =>  {
                let var_762 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_availability_zone(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_subnet_availability_zone(var_762);
            }
            ,
            s if s.matches("SubnetStatus") /* SubnetStatus com.amazonaws.redshift#Subnet$SubnetStatus */ =>  {
                let var_763 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_status(var_763);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_network_interface(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::NetworkInterface, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::NetworkInterface::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NetworkInterfaceId") /* NetworkInterfaceId com.amazonaws.redshift#NetworkInterface$NetworkInterfaceId */ =>  {
                let var_764 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_network_interface_id(var_764);
            }
            ,
            s if s.matches("SubnetId") /* SubnetId com.amazonaws.redshift#NetworkInterface$SubnetId */ =>  {
                let var_765 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subnet_id(var_765);
            }
            ,
            s if s.matches("PrivateIpAddress") /* PrivateIpAddress com.amazonaws.redshift#NetworkInterface$PrivateIpAddress */ =>  {
                let var_766 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_private_ip_address(var_766);
            }
            ,
            s if s.matches("AvailabilityZone") /* AvailabilityZone com.amazonaws.redshift#NetworkInterface$AvailabilityZone */ =>  {
                let var_767 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_availability_zone(var_767);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_attribute_value_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AttributeValueTarget>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AttributeValueTarget") /* member com.amazonaws.redshift#AttributeValueList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_attribute_value_target(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_revision_targets_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::RevisionTarget>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RevisionTarget") /* member com.amazonaws.redshift#RevisionTargetsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_revision_target(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_eligible_tracks_to_update_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::UpdateTarget>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UpdateTarget") /* member com.amazonaws.redshift#EligibleTracksToUpdateList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_update_target(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_event_info_map_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EventInfoMap>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventInfoMap") /* member com.amazonaws.redshift#EventInfoMapList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_event_info_map(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_availability_zone_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AvailabilityZone>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AvailabilityZone") /* member com.amazonaws.redshift#AvailabilityZoneList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_availability_zone(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_cluster_parameter_status_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ClusterParameterStatus>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.redshift#ClusterParameterStatusList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_cluster_parameter_status(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_availability_zone(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AvailabilityZone, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AvailabilityZone::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.redshift#AvailabilityZone$Name */ =>  {
                let var_768 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_768);
            }
            ,
            s if s.matches("SupportedPlatforms") /* SupportedPlatforms com.amazonaws.redshift#AvailabilityZone$SupportedPlatforms */ =>  {
                let var_769 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_supported_platforms_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_supported_platforms(var_769);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_attribute_value_target(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AttributeValueTarget, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AttributeValueTarget::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AttributeValue") /* AttributeValue com.amazonaws.redshift#AttributeValueTarget$AttributeValue */ =>  {
                let var_770 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_attribute_value(var_770);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_revision_target(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RevisionTarget, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RevisionTarget::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DatabaseRevision") /* DatabaseRevision com.amazonaws.redshift#RevisionTarget$DatabaseRevision */ =>  {
                let var_771 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_database_revision(var_771);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.redshift#RevisionTarget$Description */ =>  {
                let var_772 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_772);
            }
            ,
            s if s.matches("DatabaseRevisionReleaseDate") /* DatabaseRevisionReleaseDate com.amazonaws.redshift#RevisionTarget$DatabaseRevisionReleaseDate */ =>  {
                let var_773 =
                    Some(
                        aws_smithy_types::DateTime::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::date_time::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.redshift#TStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_database_revision_release_date(var_773);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_update_target(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::UpdateTarget, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::UpdateTarget::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MaintenanceTrackName") /* MaintenanceTrackName com.amazonaws.redshift#UpdateTarget$MaintenanceTrackName */ =>  {
                let var_774 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_maintenance_track_name(var_774);
            }
            ,
            s if s.matches("DatabaseVersion") /* DatabaseVersion com.amazonaws.redshift#UpdateTarget$DatabaseVersion */ =>  {
                let var_775 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_database_version(var_775);
            }
            ,
            s if s.matches("SupportedOperations") /* SupportedOperations com.amazonaws.redshift#UpdateTarget$SupportedOperations */ =>  {
                let var_776 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_supported_operation_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_supported_operations(var_776);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_event_info_map(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EventInfoMap, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EventInfoMap::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EventId") /* EventId com.amazonaws.redshift#EventInfoMap$EventId */ =>  {
                let var_777 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_id(var_777);
            }
            ,
            s if s.matches("EventCategories") /* EventCategories com.amazonaws.redshift#EventInfoMap$EventCategories */ =>  {
                let var_778 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_redshift_event_categories_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_event_categories(var_778);
            }
            ,
            s if s.matches("EventDescription") /* EventDescription com.amazonaws.redshift#EventInfoMap$EventDescription */ =>  {
                let var_779 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_event_description(var_779);
            }
            ,
            s if s.matches("Severity") /* Severity com.amazonaws.redshift#EventInfoMap$Severity */ =>  {
                let var_780 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_severity(var_780);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_cluster_parameter_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ClusterParameterStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ClusterParameterStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ParameterName") /* ParameterName com.amazonaws.redshift#ClusterParameterStatus$ParameterName */ =>  {
                let var_781 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_name(var_781);
            }
            ,
            s if s.matches("ParameterApplyStatus") /* ParameterApplyStatus com.amazonaws.redshift#ClusterParameterStatus$ParameterApplyStatus */ =>  {
                let var_782 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_apply_status(var_782);
            }
            ,
            s if s.matches("ParameterApplyErrorDescription") /* ParameterApplyErrorDescription com.amazonaws.redshift#ClusterParameterStatus$ParameterApplyErrorDescription */ =>  {
                let var_783 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_parameter_apply_error_description(var_783);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_redshift_supported_platforms_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SupportedPlatform>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SupportedPlatform") /* member com.amazonaws.redshift#SupportedPlatformsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_supported_platform(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_redshift_supported_operation_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SupportedOperation>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SupportedOperation") /* member com.amazonaws.redshift#SupportedOperationList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_supported_operation(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_supported_platform(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SupportedPlatform, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SupportedPlatform::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.redshift#SupportedPlatform$Name */ =>  {
                let var_784 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_784);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_supported_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SupportedOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SupportedOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("OperationName") /* OperationName com.amazonaws.redshift#SupportedOperation$OperationName */ =>  {
                let var_785 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_operation_name(var_785);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
