// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_reserved_node_exchange_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptReservedNodeExchangeOutput,
    crate::error::AcceptReservedNodeExchangeError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AcceptReservedNodeExchangeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependentServiceUnavailableFault" => crate::error::AcceptReservedNodeExchangeError {
            meta: generic,
            kind:
                crate::error::AcceptReservedNodeExchangeErrorKind::DependentServiceUnavailableFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::dependent_service_unavailable_fault::Builder::default(
                                );
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_dependent_service_unavailable_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidReservedNodeState" => crate::error::AcceptReservedNodeExchangeError {
            meta: generic,
            kind: crate::error::AcceptReservedNodeExchangeErrorKind::InvalidReservedNodeStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_reserved_node_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_reserved_node_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ReservedNodeAlreadyExists" => crate::error::AcceptReservedNodeExchangeError {
            meta: generic,
            kind: crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyExistsFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::reserved_node_already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_reserved_node_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ReservedNodeAlreadyMigrated" => crate::error::AcceptReservedNodeExchangeError {
            meta: generic,
            kind:
                crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyMigratedFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::reserved_node_already_migrated_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_reserved_node_already_migrated_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ReservedNodeNotFound" => crate::error::AcceptReservedNodeExchangeError {
            meta: generic,
            kind: crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::reserved_node_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReservedNodeOfferingNotFound" => crate::error::AcceptReservedNodeExchangeError {
            meta: generic,
            kind:
                crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeOfferingNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::reserved_node_offering_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_reserved_node_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "UnsupportedOperation" => crate::error::AcceptReservedNodeExchangeError {
            meta: generic,
            kind: crate::error::AcceptReservedNodeExchangeErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AcceptReservedNodeExchangeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_accept_reserved_node_exchange_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AcceptReservedNodeExchangeOutput,
    crate::error::AcceptReservedNodeExchangeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::accept_reserved_node_exchange_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_accept_reserved_node_exchange(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AcceptReservedNodeExchangeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_partner_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPartnerOutput, crate::error::AddPartnerError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddPartnerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddPartnerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::AddPartnerError {
            meta: generic,
            kind: crate::error::AddPartnerErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddPartnerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PartnerNotFound" => crate::error::AddPartnerError {
            meta: generic,
            kind: crate::error::AddPartnerErrorKind::PartnerNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::partner_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_partner_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddPartnerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedPartnerIntegration" => crate::error::AddPartnerError {
            meta: generic,
            kind: crate::error::AddPartnerErrorKind::UnauthorizedPartnerIntegrationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_partner_integration_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_partner_integration_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddPartnerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddPartnerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_partner_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPartnerOutput, crate::error::AddPartnerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_partner_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_add_partner(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddPartnerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_data_share_consumer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateDataShareConsumerOutput,
    crate::error::AssociateDataShareConsumerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AssociateDataShareConsumerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AssociateDataShareConsumerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidDataShareFault" => crate::error::AssociateDataShareConsumerError {
            meta: generic,
            kind: crate::error::AssociateDataShareConsumerErrorKind::InvalidDataShareFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_data_share_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_data_share_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AssociateDataShareConsumerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNamespaceFault" => crate::error::AssociateDataShareConsumerError {
            meta: generic,
            kind: crate::error::AssociateDataShareConsumerErrorKind::InvalidNamespaceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_namespace_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_namespace_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AssociateDataShareConsumerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AssociateDataShareConsumerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_associate_data_share_consumer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AssociateDataShareConsumerOutput,
    crate::error::AssociateDataShareConsumerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::associate_data_share_consumer_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_associate_data_share_consumer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AssociateDataShareConsumerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_cluster_security_group_ingress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeClusterSecurityGroupIngressOutput,
    crate::error::AuthorizeClusterSecurityGroupIngressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AuthorizeClusterSecurityGroupIngressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AuthorizeClusterSecurityGroupIngressError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationAlreadyExists" => crate::error::AuthorizeClusterSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeClusterSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AuthorizationQuotaExceeded" => crate::error::AuthorizeClusterSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeClusterSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSecurityGroupNotFound" => crate::error::AuthorizeClusterSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeClusterSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSecurityGroupState" => crate::error::AuthorizeClusterSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeClusterSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AuthorizeClusterSecurityGroupIngressError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_cluster_security_group_ingress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeClusterSecurityGroupIngressOutput,
    crate::error::AuthorizeClusterSecurityGroupIngressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::authorize_cluster_security_group_ingress_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_authorize_cluster_security_group_ingress(response.body().as_ref(), output).map_err(crate::error::AuthorizeClusterSecurityGroupIngressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_data_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeDataShareOutput,
    crate::error::AuthorizeDataShareError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AuthorizeDataShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AuthorizeDataShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidDataShareFault" => crate::error::AuthorizeDataShareError {
            meta: generic,
            kind: crate::error::AuthorizeDataShareErrorKind::InvalidDataShareFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_data_share_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_data_share_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeDataShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AuthorizeDataShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_data_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeDataShareOutput,
    crate::error::AuthorizeDataShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::authorize_data_share_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_authorize_data_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AuthorizeDataShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_endpoint_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeEndpointAccessOutput,
    crate::error::AuthorizeEndpointAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AuthorizeEndpointAccessError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::AuthorizeEndpointAccessError { meta: generic, kind: crate::error::AuthorizeEndpointAccessErrorKind::ClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EndpointAuthorizationAlreadyExists" => crate::error::AuthorizeEndpointAccessError { meta: generic, kind: crate::error::AuthorizeEndpointAccessErrorKind::EndpointAuthorizationAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoint_authorization_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_authorization_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EndpointAuthorizationsPerClusterLimitExceeded" => crate::error::AuthorizeEndpointAccessError { meta: generic, kind: crate::error::AuthorizeEndpointAccessErrorKind::EndpointAuthorizationsPerClusterLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoint_authorizations_per_cluster_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_authorizations_per_cluster_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidAuthorizationState" => crate::error::AuthorizeEndpointAccessError { meta: generic, kind: crate::error::AuthorizeEndpointAccessErrorKind::InvalidAuthorizationStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_authorization_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authorization_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterState" => crate::error::AuthorizeEndpointAccessError { meta: generic, kind: crate::error::AuthorizeEndpointAccessErrorKind::InvalidClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperation" => crate::error::AuthorizeEndpointAccessError { meta: generic, kind: crate::error::AuthorizeEndpointAccessErrorKind::UnsupportedOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AuthorizeEndpointAccessError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_endpoint_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeEndpointAccessOutput,
    crate::error::AuthorizeEndpointAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::authorize_endpoint_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_authorize_endpoint_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AuthorizeEndpointAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_snapshot_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeSnapshotAccessOutput,
    crate::error::AuthorizeSnapshotAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AuthorizeSnapshotAccessError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationAlreadyExists" => crate::error::AuthorizeSnapshotAccessError { meta: generic, kind: crate::error::AuthorizeSnapshotAccessErrorKind::AuthorizationAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AuthorizationQuotaExceeded" => crate::error::AuthorizeSnapshotAccessError { meta: generic, kind: crate::error::AuthorizeSnapshotAccessErrorKind::AuthorizationQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSnapshotNotFound" => crate::error::AuthorizeSnapshotAccessError { meta: generic, kind: crate::error::AuthorizeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DependentServiceRequestThrottlingFault" => crate::error::AuthorizeSnapshotAccessError { meta: generic, kind: crate::error::AuthorizeSnapshotAccessErrorKind::DependentServiceRequestThrottlingFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependent_service_request_throttling_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSnapshotState" => crate::error::AuthorizeSnapshotAccessError { meta: generic, kind: crate::error::AuthorizeSnapshotAccessErrorKind::InvalidClusterSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededFault" => crate::error::AuthorizeSnapshotAccessError { meta: generic, kind: crate::error::AuthorizeSnapshotAccessErrorKind::LimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AuthorizeSnapshotAccessError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_snapshot_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeSnapshotAccessOutput,
    crate::error::AuthorizeSnapshotAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::authorize_snapshot_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_authorize_snapshot_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AuthorizeSnapshotAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_cluster_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDeleteClusterSnapshotsOutput,
    crate::error::BatchDeleteClusterSnapshotsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchDeleteClusterSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchDeleteClusterSnapshotsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BatchDeleteRequestSizeExceeded" => crate::error::BatchDeleteClusterSnapshotsError { meta: generic, kind: crate::error::BatchDeleteClusterSnapshotsErrorKind::BatchDeleteRequestSizeExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::batch_delete_request_size_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_delete_request_size_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchDeleteClusterSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchDeleteClusterSnapshotsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_delete_cluster_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchDeleteClusterSnapshotsOutput,
    crate::error::BatchDeleteClusterSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_delete_cluster_snapshots_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_batch_delete_cluster_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchDeleteClusterSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_modify_cluster_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchModifyClusterSnapshotsOutput,
    crate::error::BatchModifyClusterSnapshotsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BatchModifyClusterSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::BatchModifyClusterSnapshotsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BatchModifyClusterSnapshotsLimitExceededFault" => crate::error::BatchModifyClusterSnapshotsError { meta: generic, kind: crate::error::BatchModifyClusterSnapshotsErrorKind::BatchModifyClusterSnapshotsLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::batch_modify_cluster_snapshots_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_batch_modify_cluster_snapshots_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchModifyClusterSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRetentionPeriodFault" => crate::error::BatchModifyClusterSnapshotsError { meta: generic, kind: crate::error::BatchModifyClusterSnapshotsErrorKind::InvalidRetentionPeriodFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BatchModifyClusterSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::BatchModifyClusterSnapshotsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_batch_modify_cluster_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BatchModifyClusterSnapshotsOutput,
    crate::error::BatchModifyClusterSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::batch_modify_cluster_snapshots_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_batch_modify_cluster_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BatchModifyClusterSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_resize_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelResizeOutput, crate::error::CancelResizeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelResizeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelResizeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::CancelResizeError {
            meta: generic,
            kind: crate::error::CancelResizeErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelResizeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::CancelResizeError {
            meta: generic,
            kind: crate::error::CancelResizeErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelResizeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResizeNotFound" => crate::error::CancelResizeError {
            meta: generic,
            kind: crate::error::CancelResizeErrorKind::ResizeNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resize_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resize_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelResizeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CancelResizeError {
            meta: generic,
            kind: crate::error::CancelResizeErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelResizeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelResizeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_resize_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelResizeOutput, crate::error::CancelResizeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_resize_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_cancel_resize(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelResizeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyClusterSnapshotOutput,
    crate::error::CopyClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyClusterSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSnapshotAlreadyExists" => crate::error::CopyClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSnapshotNotFound" => crate::error::CopyClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSnapshotQuotaExceeded" => crate::error::CopyClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSnapshotState" => crate::error::CopyClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRetentionPeriodFault" => crate::error::CopyClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyClusterSnapshotErrorKind::InvalidRetentionPeriodFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyClusterSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyClusterSnapshotOutput,
    crate::error::CopyClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_copy_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_authentication_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAuthenticationProfileOutput,
    crate::error::CreateAuthenticationProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAuthenticationProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateAuthenticationProfileError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthenticationProfileAlreadyExistsFault" => crate::error::CreateAuthenticationProfileError { meta: generic, kind: crate::error::CreateAuthenticationProfileErrorKind::AuthenticationProfileAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authentication_profile_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authentication_profile_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AuthenticationProfileQuotaExceededFault" => crate::error::CreateAuthenticationProfileError { meta: generic, kind: crate::error::CreateAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authentication_profile_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authentication_profile_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidAuthenticationProfileRequestFault" => crate::error::CreateAuthenticationProfileError { meta: generic, kind: crate::error::CreateAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_authentication_profile_request_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authentication_profile_request_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateAuthenticationProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_authentication_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAuthenticationProfileOutput,
    crate::error::CreateAuthenticationProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_authentication_profile_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_authentication_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAuthenticationProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterAlreadyExists" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::ClusterAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterParameterGroupNotFound" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::ClusterParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterQuotaExceeded" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::ClusterQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSecurityGroupNotFound" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::ClusterSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSubnetGroupNotFoundFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::ClusterSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependentServiceRequestThrottlingFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::DependentServiceRequestThrottlingFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::dependent_service_request_throttling_fault::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HsmClientCertificateNotFoundFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::HsmClientCertificateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::hsm_client_certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_client_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HsmConfigurationNotFoundFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::HsmConfigurationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::hsm_configuration_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_configuration_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientClusterCapacity" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InsufficientClusterCapacityFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSubnetGroupStateFault" => {
            crate::error::CreateClusterError {
                meta: generic,
                kind: crate::error::CreateClusterErrorKind::InvalidClusterSubnetGroupStateFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_subnet_group_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_subnet_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidClusterTrack" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidClusterTrackFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_track_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_track_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidElasticIpFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidElasticIpFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_elastic_ip_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_elastic_ip_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRetentionPeriodFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidRetentionPeriodFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagFault" => {
            crate::error::CreateClusterError {
                meta: generic,
                kind: crate::error::CreateClusterErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidVPCNetworkStateFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededFault" => {
            crate::error::CreateClusterError {
                meta: generic,
                kind: crate::error::CreateClusterErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NumberOfNodesPerClusterLimitExceeded" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_per_cluster_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NumberOfNodesQuotaExceeded" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::NumberOfNodesQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::number_of_nodes_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotScheduleNotFound" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::SnapshotScheduleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_schedule_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagLimitExceededFault" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::TagLimitExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::CreateClusterError {
            meta: generic,
            kind: crate::error::CreateClusterErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateClusterOutput, crate::error::CreateClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterParameterGroupOutput,
    crate::error::CreateClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterParameterGroupAlreadyExists" => crate::error::CreateClusterParameterGroupError { meta: generic, kind: crate::error::CreateClusterParameterGroupErrorKind::ClusterParameterGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterParameterGroupQuotaExceeded" => crate::error::CreateClusterParameterGroupError { meta: generic, kind: crate::error::CreateClusterParameterGroupErrorKind::ClusterParameterGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::CreateClusterParameterGroupError { meta: generic, kind: crate::error::CreateClusterParameterGroupErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagLimitExceededFault" => crate::error::CreateClusterParameterGroupError { meta: generic, kind: crate::error::CreateClusterParameterGroupErrorKind::TagLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterParameterGroupOutput,
    crate::error::CreateClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cluster_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateClusterParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_security_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterSecurityGroupOutput,
    crate::error::CreateClusterSecurityGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateClusterSecurityGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateClusterSecurityGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSecurityGroupAlreadyExists" => crate::error::CreateClusterSecurityGroupError { meta: generic, kind: crate::error::CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_security_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "QuotaExceeded.ClusterSecurityGroup" => crate::error::CreateClusterSecurityGroupError { meta: generic, kind: crate::error::CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_security_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::CreateClusterSecurityGroupError { meta: generic, kind: crate::error::CreateClusterSecurityGroupErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagLimitExceededFault" => crate::error::CreateClusterSecurityGroupError { meta: generic, kind: crate::error::CreateClusterSecurityGroupErrorKind::TagLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateClusterSecurityGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_security_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterSecurityGroupOutput,
    crate::error::CreateClusterSecurityGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cluster_security_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cluster_security_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateClusterSecurityGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterSnapshotOutput,
    crate::error::CreateClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateClusterSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::CreateClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateClusterSnapshotErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSnapshotAlreadyExists" => crate::error::CreateClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cluster_snapshot_already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ClusterSnapshotQuotaExceeded" => crate::error::CreateClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cluster_snapshot_quota_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidClusterState" => crate::error::CreateClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateClusterSnapshotErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRetentionPeriodFault" => crate::error::CreateClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateClusterSnapshotErrorKind::InvalidRetentionPeriodFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagFault" => {
            crate::error::CreateClusterSnapshotError {
                meta: generic,
                kind: crate::error::CreateClusterSnapshotErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagLimitExceededFault" => crate::error::CreateClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateClusterSnapshotErrorKind::TagLimitExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateClusterSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterSnapshotOutput,
    crate::error::CreateClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterSubnetGroupOutput,
    crate::error::CreateClusterSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateClusterSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSubnetGroupAlreadyExists" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSubnetGroupQuotaExceeded" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSubnetQuotaExceededFault" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DependentServiceRequestThrottlingFault" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependent_service_request_throttling_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagLimitExceededFault" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::TagLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperation" => crate::error::CreateClusterSubnetGroupError { meta: generic, kind: crate::error::CreateClusterSubnetGroupErrorKind::UnauthorizedOperation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateClusterSubnetGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cluster_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateClusterSubnetGroupOutput,
    crate::error::CreateClusterSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cluster_subnet_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_cluster_subnet_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateClusterSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEndpointAccessOutput,
    crate::error::CreateEndpointAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEndpointAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEndpointAccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessToClusterDenied" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::AccessToClusterDeniedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_to_cluster_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_to_cluster_denied_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterNotFound" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::ClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSubnetGroupNotFoundFault" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::ClusterSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EndpointAlreadyExists" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::EndpointAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoint_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EndpointsPerAuthorizationLimitExceeded" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::EndpointsPerAuthorizationLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoints_per_authorization_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoints_per_authorization_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "EndpointsPerClusterLimitExceeded" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::EndpointsPerClusterLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::endpoints_per_cluster_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoints_per_cluster_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSecurityGroupState" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterState" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::InvalidClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperation" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::UnauthorizedOperation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperation" => crate::error::CreateEndpointAccessError { meta: generic, kind: crate::error::CreateEndpointAccessErrorKind::UnsupportedOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEndpointAccessError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateEndpointAccessError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_endpoint_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEndpointAccessOutput,
    crate::error::CreateEndpointAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_endpoint_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_endpoint_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEndpointAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSubscriptionOutput,
    crate::error::CreateEventSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventSubscriptionQuotaExceeded" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind:
                crate::error::CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::event_subscription_quota_exceeded_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_event_subscription_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidTagFault" => {
            crate::error::CreateEventSubscriptionError {
                meta: generic,
                kind: crate::error::CreateEventSubscriptionErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SNSInvalidTopic" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_invalid_topic_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_invalid_topic_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSNoAuthorization" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_no_authorization_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_no_authorization_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSTopicArnNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::sns_topic_arn_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_topic_arn_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SourceNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::source_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_source_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionAlreadyExist" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::subscription_already_exist_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_already_exist_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionCategoryNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_category_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_category_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "SubscriptionEventIdNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_event_id_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_event_id_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "SubscriptionSeverityNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_severity_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_severity_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "TagLimitExceededFault" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::TagLimitExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSubscriptionOutput,
    crate::error::CreateEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hsm_client_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHsmClientCertificateOutput,
    crate::error::CreateHsmClientCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHsmClientCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateHsmClientCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HsmClientCertificateAlreadyExistsFault" => crate::error::CreateHsmClientCertificateError { meta: generic, kind: crate::error::CreateHsmClientCertificateErrorKind::HsmClientCertificateAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::hsm_client_certificate_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_client_certificate_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmClientCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "HsmClientCertificateQuotaExceededFault" => crate::error::CreateHsmClientCertificateError { meta: generic, kind: crate::error::CreateHsmClientCertificateErrorKind::HsmClientCertificateQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::hsm_client_certificate_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_client_certificate_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmClientCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::CreateHsmClientCertificateError { meta: generic, kind: crate::error::CreateHsmClientCertificateErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmClientCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagLimitExceededFault" => crate::error::CreateHsmClientCertificateError { meta: generic, kind: crate::error::CreateHsmClientCertificateErrorKind::TagLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmClientCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateHsmClientCertificateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hsm_client_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHsmClientCertificateOutput,
    crate::error::CreateHsmClientCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_hsm_client_certificate_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_hsm_client_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateHsmClientCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hsm_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHsmConfigurationOutput,
    crate::error::CreateHsmConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateHsmConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateHsmConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HsmConfigurationAlreadyExistsFault" => crate::error::CreateHsmConfigurationError {
            meta: generic,
            kind: crate::error::CreateHsmConfigurationErrorKind::HsmConfigurationAlreadyExistsFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::hsm_configuration_already_exists_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_hsm_configuration_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "HsmConfigurationQuotaExceededFault" => crate::error::CreateHsmConfigurationError {
            meta: generic,
            kind: crate::error::CreateHsmConfigurationErrorKind::HsmConfigurationQuotaExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::hsm_configuration_quota_exceeded_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_hsm_configuration_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidTagFault" => {
            crate::error::CreateHsmConfigurationError {
                meta: generic,
                kind: crate::error::CreateHsmConfigurationErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagLimitExceededFault" => crate::error::CreateHsmConfigurationError {
            meta: generic,
            kind: crate::error::CreateHsmConfigurationErrorKind::TagLimitExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateHsmConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateHsmConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_hsm_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateHsmConfigurationOutput,
    crate::error::CreateHsmConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_hsm_configuration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_hsm_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateHsmConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_scheduled_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateScheduledActionOutput,
    crate::error::CreateScheduledActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateScheduledActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateScheduledActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidScheduledAction" => crate::error::CreateScheduledActionError {
            meta: generic,
            kind: crate::error::CreateScheduledActionErrorKind::InvalidScheduledActionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_scheduled_action_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_scheduled_action_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSchedule" => crate::error::CreateScheduledActionError {
            meta: generic,
            kind: crate::error::CreateScheduledActionErrorKind::InvalidScheduleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_schedule_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_schedule_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScheduledActionAlreadyExists" => crate::error::CreateScheduledActionError {
            meta: generic,
            kind: crate::error::CreateScheduledActionErrorKind::ScheduledActionAlreadyExistsFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::scheduled_action_already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_scheduled_action_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateScheduledActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ScheduledActionQuotaExceeded" => crate::error::CreateScheduledActionError {
            meta: generic,
            kind: crate::error::CreateScheduledActionErrorKind::ScheduledActionQuotaExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::scheduled_action_quota_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_scheduled_action_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateScheduledActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ScheduledActionTypeUnsupported" => crate::error::CreateScheduledActionError {
            meta: generic,
            kind: crate::error::CreateScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::scheduled_action_type_unsupported_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_scheduled_action_type_unsupported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateScheduledActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnauthorizedOperation" => crate::error::CreateScheduledActionError {
            meta: generic,
            kind: crate::error::CreateScheduledActionErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateScheduledActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_scheduled_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateScheduledActionOutput,
    crate::error::CreateScheduledActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_scheduled_action_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_scheduled_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateScheduledActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_copy_grant_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSnapshotCopyGrantOutput,
    crate::error::CreateSnapshotCopyGrantError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateSnapshotCopyGrantError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependentServiceRequestThrottlingFault" => crate::error::CreateSnapshotCopyGrantError { meta: generic, kind: crate::error::CreateSnapshotCopyGrantErrorKind::DependentServiceRequestThrottlingFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependent_service_request_throttling_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::CreateSnapshotCopyGrantError { meta: generic, kind: crate::error::CreateSnapshotCopyGrantErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededFault" => crate::error::CreateSnapshotCopyGrantError { meta: generic, kind: crate::error::CreateSnapshotCopyGrantErrorKind::LimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotCopyGrantAlreadyExistsFault" => crate::error::CreateSnapshotCopyGrantError { meta: generic, kind: crate::error::CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_copy_grant_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_grant_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotCopyGrantQuotaExceededFault" => crate::error::CreateSnapshotCopyGrantError { meta: generic, kind: crate::error::CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_copy_grant_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_grant_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagLimitExceededFault" => crate::error::CreateSnapshotCopyGrantError { meta: generic, kind: crate::error::CreateSnapshotCopyGrantErrorKind::TagLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateSnapshotCopyGrantError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_copy_grant_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSnapshotCopyGrantOutput,
    crate::error::CreateSnapshotCopyGrantError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_snapshot_copy_grant_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_snapshot_copy_grant(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSnapshotCopyGrantError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSnapshotScheduleOutput,
    crate::error::CreateSnapshotScheduleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateSnapshotScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidSchedule" => crate::error::CreateSnapshotScheduleError { meta: generic, kind: crate::error::CreateSnapshotScheduleErrorKind::InvalidScheduleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_schedule_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_schedule_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::CreateSnapshotScheduleError { meta: generic, kind: crate::error::CreateSnapshotScheduleErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ScheduleDefinitionTypeUnsupported" => crate::error::CreateSnapshotScheduleError { meta: generic, kind: crate::error::CreateSnapshotScheduleErrorKind::ScheduleDefinitionTypeUnsupportedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::schedule_definition_type_unsupported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_schedule_definition_type_unsupported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotScheduleAlreadyExists" => crate::error::CreateSnapshotScheduleError { meta: generic, kind: crate::error::CreateSnapshotScheduleErrorKind::SnapshotScheduleAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_schedule_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotScheduleQuotaExceeded" => crate::error::CreateSnapshotScheduleError { meta: generic, kind: crate::error::CreateSnapshotScheduleErrorKind::SnapshotScheduleQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_schedule_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagLimitExceededFault" => crate::error::CreateSnapshotScheduleError { meta: generic, kind: crate::error::CreateSnapshotScheduleErrorKind::TagLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateSnapshotScheduleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_snapshot_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSnapshotScheduleOutput,
    crate::error::CreateSnapshotScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_snapshot_schedule_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_snapshot_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSnapshotScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidClusterState" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagFault" => {
            crate::error::CreateTagsError {
                meta: generic,
                kind: crate::error::CreateTagsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundFault" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagLimitExceededFault" => crate::error::CreateTagsError {
            meta: generic,
            kind: crate::error::CreateTagsErrorKind::TagLimitExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_usage_limit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUsageLimitOutput, crate::error::CreateUsageLimitError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUsageLimitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUsageLimitError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::CreateUsageLimitError {
            meta: generic,
            kind: crate::error::CreateUsageLimitErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::CreateUsageLimitError {
            meta: generic,
            kind: crate::error::CreateUsageLimitErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUsageLimit" => crate::error::CreateUsageLimitError {
            meta: generic,
            kind: crate::error::CreateUsageLimitErrorKind::InvalidUsageLimitFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_usage_limit_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_usage_limit_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededFault" => {
            crate::error::CreateUsageLimitError {
                meta: generic,
                kind: crate::error::CreateUsageLimitErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUsageLimitError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TagLimitExceededFault" => crate::error::CreateUsageLimitError {
            meta: generic,
            kind: crate::error::CreateUsageLimitErrorKind::TagLimitExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::CreateUsageLimitError {
            meta: generic,
            kind: crate::error::CreateUsageLimitErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UsageLimitAlreadyExists" => crate::error::CreateUsageLimitError {
            meta: generic,
            kind: crate::error::CreateUsageLimitErrorKind::UsageLimitAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::usage_limit_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_usage_limit_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUsageLimitError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_usage_limit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUsageLimitOutput, crate::error::CreateUsageLimitError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_usage_limit_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_usage_limit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUsageLimitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deauthorize_data_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeauthorizeDataShareOutput,
    crate::error::DeauthorizeDataShareError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeauthorizeDataShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeauthorizeDataShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidDataShareFault" => crate::error::DeauthorizeDataShareError {
            meta: generic,
            kind: crate::error::DeauthorizeDataShareErrorKind::InvalidDataShareFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_data_share_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_data_share_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeauthorizeDataShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeauthorizeDataShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deauthorize_data_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeauthorizeDataShareOutput,
    crate::error::DeauthorizeDataShareError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deauthorize_data_share_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_deauthorize_data_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeauthorizeDataShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_authentication_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAuthenticationProfileOutput,
    crate::error::DeleteAuthenticationProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAuthenticationProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAuthenticationProfileError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthenticationProfileNotFoundFault" => crate::error::DeleteAuthenticationProfileError { meta: generic, kind: crate::error::DeleteAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authentication_profile_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authentication_profile_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidAuthenticationProfileRequestFault" => crate::error::DeleteAuthenticationProfileError { meta: generic, kind: crate::error::DeleteAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_authentication_profile_request_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authentication_profile_request_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteAuthenticationProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_authentication_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAuthenticationProfileOutput,
    crate::error::DeleteAuthenticationProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_authentication_profile_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_authentication_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteAuthenticationProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSnapshotAlreadyExists" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::ClusterSnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSnapshotQuotaExceeded" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::ClusterSnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRetentionPeriodFault" => crate::error::DeleteClusterError {
            meta: generic,
            kind: crate::error::DeleteClusterErrorKind::InvalidRetentionPeriodFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteClusterOutput, crate::error::DeleteClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterParameterGroupOutput,
    crate::error::DeleteClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterParameterGroupNotFound" => crate::error::DeleteClusterParameterGroupError { meta: generic, kind: crate::error::DeleteClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterParameterGroupState" => crate::error::DeleteClusterParameterGroupError { meta: generic, kind: crate::error::DeleteClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterParameterGroupOutput,
    crate::error::DeleteClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_security_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterSecurityGroupOutput,
    crate::error::DeleteClusterSecurityGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteClusterSecurityGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteClusterSecurityGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSecurityGroupNotFound" => crate::error::DeleteClusterSecurityGroupError { meta: generic, kind: crate::error::DeleteClusterSecurityGroupErrorKind::ClusterSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSecurityGroupState" => crate::error::DeleteClusterSecurityGroupError { meta: generic, kind: crate::error::DeleteClusterSecurityGroupErrorKind::InvalidClusterSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterSecurityGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteClusterSecurityGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_security_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterSecurityGroupOutput,
    crate::error::DeleteClusterSecurityGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cluster_security_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterSnapshotOutput,
    crate::error::DeleteClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteClusterSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSnapshotNotFound" => crate::error::DeleteClusterSnapshotError {
            meta: generic,
            kind: crate::error::DeleteClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSnapshotState" => crate::error::DeleteClusterSnapshotError {
            meta: generic,
            kind: crate::error::DeleteClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteClusterSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterSnapshotOutput,
    crate::error::DeleteClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterSubnetGroupOutput,
    crate::error::DeleteClusterSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteClusterSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteClusterSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSubnetGroupNotFoundFault" => crate::error::DeleteClusterSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::cluster_subnet_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterSubnetGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidClusterSubnetGroupStateFault" => crate::error::DeleteClusterSubnetGroupError {
            meta: generic,
            kind:
                crate::error::DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetGroupStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_subnet_group_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_subnet_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterSubnetGroupError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidClusterSubnetStateFault" => crate::error::DeleteClusterSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_cluster_subnet_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_subnet_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteClusterSubnetGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteClusterSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cluster_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteClusterSubnetGroupOutput,
    crate::error::DeleteClusterSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cluster_subnet_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEndpointAccessOutput,
    crate::error::DeleteEndpointAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEndpointAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteEndpointAccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DeleteEndpointAccessError {
            meta: generic,
            kind: crate::error::DeleteEndpointAccessErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointNotFound" => crate::error::DeleteEndpointAccessError {
            meta: generic,
            kind: crate::error::DeleteEndpointAccessErrorKind::EndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSecurityGroupState" => crate::error::DeleteEndpointAccessError {
            meta: generic,
            kind:
                crate::error::DeleteEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_security_group_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointAccessError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidClusterState" => crate::error::DeleteEndpointAccessError {
            meta: generic,
            kind: crate::error::DeleteEndpointAccessErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointState" => crate::error::DeleteEndpointAccessError {
            meta: generic,
            kind: crate::error::DeleteEndpointAccessErrorKind::InvalidEndpointStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_endpoint_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEndpointAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_endpoint_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEndpointAccessOutput,
    crate::error::DeleteEndpointAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_endpoint_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_endpoint_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteEndpointAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSubscriptionOutput,
    crate::error::DeleteEventSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidSubscriptionStateFault" => crate::error::DeleteEventSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteEventSubscriptionErrorKind::InvalidSubscriptionStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_subscription_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subscription_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionNotFound" => crate::error::DeleteEventSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subscription_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSubscriptionOutput,
    crate::error::DeleteEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_event_subscription_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_hsm_client_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteHsmClientCertificateOutput,
    crate::error::DeleteHsmClientCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteHsmClientCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteHsmClientCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HsmClientCertificateNotFoundFault" => crate::error::DeleteHsmClientCertificateError { meta: generic, kind: crate::error::DeleteHsmClientCertificateErrorKind::HsmClientCertificateNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::hsm_client_certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_client_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteHsmClientCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidHsmClientCertificateStateFault" => crate::error::DeleteHsmClientCertificateError { meta: generic, kind: crate::error::DeleteHsmClientCertificateErrorKind::InvalidHsmClientCertificateStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_hsm_client_certificate_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_hsm_client_certificate_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteHsmClientCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteHsmClientCertificateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_hsm_client_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteHsmClientCertificateOutput,
    crate::error::DeleteHsmClientCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_hsm_client_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_hsm_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteHsmConfigurationOutput,
    crate::error::DeleteHsmConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteHsmConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteHsmConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HsmConfigurationNotFoundFault" => crate::error::DeleteHsmConfigurationError {
            meta: generic,
            kind: crate::error::DeleteHsmConfigurationErrorKind::HsmConfigurationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::hsm_configuration_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_configuration_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteHsmConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidHsmConfigurationStateFault" => crate::error::DeleteHsmConfigurationError {
            meta: generic,
            kind: crate::error::DeleteHsmConfigurationErrorKind::InvalidHsmConfigurationStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_hsm_configuration_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_hsm_configuration_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteHsmConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteHsmConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_hsm_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteHsmConfigurationOutput,
    crate::error::DeleteHsmConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_hsm_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_partner_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePartnerOutput, crate::error::DeletePartnerError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePartnerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePartnerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DeletePartnerError {
            meta: generic,
            kind: crate::error::DeletePartnerErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePartnerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PartnerNotFound" => crate::error::DeletePartnerError {
            meta: generic,
            kind: crate::error::DeletePartnerErrorKind::PartnerNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::partner_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_partner_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePartnerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedPartnerIntegration" => crate::error::DeletePartnerError {
            meta: generic,
            kind: crate::error::DeletePartnerErrorKind::UnauthorizedPartnerIntegrationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_partner_integration_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_partner_integration_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePartnerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePartnerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_partner_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePartnerOutput, crate::error::DeletePartnerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_partner_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_partner(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeletePartnerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_scheduled_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteScheduledActionOutput,
    crate::error::DeleteScheduledActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteScheduledActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteScheduledActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ScheduledActionNotFound" => crate::error::DeleteScheduledActionError {
            meta: generic,
            kind: crate::error::DeleteScheduledActionErrorKind::ScheduledActionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scheduled_action_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scheduled_action_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::DeleteScheduledActionError {
            meta: generic,
            kind: crate::error::DeleteScheduledActionErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteScheduledActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_scheduled_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteScheduledActionOutput,
    crate::error::DeleteScheduledActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_scheduled_action_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_copy_grant_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSnapshotCopyGrantOutput,
    crate::error::DeleteSnapshotCopyGrantError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSnapshotCopyGrantError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSnapshotCopyGrantError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidSnapshotCopyGrantStateFault" => crate::error::DeleteSnapshotCopyGrantError {
            meta: generic,
            kind:
                crate::error::DeleteSnapshotCopyGrantErrorKind::InvalidSnapshotCopyGrantStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_snapshot_copy_grant_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_snapshot_copy_grant_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotCopyGrantError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "SnapshotCopyGrantNotFoundFault" => crate::error::DeleteSnapshotCopyGrantError {
            meta: generic,
            kind: crate::error::DeleteSnapshotCopyGrantErrorKind::SnapshotCopyGrantNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_copy_grant_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_grant_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotCopyGrantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSnapshotCopyGrantError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_copy_grant_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSnapshotCopyGrantOutput,
    crate::error::DeleteSnapshotCopyGrantError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_snapshot_copy_grant_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSnapshotScheduleOutput,
    crate::error::DeleteSnapshotScheduleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSnapshotScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSnapshotScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidClusterSnapshotScheduleState" => crate::error::DeleteSnapshotScheduleError { meta: generic, kind: crate::error::DeleteSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_snapshot_schedule_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_schedule_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotScheduleNotFound" => crate::error::DeleteSnapshotScheduleError { meta: generic, kind: crate::error::DeleteSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_schedule_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteSnapshotScheduleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_snapshot_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSnapshotScheduleOutput,
    crate::error::DeleteSnapshotScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_snapshot_schedule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTagFault" => {
            crate::error::DeleteTagsError {
                meta: generic,
                kind: crate::error::DeleteTagsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundFault" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tags_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_usage_limit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUsageLimitOutput, crate::error::DeleteUsageLimitError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUsageLimitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUsageLimitError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "UnsupportedOperation" => crate::error::DeleteUsageLimitError {
            meta: generic,
            kind: crate::error::DeleteUsageLimitErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UsageLimitNotFound" => crate::error::DeleteUsageLimitError {
            meta: generic,
            kind: crate::error::DeleteUsageLimitErrorKind::UsageLimitNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::usage_limit_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_usage_limit_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUsageLimitError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_usage_limit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUsageLimitOutput, crate::error::DeleteUsageLimitError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_usage_limit_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
    Err(crate::error::DescribeAccountAttributesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_account_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_authentication_profiles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAuthenticationProfilesOutput,
    crate::error::DescribeAuthenticationProfilesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAuthenticationProfilesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAuthenticationProfilesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthenticationProfileNotFoundFault" => crate::error::DescribeAuthenticationProfilesError { meta: generic, kind: crate::error::DescribeAuthenticationProfilesErrorKind::AuthenticationProfileNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authentication_profile_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authentication_profile_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAuthenticationProfilesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidAuthenticationProfileRequestFault" => crate::error::DescribeAuthenticationProfilesError { meta: generic, kind: crate::error::DescribeAuthenticationProfilesErrorKind::InvalidAuthenticationProfileRequestFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_authentication_profile_request_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authentication_profile_request_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAuthenticationProfilesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeAuthenticationProfilesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_authentication_profiles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAuthenticationProfilesOutput,
    crate::error::DescribeAuthenticationProfilesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_authentication_profiles_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_authentication_profiles(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeAuthenticationProfilesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_db_revisions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterDbRevisionsOutput,
    crate::error::DescribeClusterDbRevisionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterDbRevisionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeClusterDbRevisionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeClusterDbRevisionsError {
            meta: generic,
            kind: crate::error::DescribeClusterDbRevisionsErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterDbRevisionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::DescribeClusterDbRevisionsError {
            meta: generic,
            kind: crate::error::DescribeClusterDbRevisionsErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterDbRevisionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeClusterDbRevisionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_db_revisions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterDbRevisionsOutput,
    crate::error::DescribeClusterDbRevisionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_db_revisions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cluster_db_revisions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClusterDbRevisionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_parameter_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterParameterGroupsOutput,
    crate::error::DescribeClusterParameterGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterParameterGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeClusterParameterGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterParameterGroupNotFound" => crate::error::DescribeClusterParameterGroupsError { meta: generic, kind: crate::error::DescribeClusterParameterGroupsErrorKind::ClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterParameterGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::DescribeClusterParameterGroupsError { meta: generic, kind: crate::error::DescribeClusterParameterGroupsErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterParameterGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeClusterParameterGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_parameter_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterParameterGroupsOutput,
    crate::error::DescribeClusterParameterGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_cluster_parameter_groups_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_cluster_parameter_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeClusterParameterGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterParametersOutput,
    crate::error::DescribeClusterParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeClusterParametersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterParameterGroupNotFound" => crate::error::DescribeClusterParametersError {
            meta: generic,
            kind:
                crate::error::DescribeClusterParametersErrorKind::ClusterParameterGroupNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterParametersError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeClusterParametersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterParametersOutput,
    crate::error::DescribeClusterParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_parameters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cluster_parameters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClusterParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_clusters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeClustersOutput, crate::error::DescribeClustersError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClustersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeClustersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeClustersError {
            meta: generic,
            kind: crate::error::DescribeClustersErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagFault" => {
            crate::error::DescribeClustersError {
                meta: generic,
                kind: crate::error::DescribeClustersErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClustersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeClustersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_clusters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeClustersOutput, crate::error::DescribeClustersError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_clusters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_clusters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClustersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_security_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterSecurityGroupsOutput,
    crate::error::DescribeClusterSecurityGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterSecurityGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeClusterSecurityGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSecurityGroupNotFound" => crate::error::DescribeClusterSecurityGroupsError { meta: generic, kind: crate::error::DescribeClusterSecurityGroupsErrorKind::ClusterSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterSecurityGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::DescribeClusterSecurityGroupsError { meta: generic, kind: crate::error::DescribeClusterSecurityGroupsErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterSecurityGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeClusterSecurityGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_security_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterSecurityGroupsOutput,
    crate::error::DescribeClusterSecurityGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_security_groups_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_cluster_security_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeClusterSecurityGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterSnapshotsOutput,
    crate::error::DescribeClusterSnapshotsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeClusterSnapshotsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeClusterSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeClusterSnapshotsErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSnapshotNotFound" => crate::error::DescribeClusterSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeClusterSnapshotsErrorKind::ClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagFault" => {
            crate::error::DescribeClusterSnapshotsError {
                meta: generic,
                kind: crate::error::DescribeClusterSnapshotsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterSnapshotsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeClusterSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterSnapshotsOutput,
    crate::error::DescribeClusterSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_snapshots_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cluster_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClusterSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_subnet_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterSubnetGroupsOutput,
    crate::error::DescribeClusterSubnetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterSubnetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeClusterSubnetGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSubnetGroupNotFoundFault" => crate::error::DescribeClusterSubnetGroupsError {
            meta: generic,
            kind:
                crate::error::DescribeClusterSubnetGroupsErrorKind::ClusterSubnetGroupNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_group_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterSubnetGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidTagFault" => {
            crate::error::DescribeClusterSubnetGroupsError {
                meta: generic,
                kind: crate::error::DescribeClusterSubnetGroupsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterSubnetGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeClusterSubnetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_subnet_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterSubnetGroupsOutput,
    crate::error::DescribeClusterSubnetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_subnet_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cluster_subnet_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClusterSubnetGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_tracks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterTracksOutput,
    crate::error::DescribeClusterTracksError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterTracksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeClusterTracksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidClusterTrack" => crate::error::DescribeClusterTracksError {
            meta: generic,
            kind: crate::error::DescribeClusterTracksErrorKind::InvalidClusterTrackFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_track_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_track_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterTracksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::DescribeClusterTracksError {
            meta: generic,
            kind: crate::error::DescribeClusterTracksErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeClusterTracksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeClusterTracksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_tracks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterTracksOutput,
    crate::error::DescribeClusterTracksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_tracks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cluster_tracks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClusterTracksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterVersionsOutput,
    crate::error::DescribeClusterVersionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeClusterVersionsError::unhandled)?;
    Err(crate::error::DescribeClusterVersionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cluster_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeClusterVersionsOutput,
    crate::error::DescribeClusterVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_cluster_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_cluster_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeClusterVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_shares_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSharesOutput,
    crate::error::DescribeDataSharesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDataSharesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDataSharesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidDataShareFault" => crate::error::DescribeDataSharesError {
            meta: generic,
            kind: crate::error::DescribeDataSharesErrorKind::InvalidDataShareFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_data_share_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_data_share_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataSharesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDataSharesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_shares_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSharesOutput,
    crate::error::DescribeDataSharesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_data_shares_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_data_shares(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDataSharesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_shares_for_consumer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSharesForConsumerOutput,
    crate::error::DescribeDataSharesForConsumerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDataSharesForConsumerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDataSharesForConsumerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNamespaceFault" => crate::error::DescribeDataSharesForConsumerError {
            meta: generic,
            kind: crate::error::DescribeDataSharesForConsumerErrorKind::InvalidNamespaceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_namespace_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_namespace_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataSharesForConsumerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDataSharesForConsumerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_shares_for_consumer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSharesForConsumerOutput,
    crate::error::DescribeDataSharesForConsumerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_data_shares_for_consumer_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_data_shares_for_consumer(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeDataSharesForConsumerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_shares_for_producer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSharesForProducerOutput,
    crate::error::DescribeDataSharesForProducerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDataSharesForProducerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDataSharesForProducerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNamespaceFault" => crate::error::DescribeDataSharesForProducerError {
            meta: generic,
            kind: crate::error::DescribeDataSharesForProducerErrorKind::InvalidNamespaceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_namespace_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_namespace_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataSharesForProducerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDataSharesForProducerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_shares_for_producer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSharesForProducerOutput,
    crate::error::DescribeDataSharesForProducerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_data_shares_for_producer_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_data_shares_for_producer(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeDataSharesForProducerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_default_cluster_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDefaultClusterParametersOutput,
    crate::error::DescribeDefaultClusterParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDefaultClusterParametersError::unhandled)?;
    Err(crate::error::DescribeDefaultClusterParametersError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_default_cluster_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDefaultClusterParametersOutput,
    crate::error::DescribeDefaultClusterParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_default_cluster_parameters_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_default_cluster_parameters(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeDefaultClusterParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointAccessOutput,
    crate::error::DescribeEndpointAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEndpointAccessError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeEndpointAccessError {
            meta: generic,
            kind: crate::error::DescribeEndpointAccessErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointNotFound" => crate::error::DescribeEndpointAccessError {
            meta: generic,
            kind: crate::error::DescribeEndpointAccessErrorKind::EndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::DescribeEndpointAccessError {
            meta: generic,
            kind: crate::error::DescribeEndpointAccessErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEndpointAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointAccessOutput,
    crate::error::DescribeEndpointAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_endpoint_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_authorization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointAuthorizationOutput,
    crate::error::DescribeEndpointAuthorizationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEndpointAuthorizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEndpointAuthorizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeEndpointAuthorizationError {
            meta: generic,
            kind: crate::error::DescribeEndpointAuthorizationErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointAuthorizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::DescribeEndpointAuthorizationError {
            meta: generic,
            kind: crate::error::DescribeEndpointAuthorizationErrorKind::UnsupportedOperationFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unsupported_operation_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEndpointAuthorizationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeEndpointAuthorizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_endpoint_authorization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEndpointAuthorizationOutput,
    crate::error::DescribeEndpointAuthorizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_endpoint_authorization_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_endpoint_authorization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEndpointAuthorizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_categories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventCategoriesOutput,
    crate::error::DescribeEventCategoriesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventCategoriesError::unhandled)?;
    Err(crate::error::DescribeEventCategoriesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_categories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventCategoriesOutput,
    crate::error::DescribeEventCategoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_event_categories_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_event_categories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventCategoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventsError::unhandled)?;
    Err(crate::error::DescribeEventsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_events_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_subscriptions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventSubscriptionsOutput,
    crate::error::DescribeEventSubscriptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEventSubscriptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTagFault" => {
            crate::error::DescribeEventSubscriptionsError {
                meta: generic,
                kind: crate::error::DescribeEventSubscriptionsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SubscriptionNotFound" => crate::error::DescribeEventSubscriptionsError {
            meta: generic,
            kind: crate::error::DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subscription_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEventSubscriptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_subscriptions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventSubscriptionsOutput,
    crate::error::DescribeEventSubscriptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_event_subscriptions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_event_subscriptions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_hsm_client_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHsmClientCertificatesOutput,
    crate::error::DescribeHsmClientCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeHsmClientCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeHsmClientCertificatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HsmClientCertificateNotFoundFault" => crate::error::DescribeHsmClientCertificatesError { meta: generic, kind: crate::error::DescribeHsmClientCertificatesErrorKind::HsmClientCertificateNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::hsm_client_certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_client_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeHsmClientCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::DescribeHsmClientCertificatesError { meta: generic, kind: crate::error::DescribeHsmClientCertificatesErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeHsmClientCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeHsmClientCertificatesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_hsm_client_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHsmClientCertificatesOutput,
    crate::error::DescribeHsmClientCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_hsm_client_certificates_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_hsm_client_certificates(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeHsmClientCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_hsm_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHsmConfigurationsOutput,
    crate::error::DescribeHsmConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeHsmConfigurationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeHsmConfigurationsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "HsmConfigurationNotFoundFault" => crate::error::DescribeHsmConfigurationsError {
            meta: generic,
            kind: crate::error::DescribeHsmConfigurationsErrorKind::HsmConfigurationNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::hsm_configuration_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_hsm_configuration_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeHsmConfigurationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidTagFault" => {
            crate::error::DescribeHsmConfigurationsError {
                meta: generic,
                kind: crate::error::DescribeHsmConfigurationsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeHsmConfigurationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeHsmConfigurationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_hsm_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeHsmConfigurationsOutput,
    crate::error::DescribeHsmConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_hsm_configurations_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_hsm_configurations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeHsmConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_logging_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoggingStatusOutput,
    crate::error::DescribeLoggingStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeLoggingStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeLoggingStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeLoggingStatusError {
            meta: generic,
            kind: crate::error::DescribeLoggingStatusErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeLoggingStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeLoggingStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_logging_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeLoggingStatusOutput,
    crate::error::DescribeLoggingStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_logging_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_logging_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeLoggingStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_node_configuration_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNodeConfigurationOptionsOutput,
    crate::error::DescribeNodeConfigurationOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeNodeConfigurationOptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeNodeConfigurationOptionsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessToSnapshotDenied" => crate::error::DescribeNodeConfigurationOptionsError { meta: generic, kind: crate::error::DescribeNodeConfigurationOptionsErrorKind::AccessToSnapshotDeniedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_to_snapshot_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_to_snapshot_denied_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeNodeConfigurationOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterNotFound" => crate::error::DescribeNodeConfigurationOptionsError { meta: generic, kind: crate::error::DescribeNodeConfigurationOptionsErrorKind::ClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeNodeConfigurationOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSnapshotNotFound" => crate::error::DescribeNodeConfigurationOptionsError { meta: generic, kind: crate::error::DescribeNodeConfigurationOptionsErrorKind::ClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeNodeConfigurationOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSnapshotState" => crate::error::DescribeNodeConfigurationOptionsError { meta: generic, kind: crate::error::DescribeNodeConfigurationOptionsErrorKind::InvalidClusterSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeNodeConfigurationOptionsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeNodeConfigurationOptionsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_node_configuration_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeNodeConfigurationOptionsOutput,
    crate::error::DescribeNodeConfigurationOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_node_configuration_options_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_node_configuration_options(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeNodeConfigurationOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_orderable_cluster_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrderableClusterOptionsOutput,
    crate::error::DescribeOrderableClusterOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOrderableClusterOptionsError::unhandled)?;
    Err(crate::error::DescribeOrderableClusterOptionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_orderable_cluster_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrderableClusterOptionsOutput,
    crate::error::DescribeOrderableClusterOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_orderable_cluster_options_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_orderable_cluster_options(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeOrderableClusterOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_partners_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePartnersOutput, crate::error::DescribePartnersError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePartnersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribePartnersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribePartnersError {
            meta: generic,
            kind: crate::error::DescribePartnersErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePartnersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedPartnerIntegration" => crate::error::DescribePartnersError {
            meta: generic,
            kind: crate::error::DescribePartnersErrorKind::UnauthorizedPartnerIntegrationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unauthorized_partner_integration_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_partner_integration_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePartnersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribePartnersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_partners_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribePartnersOutput, crate::error::DescribePartnersError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_partners_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_partners(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribePartnersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_node_offerings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedNodeOfferingsOutput,
    crate::error::DescribeReservedNodeOfferingsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedNodeOfferingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReservedNodeOfferingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependentServiceUnavailableFault" => crate::error::DescribeReservedNodeOfferingsError { meta: generic, kind: crate::error::DescribeReservedNodeOfferingsErrorKind::DependentServiceUnavailableFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependent_service_unavailable_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_unavailable_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedNodeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedNodeOfferingNotFound" => crate::error::DescribeReservedNodeOfferingsError { meta: generic, kind: crate::error::DescribeReservedNodeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_node_offering_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedNodeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperation" => crate::error::DescribeReservedNodeOfferingsError { meta: generic, kind: crate::error::DescribeReservedNodeOfferingsErrorKind::UnsupportedOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedNodeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReservedNodeOfferingsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_node_offerings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedNodeOfferingsOutput,
    crate::error::DescribeReservedNodeOfferingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_reserved_node_offerings_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_reserved_node_offerings(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeReservedNodeOfferingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_nodes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedNodesOutput,
    crate::error::DescribeReservedNodesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedNodesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeReservedNodesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependentServiceUnavailableFault" => crate::error::DescribeReservedNodesError {
            meta: generic,
            kind: crate::error::DescribeReservedNodesErrorKind::DependentServiceUnavailableFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::dependent_service_unavailable_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_unavailable_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedNodesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReservedNodeNotFound" => crate::error::DescribeReservedNodesError {
            meta: generic,
            kind: crate::error::DescribeReservedNodesErrorKind::ReservedNodeNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::reserved_node_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedNodesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeReservedNodesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_nodes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedNodesOutput,
    crate::error::DescribeReservedNodesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_reserved_nodes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_reserved_nodes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReservedNodesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_resize_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeResizeOutput, crate::error::DescribeResizeError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeResizeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeResizeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeResizeError {
            meta: generic,
            kind: crate::error::DescribeResizeErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeResizeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResizeNotFound" => crate::error::DescribeResizeError {
            meta: generic,
            kind: crate::error::DescribeResizeErrorKind::ResizeNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resize_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resize_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeResizeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeResizeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_resize_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeResizeOutput, crate::error::DescribeResizeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_resize_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_resize(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeResizeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scheduled_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScheduledActionsOutput,
    crate::error::DescribeScheduledActionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeScheduledActionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ScheduledActionNotFound" => crate::error::DescribeScheduledActionsError {
            meta: generic,
            kind: crate::error::DescribeScheduledActionsErrorKind::ScheduledActionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scheduled_action_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scheduled_action_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::DescribeScheduledActionsError {
            meta: generic,
            kind: crate::error::DescribeScheduledActionsErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeScheduledActionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_scheduled_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeScheduledActionsOutput,
    crate::error::DescribeScheduledActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_scheduled_actions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_scheduled_actions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeScheduledActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshot_copy_grants_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSnapshotCopyGrantsOutput,
    crate::error::DescribeSnapshotCopyGrantsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSnapshotCopyGrantsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeSnapshotCopyGrantsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTagFault" => {
            crate::error::DescribeSnapshotCopyGrantsError {
                meta: generic,
                kind: crate::error::DescribeSnapshotCopyGrantsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotCopyGrantsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SnapshotCopyGrantNotFoundFault" => crate::error::DescribeSnapshotCopyGrantsError {
            meta: generic,
            kind: crate::error::DescribeSnapshotCopyGrantsErrorKind::SnapshotCopyGrantNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::snapshot_copy_grant_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_grant_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeSnapshotCopyGrantsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeSnapshotCopyGrantsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshot_copy_grants_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSnapshotCopyGrantsOutput,
    crate::error::DescribeSnapshotCopyGrantsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_snapshot_copy_grants_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_snapshot_copy_grants(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSnapshotCopyGrantsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshot_schedules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSnapshotSchedulesOutput,
    crate::error::DescribeSnapshotSchedulesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSnapshotSchedulesError::unhandled)?;
    Err(crate::error::DescribeSnapshotSchedulesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_snapshot_schedules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSnapshotSchedulesOutput,
    crate::error::DescribeSnapshotSchedulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_snapshot_schedules_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_snapshot_schedules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSnapshotSchedulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_storage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStorageOutput, crate::error::DescribeStorageError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeStorageError::unhandled)?;
    Err(crate::error::DescribeStorageError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_storage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeStorageOutput, crate::error::DescribeStorageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_storage_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_storage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeStorageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_restore_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTableRestoreStatusOutput,
    crate::error::DescribeTableRestoreStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTableRestoreStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeTableRestoreStatusError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeTableRestoreStatusError {
            meta: generic,
            kind: crate::error::DescribeTableRestoreStatusErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableRestoreStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableRestoreNotFoundFault" => crate::error::DescribeTableRestoreStatusError {
            meta: generic,
            kind: crate::error::DescribeTableRestoreStatusErrorKind::TableRestoreNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::table_restore_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_table_restore_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTableRestoreStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTableRestoreStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_table_restore_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeTableRestoreStatusOutput,
    crate::error::DescribeTableRestoreStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_table_restore_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_table_restore_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTableRestoreStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidTagFault" => {
            crate::error::DescribeTagsError {
                meta: generic,
                kind: crate::error::DescribeTagsErrorKind::InvalidTagFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_tag_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFoundFault" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_usage_limits_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUsageLimitsOutput,
    crate::error::DescribeUsageLimitsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeUsageLimitsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeUsageLimitsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DescribeUsageLimitsError {
            meta: generic,
            kind: crate::error::DescribeUsageLimitsErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUsageLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::DescribeUsageLimitsError {
            meta: generic,
            kind: crate::error::DescribeUsageLimitsErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeUsageLimitsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeUsageLimitsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_usage_limits_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeUsageLimitsOutput,
    crate::error::DescribeUsageLimitsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_usage_limits_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_usage_limits(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeUsageLimitsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_logging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableLoggingOutput, crate::error::DisableLoggingError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableLoggingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableLoggingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DisableLoggingError {
            meta: generic,
            kind: crate::error::DisableLoggingErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::DisableLoggingError {
            meta: generic,
            kind: crate::error::DisableLoggingErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableLoggingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_logging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableLoggingOutput, crate::error::DisableLoggingError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_logging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_disable_logging(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisableLoggingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_snapshot_copy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableSnapshotCopyOutput,
    crate::error::DisableSnapshotCopyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableSnapshotCopyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableSnapshotCopyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::DisableSnapshotCopyError {
            meta: generic,
            kind: crate::error::DisableSnapshotCopyErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::DisableSnapshotCopyError {
            meta: generic,
            kind: crate::error::DisableSnapshotCopyErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotCopyAlreadyDisabledFault" => crate::error::DisableSnapshotCopyError {
            meta: generic,
            kind: crate::error::DisableSnapshotCopyErrorKind::SnapshotCopyAlreadyDisabledFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_copy_already_disabled_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_already_disabled_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::DisableSnapshotCopyError {
            meta: generic,
            kind: crate::error::DisableSnapshotCopyErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableSnapshotCopyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_snapshot_copy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableSnapshotCopyOutput,
    crate::error::DisableSnapshotCopyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_snapshot_copy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_disable_snapshot_copy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisableSnapshotCopyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_data_share_consumer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateDataShareConsumerOutput,
    crate::error::DisassociateDataShareConsumerError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisassociateDataShareConsumerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DisassociateDataShareConsumerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidDataShareFault" => crate::error::DisassociateDataShareConsumerError {
            meta: generic,
            kind: crate::error::DisassociateDataShareConsumerErrorKind::InvalidDataShareFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_data_share_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_data_share_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisassociateDataShareConsumerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNamespaceFault" => crate::error::DisassociateDataShareConsumerError {
            meta: generic,
            kind: crate::error::DisassociateDataShareConsumerErrorKind::InvalidNamespaceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_namespace_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_namespace_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DisassociateDataShareConsumerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisassociateDataShareConsumerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disassociate_data_share_consumer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisassociateDataShareConsumerOutput,
    crate::error::DisassociateDataShareConsumerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disassociate_data_share_consumer_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_disassociate_data_share_consumer(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DisassociateDataShareConsumerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_logging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableLoggingOutput, crate::error::EnableLoggingError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableLoggingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableLoggingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BucketNotFoundFault" => crate::error::EnableLoggingError {
            meta: generic,
            kind: crate::error::EnableLoggingErrorKind::BucketNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bucket_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bucket_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterNotFound" => crate::error::EnableLoggingError {
            meta: generic,
            kind: crate::error::EnableLoggingErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientS3BucketPolicyFault" => crate::error::EnableLoggingError {
            meta: generic,
            kind: crate::error::EnableLoggingErrorKind::InsufficientS3BucketPolicyFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_s3_bucket_policy_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_s3_bucket_policy_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::EnableLoggingError {
            meta: generic,
            kind: crate::error::EnableLoggingErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidS3BucketNameFault" => crate::error::EnableLoggingError {
            meta: generic,
            kind: crate::error::EnableLoggingErrorKind::InvalidS3BucketNameFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_s3_bucket_name_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_s3_bucket_name_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidS3KeyPrefixFault" => crate::error::EnableLoggingError {
            meta: generic,
            kind: crate::error::EnableLoggingErrorKind::InvalidS3KeyPrefixFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_s3_key_prefix_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_s3_key_prefix_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableLoggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableLoggingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_logging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableLoggingOutput, crate::error::EnableLoggingError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_logging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_enable_logging(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EnableLoggingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_snapshot_copy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableSnapshotCopyOutput,
    crate::error::EnableSnapshotCopyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableSnapshotCopyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CopyToRegionDisabledFault" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::CopyToRegionDisabledFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::copy_to_region_disabled_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_copy_to_region_disabled_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependentServiceRequestThrottlingFault" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::DependentServiceRequestThrottlingFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::dependent_service_request_throttling_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "IncompatibleOrderableOptions" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::IncompatibleOrderableOptions({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::incompatible_orderable_options::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_incompatible_orderable_options_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRetentionPeriodFault" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::InvalidRetentionPeriodFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededFault" => {
            crate::error::EnableSnapshotCopyError {
                meta: generic,
                kind: crate::error::EnableSnapshotCopyErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SnapshotCopyAlreadyEnabledFault" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::SnapshotCopyAlreadyEnabledFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_copy_already_enabled_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_already_enabled_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotCopyGrantNotFoundFault" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::SnapshotCopyGrantNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_copy_grant_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_grant_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownSnapshotCopyRegionFault" => crate::error::EnableSnapshotCopyError {
            meta: generic,
            kind: crate::error::EnableSnapshotCopyErrorKind::UnknownSnapshotCopyRegionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unknown_snapshot_copy_region_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unknown_snapshot_copy_region_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableSnapshotCopyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_snapshot_copy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableSnapshotCopyOutput,
    crate::error::EnableSnapshotCopyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_snapshot_copy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_enable_snapshot_copy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EnableSnapshotCopyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cluster_credentials_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetClusterCredentialsOutput,
    crate::error::GetClusterCredentialsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetClusterCredentialsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetClusterCredentialsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::GetClusterCredentialsError {
            meta: generic,
            kind: crate::error::GetClusterCredentialsErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetClusterCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::GetClusterCredentialsError {
            meta: generic,
            kind: crate::error::GetClusterCredentialsErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetClusterCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetClusterCredentialsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cluster_credentials_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetClusterCredentialsOutput,
    crate::error::GetClusterCredentialsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_cluster_credentials_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_cluster_credentials(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetClusterCredentialsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reserved_node_exchange_offerings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservedNodeExchangeOfferingsOutput,
    crate::error::GetReservedNodeExchangeOfferingsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DependentServiceUnavailableFault" => crate::error::GetReservedNodeExchangeOfferingsError { meta: generic, kind: crate::error::GetReservedNodeExchangeOfferingsErrorKind::DependentServiceUnavailableFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependent_service_unavailable_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_unavailable_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidReservedNodeState" => crate::error::GetReservedNodeExchangeOfferingsError { meta: generic, kind: crate::error::GetReservedNodeExchangeOfferingsErrorKind::InvalidReservedNodeStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_reserved_node_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_reserved_node_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedNodeAlreadyMigrated" => crate::error::GetReservedNodeExchangeOfferingsError { meta: generic, kind: crate::error::GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeAlreadyMigratedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_node_already_migrated_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_already_migrated_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedNodeNotFound" => crate::error::GetReservedNodeExchangeOfferingsError { meta: generic, kind: crate::error::GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_node_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedNodeOfferingNotFound" => crate::error::GetReservedNodeExchangeOfferingsError { meta: generic, kind: crate::error::GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_node_offering_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperation" => crate::error::GetReservedNodeExchangeOfferingsError { meta: generic, kind: crate::error::GetReservedNodeExchangeOfferingsErrorKind::UnsupportedOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetReservedNodeExchangeOfferingsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reserved_node_exchange_offerings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservedNodeExchangeOfferingsOutput,
    crate::error::GetReservedNodeExchangeOfferingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_reserved_node_exchange_offerings_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_reserved_node_exchange_offerings(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetReservedNodeExchangeOfferingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_aqua_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyAquaConfigurationOutput,
    crate::error::ModifyAquaConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyAquaConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyAquaConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ModifyAquaConfigurationError {
            meta: generic,
            kind: crate::error::ModifyAquaConfigurationErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyAquaConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::ModifyAquaConfigurationError {
            meta: generic,
            kind: crate::error::ModifyAquaConfigurationErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyAquaConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::ModifyAquaConfigurationError {
            meta: generic,
            kind: crate::error::ModifyAquaConfigurationErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyAquaConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyAquaConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_aqua_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyAquaConfigurationOutput,
    crate::error::ModifyAquaConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_aqua_configuration_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_aqua_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyAquaConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_authentication_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyAuthenticationProfileOutput,
    crate::error::ModifyAuthenticationProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyAuthenticationProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyAuthenticationProfileError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthenticationProfileNotFoundFault" => crate::error::ModifyAuthenticationProfileError { meta: generic, kind: crate::error::ModifyAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authentication_profile_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authentication_profile_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AuthenticationProfileQuotaExceededFault" => crate::error::ModifyAuthenticationProfileError { meta: generic, kind: crate::error::ModifyAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authentication_profile_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authentication_profile_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidAuthenticationProfileRequestFault" => crate::error::ModifyAuthenticationProfileError { meta: generic, kind: crate::error::ModifyAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_authentication_profile_request_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authentication_profile_request_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyAuthenticationProfileError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyAuthenticationProfileError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_authentication_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyAuthenticationProfileOutput,
    crate::error::ModifyAuthenticationProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_authentication_profile_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_authentication_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyAuthenticationProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyClusterOutput, crate::error::ModifyClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterAlreadyExists" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::ClusterAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterNotFound" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterParameterGroupNotFound" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::ClusterParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSecurityGroupNotFound" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::ClusterSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependentServiceRequestThrottlingFault" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::DependentServiceRequestThrottlingFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::dependent_service_request_throttling_fault::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HsmClientCertificateNotFoundFault" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::HsmClientCertificateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::hsm_client_certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_client_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "HsmConfigurationNotFoundFault" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::HsmConfigurationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::hsm_configuration_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_configuration_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientClusterCapacity" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::InsufficientClusterCapacityFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSecurityGroupState" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::InvalidClusterSecurityGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cluster_security_group_state_fault::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterTrack" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::InvalidClusterTrackFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_track_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_track_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidElasticIpFault" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::InvalidElasticIpFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_elastic_ip_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_elastic_ip_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRetentionPeriodFault" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::InvalidRetentionPeriodFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededFault" => {
            crate::error::ModifyClusterError {
                meta: generic,
                kind: crate::error::ModifyClusterErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NumberOfNodesPerClusterLimitExceeded" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_per_cluster_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NumberOfNodesQuotaExceeded" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::NumberOfNodesQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::number_of_nodes_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TableLimitExceeded" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::TableLimitExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::table_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_table_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOptionFault" => crate::error::ModifyClusterError {
            meta: generic,
            kind: crate::error::ModifyClusterErrorKind::UnsupportedOptionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_option_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_option_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyClusterOutput, crate::error::ModifyClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_db_revision_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterDbRevisionOutput,
    crate::error::ModifyClusterDbRevisionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterDbRevisionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyClusterDbRevisionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ModifyClusterDbRevisionError {
            meta: generic,
            kind: crate::error::ModifyClusterDbRevisionErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterDbRevisionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterOnLatestRevision" => crate::error::ModifyClusterDbRevisionError {
            meta: generic,
            kind: crate::error::ModifyClusterDbRevisionErrorKind::ClusterOnLatestRevisionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_on_latest_revision_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_on_latest_revision_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterDbRevisionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::ModifyClusterDbRevisionError {
            meta: generic,
            kind: crate::error::ModifyClusterDbRevisionErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterDbRevisionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyClusterDbRevisionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_db_revision_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterDbRevisionOutput,
    crate::error::ModifyClusterDbRevisionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_db_revision_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cluster_db_revision(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyClusterDbRevisionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_iam_roles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterIamRolesOutput,
    crate::error::ModifyClusterIamRolesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterIamRolesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyClusterIamRolesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ModifyClusterIamRolesError {
            meta: generic,
            kind: crate::error::ModifyClusterIamRolesErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterIamRolesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::ModifyClusterIamRolesError {
            meta: generic,
            kind: crate::error::ModifyClusterIamRolesErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterIamRolesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyClusterIamRolesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_iam_roles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterIamRolesOutput,
    crate::error::ModifyClusterIamRolesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_iam_roles_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cluster_iam_roles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyClusterIamRolesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_maintenance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterMaintenanceOutput,
    crate::error::ModifyClusterMaintenanceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterMaintenanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyClusterMaintenanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ModifyClusterMaintenanceError {
            meta: generic,
            kind: crate::error::ModifyClusterMaintenanceErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterMaintenanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::ModifyClusterMaintenanceError {
            meta: generic,
            kind: crate::error::ModifyClusterMaintenanceErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterMaintenanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyClusterMaintenanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_maintenance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterMaintenanceOutput,
    crate::error::ModifyClusterMaintenanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_maintenance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cluster_maintenance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyClusterMaintenanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterParameterGroupOutput,
    crate::error::ModifyClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterParameterGroupNotFound" => crate::error::ModifyClusterParameterGroupError { meta: generic, kind: crate::error::ModifyClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterParameterGroupState" => crate::error::ModifyClusterParameterGroupError { meta: generic, kind: crate::error::ModifyClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterParameterGroupOutput,
    crate::error::ModifyClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cluster_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyClusterParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterSnapshotOutput,
    crate::error::ModifyClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyClusterSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSnapshotNotFound" => crate::error::ModifyClusterSnapshotError {
            meta: generic,
            kind: crate::error::ModifyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSnapshotState" => crate::error::ModifyClusterSnapshotError {
            meta: generic,
            kind: crate::error::ModifyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRetentionPeriodFault" => crate::error::ModifyClusterSnapshotError {
            meta: generic,
            kind: crate::error::ModifyClusterSnapshotErrorKind::InvalidRetentionPeriodFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyClusterSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterSnapshotOutput,
    crate::error::ModifyClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_snapshot_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterSnapshotScheduleOutput,
    crate::error::ModifyClusterSnapshotScheduleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterSnapshotScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyClusterSnapshotScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ModifyClusterSnapshotScheduleError { meta: generic, kind: crate::error::ModifyClusterSnapshotScheduleErrorKind::ClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSnapshotScheduleState" => crate::error::ModifyClusterSnapshotScheduleError { meta: generic, kind: crate::error::ModifyClusterSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_snapshot_schedule_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_schedule_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotScheduleNotFound" => crate::error::ModifyClusterSnapshotScheduleError { meta: generic, kind: crate::error::ModifyClusterSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_schedule_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSnapshotScheduleError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyClusterSnapshotScheduleError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_snapshot_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterSnapshotScheduleOutput,
    crate::error::ModifyClusterSnapshotScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_snapshot_schedule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterSubnetGroupOutput,
    crate::error::ModifyClusterSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyClusterSubnetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterSubnetGroupNotFoundFault" => crate::error::ModifyClusterSubnetGroupError { meta: generic, kind: crate::error::ModifyClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSubnetQuotaExceededFault" => crate::error::ModifyClusterSubnetGroupError { meta: generic, kind: crate::error::ModifyClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DependentServiceRequestThrottlingFault" => crate::error::ModifyClusterSubnetGroupError { meta: generic, kind: crate::error::ModifyClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependent_service_request_throttling_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::ModifyClusterSubnetGroupError { meta: generic, kind: crate::error::ModifyClusterSubnetGroupErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SubnetAlreadyInUse" => crate::error::ModifyClusterSubnetGroupError { meta: generic, kind: crate::error::ModifyClusterSubnetGroupErrorKind::SubnetAlreadyInUse({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::subnet_already_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_already_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperation" => crate::error::ModifyClusterSubnetGroupError { meta: generic, kind: crate::error::ModifyClusterSubnetGroupErrorKind::UnauthorizedOperation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyClusterSubnetGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_cluster_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyClusterSubnetGroupOutput,
    crate::error::ModifyClusterSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_cluster_subnet_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_cluster_subnet_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyClusterSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_endpoint_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEndpointAccessOutput,
    crate::error::ModifyEndpointAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyEndpointAccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ModifyEndpointAccessError {
            meta: generic,
            kind: crate::error::ModifyEndpointAccessErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointNotFound" => crate::error::ModifyEndpointAccessError {
            meta: generic,
            kind: crate::error::ModifyEndpointAccessErrorKind::EndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSecurityGroupState" => crate::error::ModifyEndpointAccessError {
            meta: generic,
            kind:
                crate::error::ModifyEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_security_group_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidClusterState" => crate::error::ModifyEndpointAccessError {
            meta: generic,
            kind: crate::error::ModifyEndpointAccessErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointState" => crate::error::ModifyEndpointAccessError {
            meta: generic,
            kind: crate::error::ModifyEndpointAccessErrorKind::InvalidEndpointStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_endpoint_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::ModifyEndpointAccessError {
            meta: generic,
            kind: crate::error::ModifyEndpointAccessErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyEndpointAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_endpoint_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEndpointAccessOutput,
    crate::error::ModifyEndpointAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_endpoint_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_endpoint_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyEndpointAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEventSubscriptionOutput,
    crate::error::ModifyEventSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidSubscriptionStateFault" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::InvalidSubscriptionStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_subscription_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subscription_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSInvalidTopic" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_invalid_topic_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_invalid_topic_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSNoAuthorization" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_no_authorization_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_no_authorization_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSTopicArnNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::sns_topic_arn_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_topic_arn_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SourceNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::source_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_source_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionCategoryNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_category_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_category_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "SubscriptionEventIdNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_event_id_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_event_id_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "SubscriptionNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subscription_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionSeverityNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_severity_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_severity_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ModifyEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEventSubscriptionOutput,
    crate::error::ModifyEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_scheduled_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyScheduledActionOutput,
    crate::error::ModifyScheduledActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyScheduledActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyScheduledActionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidScheduledAction" => crate::error::ModifyScheduledActionError {
            meta: generic,
            kind: crate::error::ModifyScheduledActionErrorKind::InvalidScheduledActionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_scheduled_action_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_scheduled_action_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSchedule" => crate::error::ModifyScheduledActionError {
            meta: generic,
            kind: crate::error::ModifyScheduledActionErrorKind::InvalidScheduleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_schedule_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_schedule_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScheduledActionNotFound" => crate::error::ModifyScheduledActionError {
            meta: generic,
            kind: crate::error::ModifyScheduledActionErrorKind::ScheduledActionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::scheduled_action_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_scheduled_action_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ScheduledActionTypeUnsupported" => crate::error::ModifyScheduledActionError {
            meta: generic,
            kind: crate::error::ModifyScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::scheduled_action_type_unsupported_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_scheduled_action_type_unsupported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyScheduledActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "UnauthorizedOperation" => crate::error::ModifyScheduledActionError {
            meta: generic,
            kind: crate::error::ModifyScheduledActionErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyScheduledActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyScheduledActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_scheduled_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyScheduledActionOutput,
    crate::error::ModifyScheduledActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_scheduled_action_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_scheduled_action(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyScheduledActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_snapshot_copy_retention_period_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifySnapshotCopyRetentionPeriodOutput,
    crate::error::ModifySnapshotCopyRetentionPeriodError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ModifySnapshotCopyRetentionPeriodError { meta: generic, kind: crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::ClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterState" => crate::error::ModifySnapshotCopyRetentionPeriodError { meta: generic, kind: crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::InvalidClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRetentionPeriodFault" => crate::error::ModifySnapshotCopyRetentionPeriodError { meta: generic, kind: crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::InvalidRetentionPeriodFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_retention_period_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_retention_period_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotCopyDisabledFault" => crate::error::ModifySnapshotCopyRetentionPeriodError { meta: generic, kind: crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::SnapshotCopyDisabledFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_copy_disabled_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_copy_disabled_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperation" => crate::error::ModifySnapshotCopyRetentionPeriodError { meta: generic, kind: crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::UnauthorizedOperation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifySnapshotCopyRetentionPeriodError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_snapshot_copy_retention_period_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifySnapshotCopyRetentionPeriodOutput,
    crate::error::ModifySnapshotCopyRetentionPeriodError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_snapshot_copy_retention_period_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_snapshot_copy_retention_period(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotCopyRetentionPeriodError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_snapshot_schedule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifySnapshotScheduleOutput,
    crate::error::ModifySnapshotScheduleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifySnapshotScheduleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifySnapshotScheduleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidSchedule" => crate::error::ModifySnapshotScheduleError {
            meta: generic,
            kind: crate::error::ModifySnapshotScheduleErrorKind::InvalidScheduleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_schedule_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_schedule_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotScheduleNotFound" => crate::error::ModifySnapshotScheduleError {
            meta: generic,
            kind: crate::error::ModifySnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_schedule_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotScheduleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotScheduleUpdateInProgress" => crate::error::ModifySnapshotScheduleError {
            meta: generic,
            kind:
                crate::error::ModifySnapshotScheduleErrorKind::SnapshotScheduleUpdateInProgressFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::snapshot_schedule_update_in_progress_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_update_in_progress_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifySnapshotScheduleError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::ModifySnapshotScheduleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_snapshot_schedule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifySnapshotScheduleOutput,
    crate::error::ModifySnapshotScheduleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_snapshot_schedule_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_snapshot_schedule(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifySnapshotScheduleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_usage_limit_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyUsageLimitOutput, crate::error::ModifyUsageLimitError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyUsageLimitError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyUsageLimitError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidUsageLimit" => crate::error::ModifyUsageLimitError {
            meta: generic,
            kind: crate::error::ModifyUsageLimitErrorKind::InvalidUsageLimitFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_usage_limit_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_usage_limit_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::ModifyUsageLimitError {
            meta: generic,
            kind: crate::error::ModifyUsageLimitErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UsageLimitNotFound" => crate::error::ModifyUsageLimitError {
            meta: generic,
            kind: crate::error::ModifyUsageLimitErrorKind::UsageLimitNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::usage_limit_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_usage_limit_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyUsageLimitError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyUsageLimitError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_usage_limit_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyUsageLimitOutput, crate::error::ModifyUsageLimitError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_usage_limit_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_usage_limit(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyUsageLimitError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_pause_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PauseClusterOutput, crate::error::PauseClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PauseClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PauseClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::PauseClusterError {
            meta: generic,
            kind: crate::error::PauseClusterErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PauseClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::PauseClusterError {
            meta: generic,
            kind: crate::error::PauseClusterErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PauseClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PauseClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_pause_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PauseClusterOutput, crate::error::PauseClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::pause_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_pause_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PauseClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_node_offering_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedNodeOfferingOutput,
    crate::error::PurchaseReservedNodeOfferingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PurchaseReservedNodeOfferingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PurchaseReservedNodeOfferingError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ReservedNodeAlreadyExists" => crate::error::PurchaseReservedNodeOfferingError { meta: generic, kind: crate::error::PurchaseReservedNodeOfferingErrorKind::ReservedNodeAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_node_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedNodeOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedNodeOfferingNotFound" => crate::error::PurchaseReservedNodeOfferingError { meta: generic, kind: crate::error::PurchaseReservedNodeOfferingErrorKind::ReservedNodeOfferingNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_node_offering_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedNodeOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedNodeQuotaExceeded" => crate::error::PurchaseReservedNodeOfferingError { meta: generic, kind: crate::error::PurchaseReservedNodeOfferingErrorKind::ReservedNodeQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_node_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_node_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedNodeOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperation" => crate::error::PurchaseReservedNodeOfferingError { meta: generic, kind: crate::error::PurchaseReservedNodeOfferingErrorKind::UnsupportedOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedNodeOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PurchaseReservedNodeOfferingError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_node_offering_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedNodeOfferingOutput,
    crate::error::PurchaseReservedNodeOfferingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::purchase_reserved_node_offering_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_purchase_reserved_node_offering(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PurchaseReservedNodeOfferingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootClusterOutput, crate::error::RebootClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RebootClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::RebootClusterError {
            meta: generic,
            kind: crate::error::RebootClusterErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::RebootClusterError {
            meta: generic,
            kind: crate::error::RebootClusterErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebootClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootClusterOutput, crate::error::RebootClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reboot_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_data_share_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RejectDataShareOutput, crate::error::RejectDataShareError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RejectDataShareError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RejectDataShareError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidDataShareFault" => crate::error::RejectDataShareError {
            meta: generic,
            kind: crate::error::RejectDataShareErrorKind::InvalidDataShareFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_data_share_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_data_share_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RejectDataShareError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RejectDataShareError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reject_data_share_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RejectDataShareOutput, crate::error::RejectDataShareError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reject_data_share_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reject_data_share(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RejectDataShareError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetClusterParameterGroupOutput,
    crate::error::ResetClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ResetClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterParameterGroupNotFound" => crate::error::ResetClusterParameterGroupError { meta: generic, kind: crate::error::ResetClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterParameterGroupState" => crate::error::ResetClusterParameterGroupError { meta: generic, kind: crate::error::ResetClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ResetClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetClusterParameterGroupOutput,
    crate::error::ResetClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reset_cluster_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResetClusterParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resize_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResizeClusterOutput, crate::error::ResizeClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResizeClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResizeClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientClusterCapacity" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::InsufficientClusterCapacityFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededFault" => {
            crate::error::ResizeClusterError {
                meta: generic,
                kind: crate::error::ResizeClusterErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NumberOfNodesPerClusterLimitExceeded" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_per_cluster_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NumberOfNodesQuotaExceeded" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::NumberOfNodesQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::number_of_nodes_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedOperation" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::UnauthorizedOperation({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOperation" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::UnsupportedOperationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedOptionFault" => crate::error::ResizeClusterError {
            meta: generic,
            kind: crate::error::ResizeClusterErrorKind::UnsupportedOptionFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unsupported_option_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_option_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResizeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResizeClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resize_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResizeClusterOutput, crate::error::ResizeClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::resize_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_resize_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResizeClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_from_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreFromClusterSnapshotOutput,
    crate::error::RestoreFromClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RestoreFromClusterSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessToSnapshotDenied" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::AccessToSnapshotDeniedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_to_snapshot_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_to_snapshot_denied_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterAlreadyExists" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::ClusterAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterParameterGroupNotFound" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::ClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterQuotaExceeded" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::ClusterQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSecurityGroupNotFound" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::ClusterSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSnapshotNotFound" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSubnetGroupNotFoundFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::ClusterSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DependentServiceRequestThrottlingFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::DependentServiceRequestThrottlingFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::dependent_service_request_throttling_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "HsmClientCertificateNotFoundFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::HsmClientCertificateNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::hsm_client_certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_client_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "HsmConfigurationNotFoundFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::HsmConfigurationNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::hsm_configuration_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_hsm_configuration_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientClusterCapacity" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InsufficientClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSnapshotState" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSubnetGroupStateFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidClusterSubnetGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_subnet_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_subnet_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterTrack" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidClusterTrackFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_track_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_track_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidElasticIpFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidElasticIpFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_elastic_ip_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_elastic_ip_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRestore" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidRestoreFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_restore_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_restore_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTagFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidTagFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_tag_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_tag_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::LimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NumberOfNodesPerClusterLimitExceeded" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::NumberOfNodesPerClusterLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_per_cluster_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NumberOfNodesQuotaExceeded" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::NumberOfNodesQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::number_of_nodes_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_number_of_nodes_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SnapshotScheduleNotFound" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::SnapshotScheduleNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::snapshot_schedule_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_schedule_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TagLimitExceededFault" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::TagLimitExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::tag_limit_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_tag_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthorizedOperation" => crate::error::RestoreFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreFromClusterSnapshotErrorKind::UnauthorizedOperation({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthorized_operation::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unauthorized_operation_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreFromClusterSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_from_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreFromClusterSnapshotOutput,
    crate::error::RestoreFromClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_from_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_restore_from_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestoreFromClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_table_from_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreTableFromClusterSnapshotOutput,
    crate::error::RestoreTableFromClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreTableFromClusterSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::RestoreTableFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreTableFromClusterSnapshotErrorKind::ClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSnapshotNotFound" => crate::error::RestoreTableFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreTableFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InProgressTableRestoreQuotaExceededFault" => crate::error::RestoreTableFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreTableFromClusterSnapshotErrorKind::InProgressTableRestoreQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::in_progress_table_restore_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_in_progress_table_restore_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSnapshotState" => crate::error::RestoreTableFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreTableFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterState" => crate::error::RestoreTableFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreTableFromClusterSnapshotErrorKind::InvalidClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidTableRestoreArgument" => crate::error::RestoreTableFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreTableFromClusterSnapshotErrorKind::InvalidTableRestoreArgumentFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_table_restore_argument_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_table_restore_argument_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnsupportedOperation" => crate::error::RestoreTableFromClusterSnapshotError { meta: generic, kind: crate::error::RestoreTableFromClusterSnapshotErrorKind::UnsupportedOperationFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unsupported_operation_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unsupported_operation_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreTableFromClusterSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_table_from_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreTableFromClusterSnapshotOutput,
    crate::error::RestoreTableFromClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::restore_table_from_cluster_snapshot_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_restore_table_from_cluster_snapshot(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RestoreTableFromClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resume_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResumeClusterOutput, crate::error::ResumeClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResumeClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResumeClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::ResumeClusterError {
            meta: generic,
            kind: crate::error::ResumeClusterErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResumeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientClusterCapacity" => crate::error::ResumeClusterError {
            meta: generic,
            kind: crate::error::ResumeClusterErrorKind::InsufficientClusterCapacityFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResumeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterState" => crate::error::ResumeClusterError {
            meta: generic,
            kind: crate::error::ResumeClusterErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResumeClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResumeClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resume_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResumeClusterOutput, crate::error::ResumeClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::resume_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_resume_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResumeClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_cluster_security_group_ingress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeClusterSecurityGroupIngressOutput,
    crate::error::RevokeClusterSecurityGroupIngressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeClusterSecurityGroupIngressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RevokeClusterSecurityGroupIngressError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::RevokeClusterSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeClusterSecurityGroupIngressErrorKind::AuthorizationNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeClusterSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ClusterSecurityGroupNotFound" => crate::error::RevokeClusterSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::cluster_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeClusterSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidClusterSecurityGroupState" => crate::error::RevokeClusterSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeClusterSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RevokeClusterSecurityGroupIngressError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_cluster_security_group_ingress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeClusterSecurityGroupIngressOutput,
    crate::error::RevokeClusterSecurityGroupIngressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::revoke_cluster_security_group_ingress_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_revoke_cluster_security_group_ingress(response.body().as_ref(), output).map_err(crate::error::RevokeClusterSecurityGroupIngressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_endpoint_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeEndpointAccessOutput,
    crate::error::RevokeEndpointAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RevokeEndpointAccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::RevokeEndpointAccessError {
            meta: generic,
            kind: crate::error::RevokeEndpointAccessErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EndpointAuthorizationNotFound" => {
            crate::error::RevokeEndpointAccessError {
                meta: generic,
                kind:
                    crate::error::RevokeEndpointAccessErrorKind::EndpointAuthorizationNotFoundFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::endpoint_authorization_not_found_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_endpoint_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "EndpointNotFound" => crate::error::RevokeEndpointAccessError {
            meta: generic,
            kind: crate::error::RevokeEndpointAccessErrorKind::EndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidAuthorizationState" => crate::error::RevokeEndpointAccessError {
            meta: generic,
            kind: crate::error::RevokeEndpointAccessErrorKind::InvalidAuthorizationStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_authorization_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authorization_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidClusterSecurityGroupState" => crate::error::RevokeEndpointAccessError {
            meta: generic,
            kind:
                crate::error::RevokeEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_cluster_security_group_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidClusterState" => crate::error::RevokeEndpointAccessError {
            meta: generic,
            kind: crate::error::RevokeEndpointAccessErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidEndpointState" => crate::error::RevokeEndpointAccessError {
            meta: generic,
            kind: crate::error::RevokeEndpointAccessErrorKind::InvalidEndpointStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_endpoint_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_endpoint_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RevokeEndpointAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_endpoint_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeEndpointAccessOutput,
    crate::error::RevokeEndpointAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::revoke_endpoint_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_revoke_endpoint_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RevokeEndpointAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_snapshot_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeSnapshotAccessOutput,
    crate::error::RevokeSnapshotAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeSnapshotAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RevokeSnapshotAccessError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessToSnapshotDenied" => crate::error::RevokeSnapshotAccessError {
            meta: generic,
            kind: crate::error::RevokeSnapshotAccessErrorKind::AccessToSnapshotDeniedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::access_to_snapshot_denied_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_access_to_snapshot_denied_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeSnapshotAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AuthorizationNotFound" => crate::error::RevokeSnapshotAccessError {
            meta: generic,
            kind: crate::error::RevokeSnapshotAccessErrorKind::AuthorizationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeSnapshotAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ClusterSnapshotNotFound" => crate::error::RevokeSnapshotAccessError {
            meta: generic,
            kind: crate::error::RevokeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeSnapshotAccessError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RevokeSnapshotAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_snapshot_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeSnapshotAccessOutput,
    crate::error::RevokeSnapshotAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::revoke_snapshot_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_revoke_snapshot_access(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RevokeSnapshotAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rotate_encryption_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RotateEncryptionKeyOutput,
    crate::error::RotateEncryptionKeyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RotateEncryptionKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RotateEncryptionKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::RotateEncryptionKeyError {
            meta: generic,
            kind: crate::error::RotateEncryptionKeyErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RotateEncryptionKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependentServiceRequestThrottlingFault" => crate::error::RotateEncryptionKeyError {
            meta: generic,
            kind:
                crate::error::RotateEncryptionKeyErrorKind::DependentServiceRequestThrottlingFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::dependent_service_request_throttling_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_dependent_service_request_throttling_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RotateEncryptionKeyError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidClusterState" => crate::error::RotateEncryptionKeyError {
            meta: generic,
            kind: crate::error::RotateEncryptionKeyErrorKind::InvalidClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RotateEncryptionKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RotateEncryptionKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_rotate_encryption_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RotateEncryptionKeyOutput,
    crate::error::RotateEncryptionKeyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::rotate_encryption_key_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_rotate_encryption_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RotateEncryptionKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_partner_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePartnerStatusOutput,
    crate::error::UpdatePartnerStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdatePartnerStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdatePartnerStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ClusterNotFound" => crate::error::UpdatePartnerStatusError {
            meta: generic,
            kind: crate::error::UpdatePartnerStatusErrorKind::ClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdatePartnerStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PartnerNotFound" => crate::error::UpdatePartnerStatusError {
            meta: generic,
            kind: crate::error::UpdatePartnerStatusErrorKind::PartnerNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::partner_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_partner_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdatePartnerStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnauthorizedPartnerIntegration" => {
            crate::error::UpdatePartnerStatusError {
                meta: generic,
                kind:
                    crate::error::UpdatePartnerStatusErrorKind::UnauthorizedPartnerIntegrationFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::unauthorized_partner_integration_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_unauthorized_partner_integration_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdatePartnerStatusError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::UpdatePartnerStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_partner_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdatePartnerStatusOutput,
    crate::error::UpdatePartnerStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_partner_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_partner_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdatePartnerStatusError::unhandled)?;
        output.build()
    })
}
