// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptReservedNodeExchangeInput`](crate::input::AcceptReservedNodeExchangeInput)
pub mod accept_reserved_node_exchange_input {
    /// A builder for [`AcceptReservedNodeExchangeInput`](crate::input::AcceptReservedNodeExchangeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_id: std::option::Option<std::string::String>,
        pub(crate) target_reserved_node_offering_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string representing the node identifier of the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_id = Some(input.into());
            self
        }
        /// <p>A string representing the node identifier of the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_id = input;
            self
        }
        /// <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange.
        /// You can obtain the value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
        /// </p>
        pub fn target_reserved_node_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_reserved_node_offering_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange.
        /// You can obtain the value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
        /// </p>
        pub fn set_target_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_reserved_node_offering_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptReservedNodeExchangeInput`](crate::input::AcceptReservedNodeExchangeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptReservedNodeExchangeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptReservedNodeExchangeInput {
                reserved_node_id: self.reserved_node_id,
                target_reserved_node_offering_id: self.target_reserved_node_offering_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptReservedNodeExchangeInputOperationOutputAlias =
    crate::operation::AcceptReservedNodeExchange;
#[doc(hidden)]
pub type AcceptReservedNodeExchangeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptReservedNodeExchangeInput {
    /// Consumes the builder and constructs an Operation<[`AcceptReservedNodeExchange`](crate::operation::AcceptReservedNodeExchange)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptReservedNodeExchange,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptReservedNodeExchangeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptReservedNodeExchangeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptReservedNodeExchangeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_reserved_node_exchange(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptReservedNodeExchange::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptReservedNodeExchange",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptReservedNodeExchangeInput`](crate::input::AcceptReservedNodeExchangeInput)
    pub fn builder() -> crate::input::accept_reserved_node_exchange_input::Builder {
        crate::input::accept_reserved_node_exchange_input::Builder::default()
    }
}

/// See [`AddPartnerInput`](crate::input::AddPartnerInput)
pub mod add_partner_input {
    /// A builder for [`AddPartnerInput`](crate::input::AddPartnerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddPartnerInput`](crate::input::AddPartnerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddPartnerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddPartnerInput {
                account_id: self.account_id,
                cluster_identifier: self.cluster_identifier,
                database_name: self.database_name,
                partner_name: self.partner_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddPartnerInputOperationOutputAlias = crate::operation::AddPartner;
#[doc(hidden)]
pub type AddPartnerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddPartnerInput {
    /// Consumes the builder and constructs an Operation<[`AddPartner`](crate::operation::AddPartner)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddPartner,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddPartnerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddPartnerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddPartnerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_partner(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddPartner::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddPartner",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddPartnerInput`](crate::input::AddPartnerInput)
    pub fn builder() -> crate::input::add_partner_input::Builder {
        crate::input::add_partner_input::Builder::default()
    }
}

/// See [`AssociateDataShareConsumerInput`](crate::input::AssociateDataShareConsumerInput)
pub mod associate_data_share_consumer_input {
    /// A builder for [`AssociateDataShareConsumerInput`](crate::input::AssociateDataShareConsumerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) associate_entire_account: std::option::Option<bool>,
        pub(crate) consumer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>A value that specifies whether the datashare is associated with the entire account.</p>
        pub fn associate_entire_account(mut self, input: bool) -> Self {
            self.associate_entire_account = Some(input);
            self
        }
        /// <p>A value that specifies whether the datashare is associated with the entire account.</p>
        pub fn set_associate_entire_account(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_entire_account = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that is associated with the
        /// datashare.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that is associated with the
        /// datashare.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.consumer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDataShareConsumerInput`](crate::input::AssociateDataShareConsumerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDataShareConsumerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDataShareConsumerInput {
                data_share_arn: self.data_share_arn,
                associate_entire_account: self.associate_entire_account,
                consumer_arn: self.consumer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDataShareConsumerInputOperationOutputAlias =
    crate::operation::AssociateDataShareConsumer;
#[doc(hidden)]
pub type AssociateDataShareConsumerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateDataShareConsumerInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDataShareConsumer`](crate::operation::AssociateDataShareConsumer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDataShareConsumer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateDataShareConsumerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateDataShareConsumerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateDataShareConsumerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_data_share_consumer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDataShareConsumer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDataShareConsumer",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateDataShareConsumerInput`](crate::input::AssociateDataShareConsumerInput)
    pub fn builder() -> crate::input::associate_data_share_consumer_input::Builder {
        crate::input::associate_data_share_consumer_input::Builder::default()
    }
}

/// See [`AuthorizeClusterSecurityGroupIngressInput`](crate::input::AuthorizeClusterSecurityGroupIngressInput)
pub mod authorize_cluster_security_group_ingress_input {
    /// A builder for [`AuthorizeClusterSecurityGroupIngressInput`](crate::input::AuthorizeClusterSecurityGroupIngressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group_name: std::option::Option<std::string::String>,
        pub(crate) cidrip: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the security group to which the ingress rule is added.</p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the security group to which the ingress rule is added.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = input;
            self
        }
        /// <p>The IP range to be added the Amazon Redshift security group.</p>
        pub fn cidrip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidrip = Some(input.into());
            self
        }
        /// <p>The IP range to be added the Amazon Redshift security group.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidrip = input;
            self
        }
        /// <p>The EC2 security group to be added the Amazon Redshift security group.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_name = Some(input.into());
            self
        }
        /// <p>The EC2 security group to be added the Amazon Redshift security group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_name = input;
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified by the
        /// <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an
        /// acceptable value. </p>
        /// <p>Example: <code>111122223333</code>
        /// </p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified by the
        /// <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an
        /// acceptable value. </p>
        /// <p>Example: <code>111122223333</code>
        /// </p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeClusterSecurityGroupIngressInput`](crate::input::AuthorizeClusterSecurityGroupIngressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeClusterSecurityGroupIngressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeClusterSecurityGroupIngressInput {
                cluster_security_group_name: self.cluster_security_group_name,
                cidrip: self.cidrip,
                ec2_security_group_name: self.ec2_security_group_name,
                ec2_security_group_owner_id: self.ec2_security_group_owner_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeClusterSecurityGroupIngressInputOperationOutputAlias =
    crate::operation::AuthorizeClusterSecurityGroupIngress;
#[doc(hidden)]
pub type AuthorizeClusterSecurityGroupIngressInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl AuthorizeClusterSecurityGroupIngressInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeClusterSecurityGroupIngress`](crate::operation::AuthorizeClusterSecurityGroupIngress)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeClusterSecurityGroupIngress,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AuthorizeClusterSecurityGroupIngressInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AuthorizeClusterSecurityGroupIngressInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AuthorizeClusterSecurityGroupIngressInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_authorize_cluster_security_group_ingress(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeClusterSecurityGroupIngress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeClusterSecurityGroupIngress",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeClusterSecurityGroupIngressInput`](crate::input::AuthorizeClusterSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_cluster_security_group_ingress_input::Builder {
        crate::input::authorize_cluster_security_group_ingress_input::Builder::default()
    }
}

/// See [`AuthorizeDataShareInput`](crate::input::AuthorizeDataShareInput)
pub mod authorize_data_share_input {
    /// A builder for [`AuthorizeDataShareInput`](crate::input::AuthorizeDataShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) consumer_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize
        /// sharing for.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize
        /// sharing for.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID.</p>
        pub fn consumer_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID.</p>
        pub fn set_consumer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.consumer_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeDataShareInput`](crate::input::AuthorizeDataShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeDataShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeDataShareInput {
                data_share_arn: self.data_share_arn,
                consumer_identifier: self.consumer_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeDataShareInputOperationOutputAlias = crate::operation::AuthorizeDataShare;
#[doc(hidden)]
pub type AuthorizeDataShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AuthorizeDataShareInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeDataShare`](crate::operation::AuthorizeDataShare)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeDataShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AuthorizeDataShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AuthorizeDataShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AuthorizeDataShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_authorize_data_share(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeDataShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeDataShare",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeDataShareInput`](crate::input::AuthorizeDataShareInput)
    pub fn builder() -> crate::input::authorize_data_share_input::Builder {
        crate::input::authorize_data_share_input::Builder::default()
    }
}

/// See [`AuthorizeEndpointAccessInput`](crate::input::AuthorizeEndpointAccessInput)
pub mod authorize_endpoint_access_input {
    /// A builder for [`AuthorizeEndpointAccessInput`](crate::input::AuthorizeEndpointAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) vpc_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The cluster identifier of the cluster to grant access to.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster to grant access to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account ID to grant access to.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID to grant access to.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// Appends an item to `vpc_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_ids`](Self::set_vpc_ids).
        ///
        /// <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
        pub fn vpc_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_ids = Some(v);
            self
        }
        /// <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
        pub fn set_vpc_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeEndpointAccessInput`](crate::input::AuthorizeEndpointAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeEndpointAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeEndpointAccessInput {
                cluster_identifier: self.cluster_identifier,
                account: self.account,
                vpc_ids: self.vpc_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeEndpointAccessInputOperationOutputAlias =
    crate::operation::AuthorizeEndpointAccess;
#[doc(hidden)]
pub type AuthorizeEndpointAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AuthorizeEndpointAccessInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeEndpointAccess`](crate::operation::AuthorizeEndpointAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeEndpointAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AuthorizeEndpointAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AuthorizeEndpointAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AuthorizeEndpointAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_authorize_endpoint_access(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeEndpointAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeEndpointAccess",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeEndpointAccessInput`](crate::input::AuthorizeEndpointAccessInput)
    pub fn builder() -> crate::input::authorize_endpoint_access_input::Builder {
        crate::input::authorize_endpoint_access_input::Builder::default()
    }
}

/// See [`AuthorizeSnapshotAccessInput`](crate::input::AuthorizeSnapshotAccessInput)
pub mod authorize_snapshot_access_input {
    /// A builder for [`AuthorizeSnapshotAccessInput`](crate::input::AuthorizeSnapshotAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) account_with_restore_access: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot the account is authorized to restore.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot the account is authorized to restore.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = input;
            self
        }
        /// <p>The identifier of the Amazon Web Services account authorized to restore the specified
        /// snapshot.</p>
        /// <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>
        pub fn account_with_restore_access(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.account_with_restore_access = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account authorized to restore the specified
        /// snapshot.</p>
        /// <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>
        pub fn set_account_with_restore_access(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_with_restore_access = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeSnapshotAccessInput`](crate::input::AuthorizeSnapshotAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeSnapshotAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeSnapshotAccessInput {
                snapshot_identifier: self.snapshot_identifier,
                snapshot_cluster_identifier: self.snapshot_cluster_identifier,
                account_with_restore_access: self.account_with_restore_access,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeSnapshotAccessInputOperationOutputAlias =
    crate::operation::AuthorizeSnapshotAccess;
#[doc(hidden)]
pub type AuthorizeSnapshotAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AuthorizeSnapshotAccessInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeSnapshotAccess`](crate::operation::AuthorizeSnapshotAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeSnapshotAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AuthorizeSnapshotAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AuthorizeSnapshotAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AuthorizeSnapshotAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_authorize_snapshot_access(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeSnapshotAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeSnapshotAccess",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeSnapshotAccessInput`](crate::input::AuthorizeSnapshotAccessInput)
    pub fn builder() -> crate::input::authorize_snapshot_access_input::Builder {
        crate::input::authorize_snapshot_access_input::Builder::default()
    }
}

/// See [`BatchDeleteClusterSnapshotsInput`](crate::input::BatchDeleteClusterSnapshotsInput)
pub mod batch_delete_cluster_snapshots_input {
    /// A builder for [`BatchDeleteClusterSnapshotsInput`](crate::input::BatchDeleteClusterSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifiers:
            std::option::Option<std::vec::Vec<crate::model::DeleteClusterSnapshotMessage>>,
    }
    impl Builder {
        /// Appends an item to `identifiers`.
        ///
        /// To override the contents of this collection use [`set_identifiers`](Self::set_identifiers).
        ///
        /// <p>A list of identifiers for the snapshots that you want to delete.</p>
        pub fn identifiers(
            mut self,
            input: impl Into<crate::model::DeleteClusterSnapshotMessage>,
        ) -> Self {
            let mut v = self.identifiers.unwrap_or_default();
            v.push(input.into());
            self.identifiers = Some(v);
            self
        }
        /// <p>A list of identifiers for the snapshots that you want to delete.</p>
        pub fn set_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteClusterSnapshotMessage>>,
        ) -> Self {
            self.identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteClusterSnapshotsInput`](crate::input::BatchDeleteClusterSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteClusterSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteClusterSnapshotsInput {
                identifiers: self.identifiers,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteClusterSnapshotsInputOperationOutputAlias =
    crate::operation::BatchDeleteClusterSnapshots;
#[doc(hidden)]
pub type BatchDeleteClusterSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDeleteClusterSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteClusterSnapshots`](crate::operation::BatchDeleteClusterSnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteClusterSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteClusterSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteClusterSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteClusterSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_cluster_snapshots(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteClusterSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteClusterSnapshots",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteClusterSnapshotsInput`](crate::input::BatchDeleteClusterSnapshotsInput)
    pub fn builder() -> crate::input::batch_delete_cluster_snapshots_input::Builder {
        crate::input::batch_delete_cluster_snapshots_input::Builder::default()
    }
}

/// See [`BatchModifyClusterSnapshotsInput`](crate::input::BatchModifyClusterSnapshotsInput)
pub mod batch_modify_cluster_snapshots_input {
    /// A builder for [`BatchModifyClusterSnapshotsInput`](crate::input::BatchModifyClusterSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `snapshot_identifier_list`.
        ///
        /// To override the contents of this collection use [`set_snapshot_identifier_list`](Self::set_snapshot_identifier_list).
        ///
        /// <p>A list of snapshot identifiers you want to modify.</p>
        pub fn snapshot_identifier_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.snapshot_identifier_list.unwrap_or_default();
            v.push(input.into());
            self.snapshot_identifier_list = Some(v);
            self
        }
        /// <p>A list of snapshot identifiers you want to modify.</p>
        pub fn set_snapshot_identifier_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.snapshot_identifier_list = input;
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If you specify the value -1,
        /// the manual snapshot is retained indefinitely.</p>
        /// <p>The number must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>If you decrease the manual snapshot retention period from its current value, existing
        /// manual snapshots that fall outside of the new retention period will return an error. If
        /// you want to suppress the errors and delete the snapshots, use the force option. </p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If you specify the value -1,
        /// the manual snapshot is retained indefinitely.</p>
        /// <p>The number must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>If you decrease the manual snapshot retention period from its current value, existing
        /// manual snapshots that fall outside of the new retention period will return an error. If
        /// you want to suppress the errors and delete the snapshots, use the force option. </p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// <p>A boolean value indicating whether to override an exception if the retention period
        /// has passed. </p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>A boolean value indicating whether to override an exception if the retention period
        /// has passed. </p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchModifyClusterSnapshotsInput`](crate::input::BatchModifyClusterSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchModifyClusterSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchModifyClusterSnapshotsInput {
                snapshot_identifier_list: self.snapshot_identifier_list,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type BatchModifyClusterSnapshotsInputOperationOutputAlias =
    crate::operation::BatchModifyClusterSnapshots;
#[doc(hidden)]
pub type BatchModifyClusterSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchModifyClusterSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`BatchModifyClusterSnapshots`](crate::operation::BatchModifyClusterSnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchModifyClusterSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchModifyClusterSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchModifyClusterSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchModifyClusterSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_modify_cluster_snapshots(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchModifyClusterSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchModifyClusterSnapshots",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchModifyClusterSnapshotsInput`](crate::input::BatchModifyClusterSnapshotsInput)
    pub fn builder() -> crate::input::batch_modify_cluster_snapshots_input::Builder {
        crate::input::batch_modify_cluster_snapshots_input::Builder::default()
    }
}

/// See [`CancelResizeInput`](crate::input::CancelResizeInput)
pub mod cancel_resize_input {
    /// A builder for [`CancelResizeInput`](crate::input::CancelResizeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the cluster that you want to cancel a resize operation
        /// for.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cluster that you want to cancel a resize operation
        /// for.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelResizeInput`](crate::input::CancelResizeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelResizeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelResizeInput {
                cluster_identifier: self.cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelResizeInputOperationOutputAlias = crate::operation::CancelResize;
#[doc(hidden)]
pub type CancelResizeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelResizeInput {
    /// Consumes the builder and constructs an Operation<[`CancelResize`](crate::operation::CancelResize)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelResize,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelResizeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelResizeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelResizeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_cancel_resize(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelResize::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelResize",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelResizeInput`](crate::input::CancelResizeInput)
    pub fn builder() -> crate::input::cancel_resize_input::Builder {
        crate::input::cancel_resize_input::Builder::default()
    }
}

/// See [`CopyClusterSnapshotInput`](crate::input::CopyClusterSnapshotInput)
pub mod copy_cluster_snapshot_input {
    /// A builder for [`CopyClusterSnapshotInput`](crate::input::CopyClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) source_snapshot_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) target_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the source snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid automated snapshot whose state is
        /// <code>available</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the source snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid automated snapshot whose state is
        /// <code>available</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the cluster the source snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid cluster.</p>
        /// </li>
        /// </ul>
        pub fn source_snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_snapshot_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster the source snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_source_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_cluster_identifier = input;
            self
        }
        /// <p>The identifier given to the new manual snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for the Amazon Web Services account that is making the request.</p>
        /// </li>
        /// </ul>
        pub fn target_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier given to the new manual snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for the Amazon Web Services account that is making the request.</p>
        /// </li>
        /// </ul>
        pub fn set_target_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_snapshot_identifier = input;
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyClusterSnapshotInput`](crate::input::CopyClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyClusterSnapshotInput {
                source_snapshot_identifier: self.source_snapshot_identifier,
                source_snapshot_cluster_identifier: self.source_snapshot_cluster_identifier,
                target_snapshot_identifier: self.target_snapshot_identifier,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyClusterSnapshotInputOperationOutputAlias = crate::operation::CopyClusterSnapshot;
#[doc(hidden)]
pub type CopyClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopyClusterSnapshot`](crate::operation::CopyClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_cluster_snapshot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyClusterSnapshot",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyClusterSnapshotInput`](crate::input::CopyClusterSnapshotInput)
    pub fn builder() -> crate::input::copy_cluster_snapshot_input::Builder {
        crate::input::copy_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CreateAuthenticationProfileInput`](crate::input::CreateAuthenticationProfileInput)
pub mod create_authentication_profile_input {
    /// A builder for [`CreateAuthenticationProfileInput`](crate::input::CreateAuthenticationProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
        pub(crate) authentication_profile_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile to be created.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile to be created.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// <p>The content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn authentication_profile_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = Some(input.into());
            self
        }
        /// <p>The content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuthenticationProfileInput`](crate::input::CreateAuthenticationProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAuthenticationProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAuthenticationProfileInput {
                authentication_profile_name: self.authentication_profile_name,
                authentication_profile_content: self.authentication_profile_content,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAuthenticationProfileInputOperationOutputAlias =
    crate::operation::CreateAuthenticationProfile;
#[doc(hidden)]
pub type CreateAuthenticationProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAuthenticationProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateAuthenticationProfile`](crate::operation::CreateAuthenticationProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAuthenticationProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAuthenticationProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAuthenticationProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAuthenticationProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_authentication_profile(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAuthenticationProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAuthenticationProfile",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAuthenticationProfileInput`](crate::input::CreateAuthenticationProfileInput)
    pub fn builder() -> crate::input::create_authentication_profile_input::Builder {
        crate::input::create_authentication_profile_input::Builder::default()
    }
}

/// See [`CreateClusterInput`](crate::input::CreateClusterInput)
pub mod create_cluster_input {
    /// A builder for [`CreateClusterInput`](crate::input::CreateClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) cluster_type: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) cluster_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cluster_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) automated_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) allow_version_upgrade: std::option::Option<bool>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) hsm_client_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) hsm_configuration_identifier: std::option::Option<std::string::String>,
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enhanced_vpc_routing: std::option::Option<bool>,
        pub(crate) additional_info: std::option::Option<std::string::String>,
        pub(crate) iam_roles: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) snapshot_schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) availability_zone_relocation: std::option::Option<bool>,
        pub(crate) aqua_configuration_status:
            std::option::Option<crate::model::AquaConfigurationStatus>,
    }
    impl Builder {
        /// <p>The name of the first database to be created when the cluster is created.</p>
        /// <p>To create additional databases after the cluster is created, connect to the cluster
        /// with a SQL client and use SQL commands to create a database. For more information, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create
        /// a Database</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Default: <code>dev</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a word that is reserved by the service. A list of reserved words
        /// can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the
        /// Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>The name of the first database to be created when the cluster is created.</p>
        /// <p>To create additional databases after the cluster is created, connect to the cluster
        /// with a SQL client and use SQL commands to create a database. For more information, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create
        /// a Database</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Default: <code>dev</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a word that is reserved by the service. A list of reserved words
        /// can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the
        /// Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>A unique identifier for the cluster. You use this identifier to refer to the
        /// cluster for any subsequent cluster operations such as deleting or modifying. The
        /// identifier also appears in the Amazon Redshift console.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>myexamplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the cluster. You use this identifier to refer to the
        /// cluster for any subsequent cluster operations such as deleting or modifying. The
        /// identifier also appears in the Amazon Redshift console.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>myexamplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The type of the cluster. When cluster type is specified as</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>single-node</code>, the <b>NumberOfNodes</b>
        /// parameter is not required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>multi-node</code>, the <b>NumberOfNodes</b>
        /// parameter is required.</p>
        /// </li>
        /// </ul>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code>
        /// </p>
        /// <p>Default: <code>multi-node</code>
        /// </p>
        pub fn cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_type = Some(input.into());
            self
        }
        /// <p>The type of the cluster. When cluster type is specified as</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>single-node</code>, the <b>NumberOfNodes</b>
        /// parameter is not required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>multi-node</code>, the <b>NumberOfNodes</b>
        /// parameter is required.</p>
        /// </li>
        /// </ul>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code>
        /// </p>
        /// <p>Default: <code>multi-node</code>
        /// </p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_type = input;
            self
        }
        /// <p>The node type to be provisioned for the cluster. For information about node types,
        /// go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type to be provisioned for the cluster. For information about node types,
        /// go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The user name associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 - 128 alphanumeric characters. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        ///
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved
        /// Words</a> in the Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The user name associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 - 128 alphanumeric characters. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        ///
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved
        /// Words</a> in the Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The password associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The password associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// Appends an item to `cluster_security_groups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        pub fn cluster_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cluster_security_groups.unwrap_or_default();
            v.push(input.into());
            self.cluster_security_groups = Some(v);
            self
        }
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cluster_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the
        /// cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the
        /// cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>The name of a cluster subnet group to be associated with this cluster.</p>
        /// <p>If this parameter is not provided the resulting cluster will be deployed outside
        /// virtual private cloud (VPC).</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of a cluster subnet group to be associated with this cluster.</p>
        /// <p>If this parameter is not provided the resulting cluster will be deployed outside
        /// virtual private cloud (VPC).</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_subnet_group_name = input;
            self
        }
        /// <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the
        /// cluster. For example, if you have several EC2 instances running in a specific
        /// Availability Zone, then you might want the cluster to be provisioned in the same zone in
        /// order to decrease network latency.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the region that is specified
        /// by the endpoint.</p>
        /// <p>Example: <code>us-east-2d</code>
        /// </p>
        /// <p>Constraint: The specified Availability Zone must be in the same region as the
        /// current endpoint.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the
        /// cluster. For example, if you have several EC2 instances running in a specific
        /// Availability Zone, then you might want the cluster to be provisioned in the same zone in
        /// order to decrease network latency.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the region that is specified
        /// by the endpoint.</p>
        /// <p>Example: <code>us-east-2d</code>
        /// </p>
        /// <p>Constraint: The specified Availability Zone must be in the same region as the
        /// current endpoint.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can
        /// occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p> Default: A 30-minute window selected at random from an 8-hour block of time per
        /// region, occurring on a random day of the week. For more information about the time
        /// blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can
        /// occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p> Default: A 30-minute window selected at random from an 8-hour block of time per
        /// region, occurring on a random day of the week. For more information about the time
        /// blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the
        /// default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
        /// Redshift Parameter Groups</a>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the
        /// default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
        /// Redshift Parameter Groups</a>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_name = input;
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn automated_snapshot_retention_period(mut self, input: i32) -> Self {
            self.automated_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automated_snapshot_retention_period = input;
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the
        /// snapshot is retained indefinitely. This setting doesn't change the retention period
        /// of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the
        /// snapshot is retained indefinitely. This setting doesn't change the retention period
        /// of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        /// <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of
        /// the connection string requires the port on which the cluster will listen for incoming
        /// connections.</p>
        /// <p>Default: <code>5439</code>
        /// </p>
        /// <p>Valid Values: <code>1150-65535</code>
        /// </p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        /// <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of
        /// the connection string requires the port on which the cluster will listen for incoming
        /// connections.</p>
        /// <p>Default: <code>5439</code>
        /// </p>
        /// <p>Valid Values: <code>1150-65535</code>
        /// </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The version of the Amazon Redshift engine software that you want to deploy on the
        /// cluster.</p>
        /// <p>The version selected runs on all the nodes in the cluster.</p>
        /// <p>Constraints: Only version 1.0 is currently available.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The version of the Amazon Redshift engine software that you want to deploy on the
        /// cluster.</p>
        /// <p>The version selected runs on all the nodes in the cluster.</p>
        /// <p>Constraints: Only version 1.0 is currently available.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance
        /// window to the Amazon Redshift engine that is running on the cluster.</p>
        /// <p>When a new major version of the Amazon Redshift engine is released, you can request that
        /// the service automatically apply upgrades during the maintenance window to the Amazon Redshift
        /// engine that is running on your cluster.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn allow_version_upgrade(mut self, input: bool) -> Self {
            self.allow_version_upgrade = Some(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance
        /// window to the Amazon Redshift engine that is running on the cluster.</p>
        /// <p>When a new major version of the Amazon Redshift engine is released, you can request that
        /// the service automatically apply upgrades during the maintenance window to the Amazon Redshift
        /// engine that is running on your cluster.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_version_upgrade = input;
            self
        }
        /// <p>The number of compute nodes in the cluster. This parameter is required when the
        /// <b>ClusterType</b> parameter is specified as
        /// <code>multi-node</code>. </p>
        /// <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>If you don't specify this parameter, you get a single-node cluster. When requesting
        /// a multi-node cluster, you must specify the number of nodes that you want in the
        /// cluster.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Value must be at least 1 and no more than 100.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The number of compute nodes in the cluster. This parameter is required when the
        /// <b>ClusterType</b> parameter is specified as
        /// <code>multi-node</code>. </p>
        /// <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>If you don't specify this parameter, you get a single-node cluster. When requesting
        /// a multi-node cluster, you must specify the number of nodes that you want in the
        /// cluster.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Value must be at least 1 and no more than 100.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p>
        /// <p>Default: false</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p>
        /// <p>Default: false</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = input;
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = input;
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to
        /// use to encrypt data in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to
        /// use to encrypt data in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, input: bool) -> Self {
            self.enhanced_vpc_routing = Some(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.enhanced_vpc_routing = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn additional_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_info = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_info = input;
            self
        }
        /// Appends an item to `iam_roles`.
        ///
        /// To override the contents of this collection use [`set_iam_roles`](Self::set_iam_roles).
        ///
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the
        /// cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
        /// Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
        /// request.</p>
        /// <p>A cluster can have up to 10 IAM roles associated with it at any time.</p>
        pub fn iam_roles(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.iam_roles.unwrap_or_default();
            v.push(input.into());
            self.iam_roles = Some(v);
            self
        }
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the
        /// cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
        /// Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
        /// request.</p>
        /// <p>A cluster can have up to 10 IAM roles associated with it at any time.</p>
        pub fn set_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.iam_roles = input;
            self
        }
        /// <p>An optional parameter for the name of the maintenance track for the cluster. If you
        /// don't provide a maintenance track name, the cluster is assigned to the
        /// <code>current</code> track.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>An optional parameter for the name of the maintenance track for the cluster. If you
        /// don't provide a maintenance track name, the cluster is assigned to the
        /// <code>current</code> track.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn snapshot_schedule_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.snapshot_schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn set_snapshot_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_schedule_identifier = input;
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
        pub fn availability_zone_relocation(mut self, input: bool) -> Self {
            self.availability_zone_relocation = Some(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
        pub fn set_availability_zone_relocation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.availability_zone_relocation = input;
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            input: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.aqua_configuration_status = Some(input);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.aqua_configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterInput`](crate::input::CreateClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterInput {
                db_name: self.db_name,
                cluster_identifier: self.cluster_identifier,
                cluster_type: self.cluster_type,
                node_type: self.node_type,
                master_username: self.master_username,
                master_user_password: self.master_user_password,
                cluster_security_groups: self.cluster_security_groups,
                vpc_security_group_ids: self.vpc_security_group_ids,
                cluster_subnet_group_name: self.cluster_subnet_group_name,
                availability_zone: self.availability_zone,
                preferred_maintenance_window: self.preferred_maintenance_window,
                cluster_parameter_group_name: self.cluster_parameter_group_name,
                automated_snapshot_retention_period: self.automated_snapshot_retention_period,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
                port: self.port,
                cluster_version: self.cluster_version,
                allow_version_upgrade: self.allow_version_upgrade,
                number_of_nodes: self.number_of_nodes,
                publicly_accessible: self.publicly_accessible,
                encrypted: self.encrypted,
                hsm_client_certificate_identifier: self.hsm_client_certificate_identifier,
                hsm_configuration_identifier: self.hsm_configuration_identifier,
                elastic_ip: self.elastic_ip,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                enhanced_vpc_routing: self.enhanced_vpc_routing,
                additional_info: self.additional_info,
                iam_roles: self.iam_roles,
                maintenance_track_name: self.maintenance_track_name,
                snapshot_schedule_identifier: self.snapshot_schedule_identifier,
                availability_zone_relocation: self.availability_zone_relocation,
                aqua_configuration_status: self.aqua_configuration_status,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterInputOperationOutputAlias = crate::operation::CreateCluster;
#[doc(hidden)]
pub type CreateClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateCluster`](crate::operation::CreateCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCluster",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterInput`](crate::input::CreateClusterInput)
    pub fn builder() -> crate::input::create_cluster_input::Builder {
        crate::input::create_cluster_input::Builder::default()
    }
}

/// See [`CreateClusterParameterGroupInput`](crate::input::CreateClusterParameterGroupInput)
pub mod create_cluster_parameter_group_input {
    /// A builder for [`CreateClusterParameterGroupInput`](crate::input::CreateClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique withing your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lower-case string.</p>
        /// </note>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique withing your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lower-case string.</p>
        /// </note>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The Amazon Redshift engine version to which the cluster parameter group applies. The
        /// cluster engine version determines the set of parameters.</p>
        /// <p>To get a list of valid parameter group family names, you can call <a>DescribeClusterParameterGroups</a>. By default, Amazon Redshift returns a list of
        /// all the parameter groups that are owned by your Amazon Web Services account, including the default
        /// parameter groups for each Amazon Redshift engine version. The parameter group family names
        /// associated with the default parameter groups provide you the valid values. For example,
        /// a valid family name is "redshift-1.0". </p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_family = Some(input.into());
            self
        }
        /// <p>The Amazon Redshift engine version to which the cluster parameter group applies. The
        /// cluster engine version determines the set of parameters.</p>
        /// <p>To get a list of valid parameter group family names, you can call <a>DescribeClusterParameterGroups</a>. By default, Amazon Redshift returns a list of
        /// all the parameter groups that are owned by your Amazon Web Services account, including the default
        /// parameter groups for each Amazon Redshift engine version. The parameter group family names
        /// associated with the default parameter groups provide you the valid values. For example,
        /// a valid family name is "redshift-1.0". </p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_family = input;
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterParameterGroupInput`](crate::input::CreateClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
                parameter_group_family: self.parameter_group_family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterParameterGroupInputOperationOutputAlias =
    crate::operation::CreateClusterParameterGroup;
#[doc(hidden)]
pub type CreateClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateClusterParameterGroup`](crate::operation::CreateClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateClusterParameterGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterParameterGroupInput`](crate::input::CreateClusterParameterGroupInput)
    pub fn builder() -> crate::input::create_cluster_parameter_group_input::Builder {
        crate::input::create_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`CreateClusterSecurityGroupInput`](crate::input::CreateClusterSecurityGroupInput)
pub mod create_cluster_security_group_input {
    /// A builder for [`CreateClusterSecurityGroupInput`](crate::input::CreateClusterSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the security group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesecuritygroup</code>
        /// </p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = Some(input.into());
            self
        }
        /// <p>The name for the security group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesecuritygroup</code>
        /// </p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = input;
            self
        }
        /// <p>A description for the security group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the security group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterSecurityGroupInput`](crate::input::CreateClusterSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterSecurityGroupInput {
                cluster_security_group_name: self.cluster_security_group_name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterSecurityGroupInputOperationOutputAlias =
    crate::operation::CreateClusterSecurityGroup;
#[doc(hidden)]
pub type CreateClusterSecurityGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateClusterSecurityGroup`](crate::operation::CreateClusterSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateClusterSecurityGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_cluster_security_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateClusterSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateClusterSecurityGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterSecurityGroupInput`](crate::input::CreateClusterSecurityGroupInput)
    pub fn builder() -> crate::input::create_cluster_security_group_input::Builder {
        crate::input::create_cluster_security_group_input::Builder::default()
    }
}

/// See [`CreateClusterSnapshotInput`](crate::input::CreateClusterSnapshotInput)
pub mod create_cluster_snapshot_input {
    /// A builder for [`CreateClusterSnapshotInput`](crate::input::CreateClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A unique identifier for the snapshot that you are requesting. This identifier must
        /// be unique for all snapshots within the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot that you are requesting. This identifier must
        /// be unique for all snapshots within the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The cluster identifier for which you want a snapshot.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier for which you want a snapshot.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        ///
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        ///
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        ///
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        ///
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterSnapshotInput`](crate::input::CreateClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterSnapshotInput {
                snapshot_identifier: self.snapshot_identifier,
                cluster_identifier: self.cluster_identifier,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterSnapshotInputOperationOutputAlias = crate::operation::CreateClusterSnapshot;
#[doc(hidden)]
pub type CreateClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateClusterSnapshot`](crate::operation::CreateClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_cluster_snapshot(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateClusterSnapshot",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterSnapshotInput`](crate::input::CreateClusterSnapshotInput)
    pub fn builder() -> crate::input::create_cluster_snapshot_input::Builder {
        crate::input::create_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CreateClusterSubnetGroupInput`](crate::input::CreateClusterSubnetGroupInput)
pub mod create_cluster_subnet_group_input {
    /// A builder for [`CreateClusterSubnetGroupInput`](crate::input::CreateClusterSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesubnetgroup</code>
        /// </p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesubnetgroup</code>
        /// </p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_subnet_group_name = input;
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterSubnetGroupInput`](crate::input::CreateClusterSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClusterSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClusterSubnetGroupInput {
                cluster_subnet_group_name: self.cluster_subnet_group_name,
                description: self.description,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClusterSubnetGroupInputOperationOutputAlias =
    crate::operation::CreateClusterSubnetGroup;
#[doc(hidden)]
pub type CreateClusterSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClusterSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateClusterSubnetGroup`](crate::operation::CreateClusterSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateClusterSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClusterSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClusterSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClusterSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_cluster_subnet_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateClusterSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateClusterSubnetGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClusterSubnetGroupInput`](crate::input::CreateClusterSubnetGroupInput)
    pub fn builder() -> crate::input::create_cluster_subnet_group_input::Builder {
        crate::input::create_cluster_subnet_group_input::Builder::default()
    }
}

/// See [`CreateEndpointAccessInput`](crate::input::CreateEndpointAccessInput)
pub mod create_endpoint_access_input {
    /// A builder for [`CreateEndpointAccessInput`](crate::input::CreateEndpointAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The Redshift-managed VPC endpoint name.</p>
        /// <p>An endpoint name must contain 1-30 characters.
        /// Valid characters are A-Z, a-z, 0-9, and hyphen(-).
        /// The first character must be a letter.
        /// The name can't contain two consecutive hyphens or end with a hyphen.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The Redshift-managed VPC endpoint name.</p>
        /// <p>An endpoint name must contain 1-30 characters.
        /// Valid characters are A-Z, a-z, 0-9, and hyphen(-).
        /// The first character must be a letter.
        /// The name can't contain two consecutive hyphens or end with a hyphen.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointAccessInput`](crate::input::CreateEndpointAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEndpointAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEndpointAccessInput {
                cluster_identifier: self.cluster_identifier,
                resource_owner: self.resource_owner,
                endpoint_name: self.endpoint_name,
                subnet_group_name: self.subnet_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEndpointAccessInputOperationOutputAlias = crate::operation::CreateEndpointAccess;
#[doc(hidden)]
pub type CreateEndpointAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEndpointAccessInput {
    /// Consumes the builder and constructs an Operation<[`CreateEndpointAccess`](crate::operation::CreateEndpointAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEndpointAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEndpointAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEndpointAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEndpointAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_endpoint_access(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEndpointAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEndpointAccess",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEndpointAccessInput`](crate::input::CreateEndpointAccessInput)
    pub fn builder() -> crate::input::create_endpoint_access_input::Builder {
        crate::input::create_endpoint_access_input::Builder::default()
    }
}

/// See [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
pub mod create_event_subscription_input {
    /// A builder for [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) severity: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the event subscription to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the event subscription to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event
        /// notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to
        /// it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event
        /// notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to
        /// it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to
        /// be notified of events generated by a cluster, you would set this parameter to cluster.
        /// If this value is not specified, events are returned for all Amazon Redshift objects in your
        /// Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to
        /// be notified of events generated by a cluster, you would set this parameter to cluster.
        /// If this value is not specified, events are returned for all Amazon Redshift objects in your
        /// Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `source_ids`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects
        /// must be of the same type as was specified in the source type parameter. The event
        /// subscription will return only events generated by the specified objects. If not
        /// specified, then events are returned for all objects within the source type
        /// specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids.unwrap_or_default();
            v.push(input.into());
            self.source_ids = Some(v);
            self
        }
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects
        /// must be of the same type as was specified in the source type parameter. The event
        /// subscription will return only events generated by the specified objects. If not
        /// specified, then events are returned for all objects within the source type
        /// specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification
        /// subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification
        /// subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification
        /// subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification
        /// subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.severity = input;
            self
        }
        /// <p>A boolean value; set to <code>true</code> to activate the subscription, and set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A boolean value; set to <code>true</code> to activate the subscription, and set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                source_ids: self.source_ids,
                event_categories: self.event_categories,
                severity: self.severity,
                enabled: self.enabled,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationOutputAlias =
    crate::operation::CreateEventSubscription;
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventSubscription`](crate::operation::CreateEventSubscription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_event_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventSubscription",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
}

/// See [`CreateHsmClientCertificateInput`](crate::input::CreateHsmClientCertificateInput)
pub mod create_hsm_client_certificate_input {
    /// A builder for [`CreateHsmClientCertificateInput`](crate::input::CreateHsmClientCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_client_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier to be assigned to the new HSM client certificate that the cluster
        /// will use to connect to the HSM to use the database encryption keys.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier to be assigned to the new HSM client certificate that the cluster
        /// will use to connect to the HSM to use the database encryption keys.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHsmClientCertificateInput`](crate::input::CreateHsmClientCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHsmClientCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHsmClientCertificateInput {
                hsm_client_certificate_identifier: self.hsm_client_certificate_identifier,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHsmClientCertificateInputOperationOutputAlias =
    crate::operation::CreateHsmClientCertificate;
#[doc(hidden)]
pub type CreateHsmClientCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHsmClientCertificateInput {
    /// Consumes the builder and constructs an Operation<[`CreateHsmClientCertificate`](crate::operation::CreateHsmClientCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHsmClientCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHsmClientCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHsmClientCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHsmClientCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_hsm_client_certificate(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHsmClientCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHsmClientCertificate",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHsmClientCertificateInput`](crate::input::CreateHsmClientCertificateInput)
    pub fn builder() -> crate::input::create_hsm_client_certificate_input::Builder {
        crate::input::create_hsm_client_certificate_input::Builder::default()
    }
}

/// See [`CreateHsmConfigurationInput`](crate::input::CreateHsmConfigurationInput)
pub mod create_hsm_configuration_input {
    /// A builder for [`CreateHsmConfigurationInput`](crate::input::CreateHsmConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_configuration_identifier: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) hsm_ip_address: std::option::Option<std::string::String>,
        pub(crate) hsm_partition_name: std::option::Option<std::string::String>,
        pub(crate) hsm_partition_password: std::option::Option<std::string::String>,
        pub(crate) hsm_server_public_certificate: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = Some(input.into());
            self
        }
        /// <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = input;
            self
        }
        /// <p>A text description of the HSM configuration to be created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A text description of the HSM configuration to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn hsm_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_ip_address = Some(input.into());
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn set_hsm_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_ip_address = input;
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their
        /// database encryption keys.</p>
        pub fn hsm_partition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_partition_name = Some(input.into());
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their
        /// database encryption keys.</p>
        pub fn set_hsm_partition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_partition_name = input;
            self
        }
        /// <p>The password required to access the HSM partition.</p>
        pub fn hsm_partition_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_partition_password = Some(input.into());
            self
        }
        /// <p>The password required to access the HSM partition.</p>
        pub fn set_hsm_partition_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_partition_password = input;
            self
        }
        /// <p>The HSMs public certificate file. When using Cloud HSM, the file name is
        /// server.pem.</p>
        pub fn hsm_server_public_certificate(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_server_public_certificate = Some(input.into());
            self
        }
        /// <p>The HSMs public certificate file. When using Cloud HSM, the file name is
        /// server.pem.</p>
        pub fn set_hsm_server_public_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_server_public_certificate = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHsmConfigurationInput`](crate::input::CreateHsmConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHsmConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHsmConfigurationInput {
                hsm_configuration_identifier: self.hsm_configuration_identifier,
                description: self.description,
                hsm_ip_address: self.hsm_ip_address,
                hsm_partition_name: self.hsm_partition_name,
                hsm_partition_password: self.hsm_partition_password,
                hsm_server_public_certificate: self.hsm_server_public_certificate,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHsmConfigurationInputOperationOutputAlias = crate::operation::CreateHsmConfiguration;
#[doc(hidden)]
pub type CreateHsmConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHsmConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateHsmConfiguration`](crate::operation::CreateHsmConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHsmConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHsmConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHsmConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHsmConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_hsm_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHsmConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHsmConfiguration",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHsmConfigurationInput`](crate::input::CreateHsmConfigurationInput)
    pub fn builder() -> crate::input::create_hsm_configuration_input::Builder {
        crate::input::create_hsm_configuration_input::Builder::default()
    }
}

/// See [`CreateScheduledActionInput`](crate::input::CreateScheduledActionInput)
pub mod create_scheduled_action_input {
    /// A builder for [`CreateScheduledActionInput`](crate::input::CreateScheduledActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) target_action: std::option::Option<crate::model::ScheduledActionType>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_description: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) enable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the scheduled action. The name must be unique within an account.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action. The name must be unique within an account.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn target_action(mut self, input: crate::model::ScheduledActionType) -> Self {
            self.target_action = Some(input);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionType>,
        ) -> Self {
            self.target_action = input;
            self
        }
        /// <p>The schedule in <code>at( )</code> or <code>cron( )</code> format.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule in <code>at( )</code> or <code>cron( )</code> format.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The IAM role to assume to run the target action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role to assume to run the target action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// <p>The description of the scheduled action.
        /// </p>
        pub fn scheduled_action_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = Some(input.into());
            self
        }
        /// <p>The description of the scheduled action.
        /// </p>
        pub fn set_scheduled_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = input;
            self
        }
        /// <p>The start time in UTC of the scheduled action.
        /// Before this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time in UTC of the scheduled action.
        /// Before this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>If true, the schedule is enabled. If false, the scheduled action does not trigger.
        /// For more information about <code>state</code> of the scheduled action, see <a>ScheduledAction</a>. </p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p>If true, the schedule is enabled. If false, the scheduled action does not trigger.
        /// For more information about <code>state</code> of the scheduled action, see <a>ScheduledAction</a>. </p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScheduledActionInput`](crate::input::CreateScheduledActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateScheduledActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateScheduledActionInput {
                scheduled_action_name: self.scheduled_action_name,
                target_action: self.target_action,
                schedule: self.schedule,
                iam_role: self.iam_role,
                scheduled_action_description: self.scheduled_action_description,
                start_time: self.start_time,
                end_time: self.end_time,
                enable: self.enable,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateScheduledActionInputOperationOutputAlias = crate::operation::CreateScheduledAction;
#[doc(hidden)]
pub type CreateScheduledActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateScheduledActionInput {
    /// Consumes the builder and constructs an Operation<[`CreateScheduledAction`](crate::operation::CreateScheduledAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateScheduledAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateScheduledActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateScheduledActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateScheduledActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_scheduled_action(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateScheduledAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateScheduledAction",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateScheduledActionInput`](crate::input::CreateScheduledActionInput)
    pub fn builder() -> crate::input::create_scheduled_action_input::Builder {
        crate::input::create_scheduled_action_input::Builder::default()
    }
}

/// See [`CreateSnapshotCopyGrantInput`](crate::input::CreateSnapshotCopyGrantInput)
pub mod create_snapshot_copy_grant_input {
    /// A builder for [`CreateSnapshotCopyGrantInput`](crate::input::CreateSnapshotCopyGrantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_copy_grant_name: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the snapshot copy grant. This name must be unique in the region for the
        /// Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_copy_grant_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant. This name must be unique in the region for the
        /// Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_copy_grant_name = input;
            self
        }
        /// <p>The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift
        /// permission. If no key is specified, the default key is used.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift
        /// permission. If no key is specified, the default key is used.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotCopyGrantInput`](crate::input::CreateSnapshotCopyGrantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotCopyGrantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotCopyGrantInput {
                snapshot_copy_grant_name: self.snapshot_copy_grant_name,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotCopyGrantInputOperationOutputAlias =
    crate::operation::CreateSnapshotCopyGrant;
#[doc(hidden)]
pub type CreateSnapshotCopyGrantInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSnapshotCopyGrantInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshotCopyGrant`](crate::operation::CreateSnapshotCopyGrant)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshotCopyGrant,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSnapshotCopyGrantInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSnapshotCopyGrantInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSnapshotCopyGrantInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot_copy_grant(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshotCopyGrant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshotCopyGrant",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotCopyGrantInput`](crate::input::CreateSnapshotCopyGrantInput)
    pub fn builder() -> crate::input::create_snapshot_copy_grant_input::Builder {
        crate::input::create_snapshot_copy_grant_input::Builder::default()
    }
}

/// See [`CreateSnapshotScheduleInput`](crate::input::CreateSnapshotScheduleInput)
pub mod create_snapshot_schedule_input {
    /// A builder for [`CreateSnapshotScheduleInput`](crate::input::CreateSnapshotScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_definitions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) schedule_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) next_invocations: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `schedule_definitions`.
        ///
        /// To override the contents of this collection use [`set_schedule_definitions`](Self::set_schedule_definitions).
        ///
        /// <p>The definition of the snapshot schedule. The definition is made up of schedule
        /// expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
        pub fn schedule_definitions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schedule_definitions.unwrap_or_default();
            v.push(input.into());
            self.schedule_definitions = Some(v);
            self
        }
        /// <p>The definition of the snapshot schedule. The definition is made up of schedule
        /// expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
        pub fn set_schedule_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schedule_definitions = input;
            self
        }
        /// <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed
        /// for the identifier.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed
        /// for the identifier.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_identifier = input;
            self
        }
        /// <p>The description of the snapshot schedule.</p>
        pub fn schedule_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_description = Some(input.into());
            self
        }
        /// <p>The description of the snapshot schedule.</p>
        pub fn set_schedule_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of tags you can use to search for the schedule.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An optional set of tags you can use to search for the schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p></p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p></p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p></p>
        pub fn next_invocations(mut self, input: i32) -> Self {
            self.next_invocations = Some(input);
            self
        }
        /// <p></p>
        pub fn set_next_invocations(mut self, input: std::option::Option<i32>) -> Self {
            self.next_invocations = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotScheduleInput`](crate::input::CreateSnapshotScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSnapshotScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSnapshotScheduleInput {
                schedule_definitions: self.schedule_definitions,
                schedule_identifier: self.schedule_identifier,
                schedule_description: self.schedule_description,
                tags: self.tags,
                dry_run: self.dry_run,
                next_invocations: self.next_invocations,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSnapshotScheduleInputOperationOutputAlias = crate::operation::CreateSnapshotSchedule;
#[doc(hidden)]
pub type CreateSnapshotScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSnapshotScheduleInput {
    /// Consumes the builder and constructs an Operation<[`CreateSnapshotSchedule`](crate::operation::CreateSnapshotSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSnapshotSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSnapshotScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSnapshotScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSnapshotScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_snapshot_schedule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSnapshotSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSnapshotSchedule",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSnapshotScheduleInput`](crate::input::CreateSnapshotScheduleInput)
    pub fn builder() -> crate::input::create_snapshot_schedule_input::Builder {
        crate::input::create_snapshot_schedule_input::Builder::default()
    }
}

/// See [`CreateTagsInput`](crate::input::CreateTagsInput)
pub mod create_tags_input {
    /// A builder for [`CreateTagsInput`](crate::input::CreateTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more name/value pairs to add as tags to the specified resource. Each tag
        /// name is passed in with the parameter <code>Key</code> and the corresponding value is
        /// passed in with the parameter <code>Value</code>. The <code>Key</code> and
        /// <code>Value</code> parameters are separated by a comma (,). Separate multiple tags
        /// with a space. For example, <code>--tags "Key"="owner","Value"="admin"
        /// "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more name/value pairs to add as tags to the specified resource. Each tag
        /// name is passed in with the parameter <code>Key</code> and the corresponding value is
        /// passed in with the parameter <code>Value</code>. The <code>Key</code> and
        /// <code>Value</code> parameters are separated by a comma (,). Separate multiple tags
        /// with a space. For example, <code>--tags "Key"="owner","Value"="admin"
        /// "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTagsInput`](crate::input::CreateTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTagsInput {
                resource_name: self.resource_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTagsInputOperationOutputAlias = crate::operation::CreateTags;
#[doc(hidden)]
pub type CreateTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateTags`](crate::operation::CreateTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTags",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
}

/// See [`CreateUsageLimitInput`](crate::input::CreateUsageLimitInput)
pub mod create_usage_limit_input {
    /// A builder for [`CreateUsageLimitInput`](crate::input::CreateUsageLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
        pub(crate) limit_type: std::option::Option<crate::model::UsageLimitLimitType>,
        pub(crate) amount: std::option::Option<i64>,
        pub(crate) period: std::option::Option<crate::model::UsageLimitPeriod>,
        pub(crate) breach_action: std::option::Option<crate::model::UsageLimitBreachAction>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the cluster that you want to limit usage.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster that you want to limit usage.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Redshift feature that you want to limit.</p>
        pub fn feature_type(mut self, input: crate::model::UsageLimitFeatureType) -> Self {
            self.feature_type = Some(input);
            self
        }
        /// <p>The Amazon Redshift feature that you want to limit.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.feature_type = input;
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.
        /// If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>.
        /// If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>.
        /// </p>
        pub fn limit_type(mut self, input: crate::model::UsageLimitLimitType) -> Self {
            self.limit_type = Some(input);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.
        /// If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>.
        /// If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>.
        /// </p>
        pub fn set_limit_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitLimitType>,
        ) -> Self {
            self.limit_type = input;
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
        /// The value must be a positive number.
        /// </p>
        pub fn amount(mut self, input: i64) -> Self {
            self.amount = Some(input);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
        /// The value must be a positive number.
        /// </p>
        pub fn set_amount(mut self, input: std::option::Option<i64>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>.
        /// </p>
        pub fn period(mut self, input: crate::model::UsageLimitPeriod) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>.
        /// </p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::UsageLimitPeriod>,
        ) -> Self {
            self.period = input;
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. The default is log.
        /// For more information about this parameter, see <a>UsageLimit</a>.</p>
        pub fn breach_action(mut self, input: crate::model::UsageLimitBreachAction) -> Self {
            self.breach_action = Some(input);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. The default is log.
        /// For more information about this parameter, see <a>UsageLimit</a>.</p>
        pub fn set_breach_action(
            mut self,
            input: std::option::Option<crate::model::UsageLimitBreachAction>,
        ) -> Self {
            self.breach_action = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUsageLimitInput`](crate::input::CreateUsageLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUsageLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUsageLimitInput {
                cluster_identifier: self.cluster_identifier,
                feature_type: self.feature_type,
                limit_type: self.limit_type,
                amount: self.amount.unwrap_or_default(),
                period: self.period,
                breach_action: self.breach_action,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUsageLimitInputOperationOutputAlias = crate::operation::CreateUsageLimit;
#[doc(hidden)]
pub type CreateUsageLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUsageLimitInput {
    /// Consumes the builder and constructs an Operation<[`CreateUsageLimit`](crate::operation::CreateUsageLimit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUsageLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUsageLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUsageLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUsageLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_usage_limit(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUsageLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUsageLimit",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUsageLimitInput`](crate::input::CreateUsageLimitInput)
    pub fn builder() -> crate::input::create_usage_limit_input::Builder {
        crate::input::create_usage_limit_input::Builder::default()
    }
}

/// See [`DeauthorizeDataShareInput`](crate::input::DeauthorizeDataShareInput)
pub mod deauthorize_data_share_input {
    /// A builder for [`DeauthorizeDataShareInput`](crate::input::DeauthorizeDataShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) consumer_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The identifier of the data consumer that is to have authorization removed from the datashare.
        /// This identifier is an AWS account ID.</p>
        pub fn consumer_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the data consumer that is to have authorization removed from the datashare.
        /// This identifier is an AWS account ID.</p>
        pub fn set_consumer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.consumer_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeauthorizeDataShareInput`](crate::input::DeauthorizeDataShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeauthorizeDataShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeauthorizeDataShareInput {
                data_share_arn: self.data_share_arn,
                consumer_identifier: self.consumer_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeauthorizeDataShareInputOperationOutputAlias = crate::operation::DeauthorizeDataShare;
#[doc(hidden)]
pub type DeauthorizeDataShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeauthorizeDataShareInput {
    /// Consumes the builder and constructs an Operation<[`DeauthorizeDataShare`](crate::operation::DeauthorizeDataShare)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeauthorizeDataShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeauthorizeDataShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeauthorizeDataShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeauthorizeDataShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deauthorize_data_share(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeauthorizeDataShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeauthorizeDataShare",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeauthorizeDataShareInput`](crate::input::DeauthorizeDataShareInput)
    pub fn builder() -> crate::input::deauthorize_data_share_input::Builder {
        crate::input::deauthorize_data_share_input::Builder::default()
    }
}

/// See [`DeleteAuthenticationProfileInput`](crate::input::DeleteAuthenticationProfileInput)
pub mod delete_authentication_profile_input {
    /// A builder for [`DeleteAuthenticationProfileInput`](crate::input::DeleteAuthenticationProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile to delete.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile to delete.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAuthenticationProfileInput`](crate::input::DeleteAuthenticationProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAuthenticationProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAuthenticationProfileInput {
                authentication_profile_name: self.authentication_profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAuthenticationProfileInputOperationOutputAlias =
    crate::operation::DeleteAuthenticationProfile;
#[doc(hidden)]
pub type DeleteAuthenticationProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAuthenticationProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAuthenticationProfile`](crate::operation::DeleteAuthenticationProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAuthenticationProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAuthenticationProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAuthenticationProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAuthenticationProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_authentication_profile(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAuthenticationProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAuthenticationProfile",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAuthenticationProfileInput`](crate::input::DeleteAuthenticationProfileInput)
    pub fn builder() -> crate::input::delete_authentication_profile_input::Builder {
        crate::input::delete_authentication_profile_input::Builder::default()
    }
}

/// See [`DeleteClusterInput`](crate::input::DeleteClusterInput)
pub mod delete_cluster_input {
    /// A builder for [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) skip_final_cluster_snapshot: std::option::Option<bool>,
        pub(crate) final_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) final_cluster_snapshot_retention_period: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the cluster to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain lowercase characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain lowercase characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift
        /// deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If
        /// <code>false</code>, a final cluster snapshot is created before the cluster is
        /// deleted. </p>
        /// <note>
        /// <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be
        /// specified if <i>SkipFinalClusterSnapshot</i> is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_cluster_snapshot(mut self, input: bool) -> Self {
            self.skip_final_cluster_snapshot = Some(input);
            self
        }
        /// <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift
        /// deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If
        /// <code>false</code>, a final cluster snapshot is created before the cluster is
        /// deleted. </p>
        /// <note>
        /// <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be
        /// specified if <i>SkipFinalClusterSnapshot</i> is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_cluster_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_cluster_snapshot = input;
            self
        }
        /// <p>The identifier of the final snapshot that is to be created immediately before
        /// deleting the cluster. If this parameter is provided,
        /// <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn final_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.final_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the final snapshot that is to be created immediately before
        /// deleting the cluster. If this parameter is provided,
        /// <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_final_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn final_cluster_snapshot_retention_period(mut self, input: i32) -> Self {
            self.final_cluster_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_final_cluster_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.final_cluster_snapshot_retention_period = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterInput`](crate::input::DeleteClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterInput {
                cluster_identifier: self.cluster_identifier,
                skip_final_cluster_snapshot: self.skip_final_cluster_snapshot.unwrap_or_default(),
                final_cluster_snapshot_identifier: self.final_cluster_snapshot_identifier,
                final_cluster_snapshot_retention_period: self
                    .final_cluster_snapshot_retention_period,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterInputOperationOutputAlias = crate::operation::DeleteCluster;
#[doc(hidden)]
pub type DeleteClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCluster`](crate::operation::DeleteCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCluster",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterInput`](crate::input::DeleteClusterInput)
    pub fn builder() -> crate::input::delete_cluster_input::Builder {
        crate::input::delete_cluster_input::Builder::default()
    }
}

/// See [`DeleteClusterParameterGroupInput`](crate::input::DeleteClusterParameterGroupInput)
pub mod delete_cluster_parameter_group_input {
    /// A builder for [`DeleteClusterParameterGroupInput`](crate::input::DeleteClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter group to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot delete a default cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot delete a default cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterParameterGroupInput`](crate::input::DeleteClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterParameterGroupInputOperationOutputAlias =
    crate::operation::DeleteClusterParameterGroup;
#[doc(hidden)]
pub type DeleteClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteClusterParameterGroup`](crate::operation::DeleteClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteClusterParameterGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterParameterGroupInput`](crate::input::DeleteClusterParameterGroupInput)
    pub fn builder() -> crate::input::delete_cluster_parameter_group_input::Builder {
        crate::input::delete_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteClusterSecurityGroupInput`](crate::input::DeleteClusterSecurityGroupInput)
pub mod delete_cluster_security_group_input {
    /// A builder for [`DeleteClusterSecurityGroupInput`](crate::input::DeleteClusterSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster security group to be deleted.</p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster security group to be deleted.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterSecurityGroupInput`](crate::input::DeleteClusterSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterSecurityGroupInput {
                cluster_security_group_name: self.cluster_security_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterSecurityGroupInputOperationOutputAlias =
    crate::operation::DeleteClusterSecurityGroup;
#[doc(hidden)]
pub type DeleteClusterSecurityGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteClusterSecurityGroup`](crate::operation::DeleteClusterSecurityGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteClusterSecurityGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterSecurityGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterSecurityGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterSecurityGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_cluster_security_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteClusterSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteClusterSecurityGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterSecurityGroupInput`](crate::input::DeleteClusterSecurityGroupInput)
    pub fn builder() -> crate::input::delete_cluster_security_group_input::Builder {
        crate::input::delete_cluster_security_group_input::Builder::default()
    }
}

/// See [`DeleteClusterSnapshotInput`](crate::input::DeleteClusterSnapshotInput)
pub mod delete_cluster_snapshot_input {
    /// A builder for [`DeleteClusterSnapshotInput`](crate::input::DeleteClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the
        /// <code>available</code>, <code>failed</code>, or <code>cancelled</code>
        /// state.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the
        /// <code>available</code>, <code>failed</code>, or <code>cancelled</code>
        /// state.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterSnapshotInput`](crate::input::DeleteClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterSnapshotInput {
                snapshot_identifier: self.snapshot_identifier,
                snapshot_cluster_identifier: self.snapshot_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterSnapshotInputOperationOutputAlias = crate::operation::DeleteClusterSnapshot;
#[doc(hidden)]
pub type DeleteClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteClusterSnapshot`](crate::operation::DeleteClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_cluster_snapshot(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteClusterSnapshot",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterSnapshotInput`](crate::input::DeleteClusterSnapshotInput)
    pub fn builder() -> crate::input::delete_cluster_snapshot_input::Builder {
        crate::input::delete_cluster_snapshot_input::Builder::default()
    }
}

/// See [`DeleteClusterSubnetGroupInput`](crate::input::DeleteClusterSubnetGroupInput)
pub mod delete_cluster_subnet_group_input {
    /// A builder for [`DeleteClusterSubnetGroupInput`](crate::input::DeleteClusterSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_subnet_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster subnet group name to be deleted.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster subnet group name to be deleted.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_subnet_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterSubnetGroupInput`](crate::input::DeleteClusterSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteClusterSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteClusterSubnetGroupInput {
                cluster_subnet_group_name: self.cluster_subnet_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteClusterSubnetGroupInputOperationOutputAlias =
    crate::operation::DeleteClusterSubnetGroup;
#[doc(hidden)]
pub type DeleteClusterSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteClusterSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteClusterSubnetGroup`](crate::operation::DeleteClusterSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteClusterSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteClusterSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteClusterSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteClusterSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_cluster_subnet_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteClusterSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteClusterSubnetGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteClusterSubnetGroupInput`](crate::input::DeleteClusterSubnetGroupInput)
    pub fn builder() -> crate::input::delete_cluster_subnet_group_input::Builder {
        crate::input::delete_cluster_subnet_group_input::Builder::default()
    }
}

/// See [`DeleteEndpointAccessInput`](crate::input::DeleteEndpointAccessInput)
pub mod delete_endpoint_access_input {
    /// A builder for [`DeleteEndpointAccessInput`](crate::input::DeleteEndpointAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Redshift-managed VPC endpoint to delete.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The Redshift-managed VPC endpoint to delete.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointAccessInput`](crate::input::DeleteEndpointAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointAccessInput {
                endpoint_name: self.endpoint_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointAccessInputOperationOutputAlias = crate::operation::DeleteEndpointAccess;
#[doc(hidden)]
pub type DeleteEndpointAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEndpointAccessInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpointAccess`](crate::operation::DeleteEndpointAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpointAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEndpointAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEndpointAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEndpointAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_endpoint_access(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpointAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpointAccess",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointAccessInput`](crate::input::DeleteEndpointAccessInput)
    pub fn builder() -> crate::input::delete_endpoint_access_input::Builder {
        crate::input::delete_endpoint_access_input::Builder::default()
    }
}

/// See [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
pub mod delete_event_subscription_input {
    /// A builder for [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventSubscriptionInput {
                subscription_name: self.subscription_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteEventSubscription;
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventSubscription`](crate::operation::DeleteEventSubscription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_event_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventSubscription",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
}

/// See [`DeleteHsmClientCertificateInput`](crate::input::DeleteHsmClientCertificateInput)
pub mod delete_hsm_client_certificate_input {
    /// A builder for [`DeleteHsmClientCertificateInput`](crate::input::DeleteHsmClientCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_client_certificate_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the HSM client certificate to be deleted.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the HSM client certificate to be deleted.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHsmClientCertificateInput`](crate::input::DeleteHsmClientCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHsmClientCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHsmClientCertificateInput {
                hsm_client_certificate_identifier: self.hsm_client_certificate_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHsmClientCertificateInputOperationOutputAlias =
    crate::operation::DeleteHsmClientCertificate;
#[doc(hidden)]
pub type DeleteHsmClientCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHsmClientCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHsmClientCertificate`](crate::operation::DeleteHsmClientCertificate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHsmClientCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHsmClientCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHsmClientCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHsmClientCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_hsm_client_certificate(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHsmClientCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHsmClientCertificate",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHsmClientCertificateInput`](crate::input::DeleteHsmClientCertificateInput)
    pub fn builder() -> crate::input::delete_hsm_client_certificate_input::Builder {
        crate::input::delete_hsm_client_certificate_input::Builder::default()
    }
}

/// See [`DeleteHsmConfigurationInput`](crate::input::DeleteHsmConfigurationInput)
pub mod delete_hsm_configuration_input {
    /// A builder for [`DeleteHsmConfigurationInput`](crate::input::DeleteHsmConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_configuration_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHsmConfigurationInput`](crate::input::DeleteHsmConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHsmConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHsmConfigurationInput {
                hsm_configuration_identifier: self.hsm_configuration_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHsmConfigurationInputOperationOutputAlias = crate::operation::DeleteHsmConfiguration;
#[doc(hidden)]
pub type DeleteHsmConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHsmConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHsmConfiguration`](crate::operation::DeleteHsmConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHsmConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHsmConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHsmConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHsmConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_hsm_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHsmConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHsmConfiguration",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHsmConfigurationInput`](crate::input::DeleteHsmConfigurationInput)
    pub fn builder() -> crate::input::delete_hsm_configuration_input::Builder {
        crate::input::delete_hsm_configuration_input::Builder::default()
    }
}

/// See [`DeletePartnerInput`](crate::input::DeletePartnerInput)
pub mod delete_partner_input {
    /// A builder for [`DeletePartnerInput`](crate::input::DeletePartnerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePartnerInput`](crate::input::DeletePartnerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePartnerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePartnerInput {
                account_id: self.account_id,
                cluster_identifier: self.cluster_identifier,
                database_name: self.database_name,
                partner_name: self.partner_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePartnerInputOperationOutputAlias = crate::operation::DeletePartner;
#[doc(hidden)]
pub type DeletePartnerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePartnerInput {
    /// Consumes the builder and constructs an Operation<[`DeletePartner`](crate::operation::DeletePartner)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePartner,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePartnerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePartnerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePartnerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_partner(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePartner::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePartner",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePartnerInput`](crate::input::DeletePartnerInput)
    pub fn builder() -> crate::input::delete_partner_input::Builder {
        crate::input::delete_partner_input::Builder::default()
    }
}

/// See [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
pub mod delete_scheduled_action_input {
    /// A builder for [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scheduled action to delete. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action to delete. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScheduledActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScheduledActionInput {
                scheduled_action_name: self.scheduled_action_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteScheduledActionInputOperationOutputAlias = crate::operation::DeleteScheduledAction;
#[doc(hidden)]
pub type DeleteScheduledActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteScheduledActionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteScheduledAction`](crate::operation::DeleteScheduledAction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteScheduledAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteScheduledActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteScheduledActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteScheduledActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_scheduled_action(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteScheduledAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteScheduledAction",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
    pub fn builder() -> crate::input::delete_scheduled_action_input::Builder {
        crate::input::delete_scheduled_action_input::Builder::default()
    }
}

/// See [`DeleteSnapshotCopyGrantInput`](crate::input::DeleteSnapshotCopyGrantInput)
pub mod delete_snapshot_copy_grant_input {
    /// A builder for [`DeleteSnapshotCopyGrantInput`](crate::input::DeleteSnapshotCopyGrantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_copy_grant_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the snapshot copy grant to delete.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_copy_grant_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant to delete.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_copy_grant_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotCopyGrantInput`](crate::input::DeleteSnapshotCopyGrantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSnapshotCopyGrantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSnapshotCopyGrantInput {
                snapshot_copy_grant_name: self.snapshot_copy_grant_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSnapshotCopyGrantInputOperationOutputAlias =
    crate::operation::DeleteSnapshotCopyGrant;
#[doc(hidden)]
pub type DeleteSnapshotCopyGrantInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSnapshotCopyGrantInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSnapshotCopyGrant`](crate::operation::DeleteSnapshotCopyGrant)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSnapshotCopyGrant,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSnapshotCopyGrantInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSnapshotCopyGrantInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSnapshotCopyGrantInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_snapshot_copy_grant(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSnapshotCopyGrant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSnapshotCopyGrant",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotCopyGrantInput`](crate::input::DeleteSnapshotCopyGrantInput)
    pub fn builder() -> crate::input::delete_snapshot_copy_grant_input::Builder {
        crate::input::delete_snapshot_copy_grant_input::Builder::default()
    }
}

/// See [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
pub mod delete_snapshot_schedule_input {
    /// A builder for [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier of the snapshot schedule to delete.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier of the snapshot schedule to delete.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSnapshotScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSnapshotScheduleInput {
                schedule_identifier: self.schedule_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSnapshotScheduleInputOperationOutputAlias = crate::operation::DeleteSnapshotSchedule;
#[doc(hidden)]
pub type DeleteSnapshotScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSnapshotScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSnapshotSchedule`](crate::operation::DeleteSnapshotSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSnapshotSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSnapshotScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSnapshotScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSnapshotScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_snapshot_schedule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSnapshotSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSnapshotSchedule",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotScheduleInput`](crate::input::DeleteSnapshotScheduleInput)
    pub fn builder() -> crate::input::delete_snapshot_schedule_input::Builder {
        crate::input::delete_snapshot_schedule_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key that you want to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key that you want to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput {
                resource_name: self.resource_name,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DeleteUsageLimitInput`](crate::input::DeleteUsageLimitInput)
pub mod delete_usage_limit_input {
    /// A builder for [`DeleteUsageLimitInput`](crate::input::DeleteUsageLimitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_limit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the usage limit to delete.</p>
        pub fn usage_limit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_limit_id = Some(input.into());
            self
        }
        /// <p>The identifier of the usage limit to delete.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_limit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUsageLimitInput`](crate::input::DeleteUsageLimitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUsageLimitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUsageLimitInput {
                usage_limit_id: self.usage_limit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUsageLimitInputOperationOutputAlias = crate::operation::DeleteUsageLimit;
#[doc(hidden)]
pub type DeleteUsageLimitInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUsageLimitInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUsageLimit`](crate::operation::DeleteUsageLimit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUsageLimit,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUsageLimitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUsageLimitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUsageLimitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_usage_limit(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUsageLimit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUsageLimit",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUsageLimitInput`](crate::input::DeleteUsageLimitInput)
    pub fn builder() -> crate::input::delete_usage_limit_input::Builder {
        crate::input::delete_usage_limit_input::Builder::default()
    }
}

/// See [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
pub mod describe_account_attributes_input {
    /// A builder for [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `attribute_names`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attribute names.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_names.unwrap_or_default();
            v.push(input.into());
            self.attribute_names = Some(v);
            self
        }
        /// <p>A list of attribute names.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAttributesInput {
                attribute_names: self.attribute_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationOutputAlias =
    crate::operation::DescribeAccountAttributes;
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAttributes`](crate::operation::DescribeAccountAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAttributes",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
}

/// See [`DescribeAuthenticationProfilesInput`](crate::input::DescribeAuthenticationProfilesInput)
pub mod describe_authentication_profiles_input {
    /// A builder for [`DescribeAuthenticationProfilesInput`](crate::input::DescribeAuthenticationProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuthenticationProfilesInput`](crate::input::DescribeAuthenticationProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAuthenticationProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAuthenticationProfilesInput {
                authentication_profile_name: self.authentication_profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAuthenticationProfilesInputOperationOutputAlias =
    crate::operation::DescribeAuthenticationProfiles;
#[doc(hidden)]
pub type DescribeAuthenticationProfilesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAuthenticationProfilesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAuthenticationProfiles`](crate::operation::DescribeAuthenticationProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAuthenticationProfiles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAuthenticationProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAuthenticationProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAuthenticationProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_authentication_profiles(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAuthenticationProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAuthenticationProfiles",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAuthenticationProfilesInput`](crate::input::DescribeAuthenticationProfilesInput)
    pub fn builder() -> crate::input::describe_authentication_profiles_input::Builder {
        crate::input::describe_authentication_profiles_input::Builder::default()
    }
}

/// See [`DescribeClusterDbRevisionsInput`](crate::input::DescribeClusterDbRevisionsInput)
pub mod describe_cluster_db_revisions_input {
    /// A builder for [`DescribeClusterDbRevisionsInput`](crate::input::DescribeClusterDbRevisionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are
        /// requesting. This parameter is case sensitive. All clusters defined for an account are
        /// returned by default.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are
        /// requesting. This parameter is case sensitive. All clusters defined for an account are
        /// returned by default.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified MaxRecords value, a value is returned
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified MaxRecords value, a value is returned
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point for returning a set of
        /// response records. When the results of a <code>DescribeClusterDbRevisions</code> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or
        /// the <code>marker</code> parameter, but not both.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point for returning a set of
        /// response records. When the results of a <code>DescribeClusterDbRevisions</code> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or
        /// the <code>marker</code> parameter, but not both.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterDbRevisionsInput`](crate::input::DescribeClusterDbRevisionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterDbRevisionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterDbRevisionsInput {
                cluster_identifier: self.cluster_identifier,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterDbRevisionsInputOperationOutputAlias =
    crate::operation::DescribeClusterDbRevisions;
#[doc(hidden)]
pub type DescribeClusterDbRevisionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterDbRevisionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterDbRevisions`](crate::operation::DescribeClusterDbRevisions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterDbRevisions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterDbRevisionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterDbRevisionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterDbRevisionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_db_revisions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterDbRevisions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterDbRevisions",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterDbRevisionsInput`](crate::input::DescribeClusterDbRevisionsInput)
    pub fn builder() -> crate::input::describe_cluster_db_revisions_input::Builder {
        crate::input::describe_cluster_db_revisions_input::Builder::default()
    }
}

/// See [`DescribeClusterParameterGroupsInput`](crate::input::DescribeClusterParameterGroupsInput)
pub mod describe_cluster_parameter_groups_input {
    /// A builder for [`DescribeClusterParameterGroupsInput`](crate::input::DescribeClusterParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of a specific parameter group for which to return details. By default,
        /// details about all parameter groups and the default parameter group are
        /// returned.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific parameter group for which to return details. By default,
        /// details about all parameter groups and the default parameter group are
        /// returned.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameterGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameterGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster parameter
        /// groups that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the parameter groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster parameter
        /// groups that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the parameter groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster parameter
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the parameter groups that have either or both of these tag
        /// values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster parameter
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the parameter groups that have either or both of these tag
        /// values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterParameterGroupsInput`](crate::input::DescribeClusterParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterParameterGroupsInput {
                parameter_group_name: self.parameter_group_name,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeClusterParameterGroups;
#[doc(hidden)]
pub type DescribeClusterParameterGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterParameterGroups`](crate::operation::DescribeClusterParameterGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterParameterGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterParameterGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterParameterGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterParameterGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_parameter_groups(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterParameterGroups",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterParameterGroupsInput`](crate::input::DescribeClusterParameterGroupsInput)
    pub fn builder() -> crate::input::describe_cluster_parameter_groups_input::Builder {
        crate::input::describe_cluster_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeClusterParametersInput`](crate::input::DescribeClusterParametersInput)
pub mod describe_cluster_parameters_input {
    /// A builder for [`DescribeClusterParametersInput`](crate::input::DescribeClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a cluster parameter group for which to return details.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a cluster parameter group for which to return details.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The parameter types to return. Specify <code>user</code> to show parameters that
        /// are different form the default. Similarly, specify <code>engine-default</code> to show
        /// parameters that are the same as the default parameter group. </p>
        /// <p>Default: All parameter types returned.</p>
        /// <p>Valid Values: <code>user</code> | <code>engine-default</code>
        /// </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The parameter types to return. Specify <code>user</code> to show parameters that
        /// are different form the default. Similarly, specify <code>engine-default</code> to show
        /// parameters that are the same as the default parameter group. </p>
        /// <p>Default: All parameter types returned.</p>
        /// <p>Valid Values: <code>user</code> | <code>engine-default</code>
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameters</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameters</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterParametersInput`](crate::input::DescribeClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterParametersInput {
                parameter_group_name: self.parameter_group_name,
                source: self.source,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeClusterParameters;
#[doc(hidden)]
pub type DescribeClusterParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterParameters`](crate::operation::DescribeClusterParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_parameters(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterParameters",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterParametersInput`](crate::input::DescribeClusterParametersInput)
    pub fn builder() -> crate::input::describe_cluster_parameters_input::Builder {
        crate::input::describe_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeClustersInput`](crate::input::DescribeClustersInput)
pub mod describe_clusters_input {
    /// A builder for [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique identifier of a cluster whose properties you are requesting. This
        /// parameter is case sensitive.</p>
        /// <p>The default is that all clusters defined for an account are returned.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of a cluster whose properties you are requesting. This
        /// parameter is case sensitive.</p>
        /// <p>The default is that all clusters defined for an account are returned.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusters</a> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusters</a> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching clusters that are
        /// associated with the specified key or keys. For example, suppose that you have clusters
        /// that are tagged with keys called <code>owner</code> and <code>environment</code>. If you
        /// specify both of these tag keys in the request, Amazon Redshift returns a response with the
        /// clusters that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching clusters that are
        /// associated with the specified key or keys. For example, suppose that you have clusters
        /// that are tagged with keys called <code>owner</code> and <code>environment</code>. If you
        /// specify both of these tag keys in the request, Amazon Redshift returns a response with the
        /// clusters that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching clusters that are
        /// associated with the specified tag value or values. For example, suppose that you have
        /// clusters that are tagged with values called <code>admin</code> and <code>test</code>. If
        /// you specify both of these tag values in the request, Amazon Redshift returns a response with
        /// the clusters that have either or both of these tag values associated with
        /// them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching clusters that are
        /// associated with the specified tag value or values. For example, suppose that you have
        /// clusters that are tagged with values called <code>admin</code> and <code>test</code>. If
        /// you specify both of these tag values in the request, Amazon Redshift returns a response with
        /// the clusters that have either or both of these tag values associated with
        /// them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClustersInput`](crate::input::DescribeClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClustersInput {
                cluster_identifier: self.cluster_identifier,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClustersInputOperationOutputAlias = crate::operation::DescribeClusters;
#[doc(hidden)]
pub type DescribeClustersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusters`](crate::operation::DescribeClusters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClustersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClustersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClustersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_clusters(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusters",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClustersInput`](crate::input::DescribeClustersInput)
    pub fn builder() -> crate::input::describe_clusters_input::Builder {
        crate::input::describe_clusters_input::Builder::default()
    }
}

/// See [`DescribeClusterSecurityGroupsInput`](crate::input::DescribeClusterSecurityGroupsInput)
pub mod describe_cluster_security_groups_input {
    /// A builder for [`DescribeClusterSecurityGroupsInput`](crate::input::DescribeClusterSecurityGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of a cluster security group for which you are requesting details. You can
        /// specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p>
        /// <p> Example: <code>securitygroup1</code>
        /// </p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of a cluster security group for which you are requesting details. You can
        /// specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p>
        /// <p> Example: <code>securitygroup1</code>
        /// </p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSecurityGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSecurityGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster security groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// security groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the security groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster security groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// security groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the security groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster security
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have security groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the security groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster security
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have security groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the security groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterSecurityGroupsInput`](crate::input::DescribeClusterSecurityGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterSecurityGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterSecurityGroupsInput {
                cluster_security_group_name: self.cluster_security_group_name,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterSecurityGroupsInputOperationOutputAlias =
    crate::operation::DescribeClusterSecurityGroups;
#[doc(hidden)]
pub type DescribeClusterSecurityGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterSecurityGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterSecurityGroups`](crate::operation::DescribeClusterSecurityGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterSecurityGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterSecurityGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterSecurityGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterSecurityGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_security_groups(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterSecurityGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterSecurityGroups",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterSecurityGroupsInput`](crate::input::DescribeClusterSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_cluster_security_groups_input::Builder {
        crate::input::describe_cluster_security_groups_input::Builder::default()
    }
}

/// See [`DescribeClusterSnapshotsInput`](crate::input::DescribeClusterSnapshotsInput)
pub mod describe_cluster_snapshots_input {
    /// A builder for [`DescribeClusterSnapshotsInput`](crate::input::DescribeClusterSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cluster_exists: std::option::Option<bool>,
        pub(crate) sorting_entities:
            std::option::Option<std::vec::Vec<crate::model::SnapshotSortingEntity>>,
    }
    impl Builder {
        /// <p>The identifier of the cluster which generated the requested snapshots.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster which generated the requested snapshots.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The snapshot identifier of the snapshot about which to return
        /// information.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The snapshot identifier of the snapshot about which to return
        /// information.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The type of snapshots for which you are requesting information. By default,
        /// snapshots of all types are returned.</p>
        /// <p>Valid Values: <code>automated</code> | <code>manual</code>
        /// </p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>The type of snapshots for which you are requesting information. By default,
        /// snapshots of all types are returned.</p>
        /// <p>Valid Values: <code>automated</code> | <code>manual</code>
        /// </p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// <p>A value that requests only snapshots created at or after the specified time. The
        /// time value is specified in ISO 8601 format. For more information about ISO 8601, go to
        /// the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>A value that requests only snapshots created at or after the specified time. The
        /// time value is specified in ISO 8601 format. For more information about ISO 8601, go to
        /// the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>A time value that requests only snapshots created at or before the specified time.
        /// The time value is specified in ISO 8601 format. For more information about ISO 8601, go
        /// to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
        /// page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>A time value that requests only snapshots created at or before the specified time.
        /// The time value is specified in ISO 8601 format. For more information about ISO 8601, go
        /// to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
        /// page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSnapshots</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSnapshots</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Use this field to
        /// filter the results to snapshots owned by a particular account. To describe snapshots you
        /// own, either specify your Amazon Web Services account, or do not specify the
        /// parameter.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Use this field to
        /// filter the results to snapshots owned by a particular account. To describe snapshots you
        /// own, either specify your Amazon Web Services account, or do not specify the
        /// parameter.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster snapshots that
        /// are associated with the specified key or keys. For example, suppose that you have
        /// snapshots that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the snapshots that have either or both of these tag
        /// keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster snapshots that
        /// are associated with the specified key or keys. For example, suppose that you have
        /// snapshots that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the snapshots that have either or both of these tag
        /// keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster snapshots
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have snapshots that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the snapshots that have either or both of these tag values
        /// associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster snapshots
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have snapshots that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the snapshots that have either or both of these tag values
        /// associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// <p>A value that indicates whether to return snapshots only for an existing cluster.
        /// You can perform table-level restore only by using a snapshot of an existing cluster,
        /// that is, a cluster that has not been deleted. Values for this parameter work as follows: </p>
        /// <ul>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>true</code>,
        /// <code>ClusterIdentifier</code> is required.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> isn't specified, all snapshots
        /// associated with deleted clusters (orphaned snapshots) are returned. </p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots
        /// associated with that cluster are returned.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for an existing cluster, no
        /// snapshots are returned. </p>
        /// </li>
        /// </ul>
        pub fn cluster_exists(mut self, input: bool) -> Self {
            self.cluster_exists = Some(input);
            self
        }
        /// <p>A value that indicates whether to return snapshots only for an existing cluster.
        /// You can perform table-level restore only by using a snapshot of an existing cluster,
        /// that is, a cluster that has not been deleted. Values for this parameter work as follows: </p>
        /// <ul>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>true</code>,
        /// <code>ClusterIdentifier</code> is required.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> isn't specified, all snapshots
        /// associated with deleted clusters (orphaned snapshots) are returned. </p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots
        /// associated with that cluster are returned.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for an existing cluster, no
        /// snapshots are returned. </p>
        /// </li>
        /// </ul>
        pub fn set_cluster_exists(mut self, input: std::option::Option<bool>) -> Self {
            self.cluster_exists = input;
            self
        }
        /// Appends an item to `sorting_entities`.
        ///
        /// To override the contents of this collection use [`set_sorting_entities`](Self::set_sorting_entities).
        ///
        /// <p></p>
        pub fn sorting_entities(
            mut self,
            input: impl Into<crate::model::SnapshotSortingEntity>,
        ) -> Self {
            let mut v = self.sorting_entities.unwrap_or_default();
            v.push(input.into());
            self.sorting_entities = Some(v);
            self
        }
        /// <p></p>
        pub fn set_sorting_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotSortingEntity>>,
        ) -> Self {
            self.sorting_entities = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterSnapshotsInput`](crate::input::DescribeClusterSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterSnapshotsInput {
                cluster_identifier: self.cluster_identifier,
                snapshot_identifier: self.snapshot_identifier,
                snapshot_type: self.snapshot_type,
                start_time: self.start_time,
                end_time: self.end_time,
                max_records: self.max_records,
                marker: self.marker,
                owner_account: self.owner_account,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
                cluster_exists: self.cluster_exists,
                sorting_entities: self.sorting_entities,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterSnapshotsInputOperationOutputAlias =
    crate::operation::DescribeClusterSnapshots;
#[doc(hidden)]
pub type DescribeClusterSnapshotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterSnapshots`](crate::operation::DescribeClusterSnapshots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterSnapshots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterSnapshotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterSnapshotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterSnapshotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_snapshots(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterSnapshots",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterSnapshotsInput`](crate::input::DescribeClusterSnapshotsInput)
    pub fn builder() -> crate::input::describe_cluster_snapshots_input::Builder {
        crate::input::describe_cluster_snapshots_input::Builder::default()
    }
}

/// See [`DescribeClusterSubnetGroupsInput`](crate::input::DescribeClusterSubnetGroupsInput)
pub mod describe_cluster_subnet_groups_input {
    /// A builder for [`DescribeClusterSubnetGroupsInput`](crate::input::DescribeClusterSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the cluster subnet group for which information is requested.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster subnet group for which information is requested.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_subnet_group_name = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSubnetGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSubnetGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster subnet groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// subnet groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subnet groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster subnet groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// subnet groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subnet groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster subnet
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have subnet groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the subnet groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster subnet
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have subnet groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the subnet groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterSubnetGroupsInput`](crate::input::DescribeClusterSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterSubnetGroupsInput {
                cluster_subnet_group_name: self.cluster_subnet_group_name,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterSubnetGroupsInputOperationOutputAlias =
    crate::operation::DescribeClusterSubnetGroups;
#[doc(hidden)]
pub type DescribeClusterSubnetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterSubnetGroups`](crate::operation::DescribeClusterSubnetGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterSubnetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterSubnetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterSubnetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterSubnetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_subnet_groups(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterSubnetGroups",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterSubnetGroupsInput`](crate::input::DescribeClusterSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_cluster_subnet_groups_input::Builder {
        crate::input::describe_cluster_subnet_groups_input::Builder::default()
    }
}

/// See [`DescribeClusterTracksInput`](crate::input::DescribeClusterTracksInput)
pub mod describe_cluster_tracks_input {
    /// A builder for [`DescribeClusterTracksInput`](crate::input::DescribeClusterTracksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the maintenance track. </p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance track. </p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>An integer value for the maximum number of maintenance tracks to return.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>An integer value for the maximum number of maintenance tracks to return.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeClusterTracks</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeClusterTracks</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterTracksInput`](crate::input::DescribeClusterTracksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterTracksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterTracksInput {
                maintenance_track_name: self.maintenance_track_name,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterTracksInputOperationOutputAlias = crate::operation::DescribeClusterTracks;
#[doc(hidden)]
pub type DescribeClusterTracksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterTracksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterTracks`](crate::operation::DescribeClusterTracks)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterTracks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterTracksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterTracksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterTracksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_tracks(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterTracks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterTracks",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterTracksInput`](crate::input::DescribeClusterTracksInput)
    pub fn builder() -> crate::input::describe_cluster_tracks_input::Builder {
        crate::input::describe_cluster_tracks_input::Builder::default()
    }
}

/// See [`DescribeClusterVersionsInput`](crate::input::DescribeClusterVersionsInput)
pub mod describe_cluster_versions_input {
    /// A builder for [`DescribeClusterVersionsInput`](crate::input::DescribeClusterVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) cluster_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The specific cluster version to return.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The specific cluster version to return.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>The name of a specific cluster parameter group family to return details
        /// for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn cluster_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of a specific cluster parameter group family to return details
        /// for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_family = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterVersions</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterVersions</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterVersionsInput`](crate::input::DescribeClusterVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClusterVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClusterVersionsInput {
                cluster_version: self.cluster_version,
                cluster_parameter_group_family: self.cluster_parameter_group_family,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClusterVersionsInputOperationOutputAlias =
    crate::operation::DescribeClusterVersions;
#[doc(hidden)]
pub type DescribeClusterVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClusterVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClusterVersions`](crate::operation::DescribeClusterVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClusterVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClusterVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClusterVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClusterVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cluster_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClusterVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClusterVersions",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClusterVersionsInput`](crate::input::DescribeClusterVersionsInput)
    pub fn builder() -> crate::input::describe_cluster_versions_input::Builder {
        crate::input::describe_cluster_versions_input::Builder::default()
    }
}

/// See [`DescribeDataSharesInput`](crate::input::DescribeDataSharesInput)
pub mod describe_data_shares_input {
    /// A builder for [`DescribeDataSharesInput`](crate::input::DescribeDataSharesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the datashare to describe details of.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>The identifier of the datashare to describe details of.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataShares</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataShares</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSharesInput`](crate::input::DescribeDataSharesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSharesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSharesInput {
                data_share_arn: self.data_share_arn,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSharesInputOperationOutputAlias = crate::operation::DescribeDataShares;
#[doc(hidden)]
pub type DescribeDataSharesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDataSharesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataShares`](crate::operation::DescribeDataShares)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataShares,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSharesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSharesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSharesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_data_shares(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataShares::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataShares",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesInput`](crate::input::DescribeDataSharesInput)
    pub fn builder() -> crate::input::describe_data_shares_input::Builder {
        crate::input::describe_data_shares_input::Builder::default()
    }
}

/// See [`DescribeDataSharesForConsumerInput`](crate::input::DescribeDataSharesForConsumerInput)
pub mod describe_data_shares_for_consumer_input {
    /// A builder for [`DescribeDataSharesForConsumerInput`](crate::input::DescribeDataSharesForConsumerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumer_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DataShareStatusForConsumer>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.consumer_arn = input;
            self
        }
        /// <p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn status(mut self, input: crate::model::DataShareStatusForConsumer) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataShareStatusForConsumer>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForConsumer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForConsumer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSharesForConsumerInput`](crate::input::DescribeDataSharesForConsumerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSharesForConsumerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSharesForConsumerInput {
                consumer_arn: self.consumer_arn,
                status: self.status,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSharesForConsumerInputOperationOutputAlias =
    crate::operation::DescribeDataSharesForConsumer;
#[doc(hidden)]
pub type DescribeDataSharesForConsumerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDataSharesForConsumerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSharesForConsumer`](crate::operation::DescribeDataSharesForConsumer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSharesForConsumer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSharesForConsumerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSharesForConsumerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSharesForConsumerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_data_shares_for_consumer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSharesForConsumer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSharesForConsumer",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesForConsumerInput`](crate::input::DescribeDataSharesForConsumerInput)
    pub fn builder() -> crate::input::describe_data_shares_for_consumer_input::Builder {
        crate::input::describe_data_shares_for_consumer_input::Builder::default()
    }
}

/// See [`DescribeDataSharesForProducerInput`](crate::input::DescribeDataSharesForProducerInput)
pub mod describe_data_shares_for_producer_input {
    /// A builder for [`DescribeDataSharesForProducerInput`](crate::input::DescribeDataSharesForProducerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) producer_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DataShareStatusForProducer>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.producer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.producer_arn = input;
            self
        }
        /// <p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn status(mut self, input: crate::model::DataShareStatusForProducer) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataShareStatusForProducer>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForProducer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForProducer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSharesForProducerInput`](crate::input::DescribeDataSharesForProducerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSharesForProducerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSharesForProducerInput {
                producer_arn: self.producer_arn,
                status: self.status,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSharesForProducerInputOperationOutputAlias =
    crate::operation::DescribeDataSharesForProducer;
#[doc(hidden)]
pub type DescribeDataSharesForProducerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDataSharesForProducerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSharesForProducer`](crate::operation::DescribeDataSharesForProducer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSharesForProducer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSharesForProducerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSharesForProducerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSharesForProducerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_data_shares_for_producer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSharesForProducer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSharesForProducer",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesForProducerInput`](crate::input::DescribeDataSharesForProducerInput)
    pub fn builder() -> crate::input::describe_data_shares_for_producer_input::Builder {
        crate::input::describe_data_shares_for_producer_input::Builder::default()
    }
}

/// See [`DescribeDefaultClusterParametersInput`](crate::input::DescribeDefaultClusterParametersInput)
pub mod describe_default_cluster_parameters_input {
    /// A builder for [`DescribeDefaultClusterParametersInput`](crate::input::DescribeDefaultClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group family.</p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group family.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_family = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDefaultClusterParameters</a>
        /// request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in
        /// the <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDefaultClusterParameters</a>
        /// request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in
        /// the <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDefaultClusterParametersInput`](crate::input::DescribeDefaultClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDefaultClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDefaultClusterParametersInput {
                parameter_group_family: self.parameter_group_family,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDefaultClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeDefaultClusterParameters;
#[doc(hidden)]
pub type DescribeDefaultClusterParametersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDefaultClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDefaultClusterParameters`](crate::operation::DescribeDefaultClusterParameters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDefaultClusterParameters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDefaultClusterParametersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDefaultClusterParametersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDefaultClusterParametersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_default_cluster_parameters(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDefaultClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDefaultClusterParameters",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDefaultClusterParametersInput`](crate::input::DescribeDefaultClusterParametersInput)
    pub fn builder() -> crate::input::describe_default_cluster_parameters_input::Builder {
        crate::input::describe_default_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeEndpointAccessInput`](crate::input::DescribeEndpointAccessInput)
pub mod describe_endpoint_access_input {
    /// A builder for [`DescribeEndpointAccessInput`](crate::input::DescribeEndpointAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier associated with the described endpoint.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier associated with the described endpoint.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The name of the endpoint to be described.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint to be described.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAccess</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAccess</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointAccessInput`](crate::input::DescribeEndpointAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointAccessInput {
                cluster_identifier: self.cluster_identifier,
                resource_owner: self.resource_owner,
                endpoint_name: self.endpoint_name,
                vpc_id: self.vpc_id,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointAccessInputOperationOutputAlias = crate::operation::DescribeEndpointAccess;
#[doc(hidden)]
pub type DescribeEndpointAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointAccessInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpointAccess`](crate::operation::DescribeEndpointAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpointAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint_access(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpointAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpointAccess",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointAccessInput`](crate::input::DescribeEndpointAccessInput)
    pub fn builder() -> crate::input::describe_endpoint_access_input::Builder {
        crate::input::describe_endpoint_access_input::Builder::default()
    }
}

/// See [`DescribeEndpointAuthorizationInput`](crate::input::DescribeEndpointAuthorizationInput)
pub mod describe_endpoint_authorization_input {
    /// A builder for [`DescribeEndpointAuthorizationInput`](crate::input::DescribeEndpointAuthorizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) grantee: std::option::Option<bool>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee.
        /// If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee.
        /// If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>Indicates whether to check authorization from a grantor or grantee point of view.
        /// If true, Amazon Redshift returns endpoint authorizations that you've been granted.
        /// If false (default), checks authorization from a grantor point of view.</p>
        pub fn grantee(mut self, input: bool) -> Self {
            self.grantee = Some(input);
            self
        }
        /// <p>Indicates whether to check authorization from a grantor or grantee point of view.
        /// If true, Amazon Redshift returns endpoint authorizations that you've been granted.
        /// If false (default), checks authorization from a grantor point of view.</p>
        pub fn set_grantee(mut self, input: std::option::Option<bool>) -> Self {
            self.grantee = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointAuthorizationInput`](crate::input::DescribeEndpointAuthorizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointAuthorizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointAuthorizationInput {
                cluster_identifier: self.cluster_identifier,
                account: self.account,
                grantee: self.grantee,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointAuthorizationInputOperationOutputAlias =
    crate::operation::DescribeEndpointAuthorization;
#[doc(hidden)]
pub type DescribeEndpointAuthorizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointAuthorizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpointAuthorization`](crate::operation::DescribeEndpointAuthorization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpointAuthorization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointAuthorizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointAuthorizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointAuthorizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint_authorization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpointAuthorization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpointAuthorization",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointAuthorizationInput`](crate::input::DescribeEndpointAuthorizationInput)
    pub fn builder() -> crate::input::describe_endpoint_authorization_input::Builder {
        crate::input::describe_endpoint_authorization_input::Builder::default()
    }
}

/// See [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
pub mod describe_event_categories_input {
    /// A builder for [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The source type, such as cluster or parameter group, to which the described event
        /// categories apply.</p>
        /// <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type, such as cluster or parameter group, to which the described event
        /// categories apply.</p>
        /// <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventCategoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventCategoriesInput {
                source_type: self.source_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationOutputAlias =
    crate::operation::DescribeEventCategories;
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventCategoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventCategories`](crate::operation::DescribeEventCategories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventCategories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventCategoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventCategoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventCategoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_categories(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventCategories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventCategories",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source for which events will be returned. If this
        /// parameter is not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceIdentifier</i> is supplied,
        /// <i>SourceType</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify a cluster identifier when <i>SourceType</i> is
        /// <code>cluster</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster security group name when <i>SourceType</i>
        /// is <code>cluster-security-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster parameter group name when <i>SourceType</i>
        /// is <code>cluster-parameter-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster snapshot identifier when <i>SourceType</i>
        /// is <code>cluster-snapshot</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source for which events will be returned. If this
        /// parameter is not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceIdentifier</i> is supplied,
        /// <i>SourceType</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify a cluster identifier when <i>SourceType</i> is
        /// <code>cluster</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster security group name when <i>SourceType</i>
        /// is <code>cluster-security-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster parameter group name when <i>SourceType</i>
        /// is <code>cluster-parameter-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster snapshot identifier when <i>SourceType</i>
        /// is <code>cluster-snapshot</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceType</i> is supplied,
        /// <i>SourceIdentifier</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is
        /// a cluster identifier.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-security-group</code> when
        /// <i>SourceIdentifier</i> is a cluster security group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-parameter-group</code> when
        /// <i>SourceIdentifier</i> is a cluster parameter group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-snapshot</code> when
        /// <i>SourceIdentifier</i> is a cluster snapshot
        /// identifier.</p>
        /// </li>
        /// </ul>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceType</i> is supplied,
        /// <i>SourceIdentifier</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is
        /// a cluster identifier.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-security-group</code> when
        /// <i>SourceIdentifier</i> is a cluster security group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-parameter-group</code> when
        /// <i>SourceIdentifier</i> is a cluster parameter group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-snapshot</code> when
        /// <i>SourceIdentifier</i> is a cluster snapshot
        /// identifier.</p>
        /// </li>
        /// </ul>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The number of minutes prior to the time of the request for which to retrieve
        /// events. For example, if the request is sent at 18:00 and you specify a duration of 60,
        /// then only events which have occurred after 17:00 will be returned.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The number of minutes prior to the time of the request for which to retrieve
        /// events. For example, if the request is sent at 18:00 and you specify a duration of 60,
        /// then only events which have occurred after 17:00 will be returned.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeEvents</a> request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeEvents</a> request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
pub mod describe_event_subscriptions_input {
    /// A builder for [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Amazon Redshift event notification subscription to be
        /// described.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be
        /// described.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a DescribeEventSubscriptions request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a DescribeEventSubscriptions request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching event notification
        /// subscriptions that are associated with the specified key or keys. For example, suppose
        /// that you have subscriptions that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subscriptions that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching event notification
        /// subscriptions that are associated with the specified key or keys. For example, suppose
        /// that you have subscriptions that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subscriptions that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching event notification
        /// subscriptions that are associated with the specified tag value or values. For example,
        /// suppose that you have subscriptions that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the subscriptions that have either or
        /// both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching event notification
        /// subscriptions that are associated with the specified tag value or values. For example,
        /// suppose that you have subscriptions that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the subscriptions that have either or
        /// both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventSubscriptionsInput {
                subscription_name: self.subscription_name,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeEventSubscriptions;
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventSubscriptions`](crate::operation::DescribeEventSubscriptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_subscriptions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventSubscriptions",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeHsmClientCertificatesInput`](crate::input::DescribeHsmClientCertificatesInput)
pub mod describe_hsm_client_certificates_input {
    /// A builder for [`DescribeHsmClientCertificatesInput`](crate::input::DescribeHsmClientCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_client_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of a specific HSM client certificate for which you want information.
        /// If no identifier is specified, information is returned for all HSM client certificates
        /// owned by your Amazon Web Services account.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of a specific HSM client certificate for which you want information.
        /// If no identifier is specified, information is returned for all HSM client certificates
        /// owned by your Amazon Web Services account.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmClientCertificates</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmClientCertificates</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching HSM client certificates
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// HSM client certificates that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM client certificates that have either or both
        /// of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching HSM client certificates
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// HSM client certificates that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM client certificates that have either or both
        /// of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching HSM client
        /// certificates that are associated with the specified tag value or values. For example,
        /// suppose that you have HSM client certificates that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the HSM client certificates that have
        /// either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching HSM client
        /// certificates that are associated with the specified tag value or values. For example,
        /// suppose that you have HSM client certificates that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the HSM client certificates that have
        /// either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHsmClientCertificatesInput`](crate::input::DescribeHsmClientCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHsmClientCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHsmClientCertificatesInput {
                hsm_client_certificate_identifier: self.hsm_client_certificate_identifier,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHsmClientCertificatesInputOperationOutputAlias =
    crate::operation::DescribeHsmClientCertificates;
#[doc(hidden)]
pub type DescribeHsmClientCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHsmClientCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHsmClientCertificates`](crate::operation::DescribeHsmClientCertificates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHsmClientCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHsmClientCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHsmClientCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHsmClientCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_hsm_client_certificates(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHsmClientCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHsmClientCertificates",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHsmClientCertificatesInput`](crate::input::DescribeHsmClientCertificatesInput)
    pub fn builder() -> crate::input::describe_hsm_client_certificates_input::Builder {
        crate::input::describe_hsm_client_certificates_input::Builder::default()
    }
}

/// See [`DescribeHsmConfigurationsInput`](crate::input::DescribeHsmConfigurationsInput)
pub mod describe_hsm_configurations_input {
    /// A builder for [`DescribeHsmConfigurationsInput`](crate::input::DescribeHsmConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_configuration_identifier: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no
        /// identifier is specified, information is returned for all HSM configurations owned by
        /// your Amazon Web Services account.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no
        /// identifier is specified, information is returned for all HSM configurations owned by
        /// your Amazon Web Services account.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmConfigurations</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmConfigurations</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching HSM configurations that
        /// are associated with the specified key or keys. For example, suppose that you have HSM
        /// configurations that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM configurations that have either or both of
        /// these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching HSM configurations that
        /// are associated with the specified key or keys. For example, suppose that you have HSM
        /// configurations that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM configurations that have either or both of
        /// these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching HSM configurations
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have HSM configurations that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the HSM configurations that have either or both of these tag
        /// values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching HSM configurations
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have HSM configurations that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the HSM configurations that have either or both of these tag
        /// values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHsmConfigurationsInput`](crate::input::DescribeHsmConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHsmConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHsmConfigurationsInput {
                hsm_configuration_identifier: self.hsm_configuration_identifier,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHsmConfigurationsInputOperationOutputAlias =
    crate::operation::DescribeHsmConfigurations;
#[doc(hidden)]
pub type DescribeHsmConfigurationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeHsmConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHsmConfigurations`](crate::operation::DescribeHsmConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHsmConfigurations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHsmConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHsmConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHsmConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_hsm_configurations(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHsmConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHsmConfigurations",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHsmConfigurationsInput`](crate::input::DescribeHsmConfigurationsInput)
    pub fn builder() -> crate::input::describe_hsm_configurations_input::Builder {
        crate::input::describe_hsm_configurations_input::Builder::default()
    }
}

/// See [`DescribeLoggingStatusInput`](crate::input::DescribeLoggingStatusInput)
pub mod describe_logging_status_input {
    /// A builder for [`DescribeLoggingStatusInput`](crate::input::DescribeLoggingStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster from which to get the logging status.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster from which to get the logging status.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoggingStatusInput`](crate::input::DescribeLoggingStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoggingStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoggingStatusInput {
                cluster_identifier: self.cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoggingStatusInputOperationOutputAlias = crate::operation::DescribeLoggingStatus;
#[doc(hidden)]
pub type DescribeLoggingStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeLoggingStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoggingStatus`](crate::operation::DescribeLoggingStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoggingStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeLoggingStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeLoggingStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeLoggingStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_logging_status(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoggingStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoggingStatus",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoggingStatusInput`](crate::input::DescribeLoggingStatusInput)
    pub fn builder() -> crate::input::describe_logging_status_input::Builder {
        crate::input::describe_logging_status_input::Builder::default()
    }
}

/// See [`DescribeNodeConfigurationOptionsInput`](crate::input::DescribeNodeConfigurationOptionsInput)
pub mod describe_node_configuration_options_input {
    /// A builder for [`DescribeNodeConfigurationOptionsInput`](crate::input::DescribeNodeConfigurationOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<crate::model::ActionType>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::NodeConfigurationOptionsFilter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The action type to evaluate for possible node configurations.
        /// Specify "restore-cluster" to get configuration combinations based on an existing snapshot.
        /// Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot.
        /// Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
        /// </p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The action type to evaluate for possible node configurations.
        /// Specify "restore-cluster" to get configuration combinations based on an existing snapshot.
        /// Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot.
        /// Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
        /// </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>The identifier of the cluster to evaluate for possible node configurations.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to evaluate for possible node configurations.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot.
        /// Required if you are restoring a snapshot you do not own,
        /// optional if you own the snapshot.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot.
        /// Required if you are restoring a snapshot you do not own,
        /// optional if you own the snapshot.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name, operator, and value items to filter the results.</p>
        pub fn filters(
            mut self,
            input: impl Into<crate::model::NodeConfigurationOptionsFilter>,
        ) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>A set of name, operator, and value items to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeConfigurationOptionsFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeNodeConfigurationOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeNodeConfigurationOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>500</code>
        /// </p>
        /// <p>Constraints: minimum 100, maximum 500.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>500</code>
        /// </p>
        /// <p>Constraints: minimum 100, maximum 500.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNodeConfigurationOptionsInput`](crate::input::DescribeNodeConfigurationOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNodeConfigurationOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNodeConfigurationOptionsInput {
                action_type: self.action_type,
                cluster_identifier: self.cluster_identifier,
                snapshot_identifier: self.snapshot_identifier,
                owner_account: self.owner_account,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNodeConfigurationOptionsInputOperationOutputAlias =
    crate::operation::DescribeNodeConfigurationOptions;
#[doc(hidden)]
pub type DescribeNodeConfigurationOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeNodeConfigurationOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNodeConfigurationOptions`](crate::operation::DescribeNodeConfigurationOptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNodeConfigurationOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeNodeConfigurationOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeNodeConfigurationOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeNodeConfigurationOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_node_configuration_options(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNodeConfigurationOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNodeConfigurationOptions",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeNodeConfigurationOptionsInput`](crate::input::DescribeNodeConfigurationOptionsInput)
    pub fn builder() -> crate::input::describe_node_configuration_options_input::Builder {
        crate::input::describe_node_configuration_options_input::Builder::default()
    }
}

/// See [`DescribeOrderableClusterOptionsInput`](crate::input::DescribeOrderableClusterOptionsInput)
pub mod describe_orderable_cluster_options_input {
    /// A builder for [`DescribeOrderableClusterOptionsInput`](crate::input::DescribeOrderableClusterOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version filter value. Specify this parameter to show only the available
        /// offerings matching the specified version.</p>
        /// <p>Default: All versions.</p>
        /// <p>Constraints: Must be one of the version returned from <a>DescribeClusterVersions</a>.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The version filter value. Specify this parameter to show only the available
        /// offerings matching the specified version.</p>
        /// <p>Default: All versions.</p>
        /// <p>Constraints: Must be one of the version returned from <a>DescribeClusterVersions</a>.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>The node type filter value. Specify this parameter to show only the available
        /// offerings matching the specified node type.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type filter value. Specify this parameter to show only the available
        /// offerings matching the specified node type.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeOrderableClusterOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeOrderableClusterOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrderableClusterOptionsInput`](crate::input::DescribeOrderableClusterOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrderableClusterOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrderableClusterOptionsInput {
                cluster_version: self.cluster_version,
                node_type: self.node_type,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrderableClusterOptionsInputOperationOutputAlias =
    crate::operation::DescribeOrderableClusterOptions;
#[doc(hidden)]
pub type DescribeOrderableClusterOptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOrderableClusterOptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrderableClusterOptions`](crate::operation::DescribeOrderableClusterOptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrderableClusterOptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrderableClusterOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrderableClusterOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrderableClusterOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_orderable_cluster_options(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrderableClusterOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrderableClusterOptions",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrderableClusterOptionsInput`](crate::input::DescribeOrderableClusterOptionsInput)
    pub fn builder() -> crate::input::describe_orderable_cluster_options_input::Builder {
        crate::input::describe_orderable_cluster_options_input::Builder::default()
    }
}

/// See [`DescribePartnersInput`](crate::input::DescribePartnersInput)
pub mod describe_partners_input {
    /// A builder for [`DescribePartnersInput`](crate::input::DescribePartnersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration is being described.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration is being described.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePartnersInput`](crate::input::DescribePartnersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePartnersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePartnersInput {
                account_id: self.account_id,
                cluster_identifier: self.cluster_identifier,
                database_name: self.database_name,
                partner_name: self.partner_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePartnersInputOperationOutputAlias = crate::operation::DescribePartners;
#[doc(hidden)]
pub type DescribePartnersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePartnersInput {
    /// Consumes the builder and constructs an Operation<[`DescribePartners`](crate::operation::DescribePartners)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePartners,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePartnersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePartnersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePartnersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_partners(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePartners::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePartners",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePartnersInput`](crate::input::DescribePartnersInput)
    pub fn builder() -> crate::input::describe_partners_input::Builder {
        crate::input::describe_partners_input::Builder::default()
    }
}

/// See [`DescribeReservedNodeOfferingsInput`](crate::input::DescribeReservedNodeOfferingsInput)
pub mod describe_reserved_node_offerings_input {
    /// A builder for [`DescribeReservedNodeOfferingsInput`](crate::input::DescribeReservedNodeOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_offering_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the offering.</p>
        pub fn reserved_node_offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_offering_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the offering.</p>
        pub fn set_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_offering_id = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodeOfferings</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodeOfferings</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedNodeOfferingsInput`](crate::input::DescribeReservedNodeOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedNodeOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservedNodeOfferingsInput {
                reserved_node_offering_id: self.reserved_node_offering_id,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedNodeOfferingsInputOperationOutputAlias =
    crate::operation::DescribeReservedNodeOfferings;
#[doc(hidden)]
pub type DescribeReservedNodeOfferingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReservedNodeOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedNodeOfferings`](crate::operation::DescribeReservedNodeOfferings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedNodeOfferings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReservedNodeOfferingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReservedNodeOfferingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReservedNodeOfferingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_reserved_node_offerings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedNodeOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedNodeOfferings",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodeOfferingsInput`](crate::input::DescribeReservedNodeOfferingsInput)
    pub fn builder() -> crate::input::describe_reserved_node_offerings_input::Builder {
        crate::input::describe_reserved_node_offerings_input::Builder::default()
    }
}

/// See [`DescribeReservedNodesInput`](crate::input::DescribeReservedNodesInput)
pub mod describe_reserved_nodes_input {
    /// A builder for [`DescribeReservedNodesInput`](crate::input::DescribeReservedNodesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Identifier for the node reservation.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_id = Some(input.into());
            self
        }
        /// <p>Identifier for the node reservation.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_id = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodes</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodes</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedNodesInput`](crate::input::DescribeReservedNodesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservedNodesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservedNodesInput {
                reserved_node_id: self.reserved_node_id,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservedNodesInputOperationOutputAlias = crate::operation::DescribeReservedNodes;
#[doc(hidden)]
pub type DescribeReservedNodesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReservedNodesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservedNodes`](crate::operation::DescribeReservedNodes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservedNodes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReservedNodesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReservedNodesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReservedNodesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_reserved_nodes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservedNodes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservedNodes",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodesInput`](crate::input::DescribeReservedNodesInput)
    pub fn builder() -> crate::input::describe_reserved_nodes_input::Builder {
        crate::input::describe_reserved_nodes_input::Builder::default()
    }
}

/// See [`DescribeResizeInput`](crate::input::DescribeResizeInput)
pub mod describe_resize_input {
    /// A builder for [`DescribeResizeInput`](crate::input::DescribeResizeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a cluster whose resize progress you are requesting. This
        /// parameter is case-sensitive.</p>
        /// <p>By default, resize operations for all clusters defined for an Amazon Web Services account are
        /// returned.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of a cluster whose resize progress you are requesting. This
        /// parameter is case-sensitive.</p>
        /// <p>By default, resize operations for all clusters defined for an Amazon Web Services account are
        /// returned.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResizeInput`](crate::input::DescribeResizeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResizeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResizeInput {
                cluster_identifier: self.cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResizeInputOperationOutputAlias = crate::operation::DescribeResize;
#[doc(hidden)]
pub type DescribeResizeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeResizeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResize`](crate::operation::DescribeResize)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResize,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeResizeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeResizeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeResizeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_resize(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResize::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResize",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeResizeInput`](crate::input::DescribeResizeInput)
    pub fn builder() -> crate::input::describe_resize_input::Builder {
        crate::input::describe_resize_input::Builder::default()
    }
}

/// See [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
pub mod describe_scheduled_actions_input {
    /// A builder for [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) target_action_type: std::option::Option<crate::model::ScheduledActionTypeValues>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) active: std::option::Option<bool>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ScheduledActionFilter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the scheduled action to retrieve. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action to retrieve. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>The type of the scheduled actions to retrieve. </p>
        pub fn target_action_type(
            mut self,
            input: crate::model::ScheduledActionTypeValues,
        ) -> Self {
            self.target_action_type = Some(input);
            self
        }
        /// <p>The type of the scheduled actions to retrieve. </p>
        pub fn set_target_action_type(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionTypeValues>,
        ) -> Self {
            self.target_action_type = input;
            self
        }
        /// <p>The start time in UTC of the scheduled actions to retrieve.
        /// Only active scheduled actions that have invocations after this time are retrieved.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time in UTC of the scheduled actions to retrieve.
        /// Only active scheduled actions that have invocations after this time are retrieved.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time in UTC of the scheduled action to retrieve.
        /// Only active scheduled actions that have invocations before this time are retrieved.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action to retrieve.
        /// Only active scheduled actions that have invocations before this time are retrieved.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>If true, retrieve only active scheduled actions.
        /// If false, retrieve only disabled scheduled actions. </p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>If true, retrieve only active scheduled actions.
        /// If false, retrieve only disabled scheduled actions. </p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>List of scheduled action filters. </p>
        pub fn filters(mut self, input: impl Into<crate::model::ScheduledActionFilter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>List of scheduled action filters. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledActionFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeScheduledActions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeScheduledActions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScheduledActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScheduledActionsInput {
                scheduled_action_name: self.scheduled_action_name,
                target_action_type: self.target_action_type,
                start_time: self.start_time,
                end_time: self.end_time,
                active: self.active,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScheduledActionsInputOperationOutputAlias =
    crate::operation::DescribeScheduledActions;
#[doc(hidden)]
pub type DescribeScheduledActionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeScheduledActionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScheduledActions`](crate::operation::DescribeScheduledActions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScheduledActions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeScheduledActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeScheduledActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeScheduledActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_scheduled_actions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScheduledActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScheduledActions",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
    pub fn builder() -> crate::input::describe_scheduled_actions_input::Builder {
        crate::input::describe_scheduled_actions_input::Builder::default()
    }
}

/// See [`DescribeSnapshotCopyGrantsInput`](crate::input::DescribeSnapshotCopyGrantsInput)
pub mod describe_snapshot_copy_grants_input {
    /// A builder for [`DescribeSnapshotCopyGrantsInput`](crate::input::DescribeSnapshotCopyGrantsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_copy_grant_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the snapshot copy grant.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_copy_grant_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_copy_grant_name = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotCopyGrantsInput`](crate::input::DescribeSnapshotCopyGrantsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSnapshotCopyGrantsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSnapshotCopyGrantsInput {
                snapshot_copy_grant_name: self.snapshot_copy_grant_name,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSnapshotCopyGrantsInputOperationOutputAlias =
    crate::operation::DescribeSnapshotCopyGrants;
#[doc(hidden)]
pub type DescribeSnapshotCopyGrantsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSnapshotCopyGrantsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSnapshotCopyGrants`](crate::operation::DescribeSnapshotCopyGrants)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSnapshotCopyGrants,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSnapshotCopyGrantsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSnapshotCopyGrantsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSnapshotCopyGrantsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_snapshot_copy_grants(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSnapshotCopyGrants::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSnapshotCopyGrants",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotCopyGrantsInput`](crate::input::DescribeSnapshotCopyGrantsInput)
    pub fn builder() -> crate::input::describe_snapshot_copy_grants_input::Builder {
        crate::input::describe_snapshot_copy_grants_input::Builder::default()
    }
}

/// See [`DescribeSnapshotSchedulesInput`](crate::input::DescribeSnapshotSchedulesInput)
pub mod describe_snapshot_schedules_input {
    /// A builder for [`DescribeSnapshotSchedulesInput`](crate::input::DescribeSnapshotSchedulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the cluster whose snapshot schedules you want to
        /// view.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cluster whose snapshot schedules you want to
        /// view.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>A unique identifier for a snapshot schedule.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for a snapshot schedule.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_identifier = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key value for a snapshot schedule tag.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The key value for a snapshot schedule tag.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The value corresponding to the key of the snapshot schedule tag.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>The value corresponding to the key of the snapshot schedule tag.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code>
        /// value.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code>
        /// value.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotSchedulesInput`](crate::input::DescribeSnapshotSchedulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSnapshotSchedulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSnapshotSchedulesInput {
                cluster_identifier: self.cluster_identifier,
                schedule_identifier: self.schedule_identifier,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSnapshotSchedulesInputOperationOutputAlias =
    crate::operation::DescribeSnapshotSchedules;
#[doc(hidden)]
pub type DescribeSnapshotSchedulesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSnapshotSchedulesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSnapshotSchedules`](crate::operation::DescribeSnapshotSchedules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSnapshotSchedules,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSnapshotSchedulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSnapshotSchedulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSnapshotSchedulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_snapshot_schedules(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSnapshotSchedules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSnapshotSchedules",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotSchedulesInput`](crate::input::DescribeSnapshotSchedulesInput)
    pub fn builder() -> crate::input::describe_snapshot_schedules_input::Builder {
        crate::input::describe_snapshot_schedules_input::Builder::default()
    }
}

/// See [`DescribeStorageInput`](crate::input::DescribeStorageInput)
pub mod describe_storage_input {
    /// A builder for [`DescribeStorageInput`](crate::input::DescribeStorageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeStorageInput`](crate::input::DescribeStorageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStorageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStorageInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeStorageInputOperationOutputAlias = crate::operation::DescribeStorage;
#[doc(hidden)]
pub type DescribeStorageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeStorageInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStorage`](crate::operation::DescribeStorage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStorage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeStorageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeStorageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeStorageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_storage(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStorage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStorage",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeStorageInput`](crate::input::DescribeStorageInput)
    pub fn builder() -> crate::input::describe_storage_input::Builder {
        crate::input::describe_storage_input::Builder::default()
    }
}

/// See [`DescribeTableRestoreStatusInput`](crate::input::DescribeTableRestoreStatusInput)
pub mod describe_table_restore_status_input {
    /// A builder for [`DescribeTableRestoreStatusInput`](crate::input::DescribeTableRestoreStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) table_restore_request_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Redshift cluster that the table is being restored to.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Redshift cluster that the table is being restored to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The identifier of the table restore request to return status for. If you don't
        /// specify a <code>TableRestoreRequestId</code> value, then
        /// <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table
        /// restore requests.</p>
        pub fn table_restore_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_restore_request_id = Some(input.into());
            self
        }
        /// <p>The identifier of the table restore request to return status for. If you don't
        /// specify a <code>TableRestoreRequestId</code> value, then
        /// <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table
        /// restore requests.</p>
        pub fn set_table_restore_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_restore_request_id = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableRestoreStatusInput`](crate::input::DescribeTableRestoreStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTableRestoreStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTableRestoreStatusInput {
                cluster_identifier: self.cluster_identifier,
                table_restore_request_id: self.table_restore_request_id,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTableRestoreStatusInputOperationOutputAlias =
    crate::operation::DescribeTableRestoreStatus;
#[doc(hidden)]
pub type DescribeTableRestoreStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTableRestoreStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTableRestoreStatus`](crate::operation::DescribeTableRestoreStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTableRestoreStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTableRestoreStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTableRestoreStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTableRestoreStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_table_restore_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTableRestoreStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTableRestoreStatus",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTableRestoreStatusInput`](crate::input::DescribeTableRestoreStatusInput)
    pub fn builder() -> crate::input::describe_table_restore_status_input::Builder {
        crate::input::describe_table_restore_status_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The type of resource with which you want to view tags. Valid resource types are: </p>
        /// <ul>
        /// <li>
        /// <p>Cluster</p>
        /// </li>
        /// <li>
        /// <p>CIDR/IP</p>
        /// </li>
        /// <li>
        /// <p>EC2 security group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot</p>
        /// </li>
        /// <li>
        /// <p>Cluster security group</p>
        /// </li>
        /// <li>
        /// <p>Subnet group</p>
        /// </li>
        /// <li>
        /// <p>HSM connection</p>
        /// </li>
        /// <li>
        /// <p>HSM certificate</p>
        /// </li>
        /// <li>
        /// <p>Parameter group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot copy grant</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in
        /// the Amazon Redshift Cluster Management Guide. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource with which you want to view tags. Valid resource types are: </p>
        /// <ul>
        /// <li>
        /// <p>Cluster</p>
        /// </li>
        /// <li>
        /// <p>CIDR/IP</p>
        /// </li>
        /// <li>
        /// <p>EC2 security group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot</p>
        /// </li>
        /// <li>
        /// <p>Cluster security group</p>
        /// </li>
        /// <li>
        /// <p>Subnet group</p>
        /// </li>
        /// <li>
        /// <p>HSM connection</p>
        /// </li>
        /// <li>
        /// <p>HSM certificate</p>
        /// </li>
        /// <li>
        /// <p>Parameter group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot copy grant</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in
        /// the Amazon Redshift Cluster Management Guide. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code> value.
        /// </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code> value.
        /// </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                resource_name: self.resource_name,
                resource_type: self.resource_type,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`DescribeUsageLimitsInput`](crate::input::DescribeUsageLimitsInput)
pub mod describe_usage_limits_input {
    /// A builder for [`DescribeUsageLimitsInput`](crate::input::DescribeUsageLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_limit_id: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the usage limit to describe.</p>
        pub fn usage_limit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_limit_id = Some(input.into());
            self
        }
        /// <p>The identifier of the usage limit to describe.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_limit_id = input;
            self
        }
        /// <p>The identifier of the cluster for which you want to describe usage limits.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster for which you want to describe usage limits.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The feature type for which you want to describe usage limits.</p>
        pub fn feature_type(mut self, input: crate::model::UsageLimitFeatureType) -> Self {
            self.feature_type = Some(input);
            self
        }
        /// <p>The feature type for which you want to describe usage limits.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.feature_type = input;
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeUsageLimits</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeUsageLimits</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching usage limit objects
        /// that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the usage limit objects have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching usage limit objects
        /// that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the usage limit objects have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching usage limit objects
        /// that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the usage limit objects that have either or both of these tag
        /// values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input.into());
            self.tag_values = Some(v);
            self
        }
        /// <p>A tag value or values for which you want to return all matching usage limit objects
        /// that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the usage limit objects that have either or both of these tag
        /// values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsageLimitsInput`](crate::input::DescribeUsageLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUsageLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUsageLimitsInput {
                usage_limit_id: self.usage_limit_id,
                cluster_identifier: self.cluster_identifier,
                feature_type: self.feature_type,
                max_records: self.max_records,
                marker: self.marker,
                tag_keys: self.tag_keys,
                tag_values: self.tag_values,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUsageLimitsInputOperationOutputAlias = crate::operation::DescribeUsageLimits;
#[doc(hidden)]
pub type DescribeUsageLimitsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeUsageLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUsageLimits`](crate::operation::DescribeUsageLimits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUsageLimits,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUsageLimitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUsageLimitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUsageLimitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_usage_limits(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUsageLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUsageLimits",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUsageLimitsInput`](crate::input::DescribeUsageLimitsInput)
    pub fn builder() -> crate::input::describe_usage_limits_input::Builder {
        crate::input::describe_usage_limits_input::Builder::default()
    }
}

/// See [`DisableLoggingInput`](crate::input::DisableLoggingInput)
pub mod disable_logging_input {
    /// A builder for [`DisableLoggingInput`](crate::input::DisableLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster on which logging is to be stopped.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster on which logging is to be stopped.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableLoggingInput`](crate::input::DisableLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableLoggingInput {
                cluster_identifier: self.cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableLoggingInputOperationOutputAlias = crate::operation::DisableLogging;
#[doc(hidden)]
pub type DisableLoggingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableLoggingInput {
    /// Consumes the builder and constructs an Operation<[`DisableLogging`](crate::operation::DisableLogging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableLogging,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableLoggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableLoggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableLoggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_logging(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableLogging",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableLoggingInput`](crate::input::DisableLoggingInput)
    pub fn builder() -> crate::input::disable_logging_input::Builder {
        crate::input::disable_logging_input::Builder::default()
    }
}

/// See [`DisableSnapshotCopyInput`](crate::input::DisableSnapshotCopyInput)
pub mod disable_snapshot_copy_input {
    /// A builder for [`DisableSnapshotCopyInput`](crate::input::DisableSnapshotCopyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the source cluster that you want to disable copying of
        /// snapshots to a destination region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region
        /// snapshot copy enabled.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the source cluster that you want to disable copying of
        /// snapshots to a destination region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region
        /// snapshot copy enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableSnapshotCopyInput`](crate::input::DisableSnapshotCopyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableSnapshotCopyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableSnapshotCopyInput {
                cluster_identifier: self.cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableSnapshotCopyInputOperationOutputAlias = crate::operation::DisableSnapshotCopy;
#[doc(hidden)]
pub type DisableSnapshotCopyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableSnapshotCopyInput {
    /// Consumes the builder and constructs an Operation<[`DisableSnapshotCopy`](crate::operation::DisableSnapshotCopy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableSnapshotCopy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableSnapshotCopyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableSnapshotCopyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableSnapshotCopyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_snapshot_copy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableSnapshotCopy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableSnapshotCopy",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableSnapshotCopyInput`](crate::input::DisableSnapshotCopyInput)
    pub fn builder() -> crate::input::disable_snapshot_copy_input::Builder {
        crate::input::disable_snapshot_copy_input::Builder::default()
    }
}

/// See [`DisassociateDataShareConsumerInput`](crate::input::DisassociateDataShareConsumerInput)
pub mod disassociate_data_share_consumer_input {
    /// A builder for [`DisassociateDataShareConsumerInput`](crate::input::DisassociateDataShareConsumerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) disassociate_entire_account: std::option::Option<bool>,
        pub(crate) consumer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>A value that specifies whether association for the datashare is removed from the
        /// entire account.</p>
        pub fn disassociate_entire_account(mut self, input: bool) -> Self {
            self.disassociate_entire_account = Some(input);
            self
        }
        /// <p>A value that specifies whether association for the datashare is removed from the
        /// entire account.</p>
        pub fn set_disassociate_entire_account(mut self, input: std::option::Option<bool>) -> Self {
            self.disassociate_entire_account = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that association for
        /// the datashare is removed from.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that association for
        /// the datashare is removed from.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.consumer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateDataShareConsumerInput`](crate::input::DisassociateDataShareConsumerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateDataShareConsumerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateDataShareConsumerInput {
                data_share_arn: self.data_share_arn,
                disassociate_entire_account: self.disassociate_entire_account,
                consumer_arn: self.consumer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateDataShareConsumerInputOperationOutputAlias =
    crate::operation::DisassociateDataShareConsumer;
#[doc(hidden)]
pub type DisassociateDataShareConsumerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateDataShareConsumerInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateDataShareConsumer`](crate::operation::DisassociateDataShareConsumer)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateDataShareConsumer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateDataShareConsumerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateDataShareConsumerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateDataShareConsumerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_data_share_consumer(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateDataShareConsumer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateDataShareConsumer",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateDataShareConsumerInput`](crate::input::DisassociateDataShareConsumerInput)
    pub fn builder() -> crate::input::disassociate_data_share_consumer_input::Builder {
        crate::input::disassociate_data_share_consumer_input::Builder::default()
    }
}

/// See [`EnableLoggingInput`](crate::input::EnableLoggingInput)
pub mod enable_logging_input {
    /// A builder for [`EnableLoggingInput`](crate::input::EnableLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster on which logging is to be started.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster on which logging is to be started.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name of an existing S3 bucket where the log files are to be stored.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the same region as the cluster</p>
        /// </li>
        /// <li>
        /// <p>The cluster must have read bucket and put object permissions</p>
        /// </li>
        /// </ul>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of an existing S3 bucket where the log files are to be stored.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the same region as the cluster</p>
        /// </li>
        /// <li>
        /// <p>The cluster must have read bucket and put object permissions</p>
        /// </li>
        /// </ul>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot exceed 512 characters</p>
        /// </li>
        /// <li>
        /// <p>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
        /// (\), or control characters. The hexadecimal codes for invalid characters are: </p>
        /// <ul>
        /// <li>
        /// <p>x00 to x20</p>
        /// </li>
        /// <li>
        /// <p>x22</p>
        /// </li>
        /// <li>
        /// <p>x27</p>
        /// </li>
        /// <li>
        /// <p>x5c</p>
        /// </li>
        /// <li>
        /// <p>x7f or larger</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot exceed 512 characters</p>
        /// </li>
        /// <li>
        /// <p>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
        /// (\), or control characters. The hexadecimal codes for invalid characters are: </p>
        /// <ul>
        /// <li>
        /// <p>x00 to x20</p>
        /// </li>
        /// <li>
        /// <p>x22</p>
        /// </li>
        /// <li>
        /// <p>x27</p>
        /// </li>
        /// <li>
        /// <p>x5c</p>
        /// </li>
        /// <li>
        /// <p>x7f or larger</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableLoggingInput`](crate::input::EnableLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableLoggingInput {
                cluster_identifier: self.cluster_identifier,
                bucket_name: self.bucket_name,
                s3_key_prefix: self.s3_key_prefix,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableLoggingInputOperationOutputAlias = crate::operation::EnableLogging;
#[doc(hidden)]
pub type EnableLoggingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableLoggingInput {
    /// Consumes the builder and constructs an Operation<[`EnableLogging`](crate::operation::EnableLogging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableLogging,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableLoggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableLoggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableLoggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_enable_logging(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableLogging",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableLoggingInput`](crate::input::EnableLoggingInput)
    pub fn builder() -> crate::input::enable_logging_input::Builder {
        crate::input::enable_logging_input::Builder::default()
    }
}

/// See [`EnableSnapshotCopyInput`](crate::input::EnableSnapshotCopyInput)
pub mod enable_snapshot_copy_input {
    /// A builder for [`EnableSnapshotCopyInput`](crate::input::EnableSnapshotCopyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) destination_region: std::option::Option<std::string::String>,
        pub(crate) retention_period: std::option::Option<i32>,
        pub(crate) snapshot_copy_grant_name: std::option::Option<std::string::String>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the source cluster to copy snapshots from.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that does not already
        /// have cross-region snapshot copy enabled.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the source cluster to copy snapshots from.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that does not already
        /// have cross-region snapshot copy enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>
        /// <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.
        /// </p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_region = Some(input.into());
            self
        }
        /// <p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>
        /// <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.
        /// </p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_region = input;
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination region after
        /// they are copied from the source region.</p>
        /// <p>Default: 7.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination region after
        /// they are copied from the source region.</p>
        /// <p>Default: 7.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted
        /// cluster are copied to the destination region.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_copy_grant_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted
        /// cluster are copied to the destination region.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_copy_grant_name = input;
            self
        }
        /// <p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region
        /// after they are copied from the source Amazon Web Services Region. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region
        /// after they are copied from the source Amazon Web Services Region. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableSnapshotCopyInput`](crate::input::EnableSnapshotCopyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableSnapshotCopyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableSnapshotCopyInput {
                cluster_identifier: self.cluster_identifier,
                destination_region: self.destination_region,
                retention_period: self.retention_period,
                snapshot_copy_grant_name: self.snapshot_copy_grant_name,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableSnapshotCopyInputOperationOutputAlias = crate::operation::EnableSnapshotCopy;
#[doc(hidden)]
pub type EnableSnapshotCopyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableSnapshotCopyInput {
    /// Consumes the builder and constructs an Operation<[`EnableSnapshotCopy`](crate::operation::EnableSnapshotCopy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableSnapshotCopy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableSnapshotCopyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableSnapshotCopyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableSnapshotCopyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_snapshot_copy(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableSnapshotCopy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableSnapshotCopy",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableSnapshotCopyInput`](crate::input::EnableSnapshotCopyInput)
    pub fn builder() -> crate::input::enable_snapshot_copy_input::Builder {
        crate::input::enable_snapshot_copy_input::Builder::default()
    }
}

/// See [`GetClusterCredentialsInput`](crate::input::GetClusterCredentialsInput)
pub mod get_cluster_credentials_input {
    /// A builder for [`GetClusterCredentialsInput`](crate::input::GetClusterCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) duration_seconds: std::option::Option<i32>,
        pub(crate) auto_create: std::option::Option<bool>,
        pub(crate) db_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of a database user. If a user name matching <code>DbUser</code> exists in
        /// the database, the temporary user credentials have the same permissions as the existing
        /// user. If <code>DbUser</code> doesn't exist in the database and <code>Autocreate</code>
        /// is <code>True</code>, a new user is created using the value for <code>DbUser</code> with
        /// PUBLIC permissions. If a database user matching the value for <code>DbUser</code>
        /// doesn't exist and <code>Autocreate</code> is <code>False</code>, then the command
        /// succeeds but the connection attempt will fail because the user doesn't exist in the
        /// database.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon
        /// Redshift Database Developer Guide. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The name of a database user. If a user name matching <code>DbUser</code> exists in
        /// the database, the temporary user credentials have the same permissions as the existing
        /// user. If <code>DbUser</code> doesn't exist in the database and <code>Autocreate</code>
        /// is <code>True</code>, a new user is created using the value for <code>DbUser</code> with
        /// PUBLIC permissions. If a database user matching the value for <code>DbUser</code>
        /// doesn't exist and <code>Autocreate</code> is <code>False</code>, then the command
        /// succeeds but the connection attempt will fail because the user doesn't exist in the
        /// database.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon
        /// Redshift Database Developer Guide. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The name of a database that <code>DbUser</code> is authorized to log on to. If
        /// <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing
        /// database.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>The name of a database that <code>DbUser</code> is authorized to log on to. If
        /// <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing
        /// database.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>The unique identifier of the cluster that contains the database for which your are
        /// requesting credentials. This parameter is case sensitive.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster that contains the database for which your are
        /// requesting credentials. This parameter is case sensitive.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The number of seconds until the returned temporary password expires.</p>
        /// <p>Constraint: minimum 900, maximum 3600.</p>
        /// <p>Default: 900</p>
        pub fn duration_seconds(mut self, input: i32) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The number of seconds until the returned temporary password expires.</p>
        /// <p>Constraint: minimum 900, maximum 3600.</p>
        /// <p>Default: 900</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>Create a database user with the name specified for the user named in
        /// <code>DbUser</code> if one does not exist.</p>
        pub fn auto_create(mut self, input: bool) -> Self {
            self.auto_create = Some(input);
            self
        }
        /// <p>Create a database user with the name specified for the user named in
        /// <code>DbUser</code> if one does not exist.</p>
        pub fn set_auto_create(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_create = input;
            self
        }
        /// Appends an item to `db_groups`.
        ///
        /// To override the contents of this collection use [`set_db_groups`](Self::set_db_groups).
        ///
        /// <p>A list of the names of existing database groups that the user named in
        /// <code>DbUser</code> will join for the current session, in addition to any group
        /// memberships for an existing user. If not specified, a new user is added only to
        /// PUBLIC.</p>
        /// <p>Database group name constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn db_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.db_groups.unwrap_or_default();
            v.push(input.into());
            self.db_groups = Some(v);
            self
        }
        /// <p>A list of the names of existing database groups that the user named in
        /// <code>DbUser</code> will join for the current session, in addition to any group
        /// memberships for an existing user. If not specified, a new user is added only to
        /// PUBLIC.</p>
        /// <p>Database group name constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn set_db_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.db_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`GetClusterCredentialsInput`](crate::input::GetClusterCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetClusterCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetClusterCredentialsInput {
                db_user: self.db_user,
                db_name: self.db_name,
                cluster_identifier: self.cluster_identifier,
                duration_seconds: self.duration_seconds,
                auto_create: self.auto_create,
                db_groups: self.db_groups,
            })
        }
    }
}
#[doc(hidden)]
pub type GetClusterCredentialsInputOperationOutputAlias = crate::operation::GetClusterCredentials;
#[doc(hidden)]
pub type GetClusterCredentialsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetClusterCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`GetClusterCredentials`](crate::operation::GetClusterCredentials)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetClusterCredentials,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetClusterCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetClusterCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetClusterCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_cluster_credentials(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetClusterCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetClusterCredentials",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetClusterCredentialsInput`](crate::input::GetClusterCredentialsInput)
    pub fn builder() -> crate::input::get_cluster_credentials_input::Builder {
        crate::input::get_cluster_credentials_input::Builder::default()
    }
}

/// See [`GetReservedNodeExchangeOfferingsInput`](crate::input::GetReservedNodeExchangeOfferingsInput)
pub mod get_reserved_node_exchange_offerings_input {
    /// A builder for [`GetReservedNodeExchangeOfferingsInput`](crate::input::GetReservedNodeExchangeOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_id: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string representing the node identifier for the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_id = Some(input.into());
            self
        }
        /// <p>A string representing the node identifier for the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_id = input;
            self
        }
        /// <p>An integer setting the maximum number of ReservedNodeOfferings to
        /// retrieve.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>An integer setting the maximum number of ReservedNodeOfferings to
        /// retrieve.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of
        /// ReservedNodeOfferings.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of
        /// ReservedNodeOfferings.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservedNodeExchangeOfferingsInput`](crate::input::GetReservedNodeExchangeOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReservedNodeExchangeOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReservedNodeExchangeOfferingsInput {
                reserved_node_id: self.reserved_node_id,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReservedNodeExchangeOfferingsInputOperationOutputAlias =
    crate::operation::GetReservedNodeExchangeOfferings;
#[doc(hidden)]
pub type GetReservedNodeExchangeOfferingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetReservedNodeExchangeOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`GetReservedNodeExchangeOfferings`](crate::operation::GetReservedNodeExchangeOfferings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReservedNodeExchangeOfferings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReservedNodeExchangeOfferingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReservedNodeExchangeOfferingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReservedNodeExchangeOfferingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_reserved_node_exchange_offerings(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReservedNodeExchangeOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReservedNodeExchangeOfferings",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReservedNodeExchangeOfferingsInput`](crate::input::GetReservedNodeExchangeOfferingsInput)
    pub fn builder() -> crate::input::get_reserved_node_exchange_offerings_input::Builder {
        crate::input::get_reserved_node_exchange_offerings_input::Builder::default()
    }
}

/// See [`ModifyAquaConfigurationInput`](crate::input::ModifyAquaConfigurationInput)
pub mod modify_aqua_configuration_input {
    /// A builder for [`ModifyAquaConfigurationInput`](crate::input::ModifyAquaConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) aqua_configuration_status:
            std::option::Option<crate::model::AquaConfigurationStatus>,
    }
    impl Builder {
        /// <p>The identifier of the cluster to be modified.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to be modified.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The new value of AQUA configuration status. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            input: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.aqua_configuration_status = Some(input);
            self
        }
        /// <p>The new value of AQUA configuration status. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.aqua_configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyAquaConfigurationInput`](crate::input::ModifyAquaConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyAquaConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyAquaConfigurationInput {
                cluster_identifier: self.cluster_identifier,
                aqua_configuration_status: self.aqua_configuration_status,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyAquaConfigurationInputOperationOutputAlias =
    crate::operation::ModifyAquaConfiguration;
#[doc(hidden)]
pub type ModifyAquaConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyAquaConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`ModifyAquaConfiguration`](crate::operation::ModifyAquaConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyAquaConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyAquaConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyAquaConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyAquaConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_aqua_configuration(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyAquaConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyAquaConfiguration",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyAquaConfigurationInput`](crate::input::ModifyAquaConfigurationInput)
    pub fn builder() -> crate::input::modify_aqua_configuration_input::Builder {
        crate::input::modify_aqua_configuration_input::Builder::default()
    }
}

/// See [`ModifyAuthenticationProfileInput`](crate::input::ModifyAuthenticationProfileInput)
pub mod modify_authentication_profile_input {
    /// A builder for [`ModifyAuthenticationProfileInput`](crate::input::ModifyAuthenticationProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
        pub(crate) authentication_profile_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile to replace.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile to replace.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// <p>The new content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn authentication_profile_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = Some(input.into());
            self
        }
        /// <p>The new content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyAuthenticationProfileInput`](crate::input::ModifyAuthenticationProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyAuthenticationProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyAuthenticationProfileInput {
                authentication_profile_name: self.authentication_profile_name,
                authentication_profile_content: self.authentication_profile_content,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyAuthenticationProfileInputOperationOutputAlias =
    crate::operation::ModifyAuthenticationProfile;
#[doc(hidden)]
pub type ModifyAuthenticationProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyAuthenticationProfileInput {
    /// Consumes the builder and constructs an Operation<[`ModifyAuthenticationProfile`](crate::operation::ModifyAuthenticationProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyAuthenticationProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyAuthenticationProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyAuthenticationProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyAuthenticationProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_authentication_profile(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyAuthenticationProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyAuthenticationProfile",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyAuthenticationProfileInput`](crate::input::ModifyAuthenticationProfileInput)
    pub fn builder() -> crate::input::modify_authentication_profile_input::Builder {
        crate::input::modify_authentication_profile_input::Builder::default()
    }
}

/// See [`ModifyClusterInput`](crate::input::ModifyClusterInput)
pub mod modify_cluster_input {
    /// A builder for [`ModifyClusterInput`](crate::input::ModifyClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) cluster_type: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) cluster_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) automated_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) allow_version_upgrade: std::option::Option<bool>,
        pub(crate) hsm_client_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) hsm_configuration_identifier: std::option::Option<std::string::String>,
        pub(crate) new_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
        pub(crate) enhanced_vpc_routing: std::option::Option<bool>,
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone_relocation: std::option::Option<bool>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster to be modified.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster to be modified.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The new cluster type.</p>
        /// <p>When you submit your cluster resize request, your existing cluster goes into a
        /// read-only mode. After Amazon Redshift provisions a new cluster based on your resize
        /// requirements, there will be outage for a period while the old cluster is deleted and
        /// your connection is switched to the new cluster. You can use <a>DescribeResize</a> to track the progress of the resize request. </p>
        /// <p>Valid Values: <code> multi-node | single-node </code>
        /// </p>
        pub fn cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_type = Some(input.into());
            self
        }
        /// <p>The new cluster type.</p>
        /// <p>When you submit your cluster resize request, your existing cluster goes into a
        /// read-only mode. After Amazon Redshift provisions a new cluster based on your resize
        /// requirements, there will be outage for a period while the old cluster is deleted and
        /// your connection is switched to the new cluster. You can use <a>DescribeResize</a> to track the progress of the resize request. </p>
        /// <p>Valid Values: <code> multi-node | single-node </code>
        /// </p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_type = input;
            self
        }
        /// <p>The new node type of the cluster. If you specify a new node type, you must also
        /// specify the number of nodes parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The new node type of the cluster. If you specify a new node type, you must also
        /// specify the number of nodes parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The new number of nodes of the cluster. If you specify a new number of nodes, you
        /// must also specify the node type parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: Integer greater than <code>0</code>.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The new number of nodes of the cluster. If you specify a new number of nodes, you
        /// must also specify the node type parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: Integer greater than <code>0</code>.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// Appends an item to `cluster_security_groups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of cluster security groups to be authorized on this cluster. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Security groups currently associated with the cluster, and not in the list of
        /// groups to apply, will be revoked from the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn cluster_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cluster_security_groups.unwrap_or_default();
            v.push(input.into());
            self.cluster_security_groups = Some(v);
            self
        }
        /// <p>A list of cluster security groups to be authorized on this cluster. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Security groups currently associated with the cluster, and not in the list of
        /// groups to apply, will be revoked from the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cluster_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of virtual private cloud (VPC) security groups to be associated with the
        /// cluster. This change is asynchronously applied as soon as possible.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of virtual private cloud (VPC) security groups to be associated with the
        /// cluster. This change is asynchronously applied as soon as possible.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>The new password for the cluster admin user. This change is asynchronously applied
        /// as soon as possible. Between the time of the request and the completion of the request,
        /// the <code>MasterUserPassword</code> element exists in the
        /// <code>PendingModifiedValues</code> element of the operation response. </p>
        /// <note>
        /// <p>Operations never return the password, so this operation provides a way to
        /// regain access to the admin user account for a cluster if the password is
        /// lost.</p>
        /// </note>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The new password for the cluster admin user. This change is asynchronously applied
        /// as soon as possible. Between the time of the request and the completion of the request,
        /// the <code>MasterUserPassword</code> element exists in the
        /// <code>PendingModifiedValues</code> element of the operation response. </p>
        /// <note>
        /// <p>Operations never return the password, so this operation provides a way to
        /// regain access to the admin user account for a cluster if the password is
        /// lost.</p>
        /// </note>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The name of the cluster parameter group to apply to this cluster. This change is
        /// applied only after the cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: The cluster parameter group must be in the same parameter group family
        /// that matches the cluster version.</p>
        pub fn cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group to apply to this cluster. This change is
        /// applied only after the cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: The cluster parameter group must be in the same parameter group family
        /// that matches the cluster version.</p>
        pub fn set_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_name = input;
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        /// <p>If you decrease the automated snapshot retention period from its current value,
        /// existing automated snapshots that fall outside of the new retention period will be
        /// immediately deleted.</p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn automated_snapshot_retention_period(mut self, input: i32) -> Self {
            self.automated_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        /// <p>If you decrease the automated snapshot retention period from its current value,
        /// existing automated snapshots that fall outside of the new retention period will be
        /// immediately deleted.</p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automated_snapshot_retention_period = input;
            self
        }
        /// <p>The default for number of days that a newly created manual snapshot is retained. If
        /// the value is -1, the manual snapshot is retained indefinitely. This value doesn't
        /// retroactively change the retention periods of existing manual snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The default for number of days that a newly created manual snapshot is retained. If
        /// the value is -1, the manual snapshot is retained indefinitely. This value doesn't
        /// retroactively change the retention periods of existing manual snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, if
        /// necessary. If system maintenance is necessary during the window, it may result in an
        /// outage.</p>
        /// <p>This maintenance window change is made immediately. If the new maintenance window
        /// indicates the current time, there must be at least 120 minutes between the current time
        /// and end of the window in order to ensure that pending changes are applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example
        /// <code>wed:07:30-wed:08:00</code>.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, if
        /// necessary. If system maintenance is necessary during the window, it may result in an
        /// outage.</p>
        /// <p>This maintenance window change is made immediately. If the new maintenance window
        /// indicates the current time, there must be at least 120 minutes between the current time
        /// and end of the window in order to ensure that pending changes are applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example
        /// <code>wed:07:30-wed:08:00</code>.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The new version number of the Amazon Redshift engine to upgrade to.</p>
        /// <p>For major version upgrades, if a non-default cluster parameter group is currently
        /// in use, a new cluster parameter group in the cluster parameter group family for the new
        /// version must be specified. The new cluster parameter group can be the default for that
        /// cluster parameter group family.
        /// For more information about parameters and parameter groups, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The new version number of the Amazon Redshift engine to upgrade to.</p>
        /// <p>For major version upgrades, if a non-default cluster parameter group is currently
        /// in use, a new cluster parameter group in the cluster parameter group family for the new
        /// version must be specified. The new cluster parameter group can be the default for that
        /// cluster parameter group family.
        /// For more information about parameters and parameter groups, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>If <code>true</code>, major version upgrades will be applied automatically to the
        /// cluster during the maintenance window. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn allow_version_upgrade(mut self, input: bool) -> Self {
            self.allow_version_upgrade = Some(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades will be applied automatically to the
        /// cluster during the maintenance window. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_version_upgrade = input;
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = input;
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = input;
            self
        }
        /// <p>The new identifier for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn new_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The new identifier for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_new_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_cluster_identifier = input;
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. Only
        /// clusters in VPCs can be set to be publicly available.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. Only
        /// clusters in VPCs can be set to be publicly available.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, input: bool) -> Self {
            self.enhanced_vpc_routing = Some(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.enhanced_vpc_routing = input;
            self
        }
        /// <p>The name for the maintenance track that you want to assign for the cluster. This name
        /// change is asynchronous. The new track name stays in the
        /// <code>PendingModifiedValues</code> for the cluster until the next maintenance
        /// window. When the maintenance track changes, the cluster is switched to the latest
        /// cluster release available for the maintenance track. At this point, the maintenance
        /// track name is applied.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>The name for the maintenance track that you want to assign for the cluster. This name
        /// change is asynchronous. The new track name stays in the
        /// <code>PendingModifiedValues</code> for the cluster until the next maintenance
        /// window. When the maintenance track changes, the cluster is switched to the latest
        /// cluster release available for the maintenance track. At this point, the maintenance
        /// track name is applied.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you
        /// provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster
        /// with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>,
        /// we encrypt with the default key. </p>
        /// <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you
        /// provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster
        /// with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>,
        /// we encrypt with the default key. </p>
        /// <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use
        /// to encrypt data in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use
        /// to encrypt data in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
        pub fn availability_zone_relocation(mut self, input: bool) -> Self {
            self.availability_zone_relocation = Some(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
        pub fn set_availability_zone_relocation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.availability_zone_relocation = input;
            self
        }
        /// <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The option to change the port of an Amazon Redshift cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The option to change the port of an Amazon Redshift cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterInput`](crate::input::ModifyClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterInput {
                cluster_identifier: self.cluster_identifier,
                cluster_type: self.cluster_type,
                node_type: self.node_type,
                number_of_nodes: self.number_of_nodes,
                cluster_security_groups: self.cluster_security_groups,
                vpc_security_group_ids: self.vpc_security_group_ids,
                master_user_password: self.master_user_password,
                cluster_parameter_group_name: self.cluster_parameter_group_name,
                automated_snapshot_retention_period: self.automated_snapshot_retention_period,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
                preferred_maintenance_window: self.preferred_maintenance_window,
                cluster_version: self.cluster_version,
                allow_version_upgrade: self.allow_version_upgrade,
                hsm_client_certificate_identifier: self.hsm_client_certificate_identifier,
                hsm_configuration_identifier: self.hsm_configuration_identifier,
                new_cluster_identifier: self.new_cluster_identifier,
                publicly_accessible: self.publicly_accessible,
                elastic_ip: self.elastic_ip,
                enhanced_vpc_routing: self.enhanced_vpc_routing,
                maintenance_track_name: self.maintenance_track_name,
                encrypted: self.encrypted,
                kms_key_id: self.kms_key_id,
                availability_zone_relocation: self.availability_zone_relocation,
                availability_zone: self.availability_zone,
                port: self.port,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterInputOperationOutputAlias = crate::operation::ModifyCluster;
#[doc(hidden)]
pub type ModifyClusterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterInput {
    /// Consumes the builder and constructs an Operation<[`ModifyCluster`](crate::operation::ModifyCluster)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyCluster,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_cluster(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyCluster",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterInput`](crate::input::ModifyClusterInput)
    pub fn builder() -> crate::input::modify_cluster_input::Builder {
        crate::input::modify_cluster_input::Builder::default()
    }
}

/// See [`ModifyClusterDbRevisionInput`](crate::input::ModifyClusterDbRevisionInput)
pub mod modify_cluster_db_revision_input {
    /// A builder for [`ModifyClusterDbRevisionInput`](crate::input::ModifyClusterDbRevisionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) revision_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a cluster whose database revision you want to modify. </p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of a cluster whose database revision you want to modify. </p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The identifier of the database revision. You can retrieve this value from the
        /// response to the <a>DescribeClusterDbRevisions</a> request.</p>
        pub fn revision_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_target = Some(input.into());
            self
        }
        /// <p>The identifier of the database revision. You can retrieve this value from the
        /// response to the <a>DescribeClusterDbRevisions</a> request.</p>
        pub fn set_revision_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revision_target = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterDbRevisionInput`](crate::input::ModifyClusterDbRevisionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterDbRevisionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterDbRevisionInput {
                cluster_identifier: self.cluster_identifier,
                revision_target: self.revision_target,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterDbRevisionInputOperationOutputAlias =
    crate::operation::ModifyClusterDbRevision;
#[doc(hidden)]
pub type ModifyClusterDbRevisionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterDbRevisionInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClusterDbRevision`](crate::operation::ModifyClusterDbRevision)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClusterDbRevision,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterDbRevisionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterDbRevisionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterDbRevisionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_cluster_db_revision(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClusterDbRevision::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClusterDbRevision",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterDbRevisionInput`](crate::input::ModifyClusterDbRevisionInput)
    pub fn builder() -> crate::input::modify_cluster_db_revision_input::Builder {
        crate::input::modify_cluster_db_revision_input::Builder::default()
    }
}

/// See [`ModifyClusterIamRolesInput`](crate::input::ModifyClusterIamRolesInput)
pub mod modify_cluster_iam_roles_input {
    /// A builder for [`ModifyClusterIamRolesInput`](crate::input::ModifyClusterIamRolesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) add_iam_roles: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) remove_iam_roles: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster for which you want to associate or
        /// disassociate IAM roles.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster for which you want to associate or
        /// disassociate IAM roles.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Appends an item to `add_iam_roles`.
        ///
        /// To override the contents of this collection use [`set_add_iam_roles`](Self::set_add_iam_roles).
        ///
        /// <p>Zero or more IAM roles to associate with the cluster. The roles must be in their
        /// Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles with a single
        /// cluster in a single request.</p>
        pub fn add_iam_roles(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.add_iam_roles.unwrap_or_default();
            v.push(input.into());
            self.add_iam_roles = Some(v);
            self
        }
        /// <p>Zero or more IAM roles to associate with the cluster. The roles must be in their
        /// Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles with a single
        /// cluster in a single request.</p>
        pub fn set_add_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.add_iam_roles = input;
            self
        }
        /// Appends an item to `remove_iam_roles`.
        ///
        /// To override the contents of this collection use [`set_remove_iam_roles`](Self::set_remove_iam_roles).
        ///
        /// <p>Zero or more IAM roles in ARN format to disassociate from the cluster. You can
        /// disassociate up to 10 IAM roles from a single cluster in a single request.</p>
        pub fn remove_iam_roles(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.remove_iam_roles.unwrap_or_default();
            v.push(input.into());
            self.remove_iam_roles = Some(v);
            self
        }
        /// <p>Zero or more IAM roles in ARN format to disassociate from the cluster. You can
        /// disassociate up to 10 IAM roles from a single cluster in a single request.</p>
        pub fn set_remove_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.remove_iam_roles = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterIamRolesInput`](crate::input::ModifyClusterIamRolesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterIamRolesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterIamRolesInput {
                cluster_identifier: self.cluster_identifier,
                add_iam_roles: self.add_iam_roles,
                remove_iam_roles: self.remove_iam_roles,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterIamRolesInputOperationOutputAlias = crate::operation::ModifyClusterIamRoles;
#[doc(hidden)]
pub type ModifyClusterIamRolesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterIamRolesInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClusterIamRoles`](crate::operation::ModifyClusterIamRoles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClusterIamRoles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterIamRolesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterIamRolesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterIamRolesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_cluster_iam_roles(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClusterIamRoles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClusterIamRoles",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterIamRolesInput`](crate::input::ModifyClusterIamRolesInput)
    pub fn builder() -> crate::input::modify_cluster_iam_roles_input::Builder {
        crate::input::modify_cluster_iam_roles_input::Builder::default()
    }
}

/// See [`ModifyClusterMaintenanceInput`](crate::input::ModifyClusterMaintenanceInput)
pub mod modify_cluster_maintenance_input {
    /// A builder for [`ModifyClusterMaintenanceInput`](crate::input::ModifyClusterMaintenanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) defer_maintenance: std::option::Option<bool>,
        pub(crate) defer_maintenance_identifier: std::option::Option<std::string::String>,
        pub(crate) defer_maintenance_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) defer_maintenance_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) defer_maintenance_duration: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A unique identifier for the cluster.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the cluster.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>A boolean indicating whether to enable the deferred maintenance window. </p>
        pub fn defer_maintenance(mut self, input: bool) -> Self {
            self.defer_maintenance = Some(input);
            self
        }
        /// <p>A boolean indicating whether to enable the deferred maintenance window. </p>
        pub fn set_defer_maintenance(mut self, input: std::option::Option<bool>) -> Self {
            self.defer_maintenance = input;
            self
        }
        /// <p>A unique identifier for the deferred maintenance window.</p>
        pub fn defer_maintenance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.defer_maintenance_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the deferred maintenance window.</p>
        pub fn set_defer_maintenance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.defer_maintenance_identifier = input;
            self
        }
        /// <p>A timestamp indicating the start time for the deferred maintenance window.</p>
        pub fn defer_maintenance_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.defer_maintenance_start_time = Some(input);
            self
        }
        /// <p>A timestamp indicating the start time for the deferred maintenance window.</p>
        pub fn set_defer_maintenance_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.defer_maintenance_start_time = input;
            self
        }
        /// <p>A timestamp indicating end time for the deferred maintenance window. If you specify an
        /// end time, you can't specify a duration.</p>
        pub fn defer_maintenance_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.defer_maintenance_end_time = Some(input);
            self
        }
        /// <p>A timestamp indicating end time for the deferred maintenance window. If you specify an
        /// end time, you can't specify a duration.</p>
        pub fn set_defer_maintenance_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.defer_maintenance_end_time = input;
            self
        }
        /// <p>An integer indicating the duration of the maintenance window in days. If you specify a
        /// duration, you can't specify an end time. The duration must be 45 days or less.</p>
        pub fn defer_maintenance_duration(mut self, input: i32) -> Self {
            self.defer_maintenance_duration = Some(input);
            self
        }
        /// <p>An integer indicating the duration of the maintenance window in days. If you specify a
        /// duration, you can't specify an end time. The duration must be 45 days or less.</p>
        pub fn set_defer_maintenance_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.defer_maintenance_duration = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterMaintenanceInput`](crate::input::ModifyClusterMaintenanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterMaintenanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterMaintenanceInput {
                cluster_identifier: self.cluster_identifier,
                defer_maintenance: self.defer_maintenance,
                defer_maintenance_identifier: self.defer_maintenance_identifier,
                defer_maintenance_start_time: self.defer_maintenance_start_time,
                defer_maintenance_end_time: self.defer_maintenance_end_time,
                defer_maintenance_duration: self.defer_maintenance_duration,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterMaintenanceInputOperationOutputAlias =
    crate::operation::ModifyClusterMaintenance;
#[doc(hidden)]
pub type ModifyClusterMaintenanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterMaintenanceInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClusterMaintenance`](crate::operation::ModifyClusterMaintenance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClusterMaintenance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterMaintenanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterMaintenanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterMaintenanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_cluster_maintenance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClusterMaintenance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClusterMaintenance",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterMaintenanceInput`](crate::input::ModifyClusterMaintenanceInput)
    pub fn builder() -> crate::input::modify_cluster_maintenance_input::Builder {
        crate::input::modify_cluster_maintenance_input::Builder::default()
    }
}

/// See [`ModifyClusterParameterGroupInput`](crate::input::ModifyClusterParameterGroupInput)
pub mod modify_cluster_parameter_group_input {
    /// A builder for [`ModifyClusterParameterGroupInput`](crate::input::ModifyClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the parameter group to be modified.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter group to be modified.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An array of parameters to be modified. A maximum of 20 parameters can be modified
        /// in a single request.</p>
        /// <p>For each parameter to be modified, you must supply at least the parameter name and
        /// parameter value; other name-value pairs of the parameter are optional.</p>
        /// <p>For the workload management (WLM) configuration, you must supply all the name-value
        /// pairs in the wlm_json_configuration parameter.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>An array of parameters to be modified. A maximum of 20 parameters can be modified
        /// in a single request.</p>
        /// <p>For each parameter to be modified, you must supply at least the parameter name and
        /// parameter value; other name-value pairs of the parameter are optional.</p>
        /// <p>For the workload management (WLM) configuration, you must supply all the name-value
        /// pairs in the wlm_json_configuration parameter.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterParameterGroupInput`](crate::input::ModifyClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterParameterGroupInput {
                parameter_group_name: self.parameter_group_name,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterParameterGroupInputOperationOutputAlias =
    crate::operation::ModifyClusterParameterGroup;
#[doc(hidden)]
pub type ModifyClusterParameterGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClusterParameterGroup`](crate::operation::ModifyClusterParameterGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClusterParameterGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterParameterGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterParameterGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterParameterGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_cluster_parameter_group(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClusterParameterGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterParameterGroupInput`](crate::input::ModifyClusterParameterGroupInput)
    pub fn builder() -> crate::input::modify_cluster_parameter_group_input::Builder {
        crate::input::modify_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`ModifyClusterSnapshotInput`](crate::input::ModifyClusterSnapshotInput)
pub mod modify_cluster_snapshot_input {
    /// A builder for [`ModifyClusterSnapshotInput`](crate::input::ModifyClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot whose setting you want to modify.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot whose setting you want to modify.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>If the manual snapshot falls outside of the new retention period, you can specify the
        /// force option to immediately delete the snapshot.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>If the manual snapshot falls outside of the new retention period, you can specify the
        /// force option to immediately delete the snapshot.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// <p>A Boolean option to override an exception if the retention period has already
        /// passed.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>A Boolean option to override an exception if the retention period has already
        /// passed.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterSnapshotInput`](crate::input::ModifyClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterSnapshotInput {
                snapshot_identifier: self.snapshot_identifier,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
                force: self.force.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterSnapshotInputOperationOutputAlias = crate::operation::ModifyClusterSnapshot;
#[doc(hidden)]
pub type ModifyClusterSnapshotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClusterSnapshot`](crate::operation::ModifyClusterSnapshot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClusterSnapshot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterSnapshotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterSnapshotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterSnapshotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_cluster_snapshot(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClusterSnapshot",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterSnapshotInput`](crate::input::ModifyClusterSnapshotInput)
    pub fn builder() -> crate::input::modify_cluster_snapshot_input::Builder {
        crate::input::modify_cluster_snapshot_input::Builder::default()
    }
}

/// See [`ModifyClusterSnapshotScheduleInput`](crate::input::ModifyClusterSnapshotScheduleInput)
pub mod modify_cluster_snapshot_schedule_input {
    /// A builder for [`ModifyClusterSnapshotScheduleInput`](crate::input::ModifyClusterSnapshotScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) disassociate_schedule: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A unique identifier for the cluster whose snapshot schedule you want to modify.
        /// </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the cluster whose snapshot schedule you want to modify.
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>A unique alphanumeric identifier for the schedule that you want to associate with the
        /// cluster.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique alphanumeric identifier for the schedule that you want to associate with the
        /// cluster.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_identifier = input;
            self
        }
        /// <p>A boolean to indicate whether to remove the assoiciation between the cluster and the
        /// schedule.</p>
        pub fn disassociate_schedule(mut self, input: bool) -> Self {
            self.disassociate_schedule = Some(input);
            self
        }
        /// <p>A boolean to indicate whether to remove the assoiciation between the cluster and the
        /// schedule.</p>
        pub fn set_disassociate_schedule(mut self, input: std::option::Option<bool>) -> Self {
            self.disassociate_schedule = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterSnapshotScheduleInput`](crate::input::ModifyClusterSnapshotScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterSnapshotScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterSnapshotScheduleInput {
                cluster_identifier: self.cluster_identifier,
                schedule_identifier: self.schedule_identifier,
                disassociate_schedule: self.disassociate_schedule,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterSnapshotScheduleInputOperationOutputAlias =
    crate::operation::ModifyClusterSnapshotSchedule;
#[doc(hidden)]
pub type ModifyClusterSnapshotScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterSnapshotScheduleInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClusterSnapshotSchedule`](crate::operation::ModifyClusterSnapshotSchedule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClusterSnapshotSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterSnapshotScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterSnapshotScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterSnapshotScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_cluster_snapshot_schedule(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClusterSnapshotSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClusterSnapshotSchedule",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterSnapshotScheduleInput`](crate::input::ModifyClusterSnapshotScheduleInput)
    pub fn builder() -> crate::input::modify_cluster_snapshot_schedule_input::Builder {
        crate::input::modify_cluster_snapshot_schedule_input::Builder::default()
    }
}

/// See [`ModifyClusterSubnetGroupInput`](crate::input::ModifyClusterSubnetGroupInput)
pub mod modify_cluster_subnet_group_input {
    /// A builder for [`ModifyClusterSubnetGroupInput`](crate::input::ModifyClusterSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the subnet group to be modified.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group to be modified.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_subnet_group_name = input;
            self
        }
        /// <p>A text description of the subnet group to be modified.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A text description of the subnet group to be modified.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterSubnetGroupInput`](crate::input::ModifyClusterSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyClusterSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyClusterSubnetGroupInput {
                cluster_subnet_group_name: self.cluster_subnet_group_name,
                description: self.description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyClusterSubnetGroupInputOperationOutputAlias =
    crate::operation::ModifyClusterSubnetGroup;
#[doc(hidden)]
pub type ModifyClusterSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyClusterSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyClusterSubnetGroup`](crate::operation::ModifyClusterSubnetGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyClusterSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyClusterSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyClusterSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyClusterSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_cluster_subnet_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyClusterSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyClusterSubnetGroup",
            "redshift",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyClusterSubnetGroupInput`](crate::input::ModifyClusterSubnetGroupInput)
    pub fn builder() -> crate::input::modify_cluster_subnet_group_input::Builder {
        crate::input::modify_cluster_subnet_group_input::Builder::default()
    }
}

/// See [`ModifyEndpointAccessInput`](crate::input::ModifyEndpointAccessInput)
pub mod modify_endpoint_access_input {
    /// A builder for [`ModifyEndpointAccessInput`](crate::input::ModifyEndpointAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The endpoint to be modified.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The endpoint to be modified.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEndpointAccessInput`](crate::input::ModifyEndpointAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyEndpointAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyEndpointAccessInput {
                endpoint_name: self.endpoint_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyEndpointAccessInputOperationOutputAlias = crate::operation::ModifyEndpointAccess;
#[doc(hidden)]
pub type ModifyEndpointAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyEndpointAccessInput {
    /// Consumes the builder and constructs an Operation<[`ModifyEndpointAccess`](crate::operation::ModifyEndpointAccess)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::O