// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You are not authorized to access the cluster.</p>
    AccessToClusterDeniedFault(crate::error::AccessToClusterDeniedFault),
    /// <p>The owner of the specified snapshot has not authorized your account to access the
    /// snapshot.</p>
    AccessToSnapshotDeniedFault(crate::error::AccessToSnapshotDeniedFault),
    /// <p>The authentication profile already exists.</p>
    AuthenticationProfileAlreadyExistsFault(crate::error::AuthenticationProfileAlreadyExistsFault),
    /// <p>The authentication profile can't be found.</p>
    AuthenticationProfileNotFoundFault(crate::error::AuthenticationProfileNotFoundFault),
    /// <p>The size or number of authentication profiles has exceeded the quota.
    /// The maximum length of the JSON string and maximum number of authentication profiles is determined by a quota for your account.</p>
    AuthenticationProfileQuotaExceededFault(crate::error::AuthenticationProfileQuotaExceededFault),
    /// <p>The specified CIDR block or EC2 security group is already authorized for the
    /// specified cluster security group.</p>
    AuthorizationAlreadyExistsFault(crate::error::AuthorizationAlreadyExistsFault),
    /// <p>The specified CIDR IP range or EC2 security group is not authorized for the
    /// specified cluster security group.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p>The authorization quota for the cluster security group has been reached.</p>
    AuthorizationQuotaExceededFault(crate::error::AuthorizationQuotaExceededFault),
    /// <p>The maximum number for a batch delete of snapshots has been reached. The limit is
    /// 100. </p>
    BatchDeleteRequestSizeExceededFault(crate::error::BatchDeleteRequestSizeExceededFault),
    /// <p>The maximum number for snapshot identifiers has been reached. The limit is 100.
    /// </p>
    BatchModifyClusterSnapshotsLimitExceededFault(
        crate::error::BatchModifyClusterSnapshotsLimitExceededFault,
    ),
    /// <p>Could not find the specified S3 bucket.</p>
    BucketNotFoundFault(crate::error::BucketNotFoundFault),
    /// <p>The account already has a cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(crate::error::ClusterAlreadyExistsFault),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>Cluster is already on the latest database revision.</p>
    ClusterOnLatestRevisionFault(crate::error::ClusterOnLatestRevisionFault),
    /// <p>A cluster parameter group with the same name already exists.</p>
    ClusterParameterGroupAlreadyExistsFault(crate::error::ClusterParameterGroupAlreadyExistsFault),
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// parameter groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterParameterGroupQuotaExceededFault(crate::error::ClusterParameterGroupQuotaExceededFault),
    /// <p>The request would exceed the allowed number of cluster instances for this account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterQuotaExceededFault(crate::error::ClusterQuotaExceededFault),
    /// <p>A cluster security group with the same name already exists.</p>
    ClusterSecurityGroupAlreadyExistsFault(crate::error::ClusterSecurityGroupAlreadyExistsFault),
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// security groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterSecurityGroupQuotaExceededFault(crate::error::ClusterSecurityGroupQuotaExceededFault),
    /// <p>The value specified as a snapshot identifier is already used by an existing
    /// snapshot.</p>
    ClusterSnapshotAlreadyExistsFault(crate::error::ClusterSnapshotAlreadyExistsFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// snapshots.</p>
    ClusterSnapshotQuotaExceededFault(crate::error::ClusterSnapshotQuotaExceededFault),
    /// <p>A <i>ClusterSubnetGroupName</i> is already used by an existing
    /// cluster subnet group. </p>
    ClusterSubnetGroupAlreadyExistsFault(crate::error::ClusterSubnetGroupAlreadyExistsFault),
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet
    /// group.</p>
    ClusterSubnetGroupNotFoundFault(crate::error::ClusterSubnetGroupNotFoundFault),
    /// <p>The request would result in user exceeding the allowed number of cluster subnet
    /// groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterSubnetGroupQuotaExceededFault(crate::error::ClusterSubnetGroupQuotaExceededFault),
    /// <p>The request would result in user exceeding the allowed number of subnets in a
    /// cluster subnet groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterSubnetQuotaExceededFault(crate::error::ClusterSubnetQuotaExceededFault),
    /// <p>Cross-region snapshot copy was temporarily disabled. Try your request
    /// again.</p>
    CopyToRegionDisabledFault(crate::error::CopyToRegionDisabledFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>Your request cannot be completed because a dependent internal service is
    /// temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(crate::error::DependentServiceUnavailableFault),
    /// <p>The account already has a Redshift-managed VPC endpoint with the given identifier.</p>
    EndpointAlreadyExistsFault(crate::error::EndpointAlreadyExistsFault),
    /// <p>The authorization already exists for this endpoint.</p>
    EndpointAuthorizationAlreadyExistsFault(crate::error::EndpointAuthorizationAlreadyExistsFault),
    /// <p>The authorization for this endpoint can't be found.</p>
    EndpointAuthorizationNotFoundFault(crate::error::EndpointAuthorizationNotFoundFault),
    /// <p>The number of endpoint authorizations per cluster has exceeded its limit.</p>
    EndpointAuthorizationsPerClusterLimitExceededFault(
        crate::error::EndpointAuthorizationsPerClusterLimitExceededFault,
    ),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(crate::error::EndpointNotFoundFault),
    /// <p>The number of Redshift-managed VPC endpoints per authorization has exceeded its limit.</p>
    EndpointsPerAuthorizationLimitExceededFault(
        crate::error::EndpointsPerAuthorizationLimitExceededFault,
    ),
    /// <p>The number of Redshift-managed VPC endpoints per cluster has exceeded its limit.</p>
    EndpointsPerClusterLimitExceededFault(crate::error::EndpointsPerClusterLimitExceededFault),
    /// <p>The request would exceed the allowed number of event subscriptions for this
    /// account.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>There is already an existing Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateAlreadyExistsFault(crate::error::HsmClientCertificateAlreadyExistsFault),
    /// <p>There is no Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateNotFoundFault(crate::error::HsmClientCertificateNotFoundFault),
    /// <p>The quota for HSM client certificates has been reached.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    HsmClientCertificateQuotaExceededFault(crate::error::HsmClientCertificateQuotaExceededFault),
    /// <p>There is already an existing Amazon Redshift HSM configuration with the specified
    /// identifier.</p>
    HsmConfigurationAlreadyExistsFault(crate::error::HsmConfigurationAlreadyExistsFault),
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(crate::error::HsmConfigurationNotFoundFault),
    /// <p>The quota for HSM configurations has been reached.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    HsmConfigurationQuotaExceededFault(crate::error::HsmConfigurationQuotaExceededFault),
    /// <p>You have exceeded the allowed number of table restore requests. Wait for your
    /// current table restore requests to complete before making a new request.</p>
    InProgressTableRestoreQuotaExceededFault(
        crate::error::InProgressTableRestoreQuotaExceededFault,
    ),
    /// <p>The specified options are incompatible.</p>
    IncompatibleOrderableOptions(crate::error::IncompatibleOrderableOptions),
    /// <p>The number of nodes specified exceeds the allotted capacity of the
    /// cluster.</p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The cluster does not have read bucket or put object permissions on the S3 bucket
    /// specified when enabling logging.</p>
    InsufficientS3BucketPolicyFault(crate::error::InsufficientS3BucketPolicyFault),
    /// <p>The authentication profile request is not valid. The profile name can't be null or empty.
    /// The authentication profile API operation must be available in the Amazon Web Services Region.</p>
    InvalidAuthenticationProfileRequestFault(
        crate::error::InvalidAuthenticationProfileRequestFault,
    ),
    /// <p>The status of the authorization is not valid.</p>
    InvalidAuthorizationStateFault(crate::error::InvalidAuthorizationStateFault),
    /// <p>The cluster parameter group action can not be completed because another task is in
    /// progress that involves the parameter group. Wait a few moments and try the operation
    /// again.</p>
    InvalidClusterParameterGroupStateFault(crate::error::InvalidClusterParameterGroupStateFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// <p>The cluster snapshot schedule state is not valid.</p>
    InvalidClusterSnapshotScheduleStateFault(
        crate::error::InvalidClusterSnapshotScheduleStateFault,
    ),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The cluster subnet group cannot be deleted because it is in use.</p>
    InvalidClusterSubnetGroupStateFault(crate::error::InvalidClusterSubnetGroupStateFault),
    /// <p>The state of the subnet is invalid.</p>
    InvalidClusterSubnetStateFault(crate::error::InvalidClusterSubnetStateFault),
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(crate::error::InvalidClusterTrackFault),
    /// <p>There is an error with the datashare.</p>
    InvalidDataShareFault(crate::error::InvalidDataShareFault),
    /// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
    InvalidElasticIpFault(crate::error::InvalidElasticIpFault),
    /// <p>The status of the endpoint is not valid.</p>
    InvalidEndpointStateFault(crate::error::InvalidEndpointStateFault),
    /// <p>The specified HSM client certificate is not in the <code>available</code> state, or
    /// it is still in use by one or more Amazon Redshift clusters.</p>
    InvalidHsmClientCertificateStateFault(crate::error::InvalidHsmClientCertificateStateFault),
    /// <p>The specified HSM configuration is not in the <code>available</code> state, or it
    /// is still in use by one or more Amazon Redshift clusters.</p>
    InvalidHsmConfigurationStateFault(crate::error::InvalidHsmConfigurationStateFault),
    /// <p>The namespace isn't valid because the namespace doesn't exist. Provide a valid namespace.</p>
    InvalidNamespaceFault(crate::error::InvalidNamespaceFault),
    /// <p>Indicates that the Reserved Node being exchanged is not in an active state.</p>
    InvalidReservedNodeStateFault(crate::error::InvalidReservedNodeStateFault),
    /// <p>The restore is invalid.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// <p>The S3 bucket name is invalid. For more information about naming rules, go to
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
    /// Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3)
    /// Developer Guide.</p>
    InvalidS3BucketNameFault(crate::error::InvalidS3BucketNameFault),
    /// <p>The string specified for the logging S3 key prefix does not comply with the
    /// documented constraints.</p>
    InvalidS3KeyPrefixFault(crate::error::InvalidS3KeyPrefixFault),
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(crate::error::InvalidScheduleFault),
    /// <p>The scheduled action is not valid. </p>
    InvalidScheduledActionFault(crate::error::InvalidScheduledActionFault),
    /// <p>The snapshot copy grant can't be deleted because it is used by one or more
    /// clusters.</p>
    InvalidSnapshotCopyGrantStateFault(crate::error::InvalidSnapshotCopyGrantStateFault),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same
    /// VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The subscription request is invalid because it is a duplicate request. This
    /// subscription request is already in progress.</p>
    InvalidSubscriptionStateFault(crate::error::InvalidSubscriptionStateFault),
    /// <p>The value specified for the <code>sourceDatabaseName</code>,
    /// <code>sourceSchemaName</code>, or <code>sourceTableName</code> parameter, or a
    /// combination of these, doesn't exist in the snapshot.</p>
    InvalidTableRestoreArgumentFault(crate::error::InvalidTableRestoreArgumentFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The usage limit is not valid.</p>
    InvalidUsageLimitFault(crate::error::InvalidUsageLimitFault),
    /// <p>The cluster subnet group does not cover all Availability Zones.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(
        crate::error::NumberOfNodesPerClusterLimitExceededFault,
    ),
    /// <p>The operation would exceed the number of nodes allotted to the account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    NumberOfNodesQuotaExceededFault(crate::error::NumberOfNodesQuotaExceededFault),
    /// <p>The name of the partner was not found.</p>
    PartnerNotFoundFault(crate::error::PartnerNotFoundFault),
    /// <p>User already has a reservation with the given identifier.</p>
    ReservedNodeAlreadyExistsFault(crate::error::ReservedNodeAlreadyExistsFault),
    /// <p>Indicates that the reserved node has already been exchanged.</p>
    ReservedNodeAlreadyMigratedFault(crate::error::ReservedNodeAlreadyMigratedFault),
    /// <p>The specified reserved compute node not found.</p>
    ReservedNodeNotFoundFault(crate::error::ReservedNodeNotFoundFault),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(crate::error::ReservedNodeOfferingNotFoundFault),
    /// <p>Request would exceed the user's compute node quota.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ReservedNodeQuotaExceededFault(crate::error::ReservedNodeQuotaExceededFault),
    /// <p>A resize operation for the specified cluster is not found.</p>
    ResizeNotFoundFault(crate::error::ResizeNotFoundFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>Amazon SNS has responded that there is a problem with the specified Amazon SNS
    /// topic.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You do not have permission to publish to the specified Amazon SNS topic.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
    /// exist.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>The definition you submitted is not supported.</p>
    ScheduleDefinitionTypeUnsupportedFault(crate::error::ScheduleDefinitionTypeUnsupportedFault),
    /// <p>The scheduled action already exists. </p>
    ScheduledActionAlreadyExistsFault(crate::error::ScheduledActionAlreadyExistsFault),
    /// <p>The scheduled action cannot be found. </p>
    ScheduledActionNotFoundFault(crate::error::ScheduledActionNotFoundFault),
    /// <p>The quota for scheduled actions exceeded. </p>
    ScheduledActionQuotaExceededFault(crate::error::ScheduledActionQuotaExceededFault),
    /// <p>The action type specified for a scheduled action is not supported. </p>
    ScheduledActionTypeUnsupportedFault(crate::error::ScheduledActionTypeUnsupportedFault),
    /// <p>The cluster already has cross-region snapshot copy disabled.</p>
    SnapshotCopyAlreadyDisabledFault(crate::error::SnapshotCopyAlreadyDisabledFault),
    /// <p>The cluster already has cross-region snapshot copy enabled.</p>
    SnapshotCopyAlreadyEnabledFault(crate::error::SnapshotCopyAlreadyEnabledFault),
    /// <p>Cross-region snapshot copy was temporarily disabled. Try your request
    /// again.</p>
    SnapshotCopyDisabledFault(crate::error::SnapshotCopyDisabledFault),
    /// <p>The snapshot copy grant can't be created because a grant with the same name already
    /// exists.</p>
    SnapshotCopyGrantAlreadyExistsFault(crate::error::SnapshotCopyGrantAlreadyExistsFault),
    /// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed
    /// correctly and that the grant exists in the destination region.</p>
    SnapshotCopyGrantNotFoundFault(crate::error::SnapshotCopyGrantNotFoundFault),
    /// <p>The Amazon Web Services account has exceeded the maximum number of snapshot copy grants in this
    /// region.</p>
    SnapshotCopyGrantQuotaExceededFault(crate::error::SnapshotCopyGrantQuotaExceededFault),
    /// <p>The specified snapshot schedule already exists. </p>
    SnapshotScheduleAlreadyExistsFault(crate::error::SnapshotScheduleAlreadyExistsFault),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(crate::error::SnapshotScheduleNotFoundFault),
    /// <p>You have exceeded the quota of snapshot schedules. </p>
    SnapshotScheduleQuotaExceededFault(crate::error::SnapshotScheduleQuotaExceededFault),
    /// <p>The specified snapshot schedule is already being updated.</p>
    SnapshotScheduleUpdateInProgressFault(crate::error::SnapshotScheduleUpdateInProgressFault),
    /// <p>The specified Amazon Redshift event source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>A specified subnet is already in use by another cluster.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// <p>There is already an existing event notification subscription with the specified
    /// name.</p>
    SubscriptionAlreadyExistFault(crate::error::SubscriptionAlreadyExistFault),
    /// <p>The value specified for the event category was not one of the allowed values, or it
    /// specified a category that does not apply to the specified source type. The allowed
    /// values are Configuration, Management, Monitoring, and Security.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>An Amazon Redshift event with the specified event ID does not exist.</p>
    SubscriptionEventIdNotFoundFault(crate::error::SubscriptionEventIdNotFoundFault),
    /// <p>An Amazon Redshift event notification subscription with the specified name does not
    /// exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// <p>The value specified for the event severity was not one of the allowed values, or it
    /// specified a severity that does not apply to the specified source type. The allowed
    /// values are ERROR and INFO.</p>
    SubscriptionSeverityNotFoundFault(crate::error::SubscriptionSeverityNotFoundFault),
    /// <p>The number of tables in the cluster exceeds the limit for the requested new cluster
    /// node type. </p>
    TableLimitExceededFault(crate::error::TableLimitExceededFault),
    /// <p>The specified <code>TableRestoreRequestId</code> value was not found.</p>
    TableRestoreNotFoundFault(crate::error::TableRestoreNotFoundFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(crate::error::UnauthorizedPartnerIntegrationFault),
    /// <p>The specified region is incorrect or does not exist.</p>
    UnknownSnapshotCopyRegionFault(crate::error::UnknownSnapshotCopyRegionFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// <p>A request option was specified that is not supported.</p>
    UnsupportedOptionFault(crate::error::UnsupportedOptionFault),
    /// <p>The usage limit already exists. </p>
    UsageLimitAlreadyExistsFault(crate::error::UsageLimitAlreadyExistsFault),
    /// <p>The usage limit identifier can't be found.</p>
    UsageLimitNotFoundFault(crate::error::UsageLimitNotFoundFault),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessToClusterDeniedFault(inner) => inner.fmt(f),
            Error::AccessToSnapshotDeniedFault(inner) => inner.fmt(f),
            Error::AuthenticationProfileAlreadyExistsFault(inner) => inner.fmt(f),
            Error::AuthenticationProfileNotFoundFault(inner) => inner.fmt(f),
            Error::AuthenticationProfileQuotaExceededFault(inner) => inner.fmt(f),
            Error::AuthorizationAlreadyExistsFault(inner) => inner.fmt(f),
            Error::AuthorizationNotFoundFault(inner) => inner.fmt(f),
            Error::AuthorizationQuotaExceededFault(inner) => inner.fmt(f),
            Error::BatchDeleteRequestSizeExceededFault(inner) => inner.fmt(f),
            Error::BatchModifyClusterSnapshotsLimitExceededFault(inner) => inner.fmt(f),
            Error::BucketNotFoundFault(inner) => inner.fmt(f),
            Error::ClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ClusterNotFoundFault(inner) => inner.fmt(f),
            Error::ClusterOnLatestRevisionFault(inner) => inner.fmt(f),
            Error::ClusterParameterGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ClusterParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::ClusterParameterGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::ClusterQuotaExceededFault(inner) => inner.fmt(f),
            Error::ClusterSecurityGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ClusterSecurityGroupNotFoundFault(inner) => inner.fmt(f),
            Error::ClusterSecurityGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::ClusterSnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ClusterSnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::ClusterSnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::ClusterSubnetGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ClusterSubnetGroupNotFoundFault(inner) => inner.fmt(f),
            Error::ClusterSubnetGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::ClusterSubnetQuotaExceededFault(inner) => inner.fmt(f),
            Error::CopyToRegionDisabledFault(inner) => inner.fmt(f),
            Error::DependentServiceRequestThrottlingFault(inner) => inner.fmt(f),
            Error::DependentServiceUnavailableFault(inner) => inner.fmt(f),
            Error::EndpointAlreadyExistsFault(inner) => inner.fmt(f),
            Error::EndpointAuthorizationAlreadyExistsFault(inner) => inner.fmt(f),
            Error::EndpointAuthorizationNotFoundFault(inner) => inner.fmt(f),
            Error::EndpointAuthorizationsPerClusterLimitExceededFault(inner) => inner.fmt(f),
            Error::EndpointNotFoundFault(inner) => inner.fmt(f),
            Error::EndpointsPerAuthorizationLimitExceededFault(inner) => inner.fmt(f),
            Error::EndpointsPerClusterLimitExceededFault(inner) => inner.fmt(f),
            Error::EventSubscriptionQuotaExceededFault(inner) => inner.fmt(f),
            Error::HsmClientCertificateAlreadyExistsFault(inner) => inner.fmt(f),
            Error::HsmClientCertificateNotFoundFault(inner) => inner.fmt(f),
            Error::HsmClientCertificateQuotaExceededFault(inner) => inner.fmt(f),
            Error::HsmConfigurationAlreadyExistsFault(inner) => inner.fmt(f),
            Error::HsmConfigurationNotFoundFault(inner) => inner.fmt(f),
            Error::HsmConfigurationQuotaExceededFault(inner) => inner.fmt(f),
            Error::InProgressTableRestoreQuotaExceededFault(inner) => inner.fmt(f),
            Error::IncompatibleOrderableOptions(inner) => inner.fmt(f),
            Error::InsufficientClusterCapacityFault(inner) => inner.fmt(f),
            Error::InsufficientS3BucketPolicyFault(inner) => inner.fmt(f),
            Error::InvalidAuthenticationProfileRequestFault(inner) => inner.fmt(f),
            Error::InvalidAuthorizationStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterParameterGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterSecurityGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterSnapshotScheduleStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterSubnetGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterSubnetStateFault(inner) => inner.fmt(f),
            Error::InvalidClusterTrackFault(inner) => inner.fmt(f),
            Error::InvalidDataShareFault(inner) => inner.fmt(f),
            Error::InvalidElasticIpFault(inner) => inner.fmt(f),
            Error::InvalidEndpointStateFault(inner) => inner.fmt(f),
            Error::InvalidHsmClientCertificateStateFault(inner) => inner.fmt(f),
            Error::InvalidHsmConfigurationStateFault(inner) => inner.fmt(f),
            Error::InvalidNamespaceFault(inner) => inner.fmt(f),
            Error::InvalidReservedNodeStateFault(inner) => inner.fmt(f),
            Error::InvalidRestoreFault(inner) => inner.fmt(f),
            Error::InvalidRetentionPeriodFault(inner) => inner.fmt(f),
            Error::InvalidS3BucketNameFault(inner) => inner.fmt(f),
            Error::InvalidS3KeyPrefixFault(inner) => inner.fmt(f),
            Error::InvalidScheduleFault(inner) => inner.fmt(f),
            Error::InvalidScheduledActionFault(inner) => inner.fmt(f),
            Error::InvalidSnapshotCopyGrantStateFault(inner) => inner.fmt(f),
            Error::InvalidSubnet(inner) => inner.fmt(f),
            Error::InvalidSubscriptionStateFault(inner) => inner.fmt(f),
            Error::InvalidTableRestoreArgumentFault(inner) => inner.fmt(f),
            Error::InvalidTagFault(inner) => inner.fmt(f),
            Error::InvalidUsageLimitFault(inner) => inner.fmt(f),
            Error::InvalidVpcNetworkStateFault(inner) => inner.fmt(f),
            Error::LimitExceededFault(inner) => inner.fmt(f),
            Error::NumberOfNodesPerClusterLimitExceededFault(inner) => inner.fmt(f),
            Error::NumberOfNodesQuotaExceededFault(inner) => inner.fmt(f),
            Error::PartnerNotFoundFault(inner) => inner.fmt(f),
            Error::ReservedNodeAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ReservedNodeAlreadyMigratedFault(inner) => inner.fmt(f),
            Error::ReservedNodeNotFoundFault(inner) => inner.fmt(f),
            Error::ReservedNodeOfferingNotFoundFault(inner) => inner.fmt(f),
            Error::ReservedNodeQuotaExceededFault(inner) => inner.fmt(f),
            Error::ResizeNotFoundFault(inner) => inner.fmt(f),
            Error::ResourceNotFoundFault(inner) => inner.fmt(f),
            Error::SnsInvalidTopicFault(inner) => inner.fmt(f),
            Error::SnsNoAuthorizationFault(inner) => inner.fmt(f),
            Error::SnsTopicArnNotFoundFault(inner) => inner.fmt(f),
            Error::ScheduleDefinitionTypeUnsupportedFault(inner) => inner.fmt(f),
            Error::ScheduledActionAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ScheduledActionNotFoundFault(inner) => inner.fmt(f),
            Error::ScheduledActionQuotaExceededFault(inner) => inner.fmt(f),
            Error::ScheduledActionTypeUnsupportedFault(inner) => inner.fmt(f),
            Error::SnapshotCopyAlreadyDisabledFault(inner) => inner.fmt(f),
            Error::SnapshotCopyAlreadyEnabledFault(inner) => inner.fmt(f),
            Error::SnapshotCopyDisabledFault(inner) => inner.fmt(f),
            Error::SnapshotCopyGrantAlreadyExistsFault(inner) => inner.fmt(f),
            Error::SnapshotCopyGrantNotFoundFault(inner) => inner.fmt(f),
            Error::SnapshotCopyGrantQuotaExceededFault(inner) => inner.fmt(f),
            Error::SnapshotScheduleAlreadyExistsFault(inner) => inner.fmt(f),
            Error::SnapshotScheduleNotFoundFault(inner) => inner.fmt(f),
            Error::SnapshotScheduleQuotaExceededFault(inner) => inner.fmt(f),
            Error::SnapshotScheduleUpdateInProgressFault(inner) => inner.fmt(f),
            Error::SourceNotFoundFault(inner) => inner.fmt(f),
            Error::SubnetAlreadyInUse(inner) => inner.fmt(f),
            Error::SubscriptionAlreadyExistFault(inner) => inner.fmt(f),
            Error::SubscriptionCategoryNotFoundFault(inner) => inner.fmt(f),
            Error::SubscriptionEventIdNotFoundFault(inner) => inner.fmt(f),
            Error::SubscriptionNotFoundFault(inner) => inner.fmt(f),
            Error::SubscriptionSeverityNotFoundFault(inner) => inner.fmt(f),
            Error::TableLimitExceededFault(inner) => inner.fmt(f),
            Error::TableRestoreNotFoundFault(inner) => inner.fmt(f),
            Error::TagLimitExceededFault(inner) => inner.fmt(f),
            Error::UnauthorizedOperation(inner) => inner.fmt(f),
            Error::UnauthorizedPartnerIntegrationFault(inner) => inner.fmt(f),
            Error::UnknownSnapshotCopyRegionFault(inner) => inner.fmt(f),
            Error::UnsupportedOperationFault(inner) => inner.fmt(f),
            Error::UnsupportedOptionFault(inner) => inner.fmt(f),
            Error::UsageLimitAlreadyExistsFault(inner) => inner.fmt(f),
            Error::UsageLimitNotFoundFault(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AcceptReservedNodeExchangeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AcceptReservedNodeExchangeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AcceptReservedNodeExchangeErrorKind::DependentServiceUnavailableFault(inner) => Error::DependentServiceUnavailableFault(inner),
                crate::error::AcceptReservedNodeExchangeErrorKind::InvalidReservedNodeStateFault(inner) => Error::InvalidReservedNodeStateFault(inner),
                crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyExistsFault(inner) => Error::ReservedNodeAlreadyExistsFault(inner),
                crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyMigratedFault(inner) => Error::ReservedNodeAlreadyMigratedFault(inner),
                crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeNotFoundFault(inner) => Error::ReservedNodeNotFoundFault(inner),
                crate::error::AcceptReservedNodeExchangeErrorKind::ReservedNodeOfferingNotFoundFault(inner) => Error::ReservedNodeOfferingNotFoundFault(inner),
                crate::error::AcceptReservedNodeExchangeErrorKind::UnsupportedOperationFault(inner) => Error::UnsupportedOperationFault(inner),
                crate::error::AcceptReservedNodeExchangeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddPartnerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AddPartnerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddPartnerErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::AddPartnerErrorKind::PartnerNotFoundFault(inner) => {
                    Error::PartnerNotFoundFault(inner)
                }
                crate::error::AddPartnerErrorKind::UnauthorizedPartnerIntegrationFault(inner) => {
                    Error::UnauthorizedPartnerIntegrationFault(inner)
                }
                crate::error::AddPartnerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AssociateDataShareConsumerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AssociateDataShareConsumerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AssociateDataShareConsumerErrorKind::InvalidDataShareFault(inner) => {
                    Error::InvalidDataShareFault(inner)
                }
                crate::error::AssociateDataShareConsumerErrorKind::InvalidNamespaceFault(inner) => {
                    Error::InvalidNamespaceFault(inner)
                }
                crate::error::AssociateDataShareConsumerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::AuthorizeClusterSecurityGroupIngressError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AuthorizeClusterSecurityGroupIngressError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(inner) => Error::AuthorizationAlreadyExistsFault(inner),
                crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(inner) => Error::AuthorizationQuotaExceededFault(inner),
                crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(inner) => Error::ClusterSecurityGroupNotFoundFault(inner),
                crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(inner) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::AuthorizeClusterSecurityGroupIngressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AuthorizeDataShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AuthorizeDataShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AuthorizeDataShareErrorKind::InvalidDataShareFault(inner) => {
                    Error::InvalidDataShareFault(inner)
                }
                crate::error::AuthorizeDataShareErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AuthorizeEndpointAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AuthorizeEndpointAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AuthorizeEndpointAccessErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::AuthorizeEndpointAccessErrorKind::EndpointAuthorizationAlreadyExistsFault(inner) => Error::EndpointAuthorizationAlreadyExistsFault(inner),
                crate::error::AuthorizeEndpointAccessErrorKind::EndpointAuthorizationsPerClusterLimitExceededFault(inner) => Error::EndpointAuthorizationsPerClusterLimitExceededFault(inner),
                crate::error::AuthorizeEndpointAccessErrorKind::InvalidAuthorizationStateFault(inner) => Error::InvalidAuthorizationStateFault(inner),
                crate::error::AuthorizeEndpointAccessErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::AuthorizeEndpointAccessErrorKind::UnsupportedOperationFault(inner) => Error::UnsupportedOperationFault(inner),
                crate::error::AuthorizeEndpointAccessErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AuthorizeSnapshotAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AuthorizeSnapshotAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AuthorizeSnapshotAccessErrorKind::AuthorizationAlreadyExistsFault(inner) => Error::AuthorizationAlreadyExistsFault(inner),
                crate::error::AuthorizeSnapshotAccessErrorKind::AuthorizationQuotaExceededFault(inner) => Error::AuthorizationQuotaExceededFault(inner),
                crate::error::AuthorizeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(inner) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::AuthorizeSnapshotAccessErrorKind::DependentServiceRequestThrottlingFault(inner) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::AuthorizeSnapshotAccessErrorKind::InvalidClusterSnapshotStateFault(inner) => Error::InvalidClusterSnapshotStateFault(inner),
                crate::error::AuthorizeSnapshotAccessErrorKind::LimitExceededFault(inner) => Error::LimitExceededFault(inner),
                crate::error::AuthorizeSnapshotAccessErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDeleteClusterSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDeleteClusterSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchDeleteClusterSnapshotsErrorKind::BatchDeleteRequestSizeExceededFault(inner) => Error::BatchDeleteRequestSizeExceededFault(inner),
                crate::error::BatchDeleteClusterSnapshotsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchModifyClusterSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchModifyClusterSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchModifyClusterSnapshotsErrorKind::BatchModifyClusterSnapshotsLimitExceededFault(inner) => Error::BatchModifyClusterSnapshotsLimitExceededFault(inner),
                crate::error::BatchModifyClusterSnapshotsErrorKind::InvalidRetentionPeriodFault(inner) => Error::InvalidRetentionPeriodFault(inner),
                crate::error::BatchModifyClusterSnapshotsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelResizeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CancelResizeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelResizeErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::CancelResizeErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::CancelResizeErrorKind::ResizeNotFoundFault(inner) => {
                    Error::ResizeNotFoundFault(inner)
                }
                crate::error::CancelResizeErrorKind::UnsupportedOperationFault(inner) => {
                    Error::UnsupportedOperationFault(inner)
                }
                crate::error::CancelResizeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyClusterSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopyClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(
                    inner,
                ) => Error::ClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CopyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(inner) => {
                    Error::ClusterSnapshotNotFoundFault(inner)
                }
                crate::error::CopyClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(
                    inner,
                ) => Error::ClusterSnapshotQuotaExceededFault(inner),
                crate::error::CopyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(
                    inner,
                ) => Error::InvalidClusterSnapshotStateFault(inner),
                crate::error::CopyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(inner) => {
                    Error::InvalidRetentionPeriodFault(inner)
                }
                crate::error::CopyClusterSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateAuthenticationProfileError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateAuthenticationProfileError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateAuthenticationProfileErrorKind::AuthenticationProfileAlreadyExistsFault(inner) => Error::AuthenticationProfileAlreadyExistsFault(inner),
                crate::error::CreateAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(inner) => Error::AuthenticationProfileQuotaExceededFault(inner),
                crate::error::CreateAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(inner) => Error::InvalidAuthenticationProfileRequestFault(inner),
                crate::error::CreateAuthenticationProfileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateClusterErrorKind::ClusterAlreadyExistsFault(inner) => {
                    Error::ClusterAlreadyExistsFault(inner)
                }
                crate::error::CreateClusterErrorKind::ClusterParameterGroupNotFoundFault(inner) => {
                    Error::ClusterParameterGroupNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::ClusterQuotaExceededFault(inner) => {
                    Error::ClusterQuotaExceededFault(inner)
                }
                crate::error::CreateClusterErrorKind::ClusterSecurityGroupNotFoundFault(inner) => {
                    Error::ClusterSecurityGroupNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::ClusterSubnetGroupNotFoundFault(inner) => {
                    Error::ClusterSubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::DependentServiceRequestThrottlingFault(
                    inner,
                ) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::CreateClusterErrorKind::HsmClientCertificateNotFoundFault(inner) => {
                    Error::HsmClientCertificateNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::HsmConfigurationNotFoundFault(inner) => {
                    Error::HsmConfigurationNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::InsufficientClusterCapacityFault(inner) => {
                    Error::InsufficientClusterCapacityFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidClusterSubnetGroupStateFault(
                    inner,
                ) => Error::InvalidClusterSubnetGroupStateFault(inner),
                crate::error::CreateClusterErrorKind::InvalidClusterTrackFault(inner) => {
                    Error::InvalidClusterTrackFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidElasticIpFault(inner) => {
                    Error::InvalidElasticIpFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidRetentionPeriodFault(inner) => {
                    Error::InvalidRetentionPeriodFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::CreateClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateClusterErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::CreateClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                    inner,
                ) => Error::NumberOfNodesPerClusterLimitExceededFault(inner),
                crate::error::CreateClusterErrorKind::NumberOfNodesQuotaExceededFault(inner) => {
                    Error::NumberOfNodesQuotaExceededFault(inner)
                }
                crate::error::CreateClusterErrorKind::SnapshotScheduleNotFoundFault(inner) => {
                    Error::SnapshotScheduleNotFoundFault(inner)
                }
                crate::error::CreateClusterErrorKind::TagLimitExceededFault(inner) => {
                    Error::TagLimitExceededFault(inner)
                }
                crate::error::CreateClusterErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::CreateClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateClusterParameterGroupErrorKind::ClusterParameterGroupAlreadyExistsFault(inner) => Error::ClusterParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateClusterParameterGroupErrorKind::ClusterParameterGroupQuotaExceededFault(inner) => Error::ClusterParameterGroupQuotaExceededFault(inner),
                crate::error::CreateClusterParameterGroupErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateClusterParameterGroupErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClusterSecurityGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateClusterSecurityGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupAlreadyExistsFault(inner) => Error::ClusterSecurityGroupAlreadyExistsFault(inner),
                crate::error::CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupQuotaExceededFault(inner) => Error::ClusterSecurityGroupQuotaExceededFault(inner),
                crate::error::CreateClusterSecurityGroupErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateClusterSecurityGroupErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateClusterSecurityGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateClusterSnapshotErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::CreateClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(
                    inner,
                ) => Error::ClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CreateClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(
                    inner,
                ) => Error::ClusterSnapshotQuotaExceededFault(inner),
                crate::error::CreateClusterSnapshotErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::CreateClusterSnapshotErrorKind::InvalidRetentionPeriodFault(
                    inner,
                ) => Error::InvalidRetentionPeriodFault(inner),
                crate::error::CreateClusterSnapshotErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::CreateClusterSnapshotErrorKind::TagLimitExceededFault(inner) => {
                    Error::TagLimitExceededFault(inner)
                }
                crate::error::CreateClusterSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateClusterSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateClusterSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupAlreadyExistsFault(inner) => Error::ClusterSubnetGroupAlreadyExistsFault(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupQuotaExceededFault(inner) => Error::ClusterSubnetGroupQuotaExceededFault(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(inner) => Error::ClusterSubnetQuotaExceededFault(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(inner) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::CreateClusterSubnetGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEndpointAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEndpointAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateEndpointAccessErrorKind::AccessToClusterDeniedFault(inner) => Error::AccessToClusterDeniedFault(inner),
                crate::error::CreateEndpointAccessErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::CreateEndpointAccessErrorKind::ClusterSubnetGroupNotFoundFault(inner) => Error::ClusterSubnetGroupNotFoundFault(inner),
                crate::error::CreateEndpointAccessErrorKind::EndpointAlreadyExistsFault(inner) => Error::EndpointAlreadyExistsFault(inner),
                crate::error::CreateEndpointAccessErrorKind::EndpointsPerAuthorizationLimitExceededFault(inner) => Error::EndpointsPerAuthorizationLimitExceededFault(inner),
                crate::error::CreateEndpointAccessErrorKind::EndpointsPerClusterLimitExceededFault(inner) => Error::EndpointsPerClusterLimitExceededFault(inner),
                crate::error::CreateEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(inner) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::CreateEndpointAccessErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::CreateEndpointAccessErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::CreateEndpointAccessErrorKind::UnsupportedOperationFault(inner) => Error::UnsupportedOperationFault(inner),
                crate::error::CreateEndpointAccessErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(inner) => Error::EventSubscriptionQuotaExceededFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(inner) => Error::SubscriptionAlreadyExistFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(inner) => Error::SubscriptionEventIdNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(inner) => Error::SubscriptionSeverityNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateHsmClientCertificateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateHsmClientCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateHsmClientCertificateErrorKind::HsmClientCertificateAlreadyExistsFault(inner) => Error::HsmClientCertificateAlreadyExistsFault(inner),
                crate::error::CreateHsmClientCertificateErrorKind::HsmClientCertificateQuotaExceededFault(inner) => Error::HsmClientCertificateQuotaExceededFault(inner),
                crate::error::CreateHsmClientCertificateErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateHsmClientCertificateErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateHsmClientCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateHsmConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateHsmConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateHsmConfigurationErrorKind::HsmConfigurationAlreadyExistsFault(inner) => Error::HsmConfigurationAlreadyExistsFault(inner),
                crate::error::CreateHsmConfigurationErrorKind::HsmConfigurationQuotaExceededFault(inner) => Error::HsmConfigurationQuotaExceededFault(inner),
                crate::error::CreateHsmConfigurationErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateHsmConfigurationErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateHsmConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateScheduledActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateScheduledActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateScheduledActionErrorKind::InvalidScheduledActionFault(inner) => Error::InvalidScheduledActionFault(inner),
                crate::error::CreateScheduledActionErrorKind::InvalidScheduleFault(inner) => Error::InvalidScheduleFault(inner),
                crate::error::CreateScheduledActionErrorKind::ScheduledActionAlreadyExistsFault(inner) => Error::ScheduledActionAlreadyExistsFault(inner),
                crate::error::CreateScheduledActionErrorKind::ScheduledActionQuotaExceededFault(inner) => Error::ScheduledActionQuotaExceededFault(inner),
                crate::error::CreateScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(inner) => Error::ScheduledActionTypeUnsupportedFault(inner),
                crate::error::CreateScheduledActionErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::CreateScheduledActionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSnapshotCopyGrantError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateSnapshotCopyGrantError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateSnapshotCopyGrantErrorKind::DependentServiceRequestThrottlingFault(inner) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::CreateSnapshotCopyGrantErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateSnapshotCopyGrantErrorKind::LimitExceededFault(inner) => Error::LimitExceededFault(inner),
                crate::error::CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantAlreadyExistsFault(inner) => Error::SnapshotCopyGrantAlreadyExistsFault(inner),
                crate::error::CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantQuotaExceededFault(inner) => Error::SnapshotCopyGrantQuotaExceededFault(inner),
                crate::error::CreateSnapshotCopyGrantErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateSnapshotCopyGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateSnapshotScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateSnapshotScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateSnapshotScheduleErrorKind::InvalidScheduleFault(inner) => Error::InvalidScheduleFault(inner),
                crate::error::CreateSnapshotScheduleErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::CreateSnapshotScheduleErrorKind::ScheduleDefinitionTypeUnsupportedFault(inner) => Error::ScheduleDefinitionTypeUnsupportedFault(inner),
                crate::error::CreateSnapshotScheduleErrorKind::SnapshotScheduleAlreadyExistsFault(inner) => Error::SnapshotScheduleAlreadyExistsFault(inner),
                crate::error::CreateSnapshotScheduleErrorKind::SnapshotScheduleQuotaExceededFault(inner) => Error::SnapshotScheduleQuotaExceededFault(inner),
                crate::error::CreateSnapshotScheduleErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::CreateSnapshotScheduleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTagsErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::CreateTagsErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::CreateTagsErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::CreateTagsErrorKind::TagLimitExceededFault(inner) => {
                    Error::TagLimitExceededFault(inner)
                }
                crate::error::CreateTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUsageLimitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateUsageLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateUsageLimitErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::CreateUsageLimitErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::CreateUsageLimitErrorKind::InvalidUsageLimitFault(inner) => {
                    Error::InvalidUsageLimitFault(inner)
                }
                crate::error::CreateUsageLimitErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::CreateUsageLimitErrorKind::TagLimitExceededFault(inner) => {
                    Error::TagLimitExceededFault(inner)
                }
                crate::error::CreateUsageLimitErrorKind::UnsupportedOperationFault(inner) => {
                    Error::UnsupportedOperationFault(inner)
                }
                crate::error::CreateUsageLimitErrorKind::UsageLimitAlreadyExistsFault(inner) => {
                    Error::UsageLimitAlreadyExistsFault(inner)
                }
                crate::error::CreateUsageLimitErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeauthorizeDataShareError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeauthorizeDataShareError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeauthorizeDataShareErrorKind::InvalidDataShareFault(inner) => {
                    Error::InvalidDataShareFault(inner)
                }
                crate::error::DeauthorizeDataShareErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAuthenticationProfileError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAuthenticationProfileError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(inner) => Error::AuthenticationProfileNotFoundFault(inner),
                crate::error::DeleteAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(inner) => Error::InvalidAuthenticationProfileRequestFault(inner),
                crate::error::DeleteAuthenticationProfileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DeleteClusterErrorKind::ClusterSnapshotAlreadyExistsFault(inner) => {
                    Error::ClusterSnapshotAlreadyExistsFault(inner)
                }
                crate::error::DeleteClusterErrorKind::ClusterSnapshotQuotaExceededFault(inner) => {
                    Error::ClusterSnapshotQuotaExceededFault(inner)
                }
                crate::error::DeleteClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::DeleteClusterErrorKind::InvalidRetentionPeriodFault(inner) => {
                    Error::InvalidRetentionPeriodFault(inner)
                }
                crate::error::DeleteClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(inner) => Error::ClusterParameterGroupNotFoundFault(inner),
                crate::error::DeleteClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(inner) => Error::InvalidClusterParameterGroupStateFault(inner),
                crate::error::DeleteClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClusterSecurityGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteClusterSecurityGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteClusterSecurityGroupErrorKind::ClusterSecurityGroupNotFoundFault(inner) => Error::ClusterSecurityGroupNotFoundFault(inner),
                crate::error::DeleteClusterSecurityGroupErrorKind::InvalidClusterSecurityGroupStateFault(inner) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::DeleteClusterSecurityGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(
                    inner,
                ) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::DeleteClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(
                    inner,
                ) => Error::InvalidClusterSnapshotStateFault(inner),
                crate::error::DeleteClusterSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteClusterSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteClusterSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(inner) => Error::ClusterSubnetGroupNotFoundFault(inner),
                crate::error::DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetGroupStateFault(inner) => Error::InvalidClusterSubnetGroupStateFault(inner),
                crate::error::DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetStateFault(inner) => Error::InvalidClusterSubnetStateFault(inner),
                crate::error::DeleteClusterSubnetGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEndpointAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEndpointAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteEndpointAccessErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::DeleteEndpointAccessErrorKind::EndpointNotFoundFault(inner) => Error::EndpointNotFoundFault(inner),
                crate::error::DeleteEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(inner) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::DeleteEndpointAccessErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::DeleteEndpointAccessErrorKind::InvalidEndpointStateFault(inner) => Error::InvalidEndpointStateFault(inner),
                crate::error::DeleteEndpointAccessErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEventSubscriptionErrorKind::InvalidSubscriptionStateFault(
                    inner,
                ) => Error::InvalidSubscriptionStateFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(
                    inner,
                ) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteHsmClientCertificateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteHsmClientCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteHsmClientCertificateErrorKind::HsmClientCertificateNotFoundFault(inner) => Error::HsmClientCertificateNotFoundFault(inner),
                crate::error::DeleteHsmClientCertificateErrorKind::InvalidHsmClientCertificateStateFault(inner) => Error::InvalidHsmClientCertificateStateFault(inner),
                crate::error::DeleteHsmClientCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteHsmConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteHsmConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteHsmConfigurationErrorKind::HsmConfigurationNotFoundFault(inner) => Error::HsmConfigurationNotFoundFault(inner),
                crate::error::DeleteHsmConfigurationErrorKind::InvalidHsmConfigurationStateFault(inner) => Error::InvalidHsmConfigurationStateFault(inner),
                crate::error::DeleteHsmConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePartnerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeletePartnerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeletePartnerErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DeletePartnerErrorKind::PartnerNotFoundFault(inner) => {
                    Error::PartnerNotFoundFault(inner)
                }
                crate::error::DeletePartnerErrorKind::UnauthorizedPartnerIntegrationFault(
                    inner,
                ) => Error::UnauthorizedPartnerIntegrationFault(inner),
                crate::error::DeletePartnerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteScheduledActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteScheduledActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteScheduledActionErrorKind::ScheduledActionNotFoundFault(
                    inner,
                ) => Error::ScheduledActionNotFoundFault(inner),
                crate::error::DeleteScheduledActionErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::DeleteScheduledActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotCopyGrantError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotCopyGrantError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteSnapshotCopyGrantErrorKind::InvalidSnapshotCopyGrantStateFault(inner) => Error::InvalidSnapshotCopyGrantStateFault(inner),
                crate::error::DeleteSnapshotCopyGrantErrorKind::SnapshotCopyGrantNotFoundFault(inner) => Error::SnapshotCopyGrantNotFoundFault(inner),
                crate::error::DeleteSnapshotCopyGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(inner) => Error::InvalidClusterSnapshotScheduleStateFault(inner),
                crate::error::DeleteSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(inner) => Error::SnapshotScheduleNotFoundFault(inner),
                crate::error::DeleteSnapshotScheduleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTagsErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::DeleteTagsErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DeleteTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteUsageLimitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteUsageLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteUsageLimitErrorKind::UnsupportedOperationFault(inner) => {
                    Error::UnsupportedOperationFault(inner)
                }
                crate::error::DeleteUsageLimitErrorKind::UsageLimitNotFoundFault(inner) => {
                    Error::UsageLimitNotFoundFault(inner)
                }
                crate::error::DeleteUsageLimitErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeAuthenticationProfilesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeAuthenticationProfilesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeAuthenticationProfilesErrorKind::AuthenticationProfileNotFoundFault(inner) => Error::AuthenticationProfileNotFoundFault(inner),
                crate::error::DescribeAuthenticationProfilesErrorKind::InvalidAuthenticationProfileRequestFault(inner) => Error::InvalidAuthenticationProfileRequestFault(inner),
                crate::error::DescribeAuthenticationProfilesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterDbRevisionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClusterDbRevisionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeClusterDbRevisionsErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeClusterDbRevisionsErrorKind::InvalidClusterStateFault(
                    inner,
                ) => Error::InvalidClusterStateFault(inner),
                crate::error::DescribeClusterDbRevisionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeClusterParameterGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeClusterParameterGroupsErrorKind::ClusterParameterGroupNotFoundFault(inner) => Error::ClusterParameterGroupNotFoundFault(inner),
                crate::error::DescribeClusterParameterGroupsErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::DescribeClusterParameterGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClusterParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeClusterParametersErrorKind::ClusterParameterGroupNotFoundFault(inner) => Error::ClusterParameterGroupNotFoundFault(inner),
                crate::error::DescribeClusterParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClustersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeClustersErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeClustersErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::DescribeClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterSecurityGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClusterSecurityGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeClusterSecurityGroupsErrorKind::ClusterSecurityGroupNotFoundFault(inner) => Error::ClusterSecurityGroupNotFoundFault(inner),
                crate::error::DescribeClusterSecurityGroupsErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::DescribeClusterSecurityGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClusterSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeClusterSnapshotsErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeClusterSnapshotsErrorKind::ClusterSnapshotNotFoundFault(
                    inner,
                ) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeClusterSnapshotsErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::DescribeClusterSnapshotsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterSubnetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClusterSubnetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeClusterSubnetGroupsErrorKind::ClusterSubnetGroupNotFoundFault(inner) => Error::ClusterSubnetGroupNotFoundFault(inner),
                crate::error::DescribeClusterSubnetGroupsErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::DescribeClusterSubnetGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterTracksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClusterTracksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeClusterTracksErrorKind::InvalidClusterTrackFault(inner) => {
                    Error::InvalidClusterTrackFault(inner)
                }
                crate::error::DescribeClusterTracksErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::DescribeClusterTracksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeClusterVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeClusterVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeClusterVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDataSharesErrorKind::InvalidDataShareFault(inner) => {
                    Error::InvalidDataShareFault(inner)
                }
                crate::error::DescribeDataSharesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForConsumerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForConsumerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDataSharesForConsumerErrorKind::InvalidNamespaceFault(
                    inner,
                ) => Error::InvalidNamespaceFault(inner),
                crate::error::DescribeDataSharesForConsumerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForProducerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForProducerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDataSharesForProducerErrorKind::InvalidNamespaceFault(
                    inner,
                ) => Error::InvalidNamespaceFault(inner),
                crate::error::DescribeDataSharesForProducerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeDefaultClusterParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDefaultClusterParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDefaultClusterParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEndpointAccessErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeEndpointAccessErrorKind::EndpointNotFoundFault(inner) => {
                    Error::EndpointNotFoundFault(inner)
                }
                crate::error::DescribeEndpointAccessErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::DescribeEndpointAccessErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAuthorizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAuthorizationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEndpointAuthorizationErrorKind::ClusterNotFoundFault(
                    inner,
                ) => Error::ClusterNotFoundFault(inner),
                crate::error::DescribeEndpointAuthorizationErrorKind::UnsupportedOperationFault(
                    inner,
                ) => Error::UnsupportedOperationFault(inner),
                crate::error::DescribeEndpointAuthorizationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventCategoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventSubscriptionsErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(
                    inner,
                ) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DescribeEventSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeHsmClientCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeHsmClientCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeHsmClientCertificatesErrorKind::HsmClientCertificateNotFoundFault(inner) => Error::HsmClientCertificateNotFoundFault(inner),
                crate::error::DescribeHsmClientCertificatesErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::DescribeHsmClientCertificatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeHsmConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeHsmConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeHsmConfigurationsErrorKind::HsmConfigurationNotFoundFault(
                    inner,
                ) => Error::HsmConfigurationNotFoundFault(inner),
                crate::error::DescribeHsmConfigurationsErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::DescribeHsmConfigurationsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeLoggingStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeLoggingStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeLoggingStatusErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeLoggingStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeNodeConfigurationOptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeNodeConfigurationOptionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeNodeConfigurationOptionsErrorKind::AccessToSnapshotDeniedFault(inner) => Error::AccessToSnapshotDeniedFault(inner),
                crate::error::DescribeNodeConfigurationOptionsErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::DescribeNodeConfigurationOptionsErrorKind::ClusterSnapshotNotFoundFault(inner) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeNodeConfigurationOptionsErrorKind::InvalidClusterSnapshotStateFault(inner) => Error::InvalidClusterSnapshotStateFault(inner),
                crate::error::DescribeNodeConfigurationOptionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeOrderableClusterOptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrderableClusterOptionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOrderableClusterOptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePartnersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePartnersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePartnersErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribePartnersErrorKind::UnauthorizedPartnerIntegrationFault(
                    inner,
                ) => Error::UnauthorizedPartnerIntegrationFault(inner),
                crate::error::DescribePartnersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodeOfferingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodeOfferingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReservedNodeOfferingsErrorKind::DependentServiceUnavailableFault(inner) => Error::DependentServiceUnavailableFault(inner),
                crate::error::DescribeReservedNodeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(inner) => Error::ReservedNodeOfferingNotFoundFault(inner),
                crate::error::DescribeReservedNodeOfferingsErrorKind::UnsupportedOperationFault(inner) => Error::UnsupportedOperationFault(inner),
                crate::error::DescribeReservedNodeOfferingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeReservedNodesErrorKind::DependentServiceUnavailableFault(
                    inner,
                ) => Error::DependentServiceUnavailableFault(inner),
                crate::error::DescribeReservedNodesErrorKind::ReservedNodeNotFoundFault(inner) => {
                    Error::ReservedNodeNotFoundFault(inner)
                }
                crate::error::DescribeReservedNodesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeResizeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeResizeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeResizeErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeResizeErrorKind::ResizeNotFoundFault(inner) => {
                    Error::ResizeNotFoundFault(inner)
                }
                crate::error::DescribeResizeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeScheduledActionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeScheduledActionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeScheduledActionsErrorKind::ScheduledActionNotFoundFault(
                    inner,
                ) => Error::ScheduledActionNotFoundFault(inner),
                crate::error::DescribeScheduledActionsErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::DescribeScheduledActionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotCopyGrantsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotCopyGrantsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeSnapshotCopyGrantsErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::DescribeSnapshotCopyGrantsErrorKind::SnapshotCopyGrantNotFoundFault(inner) => Error::SnapshotCopyGrantNotFoundFault(inner),
                crate::error::DescribeSnapshotCopyGrantsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotSchedulesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotSchedulesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSnapshotSchedulesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeStorageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeStorageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeStorageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTableRestoreStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTableRestoreStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTableRestoreStatusErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeTableRestoreStatusErrorKind::TableRestoreNotFoundFault(
                    inner,
                ) => Error::TableRestoreNotFoundFault(inner),
                crate::error::DescribeTableRestoreStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeTagsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTagsErrorKind::InvalidTagFault(inner) => {
                    Error::InvalidTagFault(inner)
                }
                crate::error::DescribeTagsErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeTagsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeUsageLimitsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeUsageLimitsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeUsageLimitsErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DescribeUsageLimitsErrorKind::UnsupportedOperationFault(inner) => {
                    Error::UnsupportedOperationFault(inner)
                }
                crate::error::DescribeUsageLimitsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableLoggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DisableLoggingError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableLoggingErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DisableLoggingErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::DisableLoggingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableSnapshotCopyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisableSnapshotCopyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableSnapshotCopyErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::DisableSnapshotCopyErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::DisableSnapshotCopyErrorKind::SnapshotCopyAlreadyDisabledFault(
                    inner,
                ) => Error::SnapshotCopyAlreadyDisabledFault(inner),
                crate::error::DisableSnapshotCopyErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::DisableSnapshotCopyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisassociateDataShareConsumerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DisassociateDataShareConsumerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisassociateDataShareConsumerErrorKind::InvalidDataShareFault(
                    inner,
                ) => Error::InvalidDataShareFault(inner),
                crate::error::DisassociateDataShareConsumerErrorKind::InvalidNamespaceFault(
                    inner,
                ) => Error::InvalidNamespaceFault(inner),
                crate::error::DisassociateDataShareConsumerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableLoggingError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EnableLoggingError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableLoggingErrorKind::BucketNotFoundFault(inner) => {
                    Error::BucketNotFoundFault(inner)
                }
                crate::error::EnableLoggingErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::EnableLoggingErrorKind::InsufficientS3BucketPolicyFault(inner) => {
                    Error::InsufficientS3BucketPolicyFault(inner)
                }
                crate::error::EnableLoggingErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::EnableLoggingErrorKind::InvalidS3BucketNameFault(inner) => {
                    Error::InvalidS3BucketNameFault(inner)
                }
                crate::error::EnableLoggingErrorKind::InvalidS3KeyPrefixFault(inner) => {
                    Error::InvalidS3KeyPrefixFault(inner)
                }
                crate::error::EnableLoggingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableSnapshotCopyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::EnableSnapshotCopyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::EnableSnapshotCopyErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::CopyToRegionDisabledFault(inner) => Error::CopyToRegionDisabledFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::DependentServiceRequestThrottlingFault(inner) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::IncompatibleOrderableOptions(inner) => Error::IncompatibleOrderableOptions(inner),
                crate::error::EnableSnapshotCopyErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::InvalidRetentionPeriodFault(inner) => Error::InvalidRetentionPeriodFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::LimitExceededFault(inner) => Error::LimitExceededFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::SnapshotCopyAlreadyEnabledFault(inner) => Error::SnapshotCopyAlreadyEnabledFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::SnapshotCopyGrantNotFoundFault(inner) => Error::SnapshotCopyGrantNotFoundFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::EnableSnapshotCopyErrorKind::UnknownSnapshotCopyRegionFault(inner) => Error::UnknownSnapshotCopyRegionFault(inner),
                crate::error::EnableSnapshotCopyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetClusterCredentialsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetClusterCredentialsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetClusterCredentialsErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::GetClusterCredentialsErrorKind::UnsupportedOperationFault(inner) => {
                    Error::UnsupportedOperationFault(inner)
                }
                crate::error::GetClusterCredentialsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetReservedNodeExchangeOfferingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetReservedNodeExchangeOfferingsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetReservedNodeExchangeOfferingsErrorKind::DependentServiceUnavailableFault(inner) => Error::DependentServiceUnavailableFault(inner),
                crate::error::GetReservedNodeExchangeOfferingsErrorKind::InvalidReservedNodeStateFault(inner) => Error::InvalidReservedNodeStateFault(inner),
                crate::error::GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeAlreadyMigratedFault(inner) => Error::ReservedNodeAlreadyMigratedFault(inner),
                crate::error::GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeNotFoundFault(inner) => Error::ReservedNodeNotFoundFault(inner),
                crate::error::GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(inner) => Error::ReservedNodeOfferingNotFoundFault(inner),
                crate::error::GetReservedNodeExchangeOfferingsErrorKind::UnsupportedOperationFault(inner) => Error::UnsupportedOperationFault(inner),
                crate::error::GetReservedNodeExchangeOfferingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyAquaConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyAquaConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyAquaConfigurationErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ModifyAquaConfigurationErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::ModifyAquaConfigurationErrorKind::UnsupportedOperationFault(
                    inner,
                ) => Error::UnsupportedOperationFault(inner),
                crate::error::ModifyAquaConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyAuthenticationProfileError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyAuthenticationProfileError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(inner) => Error::AuthenticationProfileNotFoundFault(inner),
                crate::error::ModifyAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(inner) => Error::AuthenticationProfileQuotaExceededFault(inner),
                crate::error::ModifyAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(inner) => Error::InvalidAuthenticationProfileRequestFault(inner),
                crate::error::ModifyAuthenticationProfileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyClusterErrorKind::ClusterAlreadyExistsFault(inner) => {
                    Error::ClusterAlreadyExistsFault(inner)
                }
                crate::error::ModifyClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ModifyClusterErrorKind::ClusterParameterGroupNotFoundFault(inner) => {
                    Error::ClusterParameterGroupNotFoundFault(inner)
                }
                crate::error::ModifyClusterErrorKind::ClusterSecurityGroupNotFoundFault(inner) => {
                    Error::ClusterSecurityGroupNotFoundFault(inner)
                }
                crate::error::ModifyClusterErrorKind::DependentServiceRequestThrottlingFault(
                    inner,
                ) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::ModifyClusterErrorKind::HsmClientCertificateNotFoundFault(inner) => {
                    Error::HsmClientCertificateNotFoundFault(inner)
                }
                crate::error::ModifyClusterErrorKind::HsmConfigurationNotFoundFault(inner) => {
                    Error::HsmConfigurationNotFoundFault(inner)
                }
                crate::error::ModifyClusterErrorKind::InsufficientClusterCapacityFault(inner) => {
                    Error::InsufficientClusterCapacityFault(inner)
                }
                crate::error::ModifyClusterErrorKind::InvalidClusterSecurityGroupStateFault(
                    inner,
                ) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::ModifyClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::ModifyClusterErrorKind::InvalidClusterTrackFault(inner) => {
                    Error::InvalidClusterTrackFault(inner)
                }
                crate::error::ModifyClusterErrorKind::InvalidElasticIpFault(inner) => {
                    Error::InvalidElasticIpFault(inner)
                }
                crate::error::ModifyClusterErrorKind::InvalidRetentionPeriodFault(inner) => {
                    Error::InvalidRetentionPeriodFault(inner)
                }
                crate::error::ModifyClusterErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::ModifyClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                    inner,
                ) => Error::NumberOfNodesPerClusterLimitExceededFault(inner),
                crate::error::ModifyClusterErrorKind::NumberOfNodesQuotaExceededFault(inner) => {
                    Error::NumberOfNodesQuotaExceededFault(inner)
                }
                crate::error::ModifyClusterErrorKind::TableLimitExceededFault(inner) => {
                    Error::TableLimitExceededFault(inner)
                }
                crate::error::ModifyClusterErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::ModifyClusterErrorKind::UnsupportedOptionFault(inner) => {
                    Error::UnsupportedOptionFault(inner)
                }
                crate::error::ModifyClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterDbRevisionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterDbRevisionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyClusterDbRevisionErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ModifyClusterDbRevisionErrorKind::ClusterOnLatestRevisionFault(
                    inner,
                ) => Error::ClusterOnLatestRevisionFault(inner),
                crate::error::ModifyClusterDbRevisionErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::ModifyClusterDbRevisionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterIamRolesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterIamRolesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyClusterIamRolesErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ModifyClusterIamRolesErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::ModifyClusterIamRolesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterMaintenanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterMaintenanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyClusterMaintenanceErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ModifyClusterMaintenanceErrorKind::InvalidClusterStateFault(
                    inner,
                ) => Error::InvalidClusterStateFault(inner),
                crate::error::ModifyClusterMaintenanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(inner) => Error::ClusterParameterGroupNotFoundFault(inner),
                crate::error::ModifyClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(inner) => Error::InvalidClusterParameterGroupStateFault(inner),
                crate::error::ModifyClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(
                    inner,
                ) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::ModifyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(
                    inner,
                ) => Error::InvalidClusterSnapshotStateFault(inner),
                crate::error::ModifyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(
                    inner,
                ) => Error::InvalidRetentionPeriodFault(inner),
                crate::error::ModifyClusterSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyClusterSnapshotScheduleErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::ModifyClusterSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(inner) => Error::InvalidClusterSnapshotScheduleStateFault(inner),
                crate::error::ModifyClusterSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(inner) => Error::SnapshotScheduleNotFoundFault(inner),
                crate::error::ModifyClusterSnapshotScheduleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyClusterSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyClusterSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(inner) => Error::ClusterSubnetGroupNotFoundFault(inner),
                crate::error::ModifyClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(inner) => Error::ClusterSubnetQuotaExceededFault(inner),
                crate::error::ModifyClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(inner) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::ModifyClusterSubnetGroupErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::ModifyClusterSubnetGroupErrorKind::SubnetAlreadyInUse(inner) => Error::SubnetAlreadyInUse(inner),
                crate::error::ModifyClusterSubnetGroupErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::ModifyClusterSubnetGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyEndpointAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyEndpointAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyEndpointAccessErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::ModifyEndpointAccessErrorKind::EndpointNotFoundFault(inner) => Error::EndpointNotFoundFault(inner),
                crate::error::ModifyEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(inner) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::ModifyEndpointAccessErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::ModifyEndpointAccessErrorKind::InvalidEndpointStateFault(inner) => Error::InvalidEndpointStateFault(inner),
                crate::error::ModifyEndpointAccessErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::ModifyEndpointAccessErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyEventSubscriptionErrorKind::InvalidSubscriptionStateFault(inner) => Error::InvalidSubscriptionStateFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(inner) => Error::SubscriptionEventIdNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(inner) => Error::SubscriptionSeverityNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyScheduledActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyScheduledActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyScheduledActionErrorKind::InvalidScheduledActionFault(inner) => Error::InvalidScheduledActionFault(inner),
                crate::error::ModifyScheduledActionErrorKind::InvalidScheduleFault(inner) => Error::InvalidScheduleFault(inner),
                crate::error::ModifyScheduledActionErrorKind::ScheduledActionNotFoundFault(inner) => Error::ScheduledActionNotFoundFault(inner),
                crate::error::ModifyScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(inner) => Error::ScheduledActionTypeUnsupportedFault(inner),
                crate::error::ModifyScheduledActionErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::ModifyScheduledActionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifySnapshotCopyRetentionPeriodError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifySnapshotCopyRetentionPeriodError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::InvalidRetentionPeriodFault(inner) => Error::InvalidRetentionPeriodFault(inner),
                crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::SnapshotCopyDisabledFault(inner) => Error::SnapshotCopyDisabledFault(inner),
                crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::ModifySnapshotCopyRetentionPeriodErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifySnapshotScheduleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifySnapshotScheduleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifySnapshotScheduleErrorKind::InvalidScheduleFault(inner) => Error::InvalidScheduleFault(inner),
                crate::error::ModifySnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(inner) => Error::SnapshotScheduleNotFoundFault(inner),
                crate::error::ModifySnapshotScheduleErrorKind::SnapshotScheduleUpdateInProgressFault(inner) => Error::SnapshotScheduleUpdateInProgressFault(inner),
                crate::error::ModifySnapshotScheduleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyUsageLimitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyUsageLimitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyUsageLimitErrorKind::InvalidUsageLimitFault(inner) => {
                    Error::InvalidUsageLimitFault(inner)
                }
                crate::error::ModifyUsageLimitErrorKind::UnsupportedOperationFault(inner) => {
                    Error::UnsupportedOperationFault(inner)
                }
                crate::error::ModifyUsageLimitErrorKind::UsageLimitNotFoundFault(inner) => {
                    Error::UsageLimitNotFoundFault(inner)
                }
                crate::error::ModifyUsageLimitErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PauseClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PauseClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PauseClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::PauseClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::PauseClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PurchaseReservedNodeOfferingError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PurchaseReservedNodeOfferingError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PurchaseReservedNodeOfferingErrorKind::ReservedNodeAlreadyExistsFault(inner) => Error::ReservedNodeAlreadyExistsFault(inner),
                crate::error::PurchaseReservedNodeOfferingErrorKind::ReservedNodeOfferingNotFoundFault(inner) => Error::ReservedNodeOfferingNotFoundFault(inner),
                crate::error::PurchaseReservedNodeOfferingErrorKind::ReservedNodeQuotaExceededFault(inner) => Error::ReservedNodeQuotaExceededFault(inner),
                crate::error::PurchaseReservedNodeOfferingErrorKind::UnsupportedOperationFault(inner) => Error::UnsupportedOperationFault(inner),
                crate::error::PurchaseReservedNodeOfferingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RebootClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::RebootClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::RebootClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RejectDataShareError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RejectDataShareError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RejectDataShareErrorKind::InvalidDataShareFault(inner) => {
                    Error::InvalidDataShareFault(inner)
                }
                crate::error::RejectDataShareErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ResetClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(inner) => Error::ClusterParameterGroupNotFoundFault(inner),
                crate::error::ResetClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(inner) => Error::InvalidClusterParameterGroupStateFault(inner),
                crate::error::ResetClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResizeClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ResizeClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResizeClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ResizeClusterErrorKind::InsufficientClusterCapacityFault(inner) => {
                    Error::InsufficientClusterCapacityFault(inner)
                }
                crate::error::ResizeClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::ResizeClusterErrorKind::LimitExceededFault(inner) => {
                    Error::LimitExceededFault(inner)
                }
                crate::error::ResizeClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                    inner,
                ) => Error::NumberOfNodesPerClusterLimitExceededFault(inner),
                crate::error::ResizeClusterErrorKind::NumberOfNodesQuotaExceededFault(inner) => {
                    Error::NumberOfNodesQuotaExceededFault(inner)
                }
                crate::error::ResizeClusterErrorKind::UnauthorizedOperation(inner) => {
                    Error::UnauthorizedOperation(inner)
                }
                crate::error::ResizeClusterErrorKind::UnsupportedOperationFault(inner) => {
                    Error::UnsupportedOperationFault(inner)
                }
                crate::error::ResizeClusterErrorKind::UnsupportedOptionFault(inner) => {
                    Error::UnsupportedOptionFault(inner)
                }
                crate::error::ResizeClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreFromClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreFromClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreFromClusterSnapshotErrorKind::AccessToSnapshotDeniedFault(inner) => Error::AccessToSnapshotDeniedFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::ClusterAlreadyExistsFault(inner) => Error::ClusterAlreadyExistsFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::ClusterParameterGroupNotFoundFault(inner) => Error::ClusterParameterGroupNotFoundFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::ClusterQuotaExceededFault(inner) => Error::ClusterQuotaExceededFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::ClusterSecurityGroupNotFoundFault(inner) => Error::ClusterSecurityGroupNotFoundFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(inner) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::ClusterSubnetGroupNotFoundFault(inner) => Error::ClusterSubnetGroupNotFoundFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::DependentServiceRequestThrottlingFault(inner) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::HsmClientCertificateNotFoundFault(inner) => Error::HsmClientCertificateNotFoundFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::HsmConfigurationNotFoundFault(inner) => Error::HsmConfigurationNotFoundFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InsufficientClusterCapacityFault(inner) => Error::InsufficientClusterCapacityFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(inner) => Error::InvalidClusterSnapshotStateFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidClusterSubnetGroupStateFault(inner) => Error::InvalidClusterSubnetGroupStateFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidClusterTrackFault(inner) => Error::InvalidClusterTrackFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidElasticIpFault(inner) => Error::InvalidElasticIpFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidTagFault(inner) => Error::InvalidTagFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::LimitExceededFault(inner) => Error::LimitExceededFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::NumberOfNodesPerClusterLimitExceededFault(inner) => Error::NumberOfNodesPerClusterLimitExceededFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::NumberOfNodesQuotaExceededFault(inner) => Error::NumberOfNodesQuotaExceededFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::SnapshotScheduleNotFoundFault(inner) => Error::SnapshotScheduleNotFoundFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::TagLimitExceededFault(inner) => Error::TagLimitExceededFault(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::UnauthorizedOperation(inner) => Error::UnauthorizedOperation(inner),
                crate::error::RestoreFromClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RestoreTableFromClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RestoreTableFromClusterSnapshotError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreTableFromClusterSnapshotErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::RestoreTableFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(inner) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreTableFromClusterSnapshotErrorKind::InProgressTableRestoreQuotaExceededFault(inner) => Error::InProgressTableRestoreQuotaExceededFault(inner),
                crate::error::RestoreTableFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(inner) => Error::InvalidClusterSnapshotStateFault(inner),
                crate::error::RestoreTableFromClusterSnapshotErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::RestoreTableFromClusterSnapshotErrorKind::InvalidTableRestoreArgumentFault(inner) => Error::InvalidTableRestoreArgumentFault(inner),
                crate::error::RestoreTableFromClusterSnapshotErrorKind::UnsupportedOperationFault(inner) => Error::UnsupportedOperationFault(inner),
                crate::error::RestoreTableFromClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResumeClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ResumeClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResumeClusterErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::ResumeClusterErrorKind::InsufficientClusterCapacityFault(inner) => {
                    Error::InsufficientClusterCapacityFault(inner)
                }
                crate::error::ResumeClusterErrorKind::InvalidClusterStateFault(inner) => {
                    Error::InvalidClusterStateFault(inner)
                }
                crate::error::ResumeClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RevokeClusterSecurityGroupIngressError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RevokeClusterSecurityGroupIngressError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RevokeClusterSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(inner) => Error::AuthorizationNotFoundFault(inner),
                crate::error::RevokeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(inner) => Error::ClusterSecurityGroupNotFoundFault(inner),
                crate::error::RevokeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(inner) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::RevokeClusterSecurityGroupIngressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RevokeEndpointAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RevokeEndpointAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RevokeEndpointAccessErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::RevokeEndpointAccessErrorKind::EndpointAuthorizationNotFoundFault(inner) => Error::EndpointAuthorizationNotFoundFault(inner),
                crate::error::RevokeEndpointAccessErrorKind::EndpointNotFoundFault(inner) => Error::EndpointNotFoundFault(inner),
                crate::error::RevokeEndpointAccessErrorKind::InvalidAuthorizationStateFault(inner) => Error::InvalidAuthorizationStateFault(inner),
                crate::error::RevokeEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(inner) => Error::InvalidClusterSecurityGroupStateFault(inner),
                crate::error::RevokeEndpointAccessErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::RevokeEndpointAccessErrorKind::InvalidEndpointStateFault(inner) => Error::InvalidEndpointStateFault(inner),
                crate::error::RevokeEndpointAccessErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RevokeSnapshotAccessError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RevokeSnapshotAccessError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RevokeSnapshotAccessErrorKind::AccessToSnapshotDeniedFault(inner) => {
                    Error::AccessToSnapshotDeniedFault(inner)
                }
                crate::error::RevokeSnapshotAccessErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::RevokeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(
                    inner,
                ) => Error::ClusterSnapshotNotFoundFault(inner),
                crate::error::RevokeSnapshotAccessErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RotateEncryptionKeyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RotateEncryptionKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RotateEncryptionKeyErrorKind::ClusterNotFoundFault(inner) => Error::ClusterNotFoundFault(inner),
                crate::error::RotateEncryptionKeyErrorKind::DependentServiceRequestThrottlingFault(inner) => Error::DependentServiceRequestThrottlingFault(inner),
                crate::error::RotateEncryptionKeyErrorKind::InvalidClusterStateFault(inner) => Error::InvalidClusterStateFault(inner),
                crate::error::RotateEncryptionKeyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePartnerStatusError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdatePartnerStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdatePartnerStatusErrorKind::ClusterNotFoundFault(inner) => {
                    Error::ClusterNotFoundFault(inner)
                }
                crate::error::UpdatePartnerStatusErrorKind::PartnerNotFoundFault(inner) => {
                    Error::PartnerNotFoundFault(inner)
                }
                crate::error::UpdatePartnerStatusErrorKind::UnauthorizedPartnerIntegrationFault(
                    inner,
                ) => Error::UnauthorizedPartnerIntegrationFault(inner),
                crate::error::UpdatePartnerStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
